       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCB159.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. FEB 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **    DEREGULATED RESIDENTIAL GROUPING BY CSC EXTRACT PROGRAM   **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES A EXTRACT FILE TO GENERATE THE        **        
      **   DEREGULATED RESIDENTIAL CSC GROUPING REPORT.               **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 02/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
P00141** 04/2009  SS97726  ADD START/END DATE TO OPT_ATTR_INCTV       **        
A01143** 06/2009  SP94986  MODIFIED THE ACCOUNT_CUR TO SELECT A       **        
A01143**                   FINALED \ WRITE OFF ACCOUNTS.              **        
      **                                                              **        
A00633** 22 SEP 2009 RF10596 ADD CHECK FOR TIER-ACCT-TYPE-CD = 'S'    **        
      **                     AND 'R'                                  **        
P00211** 11/2009  VY95550  TREAT INTRO/PROMOTIONAL OPTIONS AS SAME AS **        
P00211**                   VP - VARIABLE PRICE OPTIONS                **        
      **                                                              **        
A02769** 10/2010  MC95456  EXTRACT  INTRO RELATED ACCOUNTS FOR DISPLAY**        
A02499** 01/2011  BD09555  ADD LOGIC FOR NEW REPORT EXTRACT           **        
P00473** 05/2011  SB93596  CHGS INCLUDED TO PULL APPROVED             **        
P00473**                   OPTION/OPT ATTR INCTV RECORDS.             **        
A04019** 05/2012  VIJAY    SEB CSC CHANGES.                           **        
A04880** 11/2014  MR7E794  CSC AMOUNT ISSUE FIX.                      **        
A04880**          ACT293                                              **        
A05460** 11/2016  DB41297  Convert PCSCA155/156/159 to write output             
ACT350**                   TO DB2 TABLE.                                        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCB159'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCB159 STARTS HERE'.            
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE FCSCB159           *          
      ****************************************************************          
      *                                                                         
       01 FIOCA159.                                                     
         02 E-FCA159-DATA-REC.                                          
           05 E-FCA159-OPTION-CODE         PIC X(12).                   
           05 E-FCA159-OPT-DESC            PIC X(50).                   
           05 E-FCA159-CSC-AMT             PIC 9.9999.                  
           05 E-FCA159-OFFER-CD            PIC X(12).                   
           05 E-FCA159-SORT-GRP-CODE       PIC 9(04).                   
           05 E-FCA159-STATUS-CODE         PIC X(01).                   
           05 E-FCA159-AGL-SEN-FLAG        PIC X(01).                   
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
                                                                        
       01  WS-WORK-VARIABLES.                                           
           05  WS-PRIOR-PND-DATE           PIC X(10)  VALUE SPACES.     
           05  WS-SORT-GRP-CODE            PIC 9(04)  VALUE ZEROS.      
           05  WS-NULL-IND-01              PIC S9(4)  COMP VALUE 0.     
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-CA159-RECS-WRITE         PIC 9(7)   VALUE ZEROS.      
           05  WS-COMMIT-CNT               PIC S9(5) COMP-3 VALUE 0.    
COB305     05 WS-SUB1        PIC S9(7) COMP-3 VALUE 0.            
COB305     05 WS-SUB2        PIC S9(7) COMP-3 VALUE 0.            
                                                                        
       01  WS-DAYS                         PIC 9(04)  VALUE ZEROS.      
       01  WS-P-DAYS                       PIC S9(4)  COMP VALUE +0.    
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
       01  WS-811                          PIC S9(4)  COMP VALUE -811.  
ACT128 01  WS1-FACTOR-KEY.                                              
COB305     05 WS1-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.            
ACT128     05 WS1-IC-NO                   PIC S9(4)  COMP.              
A04527     05 WS1-RATE-PLAN-NO            PIC X(03).                    
                                                                        
A04019 01  WS-CSC-AMT-DESC                 PIC $Z9.99 .                 
A04019 01  WS-CSC-LIT-DESC                 PIC X(04)  VALUE ' CSC'.     
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)   VALUE 'PCSCA159'. 
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSCA159'. 
                                                                        
      *****************************************************************         
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     **         
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  **         
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    **         
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       **         
      *****************************************************************         
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-END-ACCOUNT-CUR-SW       PIC X(1)   VALUE 'N'.        
               88  WS-END-ACCOUNT-CUR                 VALUE 'Y'.        
               88  WS-NOT-END-ACCOUNT-CUR             VALUE 'N'.        
           05  WS-ACCOUNT-SKIP-SW          PIC X(1)   VALUE 'N'.        
               88  SKIP-ACCOUNT                       VALUE 'Y'.        
               88  DONT-SKIP-ACCOUNT                  VALUE 'N'.        
           05  WS-AGL-SEN-DISC-SW          PIC X(1)   VALUE 'N'.        
               88  WS-AGL-SEN-DISC                    VALUE 'Y'.        
               88  WS-NO-AGL-SEN-DISC                 VALUE 'N'.        
           05  WS-ADJ-CSC-SW               PIC X(1)   VALUE 'N'.        
               88  ADJ-CSC-FOUND                      VALUE 'Y'.        
               88  ADJ-CSC-NOT-FOUND                  VALUE 'N'.        
ACT128                                                                  
ACT128 01  WS-INCTV-TABLE.                                              
ACT128     05 WS-INCTV-CNT                  PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-SNR-CNT                    PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-VERS-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-RATE-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-DUR-CNT                    PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-CSC-CNT                    PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-FACTOR-ID-HOLD             PIC X(10).                  
ACT128     05 WS-OPTION-CD-HOLD             PIC X(12).                  
A04527     05 WS-DURATION-NO-HOLD           PIC S9(4) COMP VALUE 0.     
ACT128     05 WS-INCTV-TBL OCCURS 0 TO 99999 DEPENDING ON WS-INCTV-CNT  
ACT128                    ASCENDING KEY WS-FACTOR-KEY                   
ACT128                    INDEXED BY INCTV-IND.                         
ACT128        10 WS-FACTOR-KEY.                                         
COB305           15 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.       
ACT128           15 WS-IC-NO                   PIC S9(4)  COMP.         
A04527           15 WS-RATE-PLAN-NO            PIC X(03).               
COB305        10 WS-FACTOR        PIC S9(3)V9(6) COMP-3 VALUE 0.   
ACT128                                                                  
ACT128 01  WS-SENIOR-TABLE.                                             
ACT128     05 WS-SENIOR-TBL OCCURS 0 TO 99999 DEPENDING ON WS-SNR-CNT   
ACT128                    ASCENDING KEY WS-SENIOR-ACCOUNT               
ACT128                    INDEXED BY SNR-IND.                           
COB305        10 WS-SENIOR-ACCOUNT        PIC S9(13) COMP-3 VALUE 0.       
ACT128                                                                  
ACT128 01  WS-DURATION-TABLE.                                           
ACT128     05 WS-DURATION-TBL OCCURS 0 TO 9999 DEPENDING ON WS-DUR-CNT  
ACT128                    ASCENDING KEY WS-OPTION                       
ACT128                    INDEXED BY DUR-IND.                           
ACT128        10 WS-OPTION                  PIC X(12).                  
ACT128        10 WS-DURATION                PIC S9(4) COMP.             
ACT128                                                                  
ACT128 01  WS-VERSION-TABLE.                                            
ACT128     05 WS-VERSION-TBL OCCURS 0 TO 9999 DEPENDING ON WS-VERS-CNT  
ACT128                    ASCENDING KEY WS-RATE-PLAN-NUM                
ACT128                    INDEXED BY VERS-IND.                          
ACT128        10 WS-RATE-PLAN-NUM           PIC X(3).                   
ACT128        10 WS-VERSION                 PIC S9(4) COMP.             
      *          RATE_PLAN_NO, VERSION_NO_CNTRL                                 
ACT128                                                                  
ACT128 01  WS-RATE-TABLE.                                               
ACT128     05 WS-RATE-PLAN-HOLD             PIC X(3).                   
COB305     05 WS-FACTOR-HOLD        PIC S9(3)V9(6) COMP-3 VALUE 0.      
ACT128     05 WS-RATE-TBL OCCURS 0 TO 9999 DEPENDING ON WS-RATE-CNT     
ACT128                    ASCENDING KEY WS-RATE-PLAN                    
ACT128                    INDEXED BY RATE-IND.                          
ACT128        10 WS-RATE-PLAN               PIC X(3).                   
COB305        10 WS-FACTOR-NO        PIC S9(3)V9(6) COMP-3 VALUE 0.      
ACT128                                                                  
ACT128 01  WS-CSC-TABLE.                                                
ACT128     05 WS1-CSC-RATE-PLAN.                                        
ACT128        10 WS1-CSC-RATE             PIC X(3).                     
ACT128        10 WS1-VERSION-NO-CNTRL     PIC S9(4) COMP.               
ACT128     05 WS-CSC-TBL OCCURS 0 TO 9999 DEPENDING ON WS-CSC-CNT       
ACT128                    ASCENDING KEY WS-CSC-RATE-PLAN                
ACT128                    INDEXED BY CSC-IND.                           
ACT128        10 WS-CSC-RATE-PLAN.                                      
ACT128           15 WS-CSC-RATE             PIC X(3).                   
ACT128           15 WS-VERSION-NO-CNTRL     PIC S9(4) COMP.             
COB305        10 WS-AMT-CUST-CHRG        PIC S9(5)V9(2) USAGE COMP-3 
COB305           VALUE 0.
                                                                        
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCB159 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / FCA00 MISC INPUT                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_ATTRIBUTE DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_MKT_TIER DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_RTPK_AGR DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      /                                                                         
      / CRM_OPT_ATTR_INCTV DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBOPTATT                                                 
           END-EXEC.                                                            
      /                                                                         
      / CRM_RT_PKG_OPTION DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_SPCL_FCTR_APPL DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_SPCL_FCTR DCLGEN                                                    
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_FIXED_FCTR DCLGEN                                                   
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_RATE_CREATOR DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_RATE_VRSN_DEF DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTVRSN                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_UTIL_ENVRNMT DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_RPT_PCSCA155                                                        
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRPT155                                                 
           END-EXEC.                                                            
      /                                                                         
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **BASE CURSOR TO EXTRACT THE OPTION CODES FOR THE SEB ACCOUNTS            
           EXEC SQL                                                     
              DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                  
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,UT.RATE_PLAN_NO                                   
                     ,UT.IC_NO                                          
                     ,DF.OPTION_CD                                      
                     ,DF.OFFER_CD                                       
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_CALC_TYPE_CD                               
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                     ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                WHERE (AT.CODE_ACCT_STAT IN ('A','B','S') OR            
                        (AT.CODE_ACCT_STAT = 'P' AND                    
                         CAST(AT.ACCT_CREATE_DT AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-PRIOR-PND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PRIOR-PND-DATE
              ) <> 0) OR (LEN(:WS-PRIOR-PND-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PRIOR-PND-DATE
              ), CONVERT(DATE, :WS-PRIOR-PND-DATE) ))) 
                  AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO              
                  AND UT.IC_NO             = DF.IC_NO                   
                  AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE          
                  AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO       
                  AND DF.OPTION_CD         = FI.OPTION_CD               
                  AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
                  AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
                  AND FI.PROC_STATUS_CD    = 'AC'                       
                  AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO              
                  AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','R')     
                  AND DD.EFF_START_DT      =  (SELECT                   
                     MAX(DD1.EFF_START_DT)                              
                     FROM CSS_ACCT_MKT_TIER DD1 WITH(READUNCOMMITTED)           
                      WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*              ,DF.OFFER_CD                                               
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE (AT.CODE_ACCT_STAT IN ('A','B','S') OR                    
MFA-TR*                 (AT.CODE_ACCT_STAT = 'P' AND                            
MFA-TR*                  DATE(AT.ACCT_CREATE_DT) > :WS-PRIOR-PND-DATE))         
MFA-TR*           AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO                      
MFA-TR*           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                      
MFA-TR*           AND UT.IC_NO             = DF.IC_NO                           
MFA-TR*           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                  
MFA-TR*           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND DF.OPTION_CD         = FI.OPTION_CD                       
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*           AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','R')             
MFA-TR*           AND DD.EFF_START_DT      =  (SELECT                           
MFA-TR*              MAX(DD1.EFF_START_DT)                                      
MFA-TR*              FROM CSS_ACCT_MKT_TIER DD1                                 
MFA-TR*               WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT THE DURATIONS                                    
           EXEC SQL                                                     
             DECLARE DURATION_CUR CURSOR         FOR                    
              SELECT OPTION_CD, DURATION_NO                             
                FROM CRM_OPT_ATTR_INCTV WITH(READUNCOMMITTED)                   
               WHERE RT_ATTR_INCTV_TYPE     = 'FIXED PRICE'             
                 AND ATTR_INCTV_STRT_DT    <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND ATTR_INCTV_END_DT     >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND OPT_ATTR_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()         
                 AND OPT_ATTR_VEND_TS      >= CIS.CURRENT$TIMESTAMP()         
                 AND PROC_STATUS_CD         = 'AC'                      
               ORDER BY OPTION_CD                                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DURATION_CUR CURSOR         FOR                            
MFA-TR*       SELECT OPTION_CD, DURATION_NO                                     
MFA-TR*         FROM CRM_OPT_ATTR_INCTV                                         
MFA-TR*        WHERE RT_ATTR_INCTV_TYPE     = 'FIXED PRICE'                     
MFA-TR*          AND ATTR_INCTV_STRT_DT    <= CURRENT DATE                      
MFA-TR*          AND ATTR_INCTV_END_DT     >= CURRENT DATE                      
MFA-TR*          AND OPT_ATTR_VSTART_TS    <= CURRENT TIMESTAMP                 
MFA-TR*          AND OPT_ATTR_VEND_TS      >= CURRENT TIMESTAMP                 
MFA-TR*          AND PROC_STATUS_CD         = 'AC'                              
MFA-TR*        ORDER BY OPTION_CD                                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT THE AGL SENIORS                                  
           EXEC SQL                                                     
             DECLARE AGLSNR_CUR CURSOR   FOR                            
             SELECT ACCOUNT_NO                                          
               FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
              WHERE ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'              
                AND ATTRIBUTE_VALUE_CD = 'YES'                          
                AND STATUS_CD          = 'A'                            
             ORDER BY ACCOUNT_NO                                        
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE AGLSNR_CUR CURSOR   FOR                                    
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'                      
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'YES'                                  
MFA-TR*         AND STATUS_CD          = 'A'                                    
MFA-TR*      ORDER BY ACCOUNT_NO                                                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT THE POSSIBLE FACTORS                             
           EXEC SQL                                                     
             DECLARE FACTOR_CUR CURSOR           FOR                    
            SELECT FF.ACCOUNT_NO, SA.RATE_PLAN_NO, SA.FACTOR, FF.IC_NO  
             FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                       
                 ,CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                   
                 ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                        
             WHERE FF.CODE_UTIL_TYPE = 'G'                              
              AND FF.EFF_DATE_TO    > CAST(SYSDATETIMEOFFSET() AS DATE)         
              AND SA.CODE_UTIL_TYPE = FF.CODE_UTIL_TYPE                 
              AND SA.FACTOR_ID      = FF.FACTOR_ID                      
              AND SF.SPCL_GROUP_CD  = 'BS'                              
              AND SF.FACTOR_ID      = FF.FACTOR_ID                      
           ORDER BY FF.ACCOUNT_NO, FF.IC_NO, SA.RATE_PLAN_NO, SA.FACTOR 
           FOR READ ONLY                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FACTOR_CUR CURSOR           FOR                            
MFA-TR*     SELECT FF.ACCOUNT_NO, SA.RATE_PLAN_NO, SA.FACTOR, FF.IC_NO          
MFA-TR*      FROM CSS_FIXED_FCTR FF                                             
MFA-TR*          ,CSS_SPCL_FCTR_APPL SA                                         
MFA-TR*          ,CSS_SPCL_FCTR SF                                              
MFA-TR*      WHERE FF.CODE_UTIL_TYPE = 'G'                                      
MFA-TR*       AND FF.EFF_DATE_TO    > CURRENT DATE                              
MFA-TR*       AND SA.CODE_UTIL_TYPE = FF.CODE_UTIL_TYPE                         
MFA-TR*       AND SA.FACTOR_ID      = FF.FACTOR_ID                              
MFA-TR*       AND SF.SPCL_GROUP_CD  = 'BS'                                      
MFA-TR*       AND SF.FACTOR_ID      = FF.FACTOR_ID                              
MFA-TR*    ORDER BY FF.ACCOUNT_NO, FF.IC_NO, SA.RATE_PLAN_NO, SA.FACTOR         
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    QUERYNO 7300                                                         
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT A POSSIBLE CSC                                   
                                                                        
           EXEC SQL                                                     
              DECLARE RATEPLAN_CUR CURSOR           FOR                 
                SELECT  SA.RATE_PLAN_NO                                 
                ,SA.FACTOR                                              
                 FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
                     ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
                WHERE SA.CODE_UTIL_TYPE = 'G'                           
                  AND SA.FACTOR_ID      = SF.FACTOR_ID                  
                  AND SF.FACTOR_TYPE    IN ('A')                        
                  AND SA.CODE_STATUS    IN ('A')                        
                  AND SF.ADJUST_ELEMENT =  ('N')                        
                  AND SA.DATE_FROM      <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                  AND SA.DATE_TO        >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                 ORDER BY SA.RATE_PLAN_NO                               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATEPLAN_CUR CURSOR           FOR                         
MFA-TR*         SELECT  SA.RATE_PLAN_NO                                         
MFA-TR*         ,SA.FACTOR                                                      
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR      SF                                     
MFA-TR*         WHERE SA.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND SA.FACTOR_ID      = SF.FACTOR_ID                          
MFA-TR*           AND SF.FACTOR_TYPE    IN ('A')                                
MFA-TR*           AND SA.CODE_STATUS    IN ('A')                                
MFA-TR*           AND SF.ADJUST_ELEMENT =  ('N')                                
MFA-TR*           AND SA.DATE_FROM      <= CURRENT DATE                         
MFA-TR*           AND SA.DATE_TO        >= CURRENT DATE                         
MFA-TR*          ORDER BY SA.RATE_PLAN_NO                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7320                                                   
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT A POSSIBLE CSC                                   
                                                                        
           EXEC SQL                                                     
              DECLARE VERSION_CUR CURSOR           FOR                  
              SELECT RATE_PLAN_NO, VERSION_NO_CNTRL [DESC]                
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RT.CODE_UTIL_TYPE    = 'G'                         
                 AND RT.CODE_STATUS       = 'A'                         
                 AND RT.DISPLAY_START_TS  <= CIS.CURRENT$TIMESTAMP()          
               ORDER BY RT.RATE_PLAN_NO, RT.VERSION_NO_CNTRL DESC       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE VERSION_CUR CURSOR           FOR                          
MFA-TR*       SELECT RATE_PLAN_NO, VERSION_NO_CNTRL DESC                        
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.CODE_UTIL_TYPE    = 'G'                                 
MFA-TR*          AND RT.CODE_STATUS       = 'A'                                 
MFA-TR*          AND RT.DISPLAY_START_TS  <= CURRENT TIMESTAMP                  
MFA-TR*        ORDER BY RT.RATE_PLAN_NO, RT.VERSION_NO_CNTRL DESC               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT A CUSTOMER CHARGE                                
                                                                        
           EXEC SQL                                                     
              DECLARE CUSTCHG_CUR CURSOR           FOR                  
               SELECT J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL,             
                 J4.AMT_CUST_CHRG                                       
               FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = 'G'                            
                ORDER BY J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL           
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUSTCHG_CUR CURSOR           FOR                          
MFA-TR*        SELECT J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL,                     
MFA-TR*          J4.AMT_CUST_CHRG                                               
MFA-TR*        FROM CSS_RATE_VRSN_DEF J4                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = 'G'                                    
MFA-TR*         ORDER BY J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            
      /                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
             UNTIL WS-END-ACCOUNT-CUR.                                  
           PERFORM 7020-CLOSE-ACCOUNT   THRU 7020-EXIT.                 
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE                     WS-WORK-VARIABLES.            
           MOVE ZEROS                  TO WS-CA159-RECS-WRITE.          
                                                                        
      ** SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES                        
           SET WS-NOT-END-ACCOUNT-CUR  TO TRUE.                         
           SET WS-NO-AGL-SEN-DISC      TO TRUE.                         
           SET DONT-SKIP-ACCOUNT       TO TRUE.                         
                                                                        
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (G6-PARM-DATA (1:7) = 'PENDING' AND INPUT-ACTIVE)  
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**     PCSCB159 PROCESSING ERROR   **'        
                 DISPLAY '**   NO PENDING ACCOUNT DAYS LIMIT'           
                 DISPLAY '**       PROCESSING TERMINATED     **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROS                  TO WS-DAYS.                      
           MOVE G6-PARM-DATA (15:4)    TO WS-DAYS.                      
           MOVE WS-DAYS                TO WS-P-DAYS.                    
                                                                        
      ** CALCULATE THE DATE PARM DAYS PRIOR TO CURRENT DATE                     
           PERFORM 7550-GET-PND-PRIOR-DATE THRU 7550-EXIT.              
      *                                                                         
      **DELETE OLD RECORDS FROM TBRPT155                                        
           MOVE 1 TO WS-SUB1                                            
           MOVE 9999 TO WS-SUB2                                         
           PERFORM 7275-DELETE-RPT155      THRU 7275-EXIT.              
      *                                                                         
      ** OPEN THE BASE CURSOR                                                   
           PERFORM 7000-OPEN-ACCOUNT   THRU 7000-EXIT.                  
      *                                                                         
           MOVE 0 TO 5Z-ACCOUNT-NO.                                     
                                                                        
      ** FETCH THE FIRST ROW                                                    
           PERFORM 7010-FETCH-ACCOUNT  THRU 7010-EXIT.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      **      GETS THE ACCOUNT OPTION CODE DETAILS AND WRITE THEM   **          
      **      IN THE OUTPUT EXTRACT FILE                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-ACCOUNT.                                            
      *                                                                         
           INITIALIZE E-FCA159-DATA-REC.                                
                                                                        
A02499     IF FI-OPT-CALC-TYPE-CD = 'FP' OR 'IV'                        
A02499        PERFORM 7100-GET-FXD-PRICE-DUR THRU 7100-EXIT             
A02499        IF DONT-SKIP-ACCOUNT                                      
A02499           MOVE HQ-DURATION-NO      TO WS-SORT-GRP-CODE           
A02499        END-IF                                                    
A02499     ELSE                                                         
A02499        MOVE ZEROS                  TO WS-SORT-GRP-CODE           
           END-IF.                                                      
                                                                        
A02769     MOVE SPACES                    TO WS-AGL-SEN-DISC-SW         
A02769                                       E-FCA159-AGL-SEN-FLAG.     
           PERFORM 7200-CHK-SR-FLAG       THRU 7200-EXIT.               
A02769     MOVE WS-AGL-SEN-DISC-SW        TO E-FCA159-AGL-SEN-FLAG.     
                                                                        
           PERFORM 1100-GET-CURR-CSC-AMT  THRU 1100-EXIT.               
                                                                        
           IF DONT-SKIP-ACCOUNT                                         
              PERFORM 1200-POPULATE-DETAILS THRU 1200-EXIT              
           END-IF.                                                      
                                                                        
           ADD 1 TO WS-COMMIT-CNT.                                      
           IF WS-COMMIT-CNT > 999                                       
              PERFORM 8100-COMMIT THRU 8100-EXIT                        
              MOVE 1 TO WS-COMMIT-CNT                                   
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-ACCOUNT        THRU 7010-EXIT.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1100-GET-CURR-CSC-AMT.                                    **          
      ****************************************************************          
      *                                                                         
       1100-GET-CURR-CSC-AMT.                                           
      *                                                                         
      ** GET THE ADJUSTED CSC AMOUNT FOR THE ACCOUNT IF ANY                     
           MOVE ZEROS                  TO E-FCA159-CSC-AMT.             
           SET ADJ-CSC-NOT-FOUND       TO TRUE.                         
           MOVE AT-ACCOUNT-NO          TO FF-ACCOUNT-NO.                
A02769     MOVE UT-IC-NO               TO FF-IC-NO.                     
           MOVE UT-RATE-PLAN-NO        TO SA-RATE-PLAN-NO.              
           PERFORM 7300-GET-ADJ-CSC-AMT THRU 7300-EXIT.                 
                                                                        
      ** GET THE NORMAL CSC AMOUNT IN CASE ADJUSTMENT IS NOT PRESENT            
           IF ADJ-CSC-NOT-FOUND                                         
              SET DONT-SKIP-ACCOUNT    TO TRUE                          
A04880** GET RATE FACTOR CSC IF IT IS PRESENT                                   
A04880     MOVE 0                    TO SA-FACTOR                       
A04880     PERFORM 7320-GET-REPLACE-CSC-AMT THRU 7320-EXIT              
A04880     IF SA-FACTOR > 0                                             
A04880        MOVE SA-FACTOR         TO E-FCA159-CSC-AMT                
A04880     ELSE                                                         
              MOVE UT-RATE-PLAN-NO     TO RT-RATE-PLAN-NO               
      ** GET THE VERSION CNTRL #                                                
              PERFORM 7400-SELECT-RATE-CREATOR THRU 7400-EXIT           
              IF DONT-SKIP-ACCOUNT                                      
                 MOVE UT-RATE-PLAN-NO     TO J4-RATE-PLAN-NO            
                 MOVE RT-VERSION-NO-CNTRL TO J4-VERSION-NO-CNTRL        
      ** GET THE CSC AMOUNT FOR THE VERSION CNTRL #                             
                 PERFORM 7500-GET-NRML-CSC-AMT THRU 7500-EXIT           
                 IF DONT-SKIP-ACCOUNT                                   
                    MOVE J4-AMT-CUST-CHRG TO E-FCA159-CSC-AMT           
                 END-IF                                                 
              END-IF
           END-IF                                                    
           ELSE                                                         
              MOVE SA-FACTOR           TO E-FCA159-CSC-AMT              
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1200-POPULATE-DETAILS                                     **          
      **      POPULATE THE CA159 FIELDS WITH THE VALUES RETREIVED   **          
      ****************************************************************          
      *                                                                         
       1200-POPULATE-DETAILS.                                           
      *                                                                         
           MOVE DF-OPTION-CD         TO E-FCA159-OPTION-CODE.           
                                                                        
A04019     MOVE E-FCA159-CSC-AMT     TO WS-CSC-AMT-DESC.                
A04019     MOVE FI-OPT-DESC-INT      TO E-FCA159-OPT-DESC.              
A04019*    STRING FI-OPT-DESC-INT DELIMITED BY '   '                            
A04019*           ' with '                                                      
A04019*           WS-CSC-AMT-DESC DELIMITED BY SIZE                             
A04019*           WS-CSC-LIT-DESC DELIMITED BY SIZE                             
A04019*    INTO E-FCA159-OPT-DESC.                                              
                                                                        
           MOVE DF-OFFER-CD          TO E-FCA159-OFFER-CD.              
           MOVE WS-SORT-GRP-CODE     TO E-FCA159-SORT-GRP-CODE.         
           MOVE AT-CODE-ACCT-STAT    TO E-FCA159-STATUS-CODE.           
                                                                        
           PERFORM 8000-INSERT-FCA159 THRU 8000-EXIT.                   
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*** ALL SQL SELECTS, OPENS, FETCHES, AND CLOSES GO IN THE                
      **** 7000- RANGE OF PARAGRAPHS                                            
      *                                                                         
      ****************************************************************          
      **  7000-OPEN-ACCOUNT                                         **          
      **      OPEN THE MAIN CURSOR ACCOUNT_CUR                      **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-ACCOUNT.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCOUNT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '       7000-OPEN-ACCOUNT '                      
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO               
               DISPLAY ' OPTION CODE    = ' DF-OPTION-CD                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-ACCOUNT                                        **          
      **      FETCH THE ACCOUNTS FOR PROCESSING                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:UT-RATE-PLAN-NO                                   
A02769              ,:UT-IC-NO                                          
                    ,:DF-OPTION-CD                                      
                    ,:DF-OFFER-CD                                       
                    ,:FI-OPT-DESC-INT                                   
                    ,:FI-OPT-CALC-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF 5Z-ACCOUNT-NO = AT-ACCOUNT-NO                          
                 DISPLAY 'DUPLICATE ACCOUNT ' AT-ACCOUNT-NO ' BYPASSED' 
                 GO TO 7010-FETCH-ACCOUNT                               
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-ACCOUNT-CUR TO TRUE                         
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH ACCOUNT_CUR '                    
                 DISPLAY '       7010-FETCH-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-ACCOUNT                                        **          
      **      CLOSE THE MAIN CURSOR ACCOUNT_CUR                     **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '      CLOSE ACCOUNT_CUR '                        
              DISPLAY '      7020-CLOSE-ACCOUNT '                       
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7100-GET-FXD-PRICE-DUR.                                   **          
      **      GET THE DURATION FOR THE FIXED PRICE OPTION CD        **          
      ****************************************************************          
      *                                                                         
       7100-GET-FXD-PRICE-DUR.                                          
      *                                                                         
           IF WS-DUR-CNT = 0                                            
              PERFORM 7110-LOAD-DURATION THRU 7110-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS TO HQ-DURATION-NO.                                
           SEARCH ALL WS-DURATION-TBL                                   
              AT END                                                    
                 SET SKIP-ACCOUNT         TO TRUE                       
              WHEN WS-OPTION(DUR-IND) = DF-OPTION-CD                    
                 MOVE WS-DURATION(DUR-IND) TO HQ-DURATION-NO            
                 SET DONT-SKIP-ACCOUNT     TO TRUE                      
           END-SEARCH.                                                  
           IF HQ-DURATION-NO > 0                                        
              SET DONT-SKIP-ACCOUNT     TO TRUE                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7110-LOAD-DURATION.                                       **          
      **    LOAD THE FACTOR TABLE                                               
      ****************************************************************          
       7110-LOAD-DURATION.                                              
                                                                        
           PERFORM 7111-OPEN-DURATION THRU 7111-EXIT.                   
                                                                        
           PERFORM 7112-FETCH-DURATION THRU 7112-EXIT.                  
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-DUR-CNT > 99998                                     
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       DURATION TABLE OVERFLOW'                
                DISPLAY '       7110-LOAD-DURATION  '                   
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              ADD 1 TO WS-DUR-CNT                                       
              MOVE E-FCA159-OPTION-CODE to WS-OPTION(WS-DUR-CNT)        
              MOVE HQ-DURATION-NO    TO WS-DURATION(WS-DUR-CNT)         
              PERFORM 7112-FETCH-DURATION THRU 7112-EXIT                
           END-PERFORM.                                                 
                                                                        
           PERFORM 7113-CLOSE-DURATION THRU 7113-EXIT.                  
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7111-OPEN-DURATION.                                       **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7111-OPEN-DURATION.                                              
                                                                        
           EXEC SQL                                                     
               OPEN DURATION_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN DURATION_CUR '                      
               DISPLAY '       7111-OPEN-DURATION  '                    
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7112-FETCH-DURATION.                                      **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7112-FETCH-DURATION.                                             
                                                                        
           EXEC SQL                                                     
               FETCH DURATION_CUR                                       
                INTO :E-FCA159-OPTION-CODE                              
                    ,:HQ-DURATION-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH DURATION_CUR '                     
               DISPLAY '       7112-FETCH-DURATION  '                   
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7112-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7113-CLOSE-DURATION.                                      **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7113-CLOSE-DURATION.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE DURATION_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE DURATION_CUR '                     
               DISPLAY '       7113-CLOSE-DURATION  '                   
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7113-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7200-CHK-SR-FLAG.                                         **          
      **      CHK IF THE ACCOUNT IS AGL SENIOR ACCOUNT              **          
      ****************************************************************          
      *                                                                         
       7200-CHK-SR-FLAG.                                                
      *                                                                         
           IF WS-SNR-CNT = 0                                            
              PERFORM 7210-LOAD-AGLSNR THRU 7210-EXIT                   
           END-IF.                                                      
      *                                                                         
           SEARCH ALL WS-SENIOR-TBL                                     
              AT END                                                    
                 MOVE 'N' TO WS-AGL-SEN-DISC-SW                         
              WHEN WS-SENIOR-ACCOUNT(SNR-IND) = AT-ACCOUNT-NO           
                 MOVE 'Y' TO WS-AGL-SEN-DISC-SW                         
           END-SEARCH.                                                  
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7210-LOAD-AGLSNR.                                         **          
      **    LOAD THE FACTOR TABLE                                               
      ****************************************************************          
       7210-LOAD-AGLSNR.                                                
                                                                        
           PERFORM 7211-OPEN-AGLSNR THRU 7211-EXIT.                     
                                                                        
           PERFORM 7212-FETCH-AGLSNR THRU 7212-EXIT.                    
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-DUR-CNT > 99998                                     
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       AGLSNR TABLE OVERFLOW'                  
                DISPLAY '       7210-LOAD-AGLSNR  '                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              ADD 1 TO WS-SNR-CNT                                       
              MOVE WS1-ACCOUNT-NO    TO WS-SENIOR-ACCOUNT(WS-SNR-CNT)   
              PERFORM 7212-FETCH-AGLSNR THRU 7212-EXIT                  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7213-CLOSE-AGLSNR THRU 7213-EXIT.                    
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7211-OPEN-AGLSNR.                                         **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7211-OPEN-AGLSNR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN AGLSNR_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN AGLSNR_CUR '                        
               DISPLAY '       7211-OPEN-AGLSNR  '                      
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7211-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7212-FETCH-AGLSNR.                                        **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7212-FETCH-AGLSNR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH AGLSNR_CUR                                         
                INTO :WS1-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH AGLSNR_CUR '                       
               DISPLAY '       7212-FETCH-AGLSNR  '                     
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7212-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7213-CLOSE-AGLSNR.                                        **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7213-CLOSE-AGLSNR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE AGLSNR_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE AGLSNR_CUR '                       
               DISPLAY '       7213-CLOSE-AGLSNR  '                     
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7213-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **  7275-DELETE-RPT155.                                         *         
      *****************************************************************         
      *                                                                         
       7275-DELETE-RPT155.                                              
      *                                                                         
           EXEC SQL                                                     
              DELETE                                                    
                FROM CSS_RPT_PCSCA155                                   
               WHERE JOB_NAME    ='PCSCA159'                            
                 AND ROW_ID BETWEEN :WS-SUB1 AND :WS-SUB2               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 0 TO AT-ACCOUNT-NO                                   
              PERFORM 8100-COMMIT THRU 8100-EXIT                        
              ADD 9999 TO WS-SUB1                                       
              ADD 9999 TO WS-SUB2                                       
              GO TO 7275-DELETE-RPT155                                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              DISPLAY 'TABLE DELETION COMPLETE'                         
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCB159 **'      
              DISPLAY '** PARA 7275-DELETE-RPT155              **'      
              DISPLAY '** ERROR DURING SELECT OF TIMESTAMP     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '** PROCESSING TERMINATED                **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **  7300-GET-ADJ-CSC-AMT.                                     **          
      **      CHK IF THE ACCOUNT HAS ANY ADJUSTED CSC AMOUNT        **          
      ****************************************************************          
      *                                                                         
       7300-GET-ADJ-CSC-AMT.                                            
                                                                        
           IF WS-INCTV-CNT = 0                                          
              PERFORM 7310-LOAD-FACTOR THRU 7310-EXIT                   
           END-IF.                                                      
      *                                                                         
           MOVE FF-ACCOUNT-NO   TO WS1-ACCOUNT-NO                       
           MOVE FF-IC-NO        TO WS1-IC-NO                            
           MOVE SA-RATE-PLAN-NO TO WS1-RATE-PLAN-NO                     
            SEARCH ALL WS-INCTV-TBL                                     
              WHEN WS-FACTOR-KEY(INCTV-IND) = WS1-FACTOR-KEY            
                 MOVE WS-FACTOR(INCTV-IND) TO SA-FACTOR                 
                 SET ADJ-CSC-FOUND       TO TRUE                        
            END-SEARCH.                                                 
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7310-LOAD-FACTOR.                                         **          
      **    LOAD THE FACTOR TABLE                                               
      ****************************************************************          
       7310-LOAD-FACTOR.                                                
                                                                        
           PERFORM 7311-OPEN-FACTOR THRU 7311-EXIT.                     
                                                                        
           PERFORM 7312-FETCH-FACTOR THRU 7312-EXIT.                    
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-INCTV-CNT > 99998                                   
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       INCTV TABLE OVERFLOW'                   
                DISPLAY '       7310-LOAD-FACTOR  '                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              ADD 1 TO WS-INCTV-CNT                                     
              MOVE WS1-ACCOUNT-NO    TO WS-ACCOUNT-NO(WS-INCTV-CNT)     
              MOVE WS1-IC-NO         TO WS-IC-NO(WS-INCTV-CNT)          
              MOVE WS1-RATE-PLAN-NO  TO WS-RATE-PLAN-NO(WS-INCTV-CNT)   
              MOVE SA-FACTOR         TO WS-FACTOR(WS-INCTV-CNT)         
              PERFORM 7312-FETCH-FACTOR THRU 7312-EXIT                  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7313-CLOSE-FACTOR THRU 7313-EXIT.                    
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7311-OPEN-FACTOR.                                         **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7311-OPEN-FACTOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN FACTOR_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN FACTOR_CUR '                        
               DISPLAY '       7311-OPEN-FACTOR  '                      
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7311-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7312-FETCH-FACTOR.                                        **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7312-FETCH-FACTOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH FACTOR_CUR                                         
                INTO :WS1-ACCOUNT-NO                                    
                    ,:WS1-RATE-PLAN-NO                                  
                    ,:SA-FACTOR                                         
                    ,:WS1-IC-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH FACTOR_CUR '                       
               DISPLAY '       7312-FETCH-FACTOR  '                     
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7312-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7313-CLOSE-FACTOR.                                        **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7313-CLOSE-FACTOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE FACTOR_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE FACTOR_CUR '                       
               DISPLAY '       7313-CLOSE-FACTOR  '                     
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7313-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **CHK IF THE ACCOUNT HAS ANY CSC TO BE REPLACED BY RATE FACTOR *          
      ****************************************************************          
       7320-GET-REPLACE-CSC-AMT.                                        
                                                                        
           IF WS-RATE-CNT = 0                                           
              PERFORM 7321-LOAD-RATEPLAN THRU 7321-EXIT                 
              MOVE 0                    TO SA-FACTOR                    
           END-IF.                                                      
      *                                                                         
           MOVE SA-RATE-PLAN-NO TO WS1-RATE-PLAN-NO                     
            SEARCH ALL WS-RATE-TBL                                      
              WHEN WS-RATE-PLAN(RATE-IND) = WS1-RATE-PLAN-NO            
                 MOVE WS-FACTOR-NO(RATE-IND) TO SA-FACTOR               
            END-SEARCH.                                                 
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **  7321-LOAD-RATEPLAN.                                       **          
      **    LOAD THE FACTOR TABLE                                               
      ****************************************************************          
       7321-LOAD-RATEPLAN.                                              
                                                                        
           PERFORM 7322-OPEN-RATEPLAN THRU 7322-EXIT.                   
                                                                        
           PERFORM 7323-FETCH-RATEPLAN THRU 7323-EXIT.                  
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-RATE-CNT > 9998                                     
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       RATE TABLE OVERFLOW'                    
                DISPLAY '       7321-LOAD-RATEPLAN'                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              ADD 1 TO WS-RATE-CNT                                      
              MOVE WS1-RATE-PLAN-NO  TO WS-RATE-PLAN(WS-RATE-CNT)       
              MOVE SA-FACTOR         TO WS-FACTOR-NO(WS-RATE-CNT)       
              PERFORM 7323-FETCH-RATEPLAN THRU 7323-EXIT                
           END-PERFORM.                                                 
                                                                        
           PERFORM 7324-CLOSE-RATEPLAN THRU 7324-EXIT.                  
                                                                        
       7321-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  7322-OPEN-RATEPLAN.                                       **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7322-OPEN-RATEPLAN.                                              
                                                                        
           EXEC SQL                                                     
               OPEN RATEPLAN_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN RATEPLAN_CUR '                      
               DISPLAY '       7322-OPEN-RATEPLAN  '                    
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7322-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7323-FETCH-RATEPLAN.                                      **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7323-FETCH-RATEPLAN.                                             
                                                                        
           EXEC SQL                                                     
               FETCH RATEPLAN_CUR                                       
                INTO :WS1-RATE-PLAN-NO                                  
                    ,:SA-FACTOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH RATEPLAN_CUR '                     
               DISPLAY '       7323-FETCH-RATEPLAN  '                   
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7323-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7324-CLOSE-RATEPLAN.                                      **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7324-CLOSE-RATEPLAN.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE RATEPLAN_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE RATEPLAN_CUR '                     
               DISPLAY '       7324-CLOSE-RATEPLAN  '                   
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7324-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7400-SELECT-RATE-CREATOR.                                     **        
      *                                                               **        
      ******************************************************************        
       7400-SELECT-RATE-CREATOR.                                        
                                                                        
           IF WS-VERS-CNT = 0                                           
              PERFORM 7421-LOAD-VERSION THRU 7421-EXIT                  
           END-IF.                                                      
      *                                                                         
           MOVE SA-RATE-PLAN-NO TO WS1-RATE-PLAN-NO                     
           SEARCH ALL WS-VERSION-TBL                                    
            AT END                                                      
               SET SKIP-ACCOUNT              TO TRUE                    
               DISPLAY 'RATE CREATOR VERSION NULL!!!'                   
               DISPLAY 'RATE PLAN        : '  RT-RATE-PLAN-NO           
               DISPLAY 'SKIPPING ACCOUNT : '  AT-ACCOUNT-NO             
            WHEN WS-RATE-PLAN-NUM(VERS-IND) = WS1-RATE-PLAN-NO          
                 MOVE WS-VERSION(VERS-IND) TO RT-VERSION-NO-CNTRL       
           END-SEARCH.                                                  
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7421-LOAD-VERSION.                                        **          
      **    LOAD THE VERSION TABLE                                              
      ****************************************************************          
       7421-LOAD-VERSION.                                               
                                                                        
           PERFORM 7422-OPEN-VERSION THRU 7422-EXIT.                    
                                                                        
           PERFORM 7423-FETCH-VERSION THRU 7423-EXIT.                   
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-VERS-CNT > 9998                                     
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       RATE TABLE OVERFLOW'                    
                DISPLAY '       7421-LOAD-RATEPLAN'                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              IF (WS-VERS-CNT = 0       OR                              
                (WS1-RATE-PLAN-NO NOT = WS-RATE-PLAN-NUM(WS-VERS-CNT))) 
                ADD 1 TO WS-VERS-CNT                                    
                MOVE WS1-RATE-PLAN-NO TO WS-RATE-PLAN-NUM(WS-VERS-CNT)  
                MOVE RT-VERSION-NO-CNTRL TO WS-VERSION(WS-VERS-CNT)     
              END-IF                                                    
              PERFORM 7423-FETCH-VERSION THRU 7423-EXIT                 
           END-PERFORM.                                                 
                                                                        
           PERFORM 7424-CLOSE-VERSION THRU 7424-EXIT.                   
                                                                        
       7421-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  7422-OPEN-VERSION.                                        **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7422-OPEN-VERSION.                                               
                                                                        
           EXEC SQL                                                     
               OPEN VERSION_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN VERSION_CUR '                       
               DISPLAY '       7422-OPEN-VERSION  '                     
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7422-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7423-FETCH-VERSION.                                       **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7423-FETCH-VERSION.                                              
                                                                        
           EXEC SQL                                                     
               FETCH VERSION_CUR                                        
                INTO :WS1-RATE-PLAN-NO                                  
                    ,:RT-VERSION-NO-CNTRL                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH VERSION_CUR '                      
               DISPLAY '       7423-FETCH-VERSION  '                    
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7423-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7424-CLOSE-VERSION.                                       **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7424-CLOSE-VERSION.                                              
                                                                        
           EXEC SQL                                                     
               CLOSE VERSION_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE VERSION_CUR '                      
               DISPLAY '       7424-CLOSE-VERSION  '                    
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7424-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7500-GET-NRML-CSC-AMT.                                    **          
      **      GET THE NORMAL CSC AMOUNT FOR THE CUSTOMER            **          
      ****************************************************************          
      *                                                                         
       7500-GET-NRML-CSC-AMT.                                           
                                                                        
           IF WS-CSC-CNT = 0                                            
              PERFORM 7521-LOAD-CSC THRU 7521-EXIT                      
           END-IF.                                                      
      *                                                                         
           MOVE UT-RATE-PLAN-NO           TO WS1-CSC-RATE               
           MOVE RT-VERSION-NO-CNTRL       TO WS1-VERSION-NO-CNTRL.      
           SEARCH ALL WS-CSC-TBL                                        
              AT END                                                    
                 SET SKIP-ACCOUNT         TO TRUE                       
                 DISPLAY 'RATE VRSN NOT FOUND!!!'                       
                 DISPLAY 'RATE PLAN        : '  J4-RATE-PLAN-NO         
                 DISPLAY 'SKIPPING ACCOUNT : '  AT-ACCOUNT-NO           
              WHEN WS-CSC-RATE-PLAN(CSC-IND) = WS1-CSC-RATE-PLAN        
                 MOVE WS-AMT-CUST-CHRG (CSC-IND) TO J4-AMT-CUST-CHRG    
           END-SEARCH.                                                  
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7521-LOAD-CSC.                                            **          
      **    LOAD THE CSC TABLE                                                  
      ****************************************************************          
       7521-LOAD-CSC.                                                   
                                                                        
           PERFORM 7522-OPEN-CSC THRU 7522-EXIT.                        
                                                                        
           PERFORM 7523-FETCH-CSC THRU 7523-EXIT.                       
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-CSC-CNT > 9998                                      
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       RATE TABLE OVERFLOW'                    
                DISPLAY '       7521-LOAD-RATEPLAN'                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
                ADD 1 TO WS-CSC-CNT                                     
                MOVE J4-RATE-PLAN-NO     TO WS-CSC-RATE(WS-CSC-CNT)     
                MOVE J4-VERSION-NO-CNTRL TO                             
                     WS-VERSION-NO-CNTRL(WS-CSC-CNT)                    
                MOVE J4-AMT-CUST-CHRG    TO                             
                     WS-AMT-CUST-CHRG(WS-CSC-CNT)                       
              PERFORM 7523-FETCH-CSC THRU 7523-EXIT                     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7524-CLOSE-CSC THRU 7524-EXIT.                       
                                                                        
       7521-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  7522-OPEN-CSC.                                            **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7522-OPEN-CSC.                                                   
                                                                        
           EXEC SQL                                                     
               OPEN CUSTCHG_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN CUSTCHG_CUR '                       
               DISPLAY '       7522-OPEN-CSC  '                         
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7522-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7523-FETCH-CSC.                                           **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7523-FETCH-CSC.                                                  
                                                                        
           EXEC SQL                                                     
               FETCH CUSTCHG_CUR                                        
                INTO :J4-RATE-PLAN-NO                                   
                    ,:J4-VERSION-NO-CNTRL                               
                    ,:J4-AMT-CUST-CHRG                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH CUSTCHG_CUR '                      
               DISPLAY '       7523-FETCH-CSC  '                        
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7523-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7524-CLOSE-CSC.                                           **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7524-CLOSE-CSC.                                                  
                                                                        
           EXEC SQL                                                     
               CLOSE CUSTCHG_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE CUSTCHG_CUR '                      
               DISPLAY '       7524-CLOSE-CSC  '                        
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7524-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7550-GET-PND-PRIOR-DATE.                                 **          
      **      GET THE DATE PARM PRIOR TO CURRENT DATE TO FILTER     **          
      **      THE PENDING ACCOUNTS IN MAIN CURSOR                   **          
      ****************************************************************          
      *                                                                         
       7550-GET-PND-PRIOR-DATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))          
                                     - :WS-P-DAYS)-1, 
              CAST('00010101' AS DATE))
            INTO
              :WS-PRIOR-PND-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PRIOR-PND-DATE = DATE(DAYS(CURRENT DATE)                  
MFA-TR*                              - :WS-P-DAYS)                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '   7550-GET-PND-PRIOR-DATE'                      
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      **     8000-INSERT-FCA159.                                      **        
      ******************************************************************        
      *                                                                         
       8000-INSERT-FCA159.                                              
      *                                                                         
           INITIALIZE DCLCSS-RPT-PCSCA155.                              
           MOVE 'PCSCA159'                  TO 5Z-JOB-NAME              
           ADD 1                            TO WS-CA159-RECS-WRITE      
           MOVE  WS-CA159-RECS-WRITE        TO 5Z-ROW-ID                
           MOVE  '01'                       TO 5Z-COMPANY-NO            
           MOVE  E-FCA159-OPTION-CODE       TO 5Z-OPTION-CD             
           MOVE  E-FCA159-OFFER-CD          TO 5Z-OFFER-CD              
           MOVE  E-FCA159-STATUS-CODE       TO 5Z-CODE-ACCT-STAT        
           MOVE  AT-ACCOUNT-NO              TO 5Z-ACCOUNT-NO            
           MOVE  E-FCA159-AGL-SEN-FLAG      TO 5Z-AGL-SENIOR-ATTR       
           PERFORM VARYING WS-SUB1 FROM 50 BY -1 UNTIL                  
             5Z-OPTION-DESC-LEN > 0 OR WS-SUB1 < 1                      
             IF E-FCA159-OPT-DESC(WS-SUB1:1) > ' '                      
               MOVE  WS-SUB1 TO 5Z-OPTION-DESC-LEN                      
             END-IF                                                     
           END-PERFORM                                                  
           MOVE  E-FCA159-OPT-DESC          TO 5Z-OPTION-DESC-TEXT      
           MOVE  E-FCA159-CSC-AMT           TO 5Z-CSC-AMT               
           MOVE  E-FCA159-SORT-GRP-CODE     TO 5Z-DURATION-NO.          
                                                                        
           EXEC SQL                                                     
           INSERT INTO CSS_RPT_PCSCA155                                 
                  ( CREATE_TS                                           
                   ,JOB_NAME                                            
                   ,ROW_ID                                              
                   ,COMPANY_NO                                          
                   ,OPTION_CD                                           
                   ,OFFER_CD                                            
                   ,CODE_ACCT_STAT                                      
                   ,THERM_PRICE                                         
                   ,ACCOUNT_NO                                          
                   ,ANNV_MONTH                                          
                   ,TIER_ACCT_TYPE_CD                                   
                   ,RATE_TYPE_CD                                        
                   ,RATE_PLAN_NO                                        
                   ,OPTION_DESC                                         
                   ,CSC_AMT                                             
                   ,ACCT_TYPE_CD                                        
                   ,THERM_PRICE_DSCNT                                   
                   ,NET_THERM_PRICE                                     
                   ,CSC_DSCNT                                           
                   ,NET_CSC                                             
                   ,DURATION_NO                                         
                   ,AGL_SENIOR_ATTR                                     
                   ,LAST_UPDATE_TS    )                                 
              VALUES (CIS.CURRENT$TIMESTAMP()                                 
                     ,:5Z-JOB-NAME                                      
                     ,:5Z-ROW-ID                                        
                     ,:5Z-COMPANY-NO                                    
                     ,:5Z-OPTION-CD                                     
                     ,:5Z-OFFER-CD                                      
                     ,:5Z-CODE-ACCT-STAT                                
                     ,:5Z-THERM-PRICE                                   
                     ,:5Z-ACCOUNT-NO                                    
                     ,:5Z-ANNV-MONTH                                    
                     ,:5Z-TIER-ACCT-TYPE-CD                             
                     ,:5Z-RATE-TYPE-CD                                  
                     ,:5Z-RATE-PLAN-NO                                  
                     ,:5Z-OPTION-DESC                                   
                     ,:5Z-CSC-AMT                                       
                     ,:5Z-ACCT-TYPE-CD                                  
                     ,:5Z-THERM-PRICE-DSCNT                             
                     ,:5Z-NET-THERM-PRICE                               
                     ,:5Z-CSC-DSCNT                                     
                     ,:5Z-NET-CSC                                       
                     ,:5Z-DURATION-NO                                   
                     ,:5Z-AGL-SENIOR-ATTR                               
                     ,CIS.CURRENT$TIMESTAMP()    )                            
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_RPT_PCSCA155                                         
MFA-TR*           ( CREATE_TS                                                   
MFA-TR*            ,JOB_NAME                                                    
MFA-TR*            ,ROW_ID                                                      
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,OPTION_CD                                                   
MFA-TR*            ,OFFER_CD                                                    
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,THERM_PRICE                                                 
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,ANNV_MONTH                                                  
MFA-TR*            ,TIER_ACCT_TYPE_CD                                           
MFA-TR*            ,RATE_TYPE_CD                                                
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,OPTION_DESC                                                 
MFA-TR*            ,CSC_AMT                                                     
MFA-TR*            ,ACCT_TYPE_CD                                                
MFA-TR*            ,THERM_PRICE_DSCNT                                           
MFA-TR*            ,NET_THERM_PRICE                                             
MFA-TR*            ,CSC_DSCNT                                                   
MFA-TR*            ,NET_CSC                                                     
MFA-TR*            ,DURATION_NO                                                 
MFA-TR*            ,AGL_SENIOR_ATTR                                             
MFA-TR*            ,LAST_UPDATE_TS    )                                         
MFA-TR*       VALUES (CURRENT TIMESTAMP                                         
MFA-TR*              ,:5Z-JOB-NAME                                              
MFA-TR*              ,:5Z-ROW-ID                                                
MFA-TR*              ,:5Z-COMPANY-NO                                            
MFA-TR*              ,:5Z-OPTION-CD                                             
MFA-TR*              ,:5Z-OFFER-CD                                              
MFA-TR*              ,:5Z-CODE-ACCT-STAT                                        
MFA-TR*              ,:5Z-THERM-PRICE                                           
MFA-TR*              ,:5Z-ACCOUNT-NO                                            
MFA-TR*              ,:5Z-ANNV-MONTH                                            
MFA-TR*              ,:5Z-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:5Z-RATE-TYPE-CD                                          
MFA-TR*              ,:5Z-RATE-PLAN-NO                                          
MFA-TR*              ,:5Z-OPTION-DESC                                           
MFA-TR*              ,:5Z-CSC-AMT                                               
MFA-TR*              ,:5Z-ACCT-TYPE-CD                                          
MFA-TR*              ,:5Z-THERM-PRICE-DSCNT                                     
MFA-TR*              ,:5Z-NET-THERM-PRICE                                       
MFA-TR*              ,:5Z-CSC-DSCNT                                             
MFA-TR*              ,:5Z-NET-CSC                                               
MFA-TR*              ,:5Z-DURATION-NO                                           
MFA-TR*              ,:5Z-AGL-SENIOR-ATTR                                       
MFA-TR*              ,CURRENT TIMESTAMP    )                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCB159 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 8000       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      JOBNAME   = ' 5Z-JOB-NAME                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *============================================================             
       8100-COMMIT.                                                     
      *============================================================             
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF AT-ACCOUNT-NO > 0                                         
              DISPLAY 'COMMITTED UP TO ACCOUNT: ' AT-ACCOUNT-NO
           END-IF.        
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '           PCSCB159 ENDING '.                       
           DISPLAY '*******************************************'.       
           DISPLAY '           PROGRAM SUMMARY'.                        
           DISPLAY '*******************************************'.       
           DISPLAY ' ACCOUNTS EXTRACTED : '  WS-CA159-RECS-WRITE.       
           DISPLAY '*******************************************'.       
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM****************************         
