       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCB156.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. JAN 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **      SEB FIXED RATE ACTIVITY REPORT EXTRACT PROGRAM          **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES A EXTRACT FILE TO GENERATE THE 775    **        
      **   FIXED RATE ACTIVITY REPORT. THIS IS MODFIED DESIGN TO      **        
      **   ACCOMODATE THE NEW SEB RATE STRUCTURE FOR SEB RATE         **        
      **   RE-ENGINEERING PROJECT.                                    **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 01/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
P00141** 04/2009  SS97726  ADD START/END DATE TO OPT_ATTR_INCTV       **        
P00211** 12/2009  MN90523  EARLY RENEWAL CHANGES                      **        
P00211** 02/2010  MN90523  CHANGES MADE TO USE REPORT DATE RATHER     **        
P00211**                   REVENUE MONTH FROM JOB PARM TABLE          **        
P00473** 05/2011  SB93596  CHGS INCLUDED TO PULL APPROVED             **        
P00473**                   OPTION/OPT ATTR INCTV RECORDS.             **        
A04019** 07/2012  VIJAY    SEB CSC CHANGES.                           **        
A05460** 11/2016  DB41297  Convert PCSCA155/156/159 to write output   **        
ACT350**                   TO DB2 TABLE.                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCB156'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCB156 STARTS HERE'.            
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT REC FCSCA156            *          
      ****************************************************************          
      *                                                                         
       01  FIOCA156.                                                    
         02  E-FCA156-DATA-REC.                                         
           05  E-FCA156-OPTION-CODE        PIC X(12).                   
           05  E-FCA156-OPTION-DESC        PIC X(50).                   
           05  E-FCA156-STATUS-CODE        PIC X(01).                   
           05  E-FCA156-SORT-GRP-CODE      PIC X(01).                   
           05  E-FCA156-DURATION-NO        PIC 9(04).                   
           05  E-FCA156-ACCT-STAT          PIC X(01).                   
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
                                                                        
       01  WS-WORK-VARIABLES.                                           
P00211     05  WS-REVENUE-MNTH             PIC X(06)  VALUE SPACES.     
P00211     05  WS-REVNUE-MTH-N     REDEFINES WS-REVENUE-MNTH            
P00211                                     PIC 9(06).                   
P00211     05  WS-EFF-REV-MTH              PIC S9(9) USAGE COMP         
P00211                                                     VALUE 0.     
           05  WS-NULL-IND-01              PIC S9(4)  COMP VALUE 0.     
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-CA156-RECS-WRITE         PIC 9(7)   VALUE ZEROS.      
           05  WS-COMMIT-CNT               PIC 9(7)   VALUE ZEROS.      
COB305     05 WS-SUB1        PIC S9(7) COMP-3 VALUE 0.            
COB305     05 WS-SUB2        PIC S9(7) COMP-3 VALUE 0.            
                                                                        
       01  WS-811                          PIC S9(4)  COMP VALUE -811.  
                                                                        
       01  WS-FCA156-STATUS                PIC X(2)   VALUE '00'.       
       01  WS-FCA156ER-STATUS              PIC X(2)   VALUE '00'.       
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
A04019 01  WS-CSC-AMT-DESC                 PIC $Z9.99 .                 
A04019 01  WS-CSC-LIT-DESC                 PIC X(04)  VALUE ' CSC'.     
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)   VALUE 'PCSCA156'. 
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSCA156'. 
                                                                        
      *****************************************************************         
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     **         
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  **         
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    **         
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       **         
      *****************************************************************         
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-END-ACCOUNT-CUR-SW       PIC X(1) VALUE 'N'.          
               88  WS-END-ACCOUNT-CUR      VALUE 'Y'.                   
               88  WS-NOT-END-ACCOUNT-CUR  VALUE 'N'.                   
           05  WS-ACCOUNT-SKIP-SW          PIC X(1) VALUE 'N'.          
               88  SKIP-ACCOUNT            VALUE 'Y'.                   
               88  DONT-SKIP-ACCOUNT       VALUE 'N'.                   
                                                                        
       01  WS-CSC-TABLE.                                                
           05 WS-CSC-CNT                    PIC S9(5) COMP-3 VALUE +0.  
           05 WS1-CSC-RATE                  PIC X(3).                   
           05 WS-CSC-TBL OCCURS 0 TO 9999 DEPENDING ON WS-CSC-CNT       
                          ASCENDING KEY WS-CSC-RATE-PLAN                
                          INDEXED BY CSC-IND.                           
              10 WS-CSC-RATE-PLAN           PIC X(3).                   
              10 WS-VERSION-NO-CNTRL        PIC S9(4) COMP.             
COB305        10 WS-AMT-CUST-CHRG        PIC S9(5)V9(2) USAGE COMP-3 
COB305           VALUE 0.
                                                                        
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
      /*****   WS AREA FOR REPORTDATE REVENUE MONTH                             
       COPY CWS00114.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCB156 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / FCA00 MISC INPUT                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_MKT_TIER DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_RTPK_AGR DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      /                                                                         
      / CRM_OPT_ATTR_INCTV DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBOPTATT                                                 
           END-EXEC.                                                            
      /                                                                         
      / CRM_RT_PKG_OPTION DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_UTIL_ENVRNMT DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      /                                                                         
A04019/ CSS_RATE_VRSN_DEF DCLGEN - J4                                           
      /                                                                         
A04019     EXEC SQL                                                             
A04019         INCLUDE TBRTVRSN                                                 
A04019     END-EXEC.                                                            
      *                                                              *          
      ****************************************************************          
      * CSS_RPT_PCSCA155         - 5Z                                *          
      ****************************************************************          
      *                                                              *          
      *    EXEC SQL                                                             
      *        INCLUDE TBRPT155                                                 
      *    END-EXEC.                                                            
      ******************************************************************        
      * DCLGEN TABLE(CSS_RPT_PCSCA155)                            *             
      *        LIBRARY(DAT.DEVL.PDS.DCLGENLB(TBRPT155))                *        
      *        ACTION(REPLACE)                                         *        
      *        LANGUAGE(COBOL)                                         *        
      *        QUOTE                                                   *        
      * ... IS THE DCLGEN COMMAND THAT MADE THE FOLLOWING STATEMENTS   *        
      ******************************************************************        
           EXEC SQL DECLARE CSS_RPT_PCSCA155 TABLE                      
           ( CREATE_TS                  DATETIME2(6) NOT NULL,             
             JOB_NAME                   CHAR(8) NOT NULL,               
             ROW_ID                     INT NOT NULL,               
             COMPANY_NO                 CHAR(2) NOT NULL,               
             OPTION_CD                  CHAR(12) NOT NULL,              
             OFFER_CD                   CHAR(12) NOT NULL,              
             CODE_ACCT_STAT             CHAR(1) NOT NULL,               
             THERM_PRICE                DECIMAL(11,6) NOT NULL,        
             ACCOUNT_NO                 DECIMAL(13,0) NOT NULL,        
             ANNV_MONTH                 CHAR(6) NOT NULL,               
             TIER_ACCT_TYPE_CD          CHAR(1) NOT NULL,               
             RATE_TYPE_CD               CHAR(1) NOT NULL,               
             RATE_PLAN_NO               CHAR(3) NOT NULL,               
             OPTION_DESC                VARCHAR(50) NOT NULL,           
             CSC_AMT                    DECIMAL(7,4) NOT NULL,         
             ACCT_TYPE_CD               CHAR(1) NOT NULL,               
             THERM_PRICE_DSCNT          DECIMAL(11,6) NOT NULL,        
             NET_THERM_PRICE            DECIMAL(11,6) NOT NULL,        
             CSC_DSCNT                  DECIMAL(11,6) NOT NULL,        
             NET_CSC                    DECIMAL(11,6) NOT NULL,        
             DURATION_NO                INT NOT NULL,               
             AGL_SENIOR_ATTR            CHAR(1) NOT NULL,               
             LAST_UPDATE_TS             DATETIME2(6) NOT NULL              
           ) END-EXEC.                                                  
      ******************************************************************        
      * COBOL DECLARATION FOR TABLE CSS_RPT_PCSCA155              *             
      ******************************************************************        
       01  DCLCSS-RPT-PCSCA155.                                         
           10 5Z-CREATE-TS             PIC X(26).                       
           10 5Z-JOB-NAME              PIC X(8).                        
           10 5Z-ROW-ID                PIC S9(9) USAGE COMP.            
           10 5Z-COMPANY-NO            PIC X(2).                        
           10 5Z-OPTION-CD             PIC X(12).                       
           10 5Z-OFFER-CD              PIC X(12).                       
           10 5Z-CODE-ACCT-STAT        PIC X(01).                       
COB305     10 5Z-THERM-PRICE        PIC S9(05)V9(06) USAGE COMP-3 
COB305       VALUE 0.   
COB305     10 5Z-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           10 5Z-ANNV-MONTH            PIC X(06).                       
           10 5Z-TIER-ACCT-TYPE-CD     PIC X(01).                       
           10 5Z-RATE-TYPE-CD          PIC X(01).                       
           10 5Z-RATE-PLAN-NO          PIC X(03).                       
           10 5Z-OPTION-DESC.                                           
              49 5Z-OPTION-DESC-LEN    PIC S9(4) USAGE COMP.            
              49 5Z-OPTION-DESC-TEXT   PIC X(50).                       
COB305     10 5Z-CSC-AMT        PIC S9(3)V9(04) USAGE COMP-3 VALUE 0.    
           10 5Z-ACCT-TYPE-CD          PIC X.                           
COB305     10 5Z-THERM-PRICE-DSCNT        PIC S9(05)V9(06) USAGE COMP-3 
COB305       VALUE 0.   
COB305     10 5Z-NET-THERM-PRICE        PIC S9(05)V9(06) USAGE COMP-3 
COB305       VALUE 0.   
COB305     10 5Z-CSC-DSCNT        PIC S9(05)V9(06) USAGE COMP-3 VALUE 0.   
COB305     10 5Z-NET-CSC        PIC S9(05)V9(06) USAGE COMP-3 VALUE 0.   
           10 5Z-DURATION-NO           PIC S9(9) USAGE COMP.            
           10 5Z-AGL-SENIOR-ATTR       PIC X.                           
           10 5Z-LAST-UPDATE-TS        PIC X(26).                       
      ******************************************************************        
      * THE NUMBER OF COLUMNS DESCRIBED BY THIS DECLARATION IS 23      *        
      ******************************************************************        
      * CSS_RATE_CREATOR DCLGEN                                                 
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **BASE CURSOR TO EXTRACT THE OPTION CODES FOR THE SEB ACCOUNTS            
      **DF-STATUS-CD                                                            
      *    D = DROPPED                                                          
      *    R = RENEWED                                                          
PRDFIX*    O = OPEN FOR RENEWAL                                                 
P00211*    P = PENDING                                                          
      **FI-OPT-CALC-TYPE-CD                                                     
      *   FP = FIXED PRICE                                                      
      **DD-TIER-ACCT-TYPE-CD                                                    
      *    D = DEREGULATED RESIDENTIAL                                          
      *    A = ACN RESIDENTIAL                                                  
      *    S = SMALL COMMERCIAL                                                 
      *    B = BUSINESS OWNER RESIDENTIAL                                       
      **                                                                        
           EXEC SQL                                                     
              DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                  
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,DF.ACCOUNT_NO                                     
                     ,DF.OPTION_CD                                      
                     ,DF.STATUS_CD                                      
                     ,FI.OPT_DESC_INT                                   
                     ,DD.TIER_ACCT_TYPE_CD                              
                     ,HQ.DURATION_NO                                    
A04019               ,FI.RATE_PLAN_NO                                   
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                     ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                     ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
PRDFIX          WHERE AT.ACCOUNT_NO          = DF.ACCOUNT_NO            
P00211            AND DF.STATUS_EFF_REV_MTH  = :DF-STATUS-EFF-REV-MTH   
P00211            AND DF.STATUS_CD          IN ('D','R')                
                  AND DD.ACCOUNT_NO          = DF.ACCOUNT_NO            
                  AND DD.TIER_ACCT_TYPE_CD  IN ('D','A','S','B')        
                  AND DD.EFF_START_DT        =                          
                      (SELECT MAX(D1.EFF_START_DT)                      
                         FROM CSS_ACCT_MKT_TIER D1 WITH(READUNCOMMITTED)        
                        WHERE D1.ACCOUNT_NO  = DF.ACCOUNT_NO)           
                  AND FI.OPTION_CD           = DF.OPTION_CD             
                  AND FI.OPT_CALC_TYPE_CD    = 'FP'                     
P00473            AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()        
P00473            AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()        
P00473            AND FI.PROC_STATUS_CD      = 'AC'                     
                  AND HQ.OPTION_CD           = FI.OPTION_CD             
                  AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'            
P00141            AND HQ.ATTR_INCTV_STRT_DT <= CAST(DF.LAST_UPDATE_TS
            AS DATE)  
P00141            AND HQ.ATTR_INCTV_END_DT  >= CAST(DF.LAST_UPDATE_TS
            AS DATE)  
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
P00473            AND HQ.OPT_ATTR_VSTART_TS = (                         
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= CAST(DF.LAST_UPDATE_TS
            AS DATE)   
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= CAST(DF.LAST_UPDATE_TS
            AS DATE)   
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= CAST(DF.LAST_UPDATE_TS
            AS DATE)   
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= CAST(DF.LAST_UPDATE_TS
            AS DATE)   
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,DF.ACCOUNT_NO                                             
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*              ,DF.STATUS_CD                                              
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,HQ.DURATION_NO                                            
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CSS_ACCT_MKT_TIER DD                                      
MFA-TR*              ,CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE AT.ACCOUNT_NO          = DF.ACCOUNT_NO                    
MFA-TR*           AND DF.STATUS_EFF_REV_MTH  = :DF-STATUS-EFF-REV-MTH           
MFA-TR*           AND DF.STATUS_CD          IN ('D','R')                        
MFA-TR*           AND DD.ACCOUNT_NO          = DF.ACCOUNT_NO                    
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD  IN ('D','A','S','B')                
MFA-TR*           AND DD.EFF_START_DT        =                                  
MFA-TR*               (SELECT MAX(D1.EFF_START_DT)                              
MFA-TR*                  FROM CSS_ACCT_MKT_TIER D1                              
MFA-TR*                 WHERE D1.ACCOUNT_NO  = DF.ACCOUNT_NO)                   
MFA-TR*           AND FI.OPTION_CD           = DF.OPTION_CD                     
MFA-TR*           AND FI.OPT_CALC_TYPE_CD    = 'FP'                             
MFA-TR*           AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP                
MFA-TR*           AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP                
MFA-TR*           AND FI.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND HQ.OPTION_CD           = FI.OPTION_CD                     
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                    
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= DATE(DF.LAST_UPDATE_TS)          
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= DATE(DF.LAST_UPDATE_TS)          
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= DATE(DF.LAST_UPDATE_TS)           
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= DATE(DF.LAST_UPDATE_TS)           
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= DATE(DF.LAST_UPDATE_TS)           
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= DATE(DF.LAST_UPDATE_TS)           
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      **BASE CURSOR TO EXTRACT A CUSTOMER CHARGE                                
                                                                        
           EXEC SQL                                                     
              DECLARE CUSTCHG_CUR CURSOR           FOR                  
               SELECT J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL,             
                 J4.AMT_CUST_CHRG                                       
A04019           FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                
A04019          WHERE J4.CODE_UTIL_TYPE   = 'G'                         
A04019            AND J4.VERSION_NO_CNTRL =                             
A04019            (SELECT MAX(RT.VERSION_NO_CNTRL)                      
A04019               FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)             
A04019              WHERE RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO        
A04019                AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE      
A04019                AND RT.CODE_STATUS       = 'A'                    
A04019                AND RT.DISPLAY_START_TS <= 
           CIS.CURRENT$TIMESTAMP())     
                ORDER BY J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL           
                  FOR READ ONLY                                 
                                                            
A04019     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUSTCHG_CUR CURSOR           FOR                          
MFA-TR*        SELECT J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL,                     
MFA-TR*          J4.AMT_CUST_CHRG                                               
MFA-TR*          FROM CSS_RATE_VRSN_DEF J4                                      
MFA-TR*         WHERE J4.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND J4.VERSION_NO_CNTRL =                                     
MFA-TR*           (SELECT MAX(RT.VERSION_NO_CNTRL)                              
MFA-TR*              FROM CSS_RATE_CREATOR RT                                   
MFA-TR*             WHERE RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO                
MFA-TR*               AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE              
MFA-TR*               AND RT.CODE_STATUS       = 'A'                            
MFA-TR*               AND RT.DISPLAY_START_TS <= CURRENT TIMESTAMP)             
MFA-TR*         ORDER BY J4.RATE_PLAN_NO, J4.VERSION_NO_CNTRL                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            
      /                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
             UNTIL WS-END-ACCOUNT-CUR.                                  
           PERFORM 7020-CLOSE-ACCOUNT   THRU 7020-EXIT.                 
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-WORK-VARIABLES.                                
           MOVE ZEROS                  TO WS-CA156-RECS-WRITE.          
                                                                        
      ** SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES                        
           SET WS-NOT-END-ACCOUNT-CUR  TO TRUE.                         
                                                                        
      ** GETS THE REVENUE MONTH FROM JOB_PARM_TABLE                             
P00211     PERFORM 0250-GET-REVENUE-MONTH THRU 0250-EXIT.               
P00211     DISPLAY 'EFFECTIVE REV MNTH : ' WS-REVENUE-MNTH.             
P00211     MOVE WS-EFF-REV-MTH         TO DF-STATUS-EFF-REV-MTH         
      *                                                                         
      **DELETE OLD RECORDS FROM TBRPT155                                        
           MOVE 1 TO WS-SUB1                                            
           MOVE 9999 TO WS-SUB2.                                        
           PERFORM 7275-DELETE-RPT155      THRU 7275-EXIT.              
                                                                        
      ** OPEN THE BASE CURSOR                                                   
           PERFORM 7000-OPEN-ACCOUNT   THRU 7000-EXIT.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
P00211****************************************************************          
P00211**  0250-GET-REVENUE-MONTH                                    **          
P00211**      GETS THE REVENUE MONTH FOR PROCESSING                 **          
P00211****************************************************************          
P00211*                                                                         
P00211 0250-GET-REVENUE-MONTH.                                          
P00211*                                                                         
P00211     MOVE SPACES                 TO WS-SYSIPT.                    
P00211     MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
P00211     MOVE WS-DATE                TO WS-COMMAND.                   
P00211     MOVE ZEROS                  TO WS-SEQUENCE.                  
P00211     MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
P00211                                                                  
P00211     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P00211                                                                  
P00211     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P00211         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
P00211            OR  END-OF-SYSIPT.                                    
P00211                                                                  
P00211     EVALUATE TRUE                                                
P00211        WHEN END-OF-SYSIPT                                        
P00211           CONTINUE                                               
P00211        WHEN OTHER                                                
P00211           MOVE G6-PARM-DATA (15:06)                              
P00211                                 TO WS-REVENUE-MNTH               
P00211           MOVE WS-REVNUE-MTH-N  TO WS-EFF-REV-MTH                
P00211           DISPLAY '** PROGRAM OVERRIDE REVENUE MONTH USED **'    
P00211           PERFORM 7611-CLOSE    THRU 7611-EXIT                   
P00211           GO TO 0250-EXIT                                        
P00211     END-EVALUATE.                                                
P00211*                                                                         
P00211     MOVE SPACES                 TO WS-SYSIPT.                    
P00211     MOVE 'REPORTDATE'           TO WS-PROGRAM.                   
P00211     MOVE WS-DATE                TO WS-COMMAND.                   
P00211     MOVE ZEROS                  TO WS-SEQUENCE.                  
P00211     MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
P00211                                                                  
P00211     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P00211                                                                  
P00211     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P00211         UNTIL (REPORT-DATE AND INPUT-ACTIVE)                     
P00211            OR END-OF-SYSIPT.                                     
P00211                                                                  
P00211     EVALUATE TRUE                                                
P00211        WHEN END-OF-SYSIPT                                        
P00211           DISPLAY '**   PCSCB156 PROCESSING ERROR       **'      
P00211           DISPLAY '** REPORTDATE REVENUE MONTH NOT ACTIVE **'    
P00211           DISPLAY '**     PROCESSING TERMINATED         **'      
P00211           PERFORM 9900-ABEND    THRU  9900-EXIT                  
P00211        WHEN OTHER                                                
P00211           MOVE G6-PARM-DATA (13:06)                              
P00211                                 TO WS-REVENUE-MNTH               
P00211           MOVE WS-REVNUE-MTH-N  TO WS-EFF-REV-MTH                
P00211           PERFORM 7611-CLOSE    THRU 7611-EXIT                   
P00211     END-EVALUATE.                                                
P00211*                                                                         
P00211 0250-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      **      GETS THE ACCOUNT OPTION CODE DETAILS AND WRITE THEM   **          
      **      IN THE OUTPUT EXTRACT FILE                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-ACCOUNT.                                            
      *                                                                         
           SET DONT-SKIP-ACCOUNT           TO TRUE.                     
           PERFORM 7010-FETCH-ACCOUNT      THRU 7010-EXIT.              
                                                                        
           IF WS-NOT-END-ACCOUNT-CUR AND                                
      * CHECK FOR INTROVAR ACCOUNTS, NEED NOT REPORT THEM                       
      *                                                                         
              HQ-DURATION-NO > 1     AND                                
              DONT-SKIP-ACCOUNT                                         
              PERFORM 1200-POPULATE-DETAILS THRU 1200-EXIT              
              ADD 1 TO WS-COMMIT-CNT                                    
              IF WS-COMMIT-CNT > 999                                    
                 PERFORM 8100-COMMIT THRU 8100-EXIT                     
                 MOVE 1 TO WS-COMMIT-CNT                                
              END-IF                                                    
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1200-POPULATE-DETAILS                                     **          
      **      POPULATE THE CA156 FIELDS WITH THE VALUES RETREIVED   **          
      ****************************************************************          
      *                                                                         
       1200-POPULATE-DETAILS.                                           
      *                                                                         
           INITIALIZE E-FCA156-DATA-REC.                                
                                                                        
A04019     MOVE FI-RATE-PLAN-NO  TO J4-RATE-PLAN-NO.                    
A04019     PERFORM 7500-GET-NRML-CSC-AMT THRU 7500-EXIT                 
A04019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04019        MOVE J4-AMT-CUST-CHRG TO WS-CSC-AMT-DESC                  
A04019     END-IF                                                       
           MOVE DF-OPTION-CD         TO E-FCA156-OPTION-CODE.           
A04019     STRING FI-OPT-DESC-INT DELIMITED BY '   '                    
A04019            ' WITH '                                              
A04019            WS-CSC-AMT-DESC DELIMITED BY SIZE                     
A04019            WS-CSC-LIT-DESC DELIMITED BY SIZE                     
A04019     INTO E-FCA156-OPTION-DESC.                                   
           MOVE DF-STATUS-CD         TO E-FCA156-STATUS-CODE.           
           MOVE HQ-DURATION-NO       TO E-FCA156-DURATION-NO.           
           MOVE AT-CODE-ACCT-STAT    TO E-FCA156-ACCT-STAT.             
                                                                        
      * DD-TIER-ACCT-TYPE-CD                                                    
      *    D = DEREGULATED RESDENTIAL                                           
      *    A = ACN RESIDENTIAL                                                  
      *    S = SMALL COMMERCIAL                                                 
      *    B = BUSINESS OWNER - RESIDENTIAL                                     
           EVALUATE DD-TIER-ACCT-TYPE-CD                                
               WHEN 'D'                                                 
               WHEN 'A'                                                 
               WHEN 'B'                                                 
                  MOVE '1'            TO E-FCA156-SORT-GRP-CODE         
               WHEN 'S'                                                 
                  MOVE '2'            TO E-FCA156-SORT-GRP-CODE         
               WHEN OTHER                                               
                  SET SKIP-ACCOUNT    TO TRUE                           
           END-EVALUATE.                                                
                                                                        
           IF DONT-SKIP-ACCOUNT                                         
              PERFORM 8000-INSERT-FCA155-RECORD THRU 8000-EXIT          
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*** ALL SQL SELECTS, OPENS, FETCHES, AND CLOSES GO IN THE                
      **** 7000- RANGE OF PARAGRAPHS                                            
      *                                                                         
      ****************************************************************          
      **  7000-OPEN-ACCOUNT                                         **          
      **      OPEN THE MAIN CURSOR ACCOUNT_CUR                      **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-ACCOUNT.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCOUNT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '       7000-OPEN-ACCOUNT '                      
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO               
               DISPLAY ' OPTION CODE    = ' DF-OPTION-CD                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-ACCOUNT                                        **          
      **      FETCH THE ACCOUNTS FOR PROCESSING                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:DF-ACCOUNT-NO                                     
                    ,:DF-OPTION-CD                                      
                    ,:DF-STATUS-CD                                      
                    ,:FI-OPT-DESC-INT                                   
                    ,:DD-TIER-ACCT-TYPE-CD :WS-NULL-IND-01               
                    ,:HQ-DURATION-NO                                    
                    ,:FI-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-01 < 0                                     
                 SET SKIP-ACCOUNT         TO TRUE                       
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-ACCOUNT-CUR TO TRUE                         
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH ACCOUNT_CUR '                    
                 DISPLAY '       7010-FETCH-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-ACCOUNT                                        **          
      **      CLOSE THE MAIN CURSOR ACCOUNT_CUR                     **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '      CLOSE ACCOUNT_CUR '                        
              DISPLAY '      7020-CLOSE-ACCOUNT '                       
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7275-DELETE-RPT155.                                         **        
      ******************************************************************        
      *                                                                         
       7275-DELETE-RPT155.                                              
      *                                                                         
           EXEC SQL                                                     
              DELETE                                                    
                FROM CSS_RPT_PCSCA155                                   
               WHERE JOB_NAME    ='PCSCA156'                            
                 AND ROW_ID BETWEEN :WS-SUB1 AND :WS-SUB2               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 0 TO AT-ACCOUNT-NO                                   
              PERFORM 8100-COMMIT THRU 8100-EXIT                        
              ADD 9999 TO WS-SUB1                                       
              ADD 9999 TO WS-SUB2                                       
              GO TO 7275-DELETE-RPT155                                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              DISPLAY 'TABLE DELETION COMPLETE'                         
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCB156 **'      
              DISPLAY '** PARA 7275-DELETE-RPT155              **'      
              DISPLAY '** ERROR DURING SELECT OF TIMESTAMP     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '** PROCESSING TERMINATED                **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7500-GET-NRML-CSC-AMT.                                    **          
      **      GET THE NORMAL CSC AMOUNT FOR THE CUSTOMER            **          
      ****************************************************************          
      *                                                                         
       7500-GET-NRML-CSC-AMT.                                           
                                                                        
           IF WS-CSC-CNT = 0                                            
              PERFORM 7510-LOAD-CSC THRU 7510-EXIT                      
           END-IF.                                                      
      *                                                                         
           MOVE J4-RATE-PLAN-NO           TO WS1-CSC-RATE               
           SEARCH ALL WS-CSC-TBL                                        
              AT END                                                    
                 MOVE 100 TO WS-ACTIVE-RETURN-CODE                      
                 DISPLAY 'RATE VRSN NOT FOUND!!!'                       
                 DISPLAY 'RATE PLAN        : '  J4-RATE-PLAN-NO         
              WHEN WS-CSC-RATE-PLAN(CSC-IND) = WS1-CSC-RATE             
                 MOVE   0 TO WS-ACTIVE-RETURN-CODE                      
                 MOVE WS-AMT-CUST-CHRG (CSC-IND) TO J4-AMT-CUST-CHRG    
           END-SEARCH.                                                  
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7510-LOAD-CSC.                                            **          
      **    LOAD THE CSC TABLE                                                  
      ****************************************************************          
       7510-LOAD-CSC.                                                   
                                                                        
           PERFORM 7520-OPEN-CSC THRU 7520-EXIT.                        
                                                                        
           PERFORM 7530-FETCH-CSC THRU 7530-EXIT.                       
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
              IF WS-CSC-CNT > 9998                                      
                DISPLAY '*******************************************'   
                DISPLAY '       ABENDING PROGRAM '                      
                DISPLAY '       RATE TABLE OVERFLOW'                    
                DISPLAY '       7510-LOAD-RATEPLAN'                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND      THRU 9900-EXIT                  
              END-IF                                                    
              IF (WS-CSC-CNT = 0        OR                              
                (UT-RATE-PLAN-NO NOT = WS-CSC-RATE-PLAN(WS-CSC-CNT)))   
                ADD 1 TO WS-CSC-CNT                                     
                MOVE UT-RATE-PLAN-NO     TO WS-CSC-RATE-PLAN(WS-CSC-CNT)
                MOVE J4-VERSION-NO-CNTRL TO                             
                     WS-VERSION-NO-CNTRL(WS-CSC-CNT)                    
                MOVE J4-AMT-CUST-CHRG    TO                             
                     WS-AMT-CUST-CHRG(WS-CSC-CNT)                       
              END-IF                                                    
              PERFORM 7530-FETCH-CSC THRU 7530-EXIT                     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7540-CLOSE-CSC THRU 7540-EXIT.                       
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  7520-OPEN-CSC.                                            **          
      **    OPEN THE FACTOR ID TABLE                                            
      ****************************************************************          
       7520-OPEN-CSC.                                                   
                                                                        
           EXEC SQL                                                     
               OPEN CUSTCHG_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN CUSTCHG_CUR '                       
               DISPLAY '       7520-OPEN-CSC  '                         
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7530-FETCH-CSC.                                           **          
      **    FETCH THE FACTOR ID TABLE                                           
      ****************************************************************          
       7530-FETCH-CSC.                                                  
                                                                        
           EXEC SQL                                                     
               FETCH CUSTCHG_CUR                                        
                INTO :UT-RATE-PLAN-NO                                   
                    ,:J4-VERSION-NO-CNTRL                               
                    ,:J4-AMT-CUST-CHRG                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       FETCH CUSTCHG_CUR '                      
               DISPLAY '       7530-FETCH-CSC  '                        
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7540-CLOSE-CSC.                                           **          
      **    CLOSE THE FACTOR ID TABLE                                           
      ****************************************************************          
       7540-CLOSE-CSC.                                                  
                                                                        
           EXEC SQL                                                     
               CLOSE CUSTCHG_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CLOSE CUSTCHG_CUR '                      
               DISPLAY '       7540-CLOSE-CSC  '                        
               DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      **     8000-INSERT-FCA155-RECORD.                               **        
      ******************************************************************        
      *                                                                         
       8000-INSERT-FCA155-RECORD.                                       
      *                                                                         
           MOVE '8000'                      TO WS-ACTIVE-PARAGRAPH      
           INITIALIZE DCLCSS-RPT-PCSCA155.                              
                                                                        
           MOVE 'PCSCA156'                  TO 5Z-JOB-NAME              
           ADD 1                            TO WS-CA156-RECS-WRITE      
           MOVE  WS-CA156-RECS-WRITE        TO 5Z-ROW-ID                
           MOVE  '01'                       TO 5Z-COMPANY-NO            
           MOVE  E-FCA156-OPTION-CODE       TO 5Z-OPTION-CD             
           MOVE  AT-ACCOUNT-NO              TO 5Z-ACCOUNT-NO            
           MOVE  E-FCA156-ACCT-STAT         TO 5Z-CODE-ACCT-STAT        
           MOVE  E-FCA156-STATUS-CODE       TO 5Z-TIER-ACCT-TYPE-CD     
           MOVE  E-FCA156-SORT-GRP-CODE     TO 5Z-ACCT-TYPE-CD          
           PERFORM VARYING WS-SUB1 FROM 50 BY -1 UNTIL                  
             5Z-OPTION-DESC-LEN > 0                                     
             IF E-FCA156-OPTION-DESC(WS-SUB1:1) > ' '                   
               MOVE  WS-SUB1 TO 5Z-OPTION-DESC-LEN                      
             END-IF                                                     
           END-PERFORM                                                  
           MOVE  E-FCA156-OPTION-DESC       TO 5Z-OPTION-DESC-TEXT      
           MOVE  E-FCA156-DURATION-NO       TO 5Z-DURATION-NO.          
      *                                                                         
           EXEC SQL                                                     
           INSERT INTO CSS_RPT_PCSCA155                                 
                  ( CREATE_TS                                           
                   ,JOB_NAME                                            
                   ,ROW_ID                                              
                   ,COMPANY_NO                                          
                   ,OPTION_CD                                           
                   ,OFFER_CD                                            
                   ,CODE_ACCT_STAT                                      
                   ,THERM_PRICE                                         
                   ,ACCOUNT_NO                                          
                   ,ANNV_MONTH                                          
                   ,TIER_ACCT_TYPE_CD                                   
                   ,RATE_TYPE_CD                                        
                   ,RATE_PLAN_NO                                        
                   ,OPTION_DESC                                         
                   ,CSC_AMT                                             
                   ,ACCT_TYPE_CD                                        
                   ,THERM_PRICE_DSCNT                                   
                   ,NET_THERM_PRICE                                     
                   ,CSC_DSCNT                                           
                   ,NET_CSC                                             
                   ,DURATION_NO                                         
                   ,AGL_SENIOR_ATTR                                     
                   ,LAST_UPDATE_TS    )                                 
           VALUES (CIS.CURRENT$TIMESTAMP()                                    
                  ,:5Z-JOB-NAME                                         
                  ,:5Z-ROW-ID                                           
                  ,:5Z-COMPANY-NO                                       
                  ,:5Z-OPTION-CD                                        
                  ,:5Z-OFFER-CD                                         
                  ,:5Z-CODE-ACCT-STAT                                   
                  ,:5Z-THERM-PRICE                                      
                  ,:5Z-ACCOUNT-NO                                       
                  ,:5Z-ANNV-MONTH                                       
                  ,:5Z-TIER-ACCT-TYPE-CD                                
                  ,:5Z-RATE-TYPE-CD                                     
                  ,:5Z-RATE-PLAN-NO                                     
                  ,:5Z-OPTION-DESC                                      
                  ,:5Z-CSC-AMT                                          
                  ,:5Z-ACCT-TYPE-CD                                     
                  ,:5Z-THERM-PRICE-DSCNT                                
                  ,:5Z-NET-THERM-PRICE                                  
                  ,:5Z-CSC-DSCNT                                        
                  ,:5Z-NET-CSC                                          
                  ,:5Z-DURATION-NO                                      
                  ,:5Z-AGL-SENIOR-ATTR                                  
                  ,CIS.CURRENT$TIMESTAMP()    )                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_RPT_PCSCA155                                         
MFA-TR*           ( CREATE_TS                                                   
MFA-TR*            ,JOB_NAME                                                    
MFA-TR*            ,ROW_ID                                                      
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,OPTION_CD                                                   
MFA-TR*            ,OFFER_CD                                                    
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,THERM_PRICE                                                 
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,ANNV_MONTH                                                  
MFA-TR*            ,TIER_ACCT_TYPE_CD                                           
MFA-TR*            ,RATE_TYPE_CD                                                
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,OPTION_DESC                                                 
MFA-TR*            ,CSC_AMT                                                     
MFA-TR*            ,ACCT_TYPE_CD                                                
MFA-TR*            ,THERM_PRICE_DSCNT                                           
MFA-TR*            ,NET_THERM_PRICE                                             
MFA-TR*            ,CSC_DSCNT                                                   
MFA-TR*            ,NET_CSC                                                     
MFA-TR*            ,DURATION_NO                                                 
MFA-TR*            ,AGL_SENIOR_ATTR                                             
MFA-TR*            ,LAST_UPDATE_TS    )                                         
MFA-TR*    VALUES (CURRENT TIMESTAMP                                            
MFA-TR*           ,:5Z-JOB-NAME                                                 
MFA-TR*           ,:5Z-ROW-ID                                                   
MFA-TR*           ,:5Z-COMPANY-NO                                               
MFA-TR*           ,:5Z-OPTION-CD                                                
MFA-TR*           ,:5Z-OFFER-CD                                                 
MFA-TR*           ,:5Z-CODE-ACCT-STAT                                           
MFA-TR*           ,:5Z-THERM-PRICE                                              
MFA-TR*           ,:5Z-ACCOUNT-NO                                               
MFA-TR*           ,:5Z-ANNV-MONTH                                               
MFA-TR*           ,:5Z-TIER-ACCT-TYPE-CD                                        
MFA-TR*           ,:5Z-RATE-TYPE-CD                                             
MFA-TR*           ,:5Z-RATE-PLAN-NO                                             
MFA-TR*           ,:5Z-OPTION-DESC                                              
MFA-TR*           ,:5Z-CSC-AMT                                                  
MFA-TR*           ,:5Z-ACCT-TYPE-CD                                             
MFA-TR*           ,:5Z-THERM-PRICE-DSCNT                                        
MFA-TR*           ,:5Z-NET-THERM-PRICE                                          
MFA-TR*           ,:5Z-CSC-DSCNT                                                
MFA-TR*           ,:5Z-NET-CSC                                                  
MFA-TR*           ,:5Z-DURATION-NO                                              
MFA-TR*           ,:5Z-AGL-SENIOR-ATTR                                          
MFA-TR*           ,CURRENT TIMESTAMP    )                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCB156 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 8000       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      JOBNAME   = ' 5Z-JOB-NAME                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8100-COMMIT.                                                     
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF AT-ACCOUNT-NO > 0                                         
              DISPLAY 'COMMITTED UP TO ACCOUNT: ' AT-ACCOUNT-NO
           END-IF.        
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY '*******************************************'.       
           DISPLAY '           PCSCB156 ENDING '.                       
           DISPLAY '*******************************************'.       
           DISPLAY '           PROGRAM SUMMARY'.                        
           DISPLAY '*******************************************'.       
           DISPLAY ' ACCOUNTS EXTRACTED : '  WS-CA156-RECS-WRITE.       
           DISPLAY '*******************************************'.       
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM****************************         
