       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCABLD.                                         
       DATE-WRITTEN.  07/01/15.                                         
       DATE-COMPILED.                                                   
       AUTHOR.        DB41297                                           
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00070000
      **                                                             ** 00080000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00090000
      ********                   DB2                          ********* 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS       REASON                            ** 00150000
      **                                                             ** 00160000
      ** 07/07/15    DB41297        INITIAL BUILD.                   ** 00170000
      ***************************************************************** 00180000
      *                   PCSCABLD  NARRATIVE                         * 00190000
      *                                                               * 00200000
      ***************************************************************   00210000
      *  INSERT BUILDNO INTO CSS_CSR_VER_CNTRL USING DATE IN        *   00220000
      *     FILE CSR.PROD.REGRESS.VERSION.CONTROL                   *   00230000
      ***************************************************************   00240000
      ***************************************************************** 00250000
      *                                                                 00260000
      **          ----BASIC SEQUENCE STRUCTURE ----                  ** 00270000
      **                                                             ** 00280000
      **  0000         MODULE CONTROL                                ** 00290000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00300000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00310000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00320000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00330000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00340000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00350000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00360000
      **                                                             ** 00370000
      ***************************************************************** 00380000
      *                                                                 00390000
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00450000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00480000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************00510000
      * PCSCABLD - FD FOR VERSION CONTROL                              *00520000
      ******************************************************************00530000
      *                                                                 00540000
      *                                                                 00550000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCABLD'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCABLD STARTS HERE'.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-PCSCABLD-STATUS          PIC X(02).                   
               88  PCSCABLD-SUCCESSFUL                 VALUE '00'.      
               88  WS-START-INPUT-DATA                 VALUE 'X'.       
      *                                                                 00650000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)   VALUE 'PCSCABLD'.
      *                                                                 00680000
       01  WS-INPUT-RECORD.                                             
           05  WS-IN-REC               PIC 9(8).                        
           05  WS-IN-RECR REDEFINES WS-IN-REC.                          
               10  WS-IN-YYYY          PIC 9(4).                        
               10  WS-IN-MM            PIC 99.                          
               10  WS-IN-DD            PIC 99.                          
           05  WS-VERSION-NO           PIC X(14).                       
           05  WS-CIS-OR-MOD           PIC X(3).                        
      *                                                                 00770000
       01  WS-RELEASE-DT.                                               
           05  WS-DT-YYYY              PIC 9(4).                        
           05  WS-DT-DASH1             PIC X(1) VALUE '-'.              
           05  WS-DT-MM                PIC 9(2).                        
           05  WS-DT-DASH2             PIC X(1) VALUE '-'.              
           05  WS-DT-DD                PIC 9(2).                        
           05  WS-DT-TIME              PIC X(16) VALUE                  
               '-00.00.00.000000'.                                      
      *                                                                 00860000
       01  WS-VARIABLES.                                                
           05  WS-BUILD-NO                 PIC S9(4) COMP.              
      *                                                                 00890000
      ******* JOBS FILE/TABLE DEFINITIONS                               00900000
           COPY FIOCA00.                                                00910000
           COPY FIOJC01.                                                00920000
                                                                        
      ******* CWS00039 IS CA00 WORK DATA                                00940000
       COPY CWS00039.                                                   00950000
                                                                        
      ******* CWS00010 IS FOR ERROR HANDLING VARIABLES                  00970000
       COPY CWS00010.                                                   00980000
                                                                        
      ******* CWS09900 CONTAINS VARIABLES FOR ABEND                     01000000
       COPY CWS09900.                                                   01010000
                                                                        
      ******* CWS00038 IS JC01 WORK DATA                                01030000
       COPY CWS00038.                                                   01040000
                                                                        
      ******* CWS00114 CONTAINS VARIABLES FOR CPD00114                  01060000
       COPY CWS00114.                                                   01070000
                                                                        
      ******* CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                01090000
       COPY CWS00303.                                                   01100000
                                                                        
      ***************************************************************** 01120000
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          ** 01130000
      ***************************************************************** 01140000
      *                                                                 01150000
            EXEC SQL                                                    01160000
                 INCLUDE SQLCA                                          01170000
            END-EXEC.                                                   01180000
      *                                                                 01190000
      ******************************************************************01200000
      **  CSS_JOB_PARM                                                **01210000
      ******************************************************************01220000
      *                                                                 01230000
           EXEC SQL                                                     01240000
                INCLUDE TBJBPARM                                        01250000
           END-EXEC.                                                    01260000
      ******************************************************************01270000
      * COBOL DECLARATION FOR TABLE CSS_CSR_VER_CNTRL                 **01280000
      ******************************************************************01290000
      *                                                                 01300000
           EXEC SQL                                                     01310000
               INCLUDE TBVCNTRL                                         01320000
           END-EXEC.                                                    01330000
      *                                                                 01340000
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH               PIC S9(04) COMP.         
           03  WS-PARM-VAL                     PIC X(10).               
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ***************************************************************** 01420000
      *                                                              ** 01430000
      *    0000-MAINLINE                                             ** 01440000
      *                                                              ** 01450000
      ***************************************************************** 01460000
      *                                                                 01470000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS  THRU 1000-EXIT.               
                                                                        
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01560000
      ***************************************************************** 01570000
      *                                                               * 01580000
      * 1000-PROCESS-ACCOUNTS                                         * 01590000
      * THIS WILL CONTROL THE PROCESS OF GOING THROUGH THE QSAM FILES * 01600000
      * AND CHECKING TO SEE IF ANY COMPARE SHOULD BE DONE FOR AN      * 01610000
      * ACCOUNT.                                                      * 01620000
      *                                                               * 01630000
      ***************************************************************** 01640000
      *                                                                 01650000
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-SELECT-PCSCABLD-RECORD THRU 7000-EXIT.          
                                                                        
           PERFORM 1500-INSERT-BUILD-NO THRU 1500-EXIT.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01740000
      ******************************************************************01750000
      * THIS PARA WILL INSERT NEW BUILD NUMBER                          01760000
      ******************************************************************01770000
      *                                                                 01780000
        1500-INSERT-BUILD-NO.                                           
                                                                        
           MOVE G6-PARM-DATA(12:25) TO WS-INPUT-RECORD.                 
                                                                        
           COMPUTE WS-DT-YYYY      = WS-IN-YYYY.                        
           COMPUTE WS-DT-MM        = WS-IN-MM.                          
           COMPUTE WS-DT-DD        = WS-IN-DD.                          
                                                                        
           COMPUTE VO-BUILD-NO = WS-IN-REC.                             
           MOVE WS-RELEASE-DT TO VO-RELEASE-DT.                         
           MOVE 1 TO VO-VERSION-NO.                                     
           MOVE 'Y' TO VO-REQUIRED-FL.                                  
                                                                        
           DISPLAY 'WS-RELEASE-DT  : ' WS-RELEASE-DT                    
           DISPLAY 'WS-BUILD-NO  : ' WS-IN-RECR.                        
           DISPLAY 'WS-INPUT-RECORD: ' WS-INPUT-RECORD.                 
                                                                        
           IF G6-PARM-DATA(1:11) = 'VERSION-NO='                        
              PERFORM 2100-INSERT-RLSEDT THRU 2100-EXIT                 
           ELSE                                                         
              IF G6-PARM-DATA(1:11) = 'CISMOD-NO ='                     
                 MOVE WS-VERSION-NO TO VO-BUILD-COMMENTS-TEXT           
                 MOVE 14            TO VO-BUILD-COMMENTS-LEN            
                 PERFORM 2000-INSERT-CISMOD THRU 2000-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
        1500-EXIT.                                                      
            EXIT.                                                       
      *                                                                 02080000
      ******************************************************************02090000
      * THIS PARA WILL INSERT CISMOD RECORD                             02100000
      ******************************************************************02110000
      *                                                                 02120000
        2000-INSERT-CISMOD.                                             
                                                                        
           EXEC SQL INSERT INTO                                         
                    CSS_CSR_VER_CNTRL                                   
                    (BUILD_NO,                                          
                     APP_NAME,                                          
                     RELEASE_DT,                                        
                     VERSION_NO,                                        
                     BUILD_COMMENTS,                                    
                     REQUIRED_FL,                                       
                     LAST_UPDATE_TS,                                    
                     LAST_UPDATE_USERID)                                
               VALUES (:VO-BUILD-NO,                                    
                        'CISMOD',                                       
                        CIS.CHAR2TIMESTAMP(:VO-RELEASE-DT),                     
                        '1.0',                                          
                        :VO-BUILD-COMMENTS,                             
                        :VO-REQUIRED-FL,                                
                        CIS.CURRENT$TIMESTAMP(),                              
                        'CSGCODE')                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL INSERT INTO                                         02150000
MFA-TR*             CSS_CSR_VER_CNTRL                                   02160000
MFA-TR*             (BUILD_NO,                                          02170000
MFA-TR*              APP_NAME,                                          02180000
MFA-TR*              RELEASE_DT,                                        02190000
MFA-TR*              VERSION_NO,                                        02200000
MFA-TR*              BUILD_COMMENTS,                                    02210000
MFA-TR*              REQUIRED_FL,                                       02220000
MFA-TR*              LAST_UPDATE_TS,                                    02230000
MFA-TR*              LAST_UPDATE_USERID)                                02240000
MFA-TR*        VALUES (:VO-BUILD-NO,                                    02250000
MFA-TR*                 'CISMOD',                                       02260000
MFA-TR*                 :VO-RELEASE-DT,                                 02270000
MFA-TR*                 '1.0',                                          02280000
MFA-TR*                 :VO-BUILD-COMMENTS,                             02290000
MFA-TR*                 :VO-REQUIRED-FL,                                02300000
MFA-TR*                 CURRENT TIMESTAMP,                              02310000
MFA-TR*                 'CSGCODE')                                      02320000
MFA-TR*    END-EXEC.                                                    02330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************ABENDING******************'     
              DISPLAY '* 2000-INSERT-CISMOD                      *'     
              DISPLAY '* VO-BUILD-NO ' VO-BUILD-NO                      
              DISPLAY '* RC = '  WS-ACTIVE-RETURN-CODE                  
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCABLD******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
        2000-EXIT.                                                      
            EXIT.                                                       
      *                                                                 02490000
      ******************************************************************02500000
      * THIS PARA WILL INSERT NEW RELEASE DATE                          02510000
      ******************************************************************02520000
      *                                                                 02530000
        2100-INSERT-RLSEDT.                                             
                                                                        
           EXEC SQL                                                     
                   INSERT INTO                                          
                        CSS_CSR_VER_CNTRL                               
                        (BUILD_NO,                                      
                         APP_NAME,                                      
                         RELEASE_DT,                                    
                         VERSION_NO,                                    
                         BUILD_COMMENTS,                                
                         REQUIRED_FL,                                   
                         LAST_UPDATE_TS,                                
                         LAST_UPDATE_USERID)                            
                   VALUES (:VO-BUILD-NO,                                
                            'CSR',                                      
                            CIS.CHAR2TIMESTAMP(:VO-RELEASE-DT),                 
                            '1.0',                                      
                            'CSR',                                      
                            :VO-REQUIRED-FL,                            
                            CIS.CURRENT$TIMESTAMP(),                          
                            'CSGCODE')                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02560000
MFA-TR*            INSERT INTO                                          02570000
MFA-TR*                 CSS_CSR_VER_CNTRL                               02580000
MFA-TR*                 (BUILD_NO,                                      02590000
MFA-TR*                  APP_NAME,                                      02600000
MFA-TR*                  RELEASE_DT,                                    02610000
MFA-TR*                  VERSION_NO,                                    02620000
MFA-TR*                  BUILD_COMMENTS,                                02630000
MFA-TR*                  REQUIRED_FL,                                   02640000
MFA-TR*                  LAST_UPDATE_TS,                                02650000
MFA-TR*                  LAST_UPDATE_USERID)                            02660000
MFA-TR*            VALUES (:VO-BUILD-NO,                                02670000
MFA-TR*                     'CSR',                                      02680000
MFA-TR*                     :VO-RELEASE-DT,                             02690000
MFA-TR*                     '1.0',                                      02700000
MFA-TR*                     'CSR',                                      02710000
MFA-TR*                     :VO-REQUIRED-FL,                            02720000
MFA-TR*                     CURRENT TIMESTAMP,                          02730000
MFA-TR*                     'CSGCODE')                                  02740000
MFA-TR*    END-EXEC.                                                    02750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************ABENDING******************'     
              DISPLAY '* 2100-INSERT-RLSEDT                      *'     
              DISPLAY '* VO-BUILD-NO ' VO-BUILD-NO                      
              DISPLAY '* RC = '  WS-ACTIVE-RETURN-CODE                  
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCABLD******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
        2100-EXIT.                                                      
            EXIT.                                                       
      *                                                                 02910000
      ******************************************************************02920000
      * 7000-SELECT-PCSCABLD-RECORD                                    *02930000
      * READS THE INPUT  RECORD AND TESTS FOR SUCCESS OR FAILURE       *02940000
      ******************************************************************02950000
      *                                                                 02960000
       7000-SELECT-PCSCABLD-RECORD.                                     
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
             INTO  :G6-PARM-DATA                                        
             FROM CSS_JOB_PARM                                          
             WHERE PROGRAM_NAME = 'PCSCABLD'                            
             AND STATUS = 'A'                                           
             AND CIS.SUBSTR3(PARM_DATA,1,10) = :WS-PARM-VAL                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02990000
MFA-TR*      SELECT PARM_DATA                                           03000000
MFA-TR*      INTO  :G6-PARM-DATA                                        03010000
MFA-TR*      FROM CSS_JOB_PARM                                          03020000
MFA-TR*      WHERE PROGRAM_NAME = 'PCSCABLD'                            03030000
MFA-TR*      AND STATUS = 'A'                                           03040000
MFA-TR*      AND SUBSTR(PARM_DATA,1,10) = :WS-PARM-VAL                  03050002
MFA-TR*    END-EXEC.                                                    03060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************ABENDING******************'     
              DISPLAY '* 7000-SELECT-PCSCABLD-RECORD             *'     
              DISPLAY '* PROGRAM NAME PCSCABLD'                         
              DISPLAY '* RC = '  WS-ACTIVE-RETURN-CODE                  
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCABLD******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03220000
      ******************************************************************03230000
      *       THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *03240000
      ******************************************************************03250000
      *                                                                 03260000
           EXEC SQL                                                     03270000
               INCLUDE CPD09900                                         03280000
           END-EXEC.                                                    03290000
      *                                                                 03300000
      ******************************************************************03310000
      ******************************************************************03320001
      *     9000-TERMINATE                                             *03330001
      *     CLOSE FILES                                                *03340001
      ******************************************************************03350001
      *                                                                 03360001
       9000-TERMINATE.                                                  
                                                                        
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
