       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA968.                                      
COB303 DATE-WRITTEN.     JUL 14, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***       REGULATED PROVIDER 2015   SET DURATION REMAIN = 0    ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
      ***  08/04/2015    VK7L032     COBOL CONVERSION FOR THE EZTR   ***        
      ***                            PROGRAM SEB968.                 ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT80.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT80.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA968'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_REG_PROFILE                                          *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCT_RTPK_AGR                                        *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MNT_TRANS_HIST                                       *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MT_TRN_HST_DET                                       *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_FIXED_FCTR                                           *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CRM_OPT_ATTR_INCTV                                       *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BILL_WINDOW                                          *           
      ***************************************************************           
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * COPYBOOKS                                                   *           
      ***************************************************************           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSCA968'.     
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
                                                                        
       01 WS-RP968-HDR-REC-LN1.                                         
           05 HDR-DETAILS-LINE01        PIC X(12)                       
                                            VALUE 'SCANA ENERGY'.       
           05 FILLER                    PIC X(68) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-HDR-REC-LN2.                                         
           05 HDR-DETAILS-LINE02        PIC X(37)                       
                        VALUE  'ONE SHOT UPDATE TO EXPIRE FIXED RATE.'. 
           05 FILLER                    PIC X(43) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-HDR-REC-LN3.                                         
           05 HDR-DETAILS-LINE03        PIC X(28)                       
                        VALUE  'FIXED PRICE DURATION SET TO '.          
           05 HDR-DURATION-REMAINS      PIC X(02).                      
           05 FILLER                    PIC X(50) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-HDR-REC-LN4.                                         
           05 HDR-DETAILS-LINE04        PIC X(33)                       
                        VALUE  'REGULATED TRANSITION PROJECT 2015'.     
           05 FILLER                    PIC X(47) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-HDR-REC-LN5.                                         
           05 HDR-DETAILS-LINE05        PIC X(06)                       
                        VALUE  'DATE :'.                                
           05 HDR-SYSDATE               PIC X(10).                      
           05 FILLER                    PIC X(70) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-HDR-REC.                                             
           05 HDR-ACCOUNT-NO            PIC X(10) VALUE 'ACCOUNT NO'.   
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 HDR-DURATION-REMAINDER    PIC X(13)                       
                                            VALUE 'PREV DURATION'.      
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 HDR-REG-GROUP-CODE        PIC X(14)                       
                                            VALUE 'REG GROUP CODE'.     
           05 FILLER                    PIC X(41) VALUE SPACES.         
      *                                                                         
       01 WS-RP968-FTR-REC-LN1.                                         
           05 FTR-DETAILS-LINE01        PIC X(25)                       
                        VALUE  'TOTAL ACCOUNTS UPDATED: '.              
           05 FTR-RECORDS-UPDATED       PIC 9(09) VALUE ZEROS.          
           05 FILLER                    PIC X(46) VALUE SPACES.         
      *                                                                         
       01 WS-COMMENTS-TRANS.                                            
           05 WS-COMMENTS-TRANS-TXT     PIC X(115) VALUE SPACES.        
           05 WS-FCTR-ID-TRANS          PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(86) VALUE SPACES.         
                                                                        
       01 WS-UPDATE-DETAILS.                                            
           05 WS-FF-ACCOUNT-NO          PIC X(13) VALUE SPACES.         
           05 FILLER                    PIC X(02) VALUE ' |'.           
           05 WS-UTL-TYP                PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 WS-IC-NO                  PIC 9(06) VALUE ZEROS.          
           05 FILLER                    PIC X(02) VALUE ' |'.           
           05 WS-SEQ-NO                 PIC 9(04) VALUE ZEROS.          
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 WS-FCTR-CD                PIC X(09) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE '|'.            
                                                                        
       01 WS-OUTFILE.                                                   
           05 WS-ACCOUNT-NO             PIC X(13).                      
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 WS-DURATION-REMAIN        PIC X(04).                      
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 WS-REG-GROUP-CD           PIC X(03).                      
           05 FILLER                    PIC X(58) VALUE SPACES.         
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FPT80-STATUS          PIC X(02).                      
               88 FPT80-SUCCESSFUL                VALUE '00'.           
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-UPDT-COMMIT-CNT       PIC 9(09) VALUE ZEROS.          
           05  WS-UPDT-COMMITED         PIC 9(09) VALUE ZEROS.          
           05  WS-TOT-UPD-COUNT         PIC 9(09) VALUE ZEROS.          
           05  WS-RECORD-COUNT          PIC 9(09) VALUE ZEROS.          
           05  WS-RECORD-INSERT-HST     PIC 9(09) VALUE ZEROS.          
           05  WS-RECORD-INSERT-DTL     PIC 9(09) VALUE ZEROS.          
                                                                        
       01 WS-MISC.                                                      
           05  WS-TRAN-APPL-NUM         PIC 9(03) VALUE ZEROS.          
           05  WS-TRAN-APPL-NO          PIC S9(4) USAGE COMP.           
           05  WS-FIXED-PRICE-DUR       PIC 9(02).                      
           05  WS-COMMON-DATE           PIC X(10) VALUE SPACES.         
           05  WS-DURATION-REM          PIC S9(4) USAGE COMP.           
           05  WS-DURATION-REM-C        PIC X(04).                      
           05  WS-PARM-DUR-REM-JP-C     PIC X(02).                      
           05  WS-PARM-DUR-REM-JP          REDEFINES                    
               WS-PARM-DUR-REM-JP-C     PIC 9(02).                      
           05  WS-PARM-DUR-REM-JP-B     PIC S9(4) USAGE COMP.           
           05  WS-ALL-ROWS-PROCESD      PIC X(01) VALUE 'N'.            
           05  WS-TIMESTAMP.                                            
               10 WS-TIMESTAMP-10       PIC X(10).                      
               10 WS-TIMESTAMP-REST     PIC X(16).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-COMMENTS.                                             
               10 WS-TEXT-01            PIC X(60).                      
               10 WS-TEXT-02            PIC X(55).                      
               10 WS-TEXT-03            PIC X(10).                      
           05  WS-COMMENTS-TRAN         PIC X(210).                     
           05  WS-APPEND-COMMENT-LEN    PIC S9(4) VALUE 0 COMP.         
           05  WS-APPEND-COMMENT-LNV    PIC 9(09) VALUE 150.            
                                                                        
      ***************************************************************           
      * GET THE CURRENT OPTION CODE                                 *           
      ***************************************************************           
            EXEC SQL                                                    
               DECLARE GET_OPTION_CD CURSOR WITH HOLD FOR               
                  SELECT FF.ACCOUNT_NO                                  
                        ,FF.CODE_UTIL_TYPE                              
                        ,FF.IC_NO                                       
                        ,FF.FIXED_FCTR_SEQ_NO                           
                        ,FF.FACTOR_ID                                   
                        ,FF.DURATION_REMAIN_NO                          
                        ,LR.REG_GROUP_CD                                
                    FROM CSS_ACCOUNT         AT WITH(READUNCOMMITTED)           
                        ,CSS_REG_PROFILE     LR WITH(READUNCOMMITTED)           
                        ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)           
                        ,CSS_FIXED_FCTR      FF WITH(READUNCOMMITTED)           
                        ,CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)           
                        ,CSS_BILL_WINDOW     BN WITH(READUNCOMMITTED)           
                   WHERE AT.ACCOUNT_NO         = LR.ACCOUNT_NO          
                     AND AT.ACCOUNT_NO         = DF.ACCOUNT_NO          
                     AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO          
                     AND AT.BILL_CYCLE         = BN.BILL_CYCLE          
                     AND AT.REV_MTH_LST_NRML   = 201508                 
                     AND BN.REVENUE_MONTH      = 201508                 
                     AND BN.DATE_EXTRACT       = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )        
                     AND FF.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE      
                     AND FF.IC_NO              = DF.IC_NO               
                     AND FF.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO   
                     AND FF.DURATION_REMAIN_NO > :WS-PARM-DUR-REM-JP-B  
                     AND DF.STATUS_CD          = 'O'                    
                     AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                    
                     AND HQ.OPTION_CD          = DF.OPTION_CD           
                     AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'          
                     AND HQ.FACTOR_ID          = FF.FACTOR_ID           
                     AND HQ.DURATION_NO       <> FF.DURATION_REMAIN_NO  
                     AND HQ.ATTR_INCTV_STRT_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                     AND HQ.ATTR_INCTV_END_DT  >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                     AND HQ.OPT_ATTR_VSTART_TS <= 
           CIS.CURRENT$TIMESTAMP()     
                     AND HQ.OPT_ATTR_VEND_TS   >= 
           CIS.CURRENT$TIMESTAMP()     
                     AND HQ.PROC_STATUS_CD       = 'AC'                 
                     AND HQ.OPTION_CD IN ('RG307C02XXXX','RG301C02XXXX' 
                                         ,'RG305C21XXXX','RG305C02XXXX' 
                                         ,'RG308C20XXXX','RG309C02XXXX' 
                                         ,'RG201C02XXXX','RG207C02XXXX' 
                                         ,'RG209C02XXXX','RG208C20XXXX' 
                                         ,'RG205C20XXXX','RG205C21XXXX')
                   ORDER BY AT.ACCOUNT_NO DESC                          
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE GET_OPTION_CD CURSOR WITH HOLD FOR                       
MFA-TR*           SELECT FF.ACCOUNT_NO                                          
MFA-TR*                 ,FF.CODE_UTIL_TYPE                                      
MFA-TR*                 ,FF.IC_NO                                               
MFA-TR*                 ,FF.FIXED_FCTR_SEQ_NO                                   
MFA-TR*                 ,FF.FACTOR_ID                                           
MFA-TR*                 ,FF.DURATION_REMAIN_NO                                  
MFA-TR*                 ,LR.REG_GROUP_CD                                        
MFA-TR*             FROM CSS_ACCOUNT         AT                                 
MFA-TR*                 ,CSS_REG_PROFILE     LR                                 
MFA-TR*                 ,CSS_ACCT_RTPK_AGR   DF                                 
MFA-TR*                 ,CSS_FIXED_FCTR      FF                                 
MFA-TR*                 ,CRM_OPT_ATTR_INCTV  HQ                                 
MFA-TR*                 ,CSS_BILL_WINDOW     BN                                 
MFA-TR*            WHERE AT.ACCOUNT_NO         = LR.ACCOUNT_NO                  
MFA-TR*              AND AT.ACCOUNT_NO         = DF.ACCOUNT_NO                  
MFA-TR*              AND AT.ACCOUNT_NO         = FF.ACCOUNT_NO                  
MFA-TR*              AND AT.BILL_CYCLE         = BN.BILL_CYCLE                  
MFA-TR*              AND AT.REV_MTH_LST_NRML   = 201508                         
MFA-TR*              AND BN.REVENUE_MONTH      = 201508                         
MFA-TR*              AND BN.DATE_EXTRACT       = :WS-COMMON-DATE                
MFA-TR*              AND FF.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE              
MFA-TR*              AND FF.IC_NO              = DF.IC_NO                       
MFA-TR*              AND FF.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO           
MFA-TR*              AND FF.DURATION_REMAIN_NO > :WS-PARM-DUR-REM-JP-B          
MFA-TR*              AND DF.STATUS_CD          = 'O'                            
MFA-TR*              AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                            
MFA-TR*              AND HQ.OPTION_CD          = DF.OPTION_CD                   
MFA-TR*              AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                  
MFA-TR*              AND HQ.FACTOR_ID          = FF.FACTOR_ID                   
MFA-TR*              AND HQ.DURATION_NO       <> FF.DURATION_REMAIN_NO          
MFA-TR*              AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                  
MFA-TR*              AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                  
MFA-TR*              AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP             
MFA-TR*              AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP             
MFA-TR*              AND HQ.PROC_STATUS_CD       = 'AC'                         
MFA-TR*              AND HQ.OPTION_CD IN ('RG307C02XXXX','RG301C02XXXX'         
MFA-TR*                                  ,'RG305C21XXXX','RG305C02XXXX'         
MFA-TR*                                  ,'RG308C20XXXX','RG309C02XXXX'         
MFA-TR*                                  ,'RG201C02XXXX','RG207C02XXXX'         
MFA-TR*                                  ,'RG209C02XXXX','RG208C20XXXX'         
MFA-TR*                                  ,'RG205C20XXXX','RG205C21XXXX')        
MFA-TR*            ORDER BY AT.ACCOUNT_NO DESC                                  
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-OPTION              THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSPT80-FILE.                                    
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
               MOVE 12                    TO RETURN-CODE                
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT80-FILE     **'          
               DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
           INITIALIZE PRT80-RECORD.                                     
           PERFORM 7300-SELECT-TIMESTAMP            THRU  7300-EXIT.    
           PERFORM 1100-GET-PARM-DATA               THRU  1100-EXIT.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-GET-PARM-DATA.                                          **        
      ******************************************************************        
      *                                                                         
       1100-GET-PARM-DATA.                                              
      *                                                                         
           IF WS-CURRENT-DATE > '2015-09-03'                            
               MOVE 12                    TO RETURN-CODE                
               DISPLAY '*********** PCSCA968 ABORT ****************'    
               DISPLAY '*******************************************'    
               DISPLAY '**  SCHEDULING ERROR. CONTACT PROGRAMMING**'    
               DISPLAY '**  1100-GET-REMAIN-DURATION             **'    
               DISPLAY '**  SYS DATE:' WS-CURRENT-DATE                  
               DISPLAY '**********PROCESSING TERMINATED************'    
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-GET-REMAIN-DURATION         THRU 7100-EXIT.     
           PERFORM 7200-GET-COMMON-DATE             THRU 7200-EXIT.     
      *                                                                         
           MOVE WS-PARM-DUR-REM-JP-C      TO HDR-DURATION-REMAINS.      
           MOVE WS-CURRENT-DATE           TO HDR-SYSDATE.               
           MOVE WS-PARM-DUR-REM-JP-C      TO WS-PARM-DUR-REM-JP-B.      
      *                                                                         
           PERFORM 8100-WRITE-OUTFILE-HEADER        THRU  8100-EXIT.    
           DISPLAY '*JOB PARM DATA  = DURATION REMAINING NO='                   
      -         WS-PARM-DUR-REM-JP-C.                                           
           DISPLAY 'RUNNING FOR COMMON DATE:' WS-COMMON-DATE.           
           DISPLAY 'CSS_FIXED_FCTR'                                     
           DISPLAY 'FF-ACCOUNT-NO |UTL-TYP|IC-NO|SEQ-#|FCTR-CD|'.       
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-OPTION.                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OPTION.                                             
      *                                                                         
           PERFORM 7400-OPEN-GET-OPTION-CD          THRU  7400-EXIT.    
           PERFORM 7500-FETCH-GET-OPTION-CD         THRU  7500-EXIT.    
           PERFORM 2100-DURATION-REMAINDER-CALC     THRU  2100-EXIT     
             UNTIL WS-ALL-ROWS-PROCESD = WS-YES.                        
           PERFORM 7600-CLOSE-GET-OPTION-CD         THRU  7600-EXIT.    
           PERFORM 8200-WRITE-OUTFILE-FOOTER        THRU  8200-EXIT.    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-DURATION-REMAINDER-CALULATION                              *        
      ******************************************************************        
      *                                                                         
       2100-DURATION-REMAINDER-CALC.                                    
      *                                                                         
           PERFORM 8400-UPDATE-DURATION-REMAINDER THRU 8400-EXIT.       
           PERFORM 7300-SELECT-TIMESTAMP          THRU 7300-EXIT.       
           PERFORM 2600-FORMAT-TRANS-DTL          THRU 2600-EXIT.       
           PERFORM 8500-INSERT-TRANS-HIST-CUST    THRU 8500-EXIT.       
           PERFORM 8600-INSERT-TRANS-HIST-DETL    THRU 8600-EXIT.       
           PERFORM 8800-WRITE-OUTFILE             THRU 8800-EXIT.       
           PERFORM 7500-FETCH-GET-OPTION-CD       THRU 7500-EXIT.       
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2600-FORMAT-TRANS-DTL.                                      **        
      ** FORMAT TRANSACTION DETAIL ROWS                               **        
      ******************************************************************        
      *                                                                         
       2600-FORMAT-TRANS-DTL.                                           
                                                                        
            MOVE WS-DURATION-REM        TO WS-DURATION-REM-C            
            MOVE WS-DURATION-REM-C      TO WS-DURATION-REMAIN           
            MOVE FF-ACCOUNT-NO          TO WS-ACCOUNT-NO                
            MOVE WS-CURRENT-TIMESTAMP   TO MH-TRANS-HIST-SEQ-NO         
            MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                
            MOVE 'F'                    TO MH-CODE-TRAN-TYPE            
            MOVE '   '                  TO MH-RESP-AREA-ID              
            MOVE FF-ACCOUNT-NO          TO MH-ACCOUNT-NO                
            MOVE 0                      TO MH-CUSTOMER-NO               
            MOVE WS-PROGRAM-NAME        TO MH-APPL-PROGRAM-ID           
            MOVE 0                      TO MH-PREMISE-NO                
            MOVE 'SYSTEM '              TO MH-USER-ID                   
            MOVE FF-FACTOR-ID           TO WS-TEXT-02                   
            MOVE FF-FACTOR-ID           TO WS-FCTR-ID-TRANS             
            MOVE SPACES                 TO MH-ENTITY-KEY-DESC           
            MOVE 1                      TO WS-TRAN-APPL-NUM             
            MOVE WS-TRAN-APPL-NUM       TO WS-TRAN-APPL-NO              
            MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO         
            MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO              
            MOVE 'DURATION REM'         TO MI-COLUMN-DESC               
            MOVE WS-DURATION-REM-C      TO MI-PRV-COLUMN-VALUE-TEXT     
            MOVE WS-PARM-DUR-REM-JP     TO MI-CHG-COLUMN-VALUE-TEXT     
            MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                     
                                        TO MI-PRV-COLUMN-VALUE-LEN      
            MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                     
                                        TO MI-CHG-COLUMN-VALUE-LEN      
            MOVE 'Updated duration remaining to  '                      
                                        TO WS-COMMENTS-TRANS-TXT(01:30) 
            MOVE 'expire fixed rate contract in  '                      
                                        TO WS-COMMENTS-TRANS-TXT(31:30) 
            MOVE 'August. Regulated provider  '                         
                                        TO WS-COMMENTS-TRANS-TXT(61:27) 
            MOVE 'transition 2015. Factor id:   '                       
                                        TO WS-COMMENTS-TRANS-TXT(88:28) 
            MOVE WS-COMMENTS-TRANS      TO MH-TRAN-COMMENT-TEXT         
            MOVE WS-APPEND-COMMENT-LNV  TO WS-APPEND-COMMENT-LEN        
            MOVE WS-APPEND-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN          
                                                                        
            COMPUTE WS-RECORD-COUNT      = WS-RECORD-COUNT  + 1         
            COMPUTE WS-TOT-UPD-COUNT     = WS-TOT-UPD-COUNT + 1         
            COMPUTE WS-UPDT-COMMIT-CNT   = WS-UPDT-COMMIT-CNT + 1       
                                                                        
            MOVE WS-TOT-UPD-COUNT       TO FTR-RECORDS-UPDATED          
            MOVE WS-OUTFILE             TO PRT80-RECORD                 
                                                                        
            MOVE FF-ACCOUNT-NO          TO WS-FF-ACCOUNT-NO             
            MOVE FF-CODE-UTIL-TYPE      TO WS-UTL-TYP                   
            MOVE FF-IC-NO               TO WS-IC-NO                     
            MOVE FF-FIXED-FCTR-SEQ-NO   TO WS-SEQ-NO                    
            MOVE FF-FACTOR-ID           TO WS-FCTR-CD                   
            DISPLAY WS-UPDATE-DETAILS                                   
                                                                        
            IF WS-UPDT-COMMIT-CNT = 50                                  
               COMPUTE WS-UPDT-COMMITED   = WS-UPDT-COMMITED   + 1      
               PERFORM 8999-ISSUE-COMMIT           THRU 8999-EXIT       
               DISPLAY 'COMMIT POINT # ' WS-UPDT-COMMITED               
               DISPLAY 'LAST COMMITED ACCOUNT-NO: ' WS-FF-ACCOUNT-NO    
               MOVE 0                   TO WS-UPDT-COMMIT-CNT           
            END-IF.                                                     
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33591000
      ******************************************************************        
      **  7100-GET-REMAIN-DURATION.                                   **        
      ** GET RUN DATE FROM JOB_PARM TABLE                             **        
      ******************************************************************        
      *                                                                         
       7100-GET-REMAIN-DURATION.                                        
      *                                                                         
           MOVE WS-PROGRAM-NAME           TO G6-PROGRAM-NAME.           
                                                                        
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,23,2)                             
                INTO :WS-PARM-DUR-REM-JP-C                              
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND STATUS       = 'A'                                 
                 AND SEQ_NO       = 10                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,23,2)                                     
MFA-TR*         INTO :WS-PARM-DUR-REM-JP-C                                      
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 IF WS-PARM-DUR-REM-JP  < 0                             
                    DISPLAY 'DURATION FROM JOB PARM NOT NUMERIC'        
                 END-IF                                                 
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**PARM-DATA FETCH FAILED   **'             
                    DISPLAY '**7100-GET-REMAIN-DURATION **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-GET-COMMON-DATE.                                       **        
      ** GET COMMON DATE FROM JOB_PARM TABLE                          **        
      ******************************************************************        
      *                                                                         
       7200-GET-COMMON-DATE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,10,10)                            
                INTO :WS-COMMON-DATE                                    
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'COMMON'                            
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,10,10)                                    
MFA-TR*         INTO :WS-COMMON-DATE                                            
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'COMMON'                                    
MFA-TR*          AND CMND_CODE    = 'DATE'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**COMMON DATE FETCH FAILED **'             
                    DISPLAY '**7200-GET-COMMON-DATE     **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************33600000
      * 7300-SELECT-TIMESTAMP                                          *33601000
      * SELECT CURRENT TIMESTAMP                                       *33610000
      ******************************************************************33620000
       7300-SELECT-TIMESTAMP.                                           
      *                                                                 33640000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     33650000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             33660000
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                  33670000
MFA-TR*    END-EXEC.                                                    33680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY 'CURRENT TIMESTAMP FECTH FAILED'                  
              DISPLAY '******** PCSCA968 ABORT *****'                   
              DISPLAY '**CURRENT TIMESTAMP FAILED **'                   
              DISPLAY '**7300-SELECT-TIMESTAMP    **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 7400-OPEN-GET-OPTION-CD.                                     **        
      ******************************************************************        
      *                                                                         
       7400-OPEN-GET-OPTION-CD.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_OPTION_CD                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**OPEN OPTION CURSOR ERROR **'             
                    DISPLAY '**7400-OPEN-GET-OPTION-CD  **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-FETCH-GET-OPTION-CD.                                    **        
      ******************************************************************        
      *                                                                         
       7500-FETCH-GET-OPTION-CD.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_OPTION_CD                                       
               INTO :FF-ACCOUNT-NO                                      
                   ,:FF-CODE-UTIL-TYPE                                  
                   ,:FF-IC-NO                                           
                   ,:FF-FIXED-FCTR-SEQ-NO                               
                   ,:FF-FACTOR-ID                                       
                   ,:WS-DURATION-REM                                    
                   ,:WS-REG-GROUP-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES           TO WS-ALL-ROWS-PROCESD        
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**OPTION CURSOR FETCH ERROR**'             
                    DISPLAY '**7500-FETCH-OPTION-CODE   **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7600-CLOSE-GET-OPTION-CD.                                    **        
      ******************************************************************        
      *                                                                         
       7600-CLOSE-GET-OPTION-CD.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_OPTION_CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**CLOSE OPTION CURSOR ERROR**'             
                    DISPLAY '**7600-CLOSE-GET-OPTION-CD **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **   8100-WRITE-OUTFILE-HEADER                                **  08170000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE-HEADER.                                       
      *                                                                 08230000
      *WRITE THE HEADER RECORD                                                  
      *                                                                         
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC-LN1.    
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC-LN2.    
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC-LN3.    
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC-LN4.    
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC-LN5.    
           WRITE PRT80-RECORD             FROM WS-RP968-HDR-REC.        
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8200-WRITE-OUTFILE-FOOTER                                **  08170000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE-FOOTER.                                       
      *                                                                 08230000
      *WRITE THE HEADER RECORD                                                  
      *                                                                         
           WRITE PRT80-RECORD             FROM WS-RP968-FTR-REC-LN1.    
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ******************************************************************        
      ** 8400-UPDATE-DURATION-REMAINDER.                                        
      ******************************************************************        
      *                                                                         
       8400-UPDATE-DURATION-REMAINDER.                                  
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCTR                                     
              SET DURATION_REMAIN_NO  = :WS-PARM-DUR-REM-JP-B           
                 ,EFF_DATE_TO         = IIF(TRY_CONVERT(DATE, 
              '2015-08-28') IS NULL OR (PATINDEX('%.%', '2015-08-28'
              ) <> 0) OR (LEN('2015-08-28') <> 10), CIS.CHAR2DATE(
              '2015-08-28'), CONVERT(DATE, '2015-08-28') )                    
              WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                  
              AND CODE_UTIL_TYPE      = :FF-CODE-UTIL-TYPE              
              AND IC_NO               = :FF-IC-NO                       
              AND FIXED_FCTR_SEQ_NO   = :FF-FIXED-FCTR-SEQ-NO           
              AND FACTOR_ID           = :FF-FACTOR-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     55367300
MFA-TR*       UPDATE CSS_FIXED_FCTR                                             
MFA-TR*       SET DURATION_REMAIN_NO  = :WS-PARM-DUR-REM-JP-B                   
MFA-TR*          ,EFF_DATE_TO         = '2015-08-28'                            
MFA-TR*       WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                          
MFA-TR*       AND CODE_UTIL_TYPE      = :FF-CODE-UTIL-TYPE                      
MFA-TR*       AND IC_NO               = :FF-IC-NO                               
MFA-TR*       AND FIXED_FCTR_SEQ_NO   = :FF-FIXED-FCTR-SEQ-NO                   
MFA-TR*       AND FACTOR_ID           = :FF-FACTOR-ID                           
MFA-TR*    END-EXEC.                                                    55368100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**FIXED FCTR UPDATE FAILED **'             
                    DISPLAY '**8400-UPDATE-DURATION-REM **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8500-INSERT-TRANS-HIST-CUST.                                **        
      ** INSERTING INTO CSS_MNT_TRANS_HIST                            **        
      ******************************************************************        
      *                                                                         
        8500-INSERT-TRANS-HIST-CUST.                                    
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                     (                                                  
                      TRANS_HIST_SEQ_NO                                 
                     ,DATE_TRANS                                        
                     ,CODE_TRAN_TYPE                                    
                     ,RESP_AREA_ID                                      
                     ,ACCOUNT_NO                                        
                     ,CUSTOMER_NO                                       
                     ,PREMISE_NO                                        
                     ,USER_ID                                           
                     ,APPL_PROGRAM_ID                                   
                     ,TRAN_COMMENT                                      
                     )                                                  
              VALUES                                                    
                     (                                                  
                      CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                 
                     ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                     ,:MH-CODE-TRAN-TYPE                                
                     ,:MH-RESP-AREA-ID                                  
                     ,:MH-ACCOUNT-NO                                    
                     ,:MH-CUSTOMER-NO                                   
                     ,:MH-PREMISE-NO                                    
                     ,:MH-USER-ID                                       
                     ,:MH-APPL-PROGRAM-ID                               
                     ,:MH-TRAN-COMMENT                                  
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     49150000
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                            49160000
MFA-TR*              (                                                  49161000
MFA-TR*               TRANS_HIST_SEQ_NO                                 49170000
MFA-TR*              ,DATE_TRANS                                        49180000
MFA-TR*              ,CODE_TRAN_TYPE                                    49190000
MFA-TR*              ,RESP_AREA_ID                                      49200000
MFA-TR*              ,ACCOUNT_NO                                        49210000
MFA-TR*              ,CUSTOMER_NO                                       49210000
MFA-TR*              ,PREMISE_NO                                        49210000
MFA-TR*              ,USER_ID                                           49210000
MFA-TR*              ,APPL_PROGRAM_ID                                   49210000
MFA-TR*              ,TRAN_COMMENT                                      49210000
MFA-TR*              )                                                  49211000
MFA-TR*       VALUES                                                    49220000
MFA-TR*              (                                                  49221000
MFA-TR*               :MH-TRANS-HIST-SEQ-NO                             49230000
MFA-TR*              ,:MH-DATE-TRANS                                    49240000
MFA-TR*              ,:MH-CODE-TRAN-TYPE                                49250000
MFA-TR*              ,:MH-RESP-AREA-ID                                  49260000
MFA-TR*              ,:MH-ACCOUNT-NO                                    49270000
MFA-TR*              ,:MH-CUSTOMER-NO                                   49270000
MFA-TR*              ,:MH-PREMISE-NO                                    49270000
MFA-TR*              ,:MH-USER-ID                                       49270000
MFA-TR*              ,:MH-APPL-PROGRAM-ID                               49270000
MFA-TR*              ,:MH-TRAN-COMMENT                                  49270000
MFA-TR*              )                                                  49271000
MFA-TR*    END-EXEC.                                                    49280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    COMPUTE WS-RECORD-INSERT-HST =                      
                            WS-RECORD-INSERT-HST + 1                    
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**TRANS HIST INSERT FAILED **'             
                    DISPLAY '**8500-INSERT-TRANS-HIST   **'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
        8500-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  8600-INSERT-MNT-DET.                                        **        
      ** INSERTING INTO CSS_MT_TRN_HST_DET                            **        
      ******************************************************************        
      *                                                                         
        8600-INSERT-TRANS-HIST-DETL.                                    
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MT_TRN_HST_DET                            
                     (                                                  
                      TRANS_HIST_SEQ_NO                                 
                     ,TRAN_APPL_NO                                      
                     ,COLUMN_DESC                                       
                     ,PRV_COLUMN_VALUE                                  
                     ,CHG_COLUMN_VALUE                                  
                     ,TABLE_ID                                          
                     )                                                  
              VALUES                                                    
                     (                                                  
                      CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                 
                     ,:MI-TRAN-APPL-NO                                  
                     ,:MI-COLUMN-DESC                                   
                     ,:MI-PRV-COLUMN-VALUE                              
                     ,:MI-CHG-COLUMN-VALUE                              
                     ,:MI-TABLE-ID                                      
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     49150000
MFA-TR*       INSERT INTO CSS_MT_TRN_HST_DET                            49160000
MFA-TR*              (                                                  49161000
MFA-TR*               TRANS_HIST_SEQ_NO                                 49170000
MFA-TR*              ,TRAN_APPL_NO                                      49180000
MFA-TR*              ,COLUMN_DESC                                       49190000
MFA-TR*              ,PRV_COLUMN_VALUE                                  49200000
MFA-TR*              ,CHG_COLUMN_VALUE                                  49210000
MFA-TR*              ,TABLE_ID                                          49210000
MFA-TR*              )                                                  49211000
MFA-TR*       VALUES                                                    49220000
MFA-TR*              (                                                  49221000
MFA-TR*               :MI-TRANS-HIST-SEQ-NO                             49230000
MFA-TR*              ,:MI-TRAN-APPL-NO                                  49240000
MFA-TR*              ,:MI-COLUMN-DESC                                   49250000
MFA-TR*              ,:MI-PRV-COLUMN-VALUE                              49260000
MFA-TR*              ,:MI-CHG-COLUMN-VALUE                              49270000
MFA-TR*              ,:MI-TABLE-ID                                      49270000
MFA-TR*              )                                                  49271000
MFA-TR*    END-EXEC.                                                    49280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    COMPUTE WS-RECORD-INSERT-DTL =                      
                            WS-RECORD-INSERT-DTL + 1                    
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**TRANS DET HIST INSERT XX **'             
                    DISPLAY '**8600-INSERT-TRANS-HIST-DT**'             
                    DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
        8600-EXIT.                                                      
            EXIT.                                                       
      *                                                                 08060000
      ****************************************************************  08150000
      **   8800-WRITE-OUTFILE                                       **  08170000
      ****************************************************************  08200000
      *                                                                 08210000
       8800-WRITE-OUTFILE.                                              
      *                                                                 08230000
           WRITE PRT80-RECORD.                                          
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
              MOVE 12                     TO RETURN-CODE                
              DISPLAY '**************************************'          
              DISPLAY '**  FILE WRITE UNSUCCESSFUL         **'          
              DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS              
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 08335000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT80-FILE.                                          
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
              MOVE 12                     TO RETURN-CODE                
              DISPLAY '**************************************'          
              DISPLAY '**  ERROR CLOSING FCSPT80-FILE     **'           
              DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS              
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      *****************************************************************         
      * COMMIT DB2                                                    *         
      *****************************************************************         
      *                                                                         
       8999-ISSUE-COMMIT.                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    COMPUTE WS-RECORD-INSERT-DTL =                      
                            WS-RECORD-INSERT-DTL + 1                    
               WHEN NOT-FOUND                                           
                    DISPLAY 'SQL CODE ' WS-ACTIVE-RETURN-CODE           
               WHEN OTHER                                               
                    DISPLAY '******** PCSCA968 ABORT *****'             
                    DISPLAY '**COMMIT FAILED            **'             
                    DISPLAY '**8999-ISSUE-COMMIT       T**'             
                    DISPLAY '**LAST UPDATED ACCNT:' WS-ACCOUNT-NO       
                    DISPLAY '**COMMIT POINT#     :' WS-UPDT-COMMITED    
                   DISPLAY '**RETURN CODE       :' WS-ACTIVE-RETURN-CODE
                    DISPLAY '**PROCESSING TERMINATED    **'             
                    PERFORM 9900-ABEND              THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       8999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08384100
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           DISPLAY '* TOTAL ACCOUNTS UPDATED: ' WS-TOT-UPD-COUNT        
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
