       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA935.                                        
       DATE-WRITTEN.   02 FEB 2015.                                     
       DATE-COMPILED.                                                   
      ****************************************************************  00050000
      **               SOUTH CAROLINA ELECTRIC & GAS                **  00060000
      **              COMPLETE BUSINESS SOLUTIONS INC.              **  00070000
      **                                                            **  00080000
      ********            CUSTOMER SERVICE SYSTEM             ********  00090000
      ********                      DB2                       ********  00100000
      ****************************************************************  00110000
      **                                                            **  00120000
      **              PROGRAM  MODIFICATION  LOG                    **  00130000
      **                                                            **  00140000
      **    DATE    INITIALS     REASON                             **  00150000
      **  --------  --------     ---------------------------------- **  00160000
      **  02/02/15    ESM        NEW PROGRAM TO RETRIEVE ACCOUNTS   **  00170000
      **                         FROM CSS_BILL_SAMPLE TO GO THROUGH **  00180000
      **                         SAMPLE BILLING.                    **  00190000
ACT224**  11/11/15    BD09555    ADDITIONAL CHANGES TO MAKE OUTPUT  **  00170000
ACT224**                         FILE RESEMBLE EXISTING INPUT FOR   **  00180000
ACT224**A05136-ACT224            PCSCA119                           **  00190000
A05462**   10/16    DB41297   MAKE PROGRAM MICROFOCUS COMPLIANT      ** 00016220
      ****************************************************************  00200000
      **                     PCSCA935 NARRATIVE                     **  00210000
      **  PCSCA935 RETRIEVES ACCOUNTS THE WERE SELECTED BY PCSRP441 **  00220000
      **  TO GO THROUGH SAMPLE BILLING.                             **  00230000
      ****************************************************************  00240000
      *                                                                 00250000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00310000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCRES935-FILE                                         
               ASSIGN TO UT-S-FCRES935                                  
               FILE STATUS IS WS-FCARES935-STATUS.                      
      *                                                                 00324100
           SELECT FCIND935-FILE                                         
               ASSIGN TO UT-S-FCIND935                                  
               FILE STATUS IS WS-FCAIND935-STATUS.                      
      *                                                                 00327100
           SELECT FCDEL935-FILE                                         
               ASSIGN TO UT-S-FCDEL935                                  
               FILE STATUS IS WS-FCADEL935-STATUS.                      
      *                                                                 00330000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCRES935-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
ACT224 01  FCRES935-DATA-REC                        PIC X(80).          
                                                                        
       FD  FCIND935-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
ACT224 01  FCIND935-DATA-REC                        PIC X(80).          
                                                                        
       FD  FCDEL935-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
ACT224 01  FCDEL935-DATA-REC                        PIC X(80).          
                                                                        
      *                                                                 00470000
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-ACCOUNT-TAB  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-SAMPLE-ACCT  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA935'.
MSQ017     COPY MFASQLM.
      *                                                                 00490000
       COPY FIOCA00.                                                    00491000
       COPY FIOJC01.                                                    00500000
       COPY CWS09900.                                                   00510000
       COPY CWS00004.                                                   00520000
       COPY CWS00010.                                                   00530000
       COPY CWS00038.                                                   00540000
       COPY CWS00039.                                                   00550000
       COPY CWS00303.                                                   00560000
ACT224 COPY FCSSF95.                                                            
      *                                                                 00570000
       01  WS-MISC.                                                     
           05  WS-PROGRAM-DATE         PIC X(10).                       
           05  WS-FCARES935-STATUS     PIC X(02).                       
               88 FCARES935-SUCCESSFUL VALUE '00'.                      
           05  WS-FCAIND935-STATUS     PIC X(02).                       
               88 FCAIND935-SUCCESSFUL VALUE '00'.                      
           05  WS-FCADEL935-STATUS     PIC X(02).                       
               88 FCADEL935-SUCCESSFUL VALUE '00'.                      
           05  WS-DISPLAY-SQLCODE      PIC -ZZZZZZZZ9.                  
           05  RS-RETURN-CODE          PIC S9(04) COMP.                 
           05  WS-DISPLAY-RC           PIC ---9.                        
           05  RS-RETURN-CODE-DISP     PIC S9(04).                      
           05  WS-COMMON-DATE          PIC X(10)    VALUE SPACES.       
           05  WS-DELIMITER            PIC X(01)    VALUE ';'.          
           05  WS-ACCOUNT              PIC X(13)    VALUE SPACES.       
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT                       
                                       PIC 9(13).                       
           05  WS-SAMP-ROW-COUNT       PIC S9(7)  COMP-3 VALUE +0.      
           05  WS-INDEX                PIC S9(04) COMP-3 VALUE +0.      
           05  WS-NUM-COND             PIC S9(7)  COMP-3 VALUE +0.      
      *                                                                 00670000
       01  WS-MISC-HOST-VARIABLES.                                      
           05  WS-SAMP-ACCOUNT-NO      PIC S9(13)V  USAGE COMP-3        
                                         OCCURS 150 TIMES VALUE ZEROS.  
ACT224     05  WS-SAMP-BILL-AMT        PIC S9(9)V99 USAGE COMP-3        
ACT224                                   OCCURS 150 TIMES VALUE ZEROS.  
      *                                                                 00671000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA935'.   
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA935'.   
           05  WS-COMMON               PIC X(08)    VALUE 'COMMON'.     
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
      *                                                                 00740000
      ****************************************************************  00741000
      *   SQLCA                                                      *  00742000
      ****************************************************************  00743000
           EXEC SQL                                                     00744000
               INCLUDE SQLCA                                            00745000
           END-EXEC.                                                    00746000
      *                                                                 00747000
      ****************************************************************  00748000
      *   CSS_ACCOUNT                                                *  00749000
      ****************************************************************  00749100
           EXEC SQL                                                     00750000
               INCLUDE TBACCT                                           00760000
           END-EXEC.                                                    00770000
      *                                                                 00780000
      ****************************************************************  00780100
      *   CSS_BILL_SAMPLE                                            *  00780200
      ****************************************************************  00780300
           EXEC SQL                                                     00780400
               INCLUDE TBBILSMP                                         00780500
           END-EXEC.                                                    00780600
      *                                                                 00780700
      ****************************************************************  00781000
      *   CSS_JOB_PARM                                               *  00782000
      ****************************************************************  00783000
           EXEC SQL                                                     00784000
               INCLUDE TBJBPARM                                         00785000
           END-EXEC.                                                    00786000
      *                                                                 00787000
      ****************************************************************  00788000
      *   SAMPLE_ACCT CURSOR                                         *  00789000
      ****************************************************************  00789100
           EXEC SQL                                                     
               DECLARE SAMPLE_ACCT CURSOR WITH ROWSET POSITIONING FOR   
                SELECT ACCOUNT_NO,                                      
ACT224                 USER_CALC_AM                                     
                  FROM CSS_BILL_SAMPLE WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_TYPE_CODE = :4R-ACCOUNT-TYPE-CODE        
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00790000
MFA-TR*        DECLARE SAMPLE_ACCT CURSOR WITH ROWSET POSITIONING FOR   00800000
MFA-TR*         SELECT ACCOUNT_NO,                                      00820000
MFA-TR*                USER_CALC_AM                                     00820000
MFA-TR*           FROM CSS_BILL_SAMPLE                                  00900000
MFA-TR*          WHERE ACCOUNT_TYPE_CODE = :4R-ACCOUNT-TYPE-CODE        00920000
MFA-TR*            FOR FETCH ONLY WITH UR                               00930000
MFA-TR*    END-EXEC.                                                    01010000
      *                                                                 01020000
      ****************************************************************  00788000
      *   ACCOUNT_TAB CURSOR                                         *  00789000
      ****************************************************************  00789100
           EXEC SQL                                                     
               DECLARE ACCOUNT_TAB CURSOR WITH ROWSET POSITIONING FOR   
                SELECT ACCOUNT_NO                                       
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00790000
MFA-TR*        DECLARE ACCOUNT_TAB CURSOR WITH ROWSET POSITIONING FOR   00800000
MFA-TR*         SELECT ACCOUNT_NO                                       00820000
MFA-TR*           FROM CSS_ACCOUNT                                      00900000
MFA-TR*            FOR FETCH ONLY WITH UR                               00930000
MFA-TR*    END-EXEC.                                                    01010000
      *                                                                 01020000
       LINKAGE SECTION.                                                 
       01 WS-PARM-VALUE.                                                
          05 WS-PARMVAL-LENGTH               PIC S9(04) COMP.           
          05 WS-ACCT-TYPE                    PIC X(01).                 
      *                                                                 01025000
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ****************************************************************  01040000
      *                                                              *  01050000
      *   0000-MAINLINE                                              *  01060000
      *       CONTROLS MAIN PROCESSING OF PROGRAM                    *  01070000
      *                                                              *  01080000
      ****************************************************************  01090000
       0000-MAINLINE.                                                   
      *                                                                 01110000
           PERFORM 0100-INITIALIZATION             THRU 0100-EXIT.      
           PERFORM 1000-PROCESS-OUTPUT             THRU 1000-EXIT.      
           PERFORM 9000-TERMINATE                  THRU 9000-EXIT.      
      *                                                                 01180000
           STOP RUN.                                                    
      *                                                                 01200000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01230000
      ****************************************************************  01240000
      *                                                              *  01250000
      *   0100-INITIALIZATION                                        *  01260000
      *       OPENS OUTPUT FILE AND CHECKS FOR ERRORS.               *  01270000
      *                                                              *  01280000
      ****************************************************************  01290000
       0100-INITIALIZATION.                                             
      *                                                                 01310000
           OPEN OUTPUT FCRES935-FILE.                                   
           IF NOT FCARES935-SUCCESSFUL                                  
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '**  0100-INITIALIZATION               *'         
              DISPLAY '**  ERROR OPENING FCRES935            *'         
              DISPLAY '**  FILE STATUS = ' WS-FCARES935-STATUS          
              DISPLAY '********** PCSCA935 ABORT  ************'         
              MOVE 12                        TO RETURN-CODE             
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 01420000
           OPEN OUTPUT FCIND935-FILE.                                   
           IF NOT FCAIND935-SUCCESSFUL                                  
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '**  0100-INITIALIZATION               *'         
              DISPLAY '**  ERROR OPENING FCIND935            *'         
              DISPLAY '**  FILE STATUS = ' WS-FCAIND935-STATUS          
              DISPLAY '********** PCSCA935 ABORT  ************'         
              MOVE 12                        TO RETURN-CODE             
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 01422000
           OPEN OUTPUT FCDEL935-FILE.                                   
           IF NOT FCADEL935-SUCCESSFUL                                  
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '**  0100-INITIALIZATION               *'         
              DISPLAY '**  ERROR OPENING FCDEL935            *'         
              DISPLAY '**  FILE STATUS = ' WS-FCADEL935-STATUS          
              DISPLAY '********** PCSCA935 ABORT  ************'         
              MOVE 12                        TO RETURN-CODE             
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 01429400
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01450000
      ****************************************************************  01820000
      *                                                              *  01821000
      *   1000-PROCESS                                               *  01830000
      *       OPENS SAMPLE_ACCT CURSOR, FETCHES ACCOUNTS THAT ARE TO *  01840000
      *       GO THROUGH SAMPLE BILLING, CLOSES CURSOR.              *  01850000
      *                                                              *  01861000
      ****************************************************************  01870000
       1000-PROCESS-OUTPUT.                                             
      *                                                                 01890000
           INITIALIZE    WS-ACCOUNT.                                    
                                                                        
           MOVE WS-ACCT-TYPE    TO 4R-ACCOUNT-TYPE-CODE.                
           IF 4R-ACCOUNT-TYPE-CODE = 'R' OR                             
              4R-ACCOUNT-TYPE-CODE = 'I'                                
              PERFORM 2000-OPEN-BILL-SAMP-CSR  THRU 2000-EXIT           
              PERFORM 2100-FETCH-BILL-SAMP-CSR THRU 2100-EXIT           
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
              PERFORM 2200-CLOSE-BILL-SAMP-CSR THRU 2200-EXIT           
           ELSE                                                         
              IF 4R-ACCOUNT-TYPE-CODE = 'D'                             
                 PERFORM 2400-OPEN-ACCOUNT-TAB-CSR  THRU 2400-EXIT      
                 PERFORM 2500-FETCH-ACCOUNT-TAB-CSR THRU 2500-EXIT      
                          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND       
                 PERFORM 2600-CLOSE-ACCOUNT-TAB-CSR THRU 2600-EXIT      
               ELSE                                                     
                  IF 4R-ACCOUNT-TYPE-CODE = 'X'                         
                     PERFORM 8100-DELETE-RESTART    THRU 8100-EXIT      
                     PERFORM 8200-DELETE-CORR-MAIL-STAT THRU 8200-EXIT  
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
           DISPLAY '*PCSCA935 SUCCESSFULLY COMPLETED*'.                 
      *                                                                 01930000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01970000
      ****************************************************************  01980000
      *                                                              *  01980100
      *   2000-OPEN-BILL-SAMP-CSR                                    *  01980500
      *       OPENS THE SAMPLE_ACCT CURSOR AND CHECKS FOR ERRORS.    *  01980600
      *                                                              *  01980700
      ****************************************************************  01981000
      *                                                                 01990000
       2000-OPEN-BILL-SAMP-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN SAMPLE_ACCT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 2000-OPEN-BILL-SAMP-CSR             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02000400
      ****************************************************************  02000500
      *                                                              *  02000600
      *   2100-FETCH-BILL-SAMP-CSR                                   *  02000700
      *       RETRIEVES ACCOUNTS THAT ARE TO GO THROUGH SAMPLE       *  02000800
      *       BILLING.                                               *  02000900
      *                                                              *  02001000
      ****************************************************************  02001100
       2100-FETCH-BILL-SAMP-CSR.                                        
           INITIALIZE WS-MISC-HOST-VARIABLES.                           

MSQ008     MOVE 150 TO MSQ008-SAMPLE-ACCT
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-SAMPLE-ACCT
              FETCH 
              FROM SAMPLE_ACCT          
                 INTO                                                   
                      :WS-SAMP-ACCOUNT-NO,                              
ACT224                :WS-SAMP-BILL-AMT                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     02003000
MFA-TR*         FETCH NEXT ROWSET FROM SAMPLE_ACCT FOR 150 ROWS         02004000
MFA-TR*          INTO                                                   02005000
MFA-TR*               :WS-SAMP-ACCOUNT-NO,                              02006000
MFA-TR*               :WS-SAMP-BILL-AMT                                 02006000
MFA-TR*    END-EXEC.                                                    02010000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SAMPLE-ACCT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                                        
              IF  SQLERRD(3) >= 1                                       
                  MOVE SQLERRD (3)           TO WS-SAMP-ROW-COUNT       
                  MOVE  1                    TO WS-INDEX                
                  PERFORM 2300-PROCESS-CURSOR   THRU 2300-EXIT          
                            UNTIL WS-INDEX > WS-SAMP-ROW-COUNT          
              ELSE                                                      
                  DISPLAY '* RECORD(S) NOT FOUND *'                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                              02019700
MFA-TR*               GET DIAGNOSTICS :WS-SAMP-ROW-COUNT =              02019800
MFA-TR*                      ROW_COUNT                                  02019900
MFA-TR*                     ,:WS-NUM-COND = NUMBER                      02020000
MFA-TR*           END-EXEC                                              02021000
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-SAMP-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '********** PCSCA935 ABORT  ************'     
                  DISPLAY '* 2100-FETCH-BILL-SAMP-CSR            *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
                  DISPLAY '* NUM_COND '  WS-NUM-COND                    
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA935  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              ELSE                                                      
                  DISPLAY '********** PCSCA935 ABORT  ************'     
                  DISPLAY '* 2100-FETCH-BILL-SAMP-CSR            *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA935  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02035000
      ****************************************************************  02036000
      *                                                              *  02036100
      *   2200-CLOSE-BILL-SAMP-CSR                                   *  02037000
      *       CLOSES SAMPLE_ACCT CURSOR AND CHECKS FOR ERRORS.       *  02038000
      *                                                              *  02038100
      ****************************************************************  02039000
       2200-CLOSE-BILL-SAMP-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE SAMPLE_ACCT                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 2200-CLOSE-BILL-SAMP-CSR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02049200
      ****************************************************************  02049300
      *                                                              *  02049400
      *   2300-PROCESS-CURSOR                                        *  02049500
      *       MOVES DATA TO OUTPUT VARIABLES.                        *  02049600
      *                                                              *  02049700
      ****************************************************************  02049800
       2300-PROCESS-CURSOR.                                             
                                                                        
           PERFORM 8000-WRITE-FIOCA935 THRU 8000-EXIT.                  
           ADD 1                             TO WS-INDEX.               
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02059700
      ****************************************************************  01980000
      *                                                              *  01980100
      *   2400-OPEN-ACCOUNT-TAB-CSR.                                 *  01980500
      *       OPENS THE SAMPLE_ACCT CURSOR AND CHECKS FOR ERRORS.    *  01980600
      *                                                              *  01980700
      ****************************************************************  01981000
      *                                                                 01990000
       2400-OPEN-ACCOUNT-TAB-CSR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN ACCOUNT_TAB                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 2400-OPEN-ACCOUNT-TAB-CSR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02000400
      ****************************************************************  02000500
      *                                                              *  02000600
      *   2500-FETCH-ACCOUNT-TAB-CSR                                 *  02000700
      *                                                              *  02001000
      ****************************************************************  02001100
       2500-FETCH-ACCOUNT-TAB-CSR.                                      
           INITIALIZE WS-MISC-HOST-VARIABLES.                           

MSQ008     MOVE 150 TO MSQ008-ACCOUNT-TAB
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-ACCOUNT-TAB
              FETCH 
              FROM ACCOUNT_TAB          
                 INTO                                                   
                      :WS-SAMP-ACCOUNT-NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     02003000
MFA-TR*         FETCH NEXT ROWSET FROM ACCOUNT_TAB FOR 150 ROWS         02004000
MFA-TR*          INTO                                                   02005000
MFA-TR*               :WS-SAMP-ACCOUNT-NO                               02006000
MFA-TR*    END-EXEC.                                                    02010000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ACCOUNT-TAB
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                                        
              IF  SQLERRD(3) >= 1                                       
                  MOVE SQLERRD (3)           TO WS-SAMP-ROW-COUNT       
                  MOVE  1                    TO WS-INDEX                
                  PERFORM 2300-PROCESS-CURSOR   THRU 2300-EXIT          
                            UNTIL WS-INDEX > WS-SAMP-ROW-COUNT          
              ELSE                                                      
                  DISPLAY '* RECORD(S) NOT FOUND *'                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                              02019700
MFA-TR*               GET DIAGNOSTICS :WS-SAMP-ROW-COUNT =              02019800
MFA-TR*                      ROW_COUNT                                  02019900
MFA-TR*                     ,:WS-NUM-COND = NUMBER                      02020000
MFA-TR*           END-EXEC                                              02021000
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-SAMP-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '********** PCSCA935 ABORT  ************'     
                  DISPLAY '* 2500-FETCH-ACCOUNT-TAB-CSR          *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
                  DISPLAY '* NUM_COND '  WS-NUM-COND                    
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA935  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              ELSE                                                      
                  DISPLAY '********** PCSCA935 ABORT  ************'     
                  DISPLAY '* 2500-FETCH-ACCOUNT-TAB-CSR          *'     
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA935  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02035000
      ****************************************************************  02036000
      *                                                              *  02036100
      *   2600-CLOSE-ACCOUNT-TAB-CSR                                 *  02037000
      *                                                              *  02038100
      ****************************************************************  02039000
       2600-CLOSE-ACCOUNT-TAB-CSR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNT_TAB                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 2600-CLOSE-ACCOUNT-TAB-CSR          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02049200
      ****************************************************************  02430000
      *                                                              *  02440000
      *   8000-WRITE-FIOCA936                                        *  02441000
      *       WRITES DATA TO OUTPUT FILE.                            *  02442000
      *                                                              *  02443000
      ****************************************************************  02450000
       8000-WRITE-FIOCA935.                                             
                                                                        
ACT224     MOVE WS-SAMP-ACCOUNT-NO(WS-INDEX) TO WS-ACCOUNT-NO.          
ACT224     MOVE WS-ACCOUNT                   TO FCSSF95-ACCOUNT-NO.     
ACT224     MOVE WS-SAMP-BILL-AMT  (WS-INDEX) TO FCSSF95-BILL-AMT.       
           IF WS-ACCT-TYPE = 'R'                                        
              WRITE FCRES935-DATA-REC FROM FCSSF95-REC                  
           ELSE                                                         
              IF WS-ACCT-TYPE = 'I'                                     
                 WRITE FCIND935-DATA-REC FROM FCSSF95-REC               
              ELSE                                                      
                 IF WS-ACCT-TYPE = 'D'                                  
                     WRITE FCDEL935-DATA-REC FROM FCSSF95-REC           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02520000
      ***************************************************************** 06061000
      * 8100-DELETE-RESTART.                                          * 06062000
      ***************************************************************** 06063000
       8100-DELETE-RESTART.                                             
      *                                                                 06065000
           EXEC SQL                                                     
                DELETE FROM CSS_RESTART                                 
                 WHERE NAME_PROGRAM = 'PCSCA107'                        
                   AND PARTITION_NO = 1                                 
                   AND DUP_CNTRL_NO = 1                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06069000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 8100-DELETE-RESTART                 *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 06071100
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06071400
      ***************************************************************** 06061000
      * 8200-DELETE-CORR-MAIL-STAT.                                   * 06062000
      ***************************************************************** 06063000
       8200-DELETE-CORR-MAIL-STAT.                                      
      *                                                                 06065000
           EXEC SQL                                                     
                DELETE FROM CSS_CORR_MAIL_STAT                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06069000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA935 ABORT  ************'         
              DISPLAY '* 8200-DELETE-CORR-MAIL-STAT          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA935  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 06071100
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06071400
      ****************************************************************  02640000
      *                                                              *  02641000
      *   CPD00040   G E T   F C A 0 0   C O M M O N   D A T E       *  02650000
      *                                                              *  02660000
      ****************************************************************  02670000
       COPY CPD00040.                                                   02680000
      *                                                                 02690000
      ****************************************************************  02700000
      *                                                              *  02701000
      *   CPD00037   COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE    *  02710000
      *                                                              *  02720000
      ****************************************************************  02730000
       COPY CPD00037.                                                   02740000
      *                                                                 02750000
           EXEC SQL                                                     02760000
              INCLUDE CPD00038                                          02770000
           END-EXEC.                                                    02780000
           EXEC SQL                                                     02790000
              INCLUDE CPD00039                                          02800000
           END-EXEC.                                                    02810000
      *                                                                 02820000
      ****************************************************************  02870000
      *                                                              *  02871000
      *   9000-TERMINATE                                             *  02880000
      *       CLOSES THE OUTPUT FILE.                                *  02881000
      *                                                              *  02882000
      ****************************************************************  02890000
       9000-TERMINATE.                                                  
      *                                                                 02910000
           CLOSE FCRES935-FILE.                                         
           CLOSE FCIND935-FILE.                                         
           CLOSE FCDEL935-FILE.                                         
      *                                                                 02930000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02960000
      ****************************************************************  02970000
      *                                                              *  02971000
      *   9700-PROCESS-ABEND.                                        *  02980000
      *                                                              *  02981000
      ****************************************************************  02990000
       COPY CPD0023B.                                                   03000000
      *                                                                 03001000
      ****************************************************************  03010000
      *                                                              *  03011000
      *   9900-SQL-ERROR-ROUTINE                                     *  03020000
      *                                                              *  03021000
      ****************************************************************  03030000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 03050000
           MOVE SQLCODE                      TO WS-DISPLAY-SQLCODE.     
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 03180000
              EXEC SQL                                                  03190000
                   INCLUDE CPD09900                                     03200000
              END-EXEC.                                                 03210000
