       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA921.                                        
       DATE-WRITTEN.   NOV 2011.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      ********            CUSTOMER SERVICE SYSTEM             **********        
      ********                      DB2                       **********        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **                                                              **        
      **   DATE         INITIALS   REASON                             **        
      **   __________   ________   ______________                     **        
P00527**   11/17/2011   SV95326    INITIAL PROGRAM VERSION.           **        
P00821**   01/12/2015   VK7L032    BILL-MSG-ID FIELD ADDED IN OUTPUT  **        
      **                                                              **        
      ******************************************************************        
      **       -------------- PCSCA921 NARRATIVE --------------       **        
      ******************************************************************        
      ******************************************************************        
      ** THIS PROGRAM READS THE DATA FROM CSS_SPCL_BILL_MSG AND WRITES**        
      ** THAT DATA INTO A FILE AND DELETE IT FROM CSS_SPCL_BILL_MSG   **        
      ** TABLE.                                                       **        
      ******************************************************************        
      ******************************************************************        
      **                                                              **        
      **            ---- BASIC SEQUENCE STRUCTURE ----                **        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESSING CONTROL PATH        **        
      **        3000 - 4999     BATCH PROCESSING MODULES - NOT USED   **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9799     TERMINATION MODULES                   **        
      **        9900 - 9999     ABEND/ABORT MODULES                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
             SELECT OUTFILE ASSIGN TO FCSCA921                          
             FILE STATUS IS WS-FRSTMNT-STATUS.                          
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       FD  OUTFILE                                                      
           BLOCK CONTAINS 0 RECORDS                                     
P00821     RECORD CONTAINS 20 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  OUTFILE-RECORD.                                              
           10 E-FSTMNT-ACCOUNT-NO      PIC 9(13) VALUE 0.               
           10 E-FSTMNT-COMPANY-NO      PIC X(2) VALUE SPACES.           
P00821     10 E-FSTMNT-BILL-MSG-ID     PIC X(5) VALUE SPACES.           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA921'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-START                    PIC X(40)  VALUE             
               'WORKING STORAGE FOR PCSCA921 STARTS HERE'.              
           05  WS-DISPLAY-SQLCODE          PIC -Z(8)9.                  
           05  WS-RSTMNT-REC-CNTR          PIC 9(08)  VALUE 0.          
           05  WS-FRSTMNT-STATUS           PIC X(02).                   
               88 FRSTMNT-SUCCESSFUL                  VALUE '00'.       
           05  WS-NO-MORE-RECORDS          PIC X(01)  VALUE 'N'.        
               88 NO-MORE-RECORDS                     VALUE 'Y'.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSCA921'. 
      *                                                                         
      ******************************************************************        
      * WS FOR DB2 & CICS ERROR PROCESSING                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
      *COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
      *COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * DB2 TABLES INCLUDED IN PROGRAM                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_SPCL_BILL_MSG  - U1                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     01920031
             INCLUDE TBSBLMSG                                           01930061
           END-EXEC.                                                    01940031
      *                                                                         
      ******************************************************************        
      * BBP-WQ-AUTOMATION-CURSOR                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILL_MSG_CUR CURSOR FOR                           
               SELECT REVENUE_MO_ST                                     
                     ,ACCOUNT_NO                                        
                     ,BILL_MSG_ID                                       
                     ,MSG_TYPE_CD                                       
                     ,COMPANY_NO                                        
                     ,BILL_CYCLE_ST                                     
                     ,BILL_CYCLE_END                                    
                     ,REVENUE_MO_END                                    
                 FROM CSS_SPCL_BILL_MSG WITH(READUNCOMMITTED)                   
P00821          WHERE BILL_MSG_ID    IN ('STMNT','STM12','ST12E',       
P00821                                   'ST24E')                       
                  AND MSG_TYPE_CD    = 'S'                              
                ORDER BY ACCOUNT_NO                                     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_MSG_CUR CURSOR FOR                                   
MFA-TR*        SELECT REVENUE_MO_ST                                             
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,BILL_MSG_ID                                               
MFA-TR*              ,MSG_TYPE_CD                                               
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,BILL_CYCLE_ST                                             
MFA-TR*              ,BILL_CYCLE_END                                            
MFA-TR*              ,REVENUE_MO_END                                            
MFA-TR*          FROM CSS_SPCL_BILL_MSG                                         
MFA-TR*         WHERE BILL_MSG_ID    IN ('STMNT','STM12','ST12E',               
MFA-TR*                                  'ST24E')                               
MFA-TR*           AND MSG_TYPE_CD    = 'S'                                      
MFA-TR*         ORDER BY ACCOUNT_NO                                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-INPUT-PROCESS           THRU 1000-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT OUTFILE.                                         
      *                                                                         
           IF FRSTMNT-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '* PCSCA921 PROCESSING ERROR             *'       
              DISPLAY '* 0100-ERROR ON FCSRSTMNT OPEN.           '      
              DISPLAY '* WS-FCSMRS01-STATUS:' WS-FRSTMNT-STATUS         
              DISPLAY '* PROCESSING TERMINATED:                *'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-INPUT-PROCESS                                             *        
      ******************************************************************        
      *                                                                         
       1000-INPUT-PROCESS.                                              
      *                                                                         
           PERFORM 7000-OPEN-BILL-MSG-CUR       THRU 7000-EXIT.         
           PERFORM 7010-FETCH-BILL-MSG-CUR      THRU 7010-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT          
             UNTIL NO-MORE-RECORDS.                                     
           PERFORM 7020-CLOSE-BILL-MSG-CUR      THRU 7020-EXIT.         
           DISPLAY 'WS-RSTMNT-REC-CNTR :' WS-RSTMNT-REC-CNTR.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2100-MOVE-FILE-DETAILS    THRU 2100-EXIT.            
           PERFORM 8000-WRITE-FCSRSTMNT      THRU 8000-EXIT.            
           PERFORM 8100-DELETE-BILL-MSG      THRU 8100-EXIT.            
                                                                        
           PERFORM 7010-FETCH-BILL-MSG-CUR      THRU 7010-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-MOVE-FILE-DETAILS                                         *        
      ******************************************************************        
      *                                                                         
       2100-MOVE-FILE-DETAILS.                                          
      *                                                                         
           MOVE U1-ACCOUNT-NO        TO E-FSTMNT-ACCOUNT-NO.            
           MOVE U1-COMPANY-NO        TO E-FSTMNT-COMPANY-NO.            
P00821     MOVE U1-BILL-MSG-ID       TO E-FSTMNT-BILL-MSG-ID.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-BILL-MSG-CUR                                         *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-BILL-MSG-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
              OPEN BILL_MSG_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA921 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7000-OPEN-BILL-MSG-CUR           *'   
              DISPLAY '* BILL_MSG_CUR OPEN ERROR                   *'   
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-BILL-MSG-CUR.                                       *        
      ******************************************************************        
      *                                                                         
       7010-FETCH-BILL-MSG-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL_MSG_CUR                                        
               INTO :U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF SQLCODE EQUAL NOT-FOUND                                
                 MOVE 'Y'                   TO   WS-NO-MORE-RECORDS     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA921 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7010-FETCH-BILL-MSG-CUR          *'   
              DISPLAY '* BILL_MSG_CUR FETCH ERROR                  *'   
              DISPLAY '* SUCCESSFULLY PROCESSED ACCOUNT PRIOR TO   *'   
              DISPLAY '* THE ABEND.                                *'   
              DISPLAY '* ACCOUNT NO          = ' U1-ACCOUNT-NO          
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-CLOSE-BILL-MSG-CUR                                                 
      ******************************************************************        
      *                                                                         
       7020-CLOSE-BILL-MSG-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL_MSG_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA921 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7020-CLOSE-BILL-MSG-CUR          *'   
              DISPLAY '* BILL_MSG_CUR CLOSE ERROR                  *'   
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-WRITE-FCSRSTMNT                                           *        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSRSTMNT.                                            
      *                                                                         
           WRITE OUTFILE-RECORD.                                        
      *                                                                         
           IF FRSTMNT-SUCCESSFUL                                        
              ADD 1                         TO WS-RSTMNT-REC-CNTR       
              INITIALIZE                       OUTFILE-RECORD           
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '* PCSCA921 PROCESSING ERROR           *'         
              DISPLAY '* ABEND IN 8000-WRITE-FCSRSTMNT        *'        
              DISPLAY '* WHILE WRITTING OUTFILE        *'               
              DISPLAY '* PROCESSING TERMINATED               *'         
              DISPLAY '***************************************'         
              DISPLAY '*WS-FRSTMNT-STATUS = ' WS-FRSTMNT-STATUS         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-DELETE-BILL-MSG.                                          *        
      ******************************************************************        
      *                                                                         
       8100-DELETE-BILL-MSG.                                            
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_SPCL_BILL_MSG                            
                     WHERE ACCOUNT_NO     = :U1-ACCOUNT-NO              
P00821                 AND BILL_MSG_ID    IN ('STMNT','STM12','ST12E',  
P00821                                        'ST24E')                  
                       AND MSG_TYPE_CD    = 'S'                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '* PCSCA921 PROCESSING ERROR            *'        
              DISPLAY '* ABEND IN 8100-DELETE-BILL-MSG        *'        
              DISPLAY '* ACCOUNT NO      = ' U1-ACCOUNT-NO              
              DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE OUTFILE.                                               
           IF FRSTMNT-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '* PCSCA921 PROCESSING ERROR           *'         
              DISPLAY '* ABEND IN 9000-TERMINATE             *'         
              DISPLAY '* CLOSE ERROR ON FCSRSTMNT FILE        *'        
              DISPLAY '* PROCESSING TERMINATED               *'         
              DISPLAY '***************************************'         
              DISPLAY '*WS-FRSTMNT-STATUS = ' WS-FRSTMNT-STATUS         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
