       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA920.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  08/04/08  RV97439      INITIAL VERSION                                
T35152**  09/26/08  SV82012      SECURED EXCEPTION EBILL ACCOUNTS NEED*         
T35152**                         TO CREATE AN EBILL WQ.              **         
I00221**  12/16/08  SV82012      SECURED EXCEPTION EBILL WQ'S NEED TO**         
I00221**                         GO TO CATEGORY ID 273.              **         
A00664**  04/16/09  BD09555      ADD LOGIC FOR CONSOLIDATED MASTERS  **         
A01292**  02/15/10  MC95456      NEED NOT TO GENERATE WORK QUEUES FOR**         
A01292**                         INTERNATIONAL BILLS.                **         
A01292**                         WORK QUEUES ARE TO BE GENERATED FOR **         
A01292**                         EDI ACCOUNTS IN SEB                 **         
P00236**  06/09/10  SV82012      GOOD CODE PAPERLESS MASTER NOT TO   **         
P00236**                         WRITE WQ.                           **         
A04527**  11/19/13  MR7E794     ADD USERID WHO REQUESTED BILL TO PULL**         
A04527**            ACT210                                           **         
ACT009** 12/31/13   AS7C117      REPLACE CSS_WQ_ITEMS_MF WITH        **         
ACT009** A04860                  CSS_WQ_ITEMS.                       **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA920 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM WILL WRITE A WORK QUEUE IF THE EBILL INDICATOR**         
      **  FLAG IS A 'Y' AND ACCOUNTS ON THE BANK_EFT TABLE HAS A     **         
      **  STATUS CODE OTHER THAN A 'CONFIRMED' ACCOUNT.              **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      ******************************************************************CSS00010
      * SELECT STATEMENT FOR REGULAR BILLING EXTRACT FILE              *CSS00020
      ******************************************************************CSS00040
           SELECT FCSCA920-FILE                                         
               ASSIGN UT-S-FCSCA920                                     
               FILE STATUS IS WS-FCA920-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * FD STATEMENT FOR A REGULAR BILLING EXTRACT FILE                *        
      ******************************************************************        
       FD  FCSCA920-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
           COPY SORTINDX.                                                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA920'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.  
           05  WS-ACCOUNT-NO-AN              PIC X(13).                 
           05  WS-ACCOUNT-NO-N REDEFINES     WS-ACCOUNT-NO-AN           
                                             PIC 9(13).                 
           05  RS-RETURN-CODE                PIC S9(04) COMP VALUE 0.   
           05  RS-RETURN-CODE-DISP           PIC +Z(04).                
           05  WS-EXCP-CODE                  PIC XX.                    
               88  A-GOOD-CODE         VALUE 'C3' 'C9' 'MS' 'CY' 'CD'   
A00664                                  'P ' 'E1' 'D1' 'M3' 'M9' '  '   
A01292                                  'CI'.                           
      *                                                                         
A01292     05  WS-DATABASE                   PIC 9(01) VALUE 0.         
A01292         88 CSR-DATABASE                         VALUE 1.         
A01292         88 SEB-DATABASE                         VALUE 2.         
A04527     05  WS-PULL-USERID                PIC X(07).                 
A04527     05  WS-1MNTH-PRIOR                PIC X(10) VALUE SPACES.    
A04527     05  WS-DATE-BILLED              PIC X(10) VALUE '    -  -  '.
A04527     05  FILLER REDEFINES WS-DATE-BILLED.                         
A04527         10  WS-DATE-BILL-CC         PIC X(2).                    
A04527         10  WS-DATE-BILL-YY         PIC X(2).                    
A04527         10  WS-DASH-1               PIC X(01).                   
A04527         10  WS-DATE-BILL-MM         PIC X(2).                    
A04527         10  WS-DASH-2               PIC X(01).                   
A04527         10  WS-DATE-BILL-DD         PIC X(2).                    
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA920-STATUS              PIC XX    VALUE '  '.      
               88  FCA920-SUCCESSFUL                   VALUE '00'.      
           05  WS-END-OF-FCA920               PIC X    VALUE 'N'.       
               88  END-OF-FCA920                       VALUE 'Y'.       
      *                                                                         
       01  WS-LITERAL.                                                  
           05  PROGRAM-NAME                   PIC X(8) VALUE 'PCSCA920'.
ACT009     05  SCSCB077                       PIC X(8) VALUE 'SCSCB077'.
           05  WS-Y                           PIC X(01) VALUE 'Y'.      
A00664     05  WS-WQ-COMMENTS-LEN             PIC S9(4) COMP VALUE +50. 
I00221     05  WS-WQ-COMMENTS.                                          
I00221         10  WS-WQ-PULL-CODE            PIC X(02) VALUE SPACES.   
A00664         10  WS-WQ-COMMENTS-TEXT        PIC X(48).                
A00664     05  WS-WQ-OTHER-TEXT               PIC X(48) VALUE           
A00664         ' EBILL SYSTEM-GENERATED BILL PULL               '.      
A00664     05  WS-WQ-CONS-TEXT                PIC X(48) VALUE           
A00664         ' EBILL CONSOLIDATED MASTER BILL PULL           '.       
A01292     05  WS-WQ-EDI-TEXT                 PIC X(48) VALUE           
A01292         ' EDI ACCOUNT BILL PULL                         '.       
A04527     05  WS-WQ-OTHER-TEXT-UID           PIC X(48) VALUE SPACES.   
A04527*                                                                         
A04527 01  WS-DISPLAYS.                                                 
A04527     05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
A04527     05  WS-DISPLAY-ACCOUNT          PIC ZZZZZZZZZZZZ9.           
      *                                                                         
       COPY CWS00010.                                                   00055800
       COPY CWS00303.                                                   00055800
       COPY CWS09900.                                                   00055800
       COPY CWS0070B.                                                   00055800
      *                                                                         
            EXEC SQL                                                    00056600
                 INCLUDE SQLCA                                          00056700
            END-EXEC.                                                   00056800
      *                                                                         
           EXEC SQL                                                     00057200
                INCLUDE TBACCT                                          00057300
           END-EXEC.                                                    00057400
      *                                                                         
           EXEC SQL                                                     00057200
                INCLUDE TBUTLENV                                        00057300
           END-EXEC.                                                    00057400
      *                                                                         
A01292     EXEC SQL                                                     00057200
A01292          INCLUDE TBDELQ                                          00057300
A01292     END-EXEC.                                                    00057400
A04527                                                                  
A04527*   DCLGEN FOR CSS_MNT_TRANS_HIST                                 00048800
A04527     EXEC SQL                                                     00056600
A04527          INCLUDE TBMNHIST                                        00056700
A04527     END-EXEC.                                                    00056800
A04527                                                                  
ACT009/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
ACT009      EXEC SQL                                                            
ACT009           INCLUDE CWS00077                                               
ACT009      END-EXEC.                                                           
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    ** 00065600
      ***************************************************************** 00065700
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU  0100-EXIT.            
      *                                                                         
           PERFORM 1000-PROCESS-FCSCA920    THRU  1000-EXIT             
                                            UNTIL END-OF-FCA920.        
           PERFORM 9000-TERMINATE           THRU  9000-EXIT.            
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  INITIALIZATION ROUTINE                                       *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT  FCSCA920-FILE                                    
           IF WS-FCA920-STATUS NOT = '00'                               
               DISPLAY '**************************************'         
               DISPLAY '**   ERROR OPENING REGULAR FILE'                
               DISPLAY '**   FILE STATUS = ' WS-FCA920-STATUS           
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
A01292     MOVE 'DATABASE' TO C8-DELINQ-CD                              
A01292     MOVE '01'       TO C8-COMPANY-NO                             
A01292     PERFORM 7100-GET-DEL-VALUES THRU 7100-EXIT                   
A01292     MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MAIN PROCESSING MODULE                                         *        
      ******************************************************************        
       1000-PROCESS-FCSCA920.                                           
      *                                                                         
           PERFORM 7000-READ-FCSCA920            THRU 7000-EXIT.        
      *                                                                         
           IF NOT END-OF-FCA920                                         
I00221        MOVE EXT-ACCT-ACCOUNT-NO        TO WS-ACCOUNT-NO-AN       
I00221        MOVE WS-ACCOUNT-NO-N            TO AT-ACCOUNT-NO          
I00221                                           UT-ACCOUNT-NO          
I00221        MOVE EXT-BILL-EXCEPTION-CODE    TO WS-EXCP-CODE           
I00221        IF (NOT A-GOOD-CODE)                                      
P00236          AND (EXT-ACCT-MASTER-SUB-FLAG = ' ' OR 'M')             
A01292           IF  EXT-ACCT-EBILL-REGISTER-IND = 'Y' OR               
A01292               (SEB-DATABASE AND EXT-ACCT-EDI-DEST-FLAG = 'Y')    
A00664              PERFORM 1100-BUILD-WQ        THRU 1100-EXIT         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
A00664 1100-BUILD-WQ.                                                   
ACT009     INITIALIZE CWS00077-FIELDS.                                  
A00664     MOVE EXT-BILL-EXCEPTION-CODE TO WS-WQ-PULL-CODE.             
A00664     IF EXT-ACCT-MASTER-SUB-FLAG = 'M'                            
ACT009         MOVE 275                     TO WS-77-CATEGORY-ID        
A00664         MOVE WS-WQ-CONS-TEXT         TO WS-WQ-COMMENTS-TEXT      
A00664     ELSE                                                         
A01292         IF EXT-ACCT-EBILL-REGISTER-IND = 'Y'                     
A04527                                                                  
A04527            IF WS-1MNTH-PRIOR = SPACES                            
A04527               MOVE EXT-ACCT-BILL-DATE TO WS-DATE-BILLED          
A04527               PERFORM 7200-GET-DATE-1MNTH-PRIOR THRU 7200-EXIT   
A04527            END-IF                                                
A04527            PERFORM 7500-GET-PULLED-BY-USERID THRU 7500-EXIT      
A04527            STRING WS-WQ-OTHER-TEXT(1:33) SPACE WS-PULL-USERID    
A04527                   DELIMITED BY SIZE INTO WS-WQ-OTHER-TEXT-UID    
A04527            MOVE WS-WQ-OTHER-TEXT-UID    TO WS-WQ-OTHER-TEXT      
A01292            MOVE WS-WQ-OTHER-TEXT        TO WS-WQ-COMMENTS-TEXT   
A01292         ELSE                                                     
A01292            MOVE WS-WQ-EDI-TEXT      TO WS-WQ-COMMENTS-TEXT       
A01292         END-IF                                                   
A04527         IF  EXT-BILL-BILL-DEST-CODE  = 'S' OR 'G'                
ACT009             MOVE 273                 TO WS-77-CATEGORY-ID        
A00664         ELSE                                                     
ACT009             MOVE 208                 TO WS-77-CATEGORY-ID        
A00664         END-IF                                                   
A00664     END-IF                                                       
ACT009     MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS-TEXT.        
ACT009     MOVE 0                        TO WS-77-SERV-ORDER-NO.        
ACT009     MOVE EXT-ACCT-ACCOUNT-NO      TO WS-77-ACCOUNT-NO.           
ACT009     MOVE EXT-ACCT-PREMISE-NO      TO WS-77-PREMISE-NO.           
ACT009     MOVE EXT-BILL-CUSTOMER-NO     TO WS-77-CUSTOMER-NO.          
ACT009     MOVE '   '                    TO WS-77-RESP-AREA-ID.         
ACT009     MOVE 'SYSTEM'                 TO WS-77-USER-ID-ORIG.         
ACT009     MOVE EXT-ACCT-LOCAL-OFFICE    TO WS-77-LOCAL-OFFICE.         
ACT009     MOVE 'H'                      TO WS-77-PRIORITY.             
ACT009     MOVE WS-WQ-COMMENTS-LEN       TO WS-77-COMMENTS-LEN.         
ACT009     MOVE '4'                      TO WS-77-ROUTE-CATEGORY.       
ACT009     MOVE ZERO                     TO WS-77-FREE-FORM-LEN.        
ACT009     MOVE LOW-VALUES               TO WS-77-FREE-FORM-TXT.        
ACT009     MOVE PROGRAM-NAME             TO WS-77-CREATED-BY.           
A00664     PERFORM 8895-INSERT-WORK-QUEUE     THRU 8895-EXIT.           
A00664     DISPLAY 'WQ WRITTEN FOR ACCOUNT ' EXT-ACCT-ACCOUNT-NO.       
A00664 1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  READ THE FCSCA920 INPUT FILE.                           *              
      ************************************************************              
       7000-READ-FCSCA920.                                              
      *                                                                         
           READ FCSCA920-FILE AT END                                    
                MOVE WS-Y TO WS-END-OF-FCA920.                          
           IF FCA920-SUCCESSFUL OR END-OF-FCA920                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA920 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING REGULAR FILE   **'        
              DISPLAY '**     FILE STATUS = ' WS-FCA920-STATUS          
              DISPLAY '****************************************'        
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01292***************************************************************** 15740000
A01292* 7100-GET-DEL-VALUES.                                          * 15750000
A01292*     SELECTS VALUES FROM CSS_DELINQUENCY.                      * 15810000
A01292***************************************************************** 15830000
A01292 7100-GET-DEL-VALUES.                                             
A01292                                                                  
A01292     EXEC SQL                                                     
A01292        SELECT DELINQ_VALUE                                       
A01292          INTO :C8-DELINQ-VALUE                                   
A01292          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A01292         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
A01292          AND  COMPANY_NO = :C8-COMPANY-NO                        
A01292                                                           
A01292     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT DELINQ_VALUE                                       15920000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15930000
MFA-TR*         FROM CSS_DELINQUENCY                                    15940000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         15950000
MFA-TR*         AND  COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01292                                                                  
A01292     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01292     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01292         WHEN SUCCESSFUL-CALL                                     
A01292              CONTINUE                                            
A01292         WHEN OTHER                                               
A01292              MOVE 'C8'            TO WS-DB2-TABLE-ID             
A01292              MOVE 'SELECT'        TO WS-DB2-FUNCTION             
A01292              MOVE SQLCODE         TO WS-DB2-RETURN-CODE          
A01292              MOVE '920'           TO WS-DB2-MODULE-ID            
A01292              MOVE '7100'          TO WS-DB2-PARAGRAPH            
A01292              DISPLAY '*** IN 7100-GET-DEL-VALUE    ******'       
A01292              DISPLAY '*** SELECT DATABASE NAME     ******'       
A01292              DISPLAY '*** SQL CODE    = ' SQLCODE                
A01292              DISPLAY '***DELINQ CD    = ' C8-DELINQ-CD           
A01292              MOVE 12 TO RETURN-CODE                              
A01292              PERFORM 9900-ABEND THRU 9900-EXIT                   
A01292     END-EVALUATE.                                                
A01292                                                                  
A01292 7100-EXIT.                                                       
A01292     EXIT.                                                        
      *                                                                         
A04527*****************************************************************         
A04527*   7200-GET-DATE-1MNTH-PRIOR                                             
A04527* GET A DATE 1 MONTH PRIOR TO TODAY FOR USE IN SQL QUERIES.    **         
A04527*****************************************************************         
A04527 7200-GET-DATE-1MNTH-PRIOR.                                       
A04527                                                                  
A04527     EXEC SQL                                                     
A04527        SELECT
              DATEADD( MONTH, -1, IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BILLED
              ), CONVERT(DATE, :WS-DATE-BILLED) ) )
            INTO
              :WS-1MNTH-PRIOR   
A04527     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-1MNTH-PRIOR  =  DATE(:WS-DATE-BILLED) - 1 MONTH           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A04527     IF SQLCODE NOT = SUCCESSFUL-CALL                             
A04527        DISPLAY '************ PCSCA920 *******************'       
A04527        DISPLAY '**  ERROR ON 7200-GET-DATE-1MNTH-PRIOR **'       
A04527        DISPLAY '**  SELECT FROM SYSDUMMY1              **'       
A04527        DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE        
A04527        DISPLAY '********* FATAL ERROR - ABEND ***********'       
A04527        PERFORM 9900-ABEND                THRU 9900-EXIT          
A04527     END-IF.                                                      
A04527 7200-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527***************************************************************** 00128700
A04527* 7500-GET-PULLED-BY-USERID                                    ** 00128300
A04527* FETCH USERID OF USER WHO REQUESTED FOR THE BILL TO BE PULLED ** 00128400
A04527* INTO WQ COMMENTS.                                                       
A04527***************************************************************** 00128700
A04527 7500-GET-PULLED-BY-USERID.                                       
A04527                                                                  
A04527     MOVE SPACES                      TO WS-PULL-USERID.          
A04527     MOVE WS-ACCOUNT-NO-N             TO MH-ACCOUNT-NO.           
A04527* GET USERID FOR CANCEL/REBILLS                                           
A04527     IF (EXT-BILL-BILL-DEST-CODE = 'A')                           
A04527        PERFORM 7530-GET-CANREBILL-USERID THRU 7530-EXIT          
A04527     END-IF.                                                      
A04527                                                                  
A04527* SKIP USERID RETRIEVAL FOR CROSSFOOT ERRORS AND SECURED BILLS            
A04527     IF EXT-BILL-BILL-DEST-CODE  = 'S' OR                         
A04527        EXT-BILL-BILL-DEST-CODE  = 'G' OR                         
A04527        (EXT-BILL-BILL-DEST-CODE = 'C' AND                        
A04527              EXT-BILL-PULL-CODE = 'X')                           
A04527        MOVE 'SYSTEM'                    TO WS-PULL-USERID        
A04527     ELSE                                                         
A04527* PERM PULL CODE                                                          
A04527        IF (EXT-BILL-BILL-DEST-CODE = 'C' AND                     
A04527                 EXT-BILL-PULL-CODE = 'P')                        
A04527           PERFORM 7510-GET-PERM-PULL-USERID THRU 7510-EXIT       
A04527* ALL OTHERS EXCEPT CANCEL/REBILLS                                        
A04527        ELSE                                                      
A04527           IF (EXT-BILL-BILL-DEST-CODE NOT = 'A')                 
A04527              PERFORM 7520-GET-TEMP-PULL-USERID THRU 7520-EXIT    
A04527           END-IF                                                 
A04527        END-IF                                                    
A04527     END-IF.                                                      
A04527                                                                  
A04527 7500-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527 7510-GET-PERM-PULL-USERID.                                       
A04527                                                                  
A04527     MOVE SPACES        TO MH-USER-ID                             
A04527     EXEC SQL                                                     
A04527        SELECT TOP(1) USER_ID INTO :MH-USER-ID                           
A04527          FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)       
A04527         WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A04527           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A04527           AND MI.COLUMN_DESC = 'PERM PULL CODE'                  
A04527           AND MI.CHG_COLUMN_VALUE <> 'A'                         
A04527        ORDER BY DATE_TRANS DESC                                  
A04527                                                           
A04527                                           
A04527                                                      
A04527     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID INTO :MH-USER-ID                                   
MFA-TR*         FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MI               
MFA-TR*        WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MI.COLUMN_DESC = 'PERM PULL CODE'                          
MFA-TR*          AND MI.CHG_COLUMN_VALUE <> 'A'                                 
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A04527     EVALUATE SQLCODE                                             
A04527        WHEN SUCCESSFUL-CALL                                      
A04527           MOVE MH-USER-ID       TO WS-PULL-USERID                
A04527        WHEN NOT-FOUND                                            
A04527           MOVE 'UNKNOWN'    TO WS-PULL-USERID                    
A04527        WHEN OTHER                                                
A04527           DISPLAY '************ PCSCA920 *******************'    
A04527           DISPLAY '**  ERROR ON 7510-GET-PERM-PULL-USERID **'    
A04527           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A04527           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A04527           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A04527           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A04527           PERFORM 9900-ABEND                THRU 9900-EXIT       
A04527     END-EVALUATE.                                                
A04527                                                                  
A04527 7510-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527 7520-GET-TEMP-PULL-USERID.                                       
A04527                                                                  
A04527     MOVE SPACES        TO MH-USER-ID                             
A04527     EXEC SQL                                                     
A04527        SELECT TOP(1) USER_ID                                            
A04527         INTO :MH-USER-ID                                         
A04527         FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)        
A04527         WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A04527           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A04527           AND MI.COLUMN_DESC = 'TEMP PULL CODE'                  
A04527           AND MI.CHG_COLUMN_VALUE <> 'A'                         
A04527           AND MH.DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                        :WS-1MNTH-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-1MNTH-PRIOR
              ) <> 0) OR (LEN(:WS-1MNTH-PRIOR) <> 10), CIS.CHAR2DATE(
                                                        :WS-1MNTH-PRIOR
              ), CONVERT(DATE, :WS-1MNTH-PRIOR) )                    
A04527        ORDER BY DATE_TRANS DESC                                  
A04527                                                           
A04527                                           
A04527                                                      
A04527     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID                                                    
MFA-TR*        INTO :MH-USER-ID                                                 
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MI                
MFA-TR*        WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MI.COLUMN_DESC = 'TEMP PULL CODE'                          
MFA-TR*          AND MI.CHG_COLUMN_VALUE <> 'A'                                 
MFA-TR*          AND MH.DATE_TRANS > :WS-1MNTH-PRIOR                            
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7520                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A04527     EVALUATE SQLCODE                                             
A04527        WHEN SUCCESSFUL-CALL                                      
A04527           MOVE MH-USER-ID       TO WS-PULL-USERID                
A04527        WHEN NOT-FOUND                                            
A04527           IF (EXT-BILL-BILL-DEST-CODE = 'C' AND                  
A04527                    EXT-BILL-PULL-CODE = 'T')                     
A04527               MOVE 'UNKNOWN'    TO WS-PULL-USERID                
A04527           ELSE                                                   
A04527               MOVE 'SYSTEM '    TO WS-PULL-USERID                
A04527           END-IF                                                 
A04527        WHEN OTHER                                                
A04527           DISPLAY '************ PCSCA920 *******************'    
A04527           DISPLAY '**  ERROR ON 7520-GET-TEMP-PULL-USERID **'    
A04527           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A04527           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A04527           DISPLAY '**  DATE       = ' WS-1MNTH-PRIOR             
A04527           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A04527           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A04527           PERFORM 9900-ABEND                THRU 9900-EXIT       
A04527     END-EVALUATE.                                                
A04527                                                                  
A04527 7520-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527 7530-GET-CANREBILL-USERID.                                       
A04527                                                                  
A04527     MOVE SPACES        TO MH-USER-ID                             
A04527     EXEC SQL                                                     
A04527        SELECT TOP(1) USER_ID                                            
A04527         INTO :MH-USER-ID                                         
A04527         FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)        
A04527         WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A04527           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A04527           AND MI.COLUMN_DESC = 'FNCT DESIRED'                    
A04527           AND MI.CHG_COLUMN_VALUE = 'CANCEL/REBILL'              
A04527           AND MH.DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                        :WS-1MNTH-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-1MNTH-PRIOR
              ) <> 0) OR (LEN(:WS-1MNTH-PRIOR) <> 10), CIS.CHAR2DATE(
                                                        :WS-1MNTH-PRIOR
              ), CONVERT(DATE, :WS-1MNTH-PRIOR) )                    
A04527        ORDER BY DATE_TRANS DESC                                  
A04527                                                           
A04527                                           
A04527                                                      
A04527     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID                                                    
MFA-TR*        INTO :MH-USER-ID                                                 
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MI                
MFA-TR*        WHERE MI.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MI.COLUMN_DESC = 'FNCT DESIRED'                            
MFA-TR*          AND MI.CHG_COLUMN_VALUE = 'CANCEL/REBILL'                      
MFA-TR*          AND MH.DATE_TRANS > :WS-1MNTH-PRIOR                            
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7530                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A04527     EVALUATE SQLCODE                                             
A04527        WHEN SUCCESSFUL-CALL                                      
A04527           MOVE MH-USER-ID       TO WS-PULL-USERID                
A04527        WHEN NOT-FOUND                                            
A04527           MOVE 'SYSTEM '        TO WS-PULL-USERID                
A04527        WHEN OTHER                                                
A04527           DISPLAY '************ PCSCA920 *******************'    
A04527           DISPLAY '**  ERROR ON 7530-GET-CANREBILL-USERID **'    
A04527           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A04527           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A04527           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A04527           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A04527           PERFORM 9900-ABEND                THRU 9900-EXIT       
A04527     END-EVALUATE.                                                
A04527                                                                  
A04527 7530-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
      ***************************************************************** 00290800
      **  INSERT WORK QUEUE                                          ** 00290900
      **                                                             ** 00291000
      **  8895-INSERT-WORK-QUEUE                                     ** 00291100
      ***************************************************************** 00291200
      *                                                                 00291300
       8895-INSERT-WORK-QUEUE.                                          
                                                                        
ACT009     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT009                         ABEND-FILE,                              
ACT009                         RS-RETURN-CODE                           
ACT009     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
ACT009                                                                  
ACT009     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT009        MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
ACT009        MOVE 'CALL'                     TO   ABEND-FUNCTION       
ACT009        MOVE 'SCSCB077'                 TO   TABLE-1              
ACT009        MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
ACT009        MOVE 'PREMISE_NO'               TO   TABLE-ELEMENT-2      
ACT009        MOVE 'SERV_ORDER_NO '           TO   TABLE-ELEMENT-3      
ACT009        MOVE 'SQL RETURN CODE'          TO   TABLE-ELEMENT-4      
ACT009        MOVE WS-77-ACCOUNT-NO           TO   HOSTVAR-ELEMENT-1    
ACT009        MOVE WS-77-PREMISE-NO           TO   HOSTVAR-ELEMENT-2    
ACT009        MOVE WS-77-SERV-ORDER-NO        TO   HOSTVAR-ELEMENT-3    
ACT009        MOVE WS-ACTIVE-RETURN-CODE      TO   HOSTVAR-ELEMENT-4    
ACT009        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
ACT009     END-IF.                                                      
      *                                                                 00291700
       8895-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00291700
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES                                                *00300600
      ******************************************************************00300700
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA920-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00303300
      *     9700-PROCESS-ABEND                                         *00303400
      *     STANDARDIZED BATCH/ONLINE ABEND COPYBOOK                   *00303500
      ******************************************************************00303600
      *                                                                 00303700
       COPY CPD0023B.                                                   00303800
      *                                                                 00303900
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM PROBLEM OCCURS.                          *        
      ******************************************************************        
              EXEC SQL                                                          
                   INCLUDE CPD09900                                             
              END-EXEC.                                                         
      *                                                                         
