       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA919.                                        
       AUTHOR.         VAISHNAVI.                                       
       DATE-WRITTEN.   JULY 2008.                                       
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **                                                             **         
T35152**  09/11/08  SV82012      CSR - THIRD PARTY LOGIC.            **         
T37389**  10/21/08  SV82012      NO RETURN ENVELOPE FOR MEMO AND THIRD*         
T37389**            ACT 43       PARTY BILLS.                        **         
A00747**  02/12/09  BD09555      USE BAR CODE TO POPULATE THE ZIP AND *         
      **                         ZIP+4 USED BY MAILSTREAM.  FORCE     *         
      **                         "NUMBER OF BILL COPIES" TO EQUAL 1.  *         
      **                         INITIALIZE SEQUENCE NUMBER TO ZERO.  *         
PRJ166**  09/15/09  CVNS         CALL SCSCA165 TO GET UNIQUE          *         
PRJ166**                         IDENTIFIER AND WRITE TO OUTPUT FILE. *         
P00740**  11/05/13  BD09555      ADD CHECK FOR MEMO_BILL_IND = 'Y'    *         
A04127**  01/16/15  SV95326      ADD WS-ALOC-ITPA-PROCESS PARAMETER   *         
      **                         WHILE CALLING SCSCA184               *         
P00836**  10/2015  ESM           ADDED COMM TYPE AND SUBTYPE FOR      *         
P00836**                         MEMO/TP                              *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA919 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM HANDLES THE MEMO BILL PROCESS.                **         
      **      * THE MEMO NAME AND ADDRESS ARE POPULATED BY CALLING   **         
      **        SCSCA184.                                            **         
      **      * THE INPUT IS THE RECORDS WITH EXT-MEMO-BILL-FLAG = 'Y'*         
      **  THE MEMO ADDRESS IS OBTAINED BY EXTRACTING THE NAME ID AND **         
      **  ADDRESS ID FROM CSS_CONTACT TABLE FOR CONTACT TYPE AS MB.  **         
      **  THE FREEFORM ADDRESS AND NAME ARE EXTRACTED.               **         
      **                                                             **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
                                                                        
           COPY CFDCA912.                                                       
CISOP  01  E-SRT-IDX-REC                     PIC X(802).                
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA919'.
                                                                        
           COPY CWS09900.                                                       
           COPY CWS00303.                                                       
           COPY CWSCA184.                                                       
PRJ166*** COPYBOOKS FOR WORKING STORAGE FOR SCSCA165********            05704002
PRJ166     COPY CWSCA165.                                                       
PRJ166     COPY CWS00010.                                                       
PRJ166******************************************************            05704002
                                                                        
       01 WS-MST-SUB-ACCT-IND-AT         PIC X(01).                     
       01 WS-CODE-PRNT-BLL-MST-AT        PIC X(01).                     
       01 WS-CODE-TEMP-BILL-AT           PIC X(01).                     
A04127 01 WS-ALOC-ITPA-PROCESS           PIC X(01).                     
       01 WS-SCSCA-RETURN-CODE           PIC S9(4) COMP.                
       01 LS-CURR-WQ-ITEM                PIC S9(4) COMP.                
T35152 01 WS-HOLD-TP-NAME                PIC X(70).                     
T35152                                                                  
T35152 01  WS-11-TABLES.                                                
T35152     05  WS-EMB-INPUT.                                            
T35152         10  WS-EMB-CHAR         PIC X(01)                        
T35152                                 OCCURS 255 TIMES                 
T35152                                 INDEXED BY WS-EMB-INDX.          
T35152     05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.           
T35152     05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.           
T35152     05  WS-EMB-LAST-CHAR        PIC X(01).                       
T35152     05  WS-CMP-TABLE.                                            
T35152         10  WS-CMP-CHAR         PIC X(01)                        
T35152                                 OCCURS 255 TIMES                 
T35152                                 INDEXED BY WS-CMP-INDX.          
T35152                                                                  
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF         PIC S9(04)  COMP.          
               10  WS-PRIORITY-WF            PIC X(1).                  
               10  WS-ROUTE-CATEGORY-WF      PIC X(01).                 
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF    PIC S9(04)  COMP.          
                   15  WS-COMMENTS-TEXT-WF   PIC X(250).                
               10  FILLER                    PIC X(244).                
T35152*                                                                 00040600
T35152 01  WS-THD-PRTY-DETAILS.                                         
T35152     10  WS-TP-NAME                   PIC X(70).                  
T35152     10  WS-THD-PRTY-ADDRESS.                                     
T35152         15  WS-TP-ADDR-STREET        PIC X(55).                  
T35152         15  WS-TP-ADDRESS-OVERFLOW   PIC X(35).                  
T35152         15  WS-TP-ADDR-CITY-STATE    PIC X(30).                  
T35152         15  WS-TP-ADDR-ZIP-CODE      PIC X(09).                  
T35152         15  WS-TP-ADDR-COUNTRY       PIC X(35).                  
T35152         15  WS-TP-ADDR-USPS-DELPT-CD PIC X(02).                  
T35152         15  WS-TP-VALIDATION-TS      PIC X(26).                  
                                                                        
       01  WS-NAME-ADDR-TABLE.                                          
           05  WS-NAME-ADDR-ENTRY         OCCURS 6                      
                                         INDEXED BY WS-NM-ADDR-INDX.    
               10 WS-NAME-ADDR-TYPE          PIC X(02).                 
               10 WS-NAME-ADDR-LINE          PIC X(50).                 
      *                                                                 00293900
       01  WS-MISC.                                                     
T35152     05  WS-TP-MEMO-MATCH-FLAG         PIC X  VALUE ' '.          
T35152         88  TP-MEMO-MATCH                    VALUE 'Y'.          
           05  WS-FIRST-TIME-SW              PIC X  VALUE ' '.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-DATABASE                   PIC 9(1) VALUE ZERO.       
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
           05  WS-CURRENT-DATA.                                         
               10  WS-CURR-NAME              PIC X(50).                 
               10  WS-CURR-ADDR              PIC X(50).                 
               10  WS-CURR-OFLO              PIC X(50).                 
               10  WS-CURR-CITY              PIC X(50).                 
               10  WS-CURR-ZIP               PIC X(11).                 
               10  WS-CURR-ACCT              PIC X(13).                 
           05  WS-PREV-DATA.                                            
               10  WS-PREV-NAME              PIC X(50).                 
               10  WS-PREV-ADDR              PIC X(50).                 
               10  WS-PREV-OFLO              PIC X(50).                 
               10  WS-PREV-CITY              PIC X(50).                 
               10  WS-PREV-ZIP               PIC X(11).                 
               10  WS-PREV-ACCT              PIC X(13).                 
           05  WS-HOLD-ADDR-LINES.                                      
               10  WS-HOLD-ADDR-LINE         PIC X(50) OCCURS 6.        
           05  WS-MAIL-ADDR-LINES.                                      
               10  WS-MAIL-ADDR-LINE-1       PIC X(50).                 
               10  WS-MAIL-ADDR-LINE-2       PIC X(50).                 
               10  WS-MAIL-ADDR-LINE-3       PIC X(50).                 
               10  WS-MAIL-ADDR-LINE-4       PIC X(50).                 
               10  WS-MAIL-ADDR-LINE-5       PIC X(50).                 
               10  WS-MAIL-ADDR-LINE-6       PIC X(50).                 
           05  WS-DISPLAY-SCSCA              PIC X(8).                  
           05  WS-DISPLAY-SQLCODE            PIC -ZZZZZZZZ9.            
           05  WS-HOLD-SRT-IDX-DATA          PIC X(802) VALUE SPACES.   
           05  FILLER REDEFINES WS-HOLD-SRT-IDX-DATA.                   
               10 FILLER                     PIC X(381).                
               10 WS-HOLD-MARKS.                                        
                  15 WS-HOLD-INSERT-MARKS    PIC X(1) OCCURS 12 TIMES.  
               10 FILLER                     PIC X(409).                
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY           PIC 9(04).                 
               10  WS-CURRENT-MM             PIC 9(02).                 
               10  WS-CURRENT-DD             PIC 9(02).                 
               10  WS-CURRENT-HH             PIC 9(02).                 
               10  WS-CURRENT-MS             PIC 9(02).                 
               10  WS-CURRENT-SS             PIC 9(02).                 
T35152     05  WS-SUB                        PIC 9(01)  VALUE ZEROS.    
T35152     05  WS-SUB1                       PIC 9(01)  VALUE ZEROS.    
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
PRJ166     05  WS-OK-TO-PROCESS-FL            PIC X(1)  VALUE 'N'.      
PRJ166         88 PROCESS-OK-YES                        VALUE 'Y'.      
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA919'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA919'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-MB                       PIC X(02) VALUE 'MB'.        
T35152     05  WS-TP                       PIC X(02) VALUE 'TP'.        
P00836     05  WS-FT                       PIC X(02) VALUE 'FT'.        
P00836     05  WS-FM                       PIC X(02) VALUE 'FM'.        
                                                                        
       01  WS-BLANK-LINE                   PIC X(132) VALUE SPACES.     
       01  WS-NO-DATA-LINE                 PIC X(132) VALUE             
           '               NO DATA THIS RUN.                     '.     
      *****************************************************************         
      *  DCLGEN FOR CSS_CONTACT                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCNTACT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  DCLGEN FOR CSS_CONTACT_ACCT                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCNTCAT                                                 
           END-EXEC.                                                            
                                                                        
T35152*****************************************************************         
T35152*  DCLGEN FOR CSS_THD_PRTY ZW                                   *         
T35152*****************************************************************         
T35152     EXEC SQL                                                             
T35152         INCLUDE TBTHDPTY                                                 
T35152     END-EXEC.                                                            
T35152                                                                  
T35152*****************************************************************         
T35152*  DCLGEN FOR CSS_DELINQUENCY C8                                *         
T35152*****************************************************************         
T35152     EXEC SQL                                                             
T35152         INCLUDE TBDELQ                                                   
T35152     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  DCLGEN FOR SQL PROCESSING                                    *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE NAME_ADDR_ID CURSOR FOR                          
                   SELECT CV.NAME_ID                                    
                         ,CV.ADDRESS_ID                                 
                     FROM CSS_CONTACT CV WITH(READUNCOMMITTED)                  
                         ,CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED)             
                    WHERE DW.CONTACT_ID = CV.CONTACT_ID                 
P00740                AND   (CV.CONTACT_TYPE = 'MB'                     
P00740                    OR CV.MEMO_BILL_IND = 'Y')                    
                      AND DW.ACCOUNT_NO = :DW-ACCOUNT-NO                
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE NAME_ADDR_ID CURSOR FOR                                  
MFA-TR*            SELECT CV.NAME_ID                                            
MFA-TR*                  ,CV.ADDRESS_ID                                         
MFA-TR*              FROM CSS_CONTACT CV                                        
MFA-TR*                  ,CSS_CONTACT_ACCT DW                                   
MFA-TR*             WHERE DW.CONTACT_ID = CV.CONTACT_ID                         
MFA-TR*               AND   (CV.CONTACT_TYPE = 'MB'                             
MFA-TR*                   OR CV.MEMO_BILL_IND = 'Y')                            
MFA-TR*               AND DW.ACCOUNT_NO = :DW-ACCOUNT-NO                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
T35152                                                                  
T35152     EXEC SQL                                                     
T35152         DECLARE THIRD_PARTY CURSOR FOR                           
T35152             SELECT ZW.NAME_ID                                    
T35152                   ,ZW.ADDRESS_ID                                 
T35152               FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                 
T35152              WHERE ZW.ACCOUNT_NO = :ZW-ACCOUNT-NO                
T35152                AND ZW.THD_PRTY_STATUS = 'A'                      
T35152           FOR READ ONLY                                  
T35152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE THIRD_PARTY CURSOR FOR                                   
MFA-TR*            SELECT ZW.NAME_ID                                            
MFA-TR*                  ,ZW.ADDRESS_ID                                         
MFA-TR*              FROM CSS_THD_PRTY ZW                                       
MFA-TR*             WHERE ZW.ACCOUNT_NO = :ZW-ACCOUNT-NO                        
MFA-TR*               AND ZW.THD_PRTY_STATUS = 'A'                              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
T35152                                                                  
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  MAIN PROCESS AREA.                                           *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT.                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  GET DATES, TIMES, TITLES FOR REPORT HEADERS.    *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE SPACES                             TO WS-PREV-DATA.     
           MOVE SPACES                             TO WS-CURRENT-DATA.  
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                       TO WS-CURRENT-DATE.              
           OPEN INPUT  FCSCA911-FILE                                    
                OUTPUT FCSCA912-FILE.                                   
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911'                    
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *   IF MAILING NAME AND ADDRESS MATCH, DETERMINE NUMBER OF *              
      *   BILLS INTO THE ENVELOPE AND WRITE TO THE CA912 OUTPUT  *              
      *   FILE.  IF MORE THAT ONE BILL GOES TO THE ADDRESS, WRITE*              
      *   A MULTIPLE BILLS REPORT LINE.                          *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7900-READ-FCSCA911              THRU 7900-EXIT.      
           SET FIRST-TIME                          TO TRUE.             
PRJ166     INITIALIZE                        WS-CA165-CALLING-FIELDS.   
           PERFORM 2000-PROCESS-MEMO-ADDRESS       THRU 2000-EXIT       
                                              UNTIL END-OF-CA911.       
PRJ166     MOVE  'Y'                               TO                   
PRJ166                                       WS-CA165IN-END-OF-PROG-FL. 
PRJ166     MOVE 'BLLPRT'                           TO                   
PRJ166                                             WS-CA165IN-CORR-TYPE.
PRJ166     IF PROCESS-OK-YES                                            
PRJ166        PERFORM 2400-CALL-SCSCA165           THRU 2400-EXIT       
PRJ166     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS THE DATA & LOADS THE INDIVIDUAL ADDRESS    *         
      *  FIELDS FOR AN ACCOUNT.                                       *         
      *****************************************************************         
                                                                        
       2000-PROCESS-MEMO-ADDRESS.                                       
                                                                        
           MOVE EXT-SORTIDX-FILE                   TO                   
                                              WS-HOLD-SRT-IDX-DATA.     
T35152     IF FIRST-TIME                                                
T35152        MOVE 'DATABASE'                      TO C8-DELINQ-CD      
T35152        IF EXT-SRT-COMPANY-NO IS NUMERIC                          
T35152           MOVE EXT-SRT-COMPANY-NO           TO C8-COMPANY-NO     
T35152        ELSE                                                      
T35152           MOVE '01'                         TO C8-COMPANY-NO     
T35152        END-IF                                                    
T35152        PERFORM 7300-GET-DELINQUECY          THRU 7300-EXIT       
T35152        MOVE C8-DELINQ-VALUE                 TO WS-DATABASE       
T35152        INITIALIZE WS-FIRST-TIME-SW                               
T35152     END-IF.                                                      
T35152                                                                  
T35152     IF EXT-BILL-FIRST-NOTICE-FLAG = 'Y' AND CSR-DATABASE         
T35152        PERFORM 2025-PROCESS-THIRD-PARTY      THRU 2025-EXIT      
T35152     END-IF.                                                      
T35152                                                                  
T35152     IF EXT-BILL-MEMO-FLAG = 'Y' OR SEB-DATABASE                  
T35152        PERFORM 2050-PROCESS-MEMO-BILL        THRU 2050-EXIT      
T35152     END-IF.                                                      
T35152                                                                  
           INITIALIZE  WS-CURRENT-DATA                                  
T37389                 WS-HOLD-TP-NAME.                                 
           PERFORM 7900-READ-FCSCA911              THRU 7900-EXIT.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
T35152                                                                  
T35152*****************************************************************         
T35152*  THIS ROUTINE WILL PROCESS THIRD PARTY LOGIC.                 *         
T35152*****************************************************************         
T35152                                                                  
T35152 2025-PROCESS-THIRD-PARTY.                                        
T35152                                                                  
T35152     MOVE EXT-ACCT-ACCOUNT-NO             TO WS-CURR-ACCT         
T35152                                             ZW-ACCOUNT-NO.       
PRJ166     MOVE  'T'                            TO                      
PRJ166                                      WS-CA165IN-TP-MEMO-PROCESS. 
T35152     PERFORM 7400-OPEN-THIRD-PARTY         THRU 7400-EXIT.        
T35152     PERFORM 7500-FETCH-THIRD-PARTY        THRU 7500-EXIT.        
T35152     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T35152         MOVE ZW-ADDRESS-ID            TO WS-ADDRESS-ID-AS        
T35152                                          WS-TP-ADDRESS-ID        
T35152         MOVE ZW-NAME-ID               TO WS-NAME-ID-AS           
T35152                                          WS-TP-NAME-ID           
T35152         MOVE 'T'                      TO WS-ADDRESS-FLAG         
T35152         DISPLAY 'CALL SCSCA184 TO GET THIRD PARTY ADDRESS FOR '  
T35152                  EXT-ACCT-ACCOUNT-NO                             
T37389         PERFORM 2100-GET-NAME-ADDR        THRU 2100-EXIT         
T35152         PERFORM 5200-FORMAT-THIRD-PARTY   THRU 5200-EXIT         
T35152         PERFORM 5100-FORMAT-OMR-MARKS     THRU 5100-EXIT         
PRJ166         PERFORM 2300-GET-UNIQ-IDENTIFIER  THRU 2300-EXIT         
T35152         PERFORM 8000-WRITE-SORT-IDX       THRU 8000-EXIT         
T35152         PERFORM 7500-FETCH-THIRD-PARTY    THRU 7500-EXIT         
T35152     END-PERFORM.                                                 
T35152     PERFORM 7600-CLOSE-THIRD-PARTY        THRU 7600-EXIT.        
T35152                                                                  
T35152 2025-EXIT.                                                       
T35152     EXIT.                                                        
                                                                        
T35152*****************************************************************         
T35152*  THIS ROUTINE WILL PROCESS MEMO BILL ADDRESS.                 *         
T35152*****************************************************************         
T35152                                                                  
T35152 2050-PROCESS-MEMO-BILL.                                          
T35152                                                                  
T35152     MOVE EXT-ACCT-ACCOUNT-NO             TO WS-CURR-ACCT         
T35152                                             DW-ACCOUNT-NO.       
PRJ166     MOVE  'M'                            TO                      
PRJ166                                      WS-CA165IN-TP-MEMO-PROCESS. 
T35152     PERFORM 7000-OPEN-NAME-ADDR-ID        THRU 7000-EXIT.        
T35152     PERFORM 7100-FETCH-NAME-ADDR-ID       THRU 7100-EXIT.        
T35152     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T35152         MOVE CV-ADDRESS-ID            TO WS-ADDRESS-ID-AS        
T35152         MOVE CV-NAME-ID               TO WS-NAME-ID-AS           
T35152         MOVE 'M'                      TO WS-ADDRESS-FLAG         
T35152         DISPLAY 'CALL SCSCA184 TO GET MEMO BILL ADDRESS FOR '    
T35152                 EXT-ACCT-ACCOUNT-NO                              
T37389         PERFORM 2100-GET-NAME-ADDR        THRU 2100-EXIT         
T35152         MOVE 'N'                      TO WS-TP-MEMO-MATCH-FLAG   
T37389         IF WS-HOLD-TP-NAME > SPACES                              
T35152            PERFORM 2200-CHECK-MEMO-MATCH  THRU 2200-EXIT         
T37389         END-IF                                                   
T35152         IF NOT TP-MEMO-MATCH                                     
T35152            PERFORM 5000-FORMAT-MEMO-ADDR  THRU 5000-EXIT         
T35152            PERFORM 5100-FORMAT-OMR-MARKS  THRU 5100-EXIT         
PRJ166            PERFORM 2300-GET-UNIQ-IDENTIFIER                      
PRJ166                                           THRU 2300-EXIT         
T35152            PERFORM 8000-WRITE-SORT-IDX    THRU 8000-EXIT         
T35152         END-IF                                                   
T35152         PERFORM 7100-FETCH-NAME-ADDR-ID   THRU 7100-EXIT         
T35152     END-PERFORM.                                                 
T35152     PERFORM 7200-CLOSE-NAME-ADDR-ID       THRU 7200-EXIT.        
T35152                                                                  
T35152 2050-EXIT.                                                       
T35152     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE WILL CALL SCSCA184 TO OBTAIN MAIL NAME ADDRESS. *         
      *****************************************************************         
                                                                        
T37389 2100-GET-NAME-ADDR.                                              
                                                                        
           INITIALIZE WS-NAME-ADDR-TABLE.                               
           MOVE EXT-ACCT-ACCOUNT-NO      TO WS-ACCOUNT-NO-AS.           
           MOVE EXT-BILL-CUSTOMER-NO     TO WS-CUSTOMER-NO-AS.          
                                                                        
           DISPLAY 'CALLING SCSCA184 FROM PCSCA919'.                    
                                                                        
           CALL 'SCSCA184' USING WS-SCSCA184-PARMS                      
                               WS-MST-SUB-ACCT-IND-AT                   
                               WS-CODE-PRNT-BLL-MST-AT                  
                               WS-CODE-TEMP-BILL-AT                     
                               WS-SCSCA-RETURN-CODE                     
                               LS-CURR-WQ-ITEM                          
                               WS-BILLING-WQ-ITEMS-WF                   
A04127                         WS-ALOC-ITPA-PROCESS.                    
                                                                        
           MOVE 'SCSCA184'               TO WS-DISPLAY-SCSCA.           
                                                                        
            IF WS-SCSCA-RETURN-CODE NOT = 0                             
               PERFORM 9200-SCSCA-ERROR   THRU 9200-EXIT                
            END-IF.                                                     
                                                                        
            MOVE WS-NAME-ADDRESS-TABLE   TO WS-NAME-ADDR-TABLE.         
T35152      MOVE WS-TP-ADDRESS           TO WS-THD-PRTY-DETAILS.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T35152************************************************************              
T35152*  CHECK IF THE MEMO NAME AND THIRD PARTY NAME IS THE SAME *              
T35152*  IF THEY ARE THE SAME DO NOT WRITE A ROW FOR MEMO BILL   *              
T35152************************************************************              
T35152 2200-CHECK-MEMO-MATCH.                                           
T35152                                                                  
T35152     IF WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-1                    
T35152     OR WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-2                    
T35152     OR WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-3                    
T35152     OR WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-4                    
T35152     OR WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-5                    
T35152     OR WS-HOLD-TP-NAME = EXT-ACCT-MAIL-LINE-6                    
T35152        MOVE 'Y'                   TO WS-TP-MEMO-MATCH-FLAG       
T35152     END-IF.                                                      
T35152                                                                  
T35152 2200-EXIT.                                                       
T35152     EXIT.                                                        
PRJ166************************************************************              
PRJ166* CALLS PROGRAM SCSCA165 TO GET MARKETING CORRESPONDENCE   *              
PRJ166* UNIQUE IDENTIFIER                                        *              
PRJ166************************************************************              
PRJ166 2300-GET-UNIQ-IDENTIFIER.                                        
                                                                        
           MOVE 'BLLPRT'                 TO  WS-CA165IN-CORR-TYPE.      
           MOVE EXT-ACCT-ACCOUNT-NO      TO  WS-CA165IN-ACCOUNT-NO.     
           MOVE EXT-ACCT-BILL-DATE       TO  WS-CA165IN-PROCESS-DATE.   
           MOVE WS-DATABASE              TO  WS-CA165IN-DATABASE.       
           MOVE EXT-SRT-COMPANY-NO       TO  WS-CA165IN-COMPANY-NO.     
           MOVE EXT-ACCT-LOCAL-OFFICE    TO  WS-CA165IN-LOCAL-OFFICE.   
           MOVE EXT-ACCT-REGULATED-CD    TO  WS-CA165IN-REG-GROUP-CD.   
PRJ166     MOVE  'N'                     TO  WS-CA165IN-END-OF-PROG-FL  
                                             WS-CA165IN-UPDATE-SEQ-FL.  
           MOVE  WS-PGRMNAME             TO  WS-CA165IN-APPL-PROGRAM-ID.
                                                                        
           PERFORM 2400-CALL-SCSCA165    THRU 2400-EXIT.                
           MOVE WS-CA165OUT-UNIQ-ID      TO EXT-BILL-BARCODE-UNIQUE-ID. 
           MOVE WS-CA165OUT-CUR-STATUS   TO EXT-BILL-TRACKING-STATUS-CD.
           MOVE WS-CA165IN-OK-TO-PROCESS TO WS-OK-TO-PROCESS-FL.        
                                                                        
PRJ166 2300-EXIT.                                                       
PRJ166     EXIT.                                                        
PRJ166                                                                  
PRJ166************************************************************      16440000
PRJ166*  CALL SCSCA165 TO GET UNIQUE IDENTIFIER                  *      16441000
PRJ166************************************************************      16442000
PRJ166 2400-CALL-SCSCA165.                                              
PRJ166                                                                  
           DISPLAY 'CALL SCSCA165 FROM PCSCA919'.                       
           CALL  'SCSCA165'            USING WS-SCSCA165-PARMS,         
                                                WS-CA165-MISC,          
                                                ABEND-FILE,             
                                                WS-SCSCA-RETURN-CODE    
                                                                        
           MOVE 'SCSCA165'                   TO WS-DISPLAY-SCSCA.       
                                                                        
           IF WS-SCSCA-RETURN-CODE        NOT = 0                       
              PERFORM 9200-SCSCA-ERROR   THRU   9200-EXIT               
           END-IF.                                                      
PRJ166                                                                  
PRJ166 2400-EXIT.                                                       
PRJ166     EXIT.                                                        
PRJ166                                                                  
      ************************************************************              
      *  FORMATS THE MEMO ADDRESS MOVING THE SPACES TO BACK      *              
      ************************************************************              
       5000-FORMAT-MEMO-ADDR.                                           
                                                                        
T35152     MOVE 1                        TO WS-SUB1.                    
T35152     PERFORM UNTIL WS-SUB1 > 6                                    
T35152       IF WS-NAME-ADDR-LINE (6) <= SPACES                         
T35152           MOVE WS-NAME-ADDR-ENTRY (5) TO                         
T35152                WS-NAME-ADDR-ENTRY (6)                            
T35152           MOVE WS-NAME-ADDR-ENTRY (4) TO                         
T35152                WS-NAME-ADDR-ENTRY (5)                            
T35152           MOVE WS-NAME-ADDR-ENTRY (3) TO                         
T35152                WS-NAME-ADDR-ENTRY (4)                            
T35152           MOVE WS-NAME-ADDR-ENTRY (2) TO                         
T35152                WS-NAME-ADDR-ENTRY (3)                            
T35152           MOVE WS-NAME-ADDR-ENTRY (1) TO                         
T35152                WS-NAME-ADDR-ENTRY (2)                            
T35152           MOVE SPACES TO WS-NAME-ADDR-ENTRY (1)                  
T35152        END-IF                                                    
T35152        ADD 1 TO WS-SUB1                                          
T35152     END-PERFORM.                                                 
                                                                        
           MOVE WS-NAME-ADDR-TYPE (1)    TO EXT-ACCT-MAIL-TYPE-1.       
           MOVE WS-NAME-ADDR-TYPE (2)    TO EXT-ACCT-MAIL-TYPE-2.       
           MOVE WS-NAME-ADDR-TYPE (3)    TO EXT-ACCT-MAIL-TYPE-3.       
           MOVE WS-NAME-ADDR-TYPE (4)    TO EXT-ACCT-MAIL-TYPE-4.       
           MOVE WS-NAME-ADDR-TYPE (5)    TO EXT-ACCT-MAIL-TYPE-5.       
           MOVE WS-NAME-ADDR-TYPE (6)    TO EXT-ACCT-MAIL-TYPE-6.       
                                                                        
           MOVE WS-NAME-ADDR-LINE (1)    TO EXT-ACCT-MAIL-LINE-1.       
           MOVE WS-NAME-ADDR-LINE (2)    TO EXT-ACCT-MAIL-LINE-2.       
           MOVE WS-NAME-ADDR-LINE (3)    TO EXT-ACCT-MAIL-LINE-3.       
           MOVE WS-NAME-ADDR-LINE (4)    TO EXT-ACCT-MAIL-LINE-4.       
           MOVE WS-NAME-ADDR-LINE (5)    TO EXT-ACCT-MAIL-LINE-5.       
           MOVE WS-NAME-ADDR-LINE (6)    TO EXT-ACCT-MAIL-LINE-6.       
                                                                        
           MOVE WS-BARCODE-ZIP           TO EXT-ACCT-BARCODE-ZIP.       
A00747     MOVE WS-BARCODE-ZIP           TO EXT-ACCT-ZIPCODE.           
A00747     MOVE WS-BARCODE-ZIP (6:4)     TO EXT-ACCT-ZIP-PLUS-FOUR.     
P00836     IF EXT-BILL-BILL-TYPE = 'FB'                                 
P00836        MOVE WS-FM                 TO EXT-BILL-BILL-TYPE          
P00836     ELSE                                                         
P00836        MOVE WS-MB                 TO EXT-BILL-BILL-TYPE          
P00836     END-IF.                                                      
A00747     MOVE 001                      TO EXT-BILL-NO-BILL-COPIES.    
A00747     MOVE ZERO                     TO EXT-SRT-SEQUENCE-NO.        
P00836     MOVE '06'                     TO EXT-BILL-COMM-TYPE-CD.      
P00836     MOVE '45'                     TO EXT-BILL-COMM-SUB-TYPE-CODE.
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  FORMAT OMR MARKS.                                       *              
      *  MOVE 0 TO OMR-MARKS 4 THRU 8 & 1,0,1 TO OMR-MARKS 1,2&3 *              
      ************************************************************              
       5100-FORMAT-OMR-MARKS.                                           
                                                                        
           MOVE '1'                 TO EXT-ACCT-OMR-MARK-1.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-2.             
T37389     MOVE '0'                 TO EXT-ACCT-OMR-MARK-3.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-4.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-5.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-6.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-7.             
           MOVE '0'                 TO EXT-ACCT-OMR-MARK-8.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
T35152                                                                  
T35152************************************************************              
T35152*  FORMATS THE THIRD PARTY ADDRESS                         *              
T35152************************************************************              
T35152 5200-FORMAT-THIRD-PARTY.                                         
T35152                                                                  
T35152     INITIALIZE                  WS-MAIL-ADDR-LINES.              
T35152     MOVE WS-TP-NAME               TO  WS-MAIL-ADDR-LINE-1        
T37389                                       WS-HOLD-TP-NAME.           
T35152     INITIALIZE                        WS-MAIL-ADDR-LINE-2        
T35152                                       WS-EMB-INPUT.              
T35152     STRING                            WS-TP-ADDR-STREET          
T35152                                       ' '                        
T35152                                       WS-TP-ADDRESS-OVERFLOW     
T35152                                       DELIMITED BY SIZE INTO     
T35152                                       WS-EMB-INPUT.              
T35152     MOVE SPACES                   TO WS-CMP-TABLE.               
T35152     MOVE 90                       TO WS-EMB-LENG.                
T35152     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
T35152     MOVE WS-CMP-TABLE             TO  WS-MAIL-ADDR-LINE-2.       
T35152                                                                  
T35152     MOVE SPACES                   TO WS-EMB-INPUT.               
T35152     STRING                         WS-TP-ADDR-CITY-STATE         
T35152                                    ' '                           
T35152                                    WS-TP-ADDR-ZIP-CODE(1:5)      
T35152                                    '-'                           
T35152                                    WS-TP-ADDR-ZIP-CODE(6:4)      
T35152                                    DELIMITED BY SIZE INTO        
T35152                                    WS-EMB-INPUT.                 
T35152     IF WS-TP-ADDR-ZIP-CODE(6:4) = SPACES                         
T35152        INITIALIZE                  WS-EMB-INPUT                  
T35152        STRING                      WS-TP-ADDR-CITY-STATE         
T35152                                    ' '                           
T35152                                    WS-TP-ADDR-ZIP-CODE(1:5)      
T35152                                    DELIMITED BY SIZE INTO        
T35152                                    WS-EMB-INPUT                  
T35152     END-IF.                                                      
T35152     MOVE SPACES                   TO WS-CMP-TABLE.               
T35152     MOVE 41                       TO WS-EMB-LENG.                
T35152     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
T35152     INITIALIZE                     WS-MAIL-ADDR-LINE-3.          
T35152     MOVE WS-CMP-TABLE             TO WS-MAIL-ADDR-LINE-3         
T35152     MOVE WS-TP-ADDR-COUNTRY       TO WS-MAIL-ADDR-LINE-4         
T35152     MOVE WS-MAIL-ADDR-LINES       TO WS-HOLD-ADDR-LINES.         
T35152     MOVE 1                        TO WS-SUB1.                    
T35152     PERFORM UNTIL WS-SUB1 > 6                                    
T35152       IF WS-HOLD-ADDR-LINE (6) <= SPACES                         
T35152           MOVE WS-HOLD-ADDR-LINE (5) TO                          
T35152                WS-HOLD-ADDR-LINE (6)                             
T35152           MOVE WS-HOLD-ADDR-LINE (4) TO                          
T35152                WS-HOLD-ADDR-LINE (5)                             
T35152           MOVE WS-HOLD-ADDR-LINE (3) TO                          
T35152                WS-HOLD-ADDR-LINE (4)                             
T35152           MOVE WS-HOLD-ADDR-LINE (2) TO                          
T35152                WS-HOLD-ADDR-LINE (3)                             
T35152           MOVE WS-HOLD-ADDR-LINE (1) TO                          
T35152                WS-HOLD-ADDR-LINE (2)                             
T35152           MOVE SPACES TO WS-HOLD-ADDR-LINE (1)                   
T35152        END-IF                                                    
T35152        ADD 1 TO WS-SUB1                                          
T35152     END-PERFORM.                                                 
T35152                                                                  
T35152     MOVE WS-HOLD-ADDR-LINE(1)     TO EXT-ACCT-MAIL-LINE-1.       
T35152     MOVE WS-HOLD-ADDR-LINE(2)     TO EXT-ACCT-MAIL-LINE-2.       
T35152     MOVE WS-HOLD-ADDR-LINE(3)     TO EXT-ACCT-MAIL-LINE-3        
T35152     MOVE WS-HOLD-ADDR-LINE(4)     TO EXT-ACCT-MAIL-LINE-4.       
T35152     MOVE WS-HOLD-ADDR-LINE(5)     TO EXT-ACCT-MAIL-LINE-5.       
T35152     MOVE WS-HOLD-ADDR-LINE(6)     TO EXT-ACCT-MAIL-LINE-6.       
T35152                                                                  
T35152     MOVE WS-TP-BARCODE-ZIP        TO EXT-ACCT-BARCODE-ZIP.       
A00747     MOVE WS-TP-BARCODE-ZIP        TO EXT-ACCT-ZIPCODE.           
A00747     MOVE WS-TP-BARCODE-ZIP (6:4)  TO EXT-ACCT-ZIP-PLUS-FOUR.     
P00836     IF EXT-BILL-BILL-TYPE = 'FB'                                 
P00836        MOVE WS-FT                 TO EXT-BILL-BILL-TYPE          
P00836     ELSE                                                         
P00836        MOVE WS-TP                 TO EXT-BILL-BILL-TYPE          
P00836     END-IF.                                                      
A00747     MOVE 001                      TO EXT-BILL-NO-BILL-COPIES.    
A00747     MOVE ZERO                     TO EXT-SRT-SEQUENCE-NO.        
P00836     MOVE '06'                     TO EXT-BILL-COMM-TYPE-CD.      
P00836     MOVE '44'                     TO EXT-BILL-COMM-SUB-TYPE-CODE.
T35152                                                                  
T35152 5200-EXIT.                                                       
T35152     EXIT.                                                        
T35152                                                                  
T35152************************************************************      17949000
T35152*  6010-REDUCE-EMBEDDED-SPACES                             *      17950000
T35152************************************************************      17951000
T35152                                                                  
T35152 COPY CPD00004.                                                   17953000
                                                                        
      ************************************************************              
      *  OPEN NAME_ADDR_ID CURSOR                                *              
      ************************************************************              
       7000-OPEN-NAME-ADDR-ID.                                          
                                                                        
           EXEC SQL                                                     
               OPEN NAME_ADDR_ID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
                                     WS-DISPLAY-SQLCODE.                
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY ' 7000-OPEN-NAME-ADDR-ID    '                     
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE - 1 CSS_CONTACT      '                 
              DISPLAY ' ** TABLE - 2 CSS_CONTACT_ACCT '                 
              DISPLAY ' ** ACCOUNT_NO        ' DW-ACCOUNT-NO            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  FETCH NAME_ADDR_ID CURSOR                               *              
      ************************************************************              
       7100-FETCH-NAME-ADDR-ID.                                         
                                                                        
           EXEC SQL                                                     
               FETCH NAME_ADDR_ID                                       
                INTO :CV-NAME-ID                                        
                    ,:CV-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
                                     WS-DISPLAY-SQLCODE.                
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY ' 7100-FETCH-NAME-ADDR-ID   '                
                   DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
                   DISPLAY ' ** ERROR ON FETCH  '                       
                   DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
                   DISPLAY ' ** TABLE - 1 CSS_CONTACT      '            
                   DISPLAY ' ** TABLE - 2 CSS_CONTACT_ACCT '            
                   DISPLAY ' ** ACCOUNT_NO        ' DW-ACCOUNT-NO       
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  CLOSE NAME_ADDR_ID CURSOR                               *              
      ************************************************************              
       7200-CLOSE-NAME-ADDR-ID.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE NAME_ADDR_ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
                                     WS-DISPLAY-SQLCODE.                
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY ' 7200-CLOSE-NAME-ADDR-ID   '                
                   DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
                   DISPLAY ' ** ERROR ON FETCH  '                       
                   DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
                   DISPLAY ' ** TABLE - 1 CSS_CONTACT      '            
                   DISPLAY ' ** TABLE - 2 CSS_CONTACT_ACCT '            
                   DISPLAY ' ** ACCOUNT_NO        ' DW-ACCOUNT-NO       
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
T35152                                                                  
T35152************************************************************              
T35152*  SELECT  CSS_DELINQUENCY TO GET DATABASE                 *              
T35152************************************************************              
T35152 7300-GET-DELINQUECY.                                             
T35152                                                                  
T35152     EXEC SQL                                                     
T35152          SELECT DELINQ_VALUE                                     
T35152            INTO :C8-DELINQ-VALUE                                 
T35152            FROM CSS_DELINQUENCY                                  
T35152           WHERE DELINQ_CD = :C8-DELINQ-CD                        
T35152             AND COMPANY_NO = :C8-COMPANY-NO                      
T35152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

T35152                                                                  
T35152     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
T35152                               WS-DISPLAY-SQLCODE.                
T35152                                                                  
T35152     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35152         WHEN SUCCESSFUL-CALL                                     
T35152             CONTINUE                                             
T35152         WHEN OTHER                                               
T35152             DISPLAY ' 7300-GET-DELINQUECY       '                
T35152             DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
T35152             DISPLAY ' ** ERROR ON SELECT '                       
T35152             DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
T35152             DISPLAY ' ** TABLE - 1 CSS_DELINQUENCY  '            
T35152             DISPLAY ' ** DELINQ_CD   '  C8-DELINQ-CD             
T35152             DISPLAY ' ** COMPANY_NO  '  C8-COMPANY-NO            
T35152             PERFORM 9900-ABEND THRU 9900-EXIT                    
T35152     END-EVALUATE.                                                
T35152                                                                  
T35152 7300-EXIT.                                                       
T35152     EXIT.                                                        
T35152                                                                  
T35152************************************************************              
T35152*  OPEN THIRD_PARTY CURSOR                                 *              
T35152************************************************************              
T35152 7400-OPEN-THIRD-PARTY.                                           
T35152                                                                  
T35152     EXEC SQL                                                     
T35152         OPEN THIRD_PARTY                                         
T35152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

T35152                                                                  
T35152     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
T35152                               WS-DISPLAY-SQLCODE.                
T35152     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
T35152        DISPLAY ' 7400-OPEN-THIRD-PARTY '                         
T35152        DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
T35152        DISPLAY ' ** ERROR ON OPEN   '                            
T35152        DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
T35152        DISPLAY ' ** TABLE - 1 CSS_THD_PTY      '                 
T35152        DISPLAY ' ** ACCOUNT_NO        ' ZW-ACCOUNT-NO            
T35152        PERFORM 9900-ABEND THRU 9900-EXIT                         
T35152     END-IF.                                                      
T35152                                                                  
T35152 7400-EXIT.                                                       
T35152     EXIT.                                                        
T35152*                                                                         
T35152************************************************************              
T35152*  FETCH THIRD_PARTY CURSOR                                *              
T35152************************************************************              
T35152 7500-FETCH-THIRD-PARTY.                                          
T35152                                                                  
T35152     EXEC SQL                                                     
T35152         FETCH THIRD_PARTY                                        
T35152          INTO :ZW-NAME-ID                                        
T35152              ,:ZW-ADDRESS-ID                                     
T35152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

T35152                                                                  
T35152     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
T35152                               WS-DISPLAY-SQLCODE.                
T35152     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35152         WHEN SUCCESSFUL-CALL                                     
T35152         WHEN NOT-FOUND                                           
T35152             CONTINUE                                             
T35152         WHEN OTHER                                               
T35152             DISPLAY ' 7500-FETCH-THIRD-PARTY '                   
T35152             DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
T35152             DISPLAY ' ** ERROR ON FETCH  '                       
T35152             DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
T35152             DISPLAY ' ** TABLE - 1 CSS_THD_PTY      '            
T35152             DISPLAY ' ** ACCOUNT_NO        ' ZW-ACCOUNT-NO       
T35152             PERFORM 9900-ABEND THRU 9900-EXIT                    
T35152     END-EVALUATE.                                                
T35152                                                                  
T35152 7500-EXIT.                                                       
T35152     EXIT.                                                        
T35152*                                                                         
T35152************************************************************              
T35152*  CLOSE THIRD_PARTY CURSOR                                *              
T35152************************************************************              
T35152 7600-CLOSE-THIRD-PARTY.                                          
T35152                                                                  
T35152     EXEC SQL                                                     
T35152         CLOSE THIRD_PARTY                                        
T35152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

T35152                                                                  
T35152     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
T35152                               WS-DISPLAY-SQLCODE.                
T35152     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35152         WHEN SUCCESSFUL-CALL                                     
T35152             CONTINUE                                             
T35152         WHEN OTHER                                               
T35152             DISPLAY ' 7600-CLOSE-THIRD-PARTY'                    
T35152             DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
T35152             DISPLAY ' ** ERROR ON FETCH  '                       
T35152             DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
T35152             DISPLAY ' ** TABLE - 1 CSS_THD_PRTY     '            
T35152             DISPLAY ' ** ACCOUNT_NO        ' ZW-ACCOUNT-NO       
T35152             PERFORM 9900-ABEND THRU 9900-EXIT                    
T35152     END-EVALUATE.                                                
T35152                                                                  
T35152 7600-EXIT.                                                       
T35152     EXIT.                                                        
      ************************************************************              
      *  READ THE INPUT FILE                                     *              
      ************************************************************              
                                                                        
       7900-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL OR END-OF-CA911                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA919 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      17189000
      *  CALL AFAPLINT TO WRITE THE BE28 OUTPUT FILE.            *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           MOVE SPACES                     TO E-SRT-IDX-REC.            
           MOVE EXT-SORTIDX-FILE           TO E-SRT-IDX-REC.            
           WRITE E-SRT-IDX-REC.                                         
                                                                        
           IF CA912-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '      
                        WS-CA912-STATUS                                 
               PERFORM 9000-TERMINATE      THRU 9000-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA911-FILE                                          
                 FCSCA912-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' EXT-ACCT-ACCOUNT-NO.            
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
