       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA917.                                         
      ***************************************************************** 00030000
      *                                                               * 00040000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00050000
      *                       PRICE WATERHOUSE                        * 00060000
      *                                                               * 00070000
      *                 CUSTOMER INFORMATION SYSTEM                   * 00080000
      *                                                               * 00090000
      ***************************************************************** 00100000
      *                 P R O G R A M   S U M M A R Y                 * 00110000
      *             AUDIT PROCESSING FOR MARKETTING LETTERS           * 00120000
      *      CRITERIA: ALL NOTICES WITH UNIQUE RATE PLAN NUMBERS      * 00140000
      ***************************************************************** 00150000
      *                                                               * 00160000
      *               PROGRAM  MODIFICATION  LOG                      * 00170000
      *      DATE    INITIALS     REASON                              * 00180000
      *    ________  ________     __________________________________  * 00190000
      *    05/22/08  RV97439      INITIAL VERSION.                    * 00221000
PRJ211*    12/01/09  ALEX         PRERENEWAL.                         * 00222000
PRJ245*    02/12/09  SDHAL        RATE CHANGE LETTERS.                * 00223000
P00680*    10/03/12  RAJ          FILE LENGTH CHANGE DUE TO FIOCA901  * 00224000
P00805*    03/28/14  DMS          ADD SM COMM RENEWAL LETTER          * 00225000
P00805*    04/09/14  DMS          ADD 25 DAY LETTER FOR PENDING RATE  * 00226000
      ***************************************************************** 00230000
      *                                                               * 00240000
      *         -----    BASIC SEQUENCE STRUCTURE   -----             * 00250000
      * 0000         MODULE CONTROL                                   * 00260000
      * 0100 - 0999  INITIALIZATION                                   * 00270000
      * 1000 - 1999  FUNCTIONAL CONTROL                               * 00280000
      * 2000 - 4999  DETAIL LOGIC                                     * 00290000
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               * 00300000
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     * 00310000
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    * 00320000
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    * 00330000
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          * 00340000
      *                                                               * 00350000
      ***************************************************************** 00360000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00380000
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00400000
       FILE-CONTROL.                                                    
       COPY CSSCA901.                                                   00420000
HPCCDM*    EJECT                                                        00421000
      *                                                                 00430000
           SELECT FCSCA917-FILE                                         
               ASSIGN TO UT-S-FCSCA917                                  
               FILE STATUS IS WS-FCA917-STATUS.                         
HPCCDM*    EJECT                                                        00470000
      *                                                                 00480000
       DATA DIVISION.                                                   
      *                                                                 00500000
       FILE SECTION.                                                    
      *                                                                 00520000
       COPY CFDCA901.                                                   00541000
       COPY FIOCA901.                                                   00542000
      *                                                                 00550000
       COPY CFDCA917.                                                   00551000
       01  CA917-RECORD.                                                
P00680     05  CA917-DATA                   PIC X(3500).                
      *                                                                 00630000
       WORKING-STORAGE SECTION.                                         
       01  WS-MISC.                                                     
           05  WS-AUD-IDX                   PIC 9(05) VALUE ZEROES.     
           05  WS-START                     PIC X(40)                   
           VALUE 'WORKING STORAGE FOR PCSCA917 STARTS HERE'.            
           05  WS-EOJ-CODE                  PIC S9(04) VALUE +0 COMP.   
      *                                                                 00690000
       01  WS-AUDIT-TABLE.                                              
           05  WS-AUD-TBL                       OCCURS 100 TIMES.       
               10  WS-FORM-NO                  PIC 9(05).               
               10  WS-RATE-PLAN                PIC X(03).               
      *                                                                 00740000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'PCSCA917'. 
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
      *                                                                 00790000
       01  WS-SWITCHES.                                                 
           05  WS-FCA901-STATUS             PIC X(02).                  
               88 CA901-SUCCESSFUL          VALUE '00'.                 
           05  WS-FCA917-STATUS             PIC X(02).                  
               88 CA917-SUCCESSFUL          VALUE '00'.                 
           05  WS-END-OF-CA901              PIC X(01) VALUE 'N'.        
               88 END-OF-CA901              VALUE 'Y'.                  
           05  WS-NO-PROCESSED-SW           PIC X(01) VALUE 'N'.        
               88 NO-PROCESSED              VALUE 'Y'.                  
           05  WS-TBL-FULL-SW               PIC X(01) VALUE 'N'.        
               88 TBL-FULL                  VALUE 'Y'.                  
      *                                                                 01020000
       01  WS-END                           PIC X(40)                   
           VALUE 'WORKING STORAGE FOR PCSCA917 ENDS HERE  '.            
      *                                                                 01050000
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
      ******************************************************************01080000
      *   CONTROLS MAIN PROCESSING FLOW                                *01090000
      ******************************************************************01100000
           PERFORM 0100-INITIALIZE          THRU  0100-EXIT.            
           PERFORM 1000-PROCESSING          THRU  1000-EXIT             
                 UNTIL END-OF-CA901.                                    
           PERFORM 9000-TERMINATE           THRU  9000-EXIT.            
           STOP RUN.                                                    
      *                                                                 01160000
       0000-EXIT.                                                       
           GOBACK.                                                      
HPCCDM*    EJECT                                                        01190000
      *                                                                 01200000
       0100-INITIALIZE.                                                 
      ******************************************************************01220000
      * INITIALIZE RUN                                                 *01230000
      * PRIMING READ OF STATEMENT FILE.                                *01240000
      ******************************************************************01250000
           INITIALIZE WS-AUDIT-TABLE.                                   
           OPEN INPUT FCSCA901-FILE.                                    
           IF NOT CA901-SUCCESSFUL                                      
              MOVE +0012                    TO WS-EOJ-CODE              
              MOVE WS-EOJ-CODE              TO RETURN-CODE              
              DISPLAY '**************************************'          
              DISPLAY '**  ERROR OPENING FCSCA901          **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA901-STATUS             
              DISPLAY '**************************************'          
              STOP RUN                                                  
           END-IF.                                                      
      *                                                                 01370000
           OPEN OUTPUT FCSCA917-FILE.                                   
           IF NOT CA917-SUCCESSFUL                                      
              MOVE +0012                    TO WS-EOJ-CODE              
              MOVE WS-EOJ-CODE              TO RETURN-CODE              
              DISPLAY '**************************************'          
              DISPLAY '**  ERROR OPENING FCSCA917          **'          
              DISPLAY '**  FILE STATUS = ' WS-FCA917-STATUS             
              DISPLAY '**************************************'          
              STOP RUN                                                  
           END-IF.                                                      
      *                                                                 01480000
           PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT.             
      *                                                                 01510000
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        01540000
      *                                                                 01550000
       1000-PROCESSING.                                                 
      ******************************************************************01570000
      * MAIN PROCESSING MODULE                                         *01580000
      ******************************************************************01590000
           MOVE 'N'                         TO WS-NO-PROCESSED-SW.      
           PERFORM 1500-SEARCH-NUM-TBL       THRU 1500-EXIT.            
      *                                                                 01630000
           IF NOT NO-PROCESSED AND WS-AUD-IDX < 100                     
              MOVE EXT-MKTG-MESSAGE-NO      TO WS-FORM-NO (WS-AUD-IDX)  
              MOVE EXT-MKTG-RATE-PLAN-NO    TO WS-RATE-PLAN(WS-AUD-IDX) 
                                                WS-RATE-PLAN(WS-AUD-IDX)
              INITIALIZE EXT-MKTG-MAIL-ADDRESS                          
              EVALUATE EXT-MKTG-MESSAGE-NO                              
PRJ211        WHEN 10204                                                
PRJ211        WHEN 10205                                                
PRJ211            STRING 'FIXED RATE ANNIVERSAY - PRERENEWAL LETTER -', 
PRJ211                      EXT-MKTG-MESSAGE-NO                         
PRJ211             DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(1)  
PRJ211             STRING 'RATE NUMBER = ',                             
PRJ211                    EXT-MKTG-RATE-PLAN-NO                         
PRJ211             DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)  
PRJ211        WHEN 10206                                                
PRJ211        WHEN 10208                                                
PRJ211        WHEN 10207                                                
PRJ211             STRING 'FIXED RATE ANNIVERSAY - RENEWAL LETTER - ',  
PRJ211                    EXT-MKTG-MESSAGE-NO                           
PRJ211             DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(1)  
                   STRING 'RATE NUMBER = ',                             
                          EXT-MKTG-RATE-PLAN-NO                         
                   DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)  
              WHEN 10203                                                
                   MOVE '60-DAY FREE BILL CREDIT EXPIRATION LETTER' TO  
                                           EXT-MKTG-MAILING-ADDRESS(1)  
                   STRING 'RATE NUMBER = ',                             
                          EXT-MKTG-RATE-PLAN-NO                         
                   DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)  
P00805        WHEN 10209                                                
P00805             STRING 'FIXED RATE ANNIV - RENEWAL LTR - SM COMM -', 
P00805                    EXT-MKTG-MESSAGE-NO                           
P00805             DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(1)  
P00805             STRING 'RATE NUMBER = ',                             
P00805                    EXT-MKTG-RATE-PLAN-NO                         
P00805             DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)  
P00805        WHEN 10210                                                
P00805             IF EXT-MKTG-TIER-ACCT-TYPE = 'S'                     
P00805                STRING 'FIXED RATE ANNIV - PNDG RNW LTR SC - ',   
P00805                       EXT-MKTG-MESSAGE-NO                        
P00805               DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(1)
P00805                STRING 'RATE NUMBER = ',                          
P00805                       EXT-MKTG-RATE-PLAN-NO                      
P00805               DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)
P00805             ELSE                                                 
P00805                STRING 'FIXED RATE ANNIV - PNDG RNW LTR RES - ',  
P00805                       EXT-MKTG-MESSAGE-NO                        
P00805               DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(1)
P00805                STRING 'RATE NUMBER = ',                          
P00805                       EXT-MKTG-RATE-PLAN-NO                      
P00805               DELIMITED BY SIZE INTO  EXT-MKTG-MAILING-ADDRESS(2)
P00805             END-IF                                               
              END-EVALUATE                                              
              PERFORM 8000-WRITE-OUTPUT     THRU 8000-EXIT              
           END-IF.                                                      
      *                                                                 01830000
           INITIALIZE                            FIOCA901               
                                                 CA917-RECORD.          
           PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT.             
      *                                                                 01840000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02040000
       1500-SEARCH-NUM-TBL.                                             
      ******************************************************************02060000
      * SEARCH FORM NUMBER TABLE FOR PROCESSED FORMS                   *02070000
      ******************************************************************02080000
           PERFORM VARYING WS-AUD-IDX FROM 1 BY 1                       
                                UNTIL WS-AUD-IDX > 100                  
                                   OR WS-NO-PROCESSED-SW     = 'Y'      
                                   OR WS-FORM-NO(WS-AUD-IDX) = ZEROES   
               IF EXT-MKTG-MESSAGE-NO   = WS-FORM-NO (WS-AUD-IDX) AND   
                  EXT-MKTG-RATE-PLAN-NO = WS-RATE-PLAN (WS-AUD-IDX)     
                  MOVE 'Y'                  TO WS-NO-PROCESSED-SW       
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                 02160000
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02190000
      *                                                                 02200300
       7000-READ-INPUT-FILE.                                            
      ******************************************************************02210000
      * READ INPUT FILE                                                *02220000
      ******************************************************************02230000
           READ FCSCA901-FILE                                           
               AT END MOVE WS-Y             TO WS-END-OF-CA901.         
                                                                        
           IF CA901-SUCCESSFUL OR END-OF-CA901                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA917 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSRP000       **'       
               DISPLAY '**     FILE STATUS = ' WS-FCA901-STATUS         
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE       THRU 9000-EXIT
           END-IF.             
      *                                                                 02360000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02390000
       8000-WRITE-OUTPUT.                                               
      ******************************************************************02410000
      * WRITE OUTPUT FILE                                              *02420000
      ******************************************************************02430000
           MOVE FIOCA901                    TO CA917-DATA.              
           WRITE CA917-RECORD.                                          
      *                                                                 02460000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02490000
       9000-TERMINATE.                                                  
      ******************************************************************02510000
      * WRITE OUTPUT FILE                                              *02520000
      ******************************************************************02530000
           CLOSE FCSCA901-FILE                                          
                 FCSCA917-FILE.                                         
                                                                        
      *     IF WS-REC-CNT < 1                                           02570000
      *        IF RETURN-CODE < 8                                       02580000
      *           DISPLAY                                               02590000
      *             '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'  02600000
      *           DISPLAY                                               02610000
      *             '!  INPUT FILE EMPTY OR CONTAINS NO VALID DATA  !'  02620000
      *           DISPLAY                                               02630000
      *             '!*!*                 ***                    *!*!'  02640000
      *           DISPLAY                                               02650000
      *             '!*!*        MARK THIS RUN COMPLETE          *!*!'  02660000
      *           DISPLAY                                               02670000
      *             '!****                ***                    ***!'  02680000
      *           DISPLAY                                               02690000
      *             '!****      DO NOT NOTIFY PROGRAMMER         ***!'  02700000
      *           DISPLAY                                               02710000
      *             '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'  02720000
      *           MOVE +3                    TO RETURN-CODE             02730000
      *           END-IF                                                02740000
      *     END-IF.                                                     02750000
       9000-EXIT.                                                       
            EXIT.                                                       
