       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA916.                                        
       AUTHOR.         DANIE BOOTHA.                                    
       DATE-WRITTEN.   NOV 2007.                                        
      ****************************************************************  00060000
      ********            CUSTOMER SERVICE SYSTEM             ********  00070000
      ********                      DB2                       ********  00080000
      ****************************************************************  00090000
      **                                                            **  00100000
      **              PROGRAM  MODIFICATION  LOG                    **  00110000
      **                                                            **  00120000
      **    DATE    INITIALS     REASON                             **  00130000
      **  --------  --------     ---------------------------------- **  00140000
      **  10/08/01    S. MOSES   NEW PROGRAM CALCULATING SAVINGS    **  00150000
      **                         FOR ONE RATE CUSTOMERS             **  00160000
      **  10/15/07    DB41297    SEB RATE REENGINEERING.            **  00170000
      **  06/25/07    RV97439    FIX TO SEND MARKETTING LETTERS     **  00180000
      **                         TO CORRECT MAILING ADDRESS AND     **  00190000
      **                         POPULATE COMM TYPE AND SUB TYPE    **  00200000
      **                         IN OUTPUT FILE                     **  00210000
T37389**  07/11/08    DB41297    POPULATE GOOD-PAYMENTS FROM CZ TBL.**  00220000
T37389**  08/11/08    DB41297    ONLY ALLOW ACTIVE CUSTOMERS TO GET **  00230000
      **                         LETTERS.                           **  00240000
A00765**  01/15/09    CVNS       ADDED 9000-SEND-ERROR-RESULT PARA. **  00250000
A00765**              CHENNAI                                       **  00260000
I00177**  03/11/09    RV97439    PASS MAX-ENTRY FIELDS WHILE CALLING**  00270000
I00177**                         SCSCA195.                          **  00280000
A01323**  05/28/09    EM19682    INCREASED OCCURRS ON WS-REN-TBL TO **  00290000
A01323**                         10.                                **  00300000
PRJ172**  07/10/09    RV97439    REGULATED PROVIDER TRANSISTION.    **  00310000
PRJ211**  09/15/09    AF94305    ADD 10204 & 10205 FOR PRE RENEWAL  **  00320000
PRJ211**                         LETTERS.                           **  00330000
PRJ211**                         FIX THE ACCESS WHEN WRITING AN INFO**  00340000
PRJ211**                         INTO TRANS HISTORY BY PASSING A    **  00350000
PRJ211**                         PARAMETER INTO THE PROGRAM.        **  00360000
PRJ166**  10/14/09    CVNS       ADDED CODE TO POPULATE PROCESS     **  00370000
PRJ166**              CHENNAI    DATE FROM CURRENT DATE             **  00380000
PRJ211**  10/06/09   AF94305     PHASE 2. UPDATE/CREATE RENEWAL LET.**  00390000
A37741**  20/11/09   SB93596     DECLARED  S-RETURN-CODE            **  00400000
A37741**                         RESPECTIVE TO CPD00067 CHANGES     **  00410000
PRJ211**  12/09/09   AF94305     OBSOLETE OLD 30DAY LETTERS(DUR. 1) **  00420000
PRJ211**                         PHASE 3 OF THE EARLY RENEWAL PROJ. **  00430000
PRJ211**  01/12/09   AF94305     DO NOT WRITE RECORDS TO THE OUTPUT **  00440000
PRJ211**                         FILE WHEN DURATION IS 1. THIS IS A **  00450000
PRJ211**                         PRODUCTION FIX, A NULL RECORDS IN A**  00460000
PRJ211**                         FILE.                              **  00470000
PRJ245**  12/07/09   SDHAL       INTRODUCING RATE CHANGE LETTERS    **  00480000
PRJ172**  04/14/10   RAJ         REGULATED PROVIDER.                **  00490000
A02003**  07/13/10   SJ97149     ADD NAME OF GENERATING PROGRAM     **  00500000
A02003**             ACT0014     AND PARAGRAPH IN WQ DESCRIPTION    **  00510000
PRJ396**  08/06/10   ST          18 MONTH RATE PLAN PROJECT         **  00520000
PRJ477**  12/20/10   EH          DROP RATE AND SENIOR FLAG          **  00530000
A03019**  12/20/10   EH          CLEANUP PRJ477 LOGIC               **  00540000
A03019**  08/11/11   EH          SORT RENEWAL OPTIONS FOR DIALOGUE  **  00550000
A03082**  09/22/11   BD09555     DON'T ABEND FOR -803 ON                00560000
ACT168**  A03082                 COMMUNICATION ROW TABLE                00570000
A03583**  09/23/11   SV82012     PROCESS DELTA SKYMILES FOR BEGIN   **  00580000
A03583**                         READ DATE ON OR BEFORE 10/09/2011  **  00590000
P00581**  11/18/11   RAJ         SCANA ENERGY EXIT FEE INCREASE.    **  00600000
A04106**  04/16/12   RAJ         ADD RETENTION OFFER DETAILS TO     **  00610000
A04106**                         RENEWAL OPTION LETTER.             **  00620000
P00677**  09/04/12   SDHAL       FIXED SENIOR FLAG FOR REG PROVIDER **  00630000
A04735**  08/08/13   MC95456     REMOVED DCLGEN FOR CSS_CUST_COMM_MF**  00640000
A04730**  09/04/13   VIJAY       CHANGE WS-SCSCA328 TO SCSCA328.    **  00650000
A04730**                         CHANGE WS-SCSCA195 TO SCSCA195.    **  00660000
A04730**  09/27/13   EM19682     ADDED CODE TO IDENTIFY FLEX RATE   **  00670000
A04730**                         CUSTOMERS WITH INCENTIVES.         **  00680000
P00805*   03/17/14   DMS         EXTENDED RENEWAL                   **  00690000
P00805*   04/08/14   DMS         ADD NEW 25 DAY PENDING OPTION LTR  **  00700000
A05043*   09/08/14   ESM         SENIOR RATE MESSAGE CHANGES        **  00710000
A05037*   10/21/14   ESM         TRANSPORTATION FEE CHANGES         **  00720000
A04860**  12/08/14   AS7C117     REPLACE CSS_WQ_ITEMS_MF WITH       **  00730000
A04860**             ACT048      CSS_WQ_ITEMS.                      **  00740000
P00892**  04/20/15   ESM         FIXED RATE AUTO RENEWAL            **  00750000
ACT314**  07/28/15   SS7F226     INITIALIZE ABEND FIELDS BEFRE CALL **  00760000
ACT314**             A04880      SCSCB077 - PROD FIX.               **  00770000
A05136*   10/20/15   DB41297     REMOVE REFERENCE TO CSS_INCENTIVE. **  00771000
P805CS**  03/18/16   DMS         P00805 CSC INCREASE                **  00772000
P00805**  08/22/16   ESM         ADDED 10502 MESSAGE FOR OUTER POOL **  00773000
P00805**                         CUSTOMERS.                         **  00774000
      ****************************************************************  00775000
      **                     PCSCA916 NARRATIVE                     **  00776000
      **  PCSCA916 IDENTIFIES ACCOUNTS THAT ARE ELIGIBLE FOR A      **  00777000
      **  30-DAY OR 60-DAY LETTER, AND CREATES THE CA916 FILE TO    **  00778000
      **  CREATE THOSE LETTERS.                                     **  00779000
      ****************************************************************  00780000
      *                                                                 00790000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00850000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      ******************************************************************00880000
      * CSSBE22 - SELECT STATEMENT FOR SEQUENTIAL BILLING EXTRACT FILE *00890000
      *                                                                *00900000
      ******************************************************************00910000
           SELECT FCSBE22-FILE                                          
               ASSIGN UT-S-FCSBE22                                      
               FILE STATUS IS WS-FBE22-STATUS.                          
           SELECT SEB916-FILE    ASSIGN TO UT-S-SEB916                  
               FILE STATUS IS WS-S916-STATUS.                           
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBE22.                                                    00990000
       COPY FIOBE22.                                                    01000000
       FD  SEB916-FILE                                                  
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       COPY FIOCA916.                                                   01050000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA916'.
MSQ017     COPY MFASQLM.
      *                                                                 01080000
       COPY FIOJC01.                                                    01090000
      *                                                                 01100000
       COPY CWS09900.                                                   01110000
      *                                                                 01120000
       COPY CWS00010.                                                   01130000
      *                                                                 01140000
       COPY CWS00011.                                                   01150000
      *                                                                 01160000
       COPY CWS00038.                                                   01170000
      *                                                                 01180000
       COPY CWS00039.                                                   01190000
      *                                                                 01200000
       COPY CWS00303.                                                   01210000
      *                                                                 01220000
       COPY CWS1000B.                                                   01230000
      *                                                                 01240000
           EXEC SQL                                                     01250000
               INCLUDE CWS00328                                         01260000
           END-EXEC.                                                    01270000
                                                                        
           EXEC SQL                                                     01290000
               INCLUDE CWS00063                                         01300000
           END-EXEC.                                                    01310000
       01  WS-NEW-AUDIT-TBL.                                            
           05  DDC-CNT                     PIC S9(5) COMP-3 VALUE +0.   
           05  OUT-CNT                     PIC S9(5) COMP-3 VALUE +0.   
                                                                        
        01  WS-OUTPUT-TABLE.                                            
            05 WS-OUTPUT-TBL OCCURS 0 TO 10 DEPENDING                   
                                        ON OUT-CNT.                     
               10 T-OPTION-CD             PIC  X(12).                   
               10 T-OPT-DESC-INT          PIC  X(100).                  
COB305         10 T-THERM-PRICE        PIC S9(5)V9(6) USAGE COMP-3 
COB305            VALUE 0.  
               10 T-OPTN-VALID-MNTHS      PIC S9(4) USAGE COMP.         
               10 T-RATE-CALC-TYPE-CD     PIC  X(2).                    
COB305         10 T-CSC-AMT        PIC S9(5)V9(6) USAGE COMP-3 VALUE 0.  
               10 T-CSC-REFND-FL          PIC  X(1).                    
               10 T-CSC-MNTHS             PIC S9(4) USAGE COMP.         
                                                                        
       01  WS-MISC.                                                     
           05  WS-PROGRAM-DATE         PIC X(10).                       
           05  WS-FILE-CREATE-DATE     PIC X(10).                       
           05  WS-DATE-EXTRACT         PIC X(10).                       
           05  WS-TEMP-DATE            PIC X(10).                       
           05  WS-REVENUE-MONTH-JP         PIC X(06).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH-JP.                    
               10  WS-REV-MONTH-CURR-CCYY  PIC X(4).                    
               10  WS-REV-MONTH-CURR-MM    PIC X(2).                    
           05  WS-REV-MON-JP-NUM REDEFINES WS-REVENUE-MONTH-JP          
                                       PIC 9(06).                       
COB305     05 WS-WO-MTH-YR        PIC S9(06)V COMP-3 VALUE 0.              
           05  WS-WO-MTH-YR-X          PIC X(06).                       
           05  WS-FBE22-STATUS         PIC X(02).                       
               88  FCSBE22-SUCCESSFUL  VALUE '00'.                      
               88  END-OF-FCSBE22      VALUE '10'.                      
           05  WS-FCA916-STATUS        PIC X(02).                       
               88  FCA916-SUCCESSFUL   VALUE '00'.                      
           05  WS-FIOCA916-STATUS          PIC XX       VALUE '  '.     
               88  FIOCA916-SUCCESSFUL                  VALUE '00'.     
               88  FIOCA916-READ-OK                VALUE '00' '04'.     
           05  WS-S916-STATUS              PIC XX       VALUE '  '.     
               88  S916-SUCCESSFUL                      VALUE '00'.     
           05  WS-DISPLAY-SQLCODE      PIC -ZZZZZZZZ9.                  
           05  RS-RETURN-CODE          PIC S9(04) COMP.                 
           05  S-RETURN-CODE           PIC S9(04) COMP VALUE 0.         
           05  WS-DISPLAY-RC           PIC ---9.                        
           05  RS-RETURN-CODE-DISP     PIC S9(04).                      
           05  WS-RED-FL-NULL-IND      PIC S9(4) COMP  VALUE 0.         
           05  WS-END-NULL-IND         PIC S9(4) COMP  VALUE 0.         
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN   PIC S9(4) USAGE COMP.     
               10 WS-INITIAL-COMMENT-TX-TEXT  PIC X(255).               
           05  WS-ONERATE-ANNIV-MO     PIC 9(06).                       
           05  WS-REVENUE-MONTH        PIC 9(6).                        
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10  WS-REV-YR           PIC 9(4).                        
               10  WS-REV-MTH          PIC 9(2).                        
COB305     05 WS-START-REV-MONTH        PIC S9(6) COMP-3 VALUE 0.               
           05  WS-NEXT-REVENUE-MONTH   PIC 9(6).                        
           05  FILLER REDEFINES WS-NEXT-REVENUE-MONTH.                  
               10 WS-NEXT-REV-CCYY     PIC 9(4).                        
               10 WS-NEXT-REV-MM       PIC 9(2).                        
           05  WS-START-REV-MONTH2     PIC 9(6).                        
           05  FILLER REDEFINES WS-START-REV-MONTH2.                    
               10  WS-START-REV-YR     PIC 9(4).                        
               10  WS-START-REV-MTH    PIC 9(2).                        
           05  WS-REV-MTH-LST-NRML     PIC 9(06).                       
           05  FILLER REDEFINES WS-REV-MTH-LST-NRML.                    
               10  WS-LAST-REV-YR      PIC 9(4).                        
               10  WS-LAST-REV-MTH     PIC 9(2).                        
           05  WS-HOLD-PREV-DATE.                                       
               10  WS-PREV-CCYY        PIC 9(4).                        
               10  FILLER              PIC X     VALUE '-'.             
               10  WS-PREV-MM          PIC 9(2).                        
               10  FILLER              PIC X(3).                        
           05  WS-HOLD-CURR-DATE.                                       
               10  WS-CURR-CCYY        PIC 9(4).                        
               10  FILLER              PIC X     VALUE '-'.             
               10  WS-CURR-MM          PIC 9(2).                        
               10  FILLER              PIC X(3)  VALUE '-01'.           
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
           05  WS-HIST-DISP-DATE.                                       
               10  WS-HIST-DISP-MM         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-DD         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-YR         PIC X(04).                   
           05  WS-SELECT-CURR-DATE     PIC X(10).                       
           05  WS-SELECT-PREV-DATE     PIC X(10).                       
           05  WS-FCTR-ANNIV-MONTH     PIC 9(6).                        
COB305     05 WS-FCTR-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-FCTR-MONTHS-RMNG     PIC 9(4).                        
           05  WS-HOLD-EFF-DATE-TO     PIC X(10).                       
           05  WS-HOLD-CSC-ANNIV-DATE REDEFINES WS-HOLD-EFF-DATE-TO.    
               10  WS-HOLD-EFF-CCYY           PIC X(4).                 
               10  FILLER                     PIC X.                    
               10  WS-HOLD-EFF-MM             PIC X(2).                 
               10  FILLER                     PIC X(3).                 
           05  WS-NOTICE-DATE.                                          
               10  WS-NOTICE-YY            PIC 9(02) VALUE ZEROES.      
               10  WS-NOTICE-MM            PIC 9(02) VALUE ZEROES.      
               10  WS-NOTICE-DD            PIC 9(02) VALUE ZEROES.      
           05  WS-JOB-PARM                 PIC X(10) VALUE SPACES.      
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
           05  WS-INVALID-MSG-WQ-TXT       PIC X(250) VALUE SPACES.     
COB305     05 WS-ACCOUNT-NO-P        PIC S9(13) USAGE COMP-3 VALUE 0.         
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.               
           05  WS-SCHED-PRICE-UT       PIC S9(5)V9(6) VALUE ZERO.       
           05  WS-SCHED-PRICE-BG       PIC S9(9)V9(6) VALUE ZERO.       
           05  WS-SCHED-PRICE-BG2      PIC S9(9)V9(6) VALUE ZERO.       
           05  WS-BILL-UNITS-BZ        PIC S999999999V VALUE ZERO.      
           05  WS-BILL-UNITS-BZ2       PIC S999999999V VALUE ZERO.      
           05  WS-BILL-UNITS-TOT       PIC S999999999V VALUE ZERO.      
           05  WS-RATE-PLAN-NO         PIC X(3).                        
           05  WS-RATE-VERSION-DATE        PIC X(10)                    
                  VALUE '    -  -01'.                                   
           05  FILLER REDEFINES WS-RATE-VERSION-DATE.                   
               10  WS-RATE-VERSION-YEAR    PIC X(4).                    
               10  FILLER                  PIC X.                       
               10  WS-RATE-VERSION-MONTH   PIC X(2).                    
               10  FILLER                  PIC X(3).                    
           05  WS-CURRENT-RATE-PLAN-NO PIC X(3).                        
COB305     05 WS-AMT-NET-RATE        PIC S9(5)V9(12) COMP-3 VALUE 0.          
           05  WS-REBILL-IMMEDIATE-FLAG PIC X(01) VALUE 'N'.            
           05  WS-REBILL-FLAG           PIC X(01) VALUE 'N'.            
           05  WS-ONCYCLE-FLAG          PIC X(01) VALUE 'N'.            
           05  WS-DATE-NOTICE-DUE-NULL  PIC S9(04)    COMP VALUE +0.    
           05  WS-ONERATE-ANNIV-MO-NULL PIC S9(04)    COMP VALUE +0.    
COB305     05 WS-INCENTIVE-AMT        PIC S9(07)V9(02) COMP-3 VALUE 0.         
COB305     05 WS-BILLED-AMT        PIC S9(07)V9(02) COMP-3 VALUE 0.         
COB305     05 WS-NONUTIL-AMT        PIC S9(07)V9(02) COMP-3 VALUE 0.         
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-INCENTIVE-SW         PIC X(01).                       
               88  ACCT-ON-INCENTIVE   VALUE 'Y'.                       
           05  WS-LETTER-SW            PIC X(01)  VALUE SPACES.         
               88 LETTER-OUTPUT                   VALUE 'Y'.            
           05  WS-END-OF-BE22-SW       PIC X(01).                       
               88  END-OF-BE22         VALUE 'Y'.                       
           05  WS-PROCESS-BG-SW        PIC X(01).                       
               88  NO-MORE-BG          VALUE 'N'.                       
COB305     05 WS-HOLD-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.             
COB305     05 WS-HOLD-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.            
           05  WS-HOLD-COMPANY-NO      PIC X(02).                       
           05  WS-HOLD-PARA-NUM        PIC X(04).                       
           05  WS-HOLD-WQ-TEXT         PIC X(60).                       
           05  WS-HOLD-WQ-COMMENTS     PIC X(200).                      
           05  WS-HOLD-DEST-CODE       PIC X(1).                        
           05  WS-HOLD-OFFER-FLAG      PIC X(1).                        
           05  WS-HOLD-EXT-BILLING-FL  PIC X(01).                       
           05  WS-FUT-REV-MONTH.                                        
               10  WS-FUT-REV-CCYY         PIC 9(4).                    
               10  WS-FUT-REV-MM           PIC 9(2).                    
COB305     05 WS-ACCOUNT-NO-TEMP        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-FACTOR-TYPE          PIC X(01).                       
           05  WS-IC-NO                PIC S9(04) COMP VALUE +1.        
           05  WS-CODE-UTIL-TYPE       PIC X VALUE 'G'.                 
COB305     05 WS-SUB        PIC S9(03) COMP-3 VALUE 0.            
COB305     05 WS-SUB1        PIC S9(03) COMP-3 VALUE 0.            
COB305     05 WS-SUB2        PIC S9(03) COMP-3 VALUE 0.            
COB305     05 WS-SUB3        PIC S9(03) COMP-3 VALUE 0.            
COB305     05 WS-BG-CNT        PIC S9(3) COMP-3 VALUE 0.             
           05  WS-ABEND-CNT               PIC S9(5) COMP-3 VALUE +0.    
           05  WS-ACCOUNT-COUNT           PIC 9(7)     VALUE ZEROS.     
           05  WS-ACCOUNT-REBILL          PIC 9(7)     VALUE ZEROS.     
           05  WS-ACCOUNT-DROPPED         PIC 9(7)     VALUE ZEROS.     
           05  WS-ACCOUNT-READ            PIC 9(7)     VALUE ZEROS.     
           05  WS-10203-CNT               PIC 9(7)     VALUE ZEROS.     
PRJ211     05  WS-10206-CNT               PIC 9(7)     VALUE ZEROS.     
PRJ211     05  WS-10207-CNT               PIC 9(7)     VALUE ZEROS.     
PRJ211     05  WS-10208-CNT               PIC 9(7)     VALUE ZEROS.     
P00805     05  WS-10209-CNT               PIC 9(7)     VALUE ZEROS.     
P00805     05  WS-10210-CNT               PIC 9(7)     VALUE ZEROS.     
P00892     05  WS-10215-CNT               PIC 9(7)     VALUE ZEROS.     
P00805     05  WS-10502-CNT               PIC 9(7)     VALUE ZEROS.     
           05  WS-SCSCB063                PIC X(8) VALUE 'SCSCB063'.    
A04730     05  SCSCA195                   PIC X(8) VALUE 'SCSCA195'.    
A04730     05  SCSCA328                   PIC X(8) VALUE 'SCSCA328'.    
P00677     05  WS-ACCT-TIER-CHANGED       PIC X(2).                     
P00677         88  TIER-HAS-CHANGED                     VALUE 'NE'.     
P00677         88  TIER-NOT-CHANGED                     VALUE 'EQ'.     
           05  WS-BILL-PRT-MSG-CD          PIC X(3).                    
               88  FIXED-PRICE                          VALUE           
                  'FPN' 'FPL' 'FPM' 'FPH'.                              
               88  FIXED-PRICE-AND-CSC                  VALUE           
                  'FPN' 'FPL' 'FPM' 'FPH' 'CSC'.                        
               88  FIXED-PRICE-NORMAL                   VALUE 'FPN'.    
               88  FIXED-PRICE-GRP2-LOW-CSC             VALUE 'FPL'.    
               88  FIXED-PRICE-GRP2-MED-CSC             VALUE 'FPM'.    
               88  FIXED-PRICE-GRP2-HI-CSC              VALUE 'FPH'.    
               88  FREE-CSC                             VALUE 'CSC'.    
               88  FREE-BILL-CREDIT                     VALUE 'BCR'.    
           05  WS-DDDC-ADDER-FLAG            PIC X(1).                  
               88  ONE-PART-RATE                       VALUE 'N'.       
               88  TWO-PART-RATE                       VALUE 'Y'.       
           05  WS-REGULATED-FLAG             PIC X(1).                  
               88  REGULATED-RATE                      VALUE 'Y'.       
           05  WS-THERM-PRC              PIC $$$$$9.999.                
           05  WS-FR-RENEW-BY-DATE       PIC X(10) VALUE SPACES.        
COB305     05 WS-TMP-REV-MONTH        PIC 9(6) COMP-3 VALUE 0.            
           05  WS-REVENUE-MONTH1            PIC 9(6).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH1.                      
               10  WS-TMP-REV-CCYY          PIC 9(4).                   
               10  WS-TMP-REV-MM            PIC 99.                     
PRJ172     05 WS-YEAR-DIFF-EPP              PIC S9(7) VALUE 0.          
PRJ172     05 WS-EPP-ANNIV-DATE.                                        
PRJ172         10  WS-EPP-ANNIV-YEAR        PIC 9(4)    VALUE ZERO.     
PRJ172         10  WS-EPP-ANNIV-MO          PIC 9(2)    VALUE ZERO.     
PRJ172     05  WS-EPP-ANNIV-FLAG            PIC X VALUE 'N'.            
PRJ211     05  WS-ANIV-BB-FIX-RR-FLG        PIC X VALUE 'N'.            
P805OP     05  WS-HOLD-DDC-FACTOR           PIC Z(02)9.99.              
P805OP     05  WS-HOLD-DROP-DDC-FACTOR      PIC Z(02)9.99.              
A03019     05  WS-HOLD-RENEWAL-OPTIONS.                                 
A03019         10  WS-HOLD-REN-OPT-TABLE                OCCURS 3 TIMES. 
A03019            15  WS-HOLD-REN-OPT          PIC 99      VALUE ZERO.  
A03019     05  WS-SORT-RENEWAL-OPTIONS.                                 
A03019         10  WS-SORT-REN-OPT-TABLE              OCCURS 3 TIMES.   
A03019            15  WS-SORT-REN-OPT          PIC Z9      VALUE ZERO.  
A03019     05  WS-HOLD-SUB                  PIC 99      VALUE 1.        
A03019     05  WS-HOLD-ESCAPE-FLAG          PIC X       VALUE SPACE.    
A03583     05  WS-HOLD-PREV-METER-READ-DATE PIC X(10).                  
P00892     05  WS-MAX-RT-REN-SEQ-NO         PIC S9(4) USAGE COMP.       
P00892     05  WS-HOLD-RT-PKG-SEQ-NO        PIC S9(4) USAGE COMP.       
P00892     05  WS-HOLD-STATUS-CHG-DT        PIC X(10) VALUE SPACES.     
P00892     05  WS-ACCT-HAS-AUTO-RENEW       PIC X(01) VALUE 'N'.        
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) COMP.                 
       01  WS-MULTI-ROW-FOUND-MSG.                                      
           05 FILLER                   PIC X(47) VALUE                  
              'MULTIPLE ROW FOUND ON UTIL ENVRNMT FOR ACCOUNT '.        
           05 WS-DISP-ACCOUNT-NO       PIC 9(13).                       
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA916'.   
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA916'.   
A04860     05  SCSCB077                PIC X(8)     VALUE 'SCSCB077'.   
           05  WS-COMMON               PIC X(08)    VALUE 'COMMON  '.   
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  FACTOR-DT-NOT-FOUND     PIC X(54)    VALUE               
              'ACCT FAILED TO SELECT ANNIV. DATE FOR CSC REFND FACTOR'. 
           05  DUPLICATE-FACTOR-DT     PIC X(38)    VALUE               
              'ACCOUNT HAS MULTIPLE CSC REFND FACTORS'.                 
           05  FACTOR-LINE-2           PIC X(52)    VALUE               
              '- VERIFY THAT CSC CREDIT IS 60-DAYS FROM EXPIRATION.'.   
           05  DUPLICATE-ACCT-ROW      PIC X(47)    VALUE               
              'DUPLICATE ROWS ON THE ACCOUNT TABLE FOR ACCOUNT'.        
           05  RATE-INFO-NOT-FOUND     PIC X(43)    VALUE               
              'UNABLE TO FIND RATE INFORMATION FOR ACCOUNT'.            
           05  DUPLICATE-RATE-INFO     PIC X(44)    VALUE               
              'DUPLICATE RATE INFORMATION FOUND FOR ACCOUNT'.           
           05  PRICE-NOT-FOUND         PIC X(38)    VALUE               
              'UNABLE TO FIND THERM PRICE FOR ACCOUNT'.                 
           05  DUPLICATE-PRICE         PIC X(39)    VALUE               
              'DUPLICATE THERM PRICE FOUND FOR ACCOUNT'.                
           05  MISSING-ANNIV-DATE      PIC X(49)    VALUE               
              'UNABLE TO FIND FIXED RATE ANNIVERSARY FOR ACCOUNT'.      
                                                                        
      *                                                                 03890000
PRJ211 COPY CWS00195.                                                   03900000
      *                                                                 03910000
       COPY FIOCA00.                                                    03920000
      *                                                                 03930000
           EXEC SQL                                                     03940000
               INCLUDE SQLCA                                            03950000
           END-EXEC.                                                    03960000
      *                                                                 03970000
           EXEC SQL                                                     03980000
                INCLUDE TBACCT                                          03990000
           END-EXEC.                                                    04000000
      *                                                                 04010000
           EXEC SQL                                                     04020000
                INCLUDE TBCOMDAT                                        04030000
           END-EXEC.                                                    04040000
      *                                                                 04050000
           EXEC SQL                                                     04060000
                INCLUDE TBBGTPLN                                        04070000
           END-EXEC.                                                    04080000
      *                                                                 04090000
           EXEC SQL                                                     04100000
               INCLUDE TBJBPARM                                         04110000
           END-EXEC.                                                    04120000
      *                                                                 04130000
           EXEC SQL                                                     04140000
               INCLUDE TBMNHDT                                          04150000
           END-EXEC.                                                    04160000
      *                                                                 04170000
           EXEC SQL                                                     04180000
               INCLUDE TBMNHIST                                         04190000
           END-EXEC.                                                    04200000
      *                                                                 04210000
           EXEC SQL                                                     04220000
               INCLUDE TBBILWDW                                         04230000
           END-EXEC.                                                    04240000
      *                                                                 04250000
P00892*                                                                 04260000
P00892***********************************************************       04270000
P00892* DCLGEN TABLE(CSS_ACT_RT_RENEWAL)                        *       04280000
P00892***********************************************************       04290000
P00892     EXEC SQL                                                     04300000
P00892          INCLUDE TBRATREN                                        04310000
P00892     END-EXEC.                                                    04320000
P00892*                                                                 04330000
P00892***********************************************************       04340000
P00892* DCLGEN TABLE(CSS_ACT_RT_REN_DET)                        *       04350000
P00892***********************************************************       04360000
P00892     EXEC SQL                                                     04370000
P00892          INCLUDE TBRENDET                                        04380000
P00892     END-EXEC.                                                    04390000
P00892*                                                                 04400000
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     04410000
A04860      EXEC SQL                                                    04420000
A04860           INCLUDE CWS00077                                       04430000
A04860      END-EXEC.                                                   04440000
A04860*                                                                 04450000
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-MNT-INS-SW                     PIC X(01).             
      *                                                                 04500000
PRJ211 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ****************************************************************  04520000
      **                                                            **  04530000
      **  0000-MAINLINE                                             **  04540000
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **  04550000
      **                                                            **  04560000
      ****************************************************************  04570000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION             THRU 0100-EXIT.      
           PERFORM 0185-GET-JOB-PARM    THRU 0185-EXIT.                 
           MOVE E-FBE22-ACCOUNT-NO TO WS-CA195-HOLD-ACCOUNT-NO.         
           PERFORM 1000-PROCESS                    THRU 1000-EXIT       
             UNTIL END-OF-BE22.                                         
                                                                        
           PERFORM 9000-TERMINATE                  THRU 9000-EXIT.      
           MOVE 0 TO RETURN-CODE.                                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04720000
      ****************************************************************  04730000
      **                                                            **  04740000
      **  0100-INITIALIZATION                                       **  04750000
      **      COMMON INITIALIZATION ROUTINE                         **  04760000
      **                                                            **  04770000
      ****************************************************************  04780000
       0100-INITIALIZATION.                                             
           OPEN INPUT FCSBE22-FILE.                                     
           IF FCSBE22-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '0000-ERROR ON FCSBE22 OPEN.  STATUS IS '        
                        WS-FBE22-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           OPEN OUTPUT SEB916-FILE.                                     
           IF NOT S916-SUCCESSFUL                                       
              DISPLAY '****************************************'        
              DISPLAY '**   0100-INITIALIZE                    '        
              DISPLAY '**   ERROR OPENING OUTPUT FILE'                  
              DISPLAY '**   FILE STATUS = ' WS-S916-STATUS              
              DISPLAY '****************************************'        
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
                                                                        
           IF FCSBE22-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '0000-ERROR ON FCSBE22 OPEN.  STATUS IS '        
                        WS-FBE22-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           MOVE ZEROES                   TO WS-CA195-HOLD-ACCOUNT-NO    
                                            WS-INCENTIVE-AMT            
                                            WS-BILLED-AMT               
                                            WS-NONUTIL-AMT.             
           MOVE SPACES                   TO WS-END-OF-BE22-SW.          
           PERFORM 0110-GET-PGM-RUN-DATE           THRU 0110-EXIT.      
           PERFORM 8000-READ-INPUT                 THRU 8000-EXIT       
             UNTIL E-FBE22-ACCOUNT-NO IS NUMERIC                        
                OR END-OF-BE22.                                         
                                                                        
           MOVE LOW-VALUES             TO WS-HOLD-DEST-CODE.            
           MOVE ZEROES TO WS-HOLD-CUSTOMER-NO                           
                          WS-HOLD-PREMISE-NO                            
           MOVE SPACES TO WS-HOLD-COMPANY-NO                            
                          WS-HOLD-DEST-CODE                             
                          WS-HOLD-WQ-TEXT                               
                          WS-HOLD-EFF-DATE-TO.                          
           PERFORM 0150-GET-CURRENT-DATE THRU 0150-EXIT.                
           PERFORM 0175-GET-REVENUE-MTH THRU 0175-EXIT.                 
           MOVE WS-CURRENT-DATE TO WS-TEMP-DATE.                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            05300000
      *                                                                 05310000
      ******************************************************************05320000
      *                                                                *05330000
      *     0110-GET-PGM-RUN-DATE.                                     *05340000
      *                                                                *05350000
      *     MODULE RETRIEVES THE RUN DATE.                             *05360000
      *                                                                *05370000
      ******************************************************************05380000
       0110-GET-PGM-RUN-DATE.                                           
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
                                                                        
               DISPLAY ' '                                              
               DISPLAY '************PCSCA916**************'             
               DISPLAY '* COMMON DATE BEING USED         *'             
               DISPLAY '* DATE IS ', WS-FCA00-COMMON-DATE               
               DISPLAY '* PROCESSING CONTINUES...        *'             
               DISPLAY '************PCSCA916**************'             
               DISPLAY ' '                                              
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE            TO WS-PROGRAM-DATE             
                                            WS-CURRENT-DATE             
                                            WS-FILE-CREATE-DATE         
                                            WS-JOB-PARM.                
                                                                        
           MOVE WS-INPUT-DATE (1:4)      TO WS-WO-MTH-YR-X (1:4).       
           MOVE WS-INPUT-DATE (6:2)      TO WS-WO-MTH-YR-X (5:2).       
           MOVE WS-WO-MTH-YR-X           TO WS-WO-MTH-YR.               
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05670000
      ********************************************************          05680000
      *  GET CURRENT DATE.                                   *          05690000
      ********************************************************          05700000
       0150-GET-CURRENT-DATE.                                           
           EXEC SQL                                                     
               SELECT (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3(PARM_DATA,1,10) E) T)                      
                 INTO :WS-CURRENT-DATE                                  
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMONDATE'                       
                  AND CMND_CODE    = 'CA00'                             
                  AND COMPANY_NO   = '01'                               
                  AND STATUS       = 'A'                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     05720000
MFA-TR*        SELECT DATE(SUBSTR(PARM_DATA,1,10))                      05730000
MFA-TR*          INTO :WS-CURRENT-DATE                                  05740000
MFA-TR*          FROM CSS_JOB_PARM                                      05750000
MFA-TR*         WHERE PROGRAM_NAME = 'COMMONDATE'                       05760000
MFA-TR*           AND CMND_CODE    = 'CA00'                             05770000
MFA-TR*           AND COMPANY_NO   = '01'                               05780000
MFA-TR*           AND STATUS       = 'A'                                05790000
MFA-TR*         WITH UR                                                 05800000
MFA-TR*    END-EXEC.                                                    05810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR ON 0150-GET-CURRENT-DATE    **'        
              DISPLAY '**  COULD NOT GET CURRENT DATE        **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05940000
      ******************************************************************05950000
      *                                                                *05960000
      *     0175-GET-REVENUE-MTH.                                      *05970000
      *                                                                *05980000
      ******************************************************************05990000
       0175-GET-REVENUE-MTH.                                            
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,15,6))                          
                 INTO :WS-REVENUE-MONTH-JP                              
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     06010000
MFA-TR*        SELECT (SUBSTR(PARM_DATA,15,6))                          06020000
MFA-TR*          INTO :WS-REVENUE-MONTH-JP                              06030000
MFA-TR*          FROM CSS_JOB_PARM                                      06040000
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                           06050000
MFA-TR*           AND CMND_CODE    = 'DATE'                             06060000
MFA-TR*           AND COMPANY_NO   = '01'                               06070000
MFA-TR*           AND SEQ_NO       = 20                                 06080000
MFA-TR*           AND STATUS       = 'A'                                06090000
MFA-TR*         WITH UR                                                 06100000
MFA-TR*    END-EXEC.                                                    06110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR ON 0175-GET-REVENUE-MTH     **'        
              DISPLAY '**  COULD NOT GET REVENUE MONTH       **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-REVENUE-MONTH-JP    TO WS-FUT-REV-MONTH              
           IF WS-FUT-REV-MM = 12                                        
              MOVE 01 TO WS-FUT-REV-MM                                  
              ADD 1 TO WS-FUT-REV-CCYY                                  
           ELSE                                                         
              ADD 1 TO WS-FUT-REV-MM                                    
           END-IF.                                                      
                                                                        
       0175-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06320000
      ******************************************************************06330000
      *                                                                *06340000
      *     0185-GET-JOB-PARM.                                         *06350000
      *                                                                *06360000
      ******************************************************************06370000
       0185-GET-JOB-PARM.                                               
                                                                        
PRJ172        MOVE WS-FCA00-BILL-DATE TO WS-CA195-BILL-DATE.            
              MOVE 'SCSCA195' TO WS-CA195-PROG-NAME.                    
              MOVE SPACES     TO WS-CA195-OPTION-CODE.                  
                                                                        
              PERFORM 1200-CALL-SCSCA195 THROUGH 1200-EXIT.             
                                                                        
       0185-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            06480000
      ****************************************************************  06490000
      **  1000-PROCESS                                              **  06500000
      **      READS THE INPUT FILE, MOVES FIELDS TO WORKING STOR-   **  06510000
      **      AGE, PERFORMS EDITS, PERFORMS UPDATES, AND PRINTS A   **  06520000
      **      REPORT LINE.                                          **  06530000
      ****************************************************************  06540000
       1000-PROCESS.                                                    
                                                                        
           IF WS-ABEND-CNT > 100                                        
              DISPLAY 'MAXIMUM NUMBER OF WORK QUEUES EXCEEDED'          
              DISPLAY 'JOB IS ABENDING'                                 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
A03583     SET WS-CNSMPTN-INDX TO 1.                                    
A03583     INITIALIZE WS-CNSMPTN-HIST-CX.                               
           SET WS-BILLING-INDX TO 1.                                    
           INITIALIZE WS-BILLING-DATA(1).                               
           SET WS-FH-HIST-INDX TO 1                                     
           INITIALIZE WS-FIXED-FACTR-DATA-HIST(1)                       
           SET WS-TIER-INDX TO 1                                        
           INITIALIZE WS-MKT-TIER-DATA(1)                               
           SET WS-RTPK-INDX TO 1                                        
           INITIALIZE WS-RTPK-AGR-DATA(1)                               
           SET WS-BDET-INDX TO 1                                        
           INITIALIZE WS-BILL-DET-DATA(1)                               
           SET WS-BI-FF-INDX TO 1.                                      
           INITIALIZE WS-BI-FIXED-FCTR-DATA(1)                          
           SET WS-ATTR-INDX TO 1.                                       
           INITIALIZE WS-ACCT-ATTR-DATA(1).                             
           SET WS-CALC-INDX TO 1.                                       
           INITIALIZE WS-BILL-CALC-DATA(1).                             
           SET WS-BILL-ADJ-INDX TO 1.                                   
           INITIALIZE WS-BILL-ADJ-DATA(1).                              
                                                                        
           MOVE SPACES TO FIOCA916.                                     
                                                                        
           INITIALIZE FIOCA916.                                         
A03586     INITIALIZE WS-HOLD-PREV-METER-READ-DATE.                     
                                                                        
           MOVE 0          TO               WS-AMT-MO-PYMT-BU.          
           MOVE SPACES                   TO  E-CA916-FREE-CSC-FLAG      
                                             E-CA916-EXCEPTION-SW       
P00677                                       E-CA916-SENIOR-SW          
P00677                                       WS-ACCT-TIER-CHANGED.      
                                                                        
           PERFORM 1100-READ-ACCOUNT UNTIL E-FBE22-ACCOUNT-NO NOT =     
                                           WS-CA195-HOLD-ACCOUNT-NO OR  
                                           END-OF-BE22.                 
                                                                        
           MOVE ' ' TO WS-CA195-RATE-TYPES                              
           MOVE 'N' TO WS-CA195-SENIOR-RATE-SW                          
PRJ172                 WS-EPP-ANNIV-FLAG                                
PRJ211                 WS-ANIV-BB-FIX-RR-FLG.                           
           MOVE 0 TO WS-CA195-DURATION-REMAIN-NO                        
                     WS-CA195-FREE-CSC-REMAIN-NO                        
P805OP               WS-HOLD-DROP-DDC-FACTOR                            
A02003               WS-HOLD-DDC-FACTOR.                                
           MOVE WS-FCA00-BILL-DATE TO WS-CA195-BILL-DATE.               
           SET WS-BILLING-INDX DOWN BY 1.                               
           SET WS-FH-HIST-INDX DOWN BY 1.                               
           SET WS-BDET-INDX DOWN BY 1.                                  
           SET WS-ATTR-INDX DOWN BY 1.                                  
           SET WS-BI-FF-INDX DOWN BY 1.                                 
           SET WS-TIER-INDX DOWN BY 1.                                  
           SET WS-RTPK-INDX DOWN BY 1.                                  
           SET WS-CALC-INDX DOWN BY 1.                                  
           SET WS-BILL-ADJ-INDX DOWN BY 1.                              
           SET ONE-PART-RATE TO TRUE.                                   
           MOVE SPACES     TO WS-CA195-OPTION-CODE                      
                              WS-CA195-FREE-CSC-SW.                     
           MOVE WS-CODE-UTIL-TYPE TO WS-IN-CODE-UTIL-TYPE.              
           MOVE WS-IC-NO TO WS-IN-IC-NO.                                
                                                                        
           PERFORM 1300-CHECK-REBILL THRU 1300-EXIT.                    
                                                                        
      ****************************************************************  07240000
      * PROCESS FIXED-RATE ACCOUNTS OR THOSE WITH TIER-SW SET AND    *  07250000
      * PRODUCE A 30-DAY OR 60-DAY LETTER.                           *  07260000
      ****************************************************************  07270000
                                                                        
T37389     EVALUATE TRUE                                                
T37389     WHEN WS-BG-CNT = 0                                           
T37389     WHEN WS-CODE-COMPANY-ACCT-AT  = 'B'                          
T37389     WHEN WS-CODE-ACCT-STAT-AT NOT = 'A'                          
T37389        ADD 1 TO WS-ACCOUNT-DROPPED                               
T37389        DISPLAY '*** ACCOUNT '                                    
T37389        WS-CA195-HOLD-ACCOUNT-NO ' DROPPED ***'                   
T37389        MOVE '  ' TO WS-CA195-SET-55-75-FLAG                      
T37389                     WS-CA195-SET-30-60-90-FLAG                   
T37389     WHEN OTHER                                                   
T37389        PERFORM 1200-CALL-SCSCA195 THROUGH 1200-EXIT              
T37389     END-EVALUATE.                                                
                                                                        
           MOVE WS-CA195-BILL-PRT-MSG-PL-CD TO WS-BILL-PRT-MSG-CD.      
                                                                        
P00805     IF RENEWAL-MSGS                                              
              PERFORM 2000-PROCESS-LETTERS THRU 2000-EXIT               
           ELSE                                                         
             IF PENDING-REMINDER-MSGS                                   
               CONTINUE                                                 
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF E-FBE22-ACCOUNT-NO NOT NUMERIC                            
              MOVE 9999999999999 TO E-FBE22-ACCOUNT-NO
           END-IF.                 
                                                                        
           MOVE E-FBE22-ACCOUNT-NO TO WS-CA195-HOLD-ACCOUNT-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            07590000
      *                                                                 07600000
      ****************************************************************  07610000
      * PARAGRAPH 1100 READS THROUGH THE BE22 FILE UNTIL IT REACHES  *  07620000
      * THE NEXT ACCOUNT ON THE FILE.  AS IT READS THE FILE, IT      *  07630000
      * READS IN SPECIFIC RECORDS TO OBTAIN DATA TO BE USED LATER.   *  07640000
      ****************************************************************  07650000
       1100-READ-ACCOUNT.                                               
           EVALUATE E-FBE22-TABLE-ID                                    
               WHEN 0000                                                
                   MOVE ZEROES TO WS-HOLD-CUSTOMER-NO                   
                                  WS-HOLD-PREMISE-NO                    
                                  WS-ONERATE-ANNIV-MO                   
                                  WS-FCTR-ANNIV-MONTH                   
                   MOVE SPACES TO WS-RATE-PLAN-NO                       
                                  WS-HOLD-COMPANY-NO                    
                                  WS-HOLD-DEST-CODE                     
                                  WS-HOLD-WQ-TEXT                       
                                  WS-HOLD-EFF-DATE-TO                   
                                  WS-INCENTIVE-SW                       
                                  WS-PROCESS-BG-SW                      
                                  WS-HOLD-EXT-BILLING-FL                
                   MOVE 'Y' TO WS-HOLD-OFFER-FLAG                       
                   MOVE E-FBE22-ACCOUNT-NO TO WS-ACCOUNT-NO-P           
                                              WS-ACCOUNT-NO-TEMP        
PRJ172         WHEN 0100                                                
PRJ172             PERFORM 8370-PROCESS-CU-REC THRU 8370-EXIT           
               WHEN 0300                                                
                   PERFORM 8300-PROCESS-ACCOUNT-REC THRU 8300-EXIT      
               WHEN 1910                                                
                   PERFORM 8310-PROCESS-BG-REC THRU 8310-EXIT           
               WHEN 1920                                                
                   PERFORM 8315-PROCESS-BC-REC THRU 8315-EXIT           
               WHEN 1930                                                
                   PERFORM 8320-PROCESS-BA-REC THRU 8320-EXIT           
A03583         WHEN 2100                                                
A03583             PERFORM 8321-PROCESS-CX-REC THRU 8321-EXIT           
               WHEN 2300                                                
                   PERFORM 8325-PROCESS-FH-REC THRU 8325-EXIT           
               WHEN 2500                                                
                   PERFORM 8335-PROCESS-BU-REC THRU 8335-EXIT           
               WHEN 5300                                                
                   PERFORM 8330-PROCESS-CZ-REC THRU 8330-EXIT           
               WHEN 6450                                                
                   PERFORM 8340-PROCESS-TIER-REC THRU 8340-EXIT         
               WHEN 6550                                                
                   PERFORM 8345-PROCESS-AG-REC THRU 8345-EXIT           
               WHEN 6650                                                
                   PERFORM 8355-PROCESS-YP-REC THRU 8355-EXIT           
               WHEN 6750                                                
                   PERFORM 8360-PROCESS-BT-REC THRU 8360-EXIT           
               WHEN OTHER                                               
                   CONTINUE                                             
           END-EVALUATE.                                                
           PERFORM 8000-READ-INPUT              THRU 8000-EXIT.         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08160000
      ****************************************************************  08170000
      * CALLS SCSCA195 SUBMODULE TO RETRIEVE GRP2 FIELDS, DO THE     *  08180000
      * WHOAMI FUNCTIONS, AND RETRIEVE DESCRIPTIONS FOR OPTION CODES.*  08190000
      ****************************************************************  08200000
       1200-CALL-SCSCA195.                                              
                                                                        
A04730        CALL SCSCA195    USING WS-CA195-GRP2-FIELDS               
                                     WS-BILLING-BG                      
                                     WS-BILL-DET-BT                     
                                     WS-FIXED-FCTR-HIST-FH              
                                     WS-ACCOUNT-AT                      
                                     WS-BILL-CALC-DETAIL                
                                     WS-ACCT-RTPK-AGR-DF                
                                     WS-BILL-ADJUST-DETAIL              
                                     WS-ACCT-ATTRIBUTE-YP               
                                     WS-ACCT-MKT-TIER-DD                
                                     CWS00328-FIELDS                    
I00177                               WS-SCSCA-RETURN-CODE               
I00177                               WS-CWS1000B-MAX-TBL-LIMITS.        
                                                                        
              IF WS-SCSCA-RETURN-CODE > 7                               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
              IF WS-SCSCA-RETURN-CODE > 0                               
                 DISPLAY 'SCSCA195: OPTION CODE NOT FOUND FOR ACCT '    
                 WS-CA195-HOLD-ACCOUNT-NO                               
                 ADD 1 TO WS-ABEND-CNT                                  
                 STRING 'SCSCA195: OPTION CODE NOT FOUND FOR ACCT '     
                    WS-CA195-HOLD-ACCOUNT-NO DELIMITED BY SIZE INTO     
                    WS-HOLD-WQ-COMMENTS                                 
                 PERFORM 7000-PROCESS-WQ THRU 7000-EXIT
              END-IF
              END-IF.                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08510000
      ******************************************************************08520000
      *      1300-CHECK-REBILL                                         *08530000
      * CHECK TO SEE IF THE ACCOUNT IS A REBILL.                       *08540000
      ******************************************************************08550000
       1300-CHECK-REBILL.                                               
                                                                        
           MOVE 0 TO WS-BG-CNT.                                         
           IF WS-CA195-HOLD-ACCOUNT-NO = 9999999999999                  
              GO TO 1300-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
              WS-SUB1 > 30 OR WS-ACCOUNT-NO-BG(WS-SUB1) = 0             
             IF WS-CODE-BILL-ITM-TYPE-BG(WS-SUB1)   = 'C' AND           
                WS-CODE-BILL-ITM-IND-BG(WS-SUB1)    = 'A' AND           
                WS-CODE-BILL-CALC-BG (WS-SUB1)      = 'A' AND           
               (WS-DATE-ORIG-BILL-BG (WS-SUB1) = SPACES OR LOW-VALUES)  
                MOVE WS-SUB1 TO WS-BG-CNT                               
                MOVE 31 TO WS-SUB1                                      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           IF WS-BG-CNT = 0                                             
              DISPLAY '*** THIS IS A REBILL ACCOUNT '                   
              WS-CA195-HOLD-ACCOUNT-NO ' ***'                           
              ADD 1 TO WS-ACCOUNT-REBILL                                
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08820000
      *      PROCESS THE 30 OR 60 DAY LETTERS.                         *08830000
      ******************************************************************08840000
       2000-PROCESS-LETTERS.                                            
                                                                        
           MOVE WS-CA195-HOLD-ACCOUNT-NO TO AT-ACCOUNT-NO               
                                          E-CA916-ACCOUNT-NO            
                                          WS-ACCOUNT-NO                 
                                          WS-ACCOUNT-NO-TEMP.           
                                                                        
           DISPLAY 'LETTER RECORD ' WS-ACCOUNT-NO.                      
           MOVE WS-BILL-CYCLE-AT  TO AT-BILL-CYCLE                      
                                     E-CA916-BILL-CYCLE.                
           MOVE WS-LOCAL-OFFICE-AT TO E-CA916-LOCAL-OFFICE              
           MOVE WS-COMPANY-NO-AT   TO E-CA916-COMPANY-NO                
           MOVE WS-CUSTOMER-NO-AT    TO E-CA916-CUSTOMER-NO.            
T37389     MOVE WS-ADDRESS-ID-AT     TO E-CA916-ADDRESS-ID.             
T37389     MOVE WS-ADDRESS-FORMAT-AT TO E-CA916-ADDRESS-FORMAT.         
T37389     MOVE '45'                 TO E-CA916-COMM-TYPE-CD.           
T37389     MOVE '02'                 TO E-CA916-COMM-SUBTYP-CD.         
PRJ172     MOVE WS-DHR-FL-CU         TO E-CA916-DHR-FLAG.               
                                                                        
           IF WS-AMT-MO-PYMT-BU NOT = 0                                 
              PERFORM 2500-GET-MONTHLY-PMT     THRU 2500-EXIT           
PRJ172        MOVE WS-REV-MTH-LST-NRML-AT        TO WS-REVENUE-MONTH    
PRJ172        MOVE WS-ANNIVERSARY-DATE-BU (6:2)  TO WS-EPP-ANNIV-MO     
PRJ172        MOVE WS-ANNIVERSARY-DATE-BU (1:4)  TO WS-EPP-ANNIV-YEAR   
PRJ172        COMPUTE WS-YEAR-DIFF-EPP =  WS-EPP-ANNIV-YEAR -           
PRJ172                                    WS-REV-YR                     
              IF (WS-YEAR-DIFF-EPP = 1)                                 
                 AND  WS-REV-MTH = WS-EPP-ANNIV-MO                      
PRJ172           MOVE 'Y'            TO WS-EPP-ANNIV-FLAG               
PRJ172        END-IF                                                    
PRJ211***********************************************************       09150000
PRJ211******* CHECK IF BUDGET BILLING IN SYNC WITH FIX RATE TERM*       09160000
PRJ211***********************************************************       09170000
PRJ211        IF (WS-REV-MTH - (WS-EPP-ANNIV-MO - 1)) = 0 OR            
PRJ211           (WS-REV-MTH - (WS-EPP-ANNIV-MO - 1)) = 12              
PRJ211           MOVE 'Y' TO WS-ANIV-BB-FIX-RR-FLG                      
PRJ211        END-IF                                                    
PRJ172     END-IF.                                                      
                                                                        
           MOVE WS-CA195-FREE-CSC-SW TO E-CA916-FREE-CSC-FLAG.          
           MOVE WS-CA195-OPTION-RATE TO WS-RATE-PLAN-NO                 
                                        E-RATE-PLAN-NO.                 
           MOVE WS-CA195-OPTION-DESC TO E-CA916-OPT-DESC-INT.           
                                                                        
           MOVE WS-CA195-FACTOR-FH     TO E-CA916-FACTOR-FH.            
           MOVE SPACES TO E-CA916-DDC-THERM-DESC                        
P805OP                    E-CA916-DROP-DDC-THERM-DESC.                  
                                                                        
           MOVE WS-CA195-REG-GROUP TO E-CA916-SEB-REG-GROUP.            
           MOVE WS-CA195-SENIOR-RATE-SW TO                              
                E-CA916-SEB-REG-SENIOR.                                 
PRJ477                                                                  
PRJ477     IF WS-ACCOUNT-TYPE-CODE-AT = 'R'                             
P00677           MOVE WS-SENIOR-FL-AT TO E-CA916-SENIOR-SW              
PRJ477     END-IF.                                                      
           MOVE 0 TO OUT-CNT.                                           
           MOVE 'N' TO WS-LETTER-SW.                                    
           MOVE  WS-BILL-PRT-MSG-CD TO                                  
                 E-CA916-BILL-PRT-MSG-CD.                               
                                                                        
A04730     PERFORM 2100-CHECK-FOR-FLEX-RATE THRU 2100-EXIT.             
           PERFORM 3260-GET-CUSTOMER-OPTIONS THRU 3260-EXIT.            
A05037     IF  WS-CA195-RATE-DEFINITION = '2'                           
A05037        SET TWO-PART-RATE TO TRUE                                 
A05037        MOVE WS-CA195-RATE-DEFINITION TO E-CA916-ALPHA-VARIABLE-5 
P805OP        IF WS-RET-RATE-PLAN-DDDC(1) > 0                           
A05037           MOVE WS-RET-RATE-PLAN-DDDC(1) TO WS-HOLD-DDC-FACTOR    
A05037           STRING '+($' WS-HOLD-DDC-FACTOR ' X DDDC)'             
A05037                DELIMITED BY SIZE INTO  E-CA916-DDC-THERM-DESC    
P805OP        END-IF                                                    
P805OP        IF WS-DROP-RATE-PLAN-DDDC > 0                             
P805OP           MOVE WS-DROP-RATE-PLAN-DDDC TO WS-HOLD-DROP-DDC-FACTOR 
P805OP           STRING '+($' WS-HOLD-DROP-DDC-FACTOR ' X DDDC)'        
P805OP             DELIMITED BY SIZE INTO  E-CA916-DROP-DDC-THERM-DESC  
P805OP        END-IF                                                    
A05037     END-IF.                                                      
A04730     PERFORM 2200-CHECK-FOR-INCENTIVE THRU 2200-EXIT.             
                                                                        
           IF RS-RETURN-CODE = +100                                     
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF NOT LETTER-OUTPUT                                         
              DISPLAY '*** ERROR ERROR ERROR ***'                       
              DISPLAY '*** ACCOUNT SHOULD BE PROCESSED ***'             
              DISPLAY '*** BYPASSED ACCOUNT ' WS-ACCOUNT-NO ' ***'      
              GO TO 2000-EXIT                                           
           END-IF.                                                      
P00805*****POPULATE TIER ACCOUNT TYPE CODE TO OUTPUT FILE               09650000
P00805     PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
P00805       WS-SUB1 > 1 OR WS-ACCOUNT-NO-DD(WS-SUB1) = 0               
P00805       MOVE WS-TIER-ACCT-TYPE-CD-DD (WS-SUB1) TO                  
P00805                                   E-CA916-TIER-ACCT-TYPE         
P00805     END-PERFORM.                                                 
P00805*                                                                 09710000
PRJ211*   *OLD30DAYS  OBSOLETE IN JANUARY 2010 CYCLE                    09720000
           EVALUATE TRUE                                                
PRJ211     WHEN PENDING-REMINDER-MSGS                                   
PRJ211          CONTINUE                                                
           WHEN FREE-BCR-EXP-MSG                                        
              MOVE  10203  TO E-CA916-MESSAGE-NO                        
              ADD 1 TO WS-10203-CNT                                     
P00677*                                                                 09790000
           WHEN RENEWAL-MSGS                                            
P00892           PERFORM 2400-CHECK-FOR-AUTO-RENEW THRU 2400-EXIT       
PRJ211           IF WS-CA195-REG-GROUP <= SPACE                         
P00805              IF WS-PEND-OPTN-EXIST-FL = 'Y'                      
P00805*             ***PENDING RATE***                                  09840000
P00892                 IF WS-ACCT-HAS-AUTO-RENEW = 'Y'                  
P00892                    MOVE  10215  TO E-CA916-MESSAGE-NO            
P00892                    ADD 1 TO WS-10215-CNT                         
P00892                 ELSE                                             
P00805                    MOVE  10210  TO E-CA916-MESSAGE-NO            
P00805                    ADD 1 TO WS-10210-CNT                         
P00892                 END-IF                                           
P00805              ELSE                                                
P00805                 IF E-CA916-TIER-ACCT-TYPE = 'S'                  
P00805*                ***SMALL COMMERCIAL***                           09940000
P00805                    MOVE  10209  TO E-CA916-MESSAGE-NO            
P00805                    ADD 1 TO WS-10209-CNT                         
P00805                 ELSE                                             
P00805                    IF WS-POOL-GROUP-FLAG = 'Y'                   
P00805*                   ***OUTER POOL CUSTOMERS***                    09990000
P00805                       MOVE  10502  TO E-CA916-MESSAGE-NO         
P00805                       ADD 1 TO WS-10502-CNT                      
P00805                    ELSE                                          
P00805*                   ***ALL OTHER ACCT TYPES***                    10030000
P00805                       MOVE  10206  TO E-CA916-MESSAGE-NO         
A05043                       PERFORM 2300-CHECK-FOR-SENIOR-RATE THRU    
A05043                                                       2300-EXIT  
P00805                       ADD 1 TO WS-10206-CNT                      
P00805                    END-IF                                        
P00805                 END-IF                                           
P00805              END-IF                                              
PRJ211           ELSE                                                   
P00677*                                                                 10120000
P00677******** CODE FOR GROUP-2 STARTS HERE **********************      10130000
P00677** IF THERE HAS BEEN A FAVORABLE TIER MOVEMENT (TO LOWER CSC)     10140000
P00677** USE THE 30D LETTER VERSION FOR GOOD PAYMENTS (10208)           10150000
P00677** ELSE USE THE OTHER VERSION (10207)                             10160000
P00677*                                                                 10170000
P00677              MOVE WS-CA195-REG-SW TO WS-ACCT-TIER-CHANGED        
P00677              IF TIER-HAS-CHANGED AND                             
P00677                 WS-RET-ADJ-SOURCE-CD(1) = 'L'                    
P00677                    MOVE 10208 TO E-CA916-MESSAGE-NO              
P00677                    ADD 1 TO WS-10208-CNT                         
P00677              ELSE                                                
P00677                    MOVE 10207 TO E-CA916-MESSAGE-NO              
P00677                    ADD 1 TO WS-10207-CNT                         
P00677*                                                                 10260000
P00677** IF THERE HAS BEEN AN UNFAVORABLE TIER MOVEMENT (TO HIGHER CSC) 10270000
P00677** FLAG CSC-REVERT-SW 10207 TO INCLUDE MISSED PAYMENT CLAUSE      10280000
P00677*                                                                 10290000
P00677                    IF TIER-HAS-CHANGED AND                       
P00677                       WS-RET-ADJ-SOURCE-CD(1) = 'H'              
P00677                      MOVE 'Y' TO E-CA916-CSC-REVERT-SW           
P00677                    END-IF                                        
P00677              END-IF                                              
PRJ211           END-IF                                                 
PRJ211           IF WS-ANIV-BB-FIX-RR-FLG = 'N'                         
PRJ211              MOVE ZERO         TO E-CA916-EPP-AMOUNT             
PRJ211              MOVE ZERO         TO E-CA916-EPP-AMOUNT-NEW         
PRJ211           END-IF                                                 
           END-EVALUATE.                                                
                                                                        
           MOVE WS-CURRENT-DATE(3:2) TO                                 
                E-CA916-STATEMENT-DATE(1:2)                             
           MOVE WS-CURRENT-DATE(6:2) TO                                 
                E-CA916-STATEMENT-DATE(3:2)                             
           MOVE WS-CURRENT-DATE(9:2) TO                                 
                E-CA916-STATEMENT-DATE(5:2)                             
PRJ166     MOVE WS-CURRENT-DATE           TO E-CA916-PROCESS-DATE       
           MOVE WS-CA195-GRP2-PUB-FIX-PRC TO E-CA916-GRP2-PUB-FIX-PRC   
           MOVE WS-CA195-GRP2-PUB-FIX-DESC TO                           
                 E-CA916-GRP2-PUB-FIX-DESC.                             
                                                                        
           COMPUTE E-CA916-GRP2-RENEW-DSC =                             
                WS-CA195-GRP2-PUB-FIX-PRC -                             
                WS-RET-THERM-PRICE(1).                                  
                                                                        
           MOVE WS-CA195-GRP2-PUB-VAR-PRC TO E-CA916-GRP2-PUB-VAR-PRC.  
           MOVE WS-CA195-GRP2-PUB-VAR-DESC TO                           
                 E-CA916-GRP2-PUB-VAR-DESC.                             
           MOVE WS-CA195-GRP2-HIGH-CSC-AMT TO E-CA916-GRP2-HIGH-CSC-AMT.
           MOVE WS-CA195-GRP2-MED-CSC-AMT TO E-CA916-GRP2-MED-CSC-AMT.  
           MOVE WS-CA195-GRP2-LOW-CSC-AMT TO E-CA916-GRP2-LOW-CSC-AMT.  
                                                                        
PRJ245     MOVE WS-CA195-GRP2-LOW-CSC-GOOD  TO E-CA916-NUM-VARIABLE-1.  
PRJ245     MOVE WS-CA195-GRP2-MED-CSC-GOOD  TO E-CA916-NUM-VARIABLE-2.  
T37389     MOVE WS-NBR-MISSED-PAYMENT-CZ  TO E-CA916-NBR-MISSED-PAYMENT.
T37389     MOVE WS-NBR-GOOD-PAYMENT-CZ    TO E-CA916-NBR-GOOD-PYMTS.    
PRJ245     MOVE WS-CA195-NBR-MISSED-PAYMENT   TO E-CA916-NUM-VARIABLE-3.
PRJ245     MOVE WS-CA195-GRP2-LOW-CSC-FIX-DSC TO E-CA916-NUM-VARIABLE-4.
T37389     IF WS-BILL-PRT-MSG-CD   = 'FPL'                              
T37389        MOVE 'Y' TO E-CA916-LOWEST-CSC-SW
           END-IF.                        
                                                                        
           MOVE WS-CA195-CURRENT-CSC-AMT TO E-CA916-CURR-CSC.           
           MOVE WS-CA195-TIER-SW         TO E-CA916-TIER-ACCT-SW.       
                                                                        
           PERFORM 3280-GET-NEXT-BILL-CYC THRU 3280-EXIT.               
           MOVE 'C00920'             TO E-CA916-RECORD-KEY.             
                                                                        
           EVALUATE E-CA916-EXCEPTION-SW                                
               WHEN ' '                                                 
                   MOVE WS-HOLD-DEST-CODE TO E-CA916-EXCEPTION-SW       
               WHEN OTHER                                               
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
           PERFORM 8500-WRITE-OUTPUT      THRU 8500-EXIT.               
           PERFORM 8200-UPD-TRANS-HIST    THRU 8200-EXIT.               
           PERFORM 8210-INSERT-CUST-COMM  THRU 8210-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10920000
      ********************************************************          10930000
      *  CHECK TO SEE IF CURRENT RATE IS A FLEX RATE.        *          10940000
      ********************************************************          10950000
A04730 2100-CHECK-FOR-FLEX-RATE.                                        
A04730      MOVE ' '        TO E-CA916-CURR-RATE-IS-FLEX.               
P00892      MOVE ZEROES     TO WS-HOLD-RT-PKG-SEQ-NO.                   
P00892      MOVE SPACES     TO WS-HOLD-STATUS-CHG-DT.                   
A04730                                                                  
A04730      PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL           
A04730        WS-BILLING-INDX > 30 OR                                   
A04730        WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = 0                     
A04730        IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C' AND    
A04730           WS-CODE-BILL-ITM-IND-BG(WS-BILLING-INDX) = 'A' AND     
A04730           WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) = 'A'            
A04730           PERFORM VARYING WS-RTPK-INDX FROM 1 BY 1 UNTIL         
A04730             WS-RTPK-INDX > 25 OR                                 
A04730             WS-ACCOUNT-NO-DF(WS-RTPK-INDX) = 0                   
A04730             IF WS-ACCOUNT-NO-DF(WS-RTPK-INDX) =                  
A04730                   WS-ACCOUNT-NO-BG(WS-BILLING-INDX) AND          
A04730                WS-CODE-UTIL-TYPE-DF(WS-RTPK-INDX) =              
A04730                   WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) AND      
A04730                WS-IC-NO-DF(WS-RTPK-INDX)  =                      
A04730                   WS-IC-NO-BG(WS-BILLING-INDX) AND               
A04730                WS-RT-PKG-OPT-SEQ-NO-DF(WS-RTPK-INDX) =           
A04730                   WS-RT-PKG-OPT-SEQ-NO-BG(WS-BILLING-INDX) AND   
A04730               (WS-REBILL-IMMEDIATE-FLAG = 'Y' OR                 
A04730               (WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX))           
A04730                                          = SPACES OR LOW-VALUES) 
A04730                IF WS-STAT-ADJUSTABLE-CD-DF (WS-RTPK-INDX) = 'A'  
A04730                OR WS-STAT-ADJUSTABLE-CD-DF (WS-RTPK-INDX) = 'E'  
A04730                   MOVE 'Y'        TO E-CA916-CURR-RATE-IS-FLEX   
A04730                END-IF                                            
P00892                MOVE WS-RT-PKG-OPT-SEQ-NO-DF(WS-RTPK-INDX) TO     
P00892                     WS-HOLD-RT-PKG-SEQ-NO                        
P00892                MOVE WS-STATUS-CHANGE-DT-DF(WS-RTPK-INDX) TO      
P00892                     WS-HOLD-STATUS-CHG-DT                        
A04730             END-IF                                               
A04730           END-PERFORM                                            
A04730        END-IF                                                    
A04730      END-PERFORM.                                                
A04730*                                                                 11330000
A04730 2100-EXIT.                                                       
A04730     EXIT.                                                        
A04730*                                                                 11360000
      ********************************************************          11370000
      *  CHECK TO SEE IF CURRENT RATE HAS INCENTIVES.        *          11380000
      *  ALL ENTRIES FOR ADJRATE-ATTR NEED TO BE SPACES      *          11390000
      *  FOR A RATE/OPTION TO HAVE INCENTIVES.               *          11400000
      ********************************************************          11410000
A04730 2200-CHECK-FOR-INCENTIVE.                                        
A04730     MOVE SPACES TO E-CA916-FLEX-RATE-HAS-INCTV.                  
A04730                                                                  
A04730     PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
A04730       WS-SUB1 > 5 OR E-CA916-REN-OPT-CD (WS-SUB1) = SPACES       
A04730       IF E-CA916-REN-ADJRATE-ATTR (WS-SUB1) = 'Y'                
A04730          MOVE 'Y' TO E-CA916-FLEX-RATE-HAS-INCTV                 
A04730       END-IF                                                     
A04730     END-PERFORM.                                                 
A04730*                                                                 11510000
A04730 2200-EXIT.                                                       
A04730     EXIT.                                                        
A04730*                                                                 11540000
      ********************************************************          11550000
      *  CHECK TO SEE IF THE CURRENT RATE IS A SENIOR RATE.  *          11560000
      *  THE CENTS OFF IS CHANGING FOR RATES 149 AND 152.    *          11570000
      *  149 WILL RECEIVE A .03 DISCOUNT 152 NO DISCOUNT.    *          11580000
      ********************************************************          11590000
A05043 2300-CHECK-FOR-SENIOR-RATE.                                      
A05043     MOVE SPACES TO E-CA916-ALPHA-VARIABLE-1.                     
A05043                                                                  
A05043     MOVE 1                         TO WS-SUB1                    
A05043                                       WS-SUB2.                   
A05043     PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
A05043        WS-SUB1 > 30 OR WS-ACCOUNT-NO-BG(WS-SUB1) = 0             
A05043        IF WS-CODE-BILL-ITM-TYPE-BG(WS-SUB1) = 'C'                
A05043        AND WS-CODE-BILL-ITM-IND-BG(WS-SUB1) = 'A'                
A05043        AND WS-CODE-BILL-CALC-BG(WS-SUB1) = 'A'                   
A05043        AND WS-RATE-PLAN-NO-BG(WS-SUB1) = '149' OR '152'          
A05043        PERFORM VARYING WS-SUB2 FROM 1 BY 1 UNTIL                 
A05043        WS-SUB2 > 30 OR WS-ACCOUNT-NO-DF(WS-SUB2) = 0             
A05043           IF WS-ACCOUNT-NO-DF(WS-SUB2) =                         
A05043                                       WS-ACCOUNT-NO-BG(WS-SUB1)  
A05043           AND WS-CODE-UTIL-TYPE-DF(WS-SUB2) =                    
A05043                                     WS-CODE-UTIL-TYPE-BG(WS-SUB1)
A05043           AND WS-IC-NO-DF(WS-SUB2) = WS-IC-NO-BG(WS-SUB1)        
A05043           AND WS-RT-PKG-OPT-SEQ-NO-DF(WS-SUB2) =                 
A05043                                 WS-RT-PKG-OPT-SEQ-NO-BG(WS-SUB1) 
A05043               IF WS-STATUS-EFF-REV-MTH-DF(WS-SUB2) < 201411      
A05043                  IF WS-RATE-PLAN-NO-BG(WS-SUB1) = '149'          
A05043                     MOVE 'SRP' TO E-CA916-ALPHA-VARIABLE-1       
A05043                  ELSE                                            
A05043                     MOVE 'SARP' TO E-CA916-ALPHA-VARIABLE-1      
A05043                  END-IF                                          
A05043               END-IF                                             
A05043           END-IF                                                 
A05043        END-PERFORM                                               
A05043        END-IF                                                    
A05043     END-PERFORM.                                                 
A05043*                                                                 11910000
A05043 2300-EXIT.                                                       
A05043     EXIT.                                                        
A05043*                                                                 11940000
      ********************************************************          11950000
      *  CHECK TO SEE IF THE ACCOUNT HAS ALREADY OPTED IN TO *          11960000
      *  THE FIXED RATE AUTO RENEWAL PROGRAM.                *          11970000
      ********************************************************          11980000
P00892 2400-CHECK-FOR-AUTO-RENEW.                                       
P00892      MOVE 'N'        TO WS-ACCT-HAS-AUTO-RENEW.                  
P00892                                                                  
P00892      MOVE 1                         TO WS-SUB1.                  
P00892      PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                   
P00892        WS-SUB1 > 25                                              
P00892        OR WS-ACCOUNT-NO-DF(WS-SUB1) = 0                          
P00892           IF WS-STATUS-CD-DF(WS-SUB1) = 'P'                      
P00892           AND WS-AGREEMNT-SOURCE-CD-DF(WS-SUB1) = 'FAR'          
P00892           AND WS-CA195-DUR-REM-MONTHS = 2                        
P00892              MOVE 'Y'        TO WS-ACCT-HAS-AUTO-RENEW           
P00892           END-IF                                                 
P00892      END-PERFORM.                                                
P00892*                                                                 12120000
P00892 2400-EXIT.                                                       
P00892     EXIT.                                                        
P00892*                                                                 12150000
      ********************************************************          12160000
      *  GET MONTHLY BUDGET BILLING PAYMENT (EPP).           *          12170000
      ********************************************************          12180000
       2500-GET-MONTHLY-PMT.                                            
      *                                                                 12200000
           INITIALIZE BU-AMT-MO-PYMT.                                   
           MOVE WS-ACCOUNT-NO TO BU-ACCOUNT-NO.                         
           PERFORM 8850-SELECT-BUDGET-BILLING-AMT THRU 8850-EXIT.       
           MOVE WS-AMT-MO-PYMT-BU TO E-CA916-EPP-AMOUNT.                
           MOVE BU-AMT-MO-PYMT TO E-CA916-EPP-AMOUNT-NEW.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12290000
      ********************************************************          12300000
      *  RESOLVE THE OPTION CODES AND RETRIEVE VALUES.       *          12310000
      ********************************************************          12320000
       3260-GET-CUSTOMER-OPTIONS.                                       
                                                                        
P00892     INITIALIZE DCLCSS-ACT-RT-RENEWAL                             
P00892                DCLCSS-ACT-RT-REN-DET.                            
P00892     MOVE ZEROES             TO WS-MAX-RT-REN-SEQ-NO.             
           MOVE WS-CA195-OPTION-CD TO WS-IN-OPTION-CD.                  
           MOVE WS-ACCOUNT-NO TO WS-IN-ACCOUNT-NO                       
                                 WS-ACCOUNT-NO-063                      
P00892                           5A-ACCOUNT-NO.                         
           MOVE WS-CODE-UTIL-TYPE TO WS-IN-CODE-UTIL-TYPE               
P00892                               5A-CODE-UTIL-TYPE.                 
           MOVE WS-IC-NO TO WS-IN-IC-NO                                 
P00892                      5A-IC-NO.                                   
           MOVE PROGRAM-NAME TO WS-CPD00328-CALLING-PGM.                
P00892     MOVE 'SYSTEM'     TO 5A-LAST-UPDATE-USERID.                  
           MOVE 0 TO WS-SUB-CTR WS-RET-CODE.                            
           MOVE 'N' TO WS-ROWS.                                         
P00805     MOVE 'Y' TO WS-GET-PEND-PRICE-SW-328.                        
                                                                        
A04730     CALL SCSCA328    USING CWS00328-FIELDS,                      
                                  WS-RESULT-TABLE,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           IF RS-RETURN-CODE = +100                                     
              DISPLAY '**  OPTION CODE NOT FOUND FOR CUSTOMER    **'    
              DISPLAY 'ACCOUNT NUMBER ' WS-ACCOUNT-NO-063               
              DISPLAY 'OPTION CODE    ' WS-CA195-OPTION-CD              
A02003        STRING 'PCSCA916:3260 OPTION CODE ' WS-CA195-OPTION-CD    
                 ' NOT FOUND FOR ACCOUNT ' WS-ACCOUNT-NO-063            
A02003           ' IN SCSCA328 ' DELIMITED BY SIZE                      
                 INTO WS-HOLD-WQ-COMMENTS                               
              ADD 1 TO WS-ABEND-CNT                                     
              PERFORM 7000-PROCESS-WQ THRU 7000-EXIT                    
              GO TO 3260-EXIT
           END-IF.                                          
                                                                        
           IF RS-RETURN-CODE NOT = +0                                   
              DISPLAY '**  ERROR ON 3260-GET-CUSTOMER-OPTIONS    **'    
              DISPLAY '**  RETURN CODE    = ' RS-RETURN-CODE            
              DISPLAY 'ACCOUNT NUMBER ' WS-ACCOUNT-NO                   
              DISPLAY 'OPTION CODE    ' WS-CA195-OPTION-CD              
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              GO TO 3260-EXIT
           END-IF.                                          
                                                                        
           MOVE WS-SUB-CTR TO OUT-CNT.                                  
                                                                        
           IF WS-SUB-CTR < 1                                            
           OR WS-LETTER-SW = 'Y'                                        
              GO TO 3260-EXIT
           END-IF.                                          
                                                                        
                                                                        
A03019     INITIALIZE WS-HOLD-RENEWAL-OPTIONS                           
A03019                WS-SORT-RENEWAL-OPTIONS.                          
A03019     MOVE 1 TO WS-HOLD-SUB                                        
P00805               WS-SUB1                                            
P00805     IF WS-PEND-OPTN-EXIST-FL = 'Y'                               
P805CS        MOVE WS-PEND-CURR-EXT-DESC-LONG            TO             
P00805                       E-CA916-REN-OPT-DES(WS-SUB1)               
P00805        MOVE WS-PEND-THERM-PRICE                   TO             
P00805                       E-CA916-REN-OPT-PRICE(WS-SUB1)             
P00805        MOVE WS-PEND-CSC-AMT                       TO             
P00805                       E-CA916-REN-OPT-CSC(WS-SUB1)               
P00805        MOVE WS-PEND-OPTN-VALID-MNTHS              TO             
P00805                       E-CA916-REN-OPT-MONTHS(WS-SUB1)            
P00805        MOVE WS-PEND-OPT-START-DATE                TO             
P00805                       E-CA916-PEND-OPT-START-DATE                
P00805        MOVE WS-PEND-OPT-END-DATE                  TO             
P00805                       E-CA916-PEND-OPT-END-DATE                  
P00805        MOVE WS-PEND-EXIT-FEE                      TO             
P00805                       E-CA916-EXIT-FEE-AMT(WS-SUB1)              
P00805        MOVE WS-CURR-OPT-END-DATE                  TO             
P00805                       E-CA916-CURR-OPT-END-DATE                  
P00805        MOVE WS-PEND-PRICE-DISC-TABLE              TO             
P00805                       E-CA916-PRICE-DISC-TABLE                   
P00805        MOVE WS-PEND-CSC-DISC-TABLE                TO             
P00805                       E-CA916-CSC-DISC-TABLE                     
P00892        MOVE WS-PEND-AUTO-REN-OPT-IN-FL            TO             
P00892                       E-CA916-PEND-AUTO-REN-OPT-IN               
P00805     ELSE                                                         
P00892        MOVE WS-CURR-AUTO-REN-OPT-IN-FL            TO             
P00892                       E-CA916-CURR-AUTO-REN-OPT-IN               
P00892        MOVE 'Y'                                   TO             
P00892                       E-CA916-AUTO-REN-FL                        
P00892******** ADD PARA HERE TO CSS_ACT_RT_RENEWAL                      13160000
P00892     PERFORM 3265-GET-MAX-SEQ-NO THRU 3265-EXIT                   
P00892     COMPUTE 5A-SEQ-NO = WS-MAX-RT-REN-SEQ-NO + 1                 
P00892     MOVE WS-INPUT-DATE              TO 5A-OFFERED-DT             
P00892     IF WS-HOLD-STATUS-CHG-DT > SPACES                            
P00892        MOVE WS-HOLD-STATUS-CHG-DT   TO 5A-STATUS-CHANGE-DT       
P00892     ELSE                                                         
P00892        MOVE WS-CURRENT-DATE         TO 5A-STATUS-CHANGE-DT       
P00892     END-IF                                                       
P00892     MOVE WS-HOLD-RT-PKG-SEQ-NO      TO 5A-RT-PKG-OPT-SEQ-NO      
P00892     MOVE SPACES                     TO 5A-OFFER-CD               
P00892     MOVE 'O'                        TO 5A-STATUS-CD              
P00892     PERFORM 3270-INSERT-RATE-RENEWAL THRU 3270-EXIT              
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
A02003       UNTIL WS-SUB1 > (OUT-CNT - 1) OR WS-SUB1 > 3               
P00892         MOVE WS-ACCOUNT-NO     TO 5B-ACCOUNT-NO                  
P00892         MOVE WS-CODE-UTIL-TYPE TO 5B-CODE-UTIL-TYPE              
P00892         MOVE WS-IC-NO          TO 5B-IC-NO                       
P00892         MOVE 5A-SEQ-NO         TO 5B-SEQ-NO                      
P00892         MOVE WS-SUB1           TO 5B-OPTION-SORT-NO              
               MOVE WS-RET-OPTION-CD(WS-SUB1) TO                        
A02003              E-CA916-REN-OPT-CD(WS-SUB1)                         
P00892              5B-OPTION-CD                                        
               MOVE WS-RET-CURR-EXT-DESC-LONG (WS-SUB1) TO              
A02003              E-CA916-REN-OPT-DES(WS-SUB1)                        
P00477         IF WS-RET-RATE-DEF-CD(WS-SUB1) = '2'                     
P00477            MOVE WS-RET-RATE-DEF-CD(WS-SUB1) TO                   
P00477                 E-CA916-ALPHA-VARIABLE-3                         
A03019            INITIALIZE WS-EMB-INPUT                               
A03019                       WS-EMB-LENG                                
A03019                       WS-CMP-TABLE                               
A03019                                                                  
A03019            COMPUTE WS-EMB-LENG = FUNCTION                        
A03019            LENGTH(E-CA916-REN-OPT-DES(WS-SUB1))                  
A03019            MOVE E-CA916-REN-OPT-DES(WS-SUB1) TO                  
A03019                 WS-EMB-INPUT                                     
A03019            PERFORM 6010-REDUCE-EMBEDDED-SPACES                   
A03019            THRU    6010-EXIT                                     
A03019            SET WS-CMP-INDX DOWN BY 1                             
A03019            MOVE '*' TO WS-CMP-CHAR(WS-CMP-INDX)                  
A03019            MOVE WS-CMP-TABLE TO E-CA916-REN-OPT-DES(WS-SUB1)     
A03019         END-IF                                                   
               MOVE WS-RET-OPTN-VALID-MNTHS(WS-SUB1) TO                 
A02003              E-CA916-REN-OPT-MONTHS(WS-SUB1)                     
P00892              5B-DURATION-NO                                      
A03019*        ITERATE THROUGH THE HOLDING TABLE TO DETERMINE WHERE     13610000
A03019*        THE NEXT VALUE GOES                                      13620000
A03019         PERFORM VARYING WS-SUB2 FROM 1 BY 1                      
A03019         UNTIL WS-SUB2 > WS-SUB1                                  
A03019         OR    WS-HOLD-ESCAPE-FLAG NOT = SPACE                    
A03019         OR    WS-HOLD-SUB > 3                                    
A03019               EVALUATE TRUE                                      
A03019               WHEN WS-RET-OPTN-VALID-MNTHS(WS-SUB1) =            
A03019                  WS-HOLD-REN-OPT(WS-SUB2)                        
A03019*                 DUPLICATE DETECTED, DISCARD IT, STOP            13700000
A03019*                 ITERATING                                       13710000
A03019                  MOVE 'Y' TO WS-HOLD-ESCAPE-FLAG                 
A03019                  CONTINUE                                        
A03019               WHEN WS-RET-OPTN-VALID-MNTHS(WS-SUB1) <            
A03019                    WS-HOLD-REN-OPT(WS-SUB2)                      
A03019               AND  WS-HOLD-ESCAPE-FLAG = SPACE                   
A03019*                 NEW ELEMENT LESS THAN AN EXISTING ELEMENT;      13770000
A03019*                 MOVE ELEMENTS IN HOLD TABLE TO THE RIGHT TO MAKE13780000
A03019*                 ROOM AND STOP ITERATING                         13790000
A03019                    PERFORM VARYING WS-SUB3 FROM WS-HOLD-SUB      
A03019                    BY -1 UNTIL WS-SUB3 = WS-SUB2                 
A03019                        MOVE WS-HOLD-REN-OPT(WS-SUB3 - 1) TO      
A03019                             WS-HOLD-REN-OPT(WS-SUB3)             
A03019                    END-PERFORM                                   
A03019                    MOVE WS-RET-OPTN-VALID-MNTHS(WS-SUB1) TO      
A03019                         WS-HOLD-REN-OPT(WS-SUB2)                 
A03019                    ADD 1 TO WS-HOLD-SUB                          
A03019                    MOVE 'Y' TO WS-HOLD-ESCAPE-FLAG               
A03019                    CONTINUE                                      
A03019               WHEN WS-HOLD-REN-OPT(WS-SUB2) = ZERO               
A03019               AND  WS-HOLD-ESCAPE-FLAG = SPACE                   
A03019*                   ITERATED TO EMPTY FIELD, THEREFORE NEW        13920000
A03019*                   ELEMENT IS GREATER THAN EXISTING ONES IN TABLE13930000
A03019                    MOVE WS-RET-OPTN-VALID-MNTHS(WS-SUB1) TO      
A03019                         WS-HOLD-REN-OPT(WS-SUB2)                 
A03019                    ADD 1 TO WS-HOLD-SUB                          
A03019               END-EVALUATE                                       
A03019         END-PERFORM                                              
A03019         MOVE SPACE TO WS-HOLD-ESCAPE-FLAG                        
               MOVE WS-RET-THERM-PRICE(WS-SUB1) TO                      
A02003              E-CA916-REN-OPT-PRICE(WS-SUB1)                      
P00892              5B-THERM-PRICE                                      
               MOVE WS-RET-CSC-AMT(WS-SUB1) TO                          
A02003              E-CA916-REN-OPT-CSC(WS-SUB1)                        
P00892              5B-AMT-CUST-CHRG                                    
               MOVE WS-RET-EXIT-FEE(WS-SUB1) TO                         
A02003              E-CA916-EXIT-FEE-AMT(WS-SUB1)                       
A04730         MOVE WS-RET-ADJRATE-ATTR(WS-SUB1) TO                     
A04730              E-CA916-REN-ADJRATE-ATTR(WS-SUB1)                   
P00892         MOVE WS-RET-AUTO-RENEWAL-FL(WS-SUB1) TO                  
P00892              5B-AUTO-RENEWAL-FL                                  
P00892         MOVE WS-RET-RENEWAL-OFFER-CD(WS-SUB1) TO 5B-OFFER-CD     
P00892         IF WS-RET-AUTO-RENEWAL-FL(WS-SUB1) NOT = 'Y'             
P00892            MOVE 'N' TO E-CA916-AUTO-REN-FL                       
P00892         END-IF                                                   
A02003         IF WS-SUB1 = 1                                           
A02003              MOVE WS-RET-CSC-AMT(WS-SUB1) TO                     
A02003                   E-CA916-NEW-CSC                                
A02003              MOVE WS-RET-TIER-SOURCE-CD(WS-SUB1) TO              
A02003                   E-CA916-RET-TIER-SOURCE-CD                     
A02003         END-IF                                                   
P00892******* ADD PARA TO ADD TO CSS_ACT_RT_REN_DET                     14220000
P00892         PERFORM 3275-INSERT-RATE-REN-DET THRU 3275-EXIT          
P00892         INITIALIZE DCLCSS-ACT-RT-REN-DET                         
P00805     END-PERFORM                                                  
P00477     MOVE WS-DROP-OPTION-DESC             TO                      
                                    E-CA916-DROP-DESC                   
P00477     MOVE WS-DROP-OPTION-THERM-PRICE      TO                      
P00805                              E-CA916-DROP-PRICE                  
P00477     MOVE WS-DROP-OPTION-CSC              TO                      
P00805                              E-CA916-DROP-CSC                    
A04106     MOVE WS-AMT-RETN-DISCOUNT            TO                      
P00805                              E-CA916-NUM-VARIABLE-5              
A04106     MOVE WS-PRINT-RETN-MSG-FL            TO                      
P00805                              E-CA916-ALPHA-VARIABLE-4            
A03019     MOVE WS-HOLD-REN-OPT(1) TO WS-SORT-REN-OPT(1)                
A03019     MOVE WS-HOLD-REN-OPT(2) TO WS-SORT-REN-OPT(2)                
A03019     MOVE WS-HOLD-REN-OPT(3) TO WS-SORT-REN-OPT(3)                
P00805     END-IF.                                                      
                                                                        
P805CS     MOVE WS-AUTO-REN-DSC-ELIG-FL TO E-CA916-AUTO-REN-DSC-ELIG-FL.
P805CS     MOVE WS-PAPERLESS-DSC-ELIG-FL TO                             
P805CS                              E-CA916-PAPERLESS-DSC-ELIG-FL.      
P805CS     MOVE WS-LEGACY-FIXED-RATE-FL TO E-CA916-LEGACY-FIX-RT-FL.    
P805CS     MOVE WS-OLD-CSC-RATE-PLAN-FL TO E-CA916-OLD-CSC-RATE-FL.     
P805CS     MOVE WS-AUTO-RENEW-DSC-ELIG-AMT TO                           
P805CS                              E-CA916-AUTO-RENEW-DSC-AMT.         
P805CS     MOVE WS-PAPERLESS-DSC-ELIG-AMT TO E-CA916-PAPERLESS-DSC-AMT. 
P00805     MOVE WS-NEW-RATE-BILL-DT TO E-CA916-NEW-RATE-BILL-DT.        
P805CS                                                                  
A03019     EVALUATE TRUE                                                
A03019        WHEN WS-HOLD-SUB = 2                                      
A03019               MOVE WS-SORT-REN-OPT(1) TO E-CA916-ALPHA-VARIABLE-2
A03019        WHEN WS-HOLD-SUB = 3                                      
A03019            STRING WS-SORT-REN-OPT(1)                             
A03019                   ' OR '                                         
A03019                   WS-SORT-REN-OPT(2)                             
A03019             DELIMITED BY SIZE                                    
A03019             INTO E-CA916-ALPHA-VARIABLE-2                        
A03019            END-STRING                                            
A03019        WHEN WS-HOLD-SUB = 4                                      
A03019             STRING WS-SORT-REN-OPT(1)                            
A03019                    ', '                                          
A03019                    WS-SORT-REN-OPT(2)                            
A03019                    ' OR '                                        
A03019                    WS-SORT-REN-OPT(3)                            
A03019             DELIMITED BY SIZE                                    
A03019             INTO E-CA916-ALPHA-VARIABLE-2                        
A03019            END-STRING                                            
A03019     END-EVALUATE.                                                
           MOVE 'Y' TO WS-LETTER-SW.                                    
                                                                        
       3260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14750000
      ********************************************************          14760000
      *  GET MAX SEQ NO FROM CSS_ACT_RT_RENEWAL              *          14770000
      ********************************************************          14780000
P00892 3265-GET-MAX-SEQ-NO.                                             
P00892     EXEC SQL                                                     
P00892        SELECT MAX (SEQ_NO)                                       
P00892          INTO :WS-MAX-RT-REN-SEQ-NO                              
P00892          FROM CSS_ACT_RT_RENEWAL WITH(READUNCOMMITTED)                   
P00892        WHERE ACCOUNT_NO = :5A-ACCOUNT-NO                         
P00892        GROUP BY ACCOUNT_NO                                       
P00892                                                           
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14800000
MFA-TR*       SELECT MAX (SEQ_NO)                                       14810000
MFA-TR*         INTO :WS-MAX-RT-REN-SEQ-NO                              14820000
MFA-TR*         FROM CSS_ACT_RT_RENEWAL                                 14830000
MFA-TR*       WHERE ACCOUNT_NO = :5A-ACCOUNT-NO                         14840000
MFA-TR*       GROUP BY ACCOUNT_NO                                       14850000
MFA-TR*       WITH UR                                                   14860000
MFA-TR*    END-EXEC.                                                    14870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892*                                                                 14880000
P00892     IF SQLCODE = 0 OR 100                                        
P00892         CONTINUE                                                 
P00892     ELSE                                                         
P00892         DISPLAY '**  ERROR ON 3265-GET-MAX-SEQ-NO      **'       
P00892         DISPLAY '**  COULD NOT MAX SEQ NUMBER          **'       
P00892         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
P00892         DISPLAY '**  ACCOUNT-NO     = ' 5A-ACCOUNT-NO            
P00892         PERFORM 9900-ABEND                THRU 9900-EXIT         
P00892     END-IF.                                                      
P00892                                                                  
P00892 3265-EXIT.                                                       
P00892     EXIT.                                                        
      *                                                                 15010000
      ********************************************************          15020000
      *  INSERT INTO CSS_ACT_RT_RENEWAL                      *          15030000
      ********************************************************          15040000
P00892 3270-INSERT-RATE-RENEWAL.                                        
P00892     EXEC SQL                                                     
P00892          INSERT INTO CSS_ACT_RT_RENEWAL                          
P00892                  (ACCOUNT_NO,                                    
P00892                   CODE_UTIL_TYPE,                                
P00892                   IC_NO,                                         
P00892                   SEQ_NO,                                        
P00892                   RT_PKG_OPT_SEQ_NO,                             
P00892                   OFFERED_DT,                                    
P00892                   STATUS_CD,                                     
P00892                   OFFER_CD,                                      
P00892                   STATUS_CHANGE_DT,                              
P00892                   LAST_UPDATE_TS,                                
P00892                   LAST_UPDATE_USERID)                            
P00892          VALUES  (:5A-ACCOUNT-NO,                                
P00892                   :5A-CODE-UTIL-TYPE,                            
P00892                   :5A-IC-NO,                                     
P00892                   :5A-SEQ-NO,                                    
P00892                   :5A-RT-PKG-OPT-SEQ-NO,                         
P00892                   IIF(TRY_CONVERT(DATE, :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) ),                              
P00892                   :5A-STATUS-CD,                                 
P00892                   :5A-OFFER-CD,                                  
P00892                   IIF(TRY_CONVERT(DATE, :5A-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:5A-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:5A-STATUS-CHANGE-DT
              ), CONVERT(DATE, :5A-STATUS-CHANGE-DT) ),                        
P00892                   CIS.CURRENT$TIMESTAMP(),                             
P00892                   :5A-LAST-UPDATE-USERID)                        
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15060000
MFA-TR*         INSERT INTO CSS_ACT_RT_RENEWAL                          15070000
MFA-TR*                 (ACCOUNT_NO,                                    15080000
MFA-TR*                  CODE_UTIL_TYPE,                                15090000
MFA-TR*                  IC_NO,                                         15100000
MFA-TR*                  SEQ_NO,                                        15110000
MFA-TR*                  RT_PKG_OPT_SEQ_NO,                             15120000
MFA-TR*                  OFFERED_DT,                                    15130000
MFA-TR*                  STATUS_CD,                                     15140000
MFA-TR*                  OFFER_CD,                                      15150000
MFA-TR*                  STATUS_CHANGE_DT,                              15160000
MFA-TR*                  LAST_UPDATE_TS,                                15170000
MFA-TR*                  LAST_UPDATE_USERID)                            15180000
MFA-TR*         VALUES  (:5A-ACCOUNT-NO,                                15190000
MFA-TR*                  :5A-CODE-UTIL-TYPE,                            15200000
MFA-TR*                  :5A-IC-NO,                                     15210000
MFA-TR*                  :5A-SEQ-NO,                                    15220000
MFA-TR*                  :5A-RT-PKG-OPT-SEQ-NO,                         15230000
MFA-TR*                  :5A-OFFERED-DT,                                15240000
MFA-TR*                  :5A-STATUS-CD,                                 15250000
MFA-TR*                  :5A-OFFER-CD,                                  15260000
MFA-TR*                  :5A-STATUS-CHANGE-DT,                          15270000
MFA-TR*                  CURRENT TIMESTAMP,                             15280000
MFA-TR*                  :5A-LAST-UPDATE-USERID)                        15290000
MFA-TR*    END-EXEC.                                                    15300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892*                                                                 15310000
P00892     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        DISPLAY '*************************************'           
P00892        DISPLAY '* 3270-INSERT-RATE-RENEWAL'                      
P00892        DISPLAY '* ACCOUNT_NO      = ' 5A-ACCOUNT-NO              
P00892        DISPLAY '* OFFERED DT      = ' 5A-OFFERED-DT              
P00892        DISPLAY '* STATUS CHG DT   = ' 5A-STATUS-CHANGE-DT        
P00892        DISPLAY '* PKG OPT SEQ NO  = ' 5A-RT-PKG-OPT-SEQ-NO       
P00892        DISPLAY '* SQL RETURN CODE = ' SQLCODE                    
P00892        DISPLAY '*************************************'           
P00892        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00892     END-IF.                                                      
P00892*                                                                 15470000
P00892 3270-EXIT.                                                       
P00892     EXIT.                                                        
      *                                                                 15500000
      ********************************************************          15510000
      *  INSERT INTO CSS_ACT_RT_RENDET                       *          15520000
      ********************************************************          15530000
P00892 3275-INSERT-RATE-REN-DET.                                        
P00892     EXEC SQL                                                     
P00892          INSERT INTO CSS_ACT_RT_REN_DET                          
P00892                  (ACCOUNT_NO,                                    
P00892                   CODE_UTIL_TYPE,                                
P00892                   IC_NO,                                         
P00892                   SEQ_NO,                                        
P00892                   OPTION_SORT_NO,                                
P00892                   OPTION_CD,                                     
P00892                   THERM_PRICE,                                   
P00892                   DURATION_NO,                                   
P00892                   AMT_CUST_CHRG,                                 
P00892                   SELECTION_CD,                                  
P00892                   AUTO_RENEWAL_FL,                               
P00892                   AUTO_REN_OPT_IN_FL,                            
P00892                   LAST_UPDATE_TS,                                
P00892                   OFFER_CD)                                      
P00892          VALUES  (:5B-ACCOUNT-NO,                                
P00892                   :5B-CODE-UTIL-TYPE,                            
P00892                   :5B-IC-NO,                                     
P00892                   :5B-SEQ-NO,                                    
P00892                   :5B-OPTION-SORT-NO,                            
P00892                   :5B-OPTION-CD,                                 
P00892                   :5B-THERM-PRICE,                               
P00892                   :5B-DURATION-NO,                               
P00892                   :5B-AMT-CUST-CHRG,                             
P00892                   :5B-SELECTION-CD,                              
P00892                   :5B-AUTO-RENEWAL-FL,                           
P00892                   :5B-AUTO-REN-OPT-IN-FL,                        
P00892                   CIS.CURRENT$TIMESTAMP(),                             
P00892                   :5B-OFFER-CD)                                  
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     15550000
MFA-TR*         INSERT INTO CSS_ACT_RT_REN_DET                          15560000
MFA-TR*                 (ACCOUNT_NO,                                    15570000
MFA-TR*                  CODE_UTIL_TYPE,                                15580000
MFA-TR*                  IC_NO,                                         15590000
MFA-TR*                  SEQ_NO,                                        15600000
MFA-TR*                  OPTION_SORT_NO,                                15610000
MFA-TR*                  OPTION_CD,                                     15620000
MFA-TR*                  THERM_PRICE,                                   15630000
MFA-TR*                  DURATION_NO,                                   15640000
MFA-TR*                  AMT_CUST_CHRG,                                 15650000
MFA-TR*                  SELECTION_CD,                                  15660000
MFA-TR*                  AUTO_RENEWAL_FL,                               15670000
MFA-TR*                  AUTO_REN_OPT_IN_FL,                            15680000
MFA-TR*                  LAST_UPDATE_TS,                                15690000
MFA-TR*                  OFFER_CD)                                      15700000
MFA-TR*         VALUES  (:5B-ACCOUNT-NO,                                15710000
MFA-TR*                  :5B-CODE-UTIL-TYPE,                            15720000
MFA-TR*                  :5B-IC-NO,                                     15730000
MFA-TR*                  :5B-SEQ-NO,                                    15740000
MFA-TR*                  :5B-OPTION-SORT-NO,                            15750000
MFA-TR*                  :5B-OPTION-CD,                                 15760000
MFA-TR*                  :5B-THERM-PRICE,                               15770000
MFA-TR*                  :5B-DURATION-NO,                               15780000
MFA-TR*                  :5B-AMT-CUST-CHRG,                             15790000
MFA-TR*                  :5B-SELECTION-CD,                              15800000
MFA-TR*                  :5B-AUTO-RENEWAL-FL,                           15810000
MFA-TR*                  :5B-AUTO-REN-OPT-IN-FL,                        15820000
MFA-TR*                  CURRENT TIMESTAMP,                             15830000
MFA-TR*                  :5B-OFFER-CD)                                  15840000
MFA-TR*    END-EXEC.                                                    15850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892*                                                                 15860000
P00892     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        DISPLAY '*************************************'           
P00892        DISPLAY '* 3275-INSERT-RATE-REN-DET'                      
P00892        DISPLAY '* ACCOUNT_NO  = ' 5B-ACCOUNT-NO                  
P00892        DISPLAY '* SQL RETURN CODE = ' SQLCODE                    
P00892        DISPLAY '*************************************'           
P00892        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00892     END-IF.                                                      
P00892*                                                                 15990000
P00892 3275-EXIT.                                                       
P00892     EXIT.                                                        
      *                                                                 16020000
      ********************************************************          16030000
      *  GET NEXT BILL CYCLE                                 *          16040000
      ********************************************************          16050000
       3280-GET-NEXT-BILL-CYC.                                          
      *                                                                 16070000
           INITIALIZE                     WS-FR-RENEW-BY-DATE           
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH1.            
           MOVE WS-BILL-CYCLE-AT       TO BN-BILL-CYCLE.                
           IF WS-TMP-REV-MM = 12                                        
              ADD 1                    TO WS-TMP-REV-CCYY               
              MOVE 1                   TO WS-TMP-REV-MM                 
           ELSE                                                         
              ADD  1                   TO WS-REVENUE-MONTH1             
           END-IF.                                                      
           MOVE WS-REVENUE-MONTH1      TO BN-REVENUE-MONTH.             
      *                                                                 16180000
T35152     EXEC SQL                                                     
T35152        SELECT MIN(DATE_EXTRACT)                                  
T35152         INTO :BN-DATE-EXTRACT                                    
T35152          FROM CSS_BILL_WINDOW                                    
T35152          WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                 
T35152            AND BILL_CYCLE = :BN-BILL-CYCLE                       
T35152     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35152                                                                  
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
           WHEN -811                                                    
              MOVE BN-DATE-EXTRACT TO E-CA916-RENEW-DATE                
           WHEN +100                                                    
              MOVE SPACES          TO E-CA916-RENEW-DATE                
              GO TO 3280-EXIT                                           
           WHEN OTHER                                                   
               DISPLAY '**  ERROR ON 3280-GET-NEXT-BILL-CYC   **'       
               DISPLAY '**  COULD NOT GET NEXT BILL CYCLE     **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               DISPLAY '**  ACCOUNT-NO     = ' WS-ACCOUNT-NO            
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       3280-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16440000
      ******************************************************************16450000
      *      PROCESS A WORK QUEUE                                      *16460000
      ******************************************************************16470000
       7000-PROCESS-WQ.                                                 
      *                                                                 16490000
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE 121                 TO WS-77-CATEGORY-ID.               
A04860     MOVE 'N'                 TO WS-77-PRIORITY.                  
A04860     MOVE 4                   TO WS-77-ROUTE-CATEGORY.            
A04860     MOVE 200                 TO WS-77-COMMENTS-LEN.              
A04860     MOVE WS-HOLD-WQ-COMMENTS TO WS-77-COMMENTS-TEXT.             
A04860     MOVE ZERO                TO WS-77-SERV-ORDER-NO.             
A04860     MOVE WS-INPUT-DATE       TO WS-77-DATE-REQUIRED.             
A04860     MOVE WS-CA195-HOLD-ACCOUNT-NO TO WS-77-ACCOUNT-NO.           
A04860     MOVE WS-HOLD-PREMISE-NO  TO WS-77-PREMISE-NO.                
A04860     MOVE WS-HOLD-CUSTOMER-NO TO WS-77-CUSTOMER-NO.               
A04860     MOVE ZERO                TO WS-77-FREE-FORM-LEN.             
A04860     MOVE LOW-VALUES          TO WS-77-FREE-FORM-TXT.             
A04860     MOVE PROGRAM-NAME        TO WS-77-CREATED-BY.                
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16670000
      ******************************************************************16680000
      *      GET CURRENT TIMESTAMP                                     *16690000
      ******************************************************************16700000
       7200-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16730000
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                    16740000
MFA-TR*    END-EXEC.                                                    16750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '** ERROR IN 7200-SELECT-TIMESTAMP        **'     
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16930000
      ******************************************************************16940000
      *      READS FCSBE22 FILE FOR INPUT                              *16950000
      ******************************************************************16960000
       8000-READ-INPUT.                                                 
           READ FCSBE22-FILE AT END                                     
               MOVE 'Y' TO WS-END-OF-BE22-SW.                           
                                                                        
           IF WS-END-OF-BE22-SW NOT = 'Y'                               
              ADD 1 TO WS-ACCOUNT-READ                                  
              IF WS-ACCOUNT-READ = 1 AND                                
                 WS-FCA00-BILL-DATE = LOW-VALUES                        
                 MOVE FIOBE22-DATA-REC(47:10) TO WS-FCA00-BILL-DATE
              END-IF
           END-IF.    
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17080000
      ********************************************************          17090000
      *  WRITE ROW TO TRANS HISTORY.                         *          17100000
      ********************************************************          17110000
       8200-UPD-TRANS-HIST.                                             
      *                                                                 17130000
           PERFORM 7200-GET-TIMESTAMP THRU 7200-EXIT.                   
           MOVE WS-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.                   
           MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                       
           MOVE 'F' TO MH-CODE-TRAN-TYPE.                               
           MOVE ZEROS TO MH-PREMISE-NO.                                 
           MOVE SPACES TO MH-RESP-AREA-ID.                              
           MOVE WS-CUSTOMER-NO-AT TO MH-CUSTOMER-NO.                    
           MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
           MOVE 'SYSTEM' TO MH-USER-ID.                                 
           MOVE 'NOTICES'    TO MH-APPL-PROGRAM-ID.                     
           MOVE WS-CURRENT-DATE(6:2) TO WS-HIST-DISP-MM.                
           MOVE WS-CURRENT-DATE(9:2) TO WS-HIST-DISP-DD.                
           MOVE WS-CURRENT-DATE(1:4) TO WS-HIST-DISP-YR.                
           IF WS-HOLD-DEST-CODE = 'Y'                                   
PRJ211       IF PENDING-REMINDER-MSGS                                   
PRJ211          CONTINUE                                                
             ELSE                                                       
               IF RENEWAL-MSGS                                          
PRJ211            IF WS-CA195-REG-GROUP <= SPACE                        
PRJ211               STRING                                             
PRJ211               'DEREG RENEWAL LETTER EXCEPTION - IMAGE ONLY'      
PRJ211               DELIMITED BY SIZE                                  
PRJ211               INTO MH-TRAN-COMMENT-TEXT                          
PRJ211            ELSE                                                  
PRJ211               STRING                                             
PRJ211               'REG RENEWAL LETTER EXCEPTION  -  IMAGE ONLY'      
PRJ211               DELIMITED BY SIZE                                  
PRJ211               INTO MH-TRAN-COMMENT-TEXT                          
PRJ211            END-IF                                                
PRJ211            MOVE +43 TO MH-TRAN-COMMENT-LEN                       
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
             IF PENDING-REMINDER-MSGS                                   
PRJ211          CONTINUE                                                
             ELSE                                                       
               IF RENEWAL-MSGS                                          
PRJ211            IF WS-CA195-REG-GROUP <= SPACE                        
PRJ211               STRING 'DEREG RENEWAL MARKETING LETTER'            
PRJ211                   DELIMITED BY SIZE                              
PRJ211                   INTO MH-TRAN-COMMENT-TEXT                      
PRJ211            ELSE                                                  
PRJ211               STRING 'REG RENEWAL MARKETING LETTER  '            
PRJ211                       DELIMITED BY SIZE                          
PRJ211                       INTO MH-TRAN-COMMENT-TEXT                  
PRJ211            END-IF                                                
PRJ211            MOVE +30 TO MH-TRAN-COMMENT-LEN                       
               END-IF                                                   
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF WS-MNT-INS-SW = 'Y'                                       
               PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT        
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17710000
      ********************************************************          17720000
      *  WRITE ROW TO COMM DATA.                             *          17730000
      ********************************************************          17740000
       8210-INSERT-CUST-COMM.                                           
                                                                        
           PERFORM 7200-GET-TIMESTAMP THRU 7200-EXIT.                   
                                                                        
           IF PENDING-REMINDER-MSGS                                     
PRJ211        CONTINUE                                                  
           ELSE                                                         
PRJ211       IF RENEWAL-MSGS                                            
PRJ211          IF WS-CA195-REG-GROUP <= SPACE                          
PRJ211             MOVE 'DEREG RENEWAL FIXED RATE LETTER'               
PRJ211                              TO WS-INITIAL-COMMENT-TX-TEXT       
PRJ211          ELSE                                                    
PRJ211            MOVE 'REG RENEWAL FIXED RATE LETTER'                  
PRJ211                              TO WS-INITIAL-COMMENT-TX-TEXT       
PRJ211          END-IF                                                  
           END-IF
           END-IF.                                                      
                                                                        
PRJ211     MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
A04735     MOVE WS-COMPANY-NO-AT       TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE 'L'                    TO KO-COMM-METHOD.               
           MOVE 'O'                    TO KO-COMM-DIRECTION.            
           MOVE '45'                   TO KO-COMM-TYPE-CD.              
           MOVE '02'                   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE SPACES                 TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE 'N'                    TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE LENGTH OF WS-INITIAL-COMMENT-TX-TEXT                    
                                         TO WS-INITIAL-COMMENT-TX-LEN.  
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE 'C'                    TO KO-COMM-ASSOC-CD.             
           MOVE 'N'                    TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
           MOVE 'FIXED       '         TO KO-CONTACT-NAME.              
           MOVE WS-CUSTOMER-NO-AT      TO KO-CUSTOMER-NO.               
PRJ211     MOVE WS-PREMISE-NO-AT       TO KO-PREMISE-NO.                
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18270000
MFA-TR*         INSERT INTO CSS_COMM_DATA                               18280000
MFA-TR*                 (COMMUNICATION_ID,                              18290000
MFA-TR*                  ACCOUNT_NO,                                    18300000
MFA-TR*                  CUSTOMER_NO,                                   18310000
MFA-TR*                  PREMISE_NO,                                    18320000
MFA-TR*                  COMPANY_NO,                                    18330000
MFA-TR*                  RED_FLAG_IND,                                  18340000
MFA-TR*                  RED_FLAG_EXPIRE_DT,                            18350000
MFA-TR*                  COMM_METHOD,                                   18360000
MFA-TR*                  COMM_DIRECTION,                                18370000
MFA-TR*                  COMM_TYPE_CD,                                  18380000
MFA-TR*                  COMM_SUBTYPE_CODE,                             18390000
MFA-TR*                  USER_ID_ORIG,                                  18400000
MFA-TR*                  CONTACT_NAME,                                  18410000
MFA-TR*                  PROMOTION_ID,                                  18420000
MFA-TR*                  PSC_COMPLIANCE_IND,                            18430000
MFA-TR*                  CALL_ORIGIN_ID,                                18440000
MFA-TR*                  CALL_END_TIME,                                 18450000
MFA-TR*                  NUMBER_TRANSFERS,                              18460000
MFA-TR*                  HOLD_TIME,                                     18470000
MFA-TR*                  QUEUE_TIME,                                    18480000
MFA-TR*                  SCREEN_POP_IND,                                18490000
MFA-TR*                  TOTAL_CALL_TIME,                               18500000
MFA-TR*                  INITIAL_COMMENT_TX,                            18510000
MFA-TR*                  RESPONSE_REASON_CD,                            18520000
MFA-TR*                  RESPONSE_TYPE_CD,                              18530000
MFA-TR*                  SOLICITATION_CD,                               18540000
MFA-TR*                  COMM_ASSOC_CD,                                 18550000
MFA-TR*                  COMPLAINT_FL,                                  18560000
MFA-TR*                  DISCOVERY_MTHD_CD,                             18570000
MFA-TR*                  PREV_MARKETER_CD)                              18580000
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                            18590000
MFA-TR*                  :KO-ACCOUNT-NO,                                18600000
MFA-TR*                  :KO-CUSTOMER-NO,                               18610000
MFA-TR*                  :KO-PREMISE-NO,                                18620000
MFA-TR*                  :KO-COMPANY-NO,                                18630000
MFA-TR*                  :KO-RED-FLAG-IND,                              18640000
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,     18650000
MFA-TR*                  :KO-COMM-METHOD,                               18660000
MFA-TR*                  :KO-COMM-DIRECTION,                            18670000
MFA-TR*                  :KO-COMM-TYPE-CD,                              18680000
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                         18690000
MFA-TR*                  :KO-USER-ID-ORIG,                              18700000
MFA-TR*                  :KO-CONTACT-NAME,                              18710000
MFA-TR*                  :KO-PROMOTION-ID,                              18720000
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                        18730000
MFA-TR*                  :KO-CALL-ORIGIN-ID,                            18740000
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,             18750000
MFA-TR*                  :KO-NUMBER-TRANSFERS,                          18760000
MFA-TR*                  :KO-HOLD-TIME,                                 18770000
MFA-TR*                  :KO-QUEUE-TIME,                                18780000
MFA-TR*                  :KO-SCREEN-POP-IND,                            18790000
MFA-TR*                  :KO-TOTAL-CALL-TIME,                           18800000
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                        18810000
MFA-TR*                  :KO-RESPONSE-REASON-CD,                        18820000
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                          18830000
MFA-TR*                  :KO-SOLICITATION-CD,                           18840000
MFA-TR*                  :KO-COMM-ASSOC-CD,                             18850000
MFA-TR*                  :KO-COMPLAINT-FL,                              18860000
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                         18870000
MFA-TR*                  :KO-PREV-MARKETER-CD)                          18880000
MFA-TR*    END-EXEC.                                                    18890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
                                                                        
ACT168     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT168      WHEN SUCCESSFUL-CALL                                        
ACT168          CONTINUE                                                
ACT168      WHEN -803                                                   
ACT168          DISPLAY 'PCSCA916 FAILED ADDING COMMUNICATION ROW '     
ACT168              'WITH CURRENT TIMESTAMP - ATTEMPTING SECOND TRY '   
ACT168          PERFORM 8210-INSERT-CUST-COMM  THRU 8210-EXIT           
ACT168          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
ACT168              CONTINUE                                            
ACT168            ELSE                                                  
ACT168              DISPLAY '*************************************'     
ACT168              DISPLAY '* 8210-INSERT-CUST-COMM SECOND TRY   '     
ACT168              DISPLAY '* CUSTOMER_NO = ' WS-CUSTOMER-NO-AT        
ACT168              DISPLAY '* ACCOUNT_NO  = ' AT-ACCOUNT-NO            
ACT168              DISPLAY '* SQL RETURN CODE = ' SQLCODE              
ACT168              DISPLAY '*************************************'     
ACT168              PERFORM 9900-ABEND                THRU 9900-EXIT    
ACT168          END-IF                                                  
ACT168      WHEN OTHER                                                  
ACT168          DISPLAY '*************************************'         
ACT168          DISPLAY '* 8210-INSERT-CUST-COMM FIRST TRY'             
ACT168          DISPLAY '* CUSTOMER_NO = ' WS-CUSTOMER-NO-AT            
ACT168          DISPLAY '* ACCOUNT_NO  = ' AT-ACCOUNT-NO                
ACT168          DISPLAY '* SQL RETURN CODE = ' SQLCODE                  
ACT168          DISPLAY '*************************************'         
ACT168          PERFORM 9900-ABEND                THRU 9900-EXIT        
ACT168      END-EVALUATE.                                               
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19230000
      ******************************************************************19240000
      *      PROCESS ACCOUNT RECORDS                                   *19250000
      ******************************************************************19260000
       8300-PROCESS-ACCOUNT-REC.                                        
                                                                        
           MOVE E-FBE22-DATA           TO WS-ACCOUNT-AT.                
           MOVE WS-PREMISE-NO-AT       TO WS-HOLD-PREMISE-NO.           
           MOVE WS-CUSTOMER-NO-AT      TO WS-HOLD-CUSTOMER-NO           
           MOVE WS-COMPANY-NO-AT       TO WS-HOLD-COMPANY-NO.           
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REV-MTH-LST-NRML.          
           MOVE WS-EXT-BILLING-FL-AT   TO WS-HOLD-EXT-BILLING-FL.       
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19380000
       8310-PROCESS-BG-REC.                                             
                                                                        
           MOVE E-FBE22-DATA TO WS-BILLING-DATA(WS-BILLING-INDX).       
           IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C' AND       
              WS-CODE-BILL-ITM-IND-BG(WS-BILLING-INDX) = 'A'            
               MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) TO              
                    WS-RATE-PLAN-NO                                     
               MOVE WS-IC-NO-BG(WS-BILLING-INDX) TO WS-IC-NO            
               MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) TO            
                                      WS-CODE-UTIL-TYPE                 
           END-IF.                                                      
           IF ACCT-ON-INCENTIVE                                         
              ADD WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX) TO WS-BILLED-AMT 
              ADD WS-USAGE-DOLLARS-CALC(WS-BILLING-INDX) TO             
                  WS-INCENTIVE-AMT                                      
              ADD WS-GAS-OTHR-CHG-CALC(WS-BILLING-INDX) TO              
                  WS-NONUTIL-AMT                                        
              ADD WS-AMT-STATE-TAX-BG(WS-BILLING-INDX) TO               
                  WS-NONUTIL-AMT                                        
              ADD WS-CUST-CHRG-DOLLARS-CALC(WS-BILLING-INDX) TO         
                  WS-NONUTIL-AMT                                        
           END-IF.                                                      
           SET WS-BILLING-INDX UP BY 1.                                 
           INITIALIZE WS-BILLING-DATA(WS-BILLING-INDX).                 
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19650000
       8315-PROCESS-BC-REC.                                             
                                                                        
           MOVE E-FBE22-DATA TO WS-BILL-CALC-DATA(WS-CALC-INDX).        
           MOVE WS-AMT-NET-RATE-BC(WS-CALC-INDX 1) TO                   
                WS-AMT-NET-RATE.                                        
           SET WS-CALC-INDX UP BY 1.                                    
           INITIALIZE WS-BILL-CALC-DATA(WS-CALC-INDX).                  
       8315-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19750000
       8320-PROCESS-BA-REC.                                             
                                                                        
           MOVE E-FBE22-DATA   TO WS-BILL-ADJ-DATA(WS-BILL-ADJ-INDX)    
           IF WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX) = 'BFCADJ001' OR        
                                                  'BCNADJ001' OR        
                                                  'BCNADJ'              
               MOVE 'N' TO WS-HOLD-OFFER-FLAG                           
           END-IF.                                                      
           IF ACCT-ON-INCENTIVE                                         
               IF WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX) = 'SPCDDC1'         
                   ADD WS-FACTOR-BA(WS-BILL-ADJ-INDX) TO                
                       WS-INCENTIVE-AMT                                 
                   SUBTRACT WS-FACTOR-BA(WS-BILL-ADJ-INDX) FROM         
                            WS-NONUTIL-AMT                              
               END-IF                                                   
           END-IF.                                                      
           SET WS-BILL-ADJ-INDX UP BY 1.                                
           INITIALIZE WS-BILL-ADJ-DATA(WS-BILL-ADJ-INDX).               
       8320-EXIT.                                                       
           EXIT.                                                        
A03583                                                                  
A03583 8321-PROCESS-CX-REC.                                             
A03583                                                                  
A03583     MOVE E-FBE22-DATA   TO WS-CNSMPTN-DATA(WS-CNSMPTN-INDX)      
A03583     IF ((WS-PREV-METER-READ-DATE-CALC (WS-CNSMPTN-INDX) <        
A03583        WS-HOLD-PREV-METER-READ-DATE ) OR                         
A03583        WS-HOLD-PREV-METER-READ-DATE = SPACES )                   
A03583        MOVE WS-PREV-METER-READ-DATE-CALC (WS-CNSMPTN-INDX) TO    
A03583             WS-HOLD-PREV-METER-READ-DATE                         
A03583     END-IF.                                                      
A03583     SET WS-CNSMPTN-INDX UP BY 1.                                 
A03583 8321-EXIT.                                                       
A03583     EXIT.                                                        
      *                                                                 20090000
       8325-PROCESS-FH-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO                             
                WS-FIXED-FACTR-DATA-HIST (WS-FH-HIST-INDX)              
           SET WS-FH-HIST-INDX UP BY +1.                                
           INITIALIZE WS-FIXED-FACTR-DATA-HIST(WS-FH-HIST-INDX).        
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20190000
       8330-PROCESS-CZ-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO WS-CREDIT-PROFILE-CZ.       
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20260000
       8335-PROCESS-BU-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO WS-BUDGET-PLAN-BU.          
                                                                        
       8335-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20330000
       8340-PROCESS-TIER-REC.                                           
                                                                        
           MOVE E-FBE22-DATA             TO                             
                WS-MKT-TIER-DATA(WS-TIER-INDX).                         
           SET WS-TIER-INDX UP BY +1.                                   
           INITIALIZE WS-MKT-TIER-DATA(WS-TIER-INDX).                   
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20430000
       8345-PROCESS-AG-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO                             
                WS-RTPK-AGR-DATA(WS-RTPK-INDX).                         
           SET WS-RTPK-INDX UP BY +1.                                   
           INITIALIZE WS-RTPK-AGR-DATA(WS-RTPK-INDX).                   
                                                                        
       8345-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20530000
      *                                                                 20540000
       8355-PROCESS-YP-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO                             
                WS-ACCT-ATTR-DATA(WS-ATTR-INDX)                         
           SET WS-ATTR-INDX UP BY +1.                                   
           INITIALIZE WS-ACCT-ATTR-DATA(WS-ATTR-INDX).                  
                                                                        
       8355-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20640000
       8360-PROCESS-BT-REC.                                             
                                                                        
           MOVE E-FBE22-DATA             TO                             
                WS-BILL-DET-DATA(WS-BDET-INDX).                         
           SET WS-BDET-INDX UP BY +1.                                   
           INITIALIZE WS-BILL-DET-DATA(WS-BDET-INDX).                   
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20740000
PRJ172************************************************************      20750000
PRJ172* LOAD CUSTOMER DATA                                       *      20760000
PRJ172************************************************************      20770000
PRJ172*                                                                 20780000
PRJ172 8370-PROCESS-CU-REC.                                             
PRJ172                                                                  
PRJ172     MOVE E-FBE22-DATA             TO WS-CUSTOMER-CU.             
PRJ172                                                                  
PRJ172 8370-EXIT.                                                       
PRJ172     EXIT.                                                        
      *                                                                 20850000
       8500-WRITE-OUTPUT.                                               
                                                                        
           MOVE WS-JOB-PARM-YEAR      TO WS-NOTICE-YY.                  
           MOVE WS-JOB-PARM-MONTH     TO WS-NOTICE-MM.                  
           MOVE WS-JOB-PARM-DAY       TO WS-NOTICE-DD.                  
           MOVE WS-NOTICE-DATE        TO E-CA916-NOTICE-DATE.           
           WRITE FIOCA916.                                              
           ADD 1                     TO WS-ACCOUNT-COUNT.               
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20960000
      ********************************************************          20970000
      *  SELECT BUDGET BILLING NEW AMOUNT.                   *          20980000
      ********************************************************          20990000
       8850-SELECT-BUDGET-BILLING-AMT.                                  
                                                                        
           EXEC SQL                                                     
              SELECT AMT_MO_PYMT                                        
                INTO :BU-AMT-MO-PYMT                                    
                FROM CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :BU-ACCOUNT-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21020000
MFA-TR*       SELECT AMT_MO_PYMT                                        21030000
MFA-TR*         INTO :BU-AMT-MO-PYMT                                    21040000
MFA-TR*         FROM CSS_BUDGET_PLAN                                    21050000
MFA-TR*       WHERE ACCOUNT_NO = :BU-ACCOUNT-NO                         21060000
MFA-TR*       WITH UR                                                   21070000
MFA-TR*    END-EXEC.                                                    21080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN -811                                                    
           WHEN NOT-FOUND                                               
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '*******************************************'     
              DISPLAY '** ERROR IN 8850-SELECT-BUDGET-BILLING   **'     
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-EVALUATE.                                                
       8850-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            21280000
      *                                                                 21290000
       COPY CPD00004.                                                   21300000
      *                                                                 21310000
       COPY CPD00040.                                                   21320000
      *                                                                 21330000
       COPY CPD00037.                                                   21340000
      *                                                                 21350000
           EXEC SQL                                                     21360000
              INCLUDE CPD00038                                          21370000
           END-EXEC.                                                    21380000
      *                                                                 21390000
           EXEC SQL                                                     21400000
              INCLUDE CPD00039                                          21410000
           END-EXEC.                                                    21420000
      *                                                                 21430000
           EXEC SQL                                                     21440000
               INCLUDE CPD00067                                         21450000
           END-EXEC.                                                    21460000
      *                                                                 21470000
      ****************************************************************  21480000
      **  8895-INSERT-WORK-QUEUE                                    **  21490000
      ****************************************************************  21500000
A04860*                                                                 21510000
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                 21530000
ACT314     MOVE SPACES                       TO ABEND-FUNCTION.         
ACT314     MOVE ZERO                         TO RS-RETURN-CODE.         
ACT314                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                 21740000
A00765****************************************************************  21750000
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  21760000
A00765****************************************************************  21770000
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                 21810000
      ****************************************************************  21820000
      **  9000-TERMINATE                                            **  21830000
      ****************************************************************  21840000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE22-FILE                                           
                 SEB916-FILE.                                           
           DISPLAY '60 DAY BILL CR   LETTER = ' WS-10203-CNT.           
PRJ211     DISPLAY 'DEREG RENEWAL LETTER    = ' WS-10206-CNT.           
PRJ211     DISPLAY 'REG RENEWAL OPT-1 LETTER= ' WS-10207-CNT.           
PRJ211     DISPLAY 'REG RENEWAL OPT-2 LETTER= ' WS-10208-CNT.           
P00805     DISPLAY 'DEREG SM COMM RENEWAL   = ' WS-10209-CNT.           
P00805     DISPLAY 'DEREG 25 DAY ADV RENEWAL= ' WS-10210-CNT.           
P00892     DISPLAY 'DEREG 25 DAY ADV AUTO RE= ' WS-10215-CNT.           
P00805     DISPLAY '30 DAY OUTER POOL LTR   = ' WS-10502-CNT.           
           DISPLAY 'ACCOUNTS READ           = ' WS-ACCOUNT-READ.        
           DISPLAY 'ACCOUNTS REBILLED       = ' WS-ACCOUNT-REBILL.      
           DISPLAY 'ACCOUNTS DROPPED        = ' WS-ACCOUNT-DROPPED.     
           DISPLAY 'ACCOUNTS PROCESSED      = ' WS-ACCOUNT-COUNT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22040000
      ****************************************************************  22050000
      **  9900-SQL-ERROR-ROUTINE                                    **  22060000
      ****************************************************************  22070000
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
              EXEC SQL                                                  22220000
                   INCLUDE CPD09900                                     22230000
              END-EXEC.                                                 22240000
