       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA914.                                        
       DATE-WRITTEN.   05/22/2006.                                      
       DATE-COMPILED.                                                   
       AUTHOR.         VAISHNAVI.                                       
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00070000
      **                                                             ** 00080000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00090000
      **                                                             ** 00100000
      ***************************************************************** 00110000
      **               P R O G R A M  S U M M A R Y                  ** 00120000
      **               ~~~~~~~~~~~~~  ~~~~~~~~~~~~~                  ** 00130000
      ** CHANGES TO CML - 33675.                                     ** 00140000
      ** PCSCA914 UPDATES DB2 FOR DAILY AUDITS.                      ** 00150000
      ** FCSCA912 FILE IS INPUT TO PCSCA914.                         ** 00160000
      ** THIS IS THE EXTRACT OF 6400 RECORDS FROM FCSBE29 FILE.      ** 00170000
      ** WS-MAIL-NAME-ADDR-LINE(1) WILL HAVE THE AUDIT DESCRIPTION.  ** 00180000
      ** FOR EACH RECORD IN FCSCA912 FILE INSERT/UPDATE THE DB2 TABLE** 00190000
      **                                                             ** 00200000
      ***************************************************************** 00210000
      **                                                             ** 00220000
      **             PROGRAM  MODIFICATION  LOG                      ** 00230000
      **                                                             ** 00240000
      **   DATE     INITIALS  REASON                                 ** 00250000
      **   ----     --------  ------                                 ** 00260000
T33675**   05/06    SV82012   NEW PROGRAM.                           ** 00270000
T35054**   11/06    SV82012   INSERT NEW RATE/AUDIT CONDITION        ** 00280000
      **                      DYNAMICALLY.                           ** 00281000
T35054**   11/07    SV82012   FIX PRODUCTION ABEND.                  ** 00282000
T35152**   05/08    SV82012   BILL REDESIGN FOR SEB.                 ** 00283000
T37389**   07/08    rv97439   Increase the audit conditon table array** 00284000
T37389**                      and check for overflow.                ** 00285000
A02003**   07/10    BD09555   Increase table size from 998 to 1998   ** 00286003
A02003**   07/10    BD09555   Also increase subscript size from three** 00287006
A02003**                      digits to 5.                           ** 00288006
P00599**   07/12    Gokul     Include 1000K to support CPD0101C      ** 00288007
A04494**   12/13    DMS       (ACT 5) Increase AUDIT_COND_DESC FIELD ** 00288007
A04494**                      to 300 characters.  Only execute 8200- ** 00288007
A04494**                      when 8100- executes successfully.      **        
      *END************************************************************* 00290000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00300000
      **                                                             ** 00310000
      **  0000         MODULE CONTROL                                ** 00320000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00330000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00340000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00350000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00360000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00370000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00380000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00390000
      **  9000 - 9799  TERMINATION MODULES                           ** 00400000
      **  9900 - 9999  ABEND / ABORT MODULES                         ** 00410000
      **                                                             ** 00420000
      ***************************************************************** 00430000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSCA912.                                                   00491000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDCA912.                                                   00541000
T35152 COPY SORTINDX.                                                   00550000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA914'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-FILE-TO-PROCESS           PIC X(5).                   
           05  WS-CA912-STATUS              PIC X(02).                  
               88 CA912-SUCCESSFUL              VALUE '00'.             
           05  WS-COMPANY-TYPE-CD           PIC X(01) VALUE SPACES.     
           05  WS-STORE-RETURN-CODE         PIC S9(4) COMP.             
           05  RS-RETURN-CODE               PIC S9(4) COMP.             
           05  RS-RETURN-CODE-DISP          PIC -Z(4).                  
           05  WS-DISPLAY-SQLCODE           PIC -ZZZZZZZZ9.             
           05  WS-HOLD-REV-MONTH            PIC 9(6) VALUE ZERO.        
           05  WS-DATE-BILLED               PIC X(10) VALUE SPACES.     
           05  WS-HOLD-COND-CODE            PIC X(04) VALUE SPACES.     
           05  WS-HOLD-AUD-COND-CD          PIC X(04) VALUE SPACES.     
           05  WS-HOLD-AUD-COND-CD-N REDEFINES                          
               WS-HOLD-AUD-COND-CD          PIC 9(04).                  
A04494     05  WS-HOLD-AUD-DESC             PIC X(300) VALUE SPACES.    
      *                                                                 00660000
       01  WS-SWITCHES.                                                 
           05  WS-END-REC-PROCESSED           PIC X VALUE 'N'.          
               88  END-REC-PROCESSED          VALUE 'Y'.                
           05  WS-END-OF-CA912                PIC X VALUE 'N'.          
               88  END-OF-CA912               VALUE 'Y'.                
      *                                                                 00760000
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC  X(01) VALUE 'Y'.        
           05  WS-Y                        PIC  X(01) VALUE 'Y'.        
           05  WS-NO                       PIC  X(01) VALUE 'N'.        
           05  WS-N                        PIC  X(01) VALUE 'N'.        
           05  WS-811                      PIC S9(9) VALUE -811 COMP.   
           05  PROGRAM-NAME                PIC  X(08) VALUE 'PCSCA914'. 
T35152     05  WS-COMMON-DATE              PIC X(10) VALUE 'COMMONDATE'.
      *                                                                 00840000
       01 WS-AUDIT-DESC-TABLE.                                          
T37389     05  WS-AUDIT-CNT                  PIC S9(5) COMP-3 VALUE +0. 
A02003     05  WS-AUDIT-DESC-LINE OCCURS 0 TO 1998                      
                                  DEPENDING ON WS-AUDIT-CNT.            
               10  WS-AUDIT-COND-CD          PIC X(4).                  
A04494         10  WS-AUDIT-COND-DESC        PIC X(300).                
T37389     05  WS-AUDIT-SUB                  PIC 9(05) COMP-3.          
T37389     05  WS-AUDIT-FOUND-FLAG           PIC X(01).                 
      *                                                                         
      * copy book for error handling                                    00851000
       COPY CWS00010.                                                   00852000
      *                                                                 00853000
       COPY CWS00303.                                                   00860000
       COPY CWS09900.                                                   00870000
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                                  
       COPY CWS0011A.                                                   00870000
      *    DCLGEN FOR CSS_AUDIT_COND                                    00880000
           EXEC SQL                                                     00890000
                INCLUDE TBAUDCON                                        00900000
           END-EXEC.                                                    00910000
      *    DCLGEN FOR CSS_AUDIT_COND_DSC                                00921000
           EXEC SQL                                                     00922000
                INCLUDE TBAUDDES                                        00923000
           END-EXEC.                                                    00924000
      *    DCLGEN FOR CSS_AUDIT_HIST                                    00925000
           EXEC SQL                                                     00930000
                INCLUDE TBAUDHST                                        00940000
           END-EXEC.                                                    00950000
      *   DCLGEN FOR CSS_ACCOUNT                                        00960000
           EXEC SQL                                                     00970000
               INCLUDE TBACCT                                           00980000
           END-EXEC.                                                    00990000
      *    SQL COMMUNICATION AREA.                                      01000000
           EXEC SQL                                                     01010000
               INCLUDE SQLCA                                            01020000
           END-EXEC.                                                    01030000
      *                                                                 01040000
T35152*CSS_JOB_PARMTABLE                                                01040100
T35152     EXEC SQL                                                     01040200
T35152       INCLUDE TBJBPARM                                           01040300
T35152     END-EXEC.                                                    01040400
T35152*                                                                 01040500
           EXEC SQL                                                     
               DECLARE AUDIT_COND_CSR CURSOR FOR                        
                   SELECT AH.AUDIT_COND_CD                              
                         ,AH.AUDIT_COND_DESC                            
                     FROM CSS_AUDIT_COND_DSC AH                         
                         ,CSS_AUDIT_COND AP                             
                    WHERE AH.AUDIT_COND_CD   =  AP.AUDIT_COND_CD        
                      AND AP.COMPANY_TYPE_CD = :AP-COMPANY-TYPE-CD      
                 ORDER BY AUDIT_COND_CD                                 
           END-EXEC.                                                    
      *                                                                 01047000
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-PARM-COMPANY                   PIC X(03).             
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***********************************************************       01120000
      *  PERFORM THE PROCESSING ROUTINE FOR EACH INPUT FILE:    *       01130000
      *  CA912(AUDIT BILLS - 6400 RECORDS ONLY)                 *       01140000
      ***********************************************************       01150000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
      *  POPULATE THE VALUE FOR COMPANY_TYPE_CD                         01200100
           EVALUATE WS-PARM-COMPANY                                     
               WHEN 'CSR'                                               
                    MOVE 'S'              TO WS-COMPANY-TYPE-CD         
               WHEN 'PNC'                                               
                    MOVE 'P'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SEB'                                               
                    MOVE 'D'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SBR'                                               
                    MOVE 'R'              TO WS-COMPANY-TYPE-CD         
               WHEN 'SVC'                                               
                    MOVE 'V'              TO WS-COMPANY-TYPE-CD         
           END-EVALUATE.                                                
      *                                                                 01201400
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 01202000
           PERFORM 0125-GET-AUDIT-DESC THRU 0125-EXIT.                  
      *                                                                 01204000
           DISPLAY 'CA912'.                                             
           MOVE 'CA912'                    TO WS-FILE-TO-PROCESS.       
T35152     PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
T35152             END-REC-PROCESSED.                                   
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       01460000
      *  OPEN INPUT FILES.                                      *       01470000
      ***********************************************************       01480000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA912-FILE.                                    
           IF NOT CA912-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA912          **'         
               DISPLAY '**  FILE STATUS = ' WS-CA912-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
      *    INITIALIZE WS-AUDIT-DESC-TABLE.                              01602000
           MOVE ZEROES                    TO WS-AUDIT-SUB.              
           MOVE 'N'                       TO WS-AUDIT-FOUND-FLAG.       
T35152     PERFORM 7200-GET-COMMON-DATE     THRU 7200-EXIT.             
T35152     MOVE G6-PARM-DATA              TO WS-DATE-BILLED.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      01971000
      * This para is to obatin the all the possible audits a     *      01972000
      * company can have. This is obtained from the DB2 tableS   *      01973000
      * css_audit_cond_dsc and css_audit_cond.                   *      01974000
      ************************************************************      01975000
       0125-GET-AUDIT-DESC.                                             
      *                                                                 01977000
           MOVE WS-COMPANY-TYPE-CD        TO AP-COMPANY-TYPE-CD.        
           EXEC SQL                                                     
                OPEN AUDIT_COND_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01979300
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*** PCSCA914:0125          ***'                  
              DISPLAY '*** 0125-GET-AUDIT-DESC    *** '                 
              DISPLAY '*** DB2 FUNCTION -  OPEN   *** '                 
              DISPLAY '*** DB2 TABLE CSS_AUDIT_COND, CSS_AUDIT_COND_DSC'
              DISPLAY '*** COMPANY_TYPE_CD ' AP-COMPANY-TYPE-CD         
              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE          
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 01980500
           PERFORM 0150-FETCH-AUDIT-DESC  THRU 0150-EXIT.               
      *                                                                 01980800
           EXEC SQL                                                     
                CLOSE AUDIT_COND_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01981200
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*** PCSCA914:0125          ***'                  
              DISPLAY '*** 0125-GET-AUDIT-DESC    *** '                 
              DISPLAY '*** DB2 FUNCTION -  CLOSE  *** '                 
              DISPLAY '*** DB2 TABLE CSS_AUDIT_COND, CSS_AUDIT_COND_DSC'
              DISPLAY '*** COMPANY_TYPE_CD ' AP-COMPANY-TYPE-CD         
              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE          
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 01982400
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01982700
       0150-FETCH-AUDIT-DESC.                                           
      *                                                                 01982900
           EXEC SQL                                                     
               FETCH AUDIT_COND_CSR                                     
                INTO :AH-AUDIT-COND-CD                                  
                    ,:AH-AUDIT-COND-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01983500
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *                                                                 01983800
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    GO TO 0150-EXIT                                     
               WHEN OTHER                                               
                 DISPLAY '*** PCSCA914:0150            *** '            
                 DISPLAY '*** 0150-FETCH-AUDIT-DESC    *** '            
                 DISPLAY '*** DB2 FUNCTION -  CLOSE    *** '            
                 DISPLAY '*** DB2 TABLE CSS_AUDIT_COND *** '            
                 DISPLAY '*** DB2 TABLE CSS_AUDIT_COND_DSC'             
                 DISPLAY '*** COMPANY_TYPE_CD ' AP-COMPANY-TYPE-CD      
                 DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE       
                 PERFORM 9900-ABEND     THRU 9900-EXIT                  
           END-EVALUATE.                                                
T37389     ADD 1                          TO WS-AUDIT-CNT.              
T37389     MOVE WS-AUDIT-CNT              TO WS-AUDIT-SUB.              
           MOVE AH-AUDIT-COND-CD          TO                            
                WS-AUDIT-COND-CD (WS-AUDIT-SUB).                        
A04494     MOVE AH-AUDIT-COND-DESC-TEXT(1:AH-AUDIT-COND-DESC-LEN) TO    
                WS-AUDIT-COND-DESC (WS-AUDIT-SUB).                      
           GO TO 0150-FETCH-AUDIT-DESC.                                 
      *                                                                 01986200
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01987000
      ************************************************************      02350000
      *   0690-INITIALIZE-FBE02-WS-AREA                          *      02360000
      ************************************************************      02370000
      *                                                                 02380000
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                 02490100
           PERFORM 7990-READ-INPUT THRU 7990-EXIT.                      
      *                                                                 02520000
           MOVE 'N'                       TO WS-AUDIT-FOUND-FLAG.       
A04494     INITIALIZE WS-HOLD-COND-CODE                                 
A04494                WS-HOLD-AUD-DESC                                  
A04494                WS-EMB-INPUT                                      
A04494                WS-CMP-TABLE.                                     
A04494     MOVE EXT-ACCT-MAIL-LINES TO WS-EMB-INPUT.                    
A04494     MOVE LENGTH OF EXT-ACCT-MAIL-LINES TO WS-EMB-LENG.           
A04494     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
A04494     MOVE WS-CMP-TABLE          TO WS-HOLD-AUD-DESC.              
                                                                        
           PERFORM VARYING WS-AUDIT-SUB FROM 1 BY 1 UNTIL               
T37389     WS-AUDIT-SUB > WS-AUDIT-CNT OR                               
           WS-AUDIT-FOUND-FLAG = 'Y'                                    
A04494       IF WS-HOLD-AUD-DESC          > SPACES AND                  
A04494          WS-HOLD-AUD-DESC          = WS-AUDIT-COND-DESC          
                                            (WS-AUDIT-SUB)              
                MOVE WS-AUDIT-COND-CD(WS-AUDIT-SUB)                     
                                         TO WS-HOLD-COND-CODE           
                MOVE 'Y'                 TO WS-AUDIT-FOUND-FLAG         
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 02610000
           IF WS-AUDIT-FOUND-FLAG = 'N'                                 
              DISPLAY '*** AUDIT DESCRIPTION NOT FOUND IN DATABASE***'  
A04494        DISPLAY '*** PLEASE CHECK FOR ' WS-HOLD-AUD-DESC          
A04494        IF WS-HOLD-AUD-DESC NOT =                                 
T35054           'From CSS_AUDIT_BLL_ACCT table'                        
T35054           PERFORM 1100-UPDATE-AUDITS  THRU 1100-EXIT             
T37389           ADD +1                  TO WS-AUDIT-CNT                
A02003           IF WS-AUDIT-CNT > 1998                                 
T37389             MOVE 12 TO RETURN-CODE                               
T37389             DISPLAY '**************************************'     
T37389             DISPLAY '**  TABLE WS-AUDIT-DESC-TABLE OVERFLOW'     
T37389             DISPLAY '**************************************'     
T37389             PERFORM 9900-ABEND THRU 9900-EXIT                    
T37389           END-IF                                                 
T37389           MOVE WS-AUDIT-CNT       TO WS-AUDIT-SUB                
C36428           MOVE AH-AUDIT-COND-CD   TO WS-AUDIT-COND-CD            
C36428                                      (WS-AUDIT-SUB)              
A04494           MOVE AH-AUDIT-COND-DESC-TEXT(1:AH-AUDIT-COND-DESC-LEN) 
A04494                 TO WS-AUDIT-COND-DESC(WS-AUDIT-SUB)              
T35054        END-IF                                                    
           ELSE                                                         
              PERFORM 2000-PROCESS-AUDIT   THRU 2000-EXIT               
           END-IF.                                                      
      *                                                                 02650000
T35152     IF END-OF-CA912                                              
T35152        MOVE 'Y'                 TO WS-END-REC-PROCESSED          
T35152     END-IF.                                                      
T35152*                                                                 02654000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02680000
T35054*************************************************************     02800100
T35054*  THE AUDIT CONDITION THAT COMES OUT OF THE FILE, IS NOT  *      02800200
T35054*  PRESENT IN THE DB2 TABLE, LOAD THE DB2 TABLE AND ALSO THE*     02800300
T35054*  WORKING STORAGE TABLE THAT HAVE THE DATA AND PROCESS THE *     02800400
T35054*  AUDIT CONDITION.                                        *      02800500
T35054*************************************************************     02800600
T35054*                                                                 02801000
T35054 1100-UPDATE-AUDITS.                                              
T35054*                                                                 02803000
A04494     MOVE WS-HOLD-AUD-DESC  TO AH-AUDIT-COND-DESC-TEXT.           
A04494     MOVE LENGTH OF AH-AUDIT-COND-DESC-TEXT                       
A04494                            TO AH-AUDIT-COND-DESC-LEN.            
T35054     PERFORM 7050-GET-AUDIT-COND         THRU 7050-EXIT.          
T35054     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T35054        PERFORM 7100-GET-MAX-AUDIT-COND  THRU 7100-EXIT           
T35054        IF AH-AUDIT-COND-CD IS NUMERIC                            
T35054          MOVE AH-AUDIT-COND-CD  TO WS-HOLD-AUD-COND-CD           
T35054          ADD 1                  TO WS-HOLD-AUD-COND-CD-N         
T35054          MOVE WS-HOLD-AUD-COND-CD TO AH-AUDIT-COND-CD            
T35054        END-IF                                                    
T35054        PERFORM 8100-INSERT-AUDIT-DESC THRU 8100-EXIT             
T35054     ELSE                                                         
T35054        MOVE AH-AUDIT-COND-CD    TO WS-HOLD-AUD-COND-CD           
T35054     END-IF.                                                      
T35054     MOVE WS-HOLD-AUD-COND-CD    TO WS-HOLD-COND-CODE.            
T35054     PERFORM 2000-PROCESS-AUDIT     THRU 2000-EXIT.               
T35054*                                                                 02810100
T35054 1100-EXIT.                                                       
T35054     EXIT.                                                        
T35054*                                                                 02811000
      ************************************************************      02812000
      * SELECT REVENUE MONTH LAST BILLED AND DATE BILL DAY 00    *      02820000
      * FROM CSS_ACCOUNT TABLE.                                  *      02821000
      * INSERT A ROW IN CSS_AUDIT_HISTORY TABLE FOR THE DETAILS  *      02830000
      * FROM FCSCA912 FILE.                                      *      02840000
      ************************************************************      02850000
       2000-PROCESS-AUDIT.                                              
      *                                                                 02870000
           MOVE EXT-ACCT-ACCOUNT-NO    TO AT-ACCOUNT-NO.                
           PERFORM 7000-GET-ACCT-DET   THRU 7000-EXIT.                  
      *                                                                 02900000
           MOVE EXT-SRT-COMPANY-NO     TO AX-COMPANY-NO.                
           MOVE EXT-ACCT-ACCOUNT-NO    TO AX-ACCOUNT-NO.                
           MOVE WS-DATE-BILLED         TO AX-DATE-BILLED.               
           MOVE AT-REV-MTH-LST-NRML    TO WS-HOLD-REV-MONTH.            
           MOVE WS-HOLD-REV-MONTH      TO AX-REVENUE-MONTH.             
           MOVE WS-HOLD-COND-CODE      TO AX-AUDIT-COND-CD.             
           MOVE WS-COMPANY-TYPE-CD     TO AX-COMPANY-TYPE-CD.           
      *                                                                 02960000
           PERFORM 8000-INSERT-AUDIT-HIST THRU 8000-EXIT.               
      *                                                                 02980000
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04494************************************************************              
A04494*  6010-REDUCE-EMBEDDED-SPACES                             *              
A04494************************************************************              
A04494                                                                  
A04494 COPY CPD00004.                                                           
A04494                                                                  
A04494*                                                                 03010000
      ************************************************************      03020000
      *  READ THE AUDIT BILL FILE                                *      03030000
      ************************************************************      03040000
      *                                                                 03050000
       7000-GET-ACCT-DET.                                               
      *                                                                 03070000
           EXEC SQL                                                     
                SELECT REV_MTH_LST_NRML                                 
                  INTO :AT-REV-MTH-LST-NRML                             
                  FROM CSS_ACCOUNT                                      
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03140000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSCA914:7000          ***'            
                    DISPLAY '*** 7000-GET-ACCT-DET      ***'            
                    DISPLAY '*** DB2 FUNCTION -  SELECT *** '           
                    DISPLAY '*** ACCOUNT_NO   - ' AT-ACCOUNT-NO         
                    DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE    
                    PERFORM 9900-ABEND     THRU 9900-EXIT               
           END-EVALUATE.                                                
      *                                                                 03270000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03300000
T35054 7050-GET-AUDIT-COND.                                             
T35054*                                                                 03300300
T35054     EXEC SQL                                                     
T35054          SELECT AUDIT_COND_CD                                    
T35054            INTO :AH-AUDIT-COND-CD                                
T35054            FROM CSS_AUDIT_COND_DSC                               
T35054           WHERE AUDIT_COND_DESC   =:AH-AUDIT-COND-DESC           
T35054     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35054*                                                                 03301000
T35054     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T35054                                       WS-DISPLAY-SQLCODE.        
T35054     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35054         WHEN SUCCESSFUL-CALL                                     
T35054         WHEN NOT-FOUND                                           
T35054              CONTINUE                                            
T35054         WHEN OTHER                                               
T35054              DISPLAY '*** PCSCA914:7050          ***'            
T35054              DISPLAY '*** 7050-GET-AUDIT-COND    ***'            
T35054              DISPLAY '*** DB2 FUNCTION -  SELECT *** '           
T35054              DISPLAY '*** AUDIT_COND_DESC - ' AH-AUDIT-COND-DESC 
T35054              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE    
T35054              PERFORM 9900-ABEND     THRU 9900-EXIT               
T35054     END-EVALUATE.                                                
T35054*                                                                 03302500
T35054 7050-EXIT.                                                       
T35054     EXIT.                                                        
T35054*                                                                 03303000
T35054 7100-GET-MAX-AUDIT-COND.                                         
T35054*                                                                 03305000
T35054     EXEC SQL                                                     
T35054          SELECT MAX(AUDIT_COND_CD)                               
T35054            INTO :AH-AUDIT-COND-CD                                
T35054            FROM CSS_AUDIT_COND_DSC                               
T35054     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35054*                                                                 03309200
T35054     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T35054                                       WS-DISPLAY-SQLCODE.        
T35054     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35054         WHEN SUCCESSFUL-CALL                                     
T35054              CONTINUE                                            
T35054         WHEN OTHER                                               
T35054              DISPLAY '*** PCSCA914:7100          ***'            
A04494              DISPLAY '*** 7100-GET-MAX-AUDIT-COND***'            
T35054              DISPLAY '*** DB2 FUNCTION -  SELECT *** '           
T35054              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE    
T35054              PERFORM 9900-ABEND     THRU 9900-EXIT               
T35054     END-EVALUATE.                                                
T35054*                                                                 03310500
T35054 7100-EXIT.                                                       
T35054     EXIT.                                                        
T35054*                                                                 03310800
T35152****************************************************************  03310900
T35152*   7200-GET-COMMON-DATE.                                      *  03311100
T35152*        GET THE COMMONDATE FROM CSS_JOB_PARM TABLE.           *  03311200
T35152****************************************************************  03311400
T35152 7200-GET-COMMON-DATE.                                            
T35152                                                                  
T35152     MOVE WS-COMMON-DATE      TO G6-PROGRAM-NAME.                 
T35152                                                                  
T35152     EXEC SQL                                                     
T35152        SELECT PARM_DATA                                          
T35152          INTO :G6-PARM-DATA                                      
T35152          FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
T35152        WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
T35152                                                          
T35152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03311900
MFA-TR*       SELECT PARM_DATA                                          03312000
MFA-TR*         INTO :G6-PARM-DATA                                      03312100
MFA-TR*         FROM CSS_JOB_PARM                                       03312200
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    03312300
MFA-TR*       WITH  UR                                                  03312400
MFA-TR*    END-EXEC.                                                    03312500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35152                                                                  
T35152     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
T35152                                 WS-DISPLAY-SQLCODE.              
T35152     EVALUATE WS-ACTIVE-RETURN-CODE                               
T35152         WHEN SUCCESSFUL-CALL                                     
T35152              CONTINUE                                            
T35152         WHEN OTHER                                               
T35152              DISPLAY '*** PCSCA914:7200          ***'            
A04494              DISPLAY '*** 7200-GET-COMMON-DATE   ***'            
T35152              DISPLAY '*** DB2 FUNCTION -  SELECT *** '           
T35152              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE    
T35152              PERFORM 9900-ABEND     THRU 9900-EXIT               
T35152     END-EVALUATE.                                                
T35152                                                                  
T35152 7200-EXIT.                                                       
T35152     EXIT.                                                        
T35152                                                                  
       7990-READ-INPUT.                                                 
                                                                        
           READ FCSCA912-FILE AT END                                    
               MOVE WS-Y               TO WS-END-OF-CA912.              
           IF CA912-SUCCESSFUL OR END-OF-CA912                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12                 TO RETURN-CODE                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA914 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA912       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA912-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03500000
       8000-INSERT-AUDIT-HIST.                                          
      *                                                                 03520000
           EXEC SQL                                                     
               INSERT INTO CSS_AUDIT_HISTORY                            
                     (AUDIT_COND_CD                                     
                     ,COMPANY_TYPE_CD                                   
                     ,COMPANY_NO                                        
                     ,DATE_BILLED                                       
                     ,REVENUE_MONTH                                     
                     ,ACCOUNT_NO )                                      
              VALUES (:AX-AUDIT-COND-CD                                 
                     ,:AX-COMPANY-TYPE-CD                               
                     ,:AX-COMPANY-NO                                    
                     ,IIF(TRY_CONVERT(DATE, :AX-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :AX-DATE-BILLED
              ) <> 0) OR (LEN(:AX-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :AX-DATE-BILLED
              ), CONVERT(DATE, :AX-DATE-BILLED) )                              
                     ,:AX-REVENUE-MONTH                                 
                     ,:AX-ACCOUNT-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03530000
MFA-TR*        INSERT INTO CSS_AUDIT_HISTORY                            03540000
MFA-TR*              (AUDIT_COND_CD                                     03550000
MFA-TR*              ,COMPANY_TYPE_CD                                   03551000
MFA-TR*              ,COMPANY_NO                                        03552000
MFA-TR*              ,DATE_BILLED                                       03553000
MFA-TR*              ,REVENUE_MONTH                                     03554000
MFA-TR*              ,ACCOUNT_NO )                                      03555000
MFA-TR*       VALUES (:AX-AUDIT-COND-CD                                 03556000
MFA-TR*              ,:AX-COMPANY-TYPE-CD                               03557000
MFA-TR*              ,:AX-COMPANY-NO                                    03557100
MFA-TR*              ,:AX-DATE-BILLED                                   03557200
MFA-TR*              ,:AX-REVENUE-MONTH                                 03557300
MFA-TR*              ,:AX-ACCOUNT-NO)                                   03557400
MFA-TR*    END-EXEC.                                                    03570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03580000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
      *    DISPLAY 'RECORD INSERTED ? WITH SQLCODE ' WS-DISPLAY-SQLCODE 03591000
                                                                        
           IF NOT (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                                            OR ALREADY-EXISTS)          
              DISPLAY '*** PCSCA914:8000          ***'                  
              DISPLAY '*** 8000-INSERT-AUDIT-HIST *** '                 
              DISPLAY '*** DB2 FUNCTION -  INSERT *** '                 
              DISPLAY '*** AUDIT_COND_CD   - 'AX-AUDIT-COND-CD          
              DISPLAY '*** COMPANY_TYPE_CD - 'AX-COMPANY-TYPE-CD        
              DISPLAY '*** COMPANY_NO      - 'AX-COMPANY-NO             
              DISPLAY '*** ACCOUNT_NO      - 'AX-ACCOUNT-NO             
              DISPLAY '*** REVENUE_MONTH   - 'AX-REVENUE-MONTH          
              DISPLAY '*** DATE_BILLED     - 'AX-DATE-BILLED            
              DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE          
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                 03700000
       8000-EXIT.                                                       
           EXIT.                                                        
T35054*                                                                 03730000
T35054*INSERT THE DATA INTO CSS_AUDIT_COND_DSC.                         03730100
T35054*                                                                 03731000
T35054                                                                  
T35054 8100-INSERT-AUDIT-DESC.                                          
T35054*                                                                 03731300
T35054     EXEC SQL                                                     
T35054          INSERT INTO CSS_AUDIT_COND_DSC                          
T35054               (AUDIT_COND_CD                                     
T35054               ,AUDIT_COND_DESC)                                  
T35054        VALUES (:AH-AUDIT-COND-CD                                 
T35054               ,:AH-AUDIT-COND-DESC)                              
T35054     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35054*                                                                 03732800
T35054     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T35054                                       WS-DISPLAY-SQLCODE.        
                                                                        
A04494     IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL)             
A04494        DISPLAY 'DATA LOADED FOR CSS_AUDIT_COND_DSC'              
A04494        DISPLAY 'AUDIT_COND_CD    - ' AH-AUDIT-COND-CD            
A04494        DISPLAY 'AUDIT_COND_DESC  - ' AH-AUDIT-COND-DESC          
A04494        MOVE WS-HOLD-AUD-COND-CD    TO AP-AUDIT-COND-CD           
A04494        MOVE WS-COMPANY-TYPE-CD     TO AP-COMPANY-TYPE-CD         
A04494        MOVE EXT-SRT-COMPANY-NO     TO AP-COMPANY-NO              
A04494        PERFORM 8200-INSERT-AUDIT-COND THRU 8200-EXIT             
A04494     END-IF.                                                      
T35054                                                                  
T35054     IF NOT (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL)         
T35054        DISPLAY '*** PCSCA914:8100          ***'                  
T35054        DISPLAY '*** 8100-INSERT-AUDIT-DESC *** '                 
T35054        DISPLAY '*** DB2 FUNCTION -  INSERT *** '                 
T35054        DISPLAY '*** AUDIT_COND_CD   - ' AH-AUDIT-COND-CD         
T35054        DISPLAY '*** AUDIT_COND_DESC - ' AH-AUDIT-COND-DESC       
T35054        DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE          
T35054        PERFORM 9900-ABEND     THRU 9900-EXIT                     
T35054     END-IF.                                                      
T35054*                                                                 03734700
T35054 8100-EXIT.                                                       
T35054     EXIT.                                                        
T35054*                                                                 03735000
T35054 8200-INSERT-AUDIT-COND.                                          
T35054*                                                                 03735200
T35054     EXEC SQL                                                     
T35054          INSERT INTO CSS_AUDIT_COND                              
T35054               (AUDIT_COND_CD                                     
T35054               ,COMPANY_TYPE_CD                                   
T35054               ,COMPANY_NO)                                       
T35054        VALUES (:AP-AUDIT-COND-CD                                 
T35054               ,:AP-COMPANY-TYPE-CD                               
T35054               ,:AP-COMPANY-NO)                                   
T35054     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35054*                                                                 03736200
T35054     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
T35054                                       WS-DISPLAY-SQLCODE.        
T35054*                                                                 03736500
A04494     IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL)             
A04494        DISPLAY 'DATA LOADED FOR CSS_AUDIT_COND    '              
A04494        DISPLAY 'AUDIT_COND_CD    - ' AP-AUDIT-COND-CD            
A04494        DISPLAY 'COMPANY_TYPE_CD  - ' AP-COMPANY-TYPE-CD          
A04494        DISPLAY 'COMPANY_NO       - ' AP-COMPANY-NO               
A04494        DISPLAY '*******************'                             
A04494     END-IF.                                                      
A04494                                                                  
T35054     IF NOT (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL)         
T35054        DISPLAY '*** PCSCA914:8200          ***'                  
T35054        DISPLAY '*** 8200-INSERT-AUDIT-COND *** '                 
T35054        DISPLAY '*** DB2 FUNCTION -  INSERT *** '                 
T35054        DISPLAY '*** AUDIT_COND_CD   - 'AP-AUDIT-COND-CD          
T35054        DISPLAY '*** COMPANY_TYPE_CD - 'AP-COMPANY-TYPE-CD        
T35054        DISPLAY '*** COMPANY_NO      - 'AP-COMPANY-NO             
T35054        DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE          
T35054        PERFORM 9900-ABEND     THRU 9900-EXIT                     
T35054     END-IF.                                                      
T35054*                                                                 03737600
T35054 8200-EXIT.                                                       
T35054     EXIT.                                                        
T35054*                                                                 03738000
       9000-TERMINATE.                                                  
      *                                                                 03750000
T35054     EXEC SQL                                                     
T35054         COMMIT                                                   
T35054     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03754000
           MOVE RETURN-CODE TO WS-STORE-RETURN-CODE                     
      *                                                                 03770000
           CLOSE FCSCA912-FILE.                                         
           IF RETURN-CODE = 0                                           
               MOVE WS-STORE-RETURN-CODE TO RETURN-CODE
           END-IF.                
      *                                                                 03810000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03840000
      ************************************************************      03850000
      *  9700-PROCESS-ABEND                                      *      03860000
      ************************************************************      03870000
      *                                                                 03880000
       COPY CPD0023B.                                                   03890000
      *                                                                 03900000
           EXEC SQL                                                     03910000
             INCLUDE CPD09900                                           03920000
           END-EXEC.                                                    03930000
      *                                                                 03940000
