       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA913.                                        
       AUTHOR.         GOKUL SATHIYAMOORTHY.                            
       DATE-WRITTEN.   FEBRUARY 2008.                                   
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  02-2008   GOKUL        INITIAL VERSION OF THE PROGRAM      **         
PRJ211**  11-2009   MANOJ        EARLY RENEWAL PROJECT CHANGES       **         
PRJ211**  12-2009   ALEX         UPDATE FOR EARLY RENEWAL.           **         
P00411**  07-2010   SV           mplement WNA for Electric           **         
A02003**  09-2010   DMS          Add desc for AGL Senior Discount    **         
P00430**  11-2010   DMS          Increase max for audit loop         **         
A02879**  12-2010   DMS          Use internal long description for   **         
A02879**                         the option code description         **         
A03019**  02-2011   DMS          Remove check for AGL Sr Discount    **         
A03258**  05-2011   DMS          Add rate and factor id to the       **         
A03258**                         option code description             **         
P00453**  10-2011   EH           Increase audit desc subscript to 197**         
P00565**  11-2011   SDHAL        Audit rewrite                       **         
P00473**  08-2011   SV           RATE ENTRY - BUSINESS PROCESS ADVISOR*         
P00680**  06-2012   RAJ          Customer Retention & Acquisition    **         
A04429**  10-2012   SDHAL        Added unmetered rates for audit     **         
P00805**  05-2014   DMS          Add new marketing bill message 50518**         
P00892**  10-2015   SV95326      ADD NEW MARKETING BILL MESSAGE FOR  **         
P00892**                         Fixed Rate Auto-Renewal.            **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA913 NARRATIVE                                 
      **                                                                        
      **  THIS PROGRAM HANDLES THE AUDIT PROCESSING. IT READS THE AUDIT         
      **  CODES AND POPULATES AUDIT DESC TO MAILING ADDRESS FIELDS.             
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
                                                                        
           COPY CFDCA912.                                                       
       01  E-SRT-IDX-REC                     PIC X(802).                
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-OPT-DESC  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA913'.
MSQ017     COPY MFASQLM.
                                                                        
           COPY CWS00091.                                                       
           COPY CWS09900.                                                       
A02879     COPY CWS00303.                                                       
A02879     COPY CWS0024B.                                                       
                                                                        
       01  WS-MISC.                                                     
           05  WS-MULTI-CUSTOMER             PIC X  VALUE ' '.          
               88  FIRST-MULTIPLE                   VALUE 'Y'.          
               88  THIS-IS-MULTIPLE                 VALUE 'N'.          
           05  WS-LAST-MULTI-CUSTOMER        PIC X  VALUE ' '.          
               88  LAST-MULTIPLE                    VALUE 'Y'.          
           05  WS-WRITE-ACCT-SW              PIC X  VALUE ' '.          
               88  WRITE-ACCT                       VALUE 'Y'.          
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
           05  WS-AUDIT-DATA.                                           
               10 WS-TEMP-AUDIT-CD           PIC X(4).                  
               10 WS-AUDIT-COND-CODE REDEFINES WS-TEMP-AUDIT-CD         
                                             PIC 9(4).                  
               10 WS-AUDIT-RATE-PLAN         PIC X(3).                  
               10 FILLER                     PIC X(13).                 
           05  WS-HOLD-AUDIT-DATA.                                      
               10 WS-HOLD-AUDIT-CODE         PIC X(4).                  
               10 WS-AUDIT-OPTION-CD         PIC X(12).                 
               10 WS-AUDIT-MSG-DATA  REDEFINES WS-AUDIT-OPTION-CD.      
                  15 WS-AUDIT-MSG-NO         PIC 9(5).                  
                  15 FILLER                  PIC X(7).                  
               10 WS-AUDIT-SENIOR-FL         PIC X(1).                  
A03258         10 WS-AUDIT-OPTION-RATE       PIC X(03).                 
A03258     05  WS-AUDIT-FACTOR-ID            PIC X(12).                 
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05  WS-MKTING-MSG-DESC            PIC X(300) VALUE SPACES.   
           05  WS-AGL-SENIOR-DESC            PIC X(24)  VALUE SPACES.   
A02879     05  WS-OPT-DESC-INT-LONG          PIC X(100) VALUE SPACES.   
A02879     05  WS-MISC-IDX                   PIC 9(09) COMP-3 VALUE 0.  
A02879     05  OPT-CNT                       PIC S9(5) COMP-3 VALUE +0. 
A02879     05  WS-ROW-COUNT-OPT-CD       PIC S9(09) USAGE COMP VALUE 0. 
P00565     05  WS-HOLD-AUDIT-DESC            PIC X(45) VALUE SPACES.    
P00565     05  WS-IS-AUDIT-COND-FOUND        PIC X VALUE 'N'.           
P00565         88 AUDIT-COND-FOUND           VALUE 'Y'.                 
P00565     05  WS-IS-OPTN-OR-MSSG            PIC X VALUE 'N'.           
P00565         88 OPTN-OR-MSSG               VALUE 'Y'.                 
                                                                        
       01  WS-AUDIT-TBL.                                                
           05  WS-AUD-CNT                  PIC S9(3) COMP-3 VALUE +0.   
           05  WS-AUDIT-TABLE OCCURS 0 TO 9999                          
               DEPENDING ON WS-AUD-CNT                                  
               INDEXED BY WS-AUD-IND.                                   
               10  WS-AUD-OPTION-CD        PIC X(12).                   
               10  WS-AUD-SENIOR-FL        PIC X(1).                    
A03258         10  WS-AUD-OPTION-RATE      PIC X(03).                   
A03258         10  WS-AUD-FACTOR-ID        PIC X(12).                   
                                                                        
       01  WS-MKTING-MSG-TBL.                                           
           05  WS-MSG-CNT                  PIC S9(3) COMP-3 VALUE +0.   
           05  WS-MKTING-TABLE OCCURS 0 TO 9999                         
               DEPENDING ON WS-MSG-CNT                                  
               INDEXED BY WS-MSG-IND.                                   
               10  WS-AUD-MKTING-MSG       PIC X(12).                   
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA913'.  
           05  WS-COMMON               PIC X(08)     VALUE 'COMMON  '.  
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-DASHES               PIC X(10)     VALUE ALL '-'.     
                                                                        
A02879 01  OPT-DESC-TABLE.                                              
A02879     05  OPT-DESC-TBL OCCURS 0 TO 9999                            
A02879         DEPENDING ON OPT-CNT                                     
A02879         ASCENDING KEY OPTION-CD                                  
A02879         INDEXED BY OPT-IND.                                      
A02879         10 OPTION-CD                PIC X(12).                   
A02879         10 OPT-DESC-INT-LONG        PIC X(100).                  
                                                                        
A02879*   THE FOLLOWING HOST VARIABLES ARE FOR CRM_RT_PKG_OPTION                
A02879 01 WS-OPT-DESC-HV.                                               
A02879    05 WS-OPTION-CD-HV         PIC X(12) OCCURS 100 TIMES.        
A02879    05 WS-INT-DESC-LONG-HV     PIC X(100) OCCURS 100 TIMES.       
A02879*   END HOST VARIABLES FOR CRM_RT_PKG_OPTION                              
                                                                        
A02879* SQL COMMUNICATION AREA.                                                 
A02879     EXEC SQL                                                             
A02879         INCLUDE SQLCA                                                    
A02879     END-EXEC.                                                            
A02879                                                                  
A02879* DCLGEN TABLE(CSS_DELINQUENCY)                                           
A02879     EXEC SQL                                                     00058700
A02879          INCLUDE TBDELQ                                          00058800
A02879     END-EXEC.                                                    00058900
A02879                                                                  
A02879* CURSOR TO FETCH OPTION INTERNAL LONG DESCRIPTION                        
A02879     EXEC SQL                                                     
A02879        DECLARE OPT_DESC      CURSOR WITH ROWSET POSITIONING FOR  
A02879        SELECT OPTION_CD                                          
A02879              ,COALESCE(
           OPT_DESC_INT_LONG,'DESC NOT FOUND IN TABLE') 
A02879          FROM CRM_RT_PKG_OPTION WITH(READUNCOMMITTED)                    
A02879        WHERE STATUS_CD = 'A'                                     
P00473          AND OPT_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()                
P00473          AND OPT_VEND_TS     >= CIS.CURRENT$TIMESTAMP()                
P00473          AND PROC_STATUS_CD  = 'AC'                              
A02879        ORDER BY OPTION_CD                                        
A02879        FOR READ ONLY                                     
A02879     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_DESC      CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT OPTION_CD                                                  
MFA-TR*             ,VALUE(OPT_DESC_INT_LONG,'DESC NOT FOUND IN TABLE')         
MFA-TR*         FROM CRM_RT_PKG_OPTION                                          
MFA-TR*       WHERE STATUS_CD = 'A'                                             
MFA-TR*         AND OPT_VSTART_TS   <= CURRENT TIMESTAMP                        
MFA-TR*         AND OPT_VEND_TS     >= CURRENT TIMESTAMP                        
MFA-TR*         AND PROC_STATUS_CD  = 'AC'                                      
MFA-TR*       ORDER BY OPTION_CD                                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              

SCA006        SET OPT-IND TO 1.
                                                                        
      *****************************************************************         
      *  PERFORM THE INITIALIZATION ROUTINE.  READ THE FIRST RECORD   *         
      *  FROM THE INPUT FILE, WHICH MUST BE THE BEGINNING CONTROL     *         
      *  RECORD (KEY OF LOW VALUES).  WRITE THIS CONTROL RECORD TO THE*         
      *  OUTPUT FILE.  PERFORM THE MAIN PROGRAM PROCESS ROUTINE.      *         
      *  THE LAST RECORD ON FILE MUST BE THE ENDING CONTROL RECORD    *         
      *  (KEY OF HIGH VALUES).                                        *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT.                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  GET DATES, TIMES, TITLES FOR REPORT HEADERS.    *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT  FCSCA911-FILE                                    
                OUTPUT FCSCA912-FILE.                                   
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911'                    
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *   AUDIT PROCESSING.                                      *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-READ-SORT-INDEX            THRU 7000-EXIT.      
                                                                        
A02879***GET WHICH DATABASE WE ARE DEALING WITH                         00126000
A02879     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
A02879     MOVE EXT-SRT-COMPANY-NO             TO C8-COMPANY-NO.        
A02879     PERFORM 7100-GET-DATABASE           THRU 7100-EXIT.          
A02879     MOVE C8-DELINQ-VALUE                TO LS-DATABASE.          
A02879     IF SEB-DATABASE                                              
A02879        PERFORM 8800-LOAD-OPT-TBL THRU 8800-EXIT                  
A02879     END-IF.                                                      
                                                                        
           PERFORM 2000-PROCESS-ACCT-ADDRESS       THRU 2000-EXIT       
                                              UNTIL END-OF-CA911.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS THE VARIOUS AUDIT CODES & PROCESSES THEM.  *         
      *****************************************************************         
                                                                        
       2000-PROCESS-ACCT-ADDRESS.                                       
                                                                        
P00565     MOVE SPACES                        TO EXT-BILL-AUDIT-GRP-CD, 
P00565                                           EXT-SRT-MULT-ID.       
P00565     MOVE  'N'                          TO WS-IS-OPTN-OR-MSSG.    
           MOVE EXT-BILL-AUDIT-CODES               TO                   
                                              WS-HOLD-AUDIT-DATA        
                                              WS-AUDIT-DATA.            
A04429     IF WS-HOLD-AUDIT-CODE = 'UMTR'                               
A04429        MOVE SPACES                          TO                   
A04429                                            EXT-ACCT-MAIL-LINES   
A04429        STRING           'Rate/Step Selection (unmetered) '       
A04429                         WS-AUDIT-RATE-PLAN                       
A04429                         DELIMITED BY SIZE                        
A04429                         INTO EXT-ACCT-MAIL-LINES                 
A04429        MOVE 'R'                    TO EXT-BILL-AUDIT-GRP-CD,     
A04429                                       EXT-SRT-MULT-ID            
A04429        SET WRITE-ACCT              TO TRUE                       
A04429     END-IF.                                                      
                                                                        
           IF WS-HOLD-AUDIT-CODE = 'RATE'                               
              MOVE SPACES                          TO                   
                                                  EXT-ACCT-MAIL-LINES   
              STRING           'Rate/Step Selection (energy) '          
                               WS-AUDIT-RATE-PLAN                       
                               DELIMITED BY SIZE                        
                               INTO EXT-ACCT-MAIL-LINES                 
P00565        MOVE 'R'                    TO EXT-BILL-AUDIT-GRP-CD,     
P00565                                       EXT-SRT-MULT-ID            
              SET WRITE-ACCT              TO TRUE                       
           END-IF.                                                      
                                                                        
           IF WS-HOLD-AUDIT-CODE = 'DMND'                               
              MOVE SPACES                          TO                   
                                                  EXT-ACCT-MAIL-LINES   
              STRING           'Rate/Step Selection (demand) '          
                               WS-AUDIT-RATE-PLAN                       
                               DELIMITED BY SIZE                        
                               INTO EXT-ACCT-MAIL-LINES                 
P00565        MOVE 'R'                    TO EXT-BILL-AUDIT-GRP-CD,     
P00565                                       EXT-SRT-MULT-ID            
              SET WRITE-ACCT              TO TRUE                       
           END-IF.                                                      
                                                                        
           IF WS-HOLD-AUDIT-CODE = 'TBLE'                               
              MOVE SPACES                          TO                   
                                                  EXT-ACCT-MAIL-LINES   
              MOVE 'From CSS_AUDIT_BLL_ACCT table' TO                   
                                                  EXT-ACCT-MAIL-LINES   
P00565        MOVE 'U'                    TO EXT-BILL-AUDIT-GRP-CD,     
P00565                                       EXT-SRT-MULT-ID            
              SET WRITE-ACCT              TO TRUE                       
           END-IF.                                                      
                                                                        
           IF WS-HOLD-AUDIT-CODE = 'OPTN'                               
P00565        MOVE 'Y'                             TO WS-IS-OPTN-OR-MSSG
              PERFORM 2200-GET-OPTION-DESC         THRU 2200-EXIT       
P00565        IF WRITE-ACCT                                             
P00565            MOVE 'R'                         TO                   
P00565                                         EXT-BILL-AUDIT-GRP-CD,   
P00565                                         EXT-SRT-MULT-ID          
P00565        END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOLD-AUDIT-CODE = 'MSSG'                               
P00565        MOVE 'Y'                             TO WS-IS-OPTN-OR-MSSG
              PERFORM 2300-GET-MKTING-MSG-DESC     THRU 2300-EXIT       
P00565        IF WRITE-ACCT                                             
P00565            MOVE 'K'                         TO                   
P00565                                         EXT-BILL-AUDIT-GRP-CD,   
P00565                                         EXT-SRT-MULT-ID          
P00565        END-IF                                                    
           END-IF.                                                      
                                                                        
P00565     IF (WS-HOLD-AUDIT-CODE > SPACES) AND                         
P00565        (EXT-BILL-AUDIT-GRP-CD = SPACES) AND                      
P00565        NOT (OPTN-OR-MSSG)                                        
P00565        PERFORM 2100-GET-AUDIT-GROUP         THRU 2100-EXIT       
P00565        IF NOT WRITE-ACCT                                         
P00565           PERFORM 2150-GET-AUDIT-DESC       THRU 2150-EXIT       
P00565        END-IF                                                    
           END-IF.                                                      
                                                                        
P00565     IF (WS-HOLD-AUDIT-CODE > SPACES) AND                         
P00565     NOT (OPTN-OR-MSSG) AND                                       
P00565     EXT-BILL-BILL-DEST-CODE = 'S'                                
P00565        MOVE '1' TO EXT-BILL-AUDIT-GRP-CD,                        
P00565                    EXT-SRT-MULT-ID                               
P00565     END-IF.                                                      
                                                                        
           IF WRITE-ACCT                                                
              PERFORM 8000-WRITE-SORT-IDX          THRU 8000-EXIT       
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-SORT-INDEX            THRU 7000-EXIT.      
           MOVE SPACES                             TO WS-WRITE-ACCT-SW. 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
P00565*****************************************************************         
P00565*  THIS ROUTINE GETS AUDIT GROUP TO GROUP THE AUDIT CODES       *         
P00565*****************************************************************         
                                                                        
P00565 2100-GET-AUDIT-GROUP.                                            
                                                                        
P00565     MOVE 1                             TO SUB1.                  
P00565     MOVE 'Z'                           TO EXT-BILL-AUDIT-GRP-CD, 
P00565                                           EXT-SRT-MULT-ID.       
P00565     MOVE 'NOT FOUND'                   TO WS-HOLD-AUDIT-DESC.    
P00565     MOVE 'N'                           TO WS-IS-AUDIT-COND-FOUND.
P00565     PERFORM UNTIL (SUB1 > WS-MAX-AUDIT-COND) OR AUDIT-COND-FOUND 
P00565         IF WS-AUDIT-CONDITION (SUB1) = WS-AUDIT-COND-CODE        
P00565             MOVE WS-AUDIT-COND-GRP (SUB1)   TO                   
P00565                                            EXT-BILL-AUDIT-GRP-CD,
P00565                                            EXT-SRT-MULT-ID       
P00565             MOVE WS-AUDIT-DESC (SUB1)       TO                   
P00565                                            WS-HOLD-AUDIT-DESC    
P00565             MOVE 'Y'                 TO WS-AUDIT-SELECTED (SUB1) 
P00565             MOVE 'Y'                 TO WS-IS-AUDIT-COND-FOUND   
P00565         END-IF                                                   
P00565         ADD 1                               TO SUB1              
P00565     END-PERFORM.                                                 
P00565 2100-EXIT.                                                       
P00565     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS AUDIT DESC FOR THE AUDIT CODES FROM        *         
      *  SORT INDEX FILE.                                             *         
      *****************************************************************         
                                                                        
       2150-GET-AUDIT-DESC.                                             
                                                                        
           MOVE SPACES                   TO WS-WRITE-ACCT-SW.           
           MOVE SPACES                   TO EXT-ACCT-MAIL-LINES.        
P00565     MOVE WS-HOLD-AUDIT-DESC       TO EXT-ACCT-MAIL-LINES.        
           SET WRITE-ACCT                TO TRUE.                       
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE PROCESSES AUDITS FOR MARKETING OPTIONS.         *         
      *****************************************************************         
                                                                        
       2200-GET-OPTION-DESC.                                            
                                                                        
           MOVE SPACES                           TO WS-WRITE-ACCT-SW    
A02003                                              WS-AGL-SENIOR-DESC  
A02879                                            WS-OPT-DESC-INT-LONG. 
           SET WS-AUD-IND                          TO 1.                
                                                                        
A03258     MOVE EXT-BILL-AUDIT-FCTR-ID TO WS-AUDIT-FACTOR-ID.           
                                                                        
A02879     PERFORM 2400-GET-MSG-DESC THRU 2400-EXIT.                    
                                                                        
           SEARCH WS-AUDIT-TABLE VARYING WS-AUD-IND                     
             AT END                                                     
                ADD 1                              TO WS-AUD-CNT        
                MOVE WS-AUDIT-OPTION-CD            TO                   
                                            WS-AUD-OPTION-CD(WS-AUD-CNT)
                MOVE WS-AUDIT-SENIOR-FL            TO                   
                                            WS-AUD-SENIOR-FL(WS-AUD-CNT)
A03258          MOVE WS-AUDIT-OPTION-RATE          TO                   
A03258                                    WS-AUD-OPTION-RATE(WS-AUD-CNT)
A03258          MOVE WS-AUDIT-FACTOR-ID            TO                   
A03258                                    WS-AUD-FACTOR-ID(WS-AUD-CNT)  
A02003          IF WS-AUDIT-SENIOR-FL = 'Y'                             
A02003             MOVE 'with AGL Senior Discount' TO WS-AGL-SENIOR-DESC
A02003          END-IF                                                  
                SET WRITE-ACCT                     TO TRUE              
                MOVE SPACES                        TO                   
                                                  EXT-ACCT-MAIL-LINES   
                STRING                      'OPTION: '                  
                                            WS-AUDIT-OPTION-CD          
                                            ' - '                       
A02879                                      WS-OPT-DESC-INT-LONG        
                                            DELIMITED BY SIZE           
                                                 INTO                   
                                                  EXT-ACCT-MAIL-LINES   
A03258          MOVE WS-AGL-SENIOR-DESC TO EXT-ACCT-MAIL-LINE-4         
A03258          STRING                      'CORE RATE: '               
A03258                                      WS-AUDIT-OPTION-RATE        
A03258                                      DELIMITED BY SIZE           
A03258                                           INTO                   
A03258                                            EXT-ACCT-MAIL-LINE-5  
A03258          STRING                      'FACTOR: '                  
A03258                                      WS-AUDIT-FACTOR-ID          
A03258                                      DELIMITED BY SIZE           
A03258                                           INTO                   
A03258                                            EXT-ACCT-MAIL-LINE-6  
             WHEN WS-AUD-OPTION-CD(WS-AUD-IND) = WS-AUDIT-OPTION-CD     
                MOVE SPACES                        TO WS-WRITE-ACCT-SW  
           END-SEARCH.                                                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS DESCRIPTION FOR MARKETING MESSAGES.        *         
      *****************************************************************         
                                                                        
       2300-GET-MKTING-MSG-DESC.                                        
                                                                        
           MOVE SPACES                             TO WS-WRITE-ACCT-SW  
                                                     WS-MKTING-MSG-DESC.
           SET WS-MSG-IND                          TO 1.                
                                                                        
           EVALUATE WS-AUDIT-MSG-NO                                     
               WHEN 50501                                               
                 STRING 'Fixed Rate Anniv PreRenewal Bill Message '     
PRJ211                  '- Deregulated'                                 
PRJ211                  DELIMITED BY SIZE                               
                                                 INTO WS-MKTING-MSG-DESC
               WHEN 50504                                               
                   IF EXT-ACCT-REGULATED-CD = '02'                      
                      MOVE 'Fixed Rate Drop Message - Regulated'        
                                                   TO WS-MKTING-MSG-DESC
                   ELSE                                                 
                      MOVE 'Fixed Rate Drop Message - Deregulated'      
                                                   TO WS-MKTING-MSG-DESC
                   END-IF                                               
               WHEN 50510                                               
                   MOVE '60-Day Free CSC Expiration Message '           
                                                   TO WS-MKTING-MSG-DESC
               WHEN 50511                                               
                   MOVE '60-Day Free Bill Credit Expiration Message '   
                                                   TO WS-MKTING-MSG-DESC
               WHEN 50512                                               
                   STRING 'Variable Rate with 6 or 12 Consecutive '     
                          'Timely Payments with CSC Reduction '         
                          DELIMITED BY SIZE                             
                                                 INTO WS-MKTING-MSG-DESC
               WHEN 50513                                               
                   STRING 'Variable Rate with 2 Months Missed '         
                          'Payments '                                   
                          DELIMITED BY SIZE                             
                                                 INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50514                                               
PRJ211             STRING 'Customer Credit Expiration Message '         
PRJ211                    '- DeRegulated'                               
PRJ211                    DELIMITED BY SIZE                             
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50515                                               
PRJ211             MOVE 'Group 1 Senior Bill Message - Regulated'       
PRJ211                                             TO WS-MKTING-MSG-DESC
PRJ211         WHEN 50516                                               
PRJ211            STRING 'Dropped from Group 1 Senior to Group '        
PRJ211                   '2 due to non Payment - Regulated'             
PRJ211                    DELIMITED BY SIZE                             
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50517                                               
PRJ211          STRING 'Fixed Rate Anniv Renewal Bill Message '         
PRJ211                 '- Deregulated'                                  
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
P00805         WHEN 50518                                               
P00805          STRING 'Fixed Rate Anniv w/Pending Rate Bill Message '  
P00805                 '- Deregulated'                                  
P00805                  DELIMITED BY SIZE                               
P00805                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50521                                               
PRJ211          STRING 'Fixed Rate Renewal Remainder Message '          
PRJ211                 '- DeRegulated'                                  
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50522                                               
PRJ211          STRING 'Fixed Rate Pending Renewal Message '            
PRJ211                 '- Deregulated'                                  
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50523                                               
PRJ211          MOVE 'Fixed Rate Renewal Message - DeRegulated'         
PRJ211                                             TO WS-MKTING-MSG-DESC
P00680         WHEN 50525                                               
P00680          MOVE 'Flex Rate Option Active Message - Deregulated'    
P00680                                             TO WS-MKTING-MSG-DESC
P00680         WHEN 50526                                               
P00680          MOVE 'Flex Rate Option Expired Message - Deregulated'   
P00680                                             TO WS-MKTING-MSG-DESC
PRJ211         WHEN 50601                                               
PRJ211          STRING 'Fixed Rate Anniv PreRenewal Bill Message '      
PRJ211                 '- Regulated'                                    
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50617                                               
PRJ211          STRING 'Fixed Rate Anniv Renewal Bill Message '         
PRJ211                 '- Regulated'                                    
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50619                                               
PRJ211          STRING 'Fixed Rate Drop Message - Regulated '           
PRJ211                 '6 Month Good Payment Reduction or '             
PRJ211                 'Medium/Lowest CSC with No Reduction'            
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50620                                               
PRJ211          STRING 'Fixed Rate Drop Message - Regulated '           
PRJ211                 'with 2 Missed Payment Increase'                 
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50621                                               
PRJ211          STRING 'Fixed Rate Renewal Remainder Message '          
PRJ211                 '- Regulated'                                    
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50622                                               
PRJ211          STRING 'Fixed Rate Pending Renewal Message '            
PRJ211                 '- Regulated'                                    
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50623                                               
PRJ211          MOVE 'Fixed Rate Renewal Message - Regulated'           
PRJ211                                             TO WS-MKTING-MSG-DESC
PRJ211         WHEN 50624                                               
PRJ211          STRING 'Fixed Rate Pending Renewal Message '            
PRJ211                 '- Regulated with Good Payment Reduction'        
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN 50625                                               
PRJ211          STRING 'Fixed Rate Pending Renewal Message '            
PRJ211                 '- Regulated with 2 Missed Payment'              
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
P00892         WHEN 50520                                               
P00892          STRING 'Auto Renew 30 day message '                     
P00892                 '- Deregulated'                                  
P00892                  DELIMITED BY SIZE                               
P00892                                           INTO WS-MKTING-MSG-DESC
P00892         WHEN 50626                                               
P00892          STRING 'Auto Renew OPT-out message '                    
P00892                 '- Deregulated'                                  
P00892                  DELIMITED BY SIZE                               
P00892                                           INTO WS-MKTING-MSG-DESC
P00892         WHEN 50627                                               
P00892          STRING 'PreRenew on Auto Renew '                        
P00892                 '- Deregulated'                                  
P00892                  DELIMITED BY SIZE                               
P00892                                           INTO WS-MKTING-MSG-DESC
P00892         WHEN 50628                                               
P00892          STRING 'PreRenew withAuto Renew '                       
P00892                 '- Deregulated'                                  
P00892                  DELIMITED BY SIZE                               
P00892                                           INTO WS-MKTING-MSG-DESC
PRJ211         WHEN OTHER                                               
PRJ211          STRING 'Marketing Message # '                           
PRJ211                 WS-AUDIT-MSG-NO                                  
PRJ211                  DELIMITED BY SIZE                               
PRJ211                                           INTO WS-MKTING-MSG-DESC
           END-EVALUATE.                                                
                                                                        
           SEARCH WS-MKTING-TABLE VARYING WS-MSG-IND                    
             AT END                                                     
                ADD 1                              TO WS-MSG-CNT        
                MOVE WS-AUDIT-MSG-NO               TO                   
                                           WS-AUD-MKTING-MSG(WS-MSG-CNT)
                SET WRITE-ACCT                     TO TRUE              
             WHEN WS-AUD-MKTING-MSG(WS-MSG-IND) = WS-AUDIT-MSG-NO       
                MOVE SPACES                        TO WS-WRITE-ACCT-SW  
           END-SEARCH.                                                  
                                                                        
           IF WS-MKTING-MSG-DESC > SPACES AND WRITE-ACCT                
                MOVE SPACES                        TO                   
                                                  EXT-ACCT-MAIL-LINES   
                MOVE WS-MKTING-MSG-DESC              TO                 
                                                  EXT-ACCT-MAIL-LINES   
           ELSE                                                         
              MOVE SPACES                        TO WS-WRITE-ACCT-SW    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02879***************************************************************           
A02879*  GET OPTION DESCRIPTION.                                    *           
A02879***************************************************************           
A02879 2400-GET-MSG-DESC.                                               
A02879                                                                  
A02879     SEARCH ALL OPT-DESC-TBL                                      
A02879     AT END                                                       
A02879        DISPLAY '** PCSCA913 - OPTION CODE ' WS-AUDIT-OPTION-CD   
A02879                ' NOT FOUND **'                                   
A02879        MOVE SPACES               TO WS-OPT-DESC-INT-LONG         
A02879     WHEN                                                         
A02879        OPTION-CD(OPT-IND) = WS-AUDIT-OPTION-CD                   
A02879        MOVE OPT-DESC-INT-LONG(OPT-IND) TO WS-OPT-DESC-INT-LONG   
A02879     END-SEARCH.                                                  
A02879                                                                  
A02879 2400-EXIT.                                                       
A02879     EXIT.                                                        
      ************************************************************              
      *  READ THE SORT INDEX FILE                                *              
      ************************************************************              
                                                                        
       7000-READ-SORT-INDEX.                                            
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL OR END-OF-CA911                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA913 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02879************************************************************      02543000
A02879*  7100-GET-DATABASE                                       *      02544000
A02879************************************************************      02545000
A02879     EXEC SQL                                                     14298000
A02879        INCLUDE CPD00240                                                  
A02879     END-EXEC.                                                    14300000
A02879                                                                  
      ************************************************************      17189000
      *  CALL AFAPLINT TO WRITE THE BE28 OUTPUT FILE.            *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           MOVE SPACES                     TO E-SRT-IDX-REC.            
           MOVE EXT-SORTIDX-FILE           TO E-SRT-IDX-REC.            
           WRITE E-SRT-IDX-REC.                                         
                                                                        
           IF CA912-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '      
                        WS-CA912-STATUS                                 
               PERFORM 9000-TERMINATE      THRU 9000-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02879********************************************************                  
A02879*  LOAD THE OPTION DESCRIPTION TABLE.                  *                  
A02879********************************************************                  
A02879 8800-LOAD-OPT-TBL.                                               
A02879                                                                  
A02879     PERFORM 8810-OPEN-OPT-DESC     THRU 8810-EXIT.               
A02879     PERFORM 8820-FETCH-OPT-DESC     THRU 8820-EXIT               
A02879        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
A02879     PERFORM 8830-CLOSE-OPT-DESC     THRU 8830-EXIT.              
A02879                                                                  
A02879 8800-EXIT.                                                       
A02879     EXIT.                                                        
                                                                        
A02879 8810-OPEN-OPT-DESC.                                              
A02879                                                                  
A02879     EXEC SQL                                                     
A02879         OPEN OPT_DESC                                            
A02879     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02879                                                                  
A02879     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02879     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02879        DISPLAY '****** 8810-OPEN-OPT-DESC   '                    
A02879        DISPLAY ' ** ' PROGRAM-NAME  ' PROCESSING ERROR'          
A02879        DISPLAY ' ** ERROR ON OPEN   '                            
A02879        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02879        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02879     END-IF.                                                      
A02879     MOVE 1                          TO WS-MISC-IDX.              
A02879                                                                  
A02879 8810-EXIT.                                                       
A02879     EXIT.                                                        
A02879                                                                  
A02879 8820-FETCH-OPT-DESC.                                             
A02879                                                                  
A02879     INITIALIZE WS-OPT-DESC-HV.                                   
A02879     MOVE 0 TO WS-ROW-COUNT-OPT-CD.                               

MSQ008     MOVE 100 TO MSQ008-OPT-DESC
A02879     EXEC SQL                                                     
A02879         FOR :MSQ008-OPT-DESC
              FETCH 
              FROM OPT_DESC              
A02879          INTO                                                    
A02879               :WS-OPTION-CD-HV                                   
A02879              ,:WS-INT-DESC-LONG-HV                               
A02879     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM OPT_DESC     FOR 100 ROWS                 
MFA-TR*         INTO                                                            
MFA-TR*              :WS-OPTION-CD-HV                                           
MFA-TR*             ,:WS-INT-DESC-LONG-HV                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-OPT-DESC
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02879                                                                  
A02879     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02879     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02879         WHEN SUCCESSFUL-CALL                                     
A02879         WHEN NOT-FOUND                                           
A02879         WHEN 354                                                 
A02879             EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT               
A02879             END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                                     
MFA-TR*                  :WS-ROW-COUNT-OPT-CD = ROW_COUNT                       
MFA-TR*            END-EXEC                                                     
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT-OPT-CD
A02879             MOVE 1 TO WS-MISC-IDX                                
A02879             PERFORM UNTIL WS-MISC-IDX > 100                      
A02879                        OR WS-MISC-IDX > WS-ROW-COUNT-OPT-CD      
A02879                 ADD 1 TO OPT-CNT                                 
A02879                 MOVE WS-OPTION-CD-HV(WS-MISC-IDX)                
A02879                       TO OPTION-CD(OPT-CNT)                      
A02879                 MOVE WS-INT-DESC-LONG-HV(WS-MISC-IDX)            
A02879                       TO OPT-DESC-INT-LONG(OPT-CNT)              
A02879                 ADD 1 TO WS-MISC-IDX                             
A02879             END-PERFORM                                          
A02879             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
A02879                GO TO 8820-EXIT                                   
A02879             END-IF                                               
A02879         WHEN OTHER                                               
A02879              DISPLAY '****** 8820-FETCH-OPT-DESC   '             
A02879              DISPLAY ' ** ' PROGRAM-NAME  ' PROCESSING ERROR'    
A02879              DISPLAY ' ** ERROR ON FETCH  '                      
A02879              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
A02879              PERFORM 9900-ABEND THRU 9900-EXIT                   
A02879     END-EVALUATE.                                                
A02879                                                                  
A02879 8820-EXIT.                                                       
A02879     EXIT.                                                        
A02879                                                                  
A02879 8830-CLOSE-OPT-DESC.                                             
A02879                                                                  
A02879     EXEC SQL                                                     
A02879         CLOSE OPT_DESC                                           
A02879     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02879                                                                  
A02879     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02879     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02879        DISPLAY '****** 8830-CLOSE-OPT-DESC'                      
A02879        DISPLAY ' ** ' PROGRAM-NAME  ' PROCESSING ERROR'          
A02879        DISPLAY ' ** ERROR ON CLOSE  '                            
A02879        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02879        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02879     END-IF.                                                      
A02879                                                                  
A02879 8830-EXIT.                                                       
A02879     EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA911-FILE                                          
                 FCSCA912-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM PROBLEM OCCURS.                          *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
