HPCCDM*       CBL ADV                                                           
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA912.                                        
       AUTHOR.         GOKUL SATHIYAMOORTHY.                            
       DATE-WRITTEN.   FEBRUARY 2008.                                   
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  02-2008   GOKUL        INITIAL VERSION OF THE PROGRAM      **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA912 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM FLAGS ALL THE MULTIPLES WITH THE GROUP THEY   **         
      **  ARE IN (G4 OR G5), GENERATES SEQUENCE NUMBERS AND          **         
      **  GENERATES SUB-SEQUENCE NUMBERS FOR G5 MULTIPLES.           **         
      **                     CHANGE SUMMARY                          **         
      **  TAG    MM/YYYY   NAME    PURPOSE                           **         
      **  P00114 01/2009   SDHAL   MODIFIED MAX SHEETS FOR G5 FROM   **         
      **                           24 TO 9.                          **         
A04444**  A00444 01/2012   RAJ     MAKE GRP5 SUB SEQ TO 1 FOR MASTER **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
           COPY CFDCA912.                                                       
 CISOP 01  E-SRT-IDX-REC                     PIC X(802).                
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
           COPY CWS09900.                                                       
                                                                        
       01  WS-MISC.                                                     
           05  WS-MULTI-CUSTOMER             PIC X  VALUE ' '.          
               88  FIRST-MULTIPLE                   VALUE 'Y'.          
               88  THIS-IS-MULTIPLE                 VALUE 'N'.          
           05  WS-MULTIPLE-GROUP             PIC XX VALUE '  '.         
               88  G5-MULTIPLE                      VALUE 'G5'.         
               88  G4-MULTIPLE                      VALUE 'G4'.         
           05  WS-LAST-MULTI-CUSTOMER        PIC X  VALUE ' '.          
               88  LAST-MULTIPLE                    VALUE 'Y'.          
           05  WS-FIRST-TIME-SW              PIC X  VALUE ' '.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-CURRENT-DATA.                                         
               10  WS-CURR-NAME              PIC X(50).                 
               10  WS-CURR-ADDR              PIC X(50).                 
               10  WS-CURR-OFLO              PIC X(50).                 
               10  WS-CURR-CITY              PIC X(50).                 
               10  WS-CURR-ZIP               PIC X(11).                 
               10  WS-CURR-ACCT              PIC X(13).                 
           05  WS-PREV-DATA.                                            
               10  WS-PREV-NAME              PIC X(50).                 
               10  WS-PREV-ADDR              PIC X(50).                 
               10  WS-PREV-OFLO              PIC X(50).                 
               10  WS-PREV-CITY              PIC X(50).                 
               10  WS-PREV-ZIP               PIC X(11).                 
               10  WS-PREV-ACCT              PIC X(13).                 
           05  WS-MULTIPLE-DATA.                                        
               10  WS-MULTI-NAME             PIC X(50).                 
               10  WS-MULTI-ADDR             PIC X(50).                 
               10  WS-MULTI-OFLO             PIC X(50).                 
               10  WS-MULTI-CITY             PIC X(50).                 
               10  WS-MULTI-ZIP              PIC X(11).                 
               10  WS-MULTI-ACCT             PIC X(13).                 
           05  WS-TMP-ADDR-DATA              PIC X(224).                
           05  WS-ADDR-DATA.                                            
               10 WS-ADDR-TYPE               PIC X(02) OCCURS 6 TIMES.  
               10 WS-ADDR-LINE               PIC X(50) OCCURS 6 TIMES.  
           05  WS-MULTI-ADDR-DATA.                                      
               10 WS-MULTI-ADDR-DATA-TABLE  OCCURS 6 TIMES.             
                  15 WS-MULTI-ADDR-TYPE      PIC X(02).                 
                  15 WS-MULTI-ADDR-LINE      PIC X(50).                 
           05  WS-NO-BILL-COPIES             PIC 9(4).                  
P00114     05  WS-HOLD-MULTI-SHEETS          PIC 9(4) VALUE 0.          
P00114     05  WS-SHEETS-IN-THIS-ACCT        PIC 9(4) VALUE 0.          
           05  WS-AVG-SHEET-IN-ENVLP         PIC 9(4) VALUE 0.          
           05  WS-TEMP-SRT-IDX-DATA          PIC X(802) VALUE SPACES.   
           05  WS-HOLD-SRT-IDX-DATA          PIC X(802) VALUE SPACES.   
           05  FILLER REDEFINES WS-HOLD-SRT-IDX-DATA.                   
               10 FILLER                     PIC X(355).                
               10 WS-ENVELOPE-ID.                                       
                  15 WS-MULTIPLE-ID          PIC 9(11).                 
                  15 WS-G5-SUB-SEQ           PIC 9(02).                 
               10 FILLER                     PIC X(13).                 
               10 WS-HOLD-MARKS.                                        
                  15 WS-HOLD-INSERT-MARKS    PIC X(1) OCCURS 12 TIMES.  
               10 FILLER                     PIC X(409).                
           05  WS-MULTIPLE-MARKS             PIC X(5) VALUE '00000'.    
           05  WS-MULTIPLES-INSERT-MARK  REDEFINES WS-MULTIPLE-MARKS    
                                             PIC X OCCURS 5 TIMES.      
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY         PIC 9(04).                   
               10  WS-CURRENT-MM           PIC 9(02).                   
               10  WS-CURRENT-DD           PIC 9(02).                   
               10  WS-CURRENT-HH           PIC 9(02).                   
               10  WS-CURRENT-MS           PIC 9(02).                   
               10  WS-CURRENT-SS           PIC 9(02).                   
                                                                        
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
           05  WS-PREV-ACCOUNT-NO            PIC S9(13) COMP-3 VALUE 0. 
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05  WS-MULTIPLE-ID-CT             PIC S9(11) COMP.           
           05  WS-SEQUENCE-NO                PIC S9(13) COMP.           
           05  WS-CURR-MULTIPLE-ID           PIC S9(11) COMP.           
           05  WS-PREV-MULTIPLE-ID           PIC S9(11) COMP.           
           05  WS-HOLD-MULTIPLE-ID           PIC S9(11) COMP.           
           05  WS-HOLD-G5-SUB-SEQ            PIC 9(02)  COMP  VALUE 0.  
           05  WS-HOLD-RETURN-ENVLP          PIC X(1) VALUE '0'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
           05  WS-ACCOUNT-CHANGE-SW          PIC X VALUE 'N'.           
               88  ACCOUNT-CHANGE             VALUE 'Y'.                
                                                                        
       01  WS-CALLING-PARAGRAPH              PIC X(4).                  
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA912'.  
           05  WS-COMMON               PIC X(08)     VALUE 'COMMON  '.  
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-DASHES               PIC X(10)     VALUE ALL '-'.     
           05  WS-USERABEN             PIC X(08)     VALUE 'USERABEN'.  
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  MAIN PROCESS AREA.                                           *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT.                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  GET DATES, TIMES, TITLES FOR REPORT HEADERS.    *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT  FCSCA911-FILE                                    
                OUTPUT FCSCA912-FILE.                                   
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911'                    
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *   PROCESS MULTIPLES RECORDS FROM PCSCA911 AND SEQUENCE   *              
      *   THEM PROPERLY.                                         *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-READ-FCSCA911              THRU 7000-EXIT.      
           SET FIRST-TIME                          TO TRUE.             
           PERFORM 2000-PROCESS-ACCT-ADDRESS       THRU 2000-EXIT       
                                              UNTIL END-OF-CA911.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS THE DATA & LOADS THE INDIVIDUAL ADDRESS    *         
      *  FIELDS FOR AN ACCOUNT.                                       *         
      *****************************************************************         
                                                                        
       2000-PROCESS-ACCT-ADDRESS.                                       
                                                                        
           MOVE EXT-SORTIDX-FILE                   TO                   
                                              WS-HOLD-SRT-IDX-DATA.     
           MOVE EXT-SRT-MULTIPLE-ID                TO                   
                                              WS-CURR-MULTIPLE-ID.      
                                                                        
           IF WS-CURR-MULTIPLE-ID = WS-PREV-MULTIPLE-ID                 
                                                                        
P00114        COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +                    
P00114                                       (EXT-SRT-PAGE-TOTAL / 2)   
P00114        ADD WS-SHEETS-IN-THIS-ACCT           TO                   
P00114                                       WS-HOLD-MULTI-SHEETS       
              SET THIS-IS-MULTIPLE                 TO TRUE              
           ELSE                                                         
P00114        COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +                    
P00114                                       (EXT-SRT-PAGE-TOTAL / 2)   
P00114        MOVE WS-SHEETS-IN-THIS-ACCT TO WS-HOLD-MULTI-SHEETS       
P00114        MOVE EXT-ACCT-OMR-MARK-3             TO                   
P00114                                       WS-HOLD-RETURN-ENVLP       
           END-IF.                                                      
           PERFORM 7000-READ-FCSCA911              THRU 7000-EXIT.      
                                                                        
           IF END-OF-CA911 AND THIS-IS-MULTIPLE                         
              SET LAST-MULTIPLE                    TO TRUE              
           END-IF.                                                      
                                                                        
           INITIALIZE                        WS-TEMP-SRT-IDX-DATA       
                                             WS-MULTIPLE-DATA.          
           MOVE EXT-SORTIDX-FILE                   TO                   
                                             WS-TEMP-SRT-IDX-DATA.      
           MOVE EXT-SRT-MULTIPLE-ID                TO                   
                                              WS-HOLD-MULTIPLE-ID.      
                                                                        
           MOVE WS-HOLD-SRT-IDX-DATA               TO EXT-SORTIDX-FILE. 
           IF EXT-SRT-MULTIPLE-ID = WS-HOLD-MULTIPLE-ID                 
              IF FIRST-TIME OR NOT THIS-IS-MULTIPLE                     
                 MOVE EXT-SRT-GROUP-ID             TO WS-MULTIPLE-GROUP 
                 SET THIS-IS-MULTIPLE              TO TRUE              
                 MOVE SPACES                       TO WS-FIRST-TIME-SW  
                 IF G5-MULTIPLE                                         
P00114              COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +              
P00114                                       (EXT-SRT-PAGE-TOTAL / 2)   
P00114              MOVE WS-SHEETS-IN-THIS-ACCT TO WS-HOLD-MULTI-SHEETS 
P00114              INITIALIZE               WS-HOLD-G5-SUB-SEQ         
P00114              MOVE 9                     TO                       
                                             WS-AVG-SHEET-IN-ENVLP      
                    MOVE 1                         TO                   
                                             WS-HOLD-G5-SUB-SEQ         
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF THIS-IS-MULTIPLE                                       
                 MOVE SPACES                       TO                   
                                             WS-MULTI-CUSTOMER          
                 SET LAST-MULTIPLE                 TO TRUE              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF G4-MULTIPLE                                               
              MOVE 'G4'                            TO EXT-SRT-GROUP-ID  
           END-IF.                                                      
                                                                        
           PERFORM 2100-PROCESS-OUTPUT-FILES       THRU 2100-EXIT.      
                                                                        
           MOVE WS-TEMP-SRT-IDX-DATA               TO                   
                                             EXT-SORTIDX-FILE.          
           INITIALIZE                        WS-PREV-MULTIPLE-ID.       
           MOVE WS-CURR-MULTIPLE-ID                TO                   
                                             WS-PREV-MULTIPLE-ID.       
           INITIALIZE                        WS-CURR-MULTIPLE-ID        
                                             WS-FIRST-TIME-SW.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE WRITES OUT GROUP 1, MULTIPLES, DUPLICATES &     *         
      *  MULTIPLE DUPLICATES TO THE OUTPUT FILE.                      *         
      *****************************************************************         
                                                                        
       2100-PROCESS-OUTPUT-FILES.                                       
                                                                        
           MOVE 1                                   TO SUB1.            
           IF G5-MULTIPLE                                               
              MOVE 'G5'                             TO                  
                                             EXT-SRT-GROUP-ID           
P00114        IF WS-HOLD-MULTI-SHEETS  >   WS-AVG-SHEET-IN-ENVLP        
                 ADD 1                              TO                  
                                             WS-HOLD-G5-SUB-SEQ         
                 MOVE '0'                           TO                  
                                             EXT-ACCT-OMR-MARK-2        
P00114           MOVE WS-HOLD-RETURN-ENVLP          TO                  
P00114                                       EXT-ACCT-OMR-MARK-3        
P00114           COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +                 
P00114                                       (EXT-SRT-PAGE-TOTAL / 2)   
P00114           MOVE WS-SHEETS-IN-THIS-ACCT        TO                  
P00114                                       WS-HOLD-MULTI-SHEETS       
              END-IF                                                    
                 MOVE WS-HOLD-G5-SUB-SEQ     TO EXT-SRT-G5-SUB-SEQ      
           END-IF.                                                      
A04444     IF EXT-ACCT-MASTER-SUB-FLAG = 'M'                            
A04444        MOVE 1                         TO EXT-SRT-G5-SUB-SEQ      
A04444     END-IF.                                                      
           PERFORM 8000-WRITE-SORT-IDX              THRU 8000-EXIT.     
                                                                        
           IF LAST-MULTIPLE                                             
              MOVE SPACES                           TO                  
                                             WS-LAST-MULTI-CUSTOMER     
                                             WS-MULTIPLE-GROUP          
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  READ THE CA911 INPUT FILE                               *              
      ************************************************************              
                                                                        
       7000-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL OR END-OF-CA911                          
               ADD 1               TO   WS-SEQUENCE-NO                  
               MOVE WS-SEQUENCE-NO TO   EXT-SRT-SEQUENCE-NO             
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA912 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      17189000
      *  CALL AFAPLINT TO WRITE THE BE28 OUTPUT FILE.            *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           MOVE SPACES                     TO E-SRT-IDX-REC.            
           MOVE EXT-SORTIDX-FILE           TO E-SRT-IDX-REC.            
           WRITE E-SRT-IDX-REC.                                         
                                                                        
           IF CA912-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '      
                        WS-CA912-STATUS                                 
               PERFORM 9000-TERMINATE      THRU 9000-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA911-FILE                                          
                 FCSCA912-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
