HPCCDM*       CBL ADV                                                           
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA911.                                        
       AUTHOR.         GOKUL SATHIYAMOORTHY.                            
       DATE-WRITTEN.   FEBRUARY 2008.                                   
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      *****************************************************************         
                                                                        
PRJ166**  09/15/09  MH94819      CALL SCSCA165 TO GET UNIQUE          *         
PRJ166**                         IDENTIFIER AND WRITE TO OUTPUT FILE  *         
PRJ166**                         ONLY FOR THE DUPLICATE BILL RECORDS  *         
A02003**  08/30/10  RAJ          FIX GROUP 5 ISSUE.                   *         
A02003**  08/30/10  RAJ          FIX GROUP 5 ISSUE. THE ADDRESS FIELDS*         
A02003**                         ARE NOT INITIALIZED BEFORE REUSED    *         
A02003**                         WHICH CAUSED G1 BILL MAILED AS G5.   *         
A04203**  11/30/12  RAJ          MARK SVC ACCOUNTS AS GROUP 4.        *         
A04444**  01/09/12  RAJ          PROCESS CONSOLIDATED MASTER ACCT WITH*         
A04444**                         LESS THAN 10 PAGES AS GROUP 5.       *         
      *****************************************************************         
      **                     PCSCA911 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM HANDLES THE MULTIPLES/DUPLICATES PROCESSING.  **         
      **      * THE INSERT MARKS FOR MULTIPLES/DUPLICATES ARE        **         
      **        SAVED AND WRITTEN TO THE LAST ACCOUNT IN THE GROUP.  **         
      **      * THE MULTIPLES GROUP IDENTIFIER IS WRITTEN OUT TO THE **         
      **        LAST ACCOUNT IN THE GROUP.                           **         
      **  IN ADDITION A MULTIPLES REPORT IS PRODUCED, WHICH DETAILS  **         
      **  ACCOUNTS WHOSE ADDRESSES MATCH EXACTLY AND WILL BE MAILED  **         
      **  IN ONE ENVELOPE.                                           **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
           COPY CSSP232.                                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
                                                                        
           COPY CFDCA912.                                                       
CISOP  01  E-SRT-IDX-REC                     PIC X(802).                
           COPY CFDP232.                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA911'.
                                                                        
           COPY CWS09900.                                                       
PRJ166     COPY CWS00303.                                                       
PRJ166*** COPYBOOKS FOR WORKING STORAGE FOR SCSCA165********            05704002
PRJ166     COPY CWSCA165.                                                       
PRJ166     COPY CWS00010.                                                       
PRJ166******************************************************            05704002
                                                                        
       01  WS-MISC.                                                     
           05  WS-MULTI-CUSTOMER             PIC X  VALUE ' '.          
               88  FIRST-MULTIPLE                   VALUE 'Y'.          
               88  THIS-IS-MULTIPLE                 VALUE 'N'.          
           05  WS-LAST-MULTI-CUSTOMER        PIC X  VALUE ' '.          
               88  LAST-MULTIPLE                    VALUE 'Y'.          
           05  WS-FIRST-TIME-SW              PIC X  VALUE ' '.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-CURRENT-DATA.                                         
               10  WS-CURR-NAME              PIC X(50).                 
               10  WS-CURR-ADDR              PIC X(50).                 
               10  WS-CURR-OFLO              PIC X(50).                 
               10  WS-CURR-CITY              PIC X(50).                 
               10  WS-CURR-ZIP               PIC X(11).                 
               10  WS-CURR-ACCT              PIC X(13).                 
           05  WS-PREV-DATA.                                            
               10  WS-PREV-NAME              PIC X(50).                 
               10  WS-PREV-ADDR              PIC X(50).                 
               10  WS-PREV-OFLO              PIC X(50).                 
               10  WS-PREV-CITY              PIC X(50).                 
               10  WS-PREV-ZIP               PIC X(11).                 
               10  WS-PREV-ACCT              PIC X(13).                 
           05  WS-MULTIPLE-DATA.                                        
               10  WS-MULTI-NAME             PIC X(50).                 
               10  WS-MULTI-ADDR             PIC X(50).                 
               10  WS-MULTI-OFLO             PIC X(50).                 
               10  WS-MULTI-CITY             PIC X(50).                 
               10  WS-MULTI-ZIP              PIC X(11).                 
               10  WS-MULTI-ACCT             PIC X(13).                 
           05  WS-TMP-ADDR-DATA              PIC X(224).                
           05  WS-ADDR-DATA.                                            
               10 WS-ADDR-TYPE               PIC X(02) OCCURS 6 TIMES.  
               10 WS-ADDR-LINE               PIC X(50) OCCURS 6 TIMES.  
           05  WS-MULTI-ADDR-DATA.                                      
               10 WS-MULTI-ADDR-DATA-TABLE  OCCURS 6 TIMES.             
                  15 WS-MULTI-ADDR-TYPE      PIC X(02).                 
                  15 WS-MULTI-ADDR-LINE      PIC X(50).                 
           05  WS-NO-BILL-COPIES             PIC 9(4).                  
           05  WS-TEMP-PAGES                 PIC 9(4) VALUE 0.          
           05  WS-TEMP-PAGES1                PIC 9(4) VALUE 0.          
           05  WS-TOTAL-MULTI-PAGES          PIC 9(4) VALUE 0.          
           05  WS-TOTAL-MULTI-SHEETS         PIC 9(4) VALUE 0.          
PRJ166     05  WS-EXT-BILL-BARCODE-UNIQUE-ID  PIC 9(9) VALUE 0.         
PRJ166     05  WS-EXT-BILL-TRACKING-STATUS-CD PIC X(2) VALUE SPACES.    
PRJ166     05  WS-DATABASE                   PIC 9(01) VALUE 0.         
PRJ166         88  CSR-DATABASE                      VALUE 1.           
PRJ166         88  SEB-DATABASE                      VALUE 2.           
PRJ166     05  WS-DISPLAY-SCSCA               PIC X(8) VALUE SPACES.    
PRJ166     05  WS-SCSCA-RETURN-CODE           PIC S9(4) COMP.           
PRJ166     05  WS-SCSCA165-CALL               PIC  X(1) VALUE 'N'.      
           05  WS-TEMP-SRT-IDX-DATA          PIC X(802) VALUE SPACES.   
           05  WS-HOLD-SRT-IDX-DATA          PIC X(802) VALUE SPACES.   
           05  FILLER REDEFINES WS-HOLD-SRT-IDX-DATA.                   
               10 FILLER                     PIC X(381).                
               10 WS-HOLD-MARKS.                                        
                  15 WS-HOLD-INSERT-MARKS    PIC X(1) OCCURS 12 TIMES.  
               10 FILLER                     PIC X(409).                
           05  WS-MULTIPLE-MARKS             PIC X(5) VALUE '00000'.    
           05  WS-MULTIPLES-INSERT-MARK  REDEFINES WS-MULTIPLE-MARKS    
                                             PIC X OCCURS 5 TIMES.      
           05  WS-HOLD-DATA.                                            
               10  WS-HOLD-ACCT              PIC X(13).                 
               10  WS-HOLD-SERV-ADDR         PIC X(41).                 
               10  WS-HOLD-SERV-OFLO         PIC X(41).                 
               10  WS-HOLD-SERV-CITY         PIC X(41).                 
               10  WS-HOLD-SERV-ZIP          PIC X(11).                 
                                                                        
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY           PIC 9(04).                 
               10  WS-CURRENT-MM             PIC 9(02).                 
               10  WS-CURRENT-DD             PIC 9(02).                 
               10  WS-CURRENT-HH             PIC 9(02).                 
               10  WS-CURRENT-MS             PIC 9(02).                 
               10  WS-CURRENT-SS             PIC 9(02).                 
                                                                        
           05  WS-LINE-COUNT-01             PIC S9(03) COMP-3 VALUE +99.
           05  WS-PAGE-COUNT-01              PIC S9(05) COMP-3 VALUE +0.
           05  WS-LINE-COUNT-02             PIC S9(03) COMP-3 VALUE +99.
           05  WS-PAGE-COUNT-02              PIC S9(05) COMP-3 VALUE +0.
           05  WS-PRINT-SW                   PIC X    VALUE ' '.        
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
           05  WS-PREV-ACCOUNT-NO            PIC S9(13) COMP-3 VALUE 0. 
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05  WS-DISPLAY-INPUT              PIC -Z(7)9.                
           05  WS-DISPLAY-OUTPUT             PIC -Z(7)9.                
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MONTH           PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-DAY             PIC XX.                    
               10  FILLER                    PIC X   VALUE '-'.         
               10  WS-FORMAT-YEAR            PIC X(4).                  
           05  WS-FORMAT-ZIP.                                           
               10  WS-FORMAT-FIVE              PIC X(05).               
               10  WS-FORMAT-DASH              PIC X.                   
               10  WS-FORMAT-FOUR              PIC X(04).               
               10  WS-FORMAT-USPS-DELIV-PT-CD  PIC X(02).               
           05  WS-TODAYS-DATE                PIC 9(08)    VALUE  0.     
           05  WS-TIME-OF-DAY                PIC 9(08)    VALUE  0.     
           05  WS-RUN-DATE                   PIC X(10).                 
           05  WS-SYS-DATE                   PIC 9(06) VALUE ZEROES.    
           05  FILLER                  REDEFINES                        
               WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY            PIC 9(02).                 
               10  WS-SYS-DATE-MM            PIC 9(02).                 
               10  WS-SYS-DATE-DD            PIC 9(02).                 
           05  WS-SYSTEM-DATE.                                          
               10  WS-SYST-YY                PIC 99.                    
               10  WS-SYST-MM                PIC 99.                    
               10  WS-SYST-DD                PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-SYSTEM-TIME.                                          
               10  WS-SYSTEM-HH              PIC 99.                    
               10  WS-SYSTEM-MM              PIC 99.                    
               10  WS-SYSTEM-SS              PIC 99.                    
               10  F                         PIC XX VALUE SPACES.       
           05  WS-RUN-TIME.                                             
               10  WS-RUN-HH                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-MM                 PIC 99.                    
               10  F                         PIC X VALUE ':'.           
               10  WS-RUN-SS                 PIC 99.                    
           05  WS-MULTIPLE-ID-CT             PIC S9(11) COMP.           
A04203     05  WS-MULTIPLE-BREAK             PIC X  VALUE ' '.          
A04203         88  MULTIPLE-BREAK                   VALUE 'Y'.          
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA911'.  
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSC1111'.  
           05  WS-PGRMNAME2            PIC X(08)     VALUE 'PCSC1112'.  
           05  WS-COMMON               PIC X(08)     VALUE 'COMMON  '.  
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-DASHES               PIC X(10)     VALUE ALL '-'.     
           05  WS-USERABEN             PIC X(08)     VALUE 'USERABEN'.  
           05  WS-RPT1-TITLE           PIC X(50)     VALUE              
               '         SOUTH CAROLINA ELECTRIC AND GAS          '.    
           05  WS-RPT1-HEAD            PIC X(50)     VALUE              
               ' RECORDS WITH UNMATCHED ADDRESS OVERFLOW AND ZIP  '.    
           05  WS-RPT2-TITLE           PIC X(50)     VALUE              
               '         SOUTH CAROLINA ELECTRIC AND GAS          '.    
           05  WS-RPT2-HEAD            PIC X(50)     VALUE              
               '          MULTIPLE BILLS DETAIL LISTING           '.    
                                                                        
       01  WS-BLANK-LINE                   PIC X(132) VALUE SPACES.     
       01  WS-NO-DATA-LINE                 PIC X(132) VALUE             
           '               NO DATA THIS RUN.                     '.     
       01  P-HEADER-LINE-1.                                             
           05  P-RPT1-NAME            PIC X(8).                         
           05  FILLER                 PIC X(34) VALUE SPACES.           
           05  P-RPT1-TITLE           PIC X(50).                        
           05  FILLER                 PIC X(19) VALUE SPACES.           
           05  FILLER                 PIC X(11) VALUE 'RUN DATE:  '.    
           05  P-RUN-DATE             PIC X(10).                        
                                                                        
       01  P-HEADER-LINE-2.                                             
           05  FILLER                   PIC X(07)  VALUE 'DATE: '.      
           05  P-REPORT-DATE            PIC X(10).                      
           05  FILLER                   PIC X(25)  VALUE SPACES.        
           05  P-RPT1-HEAD              PIC X(50).                      
           05  FILLER                   PIC X(21)  VALUE SPACES.        
           05  FILLER                   PIC X(11)  VALUE 'RUN TIME:  '. 
           05  P-RUN-TIME               PIC X(08).                      
                                                                        
       01  P-HEADER-LINE-2A.                                            
           05  FILLER                   PIC X(56)  VALUE SPACES.        
           05  FILLER                   PIC X(14)  VALUE                
               'CURRENT AS OF '.                                        
           05  P-LINE-2A-DATE           PIC X(10).                      
           05  FILLER                   PIC X(37)  VALUE SPACES.        
           05  FILLER                   PIC X(10)  VALUE 'PAGE:  '.     
           05  P-PAGE-NO                PIC Z,ZZ9.                      
                                                                        
       01  P-HEADER-LINE-3.                                             
           05  FILLER                      PIC X(15)                    
               VALUE 'ACCOUNT NUMBER'.                                  
           05  FILLER                      PIC X(36)                    
               VALUE 'CUSTOMER NAME'.                                   
           05  FILLER                      PIC X(40)                    
               VALUE 'SERVICE ADDRESS'.                                 
           05  FILLER                      PIC X(35)                    
               VALUE 'MAILING ADDRESS'.                                 
                                                                        
       01  P-DETAIL-LINE-1.                                             
           05  P-ACCOUNT-NO                PIC Z(13).                   
           05  FILLER                      PIC X(02)  VALUE SPACES.     
           05  P-AREA1                     PIC X(35).                   
           05  FILLER                      PIC X(01)  VALUE SPACES.     
           05  P-AREA2                     PIC X(38).                   
           05  FILLER                      PIC X(02)  VALUE SPACES.     
           05  P-AREA3                     PIC X(38).                   
                                                                        
PRJ166*****************************************************************         
PRJ166*  DCLGEN FOR SQL PROCESSING                                    *         
PRJ166*****************************************************************         
PRJ166     EXEC SQL                                                             
PRJ166         INCLUDE SQLCA                                                    
PRJ166     END-EXEC.                                                            
PRJ166                                                                  
PRJ166*****************************************************************         
PRJ166*  DCLGEN FOR CSS_DELINQUENCY C8                                *         
PRJ166*****************************************************************         
PRJ166     EXEC SQL                                                             
PRJ166         INCLUDE TBDELQ                                                   
PRJ166     END-EXEC.                                                            
PRJ166                                                                  
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  MAIN PROCESS AREA.                                           *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT.                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  GET DATES, TIMES, TITLES FOR REPORT HEADERS.    *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE SPACES                             TO WS-PREV-DATA.     
           MOVE SPACES                             TO WS-CURRENT-DATA.  
           MOVE SPACES                             TO WS-MULTIPLE-DATA. 
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                       TO WS-CURRENT-DATE.              
           STRING    WS-CURRENT-MM                                      
                     '-'                                                
                     WS-CURRENT-DD                                      
                     '-'                                                
                     WS-CURRENT-CCYY                                    
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-DATE.                 
           MOVE P-RUN-DATE             TO P-REPORT-DATE                 
                                          P-LINE-2A-DATE.               
           STRING    WS-CURRENT-HH                                      
                     ':'                                                
                     WS-CURRENT-MS                                      
                     ':'                                                
                     WS-CURRENT-SS                                      
                     DELIMITED BY SIZE                                  
                                       INTO P-RUN-TIME.                 
           OPEN INPUT  FCSCA911-FILE                                    
                OUTPUT FCSCA912-FILE                                    
                       FCSP232-FILE.                                    
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911'                    
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *   IF MAILING NAME AND ADDRESS MATCH, DETERMINE NUMBER OF *              
      *   BILLS INTO THE ENVELOPE AND WRITE TO THE CA912 OUTPUT  *              
      *   FILE.  IF MORE THAT ONE BILL GOES TO THE ADDRESS, WRITE*              
      *   A MULTIPLE BILLS REPORT LINE.                          *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-READ-FCSCA911              THRU 7000-EXIT.      
           SET FIRST-TIME                          TO TRUE.             
                                                                        
PRJ166     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
PRJ166     IF EXT-SRT-COMPANY-NO IS NUMERIC                             
PRJ166        MOVE EXT-SRT-COMPANY-NO           TO C8-COMPANY-NO        
PRJ166     ELSE                                                         
PRJ166        MOVE '01'                         TO C8-COMPANY-NO        
PRJ166     END-IF.                                                      
PRJ166     PERFORM 7100-GET-DELINQUECY          THRU 7100-EXIT.         
PRJ166     MOVE C8-DELINQ-VALUE                 TO WS-DATABASE.         
                                                                        
           PERFORM 2000-PROCESS-ACCT-ADDRESS       THRU 2000-EXIT       
                                              UNTIL END-OF-CA911.       
           IF (WS-SCSCA165-CALL = 'Y'  AND                              
               WS-CA165IN-OK-TO-PROCESS = 'Y')                          
PRJ166       MOVE  'Y'                          TO                      
PRJ166                                  WS-CA165IN-END-OF-PROG-FL       
PRJ166       MOVE 'BLLPRT'                      TO                      
PRJ166                                  WS-CA165IN-CORR-TYPE            
PRJ166     PERFORM 2400-CALL-SCSCA165         THRU 2400-EXIT            
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS THE DATA & LOADS THE INDIVIDUAL ADDRESS    *         
      *  FIELDS FOR AN ACCOUNT.                                       *         
      *****************************************************************         
                                                                        
       2000-PROCESS-ACCT-ADDRESS.                                       
                                                                        
           INITIALIZE                         WS-TEMP-PAGES             
                                              WS-TEMP-PAGES1.           
           MOVE EXT-SORTIDX-FILE                   TO                   
                                              WS-HOLD-SRT-IDX-DATA.     
           MOVE EXT-ACCT-ACCOUNT-NO                TO WS-CURR-ACCT.     
           MOVE EXT-ACCT-ZIPCODE                   TO WS-CURR-ZIP.      
           MOVE EXT-ACCT-ADDR-DETAILS              TO WS-ADDR-DATA.     
           MOVE EXT-ACCT-ACCOUNT-NO                TO WS-HOLD-ACCT      
           MOVE EXT-BILL-SERVICE-LINE-1            TO WS-HOLD-SERV-ADDR 
           MOVE EXT-BILL-SERVICE-LINE-2            TO WS-HOLD-SERV-OFLO 
           MOVE EXT-BILL-SERVICE-LINE-3            TO WS-HOLD-SERV-CITY 
PRJ166     MOVE EXT-BILL-BARCODE-UNIQUE-ID         TO                   
PRJ166                                  WS-EXT-BILL-BARCODE-UNIQUE-ID   
PRJ166     MOVE EXT-BILL-TRACKING-STATUS-CD        TO                   
PRJ166                                  WS-EXT-BILL-TRACKING-STATUS-CD  
                                                                        
           PERFORM 2050-PROCESS-ADDRESS-FIELDS     THRU 2050-EXIT.      
                                                                        
                                                                        
           IF WS-CURR-NAME = WS-PREV-NAME   AND                         
              WS-CURR-ADDR = WS-PREV-ADDR   AND                         
              WS-CURR-OFLO = WS-PREV-OFLO   AND                         
              WS-CURR-CITY = WS-PREV-CITY   AND                         
              WS-CURR-ZIP (1:5) = WS-PREV-ZIP (1:5)                     
                                                                        
              ADD EXT-SRT-PAGE-TOTAL               TO                   
                                                   WS-TOTAL-MULTI-PAGES 
              DIVIDE EXT-SRT-PAGE-TOTAL BY 2                            
                GIVING WS-TEMP-PAGES                                    
                REMAINDER WS-TEMP-PAGES1                                
              END-DIVIDE                                                
                                                                        
              IF WS-TEMP-PAGES1 = 1                                     
                 ADD 1                             TO                   
                                                   WS-TOTAL-MULTI-PAGES 
              END-IF                                                    
                                                                        
              PERFORM 2200-PROCESS-INSERT-MARKS    THRU 2200-EXIT       
              SET THIS-IS-MULTIPLE                 TO TRUE              
           ELSE                                                         
              IF NOT THIS-IS-MULTIPLE                                   
                 ADD +1                            TO WS-MULTIPLE-ID-CT 
              END-IF                                                    
           END-IF.                                                      
           MOVE EXT-SORTIDX-FILE                   TO                   
                                              WS-HOLD-SRT-IDX-DATA.     
           PERFORM 7000-READ-FCSCA911              THRU 7000-EXIT.      
                                                                        
           IF END-OF-CA911 AND THIS-IS-MULTIPLE                         
              SET LAST-MULTIPLE                    TO TRUE              
           END-IF.                                                      
                                                                        
           INITIALIZE                        WS-TEMP-SRT-IDX-DATA       
                                             WS-MULTIPLE-DATA.          
           MOVE EXT-SORTIDX-FILE                   TO                   
                                             WS-TEMP-SRT-IDX-DATA.      
                                                                        
           IF NOT END-OF-CA911                                          
              MOVE EXT-ACCT-ADDR-DETAILS           TO WS-ADDR-DATA      
              MOVE WS-CURRENT-DATA                 TO WS-TMP-ADDR-DATA  
A02003        MOVE SPACES                          TO WS-CURRENT-DATA   
A02003        MOVE EXT-ACCT-ZIPCODE                TO WS-CURR-ZIP       
              PERFORM 2050-PROCESS-ADDRESS-FIELDS  THRU 2050-EXIT       
              MOVE WS-CURRENT-DATA                 TO WS-MULTIPLE-DATA  
              MOVE WS-TMP-ADDR-DATA                TO WS-CURRENT-DATA   
              MOVE WS-HOLD-SRT-IDX-DATA            TO EXT-SORTIDX-FILE  
           END-IF.                                                      
                                                                        
A04203     INITIALIZE WS-TOTAL-MULTI-SHEETS                             
A04203                WS-MULTIPLE-BREAK.                                
A04203     COMPUTE WS-TOTAL-MULTI-SHEETS ROUNDED =                      
A04203                                          WS-TOTAL-MULTI-PAGES / 2
A04203****WHEN SERVICE CARE AND TOTAL SHEETS > 4 START AS NEW MULTIPLE          
A04444****OR MASTER ACCOUNT START AS NEW MULTIPLE                               
A04444     IF (EXT-ACCT-LOCAL-OFFICE = ('301' OR '302' OR '303')        
A04444         AND WS-TOTAL-MULTI-SHEETS >= 4) OR                       
A04444         EXT-ACCT-MASTER-SUB-FLAG = 'M'                           
A04203           INITIALIZE WS-MULTIPLE-DATA                            
A04203           SET MULTIPLE-BREAK TO TRUE                             
A04203     END-IF.                                                      
                                                                        
           IF WS-MULTI-NAME = WS-CURR-NAME   AND                        
              WS-MULTI-ADDR = WS-CURR-ADDR   AND                        
              WS-MULTI-OFLO = WS-CURR-OFLO   AND                        
              WS-MULTI-CITY = WS-CURR-CITY   AND                        
              WS-MULTI-ZIP (1:5) = WS-CURR-ZIP (1:5)                    
              IF FIRST-TIME OR NOT THIS-IS-MULTIPLE                     
                 SET THIS-IS-MULTIPLE              TO TRUE              
                 ADD EXT-SRT-PAGE-TOTAL            TO                   
                                             WS-TOTAL-MULTI-PAGES       
                 DIVIDE EXT-SRT-PAGE-TOTAL BY 2                         
                   GIVING WS-TEMP-PAGES                                 
                   REMAINDER WS-TEMP-PAGES1                             
                 END-DIVIDE                                             
                                                                        
                 IF WS-TEMP-PAGES1 = 1                                  
                   ADD 1                           TO                   
                                                   WS-TOTAL-MULTI-PAGES 
                 END-IF                                                 
                                                                        
                 PERFORM 2200-PROCESS-INSERT-MARKS THRU 2200-EXIT       
                 MOVE SPACES                       TO WS-FIRST-TIME-SW  
              END-IF                                                    
           ELSE                                                         
              IF THIS-IS-MULTIPLE                                       
                 MOVE SPACES                       TO                   
                                             WS-MULTI-CUSTOMER          
                 SET LAST-MULTIPLE                 TO TRUE              
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-MULTIPLE-ID-CT                  TO                   
                                             EXT-SRT-MULTIPLE-ID.       
           PERFORM 2100-PROCESS-OUTPUT-FILES       THRU 2100-EXIT.      
                                                                        
           MOVE WS-TEMP-SRT-IDX-DATA               TO                   
                                             EXT-SORTIDX-FILE.          
           MOVE SPACES                             TO WS-PREV-DATA.     
A04203     IF NOT MULTIPLE-BREAK                                        
A04203        MOVE WS-CURRENT-DATA                 TO WS-PREV-DATA      
A04203     END-IF.                                                      
           INITIALIZE                        WS-ADDR-DATA               
                                             WS-FIRST-TIME-SW           
                                             WS-CURRENT-DATA.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE WRITES OUT GROUP 1, MULTIPLES, DUPLICATES &     *         
      *  MULTIPLE DUPLICATES TO THE OUTPUT FILE.                      *         
      *****************************************************************         
                                                                        
       2050-PROCESS-ADDRESS-FIELDS.                                     
                                                                        
           MOVE 1                                   TO SUB1.            
                                                                        
           PERFORM UNTIL SUB1 > 6                                       
               IF WS-ADDR-TYPE (SUB1) = 'CN' OR 'AN'                    
                   MOVE WS-ADDR-LINE (SUB1)         TO WS-CURR-NAME     
               END-IF                                                   
               IF WS-ADDR-TYPE (SUB1) = 'AS'                            
                   MOVE WS-ADDR-LINE (SUB1)         TO WS-CURR-ADDR     
               END-IF                                                   
               IF WS-ADDR-TYPE (SUB1) = 'AO'                            
                   MOVE WS-ADDR-LINE (SUB1)         TO WS-CURR-OFLO     
               END-IF                                                   
               IF WS-ADDR-TYPE (SUB1) = 'AZ'                            
                   MOVE WS-ADDR-LINE (SUB1)         TO WS-CURR-CITY     
               END-IF                                                   
               ADD 1                                TO SUB1             
           END-PERFORM.                                                 
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE WRITES OUT GROUP 1, MULTIPLES, DUPLICATES &     *         
      *  MULTIPLE DUPLICATES TO THE OUTPUT FILE.                      *         
      *****************************************************************         
                                                                        
       2100-PROCESS-OUTPUT-FILES.                                       
                                                                        
           MOVE 1                                     TO SUB1.          
           IF LAST-MULTIPLE                                             
              PERFORM 2300-PROCESS-LAST-MULTIPLE      THRU 2300-EXIT    
           END-IF.                                                      
           IF EXT-BILL-NO-BILL-COPIES > 1                               
              IF NOT THIS-IS-MULTIPLE OR                                
                 NOT LAST-MULTIPLE                                      
                 ADD EXT-SRT-PAGE-TOTAL               TO                
                                               WS-TOTAL-MULTI-PAGES     
                 DIVIDE EXT-SRT-PAGE-TOTAL BY 2                         
                   GIVING WS-TEMP-PAGES                                 
                   REMAINDER WS-TEMP-PAGES1                             
                 END-DIVIDE                                             
                                                                        
                 IF WS-TEMP-PAGES1 = 1                                  
                    ADD 1                             TO                
                                                   WS-TOTAL-MULTI-PAGES 
                 END-IF                                                 
                                                                        
              END-IF                                                    
              IF LAST-MULTIPLE                                          
                 MOVE SPACES                          TO                
                                               EXT-SRT-GROUP-ID         
              END-IF                                                    
              PERFORM 2200-PROCESS-INSERT-MARKS       THRU 2200-EXIT    
              PERFORM UNTIL SUB1 > EXT-BILL-NO-BILL-COPIES              
                 MOVE 'D'                             TO                
                                                   EXT-SRT-DUPLICATE-FL 
                                                                        
                 IF SUB1 = EXT-BILL-NO-BILL-COPIES                      
                    MOVE SPACES                       TO                
                                                   EXT-SRT-DUPLICATE-FL 
PRJ166              MOVE WS-EXT-BILL-BARCODE-UNIQUE-ID TO               
PRJ166                                      EXT-BILL-BARCODE-UNIQUE-ID  
PRJ166              MOVE WS-EXT-BILL-TRACKING-STATUS-CD TO              
PRJ166                                     EXT-BILL-TRACKING-STATUS-CD  
                    MOVE WS-MULTIPLES-INSERT-MARK (1) TO                
                                               WS-HOLD-INSERT-MARKS(3)  
                    MOVE WS-MULTIPLES-INSERT-MARK (2) TO                
                                               WS-HOLD-INSERT-MARKS(4)  
                    MOVE WS-MULTIPLES-INSERT-MARK (3) TO                
                                               WS-HOLD-INSERT-MARKS(5)  
                    MOVE WS-MULTIPLES-INSERT-MARK (4) TO                
                                               WS-HOLD-INSERT-MARKS(6)  
                    MOVE WS-MULTIPLES-INSERT-MARK (5) TO                
                                               WS-HOLD-INSERT-MARKS(7)  
                    IF NOT THIS-IS-MULTIPLE                             
                       MOVE '0'                       TO                
                                               WS-HOLD-INSERT-MARKS(2)  
                    END-IF                                              
                    MOVE WS-TOTAL-MULTI-PAGES         TO                
                                             EXT-SRT-TOTAL-G5-BILLS     
                    MOVE ZEROS                        TO                
                                             WS-TOTAL-MULTI-SHEETS      
                    COMPUTE WS-TOTAL-MULTI-SHEETS ROUNDED =             
                                             WS-TOTAL-MULTI-PAGES / 2   
                    IF WS-TOTAL-MULTI-SHEETS < 5                        
                       MOVE 'G4'                      TO                
                                               EXT-SRT-GROUP-ID         
                    ELSE                                                
                       MOVE 'G5'                      TO                
                                               EXT-SRT-GROUP-ID         
                    END-IF                                              
                 ELSE                                                   
                   ADD EXT-SRT-PAGE-TOTAL             TO                
                                               WS-TOTAL-MULTI-PAGES     
                   DIVIDE EXT-SRT-PAGE-TOTAL BY 2                       
                     GIVING WS-TEMP-PAGES                               
                     REMAINDER WS-TEMP-PAGES1                           
                   END-DIVIDE                                           
                                                                        
                   IF WS-TEMP-PAGES1 = 1                                
                     ADD 1                            TO                
                                                   WS-TOTAL-MULTI-PAGES 
                   END-IF                                               
PRJ166             PERFORM 2350-GET-UNIQ-IDENTIFIER   THRU 2350-EXIT    
                 END-IF                                                 
                 MOVE WS-HOLD-MARKS                   TO                
                                               EXT-ACCT-OMR-MARKS       
                 PERFORM 8000-WRITE-SORT-IDX          THRU 8000-EXIT    
                                                                        
                 ADD 1                              TO SUB1             
              END-PERFORM                                               
           ELSE                                                         
              MOVE WS-TOTAL-MULTI-PAGES             TO                  
                                               EXT-SRT-TOTAL-G5-BILLS   
A04444        IF EXT-ACCT-MASTER-SUB-FLAG = 'M'                         
A04444           MOVE 'G5'                          TO EXT-SRT-GROUP-ID 
A04444           MOVE EXT-SRT-PAGE-TOTAL            TO                  
A00444                                          EXT-SRT-TOTAL-G5-BILLS  
A04444        END-IF                                                    
              PERFORM 8000-WRITE-SORT-IDX           THRU 8000-EXIT      
           END-IF.                                                      
           IF THIS-IS-MULTIPLE OR LAST-MULTIPLE                         
              PERFORM 2210-MULTIPLE-BILL-DETAIL     THRU 2210-EXIT      
           ELSE                                                         
              MOVE ZEROS                            TO                  
                                               WS-TOTAL-MULTI-PAGES     
           END-IF.                                                      
           IF LAST-MULTIPLE                                             
              MOVE SPACES                           TO                  
                                               WS-LAST-MULTI-CUSTOMER   
              MOVE ZEROS                            TO                  
                                               WS-TOTAL-MULTI-PAGES     
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE STORES THE INSERT MARKS FOR MULTIPLES.          *         
      *****************************************************************         
                                                                        
       2200-PROCESS-INSERT-MARKS.                                       
                                                                        
           IF WS-HOLD-INSERT-MARKS(3) = '1'                             
              MOVE '1' TO WS-MULTIPLES-INSERT-MARK (1)                  
           END-IF                                                       
           IF WS-HOLD-INSERT-MARKS(4) = '1'                             
              MOVE '1' TO WS-MULTIPLES-INSERT-MARK (2)                  
           END-IF                                                       
           IF WS-HOLD-INSERT-MARKS(5) = '1'                             
              MOVE '1' TO WS-MULTIPLES-INSERT-MARK (3)                  
           END-IF                                                       
           IF WS-HOLD-INSERT-MARKS(6) = '1'                             
              MOVE '1' TO WS-MULTIPLES-INSERT-MARK (4)                  
           END-IF                                                       
           IF WS-HOLD-INSERT-MARKS(7) = '1'                             
              MOVE '1' TO WS-MULTIPLES-INSERT-MARK (5)                  
           END-IF.                                                      
           MOVE ZEROS                              TO WS-HOLD-MARKS.    
           MOVE '1'                                TO                   
                                             WS-HOLD-INSERT-MARKS(1)    
                                             WS-HOLD-INSERT-MARKS(2).   
           MOVE WS-HOLD-MARKS                      TO                   
                                             EXT-ACCT-OMR-MARKS.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE PROCESSES THE INSERT MARKS FOR THE LAST MULTIPLE*         
      *****************************************************************         
                                                                        
       2300-PROCESS-LAST-MULTIPLE.                                      
                                                                        
           MOVE WS-MULTIPLES-INSERT-MARK (1)       TO                   
                                             WS-HOLD-INSERT-MARKS(3)    
           MOVE WS-MULTIPLES-INSERT-MARK (2)       TO                   
                                             WS-HOLD-INSERT-MARKS(4)    
           MOVE WS-MULTIPLES-INSERT-MARK (3)       TO                   
                                             WS-HOLD-INSERT-MARKS(5)    
           MOVE WS-MULTIPLES-INSERT-MARK (4)       TO                   
                                             WS-HOLD-INSERT-MARKS(6)    
           MOVE WS-MULTIPLES-INSERT-MARK (5)       TO                   
                                             WS-HOLD-INSERT-MARKS(7)    
           MOVE '0'                                TO                   
                                             WS-HOLD-INSERT-MARKS(2)    
           MOVE ZEROS                              TO WS-MULTIPLE-MARKS 
           IF WS-TOTAL-MULTI-SHEETS < 5                                 
              MOVE 'G4'                            TO EXT-SRT-GROUP-ID  
           ELSE                                                         
              MOVE 'G5'                            TO EXT-SRT-GROUP-ID  
           END-IF                                                       
           MOVE WS-TOTAL-MULTI-PAGES               TO                   
                                             EXT-SRT-TOTAL-G5-BILLS     
           MOVE WS-HOLD-MARKS                      TO                   
                                             EXT-ACCT-OMR-MARKS.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE PRINTS DETAIL LINES ON THE MULTIPLE BILL DETAIL *         
      *  REPORT.                                                      *         
      *****************************************************************         
                                                                        
       2210-MULTIPLE-BILL-DETAIL.                                       
                                                                        
           IF (WS-LINE-COUNT-02 > 52)                                   
               PERFORM 2230-MULTIPLE-BILL-HEADERS THRU 2230-EXIT
           END-IF.       
           MOVE WS-CURR-ACCT     TO P-ACCOUNT-NO.                       
           MOVE WS-CURR-NAME TO P-AREA1.                                
           MOVE WS-HOLD-SERV-ADDR TO P-AREA2.                           
           MOVE WS-CURR-ADDR    TO P-AREA3.                             
           WRITE PR232-RECORD FROM P-DETAIL-LINE-1 AFTER 3.             
           MOVE ZEROES TO P-ACCOUNT-NO.                                 
           MOVE SPACES TO P-AREA1.                                      
           MOVE WS-HOLD-SERV-OFLO    TO P-AREA2.                        
           MOVE WS-CURR-OFLO         TO P-AREA3.                        
           WRITE PR232-RECORD FROM P-DETAIL-LINE-1 AFTER 1.             
           MOVE EXT-BILL-CUSTOMER-NO TO P-AREA1.                        
           MOVE WS-HOLD-SERV-CITY         TO P-AREA2.                   
           MOVE WS-CURR-CITY           TO P-AREA3.                      
           WRITE PR232-RECORD FROM P-DETAIL-LINE-1 AFTER 1.             
           WRITE PR232-RECORD FROM WS-BLANK-LINE   AFTER 1.             
           ADD 5 TO WS-LINE-COUNT-02.                                   
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE PRINTS HEADING LINES ON THE MULTIPLE BILL       *         
      *  DETAIL REPORT.                                               *         
      *****************************************************************         
                                                                        
       2230-MULTIPLE-BILL-HEADERS.                                      
                                                                        
           ADD 1 TO WS-PAGE-COUNT-02.                                   
           MOVE WS-PAGE-COUNT-02 TO P-PAGE-NO.                          
           MOVE WS-PGRMNAME2 TO P-RPT1-NAME.                            
           MOVE WS-RPT2-HEAD TO P-RPT1-TITLE.                           
           WRITE PR232-RECORD FROM P-HEADER-LINE-1 AFTER PAGE.          
           WRITE PR232-RECORD FROM P-HEADER-LINE-2 AFTER 1.             
           WRITE PR232-RECORD FROM P-HEADER-LINE-2A AFTER 1.            
           WRITE PR232-RECORD FROM P-HEADER-LINE-3 AFTER 3.             
           MOVE 6 TO WS-LINE-COUNT-02.                                  
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ166*S**********************************************************              
      * CALLS PROGRAM SCSCA165 TO GET MARKETING CORRESPONDENCE   *              
      * UNIQUE IDENTIFIER                                        *              
      ************************************************************              
       2350-GET-UNIQ-IDENTIFIER.                                        
                                                                        
           MOVE 'BLLPRT'                 TO  WS-CA165IN-CORR-TYPE.      
           MOVE EXT-ACCT-ACCOUNT-NO      TO  WS-CA165IN-ACCOUNT-NO.     
           MOVE EXT-BILL-CUSTOMER-NO     TO  WS-CA165IN-CUSTOMER-NO.    
           MOVE EXT-ACCT-BILL-DATE       TO  WS-CA165IN-PROCESS-DATE.   
           MOVE WS-DATABASE              TO  WS-CA165IN-DATABASE.       
           MOVE EXT-SRT-COMPANY-NO       TO  WS-CA165IN-COMPANY-NO.     
           MOVE EXT-ACCT-LOCAL-OFFICE    TO  WS-CA165IN-LOCAL-OFFICE.   
           MOVE EXT-ACCT-REGULATED-CD    TO  WS-CA165IN-REG-GROUP-CD.   
           MOVE  'N'                    TO  WS-CA165IN-END-OF-PROG-FL   
                                            WS-CA165IN-UPDATE-SEQ-FL.   
           MOVE  'A'                    TO  WS-CA165IN-TP-MEMO-PROCESS. 
           MOVE  PROGRAM-NAME           TO  WS-CA165IN-APPL-PROGRAM-ID. 
                                                                        
           PERFORM 2400-CALL-SCSCA165   THRU 2400-EXIT.                 
           MOVE WS-CA165OUT-UNIQ-ID     TO EXT-BILL-BARCODE-UNIQUE-ID.  
           MOVE WS-CA165OUT-CUR-STATUS  TO EXT-BILL-TRACKING-STATUS-CD. 
           MOVE 'Y' TO WS-SCSCA165-CALL.                                
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      16440000
      *  CALL SCSCA165 TO GET UNIQUE IDENTIFIER                  *      16441000
      ************************************************************      16442000
       2400-CALL-SCSCA165.                                              
                                                                        
           DISPLAY 'CALL SCSCA165 FROM PCSCA911'.                       
           CALL  'SCSCA165'            USING WS-SCSCA165-PARMS,         
                                                WS-CA165-MISC,          
                                                ABEND-FILE,             
                                                WS-SCSCA-RETURN-CODE    
                                                                        
           MOVE 'SCSCA165'                   TO WS-DISPLAY-SCSCA.       
                                                                        
           IF WS-SCSCA-RETURN-CODE        NOT = 0                       
              PERFORM 9200-SCSCA-ERROR   THRU   9200-EXIT               
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
PRJ166*E                                                                        
                                                                        
      ************************************************************              
      *  READ THE INPUT FILE                                     *              
      ************************************************************              
                                                                        
       7000-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL OR END-OF-CA911                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA911 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ166*S***************************************************************         
      ** SELECT  CSS_DELINQUENCY TO GET DATABASE                                
      *****************************************************************         
       7100-GET-DELINQUECY.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0"
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA911 ABORT **************'       
               DISPLAY '* 7100-GET-DELINQUENCY                 *'       
               DISPLAY '* DELINQ CD ', C8-DELINQ-CD                     
               DISPLAY '* COMPANY NO', C8-COMPANY-NO                    
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA911 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
PRJ166*E                                                                        
                                                                        
      ************************************************************      17189000
      *  CALL AFAPLINT TO WRITE THE BE28 OUTPUT FILE.            *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           MOVE SPACES                     TO E-SRT-IDX-REC.            
           MOVE EXT-SORTIDX-FILE           TO E-SRT-IDX-REC.            
           WRITE E-SRT-IDX-REC.                                         
                                                                        
           IF CA912-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '      
                        WS-CA912-STATUS                                 
               PERFORM 9000-TERMINATE      THRU 9000-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA911-FILE                                          
                 FCSCA912-FILE FCSP232-FILE.                            
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
PRJ166*S                                                                        
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' EXT-ACCT-ACCOUNT-NO.            
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
PRJ166*E                                                                        
