       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA909.                                          
       AUTHOR.       SIVARAJAN .                                        
       DATE-WRITTEN. MAR 2013.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** THIS IS PROGRAM EXTRACT DATA FROM REV_BILLING_DET AND LOAD   **        
      ** THE DATA IN REV_CLASS_RATE_TMP.                              **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 3999     OUTPUT PROCESS CONTROL PATH           **        
      **        4000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
P00641** 03/23/13 SV95326  INITIAL IMPLEMENTATION.                    **        
A04527** 06/06/13 AS7C117  REMOVE UNUSED COPYBOOK CWS00056            **        
ACT084** 06/24/13 VIJAY    REMOVE UNUSED COPYBOOK CWSCB108            **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA909'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40) VALUE                
                        'WORKING STORAGE FOR PCSCA909 STARTS HERE'.     
       01 WS-MISC.                                                      
          05 WS-END-OF-DATA          PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-REVENUE-MONTH-NUM    PIC 9(06) VALUE 0.                 
                                                                        
          05 WS-REVENUE-MONTH-COMP3  PIC S9(06)   COMP-3 VALUE +0.      
      *                                                                         
       01  WS-REVENUE-MONTH.                                            
           05  WS-REVN-YEAR             PIC 9(04).                      
           05  WS-REVN-MONTH            PIC 9(02).                      
      *                                                                         
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                PIC X(08) VALUE 'PCSCA909'.    
          05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA909'.    
          05 WS-N                        PIC X(01) VALUE 'N'.           
          05 WS-Y                        PIC X(01) VALUE 'Y'.           
      *                                                                         
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
                                                                        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *        
      ******************************************************************        
       COPY FIOCA00.                                                            
      *****************************************************************         
      * WORKING STORAGE TO READ THE JOB PARM TABLE FOR REPORT DATE    *         
      *****************************************************************         
                                                                        
       COPY CWS00038.                                                           
                                                                        
       COPY CWS00114.                                                           
      ******************************************************************        
      *  CWS00039 JOB PARM ROUTINE                                     *        
      ******************************************************************        
                                                                        
       COPY CWS00039.                                                           
                                                                        
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
                                                                        
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00050.                                                           
       COPY CWS09900.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA909 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************00540000
      *    REV_BILLING_DET   - RV                                       00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVBLD                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_BILL_COMP_ADJ - RB                                      *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVCOM                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_BILL_TAX      - R9                                      *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVTAX                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_CLASS_RATE_TMP - V4                                     *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVSUM                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    CSS_JOB_PARM       - G6                                     *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
                                                                        
                                                                        
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR FOR GETTING THE STA DETAILS                            *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE REV_CORR_CUR CURSOR FOR                           
               SELECT RV.REVENUE_MONTH                                  
                     ,RV.REV_COMPANY_NO                                 
                     ,RV.CODE_SERVICE_TYPE                              
                     ,RV.CODE_REV_ACCT_TYPE                             
                     ,RV.CODE_REVENUE_CLASS                             
                     ,RV.RATE_PLAN_NO                                   
                     ,SUM(RV.CUST_CT) AS METER_CT                       
                     ,SUM(CASE WHEN RD.REV_CUST_COUNT_CD = 'P'          
                      THEN 0 ELSE RV.CUST_CT END) AS METER_LIGHT_CT     
                     ,SUM(RV.CUST_CT -                                  
                      (CASE WHEN RD.REV_CUST_COUNT_CD = 'P'             
                      THEN 0 ELSE RV.CUST_CT END))                      
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99') THEN     
                      RV.CUST_CT ELSE 0 END)                            
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99') THEN     
                      RV.CUST_CT ELSE 0 END)                            
                     ,SUM(RB.BILLED_AMT) AS BILLED_AMT                  
                     ,SUM(CASE WHEN RV.CODE_SERVICE_TYPE = 'E'          
                      THEN RB.BILL_USAGE_UNITS                          
                      ELSE RB.READ_UNITS END) AS CONSUMPTION_UNITS      
                     ,SUM(RB.BILL_USAGE_UNITS)                          
                     ,SUM(RB.READ_UNITS)                                
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99')          
                      THEN RB.BILL_USAGE_UNITS ELSE 0 END)              
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99')          
                      THEN RB.READ_UNITS ELSE 0 END)                    
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99')          
                      THEN RB.BILL_USAGE_UNITS ELSE 0 END)              
                     ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99')          
                      THEN RB.READ_UNITS ELSE 0 END)                    
                     ,SUM(COALESCE(R9.STATE_SALES_TAX_AMT, 0))          
                     ,SUM(COALESCE(R9.FRANCHISE_TAX_AMT, 0))            
                     ,SUM(COALESCE(R9.OTHER_TAX_AMT, 0))                
                 FROM REV_BILLING_DET RV WITH(READUNCOMMITTED)                  
                 LEFT OUTER JOIN                                        
                     (SELECT RB1.BILL_UNIQUE_TS                         
                     ,SUM(CASE WHEN RB1.CONSUMPT_TYPE_CD IN ('B', 'C')  
                      THEN RB1.BILL_USAGE_UNITS                         
                      WHEN RB1.CONSUMPT_TYPE_CD = 'D'                   
                      THEN (RB1.BILL_USAGE_UNITS * 10)                  
                      ELSE 0 END) AS BILL_USAGE_UNITS                   
                     ,SUM(CASE WHEN RB1.CONSUMPT_TYPE_CD IN ('B', 'C')  
                      THEN RB1.READ_UNITS                               
                      WHEN RB1.CONSUMPT_TYPE_CD = 'D'                   
                      THEN (RB1.READ_UNITS * 10)                        
                      ELSE 0 END) AS READ_UNITS                         
                     ,SUM(RB1.BILLED_AMT) AS BILLED_AMT                 
                 FROM REV_BILL_COMP_ADJ RB1 WITH(READUNCOMMITTED)               
                 JOIN REV_BILLING_DET RV1 WITH(READUNCOMMITTED)                 
                 ON RV1.BILL_UNIQUE_TS = RB1.BILL_UNIQUE_TS             
                 WHERE RB1.UTILITY_REV_CD = 'U'                         
                 AND RV1.REVENUE_MONTH = :RV-REVENUE-MONTH              
                 GROUP BY RB1.BILL_UNIQUE_TS        ) AS RB             
                 ON RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS               
                 LEFT OUTER JOIN                                        
                    (SELECT R91.BILL_UNIQUE_TS                          
                   ,SUM(CASE WHEN R91.TAX_TYPE = 'A'                    
                    THEN R91.TAX_AMT ELSE 0 END) AS STATE_SALES_TAX_AMT 
                   ,SUM(CASE WHEN R91.TAX_TYPE = 'B'                    
                    THEN R91.TAX_AMT ELSE 0 END) AS FRANCHISE_TAX_AMT   
                   ,SUM(CASE WHEN R91.TAX_TYPE = 'C'                    
                    THEN R91.TAX_AMT ELSE 0 END) AS OTHER_TAX_AMT       
                 FROM REV_BILL_TAX R91 WITH(READUNCOMMITTED)                    
                 JOIN REV_BILLING_DET RV2 WITH(READUNCOMMITTED)                 
                 ON (RV2.BILL_UNIQUE_TS = R91.BILL_UNIQUE_TS            
                     AND R91.TAX_TYPE IN ('A', 'B', 'C'))               
                 WHERE                                                  
                     RV2.REVENUE_MONTH = :RV-REVENUE-MONTH              
                 GROUP BY                                               
                 R91.BILL_UNIQUE_TS  ) R9                               
                 ON RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS               
                 LEFT OUTER JOIN CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                  
                 ON RV.RATE_PLAN_NO = RD.RATE_PLAN_NO                   
                 AND RV.COMPANY_NO = RD.COMPANY_NO                      
                 AND RV.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
                 WHERE RV.REVENUE_MONTH = :RV-REVENUE-MONTH             
                 AND RV.RATE_PLAN_NO <> '000'                           
                 AND RV.CALC_SOURCE_CD <> 'R'                           
                 GROUP BY RV.REVENUE_MONTH                              
                         ,RV.REV_COMPANY_NO                             
                         ,RV.CODE_REV_ACCT_TYPE                         
                         ,RV.CODE_REVENUE_CLASS                         
                         ,RV.RATE_PLAN_NO                               
                         ,RV.CODE_SERVICE_TYPE                          
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REV_CORR_CUR CURSOR FOR                                   
MFA-TR*        SELECT RV.REVENUE_MONTH                                          
MFA-TR*              ,RV.REV_COMPANY_NO                                         
MFA-TR*              ,RV.CODE_SERVICE_TYPE                                      
MFA-TR*              ,RV.CODE_REV_ACCT_TYPE                                     
MFA-TR*              ,RV.CODE_REVENUE_CLASS                                     
MFA-TR*              ,RV.RATE_PLAN_NO                                           
MFA-TR*              ,SUM(RV.CUST_CT) AS METER_CT                               
MFA-TR*              ,SUM(CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                  
MFA-TR*               THEN 0 ELSE RV.CUST_CT END) AS METER_LIGHT_CT             
MFA-TR*              ,SUM(RV.CUST_CT -                                          
MFA-TR*               (CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                     
MFA-TR*               THEN 0 ELSE RV.CUST_CT END))                              
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99') THEN             
MFA-TR*               RV.CUST_CT ELSE 0 END)                                    
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99') THEN             
MFA-TR*               RV.CUST_CT ELSE 0 END)                                    
MFA-TR*              ,SUM(RB.BILLED_AMT) AS BILLED_AMT                          
MFA-TR*              ,SUM(CASE WHEN RV.CODE_SERVICE_TYPE = 'E'                  
MFA-TR*               THEN RB.BILL_USAGE_UNITS                                  
MFA-TR*               ELSE RB.READ_UNITS END) AS CONSUMPTION_UNITS              
MFA-TR*              ,SUM(RB.BILL_USAGE_UNITS)                                  
MFA-TR*              ,SUM(RB.READ_UNITS)                                        
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99')                  
MFA-TR*               THEN RB.BILL_USAGE_UNITS ELSE 0 END)                      
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('E99')                  
MFA-TR*               THEN RB.READ_UNITS ELSE 0 END)                            
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99')                  
MFA-TR*               THEN RB.BILL_USAGE_UNITS ELSE 0 END)                      
MFA-TR*              ,SUM(CASE WHEN RV.RATE_DEPT_CD IN ('G99')                  
MFA-TR*               THEN RB.READ_UNITS ELSE 0 END)                            
MFA-TR*              ,SUM(COALESCE(R9.STATE_SALES_TAX_AMT, 0))                  
MFA-TR*              ,SUM(COALESCE(R9.FRANCHISE_TAX_AMT, 0))                    
MFA-TR*              ,SUM(COALESCE(R9.OTHER_TAX_AMT, 0))                        
MFA-TR*          FROM REV_BILLING_DET RV                                        
MFA-TR*          LEFT OUTER JOIN                                                
MFA-TR*              (SELECT RB1.BILL_UNIQUE_TS                                 
MFA-TR*              ,SUM(CASE WHEN RB1.CONSUMPT_TYPE_CD IN ('B', 'C')          
MFA-TR*               THEN RB1.BILL_USAGE_UNITS                                 
MFA-TR*               WHEN RB1.CONSUMPT_TYPE_CD = 'D'                           
MFA-TR*               THEN (RB1.BILL_USAGE_UNITS * 10)                          
MFA-TR*               ELSE 0 END) AS BILL_USAGE_UNITS                           
MFA-TR*              ,SUM(CASE WHEN RB1.CONSUMPT_TYPE_CD IN ('B', 'C')          
MFA-TR*               THEN RB1.READ_UNITS                                       
MFA-TR*               WHEN RB1.CONSUMPT_TYPE_CD = 'D'                           
MFA-TR*               THEN (RB1.READ_UNITS * 10)                                
MFA-TR*               ELSE 0 END) AS READ_UNITS                                 
MFA-TR*              ,SUM(RB1.BILLED_AMT) AS BILLED_AMT                         
MFA-TR*          FROM REV_BILL_COMP_ADJ RB1                                     
MFA-TR*          JOIN REV_BILLING_DET RV1                                       
MFA-TR*          ON RV1.BILL_UNIQUE_TS = RB1.BILL_UNIQUE_TS                     
MFA-TR*          WHERE RB1.UTILITY_REV_CD = 'U'                                 
MFA-TR*          AND RV1.REVENUE_MONTH = :RV-REVENUE-MONTH                      
MFA-TR*          GROUP BY RB1.BILL_UNIQUE_TS        ) AS RB                     
MFA-TR*          ON RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS                       
MFA-TR*          LEFT OUTER JOIN                                                
MFA-TR*             (SELECT R91.BILL_UNIQUE_TS                                  
MFA-TR*            ,SUM(CASE WHEN R91.TAX_TYPE = 'A'                            
MFA-TR*             THEN R91.TAX_AMT ELSE 0 END) AS STATE_SALES_TAX_AMT         
MFA-TR*            ,SUM(CASE WHEN R91.TAX_TYPE = 'B'                            
MFA-TR*             THEN R91.TAX_AMT ELSE 0 END) AS FRANCHISE_TAX_AMT           
MFA-TR*            ,SUM(CASE WHEN R91.TAX_TYPE = 'C'                            
MFA-TR*             THEN R91.TAX_AMT ELSE 0 END) AS OTHER_TAX_AMT               
MFA-TR*          FROM REV_BILL_TAX R91                                          
MFA-TR*          JOIN REV_BILLING_DET RV2                                       
MFA-TR*          ON (RV2.BILL_UNIQUE_TS = R91.BILL_UNIQUE_TS                    
MFA-TR*              AND R91.TAX_TYPE IN ('A', 'B', 'C'))                       
MFA-TR*          WHERE                                                          
MFA-TR*              RV2.REVENUE_MONTH = :RV-REVENUE-MONTH                      
MFA-TR*          GROUP BY                                                       
MFA-TR*          R91.BILL_UNIQUE_TS  ) R9                                       
MFA-TR*          ON RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS                       
MFA-TR*          LEFT OUTER JOIN CSS_RATE_PLAN_DESC RD                          
MFA-TR*          ON RV.RATE_PLAN_NO = RD.RATE_PLAN_NO                           
MFA-TR*          AND RV.COMPANY_NO = RD.COMPANY_NO                              
MFA-TR*          AND RV.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                      
MFA-TR*          WHERE RV.REVENUE_MONTH = :RV-REVENUE-MONTH                     
MFA-TR*          AND RV.RATE_PLAN_NO <> '000'                                   
MFA-TR*          AND RV.CALC_SOURCE_CD <> 'R'                                   
MFA-TR*          GROUP BY RV.REVENUE_MONTH                                      
MFA-TR*                  ,RV.REV_COMPANY_NO                                     
MFA-TR*                  ,RV.CODE_REV_ACCT_TYPE                                 
MFA-TR*                  ,RV.CODE_REVENUE_CLASS                                 
MFA-TR*                  ,RV.RATE_PLAN_NO                                       
MFA-TR*                  ,RV.CODE_SERVICE_TYPE                                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  2000-PROCESS-OUTPUT         THRU  2000-EXIT.        
           PERFORM  9000-TERMINATE              THRU 9000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 0120-PROCESS-DATE            THRU 0120-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OBTAINS BOTH THE SYSTEM DATE AND THE ACCOUNTING PERIOD. IF   *          
      * THE ACCOUNTING PERIOD IS  NOT FOUND, THE ACCOUNTING PERIOD   *          
      * DEFAULTS TO THE PREVIOUS MONTH OF THE SYSTEM DATE.           *          
      *                                                              *          
      * CALLED BY:  0100-INITIALIZATION                              *          
      ****************************************************************          
      *                                                                         
       0120-PROCESS-DATE.                                               
      *                                                                         
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           MOVE SPACES                     TO WS-SYSIPT.                
      *                                                                         
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
      *                                                                         
           MOVE WS-PARM-MONTH   TO WS-REVN-MONTH.                       
           MOVE WS-PARM-YR      TO WS-REVN-YEAR.                        
           MOVE WS-REVENUE-MONTH             TO WS-REVENUE-MONTH-NUM.   
           MOVE WS-REVENUE-MONTH-NUM         TO WS-REVENUE-MONTH-COMP3. 
           MOVE WS-REVENUE-MONTH-COMP3       TO RV-REVENUE-MONTH.       
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *                                                                *03250000
      *      CALLED FROM 0000-MAINLINE                                 *03260000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO   ACTIVE-PARAGRAPH.     
           MOVE 'N'                          TO   WS-END-OF-DATA.       
           PERFORM 7100-OPEN-REV-CORR-CUR    THRU 7100-EXIT.            
           PERFORM 8200-DELETE-REV-CLASS-RATE-TMP THRU 8200-EXIT.       
           PERFORM 2100-PROCESS-DETAIL       THRU 2100-EXIT             
                                             UNTIL NO-MORE-DATA.        
           PERFORM 7120-CLOSE-REV-CORR-CUR   THRU 7120-EXIT.            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2100-PROCESS-DETAIL.                                        *           
      *                                                             *           
      * POPULATES VALUE AND INSERTS INTO TEMPRORARY TABLE TILL THE  *           
      * THE LAST RECORD.                                            *           
      ***************************************************************           
      *                                                                         
       2100-PROCESS-DETAIL.                                             
      *                                                                         
           PERFORM 7110-FETCH-REV-CORR-CUR   THRU 7110-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 8300-INSERT-REV-CLASS-RATE-TMP THRU 8300-EXIT    
           ELSE                                                         
               MOVE 'Y'                   TO WS-END-OF-DATA             
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  6200-GET-PARAMETER-DATE                                   **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * 7100-OPEN-REV-CORR-CUR.                                     *           
      *                                                             *           
      * OPEN REVENUE CORRECTION CURSOR.                             *           
      ***************************************************************           
      *                                                                         
       7100-OPEN-REV-CORR-CUR.                                          
           EXEC SQL                                                     
                OPEN REV_CORR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA909 ABORT **************'        
              DISPLAY '*** 7100-OPEN-REV-CORR-CUR           ***'        
              DISPLAY '* REVENUE MONTH  : ' RV-REVENUE-MONTH            
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSCA909 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7110-FETCH-REV-CORR-CUR.                                   *            
      *                                                             *           
      * FETCH DATA USING REVENUE CORRECTION CURSOR.                 *           
      ***************************************************************           
      *                                                                         
       7110-FETCH-REV-CORR-CUR.                                         
           EXEC SQL                                                     
               FETCH REV_CORR_CUR                                       
                INTO :V4-REVENUE-MONTH                                  
                    ,:V4-REV-COMPANY-NO                                 
                    ,:V4-CODE-SERVICE-TYPE                              
                    ,:V4-CODE-REV-ACCT-TYPE                             
                    ,:V4-CODE-REVENUE-CLASS                             
                    ,:V4-RATE-PLAN-NO                                   
                    ,:V4-CUST-CT                                        
                    ,:V4-CUST-LIGHT-CT                                  
                    ,:V4-CUST-LESS-LIGHT-CT                             
                    ,:V4-ELE-DH-CUST-CT                                 
                    ,:V4-GAS-DH-CUST-CT                                 
                    ,:V4-BILLED-AMT                                     
                    ,:V4-CONSUMPTION-UNITS                              
                    ,:V4-BILL-USAGE-UNITS                               
                    ,:V4-READ-UNITS                                     
                    ,:V4-ELE-DH-BILL-USAGE                              
                    ,:V4-ELE-DH-READ-UNITS                              
                    ,:V4-GAS-DH-BILL-USAGE                              
                    ,:V4-GAS-DH-READ-UNITS                              
                    ,:V4-STATE-SALES-TAX-AM                             
                    ,:V4-FRANCHISE-TAX-AM                               
                    ,:V4-OTHER-TAX-AM                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA909 ABORT **************'        
              DISPLAY '*** 7110-FETCH-REV-CORR-CUR          ***'        
              DISPLAY '* REVENUE MONTH  : ' RV-REVENUE-MONTH            
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSCA909 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7120-CLOSE-REV-CORR-CUR.                                    *           
      *                                                             *           
      * CLOSE REVENUE CORRECTION CURSOR.                            *           
      ***************************************************************           
      *                                                                         
       7120-CLOSE-REV-CORR-CUR.                                         
           EXEC SQL                                                     
              CLOSE REV_CORR_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA909 ABORT **************'        
              DISPLAY '*** 7120-CLOSE-REV-CORR-CUR          ***'        
              DISPLAY '* REVENUE MONTH  : ' RV-REVENUE-MONTH            
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSCA909 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      * START FCSJC01 FILE USING E-FJC01-KEY                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 8200-DELETE-REV-CLASS-RATE-TMP.                               *         
      *****************************************************************         
       8200-DELETE-REV-CLASS-RATE-TMP.                                  
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM REV_CLASS_RATE_TMP                           
                WHERE REVENUE_MONTH = :RV-REVENUE-MONTH                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA909 ABORT **************'        
              DISPLAY '*** 8200-DELETE-REV-CLASS-RATE-TMP   ***'        
              DISPLAY '* REVENUE MONTH  : ' RV-REVENUE-MONTH            
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSCA909 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8300-INSERT-REV-CLASS-RATE-TMP.                               *         
      *****************************************************************         
       8300-INSERT-REV-CLASS-RATE-TMP.                                  
                                                                        
                                                                        
            EXEC SQL                                                    
                INSERT INTO REV_CLASS_RATE_TMP                          
                          ( REVENUE_MONTH                               
                           ,REV_COMPANY_NO                              
                           ,CODE_SERVICE_TYPE                           
                           ,CODE_REV_ACCT_TYPE                          
                           ,CODE_REVENUE_CLASS                          
                           ,RATE_PLAN_NO                                
                           ,CUST_CT                                     
                           ,CUST_LIGHT_CT                               
                           ,CUST_LESS_LIGHT_CT                          
                           ,ELE_DH_CUST_CT                              
                           ,GAS_DH_CUST_CT                              
                           ,BILLED_AMT                                  
                           ,CONSUMPTION_UNITS                           
                           ,BILL_USAGE_UNITS                            
                           ,READ_UNITS                                  
                           ,ELE_DH_BILL_USAGE                           
                           ,ELE_DH_READ_UNITS                           
                           ,GAS_DH_BILL_USAGE                           
                           ,GAS_DH_READ_UNITS                           
                           ,STATE_SALES_TAX_AM                          
                           ,FRANCHISE_TAX_AM                            
                           ,OTHER_TAX_AM )                              
                VALUES                                                  
                           (:V4-REVENUE-MONTH                           
                           ,:V4-REV-COMPANY-NO                          
                           ,:V4-CODE-SERVICE-TYPE                       
                           ,:V4-CODE-REV-ACCT-TYPE                      
                           ,:V4-CODE-REVENUE-CLASS                      
                           ,:V4-RATE-PLAN-NO                            
                           ,:V4-CUST-CT                                 
                           ,:V4-CUST-LIGHT-CT                           
                           ,:V4-CUST-LESS-LIGHT-CT                      
                           ,:V4-ELE-DH-CUST-CT                          
                           ,:V4-GAS-DH-CUST-CT                          
                           ,:V4-BILLED-AMT                              
                           ,:V4-CONSUMPTION-UNITS                       
                           ,:V4-BILL-USAGE-UNITS                        
                           ,:V4-READ-UNITS                              
                           ,:V4-ELE-DH-BILL-USAGE                       
                           ,:V4-ELE-DH-READ-UNITS                       
                           ,:V4-GAS-DH-BILL-USAGE                       
                           ,:V4-GAS-DH-READ-UNITS                       
                           ,:V4-STATE-SALES-TAX-AM                      
                           ,:V4-FRANCHISE-TAX-AM                        
                           ,:V4-OTHER-TAX-AM)                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA909 ABORT **************'        
              DISPLAY '*** 8300-INSERT-REV-CLASS-RATE-TMP   ***'        
              DISPLAY '* REVENUE MONTH  : ' RV-REVENUE-MONTH            
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              DISPLAY '********** PCSCA909 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
