       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA905.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** PCSCA905 IS THE DRIVER PROGRAM FOR BILL PRINT EXTRACT.      ** 00120000
      **                                                             ** 00130000
      ** THIS PROGRAM WILL READ IN THE BE38 FLAT FILE FROM BILLING.  ** 00140000
      ** IT WILL THEN CALL SEVERAL SUBMODULES TO DO EXTRACTS OF DATA ** 00150000
      ** FOR BILL PRINT, UPDATING THE FLAT FILE COPYBOOKS CWS10000,  ** 00160000
      ** CWS10001, AND CWS10009. THEN IT WILL TAKE THAT DATA AND     ** 00170000
      ** UPDATE THE BE38 FILE NOW THE BILL IS READY TO BE PRINTED.   ** 00180000
      ** THE BE38 FILE IS THE ONLY FILE READ IN BECAUSE IT WAS       ** 00190000
      ** ALREADY MERGED WITH THE BE37 FILE AFTER IT CAME OUT OF THE  ** 00200000
      ** BILLING PROCESS.                                            ** 00210000
      ***************************************************************** 00220000
      *                                                              ** 00230000
      *              PROGRAM  MODIFICATION  LOG                      ** 00240000
      *                                                              ** 00250000
      *    DATE     INITIALS  REASON                                 ** 00260000
      *    ----     --------  ------                                 ** 00270000
      **   12/07    RV97439   NEW PCSCA105.                          ** 00280000
BILLRD*   06/2007   DB41297   SEB RATE RE-ENGINEERING.                * 00290000
T36790**   01/08    MVC       FEB, 2008 CYCLE1 BILL INSERTS. PASS    ** 00300000
T36790**                      RA-MISC-VARIABLES (CWS07500)           ** 00310000
T36790**                      TO SCSCA160.                           ** 00320000
T36209**   03/08    MVC       ADD FIELD WS-FREE-CSC-MONTHS TO AVOID  ** 00330000
      **                      COMPILE ERRORS.                        ** 00340000
T37108**   03/08    MVC       APR, 2008 CYCLE1 BILL INSERTS. PASS    ** 00350000
      **                      WS-CUST-STATS-CE TO SCSCA160.          ** 00360000
T37389**   08/08    SV        PROCESS TO SKIP ACCOUNTS FROM BILLPRINT** 00370000
T37389**   09/08    SV ACT-37 ADD PARM TO CONTROL WQ INSERTION.      ** 00380000
T35152**   10/08    RV        CSR BILL REDESIGN.                     ** 00390000
I00177**   01/09    RV        REPLACE INDEX HARDCODING FOR CL TABLE  ** 00400000
I00177**                      AND PASS LINKAGE SECTION TO SUB PGMS   ** 00410000
I00177**                      WHICH HAS THE MAX TABLE SIZE.          ** 00420000
A01096**   04/09    RAJ       CHANGE LOGIC OF IDENTIFYING EBILL      ** 00430000
A01096**                      CUSTOMERS.                             ** 00440000
PRJ577**   06/09    STEVE     CIAC.                                  ** 00450000
PRJ172**   07/09    RAJ       REGULATED PROVIDER TRANSITION.         ** 00460000
PRJ166**   09/09    RAJ       OUTPUT MANAGEMENT.                     ** 00470000
A01973**   12/09    SDHAL     ADDING WS-ACCT-MKT-TIER-DD TO SCSCA188 ** 00480000
P00246**   02/10    EM19682   OVERRIDE REVENUE MONTH.                ** 00490000
A01292**   04/05    MC95456   PASS 'H' TO BILL DEST CODE AND 'B' TO  ** 00500000
A01292**                      SYSTEM CNTRL CODE FOR TEMP PULL CODE 'B'  00510000
A01292**                      (THIS PROCESS IS TO PULL HIGH BILLS)   ** 00520000
A02003**   09/10    RAJ       REMOVE RAPID PAY FLAG.                 ** 00530000
P00399**   11/10    DMS       REMOVE BALANCE CRED GRP FOR SCEG       ** 00540000
A03019**   01/11    SV        REMOVE BILL FORMAT RELATED CHANGES     ** 00550000
A03019**                      AS THEY ARE PROCESSED IN SCSCA186      ** 00560000
A02499**   02/11    BD09555   MOVE BANKRUPTCIES TO C3 GROUP          ** 00570000
A03313**   04/11    SV        MAY CYCLE 1 CHANGES                    ** 00580000
A03019**   05/11    SV        FIX INFINTE LOOPING LOGIC              ** 00590000
P00453**   05/11    RAJ       SCANA ENERGY PRE-PAY.                  ** 00600000
P00453**   10/11    EH        PASS PK TO SCSCA187 FOR PREPAY AUDIT   ** 00610000
P00496**   11/11    RAJ       INDUSTRIAL ENHANCEMENTS.               ** 00620000
A03964**   03/12    ED        CORRECT BANKRUPTCY BILL PULL ISSUE.    ** 00630000
P00599**   04/12    DMS       CREDIT SIMPLIFICATION                  ** 00640000
P00641**   06/12    ESM       GL TABLE CHANGES                       ** 00650000
A03876**   08/12    ESM       ADDED DF AND FF RECORDS TO LINKAGE     ** 00651000
A03876**                      FOR SCSCA188 AND SCSCA189              ** 00652000
A03876**                                                             ** 00653000
P00587**   09/12    SV        IMPLEMENT REMOTE COLLABORATOR          ** 00654000
A04527**   01/13    DB41297   CONVERT OLD CWS1000B FORMAT TO NEW     ** 00655000
A04527**   ACT001             WHEN RECORDS COME IN WITH OLD FORMAT.  ** 00656000
A04527**   03/30    SV        HANDLE THE NEW PULL CODE 'G' CREATED FOR* 00656100
A04527**   ACT038             PRICE ROUTINE ERROR.                   ** 00656200
A04527**   ACT053             FIX MISSING PERIOD ISSUE.              ** 00656300
P00680**   06/03/13 SV95326   TO ADD A PRICE NEGOTIATED ACCOUNT TO   ** 00656400
P00680**                      AUDIT FOR SCANA ENERGY.                ** 00656500
A04527**   09/19/13 MR7E794   REMOVED THE UNUSED DCLGENS.            ** 00656600
A04860** 01/22/15   AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            * 00656700
A04860**            ACT058    CSS_WQ_ITEMS.                           * 00656800
ACT162** 08/27/15   BD09555   REMOVE PULL CODE 'W' LOGIC FOR EXTIMATED* 00656900
ACT162** A05136-ACT162        BILLS PER LISA MAROUN                   * 00657000
A05136** 10/29/15   DB41297   REMOVE COPYBOOK CPD7500A                * 00657100
ACT055** 08/08/16   SV95326   ADD AUDIT CONDITION FOR SEB INITIAL     * 00657200
ACT055**            A05462    BILLS.                                  * 00657300
      ***END*********************************************************** 00657400
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00658000
      **                                                             ** 00659000
      **  0000         MODULE CONTROL                                ** 00660000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00670000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00680000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00690000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00700000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00710000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00720000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00730000
      **                                                             ** 00740000
      ***************************************************************** 00750000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** BE02 IS THE PRIMARY BILL EXTRACT FILE FOR INPUT               00810000
       COPY CSSBE38.                                                    00820000
                                                                        
      *** CA31 IS THE PRIMARY BILL EXTRACT FILE FOR OUTPUT              00840000
       COPY CSSCA31.                                                    00850000
                                                                        
      *** BE32 IS THE CONSOLIDATED EXTRACT FILE FOR OUTPUT              00870000
       COPY CSSBE32.                                                    00880000
                                                                        
T37389*** OMIT IS THE SKIP ACCOUNTS FILE FROM BILLPRINT                 00900000
T37389 COPY CSSOMIT.                                                    00910000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDBE38.                                                    00960000
       COPY FIOBE38.                                                    00970000
                                                                        
       COPY CFDCA31.                                                    00990000
       COPY FIOCA31A.                                                   01000000
                                                                        
       COPY CFDBE32.                                                    01020000
       COPY FIOBE32A.                                                   01030000
                                                                        
T37389 COPY CFDOMIT.                                                    01050000
T37389 COPY FIOOMIT.                                                    01060000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-ADJ-REASON  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA905'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05 WS-START                     PIC  X(40)                   
           VALUE 'WORKING STORAGE FOR PCSCA905 STARTS HERE'.            
           05  WS-FREE-CSC-MONTHS          PIC X(2).                    
           05  WS-NULL-IND                 PIC S9(04) COMP.             
           05  WS-START-POS                PIC S9(4) COMP.              
           05  WS-PRINT-RUN-DATE           PIC  X(10).                  
           05  WS-PROMOTION-TYPE           PIC  X   VALUE SPACES.       
               88  DELTA-SKYMILES                   VALUE 'D'.          
           05  WS-HOLD-SERVICE-STREET         PIC X(39).                
           05  WS-HOLD-SERVICE-OFLO           PIC X(26).                
           05  WS-HOLD-SERVICE-CITY-STATE-ZIP PIC X(41).                
           05  WS-HOLD-SERVICE-CARRIER-ROUTE  PIC X(05).                
           05  WS-HOLD-SERVICE-ZIPCODE        PIC X(11).                
           05  WS-HOLD-LOCATOR                PIC X(04).                
           05  WS-DISPLAY-ACCOUNT          PIC 9(13).                   
           05  WS-DISPLAY-DATE-READ        PIC X(10).                   
           05  WS-STORE-RETURN-CODE        PIC S9(04) COMP.             
           05  WS-PREVIOUS-ACCT-NO     PIC S9(13) COMP-3 VALUE 0.       
           05  WS-PREVIOUS-DATE-BILLED PIC X(10) VALUE SPACES.          
           05  WS-HOLD-BILL-STATUS         PIC  X(01).                  
               88  WS-STATUS-BILLED      VALUES 'A' 'F' 'H' 'I'.        
           05  WS-NUM-ACCOUNTS-READ        PIC S9(7) VALUE 0.           
           05  WS-NUM-ACCOUNTS-WRITTEN     PIC S9(7) VALUE 0.           
           05  WS-NUM-ACCOUNTS-SKIPPED     PIC S9(7) VALUE 0.           
           05  WS-BYPASS-CTR               PIC S9(7) VALUE 0.           
           05  WS-DISPLAY-READ             PIC -Z(7).                   
           05  WS-DISPLAY-WRITTEN          PIC -Z(7).                   
           05  WS-DISPLAY-SKIPPED          PIC -Z(7).                   
T37389     05  WS-DISPLAY-OMIT-ACCTS       PIC -Z(2).                   
           05  WS-SCSCA-RETURN-CODE        PIC S9(4) COMP.              
           05  WS-WQ-CREATED-SW            PIC X(01).                   
A03019     05  WS-BG-RATE-PLAN-FOUND-SW    PIC X(01) VALUE 'N'.         
           05  WS-ACCT-INSERT-SW           PIC X(01).                   
               88  ACCOUNT-INSERT                    VALUE 'T'.         
           05  WS-ACCT-MESSAGE-SW          PIC X(01).                   
               88  ACCOUNT-MESSAGE                   VALUE 'T'.         
           05  WS-ACCT-CREDIT-SW           PIC X(01).                   
               88  ACCOUNT-CREDIT                    VALUE 'T'.         
COB305     05 WS-INSERT-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-INSERT-BILL-CYCLE        PIC X(2).                    
           05  WS-INSERT-REV-MON-SWITCH    PIC X.                       
               88  INSERT-REV-MONTH-FOUND             VALUE 'T'.        
               88  INSERT-REV-MONTH-NOT-FOUND         VALUE 'F'.        
           05  WS-DATE-DATA.                                            
               10  WS-CURRENT-DATE         PIC X(10).                   
               10  FILLER                  PIC X(70).                   
COB305     05 WS-SEARCH-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-REBILL-DATE-TEMP         PIC X(10).                   
           05  WS-REBILL-DATE-EARLIEST     PIC X(10).                   
           05  WS-NO-OF-REBILLS            PIC 9(3).                    
COB305     05 WS-NO-OF-BILLS        PIC S9(4)V COMP-3 VALUE 0.           
COB305     05 WS-ACCOUNT-NO-TEMP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CAN-REB-SUB              PIC 9(2).                    
           05  WS-TEMP-BILL-NO             PIC S9(9) USAGE COMP.        
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-RA-TABLE-LOADED-SW       PIC X(01).                   
               88  RA-TABLE-LOADED                    VALUE 'Y'.        
BILLRD     05  WS-IC-NO                    PIC S9(04) COMP.             
BILLRD     05  WS-RT-PKG-OPT-SEQ-NO        PIC S9(04) COMP.             
BILLRD     05  WS-FACTOR-TYPE              PIC X(01).                   
           05  WS-B-FOUND                  PIC X.                       
           05  WS-BBF-DATE-FOUND           PIC X.                       
           05  WS-RATE-SECURED-FLAG    PIC X.                           
           05  WS-MARKET-PGM-CODE      PIC X(2).                        
BILLRD     05  WS-SCSCA195-SW          PIC X(1) VALUE'N'.               
                                                                        
      * FIELDS USED WITH CPD00103                                       01770000
       01  WS-CALLING-PARAGRAPH            PIC  X(04).                  
                                                                        
       01 WS-CONSO-CNTR                 PIC 9(02) VALUE 0.              
       01 WS-MISC-IDX                   PIC 9(09) COMP-3 VALUE 0.       
       01 WS-ROW-COUNT                  PIC S9(09) USAGE COMP VALUE 0.  
                                                                        
       01  WS-SORT-ADDRESS                 PIC  X(211).                 
                                                                        
       01  WS-PART-BREC-HOLD               PIC  9(01).                  
       01  WS-USER-ABEND-CODE          PIC S9(4) COMP VALUE +100.       
       01  WS-FBE38-STATUS                 PIC  X(02) EXTERNAL.         
           88  FBE38-SUCCESSFUL                       VALUE '00'.       
       01  WS-FCA31-STATUS                 PIC  X(02) EXTERNAL.         
           88  FCA31-SUCCESSFUL                       VALUE '00'.       
       01  WS-FBE32-STATUS                 PIC  X(02) EXTERNAL.         
           88  FBE32-SUCCESSFUL                       VALUE '00'.       
T37389 01  WS-OMIT-STATUS                  PIC X(02) EXTERNAL.          
T37389     88  OMIT-SUCCESSFUL             VALUE '00'.                  
T37389     88  OMIT-READ-OK                VALUE '00' '04'.             
                                                                        
       01  WS-MISC-AREA    COMP.                                        
           05  WS-SUB                  PIC S9(04) VALUE ZERO.           
                                                                        
       01 WS-ADJ-REASON-TABLE.                                          
           05  WS-ADJ-REASN-LINE OCCURS 200.                            
               10  WS-ADJ-REASON-CD          PIC X(4).                  
               10  WS-ADJ-REASON-DESC        PIC X(255).                
           05  WS-ADJ-SUB                    PIC 9(03) VALUE ZERO.      
                                                                        
       01  WS-SUBSCRIPTS.                                               
           05  WS-12-MONTH-CTR             PIC S9(04) COMP.             
           05  SUB1                        PIC 999 VALUE 0.             
                                                                        
       01  WS-MISC-HOST-VARIABLES.                                      
           05  WS-ADJ-REASON-CD1           PIC X(4)  OCCURS 100 TIMES.  
           05  WS-ADJ-REASON-DESC1         PIC X(255) OCCURS 100 TIMES. 
       01  WS-SWITCHES.                                                 
           05  WS-BEGIN-REC-SW             PIC  X(01).                  
               88  WS-BEGIN-RECS-PROCESSED            VALUE 'Y'.        
               88  WS-BEGIN-REC-NOT-PROCESSED         VALUE 'N'.        
               88  WS-START-INPUT-DATA                VALUE 'X'.        
           05  WS-BEGIN-REC-PROCESSED      PIC  X(01) VALUE 'N'.        
           05  WS-END-REC-PROCESSED        PIC  X(01) VALUE 'N'.        
           05  WS-MORE-BEGIN-REC           PIC  X(01) VALUE 'N'.        
                                                                        
           05  WS-FCSBE38-ACCT-FLAG        PIC  X(01) VALUE 'N'.        
               88  FCSBE38-ACCT-NO-CHANGED            VALUE 'Y'.        
           05  WS-FCSBE38-ACCT-PROCESS-FLAG PIC  X(01) VALUE 'N'.       
           05  WS-FCSBE38-FLAG             PIC  X(01) VALUE 'N'.        
               88  END-OF-FCSBE38                     VALUE 'Y'.        
           05  WS-CNTRL-REC-FLAG           PIC  X(01) VALUE 'N'.        
           05  WS-IS-RECORD-IN-TABLE       PIC  X(01) VALUE 'N'.        
               88  WS-RECORD-IS-IN-TABLE              VALUE 'Y'.        
               88  WS-RECORD-IS-NOT-IN-TABLE          VALUE 'N'.        
           05  WS-1ST-BE38-ENTRY-SW        PIC  X(01).                  
               88  WS-1ST-BE38-ENTRY                  VALUE 'Y'.        
               88  WS-NOT-1ST-BE38-ENTRY              VALUE 'N'.        
           05  WS-SCSCA-WQ-CREATED-SW      PIC X(01).                   
               88  WS-SCSCA-WQ-CREATED                VALUE 'Y'.        
           05  WS-INITIAL-BILL-SWITCH      PIC X(01).                   
               88  CHECK-FOR-INITIAL                  VALUE 'Y'.        
               88  NO-CHECK-FOR-INITIAL               VALUE 'N'.        
           05  WS-TEMP-CAN-REB-FLAG        PIC X(01).                   
           05  WS-INITIAL-FLAG             PIC X(01).                   
               88  CANCEL-REBILL-INITIAL              VALUE 'Y'.        
               88  INITIAL-BILL                       VALUE 'I'.        
           05  WS-PAPERLESS-SWITCHES.                                   
               10 WS-BILL-VIEW-SW          PIC X   VALUE 'N'.           
                  88  BILL-VIEW                    VALUE 'Y'.           
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-FCSBE38-CNTR         PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FCSCA31-CNTR         PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FCSBE32-CNTR         PIC S9(07) COMP-3 VALUE ZERO.    
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC  X(01) VALUE 'Y'.        
           05  WS-Y                        PIC  X(01) VALUE 'Y'.        
           05  WS-NO                       PIC  X(01) VALUE 'N'.        
           05  WS-N                        PIC  X(01) VALUE 'N'.        
           05  WS-PGRMNAME             PIC  X(08) VALUE 'PCSCA905'.     
           05  PROGRAM-NAME            PIC  X(08) VALUE 'PCSCA905'.     
           05  SCSCA159                PIC  X(08) VALUE 'SCSCA159'.     
T35152     05  SCSCA167                PIC  X(08) VALUE 'SCSCA167'.     
           05  SCSCA187                PIC  X(08) VALUE 'SCSCA187'.     
           05  SCSCA1XX                PIC  X(08) VALUE 'SCSCA1XX'.     
BILLRD     05  SCSCA195                PIC  X(08) VALUE 'SCSCA195'.     
T37389     05  SCSCA151                PIC  X(08) VALUE 'SCSCA151'.     
A04860     05  SCSCB077                PIC  X(08) VALUE 'SCSCB077'.     
           05  WS-811                  PIC S9(09) VALUE -811 COMP.      
           05  WS-BATCH                PIC  X(05) VALUE 'BATCH'.        
                                                                        
      *********************************************************         02690000
      *                                                       *         02700000
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *         02710000
      *                                                       *         02720000
      *********************************************************         02730000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(04) COMP.             
               10  WS-WQ-PRIORITY          PIC  X(01).                  
               10  WS-WQ-ROUTE-CATEGORY    PIC  X(01).                  
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(04) COMP.             
               10  WS-WQ-MESSAGE-TEXT      PIC  X(30).                  
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER              PIC S9(04) COMP VALUE +121.      
               10  FILLER                  PIC  X(01) VALUE 'N'.        
               10  FILLER                  PIC  X(01) VALUE '4'.        
               10  FILLER              PIC S9(04) COMP VALUE +29.       
               10  FILLER                  PIC  X(30) VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER              PIC S9(04) COMP VALUE +121.      
               10  FILLER                  PIC  X(01)  VALUE 'N'.       
               10  FILLER                  PIC  X(01)  VALUE '4'.       
               10  WS-MISC-MSG-LEN     PIC S9(04) COMP VALUE +60.       
               10  WS-MISC-MSG-TEXT        PIC  X(60).                  
           05  WS-ACCOUNT-BYPASS-MSG.                                   
               10  FILLER              PIC S9(04) COMP VALUE +121.      
               10  FILLER                  PIC  X(01)  VALUE 'N'.       
               10  FILLER                  PIC  X(01)  VALUE '4'.       
               10  WS-MISC-MSG-LEN     PIC S9(04) COMP VALUE +60.       
               10  WS-BYPASS-MSG-TEXT        PIC  X(90).                
           05  WS-BYPASS-INFO            PIC  X(45).                    
           05  WS-BYPASS-MSG-LITERAL     PIC  X(45)                     
                VALUE 'CONTACT BILL PRINT TEAM; ACCOUNT BYPASSED IN:'.  
           05  WS-NO-DATE-ON-BILL-MSG.                                  
               10  WS-NO-DATE-CAT-ID       PIC S9(04) COMP VALUE +137.  
               10  WS-NO-DATE-PRIORITY     PIC  X(01)  VALUE 'N'.       
               10  WS-NO-DATE-ROUTE-CAT    PIC  X(01)  VALUE '4'.       
               10  WS-NO-DATE-MSG-LEN      PIC S9(04) COMP VALUE +67.   
               10  WS-NO-DATE-MSG-TEXT     PIC  X(90).                  
           05  WS-NO-DATE-INFO             PIC  X(45).                  
           05  WS-NO-DATE-MSG-LITERAL      PIC  X(25)                   
                VALUE 'NO DATE ON BILL HEADER : '.                      
      *                                                                 03195600
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 03196000
       COPY FIOBE37.                                                    03197000
       COPY FIOBE00A.                                                   03198000
           COPY FIOCA00.                                                03199000
           COPY FIOJC01.                                                03200000
       COPY CWS0022B.                                                   03210000
       COPY CWS0024B.                                                   03220000
       COPY CWS00038.                                                   03230000
       COPY CWS00039.                                                   03240000
       COPY CWS00050.                                                   03250000
       COPY CWS00090.                                                   03260000
       COPY CWS00091.                                                   03270000
       COPY CWS1000A.                                                   03280000
       COPY CWS1000B.                                                   03290000
       COPY CWS1001A.                                                   03300000
       COPY CWS1001B.                                                   03310000
T35152 COPY CWS10009.                                                   03320000
P00599 COPY CWS1000K.                                                   03330000
       COPY CWS10017.                                                   03340000
       COPY CWS100B5.                                                   03350000
       COPY CWS100B6.                                                   03360000
       COPY CWS00303.                                                   03370000
       COPY CWS00010.                                                   03380000
       COPY CWS00096.                                                   03390000
       COPY CWSK0001.                                                   03400000
       COPY CWS00195.                                                   03410000
T37389 COPY CWSCA151.                                                   03420000
PRJ166*********************************************************         03430000
PRJ166* COPYBOOK TO LOAD DATA TO WORKING STORAGE TABLES       *         03440000
PRJ166*********************************************************         03450000
PRJ166 COPY CWSCA105.                                                   03460000
                                                                        
           EXEC SQL                                                     03480000
               INCLUDE CWS07500                                         03490000
           END-EXEC.                                                    03500000
           EXEC SQL                                                     03510000
               INCLUDE CWS00328                                         03520000
           END-EXEC.                                                    03530000
            EXEC SQL                                                    03540000
                 INCLUDE SQLCA                                          03550000
            END-EXEC.                                                   03560000
           EXEC SQL                                                     03570000
                INCLUDE CWS0070B                                        03580000
           END-EXEC.                                                    03590000
           EXEC SQL                                                     03660000
                INCLUDE TBJBPARM                                        03670000
           END-EXEC.                                                    03680000
           EXEC SQL                                                     03690000
                INCLUDE TBGLATNO                                        03700000
           END-EXEC.                                                    03710000
           EXEC SQL                                                     03750000
                INCLUDE TBDELQ                                          03760000
           END-EXEC.                                                    03770000
           EXEC SQL                                                     03780000
               INCLUDE TBBLLHDR                                         03790000
           END-EXEC.                                                    03800000
           EXEC SQL                                                     03810000
                INCLUDE TBTEMPIN                                        03820000
           END-EXEC.                                                    03830000
           EXEC SQL                                                     03840000
                INCLUDE TBLADRSN                                        03850000
           END-EXEC.                                                    03860000
           EXEC SQL                                                     03870000
               INCLUDE TBEBLINS                                         03880000
           END-EXEC.                                                    03890000
BILLRD*                                                                 03990000
BILLRD* COBOL DECLARATION FOR TABLE CSS_BILL_WINDOW                     04150000
BILLRD*                                                                 04160000
BILLRD     EXEC SQL                                                     04170000
BILLRD          INCLUDE TBBILWDW                                        04180000
BILLRD     END-EXEC.                                                    04190000
A04860*                                                                 04230100
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     04230200
A04860      EXEC SQL                                                    04230300
A04860           INCLUDE CWS00077                                       04230400
A04860      END-EXEC.                                                   04230500
A04860*                                                                 04230600
                                                                        
           EXEC SQL                                                     
               DECLARE GL_NAME CURSOR FOR                               
P00641             SELECT GL_ACCT_NAME,                                 
P00641                    GL_ACCT_NAME_DESC,                            
P00641                    GL_ACCT_NO,                                   
P00641                    GL_ACCT_CLASS                                 
P00641             FROM CSS_GL_ACCT_NO                                  
                   ORDER BY GL_ACCT_NO                                  
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               DECLARE ADJ_REASON CURSOR WITH ROWSET POSITIONING FOR    
               SELECT K0.ADJ_REASON_CD,                                 
                      K0.ADJ_REASON_DESC                                
                 FROM CSS_BILL_ADJ_REASN K0                             
               ORDER BY K0.ADJ_REASON_CD                                
           END-EXEC.                                                    
T37389                                                                  
T37389 LINKAGE SECTION.                                                 
T37389 01  WS-PARM-VALUE.                                               
T37389     03  WS-PARMVAL-LENGTH               PIC S9(04) COMP.         
T37389     03  WS-WQ-INS-SW                    PIC X(01).               
                                                                        
T37389 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 04630000
      *    0000-MAINLINE                                             ** 04640000
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    ** 04650000
      ***************************************************************** 04660000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
                                                                        
      * READ PAST ALL OF THE BEGIN RECORDS OF THE BE38 FILE.            04720000
                                                                        
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           MOVE WS-YES                TO WS-MORE-BEGIN-REC.             
           PERFORM 0500-PROCESS-BEGIN-REC     THRU 0500-EXIT            
             UNTIL WS-MORE-BEGIN-REC EQUAL WS-NO.                       
           IF END-OF-FCSBE38                                            
             DISPLAY '**     PCSCA905 PROCESSING ERROR      **'         
             DISPLAY '**       FCSBE38 FILE IS EMPTY        **'         
             DISPLAY '**       PROCESSING TERMINATED        **'         
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
           MOVE E-FBE38-ACCOUNT-NO    TO WS-PREVIOUS-ACCT-NO.           
           MOVE E-FBE38-DATE-BILLED   TO WS-PREVIOUS-DATE-BILLED.       
           MOVE WS-YES                TO WS-1ST-BE38-ENTRY-SW.          
      * WRITE THE BEGIN RECORD FOR THE OUTPUT FILE.                     04870000
           PERFORM 3100-OPEN-WRITE-BEGIN-REC  THRU 3100-EXIT.           
                                                                        
T37389* CALL SCSCA151 TO GET ACCOUNTS THAT SKIP BILL PRINT PROCESS.     04900000
T37389     MOVE WS-Y                  TO WS-CA151-FIRST-CALL-SW.        
T37389     PERFORM 3570-CALL-SKIP-ACCTS     THRU 3570-EXIT.             
T37389     MOVE WS-N                  TO WS-CA151-FIRST-CALL-SW.        
                                                                        
      * PERFORMANCE TUNING.                                             04950000
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           MOVE E-FBE38-COMPANY-NO            TO C8-COMPANY-NO          
                                                 E8-COMPANY-NO.         
           PERFORM 3549-CALL-DELIQUENCY       THRU 3549-EXIT.           
           MOVE C8-DELINQ-VALUE               TO LS-DATABASE.           
                                                                        
           IF SEB-DATABASE                                              
PRJ172        MOVE WS-INPUT-DATE         TO WS-CA195-BILL-DATE          
              DISPLAY 'CALLING SCSCA195 FROM PCSCA905'                  
              DISPLAY '     TO FETCH GROUP2 FIELDS   '                  
              MOVE 'SCSCA195' TO    WS-CA195-PROG-NAME                  
              PERFORM 3505-CALL-FETCH-GROUP2     THRU 3505-EXIT         
           END-IF.                                                      
                                                                        
      *********************************************************         05100000
      * FETCH EACH ACCOUNT FROM THE BE38 FILE AND LOAD THEM   *         05110000
      * INTO THE COPYBOOKS TO BE SENT THROUGH LINKAGE FOR THE *         05120000
      * SUBMODULES TO DO THEIR PROCESSING.                    *         05130000
      *********************************************************         05140000
                                                                        
           PERFORM 2000-PROCESS-ACCOUNTS      THRU 2000-EXIT            
             UNTIL END-OF-FCSBE38.                                      
T37389     IF ACCTS-TO-PROCESS                                          
T37389        DISPLAY '***********************************************' 
T37389        DISPLAY '* CHECK OMIT FILE, NOT ALL ACCOUNTS SKIPPED   *' 
T37389        DISPLAY '* ACCTS FROM FILE ' WS-CA151-TOT-ACCTS-FROM-FILE 
T37389        DISPLAY '* ACCTS OMITTED   ' WS-CA151-TOT-ACCTS-OMITTED   
T37389        DISPLAY '***********************************************' 
T37389     END-IF.                                                      
      * WRITE THE END RECORD FOR THE OUTPUT FILE.                       05250000
           PERFORM 5200-VALIDATE-ACCOUNT-TOTALS THRU 5200-EXIT.         
           PERFORM 5110-WRITE-END-CONTROLS THRU 5110-EXIT.              
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05340000
      *    0100-INITIALIZATION                                       ** 05350000
      *    OPEN FILES                                                ** 05360000
      *    READ JOBS TABLE TO OBTAIN RUN DATE/COMMON DATE            ** 05370000
      ***************************************************************** 05380000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE ZEROES                TO WS-FCSCA31-CNTR.               
           MOVE ZEROES                TO WS-FCSBE32-CNTR.               
           INITIALIZE                 WS-AUDIT-BILL-PRINT-CRITERIA      
                                      WS-SCSCA-RETURN-CODE              
T37389                                WS-CA151-TOT-ACCTS-OMITTED        
                                      WS-MOVING-KIOSKS.                 
           MOVE 'N' TO                WS-SCSCA-WQ-CREATED-SW            
                                      WS-WQ-CREATED-SW                  
                                      WS-FCSBE38-ACCT-PROCESS-FLAG      
                                      WS-RA-TABLE-LOADED-SW.            
                                                                        
           MOVE ZEROS                 TO LS-DATABASE.                   
                                                                        
           OPEN INPUT  FCSBE38-FILE.                                    
           IF NOT FBE38-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE38 OPEN.  STATUS IS '         
                       WS-FBE38-STATUS                                  
              PERFORM 9900-ABEND           THRU 9900-EXIT
           END-IF.              
                                                                        
           INITIALIZE WS-GL-NAME-TABLE.                                 
           EXEC SQL                                                     
               OPEN GL_NAME                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00641         MOVE 'GO' TO WS-DB2-TABLE-ID                             
               MOVE 'OPEN' TO WS-DB2-FUNCTION                           
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '905' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               DISPLAY '*** IN 0000-INITILIZATION   ******'             
               DISPLAY '*** CURSOR OPEN GL_NAME     ******'             
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           MOVE 1 TO WS-GL-SUB1.                                        
           PERFORM 0130-FETCH-GL THRU 0130-EXIT.                        
           EXEC SQL                                                     
               CLOSE GL_NAME                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00641         MOVE 'GO' TO WS-DB2-TABLE-ID                             
               MOVE 'CLOSE' TO WS-DB2-FUNCTION                          
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '905' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               DISPLAY '*** IN 0000-INITILIZATION    ******'            
               DISPLAY '*** CURSOR CLOSE GL_NAME     ******'            
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           EXEC SQL                                                     
               OPEN ADJ_REASON                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'K0'                   TO WS-DB2-TABLE-ID           
               MOVE 'OPEN'                 TO WS-DB2-FUNCTION           
               MOVE SQLCODE                TO WS-DB2-RETURN-CODE        
               MOVE '905'                  TO WS-DB2-MODULE-ID          
               MOVE '0100'                 TO WS-DB2-PARAGRAPH          
               DISPLAY '*** IN 0000-INITILIZATION    ******'            
               DISPLAY '*** CURSOR OPEN ADJ_REASON   ******'            
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12                     TO RETURN-CODE               
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
           MOVE 1                          TO WS-ADJ-SUB.               
           MOVE 1                          TO WS-MISC-IDX.              
           PERFORM 0160-FETCH-ADJ          THRU 0160-EXIT.              
           EXEC SQL                                                     
               CLOSE ADJ_REASON                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'K0'                   TO WS-DB2-TABLE-ID           
               MOVE 'CLOSE'                TO WS-DB2-FUNCTION           
               MOVE SQLCODE                TO WS-DB2-RETURN-CODE        
               MOVE '905'                  TO WS-DB2-MODULE-ID          
               MOVE '0100'                 TO WS-DB2-PARAGRAPH          
               DISPLAY '*** IN 0000-INITILIZATION    ******'            
               DISPLAY '*** CURSOR CLOSE ADJ_REASON  ******'            
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12                     TO RETURN-CODE               
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
           MOVE WS-FCA00-COMMON-DATE TO WS-CURRENT-DATE.                
           INITIALIZE WS-INSERT-BILL-CYCLE                              
                      WS-INSERT-REV-MON-SWITCH.                         
      *                                                                 06360000
      ***************************************************************   06370000
      ** SELECT THE CURRENT REVENUE MONTH BASED ON THE DATE        **   06380000
      ** RETURNED BY THE LINES ABOVE.                              **   06390000
      ***************************************************************   06400000
           EXEC SQL                                                     
               SELECT MAX(REVENUE_MONTH) INTO :WS-INSERT-REVENUE-MONTH  
               FROM CSS_BILL_WINDOW                                     
               WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
                 AND CODE_BILL_COND = 'R'                               
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06410000
MFA-TR*        SELECT MAX(REVENUE_MONTH) INTO :WS-INSERT-REVENUE-MONTH  06420000
MFA-TR*        FROM CSS_BILL_WINDOW                                     06430000
MFA-TR*        WHERE DATE_EXTRACT = :WS-CURRENT-DATE                    06440000
MFA-TR*          AND CODE_BILL_COND = 'R'                               06450000
MFA-TR*    END-EXEC                                                     06460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      ***************************************************************   06470000
      ** IF THE REVENUE-MONTH SELECT FAILS, WRITE A WORK QUEUE AND **   06480000
      ** SET A FLAG TO STOP THE PROGRAM FROM TRYING TO SELECT THE  **   06490000
      ** BILL CYCLE.  WHEN THIS HAPPENS, THE PROGRAM WILL USE THE  **   06500000
      ** BILL CYCLE FROM EACH ACCOUNT'S ACCOUNT TABLE RECORDS.     **   06510000
      ***************************************************************   06520000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               SET INSERT-REV-MONTH-NOT-FOUND TO TRUE                   
               MOVE 'PCSCA905:0100' TO WS-BYPASS-INFO                   
           ELSE                                                         
               SET INSERT-REV-MONTH-FOUND TO TRUE                       
           END-IF                                                       
      *                                                                 06600000
      ***************************************************************   06610000
      ** USING THE DATE AND REVENUE MONTH RETURNED ABOVE, THIS     **   06620000
      ** SELECT RETURNS THE MOST RECENTLY OPENED BILL CYCLE.       **   06630000
      ***************************************************************   06640000
           IF INSERT-REV-MONTH-FOUND                                    
               EXEC SQL                                                 
                   SELECT MAX(BILL_CYCLE) INTO :WS-INSERT-BILL-CYCLE    
                   FROM CSS_BILL_WINDOW                                 
                   WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
                     AND CODE_BILL_COND = 'R'                           
                     AND REVENUE_MONTH = :WS-INSERT-REVENUE-MONTH       
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 06660000
MFA-TR*            SELECT MAX(BILL_CYCLE) INTO :WS-INSERT-BILL-CYCLE    06670000
MFA-TR*            FROM CSS_BILL_WINDOW                                 06680000
MFA-TR*            WHERE DATE_EXTRACT = :WS-CURRENT-DATE                06690000
MFA-TR*              AND CODE_BILL_COND = 'R'                           06700000
MFA-TR*              AND REVENUE_MONTH = :WS-INSERT-REVENUE-MONTH       06710000
MFA-TR*        END-EXEC                                                 06720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL           
                   SET INSERT-REV-MONTH-NOT-FOUND TO TRUE               
                   MOVE 'PCSCA905:0100' TO WS-BYPASS-INFO               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 06790000
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      06830000
      *  FETCH GL ROWS, BUILDING THE W/S TABLE.                  *      06840000
      ************************************************************      06850000
                                                                        
       0130-FETCH-GL.                                                   
                                                                        
           EXEC SQL                                                     
               FETCH GL_NAME                                            
P00641          INTO :GO-GL-ACCT-NAME,                                  
P00641               :GO-GL-ACCT-NAME-DESC,                             
A01663               :GO-GL-ACCT-NO,                                    
A01663               :GO-GL-ACCT-CLASS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00641             MOVE GO-GL-ACCT-NAME TO WS-GL-NAME (WS-GL-SUB1)      
P00641             MOVE GO-GL-ACCT-NAME-DESC TO WS-GL-DESC (WS-GL-SUB1) 
                   MOVE GO-GL-ACCT-NO TO WS-GL-ACCT (WS-GL-SUB1)        
A01663             MOVE GO-GL-ACCT-CLASS TO WS-GL-ACCT-CLASS(WS-GL-SUB1)
                   ADD 1 TO WS-GL-SUB1                                  
                   GO TO 0130-FETCH-GL                                  
               WHEN NOT-FOUND                                           
                   GO TO 0130-EXIT                                      
               WHEN OTHER                                               
P00641             MOVE 'GO' TO WS-DB2-TABLE-ID                         
                   MOVE 'FETCH' TO WS-DB2-FUNCTION                      
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '905' TO WS-DB2-MODULE-ID                       
                   MOVE '0130' TO WS-DB2-PARAGRAPH                      
                   MOVE 12 TO RETURN-CODE                               
                   DISPLAY '*** IN 0130 FETCH GL ***'                   
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07210000
                                                                        
       0160-FETCH-ADJ.                                                  

MSQ008     MOVE 100 TO MSQ008-ADJ-REASON
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-ADJ-REASON
              FETCH 
              FROM ADJ_REASON            
                INTO :WS-ADJ-REASON-CD1,                                
                     :WS-ADJ-REASON-DESC1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     07250000
MFA-TR*        FETCH NEXT ROWSET FROM ADJ_REASON FOR 100 ROWS           07260000
MFA-TR*         INTO :WS-ADJ-REASON-CD1,                                07270000
MFA-TR*              :WS-ADJ-REASON-DESC1                               07280000
MFA-TR*    END-EXEC.                                                    07290000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ADJ-REASON
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                       MOVE WS-ADJ-REASON-CD1 (WS-MISC-IDX)             
                                             TO                         
                                        WS-ADJ-REASON-CD (WS-ADJ-SUB)   
                       IF WS-ADJ-REASON-CD1 (WS-MISC-IDX)  < 500        
                          INSPECT WS-ADJ-REASON-DESC1 (WS-MISC-IDX)     
                                              REPLACING ALL '/C' BY '  '
                       END-IF                                           
                       MOVE WS-ADJ-REASON-DESC1 (WS-MISC-IDX)           
                                             TO                         
                                        WS-ADJ-REASON-DESC (WS-ADJ-SUB) 
                       ADD 1                      TO WS-ADJ-SUB         
                       ADD 1                      TO WS-MISC-IDX        
                   END-PERFORM                                          
               WHEN NOT-FOUND                                           
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             07480000
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      07490000
MFA-TR*            END-EXEC                                             07500000
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
                   PERFORM UNTIL WS-MISC-IDX > WS-ROW-COUNT             
                       MOVE WS-ADJ-REASON-CD1 (WS-MISC-IDX)             
                                             TO                         
                                        WS-ADJ-REASON-CD (WS-ADJ-SUB)   
                       IF WS-ADJ-REASON-CD1 (WS-MISC-IDX)  < 500        
                          INSPECT WS-ADJ-REASON-DESC1 (WS-MISC-IDX)     
                                              REPLACING ALL '/C' BY '  '
                       END-IF                                           
                       MOVE WS-ADJ-REASON-DESC1 (WS-MISC-IDX)           
                                             TO                         
                                        WS-ADJ-REASON-DESC (WS-ADJ-SUB) 
                       ADD 1                      TO WS-ADJ-SUB         
                       ADD 1                      TO WS-MISC-IDX        
                   END-PERFORM                                          
                   GO TO 0160-EXIT                                      
               WHEN OTHER                                               
                   MOVE 'K0'                 TO WS-DB2-TABLE-ID         
                   MOVE 'FETCH'              TO WS-DB2-FUNCTION         
                   MOVE SQLCODE              TO WS-DB2-RETURN-CODE      
                   MOVE '905'                TO WS-DB2-MODULE-ID        
                   MOVE '0160'               TO WS-DB2-PARAGRAPH        
                   MOVE 12                   TO RETURN-CODE             
                   DISPLAY '*** IN 0160 FETCH GL ***'                   
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
                   PERFORM 9900-ABEND        THRU 9900-EXIT             
           END-EVALUATE.                                                
           GO TO 0160-FETCH-ADJ.                                        
                                                                        
       0160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    07820000
      ****************************************************************  07830000
      ** 0200-READ-ALL-BE38-FOR-ACCT                                **  07840000
      ** THIS IS CALLED WHEN THE PROGRAM NEEDS TO GET THE NEXT RECORD*  07850000
      ** FROM THE BE38 QSAM FILE.                                    *  07860000
      ****************************************************************  07870000
                                                                        
       0200-READ-ALL-BE38-FOR-ACCT.                                     
                                                                        
           IF WS-END-REC-PROCESSED EQUAL WS-YES                         
             IF E-FBE38-KEY-EREC EQUAL HIGH-VALUES                      
                NEXT SENTENCE                                           
             ELSE                                                       
                DISPLAY '*       PCSCA905 PROCESSING ERROR       *'     
                DISPLAY '*  LAST RECORD IS NOT A CONTROL RECORD  *'     
                DISPLAY '* PROCESSING TERMINATED                 *'     
                PERFORM 9900-ABEND         THRU 9900-EXIT               
             END-IF                                                     
           ELSE                                                         
             IF E-FBE38-KEY-EREC EQUAL HIGH-VALUES                      
                MOVE WS-YES           TO WS-END-REC-PROCESSED           
             ELSE                                                       
               IF E-FBE38-ACCOUNT-NO EQUAL WS-PREVIOUS-ACCT-NO AND      
                   E-FBE38-DATE-BILLED EQUAL WS-PREVIOUS-DATE-BILLED    
                 PERFORM 0250-LOAD-BY-TABLE-ID  THRU 0250-EXIT          
                 MOVE WS-YES          TO WS-FCSBE38-ACCT-PROCESS-FLAG   
               ELSE                                                     
                 MOVE WS-YES          TO WS-FCSBE38-ACCT-FLAG           
                 GO TO 0200-EXIT                                        
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7990-READ-FCSBE38          THRU 7990-EXIT.           
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08190000
      ** 0250-LOAD-BY-TABLE-ID.                                     **  08200000
      ** THIS PROCESS WILL DECIDE WHICH COPYBOOK AND ROUTINE TO USE **  08210000
      ** TO LOAD THE DATA FROM THE BE38 FILE.                       **  08220000
      ****************************************************************  08230000
                                                                        
       0250-LOAD-BY-TABLE-ID.                                           
                                                                        
           MOVE E-FBE38-TABLE-ID TO WS-CWS-TABLE-ID.                    
           IF WS-CWS10000-TABLE-ID                                      
P00680        PERFORM 0800-LOAD-FBE38-WS-AREA THRU 0800-EXIT
           END-IF.           
           IF WS-CWS10001-TABLE-ID                                      
              MOVE E-FBE38-SORT-KEY   TO E-FBE37-SORT-KEY               
              MOVE E-FBE38-DATA(1:250) TO E-FBE37-DATA                  
              PERFORM 0850-LOAD-FBE37-WS-AREA THRU 0850-EXIT
           END-IF.           
           IF WS-CWS10009-TABLE-ID                                      
              PERFORM 0880-LOAD-FBE38-WS-AREA THRU 0880-EXIT
           END-IF.           
                                                                        
       0250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08453300
      ** 0500-PROCESS-BEGIN-REC                                     **  08453400
      ** THIS PROCESS IS CALLED TO DO AN INITIAL READ OF THE BE38   **  08453500
      ** QSAM FILE TO SEE IF IT IS EMPTY OR IF THE FIRST RECORD IS  **  08453600
      ** NOT A CONTROL RECORD.                                      **  08453700
      ****************************************************************  08453800
                                                                        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7990-READ-FCSBE38          THRU 7990-EXIT.           
           IF END-OF-FCSBE38                                            
             DISPLAY '** PCSCA905 PROCESSING ERROR  **'                 
             DISPLAY '**   FCSBE38 FILE IS EMPTY    **'                 
             DISPLAY '**   PROCESSING TERMINATED    **'                 
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
           IF E-FBE38-KEY-BREC EQUAL LOW-VALUES                         
             MOVE E-FBE38-CREATE-DATE-BREC TO LS-INPUT-DATE             
                                              WS-INPUT-DATE             
                                              WS-PRINT-RUN-DATE         
                                              WS-DATE                   
             MOVE E-FBE38-DB-PART-BREC TO WS-PART-BREC-HOLD             
             MOVE WS-YES              TO WS-BEGIN-REC-PROCESSED         
           ELSE                                                         
            IF WS-BEGIN-REC-PROCESSED EQUAL WS-YES                      
              MOVE WS-NO              TO WS-MORE-BEGIN-REC              
              GO TO 0500-EXIT                                           
            ELSE                                                        
              DISPLAY '**       PCSCA905 PROCESSING ERROR        **'    
              DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'    
              DISPLAY '**         PROCESSING TERMINATED          **'    
              PERFORM 9900-ABEND           THRU 9900-EXIT               
            END-IF                                                      
           END-IF.                                                      
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * INITIALIZE BE37 VARIABLES : 0640-                               08710000
       COPY CPD0049B.                                                   08720000
                                                                        
      * INITIALIZE BE38 VARIABLES : 0609-                               08740000
       COPY CPD0052B.                                                   08750000
                                                                        
      * INITIALIZE BE38 BILL PRINT CWS10009 VARIABLES : 0690-           08770000
       COPY CPD0101C.                                                   08780000
                                                                        
      * LOAD BE38 VARIABLES BY TABLE ID                                 08800000
       COPY CPD0050B.                                                   08810000
                                                                        
      * LOAD BE37 VARIABLES BY TABLE ID                                 08830000
       COPY CPD0051B.                                                   08840000
                                                                        
      * LOAD BE38 BILL PRINT CWS10009 VARIABLES BY TABLE ID             08860000
       COPY CPD0102C.                                                   08870000
                                                                        
      ***************************************************************** 08890000
      *    2000-PROCESS-ACCOUNTS                                     ** 08900000
      * THIS WILL CONTROL THE PROCESS OF GOING THROUGH THE QSAM FILES** 08910000
      * AND CHECKING TO SEE IF ANY COMPARE SHOULD BE DONE FOR AN     ** 08920000
      * ACCOUNT.                                                     ** 08930000
      ***************************************************************** 08940000
                                                                        
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
           INITIALIZE LS-COMM-AREA-VARIABLES.                           
           MOVE SPACES TO WS-AUDIT-REASON.                              
           PERFORM 2010-LOAD-ACCOUNT          THRU 2010-EXIT            
      *                                                                 09010000
      * THESE LINES ARE MOVED FROM 0100-INIT TO HERE FOR DELINQ CHANGES 09020000
      ***************************************************************** 09030000
      * CHECK CSS_DELINQUENCY TABLE TO DETERMINE IF SCEG OR SEB       * 09040000
      * ACCOUNT -- ONLY SCEG ACCOUNTS ARE GOING THROUGH THE INSERT    * 09050000
      * PROGRAM (SCSCA159) IN PARA 3550-CALL-INSERT-MARKER.           * 09060000
      ***************************************************************** 09070000
                                                                        
           MOVE SPACES                        TO WS-ACCT-INSERT-SW      
                                                 WS-ACCT-MESSAGE-SW     
                                                 WS-PROMOTION-TYPE      
                                                 WS-ACCT-CREDIT-SW      
BILLRD                                           WS-SCSCA195-SW.        
                                                                        
           IF SEB-DATABASE                                              
               IF RA-TABLE-LOADED                                       
                   CONTINUE                                             
               ELSE                                                     
                   SET RA-TABLE-LOADED TO TRUE                          
               END-IF                                                   
           END-IF                                                       
           IF INSERT-REV-MONTH-NOT-FOUND                                
               MOVE WS-BILL-CYCLE-AT         TO WS-INSERT-REVENUE-MONTH 
               MOVE WS-REV-MTH-LST-NRML-AT   TO WS-INSERT-REVENUE-MONTH 
           END-IF.                                                      
           MOVE WS-ACCOUNT-NO-AT TO WS-DISPLAY-ACCOUNT.                 
           DISPLAY ' ACCOUNT: '                                         
                   WS-DISPLAY-ACCOUNT ' FOR DATE : '                    
                   WS-DISPLAY-DATE-READ.                                
T37389     MOVE WS-N                      TO WS-CA151-OMIT-ACCOUNT-FL.  
T37389     IF ACCTS-TO-PROCESS                                          
T37389        MOVE WS-ACCOUNT-NO-AT       TO WS-CA151-INPUT-ACCOUNT     
T37389        PERFORM 3570-CALL-SKIP-ACCTS THRU 3570-EXIT               
T37389        IF WS-CA151-OMIT-ACCOUNT-FL = WS-Y                        
T37389           GO TO 2000-EXIT                                        
T37389        END-IF                                                    
T37389     END-IF                                                       
           IF WS-DATE-BILLED-BI = LOW-VALUES OR SPACES                  
              DISPLAY '**** DATE BILLED ON BILLING HDR IS NULL ! ****'  
              ADD 1                     TO WS-NUM-ACCOUNTS-SKIPPED      
              MOVE 'PCSCA905'           TO WS-NO-DATE-INFO              
              STRING WS-NO-DATE-MSG-LITERAL                             
                     WS-NO-DATE-INFO                                    
                     DELIMITED BY SIZE                                  
                INTO WS-NO-DATE-MSG-TEXT                                
             MOVE WS-ACCOUNT-BYPASS-MSG TO                              
                WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
A04860        INITIALIZE CWS00077-FIELDS                                
A04860        MOVE WS-NO-DATE-CAT-ID    TO WS-77-CATEGORY-ID            
              MOVE WS-NO-DATE-PRIORITY                                  
A04860                                  TO WS-77-PRIORITY               
A04860        MOVE WS-NO-DATE-ROUTE-CAT TO WS-77-ROUTE-CATEGORY         
A04860        MOVE WS-NO-DATE-MSG-LEN   TO WS-77-COMMENTS-LEN           
A04860        MOVE WS-NO-DATE-MSG-TEXT  TO WS-77-COMMENTS-TEXT          
A04860        MOVE ZERO                 TO WS-77-SERV-ORDER-NO          
A04860        MOVE LS-INPUT-DATE        TO WS-77-DATE-REQUIRED          
A04860        MOVE WS-ACCOUNT-NO-AT     TO WS-77-ACCOUNT-NO             
A04860        MOVE WS-PREMISE-NO-AT     TO WS-77-PREMISE-NO             
A04860        MOVE WS-CUSTOMER-NO-AT    TO WS-77-CUSTOMER-NO            
A04860        MOVE SPACES               TO WS-77-RESP-AREA-ID           
A04860        MOVE WS-LOCAL-OFFICE-AT   TO WS-77-LOCAL-OFFICE           
A04860        MOVE ZERO                 TO WS-77-FREE-FORM-LEN          
A04860        MOVE LOW-VALUES           TO WS-77-FREE-FORM-TXT          
A04860        MOVE PROGRAM-NAME         TO WS-77-CREATED-BY             
T37389        IF WS-WQ-INS-SW = 'Y'                                     
                 PERFORM 8895-INSERT-WORK-QUEUE      THRU 8895-EXIT     
T37389        END-IF                                                    
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF SEB-DATABASE                                              
               INITIALIZE RA-HOLD-RATE-PLAN                             
A03019         MOVE 'N'                    TO WS-BG-RATE-PLAN-FOUND-SW  
A03019         PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL        
A03019           WS-BILLING-INDX > WS-BG-MAX-ENTRY OR                   
A03019           WS-BG-RATE-PLAN-FOUND-SW = 'Y'                         
                   IF WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) > SPACES      
                       MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) TO      
                            RA-HOLD-RATE-PLAN                           
A03019                 MOVE 'Y'            TO WS-BG-RATE-PLAN-FOUND-SW  
                   END-IF                                               
               END-PERFORM                                              
               MOVE WS-REV-MTH-LST-NRML-AT TO RA-HOLD-REVMTH            
               MOVE WS-BILL-CYCLE-AT       TO RA-HOLD-BILL-CYCLE        
           END-IF.                                                      
                                                                        
           PERFORM 3520-CALL-TRANS-HISTORY    THRU 3520-EXIT.           
                                                                        
           MOVE +1 TO WS-BILLS-PER-ENVELOPE.                            
                                                                        
           MOVE 1 TO SUB1.                                              
           PERFORM UNTIL SUB1 > 12                                      
               MOVE '0' TO WS-INSERT-MARK (SUB1)                        
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
                                                                        
      ***************************************************************   09970000
      * FLAG CERTAIN ACCOUNTS TO BE PULLED AND SENT TO CUSTOMER         09980000
      * ACCOUNTING.                                                     09990000
      ***************************************************************   10000000
           PERFORM 3800-ERROR-HANDLING THRU 3800-EXIT.                  
                                                                        
      **********************************************                    10030000
      *    SCEG ACCOUNT IF WS-DELINQ-VALUE = 1     *                    10040000
P00587*    CALL SCSCA159 FOR ALL COMPANIES         *                    10050000
      **********************************************                    10060000
                                                                        
P00587     PERFORM 3550-CALL-INSERT-MARKER THRU 3550-EXIT.              
                                                                        
           PERFORM 3510-CALL-AUDIT-TRANS      THRU 3510-EXIT.           
                                                                        
                                                                        
      * WRITE THE ACCOUNT OUT TO THE QSAM FILE                          10130000
           PERFORM 3000-WRITE-EXTRACTS        THRU 3000-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10190000
      *    2010-LOAD-ACCOUNT.                                        ** 10200000
      * THIS IS CALLED TO INITIALIZE THE CWS10000 AND CWS10001 AREAS ** 10210000
      * AND TO READ IN THE INFO FROM THE QSAM FILES FOR A SPECIFIC   ** 10220000
      * ACCOUNT. (ALSO THE CWS10009 AREA.)                           ** 10230000
      ***************************************************************** 10240000
                                                                        
       2010-LOAD-ACCOUNT.                                               
                                                                        
           MOVE 0 TO LS-CURR-WQ-ITEM.                                   
           PERFORM 0609-INITIALIZE-FBE36-WS-AREA                        
                                              THRU 0609-EXIT.           
           PERFORM 0640-INITIALIZE-FBE37-WS-AREA                        
                                              THRU 0640-EXIT.           
           PERFORM 0690-INITIALIZE-FBE38-WS-AREA                        
                                              THRU 0690-EXIT.           
      * READ FROM THE BE38 FILE FOR ALL RECORDS FOR THIS ACCOUNT.       10350000
           PERFORM 0200-READ-ALL-BE38-FOR-ACCT                          
                                              THRU 0200-EXIT            
             UNTIL FCSBE38-ACCT-NO-CHANGED                              
                OR END-OF-FCSBE38.                                      
           IF WS-FCSBE38-ACCT-PROCESS-FLAG = 'N'                        
              AND WS-FCSBE38-ACCT-FLAG = 'N' AND END-OF-FCSBE38         
             DISPLAY '**     PCSCA905 PROCESSING ERROR      **'         
             DISPLAY '**       FCSBE38 FILE IS EMPTY        **'         
             DISPLAY '**       PROCESSING TERMINATED        **'         
             MOVE 2                           TO RETURN-CODE            
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
           MOVE WS-NO                 TO WS-FCSBE38-ACCT-FLAG.          
           MOVE E-FBE38-ACCOUNT-NO    TO WS-PREVIOUS-ACCT-NO.           
           MOVE WS-PREVIOUS-DATE-BILLED TO WS-DISPLAY-DATE-READ.        
           MOVE E-FBE38-DATE-BILLED   TO WS-PREVIOUS-DATE-BILLED.       
           ADD 1 TO WS-NUM-ACCOUNTS-READ.                               
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10570000
      *   2700-BUILD-WK-QUEUES                                       ** 10580000
      * THE SUBMODULES WILL PLACE MOST OF THEIR ERRORS INTO A WORK   ** 10590000
      * QUEUE AREA IN CWS10000. THIS DRIVER PROGRAM WILL AT THE END  ** 10600000
      * OF AN ACCOUNT WILL READ ALL OF THE WORK QUEUE ITEMS, WRITE   ** 10610000
      * THEM TO THE DATABASE, AND THEN CLEAR THE CWS10000 WQ AREA.   ** 10620000
      ***************************************************************** 10630000
                                                                        
       2700-BUILD-WK-QUEUES.                                            
                                                                        
           PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1                  
                   UNTIL WS-BILL-WQ-INDX > 50                           
                      OR WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = ZERO     
A04860        INITIALIZE CWS00077-FIELDS                                
              MOVE WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)                  
A04860                                TO WS-77-CATEGORY-ID              
              MOVE WS-PRIORITY-WF (WS-BILL-WQ-INDX)                     
A04860                                TO WS-77-PRIORITY                 
              MOVE WS-ROUTE-CATEGORY-WF (WS-BILL-WQ-INDX)               
A04860                                TO WS-77-ROUTE-CATEGORY           
              MOVE WS-COMMENTS-WF (WS-BILL-WQ-INDX)                     
A04860                                TO WS-77-COMMENTS                 
A04860        MOVE ZERO               TO WS-77-SERV-ORDER-NO            
A04860        MOVE LS-INPUT-DATE      TO WS-77-DATE-REQUIRED            
A04860        MOVE WS-ACCOUNT-NO-AT   TO WS-77-ACCOUNT-NO               
A04860        MOVE WS-PREMISE-NO-AT   TO WS-77-PREMISE-NO               
A04860        MOVE WS-CUSTOMER-NO-AT  TO WS-77-CUSTOMER-NO              
A04860        MOVE SPACES             TO WS-77-RESP-AREA-ID             
A04860        MOVE WS-LOCAL-OFFICE-AT TO WS-77-LOCAL-OFFICE             
A04860        MOVE ZERO               TO WS-77-FREE-FORM-LEN            
A04860        MOVE LOW-VALUES         TO WS-77-FREE-FORM-TXT            
A04860        MOVE WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
                                      TO WS-77-CREATED-BY               
              PERFORM 8895-INSERT-WORK-QUEUE      THRU 8895-EXIT        
           END-PERFORM.                                                 
           MOVE SPACES                TO WS-BILLING-WQ-ITEMS-WF.        
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2710-GENERATE-WQ.                                                
           ADD 1 TO WS-NUM-ACCOUNTS-WRITTEN                             
           ADD 1 TO WS-BYPASS-CTR                                       
           IF WS-BYPASS-CTR > 500                                       
             DISPLAY 'MORE THAN 500 ACCOUNTS BYPASSED'                  
             DISPLAY 'WHAT THE HECK DID YOU DO?'                        
             MOVE WS-SCSCA-RETURN-CODE TO WS-STORE-RETURN-CODE          
             PERFORM 9900-ABEND THRU 9900-EXIT                          
           ELSE                                                         
             ADD 1 TO LS-CURR-WQ-ITEM                                   
             SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                     
             DISPLAY '******* ACCOUNT BYPASSED *******'                 
             STRING WS-BYPASS-MSG-LITERAL                               
                    WS-BYPASS-INFO                                      
                    DELIMITED BY SIZE                                   
                    INTO WS-BYPASS-MSG-TEXT                             
             MOVE WS-ACCOUNT-BYPASS-MSG TO                              
                WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
T37389       IF WS-WQ-INS-SW = 'Y'                                      
                PERFORM 2700-BUILD-WK-QUEUES THRU 2700-EXIT             
T37389       END-IF                                                     
             MOVE 0 TO WS-SCSCA-RETURN-CODE                             
             GO TO 2000-EXIT                                            
           END-IF.                                                      
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 11220000
      *    3000-WRITE-EXTRACTS                                       ** 11230000
      * THIS WILL WRITE OUT THE UPDATED BE38 DATA. THE OUTPUT FILE   ** 11240000
      * WILL HAVE THE CWS10000, CWS10001, AND CWS10009 ALL IN THE ONE** 11250000
      * FILE.  CHECK THE TA TABLE TO SEE IF THIS IS AN EDI ACCOUNT.  ** 11260000
      * IF SO, CREATE A CA24 RECORD AND BYPASS OTHER OUTPUT PROCESS. ** 11270000
      ***************************************************************** 11280000
                                                                        
       3000-WRITE-EXTRACTS.                                             
                                                                        
           MOVE 0 TO WS-CONSO-CNTR                                      
           PERFORM 8000-WRITE-CWS-VALUES      THRU 8000-EXIT.           
T37389     IF WS-WQ-INS-SW = 'Y'                                        
              PERFORM 2700-BUILD-WK-QUEUES    THRU 2700-EXIT            
T37389     END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  11410000
      * OPEN THE OUTPUT FILE TO WRITE THE RECORDS INTO THE *            11420000
      *      BEXX FILE *                                                11430000
      ****************************************************************  11440000
                                                                        
       3100-OPEN-WRITE-BEGIN-REC.                                       
                                                                        
           OPEN OUTPUT FCSCA31-FILE.                                    
           IF NOT FCA31-SUCCESSFUL                                      
              DISPLAY '3100-ERROR ON FCSCA31 OPEN.  STATUS IS '         
                       WS-FCA31-STATUS                                  
              PERFORM 9900-ABEND           THRU 9900-EXIT
           END-IF.              
                                                                        
           OPEN OUTPUT FCSBE32-FILE.                                    
           IF NOT FBE32-SUCCESSFUL                                      
              DISPLAY '3100-ERROR ON FCSBE32 OPEN.  STATUS IS '         
                       WS-FBE32-STATUS                                  
              PERFORM 9900-ABEND           THRU 9900-EXIT
           END-IF.              
                                                                        
           PERFORM 5100-WRITE-BEGIN-CONTROLS  THRU 5100-EXIT.           
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11650000
      *    3505-CALL-FETCH-GROUP2.                                    **11660000
      * THIS WILL CALL PROGRAM SCSCA195 TO GET THE VALUES FOR GROUP2 ** 11670000
      * FIELDS.                                                      ** 11680000
      ***************************************************************** 11690000
                                                                        
       3505-CALL-FETCH-GROUP2.                                          
                                                                        
           IF WS-SCSCA195-SW = 'Y'                                      
              GO TO 3505-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE SPACES     TO    WS-CA195-OPTION-CODE.                  
           CALL SCSCA195   USING WS-CA195-GRP2-FIELDS                   
                                 WS-BILLING-BG                          
                                 WS-BILL-DET-BT                         
                                 WS-FIXED-FCTR-HIST-FH                  
                                 WS-ACCOUNT-AT                          
                                 WS-BILL-CALC-DETAIL                    
                                 WS-ACCT-RTPK-AGR-DF                    
                                 WS-BILL-ADJUST-DETAIL                  
                                 WS-ACCT-ATTRIBUTE-YP                   
                                 WS-ACCT-MKT-TIER-DD                    
                                 CWS00328-FIELDS                        
I00177                           WS-SCSCA-RETURN-CODE                   
I00177                           WS-CWS1000B-MAX-TBL-LIMITS.            
                                                                        
           IF WS-SCSCA-RETURN-CODE > 7                                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
             IF WS-SCSCA-RETURN-CODE > 0                                
                DISPLAY 'INVALID RETURN CODE FROM SCSCA195 ' RETURN-CODE
                MOVE 'Y' TO WS-SCSCA-WQ-CREATED-SW                      
                MOVE 'SCSCA195' TO WS-BYPASS-INFO                       
                PERFORM 2710-GENERATE-WQ THRU 2710-EXIT                 
             END-IF                                                     
           END-IF.                                                      
                                                                        
       3505-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 12050000
      *    3510-CALL-AUDIT-TRANS.                                    ** 12060000
      * THIS WILL CALL PROGRAM SCSCA187 TO SELECT THE ACCOUNTS AND   ** 12070000
      * BILLS TO PROCESS FOR THE COMPANY TO DO AUDITS ON SPECIAL     ** 12080000
      * TRANSACTIONS THAT ARE ENTERED ON A USER TABLE.               ** 12090000
      ***************************************************************** 12100000
                                                                        
       3510-CALL-AUDIT-TRANS.                                           
                                                                        
           DISPLAY 'CALLING SCSCA187 FROM PCSCA905'.                    
                                                                        
           CALL SCSCA187   USING WS-ACCOUNT-AT                          
                                 WS-BILLING-BI                          
                                 WS-BILLING-BG                          
                                 WS-BILL-CALC-DETAIL                    
                                 WS-BILL-ADJUST-DETAIL                  
                                 WS-AR-CNTRL-AC                         
T28349                           WS-CUST-STATS-CE                       
                                 WS-TRANS-HIST-AR                       
                                 WS-TRN-HST-DET-AU                      
                                 WS-TRANS-HIST-MH                       
                                 WS-CONTRACT-CT                         
                                 WS-BUDGET-PLAN-BU                      
T33634                           WS-12-MONTH-DATA-EPP                   
                                 WS-DFA-ACCT-DA                         
                                 WS-DEP-ON-HAND-DO                      
                                 WS-MISC-BILL-INFO                      
                                 WS-BILLING-WQ-ITEMS-WF                 
                                 LS-PCSCA100-COMM-AREA                  
                                 WS-SCSCA-RETURN-CODE                   
                                 WS-WQ-CREATED-SW                       
T30989                           WS-CNSMPTN-HIST-CX                     
                                 WS-AUDIT-BILL-PRINT-CRITERIA           
                                 WS-AUDIT-CONDITIONS                    
T33542                           WS-INSERT-BILL-CYCLE                   
T33542                           WS-INSERT-REVENUE-MONTH                
                                 WS-NAME-ADDRESS                        
I00177                           WS-CA195-GRP2-FIELDS                   
I00177                           WS-CWS1000B-MAX-TBL-LIMITS             
P00599                           WS-PREPAY-HIST-PK                      
P00599                           WS-BILL-CRED-DET-1H                    
P00680                           WS-ACCT-RTPK-AGR-DF                    
P00680                           WS-UTILITY-TABLE-UT                    
ACT055                           WS-ACCT-MKT-TIER-DD                    
ACT055                           WS-FIXED-FCTR-HIST-FH.                 
                                                                        
           IF WS-WQ-CREATED-SW = 'Y'                                    
               MOVE 'Y' TO WS-SCSCA-WQ-CREATED-SW
           END-IF.                      
                                                                        
           IF WS-SCSCA-RETURN-CODE > 1                                  
              MOVE 'SCSCA187' TO WS-BYPASS-INFO                         
              PERFORM 2710-GENERATE-WQ THRU 2710-EXIT                   
           END-IF.                                                      
                                                                        
       3510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12580000
      *    3520-CALL-TRANS-HISTORY.                                  ** 12590000
T35152* THIS WILL CALL PROGRAM SCSCA167 TO GET THE TRANSACTION       ** 12600000
      * HISTORY RECORDS THAT ARE NEEDED FOR PRINT BUT ARE NOT ALREADY** 12610000
      * ON THE CWS10000 TYPE FILE.                                   ** 12620000
      ***************************************************************** 12630000
                                                                        
       3520-CALL-TRANS-HISTORY.                                         
                                                                        
T35152     DISPLAY 'CALLING SCSCA167 FROM PCSCA905'.                    
                                                                        
T35152     CALL SCSCA167   USING LS-PCSCA100-COMM-AREA                  
                                 WS-SCSCA-RETURN-CODE                   
                                 WS-WQ-CREATED-SW                       
                                 WS-PREMISE-PR                          
                                 WS-CUSTOMER-CU                         
                                 WS-ACCOUNT-AT                          
                                 WS-BILLING-BI                          
                                 WS-BILLING-BG                          
                                 WS-BILL-CALC-DETAIL                    
                                 WS-BILL-ADJUST-DETAIL                  
                                 WS-CNSMPTN-HIST-CX                     
                                 WS-UNMTRD-CNSMPTN-UC                   
                                 WS-FIXED-FCTR-HIST-FH                  
                                 WS-BILL-CONTRACT-BK                    
                                 WS-CUST-PLAN-TABLE-CP                  
                                 WS-FIXED-FCTR-TABLE-FF                 
                                 WS-BILL-CNTR-HIST-BX                   
                                 WS-AR-CNTRL-AC                         
                                 WS-BUDGET-PLAN-BU                      
                                 WS-PEAK-HIST-PH                        
                                 WS-INTERRUPT-ACCT-IP                   
                                 WS-INTERRUPT-IR                        
                                 WS-UTILITY-TABLE-UT                    
                                 WS-REGISTER-READ-TABLE-RG              
                                 WS-MTRD-ENVRNMT-TABLE-MN               
                                 WS-MTR-CAP-TABLE-MC                    
                                 WS-BILLING-WQ-ITEMS-WF                 
                                 WS-12-MONTH-DATA-EPP                   
                                 WS-RATE-COMPARE-RC                     
                                 WS-STANDBY-GEN-SE                      
                                 WS-TRANS-HIST-AR                       
                                 WS-TRN-HST-DET-AU                      
                                 WS-TRANS-HIST-MH                       
TPRDPP                           WS-MISC-BILL-INFO                      
TPRDPP                           WS-DFA-ACCT-DA                         
P00453                           WS-PLAN-ANN-INFO                       
                                 WS-PRINT-RUN-DATE                      
                                 WS-REFUND-RN                           
                                 WS-GL-NAME-TABLE                       
T20383                           WS-CONTRACT-CT                         
                                 WS-ADJ-REASON-TABLE                    
                                 WS-BILL-ADJUSTMNT                      
T35152                           WS-BILL-DET-BT                         
I00177                           WS-DEP-REQ-DR                          
P00453                           WS-PREPAY-HIST-PK                      
P00496                           WS-BILL-BSLN-CNTR-LN                   
P00496                           WS-BILL-BSLN-HIST-LO                   
P00496                           WS-UTL-BILL-REL-TABLE-UR               
P00496                           WS-INTERRUPT-NZ                        
P00496                           WS-CNSMPTN-HOURLY                      
I00177                           WS-CWS1000B-MAX-TBL-LIMITS.            
                                                                        
           IF WS-WQ-CREATED-SW = 'Y'                                    
               MOVE 'Y' TO WS-SCSCA-WQ-CREATED-SW
           END-IF.                      
                                                                        
           IF WS-SCSCA-RETURN-CODE > 1                                  
T35152        MOVE 'SCSCA167' TO WS-BYPASS-INFO                         
              PERFORM 2710-GENERATE-WQ THRU 2710-EXIT                   
           END-IF.                                                      
                                                                        
       3520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3549-CALL-DELIQUENCY.                                            
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY                                  
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'C8' TO WS-DB2-TABLE-ID                             
               MOVE 'OPEN' TO WS-DB2-FUNCTION                           
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '905' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '*** IN 3549 CALL DELIQUENCY ***'                
               DISPLAY '*** SQL CODE    = ' SQLCODE                     
               DISPLAY '*** ACCT NO     = ' WS-ACCOUNT-NO-AT            
               DISPLAY '*** DELINQ CODE = ' C8-DELINQ-CD                
               DISPLAY '*** COMPANY NO  = ' C8-COMPANY-NO               
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       3549-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 13570000
      *    3550-CALL-INSERT-MARKER.                                  ** 13580000
      * THIS WILL CALL PROGRAM SCSCA159 TO PROCESS THE INSERTS THAT  ** 13590000
      * WILL BE PUT INTO THE ENVELOPE WITH THE BILL.                 ** 13600000
      ***************************************************************** 13610000
                                                                        
       3550-CALL-INSERT-MARKER.                                         
                                                                        
P00587     PERFORM 3552-DETERMINE-INITIAL-BILL THRU 3552-EXIT.          
P00587                                                                  
P00587     IF SEB-DATABASE                                              
              MOVE WS-ACCOUNT-NO-AT TO WS-CA195-HOLD-ACCOUNT-NO         
              MOVE 'PCSCA905'       TO WS-CA195-PROG-NAME               
BILLRD        PERFORM 3505-CALL-FETCH-GROUP2     THRU 3505-EXIT         
BILLRD        MOVE 'Y'              TO WS-SCSCA195-SW                   
P00587     END-IF.                                                      
                                                                        
           DISPLAY 'CALLING SCSCA159 FROM PCSCA905'.                    
                                                                        
T29120     CALL SCSCA159 USING   WS-PREMISE-PR                          
T29120                           WS-ACCOUNT-AT                          
                                 WS-BILLING-BI                          
                                 WS-BILLING-BG                          
C24343                           WS-CONTRACT-CT                         
                                 WS-AR-CNTRL-AC                         
                                 WS-BUDGET-PLAN-BU                      
T5677                            WS-PROJECT-SHARE-PJ                    
                                 WS-MISC-BILL-INFO                      
                                 WS-NAME-ADDRESS                        
                                 WS-BANK-EFT-BE                         
                                 LS-PCSCA100-COMM-AREA                  
                                 WS-SCSCA-RETURN-CODE                   
                                 WS-WQ-CREATED-SW                       
                                 WS-BILLING-WQ-ITEMS-WF                 
I00177                           WS-UTILITY-TABLE-UT                    
A01096                           WS-CUST-STATS-CE                       
A02518                           WS-UNMTRD-CNSMPTN-UC                   
A03313                           WS-ADDR-FREEFORM-DZ                    
A03313                           WS-ADDR-FORMATTED-DY                   
I00177                           WS-CWS1000B-MAX-TBL-LIMITS             
P00587                           WS-FIXED-FCTR-HIST-FH                  
P00587                           WS-BILL-DET-BT                         
P00587                           WS-CA195-GRP2-FIELDS                   
P00587                           WS-ACCT-MKT-TIER-DD                    
P00587                           WS-CNSMPTN-HIST-CX                     
P00587                           WS-CREDIT-PROFILE-CZ                   
P00587                           WS-ACCT-RTPK-AGR-DF                    
P00587                           WS-BI-FIXED-FCTR-FF                    
P00587                           WS-INITIAL-FLAG                        
P00587                           WS-EXTRM-RCB-REC.                      
                                                                        
           IF WS-WQ-CREATED-SW = 'Y'                                    
               MOVE 'Y' TO WS-SCSCA-WQ-CREATED-SW
           END-IF.                      
                                                                        
           IF WS-SCSCA-RETURN-CODE > 1                                  
              MOVE 'SCSCA159' TO WS-BYPASS-INFO                         
              PERFORM 2710-GENERATE-WQ THRU 2710-EXIT                   
           END-IF.                                                      
                                                                        
       3550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3552-DETERMINE-INITIAL-BILL.                                     
                                                                        
           MOVE 1 TO WS-CAN-REB-SUB.                                    
           MOVE 0 TO WS-NO-OF-REBILLS.                                  
           MOVE SPACES TO WS-INITIAL-FLAG                               
                          WS-INITIAL-BILL-SWITCH                        
                          WS-TEMP-CAN-REB-FLAG.                         
           MOVE HIGH-VALUES TO WS-REBILL-DATE-EARLIEST                  
           PERFORM UNTIL WS-CAN-REB-SUB > 30                            
               MOVE WS-DATE-ORIG-BILL-BG (WS-CAN-REB-SUB) TO            
                WS-REBILL-DATE-TEMP                                     
               IF WS-REBILL-DATE-TEMP NOT EQUAL TO LOW-VALUES AND       
                  WS-REBILL-DATE-TEMP NOT EQUAL TO SPACES               
                   MOVE 'Y' TO WS-TEMP-CAN-REB-FLAG                     
                   IF WS-REBILL-DATE-TEMP < WS-REBILL-DATE-EARLIEST     
                       MOVE WS-REBILL-DATE-TEMP TO                      
                            WS-REBILL-DATE-EARLIEST                     
                       ADD 1 TO WS-NO-OF-REBILLS                        
                   ELSE                                                 
                       IF WS-REBILL-DATE-TEMP = WS-REBILL-DATE-EARLIEST 
                           CONTINUE                                     
                       ELSE                                             
                           ADD 1 TO WS-NO-OF-REBILLS                    
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               ADD 1 TO WS-CAN-REB-SUB                                  
           END-PERFORM.                                                 
           IF WS-NO-OF-REBILLS <= 1                                     
               SET CHECK-FOR-INITIAL TO TRUE                            
           ELSE                                                         
               SET NO-CHECK-FOR-INITIAL TO TRUE                         
           END-IF.                                                      
           IF WS-NO-OF-REBILLS = 0 MOVE 'N' TO WS-TEMP-CAN-REB-FLAG
           END-IF.    
           EVALUATE WS-TEMP-CAN-REB-FLAG                                
               WHEN 'Y'                                                 
                   IF CHECK-FOR-INITIAL                                 
                       PERFORM 3553-CHECK-CR-INITIAL THRU 3553-EXIT     
                   ELSE                                                 
                       CONTINUE                                         
                   END-IF                                               
               WHEN 'N'                                                 
                   PERFORM 3554-CHECK-FOR-INITIAL THRU 3554-EXIT        
                   IF WS-NO-OF-BILLS = 1                                
                       SET INITIAL-BILL TO TRUE                         
                   END-IF                                               
           END-EVALUATE.                                                
       3552-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3553-CHECK-CR-INITIAL.                                           
           MOVE WS-ACCOUNT-NO-AT TO WS-ACCOUNT-NO-TEMP.                 
           EXEC SQL                                                     
               SELECT BILL_NO                                           
               INTO :WS-TEMP-BILL-NO                                    
               FROM CSS_BILLING_HDR                                     
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-TEMP                   
                 AND DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                               :WS-REBILL-DATE-EARLIEST
              ) IS NULL OR (PATINDEX('%.%', :WS-REBILL-DATE-EARLIEST
              ) <> 0) OR (LEN(:WS-REBILL-DATE-EARLIEST
              ) <> 10), CIS.CHAR2DATE(:WS-REBILL-DATE-EARLIEST
              ), CONVERT(DATE, :WS-REBILL-DATE-EARLIEST) )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14730000
MFA-TR*        SELECT BILL_NO                                           14740000
MFA-TR*        INTO :WS-TEMP-BILL-NO                                    14750000
MFA-TR*        FROM CSS_BILLING_HDR                                     14760000
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-TEMP                   14770000
MFA-TR*          AND DATE_BILLED = :WS-REBILL-DATE-EARLIEST             14780000
MFA-TR*    END-EXEC.                                                    14790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'BI' TO WS-DB2-TABLE-ID                             
               MOVE 'SELECT' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '905' TO WS-DB2-MODULE-ID                           
               MOVE '3553' TO WS-DB2-PARAGRAPH                          
               MOVE WS-ACCOUNT-NO-AT TO WS-DB2-KEY-1                    
               MOVE 12 TO RETURN-CODE                                   
           END-IF.                                                      
           IF WS-TEMP-BILL-NO = 1 AND                                   
              WS-NO-OF-REBILLS = 1                                      
               SET CANCEL-REBILL-INITIAL TO TRUE                        
           END-IF.                                                      
       3553-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3554-CHECK-FOR-INITIAL.                                          
           MOVE WS-ACCOUNT-NO-AT TO WS-ACCOUNT-NO-TEMP.                 
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
               INTO :WS-NO-OF-BILLS                                     
               FROM CSS_BILLING_HDR                                     
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-TEMP                   
                 AND DATE_BILLED IS NOT NULL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'BI' TO WS-DB2-TABLE-ID                             
               MOVE 'COUNT' TO WS-DB2-FUNCTION                          
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '905' TO WS-DB2-MODULE-ID                           
               MOVE '3554' TO WS-DB2-PARAGRAPH                          
               MOVE WS-ACCOUNT-NO-AT TO WS-DB2-KEY-1                    
               MOVE 12 TO RETURN-CODE                                   
           END-IF.                                                      
       3554-EXIT.                                                       
           EXIT.                                                        
                                                                        
T37389***************************************************************** 15400000
T37389*    3570-CALL-SKIP-ACCTS                                      ** 15410000
T37389* THIS WILL CALL PROGRAM SCSCA151 TO ACCOMPLISH THE FOLLOWING.  * 15420000
T37389* 1. AT FIRST CALL LOAD ALL THE ACCOUNTS THAT SHOULD GET SKIPPED* 15430000
T37389*    FROM OMITACCT FILE.                                        * 15440000
T37389* 2. AT ACCOUNT LEVEL CALLS THIS SUB PROGRAM WILL CHECK IF THE  * 15450000
T37389*    ACCOUNT NEED TO GET SKIPPED FROM BILL PRINT.               * 15460000
T37389***************************************************************** 15470000
T37389                                                                  
T37389 3570-CALL-SKIP-ACCTS.                                            
T37389                                                                  
T37389     DISPLAY 'CALLING SCSCA151 FROM PCSCA905'.                    
T37389                                                                  
T37389     CALL SCSCA151 USING   WS-SCSCA151-PARMS                      
T37389                           WS-SCSCA-RETURN-CODE.                  
T37389                                                                  
T37389     IF WS-SCSCA-RETURN-CODE > 1                                  
T37389        MOVE 'SCSCA151'             TO WS-BYPASS-INFO             
T37389        PERFORM 9900-ABEND            THRU 9900-EXIT              
T37389     END-IF.                                                      
T37389                                                                  
T37389 3570-EXIT.                                                       
T37389     EXIT.                                                        
T37389                                                                  
      *                                                                 15890000
       3800-ERROR-HANDLING.                                             
                                                                        
           IF WS-NO-BILL-COPIES-AT > 1                                  
              IF WS-MST-SUB-ACCT-IND-AT = 'M' OR 'S'                    
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'C' TO WS-BILL-DEST-CODE                          
                 MOVE 'D' TO WS-SYSTEM-CNTRL-CODE                       
              END-IF                                                    
           END-IF.                                                      
           EVALUATE WS-CODE-TEMP-BILL-AT                                
               WHEN 'A'                                                 
               WHEN ' '                                                 
               WHEN LOW-VALUES                                          
                    CONTINUE                                            
               WHEN '~'                                                 
               WHEN '@'                                                 
               WHEN '%'                                                 
               WHEN '&'                                                 
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE WS-CODE-TEMP-BILL-AT TO WS-SYSTEM-CNTRL-CODE   
               WHEN '#'                                                 
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE '#'                  TO WS-SYSTEM-CNTRL-CODE   
P00246         WHEN 'O'                                                 
P00246              MOVE WS-CODE-P-BILL-DEST-AT TO WS-BILL-DEST-CODE    
P00246              MOVE WS-CODE-TEMP-BILL-AT TO WS-SYSTEM-CNTRL-CODE   
A01292         WHEN 'B'                                                 
A01292              MOVE 'H'                  TO WS-BILL-DEST-CODE      
A01292              MOVE WS-CODE-TEMP-BILL-AT TO WS-SYSTEM-CNTRL-CODE   
A04527         WHEN 'Z'                                                 
A04527              MOVE 'H'                  TO WS-BILL-DEST-CODE      
A04527              MOVE WS-CODE-TEMP-BILL-AT TO WS-SYSTEM-CNTRL-CODE   
               WHEN OTHER                                               
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE 'T'                  TO WS-SYSTEM-CNTRL-CODE   
           END-EVALUATE.                                                
           EVALUATE WS-CODE-PERM-BILL-AT                                
               WHEN 'A'                                                 
               WHEN ' '                                                 
               WHEN LOW-VALUES                                          
                    CONTINUE                                            
               WHEN '~'                                                 
               WHEN '@'                                                 
               WHEN '%'                                                 
               WHEN '&'                                                 
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE WS-CODE-PERM-BILL-AT TO WS-SYSTEM-CNTRL-CODE   
A02499         WHEN 'B'                                                 
A02499              MOVE 'C'                  TO WS-BILL-DEST-CODE      
A02499              MOVE '3'                  TO WS-SYSTEM-CNTRL-CODE   
               WHEN 'D'                                                 
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE 'I'                  TO WS-SYSTEM-CNTRL-CODE   
               WHEN OTHER                                               
                    MOVE 'C'                  TO WS-BILL-DEST-CODE      
                    MOVE 'P'                  TO WS-SYSTEM-CNTRL-CODE   
           END-EVALUATE.                                                
A03964     IF WS-BANKRUPTCY-IND-AT = 'B'                                
A03964         MOVE 'C'                  TO WS-BILL-DEST-CODE           
A03964         MOVE '3'                  TO WS-SYSTEM-CNTRL-CODE        
A03964     END-IF.                                                      
                                                                        
       3800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 17290000
      *    5100-WRITE-BEGIN-CONTROLS.                                ** 17300000
      * WRITE THE BEGINNING CONTROL RECORDS TO ALL OUTPUT FILES.     ** 17310000
      ***************************************************************** 17320000
                                                                        
       5100-WRITE-BEGIN-CONTROLS.                                       
                                                                        
           MOVE WS-YES                TO WS-CNTRL-REC-FLAG.             
           MOVE LOW-VALUES            TO E-FCA31-KEY-BREC.              
           MOVE WS-PART-BREC-HOLD     TO E-FCA31-DB-PART-BREC.          
           MOVE WS-INPUT-DATE         TO                                
                                     E-FCA31-CREATE-DATE-BREC.          
           PERFORM 8900-WRITE-FCSCA31         THRU 8900-EXIT.           
           MOVE SPACES                TO FIOCA31.                       
                                                                        
           MOVE WS-YES                TO WS-CNTRL-REC-FLAG.             
           MOVE LOW-VALUES            TO E-FBE32-KEY-BREC.              
           MOVE WS-PART-BREC-HOLD     TO E-FBE32-DB-PART-BREC.          
           MOVE WS-INPUT-DATE         TO                                
                                     E-FBE32-CREATE-DATE-BREC.          
           PERFORM 8910-WRITE-FCSBE32         THRU 8910-EXIT.           
           MOVE SPACES                TO FIOBE32.                       
                                                                        
           MOVE WS-NO                 TO WS-CNTRL-REC-FLAG.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5110-WRITE-END-CONTROLS.                                         
                                                                        
           MOVE WS-YES                TO WS-CNTRL-REC-FLAG.             
           MOVE HIGH-VALUES           TO FIOBE32-END-REC.               
           MOVE WS-PART-BREC-HOLD     TO E-FBE32-DB-PART-EREC.          
           MOVE WS-FCSBE32-CNTR       TO                                
                                 E-FBE32-RECORD-COUNT-EREC.             
           PERFORM 8910-WRITE-FCSBE32         THRU 8910-EXIT.           
                                                                        
           MOVE WS-NO                 TO WS-CNTRL-REC-FLAG.             
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************          17710000
      *   INPUT ACCOUNTS MUST EQUAL OUTPUT ACCOUNTS          *          17720000
      ********************************************************          17730000
                                                                        
       5200-VALIDATE-ACCOUNT-TOTALS.                                    
                                                                        
           IF WS-NUM-ACCOUNTS-READ NOT = WS-NUM-ACCOUNTS-WRITTEN        
                                       + WS-NUM-ACCOUNTS-SKIPPED        
T37389                                 + WS-CA151-TOT-ACCTS-OMITTED     
               MOVE WS-NUM-ACCOUNTS-READ TO WS-DISPLAY-READ             
               MOVE WS-NUM-ACCOUNTS-WRITTEN TO WS-DISPLAY-WRITTEN       
               MOVE WS-NUM-ACCOUNTS-SKIPPED TO WS-DISPLAY-SKIPPED       
T37389         MOVE WS-CA151-TOT-ACCTS-OMITTED                          
T37389                                      TO WS-DISPLAY-OMIT-ACCTS    
               DISPLAY '**************************************'         
               DISPLAY '** 5200-VALIDATE-ACCOUNT-TOTALS     **'         
               DISPLAY '** ERROR - NUMBER OF ACCOUNTS READ  **'         
               DISPLAY '** NOT = NUMBER OF ACCOUNTS WRITTEN **'         
               DISPLAY '**     + NUM OF NO DATE BI ACCTS    **'         
T37389         DISPLAY '**     + NUM OF ACCOUNTS OMITTED    **'         
               DISPLAY '**  INPUT ACCOUNTS = ' WS-DISPLAY-READ          
               DISPLAY '** OUTPUT ACCOUNTS = ' WS-DISPLAY-WRITTEN       
               DISPLAY '**NO DATE BI ACCTS = ' WS-DISPLAY-SKIPPED       
T37389         DISPLAY '**   ACCTS OMITTED = ' WS-DISPLAY-OMIT-ACCTS    
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************          18010000
      *   6240-GET-FCA00-COMMON-DATE.                        *          18020000
      ********************************************************          18030000
       COPY CPD00040.                                                   18040000
                                                                        
      ********************************************************          18060000
      * 6251-GET-FJC01-DATE.                                 *          18070000
      ********************************************************          18080000
       COPY CPD00037.                                                   18090000
      *                                                                 18100000
      ******************************************************************18110000
      *     7600-START-FCSJC01                                         *18120000
      ******************************************************************18130000
                                                                        
            EXEC SQL                                                    18150000
              INCLUDE CPD00038                                          18160000
            END-EXEC.                                                   18170000
                                                                        
      ******************************************************************18190000
      *     7620-START-FCSCA00                                         *18200000
      ******************************************************************18210000
                                                                        
            EXEC SQL                                                    18230000
              INCLUDE CPD00039                                          18240000
            END-EXEC.                                                   18250000
                                                                        
       7990-READ-FCSBE38.                                               
                                                                        
           READ FCSBE38-FILE                                            
               AT END                                                   
                   MOVE WS-Y TO WS-FCSBE38-FLAG.                        
           IF FBE38-SUCCESSFUL                                          
                 OR END-OF-FCSBE38                                      
              MOVE E-FBE38-SORT-KEY   TO E-FBE37-SORT-KEY               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7990-ERROR ON FIOBE38 READ'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      18450000
      * THIS COPY OF CPD00103 WILL MOVE THE VALUES FROM          *      18460000
      * CWS10000, CWS10001, AND CWS10009 TO THE BEXX AREA        *      18470000
      * AND DO THE PERFORM TO 8900-WRITE-FCSBE00 FOR EACH        *      18480000
      * OF THE TABLE ID'S IN THOSE CWS COPYBOOKS.                *      18490000
      ************************************************************      18500000
                                                                        
      * 8000-WRITE-CWS-VALUES                                           18520000
       COPY CPD00103.                                                   18530000
                                                                        
      ************************************************************      18550000
      * THIS IS THE PARAGRAPH THAT THE PARAGRAPHS IN CPD00103    *      18560000
      * CALLS FOR THE WRITE PROCESS TO DECIDE TO PRINT ONE FILE  *      18570000
      * OR MANY.                                                 *      18580000
      * THIS PROGRAM ONLY WRITES THE CWS INFO TO ONE FILE, CA31. *      18590000
      ************************************************************      18600000
                                                                        
       8800-WRITE-FCSBEXX.                                              
                                                                        
           MOVE WS-SERVICE-STREET  TO WS-HOLD-SERVICE-STREET            
           MOVE WS-SERVICE-OFLO    TO  WS-HOLD-SERVICE-OFLO             
           MOVE WS-SERVICE-CITY-STATE-ZIP                               
                                   TO  WS-HOLD-SERVICE-CITY-STATE-ZIP   
           MOVE WS-SERVICE-CARRIER-ROUTE                                
                                   TO WS-HOLD-SERVICE-CARRIER-ROUTE     
           MOVE WS-SERVICE-ZIPCODE TO WS-HOLD-SERVICE-ZIPCODE           
           MOVE WS-LOCATOR         TO WS-HOLD-LOCATOR                   
           IF WS-MST-SUB-ACCT-IND-AT = 'M' OR 'S'                       
              PERFORM 8810-FORMAT-FCSBE32 THRU 8810-EXIT                
           ELSE                                                         
              PERFORM 8820-FORMAT-FCSCA31 THRU 8820-EXIT                
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8810-FORMAT-FCSBE32.                                             
                                                                        
           MOVE E-FBE00-TABLE-ID        TO E-FBE32-TABLE-ID.            
           MOVE E-FBE00-DATA            TO E-FBE32-DATA.                
           MOVE WS-COMPANY-NO-AT        TO E-FBE32-COMPANY-NO.          
           MOVE WS-ACCOUNT-NO-AT        TO E-FBE32-ACCOUNT-NO.          
           MOVE WS-LOCAL-OFFICE-AT      TO E-FBE32-LOCAL-OFFICE.        
           MOVE WS-PREMISE-NO-AT        TO E-FBE32-PREMISE-NO.          
           MOVE WS-DISPLAY-DATE-READ    TO E-FBE32-DATE-BILLED.         
           IF WS-MST-SUB-ACCT-IND-AT  = 'S'                             
             MOVE WS-ACCT-XFER-TO-AT    TO E-FBE32-MST-ACCT-NO          
           ELSE                                                         
             MOVE WS-ACCOUNT-NO-AT      TO E-FBE32-MST-ACCT-NO          
           END-IF                                                       
           MOVE WS-MST-SUB-ACCT-IND-AT  TO E-FBE32-MST-SUB-IND.         
           ADD 1 TO WS-FCSBE32-CNTR                                     
           MOVE WS-CONSO-CNTR         TO E-FBE32-SORT-SUM-FLD.          
           IF E-FBE32-TABLE-ID = '0300'                                 
               ADD 1 TO WS-NUM-ACCOUNTS-WRITTEN
           END-IF.                        
           PERFORM 8910-WRITE-FCSBE32         THRU 8910-EXIT.           
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8820-FORMAT-FCSCA31.                                             
                                                                        
           MOVE E-FBE00-TABLE-ID        TO E-FCA31-TABLE-ID.            
           MOVE E-FBE00-DATA            TO E-FCA31-DATA.                
           MOVE WS-COMPANY-NO-AT        TO E-FCA31-COMPANY-NO.          
           MOVE WS-ACCOUNT-NO-AT        TO E-FCA31-ACCOUNT-NO.          
           MOVE WS-LOCAL-OFFICE-AT      TO E-FCA31-LOCAL-OFFICE.        
           MOVE WS-PREMISE-NO-AT        TO E-FCA31-PREMISE-NO.          
           MOVE WS-ACCT-XFER-TO-AT      TO E-FCA31-MST-ACCT-NO.         
           MOVE WS-MST-SUB-ACCT-IND-AT  TO E-FCA31-MST-SUB-IND.         
           MOVE WS-DISPLAY-DATE-READ    TO E-FCA31-DATE-BILLED.         
           ADD 1 TO WS-FCSCA31-CNTR.                                    
           MOVE ZERO                  TO E-FCA31-SORT-SUM-FLD.          
           IF E-FCA31-TABLE-ID = '0300'                                 
               ADD 1 TO WS-NUM-ACCOUNTS-WRITTEN
           END-IF.                        
           PERFORM 8900-WRITE-FCSCA31         THRU 8900-EXIT.           
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 19250000
      **  INSERT WORK QUEUE                                          ** 19260000
      **                                                             ** 19270000
      **  8895-INSERT-WORK-QUEUE                                     ** 19280000
      ***************************************************************** 19290000
A04860*                                                                 19300100
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                 19300300
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        DISPLAY 'WQ COMMENTS     ' WS-77-COMMENTS                 
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                 19340000
                                                                        
       8900-WRITE-FCSCA31.                                              
                                                                        
           WRITE FIOCA31.                                               
           MOVE SPACES                TO FIOCA31.                       
           IF FCA31-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8900-ERROR ON FCSCA31 WRITE.  STATUS IS '       
                        WS-FCA31-STATUS                                 
               PERFORM 9900-ABEND          THRU 9900-EXIT
           END-IF.              
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8910-WRITE-FCSBE32.                                              
                                                                        
           WRITE FIOBE32.                                               
           MOVE SPACES                TO FIOBE32.                       
           IF FBE32-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8910-ERROR ON FCSBE32 WRITE.  STATUS IS '       
                        WS-FBE32-STATUS                                 
               PERFORM 9900-ABEND          THRU 9900-EXIT
           END-IF.              
                                                                        
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************19650000
      *     9000-TERMINATE                                             *19660000
      *     CLOSE FILES                                                *19670000
      ******************************************************************19680000
                                                                        
       9000-TERMINATE.                                                  
           CLOSE FCSBE38-FILE                                           
                 FCSCA31-FILE                                           
                 FCSBE32-FILE.                                          
                                                                        
            IF RETURN-CODE = 0                                          
               MOVE WS-STORE-RETURN-CODE TO RETURN-CODE                 
            END-IF.                                                     
                                                                        
            IF WS-SCSCA-WQ-CREATED                                      
                DISPLAY '****************************************'      
                DISPLAY '****************************************'      
                DISPLAY '**  WORK QUEUE CREATED BY CALLED PGM  **'      
                DISPLAY '****************************************'      
                DISPLAY '****************************************'      
                IF RETURN-CODE = 0                                      
                   MOVE 1 TO RETURN-CODE
                END-IF
            END-IF.                               
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19900000
      ******************************************************************19910000
      *     9700-PROCESS-ABEND                                         *19920000
      *     STANDARDIZED BATCH/ONLINE ABEND COPYBOOK                   *19930000
      ******************************************************************19940000
      *                                                                 19950000
       COPY CPD0023B.                                                   19960000
      *                                                                 19970000
      ******************************************************************19980000
      *     9900-ABEND                                                 *19990000
      *     CLOSE FILES                                                *20000000
      ******************************************************************20010000
                                                                        
       9900-ABEND.                                                      
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           IF RETURN-CODE = 0 OR 1                                      
               MOVE 12 TO RETURN-CODE
           END-IF.                                  
           DISPLAY 'PCSCA905 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
