       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA901.                                          
      ***************************************************************** 00030000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00040000
      *                       PRICE WATERHOUSE                        * 00050000
      *                                                               * 00060000
      *                 CUSTOMER INFORMATION SYSTEM                   * 00070000
      *                                                               * 00080000
      ***************************************************************** 00090000
      *                 P R O G R A M   S U M M A R Y                 * 00100000
      *                                                               * 00110000
      * POPULATES THE SERVICE ADDRESSES & MAILING ADDRESSES FOR THE   * 00120000
      * MARKETING LETTERS.                                            * 00130000
      *                                                               * 00140000
      ***************************************************************** 00150000
      *                                                               * 00160000
      *               PROGRAM  MODIFICATION  LOG                      * 00170000
      *      DATE    INITIALS     REASON                              * 00180000
      *    ________  ________     __________________________________  * 00190000
      *    03/01/08     RV        INITIAL VERSION.                    * 00200000
      *    06/25/08     RV        CML 37389 REMOVE COMM TYPE SUBTYPE  * 00210000
      *                           HARDCODING.                         * 00220000
T37389*    07/10/08     SV82012   INCLUDE COPYBOOK FOR SCSCA184.      * 00230000
T37454*    07/10/08     RV97439   POPULATE NUMBER OF GOOD PAYMENTS TO * 00240000
T37454*                           EXT-MKTG-NUM-VARIABLE-1.            * 00250000
T37389*    08/10/08     DB41297   ADD OMR MARK FOR 30 DAY LETTERS TO  * 00260000
T37389*                           INSERT RETURN ENVELOPES.            * 00270000
T37389*    08/11/08     RV97439   Exceptional File Included To Write  * 00280000
T37389*                           Accounts With Invalid Name/Address. * 00290000
I00237*    01/20/09     RV97439   ORANGE CHANGES FOR REGULATED.       * 00300000
      *                                                               * 00310000
A00864*   1 MAR 2009    RF10596   INITIALIZE WS-INSERT-MARK TO '0'.   * 00320000
      *                                                               * 00330000
I00525*    05/11/09     SDHAL     Remove insert marks for Welcome kit * 00340000
I00525*                           (Dereg only)                        * 00350000
A00890*    06/29/09     DMS       CHANGES TO STANDARDIZE LENGTH OF    * 00360000
A00890*                           SERVICE ADDRESS FIELDS TO 50.       * 00370000
PRJ172*    07/10/09     RAJ       REGULATED PROVIDER TRANSITION.      * 00380000
PRJ211*    12/2009      ALEX      EARLY RENEWEAL (30 Days - 2 months  * 00390000
PRJ211*                           remaining letters                   * 00400000
A01440*    10/03/09     MS93554   MADE  CHANGES TO ACCEPT THE PARM    * 00410000
A01440*                           FROM THE JCL.                       * 00420000
PRJ166*    01/12/10     CVNS      CALL SCSCA165 TO GET UNIQUE         * 00430000
PRJ166*                           IDENTIFIER AND WRITE TO OUTPUT FILE * 00440000
PRJ166*    02/03/10     SV        DO NOT CALL SCSCA165 FOR WELCOME KITS 00450000
PRJ245*    01/2010      SDHAL     RATE CHANGE LETTER                  * 00460000
PRJ172*    04/14/10     RAJ       REGULATED PROVIDER.                 * 00470000
PRJ396*    08/2010      ST        18 month rate plan project          * 00480000
PRJ396*    09/2010      RAJ       18 month rate plan project          * 00490000
A03063*    06/2010      EH        Allow welcome kits goet UID         * 00500000
P00453*    06/2011      RAJ       Scana Energy Prepay.                * 00510000
P00581*    11/2011      RAJ,SDHAL SEB Exit fee change.                * 00520000
A04106*    04/2012      RAJ       ADD RETENTION OFFER DETAILS TO      * 00530000
A04106*                           RENEWAL OPTION LETTER.              * 00540000
P00680*    06/2012      RAJ       SCANA ENERGY RETENTION & ACQUISTION.* 00550000
A04730*    09/2013      ERIC      ADDED CODE TO IDENTIFY FLEX RATE    * 00560000
A04730*                           CUSTOMERS WITH INCENTIVES.          * 00570000
P00805*    02/2014      DMS       EXTENDED RENEWAL                    * 00580000
P00805*    03/2014      DMS       ADD NEW 25 DAY PENDING OPTION LETTER* 00590000
P00805*    04/2014      DMS       REMOVE RTN ENV OMR MARK FOR 10210   * 00600000
A05037*    11/2014      ESM       TRANSPORTATION FEE CHANGES          * 00610000
A04127*    01/16/15     SV95326   ADD WS-ALOC-ITPA-PROCESS PARAMETER  * 00611000
      *                           WHILE CALLING SCSCA184              * 00612000
P00892*    05/2015      ESM       FIXED RATE AUTO RENEWAL             * 00620000
P805CS*    03/2016      DMS       P00805 - CSC INCREASE               * 00621000
P00805*    08/2016      ESM       NEW RATE DATE FOR OUTER POOL        * 00622000
A05752*    02/08/17     SV95326   FIX FOR VARIABLE RATE CHANGE LETTER * 00623000
A05752*                 ACT002    OUTER POOL DROP MESSAGE FLAG .      * 00624000
      ***************************************************************** 00630000
      *                                                               * 00640000
      *         -----    BASIC SEQUENCE STRUCTURE   -----             * 00650000
      * 0000         MODULE CONTROL                                   * 00660000
      * 0100 - 0999  INITIALIZATION                                   * 00670000
      * 1000 - 1999  FUNCTIONAL CONTROL                               * 00680000
      * 2000 - 4999  DETAIL LOGIC                                     * 00690000
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               * 00700000
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     * 00710000
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    * 00720000
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    * 00730000
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          * 00740000
      *                                                               * 00750000
      ***************************************************************** 00760000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00780000
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00800000
       FILE-CONTROL.                                                    
       COPY CSSCA916.                                                   00820000
       COPY CSSCA901.                                                   00830000
T37389 COPY CSSCAEXP.                                                   00840000
HPCCDM*    EJECT                                                        00850000
      *                                                                 00860000
       DATA DIVISION.                                                   
      *                                                                 00880000
       FILE SECTION.                                                    
      *                                                                 00900000
       COPY CFDCA916.                                                   00910000
       COPY FIOCA916.                                                   00920000
       COPY CFDCA901.                                                   00930000
       COPY FIOCA901.                                                   00940000
T37389 COPY CFDCAEXP.                                                   00950000
T37389 01  FIOEXCP.                                                     
T37389     05  FIOEXCP-DATA              PIC X(1746) VALUE SPACES.      
      *                                                                 00980000
HPCCDM*EJECT                                                            00990000
      *                                                                 01000000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA901'.
MSQ017     COPY MFASQLM.
      *                                                                 01020000
       01  WS-NAME-ADDR-TABLE.                                          
           05  WS-NAME-ADDR-ENTRY         OCCURS 6                      
                                         INDEXED BY WS-NM-ADDR-INDX.    
               10 WS-NAME-ADDR-TYPE       PIC X(02).                    
               10 WS-NAME-ADDR-LINE       PIC X(50).                    
      *                                                                 01080000
       01  WS-LITERALS.                                                 
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
      *                                                                 01120000
       01  WS-PROG-MISC.                                                
           05  WS-FCA901-STATUS          PIC X(02).                     
               88  CA901-SUCCESSFUL        VALUE '00'.                  
T37389     05  WS-FCAEXP-STATUS          PIC X(02).                     
T37389         88  CAEXP-SUCCESSFUL        VALUE '00'.                  
           05  WS-FCA916-STATUS          PIC X(02).                     
               88  CA916-SUCCESSFUL        VALUE '00'.                  
           05  WS-END-OF-CA916           PIC X VALUE 'N'.               
               88  END-OF-CA916            VALUE 'Y'.                   
                                                                        
           05  WS-EOJ-CODE               PIC S9999    VALUE +0 COMP.    
           05  WS-REC-CNT                PIC 9(9)  VALUE 0.             
           05  WS-REC-WRITTEN            PIC 9(9)  VALUE 0.             
T37389     05  WS-REC-SKIPPED            PIC 9(9)  VALUE 0.             
           05  WS-RED-FL-NULL-IND        PIC S9(4) COMP  VALUE 0.       
           05  WS-NULL-IND1                PIC S9(04) COMP VALUE 0.     
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
                                                                        
           05  HOLD-ACCOUNT-NO          PIC X(13).                      
           05  HOLD-CUSTOMER-NO         PIC X(10).                      
           05  HOLD-MAIL-ADDRESS.                                       
               10  HOLD-MAILING-ADDRESS PIC X(50) OCCURS 6.             
                                                                        
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN   PIC S9(4) USAGE COMP.     
               10 WS-INITIAL-COMMENT-TX-TEXT  PIC X(255).               
           05  WS-TIMESTAMP             PIC X(26) VALUE SPACES.         
           05  WS-END-NULL-IND          PIC S9(4) COMP  VALUE 0.        
           05  SCSCA184                 PIC  X(08) VALUE 'SCSCA184'.    
PRJ166     05  SCSCA165                 PIC  X(08) VALUE 'SCSCA165'.    
           05  WS-DISPLAY-SCSCA         PIC X(08).                      
           05  WS-SUB                   PIC 9(01)  VALUE ZEROS.         
           05  WS-SUB1                  PIC 9(01)  VALUE ZEROS.         
           05  WS-ACCOUNT-NO-TEMP.                                      
               10 ACCOUNT-NO-TEMP       PIC X(13).                      
               10 ACCOUNT-NO-TEMP-1     PIC X(12).                      
           05  WS-MAIL-ADDR-LINES.                                      
               10  WS-MAIL-ADDR-LINE-1      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-2      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-3      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-4      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-5      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-6      PIC X(50).                  
           05  WS-OMR-COUNT                 PIC 9(02) VALUE 0.          
A00864     05  WS-INSERT-MARK OCCURS 13     PIC X     VALUE '0'.        
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MONTH           PIC XX.                    
               10  FILLER                    PIC X   VALUE '/'.         
               10  WS-FORMAT-YYCC            PIC X(4).                  
A04127     05  WS-ALOC-ITPA-PROCESS          PIC X(01).                 
P00892     05  WS-FORMAT-60-DAY-DATE.                                   
P00892         10  WS-FORMAT-60-MONTH        PIC X(02).                 
P00892         10  FILLER                    PIC X(01) VALUE '/'.       
P00892         10  WS-FORMAT-60-DAY          PIC X(02).                 
P00892         10  FILLER                    PIC X(01) VALUE '/'.       
P00892         10  WS-FORMAT-60-YYCC         PIC X(04).                 
      *                                                                 01640000
       01  WS-THD-PRTY-DETAILS.                                         
           10  WS-TP-NAME                   PIC X(70).                  
           10  WS-THD-PRTY-ADDRESS.                                     
               15  WS-TP-ADDR-STREET        PIC X(55).                  
               15  WS-TP-ADDRESS-OVERFLOW   PIC X(35).                  
               15  WS-TP-ADDR-CITY-STATE    PIC X(30).                  
               15  WS-TP-ADDR-ZIP-CODE      PIC X(09).                  
               15  WS-TP-ADDR-COUNTRY       PIC X(35).                  
               15  WS-TP-ADDR-USPS-DELPT-CD PIC X(02).                  
               15  WS-TP-VALIDATION-TS      PIC X(26).                  
      *                                                                 01750000
       01  WS-PREMISE-ADDR.                                             
           05  WS-PR-STREET                     PIC X(79).              
           05  WS-PR-ADDR-OVERFLOW              PIC X(26).              
           05  WS-PR-ADDR-CITY-STATE            PIC X(30).              
           05  WS-PR-ADDR-CITY-STATE-ZIP        PIC X(41).              
           05  WS-PR-ADDR-ZIP.                                          
               10  WS-PR-ADDR-ZIP-CODE          PIC X(05).              
               10  WS-PR-ADDR-ZIP-PLUS-4        PIC X(04).              
               10  WS-PR-ADDR-USPS-DELIV-PT-CD  PIC X(02).              
      *                                                                 01850000
       01 WS-MST-SUB-ACCT-IND-AT         PIC X(01).                     
       01 WS-CODE-PRNT-BLL-MST-AT        PIC X(01).                     
       01 WS-CODE-TEMP-BILL-AT           PIC X(01).                     
A01440 01 WS-MKTG-CORR-LETT-MSG          PIC X(01).                     
       01 WS-SCSCA-RETURN-CODE           PIC S9(4) COMP.                
       01 LS-CURR-WQ-ITEM                PIC S9(4) COMP.                
      *                                                                 01920000
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF               PIC S9(04)  COMP.    
               10  WS-PRIORITY-WF                  PIC X(1).            
               10  WS-ROUTE-CATEGORY-WF            PIC X(01).           
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF          PIC S9(04)  COMP.    
                   15  WS-COMMENTS-TEXT-WF         PIC X(250).          
               10  FILLER                          PIC X(244).          
      *                                                                 02030000
      *** COPYBOOK FOR WORKING STORAGE FOR SCSCA184                     02040000
       COPY CWSCA184.                                                   02050000
      ********WS FOR DB2 & CICS ERROR PROCESSING*****************       02060000
       COPY CWS00303.                                                   02070000
      ********WS-ABEND-SWITCH************************************       02080000
       COPY CWS09900.                                                   02090000
PRJ166*** COPYBOOKS FOR WORKING STORAGE FOR SCSCA165                    02100000
PRJ166 COPY CWSCA165.                                                   02110000
PRJ166 COPY CWS00010.                                                   02120000
      ********SQLCA**********************************************       02130000
           EXEC SQL                                                     02140000
                INCLUDE SQLCA                                           02150000
           END-EXEC.                                                    02160000
      **********************************************************        02170000
PRJ166********CSS_DELINQUENCY    - C8****************************       02180000
PRJ166     EXEC SQL                                                     02190000
PRJ166          INCLUDE TBDELQ                                          02200000
PRJ166     END-EXEC.                                                    02210000
PRJ166***********************************************************       02220000
PRJ166********CSS_CORR_MAIL_STAT - MW****************************       02230000
PRJ166     EXEC SQL                                                     02240000
PRJ166          INCLUDE TBMAILST                                        02250000
PRJ166     END-EXEC.                                                    02260000
PRJ166***********************************************************       02270000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA901 ENDS HERE  '.            
HPCCDM*    EJECT                                                        02300000
      *                                                                 02310000
A01440 LINKAGE SECTION.                                                 
                                                                        
A01440 01  WS-PARM-VALUE.                                               
A01440     05  WS-PARM-LENGTH            PIC S9(04) COMP.               
A01440     05  WS-PARM-CORR-LETT         PIC X(01).                     
                                                                        
A01440 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      *                                                                 02400000
       0000-MAINLINE.                                                   
      ******************************************************************02420000
      *   CONTROLS MAIN PROCESSING FLOW                                *02430000
      ******************************************************************02440000
                                                                        
            PERFORM 0100-INITIALIZE          THRU  0100-EXIT.           
            PERFORM 1000-PROCESSING          THRU  1000-EXIT            
                    UNTIL END-OF-CA916.                                 
PRJ166      MOVE    'Y'                      TO                         
PRJ166                                        WS-CA165IN-END-OF-PROG-FL.
A03063      IF WS-CA165IN-OK-TO-PROCESS = 'Y'                           
PRJ166         PERFORM 5900-CALL-SCSCA165    THRU 5900-EXIT             
PRJ166      END-IF.                                                     
            PERFORM 9000-TERMINATE           THRU  9000-EXIT.           
            DISPLAY '**************************'.                       
            DISPLAY '***     END OF RUN     ***'.                       
            DISPLAY '**************************'.                       
            DISPLAY '***  TOTAL RECS READ = ' WS-REC-CNT.               
            DISPLAY '***  TOTAL RECS WRIT = ' WS-REC-WRITTEN.           
T37389      DISPLAY '***  TOTAL RECS SKIP = ' WS-REC-SKIPPED.           
            STOP RUN.                                                   
      *                                                                 02620000
       0000-EXIT.                                                       
            GOBACK.                                                     
HPCCDM*     EJECT                                                       02650000
      *                                                                 02660000
       0100-INITIALIZE.                                                 
      ******************************************************************02680000
      * INITIALIZE RUN                                                 *02690000
      * PRIMING READ OF STATEMENT FILE.                                *02700000
      ******************************************************************02710000
      *                                                                 02720000
           INITIALIZE                  WS-FCA901-STATUS                 
                                       WS-FCA916-STATUS                 
                                       WS-END-OF-CA916                  
                                       WS-EOJ-CODE                      
                                       HOLD-ACCOUNT-NO                  
                                       HOLD-MAIL-ADDRESS.               
           OPEN OUTPUT FCSCA901-FILE.                                   
           IF NOT CA901-SUCCESSFUL                                      
                MOVE +0012 TO WS-EOJ-CODE                               
                MOVE WS-EOJ-CODE TO RETURN-CODE                         
                DISPLAY '**************************************'        
                DISPLAY '**  ERROR OPENING FCSCA901          **'        
                DISPLAY '**  FILE STATUS = ' WS-FCA901-STATUS           
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                      
      *                                                                 02880000
T37389     OPEN OUTPUT FCSCAEXP-FILE.                                   
T37389     IF NOT CAEXP-SUCCESSFUL                                      
T37389          MOVE +0012 TO WS-EOJ-CODE                               
T37389          MOVE WS-EOJ-CODE TO RETURN-CODE                         
T37389          DISPLAY '**************************************'        
T37389          DISPLAY '**  ERROR OPENING FCSCAEXP          **'        
T37389          DISPLAY '**  FILE STATUS = ' WS-FCAEXP-STATUS           
T37389          DISPLAY '**************************************'        
T37389          PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                      
      *                                                                 02980000
           OPEN INPUT  FCSCA916-FILE.                                   
           IF NOT CA916-SUCCESSFUL                                      
                MOVE +0012 TO WS-EOJ-CODE                               
                MOVE WS-EOJ-CODE TO RETURN-CODE                         
                DISPLAY '**************************************'        
                DISPLAY '**  ERROR OPENING FCSCA916          **'        
                DISPLAY '**  FILE STATUS = ' WS-FCA916-STATUS           
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                      
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                 03090000
A01440     MOVE SPACES           TO  WS-MKTG-CORR-LETT-MSG              
A01440     IF WS-PARM-LENGTH > 0 AND WS-PARM-CORR-LETT = 'Y'            
A01440        MOVE 'Y'           TO  WS-MKTG-CORR-LETT-MSG              
A01440     END-IF.                                                      
PRJ166     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
PRJ166     MOVE E-CA916-COMPANY-NO             TO C8-COMPANY-NO.        
PRJ166     PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT.          
      *                                                                 03170000
       0100-EXIT.                                                       
            EXIT.                                                       
HPCCDM*    EJECT                                                        03200000
      *                                                                 03210000
      ******************************************************************03220000
      * MAIN PROCESSING MODULE                                         *03230000
      ******************************************************************03240000
       1000-PROCESSING.                                                 
      *                                                                 03260000
           ADD +1                              TO   WS-REC-CNT.         
                                                                        
           PERFORM 2000-GET-NAMES-ADDRESSES    THRU 2000-EXIT.          
                                                                        
           PERFORM 5000-FORMAT-MAILING-ADDR    THRU 5000-EXIT.          
                                                                        
           PERFORM 5080-FORMAT-OMR-MARKS       THRU 5080-EXIT.          
                                                                        
           PERFORM 5500-INIT-EXT-NUM-VAR       THRU 5500-EXIT.          
                                                                        
PRJ166     PERFORM 2100-GET-UNIQ-IDENTIFIER    THRU 2100-EXIT.          
PRJ166                                                                  
           PERFORM 8000-WRITE-FCSCA901-FILE    THRU 8000-EXIT.          
                                                                        
           IF WS-REC-SKIPPED = 50                                       
              DISPLAY '*******PCSCA901**********'                       
              DISPLAY 'EXCEPTIONS LIMIT EXCEEDED'                       
              DISPLAY 'LAST ACCOUNT PROCESSED: ', EXT-MKTG-ACCOUNT-NO   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-INPUT-FILE        THRU 7000-EXIT.          
      *                                                                 03490000
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03520000
       2000-GET-NAMES-ADDRESSES.                                        
      ******************************************************************03540000
      * CALLS PROGRAM SCSCA184 TO GET NAMES AND ADDRESSES              *03550000
      ******************************************************************03560000
      *                                                                 03570000
T37389     INITIALIZE                           WS-SCSCA184-PARMS       
T37389                                          WS-CODE-TEMP-BILL-AT.   
                                                                        
           MOVE E-CA916-ACCOUNT-NO           TO WS-ACCOUNT-NO-AS.       
           MOVE E-CA916-CUSTOMER-NO          TO WS-CUSTOMER-NO-AS       
                                                EXT-MKTG-CUSTOMER-NO.   
           IF E-CA916-CC-ADDRESS-ID IS NOT NUMERIC                      
                MOVE ZEROES                  TO E-CA916-CC-ADDRESS-ID   
           END-IF.                                                      
           IF E-CA916-CC-NAME-ID    IS NOT NUMERIC                      
                MOVE ZEROES                  TO E-CA916-CC-NAME-ID      
           END-IF.                                                      
           IF  E-CA916-ADDRESS-ID   IS NOT NUMERIC                      
                MOVE ZEROES                  TO E-CA916-ADDRESS-ID      
           END-IF.                                                      
           MOVE E-CA916-CC-ADDRESS-ID        TO WS-TP-ADDRESS-ID.       
           MOVE E-CA916-CC-NAME-ID           TO WS-TP-NAME-ID.          
           MOVE E-CA916-ADDRESS-ID           TO WS-ADDRESS-ID-AS.       
           MOVE E-CA916-ADDRESS-FORMAT       TO WS-ADDRESS-FORMAT-AS.   
           MOVE 'A'                          TO WS-ADDRESS-FLAG.        
                                                                        
           PERFORM 5800-CALL-SCSCA184      THRU 5800-EXIT.              
                                                                        
           MOVE WS-NAME-ADDRESS-TABLE        TO WS-NAME-ADDR-TABLE.     
           MOVE WS-TP-ADDRESS                TO WS-THD-PRTY-DETAILS.    
           MOVE WS-PREMISE-ADDRESS           TO WS-PREMISE-ADDR.        
           IF WS-CUST-NAME GREATER THAN SPACES                          
              MOVE WS-CUST-NAME              TO EXT-MKTG-CUSTOMER-NAME  
           ELSE                                                         
              MOVE WS-ACCT-NAME              TO EXT-MKTG-CUSTOMER-NAME  
                                                                        
           END-IF.                                                      
           MOVE WS-COAPPL-NAME               TO                         
                                              EXT-MKTG-COAPPLICANT-NAME.
           MOVE WS-BARCODE-ZIP(1:5)          TO                         
                                              EXT-MKTG-BARCODE-ZIP(1:5) 
                                                                        
           IF WS-BARCODE-ZIP(6:4) > ' '                                 
              MOVE WS-BARCODE-ZIP(6:4)       TO                         
                                              EXT-MKTG-BARCODE-ZIP(6:4) 
           ELSE                                                         
              MOVE SPACES                    TO                         
                                              EXT-MKTG-BARCODE-ZIP(6:4) 
           END-IF                                                       
           IF WS-BARCODE-ZIP(10:2) > ' '                                
              MOVE WS-BARCODE-ZIP(10:2)      TO                         
                                              EXT-MKTG-BARCODE-ZIP(10:2)
           ELSE                                                         
              MOVE SPACES                    TO                         
                                              EXT-MKTG-BARCODE-ZIP(10:2)
           END-IF                                                       
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
              MOVE WS-NAME-ADDR-LINE(WS-SUB) TO                         
                                        EXT-MKTG-MAILING-ADDRESS(WS-SUB)
           END-PERFORM.                                                 
                                                                        
           MOVE WS-PR-STREET                 TO                         
A00890                                     EXT-MKTG-SERVICE-ADDRESS-1.  
T37389     IF WS-PR-ADDR-OVERFLOW > SPACES                              
T37389        MOVE WS-PR-ADDR-OVERFLOW       TO                         
A00890                                     EXT-MKTG-SERVICE-ADDRESS-2   
T37389        MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
A00890                                     EXT-MKTG-SERVICE-ADDRESS-3   
T37389     ELSE                                                         
T37389        MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
A00890                                     EXT-MKTG-SERVICE-ADDRESS-2   
T37389     END-IF.                                                      
A01440*                                                                 04260000
A01440     MOVE WS-MKTG-CORR-LETT-MSG        TO EXT-MKTG-CORR-LETT-MSG. 
      *                                                                 04280000
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 04310000
PRJ166 2100-GET-UNIQ-IDENTIFIER.                                        
PRJ166******************************************************************04330000
PRJ166* CALLS PROGRAM SCSCA165 TO GET MARKETING CORRESPONDENCE UNIQUE  *04340000
PRJ166* IDENTIFIER                                                     *04350000
PRJ166******************************************************************04360000
PRJ166*                                                                 04370000
PRJ166     MOVE 'BLLPRT'                 TO  WS-CA165IN-CORR-TYPE.      
PRJ166     MOVE E-CA916-ACCOUNT-NO       TO  WS-CA165IN-ACCOUNT-NO.     
PRJ166     MOVE E-CA916-CUSTOMER-NO      TO  WS-CA165IN-CUSTOMER-NO.    
PRJ166     MOVE E-CA916-PROCESS-DATE     TO  WS-CA165IN-PROCESS-DATE.   
PRJ166     MOVE E-CA916-COMPANY-NO       TO  WS-CA165IN-COMPANY-NO.     
PRJ166     MOVE C8-DELINQ-VALUE          TO  WS-CA165IN-DATABASE.       
PRJ166     MOVE E-CA916-SEB-REG-GROUP    TO  WS-CA165IN-REG-GROUP-CD.   
PRJ166     MOVE E-CA916-LOCAL-OFFICE     TO  WS-CA165IN-LOCAL-OFFICE.   
PRJ166     MOVE 'PCSCA901'               TO  WS-CA165IN-APPL-PROGRAM-ID.
PRJ166     MOVE  'N'                     TO  WS-CA165IN-TP-MEMO-PROCESS 
PRJ166                                       WS-CA165IN-UPDATE-SEQ-FL   
PRJ166                                       WS-CA165IN-END-OF-PROG-FL. 
PRJ166                                                                  
PRJ166            PERFORM 5900-CALL-SCSCA165    THRU 5900-EXIT          
PRJ166     IF WS-CA165IN-OK-TO-PROCESS = 'Y'                            
PRJ166        MOVE WS-CA165OUT-UNIQ-ID   TO EXT-MKTG-BARCODE-UNIQUE-ID  
PRJ166       MOVE WS-CA165OUT-CUR-STATUS TO EXT-MKTG-TRACKING-STATUS-CD 
PRJ166     END-IF.                                                      
PRJ166*                                                                 04560000
PRJ166  2100-EXIT.                                                      
PRJ166       EXIT.                                                      
PRJ166*                                                                 04590000
       5000-FORMAT-MAILING-ADDR.                                        
      ******************************************************************04610000
      * FORMATS THE MAILING ADDRESS MOVING THE SPACES TO BACK          *04620000
      ******************************************************************04630000
      *                                                                 04640000
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
             IF EXT-MKTG-MAILING-ADDRESS(WS-SUB) EQUAL TO SPACES        
                COMPUTE WS-SUB1 = WS-SUB + 1                            
                PERFORM VARYING WS-SUB1 FROM WS-SUB1 BY 1               
                                        UNTIL WS-SUB1 > 6               
                   IF EXT-MKTG-MAILING-ADDRESS(WS-SUB1) NOT             
                                      EQUAL TO SPACES                   
                        MOVE EXT-MKTG-MAILING-ADDRESS(WS-SUB1) TO       
                             EXT-MKTG-MAILING-ADDRESS(WS-SUB)           
                        MOVE SPACES                           TO        
                                      EXT-MKTG-MAILING-ADDRESS(WS-SUB1) 
                        ADD  +1                   TO WS-SUB             
                   END-IF                                               
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 04810000
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 04840000
      ***************************************************************** 04850000
      * SETS THE OMR MARKS FOR THE INSERTING PROCESS.                 * 04860000
      ***************************************************************** 04870000
      *                                                                 04880000
       5080-FORMAT-OMR-MARKS.                                           
      *                                                                 04900000
           MOVE '1'                 TO WS-INSERT-MARK (1).              
           MOVE '0'                 TO WS-INSERT-MARK (2)               
      *                                                                 04930000
           MOVE WS-INSERT-MARK (1)  TO EXT-MKTG-OMR-MARK-1.             
           MOVE WS-INSERT-MARK (2)  TO EXT-MKTG-OMR-MARK-2.             
           MOVE WS-INSERT-MARK (3)  TO EXT-MKTG-OMR-MARK-3.             
           MOVE WS-INSERT-MARK (4)  TO EXT-MKTG-OMR-MARK-4.             
           MOVE WS-INSERT-MARK (5)  TO EXT-MKTG-OMR-MARK-5.             
           MOVE WS-INSERT-MARK (6)  TO EXT-MKTG-OMR-MARK-6.             
           MOVE WS-INSERT-MARK (7)  TO EXT-MKTG-OMR-MARK-7.             
           MOVE WS-INSERT-MARK (8)  TO EXT-MKTG-OMR-MARK-8.             
           MOVE WS-INSERT-MARK (9)  TO EXT-MKTG-OMR-MARK-9.             
           MOVE WS-INSERT-MARK (10) TO EXT-MKTG-OMR-MARK-10.            
           MOVE WS-INSERT-MARK (11) TO EXT-MKTG-OMR-MARK-11.            
           MOVE WS-INSERT-MARK (12) TO EXT-MKTG-OMR-MARK-12.            
      *                                                                 05060000
           EVALUATE E-CA916-MESSAGE-NO                                  
T37389        WHEN 10101                                                
T37389        WHEN 10102                                                
PRJ211        WHEN 10206                                                
PRJ211        WHEN 10207                                                
PRJ211        WHEN 10208                                                
P00805        WHEN 10209                                                
T37389             MOVE '1'         TO EXT-MKTG-OMR-MARK-3              
P00677*  Gas safety insert on pocket-2 (mandatory on welcome kits)      05150000
              WHEN 10301                                                
PRJ245             MOVE '1'         TO EXT-MKTG-OMR-MARK-4              
                   MOVE '0'         TO EXT-MKTG-OMR-MARK-5              
                                       EXT-MKTG-OMR-MARK-6              
           END-EVALUATE.                                                
      *                                                                 05210000
       5080-EXIT.                                                       
      *                                                                 05230000
      ***************************************************************** 05240000
      *INTIALIZE ALL NUMERIC VARIABLES OF OUTPUT FILE IF THEY ARE     * 05250000
      *NOT NUMBERIC                                                   * 05260000
      ***************************************************************** 05270000
       5500-INIT-EXT-NUM-VAR.                                           
            IF E-CA916-CURR-CSC       NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-CURR-CSC              
            END-IF.                                                     
            IF E-CA916-NEW-CSC        NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-NEW-CSC               
            END-IF.                                                     
            IF E-CA916-DROP-PRICE     NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-DROP-PRICE            
            END-IF.                                                     
            IF E-CA916-DROP-CSC       NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-DROP-CSC              
            END-IF.                                                     
            IF E-CA916-EPP-AMOUNT     NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-EPP-AMOUNT            
            END-IF.                                                     
            IF E-CA916-EPP-AMOUNT-NEW NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-EPP-AMOUNT-NEW        
            END-IF.                                                     
            IF E-CA916-NBR-GOOD-PYMTS NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-NBR-GOOD-PYMTS        
            END-IF.                                                     
            IF E-CA916-NBR-MISSED-PAYMENT   NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-NBR-MISSED-PAYMENT    
            END-IF.                                                     
A02003      PERFORM VARYING WS-REN-OPT-IDX FROM 1 BY 1                  
A02003                UNTIL WS-REN-OPT-IDX = 6                          
A02003         IF E-CA916-REN-OPT-PRICE(WS-REN-OPT-IDX) NOT NUMERIC     
A02003            MOVE ZERO    TO E-CA916-REN-OPT-PRICE(WS-REN-OPT-IDX) 
A02003         END-IF                                                   
A02003         IF E-CA916-REN-OPT-CSC(WS-REN-OPT-IDX) NOT NUMERIC       
A02003            MOVE ZERO    TO E-CA916-REN-OPT-CSC(WS-REN-OPT-IDX)   
A02003         END-IF                                                   
A02003         IF E-CA916-EXIT-FEE-AMT(WS-REN-OPT-IDX) NOT NUMERIC      
A02003            MOVE ZERO    TO E-CA916-EXIT-FEE-AMT(WS-REN-OPT-IDX)  
A02003         END-IF                                                   
A02003      END-PERFORM.                                                
                                                                        
            IF E-CA916-GRP2-PUB-FIX-PRC     NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-PUB-FIX-PRC      
            END-IF.                                                     
            IF E-CA916-GRP2-PUB-VAR-PRC     NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-PUB-VAR-PRC      
            END-IF.                                                     
            IF E-CA916-GRP2-RENEW-DSC       NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-RENEW-DSC        
            END-IF.                                                     
            IF E-CA916-GRP2-LOW-CSC-AMT     NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-LOW-CSC-AMT      
            END-IF.                                                     
            IF E-CA916-GRP2-MED-CSC-AMT     NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-MED-CSC-AMT      
            END-IF.                                                     
            IF E-CA916-GRP2-HIGH-CSC-AMT    NOT NUMERIC                 
               MOVE ZERO               TO E-CA916-GRP2-HIGH-CSC-AMT     
            END-IF.                                                     
            IF E-CA916-FACTOR-FH      NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-FACTOR-FH             
            END-IF.                                                     
            IF E-CA916-CUST-DEP-AMT   NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-CUST-DEP-AMT          
            END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-1  NOT NUMERIC                      
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-1        
I00237      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-2  NOT NUMERIC                      
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-2        
PRJ172      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-3  NOT NUMERIC                      
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-3        
PRJ172      END-IF.                                                     
            IF E-CA916-FXD-RT-TERM-FEE NOT NUMERIC                      
               MOVE ZERO               TO E-CA916-FXD-RT-TERM-FEE       
            END-IF.                                                     
            IF E-CA916-NUM-VARIABLE-4 NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-NUM-VARIABLE-4        
            END-IF.                                                     
            IF E-CA916-NUM-VARIABLE-5 NOT NUMERIC                       
               MOVE ZERO               TO E-CA916-NUM-VARIABLE-5        
            END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-6 NOT NUMERIC                       
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-6        
PRJ245      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-7 NOT NUMERIC                       
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-7        
PRJ245      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-8 NOT NUMERIC                       
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-8        
PRJ245      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-9 NOT NUMERIC                       
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-9        
PRJ245      END-IF.                                                     
PRJ245      IF E-CA916-NUM-VARIABLE-10 NOT NUMERIC                      
PRJ245         MOVE ZERO               TO E-CA916-NUM-VARIABLE-10       
PRJ245      END-IF.                                                     
P00581      IF E-CA916-RECONN-CHRG     NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-RECONN-CHRG           
P00581      END-IF.                                                     
P00581      IF E-CA916-NEW-CONN-CHRG   NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-NEW-CONN-CHRG         
P00581      END-IF.                                                     
P00581      IF E-CA916-MTR-SET-CHRG    NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-MTR-SET-CHRG          
P00581      END-IF.                                                     
P00581      IF E-CA916-SEA-CONN-CHRG   NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-SEA-CONN-CHRG         
P00581      END-IF.                                                     
P00581      IF E-CA916-RET-CHK-CHRG    NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-RET-CHK-CHRG          
P00581      END-IF.                                                     
P00581      IF E-CA916-RESI-EXIT-FEE   NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-RESI-EXIT-FEE         
P00581      END-IF.                                                     
P00581      IF E-CA916-COMM-EXIT-FEE   NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-COMM-EXIT-FEE         
P00581      END-IF.                                                     
P00581      IF E-CA916-MAX-RESI-DEP    NOT NUMERIC                      
P00581         MOVE ZERO               TO E-CA916-MAX-RESI-DEP          
P00581      END-IF.                                                     
P805CS      IF E-CA916-AUTO-RENEW-DSC-AMT   NOT NUMERIC                 
P805CS         MOVE ZERO        TO E-CA916-AUTO-RENEW-DSC-AMT           
P805CS      END-IF.                                                     
P805CS      IF E-CA916-PAPERLESS-DSC-AMT    NOT NUMERIC                 
P805CS         MOVE ZERO        TO E-CA916-PAPERLESS-DSC-AMT            
P805CS      END-IF.                                                     
      *                                                                 06470000
       5500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06500000
      ************************************************************      06510000
      *  CALL SCSCA184 TO GET ADDRESS.                           *      06520000
      ************************************************************      06530000
       5800-CALL-SCSCA184.                                              
      *                                                                 06550000
           INITIALIZE                           WS-NAME-ADDR-TABLE.     
           DISPLAY 'CALLING SCSCA184 FROM PCSCA901'.                    
           CALL  SCSCA184                 USING WS-SCSCA184-PARMS       
                                                WS-MST-SUB-ACCT-IND-AT  
                                                WS-CODE-PRNT-BLL-MST-AT 
                                                WS-CODE-TEMP-BILL-AT    
                                                WS-SCSCA-RETURN-CODE    
                                                LS-CURR-WQ-ITEM         
                                                WS-BILLING-WQ-ITEMS-WF  
A04127                                          WS-ALOC-ITPA-PROCESS.   
                                                                        
           MOVE 'SCSCA184'                   TO WS-DISPLAY-SCSCA.       
                                                                        
           IF WS-SCSCA-RETURN-CODE        NOT = 0                       
              PERFORM 9200-SCSCA-ERROR   THRU   9200-EXIT               
           END-IF.                                                      
      *                                                                 06710000
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06740000
PRJ166*                                                                 06750000
PRJ166************************************************************      06760000
PRJ166*  CALL SCSCA165 TO GET UNIQUE IDENTIFIER                  *      06770000
PRJ166************************************************************      06780000
PRJ166 5900-CALL-SCSCA165.                                              
PRJ166*                                                                 06800000
PRJ166     DISPLAY 'CALL SCSCA165 FROM PCSCA901'.                       
PRJ166     CALL  SCSCA165                 USING WS-SCSCA165-PARMS,      
PRJ166                                          WS-CA165-MISC,          
PRJ166                                          ABEND-FILE,             
PRJ166                                          WS-SCSCA-RETURN-CODE    
PRJ166                                                                  
PRJ166     MOVE 'SCSCA165'                   TO WS-DISPLAY-SCSCA.       
PRJ166                                                                  
PRJ166     IF WS-SCSCA-RETURN-CODE        NOT = 0                       
PRJ166        PERFORM 9200-SCSCA-ERROR   THRU   9200-EXIT               
PRJ166     END-IF.                                                      
PRJ166*                                                                 06920000
PRJ166 5900-EXIT.                                                       
PRJ166     EXIT.                                                        
PRJ166*                                                                 06950000
PRJ166***************************************************************** 06960000
PRJ166** UPDATE UNIQUE IDENTIFIER TRACKING STATUS TO EI              ** 06970000
PRJ166***************************************************************** 06980000
PRJ166     EXEC SQL                                                     06990000
PRJ166         INCLUDE CPDCA166                                         07000000
PRJ166     END-EXEC.                                                    07010000
PRJ166*                                                                 07020000
      ***************************************************************** 07030000
      ** THIS ROUTINE READS THE INPUT FILE.                          ** 07040000
      ***************************************************************** 07050000
       7000-READ-INPUT-FILE.                                            
      *                                                                 07070000
PRJ166     INITIALIZE                               FIOCA916            
PRJ166                                              FIOCA901.           
            READ FCSCA916-FILE                                          
                AT END MOVE WS-Y TO WS-END-OF-CA916.                    
            IF CA916-SUCCESSFUL OR END-OF-CA916                         
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '****************************************'      
                DISPLAY '**    PCSCA901 PROCESSING ERROR       **'      
                DISPLAY '**       ERROR READING FCSCA916       **'      
                DISPLAY '**       FILE STATUS = ' WS-FCA916-STATUS      
                DISPLAY '****************************************'      
                PERFORM 9000-TERMINATE THRU 9000-EXIT
            END-IF.                  
      *                                                                 07210000
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 07240000
PRJ166*                                                                 07250000
PRJ166***************************************************************** 07260000
PRJ166** TO GET THE DATABASE                                         ** 07270000
PRJ166***************************************************************** 07280000
PRJ166 7100-SELECT-DELINQ-VALUE.                                        
PRJ166*                                                                 07300000
PRJ166     EXEC SQL                                                     
PRJ166        SELECT DELINQ_VALUE                                       
PRJ166          INTO :C8-DELINQ-VALUE                                   
PRJ166          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
PRJ166         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
PRJ166           AND COMPANY_NO = :C8-COMPANY-NO                        
PRJ166                                                           
PRJ166     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07310000
MFA-TR*       SELECT DELINQ_VALUE                                       07320000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   07330000
MFA-TR*         FROM CSS_DELINQUENCY                                    07340000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         07350000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        07360000
MFA-TR*         WITH UR                                                 07370000
MFA-TR*    END-EXEC.                                                    07380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ166                                                                  
PRJ166     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
PRJ166     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
PRJ166         CONTINUE                                                 
PRJ166     ELSE                                                         
PRJ166         DISPLAY '********** PCSCA901 ABORT **************'       
PRJ166         DISPLAY '* 7100-SELECT-DELINQ-VALUE             *'       
PRJ166         DISPLAY '* DELINQ CD ', C8-DELINQ-CD                     
PRJ166         DISPLAY '* COMPANY NO', C8-COMPANY-NO                    
PRJ166         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
PRJ166         DISPLAY '* PROGRAM ABORTING...                  *'       
PRJ166         DISPLAY '********** PCSCA901 ABORT **************'       
PRJ166         PERFORM 9900-ABEND              THRU 9900-EXIT           
PRJ166     END-IF.                                                      
PRJ166*                                                                 07530000
PRJ166 7100-EXIT.                                                       
PRJ166      EXIT.                                                       
      *                                                                 07560000
      ***************************************************************** 07570000
      ** THIS ROUTINE WRITES TO THE OUTPUT FILE.                     ** 07580000
      ***************************************************************** 07590000
       8000-WRITE-FCSCA901-FILE.                                        
      *                                                                 07610000
           MOVE E-CA916-RECORD-KEY       TO EXT-MKTG-RECORD-KEY.        
           MOVE E-CA916-MESSAGE-NO       TO EXT-MKTG-MESSAGE-NO.        
           MOVE E-CA916-COMPANY-NO       TO EXT-MKTG-COMPANY-NO.        
           MOVE E-CA916-ACCOUNT-NO       TO EXT-MKTG-ACCOUNT-NO.        
           MOVE E-CA916-STATEMENT-DATE   TO EXT-MKTG-STATEMENT-DATE.    
           MOVE E-CA916-LOCAL-OFFICE     TO EXT-MKTG-LOCAL-OFFICE.      
           MOVE E-CA916-BILL-CYCLE       TO EXT-MKTG-BILL-CYCLE.        
T37389     MOVE E-CA916-COMM-TYPE-CD     TO EXT-MKTG-COMM-TYPE-CD.      
T37389     MOVE E-CA916-COMM-SUBTYP-CD   TO EXT-MKTG-COMM-SUBTYP-CD.    
           MOVE E-CA916-NOTICE-TYPE      TO EXT-MKTG-NOTICE-TYPE.       
P00453     MOVE E-CA916-ACCT-TYPE-FLAG   TO EXT-MKTG-ACCT-TYPE-FLAG.    
P00581     MOVE E-CA916-TIER-ACCT-TYPE   TO EXT-MKTG-TIER-ACCT-TYPE.    
A04730     MOVE E-CA916-CURR-RATE-IS-FLEX                               
A04730                                   TO EXT-MKTG-CURR-RATE-IS-FLEX. 
A04730     MOVE E-CA916-FLEX-RATE-HAS-INCTV                             
A04730                                 TO EXT-MKTG-FLEX-RATE-HAS-INCTV. 
                                                                        
           IF E-CA916-STATEMENT-DATE GREATER THAN SPACES                
              MOVE E-CA916-STATEMENT-DATE(3:2) TO                       
                                               EXT-MKTG-BILL-MMYY(1:2)  
              MOVE E-CA916-STATEMENT-DATE(1:2) TO                       
                                               EXT-MKTG-BILL-MMYY(3:2)  
           END-IF.                                                      
                                                                        
PRJ245     MOVE E-CA916-NUM-VARIABLE-1   TO EXT-MKTG-NUM-VARIABLE-1.    
           MOVE E-CA916-FACTOR-FH        TO EXT-MKTG-FACTOR-FH.         
PRJ245     MOVE E-CA916-NUM-VARIABLE-2   TO EXT-MKTG-NUM-VARIABLE-2.    
           MOVE E-CA916-FXD-RT-TERM-FEE  TO EXT-MKTG-NUM-VARIABLE-3.    
PRJ245     MOVE E-CA916-NUM-VARIABLE-5   TO EXT-MKTG-NUM-VARIABLE-4.    
PRJ245     MOVE E-CA916-NUM-VARIABLE-6   TO EXT-MKTG-NUM-VARIABLE-5.    
I00237     MOVE E-CA916-CUST-DEP-AMT     TO EXT-MKTG-NUM-VARIABLE-6.    
PRJ245     MOVE E-CA916-NUM-VARIABLE-3   TO EXT-MKTG-NUM-VARIABLE-7.    
PRJ245     MOVE E-CA916-NUM-VARIABLE-4   TO EXT-MKTG-NUM-VARIABLE-8.    
PRJ396     MOVE E-CA916-NUM-VARIABLE-9   TO EXT-MKTG-NUM-VARIABLE-9.    
           MOVE E-RATE-PLAN-NO           TO EXT-MKTG-RATE-PLAN-NO.      
P00892     IF EXT-MKTG-MESSAGE-NO = '10501'                             
P00892        MOVE E-CA916-ALPHA-VARIABLE-1(1:4) TO WS-FORMAT-60-YYCC   
P00892        MOVE E-CA916-ALPHA-VARIABLE-1(6:2) TO WS-FORMAT-60-MONTH  
P00892        MOVE E-CA916-ALPHA-VARIABLE-1(9:2) TO WS-FORMAT-60-DAY    
P00892        MOVE WS-FORMAT-60-DAY-DATE TO EXT-MKTG-ALPHA-VARIABLE-1   
P00892     ELSE                                                         
P00892        MOVE E-CA916-ALPHA-VARIABLE-1 TO EXT-MKTG-ALPHA-VARIABLE-1
P00892     END-IF.                                                      
           MOVE E-CA916-ALPHA-VARIABLE-2 TO EXT-MKTG-ALPHA-VARIABLE-2.  
           MOVE E-CA916-ALPHA-VARIABLE-3 TO EXT-MKTG-ALPHA-VARIABLE-3.  
                                                                        
           IF E-PRDSC-START-DATE > SPACES                               
              MOVE E-PRDSC-START-DATE(1:4)  TO WS-FORMAT-YYCC           
              MOVE E-PRDSC-START-DATE(5:2)  TO WS-FORMAT-MONTH          
              MOVE WS-FORMAT-DATE         TO EXT-MKTG-ALPHA-VARIABLE-4  
           ELSE                                                         
A04106        MOVE E-CA916-ALPHA-VARIABLE-4 TO EXT-MKTG-ALPHA-VARIABLE-4
           END-IF.                                                      
                                                                        
           IF E-PRDSC-EXPR-DATE > SPACES                                
              MOVE E-PRDSC-EXPR-DATE(1:4)   TO WS-FORMAT-YYCC           
              MOVE E-PRDSC-EXPR-DATE(5:2)   TO WS-FORMAT-MONTH          
              MOVE WS-FORMAT-DATE        TO EXT-MKTG-ALPHA-VARIABLE-5   
           ELSE                                                         
A05037        MOVE E-CA916-ALPHA-VARIABLE-5 TO EXT-MKTG-ALPHA-VARIABLE-5
           END-IF.                                                      
                                                                        
           MOVE SPACES                   TO EXT-MKTG-ALPHA-VARIABLE-7.  
           MOVE E-CA916-SEB-REG-GROUP    TO EXT-MKTG-SEB-REG-GROUP.     
           MOVE E-CA916-SEB-REG-SENIOR   TO EXT-MKTG-SEB-REG-SENIOR.    
           MOVE E-CA916-CREDIT-GROUP     TO EXT-MKTG-CREDIT-GROUP.      
           MOVE E-CA916-SERVICE-TYPE     TO EXT-MKTG-SERVICE-TYPE.      
           MOVE E-CA916-EXCEPTION-SW     TO EXT-MKTG-EXCEPTION-SW.      
           MOVE 'Y'                      TO EXT-MKTG-IMAGING-FLAG.      
           MOVE E-CA916-BILL-PRT-MSG-CD  TO EXT-MKTG-BILL-PRT-MSG-CD.   
           MOVE E-CA916-RET-TIER-SOURCE-CD                              
                                         TO EXT-MKTG-RET-TIER-SOURCE-CD.
           MOVE E-CA916-TIER-ACCT-SW     TO EXT-MKTG-TIER-ACCT-SW.      
           MOVE E-CA916-LOWEST-CSC-SW    TO EXT-MKTG-LOWEST-CSC-SW.     
           MOVE E-CA916-SENIOR-SW        TO EXT-MKTG-SENIOR-SW.         
           MOVE E-CA916-FREE-CSC-FLAG    TO EXT-MKTG-FREE-CSC-FLAG.     
           MOVE E-CA916-EPP-AMOUNT       TO EXT-MKTG-EPP-AMOUNT.        
           MOVE E-CA916-EPP-AMOUNT-NEW   TO EXT-MKTG-EPP-AMOUNT-NEW.    
           MOVE E-CA916-NBR-GOOD-PYMTS   TO EXT-MKTG-NBR-GOOD-PYMTS.    
           MOVE E-CA916-NBR-MISSED-PAYMENT                              
                                         TO EXT-MKTG-NBR-MISSED-PAYMENT.
           MOVE E-CA916-CURR-CSC         TO EXT-MKTG-CURR-CSC.          
           MOVE E-CA916-NEW-CSC          TO EXT-MKTG-NEW-CSC.           
PRJ245     MOVE E-CA916-OPTION-DESC      TO EXT-MKTG-ALPHA-DESC.        
           MOVE E-CA916-DDC-THERM-PRICE  TO EXT-MKTG-DDC-THERM-PRICE.   
           MOVE E-CA916-DDC-THERM-DESC   TO EXT-MKTG-DDC-THERM-DESC.    
P805OP     MOVE E-CA916-DROP-DDC-THERM-DESC TO                          
P805OP                                   EXT-MKTG-DROP-DDC-THERM-DESC.  
PRJ172     MOVE E-CA916-CSC-REVERT-SW    TO EXT-MKTG-CSC-REVERT-SW.     
           MOVE E-CA916-RENEW-DATE       TO EXT-MKTG-RENEW-DATE.        
A02003     PERFORM VARYING WS-REN-OPT-IDX FROM 1 BY 1                   
A02003             UNTIL WS-REN-OPT-IDX = 6 OR                          
A02003                      E-CA916-REN-OPT-PRICE(WS-REN-OPT-IDX) = 0   
A02003        MOVE E-CA916-REN-OPT-CD(WS-REN-OPT-IDX)                   
A02003                     TO EXT-MKTG-REN-OPT-CD(WS-REN-OPT-IDX)       
A02003        MOVE E-CA916-REN-OPT-DES(WS-REN-OPT-IDX)                  
A02003                     TO EXT-MKTG-REN-OPT-DESC(WS-REN-OPT-IDX)     
A02003        MOVE E-CA916-REN-OPT-CSC(WS-REN-OPT-IDX)                  
A02003                     TO EXT-MKTG-REN-OPT-CSC(WS-REN-OPT-IDX)      
A02003        MOVE E-CA916-EXIT-FEE-AMT(WS-REN-OPT-IDX)                 
A02003                     TO EXT-MKTG-EXIT-FEE-AMT(WS-REN-OPT-IDX)     
A02003        MOVE E-CA916-REN-OPT-MONTHS(WS-REN-OPT-IDX)               
A02003                     TO EXT-MKTG-REN-OPT-MONTHS(WS-REN-OPT-IDX)   
A02003        MOVE E-CA916-REN-OPT-PRICE(WS-REN-OPT-IDX)                
A02003                     TO EXT-MKTG-REN-OPT-PRICE(WS-REN-OPT-IDX)    
A02003     END-PERFORM.                                                 
                                                                        
PRJ172     MOVE E-CA916-DHR-FLAG         TO EXT-MKTG-DHR-FLAG.          
           MOVE E-CA916-DROP-PRICE       TO EXT-MKTG-DROP-PRICE.        
           MOVE E-CA916-DROP-CSC         TO EXT-MKTG-DROP-CSC.          
           MOVE E-CA916-GRP2-PUB-FIX-PRC TO EXT-MKTG-GRP2-PUB-FIXED-PRC.
           MOVE E-CA916-GRP2-PUB-VAR-PRC TO EXT-MKTG-GRP2-PUB-VAR-PRC.  
           MOVE E-CA916-GRP2-LOW-CSC-AMT TO EXT-MKTG-GRP2-LOW-CSC-AMT.  
           MOVE E-CA916-GRP2-MED-CSC-AMT TO EXT-MKTG-GRP2-MED-CSC-AMT.  
           MOVE E-CA916-GRP2-HIGH-CSC-AMT TO EXT-MKTG-GRP2-HIGH-CSC-AMT.
           MOVE E-CA916-GRP2-PUB-FIX-DESC TO                            
                                         EXT-MKTG-GRP2-PUB-FIXED-DESC.  
           MOVE E-CA916-GRP2-PUB-VAR-DESC TO EXT-MKTG-GRP2-PUB-VAR-DESC.
           MOVE E-CA916-GRP2-RENEW-DSC    TO EXT-MKTG-GRP2-RENEW-DSC.   
PRJ245     MOVE E-CA916-INTRO-RATE-ATTRIB TO EXT-MKTG-INTRO-RATE-ATTRIB.
PRJ245     MOVE E-CA916-ALPHA-VARIABLE-6  TO EXT-MKTG-SVC-START-DT.     
PRJ245     MOVE E-CA916-ALPHA-VARIABLE-7  TO EXT-MKTG-IV-DRP-OPTION-CD. 
PRJ396*******INTRODUCTOR DROP DESCRIPTION FOR 10301 AND 10401 IS IN     08750000
PRJ396*******EXT-MKTG-ALPHA-VARIABLE-6.                                 08760000
PRJ245     MOVE E-CA916-ALPHA-VARIABLE-10   TO                          
PRJ396                                  EXT-MKTG-ALPHA-VARIABLE-6.      
P00581     MOVE E-CA916-DISCL-TC-INFO       TO                          
P00581                                  EXT-MKTG-DISCL-TC-INFO.         
P00680     MOVE E-CA916-OPT-STAT-ADJ-CD     TO E-MKTG-OPT-STAT-ADJ-CD.  
P00680     MOVE E-CA916-FLEX-ADJUSTMENT-COUNT TO                        
P00680                                  E-MKTG-FLEX-ADJUSTMENT-COUNT.   
P00680     MOVE E-CA916-PRICE-DISC-TABLE TO                             
P00680                                  E-MKTG-PRICE-DISC-TABLE.        
P00680     MOVE E-CA916-CSC-DISC-TABLE   TO                             
P00680                                  E-MKTG-CSC-DISC-TABLE.          
P00805     MOVE E-CA916-PEND-OPT-START-DATE TO                          
P00805                                  EXT-MKTG-PEND-OPT-START-DATE.   
P00805     MOVE E-CA916-PEND-OPT-END-DATE TO                            
P00805                                  EXT-MKTG-PEND-OPT-END-DATE.     
P00805     MOVE E-CA916-CURR-OPT-END-DATE TO                            
P00805                                  EXT-MKTG-CURR-OPT-END-DATE.     
P00805     MOVE E-CA916-AGREEMNT-SOURCE-CD TO                           
P00805                                  EXT-MKTG-AGREEMNT-SOURCE-CD.    
P00805     IF E-CA916-SEB-REG-GROUP <= SPACES AND                       
ACT002        (E-CA916-AGREEMNT-SOURCE-CD = 'FDN' OR                    
ACT002         E-CA916-AGREEMNT-SOURCE-CD = 'VRN')                      
P00805        MOVE 'Y' TO EXT-MKTG-DROPPED-FLAG                         
P00805     ELSE                                                         
P00805        MOVE 'N' TO EXT-MKTG-DROPPED-FLAG                         
P00805     END-IF.                                                      
P00892     MOVE E-CA916-PEND-AUTO-REN-OPT-IN TO                         
P00892                                  EXT-MKTG-PEND-AUTO-REN-OPT-IN.  
P00892     MOVE E-CA916-CURR-AUTO-REN-OPT-IN TO                         
P00892                                  EXT-MKTG-CURR-AUTO-REN-OPT-IN.  
P00892     MOVE E-CA916-AUTO-REN-FL          TO                         
P00892                                  EXT-MKTG-AUTO-REN-FL.           
P805CS     MOVE E-CA916-AUTO-REN-DSC-ELIG-FL TO                         
P805CS                                  EXT-MKTG-AUTO-REN-DSC-ELIG-FL.  
P805CS     MOVE E-CA916-PAPERLESS-DSC-ELIG-FL TO                        
P805CS                                  EXT-MKTG-PAPERLESS-DSC-ELIG-FL. 
P805CS     MOVE E-CA916-LEGACY-FIX-RT-FL TO                             
P805CS                                  EXT-MKTG-LEGACY-FIX-RT-FL.      
P805CS     IF E-CA916-OLD-CSC-RATE-FL = 'Y'                             
P805CS        IF E-CA916-CURR-CSC < E-CA916-REN-OPT-CSC(1)              
P805CS           MOVE 'Y' TO EXT-MKTG-OLD-CSC-RATE-FL                   
P805CS        ELSE                                                      
P805CS           MOVE 'N' TO EXT-MKTG-OLD-CSC-RATE-FL                   
P805CS        END-IF                                                    
P805CS     END-IF.                                                      
P805CS     MOVE E-CA916-AUTO-RENEW-DSC-AMT TO                           
P805CS                                EXT-MKTG-AUTO-RENEW-DSC-AMT.      
P805CS     MOVE E-CA916-PAPERLESS-DSC-AMT TO                            
P805CS                                  EXT-MKTG-PAPERLESS-DSC-AMT.     
P805CS     COMPUTE EXT-MKTG-NUM-VARIABLE-5 =                            
P805CS                 EXT-MKTG-AUTO-RENEW-DSC-AMT +                    
P805CS                 EXT-MKTG-PAPERLESS-DSC-AMT                       
P805CS                                                                  
P00805     MOVE E-CA916-NEW-RATE-BILL-DT TO EXT-MKTG-NEW-RATE-BILL-DT.  
ACT002     MOVE E-RATE-CALC-TYPE-CD      TO EXT-MKTG-RATE-CALC-TYPE-CD. 
P00805                                                                  
T37389     IF WS-CODE-TEMP-BILL-AT = 'T'                                
PRJ166        MOVE E-CA916-ACCOUNT-NO          TO MW-ACCOUNT-NO         
PRJ166        MOVE EXT-MKTG-BARCODE-UNIQUE-ID  TO MW-BARCODE-UNIQUE-ID  
PRJ166        MOVE 'PCSCA901 '                 TO MW-APPL-PROGRAM-ID    
PRJ166        IF WS-CA165IN-OK-TO-PROCESS = 'Y'                         
PRJ166          PERFORM 6100-UPD-TRACK-STAT-CD THRU 6100-EXIT           
PRJ166        END-IF                                                    
T37389        PERFORM 8100-WRITE-FCSEXCP-FILE  THRU 8100-EXIT           
T37389     ELSE                                                         
T37389        WRITE FIOCA901                                            
T37389        ADD 1                      TO WS-REC-WRITTEN              
T37389     END-IF.                                                      
      *                                                                 09210000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09240000
T37389***************************************************************** 09250000
T37389** THIS ROUTINE WRITES TO THE EXCEPTION FILE.                  ** 09260000
T37389***************************************************************** 09270000
T37389 8100-WRITE-FCSEXCP-FILE.                                         
T37389*                                                                 09290000
T37389     MOVE  FIOCA901                TO FIOEXCP.                    
T37389     WRITE FIOEXCP.                                               
T37389     ADD 1                         TO WS-REC-SKIPPED.             
T37389*                                                                 09330000
T37389 8100-EXIT.                                                       
T37389     EXIT.                                                        
T37389*                                                                 09360000
      ***************************************************************** 09370000
      ** TERMINATION ROUTINE. CLOSES ALL THE FILES.                  ** 09380000
      ***************************************************************** 09390000
       9000-TERMINATE.                                                  
      *                                                                 09410000
            CLOSE FCSCA916-FILE,                                        
T37389            FCSCAEXP-FILE,                                        
                  FCSCA901-FILE.                                        
            IF WS-REC-CNT < 1                                           
                IF RETURN-CODE < 8                                      
                    DISPLAY                                             
                      '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
                    DISPLAY                                             
                      '!  INPUT FILE EMPTY OR CONTAINS NO VALID DATA  !'
                    DISPLAY                                             
                      '!*!*                 ***                    *!*!'
                    DISPLAY                                             
                      '!*!*        MARK THIS RUN COMPLETE          *!*!'
                    DISPLAY                                             
                      '!****                ***                    ***!'
                    DISPLAY                                             
                      '!****      DO NOT NOTIFY PROGRAMMER         ***!'
                    DISPLAY                                             
                      '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
                  MOVE +8 TO RETURN-CODE                                
                  END-IF                                                
            END-IF.                                                     
      *                                                                 09640000
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 09670000
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' E-CA916-ACCOUNT-NO.             
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09840000
      ***************************************************************** 09850000
      ** 9900-ABEND.                                                 ** 09860000
      ***************************************************************** 09870000
      *                                                                 09880000
           EXEC SQL                                                     09890000
               INCLUDE CPD09900                                         09900000
           END-EXEC.                                                    09910000
      *                                                                 09920000
