       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA837.                                        
       DATE-WRITTEN.   FEB 2005.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                   COLUMBIA, SC 29218                        **         
      **                     (803) 748-3000                          **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      *        -------------- PCSCA837 NARRATIVE --------------       *         
      ******** ---------------------------------------------- *********         
      ********                                                *********         
      *   THIS PROGRAM CREATES AN EXTRACT FILE WHICH IS USED          *         
      *   TO PRODUCE THE 'DEPOSITS AND INTEREST' MONTHLY REPORTS.     *         
      ********                                                *********         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    USERID       REASON                              **         
      **  ________  ________   ___________________________________   **         
C31996**  02/24/05  RB19957     INITIAL REQUEST FOR PROGRAM.         **         
      **                        (THIS IS EXTRACT PROGRAM FOR PCSCA817**         
      **                         AND PCSCA827.)                      **         
      ******************************************************************00419300
      ******** ---------------------------------------------- *********         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES                
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA837.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA837.                                                           
       COPY FIOCA837.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA837'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA837 STARTS HERE'.            
      *                                                                         
      ********************************************************                  
      *  CWS00010            WS ABEND WORK AREA                                 
      ********************************************************                  
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      **    THE FOLLOWING FIELDS ARE USED IN ABEND SITUATIONS.      **          
      **    THEY STORE THE ACTIVE PARAGRAPH NUMBER, AND FORCE       **          
      **    A DATA EXCEPTION IN THE ABEND PARAGRAPHS.               **          
      ****************************************************************          
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE          PIC X VALUE SPACE.               
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                       PIC 9.                           
      *                                                                         
      ************************************************                          
      *  CWS09900  ABEND SWITCH COPYBOOK                                        
      ************************************************                          
       COPY CWS09900.                                                           
      *                                                                         
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
      *****************************************************************         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      ** ===========>  DB2 TABLES INCLUDED IN PROGRAM  <=========== **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *************************************************************             
      *      CSS_DEP_ON_HAND (PREFIX  = DO)                       *             
      *************************************************************             
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      *                                                                         
      *************************************************************             
      *      CSS_MODEL_SQL (PREFIX = MS)                          *             
      *************************************************************             
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC                                                             
      *                                                                         
      ************* END OF DB2 TABLES *****************************             
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA837-CO-REC-COUNT      PIC 9(07) VALUE ZERO.        
           05  WS-FCA837-READ-COUNT        PIC 9(07) VALUE ZERO.        
           05  WS-FCA837-STATUS            PIC X(02).                   
               88  FCA837-SUCCESSFUL                 VALUE '00'.        
           05  WS-END-OF-DATA              PIC X(01).                   
               88  WS-NO-MORE-DATA                   VALUE 'N'.         
      *                                                                         
       01  WS-HOLD-AREA.                                                
           05  RS-RETURN-CODE              PIC S9(09) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-HOLD-DATE                PIC X(10).                   
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-INPUT-DATE               PIC X(10)   VALUE SPACES.    
           05  WS-DISPLAY-RC               PIC ---9.                    
           05  WS-DATE-TRAN-NI             PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-PYMT-START-NI       PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-INTST-CALC-TO-NI    PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-CERT-ISSUE-NI       PIC S9(4) COMP VALUE 0.      
           05  WS-DUMMY                    PIC X(1).                    
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PCSCA837                 PIC X(08) VALUE 'PCSCA837'.  
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA837 ENDS HERE  '.            
      *                                                                         
      * DECLARE STATEMENT FOR DEPOSIT REVIEW CURSOR                             
      *                                                                         
           EXEC SQL                                                     
                DECLARE DEPOSIT_CSR CURSOR FOR                          
                 SELECT ACCOUNT_NO                                      
                       ,AMT_DEPOSIT                                     
                       ,AMT_REFUNDED                                    
                       ,DATE_TRAN                                       
                       ,INTRST_YTD                                      
                       ,TOTAL_INTRST                                    
                       ,DATE_PYMT_START                                 
                       ,DATE_INTST_CALC_TO                              
                       ,CODE_REFUND_STATUS                              
                       ,DEPOSIT_STATUS_CD                               
                       ,DEPOSIT_CERT_NO                                 
                       ,DATE_CERT_ISSUE                                 
                   FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                   
                  WHERE DEPOSIT_STATUS_CD IN ('A','P')                  
                    AND DATE_TRAN < IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )                       
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DEPOSIT_CSR CURSOR FOR                                  
MFA-TR*          SELECT ACCOUNT_NO                                              
MFA-TR*                ,AMT_DEPOSIT                                             
MFA-TR*                ,AMT_REFUNDED                                            
MFA-TR*                ,DATE_TRAN                                               
MFA-TR*                ,INTRST_YTD                                              
MFA-TR*                ,TOTAL_INTRST                                            
MFA-TR*                ,DATE_PYMT_START                                         
MFA-TR*                ,DATE_INTST_CALC_TO                                      
MFA-TR*                ,CODE_REFUND_STATUS                                      
MFA-TR*                ,DEPOSIT_STATUS_CD                                       
MFA-TR*                ,DEPOSIT_CERT_NO                                         
MFA-TR*                ,DATE_CERT_ISSUE                                         
MFA-TR*            FROM CSS_DEP_ON_HAND                                         
MFA-TR*           WHERE DEPOSIT_STATUS_CD IN ('A','P')                          
MFA-TR*             AND DATE_TRAN < :WS-HOLD-DATE                               
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **  0000-MAINLINE ..                                           **         
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                  **         
      *****************************************************************         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 1000-MAIN-PROCESS         THRU 1000-EXIT             
             UNTIL WS-NO-MORE-DATA.                                     
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  0100-INITIALIZATION ..                                     **         
      **       COMMON INITIALIZATION ROUTINE                         **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
           OPEN OUTPUT FCSCA837-FILE.                                   
      *                                                                         
           IF FCA837-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSCA837 OPEN.  STATUS IS '       
                        WS-FCA837-STATUS                                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           PERFORM 7030-GET-NEXT-DAY THRU 7030-EXIT.                    
      *                                                                         
           MOVE 'Y'               TO WS-END-OF-DATA.                    
           MOVE ZEROES            TO WS-FCA837-CO-REC-COUNT             
                                     WS-FCA837-READ-COUNT.              
      *                                                                         
           PERFORM 4100-WRITE-BEGIN-CONTROLS THRU 4100-EXIT.            
           PERFORM 7000-OPEN-DEPOSIT-CSR     THRU 7000-EXIT.            
           PERFORM 7010-FETCH-DEPOSIT-CSR    THRU 7010-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 1000-MAIN-PROCESS ..                                        **         
      **        INPUT PROCESSING CONTROL                             **         
      *****************************************************************         
       1000-MAIN-PROCESS.                                               
           ADD 1 TO WS-FCA837-CO-REC-COUNT.                             
           PERFORM 2040-MOVE-DATA         THRU 2040-EXIT.               
           PERFORM 8900-WRITE-FCSCA837    THRU 8900-EXIT.               
           PERFORM 7010-FETCH-DEPOSIT-CSR THRU 7010-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  2040-MOVE-DATA                                             **         
      **  THIS PARAGRAPH MOVES DATA TO THE OUTPUT FILE LAYOUT.       **         
      *****************************************************************         
       2040-MOVE-DATA.                                                  
           MOVE DO-ACCOUNT-NO         TO E-FCA837-ACCOUNT-NO.           
           MOVE DO-AMT-DEPOSIT        TO E-FCA837-AMT-DEPOSIT.          
           MOVE DO-AMT-REFUNDED       TO E-FCA837-AMT-REFUNDED.         
           MOVE DO-DATE-TRAN          TO E-FCA837-DATE-TRAN.            
           MOVE DO-INTRST-YTD         TO E-FCA837-INTRST-YTD.           
           MOVE DO-TOTAL-INTRST       TO E-FCA837-TOTAL-INTRST.         
           MOVE DO-DATE-PYMT-START    TO E-FCA837-DATE-PYMT-START.      
           MOVE DO-DATE-INTST-CALC-TO TO E-FCA837-DATE-INTST-CALC-TO.   
           MOVE DO-CODE-REFUND-STATUS TO E-FCA837-CODE-REFUND-STATUS.   
           MOVE DO-DEPOSIT-STATUS-CD  TO E-FCA837-DEPOSIT-STATUS-CD.    
           MOVE DO-DEPOSIT-CERT-NO    TO E-FCA837-DEPOSIT-CERT-NO.      
           MOVE DO-DATE-CERT-ISSUE    TO E-FCA837-DATE-CERT-ISSUE.      
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00075602
      *****************************************************************         
      ** 4100-WRITE-BEGIN-CONTROLS ..                                **         
      **                  WRITES BEGINNING CONTROL RECORD            **         
      *****************************************************************         
       4100-WRITE-BEGIN-CONTROLS.                                       
           MOVE LOW-VALUES     TO E-FCA837-KEY-BREC.                    
           MOVE ZEROES         TO E-FCA837-DB-PART-BREC.                
           MOVE WS-INPUT-DATE  TO E-FCA837-CREATE-DATE-BREC.            
      *                                                                         
           PERFORM 8900-WRITE-FCSCA837 THRU 8900-EXIT.                  
           SUBTRACT 1 FROM WS-FCA837-READ-COUNT.                        
           INITIALIZE E-FCA837-DATA-REC.                                
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 4200- WRITE-END-CONTROLS ..                                 **         
      **               WRITES ENDING CONTROL RECORD                  **         
      *****************************************************************         
       4200-WRITE-END-CONTROLS.                                         
           INITIALIZE E-FCA837-DATA-REC.                                
      *                                                                         
           MOVE HIGH-VALUES          TO E-FCA837-KEY-EREC.              
           MOVE ZERO                 TO E-FCA837-DB-PART-EREC.          
           MOVE WS-FCA837-READ-COUNT TO E-FCA837-RECORD-COUNT-EREC.     
      *                                                                         
           PERFORM 8900-WRITE-FCSCA837  THRU 8900-EXIT.                 
      *                                                                         
       4200-EXIT.                                                       
      *                                                                         
      *****************************************************************         
      **  7000-OPEN-DEPOSIT-CSR                                      **         
      **  THIS PARAGRAPH OPENS THE DRIVING CURSOR TO THE PROGRAM.    **         
      *****************************************************************         
       7000-OPEN-DEPOSIT-CSR.                                           
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             OPEN DEPOSIT_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
                CONTINUE                                                
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA837******************'    
               DISPLAY '*   PARAGRAPH = ' WS-ACTIVE-PARAGRAPH           
               DISPLAY '* DESCRIPTION = OPEN-DEPOSIT-CSR          *'    
               DISPLAY '*          RC = ' WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA837******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7010-FETCH-DEPOSIT-CSR                                     **         
      **  THIS PARAGRAPH FETCHES DATA FROM THE DRIVING CURSOR.       **         
      *****************************************************************         
       7010-FETCH-DEPOSIT-CSR.                                          
           MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              FETCH DEPOSIT_CSR                                         
               INTO :DO-ACCOUNT-NO                                      
                   ,:DO-AMT-DEPOSIT                                     
                   ,:DO-AMT-REFUNDED                                    
                   ,:DO-DATE-TRAN :WS-DATE-TRAN-NI                       
                   ,:DO-INTRST-YTD                                      
                   ,:DO-TOTAL-INTRST                                    
                   ,:DO-DATE-PYMT-START :WS-DATE-PYMT-START-NI           
                   ,:DO-DATE-INTST-CALC-TO :WS-DATE-INTST-CALC-TO-NI     
                   ,:DO-CODE-REFUND-STATUS                              
                   ,:DO-DEPOSIT-STATUS-CD                               
                   ,:DO-DEPOSIT-CERT-NO                                 
                   ,:DO-DATE-CERT-ISSUE :WS-DATE-CERT-ISSUE-NI           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              IF WS-DATE-TRAN-NI < 0                                    
                 MOVE ZEROES TO WS-DATE-TRAN-NI                         
                 MOVE SPACES TO DO-DATE-TRAN                            
              END-IF                                                    
              IF WS-DATE-INTST-CALC-TO-NI < 0                           
                 MOVE ZEROES TO WS-DATE-INTST-CALC-TO-NI                
                 MOVE SPACES TO DO-DATE-INTST-CALC-TO                   
              END-IF                                                    
              IF WS-DATE-CERT-ISSUE-NI < 0                              
                 MOVE ZEROES TO WS-DATE-CERT-ISSUE-NI                   
                 MOVE SPACES TO DO-DATE-CERT-ISSUE                      
              END-IF                                                    
              IF WS-DATE-PYMT-START-NI < 0                              
                 MOVE ZEROES TO WS-DATE-PYMT-START-NI                   
                 MOVE SPACES TO DO-DATE-PYMT-START                      
              END-IF                                                    
           ELSE                                                         
              IF SQLCODE = NOT-FOUND                                    
                 MOVE 'N' TO WS-END-OF-DATA                             
              ELSE                                                      
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*****************PCSCA837******************'  
                 DISPLAY '*   PARAGRAPH = ' WS-ACTIVE-PARAGRAPH         
                 DISPLAY '* DESCRIPTION = FETCH-DEPOSIT-CSR         *'  
                 DISPLAY '*          RC = ' WS-DISPLAY-RC               
                 DISPLAY '*   ACCOUNT # = ' DO-ACCOUNT-NO               
                 DISPLAY '* PROGRAM ABENDING...                     *'  
                 DISPLAY '*****************PCSCA837******************'  
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7020-CLOSE-DEPOSIT-CSR                                     **         
      **  THIS PARAGRAPH CLOSES THE MAIN PROCESSING CURSOR.          **         
      *****************************************************************         
       7020-CLOSE-DEPOSIT-CSR.                                          
           MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE DEPOSIT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-DISPLAY-RC                             
              DISPLAY '*****************PCSCA837******************'     
              DISPLAY '*   PARAGRAPH = ' WS-ACTIVE-PARAGRAPH            
              DISPLAY '* DESCRIPTION = CLOSE DEPOSIT_CSR         *'     
              DISPLAY '*          RC = ' WS-DISPLAY-RC                  
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCA837******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      7030-GET-NEXT-DAY.                                        *        
      ******************************************************************        
       7030-GET-NEXT-DAY.                                               
           MOVE '7030' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
                    ,DATEADD( DAY, 1, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )                               
                  INTO :WS-INPUT-DATE                                   
                      ,:WS-HOLD-DATE                                    
               FROM CSS_MODEL_SQL                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*             ,CURRENT DATE + 1 DAY                                       
MFA-TR*           INTO :WS-INPUT-DATE                                           
MFA-TR*               ,:WS-HOLD-DATE                                            
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           DISPLAY '** INPUT DATE = ' WS-INPUT-DATE.                    
           DISPLAY '** HOLD DATE = ' WS-HOLD-DATE.                      
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA837******************'    
               DISPLAY '*   PARAGRAPH = ' WS-ACTIVE-PARAGRAPH           
               DISPLAY '* DESCRIPTION = RETURN CODE ERROR         *'    
               DISPLAY '*          RC = ' WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA837******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 8900-WRITE-FCSCA837..                                      **          
      **           WRITES OUT DATA TO FCSCA837 FILE                 **          
      ****************************************************************          
       8900-WRITE-FCSCA837.                                             
           WRITE E-FCA837.                                              
      *                                                                         
           IF  FCA837-SUCCESSFUL                                        
               ADD 1                   TO WS-FCA837-READ-COUNT          
           ELSE                                                         
               DISPLAY  '8900-ERROR ON FCSCA837 WRITE. STATUS IS '      
                         WS-FCA837-STATUS                               
               PERFORM  9900-ABEND  THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
           INITIALIZE E-FCA837-DATA-REC.                                
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  9000-TERMINATE ..                                          **         
      **                    CLOSES INPUT & OUTPUT FILES              **         
      **                                                             **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 7020-CLOSE-DEPOSIT-CSR    THRU 7020-EXIT.            
           PERFORM 4200-WRITE-END-CONTROLS   THRU 4200-EXIT.            
      *                                                                         
           CLOSE FCSCA837-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *     9700-PROCESS-ABEND COPYBOOK                          ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      *     9900-ABEND COPYBOOK            *                                    
      **************************************                                    
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
