       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA827.                                        
       DATE-WRITTEN.   MAY 2004.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                   COLUMBIA, SC 29218                        **         
      **                     (803) 748-3000                          **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________   ___________________________________   **         
C31270**  09/21/04    SJB       INITIAL REQUEST FOR PROGRAM.         **         
      **                        (DUPLICATE OF PCSCA817; EXCEPT THIS  **         
      **                         PROGRAM CHECKS FOR 'ACTIVE' DEPOSIT **         
      **                         STATUS CODE)                        **         
T31996**  03/01/05  RB19957     SWITCHED TO USING INPUT FILE INSTEAD ** 00419300
T31996**                        OF CURSOR SO THE REPORT WOULD MATCH  ** 00419300
T31996**                        GL REPORT 127.                       ** 00419300
T34393**  08/09/06  RB19957     CHANGE PROGRAM TO DO INTEREST ON SEB **         
T34393**                        ACCOUNTS @ 6 MONTHS INSTEAD OF 7.    **         
T34393**                        ALSO CHANGED ALL MODEL_SQL CODE TO   **         
T34393**                        SET.                                 **         
C35671**  09/27/07  CVNS        NAME AND ADDRESS FORMAT CHANGES      **         
C35671**            CHENNAI                                          **         
A04527**  11/15/13  DB41297     ADD QUERYNO AND WITH UR.             **         
ACT209**                                                             **         
A04527**  11/26/13  AS7C117     REMOVE COMPOUND INTEREST CALC LOGIC  **         
ACT214**                        AND UNUSED CODE.                     **         
      **                                                             ** 00419300
      ***************************************************************** 00419300
      *****************************************************************         
      *    REMARKS.                                                   *         
      *        -------------- PCSCA827 NARRATIVE --------------       *         
      ******** ---------------------------------------------- *********         
      ********                                                *********         
      *   THIS PROGRAM CREATES AN EXTRACT FILE WHICH IS USED          *         
      *   TO PRODUCE THE 'DEPOSITS AND INTEREST' DAILY REPORT.        *         
      ********                                                *********         
      ******** ---------------------------------------------- *********         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES                
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TO-TOP-OF-PAGE.                       
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSRP827.                                                           
T31996 COPY CSSCA837.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDRP827.                                                           
       COPY FIORP827.                                                           
T31996 COPY CFDCA837.                                                           
T31996 COPY FIOCA837.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA827'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA827 STARTS HERE'.            
      *                                                                         
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      **    THE FOLLOWING FIELDS ARE USED IN ABEND SITUATIONS.      **          
      **    THEY STORE THE ACTIVE PARAGRAPH NUMBER, AND FORCE       **          
      **    A DATA EXCEPTION IN THE ABEND PARAGRAPHS.               **          
      ****************************************************************          
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE          PIC X VALUE SPACE.               
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                       PIC 9.                           
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
      *COPY OF CWS00074 FOLLOWS.                                                
      ****************************************************************  00000100
      * CWS00074    WORKING STORAGE FOR CPD00074                        00000200
      *             CREATE MAIL NAME AND ADDRESS                        00000300
      **************************************************************    00000400
       01 CWS00074-FIELDS.                                              
      *                                                                 00000600
           05  SUB1                        PIC S9(04) COMP.             
           05  SUB2                        PIC S9(04) COMP.             
           05  WS-BUSINESS-NAME-ENTRY      PIC X(185).                  
C35671     05  WS-CUSTOMER-NAME            PIC X(96).                   
      *  ACCOUNT NAME WILL CONTAIN CUSTOMER NAME IF NO SEPARATE         00001200
      *  ACCOUNT NAME EXISTS                                            00001300
C35671     05  WS-ACCOUNT-NAME             PIC X(96).                   
      *                                                                 00005900
      **************************************************************    00006000
      *    WS-NAME-TABLE HOLDS THE NAMES AS THEY ARE LOADED FROM   *    00006100
      *    NAME TABLE. AFTER INTERROGATING THE NAME, AND REMOVING  *    00006200
      *    IMBEDDED SPACES, THE NAME IS PUT IS WS-NAME.            *    00006300
      **************************************************************    00006400
       01  WS-NAME-TABLE.                                               
           05  WS-NAME-ENTRY             OCCURS 5                       
                                         INDEXED BY WS-NAME-INDX.       
               10 WS-NAME-TYPE            PIC X(2).                     
               10 WS-NAME-FORMAT          PIC X(1).                     
               10 WS-FIRST-NAME           PIC X(15).                    
               10 WS-MIDDLE-NAME          PIC X(15).                    
C35671         10 WS-LAST-NAME            PIC X(40).                    
C35671         10 WS-NICKNAME             PIC X(50).                    
               10 WS-TITLE-PREFIX         PIC X(9).                     
               10 WS-TITLE-SUFFIX-1       PIC X(3).                     
               10 WS-TITLE-SUFFIX-2       PIC X(3).                     
C35671         10 WS-FULL-NAME            PIC X(70).                    
               10  WS-NAME.                                             
                   15  WS-NAME-ATTN-CO      PIC X(06).                  
C35671             15  WS-NAME-REST         PIC X(90).                  
                                                                        
       01  WS-FORMATTED-NAME.                                           
C35671         10 WS-FMT-LAST-NAME        PIC X(40).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-FIRST-NAME       PIC X(15).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-MIDDLE-NAME      PIC X(15).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-TITLE-SUFFIX-1   PIC X(3).                     
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-TITLE-SUFFIX-2   PIC X(3).                     
      *                                                                 00018500
#4691  01  WS-SQL-ERROR-FIELDS-74.                                      
#4691      10  WS-TABLE-ID-74               PIC XX.                     
#4691      10  WS-FUNCTION-74               PIC X(6).                   
#4691      10  WS-RETURN-CODE-74            PIC S9(3).                  
#4691      10  WS-PARAGRAPH-74              PIC X(4).                   
#4691      10  WS-DB2-KEY-1-74.                                         
#4691          15  WS-DB2-KEY-1N-74         PIC 9(13).                  
#4691          15  FILLER                   PIC X(7).                   
#4691      10  WS-DB2-KEY-2-74.                                         
#4691          15  WS-DB2-KEY-2N-74         PIC 9(13).                  
#4691          15  FILLER                   PIC X(7).                   
      *                                                                 00019700
      *END OF COPY OF CWS00074.                                                 
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      ** ===========>  DB2 TABLES INCLUDED IN PROGRAM  <=========== **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC                                                             
      *                                                                         
           EXEC SQL                                                     00930000
              INCLUDE TBPREM                                            00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
           EXEC SQL                                                     00930000
              INCLUDE TBDEPINT                                          00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
           EXEC SQL                                                     00930000
              INCLUDE TBDEPHST                                          00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS0223B                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FRP827-CO-REC-COUNT      PIC 9(07) VALUE ZERO.        
           05  WS-FRP827-READ-COUNT        PIC 9(07) VALUE ZERO.        
T31996     05  WS-FCA837-READ-COUNT        PIC 9(07) VALUE ZERO.        
           05  WS-FRP827-STATUS            PIC X(02).                   
               88  FRP827-SUCCESSFUL                 VALUE '00'.        
T31996     05  WS-FCA837-STATUS            PIC X(02).                   
T31996         88  FCA837-SUCCESSFUL                 VALUE '00'.        
           05  WS-END-OF-DATA              PIC X(01).                   
               88  WS-NO-MORE-DATA                   VALUE 'N'.         
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
      *                                                                         
       01  WS-HOLD-AREA.                                                
COB305     05 WS-PREVIOUS-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-NULL-DEPOSIT-AMT         PIC S9(04) COMP.             
           05  WS-NULL-REFUND-AMT          PIC S9(04) COMP.             
           05  RS-RETURN-CODE              PIC S9(09) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-HOLD-DATE4               PIC  X(10).                  
           05  WS-HOLD-DATE7               PIC  X(10).                  
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.  
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-PREVIOUS-ACCOUNT-NO      PIC 9(13) VALUE ZEROES.      
           05  WS-DISPLAY-RC               PIC ---9.                    
           05  WS-DATE-TRAN-NI             PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-PYMT-START-NI       PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-INTST-CALC-TO-NI    PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-CERT-ISSUE-NI       PIC S9(4) COMP VALUE 0.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PCSCA827                 PIC X(08) VALUE 'PCSCA827'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA827'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA827'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-P                        PIC X(01) VALUE 'A'.         
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  WS-O                        PIC X(01) VALUE 'O'.         
           05  WS-REV-A                    PIC X(01) VALUE 'A'.         
           05  WS-REV-C                    PIC X(01) VALUE 'C'.         
           05  WS-ACCEPT-DATE.                                          
               10  WS-ACCEPT-DATE-CC       PIC X(02).                   
               10  WS-ACCEPT-DATE-YY       PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-ACCEPT-DATE-MM       PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-ACCEPT-DATE-DD       PIC X(02).                   
      *                                                                         
      ****************************************************************          
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA827 ENDS HERE  '.            
      *                                                                         
      *****************************************************************         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **  0000-MAINLINE ..                                           **         
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                  **         
      **                                                             **         
      *****************************************************************         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 4100-WRITE-BEGIN-CONTROLS THRU 4100-EXIT.            
      *                                                                         
T31996     PERFORM 8300-READ-FCSCA837 THRU 8300-EXIT.                   
T31996     PERFORM 1000-MAIN-PROCESS THRU 1000-EXIT                     
T31996         UNTIL E-FCA837-KEY-EREC = LOW-VALUES OR                  
T31996               WS-NO-MORE-DATA.                                   
      *                                                                         
           PERFORM 4200-WRITE-END-CONTROLS   THRU 4200-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  0100-INITIALIZATION ..                                     **         
      **       COMMON INITIALIZATION ROUTINE                         **         
      **                                                             **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSRP827-FILE.                                   
      *                                                                         
           IF FRP827-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP827 OPEN.  STATUS IS '       
                        WS-FRP827-STATUS                                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
T31996     OPEN INPUT FCSCA837-FILE.                                    
T31996*                                                                         
T31996     IF FCA837-SUCCESSFUL                                         
T31996         CONTINUE                                                 
T31996     ELSE                                                         
T31996         DISPLAY '0100-ERROR ON FCSRP837 OPEN.  STATUS IS '       
T31996                  WS-FCA837-STATUS                                
T31996         PERFORM 9900-ABEND THRU 9900-EXIT                        
T31996     END-IF.                                                      
T31996*                                                                         
           MOVE '01'                     TO C8-COMPANY-NO.              
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           PERFORM 7510-GET-DATABASE     THRU 7510-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-PARM     TO WS-COMMAND.                             
           MOVE  SPACES      TO WS-SYSIPT.                              
      *                                                                         
           MOVE 'Y'               TO WS-END-OF-DATA.                    
           MOVE ZEROES            TO WS-FRP827-CO-REC-COUNT             
T31996                               WS-FCA837-READ-COUNT               
                                     WS-FRP827-READ-COUNT.              
      *                                                                         
T31996     PERFORM 8300-READ-FCSCA837 THRU 8300-EXIT.                   
T31996     IF E-FCA837-KEY-BREC NOT = LOW-VALUES                        
T31996         DISPLAY '************* PCSCA827 *******************'     
T31996         DISPLAY '* INPUT FILE FCSCA837 HAS NO HEADER REC  *'     
T31996         DISPLAY '************* PCSCA827 *******************'     
T31996         PERFORM 9900-ABEND                 THRU 9900-EXIT        
T31996     END-IF.                                                      
T31996     MOVE E-FCA837-CREATE-DATE-BREC TO WS-INPUT-DATE              
T31996                                       WS-CURRENT-DATE.           
      *                                                                         
           PERFORM 7040-GET-PREV-DATE4 THRU 7040-EXIT.                  
           PERFORM 7050-GET-PREV-DATE7 THRU 7050-EXIT.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 1000-MAIN-PROCESS ..                                        **         
      **        INPUT PROCESSING CONTROL                             **         
      **                                                             **         
      *****************************************************************         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           ADD 1              TO WS-FRP827-CO-REC-COUNT.                
           PERFORM 7500-SELECT-ACCT-INFO    THRU 7500-EXIT.             
           PERFORM 7520-SELECT-PREMISE-INFO THRU 7520-EXIT.             
           IF DO-AMT-DEPOSIT > 0                                        
              PERFORM 5995-DEPOSIT-INTEREST-CALC  THRU 5995-EXIT        
           END-IF.                                                      
           PERFORM 4000-MAIL-NAME-ADDRESS   THRU 4000-EXIT.             
           PERFORM 2040-MOVE-DATA           THRU 2040-EXIT.             
           PERFORM 8900-WRITE-FCSRP827      THRU 8900-EXIT.             
T31996     PERFORM 8300-READ-FCSCA837       THRU 8300-EXIT.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  2040-MOVE-DATA                                             **         
      **                                                             **         
      **  THIS PARAGRAPH MOVES DATA TO THE OUTPUT FILE LAYOUT.       **         
      **                                                             **         
      *****************************************************************         
       2040-MOVE-DATA.                                                  
      *                                                                         
           IF SEB-DATABASE                                              
               PERFORM 7530-SELECT-REG-GROUP-CD THRU 7530-EXIT          
           ELSE                                                         
               MOVE '0' TO E-FRP827-REG-GROUP                           
           END-IF.                                                      
           MOVE AT-COMPANY-NO         TO E-FRP827-COMPANY-NO.           
           MOVE AT-CUSTOMER-NO        TO E-FRP827-CUST-NO.              
           MOVE AT-ACCOUNT-NO         TO E-FRP827-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NAME       TO E-FRP827-CUST-NAME.            
           MOVE AT-CREDIT-GROUP       TO E-FRP827-CREDIT-GROUP.         
           MOVE DO-DATE-TRAN          TO E-FRP827-DATE-DEPOSIT-RECD.    
           MOVE DO-AMT-DEPOSIT        TO E-FRP827-LIABLE-AMT.           
           MOVE WS-INTEREST-CALC      TO E-FRP827-AMT-INTEREST.         
           PERFORM 7540-SELECT-REVENUE-CLASS THRU 7540-EXIT.            
           MOVE BG-CODE-REVENUE-CLASS(2:1) TO E-FRP827-REV-CLASS.       
           EVALUATE E-FRP827-REV-CLASS                                  
               WHEN '1'                                                 
                  MOVE '1' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '2'                                                 
                  MOVE '2' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '3'                                                 
                  MOVE '3' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '6'                                                 
                  MOVE '4' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '7'                                                 
                  MOVE '4' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '8'                                                 
                  MOVE '2' TO E-FRP827-REV-CLASS-SORT                   
               WHEN '9'                                                 
                  MOVE '5' TO E-FRP827-REV-CLASS-SORT                   
               WHEN OTHER                                               
                  MOVE '6' TO E-FRP827-REV-CLASS-SORT                   
           END-EVALUATE.                                                
           IF AT-COMPANY-NO = '26'                                      
               IF DO-DATE-TRAN < WS-HOLD-DATE4                          
                   MOVE '1' TO E-FRP827-DATE-DEP-SORT                   
               ELSE                                                     
                   MOVE '2' TO E-FRP827-DATE-DEP-SORT                   
               END-IF                                                   
           ELSE                                                         
               IF DO-DATE-TRAN < WS-HOLD-DATE7                          
                   MOVE '1' TO E-FRP827-DATE-DEP-SORT                   
               ELSE                                                     
                   MOVE '2' TO E-FRP827-DATE-DEP-SORT                   
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  4XXX-XXXXXXX.....                                          **         
      **                                                             **         
      **  THE FOLLOWING 4000 SERIES PARAGRAPHS ARE FROM CPD00074.    **         
      **  CHANGES MADE IS TO USE FORMAT OF LAST NAME, FIRST NAME,    **         
      **  MIDDLE NAME, AND SUFFIX - REDUCING EMBEDDED BLANKS.        **         
      **                                                             **         
      *****************************************************************         
      *                                                                 00011500
       4000-MAIL-NAME-ADDRESS.                                          
           INITIALIZE WS-EMB-INPUT                                      
                      WS-NAME-TABLE                                     
                      WS-FORMATTED-NAME                                 
                      WS-CUSTOMER-NAME                                  
                      WS-ACCOUNT-NAME.                                  
                                                                        
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           PERFORM 4010-GET-ALL-NAMES  THRU 4010-EXIT.                  
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4010-GET-ALL-NAMES.                                              
           PERFORM 4070-OPEN-NAME-CURSOR THRU 4070-EXIT-OPEN.           
           PERFORM 4070-FETCH-NAME       THRU 4070-EXIT-FETCH.          
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             PERFORM 4040-MOVE-DQ-TO-WS THRU 4040-EXIT                  
             PERFORM 4070-FETCH-NAME    THRU 4070-EXIT-FETCH            
           END-PERFORM.                                                 
           PERFORM 4070-CLOSE-NAME THRU 4070-EXIT-CLOSE.                
T15310     PERFORM 4071-SELECT-BILL-NAME THRU 4071-EXIT.                
      * SAVE CUSTOMER NAME                                              00016000
           IF WS-NAME-TYPE (2) = 'CN'                                   
              SET WS-NAME-INDX TO 2                                     
              PERFORM 4020-FORMAT-NAME THRU 4020-EXIT                   
              MOVE WS-NAME (WS-NAME-INDX) TO WS-CUSTOMER-NAME           
                                             WS-ACCOUNT-NAME            
           END-IF.                                                      
      * IF MAILING NAME('AN') EXISTS, THEN CUSTOMER NAME 'CN'           00016800
      * SHOULD NOT BE USED                                              00016900
      *                                                                 00017000
           IF WS-NAME-TYPE (3) = 'AN'                                   
              MOVE WS-NAME-ENTRY (3) TO WS-NAME-ENTRY (2)               
              MOVE SPACES            TO WS-NAME-ENTRY (3)               
      *                                                                         
T13190        SET WS-NAME-INDX TO 2                                     
              PERFORM 4020-FORMAT-NAME THRU 4020-EXIT                   
              MOVE WS-NAME (WS-NAME-INDX) TO WS-ACCOUNT-NAME            
      *                                                                         
           END-IF.                                                      
      *                                                                 00018600
      * IF CUSTOMER/BILLING NAME IS 'B' (BUSINESS), IT SHOULD BE        00018700
      * SHIFTED SO THAT IT IS THE LAST NAME THAT APPEARS BEFORE         00018800
      * THE ADDRESS                                                     00018900
      *                                                                 00019000
T15815     IF WS-NAME-TYPE (4) = 'DB'                                   
T15310         CONTINUE                                                 
           ELSE                                                         
               IF WS-NAME-FORMAT (2) = 'B'                              
                  MOVE WS-NAME-ENTRY (2) TO WS-BUSINESS-NAME-ENTRY      
                  MOVE WS-NAME-ENTRY (3) TO WS-NAME-ENTRY (2)           
                  MOVE WS-NAME-ENTRY (4) TO WS-NAME-ENTRY (3)           
                  MOVE WS-NAME-ENTRY (5) TO WS-NAME-ENTRY (4)           
                  MOVE WS-BUSINESS-NAME-ENTRY TO WS-NAME-ENTRY (5)      
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00019800
           MOVE 1 TO SUB1.                                              
           MOVE 2 TO SUB2.                                              
           PERFORM 4015-SHIFT-NAME-TABLE THRU 4015-EXIT.                
           PERFORM 4020-FORMAT-NAME THRU 4020-EXIT VARYING              
                   WS-NAME-INDX FROM 1 BY 1 UNTIL (WS-NAME-INDX > 5     
                   OR WS-NAME-ENTRY (WS-NAME-INDX) = SPACES).           
                                                                        
       4010-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    00020800
      * THIS ROUTINE SHIFTS IN THE WS TABLE UP, LEAVING BLANK           00020900
      * OCCURRENCES AT THE END.                                         00021000
      **************************************************************    00021100
       4015-SHIFT-NAME-TABLE.                                           
              IF SUB2 > 5                                               
                 GO TO 4015-EXIT
              END-IF.                                       
              IF WS-NAME-ENTRY (SUB1) = SPACES                          
                 IF WS-NAME-ENTRY (SUB2) > SPACES                       
                    MOVE WS-NAME-ENTRY (SUB2) TO WS-NAME-ENTRY (SUB1)   
                    MOVE SPACES TO WS-NAME-ENTRY(SUB2)                  
                    ADD 1 TO SUB1 SUB2                                  
                 ELSE                                                   
                    ADD 1 TO SUB2
                 END-IF                                       
              ELSE                                                      
                 ADD 1 TO SUB1 SUB2
              END-IF.                                    
              GO TO 4015-SHIFT-NAME-TABLE.                              
       4015-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00022700
      **************************************************************    00022800
      * THIS ROUTINE MOVE THE FULL NAME IF THE NAME TYPE IS BUSINESS    00022900
      * AND PUTS NAME PIECES TOGETHER TO FORM THE INDIVIDUAL'S NAME.    00023000
      ***************************************************************   00023100
       4020-FORMAT-NAME.                                                
           MOVE SPACES TO WS-FORMATTED-NAME                             
                          WS-NAME(WS-NAME-INDX)                         
                          WS-EMB-INPUT                                  
                          WS-CMP-TABLE.                                 
           IF WS-NAME-FORMAT (WS-NAME-INDX) = 'B'                       
              MOVE WS-FULL-NAME (WS-NAME-INDX) TO                       
                   WS-NAME-REST (WS-NAME-INDX)                          
           ELSE                                                         
              MOVE WS-FIRST-NAME(WS-NAME-INDX)     TO WS-FMT-FIRST-NAME 
              MOVE WS-MIDDLE-NAME(WS-NAME-INDX)    TO WS-FMT-MIDDLE-NAME
              MOVE WS-LAST-NAME(WS-NAME-INDX)      TO WS-FMT-LAST-NAME  
              MOVE WS-TITLE-SUFFIX-1(WS-NAME-INDX) TO                   
                                                 WS-FMT-TITLE-SUFFIX-1  
              MOVE WS-TITLE-SUFFIX-2(WS-NAME-INDX) TO                   
                                                 WS-FMT-TITLE-SUFFIX-2  
              MOVE WS-FORMATTED-NAME TO WS-NAME-REST (WS-NAME-INDX)     
           END-IF.                                                      
           MOVE WS-NAME (WS-NAME-INDX)  TO WS-EMB-INPUT.                
           MOVE 75 TO WS-EMB-LENG.                                      
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE TO WS-NAME (WS-NAME-INDX).                 
       4020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00026300
      **************************************************************    00046700
      * MOVE NAMES FROM NAME TABLE TO WORKING STORAGE                   00046800
      **************************************************************    00046900
      *                                                                 00047000
       4040-MOVE-DQ-TO-WS.                                              
            MOVE DQ-NAME-TYPE      TO WS-NAME-TYPE (WS-NAME-INDX).      
            MOVE DQ-NAME-FORMAT    TO WS-NAME-FORMAT (WS-NAME-INDX).    
            MOVE DQ-FIRST-NAME     TO WS-FIRST-NAME (WS-NAME-INDX).     
            MOVE DQ-MIDDLE-NAME    TO WS-MIDDLE-NAME (WS-NAME-INDX).    
            MOVE DQ-LAST-NAME      TO WS-LAST-NAME(WS-NAME-INDX).       
            MOVE SPACES            TO WS-TITLE-PREFIX(WS-NAME-INDX).    
            MOVE DQ-TITLE-SUFFIX-1 TO WS-TITLE-SUFFIX-1(WS-NAME-INDX).  
            MOVE DQ-TITLE-SUFFIX-2 TO WS-TITLE-SUFFIX-2(WS-NAME-INDX).  
            MOVE DQ-FULL-NAME      TO WS-FULL-NAME (WS-NAME-INDX).      
       4040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00048300
      ***********************************************************       00057100
      *  THIS NAME ROUTINE WILL RETRIEVE A NAME IF THE NAME ID  *       00057200
      *  IS KNOWN. THE NAME WILL BE PLACED IN THE 1ST OCCURRENCE*       00057300
      *  OF THE NAME TABLE AND WILL THEN GO THROUGH THE NAME    *       00057400
      *  FORMATTING LOGIC ROUTINE TO DETERMINE BUSINESS OR      *       00057500
      *  INDIVIDUAL NAME, AND WILL REMOVE ALL EMBEDDED SPACES   *       00057600
      *  AND PLACE THE NAME IN WS-NAME                          *       00057700
      ***********************************************************       00057800
      *                                                                 00063500
      ********                                                          00063600
      * 4070 *                                                          00063700
      ********                                                          00063800
       4070-OPEN-NAME-CURSOR.                                           
#4890      MOVE ' ' TO HT-CUSTOMER-ROLE-CD.                             
           EXEC SQL                                                     
               DECLARE NAME_CURSOR CURSOR FOR                           
               SELECT  A.NAME_ID,                                       
                       A.COMPANY_NO,                                    
                       A.CUSTOMER_NO,                                   
                       A.ACCOUNT_NO,                                    
                       A.ADDRESS_ID,                                    
                       A.PREMISE_NO,                                    
                       A.CONTACT_ID,                                    
                       B.NAME_TYPE,                                     
                       B.NAME_FORMAT,                                   
                       B.FIRST_NAME,                                    
                       B.MIDDLE_NAME,                                   
                       B.LAST_NAME,                                     
                       B.TITLE_PREFIX,                                  
                       B.TITLE_SUFFIX_1,                                
                       B.TITLE_SUFFIX_2,                                
                       B.FULL_NAME                                      
               FROM CSS_NAME_ACCT_XREF A
                           WITH(READUNCOMMITTED), CSS_NAME B
                           WITH(READUNCOMMITTED)                    
               WHERE  A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                 
                      A.NAME_ID = B.NAME_ID AND                         
#4890                 A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND     
                      B.NAME_TYPE IN ('CN', 'AN', 'AA', 'DB', 'AI')     
ACT209                                                           
ACT209                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00064000
MFA-TR*        DECLARE NAME_CURSOR CURSOR FOR                           00064100
MFA-TR*        SELECT  A.NAME_ID,                                       00064200
MFA-TR*                A.COMPANY_NO,                                    00064300
MFA-TR*                A.CUSTOMER_NO,                                   00064400
MFA-TR*                A.ACCOUNT_NO,                                    00064500
MFA-TR*                A.ADDRESS_ID,                                    00064600
MFA-TR*                A.PREMISE_NO,                                    00064700
MFA-TR*                A.CONTACT_ID,                                    00064800
MFA-TR*                B.NAME_TYPE,                                     00064900
MFA-TR*                B.NAME_FORMAT,                                   00065000
MFA-TR*                B.FIRST_NAME,                                    00065100
MFA-TR*                B.MIDDLE_NAME,                                   00065200
MFA-TR*                B.LAST_NAME,                                     00065300
MFA-TR*                B.TITLE_PREFIX,                                  00065400
MFA-TR*                B.TITLE_SUFFIX_1,                                00065500
MFA-TR*                B.TITLE_SUFFIX_2,                                00065600
MFA-TR*                B.FULL_NAME                                      00065700
MFA-TR*        FROM CSS_NAME_ACCT_XREF A, CSS_NAME B                    00065800
MFA-TR*        WHERE  A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                 00065900
MFA-TR*               A.NAME_ID = B.NAME_ID AND                         00066000
MFA-TR*               A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND     00066000
MFA-TR*               B.NAME_TYPE IN ('CN', 'AN', 'AA', 'DB', 'AI')     00066100
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 4070                                                       
MFA-TR*     END-EXEC.                                                   00066200
                                                                        
      *                                                                 00066400
            EXEC SQL                                                    
                OPEN NAME_CURSOR                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
TP5109         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
TP5109         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
TP5109         MOVE 'OPEN'                 TO ABEND-FUNCTION            
TP5109         MOVE 'CSS_NAME'             TO TABLE-1                   
TP5109         MOVE '4070'                 TO ACTIVE-PARAGRAPH          
TP5109         PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT
           END-IF.              
       4070-EXIT-OPEN.                                                  
           EXIT.                                                        
      *                                                                 00068400
       4070-FETCH-NAME.                                                 
           EXEC SQL                                                     
               FETCH NAME_CURSOR INTO                                   
                       :HT-NAME-ID,                                    
                       :HT-COMPANY-NO,                                 
                       :HT-CUSTOMER-NO,                                
                       :HT-ACCOUNT-NO,                                 
                       :HT-ADDRESS-ID,                                 
                       :HT-PREMISE-NO,                                 
                       :HT-CONTACT-ID,                                 
                       :DQ-NAME-TYPE,                                  
                       :DQ-NAME-FORMAT,                                
                       :DQ-FIRST-NAME,                                 
                       :DQ-MIDDLE-NAME,                                
                       :DQ-LAST-NAME,                                  
                       :DQ-TITLE-PREFIX,                               
                       :DQ-TITLE-SUFFIX-1,                             
                       :DQ-TITLE-SUFFIX-2,                             
                       :DQ-FULL-NAME                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
TP5109         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
TP5109         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
TP5109         MOVE 'FETCH'                TO ABEND-FUNCTION            
TP5109         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-1                   
TP5109         MOVE 'CSS_NAME'             TO TABLE-2                   
TP5109         MOVE '4070'                 TO ACTIVE-PARAGRAPH          
TP5109         MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
TP5109         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
TP5109         MOVE HT-CUSTOMER-ROLE-CD    TO HOSTVAR-ELEMENT-2         
TP5109         MOVE 'CUSTOMER_ROLE_CD'     TO TABLE-ELEMENT-2           
TP5109         PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT
           END-IF.              
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              EVALUATE DQ-NAME-TYPE                                     
                WHEN 'AA'                                               
                   SET WS-NAME-INDX TO 1                                
                WHEN 'CN'                                               
                   SET WS-NAME-INDX TO 2                                
                WHEN 'AN'                                               
                   SET WS-NAME-INDX TO 3                                
                WHEN 'DB'                                               
                   SET WS-NAME-INDX TO 4                                
                WHEN 'AI'                                               
                   SET WS-NAME-INDX TO 5                                
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       4070-EXIT-FETCH.                                                 
           EXIT.                                                        
                                                                        
       4070-CLOSE-NAME.                                                 
            EXEC SQL                                                    
              CLOSE NAME_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
TP5109         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
TP5109         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
TP5109         MOVE 'CLOSE'                TO ABEND-FUNCTION            
TP5109         MOVE 'CSS_NAME'             TO TABLE-1                   
TP5109         MOVE '4070'                 TO ACTIVE-PARAGRAPH          
TP5109         PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT
           END-IF.              
       4070-EXIT-CLOSE.                                                 
           EXIT.                                                        
      *                                                                 00075602
T15310 4071-SELECT-BILL-NAME.                                           
      *                                                                 00075602
T15310     EXEC SQL                                                     
T15310        SELECT B.FULL_NAME,                                       
T15310               B.NAME_FORMAT,                                     
T15310               B.NAME_TYPE                                        
T15310          INTO :DQ-FULL-NAME,                                     
T15310               :DQ-NAME-FORMAT,                                   
T15310               :DQ-NAME-TYPE                                      
T15310          FROM CSS_ACCT_BILL_NMES A WITH(READUNCOMMITTED),                
T15310               CSS_NAME B WITH(READUNCOMMITTED)                           
T15754         WHERE A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                  
T15310               A.NAME_ID = B.NAME_ID AND                          
T15310               A.NAME_TYPE = 'DB'                                 
ACT209                                                           
ACT209                                                      
T15310     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00075605
MFA-TR*       SELECT B.FULL_NAME,                                       00075606
MFA-TR*              B.NAME_FORMAT,                                             
MFA-TR*              B.NAME_TYPE                                                
MFA-TR*         INTO :DQ-FULL-NAME,                                     00075607
MFA-TR*              :DQ-NAME-FORMAT,                                   00075607
MFA-TR*              :DQ-NAME-TYPE                                      00075607
MFA-TR*         FROM CSS_ACCT_BILL_NMES A,                              00075608
MFA-TR*              CSS_NAME B                                         00075608
MFA-TR*        WHERE A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                  00075609
MFA-TR*              A.NAME_ID = B.NAME_ID AND                                  
MFA-TR*              A.NAME_TYPE = 'DB'                                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 4071                                                       
MFA-TR*    END-EXEC.                                                    00075610

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15310     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15310     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T15310        MOVE DQ-FULL-NAME TO WS-FULL-NAME (4)                     
T15310        MOVE DQ-NAME-FORMAT TO WS-NAME-FORMAT (4)                 
T15310        MOVE DQ-NAME-TYPE TO WS-NAME-TYPE (4)                     
T15310     ELSE                                                         
T15310         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T15754             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
T15310         ELSE                                                     
T15310             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE        
T15310             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
T15310             MOVE 'SELECT'               TO ABEND-FUNCTION        
T15310             MOVE 'CSS_ACCT_BILL_NMES'   TO TABLE-1               
T15310             MOVE '4071'                 TO ACTIVE-PARAGRAPH      
T15310             MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
T15310             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
T15310             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
T15310        END-IF                                                    
T15310     END-IF.                                                      
T15310 4071-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00075602
      *****************************************************************         
      ** 4100-WRITE-BEGIN-CONTROLS ..                                **         
      **                  WRITES BEGINNING CONTROL RECORD            **         
      **                                                             **         
      *****************************************************************         
       4100-WRITE-BEGIN-CONTROLS.                                       
      *                                                                         
           MOVE LOW-VALUES             TO E-FRP827-KEY-BREC.            
           MOVE ZEROES                 TO E-FRP827-DB-PART-BREC.        
T31996     MOVE WS-INPUT-DATE          TO E-FRP827-CREATE-DATE-BREC.    
      *                                                                         
           PERFORM 8900-WRITE-FCSRP827  THRU 8900-EXIT.                 
           SUBTRACT 1 FROM WS-FRP827-READ-COUNT.                        
           INITIALIZE E-FRP827-DATA-REC.                                
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 4200- WRITE-END-CONTROLS ..                                 **         
      **               WRITES ENDING CONTROL RECORD                  **         
      **                                                             **         
      *****************************************************************         
       4200-WRITE-END-CONTROLS.                                         
      *                                                                         
           INITIALIZE E-FRP827-DATA-REC.                                
      *                                                                         
           MOVE HIGH-VALUES            TO E-FRP827-KEY-EREC.            
           MOVE ZERO                   TO E-FRP827-DB-PART-EREC.        
           MOVE WS-FRP827-READ-COUNT   TO E-FRP827-RECORD-COUNT-EREC.   
      *                                                                         
           PERFORM 8900-WRITE-FCSRP827  THRU 8900-EXIT.                 
      *                                                                         
       4200-EXIT.                                                       
      *                                                                         
      ***********************************************************               
      * INCLUDE CPD00023 CALCULATE DEPOSIT INTEREST                             
      ***********************************************************               
T31996* CPD00023 WAS COMMENTED OUT AND COPIED INTO THE PROGRAM                  
T31996* BECAUSE DEP_ON_HAND INFO NEEDS TO COME FROM THE INPUT FILE.             
T31996*        INCLUDE CPD00023                                                 
      *****************************************************************         
      ***************************************************************           
      *  CPD00023    DEPOSIT INTEREST CALCULATION                   *           
      *                                                             *           
      ***************************************************************           
      *                 P R O G R A M  S U M M A R Y                *           
      *                                                             *           
      *  THIS PROCEDURE DIVISION WILL CALCULATE THE DEPOSIT PLUS    *           
      *  INTEREST DUE FOR A GIVEN DEPOSIT, BASED ON A DAILY         *           
      *  INTEREST VALUE. WHEN USING THIS CPD ALSO INCLUDE CPD00128, *           
      *  CWS0223B, AND CPD0023B IF THE PROGRAM IS BATCH OR CPD0023C *           
      *  IF THE PROGRAM IS A CICS TRASACTION.                       *           
      *                                                             *           
      ***************************************************************           
      *                                                             *           
      *                PROGRAM  MODIFICATION  LOG                   *           
      *                                                             *           
      *     DATE     INITIALS   COMMENTS                            *           
      *   --------   --------   ----------------------------------  *           
      *   10/09/95     JHR      COPYBOOK ORIGINALLY CODED.          *           
      *   05/01/96     PD       CHECK FOR NULL ON INTEREST CALC DATE*           
      *   06/20/96     CS       TPR 3753 ADD COMPOUND INTEREST TO   *           
      *                         DEPOSIT INTEREST CALCULATION.       *           
PCR482*   02/05/97     MAD      MODIFICATIONS MADE TO USE COPYBOOK  *           
      *                         FOR DEPOSIT INTEREST PROJECTIONS    *           
      *                         ON PANEL 57.                        *           
TP9420*   02/24/97     PD       COME OUT OF THE LOOP IF DEP INT INFO*           
      *                         IS NOT FOUND.                       *           
PCR482*   03/05/97     MAD      MODIFIED PARAGRAPH 5995 TO EXIT IF  *           
      *                         THE REFUND IS 'REFUNDED' OR         *           
      *                         'TRANSFERRED'.                      *           
MAD617*   06/17/97     MAD      MODIFIED THE COPYBOOK TO CHECK THE  *           
      *                         AGE OF ALL DEPOSIT PAYMENTS - SINCE *           
      *                         CSS_DEP_PAY_HST MAY CONTAIN MULTIPLE*           
      *                         PAYMENTS ON A SINGLE DEPOSIT, EACH  *           
      *                         PAYMENT DATE MUST BE EXAMINED TO    *           
      *                         DETERMINE IF IT MEETS THE AGE       *           
      *                         REQUIREMENT (> 6 MONTHS).           *           
T20796*   10/13/99     MDJ      IF INTEREST WAS CALCULATED ON AN AMT*           
      *                         MORE THAN CSS_DEP_ON_HAND AMT-DEPOSIT           
      *                         THEN INTEREST CALCULATION IS        *           
      *                         RECALCULATED ON AMT-DEPOSIT ON CSS_ *           
      *                         DEP_ON_HAND.                        *           
T23183*   05/03/01     KS88119  MODIFIED THE PROGRAM TO CALCULATE   *           
      *                         DEPOSIT INTEREST AFTER 91 DAYS FOR  *           
      *                         PSNC ACCOUNTS.                      *           
T24758*   08/30/01     AS       INITIALIZED THE FIELDS TO COMPUTE   *           
      *                         INTEREST CORRECTLY                  *           
T23980*   11/08/01     SM19366  MODIFIED THE PROGRAM TO CALCULATE   *           
      *                         DEPOSIT INTEREST AFTER 7 MONTHS FOR *           
      *                         SEB ACCOUNT (7 MTHS PER LISA RUCKER)*           
C25619*   11/14/01     SR82046  INTEREST CALCULATION FOR PSNC IS    *           
      *                         CHANGED TO CALCULATE FROM 90 DAYS   *           
      *                         FROM THE DEPOSIT PAID IN FULL       *           
C29752*   11/19/03     MDJ      IF S031 IS CALLING PROGRAM, DETERMINE           
      *                         IF MORE THAN 1 INTEREST RATE WAS    *           
      *                         USED TO CALC INT AMOUNT.  IF SO, SET*           
      *                         AN INDICATOR SO THAT S031 WILL      *           
      *                         DISPLAY 'MULT' ON PANEL 57 INSTEAD OF           
      *                         CURRENT INT RATE.                   *           
      *                         WHEN MULT INT RATES ARE USED, INCLUDE           
      *                         THE EFF-DATE-FROM ON THE INT TABLE IN           
      *                         THE NO-OF-DAYS CALCULATION.         *           
      *                         FOR PSNC, BEGIN INT CALC ON 91ST    *           
      *                         DAY, NOT 92ND.  NEEDED TO GET PREV  *           
      *                         DAY.                                *           
C29752*   01/11/03     MDJ      SET SWITCH IF INT IS RECALCULATED SO*           
      *                         THAT INTEREST HISTORY WILL BE INSERTED          
      *                         CORRECTLY IN CPD00128.              *           
T31755*   16/11/04     CVNS     MODIFIED TO USE VARIABLE FOR DEPOSIT*           
      *                CHENNAI  AMOUNT RETRIEVAL                    *           
      *                                                             *           
      ***************************************************************           
                                                                        
       5995-DEPOSIT-INTEREST-CALC.                                      
                                                                        
           MOVE '5995'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *    EXIT IF THE DEPOSIT HAS BEEN REFUNDED.                               
PCR482     IF DO-DEPOSIT-STATUS-CD = 'R' OR                             
PCR482      DO-DEPOSIT-STATUS-CD = 'T'                                  
              GO TO 5995-EXIT                                           
           END-IF.                                                      
                                                                        
      *    SET UP INTEREST RATE TABLE.                                          
           SET WS-INT-INDX TO 1.                                        
           MOVE WS-CURRENT-DATE          TO WS-REFUND-DATE.             
CS         MOVE WS-REFUND-DATE           TO P6-EFF-DATE-FROM.           
           MOVE AT-LOCAL-OFFICE          TO P6-LOCAL-OFFICE.            
           MOVE AT-COMPANY-NO            TO P6-COMPANY-NO.              
           MOVE PR-REV-DISTRICT-CD       TO P6-REV-DISTRICT-CD.         
           PERFORM 5996-OPEN-DEP-INT-RATE       THRU 5996-EXIT.         
           PERFORM 5997-FETCH-DEP-INT-RATE      THRU 5997-EXIT.         
           PERFORM 5998-LOAD-DEP-INT-RATE       THRU 5998-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 5999-CLOSE-DEP-INT-RATE      THRU 5999-EXIT.         
                                                                        
      *    DETERMINE INTEREST CALCULATION.                                      
           MOVE +0                       TO WS-INTEREST-CALC.           
C29752     MOVE 'N'                      TO WS-RECALC-SWITCH.           
T23183     IF AT-COMPANY-NO = '01' THEN                                 
T34393        PERFORM 6009-GET-DATE-6-MNT-AGO   THRU 6009-EXIT          
T23183     ELSE                                                         
T23183        PERFORM 6016-GET-DATE-91-DAYS-AGO THRU 6016-EXIT          
T23183        MOVE WS-DATE-91-DAYS-AGO   TO WS-MIN-DEP-INT-DATE         
T23183     END-IF.                                                      
           PERFORM 6000-DETERMINE-INTRST-CALC   THRU 6000-EXIT.         
      *                                                                         
      ************RESET COUNTERS FOR THE NEXT DEPOSIT**************             
CS         MOVE 0                        TO WS-NO-OF-DAYS.              
T20796     MOVE 0                        TO WS-AMT-DEPOSIT-REF.         
C29752     MOVE 'N'                      TO WS-RECALC-SWITCH.           
                                                                        
       5995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5996-OPEN-DEP-INT-RATE.                                    *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5996-OPEN-DEP-INT-RATE.                                          
                                                                        
           MOVE '5996'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              OPEN DEP-INT-RATE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5996-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5997-FETCH-DEP-INT-RATE.                                   *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC                    *            
      *              5998-LOAD-DEP-INT-RATE.                       *            
      **************************************************************            
       5997-FETCH-DEP-INT-RATE.                                         
                                                                        
           MOVE '5997'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              FETCH DEP-INT-RATE                                        
               INTO :P6-INTRST-RATE,                                    
                    :P6-EFF-DATE-FROM,                                  
                    :WS-EFF-DATE-END                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5997-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5998-LOAD-DEP-INT-RATE.                                    *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5998-LOAD-DEP-INT-RATE.                                          
                                                                        
           MOVE '5998'                TO ACTIVE-PARAGRAPH.              
                                                                        
           MOVE AT-LOCAL-OFFICE       TO WS-LOCAL-OFFICE  (WS-INT-INDX).
           MOVE PR-REV-DISTRICT-CD    TO WS-TAX-DISTRICT  (WS-INT-INDX).
           MOVE P6-INTRST-RATE        TO WS-INTRST-RATE   (WS-INT-INDX).
           MOVE P6-EFF-DATE-FROM      TO WS-EFF-DATE-FROM (WS-INT-INDX).
                                                                        
           IF WS-INT-INDX = 1                                           
              MOVE WS-REFUND-DATE      TO WS-EFF-DATE-TO (WS-INT-INDX)  
           ELSE                                                         
              MOVE WS-EFF-DATE-TO-PREV TO WS-EFF-DATE-TO (WS-INT-INDX)  
           END-IF.                                                      
                                                                        
           MOVE WS-EFF-DATE-END       TO WS-EFF-DATE-TO-PREV.           
                                                                        
           PERFORM 5997-FETCH-DEP-INT-RATE      THRU 5997-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              SET WS-INT-INDX UP BY 1                                   
           END-IF.                                                      
                                                                        
       5998-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5999-CLOSE-DEP-INT-RATE.                                   *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5999-CLOSE-DEP-INT-RATE.                                         
                                                                        
           MOVE '5999'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              CLOSE DEP-INT-RATE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6000-DETERMINE-INTRST-CALC.                                *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       6000-DETERMINE-INTRST-CALC.                                      
                                                                        
           MOVE '6000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE AT-ACCOUNT-NO               TO DP-ACCOUNT-NO.           
           MOVE DO-DEPOSIT-CERT-NO          TO DP-DEPOSIT-CERT-NO.      
T31996     MOVE DO-AMT-DEPOSIT TO WS-AMT-DEPOSIT-23.                    
                                                                        
           PERFORM 6002-OPEN-DEP-PAY-HST            THRU 6002-EXIT.     
           PERFORM 6003-FETCH-DEP-PAY-HST           THRU 6003-EXIT.     
      *                                                                         
T23183     IF (DP-DEP-PAY-DT < WS-MIN-DEP-INT-DATE AND                  
PCR482        WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
C25169        AT-COMPANY-NO = '01')                                     
C25619          OR (DO-DATE-CERT-ISSUE < WS-MIN-DEP-INT-DATE AND        
C25619                      WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND 
C25169              AT-COMPANY-NO = '26'AND DO-DATE-CERT-ISSUE > SPACES)
CS            MOVE 'Y'                      TO RS-LT-6-MOS-AGO          
CS            PERFORM 6001-PROCESS-DEP-PAYMENT         THRU 6001-EXIT   
CS                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
CS            MOVE WS-REFUND-DATE            TO DO-DATE-INTST-CALC-TO   
           ELSE                                                         
              NEXT SENTENCE                                             
CS         END-IF.                                                      
      *                                                                         
           PERFORM 6004-CLOSE-DEP-PAY-HST           THRU 6004-EXIT.     
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6001-PROCESS-DEP-PAYMENT                                   *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
CS     6001-PROCESS-DEP-PAYMENT.                                        
CS                                                                      
CS         MOVE '6001'                      TO ACTIVE-PARAGRAPH.        
                                                                        
T23183     IF (DP-DEP-PAY-DT < WS-MIN-DEP-INT-DATE  AND                 
C25619         AT-COMPANY-NO = '01') OR                                 
C25619        (DO-DATE-CERT-ISSUE < WS-MIN-DEP-INT-DATE  AND            
ACT214         AT-COMPANY-NO = '26'AND DO-DATE-CERT-ISSUE > SPACES)     
MAD617        MOVE DP-DEP-PAY-AMT        TO WS-AMOUNT-WORK              
MAD617        ADD  DP-DEP-PAY-AMT        TO WS-AMT-DEPOSIT-REF          
T31755        IF WS-AMT-DEPOSIT-REF  >   WS-AMT-DEPOSIT-23              
T31755           MOVE WS-AMT-DEPOSIT-23  TO WS-AMOUNT-WORK              
T20796           MOVE +0                 TO WS-INTEREST-CALC            
T20796                                      WS-CURR-INTRST-CALC         
C29752           MOVE 'Y'                TO WS-RECALC-SWITCH            
T20796        END-IF                                                    
C25619        IF AT-COMPANY-NO = '01'                                   
CS               IF DP-DEP-PAY-DT <= DO-DATE-INTST-CALC-TO              
CS                  MOVE DO-DATE-INTST-CALC-TO TO WS-DATE-WORK          
CS               ELSE                                                   
CS                  MOVE DP-DEP-PAY-DT         TO WS-DATE-WORK          
CS               END-IF                                                 
C25619        ELSE                                                      
C25619******************************************************************        
C25619***  THE DEPOSIT INTEREST FOR PSNC IS CALCULATED FROM 90 DAYS FROM        
C25619***  THE DEPOSIT PAYMENT DATE.                                            
C25619***  IF THE DATE INTEREST CALC IS GREATER THAN THE DEP CERT ISSUE         
C25619***  DATE THEN INTEREST NEEDS TO BE CALCULATED FROM THE DATE              
C25619***  DATE-INTST-CALC-TO.                                                  
C25619******************************************************************        
C25619           MOVE DO-DATE-CERT-ISSUE       TO WS-PYMT-DATE          
C25619           PERFORM 6017-GET-DATE-90-DAYS-AFTER THRU 6017-EXIT     
C29752           MOVE WS-DATE-90-DAYS-AFTER    TO WS-DATE-TEMP-CPD23    
C29752           PERFORM 7094-CPD23-GET-PREVIOUS-DAY  THRU              
C29752                   7094-CPD23-EXIT                                
C25619           IF WS-DATE-TEMP-CPD23 <= DO-DATE-INTST-CALC-TO         
C25619              MOVE DO-DATE-INTST-CALC-TO TO WS-DATE-WORK          
C25619           ELSE                                                   
C29752              MOVE WS-DATE-TEMP-CPD23 TO          WS-DATE-WORK    
C25619           END-IF                                                 
C25619        END-IF                                                    
                                                                        
CS            PERFORM 6012-CALCULATE-INTEREST        THRU 6012-EXIT     
           END-IF.                                                      
CS    *                                                                         
CS         PERFORM 6003-FETCH-DEP-PAY-HST  THRU 6003-EXIT.              
CS    *                                                                         
CS     6001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6002-OPEN-DEP-PAY-HST.                                     *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6002-OPEN-DEP-PAY-HST.                                           
                                                                        
           MOVE '6002'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              OPEN DEP-PAY-HST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6003-FETCH-DEP-PAY-HST.                                    *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6003-FETCH-DEP-PAY-HST.                                          
                                                                        
           MOVE '6003'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              FETCH DEP-PAY-HST                                         
               INTO :DP-DEP-PAY-DT :WS-NULL-DEP-PAY-DT-IND,              
                    :DP-DEP-PAY-AMT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-DEP-PAY-DT-IND < ZERO                          
                 MOVE LOW-VALUES         TO DP-DEP-PAY-DT               
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6004-CLOSE-DEP-PAY-HST.                                    *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6004-CLOSE-DEP-PAY-HST.                                          
                                                                        
           MOVE '6004'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              CLOSE DEP-PAY-HST                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6005-ACCUMULATE-INTEREST.                                  *            
      *                                                            *            
      * PERFORMED BY 6012-CALCULATE-INTEREST.                      *            
      **************************************************************            
       6005-ACCUMULATE-INTEREST.                                        
                                                                        
           MOVE '6005'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE WS-EFF-DATE-TO (WS-INT-INDX)   TO WS-DATE-TO.           
                                                                        
PAL        IF WS-DATE-TO > WS-REFUND-DATE                               
PAL           MOVE WS-REFUND-DATE        TO WS-DATE-TO                  
PAL        END-IF.                                                      
                                                                        
CS         IF WS-DATE-FROM > WS-DATE-TO                                 
CS            MOVE 0                     TO WS-NO-OF-DAYS               
CS         ELSE                                                         
CS            PERFORM 6006-GET-NO-OF-DAYS         THRU 6006-EXIT        
CS         END-IF.                                                      
CS    *                                                                         
CS    *                                                                         
ACT214     PERFORM 6010-CALC-SIMPLE-INTEREST   THRU 6010-CALC-EXIT      
           ADD WS-CURR-INTRST-CALC       TO WS-INTEREST-CALC.           
      *                                                                         
       6005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6006-GET-NO-OF-DAYS.                                       *            
      *                                                            *            
      * PERFORMED BY 6012-CALCULATE-INTEREST                       *            
      *              6005-ACCUMULATE-INTEREST.                     *            
      **************************************************************            
       6006-GET-NO-OF-DAYS.                                             
                                                                        
           MOVE '6006'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
T34393        SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TO) <> 0) OR (LEN(
                                                            :WS-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TO), CONVERT(DATE, 
                                                            :WS-DATE-TO
              ) ))                  
T34393                         - CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) ))
            INTO
              :WS-NO-OF-DAYS              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-OF-DAYS =                                              
MFA-TR*                        DAYS(DATE(:WS-DATE-TO))                          
MFA-TR*                        - DAYS(DATE(:WS-DATE-FROM))                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'NO TABLE'            TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6009-GET-DATE-6-MNT-AGO.                                   *            
      *                                                            *            
      * PERFORMED BY                                               *            
      **************************************************************            
       6009-GET-DATE-6-MNT-AGO.                                         
                                                                        
           MOVE '6009'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
T34393        SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-MIN-DEP-INT-DATE          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MIN-DEP-INT-DATE =                                        
MFA-TR*                        DATE(:WS-INPUT-DATE) - 6 MONTHS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34393        MOVE 'SET'                 TO ABEND-FUNCTION              
T34393        MOVE 'NO TABLE'            TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6009-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      * 6010-CALC-SIMPLE-INTEREST                                  *            
      *                                                            *            
      * PERFORMED BY 6005 TO CALCULATE SIMPLE INTEREST FOR DEPOSITS*            
      **************************************************************            
       6010-CALC-SIMPLE-INTEREST.                                       
                                                                        
           MOVE '6010'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           COMPUTE WS-CURR-INTRST-CALC ROUNDED                          
              = WS-NO-OF-DAYS * WS-AMOUNT-WORK *                        
                WS-INTRST-RATE (WS-INT-INDX) / WS-ONE-YEAR / 100.       
                                                                        
       6010-CALC-EXIT.                                                  
           EXIT.                                                        
      **************************************************************            
      * 6012-CALCULATE-INTEREST.                                   *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6012-CALCULATE-INTEREST.                                         
                                                                        
           MOVE '6012'                             TO ACTIVE-PARAGRAPH. 
                                                                        
           SET WS-INT-INDX TO 1.                                        
           SEARCH WS-INTEREST-RATE-DATA                                 
              AT END                                                    
                 CONTINUE                                               
                                                                        
TP9420        WHEN ((WS-EFF-DATE-FROM (WS-INT-INDX) <= SPACES)          
TP9420        AND   (WS-EFF-DATE-TO (WS-INT-INDX)   <= SPACES))         
TP9420           CONTINUE                                               
              WHEN ((WS-EFF-DATE-FROM (WS-INT-INDX) <= WS-DATE-WORK)    
              AND   (WS-EFF-DATE-TO (WS-INT-INDX)   >= WS-DATE-WORK))   
                 MOVE WS-DATE-WORK                TO WS-DATE-FROM       
C29752           MOVE 'N'                         TO WS-MULTIPLE-INT-IND
C29752           MOVE WS-INTRST-RATE (WS-INT-INDX) TO                   
C29752                WS-PREV-INTRST-RATE                               
                 PERFORM 6005-ACCUMULATE-INTEREST      THRU 6005-EXIT   
                 PERFORM UNTIL WS-INT-INDX = 1                          
                    SET WS-INT-INDX DOWN BY 1                           
C29752              MOVE WS-EFF-DATE-TO (WS-INT-INDX + 1)               
C29752                                             TO WS-DATE-FROM      
                    PERFORM 6005-ACCUMULATE-INTEREST   THRU 6005-EXIT   
                 END-PERFORM                                            
                                                                        
           END-SEARCH.                                                  
                                                                        
       6012-EXIT.                                                       
           EXIT.                                                        
T23183**************************************************************            
T23183* 6016-GET-DATE-91-DAYS-AGO.                                 *            
T23183*                                                            *            
T23183* THIS PARAGRAPH GETS THE DATE 91 DAYS AGO                   *            
T23183**************************************************************            
T23183 6016-GET-DATE-91-DAYS-AGO.                                       
T23183                                                                  
T23183     MOVE '6016'                   TO ACTIVE-PARAGRAPH.           
T23183                                                                  
T23183     EXEC SQL                                                     
T34393       SELECT
              DATEADD( DAY, -91, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-DATE-91-DAYS-AGO           
T23183     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-91-DAYS-AGO =                                         
MFA-TR*                        DATE(:WS-INPUT-DATE) - 91 DAYS                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23183                                                                  
T23183     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T23183                                                                  
T23183     IF SQLCODE = SUCCESSFUL-CALL                                 
T23183        NEXT SENTENCE                                             
T23183     ELSE                                                         
T23183        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T23183        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34393        MOVE 'SET'                 TO ABEND-FUNCTION              
T34393        MOVE 'NO TABLE'            TO TABLE-1                     
T23183        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
T23183     END-IF.                                                      
T23183                                                                  
T23183 6016-EXIT.                                                       
T23183     EXIT.                                                        
C25619**************************************************************            
C25619* 6017-GET-DATE-90-DAYS-AFTER                                *            
C25619*                                                            *            
C25619* THIS PARAGRAPH GETS THE DATE 91 DAYS AFTER THE PAYMENT DATE*            
C25619**************************************************************            
C25619 6017-GET-DATE-90-DAYS-AFTER.                                     
C25619                                                                  
C25619     MOVE '6017'                   TO ACTIVE-PARAGRAPH.           
C25619                                                                  
C25619     EXEC SQL                                                     
T34393       SELECT
              DATEADD( DAY, 90, IIF(TRY_CONVERT(DATE, :WS-PYMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PYMT-DATE
              ) <> 0) OR (LEN(:WS-PYMT-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PYMT-DATE
              ), CONVERT(DATE, :WS-PYMT-DATE) ) )
            INTO
              :WS-DATE-90-DAYS-AFTER            
C25619     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-90-DAYS-AFTER =                                       
MFA-TR*                        DATE(:WS-PYMT-DATE) + 90 DAYS                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25619                                                                  
C25619     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C25619                                                                  
C25619     IF SQLCODE = SUCCESSFUL-CALL                                 
C25619        NEXT SENTENCE                                             
C25619     ELSE                                                         
C25619        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C25619        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C25619        MOVE 'SET'                 TO ABEND-FUNCTION              
C25619        MOVE 'NO TABLE'            TO TABLE-1                     
C25619        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
C25619     END-IF.                                                      
C25619                                                                  
C25619 6017-EXIT.                                                       
C25619     EXIT.                                                        
C29752*                                                                         
C29752 7094-CPD23-GET-PREVIOUS-DAY.                                     
C29752                                                                  
           EXEC SQL                                                     
T34393       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-TEMP-CPD23
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TEMP-CPD23
              ) <> 0) OR (LEN(:WS-DATE-TEMP-CPD23
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TEMP-CPD23
              ), CONVERT(DATE, :WS-DATE-TEMP-CPD23) ) )
            INTO
              :WS-DATE-TEMP-CPD23       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15024604
MFA-TR*      SET :WS-DATE-TEMP-CPD23 =                                          
MFA-TR*                        DATE(:WS-DATE-TEMP-CPD23) - 1 DAYS               
MFA-TR*    END-EXEC.                                                    15024620

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34393        MOVE 'SET'                 TO ABEND-FUNCTION              
T34393        MOVE 'NO TABLE'            TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
C29752 7094-CPD23-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *      7040-GET-PREV-DATE4.                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7040-GET-PREV-DATE4.                                             
      *                                                                         
           EXEC SQL                                                     
T34393       SELECT
              DATEADD( MONTH, -4, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-HOLD-DATE4           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-HOLD-DATE4 =                                               
MFA-TR*                        DATE(:WS-INPUT-DATE) - 4 MONTH                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           DISPLAY '** HOLD DATE = ' WS-INPUT-DATE.                     
           DISPLAY '** HOLD DATE 4 = ' WS-HOLD-DATE4.                   
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7040 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *      7050-GET-PREV-DATE7.                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7050-GET-PREV-DATE7.                                             
      *                                                                         
           EXEC SQL                                                     
T34393       SELECT
              DATEADD( MONTH, -7, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-HOLD-DATE7           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-HOLD-DATE7 =                                               
MFA-TR*                        DATE(:WS-INPUT-DATE) - 7 MONTH                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           DISPLAY '** HOLD DATE 7 = ' WS-HOLD-DATE7.                   
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7050 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7500-SELECT-ACCT-INFO                                     *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7500-SELECT-ACCT-INFO.                                           
      *                                                                 15055600
           EXEC SQL                                                     
              SELECT                                                    
                  ACCOUNT_NO,                                           
                  COMPANY_NO,                                           
                  CUSTOMER_NO,                                          
                  ADDRESS_ID,                                           
                  ADDRESS_FORMAT,                                       
                  CREDIT_GROUP,                                         
                  REV_MTH_LST_NRML,                                     
                  ACCOUNT_TYPE_CODE,                                    
                  LOCAL_OFFICE,                                         
                  PREMISE_NO                                            
              INTO                                                      
                  :AT-ACCOUNT-NO,                                       
                  :AT-COMPANY-NO,                                       
                  :AT-CUSTOMER-NO,                                      
                  :AT-ADDRESS-ID,                                       
                  :AT-ADDRESS-FORMAT,                                   
                  :AT-CREDIT-GROUP,                                     
                  :AT-REV-MTH-LST-NRML,                                 
                  :AT-ACCOUNT-TYPE-CODE,                                
                  :AT-LOCAL-OFFICE,                                     
                  :AT-PREMISE-NO                                        
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO  = :DO-ACCOUNT-NO                        
ACT209                                                           
ACT209                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15055800
MFA-TR*       SELECT                                                    15055900
MFA-TR*           ACCOUNT_NO,                                                   
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           CUSTOMER_NO,                                                  
MFA-TR*           ADDRESS_ID,                                                   
MFA-TR*           ADDRESS_FORMAT,                                               
MFA-TR*           CREDIT_GROUP,                                                 
MFA-TR*           REV_MTH_LST_NRML,                                             
MFA-TR*           ACCOUNT_TYPE_CODE,                                            
MFA-TR*           LOCAL_OFFICE,                                                 
MFA-TR*           PREMISE_NO                                                    
MFA-TR*       INTO                                                      15056300
MFA-TR*           :AT-ACCOUNT-NO,                                               
MFA-TR*           :AT-COMPANY-NO,                                               
MFA-TR*           :AT-CUSTOMER-NO,                                              
MFA-TR*           :AT-ADDRESS-ID,                                               
MFA-TR*           :AT-ADDRESS-FORMAT,                                           
MFA-TR*           :AT-CREDIT-GROUP,                                             
MFA-TR*           :AT-REV-MTH-LST-NRML,                                         
MFA-TR*           :AT-ACCOUNT-TYPE-CODE,                                        
MFA-TR*           :AT-LOCAL-OFFICE,                                             
MFA-TR*           :AT-PREMISE-NO                                                
MFA-TR*       FROM CSS_ACCOUNT                                          15056700
MFA-TR*       WHERE ACCOUNT_NO  = :DO-ACCOUNT-NO                        15056800
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                    15057000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7500 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT # = ' DO-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      *  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *04880000
      ******************************************************************04900000
       7510-GET-DATABASE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
ACT209                                                           
ACT209                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************************************'          
               DISPLAY '* 7510-GET-DATABASE'                            
               DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-RC             
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7520-SELECT-PREMISE-INFO                                  *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7520-SELECT-PREMISE-INFO.                                        
      *                                                                 15055600
           EXEC SQL                                                     
              SELECT                                                    
                  REV_DISTRICT_CD                                       
              INTO                                                      
                  :PR-REV-DISTRICT-CD                                   
              FROM CSS_PREMISE WITH(READUNCOMMITTED)                            
              WHERE PREMISE_NO = :AT-PREMISE-NO                         
ACT209                                                           
ACT209                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15055800
MFA-TR*       SELECT                                                    15055900
MFA-TR*           REV_DISTRICT_CD                                               
MFA-TR*       INTO                                                      15056300
MFA-TR*           :PR-REV-DISTRICT-CD                                           
MFA-TR*       FROM CSS_PREMISE                                          15056700
MFA-TR*       WHERE PREMISE_NO = :AT-PREMISE-NO                         15056800
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7520                                                       
MFA-TR*    END-EXEC.                                                    15057000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7520 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT # = ' AT-ACCOUNT-NO                   
               DISPLAY '* PREMISE # = ' AT-PREMISE-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 13480000
      **  7530-SELECT-REG-GROUP-CD ..                                ** 13490000
      **      GETS-DATA FROM CSS_REG-PROFILE                         ** 13500000
      **                                                             ** 13510000
      ***************************************************************** 13520000
       7530-SELECT-REG-GROUP-CD.                                        
           MOVE '7530' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13550000
           EXEC SQL                                                     
               SELECT                                                   
                  REG_GROUP_CD                                          
               INTO                                                     
                  :LR-REG-GROUP-CD                                      
               FROM                                                     
                  CSS_REG_PROFILE WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
ACT209                                                           
ACT209                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13560000
MFA-TR*        SELECT                                                   13580000
MFA-TR*           REG_GROUP_CD                                          13590000
MFA-TR*        INTO                                                     13580000
MFA-TR*           :LR-REG-GROUP-CD                                      13590000
MFA-TR*        FROM                                                     13600000
MFA-TR*           CSS_REG_PROFILE                                       13610000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        13620000
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7530                                                       
MFA-TR*    END-EXEC.                                                    13630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13640000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               IF SQLCODE = NOT-FOUND                                   
                   MOVE '0' TO E-FRP827-REG-GROUP                       
               ELSE                                                     
                   MOVE '1' TO E-FRP827-REG-GROUP                       
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7530 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT # = ' AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 13720000
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13470000
      ***************************************************************** 13480000
      **  7540-SELECT-REVENUE-CLASS.                                 ** 13490000
      **      GETS THE REVENUE CLASS                                 ** 13500000
      **                                                             ** 13510000
      ***************************************************************** 13520000
       7540-SELECT-REVENUE-CLASS.                                       
           MOVE '7540' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13550000
           EXEC SQL                                                     
               SELECT TOP(1) CODE_REVENUE_CLASS                                 
               INTO                                                     
                  :BG-CODE-REVENUE-CLASS                                
               FROM                                                     
                  CSS_BILLING_DET WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
ACT209                                                           
ACT209                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13560000
MFA-TR*        SELECT                                                   13580000
MFA-TR*           CODE_REVENUE_CLASS                                    13590000
MFA-TR*        INTO                                                     13580000
MFA-TR*           :BG-CODE-REVENUE-CLASS                                13590000
MFA-TR*        FROM                                                     13600000
MFA-TR*           CSS_BILLING_DET                                       13610000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        13620000
MFA-TR*           FETCH FIRST 1 ROWS ONLY                               13620000
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7530                                                       
MFA-TR*    END-EXEC.                                                    13630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13640000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               IF SQLCODE = NOT-FOUND                                   
                   EVALUATE AT-ACCOUNT-TYPE-CODE                        
                       WHEN 'R'                                         
                         MOVE '010' TO BG-CODE-REVENUE-CLASS            
                       WHEN 'C'                                         
                         MOVE '020' TO BG-CODE-REVENUE-CLASS            
                       WHEN 'I'                                         
                         MOVE '030' TO BG-CODE-REVENUE-CLASS            
                       WHEN 'M'                                         
                         MOVE '060' TO BG-CODE-REVENUE-CLASS            
                       WHEN 'W'                                         
                         MOVE '090' TO BG-CODE-REVENUE-CLASS            
                       WHEN OTHER                                       
                         MOVE '000' TO BG-CODE-REVENUE-CLASS            
                   END-EVALUATE                                         
               ELSE                                                     
                   NEXT SENTENCE
               END-IF                                        
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA827******************'    
               DISPLAY '* 7540 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT # = ' AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA827******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 13720000
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13470000
T31996****************************************************************          
T31996**   8300-READ-FCSCA837                                       **          
T31996**       READS THE INPUT FILE FCSCA837-FILE                   **          
T31996****************************************************************          
T31996 8300-READ-FCSCA837.                                              
T31996     MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
T31996*                                                                         
T31996     READ FCSCA837-FILE                                           
T31996         AT END                                                   
T31996             MOVE WS-N TO WS-END-OF-DATA                          
T31996             GO TO 8300-EXIT.                                     
T31996*                                                                         
T31996     IF E-FCA837-KEY-EREC = HIGH-VALUES                           
T31996         MOVE WS-N TO WS-END-OF-DATA                              
T31996         GO TO 8300-EXIT                                          
T31996     END-IF.                                                      
T31996*                                                                         
T31996     IF FCA837-SUCCESSFUL                                         
T31996         ADD 1 TO WS-FCA837-READ-COUNT                            
T31996     ELSE                                                         
T31996         DISPLAY '**  PCSCA827 PROCESSING ERROR    **'            
T31996         DISPLAY '**  ERROR ON FCSCA837 READ       **'            
T31996         DISPLAY '**  STATUS IS ' WS-FCA837-STATUS                
T31996         PERFORM 9900-ABEND THRU 9900-EXIT                        
T31996     END-IF.                                                      
T31996*                                                                         
T31996     IF E-FCA837-DEPOSIT-STATUS-CD = 'P'                          
T31996         GO TO 8300-READ-FCSCA837                                 
T31996     END-IF.                                                      
T31996*                                                                         
T31996     IF E-FCA837-KEY-BREC = LOW-VALUES OR                         
T31996        E-FCA837-KEY-EREC = HIGH-VALUES                           
T31996         NEXT SENTENCE                                            
T31996     ELSE                                                         
T31996         MOVE E-FCA837-ACCOUNT-NO         TO DO-ACCOUNT-NO        
T31996         MOVE E-FCA837-AMT-DEPOSIT        TO DO-AMT-DEPOSIT       
T31996         MOVE E-FCA837-AMT-REFUNDED       TO DO-AMT-REFUNDED      
T31996         MOVE E-FCA837-DATE-TRAN          TO DO-DATE-TRAN         
T31996         MOVE E-FCA837-INTRST-YTD         TO DO-INTRST-YTD        
T31996         MOVE E-FCA837-TOTAL-INTRST       TO DO-TOTAL-INTRST      
T31996         MOVE E-FCA837-DATE-PYMT-START    TO DO-DATE-PYMT-START   
T31996         MOVE E-FCA837-DATE-INTST-CALC-TO TO DO-DATE-INTST-CALC-TO
T31996         MOVE E-FCA837-CODE-REFUND-STATUS TO DO-CODE-REFUND-STATUS
T31996         MOVE E-FCA837-DEPOSIT-STATUS-CD  TO DO-DEPOSIT-STATUS-CD 
T31996         MOVE E-FCA837-DEPOSIT-CERT-NO    TO DO-DEPOSIT-CERT-NO   
T31996         MOVE E-FCA837-DATE-CERT-ISSUE    TO DO-DATE-CERT-ISSUE   
T31996     END-IF.                                                      
T31996*                                                                         
T31996 8300-EXIT.                                                       
T31996     EXIT.                                                        
T31996*                                                                         
      ****************************************************************          
      ** 8900-WRITE-FCSRP827..                                      **          
      **           WRITES OUT DATA TO FCSRP827 FILE                 **          
      **                                                            **          
      ****************************************************************          
       8900-WRITE-FCSRP827.                                             
      *                                                                         
           WRITE E-FRP827.                                              
      *                                                                         
           IF  FRP827-SUCCESSFUL                                        
               ADD 1                   TO WS-FRP827-READ-COUNT          
           ELSE                                                         
               DISPLAY  '8900-ERROR ON FCSRP827 WRITE. STATUS IS '      
                         WS-FRP827-STATUS                               
               PERFORM  9900-ABEND  THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
           INITIALIZE E-FRP827-DATA-REC.                                
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  9000-TERMINATE ..                                          **         
      **                    CLOSES INPUT & OUTPUT FILES              **         
      **                                                             **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSRP827-FILE                                          
T31996           FCSCA837-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9700-PROCESS-ABEND                 ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *****************                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
