       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA808.                                            
       DATE-WRITTEN. AUGUST 2003.                                       
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *      PROGRAM MODIFICATION LOG                                  *00080000
      *                                                                *00090000
      *     DATE     USER ID  REASON                                   *00100000
      *   --------   -------  ---------------------------------------- *00110000
      *   08/18/03   SS82048  INITIAL CODING - EXTRACT FOR PCSRP803    *00120000
A02036*   03/08/10   VV94890  FIX TO SQLCODE 100 ISSUES FOR THE CORRES *00120000
      *                       PONDING USER-ID AND COMPANY-NO IN CSS_US *00120000
      *                       ER_PROFILE TABLE(PARA - 7410-GET-COLLECT *00120000
      *                       OR-NAME)(ACT0019).                       *00120000
P02192*   04/11/11   DB41297  FIX OUT OF SYNC BETWEEN PCSRP754.        *00120000
ACT109*   05/07/11   DB41297  DELETE TBCLAGNY COPY PER B GAUSE.        *00120000
ACT109*   05/07/11   DB41297  APPL3082                                 *00120000
      ******************************************************************00130000
      *                                                                 00140000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00200000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00230001
       COPY CSSRP803.                                                   00240001
      *                                                                 00250001
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00280001
       COPY CFDRP803.                                                   00290001
       COPY FIORP803.                                                   00300001
      *                                                                 00310001
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA808'.
MSQ017     COPY MFASQLM.
      *                                                                 00410000
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA808 STARTS HERE'.                  
      *                                                                 00440000
       01 WORK-AREAS.                                                   
          05 SQL-ERROR-SW                PIC 9(01) VALUE 0.             
             88 SQL-ERROR                          VALUE 1.             
          05 WS-COLL-EOF-SW              PIC 9(01) VALUE 0.             
             88 END-OF-COLL                        VALUE 1.             
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-Y                        PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-N                        PIC X(01) VALUE 'N'.           
          05 PROGRAM-NAME                PIC X(8)  VALUE 'PCSCA808'.    
          05 WS-PGRMNAME                 PIC X(8)  VALUE 'PCSCA808'.    
          05 DUPLICATE-ROWS              PIC S9(04) COMP VALUE -811.    
          05 WS-ACCOUNT-NO               PIC 9(13).                     
          05 WS-LOCAL-OFFICE             PIC X(03) VALUE SPACES.        
          05 WS-LST-PYMT-DT              PIC X(10) VALUE SPACES.        
COB305    05 WS-LST-PYMT-AMT        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0. 
          05 WS-PROCESS-DATE             PIC X(10) VALUE SPACES.        
          05 WS-HOLD-DT.                                                
             10 WS-HOLD-YY               PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-MM               PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-DD               PIC X(02) VALUE SPACES.        
          05 WS-HOLD-LST-PYMT-DT.                                       
             10 WS-HOLD-LST-YR           PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-LST-MO           PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-LST-DY           PIC X(02) VALUE SPACES.        
          05 WS-COMPANY-NAME             PIC X(26) VALUE SPACES.        
          05 WS-COLL-HIST-SEQ-TS         PIC X(26).                     
          05 WS-FRP803-STATUS            PIC X(02).                     
             88  FRP803-SUCCESSFUL       VALUE ZERO.                    
          05 WS-DATABASE                 PIC 9(01) VALUE 0.             
             88  CSR-DATABASE                      VALUE 1.             
             88  SEB-DATABASE                      VALUE 2.             
          05 WS-FIRST-TIME-FLAG          PIC X(01) VALUE 'N'.           
             88 FIRST-TIME                         VALUE 'Y'.           
             88 NOT-FIRST-TIME                     VALUE 'N'.           
          05  WS-NO-COMP-RECORDS         PIC 9(07) VALUE ZEROES.        
          05  WS-NO-TOT-RECORDS          PIC 9(07) VALUE ZEROES.        
          05  WS-PREV-REG-GROUP-CD       PIC X(03) VALUE SPACES.        
          05  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
          05  RS-RETURN-CODE-DISP        PIC +Z(04).                    
          05  WS-NULL-IND1               PIC S9(04) COMP VALUE ZERO.    
          05  WS-NULL-IND2               PIC S9(04) COMP VALUE ZERO.    
          05  WS-NULL-AMT-ENTERED        PIC S9(04) COMP VALUE ZERO.    
          05  WS-PROM-TYPE-CD            PIC X(02) VALUE SPACES.        
P02192    05  WS-PTP-AMT                 PIC S9(5)V99 COMP-3 VALUE +0.  
      *                                                                 01910000
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PCSCA808 ENDS HERE'.                    
      *-- COPY BOOK THAT CONTAINS VARIABLES REQD TO GET JOB PARM DATE           
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      *                                                                         
           EXEC SQL                                                     01950000
              INCLUDE CWS00074                                          01960000
           END-EXEC.                                                    01970000
      *                                                                 02080000
           EXEC SQL                                                     01950000
             INCLUDE SQLCA                                              01960000
           END-EXEC.                                                    01970000
                                                                        
      * CSS_ACCOUNT TABLE                                               02090000
           EXEC SQL                                                     02100000
             INCLUDE TBACCT                                             02110000
           END-EXEC.                                                    02120000
                                                                        
      * CSS_USER_PROFILE TABLE                                          02090000
           EXEC SQL                                                     02100000
             INCLUDE TBUSRPRF                                           02110000
           END-EXEC.                                                    02120000
                                                                        
      * CSS_RESP_AREA TABLE                                             02090000
           EXEC SQL                                                     02100000
             INCLUDE TBRSAREA                                           02110000
           END-EXEC.                                                    02120000
                                                                        
      * CSS_COLLECT_HIST TABLE                                          02090000
           EXEC SQL                                                     02100000
             INCLUDE TBCOLHST                                           02110000
           END-EXEC.                                                    02120000
                                                                        
      * CSS_COLL_HIST_DET TABLE                                         02090000
           EXEC SQL                                                     02100000
             INCLUDE TBCOLDET                                           02110000
           END-EXEC.                                                    02120000
                                                                        
      * CSS_JOB_PARM TABLE                                              02140000
           EXEC SQL                                                     02150000
             INCLUDE TBJBPARM                                           02160000
           END-EXEC.                                                    02170000
                                                                        
      * CSS_DELINQUENCY TABLE                                           02181007
           EXEC SQL                                                     02182007
             INCLUDE TBDELQ                                             02183007
           END-EXEC.                                                    02184007
      * CSS_REG_PROFILE TABLE                                                   
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      * CSS_NAME TABLE                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      * CSS_NAME_ACCT_XREF TABLE                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE COLL_CURSOR CURSOR FOR                            
                SELECT LH.ACCOUNT_NO                                    
                      ,LH.COLL_RESULT_CD                                
                      ,LH.COLL_AGENT_ID                                 
                      ,HC.TOTAL_ARREARS                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LH.COLL_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           COLL_HIST_SEQ_TS                              
P02192                ,LH.PTP_AMT                                       
                  FROM CSS_COLL_HIST_DET LH,                            
                       CSS_COLLECT_HIST HC,                             
                       CSS_ACCOUNT AT                                   
                 WHERE LH.ACCOUNT_NO          = HC.ACCOUNT_NO           
                   AND LH.ACCOUNT_NO          = AT.ACCOUNT_NO           
                   AND LH.COLL_HIST_SEQ_TS    = HC.COLL_HIST_SEQ_TS     
                   AND LH.RECORD_CREATION_DT  = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) )        
                   AND LH.COLL_RESULT_CD     IN ('PK','PB')             
                   AND AT.COMPANY_NO          = :AT-COMPANY-NO          
                 ORDER BY AT.ACCOUNT_NO                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02190000
MFA-TR*       DECLARE COLL_CURSOR CURSOR FOR                            02200000
MFA-TR*         SELECT LH.ACCOUNT_NO                                    02210000
MFA-TR*               ,LH.COLL_RESULT_CD                                02230000
MFA-TR*               ,LH.COLL_AGENT_ID                                         
MFA-TR*               ,HC.TOTAL_ARREARS                                 02231005
MFA-TR*               ,LH.COLL_HIST_SEQ_TS                                      
MFA-TR*               ,LH.PTP_AMT                                               
MFA-TR*           FROM CSS_COLL_HIST_DET LH,                            02240000
MFA-TR*                CSS_COLLECT_HIST HC,                                     
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*          WHERE LH.ACCOUNT_NO          = HC.ACCOUNT_NO           02250000
MFA-TR*            AND LH.ACCOUNT_NO          = AT.ACCOUNT_NO           02250000
MFA-TR*            AND LH.COLL_HIST_SEQ_TS    = HC.COLL_HIST_SEQ_TS             
MFA-TR*            AND LH.RECORD_CREATION_DT  = :WS-PROCESS-DATE        02260000
MFA-TR*            AND LH.COLL_RESULT_CD     IN ('PK','PB')                     
MFA-TR*            AND AT.COMPANY_NO          = :AT-COMPANY-NO                  
MFA-TR*          ORDER BY AT.ACCOUNT_NO                                 02280005
MFA-TR*                                                                 02281005
MFA-TR*    END-EXEC.                                                    02290000
      *                                                                 02490000
           EXEC SQL                                                     
              DECLARE PTP_DET_CURSOR CURSOR FOR                         
                SELECT CIS.SUBSTR3(LAST_UPDATE_USERID,1,7)                   
                       ,PTP_AMT                                         
                       ,PTP_DT                                          
                       ,COLL_RESULT_CD                                  
                       ,PTP_ARREARS_AM                                  
                       ,LAST_UPDATE_DT                                  
P02192                 ,PTP_STATUS_CD                                   
                  FROM CSS_COLL_HIST_DET                                
                 WHERE ACCOUNT_NO         = :LH-ACCOUNT-NO              
                   AND COLL_HIST_SEQ_TS   = CIS.CHAR2TIMESTAMP(
                                                   :LH-COLL-HIST-SEQ-TS
              )        
                   AND COLL_RESULT_CD IN ('SP', 'PM', 'PP', 'PW')       
P02192             AND COLL_AGENT_ID       = :PF-USER-ID                
P02192             AND PTP_STATUS_CD IN('A','P','K','B')                
                 ORDER BY TRANS_ID DESC                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02500000
MFA-TR*       DECLARE PTP_DET_CURSOR CURSOR FOR                         02510000
MFA-TR*         SELECT SUBSTR(LAST_UPDATE_USERID,1,7)                   02520000
MFA-TR*                ,PTP_AMT                                                 
MFA-TR*                ,PTP_DT                                                  
MFA-TR*                ,COLL_RESULT_CD                                          
MFA-TR*                ,PTP_ARREARS_AM                                          
MFA-TR*                ,LAST_UPDATE_DT                                          
MFA-TR*                ,PTP_STATUS_CD                                           
MFA-TR*           FROM CSS_COLL_HIST_DET                                02530000
MFA-TR*          WHERE ACCOUNT_NO         = :LH-ACCOUNT-NO              02540000
MFA-TR*            AND COLL_HIST_SEQ_TS   = :LH-COLL-HIST-SEQ-TS        02550000
MFA-TR*            AND COLL_RESULT_CD IN ('SP', 'PM', 'PP', 'PW')               
MFA-TR*            AND COLL_AGENT_ID       = :PF-USER-ID                02250000
MFA-TR*            AND PTP_STATUS_CD IN('A','P','K','B')                        
MFA-TR*          ORDER BY TRANS_ID DESC                                 02580000
MFA-TR*    END-EXEC.                                                    02590000
      *                                                                 02600000
       COPY CWS00010.                                                   02610000
       COPY CWS09900.                                                   02620000
       COPY CWS00303.                                                   02630000
       COPY CWS00011.                                                           
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-PARMVAL                        PIC X(02).             
      ******************************************************************02640005
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ******************************************************************02710000
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *02720000
      ******************************************************************02730000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
      *                                                                         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
      *                                                                         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
      *                                                                         
           STOP RUN.                                                    
      *                                                                 03020000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************03050000
      *                                                                *03060000
      *      OPEN OUTPUT FILE PRNTFILE.                                *03070000
      *                                                                *03080000
      ******************************************************************03090000
       0100-INITIALIZE.                                                 
           IF  WS-PARMVAL-LENGTH = ZERO                                 
               DISPLAY '********** PCSCA808 ABORT ************'         
               DISPLAY 'NO PARM VALUE FOUND'                            
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
               DISPLAY '********** PCSCA808 ABORT ************'         
           END-IF.                                                      
           MOVE 0                          TO WS-COLL-EOF-SW            
P02192     MOVE ZEROES                     TO WS-NO-COMP-RECORDS        
                                              WS-NO-TOT-RECORDS.        
           MOVE 'Y'                        TO WS-FIRST-TIME-FLAG.       
                                                                        
      * GET CURRENT DATABASE                                            03151109
           MOVE '01'                     TO C8-COMPANY-NO.              
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           PERFORM 7400-GET-DATABASE     THRU 7400-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                 03156805
           MOVE WS-PARMVAL               TO AT-COMPANY-NO               
      *                                                                 03156805
           PERFORM 6251-GET-FJC01-DATE   THRU 6251-EXIT.                
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                         THRU 6240-EXIT                 
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                 03156805
           MOVE WS-INPUT-DATE            TO WS-PROCESS-DATE             
      *                                                                 03157205
           OPEN OUTPUT FCSRP803-FILE.                                   
           IF FRP803-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSCA808 PROCESSING ERROR             **'   
               DISPLAY '**  OPEN ERROR OF FCSRP803- OUTPUT FILE   **'   
               DISPLAY '**  FILE STATUS = ' WS-FRP803-STATUS            
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 03172005
           MOVE LOW-VALUES TO E-FRP803-BEGIN-REC.                       
           MOVE WS-PROCESS-DATE TO WS-HOLD-DT                           
                                 E-FRP803-CREATE-DATE-BREC.             
           IF CSR-DATABASE                                              
               MOVE 'CSR' TO E-FRP803-DATABASE                          
           ELSE                                                         
               MOVE 'SEB' TO E-FRP803-DATABASE                          
           END-IF.                                                      
           WRITE FIORP803.                                              
      *                                                                 03240000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-COLL-CSR           THRU 7000-EXIT.         
           PERFORM 7100-FETCH-COLL-CSR          THRU 7100-EXIT.         
           IF  END-OF-COLL                                              
               PERFORM 7110-CLOSE-COLL-CSR      THRU 7110-EXIT          
               PERFORM 1100-WRITE-END-CONTROLS  THRU 1100-EXIT          
           ELSE                                                         
               MOVE AT-COMPANY-NO               TO E-FRP803-COMPANY-NO  
               PERFORM UNTIL END-OF-COLL                                
                   PERFORM 2000-PROCESS-COLL    THRU 2000-EXIT          
                   PERFORM 7100-FETCH-COLL-CSR  THRU 7100-EXIT          
               END-PERFORM                                              
               PERFORM 7110-CLOSE-COLL-CSR      THRU 7110-EXIT          
               PERFORM 1100-WRITE-END-CONTROLS  THRU 1100-EXIT          
           END-IF.                                                      
      *                                                                 02993005
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04171005
      ******************************************************************04172005
      **  1100-WRITE-END-CONTROLS.                                    **04173005
      **    WRITES LAST COMPANY END RECORD & FILE END RECORD.         **04174005
      ******************************************************************04175005
       1100-WRITE-END-CONTROLS.                                         
      *                                                                 04177005
           IF  NOT-FIRST-TIME                                           
               MOVE WS-PARMVAL         TO E-FRP803-CO-NO-KEY-EREC       
               MOVE WS-NO-COMP-RECORDS TO E-FRP803-RECORD-COUNT-EREC    
               ADD WS-NO-COMP-RECORDS TO WS-NO-TOT-RECORDS              
               MOVE HIGH-VALUES TO E-FRP803-CO-KEY-EREC                 
               WRITE FIORP803                                           
           END-IF.                                                      
           MOVE HIGH-VALUES TO E-FRP803-END-REC.                        
           MOVE WS-NO-TOT-RECORDS TO E-FRP803-RECORD-COUNT-EREC.        
           WRITE FIORP803.                                              
      *                                                                 04179905
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04181000
      ******************************************************************04190000
      *                                                                *04200000
      *       2000-PROCESS-COLL                                        *04210000
      *                                                                *04220000
      ******************************************************************04230000
       2000-PROCESS-COLL.                                               
                                                                        
           MOVE LH-ACCOUNT-NO                TO E-FRP803-ACCOUNT-NO     
           MOVE LH-ACCOUNT-NO                TO AT-ACCOUNT-NO           
                                                E-FRP803-ACCOUNT-NO     
           MOVE 'Y'                          TO WS-NAME-ONLY-SW         
           PERFORM 4000-MAIL-NAME-ADDRESS    THRU 4000-EXIT             
           MOVE WS-CUSTOMER-NAME             TO E-FRP803-CUST-NAME      
      *                                                                         
P02192     MOVE '    '                    TO E-FRP803-PROM-TYPE         
           IF WS-PROM-TYPE-CD = 'PK'                                    
              MOVE 'KEPT'                    TO E-FRP803-PROM-TYPE      
           ELSE                                                         
              IF WS-PROM-TYPE-CD = 'PB'                                 
                 MOVE 'BROKEN'               TO E-FRP803-PROM-TYPE      
              END-IF                                                    
P02192     END-IF.                                                      
      *                                                                         
           PERFORM 7120-OPEN-PTP-DET-CSR     THRU 7120-EXIT             
           PERFORM 7130-FETCH-PTP-DET-CSR    THRU 7130-EXIT             
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P02192         MOVE ZEROES                 TO E-FRP803-PTP-ARREARS-AM   
P02192                                        E-FRP803-PTP-AMOUNT       
P02192         IF E-FRP803-PROM-TYPE = 'BROKEN' AND                     
P02192            LH-PTP-STATUS-CD = 'B'                                
P02192           MOVE LH-PTP-AMT             TO E-FRP803-PTP-AMOUNT     
P02192           MOVE LH-PTP-ARREARS-AM      TO E-FRP803-PTP-ARREARS-AM 
P02192         END-IF                                                   
P02192         IF LH-PTP-STATUS-CD = 'A' OR 'P' OR 'K'                  
P02192           MOVE LH-PTP-AMT             TO E-FRP803-PTP-AMOUNT     
P02192           MOVE LH-PTP-ARREARS-AM      TO E-FRP803-PTP-ARREARS-AM 
               END-IF                                                   
           ELSE                                                         
               MOVE ZEROES                   TO E-FRP803-PTP-AMOUNT     
                                                E-FRP803-PTP-ARREARS-AM 
               MOVE SPACES                   TO E-FRP803-COLL-FRST-NAME 
                                                E-FRP803-COLL-LAST-NAME 
                                                E-FRP803-COLLECTOR-ID   
                                                E-FRP803-RESP-AREA-CD   
                                                E-FRP803-RESP-AREA      
P02192     END-IF.                                                      
           MOVE LH-PTP-DT                 TO WS-HOLD-DT                 
P02192     MOVE LH-COLL-AGENT-ID-TEXT(1:7) TO E-FRP803-COLLECTOR-ID     
P02192     PERFORM 7410-GET-COLLECTOR-NAME THRU 7410-EXIT               
P02192     MOVE PF-FIRST-NAME             TO E-FRP803-COLL-FRST-NAME    
P02192     MOVE PF-LAST-NAME              TO E-FRP803-COLL-LAST-NAME    
P02192     MOVE PF-RESP-AREA-ID           TO C1-RESP-AREA-ID            
P02192                                       E-FRP803-RESP-AREA-CD      
P02192     MOVE PF-COMPANY-NO             TO C1-COMPANY-NO              
P02192     PERFORM 7420-GET-RESP-AREA-DESC   THRU 7420-EXIT             
P02192     MOVE C1-RESP-AREA-DESC         TO E-FRP803-RESP-AREA         
P02192     PERFORM 7140-CLOSE-PTP-DET-CSR    THRU 7140-EXIT.            
           MOVE WS-HOLD-MM                TO E-FRP803-PTP-MM            
           MOVE WS-HOLD-DD                TO E-FRP803-PTP-DD            
           MOVE WS-HOLD-YY                TO E-FRP803-PTP-YY            
           MOVE LH-COLL-RESULT-CD         TO E-FRP803-RESULT-CD         
           MOVE HC-TOTAL-ARREARS          TO E-FRP803-ARREARS-AMT       
           IF LH-LAST-UPDATE-DT > SPACES                                
P02192         MOVE WS-PTP-AMT           TO E-FRP803-AMT-COLL           
           ELSE                                                         
               MOVE ZEROES                   TO E-FRP803-AMT-COLL       
           END-IF                                                       
           PERFORM 8500-WRITE-DETAIL         THRU 8500-EXIT             
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04620000
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                 04620000
           EXEC SQL                                                             
                INCLUDE CPD00004                                                
           END-EXEC.                                                            
      *                                                                 04620000
      ******************************************************************        
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      ******************************************************************11187100
       COPY CPD00040.                                                   11187200
       COPY CPD00037.                                                   11188800
                                                                        
      ******************************************************************04630000
      *                                                                *04640000
      *       7000-OPEN-COLL-CSR                                       *04650000
      *                                                                *04660000
      ******************************************************************04670000
       7000-OPEN-COLL-CSR.                                              
           EXEC SQL                                                     
               OPEN COLL_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04720000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'      
              DISPLAY '** PARA 7000-OPEN-COLL-CSR              **'      
              DISPLAY '** ERROR DURING OPEN OF CURSOR          **'      
              DISPLAY '**    COLL_CURSOR                       **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 04860000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ******************************************************************04900000
      *                                                                 04910000
      *       7100-FETCH-COLL-CSR.                                      04920000
      *                                                                 04930000
      ******************************************************************04940000
       7100-FETCH-COLL-CSR.                                             
           EXEC SQL                                                     
               FETCH COLL_CURSOR                                        
               INTO :LH-ACCOUNT-NO                                      
                   ,:WS-PROM-TYPE-CD                                    
                   ,:LH-COLL-AGENT-ID                                   
                   ,:HC-TOTAL-ARREARS                                   
                   ,:LH-COLL-HIST-SEQ-TS                                
P02192             ,:LH-PTP-AMT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05020000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                 05040000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P02192         MOVE LH-PTP-AMT TO WS-PTP-AMT                            
P02192         MOVE LH-COLL-AGENT-ID-TEXT(1:7)   TO PF-USER-ID          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 1 TO WS-COLL-EOF-SW                               
P02192           MOVE ZEROS    TO WS-PTP-AMT                            
              ELSE                                                      
                 DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'   
                 DISPLAY '** PARA 7100-FETCH-COLL-CSR             **'   
                 DISPLAY '** ERROR DURING FETCH OF CURSOR         **'   
                 DISPLAY '**    COLL_CURSOR                       **'   
                 DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                
                 DISPLAY '**  PROCESSING TERMINATED               **'   
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
              END-IF                                                    
           END-IF.                                                      
      *                                                                 05200000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ******************************************************************04900000
      *                                                                 04910000
      *       7110-CLOSE-COLL-CSR.                                      04920000
      *                                                                 04930000
      ******************************************************************04940000
       7110-CLOSE-COLL-CSR.                                             
           EXEC SQL                                                     
               CLOSE COLL_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05020000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                 05040000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P02192         CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'     
               DISPLAY '** PARA 7110-CLOSE-COLL-CSR             **'     
               DISPLAY '** ERROR DURING CLOSE OF CURSOR         **'     
               DISPLAY '**    COLL_CURSOR                       **'     
               DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                  
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05200000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05221007
      ******************************************************************04630000
      *                                                                *04640000
      *       7120-OPEN-PTP-DET-CSR                                    *04650000
      *                                                                *04660000
      ******************************************************************04670000
       7120-OPEN-PTP-DET-CSR.                                           
      *                                                                 05221007
           EXEC SQL                                                     
               OPEN PTP_DET_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04720000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P02192        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'      
              DISPLAY '** PARA 7120-OPEN-PTP-DET-CSR           **'      
              DISPLAY '** ERROR DURING OPEN OF CURSOR          **'      
              DISPLAY '**    PTP_DET_CURSOR                    **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 04860000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ******************************************************************04900000
      *                                                                 04910000
      *       7130-FETCH-PTP-DET-CSR.                                   04920000
      *                                                                 04930000
      ******************************************************************04940000
       7130-FETCH-PTP-DET-CSR.                                          
           EXEC SQL                                                     
               FETCH PTP_DET_CURSOR                                     
               INTO :LH-LAST-UPDATE-USERID                              
                   ,:LH-PTP-AMT                                         
                   ,:LH-PTP-DT :WS-NULL-IND1                             
                   ,:LH-COLL-RESULT-CD                                  
                   ,:LH-PTP-ARREARS-AM                                  
                   ,:LH-LAST-UPDATE-DT :WS-NULL-IND2                     
P02192             ,:LH-PTP-STATUS-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05020000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                 05040000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES                TO LH-PTP-DT                
              END-IF                                                    
              IF WS-NULL-IND2 < 0                                       
                 MOVE SPACES                TO LH-LAST-UPDATE-DT        
              END-IF                                                    
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'      
              DISPLAY '** PARA 7130-FETCH-PTP-DET-CSR          **'      
              DISPLAY '** ERROR DURING FETCH OF CURSOR         **'      
              DISPLAY '**    PTP_DET_CURSOR                    **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                 05200000
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04890000
      ******************************************************************04900000
      *                                                                 04910000
      *       7140-CLOSE-PTP-DET-CSR.                                   04920000
      *                                                                 04930000
      ******************************************************************04940000
       7140-CLOSE-PTP-DET-CSR.                                          
           EXEC SQL                                                     
               CLOSE PTP_DET_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05020000
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                 05040000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA808 **'     
               DISPLAY '** PARA 7140-CLOSE-PTP-DET-CSR          **'     
               DISPLAY '** ERROR DURING CLOSE OF CURSOR         **'     
               DISPLAY '**    PTP_DET_CURSOR                    **'     
               DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                  
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05200000
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05221007
      ****************************************************************  05222007
      **                                                            **  05223007
      ** 7400-GET-DATABASE.                                         **  05224007
      ** DETERMINE WHETHER WE'RE IN SEB OR CSR.                     **  05225007
      **                                                            **  05226007
      ****************************************************************  05227007
      *                                                                 05228007
       7400-GET-DATABASE.                                               
      *                                                                 05229107
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY                                   
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05229907
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 05230107
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7400-GET-DATABASE'                            
               DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 05231307
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05221007
      ****************************************************************  05222007
      **                                                            **  05223007
      ** 7410-GET-COLLECTOR-NAME.                                   **  05224007
      ** GET THE COLLECTOR'S NME FROM HIS USER ID                   **  05225007
      **                                                            **  05226007
      ****************************************************************  05227007
      *                                                                 05228007
       7410-GET-COLLECTOR-NAME.                                         
      *                                                                 05229107
           EXEC SQL                                                     
              SELECT FIRST_NAME                                         
                    ,LAST_NAME                                          
                    ,RESP_AREA_ID                                       
A02036              ,COMPANY_NO                                         
                INTO :PF-FIRST-NAME                                     
                    ,:PF-LAST-NAME                                      
                    ,:PF-RESP-AREA-ID                                   
A02036              ,:PF-COMPANY-NO                                     
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID    = :PF-USER-ID                           
A02036                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05229207
MFA-TR*       SELECT FIRST_NAME                                         05229307
MFA-TR*             ,LAST_NAME                                                  
MFA-TR*             ,RESP_AREA_ID                                               
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*         INTO :PF-FIRST-NAME                                     05229407
MFA-TR*             ,:PF-LAST-NAME                                              
MFA-TR*             ,:PF-RESP-AREA-ID                                           
MFA-TR*             ,:PF-COMPANY-NO                                             
MFA-TR*         FROM CSS_USER_PROFILE                                   05229507
MFA-TR*        WHERE USER_ID    = :PF-USER-ID                           05229607
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    05229807

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05229907
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 05230107
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7410-GET-COLLECTOR-NAME'                      
               DISPLAY '* USER_ID    = ' PF-USER-ID                     
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
A02036         DISPLAY '* PROCESSING TERMINATED            **'          
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 05231307
       7410-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  05222007
      **                                                            **  05223007
      ** 7420-GET-RESP-AREA-DESC.                                   **  05224007
      ** GET THE RESPONSIBLE AREA DESCRIPTION                       **  05225007
      **                                                            **  05226007
      ****************************************************************  05227007
      *                                                                 05228007
       7420-GET-RESP-AREA-DESC.                                         
      *                                                                 05229107
           EXEC SQL                                                     
              SELECT RESP_AREA_DESC                                     
                INTO :C1-RESP-AREA-DESC                                 
                FROM CSS_RESP_AREA                                      
               WHERE COMPANY_NO    = :C1-COMPANY-NO                     
                 AND RESP_AREA_ID  = :C1-RESP-AREA-ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05229907
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 05230107
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7420-GET-RESP-AREA-DESC'                      
               DISPLAY '* RESP_AREA_ID  = ' C1-RESP-AREA-ID             
               DISPLAY '* COMPANY_NO = ' C1-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 05231307
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 05221007
      ******************************************************************        
      * PARAGRAPH 7550-START-FCSJC01 IS IN CPD00038.                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                 05221007
      ******************************************************************        
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************05832012
      *                                                                *05833012
      *   7650-GET-REG-PROFILE-INFO.                                   *05834012
      *        FETCHES LR_REG_GROUP_CD                                 *05835012
      *                                                                *05836012
      ******************************************************************05837012
       7650-GET-REG-PROFILE-INFO.                                       
      *                                                                 05839012
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE                                   
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05839712
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  MOVE '   ' TO LR-REG-GROUP-CD                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '***  PCSCA808 PROCESSING ERROR          ***'     
              DISPLAY '***  PARA 7650-GET-REG-PROFILE-INFO     ***'     
              DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***  ACCOUNT NO = ' LR-ACCOUNT-NO                
              DISPLAY '***  PROCESSING TERMINATED              ***'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 05841412
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ***************************************************************** 06490000
      *                                                               * 06500000
      *            8500-WRITE-DETAIL                                  * 06510005
      *   WRITES DETAIL ROW                                           * 06520005
      *                                                               * 06530000
      ***************************************************************** 06540000
       8500-WRITE-DETAIL.                                               
      *                                                                 06590000
           MOVE AT-COMPANY-NO              TO E-FRP803-COMPANY-NO.      
      *                                                                 06593012
           MOVE '   ' TO LR-REG-GROUP-CD.                               
           IF  SEB-DATABASE                                             
               MOVE LH-ACCOUNT-NO      TO LR-ACCOUNT-NO                 
               PERFORM 7650-GET-REG-PROFILE-INFO THRU 7650-EXIT         
           END-IF.                                                      
           MOVE LR-REG-GROUP-CD        TO E-FRP803-REG-GROUP-CD.        
      *                                                                 06730000
           MOVE LH-ACCOUNT-NO          TO WS-ACCOUNT-NO.                
           MOVE WS-ACCOUNT-NO          TO E-FRP803-ACCOUNT-NO.          
      *                                                                 06840000
           WRITE FIORP803.                                              
           ADD 1 TO WS-NO-COMP-RECORDS.                                 
           MOVE 'N' TO WS-FIRST-TIME-FLAG.                              
      *                                                                 06880000
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06931009
      ***************************************************************** 06932009
      *                                                               * 06933009
      *            8550-WRITE-COMPANY-REC                             * 06934009
      *   WRITES COMPANY REC                                          * 06935009
      *                                                               * 06936009
      ***************************************************************** 06937009
       8550-WRITE-COMPANY-REC.                                          
      *                                                                 06939009
           MOVE WS-PARMVAL         TO E-FRP803-CO-NO-KEY-EREC.          
           MOVE WS-NO-COMP-RECORDS TO E-FRP803-RECORD-COUNT-EREC.       
           ADD WS-NO-COMP-RECORDS TO WS-NO-TOT-RECORDS.                 
           MOVE HIGH-VALUES TO E-FRP803-CO-KEY-EREC.                    
           WRITE FIORP803.                                              
           MOVE 'Y' TO WS-FIRST-TIME-FLAG.                              
           INITIALIZE WS-NO-COMP-RECORDS.                               
      *                                                                 06942009
       8550-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08260000
      *                                                                *08270000
      *       9000-TERMINATE                                           *08280000
      *                                                                *08290000
      ******************************************************************08300000
       9000-TERMINATE.                                                  
      *                                                                 08500000
           CLOSE FCSRP803-FILE.                                         
      *                                                                 08500000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08530000
      *****************************************************************         
      *        9700-PROCESS-ABEND                                    **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                 08530000
      ****************************************************************  08540000
      **    9900-ABEND                                              **  08550000
      ****************************************************************  08560000
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                 08650000
