       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA805.                                            
       DATE-WRITTEN. JUNE 2003.                                         
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *      PROGRAM MODIFICATION LOG                                  *00080000
      *                                                                *00090000
      *     DATE     USER ID  REASON                                   *00100000
      *   --------   -------  ---------------------------------------- *00110000
      *   06/26/03   SM19366  INITIAL CODING                           *00120000
      *   08/28/03   SM19366  CHANGE REPORT CRITERIA                   *00121000
      *   09/12/03   SM19366  CHANGE REPORT CRITERIA PER P.LOCKLEAR    *00122000
      *                       AND J.CRAPPS.                            *00123000
C27303*   03/31/04   BB18179  1) UPDATED REPORT TO INCLUDE FACTORS THAT*00124000
      *                          EXPIRE IN THE MONTH BEING REPORTED ON.*00125000
      *                       2) IMPROVED ERROR PROCESSING LOGIC.      *00126000
      *                       3) DELETED UNUSED CODE (PARA 7040-)      *00127000
      *                       4) DELETED UNNEEDED DB2 DCLGENS          *00128000
T35434**  06/09/07  PC97415   REPLACED MODEL_SQL TO SET COMMANDS       *00129000
T35434**                      AND ADDED FETCH ONLY WITH UR FOR         *00129100
T35434**                      AVOIDING -911 ABENDS.                    *00129200
A03303**  08/29/11   SV95326  FIXED FACTOR PRECISION CHANGES           *00129300
A03303*                       FROM 4 TO 6 DECIMAL POINTS FOR           *        
A03303*                       INDUSTRIAL BILLING.                      *        
ACT004**  05/30/16   TP7R341  REMOVE DELETED COLUMNS FROM THE TABLE    *00129300
ACT004*    A04177             CSS_SPCL_FCTR                            *        
      ******************************************************************00130000
      *                                                                 00140000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00190000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT OUTFILE ASSIGN TO UT-S-OUTFILE.                       
      *                                                                 00230000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00260000
       FD OUTFILE                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 104 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOCA805-FILE.                                               
           05 FIOCA805-DATA                PIC X(104).                  
                                                                        
HPCCDM*EJECT                                                            00360000
                                                                        
      *                                                                 00380000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA805'.
MSQ017     COPY MFASQLM.
      *                                                                 00400000
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA805 STARTS HERE'.                  
      *                                                                 00430000
       COPY FIOCA805.                                                   00440000
      *                                                                 00450000
       01 WORK-AREAS.                                                   
          05 WS-RUN-DATE-SW              PIC X(01) VALUE SPACES.        
             88 HAVE-RUN-DATE                      VALUE 'Y'.           
          05 WS-REV-MNTH-SW              PIC X(01) VALUE SPACES.        
             88 HAVE-REV-MONTH                     VALUE 'Y'.           
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05  WS-COMPANY-NO              PIC X(02).                     
          05 WS-EFF-DATE-FROM-NULL  PIC S9(04)    COMP VALUE +0.        
          05 WS-EFF-DATE-TO-NULL    PIC S9(04)    COMP VALUE +0.        
          05 WS-CNTRCT-START-DT-NULL PIC S9(04)    COMP VALUE +0.       
          05 WS-CNTRCT-END-DT-NULL  PIC S9(04)    COMP VALUE +0.        
          05 WS-PROGRAM                  PIC X(08) VALUE 'PCSCA805'.    
          05 WS-ACCOUNT-NO             PIC S9(13)V   COMP-3 VALUE 0.    
COB305    05 WS-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
          05 WS-HOLD-ACCT-STAT           PIC X(01) VALUE SPACES.        
          05 WS-CURRENT-DT               PIC X(10) VALUE SPACES.        
          05 WS-CURR-DT                  PIC X(10) VALUE SPACES.        
          05 WS-CURR-DT-USE.                                            
             10 WS-FROM                  PIC X(05) VALUE SPACES.        
             10 WS-DATE-FROM             PIC X(10) VALUE SPACES.        
             10 WS-THRU                  PIC X(06) VALUE SPACES.        
             10 WS-DATE-TO               PIC X(10) VALUE SPACES.        
             10 FILLER                   PIC X(49) VALUE SPACES.        
          05 WS-STATUS                   PIC X(01) VALUE SPACES.        
          05 WS-DATE-HOLD                PIC X(10) VALUE SPACES.        
          05 WS-CURRENT-DT-32            PIC X(10) VALUE SPACES.        
          05 WS-EFF-DATE-FR-32           PIC X(10) VALUE SPACES.        
          05 WS-HOLD-DT.                                                
             10 WS-HOLD-YR               PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-MO               PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-DY               PIC X(02) VALUE SPACES.        
      *                                                                 00680000
       01  WS-VARIABLES.                                                
           05 WS-CURRENT-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-HOLD-DATE                     PIC X(10)  VALUE SPACES. 
           05 WS-PROCESS-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-DAY                           PIC S9(04) COMP.         
           05 WS-NEW-TIMESTAMP                 PIC X(26).               
A03303     05 WS-FACTOR-FF                     PIC S9(09)V9(06)         
A03303                                         USAGE COMP-3 VALUE 0.    
      *                                                                 00873700
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PCSCA805 ENDS HERE'.                    
      *                                                                 00874000
           EXEC SQL                                                     00875000
             INCLUDE SQLCA                                              00876000
           END-EXEC.                                                    00877000
                                                                        
      * CSS_ACCOUNT TABLE                                               00920000
           EXEC SQL                                                     00930000
             INCLUDE TBACCT                                             00940000
           END-EXEC.                                                    00950000
                                                                        
      * CSS_BILL_CONTRACT                                               00961000
           EXEC SQL                                                     00962000
               INCLUDE TBBLCNTR                                         00963000
           END-EXEC.                                                    00964000
                                                                        
      * CSS_BILL_WINDOW TABLE                                           00970000
           EXEC SQL                                                     00980000
             INCLUDE TBBILWDW                                           00990000
           END-EXEC.                                                    01000000
                                                                        
      * CSS_COMPANY                                                     01020000
           EXEC SQL                                                     01030000
             INCLUDE TBCOMPNY                                           01040000
           END-EXEC.                                                    01050000
                                                                        
      * CSS_FIXED_FCTR                                                  01061000
           EXEC SQL                                                     01062000
               INCLUDE TBFXDFCT                                         01063000
           END-EXEC.                                                    01064000
                                                                        
A03303* CSS_SPCL_FCTR SF                                                01064200
A03303     EXEC SQL                                                     01064300
A03303          INCLUDE TBSPLFTR                                        01064400
A03303     END-EXEC.                                                    01064500
                                                                        
      * CSS_JOB_PARM                                                    01066000
           EXEC SQL                                                     01067000
             INCLUDE TBJBPARM                                           01068000
           END-EXEC.                                                    01069000
                                                                        
      * CSS_UTIL_ENVRNMT                                                01070000
           EXEC SQL                                                     01080000
             INCLUDE TBUTLENV                                           01090000
           END-EXEC.                                                    01100000
                                                                        
      *                                                                 01160000
           EXEC SQL                                                     
             DECLARE FIXED_FACTOR CURSOR FOR                            
                SELECT                                                  
                       AT.ACCOUNT_NO                                    
                      ,FF.EFF_DATE_FROM                                 
                      ,FF.EFF_DATE_TO                                   
                      ,FF.FACTOR                                        
                      ,FF.FACTOR_ID                                     
                      ,FF.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
                      ,UT.CODE_UTIL_TYPE                                
A03303                ,SF.FCTR_POWER_10                                 
                FROM                                                    
                       CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                  
                      ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
A03303                ,CSS_SPCL_FCTR    SF WITH(READUNCOMMITTED)                
                  WHERE FF.ACCOUNT_NO = UT.ACCOUNT_NO                   
                  AND FF.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND FF.EFF_DATE_TO  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) )                 
C27303            AND FF.EFF_DATE_TO  <  IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DT-32
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT-32
              ) <> 0) OR (LEN(:WS-CURRENT-DT-32) <> 10), CIS.CHAR2DATE(
                                                      :WS-CURRENT-DT-32
              ), CONVERT(DATE, :WS-CURRENT-DT-32) )              
                  AND FF.CODE_UTIL_TYPE IN ('G','E')                    
                  AND FF.FACTOR_ID <> 'ONERATE'                         
                  AND FF.FACTOR_ID <> 'COMPPRICE'                       
                  AND FF.FACTOR_ID <> 'ANNUALMIN'                       
                  AND FF.FACTOR_ID <> 'STATELINE'                       
                  AND AT.COMPANY_NO = :WS-COMPANY-NO                    
                  AND FF.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             
                  AND FF.IC_NO          = UT.IC_NO                      
A03303            AND FF.FACTOR_ID      = SF.FACTOR_ID                  
                UNION                                                   
                   SELECT                                               
                       AT.ACCOUNT_NO                                    
                      ,BK.CNTRCT_START_DT                               
                      ,BK.CNTRCT_END_DT                                 
                      ,0                                                
                      ,'CONTRACT'                                       
                      ,BK.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
                      ,UT.CODE_UTIL_TYPE                                
A03303                ,1                                                
                FROM                                                    
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)               
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
A03303                ,CSS_SPCL_FCTR    SF WITH(READUNCOMMITTED)                
                  WHERE BK.ACCOUNT_NO = UT.ACCOUNT_NO                   
                    AND BK.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND BK.CNTRCT_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) )              
C27303              AND BK.CNTRCT_END_DT <  IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DT-32
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT-32
              ) <> 0) OR (LEN(:WS-CURRENT-DT-32) <> 10), CIS.CHAR2DATE(
                                                      :WS-CURRENT-DT-32
              ), CONVERT(DATE, :WS-CURRENT-DT-32) )           
                    AND BK.CODE_UTIL_TYPE IN ('G','E')                  
                    AND AT.COMPANY_NO = :WS-COMPANY-NO                  
                    AND BK.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND BK.IC_NO          = UT.IC_NO                    
                ORDER BY CODE_UTIL_TYPE                                 
                        ,ACCOUNT_NO                                     
                        ,RATE_PLAN_NO                                   
                        ,IC_NO                                          
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01200000
MFA-TR*      DECLARE FIXED_FACTOR CURSOR FOR                            01210000
MFA-TR*         SELECT                                                  01220000
MFA-TR*                AT.ACCOUNT_NO                                    01220100
MFA-TR*               ,FF.EFF_DATE_FROM                                 01220200
MFA-TR*               ,FF.EFF_DATE_TO                                   01220300
MFA-TR*               ,FF.FACTOR                                        01220400
MFA-TR*               ,FF.FACTOR_ID                                     01220500
MFA-TR*               ,FF.IC_NO                                         01220600
MFA-TR*               ,UT.RATE_PLAN_NO                                  01220700
MFA-TR*               ,UT.CODE_UTIL_TYPE                                01220800
MFA-TR*               ,SF.FCTR_POWER_10                                 01220900
MFA-TR*         FROM                                                    01220900
MFA-TR*                CSS_FIXED_FCTR FF                                01221000
MFA-TR*               ,CSS_ACCOUNT AT                                   01221100
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                              01221200
MFA-TR*               ,CSS_SPCL_FCTR    SF                              01221400
MFA-TR*           WHERE FF.ACCOUNT_NO = UT.ACCOUNT_NO                   01221300
MFA-TR*           AND FF.ACCOUNT_NO = AT.ACCOUNT_NO                     01221400
MFA-TR*           AND FF.EFF_DATE_TO  >= :WS-CURRENT-DT                 01221800
MFA-TR*           AND FF.EFF_DATE_TO  <  :WS-CURRENT-DT-32              01221900
MFA-TR*           AND FF.CODE_UTIL_TYPE IN ('G','E')                    01221700
MFA-TR*           AND FF.FACTOR_ID <> 'ONERATE'                         01221800
MFA-TR*           AND FF.FACTOR_ID <> 'COMPPRICE'                       01221900
MFA-TR*           AND FF.FACTOR_ID <> 'ANNUALMIN'                       01222000
MFA-TR*           AND FF.FACTOR_ID <> 'STATELINE'                       01222100
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NO                    01223000
MFA-TR*           AND FF.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             01223200
MFA-TR*           AND FF.IC_NO          = UT.IC_NO                      01223300
MFA-TR*           AND FF.FACTOR_ID      = SF.FACTOR_ID                          
MFA-TR*         UNION                                                   01224400
MFA-TR*            SELECT                                               01224500
MFA-TR*                AT.ACCOUNT_NO                                    01224600
MFA-TR*               ,BK.CNTRCT_START_DT                               01224700
MFA-TR*               ,BK.CNTRCT_END_DT                                 01224800
MFA-TR*               ,0                                                01224900
MFA-TR*               ,'CONTRACT'                                       01225000
MFA-TR*               ,BK.IC_NO                                         01225100
MFA-TR*               ,UT.RATE_PLAN_NO                                  01225200
MFA-TR*               ,UT.CODE_UTIL_TYPE                                01225300
MFA-TR*               ,1                                                01225404
MFA-TR*         FROM                                                    01225400
MFA-TR*                CSS_ACCOUNT AT                                   01225500
MFA-TR*               ,CSS_BILL_CONTRACT BK                             01225600
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                              01225700
MFA-TR*               ,CSS_SPCL_FCTR    SF                                      
MFA-TR*           WHERE BK.ACCOUNT_NO = UT.ACCOUNT_NO                   01225800
MFA-TR*             AND BK.ACCOUNT_NO = AT.ACCOUNT_NO                   01225900
MFA-TR*             AND BK.CNTRCT_END_DT >= :WS-CURRENT-DT              01226300
MFA-TR*             AND BK.CNTRCT_END_DT <  :WS-CURRENT-DT-32           01227000
MFA-TR*             AND BK.CODE_UTIL_TYPE IN ('G','E')                  01227100
MFA-TR*             AND AT.COMPANY_NO = :WS-COMPANY-NO                  01227200
MFA-TR*             AND BK.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           01227400
MFA-TR*             AND BK.IC_NO          = UT.IC_NO                    01227500
MFA-TR*         ORDER BY CODE_UTIL_TYPE                                 01228600
MFA-TR*                 ,ACCOUNT_NO                                     01228700
MFA-TR*                 ,RATE_PLAN_NO                                   01228800
MFA-TR*                 ,IC_NO                                          01228900
MFA-TR*         FOR FETCH ONLY WITH UR                                  01229000
MFA-TR*    END-EXEC.                                                    01229100
      *                                                                 01230000
       COPY CWS00010.                                                   01375100
       COPY CWS09900.                                                   01375200
       COPY CWS00303.                                                   01375300
      *                                                                 01375600
       LINKAGE SECTION.                                                 
       01 WS-PARM-VALUE.                                                
          05 WS-PARMVAL-LENGTH           PIC S9(04) COMP.               
          05 WS-PARM-COMPANY             PIC X(02).                     
      *                                                                 01376600
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      ******************************************************************01376800
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *01376900
      ******************************************************************01377000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE.                                     
      *                                                                 01377300
           PERFORM 7010-FETCH-FIXED-FACTOR THRU 7010-EXIT               
           PERFORM 8300-PROCESS-OUTFILE  THRU 8300-EXIT                 
      *                                                                 01379000
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
              PERFORM 7010-FETCH-FIXED-FACTOR THRU 7010-EXIT            
              PERFORM 8300-PROCESS-OUTFILE  THRU 8300-EXIT              
           END-PERFORM.                                                 
      *                                                                 01420000
           PERFORM 7020-CLOSE-FIXED-FACTOR THRU 7020-EXIT.              
      *                                                                 01440000
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
           STOP RUN.                                                    
      *                                                                 01470000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01500000
      *                                                                *01510000
      *      OPEN OUTPUT FILE PRNTFILE.                                *01520000
      *                                                                *01530000
      ******************************************************************01540000
       0100-INITIALIZE.                                                 
           PERFORM 0105-GET-COMPANY-NO THRU 0105-EXIT.                  
           PERFORM 0107-JOB-PARM-INFO THRU 0107-EXIT.                   
           DISPLAY 'WS-STATUS = ', WS-STATUS                            
           DISPLAY 'WS-DATE-FROM = ', WS-DATE-FROM                      
           DISPLAY 'WS-DATE-TO = ', WS-DATE-TO                          
           IF WS-STATUS EQUAL 'A'                                       
              MOVE WS-DATE-FROM TO WS-CURRENT-DT                        
              MOVE WS-DATE-TO   TO WS-CURRENT-DT-32                     
              PERFORM 0109-UPD-CURR-DT-USE THRU 0109-EXIT               
           ELSE                                                         
              PERFORM 0110-GET-CURR-DATE THRU 0110-EXIT                 
              PERFORM 7035-MOVE-DATE-32-DAYS THRU 7035-EXIT             
           END-IF.                                                      
           PERFORM 7000-OPEN-FIXED-FACTOR THRU 7000-EXIT.               
           OPEN OUTPUT OUTFILE.                                         
           MOVE SPACES                     TO E-FCA805-DATA-REC.        
      *                                                                 01730000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01750100
      ******************************************************************01750200
      *                                                                *01750300
      *       0105-GET-COMPANY-NO.                                     *01750400
      *                                                                *01750500
      ******************************************************************01750600
       0105-GET-COMPANY-NO.                                             
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
                INTO :WS-COMPANY-NO                                     
                FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
              WHERE  COMPANY_NO = :WS-PARM-COMPANY                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01750800
MFA-TR*       SELECT COMPANY_NO                                         01750900
MFA-TR*         INTO :WS-COMPANY-NO                                     01751000
MFA-TR*         FROM CSS_COMPANY                                        01751100
MFA-TR*       WHERE  COMPANY_NO = :WS-PARM-COMPANY                      01751200
MFA-TR*         WITH UR                                                 01751300
MFA-TR*    END-EXEC.                                                    01751400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01751500
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 01751700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**    PARA = 0120-GET-COMPANY'                   
              DISPLAY '** COMPANY = ' WS-PARM-COMPANY                   
              DISPLAY '** RETCODE = ' WS-ACTIVE-RETURN-CODE             
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 01753000
       0105-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01753300
      ******************************************************************01753400
      *                                                                *01753500
      *      0107-JOB-PARM-INFO                                        *01753600
      *                                                                *01753700
      ******************************************************************01753800
      *                                                                 01753900
       0107-JOB-PARM-INFO.                                              
      *                                                                 01754100
           MOVE SPACES TO G6-PARM-DATA.                                 
      *                                                                 01754500
           MOVE 'PCSCA805'               TO G6-PROGRAM-NAME.            
           MOVE 'DATE'                   TO G6-CMND-CODE.               
           MOVE WS-COMPANY-NO            TO G6-COMPANY-NO.              
           MOVE +10                      TO G6-SEQ-NO.                  
           PERFORM 0108-GET-CURR-DT-USE                 THRU 0108-EXIT. 
      *                                                                 01755100
       0107-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01755400
      *                                                                 01755500
      ******************************************************************01755600
      *                                                                *01755700
      *      0108-GET-CURR-DT-USE                                      *01755800
      *                                                                *01755900
      ******************************************************************01756000
      *                                                                 01756100
       0108-GET-CURR-DT-USE.                                            
      *                                                                 01756300
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                     ,STATUS                                            
               INTO  :G6-PARM-DATA                                      
                    ,:G6-STATUS                                         
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
               WHERE                                                    
                    PROGRAM_NAME      = :G6-PROGRAM-NAME                
               AND  CMND_CODE         = :G6-CMND-CODE                   
               AND  COMPANY_NO        = :G6-COMPANY-NO                  
               AND  SEQ_NO            = :G6-SEQ-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01756400
MFA-TR*        SELECT PARM_DATA                                         01756500
MFA-TR*              ,STATUS                                            01756600
MFA-TR*        INTO  :G6-PARM-DATA                                      01756700
MFA-TR*             ,:G6-STATUS                                         01756800
MFA-TR*        FROM CSS_JOB_PARM                                        01756900
MFA-TR*        WHERE                                                    01757000
MFA-TR*             PROGRAM_NAME      = :G6-PROGRAM-NAME                01757100
MFA-TR*        AND  CMND_CODE         = :G6-CMND-CODE                   01757200
MFA-TR*        AND  COMPANY_NO        = :G6-COMPANY-NO                  01757300
MFA-TR*        AND  SEQ_NO            = :G6-SEQ-NO                      01757400
MFA-TR*        WITH UR                                                  01757500
MFA-TR*    END-EXEC.                                                    01757600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01757700
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
      *                                                                 01757900
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE G6-PARM-DATA TO WS-CURR-DT-USE                      
               MOVE G6-STATUS TO WS-STATUS                              
           ELSE                                                         
               DISPLAY '********* PCSCA805 - ERROR ************'        
               DISPLAY '**            PARA = 0108-GET-CURR-DT-USE'      
               DISPLAY '** G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
               DISPLAY '**    G6-CMND-CODE = ' G6-CMND-CODE             
               DISPLAY '**   G6-COMPANY-NO = ' G6-COMPANY-NO            
               DISPLAY '**       G6-SEQ-NO = ' G6-SEQ-NO                
               DISPLAY '**         RETCODE = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '***************************************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       0108-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01759700
      ******************************************************************01759800
      *                                                                *01759900
      *      0109-UPD-CURR-DT-USE                                      *01760000
      *                                                                *01760100
      ******************************************************************01760200
      *                                                                 01760300
       0109-UPD-CURR-DT-USE.                                            
      *                                                                 01760500
           EXEC SQL                                                     
               UPDATE                                                   
                  CSS_JOB_PARM                                          
               SET                                                      
                  STATUS              = 'I'                             
               WHERE                                                    
                    PROGRAM_NAME      = :G6-PROGRAM-NAME                
               AND  CMND_CODE         = :G6-CMND-CODE                   
               AND  COMPANY_NO        = :G6-COMPANY-NO                  
               AND  SEQ_NO            = :G6-SEQ-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01761700
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
      *                                                                 01761900
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********* PCSCA805 - ERROR ************'        
               DISPLAY '**            PARA = 0109-UPD-CURR-DT-USE'      
               DISPLAY '**    G6-CMND-CODE = ' G6-CMND-CODE             
               DISPLAY '**   G6-COMPANY-NO = ' G6-COMPANY-NO            
               DISPLAY '**       G6-SEQ-NO = ' G6-SEQ-NO                
               DISPLAY '**         RETCODE = ' WS-ACTIVE-RETURN-CODE    
               DISPLAY '***************************************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       0109-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01763600
      ******************************************************************01763700
      *                                                                *01763800
      *       0110-GET-CURR-DATE.                                      *01763900
      *                                                                *01764000
      ******************************************************************01764100
       0110-GET-CURR-DATE.                                              
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,10,10)                            
                    ,CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() 
           AS DATE),'USA')                             
                INTO :WS-CURRENT-DT                                     
                    ,:WS-CURR-DT                                        
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = 'COMMON'                            
                AND  COMPANY_NO     = '01'                              
                AND  CMND_CODE      = 'DATE'                            
                AND  SEQ_NO         = 10                                
                AND  STATUS         = 'A'                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01764300
MFA-TR*       SELECT SUBSTR(PARM_DATA,10,10)                            01764400
MFA-TR*             ,CHAR(CURRENT DATE,USA)                             01764500
MFA-TR*         INTO :WS-CURRENT-DT                                     01764600
MFA-TR*             ,:WS-CURR-DT                                        01764700
MFA-TR*         FROM CSS_JOB_PARM                                       01764800
MFA-TR*       WHERE  PROGRAM_NAME = 'COMMON'                            01764900
MFA-TR*         AND  COMPANY_NO     = '01'                              01765000
MFA-TR*         AND  CMND_CODE      = 'DATE'                            01765100
MFA-TR*         AND  SEQ_NO         = 10                                01765200
MFA-TR*         AND  STATUS         = 'A'                               01765300
MFA-TR*       WITH UR                                                   01765400
MFA-TR*    END-EXEC.                                                    01765500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01765600
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 01765800
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**     PARA = 0110-GET-CURR-DATE'                
              DISPLAY '**  RETCODE = ' WS-ACTIVE-RETURN-CODE            
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 01769400
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01769700
      ******************************************************************02043400
      *                                                                *02043500
      *       7000-OPEN-FIXED-FACTOR                                   *02043600
      *                                                                *02043700
      ******************************************************************02043800
       7000-OPEN-FIXED-FACTOR.                                          
           EXEC SQL                                                     
               OPEN FIXED_FACTOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02047000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 02049000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**          PARA = 7000-OPEN-FIXED-FACTOR'       
              DISPLAY '**    COMPANY_NO = ' WS-COMPANY-NO               
              DISPLAY '**    CURRENT_DT = ' WS-CURRENT-DT               
              DISPLAY '** CURRENT_DT_32 = ' WS-CURRENT-DT-32            
              DISPLAY '**       RETCODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02160000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02190000
      ******************************************************************02200000
      *                                                                *02210000
      *       7010-FIXED-FACTOR                                        *02220000
      *                                                                *02230000
      ******************************************************************02240000
       7010-FETCH-FIXED-FACTOR.                                         
           EXEC SQL                                                     
               FETCH FIXED_FACTOR                                       
                INTO :AT-ACCOUNT-NO                                     
                     ,:FF-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL         
                     ,:FF-EFF-DATE-TO :WS-EFF-DATE-TO-NULL           
                     ,:FF-FACTOR                                        
                     ,:FF-FACTOR-ID                                     
                     ,:FF-IC-NO                                         
                     ,:UT-RATE-PLAN-NO                                  
                     ,:UT-CODE-UTIL-TYPE                                
A03303               ,:SF-FCTR-POWER-10                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02300000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 02320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF WS-EFF-DATE-FROM-NULL < 0                             
                   MOVE SPACES      TO FF-EFF-DATE-FROM                 
               END-IF                                                   
               IF WS-EFF-DATE-TO-NULL < 0                               
                   MOVE SPACES      TO FF-EFF-DATE-TO                   
               END-IF                                                   
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO                   
               END-IF                                                   
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**           PARA = 7010-FETCH-FIXED-FACTOR'     
              DISPLAY '**     ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  EFF-DATE-FROM = ' FF-EFF-DATE-FROM           
              DISPLAY '**    EFF-DATE-TO = ' FF-EFF-DATE-TO             
              DISPLAY '**         FACTOR = ' FF-FACTOR                  
              DISPLAY '**      FACTOR-ID = ' FF-FACTOR-ID               
              DISPLAY '**          IC-NO = ' FF-IC-NO                   
              DISPLAY '**CNTRCT-START-DT = ' BK-CNTRCT-START-DT         
              DISPLAY '**  CNTRCT-END-DT = ' BK-CNTRCT-END-DT           
              DISPLAY '**   RATE-PLAN-NO = ' UT-RATE-PLAN-NO            
              DISPLAY '** CODE-UTIL-TYPE = ' UT-CODE-UTIL-TYPE          
              DISPLAY '**        RETCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02440000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02490000
      ******************************************************************02500000
      *                                                                *02510000
      *       7020-CLOSE-AC-INFO                                       *02520000
      *                                                                *02530000
      ******************************************************************02540000
       7020-CLOSE-FIXED-FACTOR.                                         
           EXEC SQL                                                     
             CLOSE FIXED_FACTOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02590000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**     PARA = 7020-CLOSE-FIXED-FACTOR'           
              DISPLAY '**  RETCODE = ' WS-ACTIVE-RETURN-CODE            
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02720000
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02741000
      *                                                                *02742000
      *      7035-MOVE-DATE.                                           *02743000
      *                                                                *02744000
      ******************************************************************02745000
      *                                                                 02746000
T13565 7035-MOVE-DATE-32-DAYS.                                          
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              LTRIM(RTRIM(CIS.INT2CHAR(YEAR(DATEADD( MONTH, 2, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) ) ))))) + '-' + CASE            
C27303                WHEN MONTH(DATEADD( MONTH, 2, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) ) )) < 10   
C27303                     THEN '0'                                     
C27303                ELSE ''                                           
C27303              END + LTRIM(RTRIM(CIS.INT2CHAR(MONTH(DATEADD( 
              MONTH, 2, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) ) ))))) + '-01'
            INTO
              :WS-CURRENT-DT-32                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02749000
MFA-TR*      SET :WS-CURRENT-DT-32  =                                   02749100
MFA-TR*             STRIP(CHAR(YEAR(DATE(:WS-CURRENT-DT) + 2 MONTH))) ||02749200
MFA-TR*             '-' ||                                              02749300
MFA-TR*             CASE                                                02749400
MFA-TR*               WHEN MONTH(DATE(:WS-CURRENT-DT) + 2 MONTH) < 10   02749500
MFA-TR*                    THEN '0'                                     02749600
MFA-TR*               ELSE ''                                           02749700
MFA-TR*             END ||                                              02749800
MFA-TR*             STRIP(CHAR(MONTH(DATE(:WS-CURRENT-DT) +2 MONTH))) ||02749900
MFA-TR*             '-01'                                               02750000
MFA-TR*    END-EXEC.                                                    02751600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********* PCSCA805 - ERROR ************'         
              DISPLAY '**        PARA = 7035-MOVE-DATE-32-DAYS'         
              DISPLAY '**  CURRENT_DT = ' WS-CURRENT-DT                 
              DISPLAY '**     RETCODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02759100
      ******************************************************************05389300
      *                                                                *05389400
      *       8300-PROCESS-OUTFILE.                                     05389500
      *                                                                *05389600
      ******************************************************************05389700
       8300-PROCESS-OUTFILE.                                            
      *                                                                 05389900
           MOVE AT-ACCOUNT-NO              TO E-FCA805-ACCOUNT-NO.      
           MOVE FF-EFF-DATE-FROM          TO E-FCA805-EFF-DATE-FR.      
           MOVE FF-EFF-DATE-TO            TO E-FCA805-EFF-DATE-TO.      
           MOVE FF-FACTOR-ID              TO E-FCA805-FACTOR-ID.        
A03303     IF SF-FCTR-POWER-10 NOT EQUAL 0                              
A03303        COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
A03303        MOVE WS-FACTOR-FF            TO E-FCA805-FACTOR           
A03303        MOVE 0                       TO SF-FCTR-POWER-10          
A03303     ELSE                                                         
A03303        MOVE FF-FACTOR               TO E-FCA805-FACTOR           
A03303     END-IF                                                       
           MOVE UT-RATE-PLAN-NO           TO E-FCA805-RATE-PLAN.        
           MOVE UT-CODE-UTIL-TYPE         TO E-FCA805-UTIL-TYPE.        
           MOVE FF-IC-NO                  TO E-FCA805-IC-NO.            
           MOVE E-FCA805-DATA-REC          TO FIOCA805-DATA.            
           WRITE FIOCA805-FILE.                                         
      *                                                                 05391600
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05392200
      ******************************************************************05392300
      *                                                                *05392400
      *       9000-TERMINATE                                           *05392500
      *                                                                *05392600
      ******************************************************************05392700
       9000-TERMINATE.                                                  
      *                                                                 05392900
           CLOSE OUTFILE.                                               
      *                                                                 05394000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05397000
      ****************************************************************  05398000
      **    9900-ABEND                                              **  05399000
      ****************************************************************  05400000
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           MOVE 12                         TO RETURN-CODE.              
           MOVE 'YES'                      TO WS-ABEND-SWITCH.          
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
      *                                                                 05490000
