       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA801.                                            
       DATE-WRITTEN. APRIL 2002.                                        
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *      PROGRAM MODIFICATION LOG                                  *00080000
      *                                                                *00090000
      *     DATE     USER ID  REASON                                   *00100000
      *   --------   -------  ---------------------------------------- *00110000
      *   04/25/02   SM19366  INITIAL CODING                           *00120000
      *   05/02/02   SM19366  -811 ABEND ON CSS_CONTRACT TABLE         *00121000
T26954*   01/15/03   RB19957  RICK - ADDED REG-GROUP-CD TO OUTPUT FILE *00121100
C27949**  05/30/03   SS82048  CHANGES TO INLCLUDE HVAC CONTRACTS NOS   *        
      **                      AND FIRM RATES FOR PSNC NON UTIL         *        
      **                      COLLECTIONS.                             *        
C27949**  06/09/03   SS82048  INITIALIZE WS-ADD-00 TO FIX REPORT FOR   *        
      **                      SEB AND PSNC.                            *        
C28615*  07/31/03   SK88120   COLLECTIONS PHASE-II CHANGES.            *        
C28615*                     A) REPORT WAS CHANGED TO RUN AGAINST CIS   *        
C28615*                        FOR ACTIVE ACCOUNTS AND COMPANY-26.     *        
C28615*                     B) CODE CHANGES WERE MADE TO GET SECURITY  *        
C28615*                        AMOUNT.                                 *        
C30070*  09/14/04   KR19687   ADDED LOGIC TO INCLUDE BHV_MODEL_ID AND  *        
C30070*                       BHV_SCORE_RATING IN THE FIOCA801 OUTPUT  *        
C30070*                       FILE. THIS FILE IS USED AS INPUT INTO    *        
C30070*                       REPORT PROGRAM PCSRP808.                 *        
PRDFIX*  10/26/04   VIJAY     ADD DISPLAYS IN ABEND REPORT.            *        
PRDFIX*  06/14/05   VIJAY     SUM THE GAURANTEED AMOUNT IF THERE ARE   *        
      *                       THAN ONE GAURANTOR.                      *        
C34097*  07/27/07   CVNS      ADD FETCH ONLY WITH UR                   *        
      *             CHENNAI                                           *         
ACT156*  09/23/13   DB41297   OPTIMIZE PROGRAM BY LOADING CURSORS      *        
      *                       INTO WORKING STORAGE TABLES.            *         
      ******************************************************************00130000
      *                                                                 00140000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00190000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT OUTFILE ASSIGN TO UT-S-OUTFILE.                       
      *                                                                 00230000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00260000
       FD OUTFILE                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 104 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOCA801-FILE.                                               
           05 FIOCA801-DATA                PIC X(104).                  
                                                                        
HPCCDM*EJECT                                                            00360000
                                                                        
      *                                                                 00380000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA801'.
MSQ017     COPY MFASQLM.
      *                                                                 00400000
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA801 STARTS HERE'.                  
      *                                                                 00430000
       COPY FIOCA801.                                                   00440000
      *                                                                 00450000
       01 WORK-AREAS.                                                   
          05 WS-RUN-DATE-SW              PIC X(01) VALUE SPACES.        
             88 HAVE-RUN-DATE                      VALUE 'Y'.           
          05 WS-REV-MNTH-SW              PIC X(01) VALUE SPACES.        
             88 HAVE-REV-MONTH                     VALUE 'Y'.           
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-PROGRAM                  PIC X(08) VALUE 'PCSCA801'.    
          05 WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.    
COB305    05 WS-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
ACT156    05 WS-ACCOUNT-HOLD             PIC S9(13)V COMP-3 VALUE 0.    
          05 WS-HOLD-ACCT-STAT           PIC X(01) VALUE SPACES.        
          05 WS-AMT-AR-DAY-00            PIC S9(10)V9(02).              
          05 WS-AMT-AR-DAY-30            PIC S9(10)V9(02).              
          05 WS-AMT-AR-DAY-60            PIC S9(10)V9(02).              
          05 WS-AMT-AR-DAY-90            PIC S9(10)V9(02).              
          05 WS-ADD-00                   PIC S9(10)V9(02).              
          05 WS-ADD-30                   PIC S9(10)V9(02).              
          05 WS-ADD-60                   PIC S9(10)V9(02).              
          05 WS-ADD-90                   PIC S9(10)V9(02).              
C28615    05 WS-SECURITY-AMT             PIC S9(10)V9(02).              
C28615    05 WS-DEP-AMT                  PIC S9(10)V9(02).              
C28615    05 WS-GUA-AMT                  PIC S9(10)V9(02).              
C28615    05 WS-GUA-AMT-C      REDEFINES WS-GUA-AMT                     
C28615                                   PIC X(12).                     
C28615    05 WS-SURETY-AMT               PIC S9(10)V9(02).              
C28615    05 WS-NULL-IND1                PIC S9(04) COMP.               
C28615    05 WS-NULL-IND2                PIC S9(04) COMP.               
C28615    05 WS-NULL-IND3                PIC S9(04) COMP.               
C30070    05 WS-NULL-IND4                PIC S9(04) COMP.               
C30070    05 WS-NULL-IND5                PIC S9(04) COMP.               
C28615    05 WS-COMPANY-NO               PIC X(2) VALUE SPACES.         
C28615    05 WS-BILL-CYCLE               PIC 9(2) VALUE ZEROS.          
C30070    05 WS-BHV-MODEL-ID             PIC X(04) VALUE SPACES.        
C30070    05 WS-BHV-SCORE-RATING         PIC X(01) VALUE SPACES.        
      *                                                                 00660000
       01  WS-ACCT-TYPE-VALUE          PIC X(01) VALUE SPACES.          
      *                                                                 00680000
       01  WS-VARIABLES.                                                
           05 WS-ROW-EXISTS                    PIC X(01).               
              88  ROW-EXISTS                   VALUE 'Y'.               
           05 WS-PREV-BILL-CYCLE               PIC X(02)  VALUE SPACES. 
           05 WS-PHONE-NO                      PIC X(10)  VALUE SPACES. 
           05 WS-CURRENT-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-NEXT-DAY                      PIC X(10)  VALUE SPACES. 
           05 WS-CALC-DATE                     PIC X(10)  VALUE SPACES. 
           05 WS-HOLD-DATE                     PIC X(10)  VALUE SPACES. 
           05 WS-PROCESS-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-WRITE-OFF-DT                  PIC X(10)  VALUE SPACES. 
           05 WS-FINAL-WO-DATE                 PIC X(10)  VALUE SPACES. 
           05 WS-DAY                           PIC S9(04) COMP.         
           05 WS-TOTAL-ARREARS                 PIC S9(09)V99 VALUE  0.  
           05 WS-ARREARS                       PIC 9(02)  VALUE ZEROS.  
              88 30-DAY-ARREARS                VALUE 30.                
              88 60-DAY-ARREARS                VALUE 60.                
              88 90-DAY-ARREARS                VALUE 90.                
           05 WS-ARREARS-EXIST                 PIC X(01)  VALUE 'N'.    
              88 ARREARS-EXIST                 VALUE 'Y'.               
           05 WS-CFA00-STATUS                  PIC X(02).               
              88  CFA00-SUCCESSFUL             VALUE '00'.              
           05 WS-ACA00-STATUS                  PIC X(02).               
              88  ACA00-SUCCESSFUL             VALUE '00'.              
           05 WS-DATE-FOUND                    PIC X(01) VALUE 'N'.     
              88  DATE-IS-FOUND                VALUE 'Y'.               
           05 WS-NEW-TIMESTAMP                 PIC X(26).               
           05 WS-HVAC-FLAG                     PIC X(01) VALUE 'N'.     
              88  WS-HVAC                      VALUE 'Y'.               
           05 WS-HVAC-ARREARS-FLAG             PIC X(01) VALUE 'N'.     
              88  WS-HVAC-ARREARS              VALUE 'Y'.               
           05 WS-ACCT-INFO-FOUND-FLAG          PIC X(01) VALUE 'N'.     
              88  WS-ACCT-INFO-FOUND           VALUE 'Y'.               
           05 WS-COLLECT-ACTIVE-FLAG           PIC X(01) VALUE 'N'.     
              88  WS-COLLECT-ACTIVE            VALUE 'Y'.               
           05 WS-PROCESS-FLAG                  PIC X(01) VALUE 'N'.     
              88  WS-PROCESS                   VALUE 'Y'.               
T26954     05  WS-DATABASE                 PIC 9(01) VALUE 0.           
T26954         88  CSR-DATABASE                      VALUE 1.           
T26954         88  SEB-DATABASE                      VALUE 2.           
C27949     05 WS-FIRM-RATE                     PIC X(03) VALUE SPACES.  
C27949        88  FIRM-RATE                    VALUE                    
C27949            '450', '461', '462', '463', '464',                    
C27949            '145', '150', '160', '175', '180'.                    
      *                                                                 00873700
ACT156                                                                  
ACT156 01  WS-CONTR-TABLE.                                              
ACT156     05 WS-PROC-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT156     05 WS-CONTR-CNT                  PIC S9(5) COMP-3 VALUE +0.  
ACT156     05 WS-GUAR-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT156     05 WS-SURT-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT156     05 WS-CONTR-TBL OCCURS 0 TO 99999 DEPENDING ON WS-CONTR-CNT  
ACT156                    ASCENDING KEY WS-ACCOUNT-NR                   
ACT156                    INDEXED BY CONTR-IND.                         
COB305        10 WS-ACCOUNT-NR        PIC S9(13) COMP-3 VALUE 0.          
ACT156        10 WS-CNT-ITEM-ID             PIC S9(9) COMP.             
ACT156        10 WS-PYMT-PRIORITY-LVL       PIC S9(4) COMP.             
ACT156        10 WS-CNT-NAME-CD             PIC S9(4) COMP.             
ACT156                                                                  
ACT156 01  WS-GUAR-TABLE.                                               
ACT156     05 WS-GUAR-TBL OCCURS 0 TO 99999 DEPENDING ON WS-GUAR-CNT    
ACT156                    ASCENDING KEY WS-ACCOUNT-NB                   
ACT156                    INDEXED BY GUAR-IND.                          
COB305        10 WS-ACCOUNT-NB        PIC S9(13) COMP-3 VALUE 0.          
ACT156                                                                  
ACT156 01  WS-SURT-TABLE.                                               
ACT156     05 WS-SURT-TBL OCCURS 0 TO 99999 DEPENDING ON WS-SURT-CNT    
ACT156                    ASCENDING KEY WS-ACCOUNT-NT                   
ACT156                    INDEXED BY SURT-IND.                          
COB305        10 WS-ACCOUNT-NT        PIC S9(13) COMP-3 VALUE 0.          
      *                                                                 00874000
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PCSCA801 ENDS HERE'.                    
      *                                                                 00874000
           EXEC SQL                                                     00875000
             INCLUDE SQLCA                                              00876000
           END-EXEC.                                                    00877000
                                                                        
      * CSS_AR_CNTL TABLE                                               00879000
           EXEC SQL                                                     00880000
             INCLUDE TBARCNTL                                           00890000
           END-EXEC.                                                    00900000
                                                                        
      * CSS_ACCOUNT TABLE                                               00920000
           EXEC SQL                                                     00930000
             INCLUDE TBACCT                                             00940000
           END-EXEC.                                                    00950000
                                                                        
      * CSS_BILL_WINDOW TABLE                                           00970000
           EXEC SQL                                                     00980000
             INCLUDE TBBILWDW                                           00990000
           END-EXEC.                                                    01000000
                                                                        
      * CSS_COLL_ACCT_INFO TABLE                                        01020000
           EXEC SQL                                                     01030000
             INCLUDE TBACCINF                                           01040000
           END-EXEC.                                                    01050000
                                                                        
      * CSS_UTIL_ENVRNMT                                                01070000
           EXEC SQL                                                     01080000
             INCLUDE TBUTLENV                                           01090000
           END-EXEC.                                                    01100000
      * CSS_CONTRACT                                                    01110000
           EXEC SQL                                                     01120000
               INCLUDE TBCNTRCT                                         01130000
           END-EXEC.                                                    01140000
                                                                        
C30070* CSS_BHV_ACCT_SCORE                                              01110000
C30070     EXEC SQL                                                     01120000
C30070         INCLUDE TBACSCRE                                         01130000
C30070     END-EXEC.                                                    01140000
                                                                        
T26954******* TABLE DECLARATION FOR CSS_DELINQUENCY                     01150100
T26954     EXEC SQL                                                     01150200
T26954         INCLUDE TBDELQ                                           01150300
T26954     END-EXEC.                                                    01150400
T26954*                                                                 01150500
T26954****** TABLE DECLARATION FOR CSS_REG_PROFILE                      01160000
T26954     EXEC SQL                                                     01160100
T26954         INCLUDE TBREGPRF                                         01160200
T26954     END-EXEC.                                                    01160300
C28615*                                                                 01150500
C28615****** TABLE DECLARATION FOR CSS_DEP_ON_HAND                      01160000
C28615     EXEC SQL                                                     01160100
C28615         INCLUDE TBDEPHND                                         01160200
C28615     END-EXEC.                                                    01160300
C28615*                                                                 01150500
C28615****** TABLE DECLARATION FOR CSS_GUARANTOR                        01160000
C28615     EXEC SQL                                                     01160100
C28615         INCLUDE TBGTNTR                                          01160200
C28615     END-EXEC.                                                    01160300
C28615*                                                                 01150500
C28615****** TABLE DECLARATION FOR CSS_SURETY_BOND                      01160000
C28615     EXEC SQL                                                     01160100
C28615         INCLUDE TBSTYBND                                         01160200
C28615     END-EXEC.                                                    01160300
      *                                                                 01160600
      *-- COPYBOOK FOR WS-CODES-DATA-PRESENT                            01170000
       COPY CWS00056.                                                   01180000
      *                                                                 01190000
           EXEC SQL                                                     
             DECLARE COLL_ACCT_INFO CURSOR FOR                          
C28165          SELECT                                                  
C28615                AT.ACCOUNT_NO                                     
ACT156               ,AT.CODE_ACCT_STAT                                 
ACT156               ,AT.CODES_DATA_PRESENT                             
ACT156               ,AT.BILL_CYCLE                                     
ACT156               ,AT.CUSTOMER_NO                                    
ACT156               ,AT.DATE_BILL_DAY_00                               
ACT156               ,AT.CREDIT_GROUP                                   
ACT156               ,AT.BANKRUPTCY_IND                                 
ACT156               ,AT.JUDGEMENT_CASE_NO                              
ACT156               ,AT.CODE_DISC_OK                                   
ACT156               ,AT.NOTICE_EXEMPT_CD                               
C28615          FROM                                                    
C28615                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
C28615          WHERE AT.CODE_ACCT_STAT = 'A'                           
C28615            AND AT.COMPANY_NO     = :WS-COMPANY-NO                
C34097          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01200000
MFA-TR*      DECLARE COLL_ACCT_INFO CURSOR FOR                          01210000
MFA-TR*         SELECT                                                  01220000
MFA-TR*               AT.ACCOUNT_NO                                     01221000
MFA-TR*              ,AT.CODE_ACCT_STAT                                 02840000
MFA-TR*              ,AT.CODES_DATA_PRESENT                             02850000
MFA-TR*              ,AT.BILL_CYCLE                                     02860000
MFA-TR*              ,AT.CUSTOMER_NO                                    02870000
MFA-TR*              ,AT.DATE_BILL_DAY_00                               02880000
MFA-TR*              ,AT.CREDIT_GROUP                                   02890000
MFA-TR*              ,AT.BANKRUPTCY_IND                                 02900000
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                              02910000
MFA-TR*              ,AT.CODE_DISC_OK                                   02920000
MFA-TR*              ,AT.NOTICE_EXEMPT_CD                               02930000
MFA-TR*         FROM                                                    01222000
MFA-TR*               CSS_ACCOUNT AT                                    01223000
MFA-TR*         WHERE AT.CODE_ACCT_STAT = 'A'                           01223000
MFA-TR*           AND AT.COMPANY_NO     = :WS-COMPANY-NO                01223000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    01224000
      *                                                                 01225000
           EXEC SQL                                                     
             DECLARE AR_CNTL_INFO CURSOR FOR                            
                SELECT                                                  
                      AC.ACCOUNT_NO,                                    
                      AC.AMT_AR_DAY_00,                                 
                      AC.AMT_AR_DAY_30,                                 
                      AC.AMT_AR_DAY_60,                                 
                      AC.AMT_AR_DAY_90                                  
                FROM                                                    
                      CSS_AR_CNTL AC                                    
                WHERE                                                   
                      AC.ACCOUNT_NO = :WS-ACCOUNT-NO                    
                  AND AC.ITEM_ID = 0                                    
C28615            AND(AC.AMT_AR_DAY_00 > 0                              
C28615             OR AC.AMT_AR_DAY_30 > 0                              
C28615             OR AC.AMT_AR_DAY_60 > 0                              
C28615             OR AC.AMT_AR_DAY_90 > 0)                             
C34097          FOR READ ONLY                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     01226000
MFA-TR*      DECLARE AR_CNTL_INFO CURSOR FOR                            01227000
MFA-TR*         SELECT                                                  01228000
MFA-TR*               AC.ACCOUNT_NO,                                    01229000
MFA-TR*               AC.AMT_AR_DAY_00,                                 01230000
MFA-TR*               AC.AMT_AR_DAY_30,                                 01240000
MFA-TR*               AC.AMT_AR_DAY_60,                                 01250000
MFA-TR*               AC.AMT_AR_DAY_90                                  01260000
MFA-TR*         FROM                                                    01270000
MFA-TR*               CSS_AR_CNTL AC                                    01280000
MFA-TR*         WHERE                                                   01290000
MFA-TR*               AC.ACCOUNT_NO = :WS-ACCOUNT-NO                    01300000
MFA-TR*           AND AC.ITEM_ID = 0                                    01310000
MFA-TR*           AND(AC.AMT_AR_DAY_00 > 0                              01230000
MFA-TR*            OR AC.AMT_AR_DAY_30 > 0                              01240000
MFA-TR*            OR AC.AMT_AR_DAY_60 > 0                              01250000
MFA-TR*            OR AC.AMT_AR_DAY_90 > 0)                             01260000
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*    END-EXEC.                                                    01320000
ACT156*                                                                 01375000
ACT156     EXEC SQL                                                     
ACT156         DECLARE CONTR_INFO CURSOR FOR                            
ACT156         SELECT DISTINCT(CT.ACCOUNT_NO)                           
ACT156               ,CT.CNT_ITEM_ID N                                  
ACT156               ,CT.PYMT_PRIORITY_LVL                              
ACT156               ,CT.CNT_NAME_CD                                    
ACT156               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
ACT156          FROM  CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
ACT156         WHERE  CT.CNT_NAME_CD IN                                 
ACT156                (201,202,301,302,311,1080,1022,1023)              
ACT156         ORDER BY CT.ACCOUNT_NO, CT.CNT_ITEM_ID DESC              
ACT156         FOR READ ONLY                                    
ACT156     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03350000
MFA-TR*        DECLARE CONTR_INFO CURSOR FOR                            01350000
MFA-TR*        SELECT DISTINCT(CT.ACCOUNT_NO)                           03360000
MFA-TR*              ,CT.CNT_ITEM_ID N                                  03360000
MFA-TR*              ,CT.PYMT_PRIORITY_LVL                              03370000
MFA-TR*              ,CT.CNT_NAME_CD                                            
MFA-TR*              ,CT.LAST_UPDATE_TS                                         
MFA-TR*         FROM  CSS_CONTRACT CT                                   03400000
MFA-TR*        WHERE  CT.CNT_NAME_CD IN                                         
MFA-TR*               (201,202,301,302,311,1080,1022,1023)                      
MFA-TR*        ORDER BY CT.ACCOUNT_NO, CT.CNT_ITEM_ID DESC                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    03430000
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156         DECLARE GUAR_INFO CURSOR FOR                             
ACT156          SELECT DISTINCT(GU.ACCOUNT_NO)                          
ACT156            FROM CSS_GUARANTOR GU WITH(READUNCOMMITTED)                   
ACT156           WHERE GU.GUAR_STATUS_CD   = 'A'                        
ACT156         ORDER BY GU.ACCOUNT_NO                                   
ACT156         FOR READ ONLY                                    
ACT156     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05387300
MFA-TR*        DECLARE GUAR_INFO CURSOR FOR                             01350000
MFA-TR*         SELECT DISTINCT(GU.ACCOUNT_NO)                                  
MFA-TR*           FROM CSS_GUARANTOR GU                                         
MFA-TR*          WHERE GU.GUAR_STATUS_CD   = 'A'                                
MFA-TR*        ORDER BY GU.ACCOUNT_NO                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    05387500
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156         DECLARE SURT_INFO CURSOR FOR                             
ACT156          SELECT DISTINCT(SB.ACCOUNT_NO)                          
ACT156            FROM CSS_SURETY_BOND SB WITH(READUNCOMMITTED)                 
ACT156           WHERE SB.CODE_BOND_TYPE IN ('A' ,'B')                  
ACT156             AND SB.CODE_STATUS  = 'A'                            
ACT156         ORDER BY SB.ACCOUNT_NO                                   
ACT156         FOR READ ONLY                                    
ACT156     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05387300
MFA-TR*        DECLARE SURT_INFO CURSOR FOR                             01350000
MFA-TR*         SELECT DISTINCT(SB.ACCOUNT_NO)                                  
MFA-TR*           FROM CSS_SURETY_BOND SB                                       
MFA-TR*          WHERE SB.CODE_BOND_TYPE IN ('A' ,'B')                          
MFA-TR*            AND SB.CODE_STATUS  = 'A'                                    
MFA-TR*        ORDER BY SB.ACCOUNT_NO                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    05387500
                                                                        
       COPY CWS00010.                                                   01375100
       COPY CWS09900.                                                   01375200
       COPY CWS00303.                                                   01375300
      *                                                                 01375400
       PROCEDURE DIVISION.                                              

SCA006        SET CONTR-IND TO 1.
SCA006        SET GUAR-IND TO 1.
SCA006        SET SURT-IND TO 1.
      ******************************************************************01375600
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *01375700
      ******************************************************************01375800
       0000-MAINLINE.                                                   
      *                                                                 01377000
T26954     MOVE '01'                     TO C8-COMPANY-NO.              
T26954     MOVE 'DATABASE'               TO C8-DELINQ-CD.               
T26954     PERFORM 7500-GET-DATABASE     THRU 7500-EXIT.                
T26954     MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                 01377000
C28615     IF SEB-DATABASE                                              
C28615        MOVE '01'                  TO WS-COMPANY-NO               
C28615     ELSE                                                         
C28615        MOVE '26'                  TO WS-COMPANY-NO               
C28615     END-IF                                                       
      *                                                                 01377000
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
      *                                                                 01377000
           PERFORM 7010-FETCH-COLL-ACCT-INFO THRU 7010-EXIT             
      *                                                                 01379000
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
              PERFORM 8000-ACCOUNT-EXIST    THRU 8000-EXIT              
              PERFORM 7010-FETCH-COLL-ACCT-INFO THRU 7010-EXIT          
           END-PERFORM.                                                 
      *                                                                 01420000
           PERFORM 7020-CLOSE-COLL-ACCT-INFO THRU 7020-EXIT             
      *                                                                 01440000
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
           STOP RUN.                                                    
      *                                                                 01470000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01500000
      *                                                                *01510000
      *      OPEN OUTPUT FILE PRNTFILE.                                *01520000
      *                                                                *01530000
      ******************************************************************01540000
       0100-INITIALIZE.                                                 
           PERFORM 7000-OPEN-COLL-ACCT-INFO THRU 7000-EXIT.             
           OPEN OUTPUT OUTFILE.                                         
           MOVE SPACES                     TO E-FCA801-DATA-REC.        
      *                                                                 01590000
           MOVE ZEROES                     TO WS-AMT-AR-DAY-00          
                                              WS-AMT-AR-DAY-30          
                                              WS-AMT-AR-DAY-60          
                                              WS-AMT-AR-DAY-90          
                                              WS-ADD-00                 
                                              WS-ADD-30                 
                                              WS-ADD-60                 
                                              WS-ADD-90                 
C28615                                        WS-SECURITY-AMT           
C28615                                        WS-DEP-AMT                
C28615                                        WS-GUA-AMT                
C28615                                        WS-SURETY-AMT.            
           MOVE ZEROES                     TO AT-ACCOUNT-NO             
                                              AC-AMT-AR-DAY-00          
                                              AC-AMT-AR-DAY-30          
                                              AC-AMT-AR-DAY-60          
                                              AC-AMT-AR-DAY-90.         
      *                                                                 01730000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01760000
       0110-RE-INITIALIZE.                                              
      *                                                                 01780000
           MOVE ZEROES                     TO WS-AMT-AR-DAY-00          
                                              WS-AMT-AR-DAY-30          
                                              WS-AMT-AR-DAY-60          
                                              WS-AMT-AR-DAY-90          
                                              WS-ADD-00                 
                                              WS-ADD-30                 
                                              WS-ADD-60                 
                                              WS-ADD-90                 
C28615                                        WS-SECURITY-AMT           
C28615                                        WS-DEP-AMT                
C28615                                        WS-GUA-AMT                
C28615                                        WS-SURETY-AMT.            
      *                                                                 01870000
       0110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01900000
      *                                                                *01910000
      *      2000-PROCESS-COLL-HIST                                    *01920000
      *                                                                *01930000
      ******************************************************************01940000
       2000-PROCESS-COLL-HIST.                                          
                                                                        
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
                                                                        
              PERFORM 7350-CHECK-FOR-HVAC THRU 7350-EXIT                
              IF WS-HVAC                                                
                 PERFORM 7375-CHECK-HVAC-ARREARS THRU 7375-EXIT         
              END-IF                                                    
                                                                        
              IF WS-HVAC-ARREARS                                        
                 MOVE 'H' TO E-FCA801-ACCT-TYPE                         
              ELSE                                                      
                IF AT-CREDIT-GROUP NOT = 'D'                            
                   PERFORM 2200-FIND-ACCT-TYPE THRU 2200-EXIT           
                ELSE                                                    
                   MOVE 'N' TO E-FCA801-ACCT-TYPE                       
                   MOVE SPACES TO UT-RATE-PLAN-NO                       
                END-IF                                                  
              END-IF.                                                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02032500
      *                                                                *02032600
      *       2200-FIND-ACCT-TYPE                                      *02032700
      *                                                                *02032800
      ******************************************************************02032900
       2200-FIND-ACCT-TYPE.                                             
ACT156                                                                  
ACT156     PERFORM 7400-FETCH-ACCT-TYPE THRU 7400-EXIT                  
                                                                        
           MOVE UT-CODE-REVENUE-CLASS(2:1) TO WS-ACCT-TYPE-VALUE        
                                                                        
           IF WS-ACCT-TYPE-VALUE = '1'                                  
              MOVE 'R' TO E-FCA801-ACCT-TYPE                            
           ELSE                                                         
C27949        MOVE UT-RATE-PLAN-NO    TO WS-FIRM-RATE                   
C27949        IF  FIRM-RATE                                             
                 MOVE 'F' TO E-FCA801-ACCT-TYPE                         
              ELSE                                                      
                 MOVE 'C' TO E-FCA801-ACCT-TYPE                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02043400
      *                                                                *02043500
      *       7000-OPEN-AC-INFO                                        *02043600
      *                                                                *02043700
      ******************************************************************02043800
       7000-OPEN-COLL-ACCT-INFO.                                        
           EXEC SQL                                                     
               OPEN COLL_ACCT_INFO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02047000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 02049000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '** PARA 7000-OPEN-AC-INFO               **'      
              DISPLAY '** ERROR DURING OPEN OF CURSOR          **'      
              DISPLAY '**          AC_INFO                     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02160000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02190000
      ******************************************************************02200000
      *                                                                *02210000
      *       7010-FETCH-AC-INFO                                       *02220000
      *                                                                *02230000
      ******************************************************************02240000
       7010-FETCH-COLL-ACCT-INFO.                                       
           EXEC SQL                                                     
               FETCH COLL_ACCT_INFO                                     
C28615          INTO :AT-ACCOUNT-NO                                     
ACT156              ,:AT-CODE-ACCT-STAT                                 
ACT156              ,:AT-CODES-DATA-PRESENT                             
ACT156              ,:AT-BILL-CYCLE                                     
ACT156              ,:AT-CUSTOMER-NO                                    
ACT156              ,:AT-DATE-BILL-DAY-00                               
ACT156              ,:AT-CREDIT-GROUP                                   
ACT156              ,:AT-BANKRUPTCY-IND                                 
ACT156              ,:AT-JUDGEMENT-CASE-NO                              
ACT156              ,:AT-CODE-DISC-OK                                   
ACT156              ,:AT-NOTICE-EXEMPT-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02300000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 02320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT156        ADD 1 TO WS-PROC-CNT                                      
ACT156        IF WS-PROC-CNT > 9999                                     
ACT156           DISPLAY 'PROCESSING ACCOUNT ' AT-ACCOUNT-NO            
ACT156           MOVE 1 TO WS-PROC-CNT                                  
ACT156        END-IF                                                    
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '** PARA 7010-FETCH-AC-INFO              **'      
              DISPLAY '** ERROR DURING FETCH OF CURSOR         **'      
              DISPLAY '**        AC_INFO                       **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02440000
C28615     MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
      *                                                                 02460000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02490000
      ******************************************************************02500000
      *                                                                *02510000
      *       7020-CLOSE-AC-INFO                                       *02520000
      *                                                                *02530000
      ******************************************************************02540000
       7020-CLOSE-COLL-ACCT-INFO.                                       
           EXEC SQL                                                     
             CLOSE COLL_ACCT_INFO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02590000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '**   PARA 7020-CLOSE-AC-INFO            **'      
              DISPLAY '**  ERROR DURING CLOSE OF CURSOR        **'      
              DISPLAY '**           AC_INFO                    **'      
              DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
              DISPLAY '**   PROCESSING TERMINATED              **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 02720000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03240000
      ******************************************************************03250000
      *                                                                *03260000
      *       7350-CHECK-FOR-HVAC*                                      03270000
      *                                                                *03280000
      ******************************************************************03290000
       7350-CHECK-FOR-HVAC.                                             
                                                                        
ACT156     IF WS-CONTR-CNT = 0                                          
ACT156        PERFORM 7351-LOAD-CONTR-TABLE THRU 7351-EXIT              
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156     MOVE 'N' TO WS-HVAC-FLAG,                                    
ACT156                 WS-HVAC-ARREARS-FLAG.                            
ACT156                                                                  
ACT156     SEARCH ALL WS-CONTR-TBL                                      
ACT156       WHEN WS-ACCOUNT-NR(CONTR-IND) = AT-ACCOUNT-NO              
ACT156         MOVE WS-CNT-ITEM-ID(CONTR-IND) TO CT-CNT-ITEM-ID         
ACT156         MOVE WS-PYMT-PRIORITY-LVL(CONTR-IND) TO                  
ACT156              CT-PYMT-PRIORITY-LVL                                
ACT156         MOVE 'Y' TO WS-HVAC-FLAG                                 
ACT156     END-SEARCH.                                                  
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
ACT156*                                                                 03240000
ACT156******************************************************************03250000
ACT156*                                                                *03260000
ACT156*       7351-LOAD-CONTR-TABLE                                    *03270000
ACT156*                                                                *03280000
ACT156******************************************************************03290000
ACT156 7351-LOAD-CONTR-TABLE.                                           
ACT156                                                                  
ACT156     MOVE '7351'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        OPEN CONTR_INFO                                           
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF SQLCODE NOT = 0                                           
ACT156        GO TO 7351-CONT
           END-IF.                                          
ACT156                                                                  
ACT156     PERFORM 7352-FETCH-CONTR-INFO THRU 7352-EXIT.                
ACT156                                                                  
ACT156     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT156       IF WS-CONTR-CNT > 0 AND                                    
ACT156          WS-ACCOUNT-HOLD =  WS-ACCOUNT-NR(WS-CONTR-CNT)          
ACT156         CONTINUE                                                 
ACT156       ELSE                                                       
ACT156         ADD 1 TO WS-CONTR-CNT                                    
ACT156         MOVE WS-ACCOUNT-HOLD TO WS-ACCOUNT-NR(WS-CONTR-CNT)      
ACT156         MOVE CT-CNT-ITEM-ID  TO WS-CNT-ITEM-ID(WS-CONTR-CNT)     
ACT156         MOVE CT-PYMT-PRIORITY-LVL TO                             
ACT156              WS-PYMT-PRIORITY-LVL(WS-CONTR-CNT)                  
ACT156         MOVE CT-CNT-NAME-CD  TO WS-CNT-NAME-CD(WS-CONTR-CNT)     
ACT156       END-IF                                                     
ACT156       PERFORM 7352-FETCH-CONTR-INFO THRU 7352-EXIT               
ACT156     END-PERFORM.                                                 
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        CLOSE CONTR_INFO                                          
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156                                                                  
ACT156 7351-CONT.                                                       
ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        DISPLAY '* 7351-LOAD-CONTR-TABLE              *'          
ACT156        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
ACT156        DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                    
ACT156        DISPLAY '* PROGRAM ABORTING...                *'          
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        PERFORM 9900-ABEND              THRU 9900-EXIT            
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 7351-EXIT.                                                       
ACT156     EXIT.                                                        
ACT156*                                                                 03240000
ACT156******************************************************************03250000
ACT156*                                                                *03260000
ACT156*       7352-FETCH-CONTR-INFO                                    *03270000
ACT156*                                                                *03280000
ACT156******************************************************************03290000
ACT156 7352-FETCH-CONTR-INFO.                                           
ACT156                                                                  
ACT156     MOVE '7352'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        FETCH CONTR_INFO                                          
ACT156          INTO  :WS-ACCOUNT-HOLD                                  
ACT156               ,:CT-CNT-ITEM-ID                                   
ACT156               ,:CT-PYMT-PRIORITY-LVL                             
ACT156               ,:CT-CNT-NAME-CD                                   
ACT156               ,:CT-LAST-UPDATE-TS                                
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         DISPLAY '* 7352-FETCH-CONTR-INFO              *'         
ACT156         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
ACT156         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
ACT156         DISPLAY '* PROGRAM ABORTING...                *'         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 7352-EXIT.                                                       
ACT156     EXIT.                                                        
                                                                        
      ******************************************************************03650000
      *                                                                *03660000
      *       7375-CHECK-HVAC-ARREARS                                  *03670000
      *                                                                *03680000
      ******************************************************************03690000
       7375-CHECK-HVAC-ARREARS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT AC.AMT_AR_DAY_30                                  
                     ,AC.AMT_AR_DAY_60                                  
                     ,AC.AMT_AR_DAY_90                                  
                INTO  :AC-AMT-AR-DAY-30                                 
                     ,:AC-AMT-AR-DAY-60                                 
                     ,:AC-AMT-AR-DAY-90                                 
                FROM  CSS_AR_CNTL AC                                    
               WHERE  AC.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                 AND  AC.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      
                 AND  AC.ITEM_ID = :CT-CNT-ITEM-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF AC-AMT-AR-DAY-30 > 0 OR                                
                 AC-AMT-AR-DAY-60 > 0 OR                                
                 AC-AMT-AR-DAY-90 > 0                                   
                   MOVE 'Y' TO WS-HVAC-ARREARS-FLAG                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '********** PCSCA801 ABORT ************'      
                  DISPLAY '* 7375-CHECK-HVAC-ARREARS            *'      
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA801 ABORT ************'      
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04390000
      *                                                                *04400000
      *       7400-FETCH-ACCT-TYPE                                     *04410000
      *                                                                *04420000
      ******************************************************************04430000
       7400-FETCH-ACCT-TYPE.                                            
                                                                        
ACT156     EXEC SQL                                                     
ACT156        SELECT TOP(1) CODE_REVENUE_CLASS,
              RATE_PLAN_NO                                       
ACT156        INTO  :UT-CODE-REVENUE-CLASS                              
ACT156             ,:UT-RATE-PLAN-NO                                    
ACT156        FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                       
ACT156            WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                     
ACT156            ORDER BY CODE_REVENUE_CLASS                           
ACT156                                       
ACT156     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04460000
MFA-TR*       SELECT CODE_REVENUE_CLASS                                 01360000
MFA-TR*             ,RATE_PLAN_NO                                       01370000
MFA-TR*       INTO  :UT-CODE-REVENUE-CLASS                              04480000
MFA-TR*            ,:UT-RATE-PLAN-NO                                    04490000
MFA-TR*       FROM CSS_UTIL_ENVRNMT                                     01371000
MFA-TR*           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                     01372000
MFA-TR*           ORDER BY CODE_REVENUE_CLASS                           01373000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              04470000
MFA-TR*    END-EXEC.                                                    04500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                 MOVE SPACES TO UT-CODE-REVENUE-CLASS                   
             ELSE                                                       
                 DISPLAY '******************************************'   
                 DISPLAY '** CSS_UTIL_ENVRNMT                    '      
                 DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO               
                 DISPLAY '** 7400 FETCH: RETURN CODE ERROR - FETCH  '   
                 DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
             END-IF                                                     
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30070******************************************************************04390000
C30070*                                                                *04400000
C30070*       7435-FETCH-BHV-ACCT-INFO                                 *04410000
C30070*                                                                *04420000
C30070******************************************************************04430000
C30070 7435-FETCH-BHV-ACCT-INFO.                                        
C30070*                                                                 04450000
C30070     EXEC SQL                                                     
C30070        SELECT TOP(1) BHV_MODEL_ID,
              BHV_SCORE_RATING                                   
C30070        INTO  :WS-BHV-MODEL-ID :WS-NULL-IND4                       
C30070             ,:WS-BHV-SCORE-RATING :WS-NULL-IND5                   
C30070        FROM CSS_BHV_ACCT_SCORE WITH(READUNCOMMITTED)                     
C30070            WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                     
C30070            ORDER BY  LAST_UPDATE_TS  DESC                        
C34097                                       
C30070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04460000
MFA-TR*       SELECT BHV_MODEL_ID,                                      01360000
MFA-TR*              BHV_SCORE_RATING                                   01370000
MFA-TR*       INTO  :WS-BHV-MODEL-ID:WS-NULL-IND4                       04480000
MFA-TR*            ,:WS-BHV-SCORE-RATING:WS-NULL-IND5                   04490000
MFA-TR*       FROM CSS_BHV_ACCT_SCORE                                   01371000
MFA-TR*           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                             
MFA-TR*           ORDER BY  LAST_UPDATE_TS  DESC                                
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                    04500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30070*                                                                 04510000
C30070     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30070     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30070        NEXT SENTENCE                                             
C30070     ELSE                                                         
C30070       IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                   
C30070           WS-NULL-IND4 < 0 OR WS-NULL-IND5 < 0)                  
C30070           MOVE SPACES TO WS-BHV-MODEL-ID                         
C30070           MOVE SPACES TO WS-BHV-SCORE-RATING                     
C30070       ELSE                                                       
C30070           DISPLAY '******************************************'   
C30070           DISPLAY '** CSS_BHV_ACCT_SCORE                  '      
C30070           DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO               
C30070           DISPLAY '** 7435 FETCH: RETURN CODE ERROR - FETCH  '   
C30070           DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE       
C30070           DISPLAY '******************************************'   
C30070           PERFORM 9900-ABEND THRU 9900-EXIT                      
C30070       END-IF                                                     
C30070     END-IF.                                                      
C30070*                                                                 04680000
C30070 7435-EXIT.                                                       
C30070     EXIT.                                                        
                                                                        
T26954******************************************************************04980010
T26954*  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *04980020
T26954******************************************************************04980030
T26954 7500-GET-DATABASE.                                               
T26954                                                                  
T26954     EXEC SQL                                                     
T26954        SELECT  DELINQ_VALUE                                      
T26954        INTO    :C8-DELINQ-VALUE                                  
T26954        FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T26954        WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
T26954        AND     COMPANY_NO = :C8-COMPANY-NO                       
C34097                                                           
T26954     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04980060
MFA-TR*       SELECT  DELINQ_VALUE                                      04980070
MFA-TR*       INTO    :C8-DELINQ-VALUE                                  04980080
MFA-TR*       FROM    CSS_DELINQUENCY                                   04980090
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                        04980091
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                       04980092
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    04980093

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26954                                                                  
T26954     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
T26954                                                                  
T26954     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26954           NEXT SENTENCE                                          
T26954     ELSE                                                         
T26954         DISPLAY '*************************************'          
T26954         DISPLAY '* 7500-GET-DATABASE'                            
T26954         DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
T26954         DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
T26954         DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
T26954         DISPLAY '*************************************'          
T26954         PERFORM 9900-ABEND   THRU 9900-EXIT                      
T26954     END-IF.                                                      
T26954                                                                  
T26954 7500-EXIT.                                                       
T26954     EXIT.                                                        
T26954***************************************************************** 04980120
T26954**  7530-SELECT-REG-GROUP-CD ..                                ** 04980200
T26954**      GETS-DATA FROM CSS_REG-PROFILE                         ** 04980300
T26954**                                                             ** 04980400
T26954***************************************************************** 04980500
T26954 7530-SELECT-REG-GROUP-CD.                                        
T26954*                                                                 04980800
T26954     EXEC SQL                                                     
T26954         SELECT                                                   
T26954            REG_GROUP_CD                                          
T26954         INTO                                                     
T26954            :LR-REG-GROUP-CD                                      
T26954         FROM                                                     
T26954            CSS_REG_PROFILE WITH(READUNCOMMITTED)                         
T26954         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
C34097                                                           
T26954     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04980900
MFA-TR*        SELECT                                                   04981000
MFA-TR*           REG_GROUP_CD                                          04981100
MFA-TR*        INTO                                                     04981200
MFA-TR*           :LR-REG-GROUP-CD                                      04981300
MFA-TR*        FROM                                                     04981400
MFA-TR*           CSS_REG_PROFILE                                       04981500
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        04981600
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    04981700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26954*                                                                 04981800
T26954     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T26954     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T26954         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T26954             MOVE '   ' TO LR-REG-GROUP-CD                        
T26954         END-IF                                                   
T26954     ELSE                                                         
T26954         DISPLAY '**** ABEND IN 7530-SELECT-REG-GROUP-CD ****'    
T26954         DISPLAY 'ACCOUNT_NO = ' WS-ACCOUNT-NO                    
T26954         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
T26954         PERFORM 9900-ABEND THRU 9900-EXIT                        
T26954     END-IF.                                                      
T26954*                                                                 04983000
T26954 7530-EXIT.                                                       
T26954     EXIT.                                                        
      *                                                                 04990000
C30070***************************************************************** 04980120
C30070**  7550-GET-BHV-ACCT-INFO                                     ** 04980200
C30070**      GETS MODEL ID AND SCORE RATING FROM THE                ** 04980300
C30070**      CSS_BHV_ACCT_SCORE TABLE                               ** 04980400
C30070**                                                             ** 04980400
C30070***************************************************************** 04980500
C30070 7550-GET-BHV-ACCT-INFO.                                          
C30070*                                                                 04980800
ACT156     IF SEB-DATABASE                                              
ACT156        PERFORM 7435-FETCH-BHV-ACCT-INFO  THRU 7435-EXIT          
ACT156     ELSE                                                         
ACT156        MOVE SPACES TO WS-BHV-MODEL-ID                            
ACT156        MOVE SPACES TO WS-BHV-SCORE-RATING                        
ACT156     END-IF.                                                      
C30070*                                                                 04983000
C30070 7550-EXIT.                                                       
C30070     EXIT.                                                        
      *                                                                 04990000
      ******************************************************************05000000
      *                                                                *05010000
      *       8000-ACCOUNT-EXIST.                                      *05020000
      *                                                                *05030000
      ******************************************************************05040000
       8000-ACCOUNT-EXIST.                                              
           PERFORM 2000-PROCESS-COLL-HIST THRU 2000-EXIT                
           PERFORM 8100-OPEN-AR-CNTL-INFO THRU 8100-EXIT                
           PERFORM 8110-FETCH-AR-CNTL-INFO THRU 8110-EXIT               
           IF SQLCODE NOT EQUAL NOT-FOUND                               
              PERFORM UNTIL SQLCODE = NOT-FOUND                         
                 PERFORM 8010-COMPUTE-FIELDS THRU 8010-EXIT             
                 PERFORM 8110-FETCH-AR-CNTL-INFO THRU 8110-EXIT         
              END-PERFORM                                               
           END-IF                                                       
C28615     MOVE WS-ACCOUNT-NO            TO DO-ACCOUNT-NO               
C28615                                      GU-ACCOUNT-NO               
C28615                                      SB-ACCOUNT-NO               
C28615     PERFORM 8130-GET-DEP-AMT      THRU 8130-EXIT                 
C28615     PERFORM 8140-GET-GUA-AMT      THRU 8140-EXIT                 
C28615     PERFORM 8150-GET-SECURITY-AMT THRU 8150-EXIT                 
C30070     PERFORM 7550-GET-BHV-ACCT-INFO THRU 7550-EXIT                
           IF WS-ADD-30 > 0 OR WS-ADD-60 > 0 OR WS-ADD-90 > 0           
C28615        OR WS-ADD-00 > 0                                          
              PERFORM 8300-PROCESS-OUTFILE THRU 8300-EXIT               
C27949     ELSE                                                         
C27949        PERFORM 0110-RE-INITIALIZE   THRU 0110-EXIT               
           END-IF                                                       
           PERFORM 8120-CLOSE-AR-CNTL-INFO THRU 8120-EXIT.              
      *                                                                 05375800
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05377000
      ******************************************************************05378000
      *                                                                *05379000
      *       8010-COMPUTE-FIELDS.                                     *05379100
      *                                                                *05379200
      ******************************************************************05379300
       8010-COMPUTE-FIELDS.                                             
           MOVE AC-AMT-AR-DAY-00 TO WS-AMT-AR-DAY-00                    
           MOVE AC-AMT-AR-DAY-30 TO WS-AMT-AR-DAY-30                    
           MOVE AC-AMT-AR-DAY-60 TO WS-AMT-AR-DAY-60                    
           MOVE AC-AMT-AR-DAY-90 TO WS-AMT-AR-DAY-90                    
           COMPUTE WS-ADD-00 = WS-ADD-00 + WS-AMT-AR-DAY-00             
           COMPUTE WS-ADD-30 = WS-ADD-30 + WS-AMT-AR-DAY-30             
           COMPUTE WS-ADD-60 = WS-ADD-60 + WS-AMT-AR-DAY-60             
           COMPUTE WS-ADD-90 = WS-ADD-90 + WS-AMT-AR-DAY-90.            
      *                                                                 05380300
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05380600
      ******************************************************************05380700
      *                                                                *05380800
      *       8100-OPEN-AR-CNTL-INFO                                    05380900
      *                                                                *05381000
      ******************************************************************05381100
       8100-OPEN-AR-CNTL-INFO.                                          
           EXEC SQL                                                     
               OPEN AR_CNTL_INFO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05381600
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 05381800
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '** PARA 8100-OPEN-AR-CNTL-INFO      **'          
              DISPLAY '** ERROR DURING OPEN OF CURSOR          **'      
              DISPLAY '**          AR_CNTL_INFO            **'          
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05383000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05383300
      ******************************************************************05383400
      *                                                                *05383500
      *       8110-FETCH-AR-CNTL-INFO.                                  05383600
      *                                                                *05383700
      ******************************************************************05383800
       8110-FETCH-AR-CNTL-INFO.                                         
           EXEC SQL                                                     
               FETCH AR_CNTL_INFO                                       
                INTO                                                    
                     :AC-ACCOUNT-NO,                                    
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05384900
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 05385100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '** PARA 8110-FETCH-AR-CNTL-INFO       **'        
              DISPLAY '** ERROR DURING FETCH OF CURSOR         **'      
              DISPLAY '**        AR_CNTL_INFO                **'        
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
PRDFIX        DISPLAY '** ACCOUNT NO  =' WS-ACCOUNT-NO                  
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05386300
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05386600
      ******************************************************************05386700
      *                                                                *05386800
      *       8120-CLOSE-AR-CNTL-INFO.                                  05386900
      *                                                                *05387000
      ******************************************************************05387100
       8120-CLOSE-AR-CNTL-INFO.                                         
           EXEC SQL                                                     
             CLOSE AR_CNTL_INFO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05387600
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
              DISPLAY '**   PARA 8120-CLOSE-AR-CNTL-INFO       **'      
              DISPLAY '**  ERROR DURING CLOSE OF CURSOR        **'      
              DISPLAY '**           AR_CNTL_INFO            **'         
              DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
              DISPLAY '**   PROCESSING TERMINATED              **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05388900
       8120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05389200
C28615******************************************************************05386700
C28615*                                                                *05386800
C28615*       8130-GET-DEP-AMT.                                         05386900
C28615*                                                                *05387000
C28615******************************************************************05387100
C28615 8130-GET-DEP-AMT.                                                
C28615*                                                                         
C28615     EXEC SQL                                                     
C28615          SELECT SUM(D.AMT_DEPOSIT)                               
C28615            INTO :DO-AMT-DEPOSIT :WS-NULL-IND1                     
C28615            FROM CSS_DEP_ON_HAND D WITH(READUNCOMMITTED)                  
C28615           WHERE D.ACCOUNT_NO         = :DO-ACCOUNT-NO            
C28615             AND D.DEPOSIT_STATUS_CD = 'A'                        
C34097                                                           
C28615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05387300
MFA-TR*         SELECT SUM(D.AMT_DEPOSIT)                                       
MFA-TR*           INTO :DO-AMT-DEPOSIT:WS-NULL-IND1                             
MFA-TR*           FROM CSS_DEP_ON_HAND D                                        
MFA-TR*          WHERE D.ACCOUNT_NO         = :DO-ACCOUNT-NO                    
MFA-TR*            AND D.DEPOSIT_STATUS_CD = 'A'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    05387500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615*                                                                 05387600
C28615     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C28615*                                                                 05387600
C28615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C28615        IF ((WS-NULL-IND1 < 0) OR                                 
C28615            (WS-ACTIVE-RETURN-CODE =  NOT-FOUND))                 
C28615           MOVE ZEROS            TO WS-DEP-AMT                    
C28615        ELSE                                                      
C28615           MOVE DO-AMT-DEPOSIT   TO WS-DEP-AMT
              END-IF                    
C28615     ELSE                                                         
C28615        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
C28615        DISPLAY '**   PARA 8130-GET-DEP-AMT              **'      
C28615        DISPLAY '**  ERROR DURING SELECT OF TABLE        **'      
C28615        DISPLAY '**           CSS_DEP_ON_HAND            **'      
C28615        DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
PRDFIX        DISPLAY '** ACCOUNT NO: ' DO-ACCOUNT-NO                   
C28615        DISPLAY '**   PROCESSING TERMINATED              **'      
C28615        PERFORM 9900-ABEND           THRU 9900-EXIT               
C28615     END-IF.                                                      
C28615*                                                                 05388900
C28615 8130-EXIT.                                                       
C28615     EXIT.                                                        
C28615*                                                                 05389200
C28615******************************************************************05386700
C28615*                                                                *05386800
C28615*       8140-GET-GUA-AMT.                                         05386900
C28615*                                                                *05387000
C28615******************************************************************05387100
C28615 8140-GET-GUA-AMT.                                                
C28615*                                                                         
ACT156     IF WS-GUAR-CNT = 0                                           
ACT156        PERFORM 8141-LOAD-GUAR THRU 8141-EXIT                     
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156     SEARCH ALL WS-GUAR-TBL                                       
ACT156       AT END                                                     
ACT156          MOVE ZEROS                  TO WS-GUA-AMT               
ACT156          GO TO 8140-EXIT                                         
ACT156       WHEN                                                       
ACT156          WS-ACCOUNT-NB(GUAR-IND) = GU-ACCOUNT-NO                 
ACT156            CONTINUE                                              
ACT156     END-SEARCH.                                                  
                                                                        
C28615     EXEC SQL                                                     
PRDFIX          SELECT SUM(GU.AMOUNT_GUARANTEED)                        
C28615            INTO :GU-AMOUNT-GUARANTEED :WS-NULL-IND2               
C28615            FROM CSS_GUARANTOR GU WITH(READUNCOMMITTED)                   
C28615           WHERE GU.ACCOUNT_NO       = :GU-ACCOUNT-NO             
C28615             AND GU.GUAR_STATUS_CD   = 'A'                        
C34097                                                           
C28615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05387300
MFA-TR*         SELECT SUM(GU.AMOUNT_GUARANTEED)                                
MFA-TR*           INTO :GU-AMOUNT-GUARANTEED:WS-NULL-IND2                       
MFA-TR*           FROM CSS_GUARANTOR GU                                         
MFA-TR*          WHERE GU.ACCOUNT_NO       = :GU-ACCOUNT-NO                     
MFA-TR*            AND GU.GUAR_STATUS_CD   = 'A'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    05387500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615*                                                                 05387600
C28615     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C28615*                                                                 05387600
C28615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C28615        IF ((WS-NULL-IND2 < 0) OR                                 
C28615            (WS-ACTIVE-RETURN-CODE =  NOT-FOUND))                 
C28615           MOVE ZEROS                  TO WS-GUA-AMT              
C28615        ELSE                                                      
C28615           MOVE GU-AMOUNT-GUARANTEED   TO WS-GUA-AMT
              END-IF              
C28615     ELSE                                                         
C28615        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
C28615        DISPLAY '**   PARA 8140-GET-GUA-AMT              **'      
C28615        DISPLAY '**  ERROR DURING SELECT OF TABLE        **'      
C28615        DISPLAY '**           CSS_GUARANTOR              **'      
C28615        DISPLAY '** RC= ' WS-ACTIVE-RETURN-CODE                   
PRDFIX        DISPLAY '** ACCOUNT NO : ' GU-ACCOUNT-NO                  
C28615        DISPLAY '**   PROCESSING TERMINATED              **'      
C28615        PERFORM 9900-ABEND           THRU 9900-EXIT               
C28615     END-IF.                                                      
C28615*                                                                 05388900
C28615 8140-EXIT.                                                       
C28615     EXIT.                                                        
ACT156*                                                                 05389200
ACT156******************************************************************05386700
ACT156*                                                                *05386800
ACT156*       8141-LOAD-GUAR                                           *05386900
ACT156*                                                                *05387000
ACT156******************************************************************05387100
ACT156 8141-LOAD-GUAR.                                                  
ACT156                                                                  
ACT156     MOVE '8141'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        OPEN GUAR_INFO                                            
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF SQLCODE NOT = 0                                           
ACT156        GO TO 8141-CONT
           END-IF.                                          
ACT156                                                                  
ACT156     PERFORM 8142-FETCH-GUAR-INFO THRU 8142-EXIT.                 
ACT156     IF SQLCODE NOT = 0                                           
ACT156        ADD 1 TO WS-GUAR-CNT                                      
ACT156        MOVE ZEROS           TO WS-ACCOUNT-NB(WS-GUAR-CNT)        
ACT156                                WS-ACTIVE-RETURN-CODE             
ACT156        GO TO 8141-CONT
           END-IF.                                          
ACT156                                                                  
ACT156     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT156        ADD 1 TO WS-GUAR-CNT                                      
ACT156        MOVE WS-ACCOUNT-HOLD TO WS-ACCOUNT-NB(WS-GUAR-CNT)        
ACT156        PERFORM 8142-FETCH-GUAR-INFO THRU 8142-EXIT               
ACT156     END-PERFORM.                                                 
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        CLOSE GUAR_INFO                                           
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156                                                                  
ACT156 8141-CONT.                                                       
ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        DISPLAY '* 8141-LOAD-GUAR                     *'          
ACT156        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
ACT156        DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                    
ACT156        DISPLAY '* PROGRAM ABORTING...                *'          
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        PERFORM 9900-ABEND              THRU 9900-EXIT            
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 8141-EXIT.                                                       
ACT156     EXIT.                                                        
ACT156*                                                                 03240000
ACT156******************************************************************03250000
ACT156*                                                                *03260000
ACT156*       8142-FETCH-GUAR-INFO                                     *03270000
ACT156*                                                                *03280000
ACT156******************************************************************03290000
ACT156 8142-FETCH-GUAR-INFO.                                            
ACT156                                                                  
ACT156     MOVE '8142'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        FETCH GUAR_INFO                                           
ACT156          INTO  :WS-ACCOUNT-HOLD                                  
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         DISPLAY '* 8142-FETCH-GUAR-INFO               *'         
ACT156         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
ACT156         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
ACT156         DISPLAY '* PROGRAM ABORTING...                *'         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 8142-EXIT.                                                       
ACT156     EXIT.                                                        
C28615*                                                                 05389200
C28615******************************************************************05386700
C28615*                                                                *05386800
C28615*       8150-GET-SECURITY-AMT                                    *05386900
C28615*                                                                *05387000
C28615******************************************************************05387100
C28615 8150-GET-SECURITY-AMT.                                           
C28615*                                                                         
ACT156     IF WS-SURT-CNT = 0                                           
ACT156        PERFORM 8151-LOAD-SECURITY-TABLE THROUGH 8151-EXIT        
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156     SEARCH ALL WS-SURT-TBL                                       
ACT156       AT END                                                     
ACT156          MOVE ZEROS                  TO WS-SURETY-AMT            
ACT156          GO TO 8150-EXIT                                         
ACT156       WHEN                                                       
ACT156          WS-ACCOUNT-NT(SURT-IND) = SB-ACCOUNT-NO                 
ACT156            CONTINUE                                              
ACT156     END-SEARCH.                                                  
                                                                        
C28615     EXEC SQL                                                     
C28615          SELECT SUM(SB.AMT_BOND)                                 
C28615            INTO :SB-AMT-BOND :WS-NULL-IND3                        
C28615            FROM CSS_SURETY_BOND SB WITH(READUNCOMMITTED)                 
C28615           WHERE SB.ACCOUNT_NO       = :SB-ACCOUNT-NO             
C28615             AND SB.CODE_BOND_TYPE IN ('A' ,'B')                  
C28615             AND SB.CODE_STATUS  = 'A'                            
C34097                                                           
C28615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05387300
MFA-TR*         SELECT SUM(SB.AMT_BOND)                                         
MFA-TR*           INTO :SB-AMT-BOND:WS-NULL-IND3                                
MFA-TR*           FROM CSS_SURETY_BOND SB                                       
MFA-TR*          WHERE SB.ACCOUNT_NO       = :SB-ACCOUNT-NO                     
MFA-TR*            AND SB.CODE_BOND_TYPE IN ('A' ,'B')                          
MFA-TR*            AND SB.CODE_STATUS  = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    05387500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615*                                                                 05387600
C28615     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C28615*                                                                 05387600
C28615     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C28615        IF ((WS-NULL-IND3 < 0) OR                                 
C28615            (WS-ACTIVE-RETURN-CODE =  NOT-FOUND))                 
C28615           MOVE ZEROS            TO WS-SURETY-AMT                 
C28615        ELSE                                                      
C28615           MOVE SB-AMT-BOND      TO WS-SURETY-AMT
              END-IF                 
C28615     ELSE                                                         
C28615        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA801 **'      
C28615        DISPLAY '**   PARA 8150-GET-SECURITY-AMT         **'      
C28615        DISPLAY '**  ERROR DURING SELECT OF TABLE        **'      
C28615        DISPLAY '**           CSS_GUARANTOR              **'      
C28615        DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
PRDFIX        DISPLAY '** ACCOUNT NO : ' SB-ACCOUNT-NO                  
C28615        DISPLAY '**   PROCESSING TERMINATED              **'      
C28615        PERFORM 9900-ABEND           THRU 9900-EXIT               
C28615     END-IF.                                                      
C28615*                                                                 05388900
C28615 8150-EXIT.                                                       
C28615     EXIT.                                                        
ACT156*                                                                 05389200
ACT156******************************************************************05386700
ACT156*                                                                *05386800
ACT156*       8151-LOAD-SECURITY-TABLE                                 *05386900
ACT156*                                                                *05387000
ACT156******************************************************************05387100
ACT156 8151-LOAD-SECURITY-TABLE.                                        
ACT156                                                                  
ACT156     MOVE '8151'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        OPEN SURT_INFO                                            
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF SQLCODE NOT = 0                                           
ACT156        GO TO 8151-CONT
           END-IF.                                          
ACT156                                                                  
ACT156     PERFORM 8152-FETCH-SURT-INFO THRU 8152-EXIT.                 
ACT156     IF SQLCODE NOT = 0                                           
ACT156        ADD 1 TO WS-SURT-CNT                                      
ACT156        MOVE ZEROS           TO WS-ACCOUNT-NT(WS-SURT-CNT)        
ACT156                                WS-ACTIVE-RETURN-CODE             
ACT156        GO TO 8151-CONT
           END-IF.                                          
ACT156                                                                  
ACT156     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT156        ADD 1 TO WS-SURT-CNT                                      
ACT156        MOVE WS-ACCOUNT-HOLD TO WS-ACCOUNT-NT(WS-SURT-CNT)        
ACT156        PERFORM 8152-FETCH-SURT-INFO THRU 8152-EXIT               
ACT156     END-PERFORM.                                                 
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        CLOSE SURT_INFO                                           
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156                                                                  
ACT156 8151-CONT.                                                       
ACT156                                                                  
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        DISPLAY '* 8151-LOAD-SECURITY-TABLE           *'          
ACT156        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
ACT156        DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                    
ACT156        DISPLAY '* PROGRAM ABORTING...                *'          
ACT156        DISPLAY '********** PCSCA801 ABORT ************'          
ACT156        PERFORM 9900-ABEND              THRU 9900-EXIT            
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 8151-EXIT.                                                       
ACT156     EXIT.                                                        
ACT156*                                                                 03240000
ACT156******************************************************************03250000
ACT156*                                                                *03260000
ACT156*       8152-FETCH-SURT-INFO                                     *03270000
ACT156*                                                                *03280000
ACT156******************************************************************03290000
ACT156 8152-FETCH-SURT-INFO.                                            
ACT156                                                                  
ACT156     MOVE '8152'                        TO ACTIVE-PARAGRAPH.      
ACT156                                                                  
ACT156     EXEC SQL                                                     
ACT156        FETCH SURT_INFO                                           
ACT156          INTO  :WS-ACCOUNT-HOLD                                  
ACT156     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT156                                                                  
ACT156     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT156     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT156        CONTINUE                                                  
ACT156     ELSE                                                         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         DISPLAY '* 8152-FETCH-SURT-INFO               *'         
ACT156         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
ACT156         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
ACT156         DISPLAY '* PROGRAM ABORTING...                *'         
ACT156         DISPLAY '********** PCSCA801 ABORT ************'         
ACT156         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT156     END-IF.                                                      
ACT156                                                                  
ACT156 8152-EXIT.                                                       
ACT156     EXIT.                                                        
C28615*                                                                 05389200
      ******************************************************************05389300
      *                                                                *05389400
      *       8300-PROCESS-OUTFILE.                                     05389500
      *                                                                *05389600
      ******************************************************************05389700
       8300-PROCESS-OUTFILE.                                            
                                                                        
T26954     IF SEB-DATABASE                                              
T26954         PERFORM 7530-SELECT-REG-GROUP-CD THRU 7530-EXIT          
T26954     ELSE                                                         
T26954         MOVE '   ' TO LR-REG-GROUP-CD                            
T26954     END-IF.                                                      
T26954*                                                                 05389960
T26954     MOVE LR-REG-GROUP-CD           TO E-FCA801-REG-GROUP-CD.     
           MOVE AT-BILL-CYCLE             TO E-FCA801-BILL-CYCLE.       
C28615     MOVE AT-BILL-CYCLE             TO WS-BILL-CYCLE.             
C28615     MOVE AT-ACCOUNT-NO             TO E-FCA801-ACCOUNT-NO.       
           MOVE WS-ADD-00                 TO E-FCA801-AR-DAY-00.        
           MOVE WS-ADD-30                 TO E-FCA801-AR-DAY-30.        
           MOVE WS-ADD-60                 TO E-FCA801-AR-DAY-60.        
           MOVE WS-ADD-90                 TO E-FCA801-AR-DAY-90.        
C30070     MOVE WS-BHV-MODEL-ID           TO E-FCA801-BHV-MODEL-ID.     
C30070     MOVE WS-BHV-SCORE-RATING       TO E-FCA801-BHV-SCORE-RATING. 
C28615     IF WS-GUA-AMT-C(10:1) = 9                                    
C28615        MOVE 9999999999.99          TO E-FCA801-SECURITY-AMT      
C28615     ELSE                                                         
C28615        COMPUTE WS-SECURITY-AMT  =  (WS-DEP-AMT + WS-GUA-AMT +    
C28615                                     WS-SURETY-AMT)               
C28615        MOVE WS-SECURITY-AMT           TO E-FCA801-SECURITY-AMT   
C28615     END-IF                                                       
                                                                        
C28615     IF ((WS-BILL-CYCLE >= 01) AND                                
C28615         (WS-BILL-CYCLE <= 21))                                   
               MOVE E-FCA801-DATA-REC          TO FIOCA801-DATA         
               WRITE FIOCA801-FILE                                      
C28615     END-IF                                                       
      *                                                                 05390800
           PERFORM 0110-RE-INITIALIZE THRU 0110-EXIT.                   
      *                                                                 05391000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05392200
      ******************************************************************05392300
      *                                                                *05392400
      *       9000-TERMINATE                                           *05392500
      *                                                                *05392600
      ******************************************************************05392700
       9000-TERMINATE.                                                  
      *                                                                 05392900
           CLOSE OUTFILE.                                               
      *                                                                 05394000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05397000
      ****************************************************************  05398000
      **    9900-ABEND                                              **  05399000
      ****************************************************************  05400000
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           MOVE 12                         TO RETURN-CODE.              
           MOVE 'YES'                      TO WS-ABEND-SWITCH.          
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
      *                                                                 05490000
