       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA789.                                            
       AUTHOR. RS7M249.                                                 
       DATE-WRITTEN. 16 SEP 2015.                                       
       DATE-COMPILED.                                                   
      ******************************************************************00050000
      *                 SOUTH CAROLINA ELECTRIC & GAS                  *00060000
      *                                                                *00070000
      ******************************************************************00080000
      *                 CUSTOMER INFORMATION SYSTEM                    *00090000
      ******************************************************************00100000
      *                       PROGRAM SUMMARY                          *00110000
      *                                                                *00120000
      * PURPOSE:  CREATE  DNP CANCEL PROBLEM REPORT AND GENERATES EMAIL*00130099
      *                                                                *00140000
      ******************************************************************00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                PROGRAM  MODIFICATION  LOG                      *00230000
      *                                                                *00240000
      *       DATE       INITIALS         REASON                       *00250000
      *     ----------   --------         ---------------------------  *00260000
      *     09/16/2015   RS7M249          INITIALLY CODED.             *00270077
      ******************************************************************00380000
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSCA789-FILE ASSIGN TO UT-S-FCSCA789                 
              FILE STATUS IS WS-FCSCA789-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
      *                                                                 00521098
           COPY CFDCA789.                                               00522098
           COPY FIOCA789.                                               00523098
      *                                                                 00524098
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA789'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                    PIC X(40)  VALUE                  
           'WORKING STORAGE FOR PCSCA789 STARTS HERE'.                  
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-PGMNAME               PIC X(08)  VALUE 'PCSCA789'.      
          05 WS-YES                   PIC X(01)  VALUE 'Y'.             
          05 WS-NO                    PIC X(01)  VALUE 'N'.             
          05 WS-FIRST-TIME            PIC X(01)  VALUE 'Y'.             
          05 WS-HEADER.                                                 
             10  FILLER            PIC X(10) VALUE 'ACCOUNT_NO'.        
             10  FILLER            PIC X(05) VALUE SPACES.              
             10  FILLER            PIC X(14) VALUE 'PAYMENT_AMOUNT'.    
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(16) VALUE 'DATE_CASH_REPORT'.  
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(17) VALUE 'CASH_LOCAL_OFFICE'. 
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(14) VALUE 'CODE_ACCT_STAT'.    
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(16) VALUE 'TOTAL_AR_BALANCE'.  
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(12) VALUE 'APPLIED_FLAG'.      
             10  FILLER            PIC X(01) VALUE SPACES.              
             10  FILLER            PIC X(18) VALUE 'APPLIED_TIME_STAMP'.
             10  FILLER            PIC X(08) VALUE SPACES.              
             10  FILLER            PIC X(13) VALUE 'TRANS_TYPE_CD'.     
          05 WS-REPORT-PRINTED        PIC X(01)  VALUE 'N'.             
                                                                        
       01  WS-FILE-VARIABLES.                                           
           05  WS-FCSCA789-STATUS     PIC X(02)  VALUE '00'.            
               88 FCSCA789-SUCCESSFUL            VALUE '00'.            
           05  WS-NO-MORE-ROWS        PIC X(01)  VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
       01 WS-VARIABLES.                                                 
           05 WS-TIMESTAMP            PIC X(26)  VALUE SPACES.          
           05 WS-LAST-RUN-TIME-STAMP  PIC X(26)  VALUE SPACES.          
          05 WS-PAYMENT-AMT           PIC X(13)  VALUE SPACES.          
          05 WS-DATE-CASH-REPORT      PIC X(10)  VALUE SPACES.          
          05 WS-CASH-LOCAL-OFFICE     PIC X(03)  VALUE SPACES.          
          05 WS-TOTAL-AR-BALANCE      PIC X(15)  VALUE SPACES.          
          05 WS-APPLIED-FL            PIC X(01)  VALUE SPACES.          
          05 WS-APPLIED-TS            PIC X(26)  VALUE SPACES.          
          05 WS-TRANS-TYPE-CD         PIC X(01)  VALUE SPACES.          
          05 WS-CURRENT1-DATE         PIC X(10)  VALUE SPACES.          
          05 WS-CURRENT-DATE.                                           
             10 WS-CY                 PIC 9(04).                        
             10 WS-CM                 PIC 9(02).                        
             10 WS-CD                 PIC 9(02).                        
                                                                        
          05  WS-RUN-DATE.                                              
              10  WS-RD-YY            PIC X(04).                        
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-RD-MM            PIC X(02).                        
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-RD-DD            PIC X(02).                        
                                                                        
      ***************************************************************** 01140000
      *  COPYBOOK WITH COMMON SQL VARIABLES                           * 01150000
      ***************************************************************** 01160000
         COPY CWS00303.                                                 01170031
                                                                        
      ***************************************************************** 01220000
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       * 01230000
      ***************************************************************** 01240000
         COPY CWS00010.                                                 01250031
                                                                        
      ***************************************************************** 01260000
      * WORKING STORAGE FOR CPD09900                                  * 01270000
      ***************************************************************** 01280000
         COPY CWS09900.                                                 01290032
                                                                        
      ***************************************************************** 01990000
      * SQL COMMUNICATION AREA                                        * 02000000
      ***************************************************************** 02010000
           EXEC SQL                                                     02020032
              INCLUDE SQLCA                                             02030032
           END-EXEC.                                                    02040032
                                                                        
      ***************************************************************** 02109174
      * CSS_ACCOUNT,        AT                                        * 02109275
      ***************************************************************** 02109374
           EXEC SQL                                                     02109474
              INCLUDE TBACCT                                            02109574
           END-EXEC.                                                    02109674
                                                                        
      ***************************************************************** 02109878
      * CSS_PAYMENT_TRANS,  JT                                        * 02109978
      ***************************************************************** 02110078
           EXEC SQL                                                     02120078
              INCLUDE TBPMTRAN                                          02130078
           END-EXEC.                                                    02140078
                                                                        
      ***************************************************************** 02160078
      * CSS_JOB_PARM,       G6                                        * 02170078
      ***************************************************************** 02180078
           EXEC SQL                                                     02190078
              INCLUDE TBJBPARM                                          02200078
           END-EXEC.                                                    02210078
                                                                        
      ***************************************************************** 03147078
      * CURSOR TO FIND PAYMENT TRANS.                                 * 03148078
      ***************************************************************** 03149078
           EXEC SQL                                                     
              DECLARE PAY_TRNS CURSOR FOR                               
                 SELECT AT.ACCOUNT_NO                                   
                       ,CIS.DECIMAL2CHAR(JT.PAYMENT_AMT)                        
                       ,JT.DATE_CASH_REPORT                             
                       ,JT.CASH_LOCAL_OFFICE                            
                       ,AT.CODE_ACCT_STAT                               
                       ,CIS.DECIMAL2CHAR(AT.TOTAL_AR_BALANCE)                   
                       ,JT.APPLIED_FL                                   
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), JT.APPLIED_TS
           , 121), ' ', '-'), ':', '.') APPLIED_TS                             
                       ,JT.TRANS_TYPE_CD                                
                   FROM CSS_PAYMENT_TRANS JT WITH(READUNCOMMITTED),             
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE JT.DATE_CASH_REPORT = CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                    AND JT.TRANS_TYPE_CD = 'P'                          
                    AND JT.APPLIED_FL   = 'Y'                           
                    AND JT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND CIS.SUBSTR3(AT.CODES_DATA_PRESENT,29,1) = 'A'        
                    AND JT.APPLIED_TS >= CIS.CHAR2TIMESTAMP(
                                                :WS-LAST-RUN-TIME-STAMP
              )        
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03150078
MFA-TR*       DECLARE PAY_TRNS CURSOR FOR                               03160078
MFA-TR*          SELECT AT.ACCOUNT_NO                                   03170078
MFA-TR*                ,CHAR(JT.PAYMENT_AMT)                            03180078
MFA-TR*                ,JT.DATE_CASH_REPORT                             03190078
MFA-TR*                ,JT.CASH_LOCAL_OFFICE                            03200078
MFA-TR*                ,AT.CODE_ACCT_STAT                               03210078
MFA-TR*                ,CHAR(AT.TOTAL_AR_BALANCE)                       03211078
MFA-TR*                ,JT.APPLIED_FL                                   03212078
MFA-TR*                ,JT.APPLIED_TS                                   03214078
MFA-TR*                ,JT.TRANS_TYPE_CD                                03215184
MFA-TR*            FROM CSS_PAYMENT_TRANS JT,                           03216078
MFA-TR*                 CSS_ACCOUNT AT                                  03217078
MFA-TR*           WHERE JT.DATE_CASH_REPORT = CURRENT DATE              03218099
MFA-TR*             AND JT.TRANS_TYPE_CD = 'P'                          03219084
MFA-TR*             AND JT.APPLIED_FL   = 'Y'                           03219184
MFA-TR*             AND JT.ACCOUNT_NO = AT.ACCOUNT_NO                   03219289
MFA-TR*             AND SUBSTR(AT.CODES_DATA_PRESENT,29,1) = 'A'        03219378
MFA-TR*             AND JT.APPLIED_TS >= :WS-LAST-RUN-TIME-STAMP        03219499
MFA-TR*             FOR FETCH ONLY WITH UR                              03219592
MFA-TR*         QUERYNO 7000                                            03219778
MFA-TR*    END-EXEC.                                                    03219878
                                                                        
       PROCEDURE DIVISION.                                              
      ***************************************************************** 03221073
      *  0000-MAINLINE.                                               * 03222073
      *       CONTROLS THE MAIN PROCESS OF PROGRAM                    * 03223073
      ***************************************************************** 03224073
             PERFORM 0100-INITIALIZATION-PARA THRU  0100-EXIT.          
             PERFORM 2000-PROCESS-ACC         THRU  2000-EXIT.          
             PERFORM 9000-TERMINATE           THRU  9000-EXIT.          
             STOP RUN.                                                  
                                                                        
      ******************************************************************03350000
      *  0100-INTIALZATION-PARA.                                       *03360000
      *       OPEN FILES                                               *03361078
      ******************************************************************03370000
          0100-INITIALIZATION-PARA.                                     
                                                                        
             ACCEPT WS-CURRENT-DATE  FROM DATE YYYYMMDD.                
             MOVE WS-CY                       TO WS-RD-YY.              
             MOVE WS-CM                       TO WS-RD-MM.              
             MOVE WS-CD                       TO WS-RD-DD.              
             MOVE WS-RUN-DATE                 TO WS-CURRENT1-DATE.      
                                                                        
             OPEN OUTPUT FCSCA789-FILE.                                 
             IF FCSCA789-SUCCESSFUL                                     
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**   PCSCA879 PROCESSING ERROR       **'       
                DISPLAY '** ERROR ON FCSCA789 OUTPUT FILE     **'       
                DISPLAY '**  FILE STATUS = ' WS-FCSCA789-STATUS         
                PERFORM 9900-ABEND                THRU 9900-EXIT        
             END-IF.                                                    
                                                                        
          0100-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03460000
      *  2000-PROCESS-ACC.                                             *03470073
      ******************************************************************03480000
          2000-PROCESS-ACC.                                             
                                                                        
             PERFORM 6050-FETCH-JOBPRM-CURSOR  THRU 6050-EXIT.          
             MOVE G6-PARM-DATA       TO WS-LAST-RUN-TIME-STAMP.         
             PERFORM 7000-OPEN-TRANS-CURSOR     THRU  7000-EXIT.        
                                                                        
             PERFORM 7100-FETCH-TRANS-CURSOR    THRU  7100-EXIT.        
                                                                        
             PERFORM 2100-PROCESS-TRANS         THRU  2100-EXIT         
                UNTIL NO-MORE-ROWS.                                     
                                                                        
             PERFORM 7200-CLOSE-TRANS-CURSOR    THRU  7200-EXIT.        
             PERFORM 7300-UPDATE-RUN-TIME-STAMP THRU  7300-EXIT.        
                                                                        
          2000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03601090
      *  2100-PROCESS-TRANS                                            *03602090
      ******************************************************************03603090
          2100-PROCESS-TRANS.                                           
                                                                        
               IF WS-FIRST-TIME = WS-YES                                
                  MOVE WS-HEADER            TO E-FCA789-DATA            
                  WRITE FIOCA789                                        
                  MOVE SPACES               TO E-FCA789-DATA            
                  MOVE WS-NO                TO WS-FIRST-TIME            
               END-IF.                                                  
                                                                        
               MOVE AT-ACCOUNT-NO         TO E-FCA789-ACCOUNT-NO.       
               MOVE WS-PAYMENT-AMT        TO E-FCA789-PAYMENT-AMT.      
               MOVE WS-DATE-CASH-REPORT   TO E-FCA789-DATE-CASH-REPORT. 
               MOVE WS-CASH-LOCAL-OFFICE  TO E-FCA789-CASH-LOCAL-OFFICE.
               MOVE AT-CODE-ACCT-STAT     TO E-FCA789-CODE-ACCT-STAT.   
               MOVE WS-TOTAL-AR-BALANCE   TO E-FCA789-TOTAL-AR-BAL.     
               MOVE WS-APPLIED-FL         TO E-FCA789-APPLIED-FL.       
               MOVE WS-APPLIED-TS         TO E-FCA789-APPLIED-TS.       
               MOVE WS-TRANS-TYPE-CD      TO E-FCA789-TRANS-TYPE-CD.    
               MOVE SPACES                TO E-FCA789-FILLER1.          
               MOVE SPACES                TO E-FCA789-FILLER2.          
               MOVE SPACES                TO E-FCA789-FILLER3.          
               MOVE SPACES                TO E-FCA789-FILLER4.          
               MOVE SPACES                TO E-FCA789-FILLER5.          
               MOVE SPACES                TO E-FCA789-FILLER6.          
               MOVE SPACES                TO E-FCA789-FILLER7.          
               MOVE SPACES                TO E-FCA789-FILLER8.          
               MOVE SPACES                TO E-FCA789-FILLER9.          
                                                                        
               WRITE FIOCA789.                                          
               MOVE SPACES               TO E-FCA789-DATA.              
               MOVE WS-YES               TO WS-REPORT-PRINTED.          
             PERFORM 7100-FETCH-TRANS-CURSOR    THRU  7100-EXIT.        
                                                                        
          2100-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03797579
      *  6050-FETCH-JOBPRM-CURSOR.                                     *03797679
      ******************************************************************03798079
       6050-FETCH-JOBPRM-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(PARM_DATA,15,26)                          
                 INTO :G6-PARM-DATA                                     
                 FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                       
                WHERE  PROGRAM_NAME   = 'PCSCA789'                      
                  AND  COMPANY_NO     = '01'                            
                  AND  CMND_CODE      = 'PARM'                          
                  AND  STATUS         = 'A'                             
                  AND  SEQ_NO         = 10                              
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     03799295
MFA-TR*        SELECT  SUBSTR(PARM_DATA,15,26)                          03799399
MFA-TR*          INTO :G6-PARM-DATA                                     03799497
MFA-TR*          FROM  CSS_JOB_PARM                                     03799594
MFA-TR*         WHERE  PROGRAM_NAME   = 'PCSCA789'                      03799699
MFA-TR*           AND  COMPANY_NO     = '01'                            03799794
MFA-TR*           AND  CMND_CODE      = 'PARM'                          03799894
MFA-TR*           AND  STATUS         = 'A'                             03799994
MFA-TR*           AND  SEQ_NO         = 10                              03800094
MFA-TR*          WITH  UR                                               03800194
MFA-TR*    END-EXEC.                                                    03800495

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
            IF WS-ACTIVE-RETURN-CODE   EQUAL NOT-FOUND                  
              DISPLAY '********** PCSCA789 *************************'   
              DISPLAY '* DATA NOT FOUND ON JOB PARM FOR COMMONDATE *'   
              DISPLAY '* FETCHING PROCESSING TERMINATED...         *'   
              DISPLAY '********** PCSCA789 *************************'   
            END-IF                                                      
           ELSE                                                         
              DISPLAY '********** PCSCA789 ABORT *****************'     
              DISPLAY '*        6050-FETCH-JOBPRM-CURSOR         *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA789 ABORT *****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************03819979
      *  7000-OPEN-TRANS-CURSOR.                                       *03820079
      ******************************************************************03821079
          7000-OPEN-TRANS-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN PAY_TRNS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA789 ABORT *****************'     
              DISPLAY '*        7000-OPEN-TRANS-CURSOR           *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA789 ABORT *****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03835079
      *  7100-FETCH-TRANS-CURSOR.                                      *03836079
      *  CREATE REPORT FOR DUPLICATE PAYMENT TRANS                     *03836179
      ******************************************************************03837079
          7100-FETCH-TRANS-CURSOR.                                      
                                                                        
             EXEC SQL                                                   
                FETCH PAY_TRNS                                          
                 INTO :AT-ACCOUNT-NO                                    
                     ,:WS-PAYMENT-AMT                                   
                     ,:WS-DATE-CASH-REPORT                              
                     ,:WS-CASH-LOCAL-OFFICE                             
                     ,:AT-CODE-ACCT-STAT                                
                     ,:WS-TOTAL-AR-BALANCE                              
                     ,:WS-APPLIED-FL                                    
                     ,:WS-APPLIED-TS                                    
                     ,:WS-TRANS-TYPE-CD                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES           TO WS-NO-MORE-ROWS               
              END-IF                                                    
           ELSE                                                         
                                                                        
              DISPLAY '********** PCSCA789 ABORT *****************'     
              DISPLAY '*        7100-FETCH-TRANS-CURSOR          *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA789 ABORT *****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
          7100-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03847181
      *  7200-CLOSE-TRANS-CURSOR                                       *03847281
      ******************************************************************03847381
          7200-CLOSE-TRANS-CURSOR.                                      
                                                                        
             EXEC SQL                                                   
                CLOSE PAY_TRNS                                          
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA789 ABORT *****************'     
              DISPLAY '*       7200-CLOSE-TRANS-CURSOR           *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA789  ABORT ****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7200-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03849681
      *  7300-UPDATE-RUN-TIME-STAMP                                    *03849781
      ******************************************************************03849881
          7300-UPDATE-RUN-TIME-STAMP.                                   
                                                                        
             EXEC SQL                                                   
                UPDATE CSS_JOB_PARM                                     
                 SET PARM_DATA = CIS.SUBSTR3(PARM_DATA,1,14) + 
           SUBSTRING(REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'), 1, 26)   
                 WHERE PROGRAM_NAME   = 'PCSCA789'                      
                   AND COMPANY_NO     = '01'                            
                   AND CMND_CODE      = 'PARM'                          
                   AND STATUS         = 'A'                             
                   AND SEQ_NO         = 10                              
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*      EXEC SQL                                                   03850181
MFA-TR*         UPDATE CSS_JOB_PARM                                     03850281
MFA-TR*          SET PARM_DATA = SUBSTR(PARM_DATA,1,14) ||              03850391
MFA-TR*                          SUBSTR(CHAR(CURRENT TIMESTAMP),1,26)   03850481
MFA-TR*          WHERE PROGRAM_NAME   = 'PCSCA789'                      03850599
MFA-TR*            AND COMPANY_NO     = '01'                            03850681
MFA-TR*            AND CMND_CODE      = 'PARM'                          03850781
MFA-TR*            AND STATUS         = 'A'                             03850881
MFA-TR*            AND SEQ_NO         = 10                              03850981
MFA-TR*      END-EXEC.                                                  03851081

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA789 ABORT *******************'
                 DISPLAY '* DATA NOT FOUND ON JOB PARM FOR COMMONDATE *'
                 DISPLAY '*       7300-UPDATE-RUN-TIME-STAMP          *'
                 DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE    
                 DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO            
                 DISPLAY '* UPDATE PROCESSING TERMINATED...           *'
                 DISPLAY '********** PCSCA789  ABORT ******************'
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
          7300-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06640200
      * 8000-WRITE-REPORT                                              *06640337
      ******************************************************************06640400
          8000-WRITE-REPORT.                                            
                                                                        
             WRITE  FIOCA789.                                           
             IF FCSCA789-SUCCESSFUL                                     
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**        PCSCA789 PROCESSING ERROR       **'  
                DISPLAY '** CLOSE ERROR FOR FCSCA789 - OUTPUT FILE **'  
                DISPLAY '**      FILE STATUS = ' WS-FCSCA789-STATUS     
                PERFORM  9900-ABEND               THRU 9900-EXIT        
             END-IF.                                                    
                                                                        
          8000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06770000
      *  9000-TERMINATE                                                *06780000
      ******************************************************************06790000
          9000-TERMINATE.                                               
                                                                        
             CLOSE FCSCA789-FILE.                                       
                                                                        
             IF FCSCA789-SUCCESSFUL                                     
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**        PCSCA789 PROCESSING ERROR       **'  
                DISPLAY '** CLOSE ERROR FOR FCSCA789 - OUTPUT FILE **'  
                DISPLAY '**      FILE STATUS = ' WS-FCSCA789-STATUS     
             END-IF.                                                    
                                                                        
          9000-EXIT.                                                    
             EXIT.                                                      
      ***************************************************************** 06870000
      * 9100-DISPLAY-ERROR.                                           * 06880000
      ***************************************************************** 06900000
          9100-DISPLAY-ERROR.                                           
             DISPLAY '**   PROCESSING ERROR IN PCSCA789  **'.           
             DISPLAY '**   ABENDING PROGRAM              **'.           
             PERFORM 9900-ABEND               THRU 9900-EXIT.           
                                                                        
          9100-EXIT.                                                    
             EXIT.                                                      
      ***************************************************************** 06982100
      * 9900-PROCESS-ABEND                                            * 06982200
      ***************************************************************** 06983000
           EXEC SQL                                                     06984032
              INCLUDE CPD09900                                          06985032
           END-EXEC.                                                    06986032
