       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA779.                                        
       AUTHOR.         VAISHNAVI.                                       
       DATE-WRITTEN.   FEB 2008.                                        
      ***************************************************************** 00060000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00070000
      ***************************************************************** 00080000
      **                                                             ** 00090000
      **              PROGRAM  MODIFICATION  LOG                     ** 00100000
      **                                                             ** 00110000
      **    DATE    INITIALS     REASON                              ** 00120000
      **  --------  --------     ----------------------------------  ** 00130000
C35152**    02/08   SV82012      INITIAL VERSION.                    ** 00140000
      ***************************************************************** 00150000
                                                                        
      ***************************************************************** 00170000
      **                     PCSCA779 NARRATIVE                      ** 00180000
      **                                                             ** 00190000
      **  THIS PROGRAM IS TO EXTARCT THE BANKDRAFT INFO FROM BE28    ** 00200000
      **  FILE AND REFORMAT THEM INTO BE59 LAYOUT.                   ** 00210000
      ***************************************************************** 00220000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE28.                                                    00310000
       COPY CSSBE59.                                                    00320000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28.                                                     
           02  FIOBE28-DATA-REC.                                        
               05  E-FBE28-SORT-KEY              PIC X(65).             
               05  E-FBE28-DATA                  PIC X(1135).           
                                                                        
       FD  FCSBE59-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY FIOBE59.                                                    00520000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA779'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-EXT-IO-AREA.                                               
         05 SORT-KEY.                                                   
            10 LEVEL-1-SORT-FLDS.                                       
               15 KEY-L1-COMP-NO          PIC 9(2).                     
            10 LEVEL-2-SORT-FLDS.                                       
               15 KEY-L2-ACCOUNT-NO       PIC X(13).                    
               15 KEY-L2-DATE-BILLED      PIC X(10).                    
            10 LEVEL-3-SORT-FLDS.                                       
               15 KEY-L3-REC-SEQ          PIC X(3).                     
               15 KEY-L3-RECORD-ID        PIC X(10).                    
               15 KEY-L3-TIE-BREAKER      PIC 9(4).                     
            10 LEVEL-4-SORT-FLDS.                                       
               15 KEY-L4-SUB-ACCOUNT      PIC X(13).                    
               15 KEY-L4-SUB-DATE-BILLED  PIC X(10).                    
         05 WS-BILL-DATA                  PIC X(1135).                  
       COPY FIOEXT98.                                                   00710000
       COPY CWS00038.                                                   00720000
       COPY CWS00039.                                                   00730000
       COPY CWS00303.                                                   00740000
       COPY FIOCA00.                                                    00750000
       COPY FIOJC01.                                                    00760000
      ***********************************************************       00770000
      **  SQL COPYBOOKS                                        **       00780000
      ***********************************************************       00790000
           EXEC SQL                                                     00800000
               INCLUDE SQLCA                                            00810000
           END-EXEC.                                                    00820000
      *                                                                 00830000
           EXEC SQL                                                     00840000
               INCLUDE TBJBPARM                                         00850000
           END-EXEC.                                                    00860000
      * CSS_BILL_WINDOW BN                                              00870000
           EXEC SQL                                                     00880000
               INCLUDE TBBILWDW                                         00890000
           END-EXEC.                                                    00900000
      *                                                                 00910000
                                                                        
       01  WS-MISC.                                                     
           05  WS-LEN                  PIC 9(4)   COMP.                 
           05  WS-FBE28-STATUS         PIC XX     VALUE '  '.           
               88  FBE28-SUCCESSFUL               VALUE '00'.           
               88  FBE28-READ-OK                  VALUE '00' '04'.      
           05  WS-FBE59-STATUS             PIC XX VALUE '  '.           
               88  FBE59-SUCCESSFUL               VALUE '00'.           
           05  WS-DATE-DATA.                                            
               10  WS-CURRENT-DATE         PIC X(10).                   
               10  FILLER                  PIC X(70).                   
           05  WS-EXT-SUB                  PIC 9(03).                   
           05  WS-INSERT-AMOUNT            PIC S9(09)V9(2).             
           05  WS-DELETE-AMOUNT            PIC S9(09)V9(2).             
           05  WS-REC-COUNT                PIC 9(07).                   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                        PIC  X(01) VALUE 'Y'.        
           05  WS-N                        PIC  X(01) VALUE 'N'.        
           05  WS-PGRMNAME                 PIC  X(08) VALUE 'PCSCA779'. 
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-BEGIN-REC-SW                 PIC  X(01).              
               88  WS-BEGIN-REC-PROCESSED                 VALUE 'Y'.    
               88  WS-BEGIN-REC-NOT-PROCESSED             VALUE 'N'.    
           05  WS-END-REC-SW                   PIC  X(01).              
               88  WS-END-REC-PROCESSED                   VALUE 'Y'.    
               88  WS-END-REC-NOT-PROCESSED               VALUE 'N'.    
           05  WS-MORE-BEGIN-REC               PIC X      VALUE 'N'.    
           05  WS-END-OF-BE28                  PIC X      VALUE 'N'.    
               88  END-OF-BE28                            VALUE 'Y'.    
                                                                        
           05  WS-RECORD-ID       PIC X(11).                            
               88  WS-COMPANY          VALUE '0          '.             
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-USERABEN             PIC X(08)     VALUE 'USERABEN'.  
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ***************************************************************** 01340000
      *  PERFORM THE INITIALIZATION ROUTINE.  READ THE FIRST RECORD   * 01350000
      *  FROM THE INPUT FILE, WHICH MUST BE THE BEGINNING CONTROL     * 01360000
      *  RECORD (KEY OF LOW VALUES).  WRITE THIS CONTROL RECORD TO    * 01370000
      *  THE NON-EXCEPTION ACCOUNT (BE40).                            * 01380000
      ***************************************************************** 01390000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
                                                                        
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
T35152     PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
T35152     PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
T35152     MOVE WS-FCA00-COMMON-DATE   TO WS-CURRENT-DATE.              
T35152     MOVE LOW-VALUES             TO E-FBE59-KEY-BREC.             
T35152     MOVE 0                      TO E-FBE59-DB-PART-BREC.         
T35152     MOVE WS-CURRENT-DATE        TO E-FBE59-CREATE-DATE-BREC.     
T35152     PERFORM 8000-WRITE-FCSBE59    THRU 8000-EXIT.                
           PERFORM 7990-READ-FCSBE28 THRU 7990-EXIT.                    
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
             END-OF-BE28.                                               
           MOVE HIGH-VALUES            TO E-FBE59-KEY-EREC.             
           MOVE 0                      TO E-FBE59-DB-PART-EREC.         
           MOVE WS-INSERT-AMOUNT       TO E-FBE59-INSERT-AMOUNT.        
           MOVE WS-DELETE-AMOUNT       TO E-FBE59-DELETE-AMOUNT.        
           MOVE WS-REC-COUNT           TO E-FBE59-RECORD-COUNT-EREC.    
           PERFORM 8000-WRITE-FCSBE59    THRU 8000-EXIT.                
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 01550000
      *  OPEN INPUT FILE FCSBE28 AND OUTPUTFILE FCSBE59.              * 01560000
      ***************************************************************** 01570000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSBE28-FILE.                                     
           IF WS-FBE28-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBE28'                     
               DISPLAY '**   FILE STATUS = ' WS-FBE28-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                TO RETURN-CODE                    
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           OPEN OUTPUT FCSBE59-FILE.                                    
           IF WS-FBE59-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBE40'                     
               DISPLAY '**   FILE STATUS = ' WS-FBE59-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                TO RETURN-CODE                    
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           INITIALIZE WS-INSERT-AMOUNT                                  
                      WS-DELETE-AMOUNT                                  
                      WS-REC-COUNT.                                     
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      01880000
      *  MAKE SURE THE FIRST RECORD OF THE INPUT FILE IS A       *      01890000
      *  BEGINNING CONTROL RECORD (KEY = LOW-VALUES).  THERE CAN *      01900000
      *  BE MORE THAN ONE BEGINNING CONTROL RECORD.              *      01910000
      ************************************************************      01920000
                                                                        
       0200-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7990-READ-FCSBE28 THRU 7990-EXIT.                    
           IF END-OF-BE28                                               
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '********************************'               
               DISPLAY '** PCSCA779 PROCESSING ERROR  **'               
               DISPLAY '**   FCSBE28 FILE IS EMPTY    **'               
               DISPLAY '**   PROCESSING TERMINATED    **'               
               DISPLAY '********************************'               
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
      *                                                                 02060000
      *    IF E-FBE28-RECORD-ID = LOW-VALUES                            02070000
      *        MOVE WS-YES            TO WS-BEGIN-REC-SW                02080000
      *        MOVE WS-EXT-IO-AREA    TO FIOBE59-DATA                   02090000
      *    ELSE                                                         02100000
      *       IF WS-BEGIN-REC-PROCESSED                                 02110000
      *           MOVE WS-NO TO WS-MORE-BEGIN-REC                       02120000
      *           GO TO 0200-EXIT                                       02130000
      *       ELSE                                                      02140000
      *           MOVE 12 TO RETURN-CODE                                02150000
      *           DISPLAY '*******************************************' 02160000
      *           DISPLAY '**       PCSCA779 PROCESSING ERROR       **' 02170000
      *           DISPLAY '**        INPUT FILE FCSBE28             **' 02180000
      *           DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD **' 02190000
      *           DISPLAY '**         PROCESSING TERMINATED         **' 02200000
      *           DISPLAY '********************************************'02210000
      *           PERFORM 9000-TERMINATE THRU 9000-EXIT                 02220000
      *       END-IF                                                    02230000
      *    END-IF.                                                      02240000
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0500-OBTAIN-BILL-CYCLE.                                          
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
           MOVE WS-FCA00-COMMON-DATE TO BN-DATE-EXTRACT.                
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   02360000
      * LOAD BANK DRAFT DETAILS INTO FIOEXT98 LAYOUT. FOR EACH      *   02370000
      * OCCURRENCE OF BANKDRAFT WRITE A SEPERATE ROW IN BE59 FILE.  *   02380000
      * ADD THE TOTALS AND WRITE IN THE END.                        *   02390000
      ***************************************************************   02400000
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           MOVE WS-BILL-DATA      TO EXT-BANK-DRAFT-REC.                
           PERFORM VARYING WS-EXT-SUB FROM 1 BY 1 UNTIL                 
             WS-EXT-SUB > 35 OR                                         
             EXT-BNKDRFT-ACCT-NO(WS-EXT-SUB) <= ZERO                    
             MOVE EXT-BNKDRFT-ACCOUNT-NO   TO E-FBE59-ACCOUNT-NO        
             MOVE EXT-BNKDRFT-BILL-DEST-CODE                            
                                           TO E-FBE59-DEST-CODE         
             MOVE EXT-BNKDRFT-BILL-PULL-CODE                            
                                           TO E-FBE59-PULL-CODE         
             MOVE EXT-BNKDRFT-DRAFT-DATE (WS-EXT-SUB)                   
                                           TO E-FBE59-DRAFT-DATE        
             MOVE EXT-BNKDRFT-DRAFT-AMT (WS-EXT-SUB)                    
                                           TO E-FBE59-DRAFT-AMT         
             MOVE EXT-BNKDRFT-TRANS-CD (WS-EXT-SUB)                     
                                           TO E-FBE59-TRANSACTION-CD    
             MOVE EXT-BNKDRFT-CODE-SOURCE-ID (WS-EXT-SUB)               
                                           TO E-FBE59-CODE-SOURCE-ID    
             MOVE EXT-BNKDRFT-INS-DEL-FLAG (WS-EXT-SUB)                 
                                           TO E-FBE59-INS-DEL-FLAG      
             MOVE EXT-BNKDRFT-BANK-SEQ-NO (WS-EXT-SUB)                  
                                           TO E-FBE59-BANK-SEQ-NO       
             EVALUATE EXT-BNKDRFT-INS-DEL-FLAG (WS-EXT-SUB)             
                 WHEN 'I'                                               
                      COMPUTE WS-INSERT-AMOUNT  = WS-INSERT-AMOUNT      
                      + EXT-BNKDRFT-DRAFT-AMT (WS-EXT-SUB)              
                 WHEN 'D'                                               
                      COMPUTE WS-DELETE-AMOUNT  = WS-DELETE-AMOUNT      
                      + EXT-BNKDRFT-DRAFT-AMT (WS-EXT-SUB)              
             END-EVALUATE                                               
             ADD 1                         TO WS-REC-COUNT              
             PERFORM 8000-WRITE-FCSBE59    THRU 8000-EXIT               
           END-PERFORM.                                                 
           PERFORM 7990-READ-FCSBE28 THRU 7990-EXIT.                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************          02810000
      *   6240-GET-FCA00-COMMON-DATE.                        *          02820000
      ********************************************************          02830000
       COPY CPD00040.                                                   02840000
                                                                        
      ********************************************************          02860000
      * 6251-GET-FJC01-DATE.                                 *          02870000
      ********************************************************          02880000
       COPY CPD00037.                                                   02890000
                                                                        
      ******************************************************************02910000
      *     7600-START-FCSJC01                                         *02920000
      ******************************************************************02930000
                                                                        
            EXEC SQL                                                    02950000
              INCLUDE CPD00038                                          02960000
            END-EXEC.                                                   02970000
                                                                        
      ******************************************************************02990000
      *     7620-START-FCSCA00                                         *03000000
      ******************************************************************03010000
                                                                        
            EXEC SQL                                                    03030000
              INCLUDE CPD00039                                          03040000
            END-EXEC.                                                   03050000
                                                                        
      ************************************************************      03070000
      *  READ THE BE28 INPUT FILE                                *      03080000
      ************************************************************      03090000
                                                                        
       7990-READ-FCSBE28.                                               
                                                                        
           INITIALIZE WS-BILL-DATA.                                     
           READ FCSBE28-FILE INTO WS-EXT-IO-AREA                        
               AT END                                                   
                  MOVE WS-YES TO WS-END-OF-BE28.                        
           IF FBE28-READ-OK OR END-OF-BE28                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA779 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ************************************************************      03320000
      *  WRITE THE BE59 OUTPUT FILE                              *      03330000
      ************************************************************      03340000
       8000-WRITE-FCSBE59.                                              
                                                                        
            WRITE FIOBE59-DATA.                                         
                                                                        
       8000-EXIT.                                                       
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE28-FILE                                           
                 FCSBE59-FILE.                                          
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03500000
      *     9900-ABEND                                                 *03510000
      *                                                                *03520000
      *     PERFORMED IF VSAM PROBLEM OCCURS.                          *03530000
      ******************************************************************03540000
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
