       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA770.                                        
       AUTHOR.         ERIC MCCARTNEY.                                  
       DATE-WRITTEN.   DEC 2005.                                        
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060000
      ***************************************************************** 00070000
      **                                                             ** 00080000
      **              PROGRAM  MODIFICATION  LOG                     ** 00090000
      **                                                             ** 00100000
      **    DATE    INITIALS     REASON                              ** 00110000
      **  --------  --------     ----------------------------------  ** 00120000
      **  12/2005   EM19682      INITIAL VERSION OF PROGRAM          ** 00130000
T33185**  05/2007   PC97415      ADDED WITH UR FOR SELECT            ** 00141000
T35152**  10/2008   SDHAL        CHANGED COPYBOOK FIOBE26 TO FIOBE26A** 00142001
      ***************************************************************** 00150000
                                                                        
      ***************************************************************** 00170000
      **  PCSCA770 WILL INSERT OR UPDATE CSS_EBILL_INSERTS           ** 00180000
      **  THE INSERT PROCESS HAS BEEN TAKEN OUT OF PCSCA105.         ** 00190000
      ***************************************************************** 00200000
      *                                                                 00210000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE26.                                                    00250000
      *                                                                 00270000
       DATA DIVISION.                                                   
      *                                                                 00290000
       FILE SECTION.                                                    
                                                                        
       COPY CFDBE26.                                                    00371000
T35152 COPY FIOBE26A.                                                   00372001
      *                                                                 00380000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA770'.
MSQ017     COPY MFASQLM.
      *                                                                 00400000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA770'.  
           05  WS-PCSCA770-STATUS          PIC X(02) VALUE '  '.        
               88  PCSCA770-SUCCESSFUL     VALUE '00' '04'.             
           05  WS-FBE26-STATUS             PIC X(02) VALUE '  '.        
               88 FBE26-SUCCESSFUL         VALUE '00' '04'.             
           05  WS-ABEND-SWITCH             PIC X(03).                   
               88  WS-ABEND-YES                      VALUE 'YES'.       
           05  WS-END-OF-RUN-FLAG          PIC X(01).                   
               88  MORE-RECORDS                      VALUE 'N'.         
               88  NO-MORE-RECORDS                   VALUE 'Y'.         
           05  WS-END-OF-BE26              PIC X VALUE 'N'.             
               88  END-OF-BE26                       VALUE 'Y'.         
           05  WS-BILL-VIEW-SW             PIC X(01) VALUE 'N'.         
               88  BILL-VIEW                         VALUE 'Y'.         
           05  WS-HOLD-ACCT-NUMBER         PIC 9(13).                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-REVENUE-MONTH-JP         PIC X(06).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH-JP.                    
               10  WS-REV-MONTH-CURR-CCYY  PIC X(04).                   
               10  WS-REV-MONTH-CURR-MM    PIC X(02).                   
           05  WS-REV-MONTH-NUM.                                        
               10  WS-FUT-REV-CCYY         PIC 9(04).                   
               10  WS-FUT-REV-MM           PIC 9(02).                   
           05  WS-BILLED-DATE.                                          
               10  WS-BILLED-DATE-CC       PIC X(02).                   
               10  WS-BILLED-DATE-YY       PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-BILLED-DATE-MM       PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-BILLED-DATE-DD       PIC X(02).                   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA770'.  
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
      *                                                                 00790000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 00830000
           COPY CWS10009.                                               00840000
           COPY CWS00074.                                               00841000
           COPY CWS00011.                                               00850000
           COPY CWS00303.                                               00860000
           COPY CWS00010.                                               00870000
      ******* CWS00038 IS JC01 WORK DATA                                00880000
           COPY CWS00038.                                               00890000
      ******* CWS00039 IS CA00 WORK DATA                                00900000
           COPY CWS00039.                                               00910000
      ******* JOBS FILE/TABLE DEFINITIONS                               00920000
           COPY FIOCA00.                                                00930000
           COPY FIOJC01.                                                00940000
      *                                                                 00950000
           EXEC SQL                                                     00960000
                INCLUDE CWS0070B                                        00970000
           END-EXEC.                                                    00980000
      *                                                                 00990000
           EXEC SQL                                                     01000000
               INCLUDE SQLCA                                            01010000
           END-EXEC.                                                    01020000
      *                                                                 01030000
           EXEC SQL                                                     01040000
                INCLUDE TBACCT                                          01050000
           END-EXEC.                                                    01060000
      *                                                                 01070000
           EXEC SQL                                                     01080000
                INCLUDE TBCSTSTS                                        01090000
           END-EXEC.                                                    01100000
      *                                                                 01110000
           EXEC SQL                                                     01120000
               INCLUDE TBEBLINS                                         01130000
           END-EXEC.                                                    01140000
      *                                                                 01150000
           EXEC SQL                                                     01160000
                INCLUDE TBJBPARM                                        01170000
           END-EXEC.                                                    01180000
      *                                                                 01190000
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH           PIC S9(04) COMP.             
           03  WS-CMP-NAME                 PIC X(03).                   
      *                                                                 01240000
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                 01260000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE       THRU 0100-EXIT.                
           PERFORM 1000-PROCESS-RECORDS  THRU 1000-EXIT                 
                   UNTIL NO-MORE-RECORDS.                               
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01350000
       0100-INITIALIZE.                                                 
           MOVE 'N'                      TO WS-END-OF-RUN-FLAG          
                                            WS-BILL-VIEW-SW.            
                                                                        
           DISPLAY 'OPENING FILES'.                                     
                                                                        
           OPEN INPUT FCSBE26-FILE.                                     
           IF NOT FBE26-SUCCESSFUL                                      
              DISPLAY '****************************************'        
              DISPLAY '**   0100-INITIALIZE                  **'        
              DISPLAY '**   ERROR OPENING INPUT FILE         **'        
              DISPLAY '**   FILE STATUS = ' WS-FBE26-STATUS             
              DISPLAY '****************************************'        
              MOVE 12                    TO RETURN-CODE                 
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
           PERFORM 0200-GET-REVENUE-MTH  THRU 0200-EXIT.                
      *                                                                 01530000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01560000
       0200-GET-REVENUE-MTH.                                            
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,15,6))                          
                 INTO :WS-REVENUE-MONTH-JP                              
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
T33185                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01580000
MFA-TR*        SELECT (SUBSTR(PARM_DATA,15,6))                          01590000
MFA-TR*          INTO :WS-REVENUE-MONTH-JP                              01600000
MFA-TR*          FROM CSS_JOB_PARM                                      01610000
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                           01620000
MFA-TR*           AND CMND_CODE    = 'DATE'                             01630000
MFA-TR*           AND COMPANY_NO   = '01'                               01640000
MFA-TR*           AND SEQ_NO       = 20                                 01650000
MFA-TR*           AND STATUS       = 'A'                                01660000
MFA-TR*          WITH UR                                                01661000
MFA-TR*    END-EXEC.                                                    01670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01680000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-DISPLAY-SQLCODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-REVENUE-MONTH-JP TO WS-REV-MONTH-NUM         
               WHEN OTHER                                               
                   DISPLAY '**  ERROR ON 0200-GET-REVENUE-MTH     **'   
                   DISPLAY '**  COULD NOT GET REVENUE MONTH       **'   
                   DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE   
                   PERFORM 9900-ABEND    THRU 9900-EXIT                 
           END-EVALUATE.                                                
      *                                                                 01800000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01830000
      ********************************************************          01840000
      *  PROCESS INPUT RECORD.                               *          01850000
      ********************************************************          01860000
       1000-PROCESS-RECORDS.                                            
           PERFORM 8000-READ-INPUT       THRU 8000-EXIT.                
           IF MORE-RECORDS                                              
              PERFORM 2000-CHECK-FOR-EBILL-CUST THRU 2000-EXIT          
              IF BILL-VIEW                                              
                 PERFORM 3000-POPULATE-EBILL-INSERTS THRU 3000-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01980000
       2000-CHECK-FOR-EBILL-CUST.                                       
           MOVE 'N'                      TO WS-BILL-VIEW-SW.            
           MOVE E-FBE26-ACCOUNT-NO       TO AT-ACCOUNT-NO.              
      *                                                                 02020000
           EXEC SQL                                                     
               SELECT CS.EBILL_REGISTER_IND                             
                     ,AT.BILL_CYCLE                                     
                     ,AT.DATE_BILL_DAY_00                               
                 INTO :CE-EBILL-REGISTER-IND                            
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-DATE-BILL-DAY-00                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_CUST_STATS CS WITH(READUNCOMMITTED)                   
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND CS.CUSTOMER_NO = AT.CUSTOMER_NO                   
                  AND CS.CUSTOMER_TYPE = 'C'                            
T33185                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02030000
MFA-TR*        SELECT CS.EBILL_REGISTER_IND                             02040000
MFA-TR*              ,AT.BILL_CYCLE                                     02041000
MFA-TR*              ,AT.DATE_BILL_DAY_00                               02042000
MFA-TR*          INTO :CE-EBILL-REGISTER-IND                            02050000
MFA-TR*              ,:AT-BILL-CYCLE                                    02051000
MFA-TR*              ,:AT-DATE-BILL-DAY-00                              02052000
MFA-TR*          FROM CSS_ACCOUNT AT                                    02060000
MFA-TR*              ,CSS_CUST_STATS CS                                 02070000
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    02080000
MFA-TR*           AND CS.CUSTOMER_NO = AT.CUSTOMER_NO                   02090000
MFA-TR*           AND CS.CUSTOMER_TYPE = 'C'                            02100000
MFA-TR*          WITH UR                                                02101000
MFA-TR*    END-EXEC.                                                    02110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02120000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-DISPLAY-SQLCODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CE-EBILL-REGISTER-IND TO WS-BILL-VIEW-SW        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '**  PCSCA770:2000 **'                       
                   DISPLAY '**  ERROR READING **'                       
                   DISPLAY '**  ON CSS_CUST_STATS **'                   
                   DISPLAY '**  ACCOUNT NUMBER = ' WS-HOLD-ACCT-NUMBER  
                   DISPLAY '**  SQL ERROR      = ' WS-DISPLAY-SQLCODE   
                   MOVE 'IE'             TO WS-DB2-TABLE-ID             
                   MOVE 'UPDATE'         TO WS-DB2-FUNCTION             
                   MOVE SQLCODE          TO WS-DB2-RETURN-CODE          
                   MOVE '770'            TO WS-DB2-MODULE-ID            
                   MOVE '2000'           TO WS-DB2-PARAGRAPH            
                   MOVE IE-ACCOUNT-NO    TO WS-DB2-KEY-1N               
                   MOVE IE-DATE-BILLED   TO WS-DB2-KEY-2N               
                   MOVE IE-INSERT-FLAGS  TO WS-DB2-KEY-3N               
                   MOVE 12               TO RETURN-CODE                 
                   PERFORM 9900-ABEND    THRU 9900-EXIT                 
           END-EVALUATE.                                                
      *                                                                 02370000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02400000
       3000-POPULATE-EBILL-INSERTS.                                     
           MOVE E-FBE26-ACCOUNT-NO       TO IE-ACCOUNT-NO               
                                            WS-HOLD-ACCT-NUMBER.        
           MOVE WS-REV-MONTH-NUM         TO IE-REVENUE-MONTH.           
           MOVE AT-DATE-BILL-DAY-00      TO IE-DATE-BILLED.             
           MOVE AT-BILL-CYCLE            TO IE-BILL-CYCLE.              
           IF WS-CMP-NAME = 'PNC'                                       
              MOVE '26'                  TO IE-COMPANY-NO               
           ELSE                                                         
              MOVE '01'                  TO IE-COMPANY-NO               
           END-IF.                                                      
           MOVE WS-INSERT-MARK (3)       TO IE-INSERT-FLAGS(1:1).       
           MOVE WS-INSERT-MARK (4)       TO IE-INSERT-FLAGS(2:1).       
           MOVE WS-INSERT-MARK (5)       TO IE-INSERT-FLAGS(3:1).       
           MOVE WS-INSERT-MARK (6)       TO IE-INSERT-FLAGS(4:1).       
           MOVE WS-INSERT-MARK (7)       TO IE-INSERT-FLAGS(5:1).       
                                                                        
           PERFORM 4000-INSERT-EBILL-INS THRU 4000-EXIT.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
              PERFORM 5000-UPDATE-EBILL-INS THRU 5000-EXIT              
           END-IF.                                                      
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02690000
       4000-INSERT-EBILL-INS.                                           
           EXEC SQL                                                     
               INSERT INTO CSS_EBILL_INSERTS                            
                     (ACCOUNT_NO,                                       
                      BILL_CYCLE,                                       
                      COMPANY_NO,                                       
                      DATE_BILLED,                                      
                      INSERT_FLAGS,                                     
                      REVENUE_MONTH)                                    
               VALUES                                                   
                     (:IE-ACCOUNT-NO,                                   
                      :IE-BILL-CYCLE,                                   
                      :IE-COMPANY-NO,                                   
                      IIF(TRY_CONVERT(DATE, :IE-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :IE-DATE-BILLED
              ) <> 0) OR (LEN(:IE-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :IE-DATE-BILLED
              ), CONVERT(DATE, :IE-DATE-BILLED) ),                             
                      :IE-INSERT-FLAGS,                                 
                      :IE-REVENUE-MONTH)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02710000
MFA-TR*        INSERT INTO CSS_EBILL_INSERTS                            02720000
MFA-TR*              (ACCOUNT_NO,                                       02730000
MFA-TR*               BILL_CYCLE,                                       02740000
MFA-TR*               COMPANY_NO,                                       02750000
MFA-TR*               DATE_BILLED,                                      02760000
MFA-TR*               INSERT_FLAGS,                                     02770000
MFA-TR*               REVENUE_MONTH)                                    02780000
MFA-TR*        VALUES                                                   02790000
MFA-TR*              (:IE-ACCOUNT-NO,                                   02800000
MFA-TR*               :IE-BILL-CYCLE,                                   02810000
MFA-TR*               :IE-COMPANY-NO,                                   02820000
MFA-TR*               :IE-DATE-BILLED,                                  02830000
MFA-TR*               :IE-INSERT-FLAGS,                                 02840000
MFA-TR*               :IE-REVENUE-MONTH)                                02850000
MFA-TR*    END-EXEC.                                                    02860000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-DISPLAY-SQLCODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN ALREADY-EXISTS                                      
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '**  PCSCA770:4000 **'                       
                   DISPLAY '**  ERROR INSERTING **'                     
                   DISPLAY '**  INTO CSS_EBILL_INSERTS **'              
                   DISPLAY '**  ACCOUNT NUMBER = ' WS-HOLD-ACCT-NUMBER  
                   DISPLAY '**  SQL ERROR      = ' WS-DISPLAY-SQLCODE   
                   MOVE 'IE'             TO WS-DB2-TABLE-ID             
                   MOVE 'INSERT'         TO WS-DB2-FUNCTION             
                   MOVE SQLCODE          TO WS-DB2-RETURN-CODE          
                   MOVE '770'            TO WS-DB2-MODULE-ID            
                   MOVE '4000'           TO WS-DB2-PARAGRAPH            
                   MOVE IE-ACCOUNT-NO    TO WS-DB2-KEY-1N               
                   MOVE IE-DATE-BILLED   TO WS-DB2-KEY-2N               
                   MOVE IE-INSERT-FLAGS  TO WS-DB2-KEY-3N               
                   MOVE 12               TO RETURN-CODE                 
                   PERFORM 9900-ABEND    THRU 9900-EXIT                 
           END-EVALUATE.                                                
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03130000
       5000-UPDATE-EBILL-INS.                                           
           EXEC SQL                                                     
               UPDATE CSS_EBILL_INSERTS                                 
               SET    BILL_CYCLE        = :IE-BILL-CYCLE,               
                      COMPANY_NO        = :IE-COMPANY-NO,               
                      INSERT_FLAGS      = :IE-INSERT-FLAGS,             
                      REVENUE_MONTH     = :IE-REVENUE-MONTH             
               WHERE  ACCOUNT_NO        = :IE-ACCOUNT-NO                
                 AND  DATE_BILLED       = IIF(TRY_CONVERT(DATE, 
                                                        :IE-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :IE-DATE-BILLED
              ) <> 0) OR (LEN(:IE-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :IE-DATE-BILLED
              ), CONVERT(DATE, :IE-DATE-BILLED) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03150000
MFA-TR*        UPDATE CSS_EBILL_INSERTS                                 03160000
MFA-TR*        SET    BILL_CYCLE        = :IE-BILL-CYCLE,               03170000
MFA-TR*               COMPANY_NO        = :IE-COMPANY-NO,               03180000
MFA-TR*               INSERT_FLAGS      = :IE-INSERT-FLAGS,             03190000
MFA-TR*               REVENUE_MONTH     = :IE-REVENUE-MONTH             03200000
MFA-TR*        WHERE  ACCOUNT_NO        = :IE-ACCOUNT-NO                03210000
MFA-TR*          AND  DATE_BILLED       = :IE-DATE-BILLED               03220000
MFA-TR*    END-EXEC.                                                    03230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-DISPLAY-SQLCODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '**  PCSCA770:5000 **'                       
                   DISPLAY '**  ERROR UPDATING **'                      
                   DISPLAY '**  ON CSS_EBILL_INSERTS **'                
                   DISPLAY '**  ACCOUNT NUMBER = ' WS-HOLD-ACCT-NUMBER  
                   DISPLAY '**  SQL ERROR      = ' WS-DISPLAY-SQLCODE   
                   MOVE 'IE'             TO WS-DB2-TABLE-ID             
                   MOVE 'UPDATE'         TO WS-DB2-FUNCTION             
                   MOVE SQLCODE          TO WS-DB2-RETURN-CODE          
                   MOVE '770'            TO WS-DB2-MODULE-ID            
                   MOVE '5000'           TO WS-DB2-PARAGRAPH            
                   MOVE IE-ACCOUNT-NO    TO WS-DB2-KEY-1N               
                   MOVE IE-DATE-BILLED   TO WS-DB2-KEY-2N               
                   MOVE IE-INSERT-FLAGS  TO WS-DB2-KEY-3N               
                   MOVE 12               TO RETURN-CODE                 
                   PERFORM 9900-ABEND    THRU 9900-EXIT                 
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03510000
      ********************************************************          03520000
      *  READ INPUT RECORD.                                  *          03530000
      ********************************************************          03540000
       8000-READ-INPUT.                                                 
           READ FCSBE26-FILE                                            
               AT END                                                   
                  MOVE WS-Y     TO WS-END-OF-BE26                       
                                   WS-END-OF-RUN-FLAG.                  
                                                                        
           IF FBE26-SUCCESSFUL                                          
           OR END-OF-BE26                                               
              MOVE E-FBE26-DATA TO WS-MISC-BILL-INFO                    
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA770 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING INPUT FILE     **'        
              DISPLAY '**     FILE STATUS = ' WS-FBE26-STATUS           
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03760000
       9000-TERMINATE.                                                  
           CLOSE FCSBE26-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03810000
      ****************************************************************  03820000
      **   9900-   THIS INCLUDES THE DB2 SQL ABEND MODULE           **  03830000
      ****************************************************************  03840000
      *                                                                 03850000
           EXEC SQL                                                     03860000
               INCLUDE CPD09900                                         03870000
           END-EXEC.                                                    03880000
