       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA763.                                        
       DATE-WRITTEN.   OCTOBER 2002.                                    
       DATE-COMPILED.                                                   
      *****************************************************************         
      *              M O D U L E   I N F O R M A T I O N              *         
      *                                                               *         
      *  MODULE NAME:  PCSCA763                                       *         
      *                                                               *         
      *  MODULE DESC:  CREATES A FILE OF VOIDED/CANCELED CHECKS TO    *         
      *                BE SENT TO THE BANKS TO REMOVE THEM FROM THE   *         
      *                POSITIVE PAY FILE                              *         
      *                THIS PROGRAM WILL RUN AFTER THE PCSCA691 RUNS  *         
      *                THE OUTPUT FILE OF PCSCA691 I.E. CHECKS ISSUED *         
      *                AND OUTPUT FILE OF THIS PROGRAM I.E. CHECKS    *         
      *                VOIDED WILL BE MERGED AND SENT TO THE BANK DAILY         
      *                                                               *         
      *                THIS PROGRAMS PROCESSES ALL CHECKS VOIDED SINCE*         
      *                AND FOR WHICH STOP PAYMENT WAS SENT SINCE THE  *         
      *                LAST TIME THIS PROGRAM RAN.                    *         
      *                                                               *         
      *  LANGUAGE   :  COBOL II / DB2                                 *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
      *               M A I N T E N A N C E   L O G                   *         
      *                                                               *         
      * DATE        USERID   DESCRIPTION                              *         
      *---------------------------------------------------------------*         
      * 2002-10-10  SS82048  CML26474 - INITIAL CODING                *         
      * 2003-02-21  SS82048  CML26474 - CHANGES TO PRINT A REPORT OF  *         
      *                                 VOIDED CHECKS                 *         
T29199* 2003-09-03  CB18344  CHANGED WACHOVIA ACCOUNT NUMBER DUE TO   *         
T29199*                      MERGER WITH FIRST UNION.                           
T29872* 2003-11-24  COVANSYS CHANGED THE CURSOR TO AVOID DUPLICATE    *         
T29872*                      ACCOUNTS IN REPORT                       *         
      *                                                               *         
A02034* 6 APR 2010  RF10596  ADD 'WITH UR'                            *         
      *                                                               *         
      *****************************************************************         
      *                   M O D U L E   F L O W                       *         
      *                                                               *         
      *   PARAGRAPH                                                   *         
      *  FROM - THRU     DESCRIPTION                                  *         
      *  -----------------------------------------------------------  *         
      *  0000 - 0999     MAIN CONTROL PATH                            *         
      *  1000 - 1999     INITIALIZATION, PRINTING TITLES, AND         *         
      *                  INITIAL READS                                *         
      *  2000 - 2999     COMMON PROCESSING                            *         
      *  3000 - 3999     GRAND TOTAL PROCESSING                       *         
      *  4000 - 4999     NAME/ADDRESS PROCESSING                      *         
      *  6000 - 6999     REDUCE EMBEDDED SPACES PROCESSING            *         
      *  7000 - 7999     INQUIRY CALLS TO INPUT FILES / DATABASE      *         
      *  9000 - 9999     TERMINATION ROUTINES                         *         
      *                                                               *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *          E N V I R O N M E N T   D I V I S I O N              *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
                                                                        
      *****************************************************************         
      *  C O N F I G U R A T I O N   S E C T I O N                    *         
      *****************************************************************         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
                                                                        
      *****************************************************************         
      *  I N P U T - O U T P U T   S E C T I O N                      *         
      *****************************************************************         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA95.                                                        
           COPY CSSCA96.                                                        
           COPY CSSCA97.                                                        
       COPY CSSPT33.                                                            
      *****************************************************************         
      *                    D A T A   D I V I S I O N                  *         
      *****************************************************************         
       DATA DIVISION.                                                   
                                                                        
      *****************************************************************         
      *  F I L E   S E C T I O N                                      *         
      *****************************************************************         
       FILE SECTION.                                                    
           COPY CFDCA95.                                                        
           COPY FIOCA95.                                                        
           COPY CFDCA96.                                                        
           COPY FIOCA96.                                                        
           COPY CFDCA97.                                                        
           COPY FIOCA97.                                                        
           COPY CFDPT33.                                                        
      *****************************************************************         
      *  W O R K I N G - S T O R A G E   S E C T I O N                *         
      *****************************************************************         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA763'.
MSQ017     COPY MFASQLM.
                                                                        
      *****                                                                     
      *  START OF WORKING STORAGE                                               
      *****                                                                     
       01  WS00-START                         PIC X(40) VALUE           
           'WORKING STORAGE FOR PCSCA763 STARTS HERE'.                  
                                                                        
      *****                                                                     
      *  CONSTANTS AND SWITCHES                                                 
      *****                                                                     
       01  WS01-CONSTANTS-AND-SWITCHES.                                 
           05  WS-CONSTANTS.                                            
               10  WS-PROGRAM-NAME            PIC X(08) VALUE           
                   'PCSCA763'.                                          
               10  WS-REFUND-DATA-STATUS      PIC X(01) VALUE 'Y'.      
                   88 WS-REFUND-NO-DATA       VALUE 'N'.                
                   88 WS-REFUND-DATA          VALUE 'Y'.                
               10  WS-DATA-FOUND-FL           PIC X(01) VALUE SPACES.   
                   88  WS-DATA-FOUND          VALUE 'Y'.                
               10  WS-Y                       PIC X(01) VALUE 'Y'.      
               10  WS-N                       PIC X(01) VALUE 'N'.      
               10  WS-REFUND-STATUS-DT-NULL   PIC S9(4) COMP VALUE  0.  
                   88  REFUND-STATUS-DT-NULL                 VALUE -1.  
               10  WS-DATE-REFUNDED-NULL      PIC S9(4) COMP VALUE  0.  
                   88  DATE-REFUNDED-NULL                    VALUE -1.  
           05  WS-FCA95-STATUS             PIC X(02) VALUE SPACES.      
               88 FCA95-SUCCESSFUL         VALUE '00'.                  
           05  WS-FCA96-STATUS             PIC X(02) VALUE SPACES.      
               88 FCA96-SUCCESSFUL         VALUE '00'.                  
           05  WS-FCA97-STATUS             PIC X(02) VALUE SPACES.      
               88 FCA97-SUCCESSFUL         VALUE '00'.                  
           05  WS-FCSPT33-STATUS           PIC X(02)  VALUE '00'.       
               88 FCSPT33-SUCCESSFUL       VALUE '00'.                  
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88 CSR-DATABASE                       VALUE 1.           
               88 SEB-DATABASE                       VALUE 2.           
           05  WS-ISSUE-DATE               PIC X(06).                   
           05  WS-ISS-DATE-FIRST-UNION     PIC X(08).                   
      *                                                                         
       01  WS-CHECK-NO-HOLD.                                            
           05  WS-FIRST-POS                 PIC 9(01) VALUE 0.          
           05  WS-REST-OF-NUMBER            PIC 9(09) VALUE 0.          
      *                                                                         
       01  WS-ISSUE-HOLD.                                               
           05  WS-ISSUE-YY                  PIC X(02) VALUE SPACES.     
           05  WS-ISSUE-MM                  PIC X(02) VALUE SPACES.     
           05  WS-ISSUE-DD                  PIC X(02) VALUE SPACES.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-TOT-CANCEL-CNT            PIC 9(05) VALUE ZEROS.      
           05  WS-TOT-CANCEL-AMT            PIC 9(10)V99 VALUE ZEROS.   
           05  WS-PAGE-COUNT                PIC 9(03)  VALUE 0.         
           05  WS-LINE-COUNT                PIC 9(03)  VALUE 0.         
           05  WS-DETAIL-CANCELLED.                                     
               10  WS-DET-CAN-CNT       PIC 9(05).                      
               10  WS-DET-CAN-CNT-TOT   PIC 9(05).                      
               10  WS-DET-CAN-AMT       PIC 9(06)V9(02).                
               10  WS-DET-CAN-AMT-TOT   PIC 9(07)V9(02).                
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE +0.       
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
           05  PROGRAM-NAME             PIC X(08) VALUE                 
                   'PCSCA763'.                                          
      *                                                                         
       01  WS-REPORT-LINES.                                             
           05  WS-TITLES.                                               
               10  WS-TITLE1A.                                          
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS-TITLE1A-REPTNAME    PIC X(11) VALUE           
                                              'PCSCA763-01'.            
                   15  FILLER                 PIC X(41) VALUE SPACES.   
                   15  WS-TITLE1A-COMP-NAME   PIC X(26).                
                   15  FILLER                 PIC X(33) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'RUN-DATE: '.                              
                   15  WS-TITLE1A-RUN-DT      PIC X(10).                
      *                                                                         
               10  WS-TITLE2B.                                          
                   15  FILLER                 PIC X(44) VALUE SPACES.   
                   15  FILLER                 PIC X(38) VALUE           
                       'DAILY CHECKS CANCELLED (VOIDED) REPORT'.        
                   15  FILLER                 PIC X(30) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'RUN-TIME: '.                              
                   15  WS-TITLE2B-RUN-TM      PIC X(08).                
      *                                                                         
               10  WS-TITLE2C.                                          
                   15  FILLER                 PIC X(116) VALUE SPACES.  
                   15  FILLER                 PIC X(10)                 
                       VALUE 'PAGE:     '.                              
                   15  WS-TITLE2C-PAGE-NBR    PIC ZZ,ZZ9.               
      *                                                                         
           05  WS-HEADERS.                                              
               10  WS-HEADERS-DETAIL.                                   
                   15  WS-HEADER1-DETAIL.                               
                       20  FILLER             PIC X(08) VALUE SPACES.   
                       20  FILLER             PIC X(05) VALUE           
                           'CHECK'.                                     
                       20  FILLER             PIC X(15) VALUE SPACES.   
                       20  FILLER             PIC X(05) VALUE           
                           'CHECK'.                                     
                       20  FILLER             PIC X(82) VALUE SPACES.   
                       20  FILLER             PIC X(07) VALUE           
                           'ACCOUNT'.                                   
                       20  FILLER             PIC X(10) VALUE SPACES.   
      *                                                                         
                   15  WS-HEADER2-DETAIL.                               
                       20  FILLER             PIC X(08) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'NUMBER'.                                    
                       20  FILLER             PIC X(13) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'AMOUNT'.                                    
                       20  FILLER             PIC X(07) VALUE SPACES.   
                       20  FILLER             PIC X(09) VALUE           
                           'STATUS CD'.                                 
                       20  FILLER             PIC X(05) VALUE SPACES.   
                       20  FILLER             PIC X(09) VALUE           
                           'STATUS DT'.                                 
                       20  FILLER             PIC X(06) VALUE SPACES.   
                       20  FILLER             PIC X(13) VALUE           
                           'CUSTOMER NAME'.                             
                       20  FILLER             PIC X(33) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'NUMBER'.                                    
                       20  FILLER             PIC X(11) VALUE SPACES.   
                                                                        
           05  WS-DETAIL-LINE.                                          
               10  FILLER                     PIC X(04) VALUE SPACES.   
               10  WS-CHECK-NO                PIC ZZZ999999.            
               10  FILLER                     PIC X(06) VALUE SPACES.   
               10  WS-CHECK-AMOUNT            PIC ZZ,ZZZ,ZZZ.99.        
               10  FILLER                     PIC X(07) VALUE SPACES.   
               10  WS-CHECK-STATUS            PIC X(12).                
               10  FILLER                     PIC X(02) VALUE SPACES.   
               10  WS-REFUND-STATUS-DT        PIC X(10).                
               10  FILLER                     PIC X(05) VALUE SPACES.   
               10  WS-CUST-NAME               PIC X(42).                
               10  FILLER                     PIC X(04) VALUE SPACES.   
               10  WS-ACCOUNT-NO              PIC 9999999999999.        
               10  FILLER                     PIC X(05) VALUE SPACES.   
           05  WS-END-DATA-LINE.                                        
               10  FILLER                     PIC X(56) VALUE SPACES.   
               10  FILLER                     PIC X(22)                 
                   VALUE '*** END OF REPORT *** '.                      
               10  FILLER                     PIC X(55) VALUE SPACES.   
           05  WS-BLANK-LINE                  PIC X(133) VALUE SPACES.  
           05  WS-TOTAL-LINES.                                          
               10  WS-CANCEL-LINE-TOTAL.                                
                   15  FILLER                   PIC X(01)  VALUE SPACE. 
                   15  FILLER                   PIC X(56)  VALUE        
                'TOTAL NUMBER OF CANCELLED CHECKS THIS PAGE...........'.
                   15  WS-CANCEL-PAGE-CNT       PIC ZZZ,ZZZ,ZZ9.        
                   15  FILLER                   PIC X(64)  VALUE SPACES.
               10  WS-CANCEL-LINE-AMOUNT.                               
                   15  FILLER                   PIC X(01)  VALUE SPACE. 
                   15  FILLER                   PIC X(53)  VALUE        
                'TOTAL CANCELLED CHECK AMOUNT THIS PAGE...............'.
                   15  WS-CANCEL-PAGE-AMT       PIC $$$,$$$,$$9.99.     
                   15  FILLER                   PIC X(64)  VALUE SPACES.
               10  WS-CANCEL-GRAND-TOTAL.                               
                   15  FILLER                   PIC X(01)  VALUE SPACE. 
                   15  FILLER                   PIC X(56)  VALUE        
                'TOTAL NUMBER OF CANCELLED CHECKS.....................'.
                   15  WS-CANCEL-TOT-CNT        PIC ZZZ,ZZZ,ZZ9.        
                   15  FILLER                   PIC X(64)  VALUE SPACES.
               10  WS-CANCEL-GRAND-AMOUNT.                              
                   15  FILLER                   PIC X(01)  VALUE SPACE. 
                   15  FILLER                   PIC X(53)  VALUE        
                'TOTAL CANCELLED CHECK AMOUNT.........................'.
                   15  WS-CANCEL-TOT-AMT        PIC $$$,$$$,$$9.99.     
                   15  FILLER                   PIC X(64)  VALUE SPACES.
      *****                                                                     
      *  NO-DATA                                                                
      *****                                                                     
           05  WS-NO-DATA-LINE.                                         
               10  FILLER                     PIC X(55) VALUE SPACES.   
               10  FILLER                     PIC X(22) VALUE           
                     '** NO DATA THIS RUN **'.                          
               10  FILLER                     PIC X(55) VALUE SPACES.   
                                                                        
       01  WS-ISSUE-HOLD-FIRST-UNION.                                   
                                                                        
           05  WS-ISSUE-YY-FIRST-UNION      PIC X(04) VALUE SPACES.     
           05  WS-ISSUE-MM-FIRST-UNION      PIC X(02) VALUE SPACES.     
           05  WS-ISSUE-DD-FIRST-UNION      PIC X(02) VALUE SPACES.     
      *                                                                         
      *****                                                                     
      *  DATES, TIMES AND TIMESTAMPS                                            
      *****                                                                     
       01  WS-WORK-AREA.                                                
           05  WS-PGRMNAME                    PIC X(08).                
           05  WS-CURRENT-TIMESTMP            PIC X(26) VALUE SPACES.   
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ERROR HANDLING                                            
      *****                                                                     
       COPY CWS00010.                                                           
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ABEND SWITCH                                              
      *****                                                                     
       COPY CWS09900.                                                           
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR REDUCING EMBEDDED SPACES                           
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00011                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00074                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR JOB PARM INFORMATION                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
                                                                        
       01  WS-INPUT-DATA-R8                                             
           REDEFINES  WS-INPUT-DATA-BREAKDOWN.                          
           05  WS-LAST-PRG-RUN-DT           PIC X(14).                  
               88  LAST-PRG-RUN-DATE                                    
               VALUE 'LAST RUN DATE='.                                  
           05  WS-LAST-PRG-RUN-DATE-TIME    PIC X(26).                  
                                                                        
      *****                                                                     
      *  COPYBOOK FOR DB2/SQL ERROR HANDLING                                    
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00303                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  SQLCA                                                                  
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ACCOUNT                                                            
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *****                                                                     
      *  CSS_DELINQUENCY                                                        
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_REFUND                                                             
      *****                                                                     
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                 00933000
      *****                                                                     
      * CSS_MNT_TRANS_HIST                                              00929000
      *****                                                                     
           EXEC SQL                                                     00930000
              INCLUDE TBMNHIST                                          00931000
           END-EXEC.                                                    00932000
      *                                                                 00933000
      *****                                                             00933000
      * CSS_MT_TRN_HST_DET                                              00929000
      *****                                                             00933000
           EXEC SQL                                                     00930000
              INCLUDE TBMNHDT                                           00931000
           END-EXEC.                                                    00932000
      *****                                                             00933000
      *                                                                         
      *****                                                                     
      *  CSS_JOB_PARM                                                           
      *****                                                                     
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_ACCT_BILL_NMES                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBATBLNM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****                                                                     
      *  CSS_ACCT_MISC_INFO                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ADDR_FORMATTED                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ADDR_FREEFORM                                                      
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      *****                                                                     
      *  CSS_COMPANY                                                            
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_CUST_ADDR_XREF                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_NAME                                                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_NAME_ACCT_XREF                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ZIP_CODE                                                           
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE REFUND-CURSOR CURSOR FOR                        
                SELECT                                                  
T29872*               RN.ACCOUNT_NO,                                            
T29872                DISTINCT(RN.ACCOUNT_NO),                          
                      RN.REFUND_CHECK_NO,                               
                      RN.CHECK_STATUS_CD,                               
                      RN.REFUND_STATUS_DT,                              
                      RN.DATE_REFUNDED,                                 
                      RN.AMT_REFUNDED,                                  
                      AT.COMPANY_NO                                     
                FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                     
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED),              
                      CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)               
               WHERE  RN.CHECK_STATUS_CD IN ('X','S')                   
                 AND  RN.REFUND_CHECK_NO <> '0        '                 
                 AND  RN.REFUND_CHECK_NO <> '000000000'                 
                 AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     
                 AND  AT.ACCOUNT_NO = MH.ACCOUNT_NO                     
                 AND  AT.COMPANY_NO = :AT-COMPANY-NO                    
                 AND  MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )      
                 AND  MH.TRANS_HIST_SEQ_NO >  CIS.CHAR2TIMESTAMP(
                                             :WS-LAST-PRG-RUN-DATE-TIME
              )
                 AND  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO       
                 AND  MH.DATE_TRANS      = RN.REFUND_STATUS_DT          
                 AND  MH.APPL_PROGRAM_ID = 'PANEL270'                   
                 AND  MI.COLUMN_DESC = 'CHECK_STATUS_CD'                
                 AND  MI.CHG_COLUMN_VALUE = RN.CHECK_STATUS_CD          
            ORDER BY  RN.REFUND_CHECK_NO                                
A02034                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE REFUND-CURSOR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*               RN.ACCOUNT_NO,                                            
MFA-TR*               DISTINCT(RN.ACCOUNT_NO),                                  
MFA-TR*               RN.REFUND_CHECK_NO,                                       
MFA-TR*               RN.CHECK_STATUS_CD,                                       
MFA-TR*               RN.REFUND_STATUS_DT,                                      
MFA-TR*               RN.DATE_REFUNDED,                                         
MFA-TR*               RN.AMT_REFUNDED,                                          
MFA-TR*               AT.COMPANY_NO                                             
MFA-TR*         FROM  CSS_REFUND  RN,                                           
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_MNT_TRANS_HIST MH,                                    
MFA-TR*               CSS_MT_TRN_HST_DET MI                             01988000
MFA-TR*        WHERE  RN.CHECK_STATUS_CD IN ('X','S')                           
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '0        '                         
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '000000000'                         
MFA-TR*          AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                             
MFA-TR*          AND  AT.ACCOUNT_NO = MH.ACCOUNT_NO                             
MFA-TR*          AND  AT.COMPANY_NO = :AT-COMPANY-NO                            
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO <= :WS-CURRENT-TIMESTMP              
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >  :WS-LAST-PRG-RUN-DATE-TIME        
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO       02000000
MFA-TR*          AND  MH.DATE_TRANS      = RN.REFUND_STATUS_DT                  
MFA-TR*          AND  MH.APPL_PROGRAM_ID = 'PANEL270'                           
MFA-TR*          AND  MI.COLUMN_DESC = 'CHECK_STATUS_CD'                        
MFA-TR*          AND  MI.CHG_COLUMN_VALUE = RN.CHECK_STATUS_CD                  
MFA-TR*     ORDER BY  RN.REFUND_CHECK_NO                                        
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSCA763 ENDS HERE'.                    
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-PARMVAL                        PIC X(02).             
               88  WS-SCEG                       VALUE '01'.            
               88  WS-PSNC                       VALUE '26'.            
                                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *             P R O C E D U R E   D I V I S I O N               *         
      *****************************************************************         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      *****************************************************************         
      *  0000-MAINLINE                                                *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT.                                           
      *                                                                         
           PERFORM 8600-UPDATE-JOB-PARM THRU 8600-EXIT.                 
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  0100-INITIALIZATION                                          *         
      *                                                               *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-WORK-AREA                                      
                                                                        
           IF  WS-PARMVAL-LENGTH = ZERO                                 
               DISPLAY 'NO PARM VALUE FOUND'                            
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF.                                                      
           MOVE WS-PARMVAL       TO AT-COMPANY-NO                       
           MOVE WS-PROGRAM-NAME  TO WS-PGRMNAME.                        
           MOVE 'DATABASE'                    TO C8-DELINQ-CD           
           MOVE '01'                          TO C8-COMPANY-NO          
           PERFORM 6500-GET-DATABASE          THRU 6500-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-DATABASE            
           IF  SEB-DATABASE                                             
               OPEN OUTPUT FCSCA95-FILE                                 
               IF FCA95-SUCCESSFUL                                      
T29199            MOVE 'REFUND-WACHOVIA-SEB' TO C8-DELINQ-CD            
               ELSE                                                     
                  DISPLAY ' '                                           
                  DISPLAY '**  PCSCA763 PROCESSING ERROR        **'     
                  DISPLAY '**  OPEN ERROR ON FCSCA95 FILE       **'     
                  DISPLAY '**  FILE STATUS = ' WS-FCA95-STATUS          
                  DISPLAY '**  PROCESSING TERMINATED            **'     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           ELSE                                                         
               IF  WS-SCEG                                              
                   OPEN OUTPUT FCSCA96-FILE                             
                   IF FCA96-SUCCESSFUL                                  
T29199                MOVE 'REFUND-WACHOVIA-SCEG' TO C8-DELINQ-CD       
T29199                MOVE '01' TO C8-COMPANY-NO                        
                   ELSE                                                 
                      DISPLAY ' '                                       
                      DISPLAY '**  PCSCA763 PROCESSING ERROR        **' 
                      DISPLAY '**  OPEN ERROR ON FCSCA96 FILE       **' 
                      DISPLAY '**  FILE STATUS = ' WS-FCA96-STATUS      
                      DISPLAY '**  PROCESSING TERMINATED            **' 
                      PERFORM 9900-ABEND THRU 9900-EXIT                 
                   END-IF                                               
               ELSE                                                     
                   OPEN OUTPUT FCSCA97-FILE                             
                   IF FCA97-SUCCESSFUL                                  
T29199                MOVE 'REFUND-WACHOVIA-PSNC' TO C8-DELINQ-CD       
T29199                MOVE '26' TO C8-COMPANY-NO                        
                   ELSE                                                 
                      DISPLAY ' '                                       
                      DISPLAY '**  PCSCA763 PROCESSING ERROR        **' 
                      DISPLAY '**  OPEN ERROR ON FCSCA97 FILE       **' 
                      DISPLAY '**  FILE STATUS = ' WS-FCA97-STATUS      
                      DISPLAY '**  PROCESSING TERMINATED            **' 
                      PERFORM 9900-ABEND THRU 9900-EXIT                 
                   END-IF                                               
               END-IF                                                   
           END-IF                                                       
      *                                                                         
T29199     PERFORM 1500-SELECT-BANK-ACCT-NBR THRU 1500-EXIT.            
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE                                     
      *                                                                         
           IF  FCSPT33-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA763 PROCESSING ERROR        **'        
               DISPLAY '**  OPEN ERROR ON FCSPT33 FILE       **'        
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**  PROCESSING TERMINATED            **'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
      *                                                                         
           MOVE WS-PARMVAL               TO G6-COMPANY-NO               
           MOVE WS-PROGRAM-NAME          TO G6-PROGRAM-NAME             
           PERFORM 7000-SELECT-TIMESTAMP     THRU 7000-EXIT.            
           PERFORM 7700-SELECT-LAST-RUN-DATE THRU 7700-EXIT.            
           IF  SQLCODE EQUAL NOT-FOUND                                  
               DISPLAY '**       PCSCA763 PROCESSING ERROR       **'    
               DISPLAY '**       PARA - 0100-INITIALIZATION      **'    
               DISPLAY '**  NO RECORD AVAILABLE IN JOB PARM FOR  **'    
               DISPLAY '**         LAST PROGRAM RUN DATE         **'    
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           MOVE G6-PARM-DATA TO WS-INPUT-DATA-BREAKDOWN.                
                                                                        
           IF  WS-LAST-PRG-RUN-DATE-TIME NOT < WS-CURRENT-TIMESTMP      
               DISPLAY '**      PCSCA763 PROCESSING ERROR           **' 
               DISPLAY '**      PARA - 0100-INITIALIZATION          **' 
               DISPLAY '**  LAST RUN DATE TIME IS NOT LESS THAN THE **' 
               DISPLAY '**             CURRENT DATE TIME            **' 
               DISPLAY '**         PROCESSING TERMINATED            **' 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARMVAL       TO C7-COMPANY-NO                       
           PERFORM 7010-RETRIEVE-COMP-NAME THRU 7010-EXIT               
           MOVE C7-COMPANY-NAME  TO WS-TITLE1A-COMP-NAME                
                                                                        
           STRING WS-CURRENT-TIMESTMP(6:2) DELIMITED BY SIZE            
                  '/'                   DELIMITED BY SIZE               
                  WS-CURRENT-TIMESTMP(9:2) DELIMITED BY SIZE            
                  '/'                   DELIMITED BY SIZE               
                  WS-CURRENT-TIMESTMP(1:4) DELIMITED BY SIZE            
             INTO WS-TITLE1A-RUN-DT.                                    
                                                                        
           STRING WS-CURRENT-TIMESTMP(12:2) DELIMITED BY SIZE           
                  ':'                   DELIMITED BY SIZE               
                  WS-CURRENT-TIMESTMP(15:2) DELIMITED BY SIZE           
                  ':'                   DELIMITED BY SIZE               
                  WS-CURRENT-TIMESTMP(18:2) DELIMITED BY SIZE           
             INTO WS-TITLE2B-RUN-TM.                                    
                                                                        
           PERFORM 8720-WRITE-CANCEL-TITLES THRU 8720-EXIT              
           PERFORM 7100-OPEN-REFUND-CURSOR THRU 7100-EXIT.              
           PERFORM 7200-FETCH-REFUND-CURSOR THRU 7200-EXIT.             
      *                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF  WS-REFUND-NO-DATA                                        
               MOVE WS-NO-DATA-LINE  TO PRT33-DATA                      
               PERFORM 8710-WRITE-REPORT THRU 8710-EXIT                 
               GO TO 1000-EXIT                                          
           END-IF                                                       
           PERFORM UNTIL WS-REFUND-NO-DATA                              
               MOVE 'Y' TO WS-DATA-FOUND-FL                             
               PERFORM 2000-CREATE-FILES                                
                  THRU 2000-EXIT                                        
               PERFORM 7200-FETCH-REFUND-CURSOR THRU 7200-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7300-CLOSE-REFUND-CURSOR THRU 7300-EXIT.             
           IF  WS-PSNC AND WS-DATA-FOUND                                
               PERFORM 8500-WRITE-RECONCILE-HDR THRU 8500-EXIT          
           END-IF.                                                      
           PERFORM 8730-WRITE-CANCEL-PAGE-TOTALS THRU 8730-EXIT         
           PERFORM 8740-WRITE-CANCEL-GRAND-TOTAL THRU 8740-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
T29199************************************************************              
T29199**  1500-SELECT-BANK-ACCT-NBR.                            **              
T29199**      SELECTS WACHOVIA BANK ACCOUNT NUMBERS FROM        **              
T29199**      CSS_DELINQUENCY.                                  **              
T29199************************************************************              
T29199 1500-SELECT-BANK-ACCT-NBR.                                       
T29199*                                                                         
T29199     EXEC SQL                                                     
T29199         SELECT DESCRIPTION                                       
T29199         INTO  :C8-DESCRIPTION                                    
T29199         FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T29199         WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
T29199         AND    COMPANY_NO = :C8-COMPANY-NO                       
A02034                                                           
T29199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DESCRIPTION                                               
MFA-TR*        INTO  :C8-DESCRIPTION                                            
MFA-TR*        FROM   CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*        AND    COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29199*                                                                         
T29199     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
T29199*                                                                         
T29199     EVALUATE WS-ACTIVE-RETURN-CODE                               
T29199         WHEN SUCCESSFUL-CALL                                     
T29199              CONTINUE                                            
T29199         WHEN OTHER                                               
T29199             DISPLAY '** PCSCA763 PROCESSING ERROR      **'       
T29199             DISPLAY '** ERROR ON SELECT                **'       
T29199             DISPLAY '** PARA 1500-SELECT-BANK-ACCT-NBR **'       
T29199             DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
T29199             DISPLAY '** DELINQ CODE: ' C8-DELINQ-CD              
T29199             DISPLAY '** COMPANY NO: ' C8-COMPANY-NO              
T29199             DISPLAY '** PROCESSING TERMINATED            **'     
T29199             PERFORM 9900-ABEND THRU 9900-EXIT                    
T29199     END-EVALUATE.                                                
T29199*                                                                         
T29199 1500-EXIT.                                                       
T29199     EXIT.                                                        
      *****************************************************************         
      *  2000-CREATE-FILES.                                           *         
      *                                                               *         
      *****************************************************************         
       2000-CREATE-FILES.                                               
                                                                        
           IF  SEB-DATABASE                                             
               PERFORM 8000-CREATE-SEB-FILE THRU 8000-EXIT              
           ELSE                                                         
              IF  AT-COMPANY-NO = '01'                                  
                  PERFORM 8100-CREATE-SCEG-FILE THRU 8100-EXIT          
              ELSE                                                      
                  IF  AT-COMPANY-NO = '26'                              
                      PERFORM 8200-CREATE-PSNC-FILE THRU 8200-EXIT      
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
           ADD RN-AMT-REFUNDED  TO WS-TOT-CANCEL-AMT                    
           ADD 1                TO WS-TOT-CANCEL-CNT.                   
           IF  WS-LINE-COUNT > 56                                       
               PERFORM 8730-WRITE-CANCEL-PAGE-TOTALS THRU 8730-EXIT     
               MOVE ZEROES TO WS-DET-CAN-CNT                            
                              WS-DET-CAN-AMT                            
               PERFORM 8720-WRITE-CANCEL-TITLES THRU 8720-EXIT          
           END-IF                                                       
           MOVE RN-REFUND-CHECK-NO TO WS-CHECK-NO.                      
           MOVE RN-AMT-REFUNDED TO WS-CHECK-AMOUNT.                     
           MOVE RN-ACCOUNT-NO TO WS-ACCOUNT-NO                          
                                 AT-ACCOUNT-NO.                         
           MOVE 'Y' TO WS-NAME-ONLY-SW.                                 
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           MOVE WS-ACCOUNT-NAME TO WS-CUST-NAME.                        
           IF REFUND-STATUS-DT-NULL                                     
              MOVE SPACES TO WS-REFUND-STATUS-DT                        
           ELSE                                                         
              MOVE RN-REFUND-STATUS-DT TO WS-REFUND-STATUS-DT           
           END-IF.                                                      
           IF RN-CHECK-STATUS-CD = 'X'                                  
              MOVE 'VOIDED' TO WS-CHECK-STATUS                          
           ELSE                                                         
              IF RN-CHECK-STATUS-CD = 'S'                               
                 MOVE 'STOP PAYMENT' TO WS-CHECK-STATUS                 
              END-IF                                                    
           END-IF.                                                      
           ADD 1 TO WS-DET-CAN-CNT                                      
                    WS-DET-CAN-CNT-TOT                                  
           ADD RN-AMT-REFUNDED TO WS-DET-CAN-AMT                        
                                  WS-DET-CAN-AMT-TOT                    
           MOVE WS-DETAIL-LINE TO PRT33-DATA                            
           PERFORM 8710-WRITE-REPORT THRU 8710-EXIT.                    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 4000 - 4095                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00074, WHICH RETRIEVES NAMES AND          *         
      *         ADDRESSES                                             *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00074                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 6010 - 6011                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00004, WHICH REDUCES EMBEDDED SPACES      *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00004                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 6500-GET-DATABASE.                                            *         
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
      *****************************************************************         
       6500-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
               AND  COMPANY_NO = :C8-COMPANY-NO                         
A02034                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*        AND  COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE C8-DELINQ-VALUE          TO WS-DATABASE             
           ELSE                                                         
               DISPLAY '**   PCSCA763 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 6500    **'            
               DISPLAY '* RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**     PROCESSING TERMINATED     **'            
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7000-SELECT-TIMESTAMP                                     *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7000-SELECT-TIMESTAMP.                                           
      *                                                                 00691000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET: WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**   PCSCA763 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7000    **'            
               DISPLAY '* RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**     PROCESSING TERMINATED     **'            
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *  7010-RETRIEVE-COMP-NAME                                      *         
      *                                                               *         
      *****************************************************************         
       7010-RETRIEVE-COMP-NAME.                                         
                                                                        
           EXEC SQL                                                     
                SELECT COMPANY_NAME                                     
                  INTO :C7-COMPANY-NAME                                 
                  FROM CSS_COMPANY WITH(READUNCOMMITTED)                        
                 WHERE COMPANY_NO = :C7-COMPANY-NO                      
A02034                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COMPANY_NAME                                             
MFA-TR*           INTO :C7-COMPANY-NAME                                         
MFA-TR*           FROM CSS_COMPANY                                              
MFA-TR*          WHERE COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '***********************************'             
              DISPLAY '**   PCSCA763 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 7010    **'             
              DISPLAY '**  UNABLE TO RETRIEVE COMP NAME **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7100-OPEN-REFUND-CURSOR                                      *         
      *                                                               *         
      *****************************************************************         
       7100-OPEN-REFUND-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN REFUND-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA763 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7100    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7200-FETCH-REFUND-CURSOR                                     *         
      *                                                               *         
      *****************************************************************         
       7200-FETCH-REFUND-CURSOR.                                        
           EXEC SQL                                                     
                FETCH REFUND-CURSOR                                     
                INTO                                                    
                      :RN-ACCOUNT-NO,                                   
                      :RN-REFUND-CHECK-NO,                              
                      :RN-CHECK-STATUS-CD,                              
                      :RN-REFUND-STATUS-DT :WS-REFUND-STATUS-DT-NULL,    
                      :RN-DATE-REFUNDED :WS-DATE-REFUNDED-NULL,          
                      :RN-AMT-REFUNDED,                                 
                      :AT-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-N TO WS-REFUND-DATA-STATUS                     
              ELSE                                                      
                  DISPLAY '***********************************'         
                  DISPLAY '**   PCSCA763 PROCESSING ERROR   **'         
                  DISPLAY '**    ABEND IN PARAGRAPH 7200    **'         
                  DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY '**     PROCESSING TERMINATED     **'         
                  DISPLAY '***********************************'         
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7300-CLOSE-REFUND-CURSOR                                     *         
      *                                                               *         
      *****************************************************************         
       7300-CLOSE-REFUND-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE REFUND-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA763 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7300    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7700-SELECT-LAST-RUN-DATE                                 *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7700-SELECT-LAST-RUN-DATE.                                       
      *                                                                 00691000
           EXEC SQL                                                     
               SELECT PROGRAM_NAME,                                     
                      COMPANY_NO,                                       
                      CMND_CODE,                                        
                      SEQ_NO,                                           
                      STATUS,                                           
                      PARM_DATA                                         
               INTO   :G6-PROGRAM-NAME,                                 
                      :G6-COMPANY-NO,                                   
                      :G6-CMND-CODE,                                    
                      :G6-SEQ-NO,                                       
                      :G6-STATUS,                                       
                      :G6-PARM-DATA                                     
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 1                                   
                 AND STATUS       = 'A'                                 
A02034                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PROGRAM_NAME,                                     05201700
MFA-TR*               COMPANY_NO,                                       05201700
MFA-TR*               CMND_CODE,                                        05201700
MFA-TR*               SEQ_NO,                                           05201700
MFA-TR*               STATUS,                                           05201700
MFA-TR*               PARM_DATA                                         05201700
MFA-TR*        INTO   :G6-PROGRAM-NAME,                                 05201700
MFA-TR*               :G6-COMPANY-NO,                                   05201700
MFA-TR*               :G6-CMND-CODE,                                    05201700
MFA-TR*               :G6-SEQ-NO,                                       05201700
MFA-TR*               :G6-STATUS,                                       05201700
MFA-TR*               :G6-PARM-DATA                                     05201700
MFA-TR*        FROM CSS_JOB_PARM                                        05201800
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    05202000
MFA-TR*          AND COMPANY_NO   = :G6-COMPANY-NO                      05202000
MFA-TR*          AND CMND_CODE    = 'PARM'                              05202000
MFA-TR*          AND SEQ_NO       = 1                                   05202000
MFA-TR*          AND STATUS       = 'A'                                 05202000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    05202600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05202700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '**  PROCESSING ERROR IN PROGRAM PCSCA763  **'   
               DISPLAY '**      PARA - 7700-SELECT-LAST-RUN-DATE  **'   
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               DISPLAY '**         PROCESSING TERMINATED          **'   
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 8000-CREATE-SEB-FILE.                                         *         
      * WRITES VOID CHECKS TO POSPAY FILE WITH VOID CODE AS 'V' FOR   *         
      * SEB RUN.                                                      *         
      *****************************************************************         
       8000-CREATE-SEB-FILE.                                            
           INITIALIZE E-FCA95-OUTPUT-REC.                               
T29199     MOVE C8-DESCRIPTION(3:13)   TO E-FCA95-WACHOVIA-ACCOUNT-NO.  
C29199*    MOVE 0320651581             TO E-FCA95-WACHOVIA-ACCOUNT-NO.          
           MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
           MOVE WS-CHECK-NO-HOLD       TO E-FCA95-CHECK-NO.             
           MOVE RN-AMT-REFUNDED        TO E-FCA95-AMOUNT.               
           MOVE RN-DATE-REFUNDED(3:2)  TO WS-ISSUE-YY.                  
           MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM.                  
           MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD.                  
           MOVE WS-ISSUE-HOLD          TO WS-ISSUE-DATE.                
           MOVE WS-ISSUE-DATE          TO E-FCA95-ISSUE-DATE.           
           MOVE 'V'                    TO E-FCA95-VOID-CODE.            
                                                                        
           WRITE FIOCA95.                                               
                                                                        
           IF FCA95-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ABEND IN 8000-CREATE-SEB-FILE       **'      
              DISPLAY '**  STATUS      = ' WS-FCA95-STATUS              
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8100-CREATE-SCEG-FILE.                                        *         
      * WRITES VOID CHECKS TO POSPAY FILE WITH VOID CODE AS 'V' FOR   *         
      * SCEG RUN.                                                     *         
      *****************************************************************         
       8100-CREATE-SCEG-FILE.                                           
           INITIALIZE E-FCA96-OUTPUT-REC.                               
T29199     MOVE C8-DESCRIPTION(3:13)   TO E-FCA96-WACHOVIA-ACCOUNT-NO.  
C29199*    MOVE 0320261019             TO E-FCA96-WACHOVIA-ACCOUNT-NO.          
           MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
           MOVE WS-CHECK-NO-HOLD       TO E-FCA96-CHECK-NO.             
           MOVE RN-AMT-REFUNDED        TO E-FCA96-AMOUNT.               
           MOVE RN-DATE-REFUNDED(3:2)  TO WS-ISSUE-YY.                  
           MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM.                  
           MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD.                  
           MOVE WS-ISSUE-HOLD          TO WS-ISSUE-DATE.                
           MOVE WS-ISSUE-DATE          TO E-FCA96-ISSUE-DATE.           
           MOVE 'V'                    TO E-FCA96-VOID-CODE.            
                                                                        
           WRITE FIOCA96.                                               
                                                                        
           IF FCA96-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ABEND IN 8100-CREATE-SCEG-FILE       **'     
              DISPLAY '**  STATUS      = ' WS-FCA96-STATUS              
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8200-CREATE-PSNC-FILE.                                        *         
      * WRITES VOID CHECKS TO POSPAY FILE WITH VOID CODE AS 'V' FOR   *         
      * PSNC RUN.                                                     *         
      *****************************************************************         
       8200-CREATE-PSNC-FILE.                                           
           INITIALIZE E-FCA97-OUTPUT-REC.                               
T29199*    MOVE C8-DESCRIPTION(3:13)   TO E-FCA97-WACHOVIA-ACCOUNT-NO.          
C29199     MOVE 2079900098468          TO E-FCA97-WACHOVIA-ACCOUNT-NO.  
           MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
           MOVE WS-CHECK-NO-HOLD       TO E-FCA97-CHECK-NO.             
           MOVE WS-CHECK-NO-HOLD       TO E-FCA97-CHECK-NO.             
           MOVE RN-AMT-REFUNDED        TO E-FCA97-AMOUNT.               
           MOVE RN-DATE-REFUNDED(1:4)  TO WS-ISSUE-YY-FIRST-UNION.      
           MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM-FIRST-UNION.      
           MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD-FIRST-UNION.      
           MOVE WS-ISSUE-HOLD-FIRST-UNION TO WS-ISS-DATE-FIRST-UNION.   
           MOVE WS-ISS-DATE-FIRST-UNION TO E-FCA97-ISSUE-DATE.          
                                                                        
           MOVE 'V'                    TO E-FCA97-VOID-CODE.            
                                                                        
           WRITE FIOCA97.                                               
                                                                        
           IF FCA97-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ABEND IN 8200-CREATE-PSNC-FILE       **'     
              DISPLAY '**  STATUS      = ' WS-FCA97-STATUS              
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      ** WRITES RECONCILIATION HEADER FOR FIRST UNION POSITIVE  **              
      ** PAY FILE.                                              **              
      **                                                        **              
      *                                                                         
      ************************************************************              
       8500-WRITE-RECONCILE-HDR.                                        
                                                                        
           MOVE 'RECONCILIATIONHEADER' TO E-FCA97-RECONCILE-HDR.        
           MOVE 0001 TO E-FCA97-BANK-NO.                                
T29199     MOVE 2079900098468 TO E-FCA97-BANK-ACCOUNT-NO.               
T29199*    MOVE E-FCA97-WACHOVIA-ACCOUNT-NO TO E-FCA97-BANK-ACCOUNT-NO.         
           MOVE WS-TOT-CANCEL-AMT      TO E-FCA97-TOTAL-AMOUNT.         
           MOVE WS-TOT-CANCEL-CNT      TO E-FCA97-TOTAL-ITEM-COUNT.     
           WRITE FIOCA97-HEADER-REC.                                    
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8600-UPDATE-JOB-PARM                                          *         
      *     UPDATES CURRENT DATE IN JOB PARM TO HAVE THE DATE THE     *         
      *     PROGRAM HAS RUN SO IT IS AVAILABLE FOR THE NEXT RUN.      *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8600-UPDATE-JOB-PARM.                                            
      *                                                                         
           MOVE WS-PARMVAL               TO G6-COMPANY-NO               
           MOVE WS-PROGRAM-NAME          TO G6-PROGRAM-NAME             
           MOVE WS-CURRENT-TIMESTMP      TO WS-LAST-PRG-RUN-DATE-TIME   
           MOVE WS-INPUT-DATA-R8         TO G6-PARM-DATA.               
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                SET PARM_DATA      = :G6-PARM-DATA                      
                WHERE COMPANY_NO   = :G6-COMPANY-NO                     
                  AND PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = 'PARM'                             
                  AND SEQ_NO       = 1                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  SQLCODE = SUCCESSFUL-CALL                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PROCESSING ERROR IN PROGRAM PCSCA763  **'   
               DISPLAY '**      PARA - 8600-UPDATE-JOB-PARM       **'   
               DISPLAY '**   ERROR DURING UPDATE OF CSS_JOB_PARM  **'   
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      ** 8710-WRITE-REPORT                                        **            
      **    WRITES RECORD INTO REPORT FILE                        **            
      **************************************************************            
       8710-WRITE-REPORT.                                               
      *                                                                         
           MOVE '8710'                      TO WS-ACTIVE-PARAGRAPH.     
      *                                                                         
           WRITE PRT33-RECORD.                                          
           IF FCSPT33-SUCCESSFUL                                        
              ADD 1                         TO WS-LINE-COUNT            
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PROGRAM PCSCA763  **'    
              DISPLAY '**  ABEND IN 8710-WRITE-REPORT        **'        
              DISPLAY '**  STATUS = ' WS-FCSPT33-STATUS                 
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  8720-WRITE-CANCEL-TITLES                                     *         
      *                                                               *         
      *****************************************************************         
       8720-WRITE-CANCEL-TITLES.                                        
                                                                        
           ADD 1 TO WS-PAGE-COUNT.                                      
                                                                        
           MOVE WS-PAGE-COUNT TO WS-TITLE2C-PAGE-NBR.                   
                                                                        
           WRITE PRT33-RECORD   FROM WS-TITLE1A                         
                 AFTER ADVANCING PAGE.                                  
           MOVE WS-TITLE2B       TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-TITLE2C       TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-BLANK-LINE    TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-HEADER1-DETAIL TO PRT33-RECORD                       
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-HEADER2-DETAIL TO PRT33-RECORD                       
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-BLANK-LINE    TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE 7 TO WS-LINE-COUNT.                                     
                                                                        
       8720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  8730-WRITE-CANCEL-PAGE-TOTALS.                               *         
      *                                                               *         
      *****************************************************************         
       8730-WRITE-CANCEL-PAGE-TOTALS.                                   
                                                                        
           MOVE WS-DET-CAN-CNT        TO WS-CANCEL-PAGE-CNT.            
           MOVE WS-DET-CAN-AMT        TO WS-CANCEL-PAGE-AMT.            
           MOVE WS-BLANK-LINE         TO PRT33-RECORD                   
           PERFORM 8710-WRITE-REPORT  THRU 8710-EXIT.                   
           MOVE WS-CANCEL-LINE-TOTAL  TO PRT33-RECORD                   
           PERFORM 8710-WRITE-REPORT  THRU 8710-EXIT.                   
           MOVE WS-CANCEL-LINE-AMOUNT TO PRT33-RECORD                   
           PERFORM 8710-WRITE-REPORT  THRU 8710-EXIT.                   
                                                                        
                                                                        
       8730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  8740-WRITE-CANCEL-GRAND-TOTAL                                *         
      *                                                               *         
      *****************************************************************         
       8740-WRITE-CANCEL-GRAND-TOTAL.                                   
                                                                        
           ADD 1 TO WS-PAGE-COUNT.                                      
                                                                        
           MOVE WS-PAGE-COUNT    TO WS-TITLE2C-PAGE-NBR                 
           WRITE PRT33-RECORD   FROM WS-TITLE1A                         
                 AFTER ADVANCING PAGE.                                  
           MOVE WS-TITLE2B       TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-TITLE2C       TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-BLANK-LINE    TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-BLANK-LINE    TO PRT33-RECORD                        
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-DET-CAN-CNT-TOT TO WS-CANCEL-TOT-CNT.                
           MOVE WS-DET-CAN-AMT-TOT TO WS-CANCEL-TOT-AMT.                
           MOVE WS-CANCEL-GRAND-TOTAL  TO PRT33-RECORD                  
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
           MOVE WS-CANCEL-GRAND-AMOUNT TO PRT33-RECORD                  
           PERFORM 8710-WRITE-REPORT        THRU 8710-EXIT.             
                                                                        
       8740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  9000-TERMINATE                                               *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) CLOSES THE INPUT AND OUTPUT FILES                     *         
      *                                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           IF  SEB-DATABASE                                             
               CLOSE FCSCA95-FILE                                       
           ELSE                                                         
              IF  WS-SCEG                                               
                  CLOSE FCSCA96-FILE                                    
              ELSE                                                      
                  CLOSE FCSCA97-FILE                                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  9700-PROCESS-ABEND                                           *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) PROVIDES ABEND LOGIC FOR NAME/ADDRESS ROUTINE         *         
      *                                                               *         
      *****************************************************************         
       COPY CPD0023B.                                                           
                                                                        
      *****************************************************************         
      *  9900-ABEND                                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          *         
      *         PROCESSING PARAGRAPH                                  *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
                                                                        
