       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA749.                                      
COB303 DATE-WRITTEN.     OCT 15, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--SORT ACH FILE BASED ON COMPANY ID.                          --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  10/15/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT018*--                            CSR749 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      ******************************************************************        
      * CSSPT749- SELECT STATEMENT FOR A 94 VARIABLE INPUT FILE        *        
      ******************************************************************        
           SELECT FCSPT749-FILE                                         
               ASSIGN UT-S-ACHIN                                        
               FILE STATUS IS WS-FCS749-STATUS.                         
      *                                                                         
      ******************************************************************        
      * CSSPT749- SELECT STATEMENT FOR A 94 VARIABLE INPUT FILE        *        
      ******************************************************************        
           SELECT FCSPTFL1-FILE                                         
               ASSIGN UT-S-SCEGACH.                                     
      *                                                                         
      ******************************************************************        
      * CSSPT749- SELECT STATEMENT FOR A 94 VARIABLE INPUT FILE        *        
      ******************************************************************        
           SELECT FCSPTFL2-FILE                                         
               ASSIGN UT-S-SEBACH.                                      
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      ** CFDPT749- FILE DESCRIPTION FOR THE FILE FIOPT749          **           
      ***************************************************************           
       FD  FCSPT749-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIOPT749 - FILE LAYOUT FOR PCSCA749                            *        
      ******************************************************************        
      *                                                                         
       01 FIOPT749.                                                     
          05 PT749-REC.                                                 
            10 FILE-CD                       PIC X(01).                 
            10 FILE-DATA-01                  PIC X(39).                 
            10 FILE-COMP-ID                  PIC X(10).                 
            10 FILE-DATA-02                  PIC X(44).                 
      *                                                                         
      ***************************************************************           
       FD  FCSPTFL1-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIOPT749 - FILE LAYOUT FOR PCSCA749                            *        
      ******************************************************************        
      *                                                                         
       01 FIOPTFL1.                                                     
          05 PTFL1-REC                       PIC X(94).                 
      *                                                                         
       FD  FCSPTFL2-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
       01 FIOPTFL2.                                                     
          05 PTFL2-REC                       PIC X(94).                 
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA749'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-START                     PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA749 STARTS HERE'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-SCEG-COMP-ID           PIC X(10) VALUE '2086040100'.   
           05 WS-SEB-COMP-ID            PIC X(10) VALUE '2086040200'.   
           05 WS-SCEG-COMP-SW           PIC X(01) VALUE 'N'.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCS749-STATUS         PIC X(02) VALUE '00'.           
               88 FCS749-SUCCESSFUL               VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 9000-TERMINATE            THRU  9000-EXIT.           
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT  FCSPT749-FILE.                                   
           OPEN OUTPUT FCSPTFL1-FILE.                                   
           OPEN OUTPUT FCSPTFL2-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-READ-FCSPT749        THRU 7000-EXIT.            
           PERFORM 2000-PROCESS-DTLS         THRU 2000-EXIT             
             UNTIL END-OF-REC.                                          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS                                            **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           MOVE SPACES                      TO PTFL1-REC                
                                             PTFL2-REC.                 
           EVALUATE FILE-CD                                             
               WHEN '1'                                                 
                    MOVE PT749-REC           TO PTFL1-REC               
                    PERFORM 8000-WRITE-SCEG     THRU 8000-EXIT          
               WHEN '5'                                                 
                 IF FILE-COMP-ID EQUAL WS-SCEG-COMP-ID                  
                    MOVE PT749-REC           TO PTFL1-REC               
                    PERFORM 8000-WRITE-SCEG     THRU 8000-EXIT          
                    MOVE WS-YES              TO WS-SCEG-COMP-SW         
                 ELSE                                                   
                    MOVE PT749-REC           TO PTFL2-REC               
                    PERFORM 8100-WRITE-SEB      THRU 8100-EXIT          
                    MOVE WS-NO               TO WS-SCEG-COMP-SW         
                 END-IF                                                 
               WHEN '9'                                                 
                    MOVE PT749-REC           TO PTFL2-REC               
                    PERFORM 8100-WRITE-SEB      THRU 8100-EXIT          
               WHEN OTHER                                               
                 IF WS-SCEG-COMP-SW EQUAL WS-YES                        
                    MOVE PT749-REC           TO PTFL1-REC               
                    PERFORM 8000-WRITE-SCEG     THRU 8000-EXIT          
                 ELSE                                                   
                    MOVE PT749-REC           TO PTFL2-REC               
                    PERFORM 8100-WRITE-SEB      THRU 8100-EXIT          
                 END-IF                                                 
           END-EVALUATE.                                                
           PERFORM 7000-READ-FCSPT749           THRU 7000-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSPT749 FILE FOR INPUT                                  *        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSPT749.                                              
      *                                                                         
           READ FCSPT749-FILE.                                          
                                                                        
           IF FCS749-SUCCESSFUL  OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSCA749 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSPT749 FILE ***'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCS749-STATUS            
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-SCEG.                                             **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-SCEG.                                                 
      *                                                                         
           WRITE FIOPTFL1.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-SEB                                               **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-SEB.                                                  
      *                                                                         
           WRITE FIOPTFL2.                                              
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT749-FILE.                                         
           CLOSE FCSPTFL1-FILE.                                         
           CLOSE FCSPTFL2-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
