       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA716.                                        
      ***************************************************************** 00000300
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00000400
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      **  READ THE FILE OF EXCEPTION BILL RECORDS IN DIALOG FORMAT   **         
      **  AND LOAD THEM TO A TABLE SO THAT THEY CAN BE EXTRACTED     **         
      **  IF THEY HAVE BEEN OKAYED FOR PRINTING.                     **         
      *****************************************************************         
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
                                                                        
           SELECT FCSCA716 ASSIGN TO UT-S-FCSCA716.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** CA716 IS THE INPUT FILE THAT WILL HAVE ACCOUNTS TO INSERT     00018100
       FD  FCSCA716                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  EXCP-DETAIL                     PIC X(1230).                 
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA716'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-RETURN-CODE              PIC S9(4)  COMP.             
           05  RS-RETURN-CODE-DISP         PIC ZZZZ9-.                  
           05  RS-RETURN-CODE              PIC S9(4)  COMP.             
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-RESTART                  PIC X.                       
               88  THIS-IS-A-RESTART                 VALUE 'Y'.         
           05  WS-END-OF-FILE              PIC X.                       
               88  END-OF-CA716                      VALUE 'Y'.         
           05  WS-PROGRAM-NAME             PIC X(10) VALUE 'PCSCA716'.  
           05  WS-COUNTER                  PIC 9(06) VALUE ZERO.        
           05  FILLER REDEFINES WS-COUNTER.                             
               10  WS-COMMIT-NBR           PIC 9(5).                    
               10  WS-CNTR-TEST            PIC 9(1).                    
           EXEC SQL                                                     00022800
               INCLUDE FIOCA716                                                 
           END-EXEC.                                                            
      * COPYBOOK ADDED SQL ERROR HANDLING                                       
       COPY CWS00010.                                                   01506000
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                   01506000
      * FIELDS FOR SQL/DB2 ERROR CHECKING                                       
       COPY CWS00303.                                                   01505000
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
           EXEC SQL                                                     
               DECLARE EXCP_BILL_DETAILS CURSOR WITH HOLD FOR           
                  SELECT  DATE_BILLED                                   
                         ,ACCOUNT_NO                                    
                         ,BILL_IMAGE_SEQ                                
                    FROM CSS_EXCP_BILL_DET                              
                   WHERE STATUS    = 'D'                                
                   ORDER BY DATE_BILLED,                                
                            ACCOUNT_NO                                  
           END-EXEC.                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           OPEN INPUT FCSCA716.                                         
           PERFORM 7100-CHECK-FOR-RESTART   THRU 7100-EXIT.             
           PERFORM 7000-READ-FCSCA716       THRU 7000-EXIT.             
           PERFORM 2000-PROCESS-ACCOUNTS    THRU 2000-EXIT              
             UNTIL END-OF-CA716.                                        
           IF WS-COUNTER > 0 AND WS-CNTR-TEST NOT = 0                   
               ADD +1                       TO   WS-COMMIT-NBR          
           END-IF.                                                      
           PERFORM 8100-ISSUE-COMMIT        THRU 8100-EXIT.             
           PERFORM 3000-PURGE-PROCESSED-BILLS.                          
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 00128700
      * READS THE DATA FROM INPUT FILE AND LOADS TO CSS_EXCP_BILL_DET** 00128400
      ***************************************************************** 00128700
                                                                        
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
           MOVE E-EXCP-DET-ACCOUNT-NO       TO WS-ACCOUNT-NO.           
           IF E-EXCP-DET-RECORD-TYPE = 'ACCOUNTREC'                     
               IF WS-COUNTER > 0 AND WS-CNTR-TEST = 0                   
                   DISPLAY 'COMMIT #' WS-COMMIT-NBR                     
                   PERFORM 8100-ISSUE-COMMIT    THRU 8100-EXIT          
               END-IF                                                   
               COMPUTE WS-COUNTER = WS-COUNTER + 1                      
           END-IF.                                                      
           PERFORM 8000-INSERT-EXCP-DETAILS THRU 8000-EXIT.             
           PERFORM 7000-READ-FCSCA716       THRU 7000-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      * PURGE ACCOUNTS THAT HAVE ALREADY BEEN PROCESSED, MARKED WITH ** 00128400
      * STATUS = 'D'                                                 ** 00128400
      ***************************************************************** 00128700
                                                                        
       3000-PURGE-PROCESSED-BILLS.                                      
           DISPLAY 'PURGING PROCESSED BILL DETAILS'.                    
           MOVE 0             TO WS-COUNTER.                            
                                                                        
           PERFORM 7200-OPEN-EXCP-DETAILS    THRU 7200-EXIT.            
           PERFORM 7300-FETCH-EXCP-DETAILS   THRU 7300-EXIT.            
           PERFORM UNTIL SQLCODE  = NOT-FOUND                           
               PERFORM 7500-DELETE-EXCP-DETAILS THRU 7500-EXIT          
               ADD +1         TO WS-COUNTER                             
               IF WS-CNTR-TEST = 0                                      
                  DISPLAY 'COMMIT  #' WS-COMMIT-NBR                     
                  PERFORM 8100-ISSUE-COMMIT    THRU 8100-EXIT           
               END-IF                                                   
               PERFORM 7300-FETCH-EXCP-DETAILS   THRU 7300-EXIT         
           END-PERFORM                                                  
           COMPUTE WS-COUNTER = WS-COUNTER + 1.                         
                                                                        
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00122600
      ** 7000-READ-FCSCA716.                                        **  00122700
      ** READ THE INPUT FILE FCSCA716.                              **  00122800
      ****************************************************************  00123100
       7000-READ-FCSCA716.                                              
                                                                        
           READ FCSCA716 INTO EXCP-DETAIL-REC                           
                AT END                                                  
                    MOVE 'Y'                   TO WS-END-OF-FILE.       
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
       7100-CHECK-FOR-RESTART.                                          
           EXEC SQL                                                     
               SELECT 'Y'                                               
                   INTO  :WS-RESTART                                    
                   FROM  CSS_JOB_PARM                                   
                   WHERE PROGRAM_NAME = :WS-PROGRAM-NAME AND            
                       STATUS       = 'A'              AND              
                       PARM_DATA    = 'RESTART-REQ=Y'                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE TRUE                                                
               WHEN SQLCODE = SUCCESSFUL-CALL                           
                   MOVE 'Y' TO WS-RESTART                               
               WHEN SQLCODE = NOT-FOUND                                 
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 12                   TO WS-RETURN-CODE          
                   MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE-DISP     
                   DISPLAY '7100-CHECK-FOR-RESTART SQLCODE = '          
                           SQLCODE                                      
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-EVALUATE.                                                
       7100-EXIT.                                                       
           EXIT.                                                        
       7200-OPEN-EXCP-DETAILS.                                          
           EXEC SQL                                                     
               OPEN EXCP_BILL_DETAILS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
                   MOVE 12                   TO WS-RETURN-CODE          
                   MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE-DISP     
                   DISPLAY '7200-OPEN-EXCP-DETAILS SQLCODE = '          
                           SQLCODE                                      
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
       7300-FETCH-EXCP-DETAILS.                                         
           EXEC SQL                                                     
               FETCH EXCP_BILL_DETAILS                                  
               INTO   :E-EXCP-DET-BILL-DATE,                            
                      :WS-ACCOUNT-NO,                                   
                      :E-EXCP-DET-SUB-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
                   MOVE 12                   TO WS-RETURN-CODE          
                   MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE-DISP     
                   DISPLAY '7300-FETCH-EXCP-DETAILS SQLCODE = '         
                           SQLCODE                                      
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
       7400-CLOSE-EXCP-DETAILS.                                         
           EXEC SQL                                                     
               CLOSE EXCP_BILL_DETAILS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
                   MOVE 12                   TO WS-RETURN-CODE          
                   MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE-DISP     
                   DISPLAY '7400-CLOSE-EXCP-DETAILS SQLCODE = '         
                           SQLCODE                                      
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-DELETE-EXCP-DETAILS.                                        
           EXEC SQL DELETE                                              
               FROM  CSS_EXCP_BILL_DET                                  
                    WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO        AND    
                          DATE_BILLED    = IIF(TRY_CONVERT(DATE, 
                                                  :E-EXCP-DET-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :E-EXCP-DET-BILL-DATE
              ) <> 0) OR (LEN(:E-EXCP-DET-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:E-EXCP-DET-BILL-DATE
              ), CONVERT(DATE, :E-EXCP-DET-BILL-DATE) ) AND    
                          BILL_IMAGE_SEQ = :E-EXCP-DET-SUB-SEQ-NO       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DELETE                                                      
MFA-TR*        FROM  CSS_EXCP_BILL_DET                                          
MFA-TR*             WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO        AND            
MFA-TR*                   DATE_BILLED    = :E-EXCP-DET-BILL-DATE AND            
MFA-TR*                   BILL_IMAGE_SEQ = :E-EXCP-DET-SUB-SEQ-NO               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE =  SUCCESSFUL-CALL                                
               DISPLAY WS-ACCOUNT-NO    ' ' E-EXCP-DET-BILL-DATE ' '    
                  E-EXCP-DET-SUB-SEQ-NO ' WAS DELETED'                  
           ELSE                                                         
               MOVE 12                   TO WS-RETURN-CODE              
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE-DISP         
               DISPLAY '7500-DELETE-EXCP-DETAILS SQLCODE = '            
                       SQLCODE                                          
               DISPLAY 'KEY = ' WS-ACCOUNT-NO ' '                       
                       E-EXCP-DET-BILL-DATE   ' '                       
                       E-EXCP-DET-SUB-SEQ-NO                            
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-EXCP-DETAILS                                       *        
      *    INSERT ROW IN THE CSS_EXCP_BILL_DET TABLE                   *        
      ******************************************************************        
       8000-INSERT-EXCP-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EXCP_BILL_DET                             
                    ( DATE_BILLED                                       
                    , ACCOUNT_NO                                        
                    , BILL_IMAGE_SEQ                                    
                    , ACCOUNT_SEQ_NO                                    
                    , BILL_IMAGE)                                       
             VALUES  (IIF(TRY_CONVERT(DATE, :E-EXCP-DET-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :E-EXCP-DET-BILL-DATE
              ) <> 0) OR (LEN(:E-EXCP-DET-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:E-EXCP-DET-BILL-DATE
              ), CONVERT(DATE, :E-EXCP-DET-BILL-DATE) )                        
                    , :WS-ACCOUNT-NO                                    
                    , :E-EXCP-DET-SUB-SEQ-NO                            
                    , :E-EXCP-DET-SEQ-NO                                
                    , :E-EXCP-DET-BE28-DATA)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EXCP_BILL_DET                                     
MFA-TR*             ( DATE_BILLED                                               
MFA-TR*             , ACCOUNT_NO                                                
MFA-TR*             , BILL_IMAGE_SEQ                                            
MFA-TR*             , ACCOUNT_SEQ_NO                                            
MFA-TR*             , BILL_IMAGE)                                               
MFA-TR*      VALUES  (:E-EXCP-DET-BILL-DATE                                     
MFA-TR*             , :WS-ACCOUNT-NO                                            
MFA-TR*             , :E-EXCP-DET-SUB-SEQ-NO                                    
MFA-TR*             , :E-EXCP-DET-SEQ-NO                                        
MFA-TR*             , :E-EXCP-DET-BE28-DATA)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE-DISP     
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL            
                   IF E-EXCP-DET-RECORD-TYPE = 'ACCOUNTREC'             
                      DISPLAY WS-ACCOUNT-NO ' ' E-EXCP-DET-BILL-DATE ' '
                              E-EXCP-DET-SUB-SEQ-NO ' WAS ADDED'        
                   END-IF                                               
               WHEN WS-ACTIVE-RETURN-CODE =  ALREADY-EXISTS             
                   IF THIS-IS-A-RESTART                                 
                       MOVE 4                    TO WS-RETURN-CODE      
                       DISPLAY E-EXCP-DET-BILL-DATE   ' '               
                           E-EXCP-DET-ACCOUNT-NO  ' '                   
                           E-EXCP-DET-SEQ-NO      ' '                   
                           E-EXCP-DET-SUB-SEQ-NO                        
                           ' WAS ALREADY ON TABLE - NOT ADDED'          
                   END-IF                                               
               WHEN OTHER                                               
                   DISPLAY 'SQLCODE ' RS-RETURN-CODE-DISP               
                   MOVE 12                        TO WS-RETURN-CODE     
                   DISPLAY E-EXCP-DET-BILL-DATE   ' '                   
                           E-EXCP-DET-ACCOUNT-NO  ' '                   
                           E-EXCP-DET-SEQ-NO      ' '                   
                           E-EXCP-DET-SUB-SEQ-NO                        
                       ' NOT ADDED - SQLCODE = ' RS-RETURN-CODE-DISP    
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
      *                                                                         
      ****************************************************************  04850000
      **  8100-ISSUE-COMMIT.                                        **          
      **      GET COMMIT AFTER EVERY 100 RECORDS UPDATED            **  04880000
      ****************************************************************  04900000
      *                                                                         
       8100-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE-DISP.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'SQLCODE ' RS-RETURN-CODE-DISP                    
              MOVE 12                        TO RETURN-CODE             
              DISPLAY '*******************************************'     
              DISPLAY ' ERROR IN PCSCA716 8100-ISSUE-COMMIT       '     
              DISPLAY ' RETURN CODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXIT.                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA716.                                              
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
