       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA715.                                        
      ***************************************************************** 00000300
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00000400
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      **  READ THE EXCEPTION BILLS THAT HAVE BEEN REFORMATTED FOR    **         
      **  ONLINE BILL VIEW.  ADD THE NEW EXCEPTION BILLS TO THE      **         
      **  DATABASE, TAKING A CHECKPOINT EVERY 1000 ROWS.  FOR EVERY  **         
      **  COMMIT, DISPLAY THE ACCOUNT NUMBER OF WHERE TEH RERUN IS TO**         
      **  BEGIN, IF NECESSARY.                                       **         
      *****************************************************************         
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
A03289**   05/11    SV        INITIAL VERSION.                       ** 00016220
A03462**   07/11    SDHAL     ADD USERID WHO REQUESTED BILL TO PULL. **         
ACT175**   05/15    BD09555   SPACE OUT BINARY VALUES IN BILL_IMAGE. **         
      **A05460-ACT175                                                **         
ACT175**   05/24    BD09555   MOVE READ TO PREVENT PROCESSING TRASH  **         
      **A05460-ACT175         AT END OF FILE                         **         
      ***************************************************************** 00016300
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00016400
      **                                                             ** 00016500
      **  0000         MODULE CONTROL                                ** 00016600
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00016700
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00016800
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016900
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00017100
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00017200
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00017300
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** CA715 IS THE INPUT FILE THAT WILL HAVE ACCOUNTS TO INSERT     00018100
       COPY CSSCA715.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** CA715 IS THE INPUT FILE THAT WILL HAVE ACCOUNTS TO INSERT     00018100
       COPY CFDCA715.                                                           
       COPY FIOCA715.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA715'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO               PIC 9(13).                   
           05  WS-HOLD-NOOPS-DATA          PIC X(430) VALUE SPACES.     
           05  FILLER REDEFINES WS-HOLD-NOOPS-DATA.                     
               10 WS-HOLD-NOOPS-SEQ        PIC X(6).                    
               10 WS-HOLD-NOOPS            PIC X(424).                  
           05  WS-ERROR-COUNT              PIC 9(04).                   
           05  WS-DATE-BILLED              PIC X(10) VALUE '    -  -  '.
           05  FILLER REDEFINES WS-DATE-BILLED.                         
               10  WS-DATE-BILL-CC         PIC X(2).                    
               10  WS-DATE-BILL-YY         PIC X(2).                    
               10  WS-DASH-1               PIC X(01).                   
               10  WS-DATE-BILL-MM         PIC X(2).                    
               10  WS-DASH-2               PIC X(01).                   
               10  WS-DATE-BILL-DD         PIC X(2).                    
           05  WS-NOOP-DATE-BILLED         PIC X(10).                   
           05  FILLER REDEFINES WS-NOOP-DATE-BILLED.                    
               10  WS-NOOP-DATE-MM         PIC X(2).                    
               10  FILLER                  PIC X(01).                   
               10  WS-NOOP-DATE-DD         PIC X(2).                    
               10  FILLER                  PIC X(01).                   
               10  WS-NOOP-DATE-CC         PIC X(2).                    
               10  WS-NOOP-DATE-YY         PIC X(2).                    
           05  WS-RECORDS-READ             PIC 9(09) VALUE ZERO.        
           05  WS-COMPANY-NO               PIC X(02).                   
A03462     05  WS-PULL-USERID              PIC X(07).                   
A03462     05  WS-1MNTH-PRIOR              PIC X(10) VALUE SPACES.      
           05  WS-COUNTER                  PIC 9(07) VALUE ZERO.        
           05  FILLER REDEFINES WS-COUNTER.                             
               10  WS-CHECK-POINT          PIC 9(4).                    
               10  WS-CNTR-TEST            PIC 9(3).                    
                                                                        
       01  WS-NOOPS-SEQ-STRUCTURE.                                      
           05  WS-NOOP-SEQ-1               PIC S9(08) COMP.             
           05  WS-NOOP-SEQ-2               PIC S9(04) COMP.             
       01  WS-NOOPS-STRUCTURE.                                          
           05  WS-NOOP-IDX                 PIC X(06) VALUE SPACES.      
               88  NOOP-RECORD                       VALUE 'IDX@@@'.    
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-DATE           PIC X(10) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-CORRES-TYPE         PIC X(04) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-CUST-NO             PIC X(10) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-ACCT-NO             PIC X(13) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-NO             PIC 9(09) VALUE 0.           
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-DEST-CD        PIC X(01) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-PULL-CD        PIC X(01) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-TOTAL-PAGES         PIC 9(09) VALUE 0.           
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-IMAGE-FL       PIC X(01) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-COMPANY-NO          PIC X(02) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-TYPE           PIC X(02) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-MAIL-DTL            PIC X(312) VALUE SPACES.     
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BRCODE-ZIP          PIC X(11) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-ACCT-ZIP            PIC X(09) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-BILL-UNIQID         PIC X(09) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-TRK-STATUS          PIC X(02) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-EDI-DEST-FL         PIC X(01) VALUE SPACES.      
           05  FILLER                      PIC X(01) VALUE '~'.         
           05  WS-NOOP-NO-COPIES           PIC X(01) VALUE SPACES.      
                                                                        
       01  WS-SQL-VARIABLES.                                            
           05  WS-SQL-CURSOR-TEMP          PIC X(25).                   
           05  WS-SQL-CALL-TEMP            PIC X(3).                    
           05  WS-SQL-PARA-TEMP            PIC X(4).                    
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC -Z(4).                   
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-PARM-ERROR               PIC X(01) VALUE 'N'.         
           05  WS-END-OF-CA715             PIC X(01) VALUE 'N'.         
               88  END-OF-CA715                      VALUE 'Y'.         
           05  WS-FCA715-STATUS            PIC X(02).                   
               88  FCA715-SUCCESSFUL                 VALUE ZERO.        
           05 WS-INSERT-SW                 PIC X(01) VALUE 'N'.         
               88  INSERT-ACCT                       VALUE 'Y'.         
           05 WS-DELETE-SW                 PIC X(01) VALUE 'N'.         
               88  DELETE-ACCTS                      VALUE 'Y'.         
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ            PIC 9(07) VALUE ZERO.        
           05  WS-ACCTS-INSERTED           PIC 9(07) VALUE ZERO.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-DELIMITER                PIC X(01) VALUE '~'.         
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA715'.  
                                                                        
       01  WS-DISPLAYS.                                                 
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-DISPLAY-ACCOUNT          PIC ZZZZZZZZZZZZ9.           
                                                                        
      * COPYBOOK ADDED SQL ERROR HANDLING                                       
       COPY CWS00010.                                                   01506000
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                   01506000
      * FIELDS FOR SQL/DB2 ERROR CHECKING                                       
       COPY CWS00303.                                                   01505000
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
      *                                                                         
      *   DCLGEN FOR CSS_EXCEPTION_BILL                                 00048800
           EXEC SQL                                                     00056600
                INCLUDE TBBILLEX                                        00056700
           END-EXEC.                                                    00056800
                                                                        
      *   DCLGEN FOR CSS_MNT_TRANS_HIST                                 00048800
           EXEC SQL                                                     00056600
                INCLUDE TBMNHIST                                        00056700
           END-EXEC.                                                    00056800
                                                                        
      *   DCLGEN FOR CSS_MT_TRN_HST_DET                                 00048800
           EXEC SQL                                                     00056600
                INCLUDE TBMNHDT                                         00056700
           END-EXEC.                                                    00056800
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUES.                                              
           05 WS-PARMVAL-LENGTH             PIC S9(04) COMP.            
           05 WS-PARM-VALUE                 PIC X(01).                  
           05 FILLER                        PIC X(01).                  
           05 WS-PARM-REFMT                 PIC X(01).                  
           05 FILLER                        PIC X(01).                  
           05 WS-PARM-RESET                 PIC X(05).                  
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUES.                         
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 2000-PROCESS-ACCOUNTS       THRU 2000-EXIT           
             UNTIL END-OF-CA715.                                        
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00072100
      *    0100-INITIALIZATION                                       ** 00072200
      *    OPEN FILES                                                ** 00072300
      ***************************************************************** 00072500
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA715-FILE.                                    
           IF NOT FCA715-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSCA715'                    
               DISPLAY '**   FILE STATUS = ' WS-FCA715-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
           INITIALIZE  WS-MISC.                                         
           PERFORM 0110-VALIDATE-PARM    THRU 0110-EXIT.                
ACT175     PERFORM 7000-READ-FCSCA715 THRU 7000-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 0110-VALIDATE-PARM                                         **  00122700
      **                                                            **        00
      ** 1) FIRST PARM FIELD TELLS WHICH GROUP OF BILLS TO EXTRACT. **        00
      ** 2) THE SECOND PARM FIELDS SHOULD BE BLANK IN THE NORMAL    **        00
      **    RUNS, BUT MIGHT REQUIRE AN "N" IN A RERUN.  THAT        **        00
      **    INDICATES THAT THE INPUT FILE IS ALREADY PROPERLY       **        00
      **    FORMATTED, AND THERE IS NO NEED TO REFORMAT.            **        00
      ** 3) THE THIRD PARM WILL SAY "RESET" IN A SITUATION IN WHICH **        00
      **    THE TABLE NEEDS TO BE DELETED AND COMPLETELY RELOADED.  **        00
      ****************************************************************        01
      ** VALID PARM VALUES:                                         **        01
      **    'D'              *SEB DEREGULATED                       **        01
      **    'R'              *SEB REGULATED                         **        01
      **    'V'              *SERVICE CARE                          **        01
      **    'C'              *CSR CIG (INDUSTRIAL GAS) BILLS        **        01
      **    'I'              *CSR INDUSTRIAL ELECTRIC BILLS         **        01
      **    'O'              *CSR ALL OTHER EXCEPTIONS              **        01
      ** THE REFMT-PARM SHOULD BE BLANK OR "N"                      **        01
      ** THE RESET-PARM SHOULD BE BLANK OR "RESET"                  **        01
      ****************************************************************  00122600
       0110-VALIDATE-PARM.                                              
                                                                        
            IF WS-PARM-VALUE = ('C' OR 'D' OR 'I' OR 'O' OR 'R' OR 'V') 
               CONTINUE                                                 
            ELSE                                                        
               DISPLAY 'PCSCA715 - ERROR IN PARM VALUE ' WS-PARM-VALUE  
               MOVE 'Y'               TO WS-PARM-ERROR                  
            END-IF.                                                     
                                                                        
            IF WS-PARM-REFMT > ' '                                      
              IF WS-PARM-REFMT = 'N'                                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY 'PCSCA715 - ERROR IN PARM REFMT ' WS-PARM-REFMT
                 MOVE 'Y'               TO WS-PARM-ERROR                
              END-IF                                                    
            END-IF.                                                     
                                                                        
            IF WS-PARM-RESET > ' '                                      
              IF WS-PARM-RESET = 'RESET'                                
                 PERFORM 8200-DROP-EXCP-TABLE     THRU 8200-EXIT        
              ELSE                                                      
                 DISPLAY 'PCSCA715 - ERROR IN PARM RESET ' WS-PARM-RESET
                 MOVE 'Y'               TO WS-PARM-ERROR                
              END-IF                                                    
            END-IF.                                                     
                                                                        
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03462*****************************************************************         
A03462*   0120-GET-DATE-1MNTH-PRIOR                                             
A03462* GET A DATE 1 MONTH PRIOR TO TODAY FOR USE IN SQL QUERIES.    **         
A03462*****************************************************************         
A03462 0120-GET-DATE-1MNTH-PRIOR.                                       
A03462                                                                  
A03462     EXEC SQL                                                     
A03462        SELECT TOP(1) DATEADD( MONTH, -1, IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BILLED
              ), CONVERT(DATE, :WS-DATE-BILLED) ) )                    
A03462         INTO :WS-1MNTH-PRIOR                                     
A03462         FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                         
A03462                                                           
A03462                                           
A03462                                                       
A03462     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-DATE-BILLED) - 1 MONTH                            
MFA-TR*        INTO :WS-1MNTH-PRIOR                                             
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 120                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03462     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A03462     IF SQLCODE NOT = SUCCESSFUL-CALL                             
A03462        DISPLAY '************ PCSCA718 *******************'       
A03462        DISPLAY '**  ERROR ON 0120-GET-DATE-1MNTH-PRIOR **'       
A03462        DISPLAY '**  SELECT FROM SYSDUMMY1              **'       
A03462        DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE        
A03462        DISPLAY '********* FATAL ERROR - ABEND ***********'       
A03462        PERFORM 9900-ABEND                THRU 9900-EXIT          
A03462     END-IF.                                                      
A03462 0120-EXIT.                                                       
A03462     EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *   2000-PROCESS-ACCOUNTS.                                     ** 00128300
      * READS THE DATA FROM INPUT FILE AND LOADS TO WORKING STORAGE  ** 00128400
      * TABLES.                                                      ** 00128500
      ***************************************************************** 00128700
                                                                        
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
                                                                        
           IF WS-PARM-REFMT = 'N'                                       
              MOVE E-FCA715-RECORD          TO DCLCSS-EXCEPTION-BILL    
           ELSE                                                         
              PERFORM 2100-REFORMAT-DATA    THRU 2100-EXIT              
           END-IF.                                                      
                                                                        
A03462     IF WS-1MNTH-PRIOR = SPACES                                   
A03462        PERFORM 0120-GET-DATE-1MNTH-PRIOR THRU 0120-EXIT          
A03462     END-IF.                                                      
                                                                        
A03462     PERFORM 2500-GET-PULLED-BY-USERID THRU 2500-EXIT.            
                                                                        
           COMPUTE WS-COUNTER = WS-COUNTER + 1.                         
                                                                        
           PERFORM 8000-INSERT-EXCP-BILL   THRU 8000-EXIT.              
                                                                        
           IF WS-CNTR-TEST = 0                                          
              DISPLAY 'CHECKPOINT ' WS-CHECK-POINT                      
              PERFORM 8100-ISSUE-COMMIT    THRU 8100-EXIT               
           END-IF.                                                      
ACT175     PERFORM 7000-READ-FCSCA715 THRU 7000-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *   2100-REFORMAT-DATA                                         ** 00128300
      * REFORMAT THE DATA TO LOAD INTO CSS_EXCEPTION_BILL TABLE      ** 00128400
      ***************************************************************** 00128700
       2100-REFORMAT-DATA.                                              
                                                                        
           INITIALIZE DCLCSS-EXCEPTION-BILL                             
                      WS-NOOPS-STRUCTURE.                               
           MOVE E-FCA715-RECORD             TO WS-HOLD-NOOPS-DATA.      
           MOVE WS-HOLD-NOOPS-SEQ           TO WS-NOOPS-SEQ-STRUCTURE.  
                                                                        
           UNSTRING                            WS-HOLD-NOOPS            
           DELIMITED BY                        WS-DELIMITER             
           INTO                                WS-NOOP-IDX              
                                               WS-NOOP-BILL-DATE        
                                               WS-NOOP-CORRES-TYPE      
                                               WS-NOOP-CUST-NO          
                                               WS-NOOP-ACCT-NO          
                                               WS-NOOP-BILL-NO          
                                               WS-NOOP-BILL-DEST-CD     
                                               WS-NOOP-BILL-PULL-CD     
                                               WS-NOOP-TOTAL-PAGES      
                                               WS-NOOP-BILL-IMAGE-FL    
                                               WS-NOOP-COMPANY-NO       
                                               WS-NOOP-BILL-TYPE        
                                               WS-NOOP-MAIL-DTL         
                                               WS-NOOP-BRCODE-ZIP       
                                               WS-NOOP-ACCT-ZIP         
                                               WS-NOOP-BILL-UNIQID      
                                               WS-NOOP-TRK-STATUS       
                                               WS-NOOP-EDI-DEST-FL      
                                               WS-NOOP-NO-COPIES.       
                                                                        
           MOVE WS-NOOP-ACCT-NO            TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO              TO JW-ACCOUNT-NO.            
           MOVE WS-NOOP-BILL-DATE          TO WS-NOOP-DATE-BILLED.      
           MOVE '-'                        TO WS-DASH-1                 
                                              WS-DASH-2.                
           MOVE WS-NOOP-DATE-MM            TO WS-DATE-BILL-MM.          
           MOVE WS-NOOP-DATE-DD            TO WS-DATE-BILL-DD.          
           MOVE WS-NOOP-DATE-CC            TO WS-DATE-BILL-CC.          
           MOVE WS-NOOP-DATE-YY            TO WS-DATE-BILL-YY.          
           MOVE WS-DATE-BILLED             TO JW-DATE-BILLED.           
           MOVE 'A'                        TO JW-BILL-DISP-CD.          
           MOVE WS-PARM-VALUE              TO JW-COMPANY-TYPE-CD.       
           MOVE WS-NOOP-SEQ-1              TO JW-ACCOUNT-SEQ-NO.        
           MOVE '2005-01-01-01.00.00.000001' TO JW-LAST-UPDATE-TS.      
           MOVE WS-NOOP-BILL-NO            TO JW-BILL-NO.               
           MOVE WS-NOOP-BILL-DEST-CD       TO JW-DEST-CD.               
           MOVE WS-NOOP-BILL-PULL-CD       TO JW-PULL-CD.               
                                                                        
           IF WS-PARM-VALUE = 'O'                                       
              IF WS-NOOP-NO-COPIES = '0'                                
                 MOVE 'M'                  TO JW-COMPANY-TYPE-CD        
              ELSE                                                      
                 MOVE 'O'                  TO JW-COMPANY-TYPE-CD        
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-VALUE = 'D'                                       
              IF WS-NOOP-NO-COPIES = '0'                                
                 MOVE 'L'                  TO JW-COMPANY-TYPE-CD        
              ELSE                                                      
                 MOVE 'D'                  TO JW-COMPANY-TYPE-CD        
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-VALUE = 'R'                                       
              IF WS-NOOP-NO-COPIES = '0'                                
                 MOVE 'H'                  TO JW-COMPANY-TYPE-CD        
              ELSE                                                      
                 MOVE 'R'                  TO JW-COMPANY-TYPE-CD        
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-VALUE = 'V'                                       
              IF WS-NOOP-NO-COPIES = '0'                                
                 MOVE 'J'                  TO JW-COMPANY-TYPE-CD        
              ELSE                                                      
                 MOVE 'V'                  TO JW-COMPANY-TYPE-CD        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-NOOP-COMPANY-NO         TO JW-COMPANY-NO.            
           IF JW-COMPANY-NO  = '01'                                     
              IF JW-DEST-CD = 'G'                                       
                IF WS-NOOP-NO-COPIES = '0'                              
                   MOVE 'Q'                TO JW-COMPANY-TYPE-CD        
                ELSE                                                    
                   MOVE 'C'                TO JW-COMPANY-TYPE-CD        
                END-IF                                                  
             ELSE                                                       
                IF JW-DEST-CD = 'S'                                     
                  IF WS-NOOP-NO-COPIES = '0'                            
                     MOVE 'K'              TO JW-COMPANY-TYPE-CD        
                  ELSE                                                  
                     MOVE 'I'              TO JW-COMPANY-TYPE-CD        
                  END-IF                                                
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
           MOVE LOW-VALUES                 TO JW-BILL-IMAGE-TEXT.       
           MOVE WS-NOOP-SEQ-2              TO JW-BILL-IMAGE-SEQ.        
ACT175     MOVE SPACES                     TO E-FCA715-RECORD (1:6).    
           MOVE LENGTH OF E-FCA715-RECORD  TO JW-BILL-IMAGE-LEN.        
           MOVE E-FCA715-RECORD            TO JW-BILL-IMAGE-TEXT.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03462***************************************************************** 00128700
A03462* 2500-GET-PULLED-BY-USERID                                    ** 00128300
A03462* FETCH USERID OF USER WHO REQUESTED FOR THE BILL TO BE PULLED ** 00128400
A03462* INTO OLBV.                                                              
A03462***************************************************************** 00128700
A03462 2500-GET-PULLED-BY-USERID.                                       
A03462                                                                  
A03462     MOVE SPACES                      TO WS-PULL-USERID.          
A03462     MOVE WS-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
A03462* GET USERID FOR CANCEL/REBILLS                                           
A03462     IF (JW-DEST-CD = 'A')                                        
A03462        PERFORM 2530-GET-CANREBILL-USERID THRU 2530-EXIT          
A03462     END-IF.                                                      
A03462                                                                  
A03462* SKIP USERID RETRIEVAL FOR CROSSFOOT ERRORS AND SECURED BILLS            
A03462     IF JW-DEST-CD = 'S' OR JW-DEST-CD = 'G' OR                   
A03462        (JW-DEST-CD = 'C' AND JW-PULL-CD = 'X')                   
A03462        MOVE 'SYSTEM'                    TO WS-PULL-USERID        
A03462     ELSE                                                         
A03462* PERM PULL CODE                                                          
A03462        IF (JW-DEST-CD = 'C' AND JW-PULL-CD = 'P')                
A03462           PERFORM 2510-GET-PERM-PULL-USERID THRU 2510-EXIT       
A03462* ALL OTHERS EXCEPT CANCEL/REBILLS                                        
A03462        ELSE                                                      
A03462           IF (JW-DEST-CD NOT = 'A')                              
A03462              PERFORM 2520-GET-TEMP-PULL-USERID THRU 2520-EXIT    
A03462           END-IF                                                 
A03462        END-IF                                                    
A03462     END-IF.                                                      
A03462     MOVE WS-PULL-USERID              TO JW-PULLED-BY-USERID.     
A03462                                                                  
A03462 2500-EXIT.                                                       
A03462     EXIT.                                                        
A03462                                                                  
A03462                                                                  
A03462 2510-GET-PERM-PULL-USERID.                                       
A03462                                                                  
A03462     MOVE SPACES        TO MH-USER-ID                             
A03462     EXEC SQL                                                     
A03462        SELECT TOP(1) USER_ID INTO :MH-USER-ID                           
A03462          FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MT
                           WITH(READUNCOMMITTED)       
A03462         WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A03462           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A03462           AND MT.COLUMN_DESC = 'PERM PULL CODE'                  
A03462           AND MT.CHG_COLUMN_VALUE <> 'A'                         
A03462        ORDER BY DATE_TRANS DESC                                  
A03462                                                           
A03462                                           
A03462                                                      
A03462     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID INTO :MH-USER-ID                                   
MFA-TR*         FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MT               
MFA-TR*        WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MT.COLUMN_DESC = 'PERM PULL CODE'                          
MFA-TR*          AND MT.CHG_COLUMN_VALUE <> 'A'                                 
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 2510                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03462     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A03462     EVALUATE SQLCODE                                             
A03462        WHEN SUCCESSFUL-CALL                                      
A03462           MOVE MH-USER-ID       TO WS-PULL-USERID                
A03462        WHEN NOT-FOUND                                            
A03462           MOVE 'UNKNOWN'    TO WS-PULL-USERID                    
A03462        WHEN OTHER                                                
A03462           DISPLAY '************ PCSCA718 *******************'    
A03462           DISPLAY '**  ERROR ON 2510-GET-PERM-PULL-USERID **'    
A03462           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A03462           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A03462           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A03462           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A03462           PERFORM 9900-ABEND                THRU 9900-EXIT       
A03462     END-EVALUATE.                                                
A03462                                                                  
A03462                                                                  
A03462 2510-EXIT.                                                       
A03462     EXIT.                                                        
A03462                                                                  
A03462 2520-GET-TEMP-PULL-USERID.                                       
A03462                                                                  
A03462     MOVE SPACES        TO MH-USER-ID                             
A03462     EXEC SQL                                                     
A03462        SELECT TOP(1) USER_ID                                            
A03462         INTO :MH-USER-ID                                         
A03462         FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MT
                           WITH(READUNCOMMITTED)        
A03462         WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A03462           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A03462           AND MT.COLUMN_DESC = 'TEMP PULL CODE'                  
A03462           AND MT.CHG_COLUMN_VALUE <> 'A'                         
A03462           AND MH.DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                        :WS-1MNTH-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-1MNTH-PRIOR
              ) <> 0) OR (LEN(:WS-1MNTH-PRIOR) <> 10), CIS.CHAR2DATE(
                                                        :WS-1MNTH-PRIOR
              ), CONVERT(DATE, :WS-1MNTH-PRIOR) )                    
A03462        ORDER BY DATE_TRANS DESC                                  
A03462                                                           
A03462                                           
A03462                                                      
A03462     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID                                                    
MFA-TR*        INTO :MH-USER-ID                                                 
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MT                
MFA-TR*        WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MT.COLUMN_DESC = 'TEMP PULL CODE'                          
MFA-TR*          AND MT.CHG_COLUMN_VALUE <> 'A'                                 
MFA-TR*          AND MH.DATE_TRANS > :WS-1MNTH-PRIOR                            
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 2520                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03462     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A03462     EVALUATE SQLCODE                                             
A03462        WHEN SUCCESSFUL-CALL                                      
A03462           MOVE MH-USER-ID       TO WS-PULL-USERID                
A03462        WHEN NOT-FOUND                                            
A03462           IF (JW-DEST-CD = 'C' AND JW-PULL-CD = 'T')             
A03462               MOVE 'UNKNOWN'    TO WS-PULL-USERID                
A03462           ELSE                                                   
A03462               MOVE 'SYSTEM '    TO WS-PULL-USERID                
A03462           END-IF                                                 
A03462        WHEN OTHER                                                
A03462           DISPLAY '************ PCSCA718 *******************'    
A03462           DISPLAY '**  ERROR ON 2520-GET-TEMP-PULL-USERID **'    
A03462           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A03462           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A03462           DISPLAY '**  DATE       = ' WS-1MNTH-PRIOR             
A03462           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A03462           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A03462           PERFORM 9900-ABEND                THRU 9900-EXIT       
A03462     END-EVALUATE.                                                
A03462                                                                  
A03462 2520-EXIT.                                                       
A03462     EXIT.                                                        
A03462                                                                  
A03462 2530-GET-CANREBILL-USERID.                                       
A03462                                                                  
A03462     MOVE SPACES        TO MH-USER-ID                             
A03462     EXEC SQL                                                     
A03462        SELECT TOP(1) USER_ID                                            
A03462         INTO :MH-USER-ID                                         
A03462         FROM CSS_MNT_TRANS_HIST MH
                           WITH(READUNCOMMITTED), CSS_MT_TRN_HST_DET MT
                           WITH(READUNCOMMITTED)        
A03462         WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO        
A03462           AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                     
A03462           AND MT.COLUMN_DESC = 'FNCT DESIRED'                    
A03462           AND MT.CHG_COLUMN_VALUE = 'CANCEL/REBILL'              
A03462           AND MH.DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                        :WS-1MNTH-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-1MNTH-PRIOR
              ) <> 0) OR (LEN(:WS-1MNTH-PRIOR) <> 10), CIS.CHAR2DATE(
                                                        :WS-1MNTH-PRIOR
              ), CONVERT(DATE, :WS-1MNTH-PRIOR) )                    
A03462        ORDER BY DATE_TRANS DESC                                  
A03462                                                           
A03462                                           
A03462                                                      
A03462     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID                                                    
MFA-TR*        INTO :MH-USER-ID                                                 
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH, CSS_MT_TRN_HST_DET MT                
MFA-TR*        WHERE MT.TRANS_HIST_SEQ_NO = MH.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.ACCOUNT_NO = :MH-ACCOUNT-NO                             
MFA-TR*          AND MT.COLUMN_DESC = 'FNCT DESIRED'                            
MFA-TR*          AND MT.CHG_COLUMN_VALUE = 'CANCEL/REBILL'                      
MFA-TR*          AND MH.DATE_TRANS > :WS-1MNTH-PRIOR                            
MFA-TR*       ORDER BY DATE_TRANS DESC                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 2530                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03462     MOVE SQLCODE    TO WS-DISPLAY-SQLCODE.                       
A03462     EVALUATE SQLCODE                                             
A03462        WHEN SUCCESSFUL-CALL                                      
A03462           MOVE MH-USER-ID       TO WS-PULL-USERID                
A03462        WHEN NOT-FOUND                                            
A03462           MOVE 'SYSTEM '        TO WS-PULL-USERID                
A03462        WHEN OTHER                                                
A03462           DISPLAY '************ PCSCA718 *******************'    
A03462           DISPLAY '**  ERROR ON 2530-GET-CANREBILL-USERID **'    
A03462           DISPLAY '**  SELECT FROM CSS_MT_TRN_HST_DET     **'    
A03462           DISPLAY '**  ACCOUNT_NO = ' MH-ACCOUNT-NO              
A03462           DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE     
A03462           DISPLAY '********* FATAL ERROR - ABEND ***********'    
A03462           PERFORM 9900-ABEND                THRU 9900-EXIT       
A03462     END-EVALUATE.                                                
A03462                                                                  
A03462 2530-EXIT.                                                       
A03462     EXIT.                                                        
A03462                                                                  
                                                                        
      ****************************************************************  00122600
      ** 7000-READ-FCSCA715.                                        **  00122700
      ** READ THE INPUT FILE FCSCA715.                              **  00122800
      ****************************************************************  00123100
       7000-READ-FCSCA715.                                              
                                                                        
           READ FCSCA715-FILE AT END                                    
                MOVE 'Y'                   TO WS-END-OF-CA715.          
           IF FCA715-SUCCESSFUL OR END-OF-CA715                         
              ADD  +1                      TO WS-RECORDS-READ           
           ELSE                                                         
              MOVE 12                      TO RETURN-CODE               
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA715 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING FCSCA715       **'        
              DISPLAY '**     FILE STATUS = ' WS-FCA715-STATUS          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-EXCP-BILL                                          *        
      *    INSERT ROW IN THE CSS_EXCEPTION_BILL TABLE                  *        
      ******************************************************************        
       8000-INSERT-EXCP-BILL.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EXCEPTION_BILL                            
                    ( DATE_BILLED                                       
                    , COMPANY_NO                                        
                    , ACCOUNT_NO                                        
                    , DEST_CD                                           
                    , PULL_CD                                           
                    , BILL_NO                                           
                    , BILL_IMAGE_SEQ                                    
                    , COMPANY_TYPE_CD                                   
                    , ACCOUNT_SEQ_NO                                    
                    , LAST_UPDATE_TS                                    
                    , LAST_UPDATE_USERID                                
                    , BILL_DISP_CD                                      
                    , BILL_IMAGE                                        
                    , PULLED_BY_USERID)                                 
             VALUES  (IIF(TRY_CONVERT(DATE, :JW-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :JW-DATE-BILLED
              ) <> 0) OR (LEN(:JW-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :JW-DATE-BILLED
              ), CONVERT(DATE, :JW-DATE-BILLED) )                              
                    , :JW-COMPANY-NO                                    
                    , :JW-ACCOUNT-NO                                    
                    , :JW-DEST-CD                                       
                    , :JW-PULL-CD                                       
                    , :JW-BILL-NO                                       
                    , :JW-BILL-IMAGE-SEQ                                
                    , :JW-COMPANY-TYPE-CD                               
                    , :JW-ACCOUNT-SEQ-NO                                
                    , CIS.CHAR2TIMESTAMP(:JW-LAST-UPDATE-TS)                    
                    , :JW-LAST-UPDATE-USERID                            
                    , :JW-BILL-DISP-CD                                  
                    , :JW-BILL-IMAGE                                    
                    , :JW-PULLED-BY-USERID)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EXCEPTION_BILL                                    
MFA-TR*             ( DATE_BILLED                                               
MFA-TR*             , COMPANY_NO                                                
MFA-TR*             , ACCOUNT_NO                                                
MFA-TR*             , DEST_CD                                                   
MFA-TR*             , PULL_CD                                                   
MFA-TR*             , BILL_NO                                                   
MFA-TR*             , BILL_IMAGE_SEQ                                            
MFA-TR*             , COMPANY_TYPE_CD                                           
MFA-TR*             , ACCOUNT_SEQ_NO                                            
MFA-TR*             , LAST_UPDATE_TS                                            
MFA-TR*             , LAST_UPDATE_USERID                                        
MFA-TR*             , BILL_DISP_CD                                              
MFA-TR*             , BILL_IMAGE                                                
MFA-TR*             , PULLED_BY_USERID)                                         
MFA-TR*      VALUES  (:JW-DATE-BILLED                                           
MFA-TR*             , :JW-COMPANY-NO                                            
MFA-TR*             , :JW-ACCOUNT-NO                                            
MFA-TR*             , :JW-DEST-CD                                               
MFA-TR*             , :JW-PULL-CD                                               
MFA-TR*             , :JW-BILL-NO                                               
MFA-TR*             , :JW-BILL-IMAGE-SEQ                                        
MFA-TR*             , :JW-COMPANY-TYPE-CD                                       
MFA-TR*             , :JW-ACCOUNT-SEQ-NO                                        
MFA-TR*             , :JW-LAST-UPDATE-TS                                        
MFA-TR*             , :JW-LAST-UPDATE-USERID                                    
MFA-TR*             , :JW-BILL-DISP-CD                                          
MFA-TR*             , :JW-BILL-IMAGE                                            
MFA-TR*             , :JW-PULLED-BY-USERID)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              MOVE WS-PGRMNAME               TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_EXCEPTION_BILL'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_BILLED'             TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE JW-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE JW-DATE-BILLED            TO HOSTVAR-ELEMENT-2       
              MOVE JW-BILL-NO                TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
      *                                                                         
      ****************************************************************  04850000
      **  8100-ISSUE-COMMIT.                                        **          
      **      GET COMMIT AFTER EVERY 100 RECORDS UPDATED            **  04880000
      ****************************************************************  04900000
      *                                                                         
       8100-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              DISPLAY '*******************************************'     
              DISPLAY ' ERROR IN PCSCA715 8100-ISSUE-COMMIT       '     
              DISPLAY ' RETURN CODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-DROP-EXCP-TABLE.                                            
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_EXCEPTION_BILL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              MOVE WS-PGRMNAME               TO ABEND-PROGRAM           
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_EXCEPTION_BILL'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXIT.                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA715-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
