       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA714.                                        
       AUTHOR.         JASON WRIGHT.                                    
       DATE-WRITTEN.   FEBRUARY 2000.                                   
      ***************************************************************** 00050005
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060005
      ***************************************************************** 00070005
      **                                                             ** 00080005
      **              PROGRAM  MODIFICATION  LOG                     ** 00090005
      **                                                             ** 00100005
      **    DATE    INITIALS     REASON                              ** 00110005
      **  --------  --------     ----------------------------------  ** 00120005
      **  02/2000     JW         INITIAL VERSION OF PROGRAM          ** 00130005
      **                                                             ** 00140005
      ***************************************************************** 00150005
                                                                        
      ***************************************************************** 00170005
      **  PCSCA714 READS IN THE MSOUTPUT FILE.  IT WRITES OUT A NEW  ** 00180005
      **  FILE WITH A SEQUENCE NUMBER APPENDED TO EACH RECORD, AND   ** 00190005
      **  AN ZIP-CODE CHANGE INDICATOR.  THIS FILE WILL BE SORTED    ** 00200005
      **  AND USED WITH FCSBE40.SRTD TO ADD INFORMATION TO THE BE40  ** 00210005
      **  RECORD.  IT ALSO PRODUCES A REPORT FOR THE MAILROOM        ** 00220005
      **  LISTING THE VARIOUS ZIP CODE GROUPINGS, AND HOW MANY       ** 00230005
      **  PIECES OF MAIL WILL BE GOING OUT IN EACH GROUPING.         ** 00240005
      ***************************************************************** 00250005
      *                                                                 00260005
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT MAILSTREAM-IN                                         
               ASSIGN TO MAILIN                                         
               FILE STATUS IS WS-MAILIN-STATUS.                         
           SELECT MAILSTREAM-OUT                                        
               ASSIGN TO MAILOUT                                        
               FILE STATUS IS WS-MAILOUT-STATUS.                        
T21816     SELECT REPORT-OUT                                            
T21816         ASSIGN TO REPOUT                                         
T21816         FILE STATUS IS WS-REPOUT-STATUS.                         
T21816     SELECT REPORT2-OUT                                           
T21816         ASSIGN TO REP2OUT                                        
T21816         FILE STATUS IS WS-REP2OUT-STATUS.                        
      *                                                                 00420005
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD MAILSTREAM-IN.                                                
       01 MS-IN                            PIC X(512).                  
      *                                                                 00470005
       FD MAILSTREAM-OUT.                                               
       01 MS-OUT                           PIC X(520).                  
      *                                                                 00500005
T21816 FD REPORT-OUT.                                                   
T21816 01 REP-OUT                          PIC X(80).                   
      *                                                                 00530005
T21816 FD REPORT2-OUT.                                                  
T21816 01 REP2-OUT                         PIC X(80).                   
      *                                                                 00560005
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA714'.
MSQ017     COPY MFASQLM.
      *                                                                 00580005
       01  WS-MS-IN.                                                    
           05  FILLER                      PIC X(52).                   
           05  WS-MS-IN-ZIP                PIC 9(9).                    
           05  FILLER                      PIC X(92).                   
           05  WS-ZIP-GROUP-IN             PIC X(5).                    
           05  FILLER                      PIC X(5).                    
           05  WS-MS-TYPE                  PIC X(2).                    
           05  FILLER                      PIC X(347).                  
      *                                                                 00670005
       01  WS-MS-OUT.                                                   
           05  WS-MSOUT-DATA               PIC X(512)   VALUE SPACES.   
           05  FILLER                      PIC X(1).                    
           05  WS-MSOUT-SEQ-NO             PIC 9(5)     VALUE ZEROS.    
           05  FILLER                      PIC X.                       
           05  WS-MSOUT-ZIP-CHANGE         PIC X        VALUE SPACES.   
      *                                                                 00740005
       01  WS-MISC.                                                     
           05  WS-ZIP-CODE-PREV            PIC X(5)     VALUE SPACES.   
           05  WS-SEQUENCE-NO-TEMP         PIC 9(5)     VALUE ZEROS.    
           05  WS-ZIP-FLAG                 PIC X        VALUE SPACES.   
               88  ZIP-CHANGE                           VALUE 'T'.      
           05  WS-END-OF-MSIN              PIC X        VALUE SPACES.   
               88  END-OF-INPUT                         VALUE 'T'.      
           05  WS-MAILIN-STATUS            PIC XX       VALUE '  '.     
               88  MAILIN-SUCCESSFUL                    VALUE '00'.     
               88  MAILIN-READ-OK                       VALUE '00' '04'.
           05  WS-MAILOUT-STATUS           PIC XX       VALUE '  '.     
               88  MAILOUT-SUCCESSFUL                   VALUE '00'.     
           05  WS-MS-TYPE-PREV             PIC X(2)     VALUE SPACES.   
T21816     05  WS-REPOUT-STATUS            PIC XX       VALUE '  '.     
T21816         88  REPOUT-SUCCESSFUL                    VALUE '00'.     
T21816     05  WS-REP2OUT-STATUS           PIC XX       VALUE '  '.     
T21816         88  REP2OUT-SUCCESSFUL                   VALUE '00'.     
T21816     05  WS-NUMBER-IN-GROUP          PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-NUMBER-IN-AT             PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-NUMBER-IN-AV             PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-NUMBER-IN-AB             PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-NUMBER-IN-OTHER          PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-NUMBER-IN-NONE           PIC 9(5)     VALUE ZEROS.    
T21816     05  WS-GROUP-FLAG               PIC X        VALUE SPACES.   
T21816         88  GROUP-CHANGE                         VALUE 'T'.      
T21816     05  WS-OUTPUT-LINE.                                          
T21816         10  WS-OUTPUT-ZIP-GROUP     PIC X(15).                   
T21816         10  FILLER                  PIC X(3)     VALUE ' = '.    
T21816         10  WS-OUTPUT-REC-COUNT     PIC X(5).                    
T21877     05  WS-DATE-DATA.                                            
T21877         10  WS-CURRENT-DATE         PIC X(10).                   
T21877         10  FILLER                  PIC X(70).  
MAN008     05 WS-DATE-DATA-MAN008 REDEFINES 
MAN008           WS-DATE-DATA PIC X(80).		                 
COB305     05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.   
T21816     05  WS-BILL-CYCLE               PIC X(2).                    
T21816     05  WS-ABEND-SWITCH             PIC X(3).                    
T21816         88  WS-ABEND-YES                         VALUE 'YES'.    
T21816*                                                                 01110005
T21816 01  WS-SQL-VARIABLES.                                            
T21816     05  WS-SQL-RETURN-CODE          PIC S9(3)V   VALUE ZEROS.    
T21816     05  SUCCESSFUL-CALL             PIC S9(3)V   VALUE 000.      
T21816     05  WS-RETURN-CODE              PIC S9(3)V   VALUE ZEROS.    
T21816/                                                                 01160005
T21816     EXEC SQL                                                     01170005
T21816         INCLUDE SQLCA                                            01180005
T21816     END-EXEC.                                                    01190005
T21816/                                                                 01200005
T21816     EXEC SQL                                                     01210005
T21816         INCLUDE TBMODEL                                          01220005
T21816     END-EXEC.                                                    01230005
T21816/                                                                 01240005
T21816     EXEC SQL                                                     01250005
T21816         INCLUDE TBBILWDW                                         01260005
T21816     END-EXEC.                                                    01270005
T21816/                                                                 01280005
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                 01310005
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
           PERFORM 0500-GET-BILL-CYCLE THRU 0500-EXIT.                  
           PERFORM 1000-PROCESS-RECORDS THRU 1000-EXIT.                 
           PERFORM 8775-WRITE-OTHER THRU 8775-EXIT.                     
           PERFORM 9000-TERMINATE.                                      
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01400005
       0100-INITIALIZE.                                                 
T21816     EXEC SQL                                                     
T21877         SELECT PARM_DATA                                         
MAN008*        INTO  :WS-DATE-DATA                                      
MAN008         INTO  :WS-DATE-DATA-MAN008
T21877         FROM CSS_JOB_PARM                                        
T21877         WHERE PROGRAM_NAME = 'COMMONDATE'                        
T21816     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21816     IF SQLCODE NOT EQUAL TO SUCCESSFUL-CALL                      
T21816         DISPLAY '****************************************'       
T21816         DISPLAY '**   0100-INITIALIZE                  **'       
T21816         DISPLAY '**   ERROR OPENING CSS_MODEL_SQL      **'       
T21816         DISPLAY '****************************************'       
T21816         MOVE SQLCODE TO WS-SQL-RETURN-CODE                       
T21816         DISPLAY 'RETURN CODE IS ' WS-SQL-RETURN-CODE             
T21816     END-IF.                                                      
           OPEN INPUT MAILSTREAM-IN.                                    
           IF NOT MAILIN-SUCCESSFUL                                     
               DISPLAY '****************************************'       
               DISPLAY '**   0100-INITIALIZE                    '       
               DISPLAY '**   ERROR OPENING MSOUTPUT'                    
               DISPLAY '**   FILE STATUS = ' WS-MAILIN-STATUS           
               DISPLAY '****************************************'       
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           OPEN OUTPUT MAILSTREAM-OUT.                                  
           IF NOT MAILOUT-SUCCESSFUL                                    
               DISPLAY '****************************************'       
               DISPLAY '**   0100-INITIALIZE                    '       
               DISPLAY '**   ERROR OPENING MSOUTPUT.CHANGED'            
               DISPLAY '**   FILE STATUS = ' WS-MAILOUT-STATUS          
               DISPLAY '****************************************'       
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
T21816     OPEN OUTPUT REPORT-OUT.                                      
T21816     IF NOT REPOUT-SUCCESSFUL                                     
T21816         DISPLAY '****************************************'       
T21816         DISPLAY '**   0100-INITIALIZE                    '       
T21816         DISPLAY '**   ERROR OPENING REPORT #1'                   
T21816         DISPLAY '**   FILE STATUS = ' WS-REPOUT-STATUS           
T21816         DISPLAY '****************************************'       
T21816         MOVE 12 TO RETURN-CODE                                   
T21816         PERFORM 9000-TERMINATE THRU 9000-EXIT                    
T21816     END-IF.                                                      
T21816     OPEN OUTPUT REPORT2-OUT.                                     
T21816     IF NOT REP2OUT-SUCCESSFUL                                    
T21816         DISPLAY '****************************************'       
T21816         DISPLAY '**   0100-INITIALIZE                    '       
T21816         DISPLAY '**   ERROR OPENING REPORT #2'                   
T21816         DISPLAY '**   FILE STATUS = ' WS-REP2OUT-STATUS          
T21816         DISPLAY '****************************************'       
T21816         MOVE 12 TO RETURN-CODE                                   
T21816         PERFORM 9000-TERMINATE THRU 9000-EXIT                    
T21816     END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01980005
T21816 0500-GET-BILL-CYCLE.                                             
T21816     EXEC SQL                                                     
T21816         SELECT DISTINCT REVENUE_MONTH MAX                        
T21816         INTO  :WS-REVENUE-MONTH                                  
T21816         FROM CSS_BILL_WINDOW                                     
T21816         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
T21816     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02000005
MFA-TR*        SELECT DISTINCT REVENUE_MONTH MAX                        02010005
MFA-TR*        INTO  :WS-REVENUE-MONTH                                  02020005
MFA-TR*        FROM CSS_BILL_WINDOW                                     02030005
MFA-TR*        WHERE DATE_EXTRACT = :WS-CURRENT-DATE                    02040005
MFA-TR*    END-EXEC.                                                    02050005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21816     IF SQLCODE NOT EQUAL TO SUCCESSFUL-CALL                      
T21816         DISPLAY '********************************************'   
T21816         DISPLAY '**   0500-GET-BILL-CYCLE                  **'   
T21816         DISPLAY '**   ERROR SELECTING REVENUE MONTH        **'   
T21816         DISPLAY '********************************************'   
T21816         MOVE SQLCODE TO WS-SQL-RETURN-CODE                       
T21816         DISPLAY 'RETURN CODE IS ' WS-SQL-RETURN-CODE             
T21816     END-IF.                                                      
           MOVE ZEROS TO WS-SQL-RETURN-CODE                             
T21816     EXEC SQL                                                     
T21816         SELECT MAX(BILL_CYCLE)                                   
T21816         INTO  :WS-BILL-CYCLE                                     
T21816         FROM CSS_BILL_WINDOW                                     
T21816         WHERE REVENUE_MONTH = :WS-REVENUE-MONTH                  
T21816         AND DATE_EXTRACT = IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                      
T21816     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02150005
MFA-TR*        SELECT MAX(BILL_CYCLE)                                   02160005
MFA-TR*        INTO  :WS-BILL-CYCLE                                     02170005
MFA-TR*        FROM CSS_BILL_WINDOW                                     02180005
MFA-TR*        WHERE REVENUE_MONTH = :WS-REVENUE-MONTH                  02190005
MFA-TR*        AND DATE_EXTRACT = :WS-CURRENT-DATE                      02200005
MFA-TR*    END-EXEC.                                                    02210005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21816     IF SQLCODE NOT EQUAL TO SUCCESSFUL-CALL                      
T21816         DISPLAY '********************************************'   
T21816         DISPLAY '**   0500-GET-BILL-CYCLE                  **'   
T21816         DISPLAY '**   ERROR SELECTING BILL CYCLE           **'   
T21816         DISPLAY '********************************************'   
T21816         MOVE SQLCODE TO WS-SQL-RETURN-CODE                       
T21816         DISPLAY 'RETURN CODE IS ' WS-SQL-RETURN-CODE             
T21816     END-IF.                                                      
T21877     IF WS-SQL-RETURN-CODE EQUAL TO ZEROS                         
T21816         MOVE 'BILL CYCLE' TO WS-OUTPUT-ZIP-GROUP                 
T21816         MOVE WS-BILL-CYCLE TO WS-OUTPUT-REC-COUNT                
T21816         MOVE WS-OUTPUT-LINE TO REP-OUT                           
T21816         MOVE WS-OUTPUT-LINE TO REP2-OUT                          
T21816         WRITE REP-OUT                                            
T21816         WRITE REP2-OUT                                           
T21877     ELSE                                                         
T21877         MOVE 'SQL ERROR DETERMINING BILL CYCLE' TO REP-OUT       
T21877         MOVE 'SQL ERROR DETERMINING BILL CYCLE' TO REP2-OUT      
T21877         WRITE REP-OUT                                            
T21877         WRITE REP2-OUT                                           
T21877         MOVE 'CONTACT BILL-PRINT TEAM' TO REP-OUT                
T21877         MOVE 'CONTACT BILL-PRINT TEAM' TO REP2-OUT               
T21877         WRITE REP-OUT                                            
T21877         WRITE REP2-OUT                                           
T21877     END-IF.                                                      
T21816 0500-EXIT.                                                       
T21816     EXIT.                                                        
      *                                                                 02490005
       1000-PROCESS-RECORDS.                                            
           PERFORM UNTIL END-OF-INPUT                                   
               MOVE SPACES TO WS-MSOUT-ZIP-CHANGE                       
               PERFORM 8000-READ-MSIN THRU 8000-EXIT                    
               IF NOT END-OF-INPUT                                      
                   MOVE WS-MS-IN TO WS-MSOUT-DATA                       
                   ADD 1 TO WS-SEQUENCE-NO-TEMP                         
      *                                                                 02570005
      ************************************************************      02580005
      ** THE FOLLOWING EVALUATE STATEMENT EXAMINES WS-MS-TYPE.  **      02590005
      ** THIS VARIABLE INDICATES WHETHER THE LINE IN THE        **      02600005
      ** MSOUTPUT FILE IS A FIVE-DIGIT ZIP (AV), A THREE-DIGIT  **      02610005
      ** ZIP (AT) OR ANY OTHER KIND.                            **      02620005
      ************************************************************      02630005
      *                                                                 02640005
T21816             EVALUATE WS-MS-TYPE                                  
T21816                 WHEN 'AV'                                        
T21816                 WHEN 'AT'                                        
T21861                     IF WS-ZIP-CODE-PREV = '  '                   
T21861                         PERFORM 8785-WRITE-INVALID THRU          
T21861                            8785-EXIT                             
T21861                     END-IF                                       
T21816                     IF WS-ZIP-GROUP-IN NOT EQUAL TO              
T21816                        WS-ZIP-CODE-PREV                          
T21816                         PERFORM 8760-WRITE-DIGIT THRU 8760-EXIT  
T21816                         MOVE '1' TO WS-MSOUT-ZIP-CHANGE          
T21816                     END-IF                                       
T21816                     ADD 1 TO WS-NUMBER-IN-GROUP                  
      *                                                                 02780005
      ************************************************************      02790005
      ** WHEN THE RECORD TYPE IS A FIVE-DIGIT ZIP OR A THREE-   **      02800005
      ** DIGIT ZIP, COMPARE THE ZIP-CODE GROUP.  THIS IS        **      02810005
      ** ANOTHER FIELD IN THE MSOUTPUT FILE.  IN THE CASE OF    **      02820005
      ** FIVE DIGIT ZIP, THE GROUP IS THE ACTUAL FIVE DIGIT ZIP **      02830005
      ** CODE.  IN THE CASE OF THREE-DIGIT ZIP, IT IS THE THREE **      02840005
      ** DIGIT ZIP CODE GROUP.  WHEN THEY ARE EQUAL, MOVE A '1' **      02850005
      ** TO THE ZIP CODE SPLASH MARK TO BE WRITTEN IN THE FILE. **      02860005
      ************************************************************      02870005
      *                                                                 02880005
T21816                 WHEN OTHER                                       
T21816                     PERFORM 8760-WRITE-DIGIT THRU 8760-EXIT      
T21816                     IF WS-MS-TYPE = 'AB'                         
T21816                         ADD 1 TO WS-NUMBER-IN-AB                 
T21816                     END-IF                                       
T21816                     IF WS-MS-TYPE = 'FP' OR WS-MS-TYPE = 'AC'    
                              OR WS-MS-TYPE = 'SP'                      
T21816                         ADD 1 TO WS-NUMBER-IN-OTHER              
T21816                     END-IF                                       
T21816                     IF WS-MS-TYPE = '  '                         
T21816                         ADD 1 TO WS-NUMBER-IN-NONE               
T21816                     END-IF                                       
                           IF WS-MS-TYPE NOT EQUAL TO WS-MS-TYPE-PREV   
                               MOVE '1' TO WS-MSOUT-ZIP-CHANGE          
                               MOVE WS-MS-TYPE TO WS-MS-TYPE-PREV       
                           END-IF                                       
      *                                                                 03040005
      ************************************************************      03050005
      ** IF THE LINE IS NOT CLASSIFIED AS A THREE OR FIVE DIGIT **      03060005
      ** ZIP, THEN A ZIP CHANGE SPLASH IS ONLY NEEDED WHEN THE  **      03070005
      ** TYPE CHANGES.  (BAR CODED, FULL POSTAGE, ANYTHING ELSE)**      03080005
      ************************************************************      03090005
      *                                                                 03100005
                   END-EVALUATE                                         
                   PERFORM 8500-WRITE-MSOUT THRU 8500-EXIT              
                   MOVE WS-ZIP-GROUP-IN TO WS-ZIP-CODE-PREV             
               END-IF                                                   
           END-PERFORM.                                                 
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03180005
       8000-READ-MSIN.                                                  
           READ MAILSTREAM-IN INTO WS-MS-IN                             
               AT END MOVE 'T' TO WS-END-OF-MSIN.                       
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03240005
       8500-WRITE-MSOUT.                                                
           MOVE WS-SEQUENCE-NO-TEMP TO WS-MSOUT-SEQ-NO.                 
           WRITE MS-OUT FROM WS-MS-OUT.                                 
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03300005
      ****************************************************************  03310005
      **  8760-WRITE-DIGIT                                              03320005
      **  THIS PARAGRAPH HANDLES THE FIVE AND THREE DIGIT ZIP       **  03330005
      **  CODES.                                                    **  03340005
      ****************************************************************  03350005
      *                                                                 03360005
T21816 8760-WRITE-DIGIT.                                                
T21816*                                                                 03380005
T21816****************************************************************  03390005
T21816**  IF THERE IS A PREVIOUS ZIP CODE GROUP, AND THE PREVIOUS   **  03400005
T21816**  GROUP TYPE IS A 5 OR 3 DIGIT ZIP CODE, THIS SENTENCE      **  03410005
T21816**  WRITES A LINE FOR THE PREVIOUS ZIP CODE GROUP DISPLAYING  **  03420005
T21816**  HOW MANY BILLS FALL INTO IT.                              **  03430005
T21816****************************************************************' 03440005
T21816*                                                                 03450005
T21816     IF (WS-ZIP-CODE-PREV NOT EQUAL TO SPACES) AND                
T21816         ((WS-MS-TYPE-PREV EQUAL TO 'AV') OR (WS-MS-TYPE-PREV     
T21816         EQUAL TO 'AT'))                                          
T21816             MOVE WS-ZIP-CODE-PREV TO WS-OUTPUT-ZIP-GROUP         
T21816             MOVE WS-NUMBER-IN-GROUP TO WS-OUTPUT-REC-COUNT       
T21816             MOVE WS-OUTPUT-LINE TO REP-OUT                       
T21816             MOVE WS-OUTPUT-LINE TO REP2-OUT                      
T21816             WRITE REP-OUT                                        
T21816             WRITE REP2-OUT                                       
T21816             MOVE ZEROS TO WS-NUMBER-IN-GROUP                     
T21816     END-IF.                                                      
T21816******************************************************************03570005
T21816**  THIS SENTENCE WRITES THE SECTION HEADERS FOR THE FIVE DIGIT **03580005
T21816**  AND THREE DIGIT ZIP CODES.                                  **03590005
T21816******************************************************************03600005
T21816     IF WS-MS-TYPE NOT EQUAL TO WS-MS-TYPE-PREV                   
T21816         EVALUATE WS-MS-TYPE                                      
T21816             WHEN 'AV'                                            
T21816                 MOVE '5-DIGIT ZIP CODES' TO REP-OUT              
T21816                 MOVE '5-DIGIT ZIP CODES' TO REP2-OUT             
T21816                 WRITE REP-OUT                                    
T21816                 WRITE REP2-OUT                                   
T21816             WHEN 'AT'                                            
T21816                 MOVE '3-DIGIT ZIP CODES' TO REP-OUT              
T21816                 MOVE '3-DIGIT ZIP CODES' TO REP2-OUT             
T21816                 WRITE REP-OUT                                    
T21816                 WRITE REP2-OUT                                   
T21816         END-EVALUATE                                             
T21816     END-IF.                                                      
T21816     MOVE WS-MS-TYPE TO WS-MS-TYPE-PREV.                          
T21816 8760-EXIT.                                                       
T21816     EXIT.                                                        
T21816*                                                                 03780005
T21816***************************************************************   03790005
T21816**  8775-WRITE-OTHER                                         **   03800005
T21816**  THIS PARAGRAPH TAKES CARE OF WRITING OUT A SUMMARY OF    **   03810005
T21816**  THE NUMBER OF BILLS THAT FALL INTO THE OTHER CATEGORIES. **   03820005
T21816***************************************************************   03830005
T21816*                                                                 03840005
T21816 8775-WRITE-OTHER.                                                
T21816     MOVE 'BAR CODED' TO WS-OUTPUT-ZIP-GROUP.                     
T21816     MOVE WS-NUMBER-IN-AB TO WS-OUTPUT-REC-COUNT.                 
T21816     MOVE WS-OUTPUT-LINE TO REP-OUT.                              
T21816     MOVE WS-OUTPUT-LINE TO REP2-OUT.                             
T21816     WRITE REP-OUT.                                               
T21816     WRITE REP2-OUT.                                              
T21816     MOVE 'OTHER' TO WS-OUTPUT-ZIP-GROUP.                         
T21816     MOVE WS-NUMBER-IN-OTHER TO WS-OUTPUT-REC-COUNT.              
T21816     MOVE WS-OUTPUT-LINE TO REP-OUT.                              
T21816     MOVE WS-OUTPUT-LINE TO REP2-OUT.                             
T21816     WRITE REP-OUT.                                               
T21816     WRITE REP2-OUT.                                              
T21816 8775-EXIT.                                                       
T21816     EXIT.                                                        
      *                                                                 04000005
T21861 8785-WRITE-INVALID.                                              
T21861     MOVE 'INVALID ZIP' TO WS-OUTPUT-ZIP-GROUP.                   
T21861     MOVE WS-NUMBER-IN-NONE TO WS-OUTPUT-REC-COUNT.               
T21861     MOVE WS-OUTPUT-LINE TO REP-OUT.                              
T21861     MOVE WS-OUTPUT-LINE TO REP2-OUT.                             
T21861     WRITE REP-OUT.                                               
T21861     WRITE REP2-OUT.                                              
T21861 8785-EXIT.                                                       
T21861     EXIT.                                                        
      *                                                                 04100005
       9000-TERMINATE.                                                  
           CLOSE MAILSTREAM-IN                                          
                 MAILSTREAM-OUT.                                        
           DISPLAY 'ACCOUNTS PROCESSED = ' WS-SEQUENCE-NO-TEMP.         
           STOP RUN.                                                    
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04180005
           EXEC SQL                                                     04190005
               INCLUDE CPD09900                                         04200005
           END-EXEC.                                                    04210005
