       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA710.                                        
       AUTHOR.         RICK SPIRES.                                     
       DATE-WRITTEN.   AUGUST, 2003.                                    
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      **                     PCSCA710 NARRATIVE                                 
      **                                                                        
      **  THIS PROGRAM EXTRACTS BILLING DATA FOR THE EDI810 BILLING             
C35152**  TABLES. THIS PROGRAM READS FCSBE28 TO PROCESS RECORDS                 
      **  TO BUILD THE EDI BILLING TABLES.                                      
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  08/29/03  R.SPIRES     WROTE PROGRAM                       **         
      **  10/20/03  R.SPIRES     FIX CHARGES INIT PROBLEM FOR GAS.   **         
RS0129**  01/29/04  R.SPIRES     FIX DATE PROBLEMS WITH USAGE.       **         
RS0305**  03/05/04  R.SPIRES     FIX REVERSED TOU 41 AND 42 VALUES.  **         
RS0629**  06/29/04  R.SPIRES     CORRECT TRANS CD ERROR.             **         
RS0716**  07/16/04  R.SPIRES     FIX TAX001 RECORDS ERROR.           **         
RS0927**  09/27/04  R.SPIRES     ADD ESTIMATE FLAG.                  **         
RS1215**  12/15/04  R.SPIRES     ADD ROLLBACK LOGIC.                 **         
RS0105**  01/11/05  R.SPIRES     CHECK "I" STATUS ON ACCT_DEST       **         
RS0105**  01/24/05  R.SPIRES     ALLOW NEGATIVE ENERGY CHARGES       **         
RS0205**  02/21/05  R.SPIRES     FIX LOW-VALUES IN CHRG DESC         **         
RS0421**  04/21/05  R.SPIRES     ADD MISC CHARGES TO CHARGES TBLE -  **         
RS0421**                         SERVICE CARE, PROJECT SHARE & HVAC. **         
RS0511**  05/11/05  R.SPIRES     STOP GETTING DPP PREVIOUS BALANCE.  **         
RS0512**  05/12/05  R.SPIRES     STOP GETTING DPP PREVIOUS BALANCE.  **         
RS0524**  05/24/05  R.SPIRES     CHECK EDI-ACCT BEFORE MASTER/SUB.   **         
RS0721**  07/21/05  R.SPIRES     SELECT ONLY "A" ACCTS FROM ACCT DEST**         
RS0727**  07/27/05  R.SPIRES     IGNORE OOB IF CHECKFREE ACCOUNT.    **         
RS0829**  08/29/05  R.SPIRES     Change charges table to pull therms.**         
C33146**  09/23/05  R.SPIRES     USE IC NO FOR TAX RECORDS - AVISTA  **         
C33146**  10/11/05  R.SPIRES     Capture BTU Factor.                 **         
C32211**  11/10/05  R.SPIRES     ADD DEPOSIT CODES FOR CHARGE TYPE.  **         
RS1216**  12/16/05  R.SPIRES     ALLOW USAGE CODE ON LPC AND PRB TO  **         
RS1216**                         ENSURE SAC02 AND SAC03 CONSISTENCY. **         
RS1228**  12/28/05  R.SPIRES     RELEASE CANCEL REBILLS PER LORI J   **         
RS0116**  01/16/06  R.SPIRES     PLUG USAGE CODE WHEN NOT IN VERBIAGE**         
RS0124**  01/24/06  R.SPIRES     ELIMINATE K4 USAGE CD WITH NO UNITS.**         
C33663**  02/15/06  R.SPIRES     RELEASE INVALID RATE HAS CSC REFUND.**         
C33527**  03/27/06  R.SPIRES     ADD ADDITIONAL CHECKS FOR RELEASE.  **         
C34112**  04/04/06  R.SPIRES     Plug util type E for Overhead lights**         
C34100**  04/13/06  R.SPIRES     Add type for shoulder on TOU meters **         
C34198**  04/27/06  R.SPIRES     Change IC to 1 for FRN001 for Norsou**         
C34100**  04/28/06  R.SPIRES     Correct shoulder logic on TOU meters**         
C34124**  05/08/06  R.SPIRES     Correct invalid REF records         **         
C32845**  05/09/06  R.SPIRES     Do not HOLD BellSouth Accounts.     **         
C34124**  05/16/06  R.SPIRES     Correct invalid REF records.        **         
C34124**  05/18/06  R.SPIRES     Correct usage cd for Overhead lites **         
C32845**  05/18/06  R.SPIRES     Do not HOLD BellSouth Accounts.     **         
RS0607**  06/07/06  R.SPIRES     Correct read date for Service Care. **         
C34456**  06/29/06  R.SPIRES     READ CSS_EDI_DEST FOR XML OR EDI IND**         
C34456**                         ADD COMMIT LOGIC. ADD WITH UR.      **         
C34456**  07/31/06  R.SPIRES     CHANGE LOGIC USING MODEL_SQL.       **         
C34456**  08/07/06  R.SPIRES     DELETE MODEL_SQL INCLUDE.           **         
C34456**  08/10/06  R.SPIRES     REPLACE DISTINCT SELECT.            **         
C34583**  02/01/07  R.SPIRES     Do not hold Checkfree Master Accts  **         
C34456**  07/24/07  R.SPIRES     Add COMMIT Logic                    **         
C36705**  01/17/08  R.SPIRES     Do not pass code_util_type for      **         
C36705**                         XML previous balance and LPC.       **         
C35152**  01/21/08  R.SPIRES     Converted to new bill print format. **         
C36867**  04/10/08  R.SPIRES     Add AGL account number              **         
ACT736**  03/16/09  R.SPIRES     Change time period default to spaces.*         
ACT736**  05/20/09  R.SPIRES     Correct Estimated reading indicator. *         
C00526**  11/16/09  R.SPIRES     Add Record Type 90 (AUTOCARD ENR).   *         
A01453**  12/21/09  DMS          Remove special characters from       *         
A01453**                         service address.                     *         
A02034**  03/04/10  VIJAY        Change RECORD ID OF WS-CONS-DET-REC  *         
A02034**  ACT026                 TO 004 AND WS-SP-ID-HDR-REC TO 005.  *         
PRJ243**  04/14/10  DMS          ADDED COPYBOOK FIOEXT04              *         
PRJ251**  05/10/10  R.SPIRES     STOP ABENDING WHEN INVALID REC TYPE. *         
A01749**  05/10/10  SDHAL        Pass DDDC factor to the EDI usage table        
P00496**  10/04/11  SV82012      EDI Changes for Industrial Enhancement         
P00496**                         project.                             *         
A03699**  01/18/12  SDHAL        Charges-desc field size increase     *         
A03511**  03/05/12  SDHAL        Rate Plan desc added to EDI Bill usage         
ACT090**  06/10/13  BD09555      Add charges for $0 if no other       *         
      **            A04527       process writes out the charges row   *         
ACT003**  07/14/13  DMS          A04897-Remove WS-CURRENT-CHGS-DUE-DATE         
A04880**  11/06/14  DB41297      CHECK HW-BEGIN-READ-DT = SPACES      *         
ACT286**                         MOVE CURRENT-DATE.                   *         
ACT123**  06/15/15  RS7M249      REMOVED UNUSED COPYBOOKS.            *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE28.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      ******************************************************************        
      * CFDBE28 - FD STATEMENT FOR A BILL PRINT FILE                   *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
C35152     RECORDING MODE IS F                                          
           DATA RECORD IS FCSBE28-DATA.                                 
       01  FCSBE28-DATA.                                                
C35152     05  FCSBE28-REC         PIC X OCCURS  1200 TIMES.            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA710'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-CSF-IO-AREA.                                              
C35152     05  SORT-KEY.                                                
C35152         10  LEVEL-1-SORT-FLDS.                                   
C35152             15  KEY-L1-COMP-NO           PIC 9(2).               
C35152         10  LEVEL-2-SORT-FLDS.                                   
C35152             15  KEY-L2-ACCOUNT-NO        PIC X(13).              
C35152             15  KEY-L2-DATE-BILLED       PIC X(10).              
C35152         10  LEVEL-3-SORT-FLDS.                                   
C35152             15  KEY-L3-REC-SEQ           PIC X(3).               
C35152             15  KEY-L3-RECORD-ID         PIC X(10).              
C35152             15  KEY-L3-TIE-BREAKER       PIC 9(4).               
C35152         10  LEVEL-4-SORT-FLDS.                                   
C35152             15  KEY-L4-SUB-ACCOUNT       PIC X(13).              
C35152             15  KEY-L4-SUB-DATE-BILLED   PIC X(10).              
           05  WS-BE28-DATA                     PIC X(1200).            
       COPY FIOEXT01.                                                           
       COPY FIOEXT02.                                                           
       COPY FIOEXT03.                                                           
PRJ243 COPY FIOEXT04.                                                           
       COPY FIOEXT05.                                                           
C35152 COPY FIOEXT08.                                                           
C35152 COPY FIOEXT09.                                                           
       COPY FIOEXT10.                                                           
       COPY FIOEXT14.                                                           
       COPY FIOEXT15.                                                           
       COPY FIOEXT16.                                                           
       COPY FIOEXT21.                                                           
       COPY FIOEXT22.                                                           
                                                                        
       01  WS-MISC.                                                     
           05  SUB1                         PIC 9(3) VALUE 0.           
           05  SUB2                         PIC 9(3) VALUE 0.           
           05  DESC-SUB                     PIC S9(4)  COMP VALUE +0.   
           05  USE-SUB                      PIC S9(4)  COMP VALUE +0.   
C36867     05  AGL-SUB                      PIC S9(4)  COMP VALUE +0.   
C36867     05  AGL-SUB2                     PIC S9(4)  COMP VALUE +0.   
           05  WS-LEN                       PIC 9(4)   COMP.            
           05  WS-COMMIT-CNT                PIC S9(4)   COMP VALUE +0.  
           05  WS-HOLD-ACCOUNT-LEN          PIC 9(4)   COMP.            
           05  WS-HOLD-BILL-LEN             PIC 9(4)   COMP.            
           05  WS-HOLD-LP-HDR-LEN           PIC 9(4)   COMP.            
           05  WS-HOLD-LP-SUM-LEN           PIC 9(4)   COMP.            
           05  WS-HOLD-LP-STMT-LEN          PIC 9(4)   COMP.            
           05  WS-HOLD-BILL-DEST-CODE       PIC X      VALUE SPACES.    
           05  WS-FBE28-STATUS              PIC XX     VALUE '  '.      
               88  FBE28-SUCCESSFUL                    VALUE '00'.      
               88  FBE28-READ-OK                       VALUE '00' '04'. 
           05  WS-PARSE-STATUS              PIC X      VALUE ' '.       
               88  USE-PARSED                          VALUE 'U'.       
               88  TYPE-FND                            VALUE 'T'.       
           05  WS-CHG-USAGE                 PIC X(09)  VALUE SPACES.    
           05  WS-CHG-USAGE-N               PIC 9(09)  VALUE ZEROS.     
           05  WS-PREV-ACCOUNT-NO           PIC X(13)  VALUE SPACES.    
           05  WS-FCSBE28-CNTR              PIC S9(7) COMP-3 VALUE +0.  
           05  WS-CUR-TS                    PIC  X(26) VALUE SPACES.    
           05  WS-CUR-DATE                  PIC  X(10) VALUE SPACES.    
           05  WS-SCHED-SEND-DATE           PIC  X(10) VALUE SPACES.    
           05  WS-F04-DATE.                                             
               10 WS-F04-MONTH              PIC  X(03).                 
               10 FILLER                    PIC  X(01).                 
               10 WS-F04-DAY                PIC  X(02).                 
           05  WS-RET-DATE                  PIC  X(10) VALUE SPACES.    
RS0129     05  WS-RET-DATE-R REDEFINES WS-RET-DATE.                     
RS0129         10  WS-RET-DATE-YR-N         PIC  9(04).                 
           05  WS-PGRMNAME                  PIC  X(08) VALUE 'PCSCA710'.
           05  PROGRAM-NAME                 PIC  X(08) VALUE 'PCSCA710'.
A01453     05  WS-SPEC-CHARS.                                           
A01453         10  SPEC-CHAR1               PIC  X(14) VALUE            
A01453          '<>%*~(|)/@{}\'.                                       
A01453         10  SPEC-CHAR2               PIC  X(01) VALUE '"'.       
A01453         10  SPEC-CHAR3               PIC  X(01) VALUE "'".       
A01453     05  WS-CONVERT-FROM REDEFINES WS-SPEC-CHARS PIC X(16).       
A01453     05  WS-CONVERT-TO                PIC  X(16) VALUE SPACES.    
                                                                        
       01  WS-SWITCHES.                                                 
ACT090     05  WS-CHARGES-SW                   PIC  X(01) VALUE SPACES. 
ACT090         88  CHARGES-NOT-WRITTEN                    VALUE 'N'.    
           05  WS-PROCESS-TYPE-SW              PIC  X(01) VALUE SPACES. 
               88  PROCESS-HEADER                         VALUE 'H'.    
               88  PROCESS-DETAIL                         VALUE 'D'.    
           05  WS-PROCESS-TYPE-SW2             PIC  X(01) VALUE SPACES. 
               88  PROCESS-USAGE                          VALUE 'U'.    
               88  PROCESS-CHARGES                        VALUE 'C'.    
           05  WS-PROCESS-BCD-SW               PIC  X(01) VALUE SPACES. 
               88  START-BCD                              VALUE 'S'.    
               88  END-BCD                                VALUE 'E'.    
           05  WS-END-REC-SW                   PIC  X(01).              
               88  WS-END-REC-PROCESSED                   VALUE 'Y'.    
               88  WS-END-REC-NOT-PROCESSED               VALUE 'N'.    
           05  WS-EPP-SW                       PIC X      VALUE 'N'.    
               88  EPP-ACCT                               VALUE 'Y'.    
               88  NON-EPP-ACCT                           VALUE 'N'.    
           05  WS-EDI-SW                       PIC X      VALUE 'N'.    
               88  EDI-ACCT                               VALUE 'Y'.    
               88  NON-EDI-ACCT                           VALUE 'N'.    
RS0727     05  WS-CKF-SW                       PIC X      VALUE 'N'.    
RS0727         88  CKF-ACCT                               VALUE 'Y'.    
RS0727         88  NON-CKF-ACCT                           VALUE 'N'.    
           05  WS-END-OF-BE28                  PIC X      VALUE 'N'.    
               88  END-OF-BE28                            VALUE 'Y'.    
           05  WS-ACCOUNT-CHANGE-SW            PIC X      VALUE 'N'.    
               88  ACCOUNT-CHANGE                         VALUE 'Y'.    
           05  WS-PROCESS-SW                   PIC 9(01)  VALUE 1.      
               88  PROCESS-CSR                            VALUE 1.      
               88  PROCESS-SEB                            VALUE 2.      
           05  WS-SUB-AMT-SW                   PIC 9(01)  VALUE 0.      
               88  SUB-AM-EQ                              VALUE 1.      
               88  SUB-AM-NE                              VALUE 2.      
           05  WS-DUP-IND                      PIC X(01)  VALUE 'N'.    
               88  WS-Y                                   VALUE 'Y'.    
               88  WS-N                                   VALUE 'N'.    
           05  WS-REV-IND                      PIC X(01)  VALUE 'B'.    
               88  GET-BILL-WINDOW                        VALUE 'B'.    
               88  GET-JOB-PARM                           VALUE 'J'.    
           05  WS-TOU-IND                      PIC X(01)  VALUE 'N'.    
               88  TOU-ACCT                               VALUE 'T'.    
               88  NON-TOU-ACCT                           VALUE 'N'.    
C34456     05  WS-FORMAT-TYPE                  PIC X(01)  VALUE ' '.    
C34456         88  XML-FORMAT                             VALUE 'X'.    
C34456         88  EDI-FORMAT                             VALUE 'E'.    
           05  WS-MORE-BEGIN-REC               PIC X      VALUE 'N'.    
                                                                        
       01  WS-HOLD-AREA.                                                
           05  WS-HOLD-ACCOUNT-NO              PIC X(13).               
COB305     05 WS-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.      
COB305     05 WS-SUB-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.      
           05  WS-MST-SUB-IND                  PIC X(01).               
           05  WS-BILL-DEST-CD-02              PIC X(01).               
           05  WS-BILL-DEST-CD-29              PIC X(01).               
           05  WS-BILL-DATE                    PIC X(08).               
           05  WS-MS-FLAG                      PIC X(01).               
               88 WS-SUB                           VALUE 'S'.           
               88 WS-MASTER                        VALUE 'M'.           
           05  WS-FB-FLAG                      PIC X(01).               
           05  WS-RB-FLAG                      PIC X(01).               
           05  WS-XFER-TO-ACCT                 PIC X(13).               
           05  WS-METER-NO                     PIC X(09).               
           05  WS-BILL-TYPE                    PIC X(01).               
           05  WS-IC-FLAG                      PIC X(01).               
           05  WS-DBA-NAME                     PIC X(50).               
           05  WS-CUST-NAME                    PIC X(50).               
C33146     05  WS-DEST-ID                      PIC X(10).               
           05  WS-SERV-LINE1                   PIC X(50).               
           05  WS-SERV-LINE2                   PIC X(50).               
           05  WS-SERV-LINE3                   PIC X(50).               
COB305     05 WS-CURR-AMT-DUE        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-PREV-BILL-AMT                PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-PYMTS                        PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-SUM-CHRGS                    PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-SUM-AMT-DUE                  PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-TOT-MST-BILL                 PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-TOT-SUB-BILL                 PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
           05  WS-SUB-AMT                      PIC S9(9)V99 COMP-3      
                                                   VALUE ZERO.          
COB305     05 WS-TOTAL-AMT-DUE        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-TOTAL-DUE-DATE               PIC X(10).               
           05  WS-IB-ST-DATE                   PIC X(6).                
           05  WS-IB-END-DATE                  PIC X(6).                
           05  WS-PULL-CODE                    PIC X.                   
           05  WS-HOLD-DAYS                    PIC S9(3).               
           05  WS-PARM-COMP-NO                 PIC X(02).               
           05  WS-BILL-NO                      PIC 9(9).                
           05  WS-RATE-PLAN-NO                 PIC XXX.                 
           05  WS-CODE-UTIL-TYPE               PIC X.                   
           05  WS-SAVE-CODE-UTIL-TYPE          PIC X.                   
           05  WS-MULTI-METER                  PIC X.                   
RS0927     05  WS-EST-IND                      PIC X.                   
           05  WS-IC-NO                        PIC S9(4) COMP.          
COB305     05 WS-BILL-UNITS        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-BTU-FACTOR        PIC S9(2)V9(5) COMP-3 VALUE 0.   
COB305     05 WS-THERM-USAGE        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-DDDC-FACTOR        PIC S9(8)V999 COMP-3 VALUE 0.    
A03511     05  WS-EDI-RATE-DESC                PIC X(80).               
A03511     05  WS-EDI-RATE-DESC-EXT            PIC X(80).               
COB305     05 WS-BILLED-AM        PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05  WS-CHARGE-TYPE                  PIC X(10).               
           05  WS-HF-SEQ                       PIC S9(4) COMP.          
           05  WS-HW-SEQ                       PIC S9(4) COMP.          
           05  WS-MISC-SEQ                     PIC 9(03) VALUE 1.       
           05  WS-MISC-SEQ-X REDEFINES WS-MISC-SEQ                      
                                               PIC X(03).               
COB305     05 WS-TOT-CUR-CHRG        PIC S9(9)V9(2) COMP-3 VALUE 0.   
COB305     05 WS-BAL-BR-FWD        PIC S9(9)V9(2) COMP-3 VALUE 0.   
COB305     05 WS-TOT-AMT-DUE        PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05  WS-USAGE-CD                     PIC X(02).               
A03699     05  WS-CHARGE-DESC                  PIC X(255).              
           05  WS-MS-IND                       PIC X.                   
COB305     05 WS-ADDRESS-ID        PIC S9(13)V COMP-3 VALUE 0.   
           05  WS-ZIP-CODE.                                             
               10  WS-ZIP-CODE1                PIC X(05).               
               10  WS-ZIP-CODE-PLUS-FOUR       PIC X(04).               
           05  WS-CITY                         PIC X(26).               
           05  WS-STATE                        PIC X(02).               
           05  WS-CYCLE                        PIC X(02).               
           05  WS-STATUS-CD                    PIC X(01).               
           05  WS-REV-MO                       PIC 9(06).               
           05  WS-REV-MO-X REDEFINES WS-REV-MO PIC X(06).               
           05  WS-DATE-BILLED                  PIC X(10).               
           05  WS-DATE-START                   PIC X(10).               
           05  WS-DATE-END                     PIC X(10).               
C36867     05  WS-AGL-ACCT-NO                  PIC X(20).               
A01453     05  WS-HOLD-SERV-LINE               PIC X(50).               
                                                                        
      *************************************************************     00000100
      * This Copybook contains all the Record Seq numbers and     *     00000200
      * Record ids used in the File Layout for Dialogue.          *     00000300
      *************************************************************     00000400
                                                                        
       01 WS-EXT-FIELDS.                                                
      *                                                                 00000700
          05  WS-EXT-RECORD-SEQ             PIC X(03).                  
              88  WS-ACCOUNT-REC                VALUE '001'.            
              88  WS-BILL-REC                   VALUE '002'.            
              88  WS-CONS-HDR-REC               VALUE '003'.            
A02034        88  WS-CONS-DET-REC               VALUE '004'.            
A02034        88  WS-SP-ID-HDR-REC              VALUE '005'.            
              88  WS-LPRINT-STMT-REC            VALUE '006'.            
              88  WS-LPRINT-SUM-REC             VALUE '007'.            
              88  WS-ELEC-IC-REC                VALUE '008'.            
              88  WS-GAS-IC-REC                 VALUE '011'.            
              88  WS-ELEC-METER-REC             VALUE '009'.            
              88  WS-ELEC-CHARGES-REC           VALUE '010'.            
              88  WS-GAS-CHARGES-REC            VALUE '013'.            
              88  WS-GAS-METER-REC              VALUE '012'.            
              88  WS-INSTALL-DET-REC            VALUE '014'.            
              88  WS-MISC-CHG-DET-REC           VALUE '015'.            
              88  WS-DPP-HDR-REC                VALUE '016'.            
              88  WS-DPP-DET-REC                VALUE '017'.            
              88  WS-EPP-HDR-REC                VALUE '018'.            
              88  WS-EPP-DET-REC                VALUE '019'.            
              88  WS-EPP-MU-DET-REC             VALUE '020'.            
              88  WS-BILL-SUM-DET-REC           VALUE '021'.            
              88  WS-STMT-DET-REC               VALUE '022'.            
              88  WS-IMP-NOTICE-REC             VALUE '023'.            
              88  WS-SPECIAL-MSG-REC            VALUE '023'.            
              88  WS-TBL-MSG-DET-REC            VALUE '023'.            
              88  WS-LIT-MSG-REC                VALUE '023'.            
              88  WS-EPP-ANNIV-HDR-REC          VALUE '024'.            
              88  WS-EPP-ANNIV-DET-REC          VALUE '025'.            
              88  WS-CREDIT-LETTER-REC          VALUE '026'.            
              88  WS-ADDL-DET-REC               VALUE '027'.            
              88  WS-ELEC-DEM-IC-REC            VALUE '028'.            
              88  WS-ELEC-DEM-METER-REC         VALUE '029'.            
              88  WS-ELEC-DEM-CHARGES-REC       VALUE '030'.            
              88  WS-WHSL-IC-REC                VALUE '031'.            
              88  WS-WHSL-METER-REC             VALUE '032'.            
              88  WS-SEPA-ADJUST-REC            VALUE '033'.            
              88  WS-WHSL-CHARGES-REC           VALUE '034'.            
              88  WS-TOU-NON-DEM-IC-REC         VALUE '035'.            
              88  WS-TOU-NON-METER-REC          VALUE '036'.            
              88  WS-TOU-NON-CHARGES-REC        VALUE '037'.            
              88  WS-TOU-DEM-IC-REC             VALUE '038'.            
              88  WS-TOU-DEM-METER-REC          VALUE '039'.            
              88  WS-TOU-DEM-SUM-REC            VALUE '040'.            
              88  WS-TOU-DEM-CHARGES-REC        VALUE '041'.            
              88  WS-RTP-IC-REC                 VALUE '042'.            
              88  WS-RTP-METER-REC              VALUE '043'.            
              88  WS-RTP-DEM-SUM-REC            VALUE '044'.            
              88  WS-RTP-BASE-CHG-REC           VALUE '045'.            
              88  WS-RTP-CHG-REC                VALUE '046'.            
              88  WS-MUNI-IC-REC                VALUE '047'.            
              88  WS-MUNI-CHARGES-REC           VALUE '048'.            
              88  WS-NON-MUNI-IC-REC            VALUE '049'.            
              88  WS-NON-MUNI-METER-REC         VALUE '050'.            
              88  WS-NON-MUNI-CHARGES-REC       VALUE '051'.            
              88  WS-STMT-ADJ                   VALUE '052'.            
C00526        88  WS-AUTOCARD-REC               VALUE '090'.            
              88  WS-SUB-HDR                    VALUE '094'.            
              88  WS-SUB-IC-REC                 VALUE '095'.            
              88  WS-SUB-METER-REC              VALUE '096'.            
              88  WS-SUB-CHARGES-REC            VALUE '097'.            
              88  WS-BNKDRFT-REC                VALUE '098'.            
              88  WS-DUMMY-REC                  VALUE '099'.            
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-DUE-NI          PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-READ-NI         PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-START-NI        PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-END-NI          PIC S9(4) COMP VALUE 0.          
           05  WS-SUB-ACCT-NI          PIC S9(4) COMP VALUE 0.          
           05  WS-NI                   PIC S9(4) COMP VALUE 0.          
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-USERABEN             PIC X(08)     VALUE 'USERABEN'.  
           05  WS-1                    PIC 9(01)     VALUE 1.           
           05  WS-ONE                  PIC S9(04)    VALUE +1 COMP.     
           05  WS-FIFTY                PIC S9(04)    VALUE +50 COMP.    
           05  WS-TWO-FIFTY            PIC S9(04)    VALUE +250 COMP.   
                                                                        
       COPY CWS00038.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
                                                                        
A03511 01  WS-11-TABLES.                                                
A03511     05  WS-EMB-INPUT.                                            
A03511         10  WS-EMB-CHAR         PIC X(01)                        
A03511                                 OCCURS 255 TIMES                 
A03511                                 INDEXED BY WS-EMB-INDX.          
A03511     05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.           
A03511     05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.           
A03511     05  WS-EMB-LAST-CHAR        PIC X(01).                       
A03511     05  WS-CMP-TABLE.                                            
A03511         10  WS-CMP-CHAR         PIC X(01)                        
A03511                                 OCCURS 255 TIMES                 
A03511                                 INDEXED BY WS-CMP-INDX.          
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * WS FOR DATE ROUTINES                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00018                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * WS FOR DATE ROUTINES                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ADDR_FORMATTED                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ADDR_FREEFORM                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_ACCT_DEST                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACDEST                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCT_BILL_NMES                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_HDR                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBILHDR                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_USAGE                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLUSGE                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_CHRGS                                            *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCHGS                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_WINDOW                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_DELINQUENCY                                              *          
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
C34456*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C34456* CSS_EDI_DEST                                                            
C34456*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C34456                                                                  
C34456     EXEC SQL                                                             
C34456         INCLUDE TBEDIDES                                                 
C34456     END-EXEC.                                                            
C34456                                                                  
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_HOLIDAY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHLDAY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_MTRD_ENVRNMT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_NAME                                                                
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PREMISE                                                             
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ZIP_CODE                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  PERFORM THE INITIALIZATION ROUTINE.  READ THE FIRST RECORD   *         
      *  FROM THE INPUT FILE, WHICH MUST BE THE BEGINNING CONTROL     *         
      *  RECORD (KEY OF LOW VALUES).  WRITE THIS CONTROL RECORD TO    *         
      *  THE NON-EXCEPTION ACCOUNT (BE28).                            *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
                                                                        
           PERFORM 0200-PROCESS-BEGIN-REC THRU 0200-EXIT.               
                                                                        
           MOVE EXT-BILL-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO.              
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT UNTIL           
             END-OF-BE28.                                               
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.                                                  *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSBE28-FILE.                                     
           IF WS-FBE28-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBE28'                     
               DISPLAY '**   FILE STATUS = ' WS-FBE28-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
      *****************************************************************         
      * CHECK CSS_DELINQUENCY TABLE TO DETERMINE IF SCEG/PSNC OR SEB  *         
      * ACCOUNT --                                                    *         
      *****************************************************************         
      *                                                                         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           MOVE WS-PARM-COMP-NO               TO C8-COMPANY-NO.         
           PERFORM 7400-CALL-DELIQUENCY       THRU 7400-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-1                       TO WS-PROCESS-SW          
           ELSE                                                         
              MOVE C8-DELINQ-VALUE            TO WS-PROCESS-SW          
           END-IF.                                                      
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  MAKE SURE THE FIRST RECORD OF THE INPUT FILE IS A       *              
      *  BEGINNING CONTROL RECORD (KEY = LOW-VALUES).  THERE CAN *              
      *  BE MORE THAN ONE BEGINNING CONTROL RECORD.              *              
      ************************************************************              
                                                                        
       0200-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7000-READ-FCSBE28 THRU 7000-EXIT.                    
           IF END-OF-BE28                                               
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '********************************'               
               DISPLAY '** PCSCA710 PROCESSING ERROR  **'               
               DISPLAY '**   FCSBE28 FILE IS EMPTY    **'               
               DISPLAY '**   PROCESSING TERMINATED    **'               
               DISPLAY '********************************'               
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * WRITE COMPANY REC TO NON-EXCEPTION FILE.  IF DEST CODE IS   *           
      * GREATER THAN SPACES ON ACCOUNT REC OR BILL REC, WRITE ALL   *           
      * RECORDS FOR ACCOUNT TO EXCEPTION FILE (BE41).               *           
      ***************************************************************           
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           MOVE KEY-L3-REC-SEQ    TO WS-EXT-RECORD-SEQ.                 
                                                                        
           EVALUATE TRUE                                                
      *****************************************************                     
      *  001 Account Record                                                     
      *****************************************************                     
               WHEN WS-ACCOUNT-REC                                      
                 IF EDI-ACCT                                            
                    COMPUTE WS-BAL-BR-FWD = WS-PREV-BILL-AMT +          
                                            WS-PYMTS                    
                    IF WS-BAL-BR-FWD NOT EQUAL ZERO                     
                       MOVE WS-BAL-BR-FWD     TO WS-BILLED-AM           
                       MOVE 'Balance Brought Forward'                   
                                              TO WS-CHARGE-DESC         
                       MOVE 'PRB002'          TO WS-CHARGE-TYPE         
                       SET  PROCESS-CHARGES   TO TRUE                   
                       PERFORM 2000-PROCESS-EDI THRU 2000-EXIT          
                    END-IF                                              
                    COMPUTE WS-SUM-AMT-DUE = WS-BAL-BR-FWD +            
                                             WS-SUM-CHRGS               
                    IF WS-TOT-AMT-DUE NOT EQUAL WS-SUM-AMT-DUE          
                    AND NON-EPP-ACCT                                    
RS0727              AND NON-CKF-ACCT                                    
                       MOVE 'H'               TO WS-STATUS-CD           
                       PERFORM 8350-UPD-EDI-HDR                         
                                              THRU 8350-EXIT            
                       DISPLAY 'ACCOUNT NO = ' WS-HOLD-ACCOUNT-NO       
                       DISPLAY 'BILL NO    = ' WS-BILL-NO               
                       DISPLAY 'SYSTEM AMT DUE = ' WS-TOT-AMT-DUE       
                       DISPLAY 'CHARGES PROCESSED = ' WS-SUM-AMT-DUE    
                    END-IF                                              
                 END-IF                                                 
      *   This code is executed even if this is not an edi account              
                   INITIALIZE                 WS-SWITCHES               
                   SET PROCESS-HEADER         TO TRUE                   
                   SET START-BCD              TO TRUE                   
                   SET NON-EPP-ACCT           TO TRUE                   
ACT090             SET CHARGES-NOT-WRITTEN    TO TRUE                   
                   MOVE SPACES                TO WS-HOLD-AREA           
A03511             MOVE SPACES                TO WS-EDI-RATE-DESC       
A03511             MOVE SPACES                TO WS-EDI-RATE-DESC-EXT   
A03511             MOVE SPACES                TO WS-EMB-INPUT           
                   MOVE ZEROS                 TO WS-CURR-AMT-DUE        
                   MOVE ZEROS                 TO WS-BAL-BR-FWD          
                   MOVE ZEROS                 TO WS-PREV-BILL-AMT       
                   MOVE ZEROS                 TO WS-PYMTS               
                   MOVE ZEROS                 TO WS-SUM-CHRGS           
                   MOVE ZEROS                 TO WS-SUM-AMT-DUE         
                   MOVE ZEROS                 TO WS-TOTAL-AMT-DUE       
                   MOVE ZEROS                 TO WS-BILL-NO             
                   MOVE ZEROS                 TO WS-IC-NO               
                   MOVE ZEROS                 TO WS-BILL-UNITS          
RS0829             MOVE ZEROS                 TO WS-THERM-USAGE         
                   MOVE ZEROS                 TO WS-BILLED-AM           
                   MOVE ZEROS                 TO WS-TOT-CUR-CHRG        
                   MOVE ZEROS                 TO WS-BAL-BR-FWD          
                   MOVE ZEROS                 TO WS-TOT-AMT-DUE         
                   MOVE ZEROS                 TO WS-SUB-ACCT-NO         
                   MOVE ZEROS                 TO WS-REV-MO              
                   MOVE ZEROS                 TO WS-DATE-DUE-NI         
                   MOVE ZEROS                 TO WS-DATE-READ-NI        
                   MOVE ZEROS                 TO WS-DATE-START-NI       
                   MOVE ZEROS                 TO WS-DATE-END-NI         
                   MOVE ZEROS                 TO WS-SUB-ACCT-NI         
                   MOVE ZEROS                 TO WS-DDDC-FACTOR         
C33146             MOVE +1.0                  TO WS-BTU-FACTOR          
                   MOVE WS-ONE                TO WS-HF-SEQ              
                                                 WS-HW-SEQ              
                                                 WS-MISC-SEQ            
C34456*****************************************************************         
C34456*  This commit added 7/26.                                                
C34456*****************************************************************         
C34456             ADD WS-ONE                 TO WS-COMMIT-CNT          
C34456             IF WS-COMMIT-CNT > WS-TWO-FIFTY                      
C34456                PERFORM 8700-COMMIT     THRU 8700-EXIT            
C34456                MOVE ZERO               TO WS-COMMIT-CNT          
C34456             END-IF                                               
C35152             MOVE WS-BE28-DATA              TO EXT-ACCT-REC       
                   MOVE EXT-ACCT-ACCOUNT-NO       TO WS-HOLD-ACCOUNT-NO 
                   MOVE EXT-ACCT-BILL-DEST-CODE   TO WS-BILL-DEST-CD-29 
                   MOVE EXT-ACCT-BILL-DATE        TO WS-DATE-BILLED     
                   MOVE EXT-ACCT-MASTER-SUB-FLAG  TO WS-MS-FLAG         
                   MOVE EXT-ACCT-FINAL-BILL-FLAG  TO WS-FB-FLAG         
                   MOVE EXT-ACCT-REBILL-FLAG      TO WS-RB-FLAG         
                   MOVE EXT-ACCT-XFER-TO-ACCOUNT  TO WS-XFER-TO-ACCT    
                   MOVE EXT-ACCT-BILL-TYPE        TO WS-BILL-TYPE       
                   MOVE EXT-ACCT-BILL-CYCLE       TO WS-CYCLE           
C36867             IF EXT-ACCT-AGL-ACCOUNT-NO > ZEROS                   
C36867                PERFORM 4100-PARSE-AGL-ACCT-NO                    
C36867                                            THRU 4100-EXIT        
C36867             ELSE                                                 
C36867                MOVE SPACES                 TO WS-AGL-ACCT-NO     
C36867             END-IF                                               
                   PERFORM 3000-PROCESS-ACCTS     THRU 3000-EXIT        
      *****************************************************************         
      *  002 - Bill Record                                                      
      *****************************************************************         
               WHEN WS-BILL-REC                                         
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA              TO EXT-BILL-REC       
                   MOVE EXT-BILL-BILL-DEST-CODE   TO WS-BILL-DEST-CD-02 
                   MOVE EXT-BILL-PULL-CODE        TO WS-PULL-CODE       
A01453             MOVE EXT-BILL-SERVICE-LINE-1   TO WS-HOLD-SERV-LINE  
A01453             PERFORM 4200-REMOVE-SPECIAL-CHARS THRU 4200-EXIT     
A01453             MOVE WS-HOLD-SERV-LINE         TO WS-SERV-LINE1      
A01453             MOVE EXT-BILL-SERVICE-LINE-2   TO WS-HOLD-SERV-LINE  
A01453             PERFORM 4200-REMOVE-SPECIAL-CHARS THRU 4200-EXIT     
A01453             MOVE WS-HOLD-SERV-LINE         TO WS-SERV-LINE2      
                   MOVE EXT-BILL-CUST-NAME        TO WS-CUST-NAME       
                   MOVE EXT-BILL-CURRENT-AMT      TO WS-CURR-AMT-DUE    
                   MOVE EXT-BILL-TOTAL-AMT        TO WS-TOT-AMT-DUE     
                   MOVE EXT-BILL-TOTAL-DUE-DATE   TO WS-TOTAL-DUE-DATE  
C35152             MOVE EXT-BILL-TOTAL-CURR-CHARGES                     
C35152                                            TO WS-TOT-CUR-CHRG    
C35152             MOVE EXT-BILL-BAL-BROUGHT-FWD  TO WS-BAL-BR-FWD      
C35152             MOVE EXT-BILL-TOTAL-AMT-DUE    TO WS-TOT-AMT-DUE     
                   MOVE EXT-BILL-BILL-NO          TO WS-BILL-NO         
      ** Check header table for dups for acct and bill number                   
                   PERFORM 3500-CHK-DUP-ACCTS     THRU 3500-EXIT        
      ** Check deposit information                                              
                   IF EDI-ACCT                                          
                     IF EXT-BILL-DEPOSIT-AMT > ZERO                     
                        ADD  EXT-BILL-DEPOSIT-AMT TO WS-SUM-CHRGS       
                        MOVE EXT-BILL-DEPOSIT-AMT TO WS-BILLED-AM       
                        MOVE 'DEPOSIT'            TO WS-CHARGE-DESC     
                        MOVE 'MSC001'             TO WS-CHARGE-TYPE     
                        SET  PROCESS-CHARGES      TO TRUE               
                        PERFORM 2000-PROCESS-EDI  THRU 2000-EXIT        
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
      *****************************************************************         
      *  003 - Consolidated Header Record                                       
      *****************************************************************         
               WHEN WS-CONS-HDR-REC                                     
                 IF EDI-ACCT                                            
                   MOVE ZEROS                 TO WS-TOT-SUB-BILL        
                 END-IF                                                 
      *****************************************************************         
      *  004 - Consolidated Detail Record                                       
      *****************************************************************         
               WHEN WS-CONS-DET-REC                                     
                 IF EDI-ACCT                                            
                   SET WS-MASTER              TO TRUE                   
                   MOVE WS-BE28-DATA          TO EXT-CONS-DTL-REC       
                   MOVE EXT-CDTL-SUB-ACCOUNT-NO                         
                                              TO WS-SUB-ACCT-NO         
                   ADD EXT-CDTL-SUB-CURRENT-BILL-AMT                    
                                              TO WS-TOT-SUB-BILL        
                   MOVE EXT-CDTL-SUB-CURRENT-BILL-AMT                   
                                              TO WS-SUB-AMT             
                   MOVE EXT-CDTL-SUB-CURRENT-BILL-AMT                   
                                              TO WS-BILLED-AM           
      * OFFSETS NEGATIVE TRANSFER FOR SUB-ACCOUNT                               
                   MOVE 'MST'                 TO WS-CHARGE-DESC         
                   MOVE 'MSC001'              TO WS-CHARGE-TYPE         
                   SET  PROCESS-CHARGES       TO TRUE                   
                   PERFORM 2000-PROCESS-EDI   THRU 2000-EXIT            
                   PERFORM 7950-CHK-SUB-AMT   THRU 7950-EXIT            
                   IF SUB-AM-EQ                                         
                     MOVE 'R'                 TO WS-STATUS-CD           
                     PERFORM 8300-UPD-EDI-HDR THRU 8300-EXIT            
                   END-IF                                               
                 END-IF                                                 
      *****************************************************************         
      *  008 - Electric Header Record                                           
      *  011 - Gas Header Record                                                
      *  028 - Electric Demand Header Record                                    
      *  031 - Wholesale Header Record                                          
      *  035 - TOU Non Demand Header Record                                     
      *  038 - TOU Demand Header Record                                         
      *  042 - RTP-Header Record                                                
      *  047 - Muni Lites Header Record                                         
      *  049 - Non Muni Lites Header Record                                     
      *****************************************************************         
               WHEN WS-ELEC-IC-REC                                      
               WHEN WS-GAS-IC-REC                                       
               WHEN WS-ELEC-DEM-IC-REC                                  
               WHEN WS-WHSL-IC-REC                                      
               WHEN WS-TOU-NON-DEM-IC-REC                               
               WHEN WS-TOU-DEM-IC-REC                                   
               WHEN WS-RTP-IC-REC                                       
               WHEN WS-MUNI-IC-REC                                      
               WHEN WS-NON-MUNI-IC-REC                                  
                 IF EDI-ACCT                                            
                   MOVE WS-BE28-DATA          TO EXT-IC-HDR-REC         
                   MOVE EXT-IC-HDR-PUB-RATE-PLAN-NO                     
                                              TO WS-RATE-PLAN-NO        
                   MOVE EXT-IC-HDR-CODE-UTIL-TYPE                       
                                              TO WS-CODE-UTIL-TYPE      
                   MOVE EXT-IC-HDR-MULTI-METER TO WS-MULTI-METER        
                   MOVE EXT-IC-HDR-IC-NUMBER  TO WS-IC-NO               
                   MOVE EXT-IC-HDR-BTU-FACTOR TO WS-BTU-FACTOR          
ACT736             IF EXT-IC-HDR-CODE-METER-READ = 'E'                  
                      MOVE 'E'                TO WS-EST-IND             
                   END-IF                                               
A01749             IF WS-GAS-IC-REC                                     
A01749                MOVE EXT-IC-HDR-DESIGN-DAY-CAPACITY               
A01749                                        TO WS-DDDC-FACTOR         
A03511                MOVE  EXT-IC-HDR-OPTION-DESC                      
A03511                                        TO WS-EDI-RATE-DESC       
A03511                INSPECT WS-EDI-RATE-DESC                          
A03511                     CONVERTING "<>~*&#;"                         
A03511                     TO         "       "                         
A03511                STRING EXT-IC-HDR-RATE-MSG-LINE1                  
A03511                     EXT-IC-HDR-RATE-MSG-LINE2                    
A03511                     EXT-IC-HDR-RATE-MSG-LINE3 DELIMITED BY SIZE  
A03511                                        INTO WS-EDI-RATE-DESC-EXT 
A03511                END-STRING                                        
A03511                INSPECT WS-EDI-RATE-DESC-EXT                      
A03511                     CONVERTING "<>~*&#;"                         
A03511                     TO         "       "                         
A03511                MOVE SPACES TO WS-EMB-INPUT                       
A03511                               WS-CMP-TABLE                       
A03511                MOVE 80 to WS-EMB-LENG                            
A03511                MOVE WS-EDI-RATE-DESC-EXT TO WS-EMB-INPUT         
A03511                PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT
A03511                MOVE WS-CMP-TABLE TO WS-EDI-RATE-DESC-EXT         
A01749             END-IF                                               
                 END-IF                                                 
      *****************************************************************         
      *  009 - Electric Meter Record                                            
      *  012 - Gas Meter Record                                                 
      *  029 - Electric Demand Header Record                                    
      *  032 - Wholesale Meter Record                                           
      *  036 - TOU Non Demand Meter Record                                      
      *  039 - TOU Demand Meter Record                                          
      *  043 - RTP-Meter Record                                                 
      *  050 - Non Muni Lites Meter Record                                      
      *****************************************************************         
               WHEN WS-ELEC-METER-REC                                   
               WHEN WS-ELEC-DEM-METER-REC                               
               WHEN WS-WHSL-METER-REC                                   
               WHEN WS-TOU-NON-METER-REC                                
               WHEN WS-TOU-DEM-METER-REC                                
               WHEN WS-GAS-METER-REC                                    
               WHEN WS-RTP-METER-REC                                    
               WHEN WS-NON-MUNI-METER-REC                               
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-IC-MTR-REC         
                   SET PROCESS-USAGE          TO TRUE                   
                   PERFORM 2000-PROCESS-EDI                             
                      THRU 2000-EXIT                                    
                 END-IF                                                 
      *****************************************************************         
      *  010 - Electric Charges Record                                          
      *  012 - Gas Charges Record                                               
      *  030 - Electric Demand Charges Record                                   
      *  034 - Wholesale Charges Record                                         
      *  037 - TOU Non Demand Charges Record                                    
      *  041 - TOU Demand Charges Record                                        
      *  045 - RTP Base Charges Record                                          
      *  046 - RTP Charges Record                                               
      *  048 - Muni Lites Charges Record                                        
      *  051 - Non Muni Lites Charges Record                                    
      *****************************************************************         
               WHEN WS-ELEC-CHARGES-REC                                 
               WHEN WS-ELEC-DEM-CHARGES-REC                             
               WHEN WS-WHSL-CHARGES-REC                                 
               WHEN WS-TOU-NON-CHARGES-REC                              
               WHEN WS-TOU-DEM-CHARGES-REC                              
               WHEN WS-RTP-BASE-CHG-REC                                 
               WHEN WS-RTP-CHG-REC                                      
      *        WHEN WS-RTP-THIRD-TIER                                           
               WHEN WS-GAS-CHARGES-REC                                  
               WHEN WS-MUNI-CHARGES-REC                                 
               WHEN WS-NON-MUNI-CHARGES-REC                             
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-IC-CHG-REC         
                   MOVE SPACES                TO WS-USAGE-CD            
                   IF EXT-IC-CHG-CHARGES-DESC (1:15) = 'State and Local'
                     MOVE EXT-IC-CHG-CHARGES-DESC TO WS-CHARGE-DESC     
                     MOVE 'TAX001'            TO WS-CHARGE-TYPE         
                     MOVE EXT-IC-CHG-CHARGES-AMT TO WS-BILLED-AM        
                     ADD  EXT-IC-CHG-CHARGES-AMT TO WS-SUM-CHRGS        
                     SET  PROCESS-CHARGES     TO TRUE                   
                     PERFORM 2000-PROCESS-EDI THRU 2000-EXIT            
                   ELSE                                                 
                   IF EXT-IC-CHG-CHARGES-DESC (1:15) = 'Customer Servic'
                     MOVE EXT-IC-CHG-CHARGES-DESC TO WS-CHARGE-DESC     
                     MOVE 'BAS001'            TO WS-CHARGE-TYPE         
                     MOVE EXT-IC-CHG-CHARGES-AMT TO WS-BILLED-AM        
                     ADD  EXT-IC-CHG-CHARGES-AMT TO WS-SUM-CHRGS        
                     SET  PROCESS-CHARGES     TO TRUE                   
                     PERFORM 2000-PROCESS-EDI THRU 2000-EXIT            
                   ELSE                                                 
                   IF EXT-IC-CHG-CHARGES-DESC (1:11) = 'Natural Gas'    
RS0725             OR EXT-IC-CHG-CHARGES-DESC (1:15) = 'AGL Pass Throug'
RS0105               IF EXT-IC-CHG-CHARGES-AMT NOT EQUAL 0              
RS0116                 IF EXT-IC-CHG-CHARGES-DESC (1:16) =              
                                                      'Natural Gas Char'
RS0116                    MOVE 'TD'             TO WS-USAGE-CD          
RS0116                 ELSE                                             
                       PERFORM 4000-PARSE-EXT-IC-CHG-DESC               
                                                THRU 4000-EXIT          
RS0116                 END-IF                                           
                       IF EXT-IC-CHG-CHARGES-DESC (1:7) = HIGH-VALUES   
                          MOVE EXT-IC-CHG-CHARGES-DESC (8:30)           
                                                TO WS-CHARGE-DESC       
                       ELSE                                             
                       MOVE EXT-IC-CHG-CHARGES-DESC TO WS-CHARGE-DESC   
                       END-IF                                           
                       MOVE 'ENC001'            TO WS-CHARGE-TYPE       
                       IF WS-USAGE-CD = 'K1' OR 'K4'                    
                          MOVE 'DMD001'         TO WS-CHARGE-TYPE       
                       END-IF                                           
                       IF WS-CHARGE-DESC (1:8) = 'OVERHEAD'             
                          MOVE 'ODL001'         TO WS-CHARGE-TYPE       
                       END-IF                                           
                       MOVE EXT-IC-CHG-CHARGES-AMT TO WS-BILLED-AM      
                       ADD  EXT-IC-CHG-CHARGES-AMT TO WS-SUM-CHRGS      
RS0829                 IF EXT-IC-CHG-CHARGES-DESC (1:11) = 'Natural Gas'
RS0829                    MOVE WS-THERM-USAGE TO WS-BILL-UNITS          
RS0829                 END-IF                                           
                       SET  PROCESS-CHARGES     TO TRUE                 
                       PERFORM 2000-PROCESS-EDI THRU 2000-EXIT          
                     END-IF                                             
                   ELSE                                                 
                     MOVE EXT-IC-CHG-CHARGES-DESC TO WS-CHARGE-DESC     
                     MOVE 'MSC001'            TO WS-CHARGE-TYPE         
                     MOVE EXT-IC-CHG-CHARGES-AMT TO WS-BILLED-AM        
                     ADD  EXT-IC-CHG-CHARGES-AMT TO WS-SUM-CHRGS        
                     SET  PROCESS-CHARGES     TO TRUE                   
                     PERFORM 2000-PROCESS-EDI THRU 2000-EXIT            
                   END-IF                                               
                   END-IF                                               
                   END-IF                                               
                 END-IF                                                 
      *****************************************************************         
      *  014 - Install Detail Record                                            
      *****************************************************************         
               WHEN WS-INSTALL-DET-REC                                  
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-INST-DTL-REC       
                   MOVE EXT-INST-DTL-CONTRACT-DESC                      
                                              TO WS-CHARGE-DESC         
                   MOVE 'MSC001'              TO WS-CHARGE-TYPE         
                   ADD  EXT-INST-DTL-CURRENT-CHG                        
                                              TO WS-SUM-CHRGS           
                   MOVE EXT-INST-DTL-CURRENT-CHG                        
                                              TO WS-BILLED-AM           
                   SET  PROCESS-CHARGES       TO TRUE                   
                   PERFORM 2000-PROCESS-EDI   THRU 2000-EXIT            
                 END-IF                                                 
      *****************************************************************         
      *  015 - Miscellaneous Charge Detail Record                               
      *****************************************************************         
               WHEN WS-MISC-CHG-DET-REC                                 
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-MISC-CHG-DTL-REC   
                   MOVE EXT-MISC-CHG-DESC     TO WS-CHARGE-DESC         
                   IF WS-CHARGE-DESC (1:12) EQUAL 'Late Payment'        
                      MOVE 'LPC001'           TO WS-CHARGE-TYPE         
                   ELSE                                                 
C32211             IF WS-CHARGE-DESC (1:7)  EQUAL 'Deposit'             
C32211                MOVE 'DAB002'           TO WS-CHARGE-TYPE         
C32211             ELSE                                                 
                   IF WS-MS-FLAG = 'S'                                  
                   AND WS-CHARGE-DESC  (1:11) EQUAL 'Transfer to'       
                      MOVE 'SUB001'           TO WS-CHARGE-TYPE         
                   ELSE                                                 
                      MOVE 'MSC001'           TO WS-CHARGE-TYPE         
C32211             END-IF END-IF END-IF                                 
                   ADD  EXT-MISC-CHG-AMT      TO WS-SUM-CHRGS           
                   MOVE EXT-MISC-CHG-AMT      TO WS-BILLED-AM           
                   SET  PROCESS-CHARGES       TO TRUE                   
                   PERFORM 2000-PROCESS-EDI   THRU 2000-EXIT            
                 END-IF                                                 
      *****************************************************************         
      *  016 - DPP Header Record                                                
      *****************************************************************         
               WHEN WS-DPP-HDR-REC                                      
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-DPP-HDR-REC        
                   MOVE 'DPP'                 TO WS-CHARGE-DESC         
                   MOVE 'MSC001'              TO WS-CHARGE-TYPE         
                   MOVE EXT-DPP-HDR-MO-PYMT   TO WS-BILLED-AM           
                   ADD  EXT-DPP-HDR-MO-PYMT   TO WS-SUM-CHRGS           
                   SET  PROCESS-CHARGES       TO TRUE                   
                   PERFORM 2000-PROCESS-EDI   THRU 2000-EXIT            
                 END-IF                                                 
      *****************************************************************         
      *  017 - DPP Detail Record - Skip this record                             
      *****************************************************************         
               WHEN WS-DPP-DET-REC                                      
RS0511           CONTINUE                                               
      *****************************************************************         
      *  021 - Bill Sum Detail                                                  
      *****************************************************************         
               WHEN WS-BILL-SUM-DET-REC                                 
                 IF EDI-ACCT                                            
C35152             MOVE WS-BE28-DATA          TO EXT-BILLSUM-REC        
                   IF EXT-BILLSUM-DESC (1:15) = 'State Sales Tax'       
RS0716             OR EXT-BILLSUM-DESC (1:16) = 'State Excise Tax'      
                      ADD  EXT-BILLSUM-CHARGES                          
                                              TO WS-SUM-CHRGS           
                      MOVE EXT-BILLSUM-CHARGES                          
                                              TO WS-BILLED-AM           
                      MOVE EXT-BILLSUM-DESC                             
                                              TO WS-CHARGE-DESC         
                      MOVE 'TAX001'           TO WS-CHARGE-TYPE         
                      SET  PROCESS-CHARGES    TO TRUE                   
                      PERFORM 2000-PROCESS-EDI                          
                                              THRU 2000-EXIT            
                   END-IF                                               
RS0421             IF EXT-BILLSUM-DESC (1:16) = 'Unregulated Misc'      
RS0421                ADD  EXT-BILLSUM-CHARGES                          
RS0421                                        TO WS-SUM-CHRGS           
RS0421                MOVE EXT-BILLSUM-CHARGES                          
RS0421                                        TO WS-BILLED-AM           
RS0421                MOVE EXT-BILLSUM-DESC                             
RS0421                                        TO WS-CHARGE-DESC         
RS0421                SET  PROCESS-CHARGES    TO TRUE                   
RS0421                PERFORM 2000-PROCESS-EDI                          
RS0421                                        THRU 2000-EXIT            
RS0421             END-IF                                               
                 END-IF                                                 
      *****************************************************************         
      *  022 - Bill Statement Detail                                            
      *****************************************************************         
ACT090         WHEN WS-STMT-DET-REC                                     
ACT090           IF EDI-ACCT                                            
ACT090               PERFORM 3600-BILL-SUM-DET-REC                      
ACT090           END-IF                                                 
      *****************************************************************         
      *  023 - Messages record.  If we have one of these, and we                
      *        haven't written out a charges record yet, go ahead and           
      *        write one for $0.                                                
      *****************************************************************         
ACT090         WHEN WS-IMP-NOTICE-REC                                   
ACT090           IF EDI-ACCT                                            
ACT090              IF CHARGES-NOT-WRITTEN                              
ACT090                 MOVE 0              TO WS-SUM-CHRGS              
ACT090                 MOVE 0              TO WS-BILLED-AM              
ACT090                 MOVE 'DUMMY RECORD' TO WS-CHARGE-DESC            
ACT090                 MOVE 'MSC001'       TO WS-CHARGE-TYPE            
ACT090                 SET PROCESS-CHARGES TO TRUE                      
ACT090                 PERFORM 2000-PROCESS-EDI THRU 2000-EXIT          
ACT090              END-IF                                              
ACT090           END-IF                                                 
               WHEN WS-EPP-HDR-REC                                      
                 IF EDI-ACCT                                            
                   SET EPP-ACCT               TO TRUE                   
                 END-IF                                                 
C35152         WHEN WS-STMT-ADJ                                         
               WHEN WS-LPRINT-STMT-REC                                  
               WHEN WS-SP-ID-HDR-REC                                    
               WHEN WS-SEPA-ADJUST-REC                                  
               WHEN WS-TOU-DEM-SUM-REC                                  
               WHEN WS-RTP-DEM-SUM-REC                                  
               WHEN WS-EPP-DET-REC                                      
               WHEN WS-EPP-MU-DET-REC                                   
               WHEN WS-LIT-MSG-REC                                      
               WHEN WS-TBL-MSG-DET-REC                                  
               WHEN WS-EPP-ANNIV-HDR-REC                                
               WHEN WS-EPP-ANNIV-DET-REC                                
               WHEN WS-CREDIT-LETTER-REC                                
               WHEN WS-ADDL-DET-REC                                     
C35152         WHEN WS-BNKDRFT-REC                                      
C35152         WHEN WS-SP-ID-HDR-REC                                    
C35152         WHEN WS-LPRINT-SUM-REC                                   
C00526         WHEN WS-AUTOCARD-REC                                     
C35152         WHEN WS-SUB-HDR                                          
C35152         WHEN WS-SUB-IC-REC                                       
C35152         WHEN WS-SPECIAL-MSG-REC                                  
C35152         WHEN WS-SUB-METER-REC                                    
C35152         WHEN WS-SUB-CHARGES-REC                                  
C35152         WHEN WS-DUMMY-REC                                        
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY 'PCSCA710'                                   
                   DISPLAY EXT-BILL-ACCOUNT-NO ' '                      
                   DISPLAY WS-EXT-RECORD-SEQ ' RECORD SEQ NOT DEFINED'  
PRJ251*            MOVE 12 TO RETURN-CODE                                       
PRJ251*            PERFORM 9000-TERMINATE                                       
           END-EVALUATE.                                                
                                                                        
           PERFORM 7000-READ-FCSBE28 THRU 7000-EXIT.                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   2000-PROCESS-EDI-TABLES                                    **        
      **        INSERT EDI820 DATA INTO EDI TABLES                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2000-PROCESS-EDI.                                                
                                                                        
           IF PROCESS-HEADER                                            
              PERFORM 2100-FORMAT-HDR          THRU 2100-EXIT           
              PERFORM 8000-INSERT-HZ           THRU 8000-EXIT           
           END-IF.                                                      
                                                                        
           IF PROCESS-USAGE                                             
             IF WS-CODE-UTIL-TYPE = 'U'                                 
               IF WS-DATE-START = SPACES                                
               AND WS-DATE-END = SPACES                                 
                  GO TO 2000-EXIT
               END-IF
             END-IF
           END-IF.                                      
                                                                        
           IF PROCESS-USAGE                                             
              PERFORM 2200-FORMAT-USAGE        THRU 2200-EXIT           
              PERFORM 8100-INSERT-HW           THRU 8100-EXIT           
              IF EXT-IC-MTR-KW-DEMAND > ZEROS                           
                 PERFORM 2210-FORMAT-KW        THRU 2210-EXIT           
                 PERFORM 8100-INSERT-HW        THRU 8100-EXIT           
              END-IF                                                    
              IF EXT-IC-MTR-KVA-DEMAND > ZEROS                          
                 PERFORM 2230-FORMAT-KVA       THRU 2230-EXIT           
                 PERFORM 8100-INSERT-HW        THRU 8100-EXIT           
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'                         TO   WS-CHARGES-SW       
              PERFORM 2300-FORMAT-CHARGES      THRU 2300-EXIT           
              PERFORM 8200-INSERT-HF           THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2100-FORMAT-HDR                                             **        
      **      FORMATS DATA FOR CSS_EDI_PYMT_HDR                       **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2100-FORMAT-HDR.                                                 
                                                                        
           PERFORM 7200-GET-CURRENT-TIMESTAMP  THRU 7200-EXIT.          
                                                                        
           SET PROCESS-DETAIL                  TO TRUE.                 
           MOVE WS-HOLD-ACCOUNT-NO             TO HZ-ACCOUNT-NO.        
           MOVE WS-TOT-AMT-DUE                 TO HZ-AMT-DUE.           
           IF WS-TOTAL-DUE-DATE = SPACES OR LOW-VALUES                  
              MOVE WS-CUR-DATE                 TO HZ-BILL-DUE-DATE      
           ELSE                                                         
              MOVE WS-TOTAL-DUE-DATE           TO HZ-BILL-DUE-DATE
           END-IF.     
           MOVE WS-BILL-NO                     TO HZ-BILL-NO.           
           PERFORM 7300-GET-ACCOUNT            THRU 7300-EXIT.          
           PERFORM 7305-GET-PREMISE            THRU 7305-EXIT.          
           PERFORM 7310-GET-ZIP-CODE           THRU 7310-EXIT.          
           PERFORM 7320-GET-CITY               THRU 7320-EXIT.          
           MOVE WS-STATE                       TO HZ-CODE-STATE-ID.     
           MOVE WS-FIFTY                       TO HZ-CUSTOMER-NA-LEN.   
           MOVE WS-CUST-NAME                   TO HZ-CUSTOMER-NA-TEXT.  
           PERFORM 7500-GET-DBA-NAME           THRU 7500-EXIT.          
           IF WS-DBA-NAME NOT EQUAL SPACES                              
              MOVE WS-DBA-NAME                 TO HZ-CUSTOMER-NA-TEXT   
           END-IF.                                                      
           MOVE WS-DATE-BILLED                 TO HZ-DATE-BILLED.       
           MOVE WS-CUR-DATE                    TO HZ-DATE-CREATED.      
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO HZ-DATE-READ.         
RS0607     IF HZ-DATE-READ (1:4) NOT NUMERIC                            
RS0607     OR HZ-DATE-READ (6:2) NOT NUMERIC                            
RS0607     OR HZ-DATE-READ (9:2) NOT NUMERIC                            
RS0607         MOVE HZ-DATE-CREATED            TO HZ-DATE-READ          
RS0607     END-IF.                                                      
           MOVE SPACES                         TO HZ-EXTRACTED-FL.      
           MOVE WS-CUR-TS                      TO HZ-EXTRACTED-TS.      
           MOVE WS-CUR-TS                      TO HZ-LAST-UPDATE-TS.    
           MOVE 'SYSTEM'                       TO HZ-LAST-UPDATE-USERID.
           MOVE WS-MST-ACCT-NO                 TO HZ-MST-ACCT-NO.       
           MOVE WS-MST-SUB-IND                 TO HZ-MST-SUB-ACCT-IND.  
           MOVE '00'                           TO HZ-PURPOSE-CD.        
           MOVE WS-SCHED-SEND-DATE             TO HZ-SCHED-SEND-DT.     
           IF WS-BILL-DEST-CD-02 EQUAL SPACES                           
           AND WS-BILL-DEST-CD-29 EQUAL SPACES                          
              MOVE 'R'                         TO HZ-STATUS-CD          
           ELSE                                                         
              MOVE 'H'                         TO HZ-STATUS-CD          
           END-IF.                                                      
           IF WS-BILL-DEST-CD-02 EQUAL 'M'                              
           AND WS-BILL-DEST-CD-29 EQUAL 'M'                             
              MOVE 'R'                         TO HZ-STATUS-CD          
           END-IF.                                                      
RS1228                                                                  
RS1228     IF WS-BILL-DEST-CD-02 EQUAL 'A'                              
RS1228     AND WS-BILL-DEST-CD-29 EQUAL 'A'                             
RS1228        MOVE 'R'                         TO HZ-STATUS-CD          
RS1228     END-IF.                                                      
C33663**************************************************************            
C33663*     ALLOW INVALID RATE HAS CSC REFUND (SEB ONLY).          *            
C33663**************************************************************            
C33663                                                                  
C33663     IF WS-BILL-DEST-CD-02 EQUAL 'H'                              
C33663     AND WS-BILL-DEST-CD-29 EQUAL 'H'                             
C33663     AND WS-PULL-CODE EQUAL 'A'                                   
C33663        MOVE 'R'                         TO HZ-STATUS-CD          
C33663     END-IF.                                                      
C33527                                                                  
C33527     IF WS-BILL-DEST-CD-02 EQUAL 'C'                              
C33527     AND WS-BILL-DEST-CD-29 EQUAL 'C'                             
C33527     AND WS-PULL-CODE EQUAL '@'                                   
C33527        MOVE 'R'                         TO HZ-STATUS-CD          
C33527     END-IF.                                                      
                                                                        
C34583     IF WS-BILL-DEST-CD-02 EQUAL 'C'                              
C34583     AND WS-BILL-DEST-CD-29 EQUAL 'C'                             
C34583     AND WS-PULL-CODE EQUAL 'I'                                   
C34583        MOVE 'R'                         TO HZ-STATUS-CD          
C34583     END-IF.                                                      
                                                                        
C32845     IF WS-BILL-DEST-CD-29 EQUAL 'M'                              
C32845     AND WS-BILL-DEST-CD-02 EQUAL 'A'                             
C32845        MOVE 'R'                         TO HZ-STATUS-CD          
C32845     END-IF.                                                      
C32845                                                                  
C32845     IF WS-BILL-DEST-CD-29 EQUAL 'M'                              
C32845     AND WS-BILL-DEST-CD-02 EQUAL 'C'                             
C32845        MOVE 'R'                         TO HZ-STATUS-CD          
C32845     END-IF.                                                      
C32845                                                                  
C34583     IF WS-MASTER                                                 
C34583       IF CKF-ACCT                                                
C34583          MOVE 'R'                       TO HZ-STATUS-CD          
C34583       END-IF                                                     
C34583     END-IF.                                                      
C34583                                                                  
           IF WS-SUB                                                    
              MOVE 'S'                         TO HZ-STATUS-CD          
           END-IF.                                                      
                                                                        
           MOVE WS-FIFTY                       TO HZ-STREET-ADDR-1-LEN. 
           MOVE WS-SERV-LINE1                  TO HZ-STREET-ADDR-1-TEXT.
           MOVE WS-FIFTY                       TO HZ-STREET-ADDR-2-LEN. 
           MOVE WS-SERV-LINE2                  TO HZ-STREET-ADDR-2-TEXT.
           MOVE 'P'                            TO HZ-TRANS-CD.          
           IF WS-FB-FLAG NOT = SPACES                                   
              MOVE 'F'                         TO HZ-TRANS-CD           
           END-IF.                                                      
RS0629     IF WS-RB-FLAG = 'Y'                                          
              MOVE 'C'                         TO HZ-TRANS-CD           
           END-IF.                                                      
           MOVE 'N'                            TO HZ-UPDATE-IND.        
           MOVE WS-ZIP-CODE                    TO HZ-ZIP-CODE.          
                                                                        
           PERFORM 7900-CHK-BILL-WINDOW        THRU 7900-EXIT.          
                                                                        
           IF GET-JOB-PARM                                              
              PERFORM 7980-GET-REVENUE-MONTH   THRU 7980-EXIT           
           END-IF.                                                      
                                                                        
           SET GET-BILL-WINDOW                 TO TRUE.                 
                                                                        
           MOVE WS-REV-MO                      TO HZ-REVENUE-MONTH.     
RS0927     MOVE WS-EST-IND                     TO HZ-ESTIMATED-FL.      
C36867     MOVE WS-AGL-ACCT-NO                 TO HZ-DIST-ACCT-NO.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2200-FORMAT-USAGE                                           **        
      **      FORMATS DATA FOR CSS_EDI_BILL_USAGE                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2200-FORMAT-USAGE.                                               
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO             TO HW-ACCOUNT-NO.        
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO HW-BEGIN-READ-DT.     
ACT286     IF HW-BEGIN-READ-DT = SPACES OR LOW-VALUES                   
ACT286        MOVE WS-CUR-DATE                 TO HW-BEGIN-READ-DT      
ACT286     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO WS-DATE-START.        
           MOVE EXT-IC-MTR-PREV-METER-READ     TO HW-BEGIN-READING.     
           MOVE WS-BILL-NO                     TO HW-BILL-NO.           
C33146     MOVE WS-BTU-FACTOR                  TO HW-BTU-FACTOR.        
A01749     MOVE WS-DDDC-FACTOR                 TO HW-DDDC-FACTOR.       
A03511     MOVE WS-EDI-RATE-DESC               TO HW-RATE-PLAN-DESC-TX. 
A03511     MOVE WS-EDI-RATE-DESC-EXT           TO HW-RATE-PLAN-DESC-EXT.
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'On'                  
RS0305        MOVE '42'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Of'                  
RS0305        MOVE '41'                        TO HW-CODE-TIME-PERIOD   
C34100     ELSE                                                         
C34100     IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Sh'                  
C34100        MOVE '43'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
              MOVE EXT-IC-MTR-CODE-TIME-PERIOD TO HW-CODE-TIME-PERIOD   
C34100     END-IF END-IF END-IF.                                        
           MOVE EXT-IC-MTR-CONSTANT            TO HW-CONSTANT.          
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO HW-END-READ-DT.       
ACT236     IF HW-END-READ-DT = SPACES OR LOW-VALUES                     
ACT236        MOVE WS-CUR-DATE                 TO HW-END-READ-DT        
ACT236     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO WS-DATE-END.          
           MOVE EXT-IC-MTR-CURR-METER-READ     TO HW-END-READING.       
           MOVE WS-IC-NO                       TO HW-IC-NO.             
           MOVE EXT-IC-MTR-METER-NO            TO HW-METER-NO.          
           IF TOU-ACCT                                                  
             IF EXT-IC-MTR-METER-NO = SPACES                            
                MOVE WS-METER-NO               TO HW-METER-NO           
             ELSE                                                       
                MOVE EXT-IC-MTR-METER-NO       TO WS-METER-NO           
             END-IF                                                     
           END-IF.                                                      
           MOVE EXT-IC-MTR-USAGE               TO HW-NO-UNITS.          
RS0829     MOVE EXT-IC-MTR-THERM-USAGE         TO WS-THERM-USAGE.       
                                                                        
           IF WS-RATE-PLAN-NO = SPACES                                  
              PERFORM 7700-GET-UTIL-ENVRNMT    THRU 7700-EXIT           
           END-IF.                                                      
           MOVE WS-RATE-PLAN-NO                TO HW-RATE-PLAN-NO.      
           MOVE WS-CODE-UTIL-TYPE              TO HW-CODE-UTIL-TYPE.    
           MOVE WS-HW-SEQ                      TO HW-SEQ-NO.            
                                                                        
           IF WS-CODE-UTIL-TYPE = 'E'                                   
              MOVE 'KH'                        TO HW-USAGE-CD           
           ELSE                                                         
           IF WS-CODE-UTIL-TYPE = 'G'                                   
              MOVE 'HH'                        TO HW-USAGE-CD           
           ELSE                                                         
           IF WS-CODE-UTIL-TYPE = 'U'                                   
              MOVE 'UN'                        TO HW-USAGE-CD           
              IF WS-SAVE-CODE-UTIL-TYPE = 'E'                           
                 MOVE 'KH'                     TO HW-USAGE-CD           
              ELSE                                                      
              IF WS-SAVE-CODE-UTIL-TYPE = 'G'                           
                 MOVE 'HH'                     TO HW-USAGE-CD           
              END-IF END-IF                                             
           ELSE                                                         
              MOVE SPACES                      TO HW-USAGE-CD           
           END-IF END-IF END-IF.                                        
                                                                        
C35152     IF WS-NON-MUNI-METER-REC                                     
C34124        MOVE +1                          TO HW-IC-NO              
C34124        MOVE 'KH'                        TO HW-USAGE-CD           
C34124        MOVE 'U'                         TO HW-CODE-UTIL-TYPE     
C34124     END-IF.                                                      
C34124                                                                  
           ADD  WS-ONE                         TO WS-HW-SEQ.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2210-FORMAT-KW                                                        
      **      FORMATS DATA FOR CSS_EDI_BILL_USAGE                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2210-FORMAT-KW.                                                  
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO             TO HW-ACCOUNT-NO.        
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO HW-BEGIN-READ-DT.     
ACT236     IF HW-BEGIN-READ-DT = SPACES OR LOW-VALUES                   
ACT236        MOVE WS-CUR-DATE                 TO HW-BEGIN-READ-DT      
ACT236     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO WS-DATE-START.        
           MOVE ZEROS                          TO HW-BEGIN-READING.     
           MOVE WS-BILL-NO                     TO HW-BILL-NO.           
C33146     MOVE WS-BTU-FACTOR                  TO HW-BTU-FACTOR.        
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'On'                  
RS0305        MOVE '42'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Of'                  
RS0305        MOVE '41'                        TO HW-CODE-TIME-PERIOD   
C34100     ELSE                                                         
C34100     IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Sh'                  
C34100        MOVE '43'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
              MOVE EXT-IC-MTR-CODE-TIME-PERIOD TO HW-CODE-TIME-PERIOD   
C34100     END-IF END-IF END-IF.                                        
           MOVE +1.0                           TO HW-CONSTANT.          
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO HW-END-READ-DT.       
ACT236     IF HW-END-READ-DT = SPACES OR LOW-VALUES                     
ACT236        MOVE WS-CUR-DATE                 TO HW-END-READ-DT        
ACT236     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO WS-DATE-END.          
           MOVE EXT-IC-MTR-KW-DEMAND           TO HW-END-READING.       
           MOVE WS-IC-NO                       TO HW-IC-NO.             
           MOVE EXT-IC-MTR-METER-NO            TO HW-METER-NO.          
           IF TOU-ACCT                                                  
             IF EXT-IC-MTR-METER-NO = SPACES                            
                MOVE WS-METER-NO               TO HW-METER-NO           
             ELSE                                                       
                MOVE EXT-IC-MTR-METER-NO       TO WS-METER-NO           
             END-IF                                                     
           END-IF.                                                      
           MOVE EXT-IC-MTR-KW-DEMAND           TO HW-NO-UNITS.          
                                                                        
           MOVE WS-RATE-PLAN-NO                TO HW-RATE-PLAN-NO.      
           MOVE WS-CODE-UTIL-TYPE              TO HW-CODE-UTIL-TYPE.    
           MOVE WS-HW-SEQ                      TO HW-SEQ-NO.            
           MOVE 'K1'                           TO HW-USAGE-CD.          
                                                                        
           ADD  WS-ONE                         TO WS-HW-SEQ.            
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2230-FORMAT-KVA                                                       
      **      FORMATS DATA FOR CSS_EDI_BILL_USAGE                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2230-FORMAT-KVA.                                                 
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO             TO HW-ACCOUNT-NO.        
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO HW-BEGIN-READ-DT.     
ACT236     IF HW-BEGIN-READ-DT = SPACES OR LOW-VALUES                   
ACT236        MOVE WS-CUR-DATE                 TO HW-BEGIN-READ-DT      
ACT236     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-ST      TO WS-DATE-START.        
           MOVE ZEROS                          TO HW-BEGIN-READING.     
           MOVE WS-BILL-NO                     TO HW-BILL-NO.           
C33146     MOVE WS-BTU-FACTOR                  TO HW-BTU-FACTOR.        
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'On'                  
RS0305        MOVE '42'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
           IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Of'                  
RS0305        MOVE '41'                        TO HW-CODE-TIME-PERIOD   
C34100     ELSE                                                         
C34100     IF EXT-IC-MTR-CODE-TIME-PERIOD (1:2) = 'Sh'                  
C34100        MOVE '43'                        TO HW-CODE-TIME-PERIOD   
           ELSE                                                         
              MOVE EXT-IC-MTR-CODE-TIME-PERIOD TO HW-CODE-TIME-PERIOD   
C34100     END-IF END-IF END-IF.                                        
           MOVE +1.0                           TO HW-CONSTANT.          
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO HW-END-READ-DT.       
ACT236     IF HW-END-READ-DT = SPACES OR LOW-VALUES                     
ACT236        MOVE WS-CUR-DATE                 TO HW-END-READ-DT        
ACT236     END-IF.                                                      
           MOVE EXT-IC-MTR-BILL-PERIOD-END     TO WS-DATE-END.          
           MOVE EXT-IC-MTR-KVA-DEMAND          TO HW-END-READING.       
           MOVE WS-IC-NO                       TO HW-IC-NO.             
           MOVE EXT-IC-MTR-METER-NO            TO HW-METER-NO.          
           IF TOU-ACCT                                                  
             IF EXT-IC-MTR-METER-NO = SPACES                            
                MOVE WS-METER-NO               TO HW-METER-NO           
             ELSE                                                       
                MOVE EXT-IC-MTR-METER-NO       TO WS-METER-NO           
             END-IF                                                     
           END-IF.                                                      
           MOVE EXT-IC-MTR-KVA-DEMAND          TO HW-NO-UNITS.          
                                                                        
           MOVE WS-RATE-PLAN-NO                TO HW-RATE-PLAN-NO.      
           MOVE WS-CODE-UTIL-TYPE              TO HW-CODE-UTIL-TYPE.    
           MOVE WS-HW-SEQ                      TO HW-SEQ-NO.            
           MOVE 'K4'                           TO HW-USAGE-CD.          
                                                                        
           ADD  WS-ONE                         TO WS-HW-SEQ.            
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2250-FORMAT-CCF                                                       
      **      FORMATS DATA FOR CSS_EDI_BILL_USAGE                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2250-FORMAT-CCF.                                                 
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO             TO HW-ACCOUNT-NO.        
           MOVE WS-IB-ST-DATE                  TO WS-F04-DATE.          
           PERFORM 2400-FORMAT-DATE            THRU 2400-EXIT.          
           MOVE WS-RET-DATE                    TO HW-BEGIN-READ-DT.     
           MOVE ZEROS                          TO HW-BEGIN-READING.     
           MOVE WS-BILL-NO                     TO HW-BILL-NO.           
C33146     MOVE WS-BTU-FACTOR                  TO HW-BTU-FACTOR.        
ACT736     MOVE SPACES                         TO HW-CODE-TIME-PERIOD.  
           MOVE +1.0                           TO HW-CONSTANT.          
           MOVE WS-IB-END-DATE                 TO WS-F04-DATE.          
           PERFORM 2400-FORMAT-DATE            THRU 2400-EXIT.          
           MOVE WS-RET-DATE                    TO HW-END-READ-DT.       
           MOVE WS-IC-NO                       TO HW-IC-NO.             
                                                                        
           PERFORM 7760-GET-UTIL-ENVRNMT       THRU 7760-EXIT.          
                                                                        
           MOVE WS-RATE-PLAN-NO                TO HW-RATE-PLAN-NO.      
           MOVE WS-CODE-UTIL-TYPE              TO HW-CODE-UTIL-TYPE.    
           MOVE WS-HW-SEQ                      TO HW-SEQ-NO.            
           MOVE WS-USAGE-CD                    TO HW-USAGE-CD.          
                                                                        
           ADD  WS-ONE                         TO WS-HW-SEQ.            
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2300-FORMAT-CHARGES                                         **        
      **      FORMATS DATA FOR CSS_EDI_BILL_CHRGS                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2300-FORMAT-CHARGES.                                             
                                                                        
RS0331     IF WS-CHARGE-TYPE (1:3) EQUAL 'MSC' OR 'LPC'                 
C33146                                OR 'PRB'                          
              MOVE SPACES                      TO WS-RATE-PLAN-NO       
              MOVE SPACES                      TO WS-MULTI-METER        
              MOVE ZEROS                       TO WS-BILL-UNITS         
RS0829        MOVE ZEROS                       TO WS-THERM-USAGE
           END-IF.       
                                                                        
RS0331     IF WS-CHARGE-TYPE (1:3) EQUAL 'FRN'                          
RS0331        MOVE SPACES                      TO WS-RATE-PLAN-NO       
RS0331        MOVE SPACES                      TO WS-MULTI-METER        
RS0331        MOVE SPACES                      TO WS-USAGE-CD           
RS0331        MOVE ZEROS                       TO WS-BILL-UNITS         
RS0829        MOVE ZEROS                       TO WS-THERM-USAGE
           END-IF.       
RS0331                                                                  
C34198     IF WS-CHARGE-TYPE (1:3) EQUAL 'TAX'                          
C34456       IF XML-FORMAT                                              
C33146          MOVE ZEROS                     TO WS-IC-NO
             END-IF
           END-IF.             
C33146                                                                  
C34198     IF WS-CHARGE-TYPE (1:3) EQUAL 'FRN'                          
C34456       IF XML-FORMAT                                              
C34198          MOVE ZEROS                     TO WS-IC-NO
             END-IF
           END-IF.             
C34198                                                                  
C36705     IF WS-CHARGE-TYPE (1:3) EQUAL 'LPC' OR 'PRB'                 
C36705       IF XML-FORMAT                                              
C36705          MOVE SPACES                    TO WS-CODE-UTIL-TYPE     
C36705       END-IF                                                     
C36705     END-IF.                                                      
C36705                                                                  
RS1216     IF WS-CHARGE-TYPE (1:3) EQUAL 'MSC' OR 'LPC' OR 'PRB'        
C34456       IF XML-FORMAT                                              
RS1216          MOVE ZEROS                     TO WS-IC-NO              
RS0124       ELSE                                                       
RS0124          IF WS-BILL-UNITS = ZERO                                 
RS0124             MOVE SPACES                 TO WS-USAGE-CD           
RS0124          END-IF                                                  
RS0124       END-IF                                                     
RS0124     END-IF.                                                      
RS1216                                                                  
C34112     IF WS-CHARGE-TYPE (1:3) EQUAL 'ODL'                          
C34456       IF EDI-FORMAT                                              
C35152         IF WS-NON-MUNI-CHARGES-REC                               
C34112          MOVE +1                        TO WS-IC-NO              
C34124          MOVE 'U'                       TO WS-CODE-UTIL-TYPE     
C34124         END-IF                                                   
C34112       END-IF                                                     
C34112     END-IF.                                                      
C34112                                                                  
           MOVE WS-HOLD-ACCOUNT-NO             TO HF-ACCOUNT-NO.        
           MOVE WS-BILL-NO                     TO HF-BILL-NO.           
           MOVE WS-BILL-UNITS                  TO HF-BILL-UNITS.        
           MOVE WS-BILLED-AM                   TO HF-BILLED-AM.         
           MOVE WS-CHARGE-TYPE                 TO HF-CHARGE-TYPE-TX.    
           MOVE WS-IC-NO                       TO HF-IC-NO.             
           MOVE WS-HF-SEQ                      TO HF-SEQ-NO.            
           MOVE WS-USAGE-CD                    TO HF-USAGE-CD.          
C32211                                                                  
C34456     IF EDI-FORMAT                                                
C32211       IF WS-BILL-UNITS < +1                                      
C32211          MOVE SPACES                    TO HF-USAGE-CD
             END-IF
           END-IF.          
C32211                                                                  
RS0205     INSPECT WS-CHARGE-DESC REPLACING ALL LOW-VALUES              
RS0205             BY SPACES.                                           
RS0205     INSPECT WS-CHARGE-DESC REPLACING ALL HIGH-VALUES             
RS0205             BY SPACES.                                           
A03699     MOVE LENGTH OF WS-CHARGE-DESC    TO HF-CHARGE-TYPE-DESC-LEN. 
A03699     IF HF-CHARGE-TYPE-DESC-LEN > 0 THEN                          
A03699          MOVE WS-CHARGE-DESC         TO HF-CHARGE-TYPE-DESC-TEXT 
A03699     ELSE                                                         
A03699          MOVE SPACES                 TO HF-CHARGE-TYPE-DESC-TEXT 
A03699          MOVE 0                      TO HF-CHARGE-TYPE-DESC-LEN  
A03699     END-IF.                                                      
           MOVE ZEROS                          TO HF-SUB-ACCT-NO.       
           MOVE WS-CODE-UTIL-TYPE              TO HF-CODE-UTIL-TYPE.    
                                                                        
RS1023     IF WS-CHARGE-TYPE (1:3) EQUAL 'BAS'                          
RS1023        MOVE SPACES                      TO HF-USAGE-CD           
RS1023        MOVE ZEROS                       TO HF-BILL-UNITS
           END-IF.        
                                                                        
           IF WS-MASTER                                                 
           AND WS-CHARGE-DESC (1:3) = 'MST'                             
              MOVE WS-SUB-ACCT-NO              TO HF-SUB-ACCT-NO        
           END-IF.                                                      
                                                                        
           IF HF-SUB-ACCT-NO = ZEROS                                    
              MOVE -1                          TO WS-SUB-ACCT-NI        
           ELSE                                                         
              MOVE ZEROS                       TO WS-SUB-ACCT-NI        
           END-IF.                                                      
                                                                        
           ADD  WS-ONE                         TO WS-HF-SEQ.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2400-DATE-FORMAT-PROCESS                                    **        
      **    FORMATS THE DATE                                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2400-FORMAT-DATE.                                                
                                                                        
           IF WS-F04-DATE (5:2) NOT NUMERIC                             
              MOVE WS-CUR-DATE                 TO WS-RET-DATE           
              GO TO 2400-EXIT                                           
           ELSE                                                         
           MOVE WS-CUR-DATE (1:4)              TO WS-RET-DATE
           END-IF.          
           MOVE WS-F04-DATE (5:2)              TO WS-RET-DATE (9:2).    
           MOVE '-'                            TO WS-RET-DATE (5:1).    
           MOVE '-'                            TO WS-RET-DATE (8:1).    
                                                                        
           EVALUATE WS-F04-MONTH                                        
               WHEN 'Jan'                                               
                    MOVE '01'                  TO WS-RET-DATE (6:2)     
               WHEN 'Feb'                                               
                    MOVE '02'                  TO WS-RET-DATE (6:2)     
               WHEN 'Mar'                                               
                    MOVE '03'                  TO WS-RET-DATE (6:2)     
               WHEN 'Apr'                                               
                    MOVE '04'                  TO WS-RET-DATE (6:2)     
               WHEN 'May'                                               
                    MOVE '05'                  TO WS-RET-DATE (6:2)     
               WHEN 'Jun'                                               
                    MOVE '06'                  TO WS-RET-DATE (6:2)     
               WHEN 'Jul'                                               
                    MOVE '07'                  TO WS-RET-DATE (6:2)     
               WHEN 'Aug'                                               
                    MOVE '08'                  TO WS-RET-DATE (6:2)     
               WHEN 'Sep'                                               
                    MOVE '09'                  TO WS-RET-DATE (6:2)     
               WHEN 'Oct'                                               
                    MOVE '10'                  TO WS-RET-DATE (6:2)     
               WHEN 'Nov'                                               
                    MOVE '11'                  TO WS-RET-DATE (6:2)     
               WHEN 'Dec'                                               
                    MOVE '12'                  TO WS-RET-DATE (6:2)     
           END-EVALUATE.                                                
                                                                        
RS0129     IF WS-RET-DATE > WS-CUR-DATE                                 
RS0129        SUBTRACT WS-1 FROM WS-RET-DATE-YR-N                       
RS0129     END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2500-DATE-FORMAT-PROCESS                                    **        
      **    FORMATS THE DATE                                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2500-FORMAT-DATE.                                                
                                                                        
           MOVE WS-CUR-DATE (1:2)              TO WS-RET-DATE (1:2).    
           MOVE WS-F04-DATE (1:2)              TO WS-RET-DATE (3:2).    
           MOVE '-'                            TO WS-RET-DATE (5:1).    
           MOVE WS-F04-DATE (3:2)              TO WS-RET-DATE (6:2).    
           MOVE '-'                            TO WS-RET-DATE (8:1).    
           MOVE WS-F04-DATE (5:2)              TO WS-RET-DATE (9:2).    
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  3000-PROCESS-ACCTS                                          **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       3000-PROCESS-ACCTS.                                              
                                                                        
           PERFORM 7800-CHK-EDI-ACCT          THRU 7800-EXIT.           
C34456     PERFORM 7810-EDI-DEST              THRU 7810-EXIT.           
                                                                        
      *****************************************************************         
      * CHECK CSS_EDI_ACCT-DEST TO DETERMINE NUMBER OF DAYS FOR       *         
      * SCHEDULED RELEASE DATE.                                       *         
      *****************************************************************         
                                                                        
           IF EDI-ACCT                                                  
              PERFORM 7200-GET-CURRENT-TIMESTAMP                        
                                              THRU 7200-EXIT            
              MOVE WS-CUR-DATE                TO WS-NEW-BUSINESS-DAY    
              MOVE ZERO                       TO SUB1                   
              MOVE WS-NO                      TO WS-NEXT-BUSINESS-DAY   
              PERFORM                                                   
                 VARYING SUB1 FROM WS-ONE BY WS-ONE                     
                 UNTIL SUB1 GREATER THAN WS-HOLD-DAYS                   
                     PERFORM 6500-GET-NEXT-BUSINESS-DAY                 
                        THRU 6500-NEXT-BUSINESS-DAY-EXIT                
                       UNTIL NEXT-BUSINESS-DAY-FOUND                    
              END-PERFORM                                               
              MOVE WS-NEW-BUSINESS-DAY        TO WS-SCHED-SEND-DATE     
           END-IF.                                                      
                                                                        
           PERFORM 7850-CHK-DUP-ACCT          THRU 7850-EXIT.           
                                                                        
           IF WS-Y                                                      
             IF WS-RB-FLAG = 'Y'                                        
                MOVE 'X'                      TO WS-STATUS-CD           
             ELSE                                                       
                MOVE 'H'                      TO WS-STATUS-CD           
             END-IF                                                     
             PERFORM 8350-UPD-EDI-HDR         THRU 8350-EXIT            
           END-IF.                                                      
                                                                        
           SET WS-N                           TO TRUE.                  
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  3500-CHK-DUP-ACCTS                                          **        
      **      CHECK TO ENSURE THIS IS NOT A DUPLICATE BILL.           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       3500-CHK-DUP-ACCTS.                                              
                                                                        
           IF WS-BILL-NO = ZEROS                                        
              GO TO 3500-EXIT
           END-IF.                                          
                                                                        
           PERFORM 7880-CHK-DUP-ACCT          THRU 7880-EXIT.           
                                                                        
           IF WS-Y                                                      
              SET NON-EDI-ACCT                TO TRUE                   
           END-IF.                                                      
                                                                        
           SET WS-N                           TO TRUE.                  
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
ACT090 3600-BILL-SUM-DET-REC.                                           
ACT090     MOVE WS-BE28-DATA          TO EXT-STMT-DTL-REC               
ACT090     IF EXT-STMT-DTL-DESC (1:16) EQUAL 'Previous Bill Am'         
ACT090        MOVE EXT-STMT-DTL-AMT   TO WS-PREV-BILL-AMT               
ACT090     ELSE                                                         
ACT090        IF EXT-STMT-DTL-DESC (1:16) EQUAL 'Payment Received' OR   
ACT090           EXT-STMT-DTL-DESC (1:17) EQUAL 'ePayment Received'     
ACT090           ADD EXT-STMT-DTL-AMT    TO WS-PYMTS                    
ACT090        ELSE                                                      
ACT090           ADD  EXT-STMT-DTL-AMT   TO WS-SUM-CHRGS                
ACT090           MOVE EXT-STMT-DTL-AMT   TO WS-BILLED-AM                
ACT090           MOVE EXT-STMT-DTL-DESC  TO WS-CHARGE-DESC              
ACT090           IF EXT-STMT-DTL-DESC (1:14) EQUAL 'Set Up Deposit'     
ACT090              MOVE 'DAB001'        TO WS-CHARGE-TYPE              
ACT090           ELSE                                                   
ACT090              IF EXT-STMT-DTL-DESC (1:16) = 'Max Deposit Refu' OR 
ACT090                 EXT-STMT-DTL-DESC (1:14) = 'Deposit Credit'   OR 
ACT090                 EXT-STMT-DTL-DESC (1:16) = 'Deposit and Inte' OR 
ACT090                 EXT-STMT-DTL-DESC (1:16) = 'Credit Billed De'    
ACT090                    MOVE 'DAB003'        TO WS-CHARGE-TYPE        
ACT090              ELSE                                                
ACT090                    MOVE 'MSC001'           TO WS-CHARGE-TYPE     
ACT090              END-IF                                              
ACT090           END-IF                                                 
ACT090        SET  PROCESS-CHARGES    TO TRUE                           
ACT090        PERFORM 2000-PROCESS-EDI THRU 2000-EXIT                   
ACT090        END-IF                                                    
ACT090     END-IF.                                                      
ACT090 3600-EXIT.                                                       
ACT090     EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  4000-PARSE-EXT-IC-CHG-DESC                                  **        
      **      PARSE TO FIND USAGE AND USAGE CODE.                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       4000-PARSE-EXT-IC-CHG-DESC.                                      
                                                                        
           MOVE SPACES             TO WS-USAGE-CD.                      
                                                                        
P00496     IF EXT-IC-CHG-USAGE > 0                                      
P00496        MOVE EXT-IC-CHG-USAGE TO WS-BILL-UNITS                    
           ELSE                                                         
              MOVE ZEROS            TO WS-BILL-UNITS                    
           END-IF.                                                      
                                                                        
P00496     IF EXT-IC-CHG-USAGE-TYPE = 'Therms' OR 'therms'              
              MOVE 'TD'             TO WS-USAGE-CD                      
P00496     END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
C36867                                                                  
C36867******************************************************************        
C36867**                                                              **        
C36867**  4100-PARSE-AGL-ACCT-NO                                      **        
C36867**      PARSE TO DELETE LEADING ZEROS IN AGL ACCT NUMBER.       **        
C36867**                                                              **        
C36867******************************************************************        
C36867                                                                  
C36867 4100-PARSE-AGL-ACCT-NO.                                          
C36867                                                                  
C36867* THIS CODE SHOULD CATCH 99% OF THE ACCOUNT NUMBERS                       
C36867                                                                  
C36867     IF EXT-ACCT-AGL-ACCOUNT-NO (1:10) = '0000000000'             
C36867       IF EXT-ACCT-AGL-ACCOUNT-NO (11:1) > '0'                    
C36867          MOVE EXT-ACCT-AGL-ACCOUNT-NO (11:10) TO                 
C36867               WS-AGL-ACCT-NO                                     
C36867               GO TO 4100-EXIT                                    
C36867       ELSE                                                       
C36867       IF EXT-ACCT-AGL-ACCOUNT-NO (12:1) > '0'                    
C36867          MOVE EXT-ACCT-AGL-ACCOUNT-NO (12:9) TO                  
C36867               WS-AGL-ACCT-NO                                     
C36867               GO TO 4100-EXIT                                    
C36867       END-IF END-IF                                              
C36867     END-IF                                                       
C36867                                                                  
C36867* THE BYTE BY BYTE PARSING IS NEEDED                                      
C36867     MOVE +1                 TO AGL-SUB.                          
C36867     MOVE +1                 TO AGL-SUB2.                         
C36867                                                                  
C36867     PERFORM VARYING AGL-SUB FROM AGL-SUB BY +1 UNTIL             
C36867                     AGL-SUB > +20                                
C36867        IF EXT-ACCT-AGL-ACCOUNT-NO (AGL-SUB:1) > '0'              
C36867           COMPUTE AGL-SUB2 = (20 - AGL-SUB) + 1                  
C36867           MOVE EXT-ACCT-AGL-ACCOUNT-NO(AGL-SUB:AGL-SUB2)         
C36867                             TO WS-AGL-ACCT-NO                    
C36867           MOVE +21          TO AGL-SUB                           
C36867        END-IF                                                    
C36867     END-PERFORM.                                                 
C36867                                                                  
C36867 4100-EXIT.                                                       
C36867     EXIT.                                                        
                                                                        
A01453*****************************************************************         
A01453**                                                              *         
A01453**  4200-REMOVE-SPECIAL-CHARS                                   *         
A01453**      INSPECT THE SERVICE ADDRESS AND REPLACE ANY SPECIAL     *         
A01453**      CHARACTERS WITH A SPACE.                                *         
A01453*****************************************************************         
A01453 4200-REMOVE-SPECIAL-CHARS.                                       
A01453                                                                  
A01453     INSPECT WS-HOLD-SERV-LINE CONVERTING                         
A01453        WS-CONVERT-FROM TO WS-CONVERT-TO.                         
A01453                                                                  
A01453 4200-EXIT.                                                       
A01453     EXIT.                                                        
A01453                                                                  
A03511***************************************************************** 08880000
A03511*    6010-REDUCE-EMBEDDED-SPACES                               ** 08890000
A03511*                                                              ** 08900000
A03511*    COPYBOOK CPD00004 CONTAINS THE LOGIC FOR REMOVING         ** 08910000
A03511*    EMBEDDED SPACES.                                          ** 08920000
A03511***************************************************************** 08930000
A03511*                                                                 08940000
A03511     EXEC SQL                                                     08950000
A03511         INCLUDE CPD00004                                         08960000
A03511     END-EXEC.                                                    08970000
      *                                                                 08980000
      ***************************************************************** 08880000
      *    6500-GET-NEXT-BUSINESS-DAY                                ** 08890000
      *                                                              ** 08900000
      *    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          ** 08910000
      *    THE NEXT BUSINESS DAY.                                    ** 08920000
      ***************************************************************** 08930000
      *                                                                 08940000
           EXEC SQL                                                     08950000
               INCLUDE CPD00315                                         08960000
           END-EXEC.                                                    08970000
      *                                                                 08980000
      ************************************************************              
      *  READ THE BE28 INPUT FILE                                *              
      ************************************************************              
                                                                        
       7000-READ-FCSBE28.                                               
                                                                        
           READ FCSBE28-FILE INTO WS-CSF-IO-AREA                        
               AT END                                                   
                  MOVE WS-YES TO WS-END-OF-BE28.                        
                                                                        
           IF FBE28-READ-OK OR END-OF-BE28                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA710 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      **  7200-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
      ************************************************************              
       7200-GET-CURRENT-TIMESTAMP.                                      
C34456     EXEC SQL                                                     
C34456         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CUR-TS                                        
C34456     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP                                         
MFA-TR*        INTO   :WS-CUR-TS                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34456                                                                  
C34456     EXEC SQL                                                     
C34456         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CUR-DATE                                      
C34456     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT DATE                                              
MFA-TR*        INTO   :WS-CUR-DATE                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34456                                                                  
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '7200-GET-CURRENT-TIMESTAMP'                      
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7300-GET-ACCOUNT.                                     **              
      **      GETS ADDRESS_ID FROM CSS_ACCOUNT.                 **              
      ************************************************************              
       7300-GET-ACCOUNT.                                                
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO         TO AT-ACCOUNT-NO.            
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,ACCT_XFER_TO                                      
                     ,MST_SUB_ACCT_IND                                  
               INTO   :AT-PREMISE-NO                                    
                     ,:AT-ACCT-XFER-TO                                  
                     ,:AT-MST-SUB-ACCT-IND                              
               FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,ACCT_XFER_TO                                              
MFA-TR*              ,MST_SUB_ACCT_IND                                          
MFA-TR*        INTO   :AT-PREMISE-NO                                            
MFA-TR*              ,:AT-ACCT-XFER-TO                                          
MFA-TR*              ,:AT-MST-SUB-ACCT-IND                                      
MFA-TR*        FROM  CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY 'ACCOUNT = ', WS-HOLD-ACCOUNT-NO                  
              DISPLAY '7300-GET-ACCOUNT '                               
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
              MOVE AT-ACCT-XFER-TO         TO WS-MST-ACCT-NO            
           ELSE                                                         
              MOVE ZEROS                   TO WS-MST-ACCT-NO            
           END-IF.                                                      
           MOVE AT-MST-SUB-ACCT-IND        TO WS-MST-SUB-IND.           
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7305-GET-PREMISE.                                     **              
      **      GETS ADDRESS_ID FROM CSS_PREMISE.                 **              
      ************************************************************              
       7305-GET-PREMISE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID                                        
               INTO   :PR-ADDRESS-ID                                    
               FROM  CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :AT-PREMISE-NO                        
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID                                                
MFA-TR*        INTO   :PR-ADDRESS-ID                                            
MFA-TR*        FROM  CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :AT-PREMISE-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY 'ACCOUNT = ', WS-HOLD-ACCOUNT-NO                  
              DISPLAY 'PREMISE = ', AT-PREMISE-NO                       
              DISPLAY '7305-GET-PREMISE '                               
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE PR-ADDRESS-ID              TO WS-ADDRESS-ID.            
      *                                                                         
       7305-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7310-GET-ZIP-CODE                                     **              
      **      GETS ZIP CODE   FROM CSS_ADDR_FORMATTED           **              
      ************************************************************              
       7310-GET-ZIP-CODE.                                               
                                                                        
           IF WS-ADDRESS-ID EQUAL ZEROS                                 
              MOVE SPACES TO WS-ZIP-CODE                                
              GO TO 7310-EXIT                                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT ZIP_CODE                                          
                     ,ZIP_CODE_PLUS_FOUR                                
               INTO   :DY-ZIP-CODE                                      
                     ,:DY-ZIP-CODE-PLUS-FOUR                            
               FROM  CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
               WHERE ADDRESS_ID = :WS-ADDRESS-ID                        
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*        INTO   :DY-ZIP-CODE                                              
MFA-TR*              ,:DY-ZIP-CODE-PLUS-FOUR                                    
MFA-TR*        FROM  CSS_ADDR_FORMATTED                                         
MFA-TR*        WHERE ADDRESS_ID = :WS-ADDRESS-ID                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE DY-ZIP-CODE             TO WS-ZIP-CODE1              
              MOVE DY-ZIP-CODE-PLUS-FOUR   TO WS-ZIP-CODE-PLUS-FOUR     
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              EXEC SQL                                                  
                  SELECT ADDR_ZIP_CODE                                  
                  INTO   :DZ-ADDR-ZIP-CODE                              
                  FROM  CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                 
                  WHERE ADDRESS_ID = :WS-ADDRESS-ID                     
C34456                                                           
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT ADDR_ZIP_CODE                                          
MFA-TR*           INTO   :DZ-ADDR-ZIP-CODE                                      
MFA-TR*           FROM  CSS_ADDR_FREEFORM                                       
MFA-TR*           WHERE ADDRESS_ID = :WS-ADDRESS-ID                             
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE     
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE DZ-ADDR-ZIP-CODE     TO WS-ZIP-CODE               
              ELSE                                                      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY 'ACCOUNT = ', WS-HOLD-ACCOUNT-NO               
                 DISPLAY 'ADDRESS ID NOT FOUND = ', WS-ADDRESS-ID       
                 MOVE SPACES                  TO WS-ZIP-CODE            
              ELSE                                                      
                 DISPLAY 'ADDR ID = ', WS-ADDRESS-ID                    
                 DISPLAY '7310-GET-ADDR-ID '                            
                 DISPLAY '**RETURN CODE : ' SQLCODE                     
                 DISPLAY '**         PROCESSING TERMINATED         **'  
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF END-IF                                             
           ELSE                                                         
              DISPLAY 'ADDR ID = ', WS-ADDRESS-ID                       
              DISPLAY '7310-GET-ADDR-ID '                               
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7320-GET-CITY.                                        **              
      **      GETS CITY AND STATE FROM CSS_ZIP_CODE             **              
      ************************************************************              
       7320-GET-CITY.                                                   
                                                                        
           IF WS-ZIP-CODE EQUAL SPACES                                  
              GO TO 7320-EXIT                                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOWN                                              
                     ,STATE                                             
               INTO   :A4-TOWN                                          
                     ,:A4-STATE                                         
               FROM  CSS_ZIP_CODE WITH(READUNCOMMITTED)                         
               WHERE ZIP_CODE = :WS-ZIP-CODE1                           
                 AND ZIP_CODE_TOKEN = '1'                               
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*        INTO   :A4-TOWN                                                  
MFA-TR*              ,:A4-STATE                                                 
MFA-TR*        FROM  CSS_ZIP_CODE                                               
MFA-TR*        WHERE ZIP_CODE = :WS-ZIP-CODE1                                   
MFA-TR*          AND ZIP_CODE_TOKEN = '1'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE A4-TOWN                 TO WS-CITY                   
              MOVE A4-STATE                TO WS-STATE                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES                  TO WS-CITY                   
              MOVE SPACES                  TO WS-STATE                  
           ELSE                                                         
              DISPLAY 'ZIPCODE = ', WS-ZIP-CODE1                        
              DISPLAY '7320-GET-CITY    '                               
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF END-IF.                                               
      *                                                                         
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINES IF WE ARE PROCESS SCEG/PSNC OR SEB                           
      ******************************************************************        
       7400-CALL-DELIQUENCY.                                            
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD = :C8-DELINQ-CD                                
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7400-CALL-DELINQUENCY'                 
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSCA710 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETS THE COMPANY NAME FOR THE CASH COMPANY NUMBER                       
      ******************************************************************        
      *                                                                         
       7450-GET-COMP-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     56130000
MFA-TR*       SELECT COMPANY_NAME                                       56140000
MFA-TR*         INTO :C7-COMPANY-NAME                                   56170000
MFA-TR*         FROM CSS_COMPANY C7                                     56200000
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     56210000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    56242000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7450-GET-COMP-DESC'                    
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'CASH COMPANY NO  ', C7-COMPANY-NO               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSCA710 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE COMPANY NAME FOR THE CASH COMPANY NUMBER                       
      ******************************************************************        
      *                                                                         
       7500-GET-DBA-NAME.                                               
      *                                                                         
           MOVE WS-HOLD-ACCOUNT-NO         TO AB-ACCOUNT-NO.            
                                                                        
           EXEC SQL                                                     
                SELECT DQ.FULL_NAME                                     
                  INTO :DQ-FULL-NAME                                    
                  FROM CSS_NAME           DQ WITH(READUNCOMMITTED),             
                       CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)              
                 WHERE AB.ACCOUNT_NO = :AB-ACCOUNT-NO                   
                   AND DQ.NAME_ID    = AB.NAME_ID                       
                   AND DQ.NAME_TYPE = 'DB'                              
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FULL_NAME                                             
MFA-TR*           INTO :DQ-FULL-NAME                                            
MFA-TR*           FROM CSS_NAME           DQ,                                   
MFA-TR*                CSS_ACCT_BILL_NMES AB                                    
MFA-TR*          WHERE AB.ACCOUNT_NO = :AB-ACCOUNT-NO                           
MFA-TR*            AND DQ.NAME_ID    = AB.NAME_ID                               
MFA-TR*            AND DQ.NAME_TYPE = 'DB'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE DQ-FULL-NAME                TO WS-DBA-NAME           
           ELSE                                                         
              MOVE SPACES                      TO WS-DBA-NAME           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      *  7700-GET-UTIL-ENVNMT                                    *              
      *                                                          *              
      ************************************************************              
                                                                        
       7700-GET-UTIL-ENVRNMT.                                           
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO      TO UT-ACCOUNT-NO.               
                                                                        
           MOVE WS-CODE-UTIL-TYPE       TO WS-SAVE-CODE-UTIL-TYPE.      
           MOVE 'U'                     TO WS-CODE-UTIL-TYPE.           
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :UT-RATE-PLAN-NO                                  
               FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*        FROM CSS_UTIL_ENVRNMT                                            
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UT-RATE-PLAN-NO     TO WS-RATE-PLAN-NO               
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7700-GET-UTIL-ENVRNMT '                
               DISPLAY 'IF NOT STOPPED, PGM WILL ABEND WITH -530'       
               DISPLAY '   DUE TO RI ON THE RATE TABLE'                 
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'UTIL-TYPE  = ', WS-CODE-UTIL-TYPE               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSCA710 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7750-GET-UTIL-ENVNMT                                    *              
      *           GET IC_NO                                      *              
      ************************************************************              
                                                                        
       7750-GET-UTIL-ENVRNMT.                                           
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO      TO UT-ACCOUNT-NO.               
                                                                        
           MOVE 'G'                     TO WS-CODE-UTIL-TYPE.           
                                                                        
           EXEC SQL                                                     
               SELECT IC_NO                                             
                 INTO :UT-IC-NO                                         
               FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND RATE_PLAN_NO   = :WS-RATE-PLAN-NO                  
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IC_NO                                                     
MFA-TR*          INTO :UT-IC-NO                                                 
MFA-TR*        FROM CSS_UTIL_ENVRNMT                                            
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND RATE_PLAN_NO   = :WS-RATE-PLAN-NO                          
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UT-IC-NO            TO WS-IC-NO                      
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7750-GET-UTIL-ENVRNMT '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'UTIL-TYPE  = ', WS-CODE-UTIL-TYPE               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7760-GET-UTIL-ENVNMT                                    *              
      *           GET IC_NO                                      *              
      ************************************************************              
                                                                        
       7760-GET-UTIL-ENVRNMT.                                           
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO      TO UT-ACCOUNT-NO.               
                                                                        
           MOVE 'G'                     TO WS-CODE-UTIL-TYPE.           
                                                                        
           EXEC SQL                                                     
               SELECT UT.IC_NO                                          
                     ,UT.RATE_PLAN_NO                                   
                 INTO :UT-IC-NO                                         
                     ,:UT-RATE-PLAN-NO                                  
               FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                  
                    CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO                  
                 AND UT.IC_NO          = MN.IC_NO                       
                 AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE              
                 AND MN.METER_NO       = :WS-METER-NO                   
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.IC_NO                                                  
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*          INTO :UT-IC-NO                                                 
MFA-TR*              ,:UT-RATE-PLAN-NO                                          
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT,                                        
MFA-TR*             CSS_MTRD_ENVRNMT MN                                         
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO                          
MFA-TR*          AND UT.IC_NO          = MN.IC_NO                               
MFA-TR*          AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                      
MFA-TR*          AND MN.METER_NO       = :WS-METER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UT-IC-NO            TO WS-IC-NO                      
              MOVE UT-RATE-PLAN-NO     TO WS-RATE-PLAN-NO               
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7760-GET-UTIL-ENVRNMT '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'UTIL-TYPE  = ', WS-CODE-UTIL-TYPE               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7800-CHK-EDI-ACCT                                       *              
      *                                                          *              
      ************************************************************              
                                                                        
       7800-CHK-EDI-ACCT.                                               
                                                                        
RS0105     PERFORM 7200-GET-CURRENT-TIMESTAMP  THRU 7200-EXIT.          
           MOVE WS-HOLD-ACCOUNT-NO      TO NF-ACCOUNT-NO.               
                                                                        
           EXEC SQL                                                     
RS0727         SELECT DEST_ID                                           
RS0727               ,STAT_BEGIN_DT                                     
                     ,STAT_END_DT                                       
RS0105               ,STATUS_CD                                         
                     ,HOLD_DAYS_NO                                      
RS0727           INTO :NF-DEST-ID                                       
RS0727               ,:NF-STAT-BEGIN-DT                                 
                     ,:NF-STAT-END-DT                                   
RS0105               ,:NF-STATUS-CD                                     
                     ,:NF-HOLD-DAYS-NO                                  
               FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :NF-ACCOUNT-NO                    
RS0721           AND STATUS_CD      = 'A'                               
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEST_ID                                                   
MFA-TR*              ,STAT_BEGIN_DT                                             
MFA-TR*              ,STAT_END_DT                                               
MFA-TR*              ,STATUS_CD                                                 
MFA-TR*              ,HOLD_DAYS_NO                                              
MFA-TR*          INTO :NF-DEST-ID                                               
MFA-TR*              ,:NF-STAT-BEGIN-DT                                         
MFA-TR*              ,:NF-STAT-END-DT                                           
MFA-TR*              ,:NF-STATUS-CD                                             
MFA-TR*              ,:NF-HOLD-DAYS-NO                                          
MFA-TR*        FROM CSS_EDI_ACCT_DEST                                           
MFA-TR*        WHERE ACCOUNT_NO     = :NF-ACCOUNT-NO                            
MFA-TR*          AND STATUS_CD      = 'A'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33146       MOVE NF-DEST-ID           TO WS-DEST-ID                    
             IF WS-CUR-DATE >= NF-STAT-BEGIN-DT                         
                         OR <= NF-STAT-END-DT                           
                SET EDI-ACCT             TO TRUE                        
                MOVE NF-HOLD-DAYS-NO     TO WS-HOLD-DAYS                
             ELSE                                                       
                SET NON-EDI-ACCT         TO TRUE                        
             END-IF                                                     
RS0727       IF NF-DEST-ID = 'CHECKFREE'                                
RS0727          SET CKF-ACCT TO TRUE                                    
RS0727       ELSE                                                       
RS0727          SET NON-CKF-ACCT TO TRUE                                
RS0727       END-IF                                                     
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET NON-EDI-ACCT         TO TRUE                          
RS0727        SET NON-CKF-ACCT         TO TRUE                          
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7800-CHK-EDI-ACCT     '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
RS0721     END-IF                                                       
           END-IF.                                                      
RS0524                                                                  
RS0524     IF EDI-ACCT                                                  
RS0524       IF WS-SUB                                                  
RS0524          PERFORM 7300-GET-ACCOUNT  THRU 7300-EXIT                
RS0524          IF WS-MST-SUB-IND EQUAL 'S'                             
RS0524             MOVE WS-MST-ACCT-NO    TO NF-ACCOUNT-NO              
RS0524          END-IF                                                  
RS0524       END-IF                                                     
RS0524     END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
C34456*                                                                         
C34456************************************************************              
C34456*                                                          *              
C34456*  7810-EDI-DEST                                           *              
C34456*                                                          *              
C34456************************************************************              
C34456                                                                  
C34456 7810-EDI-DEST.                                                   
C34456                                                                  
C34456     IF NON-EDI-ACCT                                              
C34456        GO TO 7810-EXIT                                           
C34456     END-IF.                                                      
C34456                                                                  
C34456     EXEC SQL                                                     
C34456         SELECT FORMAT_TYPE                                       
C34456           INTO :NJ-FORMAT-TYPE                                   
C34456         FROM CSS_EDI_DEST WITH(READUNCOMMITTED)                          
C34456         WHERE DEST_ID        = :WS-DEST-ID                       
C34456                                                           
C34456     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FORMAT_TYPE                                               
MFA-TR*          INTO :NJ-FORMAT-TYPE                                           
MFA-TR*        FROM CSS_EDI_DEST                                                
MFA-TR*        WHERE DEST_ID        = :WS-DEST-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34456                                                                  
C34456     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
C34456     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C34456        MOVE NJ-FORMAT-TYPE       TO WS-FORMAT-TYPE               
C34456     ELSE                                                         
C34456        DISPLAY '************** PCSCA710 ************'            
C34456        DISPLAY 'ERROR IN 7810-EDI-DEST     '                     
C34456        DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                  
C34456        DISPLAY 'DEST ID = ', WS-DEST-ID                          
C34456        DISPLAY 'PROCESSING TERMINATED  '                         
C34456        DISPLAY '************** PCSRP708 ************'            
C34456        PERFORM 9900-ABEND              THRU 9900-EXIT            
C34456     END-IF.                                                      
C34456                                                                  
C34456 7810-EXIT.                                                       
C34456     EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7850-CHK-DUP-ACCT                                       *              
      *                                                          *              
      ************************************************************              
                                                                        
       7850-CHK-DUP-ACCT.                                               
                                                                        
           SET  WS-N                    TO TRUE.                        
           MOVE WS-HOLD-ACCOUNT-NO      TO HZ-ACCOUNT-NO.               
           MOVE WS-REV-MO               TO HZ-REVENUE-MONTH.            
                                                                        
           EXEC SQL                                                     
C34456         SELECT TOP(1) 'Y'                                               
                 INTO :WS-DUP-IND                                       
               FROM CSS_EDI_BILL_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :HZ-ACCOUNT-NO                    
                 AND REVENUE_MONTH  = :HZ-REVENUE-MONTH                 
C34456                                              
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DUP-IND                                               
MFA-TR*        FROM CSS_EDI_BILL_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO     = :HZ-ACCOUNT-NO                            
MFA-TR*          AND REVENUE_MONTH  = :HZ-REVENUE-MONTH                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET WS-N                 TO TRUE                          
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7850-CHK-DUP-ACCT     '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7880-CHK-DUP-ACCT                                       *              
      *                                                          *              
      ************************************************************              
                                                                        
       7880-CHK-DUP-ACCT.                                               
                                                                        
           SET  WS-N                    TO TRUE.                        
           MOVE WS-BILL-NO              TO HF-BILL-NO.                  
           MOVE WS-HOLD-ACCOUNT-NO      TO HF-ACCOUNT-NO.               
                                                                        
           EXEC SQL                                                     
C34456         SELECT TOP(1) 'Y'                                               
                 INTO :WS-DUP-IND                                       
               FROM CSS_EDI_BILL_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :HF-ACCOUNT-NO                    
                 AND BILL_NO        = :HF-BILL-NO                       
C34456                                              
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DUP-IND                                               
MFA-TR*        FROM CSS_EDI_BILL_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO     = :HF-ACCOUNT-NO                            
MFA-TR*          AND BILL_NO        = :HF-BILL-NO                               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET WS-N                 TO TRUE                          
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7880-CHK-DUP-ACCT     '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'ACCOUNT NO = ', WS-HOLD-ACCOUNT-NO              
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                         
       7880-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7900-CHK-BILL-WINDOW                                    *              
      *                                                          *              
      ************************************************************              
                                                                        
       7900-CHK-BILL-WINDOW.                                            
                                                                        
           SET GET-BILL-WINDOW          TO TRUE.                        
                                                                        
           IF WS-DATE-BILLED = SPACES                                   
              GO TO 7900-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-DATE-BILLED          TO BN-DATE-EXTRACT.             
           MOVE WS-CYCLE                TO BN-BILL-CYCLE.               
                                                                        
           EXEC SQL                                                     
               SELECT REVENUE_MONTH                                     
                 INTO :BN-REVENUE-MONTH                                 
               FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                       
               WHERE DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                  
                 AND BILL_CYCLE     = :BN-BILL-CYCLE                    
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REVENUE_MONTH                                             
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*        FROM CSS_BILL_WINDOW                                             
MFA-TR*        WHERE DATE_EXTRACT   = :BN-DATE-EXTRACT                          
MFA-TR*          AND BILL_CYCLE     = :BN-BILL-CYCLE                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE BN-REVENUE-MONTH    TO WS-REV-MO                     
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              SET GET-JOB-PARM         TO TRUE                          
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7900-CHK-BILL-WINDOW  '                
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'BILL DATE  = ', WS-DATE-BILLED                  
               DISPLAY 'BILL CYCLE = ', WS-CYCLE                        
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7950-CHK-SUB-AMT                                        *              
      *                                                          *              
      ************************************************************              
                                                                        
       7950-CHK-SUB-AMT.                                                
                                                                        
           MOVE ZEROS                  TO WS-NI.                        
           MOVE WS-SUB-ACCT-NO         TO HF-ACCOUNT-NO.                
           MOVE WS-REV-MO              TO HZ-REVENUE-MONTH.             
                                                                        
           EXEC SQL                                                     
               SELECT SUM(BILLED_AM)                                    
                 INTO :HF-BILLED-AM :WS-NI                               
               FROM CSS_EDI_BILL_CHRGS HF WITH(READUNCOMMITTED),                
                    CSS_EDI_BILL_HDR   HZ WITH(READUNCOMMITTED)                 
               WHERE HF.ACCOUNT_NO    = :HF-ACCOUNT-NO                  
                 AND HZ.REVENUE_MONTH = :HZ-REVENUE-MONTH               
                 AND HF.ACCOUNT_NO    = HZ.ACCOUNT_NO                   
                 AND HF.CHARGE_TYPE_TX <> 'SUB001'                      
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(BILLED_AM)                                            
MFA-TR*          INTO :HF-BILLED-AM:WS-NI                                       
MFA-TR*        FROM CSS_EDI_BILL_CHRGS HF,                                      
MFA-TR*             CSS_EDI_BILL_HDR   HZ                                       
MFA-TR*        WHERE HF.ACCOUNT_NO    = :HF-ACCOUNT-NO                          
MFA-TR*          AND HZ.REVENUE_MONTH = :HZ-REVENUE-MONTH                       
MFA-TR*          AND HF.ACCOUNT_NO    = HZ.ACCOUNT_NO                           
MFA-TR*          AND HF.CHARGE_TYPE_TX <> 'SUB001'                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             IF WS-NI = -1                                              
                SET SUB-AM-NE TO TRUE                                   
             ELSE                                                       
             IF HF-BILLED-AM = WS-BILLED-AM                             
                SET SUB-AM-EQ TO TRUE                                   
             ELSE                                                       
                SET SUB-AM-NE TO TRUE                                   
                DISPLAY '*****SUB AMT NE MST SUB AMT ********'          
                DISPLAY 'SUB AMT ' HF-BILLED-AM                         
                DISPLAY 'MST AMT FOR SUB ' WS-BILLED-AM                 
             END-IF END-IF                                              
           ELSE                                                         
               DISPLAY '************** PCSCA710 ************'           
               DISPLAY 'ERROR IN 7950-CHK-SUB-AMT  '                    
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'SUB ACCT   = ', WS-SUB-ACCT-NO                  
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP708 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   RETRIEVE REVENUE MONTH FROM CSS_JOB_PARM                     *        
      ******************************************************************        
      *                                                                         
       7980-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,15,6))                          
                 INTO :WS-REV-MO-X                                      
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
C34456                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT (SUBSTR(PARM_DATA,15,6))                                  
MFA-TR*          INTO :WS-REV-MO-X                                              
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR ON 7980-GET-REVENUE-MONTH   **'        
              DISPLAY '**  COULD NOT GET REVENUE MONTH       **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7980-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *   8000-INSERT-HZ                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF CSS_EDI_BILL_HDR                     *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8000-INSERT-HZ.                                                  
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_BILL_HDR                              
                    (ACCOUNT_NO,                                        
                     AMT_DUE,                                           
                     BILL_DUE_DATE,                                     
                     BILL_NO,                                           
                     CODE_STATE_ID,                                     
                     CUSTOMER_NA,                                       
                     DATE_BILLED,                                       
                     DATE_CREATED,                                      
                     DATE_READ,                                         
                     EXTRACTED_FL,                                      
                     LAST_UPDATE_TS,                                    
                     LAST_UPDATE_USERID,                                
                     MST_ACCT_NO,                                       
                     MST_SUB_ACCT_IND,                                  
                     PURPOSE_CD,                                        
                     SCHED_SEND_DT,                                     
                     STATUS_CD,                                         
                     STREET_ADDR_1,                                     
                     STREET_ADDR_2,                                     
                     TRANS_CD,                                          
                     UPDATE_IND,                                        
                     ZIP_CODE,                                          
                     REVENUE_MONTH,                                     
                     ESTIMATED_FL,                                      
C36867               DIST_ACCT_NO)                                      
              VALUES                                                    
                    (:HZ-ACCOUNT-NO,                                    
                     :HZ-AMT-DUE,                                       
                     IIF(TRY_CONVERT(DATE, :HZ-BILL-DUE-DATE 
                                           :WS-DATE-DUE-NI
              ) IS NULL OR (PATINDEX('%.%', :HZ-BILL-DUE-DATE 
                                                        :WS-DATE-DUE-NI
              ) <> 0) OR (LEN(:HZ-BILL-DUE-DATE :WS-DATE-DUE-NI
              ) <> 10), CIS.CHAR2DATE(:HZ-BILL-DUE-DATE :WS-DATE-DUE-NI
              ), CONVERT(DATE, :HZ-BILL-DUE-DATE :WS-DATE-DUE-NI) ),           
                     :HZ-BILL-NO,                                       
                     :HZ-CODE-STATE-ID,                                 
                     :HZ-CUSTOMER-NA,                                   
                     IIF(TRY_CONVERT(DATE, :HZ-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-BILLED
              ) <> 0) OR (LEN(:HZ-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :HZ-DATE-BILLED
              ), CONVERT(DATE, :HZ-DATE-BILLED) ),                             
                     IIF(TRY_CONVERT(DATE, :HZ-DATE-CREATED
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-CREATED
              ) <> 0) OR (LEN(:HZ-DATE-CREATED) <> 10), CIS.CHAR2DATE(
                                                       :HZ-DATE-CREATED
              ), CONVERT(DATE, :HZ-DATE-CREATED) ),                            
                     IIF(TRY_CONVERT(DATE, :HZ-DATE-READ 
                                           :WS-DATE-READ-NI
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-READ 
                                                       :WS-DATE-READ-NI
              ) <> 0) OR (LEN(:HZ-DATE-READ :WS-DATE-READ-NI
              ) <> 10), CIS.CHAR2DATE(:HZ-DATE-READ :WS-DATE-READ-NI
              ), CONVERT(DATE, :HZ-DATE-READ :WS-DATE-READ-NI) ),              
                     :HZ-EXTRACTED-FL,                                  
                     CIS.CHAR2TIMESTAMP(:HZ-LAST-UPDATE-TS),                    
                     :HZ-LAST-UPDATE-USERID,                            
                     :HZ-MST-ACCT-NO,                                   
                     :HZ-MST-SUB-ACCT-IND,                              
                     :HZ-PURPOSE-CD,                                    
                     IIF(TRY_CONVERT(DATE, :HZ-SCHED-SEND-DT
              ) IS NULL OR (PATINDEX('%.%', :HZ-SCHED-SEND-DT
              ) <> 0) OR (LEN(:HZ-SCHED-SEND-DT) <> 10), CIS.CHAR2DATE(
                                                      :HZ-SCHED-SEND-DT
              ), CONVERT(DATE, :HZ-SCHED-SEND-DT) ),                           
                     :HZ-STATUS-CD,                                     
                     :HZ-STREET-ADDR-1,                                 
                     :HZ-STREET-ADDR-2,                                 
                     :HZ-TRANS-CD,                                      
                     :HZ-UPDATE-IND,                                    
                     :HZ-ZIP-CODE,                                      
                     :HZ-REVENUE-MONTH,                                 
                     :HZ-ESTIMATED-FL,                                  
C36867               :HZ-DIST-ACCT-NO)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EDI_BILL_HDR                                      
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              AMT_DUE,                                                   
MFA-TR*              BILL_DUE_DATE,                                             
MFA-TR*              BILL_NO,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              CUSTOMER_NA,                                               
MFA-TR*              DATE_BILLED,                                               
MFA-TR*              DATE_CREATED,                                              
MFA-TR*              DATE_READ,                                                 
MFA-TR*              EXTRACTED_FL,                                              
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              LAST_UPDATE_USERID,                                        
MFA-TR*              MST_ACCT_NO,                                               
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              PURPOSE_CD,                                                
MFA-TR*              SCHED_SEND_DT,                                             
MFA-TR*              STATUS_CD,                                                 
MFA-TR*              STREET_ADDR_1,                                             
MFA-TR*              STREET_ADDR_2,                                             
MFA-TR*              TRANS_CD,                                                  
MFA-TR*              UPDATE_IND,                                                
MFA-TR*              ZIP_CODE,                                                  
MFA-TR*              REVENUE_MONTH,                                             
MFA-TR*              ESTIMATED_FL,                                              
MFA-TR*              DIST_ACCT_NO)                                              
MFA-TR*       VALUES                                                            
MFA-TR*             (:HZ-ACCOUNT-NO,                                            
MFA-TR*              :HZ-AMT-DUE,                                               
MFA-TR*              :HZ-BILL-DUE-DATE:WS-DATE-DUE-NI,                          
MFA-TR*              :HZ-BILL-NO,                                               
MFA-TR*              :HZ-CODE-STATE-ID,                                         
MFA-TR*              :HZ-CUSTOMER-NA,                                           
MFA-TR*              :HZ-DATE-BILLED,                                           
MFA-TR*              :HZ-DATE-CREATED,                                          
MFA-TR*              :HZ-DATE-READ:WS-DATE-READ-NI,                             
MFA-TR*              :HZ-EXTRACTED-FL,                                          
MFA-TR*              :HZ-LAST-UPDATE-TS,                                        
MFA-TR*              :HZ-LAST-UPDATE-USERID,                                    
MFA-TR*              :HZ-MST-ACCT-NO,                                           
MFA-TR*              :HZ-MST-SUB-ACCT-IND,                                      
MFA-TR*              :HZ-PURPOSE-CD,                                            
MFA-TR*              :HZ-SCHED-SEND-DT,                                         
MFA-TR*              :HZ-STATUS-CD,                                             
MFA-TR*              :HZ-STREET-ADDR-1,                                         
MFA-TR*              :HZ-STREET-ADDR-2,                                         
MFA-TR*              :HZ-TRANS-CD,                                              
MFA-TR*              :HZ-UPDATE-IND,                                            
MFA-TR*              :HZ-ZIP-CODE,                                              
MFA-TR*              :HZ-REVENUE-MONTH,                                         
MFA-TR*              :HZ-ESTIMATED-FL,                                          
MFA-TR*              :HZ-DIST-ACCT-NO)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
              SET NON-EDI-ACCT        TO TRUE                           
              DISPLAY '*******************************************'     
              DISPLAY '**   Duplicate Account Record            **'     
              DISPLAY ' ACCOUNT # = ', WS-HOLD-ACCOUNT-NO               
              DISPLAY '*******************************************'     
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA710 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO HZ TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY ' ACCOUNT   = ', WS-HOLD-ACCOUNT-NO               
              DISPLAY ' DUE  DATE = ', HZ-BILL-DUE-DATE                 
              DISPLAY ' BILL DATE = ', HZ-DATE-BILLED                   
              DISPLAY ' READ DATE = ', HZ-DATE-READ                     
              DISPLAY ' SEND DATE = ', HZ-SCHED-SEND-DT                 
              DISPLAY ' CREATE DATE = ', HZ-DATE-CREATED                
              DISPLAY ' UPDATE TS = ', HZ-LAST-UPDATE-TS                
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8100-INSERT-HW                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF CSS_EDI_BILL_USAGE                   *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8100-INSERT-HW.                                                  
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_BILL_USAGE                            
                    (ACCOUNT_NO,                                        
                     BEGIN_READ_DT,                                     
                     BEGIN_READING,                                     
                     BILL_NO,                                           
                     BTU_FACTOR,                                        
                     CODE_TIME_PERIOD,                                  
                     CODE_UTIL_TYPE,                                    
                     CONSTANT,                                          
                     END_READ_DT,                                       
                     END_READING,                                       
                     IC_NO,                                             
                     METER_NO,                                          
                     NO_UNITS,                                          
                     RATE_PLAN_NO,                                      
                     SEQ_NO,                                            
                     USAGE_CD,                                          
A01749               DDDC_FACTOR,                                       
A03511               RATE_PLAN_DESC_TX,                                 
A03511               RATE_PLAN_DESC_EXT)                                
              VALUES                                                    
                    (:HW-ACCOUNT-NO,                                    
                     IIF(TRY_CONVERT(DATE, :HW-BEGIN-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-BEGIN-READ-DT
              ) <> 0) OR (LEN(:HW-BEGIN-READ-DT) <> 10), CIS.CHAR2DATE(
                                                      :HW-BEGIN-READ-DT
              ), CONVERT(DATE, :HW-BEGIN-READ-DT) ),                           
                     :HW-BEGIN-READING,                                 
                     :HW-BILL-NO,                                       
                     :HW-BTU-FACTOR,                                    
                     :HW-CODE-TIME-PERIOD,                              
                     :HW-CODE-UTIL-TYPE,                                
                     :HW-CONSTANT,                                      
                     IIF(TRY_CONVERT(DATE, :HW-END-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-END-READ-DT
              ) <> 0) OR (LEN(:HW-END-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :HW-END-READ-DT
              ), CONVERT(DATE, :HW-END-READ-DT) ),                             
                     :HW-END-READING,                                   
                     :HW-IC-NO,                                         
                     :HW-METER-NO,                                      
                     :HW-NO-UNITS,                                      
                     :HW-RATE-PLAN-NO,                                  
                     :HW-SEQ-NO,                                        
                     :HW-USAGE-CD,                                      
A01749               :HW-DDDC-FACTOR,                                   
A03511               :HW-RATE-PLAN-DESC-TX,                             
A03511               :HW-RATE-PLAN-DESC-EXT)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EDI_BILL_USAGE                                    
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              BEGIN_READ_DT,                                             
MFA-TR*              BEGIN_READING,                                             
MFA-TR*              BILL_NO,                                                   
MFA-TR*              BTU_FACTOR,                                                
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              CONSTANT,                                                  
MFA-TR*              END_READ_DT,                                               
MFA-TR*              END_READING,                                               
MFA-TR*              IC_NO,                                                     
MFA-TR*              METER_NO,                                                  
MFA-TR*              NO_UNITS,                                                  
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              SEQ_NO,                                                    
MFA-TR*              USAGE_CD,                                                  
MFA-TR*              DDDC_FACTOR,                                               
MFA-TR*              RATE_PLAN_DESC_TX,                                         
MFA-TR*              RATE_PLAN_DESC_EXT)                                        
MFA-TR*       VALUES                                                            
MFA-TR*             (:HW-ACCOUNT-NO,                                            
MFA-TR*              :HW-BEGIN-READ-DT,                                         
MFA-TR*              :HW-BEGIN-READING,                                         
MFA-TR*              :HW-BILL-NO,                                               
MFA-TR*              :HW-BTU-FACTOR,                                            
MFA-TR*              :HW-CODE-TIME-PERIOD,                                      
MFA-TR*              :HW-CODE-UTIL-TYPE,                                        
MFA-TR*              :HW-CONSTANT,                                              
MFA-TR*              :HW-END-READ-DT,                                           
MFA-TR*              :HW-END-READING,                                           
MFA-TR*              :HW-IC-NO,                                                 
MFA-TR*              :HW-METER-NO,                                              
MFA-TR*              :HW-NO-UNITS,                                              
MFA-TR*              :HW-RATE-PLAN-NO,                                          
MFA-TR*              :HW-SEQ-NO,                                                
MFA-TR*              :HW-USAGE-CD,                                              
MFA-TR*              :HW-DDDC-FACTOR,                                           
MFA-TR*              :HW-RATE-PLAN-DESC-TX,                                     
MFA-TR*              :HW-RATE-PLAN-DESC-EXT)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA710 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO HW TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY ' ACCOUNT = ', WS-HOLD-ACCOUNT-NO                 
              DISPLAY ' HW RECORD = ', DCLCSS-EDI-BILL-USAGE            
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8200-INSERT-HF                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF CSS_EDI_BILL_CHGS                    *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8200-INSERT-HF.                                                  
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_BILL_CHRGS                            
                    (ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     BILL_UNITS,                                        
                     BILLED_AM,                                         
                     CHARGE_TYPE_TX,                                    
                     IC_NO,                                             
                     SEQ_NO,                                            
                     USAGE_CD,                                          
                     CHARGE_TYPE_DESC,                                  
                     SUB_ACCT_NO,                                       
                     CODE_UTIL_TYPE)                                    
              VALUES                                                    
                    (:HF-ACCOUNT-NO,                                    
                     :HF-BILL-NO,                                       
                     :HF-BILL-UNITS,                                    
                     :HF-BILLED-AM,                                     
                     :HF-CHARGE-TYPE-TX,                                
                     :HF-IC-NO,                                         
                     :HF-SEQ-NO,                                        
                     :HF-USAGE-CD,                                      
                     :HF-CHARGE-TYPE-DESC,                              
                     :HF-SUB-ACCT-NO :WS-SUB-ACCT-NI,                    
                     :HF-CODE-UTIL-TYPE)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA710 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO HF TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY ' ACCOUNT = ', WS-HOLD-ACCOUNT-NO                 
              DISPLAY ' HF RECORD = ', DCLCSS-EDI-BILL-CHRGS            
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  8300-UPD-EDI-HDR                                        *              
      *                                                          *              
      ************************************************************              
                                                                        
       8300-UPD-EDI-HDR.                                                
                                                                        
           MOVE WS-REV-MO             TO HZ-REVENUE-MONTH.              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EDI_BILL_HDR                                  
                  SET STATUS_CD     = :WS-STATUS-CD                     
                WHERE ACCOUNT_NO    = :WS-SUB-ACCT-NO                   
                  AND REVENUE_MONTH = :HZ-REVENUE-MONTH                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA710 PROCESSING ERROR           **'     
              DISPLAY '**   UPDATE TO HZ TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS:'  WS-ACTIVE-RETURN-CODE        
              DISPLAY ' ACCOUNT = ', WS-HOLD-ACCOUNT-NO                 
              DISPLAY ' SUB ACCT  = ', WS-SUB-ACCT-NO                   
              DISPLAY ' STATUS CD = ', WS-STATUS-CD                     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  8350-UPD-EDI-HDR                                        *              
      *                                                          *              
      ************************************************************              
                                                                        
       8350-UPD-EDI-HDR.                                                
                                                                        
           MOVE WS-HOLD-ACCOUNT-NO    TO HZ-ACCOUNT-NO.                 
           MOVE WS-BILL-NO            TO HZ-BILL-NO.                    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EDI_BILL_HDR                                  
                  SET STATUS_CD   = :WS-STATUS-CD                       
                WHERE ACCOUNT_NO  = :HZ-ACCOUNT-NO                      
                  AND BILL_NO     = :HZ-BILL-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA710 PROCESSING ERROR           **'     
              DISPLAY '**   UPDATE TO HZ TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS:'  WS-ACTIVE-RETURN-CODE        
              DISPLAY ' ACCOUNT = ', WS-HOLD-ACCOUNT-NO                 
              DISPLAY ' SUB ACCT  = ', WS-SUB-ACCT-NO                   
              DISPLAY ' STATUS CD = ', WS-STATUS-CD                     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  8700-COMMIT                                             *              
      *                                                          *              
      ************************************************************              
                                                                        
       8700-COMMIT.                                                     
                                                                        
C34456     EXEC SQL                                                     
C34456         COMMIT                                                   
C34456     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE28-FILE.                                          
                                                                        
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM PROBLEM OCCURS.                          *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
                                                                        
RS1215     EXEC SQL                                                     
RS1215         ROLLBACK                                                 
RS1215     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
