       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA704.                                        
       DATE-WRITTEN.   JULY 1999                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      *              M O D U L E   I N F O R M A T I O N              *         
      *                                                               *         
      *  MODULE NAME:  PCSCA704                                       *         
      *                                                               *         
      *  MODULE DESC:  CREATES 2 REPORTS REGARDING CHANGES MADE TO    *         
      *                CHECK STATUS CODES:                            *         
      *                1) LISTS DETAIL FOR CHECKS MARKED AS 'L'       *         
      *                   (CLEARED) DURING THE MONTH.                 *         
      *                2) LISTS DETAIL FOR CHECKS MARKED AS 'X'       *         
      *                   (VOIDED) AND 'S' (STOP PAY) DURING THE      *         
      *                   MONTH.                                      *         
      *                                                               *         
      *  LANGUAGE   :  COBOL II / DB2                                 *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
      *               M A I N T E N A N C E   L O G                   *         
      *                                                               *         
      * DATE        USERID   DESCRIPTION                              *         
      *---------------------------------------------------------------*         
      * 1999-07-30  CB18344  INITIAL CODING                           *         
T22231* 2000-07-21  DS19153  CHANGE PROGRAM TO BASE REPORTS ON A      *         
T22231*                      REVENUE MONTH, INSTEAD OF A CALENDAR MO. *         
T20186* 2000-09-08  CB18344  MADE CHANGES TO ALLOW REPORT OF ESCHEATED*         
T20186*                      THAT ARE VOIDED EACH MONTH.              *         
T22793* 2000-10-04  SM19368  MADE CHANGES TO ALLOW REPORT PCSCA704-01*          
T22793*                      GENERATE BY CALENDAR MONTH INSTEAD       *         
T22793*                      REVENUE MONTH. THIS REPORT IS NOW        *         
T22793*                      PRODUCING IN A SEPERATE ROUTINE:         *         
T22793*                      2001-PRODUCE-REPORTS                     *         
C23521* 2001-01-18  CB18344  MADE CHANGES TO USE SYSTEM DATE INSTEAD  *         
C23521*                      OF REPORTDATE.                           *         
T23875* 2001-07-30  KS88119  MADE CHANGES TO USE COMPANY BREAK LOGIC  *         
T23875*                      FOR THE REPORT.                          *         
T25319* 2001-10-10  DL85939  MULTICOMPANY - TO FIX ABEND IN SEB.      *         
T27145* 2002-09-06  COVANSYS GENERATE THREE REFUND REPORTS FOR        *         
T27145*                      SCANA ENERGY REGULATED DIVISION.         *         
T35434* 2007-05-23  COVANSYS REPLACED MODEL_SQL TO SET COMMANDS AND   *         
T35434*                      ADDED FOR FETCH ONLY WITH UR TO AVOID    *         
T35434*                      -911S.                                   *         
ACT144*   08/13/13  BD09555     REPLACE DATE CARD WITH DB2 COMMON DATE *        
      *   A04524                                                       *        
      *****************************************************************         
      *                   M O D U L E   F L O W                       *         
      *                                                               *         
      *   PARAGRAPH                                                   *         
      *  FROM - THRU     DESCRIPTION                                  *         
      *  -----------------------------------------------------------  *         
      *  0000 - 0999     MAIN CONTROL PATH                            *         
      *  1000 - 1999     INITIALIZATION, PRINTING TITLES, AND         *         
      *                  INITIAL READS                                *         
      *  2000 - 2999     COMMON PROCESSING                            *         
      *  3000 - 3999     GRAND TOTAL PROCESSING                       *         
      *  4000 - 4999     NAME/ADDRESS PROCESSING                      *         
      *  6000 - 6999     REDUCE EMBEDDED SPACES PROCESSING            *         
      *  7000 - 7999     INQUIRY CALLS TO INPUT FILES / DATABASE      *         
      *  9000 - 9999     TERMINATION ROUTINES                         *         
      *                                                               *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *          E N V I R O N M E N T   D I V I S I O N              *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
                                                                        
      *****************************************************************         
      *  C O N F I G U R A T I O N   S E C T I O N                    *         
      *****************************************************************         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
                                                                        
      *****************************************************************         
      *  I N P U T - O U T P U T   S E C T I O N                      *         
      *****************************************************************         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCPT7041-FILE                                         
               ASSIGN UT-S-FCPT7041.                                    
                                                                        
           SELECT FCPT7042-FILE                                         
               ASSIGN UT-S-FCPT7042.                                    
T20186                                                                  
T20186     SELECT FCPT7043-FILE                                         
T20186         ASSIGN UT-S-FCPT7043.                                    
                                                                        
T27145     SELECT FCPT7044-FILE                                         
T27145         ASSIGN UT-S-FCPT7044.                                    
T27145                                                                  
T27145     SELECT FCPT7045-FILE                                         
T27145         ASSIGN UT-S-FCPT7045.                                    
T27145                                                                  
T27145     SELECT FCPT7046-FILE                                         
T27145         ASSIGN UT-S-FCPT7046.                                    
T27145                                                                  
      *****************************************************************         
      *                    D A T A   D I V I S I O N                  *         
      *****************************************************************         
       DATA DIVISION.                                                   
                                                                        
      *****************************************************************         
      *  F I L E   S E C T I O N                                      *         
      *****************************************************************         
       FILE SECTION.                                                    
                                                                        
       FD  FCPT7041-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT7041-RECORD.                                              
           05  PRT7041-CC                PIC X(01).                     
           05  PRT7041-DATA              PIC X(132).                    
                                                                        
       FD  FCPT7042-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT7042-RECORD.                                              
           05  PRT7042-CC                PIC X(01).                     
           05  PRT7042-DATA              PIC X(132).                    
                                                                        
       FD  FCPT7043-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT7043-RECORD.                                              
           05  PRT7043-CC                PIC X(01).                     
           05  PRT7043-DATA              PIC X(132).                    
                                                                        
T27145 FD  FCPT7044-FILE                                                
T27145     BLOCK CONTAINS 0 RECORDS                                     
T27145     RECORDING MODE IS F                                          
T27145     LABEL RECORDS ARE STANDARD.                                  
T27145 01  PRT7044-RECORD.                                              
T27145     05  PRT7044-CC                PIC X(01).                     
T27145     05  PRT7044-DATA              PIC X(132).                    
T27145                                                                  
T27145                                                                  
T27145 FD  FCPT7045-FILE                                                
T27145     BLOCK CONTAINS 0 RECORDS                                     
T27145     RECORDING MODE IS F                                          
T27145     LABEL RECORDS ARE STANDARD.                                  
T27145 01  PRT7045-RECORD.                                              
T27145     05  PRT7045-CC                PIC X(01).                     
T27145     05  PRT7045-DATA              PIC X(132).                    
T27145                                                                  
T27145 FD  FCPT7046-FILE                                                
T27145     BLOCK CONTAINS 0 RECORDS                                     
T27145     RECORDING MODE IS F                                          
T27145     LABEL RECORDS ARE STANDARD.                                  
T27145 01  PRT7046-RECORD.                                              
T27145     05  PRT7046-CC                PIC X(01).                     
T27145     05  PRT7046-DATA              PIC X(132).                    
T27145                                                                  
      *****************************************************************         
      *  W O R K I N G - S T O R A G E   S E C T I O N                *         
      *****************************************************************         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA704'.
MSQ017     COPY MFASQLM.
                                                                        
      *****                                                                     
      *  START OF WORKING STORAGE                                               
      *****                                                                     
       01  WS00-START                         PIC X(40) VALUE           
           'WORKING STORAGE FOR PCSCA704 STARTS HERE'.                  
                                                                        
      *****                                                                     
      *  CONSTANTS AND SWITCHES                                                 
      *****                                                                     
       01  WS01-CONSTANTS-AND-SWITCHES.                                 
           05  C01-CONSTANTS.                                           
               10  C01-YES                    PIC X(01) VALUE 'Y'.      
               10  C01-NO                     PIC X(01) VALUE 'N'.      
               10  C01-COMPANY-NO             PIC X(02) VALUE '01'.     
T23875         10  C26-COMPANY-NO             PIC X(02) VALUE '26'.     
               10  C01-PROGRAM-NAME           PIC X(08) VALUE           
                   'PCSCA704'.                                          
               10  C01-REPORT1-NAME           PIC X(11) VALUE           
                   'PCSCA704-01'.                                       
               10  C01-REPORT2-NAME           PIC X(11) VALUE           
                   'PCSCA704-02'.                                       
T20186         10  C01-REPORT3-NAME           PIC X(11) VALUE           
T20186             'PCSCA704-03'.                                       
T27145         10  C01-REPORT4-NAME           PIC X(11) VALUE           
T27145             'PCSCA704-04'.                                       
T27145         10  C01-REPORT5-NAME           PIC X(11) VALUE           
T27145             'PCSCA704-05'.                                       
T27145         10  C01-REPORT6-NAME           PIC X(11) VALUE           
T27145             'PCSCA704-06'.                                       
               10  PROGRAM-NAME               PIC X(08) VALUE           
                   'PCSCA704'.                                          
T23875         10  WS-REFUND-DATA-STATUS      PIC X(01) VALUE 'Y'.      
T23875             88 WS-REFUND-NO-DATA       VALUE 'N'.                
T23875             88 WS-REFUND-DATA          VALUE 'Y'.                
T27145         10  WS-SEBR-REFUND-DATA-STATUS PIC X(01) VALUE 'Y'.      
T27145             88 WS-SEBR-REFUND-NO-DATA  VALUE 'N'.                
T27145             88 WS-SEBR-REFUND-DATA     VALUE 'Y'.                
T23875         10  WS-CL-REFUND-DATA-STATUS   PIC X(01) VALUE 'Y'.      
T23875             88 WS-CL-REFUND-NO-DATA    VALUE 'N'.                
T23875             88 WS-CL-REFUND-DATA       VALUE 'Y'.                
T27145         10  WS-SEBR-CL-REFUND-DATA-STATUS   PIC X(01) VALUE 'Y'. 
T27145             88 WS-SEBR-CL-REFUND-NO-DATA         VALUE 'N'.      
T27145             88 WS-SEBR-CL-REFUND-DATA            VALUE 'Y'.      
               10  WS-Y                       PIC X(01) VALUE 'Y'.      
               10  WS-N                       PIC X(01) VALUE 'N'.      
               10  WS-ONE                     PIC X(02) VALUE '01'.     
               10  WS-REFUND-STATUS-DT-NULL   PIC S9(4) COMP VALUE  0.  
                   88  REFUND-STATUS-DT-NULL                 VALUE -1.  
T20186         10  WS-DATE-ESCHEATED-NULL     PIC S9(4) COMP VALUE  0.  
T20186             88  DATE-ESCHEATED-NULL                   VALUE -1.  
               10  WS-CANCEL-PAGE-BREAK       PIC X(1)  VALUE 'N'.      
               10  WS-CLEAR-PAGE-BREAK        PIC X(1)  VALUE 'N'.      
T23875         10  WS-HOLD-COMPANY            PIC X(02) VALUE SPACES.   
T27145     05  WS-NOT-SEBR                    PIC X(01) VALUE 'N'.      
T27145     05  WS-YES-SEBR                    PIC X(01) VALUE 'Y'.      
T27145     05  WS-SEBR-FOUND                  PIC X(01) VALUE 'N'.      
T27145     05  WS-SEBR-NOT                    PIC X(01) VALUE 'N'.      
T27145     05  WS-SEBR-YES                    PIC X(01) VALUE 'Y'.      
T27145     05  WS-FOUND-SEBR                  PIC X(01) VALUE 'N'.      
T27145     05  WS-FIRST-TIME                  PIC X(01) VALUE 'Y'.      
T27145     05  WS-TIME-FIRST                  PIC X(01) VALUE 'Y'.      
T27145     05  WS-DEREG-TITLE                 PIC X(23) VALUE           
T27145                                        ' - DEREGULATED DIVISION'.
T27145     05  WS-REG-TITLE                   PIC X(23) VALUE           
T27145                                        ' - REGULATED DIVISION  '.
T27145     05  WS05-SEBR-DET-CLR-CNT          PIC 9(05).                
T27145     05  WS05-SEBR-DET-CLR-AMT          PIC 9(06)V9(02).          
T27145     05  WS05-SEBR-DET-CLR-CNT-TOT      PIC 9(05).                
T27145     05  WS05-SEBR-DET-CLR-AMT-TOT      PIC 9(06)V9(02).          
T27145     05  WS05-SEBR-DET-CAN-CNT          PIC 9(05).                
T27145     05  WS05-SEBR-DET-CAN-AMT          PIC 9(06)V9(02).          
T27145     05  WS05-SEBR-DET-CAN-CNT-TOT      PIC 9(05).                
T27145     05  WS05-SEBR-DET-CAN-AMT-TOT      PIC 9(06)V9(02).          
T27145     05  WS05-SEBR-DET-ESC-CNT          PIC 9(05).                
T27145     05  WS05-SEBR-DET-ESC-AMT          PIC 9(06)V9(02).          
T27145     05  WS05-SEBR-DET-ESC-CNT-TOT      PIC 9(05).                
T27145     05  WS05-SEBR-DET-ESC-AMT-TOT      PIC 9(06)V9(02).          
T27145     05  WS-SEB-ROW                     PIC X(01) VALUE 'N'.      
T27145             88  ROW-PRESENT                      VALUE 'Y'.      
T27145     05  WS-ROW-SEB                     PIC X(01) VALUE 'N'.      
T27145             88  PRESENT-ROW                      VALUE 'Y'.      
T23875     05  WS-COMPANY-ONE                 PIC X(01) VALUE 'Y'.      
T23875             88  SCEG-FIRST                       VALUE 'Y'.      
T23875             88  SCEG-SECOND                      VALUE 'N'.      
T23875     05  WS-COMPANY-TWO                 PIC X(01) VALUE 'Y'.      
T23875             88  FIRST-SCEG                       VALUE 'Y'.      
T23875             88  SECOND-SCEG                      VALUE 'N'.      
T23875     05  WS-COMPANY-PSNC                PIC X(01) VALUE 'Y'.      
T23875             88  NO-PSNC                          VALUE 'N'.      
T23875     05  WS-COMPANY-PNC                 PIC X(01) VALUE 'Y'.      
T23875             88  NOT-PSNC                         VALUE 'N'.      
T25319     05  WS-DATABASE                    PIC 9(1)  VALUE 0.        
T25319             88 CSR-DATABASE                      VALUE 1.        
T25319             88 SEB-DATABASE                      VALUE 2.        
ACT144     05  WS-END-DATE                      PIC X(10).              
ACT144     05  FILLER REDEFINES WS-END-DATE.                            
ACT144         10  WS-END-CCYY                PIC 9999.                 
ACT144         10  FILLER                     PIC X.                    
ACT144         10  WS-END-MONTH               PIC 99.                   
ACT144         10  FILLER                     PIC X.                    
ACT144         10  WS-END-DAY                 PIC 99.                   
C23521*                                                                         
C23521 01  WS01-BEG-DATE.                                               
C23521     05  WS01-BEG-YYYY.                                           
C23521         10  WS01-BEG-CC                PIC X(02).                
C23521         10  WS01-BEG-YY                PIC X(02).                
C23521     05  FILLER                         PIC X(01) VALUE '-'.      
C23521     05  WS01-BEG-MM                    PIC X(02).                
C23521     05  FILLER                         PIC X(01) VALUE '-'.      
C23521     05  WS01-BEG-DD                    PIC X(02).                
C23521*                                                                         
C23521 01  WS01-END-DATE.                                               
C23521     05  WS01-END-YYYY.                                           
C23521         10  WS01-END-CC                PIC X(02).                
C23521         10  WS01-END-YY                PIC X(02).                
C23521     05  FILLER                         PIC X(01) VALUE '-'.      
C23521     05  WS01-END-MM                    PIC X(02).                
C23521     05  FILLER                         PIC X(01) VALUE '-'.      
C23521     05  WS01-END-DD                    PIC X(02).                
      *****                                                                     
      *  TITLES AND HEADERS                                                     
      *****                                                                     
       01  WS01-TITLES-AND-HEADERS.                                     
           05  WS01-TITLES.                                             
               10  WS01-TITLE1A.                                        
                   15  FILLER                 PIC X(01) VALUE SPACES.   
                   15  WS01-TITLE1A-REPTNAME  PIC X(11).                
                   15  FILLER                 PIC X(41) VALUE SPACES.   
                   15  WS01-TITLE1A-COMP-NAME PIC X(26).                
                   15  FILLER                 PIC X(33) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'RUN-DATE: '.                              
                   15  WS01-TITLE1A-RUN-DT    PIC X(10).                
      *                                                                         
T27145        10  WS01-TITLE1A-SEB REDEFINES WS01-TITLE1A.              
T27145            15  FILLER                     PIC X(53).             
T27145            15  WS01-TITLE1A-SEB-COMP-NAME PIC X(12).             
T27145            15  WS01-TITLE1A-SEB-DIV       PIC X(23).             
T27145            15  FILLER                     PIC X(44).             
T27145*                                                                         
               10  WS01-TITLE1B.                                        
                   15  FILLER                 PIC X(48) VALUE SPACES.   
                   15  FILLER                 PIC X(29) VALUE           
                       'CHECKS PAID FOR THE MONTH OF '.                 
                   15  WS01-TITLE1B-DATE.                               
                       20  WS01-TITLE1B-MTH   PIC X(02).                
                       20  FILLER             PIC X(01) VALUE '/'.      
                       20  WS01-TITLE1B-YR    PIC X(04).                
                   15  FILLER                 PIC X(28) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'RUN-TIME: '.                              
                   15  WS01-TITLE1B-RUN-TM    PIC X(08).                
      *                                                                         
               10  WS01-TITLE1C.                                        
                   15  FILLER                 PIC X(60) VALUE SPACES.   
                   15  FILLER                 PIC X(13)                 
                       VALUE 'DETAIL REPORT'.                           
                   15  FILLER                 PIC X(43) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'PAGE:     '.                              
                   15  WS01-TITLE1C-PAGE-NBR  PIC ZZ,ZZ9.               
      *                                                                         
               10  WS02-TITLE2B.                                        
                   15  FILLER                 PIC X(41) VALUE SPACES.   
                   15  FILLER                 PIC X(43) VALUE           
                       'CHECKS CANCELLED (VOIDED) FOR THE MONTH OF '.   
                   15  WS02-TITLE2B-DATE.                               
                       20  WS02-TITLE2B-MTH   PIC X(02).                
                       20  FILLER             PIC X(01) VALUE '/'.      
                       20  WS02-TITLE2B-YR    PIC X(04).                
                   15  FILLER                 PIC X(21) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'RUN-TIME: '.                              
                   15  WS02-TITLE2B-RUN-TM    PIC X(08).                
      *                                                                         
               10  WS02-TITLE2C.                                        
                   15  FILLER                 PIC X(60) VALUE SPACES.   
                   15  FILLER                 PIC X(13)                 
                       VALUE 'DETAIL REPORT'.                           
                   15  FILLER                 PIC X(43) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'PAGE:     '.                              
                   15  WS02-TITLE2C-PAGE-NBR  PIC ZZ,ZZ9.               
      *                                                                         
T20186         10  WS02-TITLE3B.                                        
T20186             15  FILLER                 PIC X(36) VALUE SPACES.   
T20186             15  FILLER                 PIC X(43) VALUE           
T20186                 'ESCHEATED CHECKS CANCELLED (VOIDED) FOR THE'.   
T20186             15  FILLER                 PIC X(10) VALUE           
T20186                 ' MONTH OF '.                                    
T20186             15  WS02-TITLE3B-DATE.                               
T20186                 20  WS02-TITLE3B-MTH   PIC X(02).                
T20186                 20  FILLER             PIC X(01) VALUE '/'.      
T20186                 20  WS02-TITLE3B-YR    PIC X(04).                
T20186             15  FILLER                 PIC X(16) VALUE SPACES.   
T20186             15  FILLER                 PIC X(10)                 
T20186                 VALUE 'RUN-TIME: '.                              
T20186             15  WS02-TITLE3B-RUN-TM    PIC X(08).                
T20186*                                                                         
T20186         10  WS02-TITLE3C.                                        
T20186             15  FILLER                 PIC X(60) VALUE SPACES.   
                   15  FILLER                 PIC X(13)                 
                       VALUE 'DETAIL REPORT'.                           
                   15  FILLER                 PIC X(43) VALUE SPACES.   
                   15  FILLER                 PIC X(10)                 
                       VALUE 'PAGE:     '.                              
                   15  WS02-TITLE3C-PAGE-NBR  PIC ZZ,ZZ9.               
      *                                                                         
           05  WS-HEADERS.                                              
               10  WS-HEADERS-DETAIL.                                   
                   15  WS-HEADER1-DETAIL.                               
                       20  FILLER             PIC X(07) VALUE SPACES.   
                       20  FILLER             PIC X(05) VALUE           
                           'CHECK'.                                     
                       20  FILLER             PIC X(13) VALUE SPACES.   
                       20  FILLER             PIC X(05) VALUE           
                           'CHECK'.                                     
                       20  FILLER             PIC X(86) VALUE SPACES.   
                       20  FILLER             PIC X(07) VALUE           
                           'ACCOUNT'.                                   
                       20  FILLER             PIC X(09) VALUE SPACES.   
      *                                                                         
                   15  WS-HEADER2-DETAIL.                               
                       20  FILLER             PIC X(07) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'NUMBER'.                                    
                       20  FILLER             PIC X(12) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'AMOUNT'.                                    
                       20  FILLER             PIC X(07) VALUE SPACES.   
                       20  FILLER             PIC X(09) VALUE           
                           'STATUS CD'.                                 
                       20  FILLER             PIC X(06) VALUE SPACES.   
                       20  FILLER             PIC X(09) VALUE           
                           'STATUS DT'.                                 
                       20  FILLER             PIC X(18) VALUE SPACES.   
                       20  FILLER             PIC X(13) VALUE           
                           'CUSTOMER NAME'.                             
                       20  FILLER             PIC X(23) VALUE SPACES.   
                       20  FILLER             PIC X(06) VALUE           
                           'NUMBER'.                                    
                       20  FILLER             PIC X(10) VALUE SPACES.   
                                                                        
      *****                                                                     
      *  DETAIL LINES                                                           
      *****                                                                     
       01  WS03-DETAIL-LINES.                                           
           05  WS03-BLANK-LINE                PIC X(133) VALUE SPACES.  
           05  WS03-LINE-DETAIL.                                        
               10  FILLER                     PIC X(04) VALUE SPACES.   
               10  WS03-CHECK-NO              PIC ZZZ999999.            
               10  FILLER                     PIC X(06) VALUE SPACES.   
               10  WS03-CHECK-AMOUNT          PIC ZZ,ZZZ,ZZZ.99.        
               10  FILLER                     PIC X(07) VALUE SPACES.   
               10  WS03-CHECK-STATUS          PIC X(12).                
               10  FILLER                     PIC X(02) VALUE SPACES.   
               10  WS03-REFUND-STATUS-DT      PIC X(10).                
               10  FILLER                     PIC X(05) VALUE SPACES.   
               10  WS03-CUSTOMER-NAME         PIC X(42).                
               10  FILLER                     PIC X(04) VALUE SPACES.   
               10  WS03-ACCOUNT-NO            PIC 9999999999999.        
               10  FILLER                     PIC X(05) VALUE SPACES.   
           05  WS03-END-DATA-LINE.                                      
               10  FILLER                     PIC X(56) VALUE SPACES.   
               10  FILLER                     PIC X(22)                 
                   VALUE '*** END OF REPORT *** '.                      
               10  FILLER                     PIC X(55) VALUE SPACES.   
T23875*****                                                                     
T23875*  NO-DATA                                                                
T23875*****                                                                     
T23875 01  WS04A-NO-DATA-LINE.                                          
T23875     05  FILLER                         PIC X(55) VALUE SPACES.   
T23875     05  FILLER                         PIC X(22) VALUE           
T23875               '** NO DATA THIS RUN **'.                          
T23875     05  FILLER                         PIC X(55) VALUE SPACES.   
                                                                        
      *****                                                                     
      *  DATES, TIMES AND TIMESTAMPS                                            
      *****                                                                     
       01  WS04-DATE-TIME-STAMPS.                                       
           05  WS04-CURRENT-TS                PIC X(26).                
           05  WS04-CURRENT-TS-BREAKDOWN   REDEFINES WS04-CURRENT-TS.   
               10  WS04-CURRENT-DATE.                                   
                   15  WS04-CURRENT-YEAR      PIC X(04).                
                   15  FILLER                 PIC X(01).                
                   15  WS04-CURRENT-MONTH     PIC X(02).                
                   15  FILLER                 PIC X(01).                
                   15  WS04-CURRENT-DAY       PIC X(02).                
               10  FILLER                     PIC X(01).                
               10  WS04-CURRENT-TIME.                                   
                   15  WS04-CURRENT-HOUR      PIC X(02).                
                   15  FILLER                 PIC X(01).                
                   15  WS04-CURRENT-MIN       PIC X(02).                
                   15  FILLER                 PIC X(01).                
                   15  WS04-CURRENT-SEC       PIC X(02).                
                   15  FILLER                 PIC X(01).                
                   15  WS04-CURRENT-MSEC      PIC X(06).                
T22231     05  WS04-REV-YYYYMM.                                         
T22231         10  WS04-REV-YYYY              PIC 9(04).                
T22231         10  WS04-REV-MM                PIC 9(02).                
T22231     05  WS04-REV-TEMP                  PIC X(06).                
COB305     05 WS04-REV-MONTH        PIC S9(06)V USAGE COMP-3 VALUE 0. 
T22231     05  WS04-BEG-REV-DT                PIC X(10).                
T22231     05  WS04-END-REV-DT                PIC X(10).                
                                                                        
                                                                        
                                                                        
       01  WS05-WORK-AREA.                                              
           05  WS-PGRMNAME                    PIC X(08).                
           05  WS05-DETAIL-AREA.                                        
               10  WS05-DETAIL-CLEARED.                                 
                   15  WS05-DET-CLR-CNT       PIC 9(05).                
                   15  WS05-DET-CLR-CNT-TOT   PIC 9(05).                
                   15  WS05-DET-CLR-AMT       PIC 9(06)V9(02).          
                   15  WS05-DET-CLR-AMT-TOT   PIC 9(07)V9(02).          
               10  WS05-DETAIL-CANCELLED.                               
                   15  WS05-DET-CAN-CNT       PIC 9(05).                
                   15  WS05-DET-CAN-CNT-TOT   PIC 9(05).                
                   15  WS05-DET-CAN-AMT       PIC 9(06)V9(02).          
                   15  WS05-DET-CAN-AMT-TOT   PIC 9(07)V9(02).          
T20186         10  WS05-ESCHEA-CANCELLED.                               
T20186             15  WS05-DET-ESC-CNT       PIC 9(05).                
T20186             15  WS05-DET-ESC-CNT-TOT   PIC 9(05).                
T20186             15  WS05-DET-ESC-AMT       PIC 9(06)V9(02).          
T20186             15  WS05-DET-ESC-AMT-TOT   PIC 9(07)V9(02).          
           05  WS05-PAGE-COUNTERS.                                      
               10  WS05-REPORT1-PAGE-NBR      PIC 9(05).                
               10  WS05-REPORT2-PAGE-NBR      PIC 9(05).                
T20186         10  WS05-REPORT3-PAGE-NBR      PIC 9(05).                
T27145         10  WS05-REPORT4-PAGE-NBR      PIC 9(05).                
T27145         10  WS05-REPORT5-PAGE-NBR      PIC 9(05).                
T27145         10  WS05-REPORT6-PAGE-NBR      PIC 9(05).                
           05  WS05-LINE-COUNTERS.                                      
               10  WS05-REPORT1-LINE-CTR      PIC 9(02) VALUE 60.       
               10  WS05-REPORT2-LINE-CTR      PIC 9(02) VALUE 60.       
T20186         10  WS05-REPORT3-LINE-CTR      PIC 9(02) VALUE 60.       
T27145         10  WS05-REPORT4-LINE-CTR      PIC 9(02) VALUE 60.       
T27145         10  WS05-REPORT5-LINE-CTR      PIC 9(02) VALUE 60.       
T27145         10  WS05-REPORT6-LINE-CTR      PIC 9(02) VALUE 60.       
                                                                        
       01  WS06-TOTAL-LINES.                                            
           05  WS06-CLEAR-LINE-TOTAL.                                   
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(56)  VALUE          
               'TOTAL NUMBER OF CLEARED CHECKS THIS PAGE..........'.    
               10  WS06-CLEAR-PAGE-CNT        PIC ZZZ,ZZZ,ZZ9.          
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CLEAR-LINE-AMOUNT.                                  
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(53)  VALUE          
               'TOTAL AMOUNT OF CLEARED CHECKS THIS PAGE..........'.    
               10  WS06-CLEAR-PAGE-AMT        PIC $$$,$$$,$$9.99.       
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CANCEL-LINE-TOTAL.                                  
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(56)  VALUE          
            'TOTAL NUMBER OF CANCELLED CHECKS THIS PAGE...........'.    
               10  WS06-CANCEL-PAGE-CNT       PIC ZZZ,ZZZ,ZZ9.          
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CANCEL-LINE-AMOUNT.                                 
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(53)  VALUE          
              'TOTAL CANCELLED CHECK AMOUNT THIS PAGE...............'.  
               10  WS06-CANCEL-PAGE-AMT       PIC $$$,$$$,$$9.99.       
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-ESCHEA-LINE-TOTAL.                                  
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(56)  VALUE          
            'TOTAL NUMBER OF CANCELLED CHECKS THIS PAGE...........'.    
               10  WS06-ESCHEA-PAGE-CNT       PIC ZZZ,ZZZ,ZZ9.          
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-ESCHEA-LINE-AMOUNT.                                 
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(53)  VALUE          
              'TOTAL CANCELLED CHECK AMOUNT THIS PAGE...............'.  
               10  WS06-ESCHEA-PAGE-AMT       PIC $$$,$$$,$$9.99.       
               10  FILLER                     PIC X(64)  VALUE SPACES.  
                                                                        
           05  WS06-CLEAR-GRAND-TOTAL.                                  
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(56)  VALUE          
               'TOTAL NUMBER OF CLEARED CHECKS....................'.    
               10  WS06-CLEAR-TOT-CNT         PIC ZZZ,ZZZ,ZZ9.          
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CLEAR-GRAND-AMOUNT.                                 
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(53)  VALUE          
               'TOTAL AMOUNT OF CLEARED CHECKS....................'.    
               10  WS06-CLEAR-TOT-AMT         PIC $$$,$$$,$$9.99.       
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CANCEL-GRAND-TOTAL.                                 
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(56)  VALUE          
            'TOTAL NUMBER OF CANCELLED CHECKS.....................'.    
               10  WS06-CANCEL-TOT-CNT        PIC ZZZ,ZZZ,ZZ9.          
               10  FILLER                     PIC X(64)  VALUE SPACES.  
           05  WS06-CANCEL-GRAND-AMOUNT.                                
               10  FILLER                     PIC X(01)  VALUE SPACE.   
               10  FILLER                     PIC X(53)  VALUE          
              'TOTAL CANCELLED CHECK AMOUNT.........................'.  
               10  WS06-CANCEL-TOT-AMT        PIC $$$,$$$,$$9.99.       
               10  FILLER                     PIC X(64)  VALUE SPACES.  
T20186     05  WS06-ESCHEA-GRAND-TOTAL.                                 
T20186         10  FILLER                     PIC X(01)  VALUE SPACE.   
T20186         10  FILLER                     PIC X(56)  VALUE          
T20186      'TOTAL NUMBER OF CANCELLED CHECKS.....................'.    
T20186         10  WS06-ESCHEA-TOT-CNT        PIC ZZZ,ZZZ,ZZ9.          
T20186         10  FILLER                     PIC X(64)  VALUE SPACES.  
T20186     05  WS06-ESCHEA-GRAND-AMOUNT.                                
T20186         10  FILLER                     PIC X(01)  VALUE SPACE.   
T20186         10  FILLER                     PIC X(53)  VALUE          
T20186        'TOTAL CANCELLED CHECK AMOUNT.........................'.  
T20186         10  WS06-ESCHEA-TOT-AMT        PIC $$$,$$$,$$9.99.       
T20186         10  FILLER                     PIC X(64)  VALUE SPACES.  
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE                 PIC S9(04) COMP VALUE +0. 
           05  RS-RETURN-CODE-DISP            PIC +Z(04).               
           05  RS-ACCT-XFER-TO                PIC X(13)  VALUE SPACES.  
           05  RS-ITEM-ID                     PIC S9(09) COMP VALUE +0. 
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ERROR HANDLING                                            
      *****                                                                     
       COPY CWS00010.                                                           
                                                                        
      *****                                                                     
      *  COPYBOOK FOR ABEND SWITCH                                              
      *****                                                                     
       COPY CWS09900.                                                           
                                                                        
C23521*****                                                                     
C23521*  COPYBOOK FOR SYSTEM DATE.                                              
                                                                        
      *****                                                                     
      *  COPYBOOK FOR DATE CHECK                                                
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE FIOJC01                                                    
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR REDUCING EMBEDDED SPACES                           
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00011                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR JOB PARM INFORMATION                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  COPYBOOK FOR RETRIEVING REPORT DATES                                   
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00114                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00074                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  COPYBOOK FOR DB2/SQL ERROR HANDLING                                    
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE CWS00303                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  SQLCA                                                                  
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ACCOUNT                                                            
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
T25319*                                                                         
T25319*  CSS_DELINQUENCY                                                        
T25319     EXEC SQL                                                             
T25319       INCLUDE TBDELQ                                                     
T25319     END-EXEC.                                                            
                                                                        
T20186*****                                                                     
T20186*  CSS_BILL_WINDOW                                                        
T20186*****                                                                     
T20186     EXEC SQL                                                             
T20186       INCLUDE TBBILWDW                                                   
T20186     END-EXEC.                                                            
T20186                                                                  
      *****                                                                     
      *  CSS_REFUND                                                             
      *****                                                                     
           EXEC SQL                                                     02670100
               INCLUDE TBREFUND                                         02670200
           END-EXEC.                                                    02670300
                                                                        
      *****                                                                     
      *  CSS_ACCT_MISC_INFO                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ADDR_FORMATTED                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ADDR_FREEFORM                                                      
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_COMPANY                                                            
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_CUST_ADDR_XREF                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_JOB_PARM                                                           
      *****                                                                     
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_NAME                                                               
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_NAME_ACCT_XREF                                                     
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
                                                                        
      *****                                                                     
      *  CSS_ZIP_CODE                                                           
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
                                                                        
      *                                                                 03724700
T23875*    EXEC SQL                                                     03724000
T23875*         DECLARE REFUND-CURSOR CURSOR FOR                        03730000
T23875*         SELECT                                                  03740000
T23875*               ACCOUNT_NO,                                       03750000
T23875*               REFUND_CHECK_NO,                                  03750000
T23875*               CHECK_STATUS_CD,                                  03770000
T23875*               REFUND_STATUS_DT,                                 03770000
T23875*               DATE_ESCHEATED,                                   03770000
T23875*               AMT_REFUNDED                                      03780000
T23875*         FROM  CSS_REFUND                                        03790000
T23875*        WHERE  CHECK_STATUS_CD IN ('L', 'X', 'S')                03800000
T23875*        WHERE  CHECK_STATUS_CD IN ('X', 'S')                     03800000
T23875*          AND  REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT         03800000
T23875*          AND  REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT         03800000
T23875*          AND  REFUND_CHECK_NO <> '0        '                    03800000
T23875*          AND  REFUND_CHECK_NO <> '000000000'                    03800000
T23875*     ORDER BY  REFUND_CHECK_NO                                   03800000
T23875*    END-EXEC.                                                    03820000
      *                                                                 03724700
T23875     EXEC SQL                                                     
T23875          DECLARE REFUND-CURSOR CURSOR FOR                        
T23875          SELECT                                                  
T23875                RN.ACCOUNT_NO,                                    
T23875                RN.REFUND_CHECK_NO,                               
T23875                RN.CHECK_STATUS_CD,                               
T23875                RN.REFUND_STATUS_DT,                              
T23875                RN.DATE_ESCHEATED,                                
T23875                RN.AMT_REFUNDED,                                  
T27145                RN.LOCAL_OFFICE,                                  
T23875                AT.COMPANY_NO                                     
T23875          FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                     
T23875                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T22793*        WHERE  CHECK_STATUS_CD IN ('L', 'X', 'S')                03800000
T23875         WHERE  RN.CHECK_STATUS_CD IN ('X', 'S')                  
T23875           AND  RN.REFUND_STATUS_DT >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-BEG-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-BEG-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-BEG-DT) )      
T23875           AND  RN.REFUND_STATUS_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )      
T23875           AND  RN.REFUND_CHECK_NO <> '0        '                 
T23875           AND  RN.REFUND_CHECK_NO <> '000000000'                 
T23875           AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     
T23875      ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 
T35434      FOR READ ONLY                                       
T23875     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03724000
MFA-TR*         DECLARE REFUND-CURSOR CURSOR FOR                        03730000
MFA-TR*         SELECT                                                  03740000
MFA-TR*               RN.ACCOUNT_NO,                                    03750000
MFA-TR*               RN.REFUND_CHECK_NO,                               03750000
MFA-TR*               RN.CHECK_STATUS_CD,                               03770000
MFA-TR*               RN.REFUND_STATUS_DT,                              03770000
MFA-TR*               RN.DATE_ESCHEATED,                                03770000
MFA-TR*               RN.AMT_REFUNDED,                                  03780000
MFA-TR*               RN.LOCAL_OFFICE,                                  03780000
MFA-TR*               AT.COMPANY_NO                                     03780000
MFA-TR*         FROM  CSS_REFUND  RN,                                   03790000
MFA-TR*               CSS_ACCOUNT AT                                    03790000
MFA-TR*        WHERE  CHECK_STATUS_CD IN ('L', 'X', 'S')                03800000
MFA-TR*        WHERE  RN.CHECK_STATUS_CD IN ('X', 'S')                  03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT      03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT      03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '0        '                 03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '000000000'                 03800000
MFA-TR*          AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     03800000
MFA-TR*     ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 03800000
MFA-TR*     FOR FETCH ONLY WITH UR                                      03800000
MFA-TR*    END-EXEC.                                                    03820000
      *                                                                 03724700
T27145     EXEC SQL                                                     
T27145          DECLARE SEBR-REFUND-CURSOR CURSOR FOR                   
T27145          SELECT                                                  
T27145                RN.ACCOUNT_NO,                                    
T27145                RN.REFUND_CHECK_NO,                               
T27145                RN.CHECK_STATUS_CD,                               
T27145                RN.REFUND_STATUS_DT,                              
T27145                RN.DATE_ESCHEATED,                                
T27145                RN.AMT_REFUNDED,                                  
T27145                RN.LOCAL_OFFICE,                                  
T27145                AT.COMPANY_NO                                     
T27145          FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                     
T27145                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T27145         WHERE  RN.CHECK_STATUS_CD IN ('X', 'S')                  
T27145           AND  RN.REFUND_STATUS_DT >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-BEG-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-BEG-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-BEG-DT) )      
T27145           AND  RN.REFUND_STATUS_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )      
T27145           AND  RN.REFUND_CHECK_NO <> '0        '                 
T27145           AND  RN.REFUND_CHECK_NO <> '000000000'                 
T27145           AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     
T27145           AND  RN.LOCAL_OFFICE BETWEEN '500' AND '599'           
T27145      ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 
T35434      FOR READ ONLY                                       
T27145     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03724000
MFA-TR*         DECLARE SEBR-REFUND-CURSOR CURSOR FOR                   03730000
MFA-TR*         SELECT                                                  03740000
MFA-TR*               RN.ACCOUNT_NO,                                    03750000
MFA-TR*               RN.REFUND_CHECK_NO,                               03750000
MFA-TR*               RN.CHECK_STATUS_CD,                               03770000
MFA-TR*               RN.REFUND_STATUS_DT,                              03770000
MFA-TR*               RN.DATE_ESCHEATED,                                03770000
MFA-TR*               RN.AMT_REFUNDED,                                  03780000
MFA-TR*               RN.LOCAL_OFFICE,                                  03780000
MFA-TR*               AT.COMPANY_NO                                     03780000
MFA-TR*         FROM  CSS_REFUND  RN,                                   03790000
MFA-TR*               CSS_ACCOUNT AT                                    03790000
MFA-TR*        WHERE  RN.CHECK_STATUS_CD IN ('X', 'S')                  03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT      03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT      03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '0        '                 03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '000000000'                 03800000
MFA-TR*          AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     03800000
MFA-TR*          AND  RN.LOCAL_OFFICE BETWEEN '500' AND '599'           03800000
MFA-TR*     ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 03800000
MFA-TR*     FOR FETCH ONLY WITH UR                                      03800000
MFA-TR*    END-EXEC.                                                    03820000
T27145                                                                  
T23875* COMMENTED FOR COMPANY BREAK LOGIC CHANGES                       03724700
T22793*    EXEC SQL                                                     03724000
T22793*         DECLARE CL-REFUND-CURSOR CURSOR FOR                     03730000
T22793*         SELECT                                                  03740000
T22793*               ACCOUNT_NO,                                       03750000
T22793*               REFUND_CHECK_NO,                                  03750000
T22793*               CHECK_STATUS_CD,                                  03770000
T22793*               REFUND_STATUS_DT,                                 03770000
T22793*               DATE_ESCHEATED,                                   03770000
T22793*               AMT_REFUNDED                                      03780000
T22793*         FROM  CSS_REFUND                                        03790000
T22793*        WHERE  CHECK_STATUS_CD IN ('L')                          03800000
T22793*          AND  REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT         03800000
T22793*          AND  REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT         03800000
T22793*          AND  REFUND_CHECK_NO <> '0        '                    03800000
T22793*          AND  REFUND_CHECK_NO <> '000000000'                    03800000
T22793*     ORDER BY  REFUND_CHECK_NO                                   03800000
T22793*    END-EXEC.                                                    03820000
      *                                                                 03830000
T23875     EXEC SQL                                                     
T23875          DECLARE CL-REFUND-CURSOR CURSOR FOR                     
T23875          SELECT                                                  
T23875                RN.ACCOUNT_NO,                                    
T23875                RN.REFUND_CHECK_NO,                               
T23875                RN.CHECK_STATUS_CD,                               
T23875                RN.REFUND_STATUS_DT,                              
T23875                RN.DATE_ESCHEATED,                                
T23875                RN.AMT_REFUNDED,                                  
T27145                RN.LOCAL_OFFICE,                                  
T23875                AT.COMPANY_NO                                     
T23875          FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                     
T23875                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T23875         WHERE  RN.CHECK_STATUS_CD IN ('L')                       
T23875           AND  RN.REFUND_STATUS_DT >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-BEG-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-BEG-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-BEG-DT) )      
T23875           AND  RN.REFUND_STATUS_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )      
T23875           AND  RN.REFUND_CHECK_NO <> '0        '                 
T23875           AND  RN.REFUND_CHECK_NO <> '000000000'                 
T23875           AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     
T23875      ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 
T35434      FOR READ ONLY                                       
T23875     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03724000
MFA-TR*         DECLARE CL-REFUND-CURSOR CURSOR FOR                     03730000
MFA-TR*         SELECT                                                  03740000
MFA-TR*               RN.ACCOUNT_NO,                                    03750000
MFA-TR*               RN.REFUND_CHECK_NO,                               03750000
MFA-TR*               RN.CHECK_STATUS_CD,                               03770000
MFA-TR*               RN.REFUND_STATUS_DT,                              03770000
MFA-TR*               RN.DATE_ESCHEATED,                                03770000
MFA-TR*               RN.AMT_REFUNDED,                                  03780000
MFA-TR*               RN.LOCAL_OFFICE,                                  03780000
MFA-TR*               AT.COMPANY_NO                                     03780000
MFA-TR*         FROM  CSS_REFUND  RN,                                   03790000
MFA-TR*               CSS_ACCOUNT AT                                    03790000
MFA-TR*        WHERE  RN.CHECK_STATUS_CD IN ('L')                       03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT      03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT      03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '0        '                 03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '000000000'                 03800000
MFA-TR*          AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     03800000
MFA-TR*     ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 03800000
MFA-TR*     FOR FETCH ONLY WITH UR                                      03800000
MFA-TR*    END-EXEC.                                                    03820000
      *                                                                 03830000
T27145     EXEC SQL                                                     
T27145          DECLARE SEBR-CLRFND-CURSOR CURSOR FOR                   
T27145          SELECT                                                  
T27145                RN.ACCOUNT_NO,                                    
T27145                RN.REFUND_CHECK_NO,                               
T27145                RN.CHECK_STATUS_CD,                               
T27145                RN.REFUND_STATUS_DT,                              
T27145                RN.DATE_ESCHEATED,                                
T27145                RN.AMT_REFUNDED,                                  
T27145                RN.LOCAL_OFFICE,                                  
T27145                AT.COMPANY_NO                                     
T27145          FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                     
T27145                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T27145         WHERE  RN.CHECK_STATUS_CD IN ('L')                       
T27145           AND  RN.REFUND_STATUS_DT >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-BEG-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-BEG-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-BEG-DT) )      
T27145           AND  RN.REFUND_STATUS_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )      
T27145           AND  RN.REFUND_CHECK_NO <> '0        '                 
T27145           AND  RN.REFUND_CHECK_NO <> '000000000'                 
T27145           AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     
T27145           AND  RN.LOCAL_OFFICE BETWEEN '500' AND '599'           
T27145      ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 
T35434      FOR READ ONLY                                       
T27145     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03724000
MFA-TR*         DECLARE SEBR-CLRFND-CURSOR CURSOR FOR                   03730000
MFA-TR*         SELECT                                                  03740000
MFA-TR*               RN.ACCOUNT_NO,                                    03750000
MFA-TR*               RN.REFUND_CHECK_NO,                               03750000
MFA-TR*               RN.CHECK_STATUS_CD,                               03770000
MFA-TR*               RN.REFUND_STATUS_DT,                              03770000
MFA-TR*               RN.DATE_ESCHEATED,                                03770000
MFA-TR*               RN.AMT_REFUNDED,                                  03780000
MFA-TR*               RN.LOCAL_OFFICE,                                  03780000
MFA-TR*               AT.COMPANY_NO                                     03780000
MFA-TR*         FROM  CSS_REFUND  RN,                                   03790000
MFA-TR*               CSS_ACCOUNT AT                                    03790000
MFA-TR*        WHERE  RN.CHECK_STATUS_CD IN ('L')                       03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT >= :WS-STNDTE-RPT-BEG-DT      03800000
MFA-TR*          AND  RN.REFUND_STATUS_DT <= :WS-STNDTE-RPT-END-DT      03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '0        '                 03800000
MFA-TR*          AND  RN.REFUND_CHECK_NO <> '000000000'                 03800000
MFA-TR*          AND  AT.ACCOUNT_NO = RN.ACCOUNT_NO                     03800000
MFA-TR*          AND  RN.LOCAL_OFFICE BETWEEN '500' AND '599'           03800000
MFA-TR*     ORDER BY  AT.COMPANY_NO, RN.REFUND_CHECK_NO                 03800000
MFA-TR*     FOR FETCH ONLY WITH UR                                      03800000
MFA-TR*    END-EXEC.                                                    03820000
                                                                        
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSCA704 ENDS HERE'.                    
                                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *             P R O C E D U R E   D I V I S I O N               *         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  0000-MAINLINE                                                *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION                                  
              THRU 1000-EXIT.                                           
      *                                                                         
           IF NOT WS-REFUND-NO-DATA                                     
              PERFORM 2000-PRODUCE-REPORTS                              
                 THRU 2000-EXIT                                         
T23875*          UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                   
T23875           UNTIL WS-REFUND-NO-DATA                                
T27145*     TO WRITE SEBR RECORDS                                               
T27145      IF SEB-DATABASE AND WS-SEBR-YES = 'Y' AND PRESENT-ROW       
T27145                                                                  
T27145        PERFORM 2201-WRITE-SEBR-CANPAGE-TOTALS THRU 2201-EXIT     
T27145        PERFORM 2301-WRITE-SEBR-ESCPAGE-TOTALS THRU 2301-EXIT     
T27145        MOVE WS-DEREG-TITLE          TO WS01-TITLE1A-SEB-DIV      
T27145        PERFORM 2251-WRITE-SEBR-CANGRND-TOTAL  THRU 2251-EXIT     
T27145        PERFORM 2351-WRITE-SEBR-ESCGRND-TOTAL  THRU 2351-EXIT     
T27145        MOVE SPACES                  TO WS01-TITLE1A-SEB-DIV      
T27145                                                                  
T27145        INITIALIZE WS05-SEBR-DET-CAN-AMT,                         
T27145                   WS05-SEBR-DET-ESC-AMT,                         
T27145                   WS05-SEBR-DET-CAN-CNT-TOT,                     
T27145                   WS05-SEBR-DET-CAN-AMT-TOT,                     
T27145                   WS06-CANCEL-TOT-CNT,                           
T27145                   WS06-CANCEL-TOT-AMT,                           
T27145                   WS05-SEBR-DET-ESC-CNT-TOT,                     
T27145                   WS05-SEBR-DET-ESC-AMT-TOT,                     
T27145                   WS06-ESCHEA-TOT-CNT,                           
T27145                   WS06-ESCHEA-TOT-AMT                            
T27145                                                                  
T27145        MOVE ZEROES TO WS05-REPORT5-LINE-CTR                      
T27145        MOVE ZEROES TO WS05-REPORT6-LINE-CTR                      
T27145                                                                  
T27145        PERFORM 1502-OPEN-SEBR-REFUND-CURSOR   THRU 1502-EXIT     
T27145        PERFORM 1602-FETCH-SEBR-REFUND-CURSOR  THRU 1602-EXIT     
                                                                        
T27145        PERFORM 2002-PRODUCE-SEBR-REPORTS      THRU 2002-EXIT     
T27145                UNTIL WS-SEBR-REFUND-NO-DATA                      
T27145                                                                  
T27145        MOVE SPACES TO WS01-TITLE1A-SEB-DIV                       
T27145      END-IF                                                      
T27145                                                                  
T23875*    PERFORM 3000-WRITE-GRAND-TOTALS                                      
T23875*        THRU 3000-EXIT.                                                  
T25319*      COND CSR-DATABASE ADDED IN THE IF                                  
T25319        IF NOT NOT-PSNC AND CSR-DATABASE                          
T23875          MOVE C26-COMPANY-NO TO C7-COMPANY-NO                    
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T23875          PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT         
T23875          PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT         
T23875          WRITE PRT7042-RECORD FROM WS04A-NO-DATA-LINE            
T23875              AFTER ADVANCING 1 LINE                              
T23875          WRITE PRT7043-RECORD FROM WS04A-NO-DATA-LINE            
T23875              AFTER ADVANCING 1 LINE                              
T27145          IF SEB-DATABASE                                         
T27145             PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT 
T27145             PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT 
T27145             WRITE PRT7045-RECORD FROM WS04A-NO-DATA-LINE         
T27145                AFTER ADVANCING 1 LINE                            
T27145             WRITE PRT7046-RECORD FROM WS04A-NO-DATA-LINE         
T27145                AFTER ADVANCING 1 LINE                            
T27145         END-IF                                                   
T23875        ELSE                                                      
T23875         PERFORM 2200-WRITE-CANCEL-PAGE-TOTALS THRU 2200-EXIT     
T23875         PERFORM 2300-WRITE-ESCHEA-PAGE-TOTALS THRU 2300-EXIT     
T23875         PERFORM 2250-WRITE-CANCEL-GRAND-TOTAL THRU 2250-EXIT     
T23875         PERFORM 2350-WRITE-ESCHEA-GRAND-TOTAL THRU 2350-EXIT     
T27145         IF SEB-DATABASE                                          
T27145          PERFORM 2201-WRITE-SEBR-CANPAGE-TOTALS THRU 2201-EXIT   
T27145          PERFORM 2301-WRITE-SEBR-ESCPAGE-TOTALS THRU 2301-EXIT   
T27145          MOVE WS-REG-TITLE    TO WS01-TITLE1A-SEB-DIV            
T27145          PERFORM 2251-WRITE-SEBR-CANGRND-TOTAL  THRU 2251-EXIT   
T27145          PERFORM 2351-WRITE-SEBR-ESCGRND-TOTAL  THRU 2351-EXIT   
T27145          MOVE  SPACES         TO WS01-TITLE1A-SEB-DIV            
T27145         END-IF                                                   
T23875        END-IF                                                    
T23875     END-IF.                                                      
T23875                                                                  
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
       0000-EXIT.                                                       
           STOP RUN.                                                    
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1000-INITIALIZATION                                          *         
      *                                                               *         
      *****************************************************************         
       1000-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS04-DATE-TIME-STAMPS                             
                      WS05-WORK-AREA.                                   
                                                                        
           MOVE C01-PROGRAM-NAME TO WS-PGRMNAME.                        
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES TO WS-INPUT-AREA                              
                             WS-INPUT-DATA-BREAKDOWN                    
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE C01-PROGRAM-NAME TO WS-PGRMNAME                      
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCPT7041-FILE.                                   
                                                                        
           OPEN OUTPUT FCPT7042-FILE.                                   
T20186                                                                  
T20186     OPEN OUTPUT FCPT7043-FILE.                                   
                                                                        
           PERFORM 1100-SELECT-CURR-TIMESTAMP THRU 1100-EXIT.           
T25319     MOVE '01'                      TO C8-COMPANY-NO.             
T25319     MOVE 'DATABASE'                TO C8-DELINQ-CD.              
T25319     PERFORM 1110-GET-DELINQ-VALUE      THRU 1110-EXIT.           
T25319     MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
                                                                        
T27145     IF SEB-DATABASE                                              
T27145        OPEN OUTPUT FCPT7044-FILE                                 
T27145                                                                  
T27145        OPEN OUTPUT FCPT7045-FILE                                 
T27145                                                                  
T27145        OPEN OUTPUT FCPT7046-FILE                                 
T27145     END-IF.                                                      
T27145                                                                  
           PERFORM 1200-POPULATE-TITLES THRU 1200-EXIT.                 
                                                                        
T23875*    PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT.                      
                                                                        
T23875*COMMENTED FOR MULTICOMPANY CHANGES                                       
T22231*    PERFORM 1350-CALC-REVENUE-DATES  THRU  1350-EXIT.                    
      *                                                                         
T22793     PERFORM 1501-OPEN-CL-REFUND-CURSOR THRU 1501-EXIT.           
T22793     PERFORM 1601-FETCH-CL-REFUND-CURSOR THRU 1601-EXIT.          
T23875*                                                                         
T23875     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T23875        MOVE C01-COMPANY-NO TO C7-COMPANY-NO                      
T23875        PERFORM 1210-RETRIEVE-COMP-NAME  THRU 1210-EXIT           
T23875        MOVE C7-COMPANY-NAME TO WS01-TITLE1A-COMP-NAME            
T23875        PERFORM 1300-WRITE-CLEAR-TITLES  THRU 1300-EXIT           
T23875        WRITE PRT7041-RECORD FROM WS04A-NO-DATA-LINE              
T23875           AFTER ADVANCING 1 LINE                                 
T27145        IF SEB-DATABASE                                           
T27145           PERFORM 1301-WRITE-SEBR-CLEAR-TITLES THRU 1301-EXIT    
T27145           WRITE PRT7044-RECORD FROM WS04A-NO-DATA-LINE           
T27145              AFTER ADVANCING 1 LINE                              
T27145        END-IF                                                    
T25319*       IF CONDITION ADDED TO AVOID EXECUTION FOR SEB                     
T25319        IF CSR-DATABASE                                           
T23875           MOVE C26-COMPANY-NO TO C7-COMPANY-NO                   
T23875           PERFORM 1210-RETRIEVE-COMP-NAME  THRU 1210-EXIT        
T23875           MOVE C7-COMPANY-NAME TO WS01-TITLE1A-COMP-NAME         
T23875           PERFORM 1300-WRITE-CLEAR-TITLES  THRU 1300-EXIT        
T23875           WRITE PRT7041-RECORD FROM WS04A-NO-DATA-LINE           
T23875              AFTER ADVANCING 1 LINE                              
T23875        END-IF                                                    
T23875     END-IF.                                                      
T23875*                                                                         
           IF WS-CL-REFUND-DATA-STATUS NOT = 'N'                        
T22793        PERFORM 2001-PRODUCE-REPORTS                              
T22793          THRU 2001-EXIT                                          
T22793*         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                    
T23875          UNTIL WS-CL-REFUND-NO-DATA                              
T23875        PERFORM 2100-WRITE-CLEAR-PAGE-TOTALS THRU 2100-EXIT       
T23875        PERFORM 2150-WRITE-CLEAR-GRAND-TOTAL THRU 2150-EXIT       
T27145                                                                  
T27145        IF SEB-DATABASE AND ROW-PRESENT                           
T27145          PERFORM 2101-WRITE-SEBR-CLRPAGE-TOTALS THRU 2101-EXIT   
T27145          MOVE WS-DEREG-TITLE      TO WS01-TITLE1A-SEB-DIV        
T27145          PERFORM 2151-WRITE-SEBR-CLRGRAND-TOTAL THRU 2151-EXIT   
T27145          MOVE SPACES              TO WS01-TITLE1A-SEB-DIV        
T27145        END-IF                                                    
T27145*                                                                         
T25319*      CSR-DATABASE ADDED IN THE IF COND                                  
T25319        IF NOT NO-PSNC AND CSR-DATABASE                           
T23875           MOVE C26-COMPANY-NO     TO C7-COMPANY-NO               
T23875           PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT         
T23875           MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME      
T23875           PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT         
T23875           WRITE PRT7041-RECORD FROM WS04A-NO-DATA-LINE           
T23875              AFTER ADVANCING 1 LINE                              
T27145           IF SEB-DATABASE                                        
T27145              PERFORM 1301-WRITE-SEBR-CLEAR-TITLES                
T27145                                                 THRU 1301-EXIT   
T27145              WRITE PRT7044-RECORD FROM WS04A-NO-DATA-LINE        
T27145                 AFTER ADVANCING 1 LINE                           
T27145           END-IF                                                 
T23875        END-IF                                                    
T23875     END-IF                                                       
      *                                                                         
T27145*    TO WRITE THE SEBR RECORDS                                            
T27145     IF SEB-DATABASE AND WS-YES-SEBR = 'Y' AND ROW-PRESENT        
T27145        PERFORM 1503-OPEN-SEBR-CLRFND-CURSOR     THRU 1503-EXIT   
T27145        PERFORM 1603-FETCH-SEBR-CLRFND-CURSOR    THRU 1603-EXIT   
T27145        PERFORM 2003-PRODUCE-SEBR-REPORTS        THRU 2003-EXIT   
T27145          UNTIL WS-SEBR-CL-REFUND-NO-DATA                         
T27145                                                                  
T27145        PERFORM 2101-WRITE-SEBR-CLRPAGE-TOTALS   THRU 2101-EXIT   
T27145        MOVE WS-REG-TITLE    TO WS01-TITLE1A-SEB-DIV              
T27145        PERFORM 2151-WRITE-SEBR-CLRGRAND-TOTAL   THRU 2151-EXIT   
T27145        MOVE SPACES          TO WS01-TITLE1A-SEB-DIV              
T27145     END-IF                                                       
T27145*                                                                         
T22793     MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                         
      *                                                                         
T23875*COMMENTS FOR MULTICOMPANY CHANGES BEGIN                                  
T22231*    MOVE WS04-BEG-REV-DT    TO  WS-STNDTE-RPT-BEG-DT.                    
T22231*    MOVE WS04-END-REV-DT    TO  WS-STNDTE-RPT-END-DT.                    
      *                                                                         
T23875*    PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT.                     
T20186*    PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT.                     
T23875*COMMENTS FOR MULTICOMPANY CHANGES END                                    
      *                                                                         
T23875     PERFORM 1350-CALC-REVENUE-DATES THRU  1350-EXIT              
T23875     MOVE WS04-BEG-REV-DT    TO  WS-STNDTE-RPT-BEG-DT             
T23875     MOVE WS04-END-REV-DT    TO  WS-STNDTE-RPT-END-DT             
      *                                                                         
           PERFORM 1500-OPEN-REFUND-CURSOR THRU 1500-EXIT.              
           PERFORM 1600-FETCH-REFUND-CURSOR THRU 1600-EXIT.             
      *                                                                         
T23875     IF WS-REFUND-NO-DATA                                         
T23875        MOVE C01-COMPANY-NO TO C7-COMPANY-NO                      
T23875        PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT            
T23875        MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME         
T23875        PERFORM 1350-CALC-REVENUE-DATES THRU  1350-EXIT           
T23875        MOVE WS04-BEG-REV-DT    TO  WS-STNDTE-RPT-BEG-DT          
T23875        MOVE WS04-END-REV-DT    TO  WS-STNDTE-RPT-END-DT          
      *                                                                         
T23875        PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT           
T23875        PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT           
T23875        WRITE PRT7042-RECORD FROM  WS04A-NO-DATA-LINE             
T23875         AFTER ADVANCING 1 LINE                                   
T23875        WRITE PRT7043-RECORD FROM  WS04A-NO-DATA-LINE             
T23875         AFTER ADVANCING 1 LINE                                   
T27145        IF SEB-DATABASE                                           
T27145           PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT   
T27145           PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT   
T27145           WRITE PRT7045-RECORD FROM  WS04A-NO-DATA-LINE          
T27145            AFTER ADVANCING 1 LINE                                
T27145           WRITE PRT7046-RECORD FROM  WS04A-NO-DATA-LINE          
T27145            AFTER ADVANCING 1 LINE                                
T27145        END-IF                                                    
      *                                                                         
T25319*    IF CONDITION ADDED                                                   
T25319        IF CSR-DATABASE                                           
T23875           MOVE C26-COMPANY-NO     TO C7-COMPANY-NO               
T23875           PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT         
T23875           MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME      
T23875           PERFORM 1350-CALC-REVENUE-DATES THRU  1350-EXIT        
T23875           MOVE WS04-BEG-REV-DT    TO  WS-STNDTE-RPT-BEG-DT       
T23875           MOVE WS04-END-REV-DT    TO  WS-STNDTE-RPT-END-DT       
      *                                                                         
T23875           PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT        
T23875           PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT        
T23875           WRITE PRT7042-RECORD FROM  WS04A-NO-DATA-LINE          
T23875               AFTER ADVANCING 1 LINE                             
T23875           WRITE PRT7043-RECORD FROM  WS04A-NO-DATA-LINE          
T23875               AFTER ADVANCING 1 LINE                             
T23875        END-IF                                                    
T23875     END-IF.                                                      
      *                                                                         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1100-SELECT-CURR-TIMESTAMP                                   *         
      *                                                               *         
      *****************************************************************         
       1100-SELECT-CURR-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS04-CURRENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS04-CURRENT-TS = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '***********************************'             
              DISPLAY '**   PCSCA704 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 1100    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25319*                                                                         
T25319*****************************************************************         
T25319* 1110-GET-DELINQ-VALUE                                         *         
T25319*****************************************************************         
T25319 1110-GET-DELINQ-VALUE.                                           
T25319                                                                  
T25319     EXEC SQL                                                     
T25319        SELECT  DELINQ_VALUE                                      
T25319          INTO  :C8-DELINQ-VALUE                                  
T25319          FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T25319         WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
T25319           AND  COMPANY_NO = :C8-COMPANY-NO                       
T35434                                                           
T25319     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO  :C8-DELINQ-VALUE                                          
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25319                                                                  
T25319     IF SQLCODE = SUCCESSFUL-CALL                                 
T25319         CONTINUE                                                 
T25319     ELSE                                                         
T25319         DISPLAY '** 1110-GET-DELINQ-VALUE'                       
T25319         DISPLAY '** ERROR ON SELECT FROM CSS_DELINQUENCY **'     
T25319         DISPLAY '** DELINQ_CD = ' C8-DELINQ-CD ' ; SQLCODE = '   
T25319                 SQLCODE                                          
T25319         DISPLAY '** DCOMPANY_NO= ' C8-COMPANY-NO ' ; SQLCODE = ' 
T25319                 SQLCODE                                          
T25319         DISPLAY '**  PROCESSING TERMINATED  **'                  
T25319         PERFORM 9900-ABEND      THRU  9900-EXIT                  
T25319     END-IF.                                                      
T25319                                                                  
T25319 1110-EXIT.                                                       
T25319     EXIT.                                                        
T25319*                                                                         
      *****************************************************************         
      *  1200-POPULATE-TITLES                                         *         
      *                                                               *         
      *****************************************************************         
       1200-POPULATE-TITLES.                                            
                                                                        
T23875*    PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT.                      
T23875*                                                                         
T23875*    MOVE C7-COMPANY-NAME TO WS01-TITLE1A-COMP-NAME.                      
                                                                        
           STRING WS04-CURRENT-TS(6:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(9:2)  DELIMITED BY SIZE               
                  '/'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(1:4)  DELIMITED BY SIZE               
             INTO WS01-TITLE1A-RUN-DT.                                  
                                                                        
           STRING WS04-CURRENT-TS(12:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(15:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(18:2) DELIMITED BY SIZE               
             INTO WS01-TITLE1B-RUN-TM.                                  
                                                                        
           STRING WS04-CURRENT-TS(12:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(15:2) DELIMITED BY SIZE               
                  ':'                   DELIMITED BY SIZE               
                  WS04-CURRENT-TS(18:2) DELIMITED BY SIZE               
             INTO WS02-TITLE2B-RUN-TM.                                  
                                                                        
T20186     MOVE WS02-TITLE2B-RUN-TM TO WS02-TITLE3B-RUN-TM.             
                                                                        
C23521*    PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.                      
C23521*                                                                         
C23521*    MOVE WS-STNDTE-BEG-MONTH TO WS01-TITLE1B-MTH                         
C23521*                                WS02-TITLE2B-MTH                         
C23521*                                WS02-TITLE3B-MTH                         
C23521*                                WS04-REV-MM.                             
C23521*    MOVE WS-STNDTE-BEG-YEAR TO WS01-TITLE1B-YR                           
C23521*                               WS02-TITLE2B-YR                           
C23521*                               WS02-TITLE3B-YR                           
C23521*                               WS04-REV-YYYY.                            
C23521*                                                                         
ACT144     EXEC SQL SELECT
              (SELECT CAST(DATEADD(DAY, -DAY(E), E) AS DATE) 
              FROM (SELECT DATEADD(MONTH, 1, DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) E) T)
            INTO
              :WS-END-DATE                        
ACT144     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL SET :WS-END-DATE =                                          
MFA-TR*        LAST_DAY(CURRENT_DATE - 1 MONTHS)                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT144     MOVE WS-END-CCYY      TO WS01-BEG-YYYY                       
ACT144                              WS01-END-YYYY.                      
C23521     MOVE WS01-BEG-YYYY    TO WS01-TITLE1B-YR                     
C23521                              WS02-TITLE2B-YR                     
C23521                              WS02-TITLE3B-YR                     
C23521                              WS04-REV-YYYY.                      
ACT144     MOVE WS-END-MONTH     TO WS01-BEG-MM                         
C23521                              WS01-END-MM                         
C23521                              WS01-TITLE1B-MTH                    
C23521                              WS02-TITLE2B-MTH                    
C23521                              WS02-TITLE3B-MTH                    
C23521                              WS04-REV-MM.                        
C23521     MOVE 01               TO WS01-BEG-DD.                        
C23521     MOVE WS-END-DAY       TO WS01-END-DD.                        
ACT144     MOVE WS01-BEG-DATE    TO WS-STNDTE-RPT-BEG-DT.               
ACT144     MOVE WS01-END-DATE    TO WS-STNDTE-RPT-END-DT.               
C23521*                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1210-RETRIEVE-COMP-NAME                                      *         
      *                                                               *         
      *****************************************************************         
       1210-RETRIEVE-COMP-NAME.                                         
                                                                        
           EXEC SQL                                                     
                SELECT COMPANY_NAME                                     
                  INTO :C7-COMPANY-NAME                                 
                  FROM CSS_COMPANY WITH(READUNCOMMITTED)                        
T23875*          WHERE COMPANY_NO = :C01-COMPANY-NO                             
T23875           WHERE COMPANY_NO = :C7-COMPANY-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COMPANY_NAME                                             
MFA-TR*           INTO :C7-COMPANY-NAME                                         
MFA-TR*           FROM CSS_COMPANY                                              
MFA-TR*          WHERE COMPANY_NO = :C01-COMPANY-NO                             
MFA-TR*          WHERE COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '***********************************'             
              DISPLAY '**   PCSCA704 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 1210    **'             
              DISPLAY '**  UNABLE TO RETRIEVE COMP NAME **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1300-WRITE-CLEAR-TITLES                                      *         
      *                                                               *         
      *****************************************************************         
       1300-WRITE-CLEAR-TITLES.                                         
                                                                        
           ADD 1 TO WS05-REPORT1-PAGE-NBR.                              
                                                                        
           MOVE WS05-REPORT1-PAGE-NBR TO WS01-TITLE1C-PAGE-NBR.         
                                                                        
           MOVE C01-REPORT1-NAME TO WS01-TITLE1A-REPTNAME.              
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1A                       
                 AFTER ADVANCING PAGE.                                  
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1B                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1C                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS-HEADER1-DETAIL                  
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS-HEADER2-DETAIL                  
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE  7 TO WS05-REPORT1-LINE-CTR.                            
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  1301-WRITE-SEBR-CLEAR-TITLES                                 *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1301-WRITE-SEBR-CLEAR-TITLES.                                    
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT4-PAGE-NBR.         
T27145                                                                  
T27145     MOVE WS05-REPORT4-PAGE-NBR TO WS01-TITLE1C-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT4-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS-HEADER1-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS-HEADER2-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE 7                     TO WS05-REPORT4-LINE-CTR.         
T27145*                                                                         
T27145 1301-EXIT.                                                       
T27145     EXIT.                                                        
T27145*                                                                         
T22231****************************************************************          
T22231* 1350-CALC-REVENUE-DATES.                                     *          
T22231*                                                              *          
T22231*    1. FIND THE BEGINING DATE FOR THE REVENUE MONTH           *          
T22231*    2. FIND THE ENDING DATE FOR THE REVENUE MONTH             *          
T22231*                                                              *          
T22231*       THE REVENUE MONTH STARTS WHEN THE FIRST BILL CYCLE     *          
T22231*       OPENS ON CSS_BILL_WINDOW AND ENDS ONE DAY PRIOR TO     *          
T22231*       THE OPENING OF THE NEXT '01' BILL CYCLE.               *          
T22231*                                                              *          
T22231****************************************************************          
T22231 1350-CALC-REVENUE-DATES.                                         
T22231                                                                  
T22231     MOVE WS04-REV-YYYYMM      TO  WS04-REV-TEMP.                 
T22231     MOVE WS04-REV-TEMP        TO  WS04-REV-MONTH.                
T22231                                                                  
T22231     EXEC SQL                                                     
T22231          SELECT MIN(DATE_EXTRACT)                                
T22231            INTO :WS04-BEG-REV-DT                                 
T22231            FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
T22231           WHERE REVENUE_MONTH   =  :WS04-REV-MONTH               
T22231             AND BILL_CYCLE      =  :WS-ONE                       
T35434                                                           
T22231     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MIN(DATE_EXTRACT)                                        
MFA-TR*           INTO :WS04-BEG-REV-DT                                         
MFA-TR*           FROM CSS_BILL_WINDOW                                          
MFA-TR*          WHERE REVENUE_MONTH   =  :WS04-REV-MONTH                       
MFA-TR*            AND BILL_CYCLE      =  :WS-ONE                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22231                                                                  
T22231     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22231                                                                  
T22231     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
T22231        DISPLAY '***************************************'         
T22231        DISPLAY '**   PCSCA704 PROCESSING ERROR       **'         
T22231        DISPLAY '**    ABEND IN PARAGRAPH 1350        **'         
T22231        DISPLAY '**  UNABLE TO RETRIEVE REVENUE DATES **'         
T22231        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
T22231        DISPLAY '**  NO ENTRY FOR MONTH :' WS04-REV-YYYYMM        
T22231        DISPLAY '**     PROCESSING TERMINATED         **'         
T22231        DISPLAY '***************************************'         
T22231        PERFORM 9900-ABEND THRU 9900-EXIT                         
T22231     END-IF.                                                      
T22231*                                                                         
T22231* INCREASE THE REVENUE MONTH BY 1                                         
T22231*                                                                         
T22231     EVALUATE WS04-REV-MM                                         
T22231         WHEN 01 THRU 11                                          
T22231              ADD 1   TO  WS04-REV-MM                             
T22231         WHEN 12                                                  
T22231              MOVE 1  TO  WS04-REV-MM                             
T22231              ADD  1  TO  WS04-REV-YYYY                           
T22231     END-EVALUATE.                                                
T22231                                                                  
T22231     MOVE WS04-REV-YYYYMM      TO  WS04-REV-TEMP.                 
T22231     MOVE WS04-REV-TEMP        TO  WS04-REV-MONTH.                
T22231                                                                  
T22231     EXEC SQL                                                     
T22231          SELECT DATEADD( DAY, -1, MIN(DATE_EXTRACT) )                    
T22231            INTO :WS04-END-REV-DT                                 
T22231            FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
T22231           WHERE REVENUE_MONTH   =  :WS04-REV-MONTH               
T22231             AND BILL_CYCLE      =  :WS-ONE                       
T35434                                                           
T22231     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MIN(DATE_EXTRACT) - 1 DAY                                
MFA-TR*           INTO :WS04-END-REV-DT                                         
MFA-TR*           FROM CSS_BILL_WINDOW                                          
MFA-TR*          WHERE REVENUE_MONTH   =  :WS04-REV-MONTH                       
MFA-TR*            AND BILL_CYCLE      =  :WS-ONE                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22231                                                                  
T22231     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22231                                                                  
T22231     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
T22231        DISPLAY '***************************************'         
T22231        DISPLAY '**   PCSCA704 PROCESSING ERROR       **'         
T22231        DISPLAY '**    ABEND IN PARAGRAPH 1350        **'         
T22231        DISPLAY '**  UNABLE TO RETRIEVE REVENUE DATES **'         
T22231        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
T22231        DISPLAY '**  NO ENTRY FOR MONTH1:' WS04-REV-YYYYMM        
T22231        DISPLAY '**     PROCESSING TERMINATED         **'         
T22231        DISPLAY '***************************************'         
T22231        PERFORM 9900-ABEND THRU 9900-EXIT                         
T22231     END-IF.                                                      
T22231                                                                  
T22231 1350-EXIT.                                                       
T22231     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1400-WRITE-CANCEL-TITLES                                     *         
      *                                                               *         
      *****************************************************************         
       1400-WRITE-CANCEL-TITLES.                                        
                                                                        
           ADD 1 TO WS05-REPORT2-PAGE-NBR.                              
                                                                        
           MOVE WS05-REPORT2-PAGE-NBR TO WS02-TITLE2C-PAGE-NBR.         
                                                                        
           MOVE C01-REPORT2-NAME TO WS01-TITLE1A-REPTNAME.              
                                                                        
           WRITE PRT7042-RECORD FROM WS01-TITLE1A                       
                 AFTER ADVANCING PAGE.                                  
                                                                        
           WRITE PRT7042-RECORD FROM WS02-TITLE2B                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS02-TITLE2C                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS-HEADER1-DETAIL                  
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS-HEADER2-DETAIL                  
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE 7 TO WS05-REPORT2-LINE-CTR.                             
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  1401-WRITE-SEBR-CANCEL-TITLES                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1401-WRITE-SEBR-CANCEL-TITLES.                                   
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT5-PAGE-NBR.         
T27145                                                                  
T27145     MOVE WS05-REPORT5-PAGE-NBR TO WS02-TITLE2C-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT5-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS02-TITLE2B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS02-TITLE2C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS-HEADER1-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS-HEADER2-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE 7                     TO WS05-REPORT5-LINE-CTR.         
T27145                                                                  
T27145 1401-EXIT.                                                       
T27145     EXIT.                                                        
T27145                                                                  
T20186*****************************************************************         
T20186*  1450-WRITE-ESCHEA-TITLES                                     *         
T20186*                                                               *         
T20186*****************************************************************         
T20186 1450-WRITE-ESCHEA-TITLES.                                        
T20186                                                                  
T20186     ADD 1 TO WS05-REPORT3-PAGE-NBR.                              
T20186                                                                  
T20186     MOVE WS05-REPORT3-PAGE-NBR TO WS02-TITLE3C-PAGE-NBR.         
T20186                                                                  
T20186     MOVE C01-REPORT3-NAME TO WS01-TITLE1A-REPTNAME.              
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS01-TITLE1A                       
T20186           AFTER ADVANCING PAGE.                                  
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS02-TITLE3B                       
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS02-TITLE3C                       
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS03-BLANK-LINE                    
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS-HEADER1-DETAIL                  
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS-HEADER2-DETAIL                  
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS03-BLANK-LINE                    
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     MOVE 7 TO WS05-REPORT3-LINE-CTR.                             
T20186                                                                  
T20186 1450-EXIT.                                                       
T20186     EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  1451-WRITE-SEBR-ESCHEA-TITLES                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1451-WRITE-SEBR-ESCHEA-TITLES.                                   
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT6-PAGE-NBR.         
T27145                                                                  
T27145     MOVE WS05-REPORT6-PAGE-NBR TO WS02-TITLE3C-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT6-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS02-TITLE3B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS02-TITLE3C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS-HEADER1-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS-HEADER2-DETAIL                  
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE 7                     TO WS05-REPORT6-LINE-CTR.         
T27145                                                                  
T27145 1451-EXIT.                                                       
T27145     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1500-OPEN-REFUND-CURSOR                                      *         
      *                                                               *         
      *****************************************************************         
       1500-OPEN-REFUND-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN REFUND-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA704 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 1500    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
T22793*****************************************************************         
T22793*  1501-OPEN-CL-REFUND-CURSOR                                    *        
T22793*                                                               *         
T22793*****************************************************************         
T22793 1501-OPEN-CL-REFUND-CURSOR.                                      
T22793                                                                  
T22793     EXEC SQL                                                     
T22793          OPEN CL-REFUND-CURSOR                                   
T22793     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22793                                                                  
T22793     MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
T22793     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T22793         NEXT SENTENCE                                            
T22793     ELSE                                                         
T22793         DISPLAY '***********************************'            
T22793         DISPLAY '**   PCSCA704 PROCESSING ERROR   **'            
T22793         DISPLAY '**    ABEND IN PARAGRAPH 1501    **'            
T22793         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
T22793         DISPLAY '**     PROCESSING TERMINATED     **'            
T22793         DISPLAY '***********************************'            
T22793         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
T22793 1501-EXIT.                                                       
T22793     EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  1502-OPEN-SEBR-REFUND-CURSOR                                 *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1502-OPEN-SEBR-REFUND-CURSOR.                                    
T27145                                                                  
T27145     EXEC SQL                                                     
T27145          OPEN SEBR-REFUND-CURSOR                                 
T27145     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27145                                                                  
T27145     MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
T27145     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T27145         NEXT SENTENCE                                            
T27145     ELSE                                                         
T27145         DISPLAY '***********************************'            
T27145         DISPLAY '**   PCSCA704 PROCESSING ERROR   **'            
T27145         DISPLAY '**    ABEND IN PARAGRAPH 1502    **'            
T27145         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
T27145         DISPLAY '**     PROCESSING TERMINATED     **'            
T27145         DISPLAY '***********************************'            
T27145         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T27145                                                                  
T27145 1502-EXIT.                                                       
T27145     EXIT.                                                        
T27145                                                                  
T27145*****************************************************************         
T27145*  1503-OPEN-SEBR-CLRFND-CURSOR                                 *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1503-OPEN-SEBR-CLRFND-CURSOR.                                    
T27145                                                                  
T27145     EXEC SQL                                                     
T27145          OPEN SEBR-CLRFND-CURSOR                                 
T27145     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27145                                                                  
T27145     MOVE SQLCODE TO  WS-ACTIVE-RETURN-CODE.                      
T27145     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T27145         NEXT SENTENCE                                            
T27145     ELSE                                                         
T27145         DISPLAY '***********************************'            
T27145         DISPLAY '**   PCSCA704 PROCESSING ERROR   **'            
T27145         DISPLAY '**    ABEND IN PARAGRAPH 1503    **'            
T27145         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
T27145         DISPLAY '**     PROCESSING TERMINATED     **'            
T27145         DISPLAY '***********************************'            
T27145         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T27145                                                                  
T27145 1503-EXIT.                                                       
T27145     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  1600-FETCH-REFUND-CURSOR                                     *         
      *                                                               *         
      *****************************************************************         
       1600-FETCH-REFUND-CURSOR.                                        
           EXEC SQL                                                     
                FETCH REFUND-CURSOR                                     
                INTO                                                    
                      :RN-ACCOUNT-NO,                                   
                      :RN-REFUND-CHECK-NO,                              
                      :RN-CHECK-STATUS-CD,                              
                      :RN-REFUND-STATUS-DT :WS-REFUND-STATUS-DT-NULL,   
                      :RN-DATE-ESCHEATED :WS-DATE-ESCHEATED-NULL,     
                      :RN-AMT-REFUNDED,                                 
T27145                :RN-LOCAL-OFFICE,                                 
T23875                :AT-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T27145     MOVE 'Y'     TO WS-SEBR-NOT.                                 
T27145     MOVE 'N'     TO WS-SEBR-YES.                                 
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T23875*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  07080000
T23875     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T23875*       NEXT SENTENCE                                                     
T27145        IF SEB-DATABASE                                           
T27145           IF RN-LOCAL-OFFICE < 500 OR > 599                      
T27145              MOVE 'N'          TO WS-SEBR-NOT                    
T27145           END-IF                                                 
T27145           SET PRESENT-ROW      TO TRUE                           
T27145        END-IF                                                    
T23875     ELSE                                                         
T23875        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T23875           MOVE WS-N TO WS-REFUND-DATA-STATUS                     
T27145           MOVE 'Y'  TO WS-SEBR-YES                               
T23875        ELSE                                                      
                  DISPLAY '***********************************'         
                  DISPLAY '**   PCSCA704 PROCESSING ERROR   **'         
                  DISPLAY '**    ABEND IN PARAGRAPH 1600    **'         
                  DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY '**     PROCESSING TERMINATED     **'         
                  DISPLAY '***********************************'         
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
T23875        END-IF                                                    
T23875     END-IF.                                                      
                                                                        
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
T22793*****************************************************************         
T22793*  1601-FETCH-CL-REFUND-CURSOR                                  *         
T22793*                                                               *         
T22793*****************************************************************         
T22793 1601-FETCH-CL-REFUND-CURSOR.                                     
T22793     EXEC SQL                                                     
T22793          FETCH CL-REFUND-CURSOR                                  
T22793          INTO                                                    
T22793                :RN-ACCOUNT-NO,                                   
T22793                :RN-REFUND-CHECK-NO,                              
T22793                :RN-CHECK-STATUS-CD,                              
T22793                :RN-REFUND-STATUS-DT :WS-REFUND-STATUS-DT-NULL,   
T22793                :RN-DATE-ESCHEATED :WS-DATE-ESCHEATED-NULL,     
T22793                :RN-AMT-REFUNDED,                                 
T27145                :RN-LOCAL-OFFICE,                                 
T23875                :AT-COMPANY-NO                                    
T22793     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22793                                                                  
T27145     MOVE 'Y'     TO WS-NOT-SEBR.                                 
T27145     MOVE 'N'     TO WS-YES-SEBR.                                 
T22793     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22793                                                                  
T23875*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  07080000
T22793     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T22793*       NEXT SENTENCE                                                     
T27145        IF SEB-DATABASE                                           
T27145           IF RN-LOCAL-OFFICE < 500 OR > 599                      
T27145              MOVE 'N'      TO WS-NOT-SEBR                        
T27145           END-IF                                                 
T27145           SET ROW-PRESENT  TO TRUE                               
T27145        END-IF                                                    
T23875     ELSE                                                         
T23875        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T23875           MOVE WS-N  TO WS-CL-REFUND-DATA-STATUS                 
T27145           MOVE 'Y'   TO WS-YES-SEBR                              
T22793        ELSE                                                      
T22793            DISPLAY '***********************************'         
T22793            DISPLAY '**   PCSCA704 PROCESSING ERROR   **'         
T22793            DISPLAY '**    ABEND IN PARAGRAPH 1601    **'         
T22793            DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
T22793            DISPLAY '**     PROCESSING TERMINATED     **'         
T22793            DISPLAY '***********************************'         
T22793            PERFORM 9900-ABEND THRU 9900-EXIT                     
T23875        END-IF                                                    
T23875     END-IF.                                                      
                                                                        
                                                                        
T22793 1601-EXIT.                                                       
T22793     EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  1602-FETCH-SEBR-REFUND-CURSOR                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1602-FETCH-SEBR-REFUND-CURSOR.                                   
T27145     EXEC SQL                                                     
T27145          FETCH SEBR-REFUND-CURSOR                                
T27145          INTO                                                    
T27145                :RN-ACCOUNT-NO,                                   
T27145                :RN-REFUND-CHECK-NO,                              
T27145                :RN-CHECK-STATUS-CD,                              
T27145                :RN-REFUND-STATUS-DT :WS-REFUND-STATUS-DT-NULL,   
T27145                :RN-DATE-ESCHEATED :WS-DATE-ESCHEATED-NULL,     
T27145                :RN-AMT-REFUNDED,                                 
T27145                :RN-LOCAL-OFFICE,                                 
T27145                :AT-COMPANY-NO                                    
T27145     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27145                                                                  
T27145     MOVE 'N'        TO WS-FOUND-SEBR.                            
T27145     MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
T27145                                                                  
T27145     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T27145        MOVE 'Y'     TO  WS-FOUND-SEBR                            
T27145     ELSE                                                         
T27145        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T27145           MOVE WS-N TO WS-SEBR-REFUND-DATA-STATUS                
T27145        ELSE                                                      
T27145            DISPLAY '***********************************'         
T27145            DISPLAY '**   PCSCA704 PROCESSING ERROR   **'         
T27145            DISPLAY '**    ABEND IN PARAGRAPH 1602    **'         
T27145            DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
T27145            DISPLAY '**     PROCESSING TERMINATED     **'         
T27145            DISPLAY '***********************************'         
T27145            PERFORM 9900-ABEND THRU 9900-EXIT                     
T27145        END-IF                                                    
T27145     END-IF.                                                      
T27145                                                                  
T27145 1602-EXIT.                                                       
T27145     EXIT.                                                        
T27145*****************************************************************         
T27145*  1603-FETCH-SEBR-CLRFND-CURSOR                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 1603-FETCH-SEBR-CLRFND-CURSOR.                                   
T27145     EXEC SQL                                                     
T27145          FETCH SEBR-CLRFND-CURSOR                                
T27145          INTO                                                    
T27145                :RN-ACCOUNT-NO,                                   
T27145                :RN-REFUND-CHECK-NO,                              
T27145                :RN-CHECK-STATUS-CD,                              
T27145                :RN-REFUND-STATUS-DT :WS-REFUND-STATUS-DT-NULL,   
T27145                :RN-DATE-ESCHEATED :WS-DATE-ESCHEATED-NULL,     
T27145                :RN-AMT-REFUNDED,                                 
T27145                :RN-LOCAL-OFFICE,                                 
T27145                :AT-COMPANY-NO                                    
T27145     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27145                                                                  
T27145     MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
T27145                                                                  
T27145     MOVE 'N'         TO WS-SEBR-FOUND.                           
T27145     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T27145        MOVE 'Y'      TO WS-SEBR-FOUND                            
T27145     ELSE                                                         
T27145        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T27145           MOVE WS-N  TO WS-SEBR-CL-REFUND-DATA-STATUS            
T27145        ELSE                                                      
T27145            DISPLAY '***********************************'         
T27145            DISPLAY '**   PCSCA704 PROCESSING ERROR   **'         
T27145            DISPLAY '**    ABEND IN PARAGRAPH 1603    **'         
T27145            DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
T27145            DISPLAY '**     PROCESSING TERMINATED     **'         
T27145            DISPLAY '***********************************'         
T27145            PERFORM 9900-ABEND THRU 9900-EXIT                     
T27145        END-IF                                                    
T27145     END-IF.                                                      
T27145*                                                                         
T27145 1603-EXIT.                                                       
T27145     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  2000-PRODUCE-REPORTS                                         *         
      *                                                               *         
      *****************************************************************         
       2000-PRODUCE-REPORTS.                                            
                                                                        
T22793*    IF WS05-REPORT1-LINE-CTR > 56                                        
T22793*       PERFORM 2100-WRITE-CLEAR-PAGE-TOTALS THRU 2100-EXIT               
T22793*       PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT                    
T22793*    END-IF                                                               
T23875*                                                                         
T23875     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T23875       IF FIRST-SCEG                                              
T23875        IF AT-COMPANY-NO  NOT EQUAL WS-ONE                        
T23875          MOVE WS-ONE             TO C7-COMPANY-NO                
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T23875          PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT         
T23875          PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT         
T23875          WRITE PRT7042-RECORD FROM WS04A-NO-DATA-LINE            
T23875              AFTER ADVANCING 1 LINE                              
T23875          WRITE PRT7043-RECORD FROM WS04A-NO-DATA-LINE            
T23875              AFTER ADVANCING 1 LINE                              
T27145          IF SEB-DATABASE                                         
T27145            PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT  
T27145            PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT  
T27145            WRITE PRT7045-RECORD FROM WS04A-NO-DATA-LINE          
T27145                AFTER ADVANCING 1 LINE                            
T27145            WRITE PRT7046-RECORD FROM WS04A-NO-DATA-LINE          
T27145                AFTER ADVANCING 1 LINE                            
T27145          END-IF                                                  
T23875          MOVE AT-COMPANY-NO      TO C7-COMPANY-NO,               
T23875                                     WS-HOLD-COMPANY              
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T23875          PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT         
T23875          PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT         
T27145          IF SEB-DATABASE                                         
T27145            MOVE SPACES           TO WS01-TITLE1A-SEB-DIV         
T27145            PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT  
T27145            PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT  
T27145          END-IF                                                  
T23875          SET NOT-PSNC            TO TRUE                         
T23875        ELSE                                                      
T23875          MOVE AT-COMPANY-NO      TO C7-COMPANY-NO,               
T23875                                     WS-HOLD-COMPANY              
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T23875          PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT         
T23875          PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT         
T27145          IF SEB-DATABASE                                         
T27145            MOVE WS-DEREG-TITLE   TO WS01-TITLE1A-SEB-DIV         
T27145            PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT  
T27145            PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT  
T27145            MOVE SPACES           TO WS01-TITLE1A-SEB-DIV         
T27145          END-IF                                                  
T23875        END-IF                                                    
T23875        SET SECOND-SCEG         TO TRUE                           
T23875       END-IF                                                     
T23875       IF AT-COMPANY-NO NOT EQUAL WS-HOLD-COMPANY                 
T23875         MOVE AT-COMPANY-NO  TO WS-HOLD-COMPANY,                  
T23875                                C7-COMPANY-NO                     
T23875         PERFORM 2200-WRITE-CANCEL-PAGE-TOTALS THRU 2200-EXIT     
T23875         PERFORM 2250-WRITE-CANCEL-GRAND-TOTAL THRU 2250-EXIT     
T27145         IF SEB-DATABASE AND WS-SEBR-NOT = 'N'                    
T27145           MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV           
T27145           PERFORM 2201-WRITE-SEBR-CANPAGE-TOTALS                 
T27145                                               THRU 2201-EXIT     
T27145           PERFORM 2251-WRITE-SEBR-CANGRND-TOTAL                  
T27145                                               THRU 2251-EXIT     
T27145           MOVE SPACES          TO WS01-TITLE1A-SEB-DIV           
T27145         END-IF                                                   
T27145                                                                  
T23875         INITIALIZE WS05-DET-CAN-CNT-TOT,                         
T23875                    WS05-DET-CAN-AMT-TOT,                         
T23875                    WS06-CANCEL-TOT-CNT,                          
T23875                    WS06-CANCEL-TOT-AMT                           
T23875         PERFORM 2300-WRITE-ESCHEA-PAGE-TOTALS THRU 2300-EXIT     
T23875         PERFORM 2350-WRITE-ESCHEA-GRAND-TOTAL THRU 2350-EXIT     
T27145         IF SEB-DATABASE AND WS-SEBR-NOT ='N'                     
T27145           MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV           
T27145           PERFORM 2301-WRITE-SEBR-ESCPAGE-TOTALS                 
T27145                                               THRU 2301-EXIT     
T27145           PERFORM 2351-WRITE-SEBR-ESCGRND-TOTAL                  
T27145                                               THRU 2351-EXIT     
T27145           MOVE SPACES          TO WS01-TITLE1A-SEB-DIV           
T27145         END-IF                                                   
T27145*                                                                         
T23875         INITIALIZE WS05-DET-ESC-CNT-TOT,                         
T23875                    WS05-DET-ESC-AMT-TOT,                         
T23875                    WS06-ESCHEA-TOT-CNT,                          
T23875                    WS06-ESCHEA-TOT-AMT                           
T23875         PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT           
T23875         MOVE C7-COMPANY-NAME   TO WS01-TITLE1A-COMP-NAME         
T23875         PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT          
T23875         PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT          
T27145         IF SEB-DATABASE AND WS-SEBR-NOT = 'N'                    
T27145           MOVE WS-DEREG-TITLE   TO WS01-TITLE1A-SEB-DIV          
T27145           PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT   
T27145           PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT   
T27145           MOVE SPACES           TO WS01-TITLE1A-SEB-DIV          
T27145         END-IF                                                   
T23875         SET NOT-PSNC            TO TRUE                          
T23875       END-IF                                                     
T23875     END-IF.                                                      
T23875                                                                  
           IF WS05-REPORT2-LINE-CTR > 56                                
              PERFORM 2200-WRITE-CANCEL-PAGE-TOTALS THRU 2200-EXIT      
              PERFORM 1400-WRITE-CANCEL-TITLES THRU 1400-EXIT           
           END-IF                                                       
                                                                        
T20186     IF WS05-REPORT3-LINE-CTR > 56                                
T20186        PERFORM 2300-WRITE-ESCHEA-PAGE-TOTALS THRU 2300-EXIT      
T20186        PERFORM 1450-WRITE-ESCHEA-TITLES THRU 1450-EXIT           
T20186     END-IF                                                       
                                                                        
T27145     IF WS05-REPORT5-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          MOVE WS-DEREG-TITLE    TO WS01-TITLE1A-SEB-DIV          
T27145          PERFORM 2201-WRITE-SEBR-CANPAGE-TOTALS                  
T27145                                                THRU 2201-EXIT    
T27145          PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT    
T27145          MOVE SPACES            TO WS01-TITLE1A-SEB-DIV          
T27145        END-IF                                                    
T27145     END-IF                                                       
T27145                                                                  
T27145     IF WS05-REPORT6-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          MOVE WS-DEREG-TITLE    TO WS01-TITLE1A-SEB-DIV          
T27145          PERFORM 2301-WRITE-SEBR-ESCPAGE-TOTALS                  
T27145                                                THRU 2301-EXIT    
T27145          PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES                   
T27145                                                THRU 1451-EXIT    
T27145          MOVE SPACES            TO WS01-TITLE1A-SEB-DIV          
T27145        END-IF                                                    
T20186     END-IF                                                       
                                                                        
           MOVE RN-REFUND-CHECK-NO TO WS03-CHECK-NO.                    
           MOVE RN-AMT-REFUNDED TO WS03-CHECK-AMOUNT.                   
           MOVE RN-ACCOUNT-NO TO WS03-ACCOUNT-NO                        
                                 AT-ACCOUNT-NO.                         
           MOVE 'Y' TO WS-NAME-ONLY-SW.                                 
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           MOVE WS-ACCOUNT-NAME TO WS03-CUSTOMER-NAME.                  
           IF REFUND-STATUS-DT-NULL                                     
              MOVE SPACES TO WS03-REFUND-STATUS-DT                      
           ELSE                                                         
              MOVE RN-REFUND-STATUS-DT TO WS03-REFUND-STATUS-DT         
           END-IF                                                       
                                                                        
T22793*    IF RN-CHECK-STATUS-CD = 'L'                                          
T22793*       MOVE 'CLEARED' TO WS03-CHECK-STATUS                               
T22793*       ADD 1 TO WS05-DET-CLR-CNT                                         
T22793*                WS05-DET-CLR-CNT-TOT                                     
T22793*       ADD RN-AMT-REFUNDED TO WS05-DET-CLR-AMT                           
T22793*                              WS05-DET-CLR-AMT-TOT                       
T22793*       WRITE PRT7041-RECORD FROM WS03-LINE-DETAIL                        
T22793*             AFTER ADVANCING 1 LINE                                      
T22793*       ADD 1 TO WS05-REPORT1-LINE-CTR                                    
T22793*    ELSE                                                                 
              IF RN-CHECK-STATUS-CD = 'X'                               
                 MOVE 'VOIDED' TO WS03-CHECK-STATUS                     
              ELSE                                                      
T22793        IF RN-CHECK-STATUS-CD = 'S'                               
                 MOVE 'STOP PAYMENT' TO WS03-CHECK-STATUS               
              END-IF                                                    
T22793        END-IF                                                    
T20186*       ADD 1 TO WS05-DET-CAN-CNT                                         
T20186*                WS05-DET-CAN-CNT-TOT                                     
T20186*       ADD RN-AMT-REFUNDED TO WS05-DET-CAN-AMT                           
T20186*                              WS05-DET-CAN-AMT-TOT                       
T20186*          WRITE PRT7042-RECORD FROM WS03-LINE-DETAIL                     
T20186*                AFTER ADVANCING 1 LINE                                   
T20186        IF DATE-ESCHEATED-NULL                                    
T20186           ADD 1 TO WS05-DET-CAN-CNT                              
T20186                    WS05-DET-CAN-CNT-TOT                          
T20186           ADD RN-AMT-REFUNDED TO WS05-DET-CAN-AMT                
T20186                                  WS05-DET-CAN-AMT-TOT            
T20186           WRITE PRT7042-RECORD FROM WS03-LINE-DETAIL             
T20186                 AFTER ADVANCING 1 LINE                           
T20186           ADD 1 TO WS05-REPORT2-LINE-CTR                         
T27145           IF WS-SEBR-NOT = 'N' AND SEB-DATABASE                  
T27145             WRITE PRT7045-RECORD FROM WS03-LINE-DETAIL           
T27145                   AFTER ADVANCING 1 LINE                         
T27145             ADD 1               TO WS05-SEBR-DET-CAN-CNT         
T27145                                    WS05-SEBR-DET-CAN-CNT-TOT     
T27145                                                                  
T27145             ADD RN-AMT-REFUNDED TO WS05-SEBR-DET-CAN-AMT         
T27145                                    WS05-SEBR-DET-CAN-AMT-TOT     
T27145                                                                  
T27145             ADD 1               TO WS05-REPORT5-LINE-CTR         
T27145           END-IF                                                 
T20186        ELSE                                                      
T20186           ADD 1 TO WS05-DET-ESC-CNT                              
T20186                    WS05-DET-ESC-CNT-TOT                          
T20186           ADD RN-AMT-REFUNDED TO WS05-DET-ESC-AMT                
T20186                                  WS05-DET-ESC-AMT-TOT            
T20186           WRITE PRT7043-RECORD FROM WS03-LINE-DETAIL             
T20186                 AFTER ADVANCING 1 LINE                           
T20186           ADD 1 TO WS05-REPORT3-LINE-CTR                         
T27145           IF WS-SEBR-NOT = 'N' AND SEB-DATABASE                  
T27145             WRITE PRT7046-RECORD FROM WS03-LINE-DETAIL           
T27145                   AFTER ADVANCING 1 LINE                         
T27145             ADD 1               TO WS05-SEBR-DET-ESC-CNT         
T27145                                    WS05-SEBR-DET-ESC-CNT-TOT     
T27145             ADD RN-AMT-REFUNDED TO WS05-SEBR-DET-ESC-AMT         
T27145                                    WS05-SEBR-DET-ESC-AMT-TOT     
T27145                                                                  
T27145             ADD 1               TO WS05-REPORT6-LINE-CTR         
T27145           END-IF                                                 
T20186        END-IF.                                                   
                                                                        
T20186*       ADD 1 TO WS05-REPORT2-LINE-CTR                                    
T22793*    END-IF.                                                              
                                                                        
T27145     IF WS-FOUND-SEBR = 'Y'                                       
T27145        PERFORM 1602-FETCH-SEBR-REFUND-CURSOR                     
T27145     ELSE                                                         
              PERFORM 1600-FETCH-REFUND-CURSOR                          
T27145     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  2002-PRODUCE-SEBR-REPORTS                                    *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2002-PRODUCE-SEBR-REPORTS.                                       
T27145                                                                  
T27145     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T27145        MOVE WS-REG-TITLE     TO WS01-TITLE1A-SEB-DIV             
T27145        IF WS-FIRST-TIME = 'Y'                                    
T27145         MOVE AT-COMPANY-NO   TO WS-HOLD-COMPANY,                 
T27145                                 C7-COMPANY-NO                    
T27145         PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT           
T27145                                                                  
T27145         MOVE WS-REG-TITLE    TO WS01-TITLE1A-SEB-DIV             
T27145         PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT     
T27145         PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES THRU 1451-EXIT     
T27145         MOVE 'N'             TO WS-FIRST-TIME                    
T27145        END-IF                                                    
T27145                                                                  
T27145     END-IF.                                                      
T27145                                                                  
T27145     IF WS05-REPORT5-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          PERFORM 2201-WRITE-SEBR-CANPAGE-TOTALS                  
T27145                                                THRU 2201-EXIT    
T27145          PERFORM 1401-WRITE-SEBR-CANCEL-TITLES THRU 1401-EXIT    
T27145        END-IF                                                    
T27145     END-IF                                                       
T27145                                                                  
T27145     IF WS05-REPORT6-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          PERFORM 2301-WRITE-SEBR-ESCPAGE-TOTALS                  
T27145                                                THRU 2301-EXIT    
T27145          PERFORM 1451-WRITE-SEBR-ESCHEA-TITLES                   
T27145                                                THRU 1451-EXIT    
T27145        END-IF                                                    
T27145     END-IF                                                       
T27145                                                                  
T27145     MOVE RN-REFUND-CHECK-NO TO WS03-CHECK-NO.                    
T27145     MOVE RN-AMT-REFUNDED    TO WS03-CHECK-AMOUNT.                
T27145     MOVE RN-ACCOUNT-NO      TO WS03-ACCOUNT-NO                   
T27145                                AT-ACCOUNT-NO.                    
T27145     MOVE 'Y'                TO WS-NAME-ONLY-SW.                  
T27145     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
T27145     MOVE WS-ACCOUNT-NAME    TO WS03-CUSTOMER-NAME.               
T27145     IF REFUND-STATUS-DT-NULL                                     
T27145        MOVE SPACES              TO WS03-REFUND-STATUS-DT         
T27145     ELSE                                                         
T27145        MOVE RN-REFUND-STATUS-DT TO WS03-REFUND-STATUS-DT         
T27145     END-IF                                                       
T27145                                                                  
T27145     IF RN-CHECK-STATUS-CD = 'X'                                  
T27145        MOVE 'VOIDED'        TO WS03-CHECK-STATUS                 
T27145     ELSE                                                         
T27145     IF RN-CHECK-STATUS-CD = 'S'                                  
T27145        MOVE 'STOP PAYMENT'  TO WS03-CHECK-STATUS                 
T27145      END-IF                                                      
T27145      END-IF                                                      
T27145      IF DATE-ESCHEATED-NULL                                      
T27145         ADD 1               TO WS05-SEBR-DET-CAN-CNT             
T27145                                WS05-SEBR-DET-CAN-CNT-TOT         
T27145         ADD RN-AMT-REFUNDED TO WS05-SEBR-DET-CAN-AMT             
T27145                                WS05-SEBR-DET-CAN-AMT-TOT         
T27145         IF WS-FOUND-SEBR = 'Y' AND SEB-DATABASE                  
T27145           WRITE PRT7045-RECORD FROM WS03-LINE-DETAIL             
T27145                 AFTER ADVANCING 1 LINE                           
T27145           ADD 1             TO WS05-REPORT5-LINE-CTR             
T27145         END-IF                                                   
T27145      ELSE                                                        
T27145         ADD 1               TO WS05-SEBR-DET-ESC-CNT             
T27145                                WS05-SEBR-DET-ESC-CNT-TOT         
T27145         ADD RN-AMT-REFUNDED TO WS05-SEBR-DET-ESC-AMT             
T27145                                WS05-SEBR-DET-ESC-AMT-TOT         
T27145         IF WS-FOUND-SEBR = 'Y' AND SEB-DATABASE                  
T27145           WRITE PRT7046-RECORD FROM WS03-LINE-DETAIL             
T27145                 AFTER ADVANCING 1 LINE                           
T27145           ADD 1             TO WS05-REPORT6-LINE-CTR             
T27145         END-IF                                                   
T27145      END-IF.                                                     
                                                                        
T27145      PERFORM 1602-FETCH-SEBR-REFUND-CURSOR.                      
                                                                        
       2002-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22793*****************************************************************         
T22793*  2001-PRODUCE-REPORTS                                         *         
T22793*                                                               *         
T22793*****************************************************************         
T22793 2001-PRODUCE-REPORTS.                                            
T22793                                                                  
T23875     IF SCEG-FIRST                                                
T23875       IF AT-COMPANY-NO  NOT EQUAL WS-ONE                         
T23875          MOVE WS-ONE          TO C7-COMPANY-NO                   
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME TO WS01-TITLE1A-COMP-NAME          
T22793          PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT          
T22793          WRITE PRT7041-RECORD FROM WS04A-NO-DATA-LINE            
T22793              AFTER ADVANCING 1 LINE                              
T27145          IF SEB-DATABASE                                         
T27145            PERFORM 1301-WRITE-SEBR-CLEAR-TITLES THRU 1301-EXIT   
T27145            WRITE PRT7044-RECORD FROM WS04A-NO-DATA-LINE          
T27145                AFTER ADVANCING 1 LINE                            
T27145          END-IF                                                  
T23875          MOVE AT-COMPANY-NO   TO C7-COMPANY-NO,                  
T23875                                  WS-HOLD-COMPANY                 
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T22793          PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT          
T27145          IF SEB-DATABASE                                         
T27145            PERFORM 1301-WRITE-SEBR-CLEAR-TITLES THRU 1301-EXIT   
T27145          END-IF                                                  
T23875          SET  NO-PSNC           TO  TRUE                         
T23875       ELSE                                                       
T23875          MOVE AT-COMPANY-NO   TO C7-COMPANY-NO,                  
T23875                                     WS-HOLD-COMPANY              
T23875          PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT          
T23875          MOVE C7-COMPANY-NAME    TO WS01-TITLE1A-COMP-NAME       
T22793          PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT          
T27145          IF SEB-DATABASE                                         
T27145            MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV          
T27145            PERFORM 1301-WRITE-SEBR-CLEAR-TITLES THRU 1301-EXIT   
T27145            MOVE SPACES          TO WS01-TITLE1A-SEB-DIV          
T27145          END-IF                                                  
T23875       END-IF                                                     
T23875       SET SCEG-SECOND         TO TRUE                            
T23875     END-IF                                                       
T23875     IF AT-COMPANY-NO NOT EQUAL WS-HOLD-COMPANY                   
T23875        MOVE AT-COMPANY-NO     TO WS-HOLD-COMPANY,                
T23875                                  C7-COMPANY-NO                   
T23875        PERFORM 2100-WRITE-CLEAR-PAGE-TOTALS THRU 2100-EXIT       
T23875        PERFORM 2150-WRITE-CLEAR-GRAND-TOTAL THRU 2150-EXIT       
T27145        IF SEB-DATABASE AND WS-NOT-SEBR = 'N'                     
T27145          MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV            
T27145          PERFORM 2101-WRITE-SEBR-CLRPAGE-TOTALS THRU 2101-EXIT   
T27145          PERFORM 2151-WRITE-SEBR-CLRGRAND-TOTAL THRU 2151-EXIT   
T27145          MOVE SPACES          TO WS01-TITLE1A-SEB-DIV            
T27145        END-IF                                                    
T27145                                                                  
T23875        INITIALIZE WS05-DET-CLR-CNT-TOT,                          
T23875                   WS05-DET-CLR-AMT-TOT,                          
T23875                   WS06-CLEAR-TOT-CNT,                            
T23875                   WS06-CLEAR-TOT-AMT                             
T23875        PERFORM 1210-RETRIEVE-COMP-NAME THRU 1210-EXIT            
T23875        MOVE C7-COMPANY-NAME TO WS01-TITLE1A-COMP-NAME            
T23875        PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT            
T27145        IF SEB-DATABASE AND WS-NOT-SEBR = 'N'                     
T27145           MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV           
T27145           PERFORM 1301-WRITE-SEBR-CLEAR-TITLES THRU 1301-EXIT    
T27145           MOVE SPACES          TO WS01-TITLE1A-SEB-DIV           
T27145        END-IF                                                    
T23875        SET  NO-PSNC           TO  TRUE                           
T23875     END-IF.                                                      
T23875*                                                                         
T22793     IF WS05-REPORT1-LINE-CTR > 56                                
T22793        PERFORM 2100-WRITE-CLEAR-PAGE-TOTALS THRU 2100-EXIT       
T22793        PERFORM 1300-WRITE-CLEAR-TITLES THRU 1300-EXIT            
T22793     END-IF.                                                      
                                                                        
T27145     IF WS05-REPORT4-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          MOVE WS-DEREG-TITLE  TO WS01-TITLE1A-SEB-DIV            
T27145          PERFORM 2101-WRITE-SEBR-CLRPAGE-TOTALS THRU 2101-EXIT   
T27145          PERFORM 1301-WRITE-SEBR-CLEAR-TITLES   THRU 1301-EXIT   
T27145          MOVE SPACES          TO WS01-TITLE1A-SEB-DIV            
T27145        END-IF                                                    
T27145     END-IF.                                                      
                                                                        
T22793     MOVE RN-REFUND-CHECK-NO TO WS03-CHECK-NO.                    
T22793     MOVE RN-AMT-REFUNDED TO WS03-CHECK-AMOUNT.                   
T22793     MOVE RN-ACCOUNT-NO TO WS03-ACCOUNT-NO                        
T22793                           AT-ACCOUNT-NO.                         
T22793     MOVE 'Y' TO WS-NAME-ONLY-SW.                                 
T22793     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
T22793     MOVE WS-ACCOUNT-NAME TO WS03-CUSTOMER-NAME.                  
T22793     IF REFUND-STATUS-DT-NULL                                     
T22793        MOVE SPACES TO WS03-REFUND-STATUS-DT                      
T22793     ELSE                                                         
T22793        MOVE RN-REFUND-STATUS-DT TO WS03-REFUND-STATUS-DT         
T22793     END-IF.                                                      
                                                                        
T22793     IF RN-CHECK-STATUS-CD = 'L'                                  
T22793        MOVE 'CLEARED' TO WS03-CHECK-STATUS                       
T22793        ADD 1 TO WS05-DET-CLR-CNT                                 
T22793                 WS05-DET-CLR-CNT-TOT                             
T22793        ADD RN-AMT-REFUNDED TO WS05-DET-CLR-AMT                   
T22793                               WS05-DET-CLR-AMT-TOT               
T22793        WRITE PRT7041-RECORD FROM WS03-LINE-DETAIL                
T22793              AFTER ADVANCING 1 LINE                              
T22793        ADD 1 TO WS05-REPORT1-LINE-CTR                            
T27145        IF WS-NOT-SEBR = 'N' AND SEB-DATABASE                     
T27145          WRITE PRT7044-RECORD FROM WS03-LINE-DETAIL              
T27145                AFTER ADVANCING 1 LINE                            
T27145          ADD 1               TO WS05-SEBR-DET-CLR-CNT            
T27145                                 WS05-SEBR-DET-CLR-CNT-TOT        
T27145          ADD RN-AMT-REFUNDED TO WS05-SEBR-DET-CLR-AMT            
T27145                                 WS05-SEBR-DET-CLR-AMT-TOT        
T27145          ADD 1 TO WS05-REPORT4-LINE-CTR                          
T27145        END-IF                                                    
T22793     END-IF.                                                      
                                                                        
T27145     IF WS-SEBR-FOUND = 'Y'                                       
T27145        PERFORM 1603-FETCH-SEBR-CLRFND-CURSOR                     
T27145     ELSE                                                         
T22793        PERFORM 1601-FETCH-CL-REFUND-CURSOR                       
T27145     END-IF.                                                      
                                                                        
       2001-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  2003-PRODUCE-SEBR-REPORTS                                    *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2003-PRODUCE-SEBR-REPORTS.                                       
T27145     IF WS-TIME-FIRST = 'Y'                                       
T27145        MOVE ZEROES          TO WS05-REPORT4-LINE-CTR             
T27145        MOVE AT-COMPANY-NO   TO C7-COMPANY-NO,                    
T27145                                WS-HOLD-COMPANY                   
T27145                                                                  
T27145        PERFORM 1210-RETRIEVE-COMP-NAME          THRU 1210-EXIT   
T27145        MOVE WS-REG-TITLE    TO WS01-TITLE1A-SEB-DIV              
T27145                                                                  
T27145        PERFORM 1301-WRITE-SEBR-CLEAR-TITLES     THRU 1301-EXIT   
T27145                                                                  
T27145        INITIALIZE WS05-SEBR-DET-CLR-CNT-TOT,                     
T27145                   WS05-SEBR-DET-CLR-AMT-TOT,                     
T27145                   WS06-CLEAR-TOT-CNT,                            
T27145                   WS06-CLEAR-TOT-AMT,                            
T27145                   WS05-SEBR-DET-CLR-AMT                          
T27145                                                                  
T27145        MOVE 'N'             TO WS-TIME-FIRST                     
T27145     END-IF                                                       
T27145                                                                  
T27145     MOVE WS-REG-TITLE       TO WS01-TITLE1A-SEB-DIV.             
T27145                                                                  
T27145     IF WS05-REPORT4-LINE-CTR > 56                                
T27145        IF SEB-DATABASE                                           
T27145          PERFORM 2101-WRITE-SEBR-CLRPAGE-TOTALS THRU 2101-EXIT   
T27145          PERFORM 1301-WRITE-SEBR-CLEAR-TITLES   THRU 1301-EXIT   
T27145        END-IF                                                    
T27145     END-IF.                                                      
T27145                                                                  
T27145     MOVE RN-REFUND-CHECK-NO TO WS03-CHECK-NO.                    
T27145     MOVE RN-AMT-REFUNDED    TO WS03-CHECK-AMOUNT.                
T27145     MOVE RN-ACCOUNT-NO      TO WS03-ACCOUNT-NO                   
T27145                                AT-ACCOUNT-NO.                    
T27145     MOVE 'Y'                TO WS-NAME-ONLY-SW.                  
T27145     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
T27145     MOVE WS-ACCOUNT-NAME    TO WS03-CUSTOMER-NAME.               
T27145     IF REFUND-STATUS-DT-NULL                                     
T27145        MOVE SPACES              TO WS03-REFUND-STATUS-DT         
T27145     ELSE                                                         
T27145        MOVE RN-REFUND-STATUS-DT TO WS03-REFUND-STATUS-DT         
T27145     END-IF.                                                      
T27145                                                                  
T27145     IF RN-CHECK-STATUS-CD = 'L'                                  
T27145        MOVE 'CLEARED'       TO WS03-CHECK-STATUS                 
T27145        ADD 1                TO WS05-SEBR-DET-CLR-CNT             
T27145                                WS05-SEBR-DET-CLR-CNT-TOT         
T27145        ADD RN-AMT-REFUNDED  TO WS05-SEBR-DET-CLR-AMT             
T27145                                WS05-SEBR-DET-CLR-AMT-TOT         
T27145                                                                  
T27145        IF WS-SEBR-FOUND = 'Y' AND SEB-DATABASE                   
T27145          WRITE PRT7044-RECORD FROM WS03-LINE-DETAIL              
T27145                AFTER ADVANCING 1 LINE                            
T27145          ADD 1              TO WS05-REPORT4-LINE-CTR             
T27145        END-IF                                                    
T27145     END-IF.                                                      
T27145                                                                  
T27145     PERFORM 1603-FETCH-SEBR-CLRFND-CURSOR.                       
                                                                        
       2003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  2100-WRITE-CLEAR-PAGE-TOTALS                                 *         
      *                                                               *         
      *****************************************************************         
       2100-WRITE-CLEAR-PAGE-TOTALS.                                    
                                                                        
                                                                        
           MOVE WS05-DET-CLR-CNT TO WS06-CLEAR-PAGE-CNT.                
           MOVE WS05-DET-CLR-AMT TO WS06-CLEAR-PAGE-AMT.                
           WRITE PRT7041-RECORD FROM WS06-CLEAR-LINE-TOTAL              
                 AFTER ADVANCING 2 LINES.                               
                                                                        
           WRITE PRT7041-RECORD FROM WS06-CLEAR-LINE-AMOUNT             
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE ZEROES TO WS05-DET-CLR-CNT                              
                          WS05-DET-CLR-AMT.                             
                                                                        
           ADD 3 TO WS05-REPORT1-LINE-CTR.                              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  2101-WRITE-SEBR-CLRPAGE-TOTALS                               *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2101-WRITE-SEBR-CLRPAGE-TOTALS.                                  
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-CLR-CNT TO WS06-CLEAR-PAGE-CNT.           
T27145     MOVE WS05-SEBR-DET-CLR-AMT TO WS06-CLEAR-PAGE-AMT.           
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS06-CLEAR-LINE-TOTAL              
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS06-CLEAR-LINE-AMOUNT             
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE ZEROES                TO WS05-SEBR-DET-CLR-CNT          
T27145                                   WS05-SEBR-DET-CLR-AMT.         
T27145                                                                  
T27145     ADD 3                      TO WS05-REPORT4-LINE-CTR.         
T27145                                                                  
T27145 2101-EXIT.                                                       
T27145     EXIT.                                                        
                                                                        
T23875*****************************************************************         
T23875*  2150-WRITE-CLEAR-GRAND-TOTAL                                 *         
T23875*                                                               *         
T23875*****************************************************************         
T23875 2150-WRITE-CLEAR-GRAND-TOTAL.                                    
T23875                                                                  
T23875     ADD 1 TO WS05-REPORT1-PAGE-NBR.                              
T23875                                                                  
T23875     MOVE C01-REPORT1-NAME TO WS01-TITLE1A-REPTNAME.              
T23875                                                                  
T23875     MOVE WS05-REPORT1-PAGE-NBR TO WS01-TITLE1C-PAGE-NBR.         
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS01-TITLE1A                       
T23875           AFTER ADVANCING PAGE.                                  
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS01-TITLE1B                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS01-TITLE1C                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS03-BLANK-LINE                    
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     MOVE WS05-DET-CLR-CNT-TOT TO WS06-CLEAR-TOT-CNT.             
T23875     MOVE WS05-DET-CLR-AMT-TOT TO WS06-CLEAR-TOT-AMT.             
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS06-CLEAR-GRAND-TOTAL             
T23875           AFTER ADVANCING 2 LINES.                               
T23875                                                                  
T23875     WRITE PRT7041-RECORD FROM WS06-CLEAR-GRAND-AMOUNT            
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875 2150-EXIT.                                                       
T23875     EXIT.                                                        
T27145*                                                                         
T27145*****************************************************************         
T27145*  2151-WRITE-SEBR-CLRGRAND-TOTAL                               *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2151-WRITE-SEBR-CLRGRAND-TOTAL.                                  
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT4-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT4-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     MOVE WS05-REPORT4-PAGE-NBR TO WS01-TITLE1C-PAGE-NBR.         
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS01-TITLE1C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-CLR-CNT-TOT TO WS06-CLEAR-TOT-CNT.        
T27145     MOVE WS05-SEBR-DET-CLR-AMT-TOT TO WS06-CLEAR-TOT-AMT.        
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS06-CLEAR-GRAND-TOTAL             
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7044-RECORD FROM WS06-CLEAR-GRAND-AMOUNT            
T27145           AFTER ADVANCING 1 LINE.                                
T27145*                                                                         
T27145 2151-EXIT.                                                       
T27145     EXIT.                                                        
T27145                                                                  
      *****************************************************************         
      *  2200-WRITE-CANCEL-PAGE-TOTALS                                *         
      *                                                               *         
      *****************************************************************         
       2200-WRITE-CANCEL-PAGE-TOTALS.                                   
                                                                        
           MOVE WS05-DET-CAN-CNT TO WS06-CANCEL-PAGE-CNT.               
           MOVE WS05-DET-CAN-AMT TO WS06-CANCEL-PAGE-AMT.               
                                                                        
           WRITE PRT7042-RECORD FROM WS06-CANCEL-LINE-TOTAL             
                 AFTER ADVANCING 2 LINES.                               
                                                                        
           WRITE PRT7042-RECORD FROM WS06-CANCEL-LINE-AMOUNT            
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           MOVE ZEROES TO WS05-DET-CAN-CNT                              
                          WS05-DET-CAN-AMT.                             
                                                                        
           ADD 3 TO WS05-REPORT2-LINE-CTR.                              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
T27145*                                                                         
T27145*****************************************************************         
T27145*  2201-WRITE-SEBR-CANPAGE-TOTALS                               *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2201-WRITE-SEBR-CANPAGE-TOTALS.                                  
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-CAN-CNT TO WS06-CANCEL-PAGE-CNT.          
T27145     MOVE WS05-SEBR-DET-CAN-AMT TO WS06-CANCEL-PAGE-AMT.          
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS06-CANCEL-LINE-TOTAL             
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS06-CANCEL-LINE-AMOUNT            
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE ZEROES                TO WS05-SEBR-DET-CAN-CNT          
T27145                                   WS05-SEBR-DET-CAN-AMT.         
T27145                                                                  
T27145     ADD 3                      TO WS05-REPORT5-LINE-CTR.         
T27145                                                                  
T27145 2201-EXIT.                                                       
T27145     EXIT.                                                        
T27145*                                                                         
T23875*****************************************************************         
T23875*  2250-WRITE-CANCEL-GRAND-TOTAL                                *         
T23875*                                                               *         
T23875*****************************************************************         
T23875 2250-WRITE-CANCEL-GRAND-TOTAL.                                   
T23875                                                                  
T23875     ADD 1 TO WS05-REPORT2-PAGE-NBR.                              
T23875                                                                  
T23875     MOVE C01-REPORT2-NAME TO WS01-TITLE1A-REPTNAME.              
T23875                                                                  
T23875     MOVE WS05-REPORT2-PAGE-NBR TO WS02-TITLE2C-PAGE-NBR          
T23875     WRITE PRT7042-RECORD FROM WS01-TITLE1A                       
T23875           AFTER ADVANCING PAGE.                                  
T23875                                                                  
T23875     WRITE PRT7042-RECORD FROM WS02-TITLE2B                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7042-RECORD FROM WS02-TITLE2C                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7042-RECORD FROM WS03-BLANK-LINE                    
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     MOVE WS05-DET-CAN-CNT-TOT TO WS06-CANCEL-TOT-CNT.            
T23875     MOVE WS05-DET-CAN-AMT-TOT TO WS06-CANCEL-TOT-AMT.            
T23875                                                                  
T23875     WRITE PRT7042-RECORD FROM WS06-CANCEL-GRAND-TOTAL            
T23875           AFTER ADVANCING 2 LINES.                               
T23875                                                                  
T23875     WRITE PRT7042-RECORD FROM WS06-CANCEL-GRAND-AMOUNT           
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875 2250-EXIT.                                                       
T23875     EXIT.                                                        
T20186                                                                  
T27145*****************************************************************         
T27145*  2251-WRITE-SEBR-CANGRND-TOTAL                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2251-WRITE-SEBR-CANGRND-TOTAL.                                   
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT5-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT5-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     MOVE WS05-REPORT5-PAGE-NBR TO WS02-TITLE2C-PAGE-NBR          
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS02-TITLE2B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS02-TITLE2C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-CAN-CNT-TOT TO WS06-CANCEL-TOT-CNT.       
T27145     MOVE WS05-SEBR-DET-CAN-AMT-TOT TO WS06-CANCEL-TOT-AMT.       
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS06-CANCEL-GRAND-TOTAL            
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7045-RECORD FROM WS06-CANCEL-GRAND-AMOUNT           
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145 2251-EXIT.                                                       
T27145     EXIT.                                                        
T20186                                                                  
T20186*****************************************************************         
T20186*  2300-WRITE-ESCHEA-PAGE-TOTALS                                *         
T20186*                                                               *         
T20186*****************************************************************         
T20186 2300-WRITE-ESCHEA-PAGE-TOTALS.                                   
T20186                                                                  
T20186     MOVE WS05-DET-ESC-CNT TO WS06-ESCHEA-PAGE-CNT.               
T20186     MOVE WS05-DET-ESC-AMT TO WS06-ESCHEA-PAGE-AMT.               
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS06-ESCHEA-LINE-TOTAL             
T20186           AFTER ADVANCING 2 LINES.                               
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS06-ESCHEA-LINE-AMOUNT            
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     MOVE ZEROES TO WS05-DET-ESC-CNT                              
T20186                    WS05-DET-ESC-AMT.                             
T20186                                                                  
T20186     ADD 3 TO WS05-REPORT3-LINE-CTR.                              
T20186                                                                  
T20186 2300-EXIT.                                                       
T20186     EXIT.                                                        
                                                                        
T27145*****************************************************************         
T27145*  2301-WRITE-SEBR-ESCPAGE-TOTALS                               *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2301-WRITE-SEBR-ESCPAGE-TOTALS.                                  
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-ESC-CNT TO WS06-ESCHEA-PAGE-CNT.          
T27145     MOVE WS05-SEBR-DET-ESC-AMT TO WS06-ESCHEA-PAGE-AMT.          
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS06-ESCHEA-LINE-TOTAL             
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS06-ESCHEA-LINE-AMOUNT            
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE ZEROES                TO WS05-SEBR-DET-ESC-CNT          
T27145                                   WS05-SEBR-DET-ESC-AMT.         
T27145                                                                  
T27145     ADD 3                      TO WS05-REPORT6-LINE-CTR.         
T27145                                                                  
T27145 2301-EXIT.                                                       
T27145     EXIT.                                                        
                                                                        
T23875*****************************************************************         
T23875*  2350-WRITE-ESCHEA-GRAND-TOTAL                                *         
T23875*                                                               *         
T23875*****************************************************************         
T23875 2350-WRITE-ESCHEA-GRAND-TOTAL.                                   
T23875                                                                  
T23875     ADD 1 TO WS05-REPORT3-PAGE-NBR.                              
T23875                                                                  
T23875     MOVE C01-REPORT3-NAME TO WS01-TITLE1A-REPTNAME.              
T23875                                                                  
T23875     MOVE WS05-REPORT3-PAGE-NBR TO WS02-TITLE3C-PAGE-NBR          
T23875     WRITE PRT7043-RECORD FROM WS01-TITLE1A                       
T23875           AFTER ADVANCING PAGE.                                  
T23875                                                                  
T23875     WRITE PRT7043-RECORD FROM WS02-TITLE3B                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7043-RECORD FROM WS02-TITLE3C                       
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     WRITE PRT7043-RECORD FROM WS03-BLANK-LINE                    
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875     MOVE WS05-DET-ESC-CNT-TOT TO WS06-ESCHEA-TOT-CNT.            
T23875     MOVE WS05-DET-ESC-AMT-TOT TO WS06-ESCHEA-TOT-AMT.            
T23875                                                                  
T23875     WRITE PRT7043-RECORD FROM WS06-ESCHEA-GRAND-TOTAL            
T23875           AFTER ADVANCING 2 LINES.                               
T23875                                                                  
T23875     WRITE PRT7043-RECORD FROM WS06-ESCHEA-GRAND-AMOUNT           
T23875           AFTER ADVANCING 1 LINE.                                
T23875                                                                  
T23875 2350-EXIT.                                                       
T23875     EXIT.                                                        
T23875                                                                  
T27145*****************************************************************         
T27145*  2351-WRITE-SEBR-ESCGRND-TOTAL                                *         
T27145*                                                               *         
T27145*****************************************************************         
T27145 2351-WRITE-SEBR-ESCGRND-TOTAL.                                   
T27145                                                                  
T27145     ADD 1                      TO WS05-REPORT6-PAGE-NBR.         
T27145                                                                  
T27145     MOVE C01-REPORT6-NAME      TO WS01-TITLE1A-REPTNAME.         
T27145                                                                  
T27145     MOVE WS05-REPORT6-PAGE-NBR TO WS02-TITLE3C-PAGE-NBR          
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS01-TITLE1A                       
T27145           AFTER ADVANCING PAGE.                                  
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS02-TITLE3B                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS02-TITLE3C                       
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS03-BLANK-LINE                    
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145     MOVE WS05-SEBR-DET-ESC-CNT-TOT TO WS06-ESCHEA-TOT-CNT.       
T27145     MOVE WS05-SEBR-DET-ESC-AMT-TOT TO WS06-ESCHEA-TOT-AMT.       
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS06-ESCHEA-GRAND-TOTAL            
T27145           AFTER ADVANCING 2 LINES.                               
T27145                                                                  
T27145     WRITE PRT7046-RECORD FROM WS06-ESCHEA-GRAND-AMOUNT           
T27145           AFTER ADVANCING 1 LINE.                                
T27145                                                                  
T27145 2351-EXIT.                                                       
T27145     EXIT.                                                        
T27145                                                                  
      *****************************************************************         
      *  3000-WRITE-GRAND-TOTALS                                      *         
      *                                                               *         
      *****************************************************************         
       3000-WRITE-GRAND-TOTALS.                                         
                                                                        
           PERFORM 2100-WRITE-CLEAR-PAGE-TOTALS THRU 2100-EXIT.         
           PERFORM 2200-WRITE-CANCEL-PAGE-TOTALS THRU 2200-EXIT.        
T20186     PERFORM 2300-WRITE-ESCHEA-PAGE-TOTALS THRU 2300-EXIT.        
                                                                        
           PERFORM 3100-WRITE-GRAND-TITLES.                             
                                                                        
           MOVE WS05-DET-CLR-CNT-TOT TO WS06-CLEAR-TOT-CNT.             
           MOVE WS05-DET-CLR-AMT-TOT TO WS06-CLEAR-TOT-AMT.             
           MOVE WS05-DET-CAN-CNT-TOT TO WS06-CANCEL-TOT-CNT.            
           MOVE WS05-DET-CAN-AMT-TOT TO WS06-CANCEL-TOT-AMT.            
T20186     MOVE WS05-DET-ESC-CNT-TOT TO WS06-ESCHEA-TOT-CNT.            
T20186     MOVE WS05-DET-ESC-AMT-TOT TO WS06-ESCHEA-TOT-AMT.            
                                                                        
           WRITE PRT7041-RECORD FROM WS06-CLEAR-GRAND-TOTAL             
                 AFTER ADVANCING 2 LINES.                               
                                                                        
           WRITE PRT7041-RECORD FROM WS06-CLEAR-GRAND-AMOUNT            
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS06-CANCEL-GRAND-TOTAL            
                 AFTER ADVANCING 2 LINES.                               
                                                                        
           WRITE PRT7042-RECORD FROM WS06-CANCEL-GRAND-AMOUNT           
                 AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS06-ESCHEA-GRAND-TOTAL            
T20186           AFTER ADVANCING 2 LINES.                               
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS06-ESCHEA-GRAND-AMOUNT           
T20186           AFTER ADVANCING 1 LINE.                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  3100-WRITE-GRAND-TITLES                                      *         
      *                                                               *         
      *****************************************************************         
       3100-WRITE-GRAND-TITLES.                                         
                                                                        
           ADD 1 TO WS05-REPORT1-PAGE-NBR.                              
                                                                        
           MOVE C01-REPORT1-NAME TO WS01-TITLE1A-REPTNAME.              
                                                                        
           MOVE WS05-REPORT1-PAGE-NBR TO WS01-TITLE1C-PAGE-NBR.         
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1A                       
                 AFTER ADVANCING PAGE.                                  
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1B                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS01-TITLE1C                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7041-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           ADD 1 TO WS05-REPORT2-PAGE-NBR.                              
                                                                        
           MOVE C01-REPORT2-NAME TO WS01-TITLE1A-REPTNAME.              
                                                                        
           MOVE WS05-REPORT2-PAGE-NBR TO WS02-TITLE2C-PAGE-NBR          
           WRITE PRT7042-RECORD FROM WS01-TITLE1A                       
                 AFTER ADVANCING PAGE.                                  
                                                                        
           WRITE PRT7042-RECORD FROM WS02-TITLE2B                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS02-TITLE2C                       
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT7042-RECORD FROM WS03-BLANK-LINE                    
                 AFTER ADVANCING 1 LINE.                                
                                                                        
T20186     ADD 1 TO WS05-REPORT3-PAGE-NBR.                              
T20186                                                                  
T20186     MOVE C01-REPORT3-NAME TO WS01-TITLE1A-REPTNAME.              
T20186                                                                  
T20186     MOVE WS05-REPORT3-PAGE-NBR TO WS02-TITLE3C-PAGE-NBR          
T20186     WRITE PRT7043-RECORD FROM WS01-TITLE1A                       
T20186           AFTER ADVANCING PAGE.                                  
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS02-TITLE3B                       
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS02-TITLE3C                       
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
T20186     WRITE PRT7043-RECORD FROM WS03-BLANK-LINE                    
T20186           AFTER ADVANCING 1 LINE.                                
T20186                                                                  
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 4000 - 4095                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00074, WHICH RETRIEVES NAMES AND          *         
      *         ADDRESSES                                             *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00074                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 6010 - 6011                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00004, WHICH REDUCES EMBEDDED SPACES      *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00004                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 6200 - 6340                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00114, WHICH RETRIEVES THE REPORT DATES   *         
      *                                                               *         
      *****************************************************************         
C23521*    EXEC SQL                                                             
C23521*      INCLUDE CPD00114                                                   
C23521*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  6251-GET-FJC01-DATE                                          *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00037, WHICH CONTAINS THE DB2 STATEMENTS  *         
      *         NECESSARY TO RETRIEVE PARMS FROM TABLE CSS_JOB_PARM   *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  PARAGRAPHS 7600 - 7611                                       *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD00038, WHICH DECLARES, OPENS, FETCHES     *         
      *         AND CLOSES CURSOR TO CSS_JOB_PARM                     *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  9000-TERMINATE                                               *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) CLOSES THE INPUT AND OUTPUT FILES                     *         
      *                                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCPT7041-FILE.                                         
                                                                        
           CLOSE FCPT7042-FILE.                                         
T20186                                                                  
T20186     CLOSE FCPT7043-FILE.                                         
                                                                        
T27145     IF SEB-DATABASE                                              
T27145        CLOSE FCPT7044-FILE                                       
T27145                                                                  
T27145        CLOSE FCPT7045-FILE                                       
T27145                                                                  
T27145        CLOSE FCPT7046-FILE                                       
T27145     END-IF.                                                      
T27145                                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  9700-PROCESS-ABEND                                           *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) PROVIDES ABEND LOGIC FOR NAME/ADDRESS ROUTINE         *         
      *                                                               *         
      *****************************************************************         
       COPY CPD0023B.                                                           
                                                                        
      *****************************************************************         
      *  9900-ABEND                                                   *         
      *                                                               *         
      *    THIS PARAGRAPH:                                            *         
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          *         
      *         PROCESSING PARAGRAPH                                  *         
      *                                                               *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
                                                                        
