       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA699                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **              P R O G R A M S U M M A R Y                    **         
      **                                                             **         
      **                                                             **         
      **         F U N C T I O N A L   D E S C R I P T I O N         **         
      **                         O F   M O D U L E                   **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  REPORTS THE ACCOUNTS IN CSS_REFUND TABLE IF THE ACCT       **         
      **  HAS ONLY DEPOSIT MONEY AS REFUND AND CHECK STATUS IS I,U,M **         
      **  ACCOUNTS WHERE MONEY OTHER THAN DEPOSIT IS SITTING, IT WILL**         
      **  REPORTED AS COMBO                                          **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  USF ESCHEATMENT IS FOR CHECKS THAT ARE FROM DEPOSIT        **         
      **  PORTION OF REFUND, IF THE CHECK WAS NEVER CASHED OUT(I,U,M)**         
      **  IT WILL BE ESCHEATED TO USF OR STATE BASED ON THE SOURCE   **         
      **  OF THE MONEY.                                              **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **             PROGRAM  MODIFICATION  LOG                      **         
      **                                                             **         
      **   DATE        INITIALS     REASON                           **         
      **   ----        --------     ------                           **         
      **   DATE        INITIALS     REASON                           **         
      **   ----        --------     ------                           **         
      **   11/21/06     JS83520     INITIAL VERSION                  **         
      **   05/31/07     PC97415     FLAG WS_NAME_ONLY_SW IS SET FOR  **         
      **                            CPD00074, REPLACED MODEL_SQL WITH**         
      **                            SET COMMAND,ADDED WITH UR FOR-911**         
      **   06/04/07     DM94438     PUT THE INTEREST PORTION OF THE  **         
      **                            DEPOSIT MONEY REFUNDED IN THE RPT**         
      **   11/18/08     DM94438     REWRITE PROGRAM DRIVER CURSOR TO **         
      **                            USE CSS_REFUND TABLE INSTEAD OF  **         
      **                            CSS_AR_TRN TABLE                 **         
C37112**   01/14/09     RC41079     ADDED CODE TO PULL ONLY RESIDENT-**         
C37112**                            IAL CUSTOMER TO WHERE CLAUSE OF  **         
C37112**                            UNCLMD_DEP CURSOR.               **         
      ****************************************************************          
      *                                                                         
      *             ---- BASIC SEQUENCE STRUCTURE ----                          
      *         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION            
      *         1000 - 1999     INPUT PROCESSING CONTROL PATH                   
      *         2000 - 2999     OUTPUT PROCESSING CONTROL PATH                  
      *         3000 - 4999     BATCH PROCESSING MODULES - NOT USED             
      *         5000 - 5999     COMMON PROGRAM MODULES                          
      *         6000 - 6999     COMMON SYSTEM MODULES                           
      *         7000 - 7999     INPUT MODULES                                   
      *         8000 - 8999     OUTPUT MODULES                                  
      *         9000 - 9799     TERMINATION MODULES                             
      *         9800 - 9899     XCTLS TO PROGRAMS                               
      *         9900 - 9999     ABEND/ABORT MODULES                             
      *    EJECT                                                                
      *    ---- ------------------------- ------------------------------        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
            SELECT FCSR6991-FILE  ASSIGN UT-S-FCSR6991.                 
            SELECT FCSR6992-FILE  ASSIGN UT-S-FCSR6992.                 
                                                                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSR6991-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01 PRT33-RECORD.                                                
            05 PRT33-DATA             PIC X(132).                       
       FD  FCSR6992-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01 PRT33A-RECORD.                                               
            05 PRT33-DATA             PIC X(132).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA699'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA699 STARTS HERE'.            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *  WORKING STORAGE FOR REPORT HEADER.                                     
      *                                                                         
       COPY CWS00079.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      ** INCLUDE CWS00061 FOR GL NEUMONICS                                      
       COPY CWS00061.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
      * FOR NAME AND ADDRESS                                                    
       COPY CWS00074.                                                           
      *                                                                         
      * FOR DB2 ABEND VARIABLES                                                 
       COPY CWS00010.                                                           
      *                                                                         
      * FOR REDUCING EMBEDDED SPACES                                            
       COPY CWS00011.                                                           
      *                                                                         
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
                                                                        
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
        COPY CJF00101.                                                          
      *                                                                         
       01 WS-YEAR-WORK PIC S9(3)   COMP-3      VALUE +0.                
       01 WS-LEAP-YEAR PIC S9(3)   COMP-3      VALUE +0.                
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-STAT-UPT-DT.                                              
           05  WS-UPT-CC               PIC X(02).                       
           05  WS-UPT-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-UPT-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-UPT-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-JOB-PARM-DATA.                                            
           05  WS-BEGIN-DATE-MSG       PIC X(13).                       
           05  WS-BEGIN-DATE           PIC X(10).                       
           05  WS-BEGIN-DATE-R REDEFINES WS-BEGIN-DATE.                 
               10  WS-BEGIN-DATE-YR-R  PIC 9(4).                        
               10  FILLER              PIC X(1).                        
               10  WS-BEGIN-DATE-MM-R  PIC 9(2).                        
               10  FILLER              PIC X(1).                        
               10  WS-BEGIN-DATE-DD-R  PIC 9(2).                        
           05  FILLER                  PIC X(03).                       
           05  WS-END-DATE-MSSG        PIC X(11).                       
           05  WS-END-DATE             PIC X(10).                       
           05  WS-END-DATE-R REDEFINES WS-END-DATE.                     
               10  WS-END-DATE-YR-R    PIC 9(4).                        
               10  FILLER              PIC X(1).                        
               10  WS-END-DATE-MM-R    PIC 9(2).                        
               10  FILLER              PIC X(1).                        
               10  WS-END-DATE-DD-R    PIC 9(2).                        
           05  FILLER                  PIC X(03).                       
           05  WS-ESC-REPT-MSSG        PIC X(04).                       
           05  WS-ESC-REPT-FLAG        PIC X(01).                       
           05  WS-REG-ACCT             PIC X(01)  VALUE 'Y'.            
           05  WS-REG-ESC-CODE         PIC X(01)  VALUE 'N'.            
           05  WS-DREG-ESC-CODE        PIC X(01)  VALUE 'N'.            
           05  FILLER                  PIC X(03).                       
           05  WS-ESC-DATE-MSSG        PIC X(11).                       
           05  WS-ESC-DATE             PIC X(10).                       
           05  WS-ESC-DATE-R REDEFINES WS-ESC-DATE.                     
               10  WS-ESC-DATE-YR-R    PIC 9(4).                        
               10  FILLER              PIC X(1).                        
               10  WS-ESC-DATE-MM-R    PIC 9(2).                        
               10  FILLER              PIC X(1).                        
               10  WS-ESC-DATE-DD-R    PIC 9(2).                        
      *                                                                 01362500
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA699'.   
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA699'.   
           05  WS-Y                    PIC X(08)    VALUE 'Y'.          
           05  WS-N                    PIC X(08)    VALUE 'N'.          
      *                                                                         
       01 WS-SWITCHES.                                                  
           05  WS-DATA-FOUND-FL        PIC X(01)    VALUE SPACES.       
               88 WS-DATA-FOUND                     VALUE 'Y'.          
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT1-PAGE-NO             PIC 9(04)    VALUE 0.            
       01  WS-RPT1S-LINE-NO            PIC 9(02)    VALUE 0.            
       01  WS-RPT1S-PAGE-NO            PIC 9(04)    VALUE 0.            
       01  WS-RPT2-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT2-PAGE-NO             PIC 9(04)    VALUE 0.            
       01  WS-RPT3-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT3-PAGE-NO             PIC 9(04)    VALUE 0.            
       01  WS-RPT4-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT4-PAGE-NO             PIC 9(04)    VALUE 0.            
       01  WS-ESCHEATMENT-CD           PIC X(05)    VALUE SPACES.       
       01  WS-DREG-CNT                 PIC S9(5)    VALUE 0.            
       01  WS-REG-CNT                  PIC S9(5)    VALUE 0.            
      *                                                                         
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADERS        **          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
           05  WS-RPT-TITLE-1.                                          
               10  P-RPT-PGRMNAME-1    PIC X(10).                       
               10  FILLER              PIC X(44)    VALUE SPACES.       
               10  P-RPT-CO-NAME-1     PIC X(26).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                      'RUN DATE: '.                     
               10  P-RPT-RUN-DATE-1    PIC X(08).                       
      *                                                                         
           05  WS-RPT-TITLE-2.                                          
               10  FILLER              PIC X(06)    VALUE               
                                      'DATE: '.                         
               10  P-RPT-TRAN-DATE     PIC X(08).                       
               10  FILLER              PIC X(24)    VALUE SPACES.       
               10  P-RPT-REP-TITLE     PIC X(43).                       
      *        'UNCLAIMED CUSTOMER DEPOSITS FOR ESCHEATMENT'.           01760000
               10  FILLER              PIC X(32)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                      'RUN TIME:  '.                    
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
           05  WS-RPT-TITLE-3.                                          
               10  FILLER              PIC X(45)    VALUE SPACES.       
               10  FILLER              PIC X(16)    VALUE               
                           ' EFFECTIVE UPTO '.                          
      *        10  BEG-DATE-MM         PIC X(02)    VALUE SPACES.         033200
      *        10  FILLER              PIC X(01)    VALUE '/'.            033200
      *        10  BEG-DATE-DD         PIC X(02)    VALUE SPACES.         033200
      *        10  FILLER              PIC X(01)    VALUE '/'.            033300
      *        10  BEG-DATE-YYYY       PIC X(04)    VALUE SPACES.         033100
               10  FILLER              PIC X(04)    VALUE '    '.       
               10  END-DATE-MM         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  END-DATE-DD         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  END-DATE-YYYY       PIC X(04)    VALUE SPACES.       
               10  FILLER              PIC X(32)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE               
                                      'PAGE:'.                          
               10  P-RPT-PAGE-NO       PIC ZZ,ZZZ.                      
               10  FILLER              PIC X(07)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT-TITLE-4.                                          
               10  FILLER              PIC X(44)    VALUE SPACES.       
               10  FILLER              PIC X(44)    VALUE               
               '    SEB - REGULATED CUSTOMERS               '.          
               10  FILLER              PIC X(44)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT-TITLE-5.                                          
               10  FILLER              PIC X(44)    VALUE SPACES.       
               10  FILLER              PIC X(44)    VALUE               
               '    SEB - DEREGULATED CUSTOMERS             '.          
               10  FILLER              PIC X(44)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-11.                                         
           05  FILLER                  PIC X(11)    VALUE               
                                       'ACCT NUMBER'.                   
      *    05  FILLER                  PIC X(10)    VALUE SPACES.               
           05  FILLER                  PIC X(02)    VALUE SPACES.       
           05  FILLER                  PIC X(07)    VALUE 'ESC CD '.    
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(04)    VALUE               
                                       'NAME'.                          
           05  FILLER                  PIC X(16)    VALUE SPACES.       
           05  FILLER                  PIC X(11)    VALUE               
                                       'AMT DEPOSIT'.                   
           05  FILLER                  PIC X(09)    VALUE SPACES.       
           05  FILLER                  PIC X(11)    VALUE               
                                       'AMT REFUND '.                   
           05  FILLER                  PIC X(09)    VALUE SPACES.       
           05  FILLER                  PIC X(11)    VALUE               
                                       'INTRST AMT '.                   
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(12)    VALUE               
                                       'CHECK STATUS'.                  
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(11)    VALUE               
                                       'REFUND DATE'.                   
           05  FILLER                  PIC X(08)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-12.                                         
           05  FILLER                  PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-DET-11.                                         
           05  P-RPT1-ACCT-NUMB        PIC 9(13)    VALUE ZEROES.       
      *    05  FILLER                  PIC X(03)    VALUE SPACES.               
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  P-RPT1-ESC-CODE         PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(02)    VALUE SPACES.       
           05  P-RPT1-CUST-NAME        PIC X(16)    VALUE SPACES.       
           05  FILLER                  PIC X(03)    VALUE SPACES.       
           05  P-RPT1-AMT-DEPOSIT      PIC ZZZ,ZZZ,ZZ9.99 VALUE ZEROES. 
           05  FILLER                  PIC X(04)    VALUE SPACES.       
           05  P-RPT1-AMT-REFUND       PIC ZZZ,ZZZ,ZZ9.99 VALUE ZEROES. 
      *    05  FILLER                  PIC X(15)    VALUE SPACES.               
           05  FILLER                  PIC X(04)    VALUE SPACES.       
           05  P-RPT1-AMT-INT          PIC ZZZ,ZZZ,ZZ9.99 VALUE ZEROES. 
           05  FILLER                  PIC X(11)    VALUE SPACES.       
           05  P-RPT1-CHECK-STATUS     PIC X(14)    VALUE SPACES.       
           05  FILLER                  PIC X(04)    VALUE SPACES.       
           05  P-RPT1-ISS-DATE         PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)   VALUE SPACES.        
           05  FILLER                  PIC X(22)   VALUE                
                    '*** END OF REPORT ***'.                            
           05  FILLER                  PIC X(55)   VALUE SPACES.        
      *                                                                         
       01  WS-SPACE-LINE.                                               
           05  FILLER                  PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-PRT-GRAND-TOTALS.                                         
           05  FILLER                  PIC X(07)   VALUE                
                    'TOTALS '.                                          
           05  FILLER                  PIC X(14)   VALUE SPACES.        
           05  WS-PRT-GRAND-NUMBER     PIC ZZ,ZZZ.                      
           05  FILLER                  PIC X(16)   VALUE SPACES.        
           05  WS-PRT-DEPOSIT-TOTALS   PIC $$,$$$,$$9.99.               
           05  FILLER                  PIC X(06)   VALUE SPACES.        
           05  WS-PRT-REFUND-TOTALS    PIC $$,$$$,$$9.99.               
           05  FILLER                  PIC X(02)   VALUE SPACES.        
           05  WS-PRT-INTRST-TOTALS    PIC $$,$$$,$$9.99.               
           05  FILLER                  PIC X(53)   VALUE SPACES.        
      *                                                                         
       01  WS-PRT-SUB-TOTALS.                                           
           05  FILLER                  PIC X(10)   VALUE                
                    'SUB TOTALS'.                                       
           05  FILLER                  PIC X(11)   VALUE SPACES.        
           05  WS-PRT-SUB-NUMBER     PIC ZZ,ZZZ.                        
           05  FILLER                  PIC X(16)   VALUE SPACES.        
           05  WS-PRT-SUB-DEPOSIT-TOTALS   PIC $$,$$$,$$9.99.           
           05  FILLER                  PIC X(06)   VALUE SPACES.        
           05  WS-PRT-SUB-REFUND-TOTALS    PIC $$,$$$,$$9.99.           
           05  FILLER                  PIC X(02)   VALUE SPACES.        
           05  WS-PRT-SUB-INTRST-TOTALS    PIC $$,$$$,$$9.99.           
           05  FILLER                  PIC X(53)   VALUE SPACES.        
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE          PIC S9(04)  COMP.                
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-NO-OF-LINES          PIC S9(04)  COMP-3 VALUE ZERO.   
           05  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.        
           05  WS-DATE-TRANS           PIC X(10)   VALUE SPACES.        
COB305     05 WS-AMT-DEPOSIT        PIC S9(9)V9(2) COMP-3 VALUE 0.           
COB305     05 WS-INTEREST-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.           
           05  WS-DATE-DEPOSIT         PIC X(10).                       
           05  WS-TRANSFER-MSG.                                         
               10  FILLER              PIC X(23)   VALUE                
                          'ESCHEATED CHECK NUMBER '.                    
               10  WS-CHK-NUM          PIC 9(09).                       
           05  WS-PREV-COMP-NO         PIC X(02)   VALUE SPACES.        
           05  WS-COMP-NO-CHNG         PIC X(01)   VALUE 'N'.           
           05  WS-PREV-ESC-CODE-REG    PIC X(01)   VALUE SPACES.        
           05  WS-PREV-ESC-CODE-DREG   PIC X(01)   VALUE SPACES.        
           05  WS-TOT-SREFUND-AMT-REG   PIC 9(10)V99 VALUE ZEROES.      
           05  WS-TOT-SDEPOSIT-AMT-REG  PIC 9(10)V99 VALUE ZEROES.      
           05  WS-TOT-SINTRST-AMT-REG   PIC 9(10)V99 VALUE ZEROES.      
           05  WS-TOT-SREF-ACCT-REG     PIC 9(05)    VALUE ZEROES.      
           05  WS-TOT-SREFUND-AMT-DREG   PIC 9(10)V99 VALUE ZEROES.     
           05  WS-TOT-SDEPOSIT-AMT-DREG  PIC 9(10)V99 VALUE ZEROES.     
           05  WS-TOT-SINTRST-AMT-DREG   PIC 9(10)V99 VALUE ZEROES.     
           05  WS-TOT-SREF-ACCT-DREG     PIC 9(05)    VALUE ZEROES.     
           05  WS-TOT-REFUND-AMT-REG   PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-DEPOSIT-AMT-REG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-INTRST-AMT-REG   PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-REF-ACCT-REG     PIC 9(05)    VALUE ZEROES.       
           05  WS-TOT-REFUND-AMT-REGS  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-DEPOSIT-AMT-REGS PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-INTRST-AMT-REGS  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-REF-ACCT-REGS    PIC 9(05)    VALUE ZEROES.       
           05  WS-TOT-REFUND-AMT-DREG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-INTRST-AMT-DREG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-DEPOSIT-AMT-DREG PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-REF-ACCT-DEREG   PIC 9(05)    VALUE ZEROES.       
           05  WS-TOT-ESC-REF-AMT-REG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-DEP-AMT-REG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-INT-AMT-REG  PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-ACCT-REG     PIC 9(05)    VALUE ZEROES.       
           05  WS-TOT-ESC-REF-AMT-DREG PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-DEP-AMT-DREG PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-INT-AMT-DREG PIC 9(10)V99 VALUE ZEROES.       
           05  WS-TOT-ESC-ACCT-DEREG   PIC 9(05)    VALUE ZEROES.       
           05  WS-INDICATOR            PIC S9(9)   COMP SYNC VALUE +0.  
           05  WS-SYSIN-COMP-NO        PIC X(02)   VALUE '01'.          
           05  WS-PARM-YEAR            PIC 9(02).                       
           05  WS-DATE-T1.                                              
               10  WS-DATE-T1-YYYY     PIC X(04)   VALUE SPACES.        
               10  FILLER              PIC X(01)   VALUE '/'.           
               10  WS-DATE-T1-MM       PIC X(02)   VALUE SPACES.        
               10  FILLER              PIC X(01)   VALUE '/'.           
               10  WS-DATE-T1-DD       PIC X(02)   VALUE SPACES.        
           05  WS-DATE-T2.                                              
               10  WS-DATE-T2-MM       PIC X(02)   VALUE SPACES.        
               10  FILLER              PIC X(01)   VALUE '/'.           
               10  WS-DATE-T2-DD       PIC X(02)   VALUE SPACES.        
               10  FILLER              PIC X(01)   VALUE '/'.           
               10  WS-DATE-T2-YYYY     PIC X(04)   VALUE SPACES.        
           05  WS-END-OF-ROWS          PIC X(01)   VALUE 'N'.           
               88  NOT-END-OF-ROWS                 VALUE 'N'.           
               88  END-OF-ROWS                     VALUE 'Y'.           
           05  WS-FIRST-TIME           PIC X(01)   VALUE 'Y'.           
           05  WS-MIDDLE-NAME-ALL      PIC X(15).                       
           05  WS-MIDDLE-INIT REDEFINES WS-MIDDLE-NAME-ALL              
                                       PIC X(1).                        
           05  WS-AMT-REFUNDED         PIC ZZZZZZZZ.ZZ.                 
           05  WS-NULL-REQUEST-DT      PIC S9(04)  USAGE COMP.          
           05  WS-NULL-IND             PIC S9(04)  USAGE COMP.          
           05  WS-NULL-DATE-ESCHEATED  PIC S9(04)  USAGE COMP.          
           05  WS-NULL-INT-AMT         PIC S9(04)  USAGE COMP.          
           05  WS-NULL-DEP-AMT         PIC S9(04)  USAGE COMP.          
           05  WS-REQUEST-DT           PIC X(10).                       
           05  WS-REQUEST-DT-R REDEFINES WS-REQUEST-DT.                 
               10  WS-REQUEST-CC       PIC X(02).                       
               10  WS-REQUEST-YY       PIC X(02).                       
               10  WS-REQUEST-SL1      PIC X(01).                       
               10  WS-REQUEST-MM       PIC X(02).                       
               10  WS-REQUEST-SL2      PIC X(01).                       
               10  WS-REQUEST-DD       PIC X(02).                       
      *                                                                         
         COPY CWS09900.                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCOUNT *****************               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_LOCAL_OFFICE****************            
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_BILL_NMES  **************          
      ******* TABLE DECLARATION FOR CSS_ACCT_MISC_INFO  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ADDR_FORMATTED ***************          
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_AR_TRANS_HIST ***********               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_AR_TRN_HST_DET **********               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_BUS_CUST_STATS  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBSCSTS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_COMPANY  ****************               
                                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_CUST_ADD_XREF ******************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FRO CSS_GL_ACCT_NO *******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_JOB_PARM    ******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_NAME *************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_NAME_ACCT_XREF *****************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_REFUND      ******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_INT_HIST    ******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ZIP_CODE   *****************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR BATCH-JRNL-ROUTINE  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_LOCKOUT                                                       
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARLOCK                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      ***                                                                       
      ***  CURSOR FOR SEB REGULATED CUSTOMERS - UNCLAIMED DEPOSITS              
      ***                                                                       
           EXEC SQL                                                     
               DECLARE UNCLMD_DEP CURSOR FOR                            
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.ADDRESS_ID                                     
                     ,AT.COMPANY_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.TOTAL_AR_BALANCE                               
                     ,RN.MANUAL_INDICATOR                               
                     ,RN.REFUND_CHECK_NO                                
                     ,RN.AMT_REFUNDED                                   
                     ,RN.CHECK_ISS_REAS_CD                              
                     ,RN.DATE_REFUNDED                                  
                     ,RN.REFUND_ITEM_ID                                 
                     ,RN.CHECK_STATUS_CD                                
                     ,RN.DATE_ESCHEATED                                 
                     ,AT.PREMISE_NO                                     
                     ,RN.REQUEST_DT                                     
                     ,RN.ESCHEATMENT_CD                                 
                     ,B1.REGULATED_CD                                   
           FROM                                                         
                 CSS_REFUND        RN WITH(READUNCOMMITTED)                     
                ,CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                     
                ,CSS_LOCAL_OFFICE  B1 WITH(READUNCOMMITTED)                     
           WHERE                                                        
                 RN.ACCOUNT_NO = AT.ACCOUNT_NO                          
             AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                      
C37112       AND AT.ACCOUNT_TYPE_CODE = 'R'                             
             AND RN.CHECK_STATUS_CD IN ('I','U','M')                    
             AND RN.ESCHEATMENT_CD IN ('U','S')                         
             AND RN.DATE_REFUNDED >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )                     
             AND RN.DATE_REFUNDED <= IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                       
             AND AT.CODE_ACCT_STAT IN ('B','S')                         
           ORDER BY B1.REGULATED_CD,                                    
           RN.ESCHEATMENT_CD,RN.DATE_REFUNDED,RN.ACCOUNT_NO             
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UNCLMD_DEP CURSOR FOR                                    
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,RN.MANUAL_INDICATOR                                       
MFA-TR*              ,RN.REFUND_CHECK_NO                                        
MFA-TR*              ,RN.AMT_REFUNDED                                           
MFA-TR*              ,RN.CHECK_ISS_REAS_CD                                      
MFA-TR*              ,RN.DATE_REFUNDED                                          
MFA-TR*              ,RN.REFUND_ITEM_ID                                         
MFA-TR*              ,RN.CHECK_STATUS_CD                                        
MFA-TR*              ,RN.DATE_ESCHEATED                                         
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,RN.REQUEST_DT                                             
MFA-TR*              ,RN.ESCHEATMENT_CD                                         
MFA-TR*              ,B1.REGULATED_CD                                           
MFA-TR*    FROM                                                                 
MFA-TR*          CSS_REFUND        RN                                           
MFA-TR*         ,CSS_ACCOUNT       AT                                           
MFA-TR*         ,CSS_LOCAL_OFFICE  B1                                           
MFA-TR*    WHERE                                                                
MFA-TR*          RN.ACCOUNT_NO = AT.ACCOUNT_NO                                  
MFA-TR*      AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                              
MFA-TR*      AND AT.ACCOUNT_TYPE_CODE = 'R'                                     
MFA-TR*      AND RN.CHECK_STATUS_CD IN ('I','U','M')                            
MFA-TR*      AND RN.ESCHEATMENT_CD IN ('U','S')                                 
MFA-TR*      AND RN.DATE_REFUNDED >= :WS-BEGIN-DATE                             
MFA-TR*      AND RN.DATE_REFUNDED <= :WS-END-DATE                               
MFA-TR*      AND AT.CODE_ACCT_STAT IN ('B','S')                                 
MFA-TR*    ORDER BY B1.REGULATED_CD,                                            
MFA-TR*    RN.ESCHEATMENT_CD,RN.DATE_REFUNDED,RN.ACCOUNT_NO                     
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
      ***                                                                       
      *                                                                         
       01  WS-END                       PIC X(40)                       
               VALUE ' WORKING STORAGE FOR PCSCA699 ENDS HERE '.        
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           MOVE 'UNCLAIMED CUSTOMER DEPOSITS FOR ESCHEATMENT'           
                                              TO P-RPT-REP-TITLE        
      *                                                                         
      *  GENERATE REPORT FOR SEB CUSTOMERS TO REPORT                            
      *  UNCLAIMED DEPOSITS                                                     
      *                                                                         
           PERFORM 7005-OPEN-REG-CURSOR       THRU 7005-EXIT            
           PERFORM 7010-FETCH-REG-CURSOR      THRU 7010-EXIT            
                                                                        
           IF END-OF-ROWS                                               
              PERFORM 8300-NO-DATA-PARA       THRU 8300-EXIT            
           ELSE                                                         
             IF WS-REG-ACCT= 'N' AND WS-DREG-CNT = 1                    
              PERFORM 8050-PRINT-HDR-699-2    THRU 8050-EXIT            
             END-IF                                                     
           END-IF                                                       
                                                                        
           PERFORM UNTIL END-OF-ROWS                                    
              PERFORM 1000-CURSOR-PROCESS   THRU 1000-EXIT              
             IF WS-REG-ACCT ='Y'                                        
              MOVE RN-ESCHEATMENT-CD TO WS-PREV-ESC-CODE-REG            
             ELSE                                                       
              MOVE RN-ESCHEATMENT-CD TO WS-PREV-ESC-CODE-DREG           
             END-IF                                                     
              PERFORM 7010-FETCH-REG-CURSOR   THRU 7010-EXIT            
             IF WS-REG-ACCT ='Y'                                        
              IF WS-REG-CNT = 1                                         
                PERFORM 8000-PRINT-HDR-699-1    THRU 8000-EXIT          
              END-IF                                                    
              IF RN-ESCHEATMENT-CD NOT EQUAL WS-PREV-ESC-CODE-REG       
                MOVE 'Y' TO WS-REG-ESC-CODE                             
              ELSE                                                      
                MOVE 'N' TO WS-REG-ESC-CODE                             
              END-IF                                                    
             END-IF                                                     
             IF WS-REG-ACCT ='N'                                        
              IF RN-ESCHEATMENT-CD NOT EQUAL WS-PREV-ESC-CODE-DREG      
                MOVE 'Y' TO WS-DREG-ESC-CODE                            
              ELSE                                                      
                MOVE 'N' TO WS-DREG-ESC-CODE                            
              END-IF                                                    
             END-IF                                                     
           END-PERFORM                                                  
                                                                        
           PERFORM 7015-CLOSE-REG-CURSOR      THRU 7015-EXIT            
      *                                                                         
           PERFORM 7590-UPDATE-JOB-PARM-TABLE THRU 7590-EXIT            
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   0100-INITIALIZATION                                          *        
      *        COMMON INITIALIZATION ROUTINE                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
           OPEN OUTPUT FCSR6991-FILE.                                   
      *                                                                         
           OPEN OUTPUT FCSR6992-FILE.                                   
      *                                                                         
                                                                        
      *  CHECK AR LOCKOUT                                                       
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA699 PROCESSING ERROR'                   
              DISPLAY '**  AR LOCKOUT IN EFFECT'                        
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES TO WS-INPUT-AREA                              
              MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN                    
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSCA699' TO WS-PGRMNAME                            
           END-IF.                                                      
      *                                                                         
           IF WS-INPUT-DATE EQUAL TO SPACES                             
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA699 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 0100-INITIALIZATION'              
              DISPLAY                                                   
              'COMMON DATE IS NOT AVAILABLE IN JOB PARM TABLE'          
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-DATE-10.                            
           MOVE WS-D10-YY TO WS-D8-YY.                                  
           MOVE WS-D10-MM TO WS-D8-MM.                                  
           MOVE WS-D10-DD TO WS-D8-DD.                                  
           MOVE WS-DATE-8 TO P-RPT-TRAN-DATE                            
                             P-RPT1-REPORT-DATE.                        
      *                                                                         
      *                                                                         
           PERFORM 0110-READ-CSS-JOB-PARM THRU 0110-EXIT.               
                                                                        
      *    MOVE WS-BEGIN-DATE-MM-R        TO BEG-DATE-MM                        
      *    MOVE WS-BEGIN-DATE-DD-R        TO BEG-DATE-DD                        
      *    MOVE WS-BEGIN-DATE-YR-R        TO BEG-DATE-YYYY                      
           MOVE WS-END-DATE-MM-R          TO END-DATE-MM                
           MOVE WS-END-DATE-DD-R          TO END-DATE-DD                
           MOVE WS-END-DATE-YR-R          TO END-DATE-YYYY              
                                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH TO WS-RT-HH.                                      
           MOVE WS-MM TO WS-RT-MM.                                      
           MOVE WS-SS TO WS-RT-SS.                                      
           MOVE WS-RUN-TIME TO P-RPT-RUN-TIME.                          
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY TO WS-RD-YY.                                      
           MOVE WS-CM TO WS-RD-MM.                                      
           MOVE WS-CD TO WS-RD-DD.                                      
           MOVE WS-RUN-DATE TO P-RPT-RUN-DATE-1.                        
      *                                                                         
           MOVE WS-CM TO WS-UPT-MM.                                     
           MOVE WS-CD TO WS-UPT-DD.                                     
           MOVE WS-D10-CC TO WS-UPT-CC.                                 
           MOVE WS-CY TO WS-UPT-YY.                                     
      *                                                                         
           INITIALIZE WS-100-RECORD-ID-DATA                             
                      WS-PRT-GRAND-TOTALS.                              
                                                                        
           MOVE '01'                     TO C7-COMPANY-NO               
           PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09480000
      ****************************************************************  09490000
      *                                                              *  09500000
      * 0110-READ-CSS-JOB-PARM.                                      *  09510000
      *     SELECTS JOB PARM INFORMATION.                            *  09520000
      *                                                              *  09540000
      ****************************************************************  09550000
      *                                                                 09560000
       0110-READ-CSS-JOB-PARM.                                          
      *                                                                 09560000
           EXEC SQL                                                     
               SELECT G6.PARM_DATA                                      
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   
                 AND G6.COMPANY_NO  = :WS-SYSIN-COMP-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02671000
MFA-TR*        SELECT G6.PARM_DATA                                      02671200
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                   02671700
MFA-TR*         WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   02671800
MFA-TR*          AND G6.COMPANY_NO  = :WS-SYSIN-COMP-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    02673000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02674000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               MOVE G6-PARM-DATA      TO WS-JOB-PARM-DATA               
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA699 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 0110-READ-CSS-JOB-PARM'          
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 09700000
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-CURSOR-PROCESS                                            *        
      *                                                                *        
      ******************************************************************        
       1000-CURSOR-PROCESS.                                             
      *                                                                         
           SET WS-DATA-FOUND TO TRUE                                    
           MOVE 'Y'          TO WS-NAME-ONLY-SW.                        
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           PERFORM 3000-FORMAT-ESCHEATMENT THRU 3000-EXIT.              
           IF WS-REG-ACCT ='Y'                                          
             PERFORM 8900-WRITE-FCSR6991   THRU 8900-EXIT               
           END-IF                                                       
           IF WS-REG-ACCT = 'N'                                         
             PERFORM 8950-WRITE-FCSR6992   THRU 8950-EXIT               
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 3000-FORMAT-ESCHEATMENT.                                       *        
      *  FORMATS RECORDS FOR PRINTING REPORT 1.                        *        
      *                                                                *        
      ******************************************************************        
       3000-FORMAT-ESCHEATMENT.                                         
      *                                                                         
           MOVE AT-ACCOUNT-NO      TO P-RPT1-ACCT-NUMB                  
           MOVE RN-DATE-REFUNDED   TO WS-DATE-T1.                       
           MOVE WS-DATE-T1-MM      TO WS-DATE-T2-MM.                    
           MOVE WS-DATE-T1-DD      TO WS-DATE-T2-DD.                    
           MOVE WS-DATE-T1-YYYY    TO WS-DATE-T2-YYYY.                  
           MOVE WS-DATE-T2         TO P-RPT1-ISS-DATE.                  
           MOVE RN-AMT-REFUNDED    TO P-RPT1-AMT-REFUND.                
           MOVE WS-INTEREST-AMT    TO P-RPT1-AMT-INT.                   
           PERFORM 8550-MOVE-STATUS-CODE-DESCR THRU 8550-EXIT.          
           IF WS-ACCOUNT-NAME = SPACES                                  
              MOVE WS-CUSTOMER-NAME TO P-RPT1-CUST-NAME                 
           ELSE                                                         
              MOVE WS-ACCOUNT-NAME TO P-RPT1-CUST-NAME                  
           END-IF                                                       
           PERFORM 7800-GET-DEP-INT-AMT THRU 7800-EXIT                  
           MOVE WS-AMT-DEPOSIT          TO P-RPT1-AMT-DEPOSIT           
           MOVE SPACES  TO WS-ESCHEATMENT-CD                            
           IF RN-ESCHEATMENT-CD = 'S'                                   
              MOVE 'COMBO' TO WS-ESCHEATMENT-CD                         
           ELSE                                                         
             IF RN-ESCHEATMENT-CD = 'U'                                 
               MOVE 'USF' TO WS-ESCHEATMENT-CD                          
             END-IF                                                     
           END-IF                                                       
           MOVE WS-ESCHEATMENT-CD  TO P-RPT1-ESC-CODE                   
           .                                                            
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7005-OPEN-REG-CURSOR                                           *        
      *  OPENS THE CURSOR ESCHEATMENT                                  *        
      *                                                                *        
      ******************************************************************        
       7005-OPEN-REG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN UNCLMD_DEP                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA699 PROCESSING ERROR'                   
              DISPLAY '**  PARAGRAPH = 7005-OPEN-REG-CURSOR'            
              DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7010-FETCH-REG-CURSOR.                                       *        
      *        FETCHES ROW FROM ACCT & REFUND FOR CORRESPONDING ACCT   *        
      *        NUMBERS.                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-REG-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH UNCLMD_DEP                                          
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-ADDRESS-ID,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-LOCAL-OFFICE,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :RN-MANUAL-INDICATOR,                               
                    :RN-REFUND-CHECK-NO,                                
                    :RN-AMT-REFUNDED,                                   
                    :RN-CHECK-ISS-REAS-CD,                              
                    :RN-DATE-REFUNDED,                                  
                    :RN-REFUND-ITEM-ID,                                 
                    :RN-CHECK-STATUS-CD,                                
                    :RN-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED,                 
                    :AT-PREMISE-NO,                                     
                    :RN-REQUEST-DT :WS-NULL-REQUEST-DT,                         
                    :RN-ESCHEATMENT-CD,                                 
                    :B1-REGULATED-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF B1-REGULATED-CD = '02'                                 
                 MOVE 'Y' TO WS-REG-ACCT                                
                 COMPUTE WS-REG-CNT = WS-REG-CNT + 1                    
              ELSE                                                      
                 MOVE 'N' TO WS-REG-ACCT                                
                 COMPUTE WS-DREG-CNT = WS-DREG-CNT + 1                  
              END-IF                                                    
              MOVE ZEROES TO WS-INTEREST-AMT                            
              PERFORM 7900-GET-DEP-INT-AMT THRU 7900-EXIT               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-ROWS                             
              ELSE                                                      
                 DISPLAY '*************************************'        
                 DISPLAY '** PCSCA699 PROCESSING ERROR'                 
                 DISPLAY '** PARAGRAPH = 7010-FETCH-REG-CURSOR'         
                 DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '** PROCESSING TERMINATED'                     
                 DISPLAY '*************************************'        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7015-CLOSE-REG-CURSOR.                                       *        
      *        CLOSES CURSOR ESCHEATMENT_CSR                           *        
      *                                                                *        
      ******************************************************************        
       7015-CLOSE-REG-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE UNCLMD_DEP                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA699 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7015-CLOSE-REG-CURSOR'           
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7590-UPDATE-JOB-PARM-TABLE.                                  *  09749500
      *     INCREMENT  DATE ON JOB PARM TABLE FOR START DATE AND END *  09749600
      *     DATE.                                                    *  09749700
      *                                                              *  09749800
      ****************************************************************  09749900
                                                                        
       7590-UPDATE-JOB-PARM-TABLE.                                      
                                                                        
           ADD 3 TO WS-END-DATE-MM-R                                    
      *                                                                         
                                                                        
           IF WS-END-DATE-MM-R > 12                                     
             ADD 1 TO WS-END-DATE-YR-R                                  
             MOVE 3 TO WS-END-DATE-MM-R                                 
           END-IF.                                                      
      *SINCE THIS JOB CAN ALSO BE ON REQUEST,COVERING ALL MONTHS BELOW          
           IF WS-END-DATE-MM-R = 01 OR 03 OR 05 OR 07 OR 08 OR 10 OR 12 
              MOVE 31 TO WS-END-DATE-DD-R                               
           END-IF.                                                      
                                                                        
           IF WS-END-DATE-MM-R = 04 OR 06 OR 09 OR 11                   
              MOVE 30 TO WS-END-DATE-DD-R                               
           END-IF.                                                      
                                                                        
           IF WS-END-DATE-MM-R = 02                                     
             DIVIDE WS-END-DATE-YR-R BY +4                              
                  GIVING WS-YEAR-WORK REMAINDER WS-LEAP-YEAR            
             IF WS-LEAP-YEAR EQUAL ZERO                                 
               MOVE 29 TO WS-END-DATE-DD-R                              
             ELSE                                                       
               MOVE 28 TO WS-END-DATE-DD-R                              
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-JOB-PARM-DATA TO G6-PARM-DATA.                       
           MOVE 'PARM' TO G6-CMND-CODE.                                 
           MOVE 0001 TO G6-SEQ-NO.                                      
                                                                        
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                SET PARM_DATA    = :G6-PARM-DATA                        
              WHERE COMPANY_NO   = :WS-SYSIN-COMP-NO                    
                AND PROGRAM_NAME = :PROGRAM-NAME                        
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND SEQ_NO       = :G6-SEQ-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA699 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7590-UPDATE-JOB-PARM-TABLE'      
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-GET-COMPANY-DESC                                    **          
      **      SELECTS COMPANY NAME FROM CSS_COMPANY USING COMPANY   **          
      **      NO FROM ROW FETCHED FROM CSS_ACCOUNT.                 **          
      ****************************************************************          
      *                                                                         
       7100-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
                 INTO :C7-COMPANY-NAME                                  
                 FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
                WHERE COMPANY_NO = :C7-COMPANY-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C7-COMPANY-NAME TO P-RPT-CO-NAME-1                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '*************************************'       
                  DISPLAY '** PCSCA699 PROCESSING ERROR'                
                  DISPLAY '** PARAGRAPH = 7100-GET-COMPANY-DESC'        
                  DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY '** PROCESSING TERMINATED'                    
                  DISPLAY '*************************************'       
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06645500
      ************************************************************      06645600
      **  7560-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP                        **              
      ************************************************************              
       7560-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-DATE-TRANS        = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA699 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7560-GET-CURRENT-TIMESTAMP'       
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *                                                                 09720100
      ****************************************************************  09749300
      *                                                              *  09749400
       7800-GET-DEP-INT-AMT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                   AR.AMT_ORIG_ENTERED                                  
                INTO                                                    
                   :WS-AMT-DEPOSIT :WS-NULL-DEP-AMT                      
                FROM                                                    
                  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                    
                 ,CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                    
                WHERE                                                   
                   AR.ACCOUNT_NO = :AT-ACCOUNT-NO                       
                   AND AR.ACCOUNT_NO = AT.ACCOUNT_NO                    
                   AND AR.DATE_TRANS <= CAST(AT.ACCT_FINALED_DT AS DATE)        
                   AND AR.CODE_TRAN_TYPE = 'I'                          
                   AND AR.AMT_BILLED_UNPAID < 0                         
                   AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')    
                   ORDER BY AR.TRANS_HIST_SEQ_NO DESC                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*            AR.AMT_ORIG_ENTERED                                          
MFA-TR*         INTO                                                            
MFA-TR*            :WS-AMT-DEPOSIT:WS-NULL-DEP-AMT                              
MFA-TR*         FROM                                                            
MFA-TR*           CSS_AR_TRANS_HIST AR                                          
MFA-TR*          ,CSS_ACCOUNT       AT                                          
MFA-TR*         WHERE                                                           
MFA-TR*            AR.ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*            AND AR.ACCOUNT_NO = AT.ACCOUNT_NO                            
MFA-TR*            AND AR.DATE_TRANS <= DATE(AT.ACCT_FINALED_DT)                
MFA-TR*            AND AR.CODE_TRAN_TYPE = 'I'                                  
MFA-TR*            AND AR.AMT_BILLED_UNPAID < 0                                 
MFA-TR*            AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')            
MFA-TR*            ORDER BY AR.TRANS_HIST_SEQ_NO DESC                           
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-DEP-AMT = -1                                   
                 MOVE 0 TO WS-AMT-DEPOSIT                               
                 DISPLAY ' DEPOSIT IS 0 FOR ' AT-ACCOUNT-NO             
              END-IF                                                    
           ELSE                                                         
            IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                       
                 MOVE 0 TO WS-AMT-DEPOSIT                               
                 DISPLAY ' DEPOSIT IS 0 FOR ' AT-ACCOUNT-NO             
                                                                        
            ELSE                                                        
             IF WS-ACTIVE-RETURN-CODE = -811                            
                MOVE 0 TO WS-AMT-DEPOSIT                                
                DISPLAY 'DUP SO-FINAL DEP  '  AT-ACCOUNT-NO             
                PERFORM 8150-DET-DEP-DUPS THRU 8150-EXIT                
                                                                        
            ELSE                                                        
              DISPLAY '*************************************'           
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** PCSCA699 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7800-GET-DEP-INT-AMT'             
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
            END-IF                                                      
                                                                        
           END-IF
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7900-GET-DEP-INT-AMT.                                    **          
      **      SELECTS INTEREST AMOUNT THAT WAS                      **          
      **      CREDITED FOR THE DEPOSITS                             **          
      ****************************************************************          
                                                                        
      *                                                                         
       7900-GET-DEP-INT-AMT.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(INTEREST_AMT)                                 
                 INTO :WS-INTEREST-AMT :WS-NULL-INT-AMT                  
                 FROM CSS_INTEREST_HIST IH WITH(READUNCOMMITTED)                
                WHERE IH.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND INT_CREDIT_DT = IIF(TRY_CONVERT(DATE, 
                                                      :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) )                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(INTEREST_AMT)                                         
MFA-TR*          INTO :WS-INTEREST-AMT:WS-NULL-INT-AMT                          
MFA-TR*          FROM CSS_INTEREST_HIST IH                                      
MFA-TR*         WHERE IH.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND INT_CREDIT_DT = :RN-DATE-REFUNDED                         
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** PCSCA699 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7900-GET-DEP-INT-AMT'             
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ** TO GET COMMON DATE FROM JOB PARM                            **         
                                                                        
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      * CHECK AR LOCKOUT *********************************************          
      *7999-SELECT-AL                                                           
           EXEC SQL                                                             
               INCLUDE CPD00075                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8000-PRINT-HDR-699-1.                                        *        
      *   IT WRITES THE REPORT 1 HEADERS WHEN EVER THERE IS CHANGE IN  *        
      *   COMPANY NO. WRITES DIFFERENT TITLES BASED ON ALL CHECKS SET  *        
      *   TO ESCHEATMENT, AND ALL CHECKS SET TO ESCHEATMENT FOR AN     *        
      *   AMOUNT >= $25.00.                                            *        
      ******************************************************************        
       8000-PRINT-HDR-699-1.                                            
      *                                                                         
           MOVE 'PCSCA699-1' TO P-RPT-PGRMNAME-1.                       
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-1                       
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-2                       
                 AFTER ADVANCING 1 LINE.                                
           ADD +1               TO WS-RPT1-PAGE-NO.                     
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-3                       
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-4                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-11                  
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-12                  
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES             TO WS-RPT1-LINE-NO.                  
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8050-PRINT-HEADER-699-2.                                     *        
      *   WRITES HEADER FOR REPORT 2 WHENEVER THERE IS A PAGE BREAK    *        
      *   FOR REPORT 2.                                                *        
      ******************************************************************        
       8050-PRINT-HDR-699-2.                                            
      *                                                                         
           MOVE 'PCSCA699-2'        TO P-RPT-PGRMNAME-1.                
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-1                      
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-2                      
                 AFTER ADVANCING 1 LINE.                                
           ADD +1                   TO WS-RPT2-PAGE-NO.                 
           MOVE WS-RPT2-PAGE-NO     TO P-RPT-PAGE-NO.                   
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-3                      
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-5                      
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33A-RECORD FROM WS-PRINT-REP-HDR-11                 
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33A-RECORD FROM WS-PRINT-REP-HDR-12                 
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT2-LINE-NO.                              
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      05470000
      **  8150-DET-DEP-DUPS                                     **      05480000
      **      GETS THE DEPOSIT PORTION AT THE TIME OF FINAL     **      05490000
      **      BILL AND SUMS FOR MULTIPLE ROWS                   **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8150-DET-DEP-DUPS.                                               
            EXEC SQL                                                    
               SELECT                                                   
                      SUM(AR.AMT_ORIG_ENTERED)                          
               INTO                                                     
                       :AR-AMT-ORIG-ENTERED                             
               FROM                                                     
                       CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                      ,CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)               
                 WHERE                                                  
                   AR.ACCOUNT_NO = :AT-ACCOUNT-NO                       
                   AND AR.ACCOUNT_NO = AT.ACCOUNT_NO                    
                   AND AR.DATE_TRANS <= CAST(AT.ACCT_FINALED_DT AS DATE)        
                   AND AR.CODE_TRAN_TYPE = 'I'                          
                   AND AR.AMT_BILLED_UNPAID < 0                         
                   AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')    
                   GROUP BY AR.ACCOUNT_NO                               
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT                                                           
MFA-TR*               SUM(AR.AMT_ORIG_ENTERED)                                  
MFA-TR*        INTO                                                             
MFA-TR*                :AR-AMT-ORIG-ENTERED                                     
MFA-TR*        FROM                                                             
MFA-TR*                CSS_ACCOUNT     AT                                       
MFA-TR*               ,CSS_AR_TRANS_HIST AR                                     
MFA-TR*          WHERE                                                          
MFA-TR*            AR.ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*            AND AR.ACCOUNT_NO = AT.ACCOUNT_NO                            
MFA-TR*            AND AR.DATE_TRANS <= DATE(AT.ACCT_FINALED_DT)                
MFA-TR*            AND AR.CODE_TRAN_TYPE = 'I'                                  
MFA-TR*            AND AR.AMT_BILLED_UNPAID < 0                                 
MFA-TR*            AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')            
MFA-TR*            GROUP BY AR.ACCOUNT_NO                                       
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            EVALUATE WS-ACTIVE-RETURN-CODE                              
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AR-AMT-ORIG-ENTERED  TO WS-AMT-DEPOSIT          
               WHEN OTHER                                               
                    DISPLAY '** PCSCA699 PROCESSING ERROR    **'        
                    DISPLAY '** ERROR IN SELECT              **'        
                    DISPLAY '** PARA 8150-DET-DEP-DUPS       **'        
                    DISPLAY '** SQLCODE IS  ** ' SQLCODE                
                    DISPLAY '** PROCESSING TERMINATED        **'        
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
            END-EVALUATE.                                               
                                                                        
       8150-EXIT.                                                       
            EXIT.                                                       
      ************************************************************      05470000
      *                                                                         
                                                                        
       8300-NO-DATA-PARA.                                               
      *                                                                         
              IF WS-REG-ACCT = 'Y'                                      
                 PERFORM 8000-PRINT-HDR-699-1 THRU 8000-EXIT            
                 WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER          
                       ADVANCING 2 LINES                                
              END-IF                                                    
              IF WS-REG-ACCT = 'N'                                      
                 PERFORM 8050-PRINT-HDR-699-2 THRU 8050-EXIT            
                 WRITE PRT33A-RECORD FROM WS-NO-DATA-LINE AFTER         
                       ADVANCING 2 LINES                                
              END-IF.                                                   
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **   8550-MOVE-STATUS-CODE-DESCR                              **          
      **       MOVES THE STATUS CODE DESCRIPTION TO OUTPUT FIELD.   **          
      ****************************************************************          
      *                                                                         
       8550-MOVE-STATUS-CODE-DESCR.                                     
                                                                        
           EVALUATE RN-CHECK-STATUS-CD                                  
               WHEN 'A'                                                 
                   MOVE 'APPROVED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'C'                                                 
                   MOVE 'CANCELLED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'D'                                                 
                   MOVE 'DISAPPROVED   ' TO P-RPT1-CHECK-STATUS         
               WHEN 'E'                                                 
                   MOVE 'SENT FOR ESCHE' TO P-RPT1-CHECK-STATUS         
               WHEN 'F'                                                 
                   MOVE 'FORGED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'I'                                                 
                   MOVE 'ISSUED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'L'                                                 
                   MOVE 'CLEARED       ' TO P-RPT1-CHECK-STATUS         
               WHEN 'M'                                                 
                   MOVE 'REMAILED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'R'                                                 
                   MOVE 'REQUESTED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'S'                                                 
                   MOVE 'STOP PAYMENT  ' TO P-RPT1-CHECK-STATUS         
               WHEN 'T'                                                 
                   MOVE 'ESCHEATED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'U'                                                 
                   MOVE 'UNDELIVERABLE ' TO P-RPT1-CHECK-STATUS         
               WHEN 'X'                                                 
                   MOVE 'VOIDED        ' TO P-RPT1-CHECK-STATUS         
           END-EVALUATE.                                                
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8900-WRITE-FCSR6991                                          *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8900-WRITE-FCSR6991.                                             
      *                                                                         
           IF WS-REG-ESC-CODE = 'Y' AND  WS-REG-CNT NOT = 1             
             MOVE WS-TOT-SREF-ACCT-REG     TO WS-PRT-SUB-NUMBER         
             MOVE WS-TOT-SREFUND-AMT-REG   TO WS-PRT-SUB-REFUND-TOTALS  
             MOVE WS-TOT-SINTRST-AMT-REG   TO WS-PRT-SUB-INTRST-TOTALS  
             MOVE WS-TOT-SDEPOSIT-AMT-REG  TO WS-PRT-SUB-DEPOSIT-TOTALS 
             WRITE PRT33-RECORD FROM WS-SPACE-LINE                      
             WRITE PRT33-RECORD FROM WS-SPACE-LINE                      
             WRITE PRT33-RECORD FROM WS-PRT-SUB-TOTALS                  
                   AFTER ADVANCING 3 LINES                              
             INITIALIZE WS-PRT-SUB-TOTALS                               
             MOVE 0 TO WS-TOT-SREFUND-AMT-REG                           
                     ,WS-TOT-SDEPOSIT-AMT-REG                           
                     ,WS-TOT-SINTRST-AMT-REG                            
                     ,WS-TOT-SREF-ACCT-REG                              
             WRITE PRT33-RECORD FROM WS-SPACE-LINE                      
           END-IF.                                                      
                                                                        
           IF WS-RPT1-LINE-NO > 50                                      
              PERFORM 8000-PRINT-HDR-699-1 THRU 8000-EXIT               
              MOVE ZEROES            TO WS-RPT1-LINE-NO                 
           END-IF.                                                      
           IF WS-AMT-DEPOSIT NOT= 0                                     
                                                                        
             WRITE PRT33-RECORD FROM WS-PRINT-REP-DET-11                
                   AFTER  ADVANCING 1 LINE                              
             ADD 1                     TO WS-RPT1-LINE-NO               
             ADD RN-AMT-REFUNDED       TO WS-TOT-REFUND-AMT-REG         
             ADD WS-AMT-DEPOSIT        TO WS-TOT-DEPOSIT-AMT-REG        
             ADD WS-INTEREST-AMT       TO WS-TOT-INTRST-AMT-REG         
             ADD 1                     TO WS-TOT-REF-ACCT-REG           
             ADD RN-AMT-REFUNDED       TO WS-TOT-SREFUND-AMT-REG        
             ADD WS-AMT-DEPOSIT        TO WS-TOT-SDEPOSIT-AMT-REG       
             ADD WS-INTEREST-AMT       TO WS-TOT-SINTRST-AMT-REG        
             ADD 1                     TO WS-TOT-SREF-ACCT-REG          
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8950-WRITE-FCSR6992                                          *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8950-WRITE-FCSR6992.                                             
      *                                                                         
           IF WS-DREG-ESC-CODE = 'Y'                                    
             MOVE WS-TOT-SREF-ACCT-DREG     TO WS-PRT-SUB-NUMBER        
             MOVE WS-TOT-SREFUND-AMT-DREG   TO WS-PRT-SUB-REFUND-TOTALS 
             MOVE WS-TOT-SINTRST-AMT-DREG  TO WS-PRT-SUB-INTRST-TOTALS  
             MOVE WS-TOT-SDEPOSIT-AMT-DREG TO WS-PRT-SUB-DEPOSIT-TOTALS 
             WRITE PRT33A-RECORD FROM WS-SPACE-LINE                     
             WRITE PRT33A-RECORD FROM WS-SPACE-LINE                     
             WRITE PRT33A-RECORD FROM WS-PRT-SUB-TOTALS                 
                   AFTER ADVANCING 3 LINES                              
             INITIALIZE WS-PRT-SUB-TOTALS                               
             MOVE 0 TO WS-TOT-SREFUND-AMT-DREG                          
                     ,WS-TOT-SDEPOSIT-AMT-DREG                          
                     ,WS-TOT-SINTRST-AMT-DREG                           
                     ,WS-TOT-SREF-ACCT-DREG                             
             WRITE PRT33A-RECORD FROM WS-SPACE-LINE                     
           END-IF.                                                      
           IF WS-RPT2-LINE-NO > 50 AND NOT-END-OF-ROWS                  
              PERFORM 8050-PRINT-HDR-699-2 THRU 8050-EXIT               
              MOVE ZEROES      TO WS-RPT2-LINE-NO                       
           END-IF.                                                      
           IF WS-AMT-DEPOSIT NOT= 0                                     
             WRITE PRT33A-RECORD FROM WS-PRINT-REP-DET-11               
                   AFTER  ADVANCING 1 LINE                              
             ADD 1               TO WS-RPT2-LINE-NO                     
             ADD RN-AMT-REFUNDED TO WS-TOT-REFUND-AMT-DREG              
             ADD WS-AMT-DEPOSIT  TO WS-TOT-DEPOSIT-AMT-DREG             
             ADD WS-INTEREST-AMT TO WS-TOT-INTRST-AMT-DREG              
             ADD 1               TO WS-TOT-REF-ACCT-DEREG               
             ADD RN-AMT-REFUNDED TO WS-TOT-SREFUND-AMT-DREG             
             ADD WS-AMT-DEPOSIT  TO WS-TOT-SDEPOSIT-AMT-DREG            
             ADD WS-INTEREST-AMT TO WS-TOT-SINTRST-AMT-DREG             
             ADD 1               TO WS-TOT-SREF-ACCT-DREG               
           END-IF.                                                      
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   9000-CLOSE-FILES.                                            *        
      *                                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-TOT-REF-ACCT-REG NOT = 0                               
              MOVE WS-TOT-SREF-ACCT-REG     TO WS-PRT-SUB-NUMBER        
              MOVE WS-TOT-SREFUND-AMT-REG   TO WS-PRT-SUB-REFUND-TOTALS 
              MOVE WS-TOT-SINTRST-AMT-REG   TO WS-PRT-SUB-INTRST-TOTALS 
              MOVE WS-TOT-SDEPOSIT-AMT-REG  TO WS-PRT-SUB-DEPOSIT-TOTALS
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-PRT-SUB-TOTALS                 
                   AFTER ADVANCING 3 LINES                              
              INITIALIZE WS-PRT-SUB-TOTALS                              
                                                                        
              MOVE WS-TOT-REF-ACCT-REG     TO WS-PRT-GRAND-NUMBER       
              MOVE WS-TOT-REFUND-AMT-REG   TO WS-PRT-REFUND-TOTALS      
              MOVE WS-TOT-INTRST-AMT-REG   TO WS-PRT-INTRST-TOTALS      
              MOVE WS-TOT-DEPOSIT-AMT-REG  TO WS-PRT-DEPOSIT-TOTALS     
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS               
                    AFTER ADVANCING 3 LINES                             
              INITIALIZE WS-PRT-GRAND-TOTALS                            
           END-IF.                                                      
           IF WS-TOT-REF-ACCT-REGS NOT = 0                              
              MOVE WS-TOT-REF-ACCT-REGS     TO WS-PRT-GRAND-NUMBER      
              MOVE WS-TOT-REFUND-AMT-REGS   TO WS-PRT-REFUND-TOTALS     
              MOVE WS-TOT-INTRST-AMT-REGS   TO WS-PRT-INTRST-TOTALS     
              MOVE WS-TOT-DEPOSIT-AMT-REGS  TO WS-PRT-DEPOSIT-TOTALS    
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-SPACE-LINE                     
              WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS               
                    AFTER ADVANCING 3 LINES                             
              INITIALIZE WS-PRT-GRAND-TOTALS                            
           END-IF.                                                      
           IF WS-TOT-REF-ACCT-DEREG NOT = 0                             
              MOVE WS-TOT-SREF-ACCT-DREG    TO WS-PRT-SUB-NUMBER        
              MOVE WS-TOT-SREFUND-AMT-DREG  TO WS-PRT-SUB-REFUND-TOTALS 
              MOVE WS-TOT-SINTRST-AMT-DREG  TO WS-PRT-SUB-INTRST-TOTALS 
             MOVE WS-TOT-SDEPOSIT-AMT-DREG TO WS-PRT-SUB-DEPOSIT-TOTALS 
              WRITE PRT33A-RECORD FROM WS-SPACE-LINE                    
              WRITE PRT33A-RECORD FROM WS-SPACE-LINE                    
              WRITE PRT33A-RECORD FROM WS-PRT-SUB-TOTALS                
                   AFTER ADVANCING 3 LINES                              
              INITIALIZE WS-PRT-SUB-TOTALS                              
                                                                        
              MOVE WS-TOT-REF-ACCT-DEREG    TO WS-PRT-GRAND-NUMBER      
              MOVE WS-TOT-REFUND-AMT-DREG   TO WS-PRT-REFUND-TOTALS     
              MOVE WS-TOT-INTRST-AMT-DREG   TO WS-PRT-INTRST-TOTALS     
              MOVE WS-TOT-DEPOSIT-AMT-DREG  TO WS-PRT-DEPOSIT-TOTALS    
              WRITE PRT33A-RECORD FROM WS-SPACE-LINE                    
              WRITE PRT33A-RECORD FROM WS-SPACE-LINE                    
              WRITE PRT33A-RECORD FROM WS-PRT-GRAND-TOTALS              
                    AFTER ADVANCING 3 LINES                             
           END-IF.                                                      
                                                                        
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE                     
                 AFTER ADVANCING 3 LINES.                               
           WRITE PRT33A-RECORD FROM WS-END-DATA-LINE                    
                 AFTER ADVANCING 3 LINES.                               
                                                                        
           CLOSE FCSR6991-FILE.                                         
           CLOSE FCSR6992-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 6010-REDUCE-EMBEDDED-SPACES .                               **         
      *****************************************************************         
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      * TO CALL PARA TO CREATE BATCH JOURNAL.                                   
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
      * TO GET TODAY'S DATE FROM JOB PARM TABLE                                 
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
                                                                        
      * TO GET NAME AND MAIL OR SERVICE ADDRESS                                 
                                                                        
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
      *                                                                         
      * 9700-PROCESS-ABEND.                                                     
       COPY CPD0023B.                                                           
      *                                                                         
      * AR-LOCKOUT ERROR * DEFINED IN AR-LOCKOUT CPD00075                       
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                         
      *                                                                         
      ****************************************************************          
      **      THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
