       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA694.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **              P R O G R A M S U M M A R Y                    **         
      **                                                             **         
      **                                                             **         
      **         F U N C T I O N A L   D E S C R I P T I O N         **         
      **                         O F   M O D U L E                   **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  PRINTS REPORT CA694-1.                                     **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  THIS PROGRAM PROVIDES A REPORT OF ALL OUTSTANDING CHECKS   **         
      **  THAT WILL BE ESCHEATED WITH AN AMOUNT GREATER THAN OR EQUAL**         
T27536****TO $100*****.                                              **         
T27536**  TO $50.                                                    **         
      ****************************************************************          
      **                                                             **         
      **             PROGRAM  MODIFICATION  LOG                      **         
      **                                                             **         
      **   DATE        USERID       REASON                           **         
      **   ----        -------      ------                           **         
      **   09/08/2000  CB18344      INITIAL VERSION                  **         
T20186**   09/11/2000  CB18344      REMOVED LINE THAT EXCLUDED ACCTS **         
T20186**                            THAT HAVE BEEN WRITTEN OFF.      **         
T23643**   06/21/2001  BK88121      INCLUDED COMPANY-NO INTO JOB_PARM**         
T23643**                            TABLE AND CHECK THE COMPANY-NO   **         
T27271**   08/21/2002  COVANSYS     CHANGED LOGIC FOR THE UPDATE OF  **         
T27271**               CHENNAI      CSS_JOB_PARM FOR MULTI-COMPANY   **         
T27536**   02/26/2003  COVANSYS     CHANGED TO GENERATE REPORT HAVI  **         
T27536**               CHENNAI      NG AMOUNT GREATER OR EQUAL TO $50**         
T28025**   06/07/2004  CB18344      CHANGED TO GENERATE OUTPUT FILE  **         
T28025**                            NEEDED FOR DUE DILIGENCE LETTERS.**         
T31496**   01/12/2005  CB18344      CHANGED PROGRAM TO WRITE TO THE  **         
T31496**                            CSS_MNT_TRANS_HIST TABLE INSTEAD **         
T31496**                            OF THE CSS_AR_TRANS_HIST TABLE.  **         
T27597**   03/23/2005  CB18344      CHANGED PROGRAM TO SELECT ONLY   **         
T27597**                            DEREGULATED SEB ACCOUNTS.        **         
T32660**   06/07/2005  CB18344      CHANGED PROGRAM TO ENSURE SERVICE**         
T32660**                            ADDRESS IS USED FOR DUE DILIGENCE**         
T32660**                            LETTERS.                         **         
C35584**   05/21/2007  WILLIE       ADD CHANGE TO MOVE COMM TYPE AND **         
C35584**                            TO NEW COPYBOOK FIELD IN FIORP000**         
C35152**   03/11/2008  VP94820     -STOPPED POPULATING MAILING ADDR.,**         
C35152**                           -PASSING ADDRRESS ID,CUSTOMER ID &**         
C35152**                           -ADDRESS FORMAT TO BILL PRINT.    **         
C37112**                                                                        
C37112**   04/03/2008  RC41079     CHANGED PROGRAM TO ALSO PROCESS   **         
C37112**                           REGULATED ACCOUNTS WHEN RUNNING IN**         
C37112**                           SEB.  CREATES REGULATED AND DEREG-**         
C37112**                           ULATED REPORTS FOR CA694.         **         
C37112**                                                             **         
P35809**   04/14/2008  RC41079     ADDED A CHECK FOR ESCHEATEMENT_CD **         
P35809**                           NOT EQUAL TO 'U' IN THE WHERE     **         
P35809**                           CLAUSE OF THE ESCHEATMENT_CSR     **         
P35809**                           CURSOR.                           **         
P35809**                                                             **         
A03866**   02/02/2012  MC95456     COMMUNICATION DETAILS ARE TO BE   **         
A03866**   A03866-ACT012           WRITTEN TO CSS_COMM_DATA.         **         
ACT034**   04/04/12    NS75440     MOVED 'N' TO KO-RED-FLAG-IND AND  **         
ACT034**   A03967                  KO-PSC-COMPLIANCE-IND ALSO REMOVED**         
ACT034**                           COMMENTS.                         **         
P00599**   08/03/12    GV7A828     MODIFIED THE PROGRAM TO CALL      **         
P00599**                           SCSKR125 SUB-PROGRAM INSTEAD OF   **         
P00599**                           WRITING TO THE RP000 FILE         **         
      ****************************************************************          
      *                                                                         
      *             ---- BASIC SEQUENCE STRUCTURE ----                          
      *         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION            
      *         1000 - 1999     INPUT PROCESSING CONTROL PATH                   
      *         2000 - 2999     OUTPUT PROCESSING CONTROL PATH                  
      *         3000 - 4999     BATCH PROCESSING MODULES - NOT USED             
      *         5000 - 5999     COMMON PROGRAM MODULES                          
      *         6000 - 6999     COMMON SYSTEM MODULES                           
      *         7000 - 7999     INPUT MODULES                                   
      *         8000 - 8999     OUTPUT MODULES                                  
      *         9000 - 9799     TERMINATION MODULES                             
      *         9800 - 9899     XCTLS TO PROGRAMS                               
      *         9900 - 9999     ABEND/ABORT MODULES                             
      *    EJECT                                                                
      *    ---- ------------------------- ------------------------------        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
T28025*                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA694'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA694 STARTS HERE'.            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *                                                                         
      *  WORKING STORAGE FOR REPORT HEADER.                                     
      *                                                                         
       COPY CWS00079.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      ** INCLUDE CWS00061 FOR GL NEUMONICS                                      
       COPY CWS00061.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
      * FOR NAME AND ADDRESS                                                    
       COPY CWS00074.                                                           
      *                                                                         
      * FOR DB2 ABEND VARIABLES                                                 
       COPY CWS00010.                                                           
      *                                                                         
      * FOR REDUCING EMBEDDED SPACES                                            
       COPY CWS00011.                                                           
      *                                                                         
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      *                                                                         
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
       COPY CJF00101.                                                           
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
       01  WS-DATE-T1.                                                  
           05  WS-DATE-T1-YYYY         PIC X(04)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-T1-MM           PIC X(02)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-T1-DD           PIC X(02)    VALUE SPACES.       
      *                                                                         
       01  WS-DATE-T2.                                                  
           05  WS-DATE-T2-MM           PIC X(02)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-T2-DD           PIC X(02)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DATE-T2-YYYY         PIC X(04)    VALUE SPACES.       
      *                                                                         
       01  WS-JOB-PARM-DATA.                                            
           05  WS-BEGIN-DATE-MSSG      PIC X(13).                       
           05  WS-BEGIN-DATE-DATA      PIC X(10).                       
           05  WS-BEGIN-DATE-R REDEFINES WS-BEGIN-DATE-DATA.            
               10  WS-BEGIN-DATE-YR-R  PIC 9(4).                        
               10  FILLER              PIC X(1).                        
               10  WS-BEGIN-DATE-MM-R  PIC 9(2).                        
               10  FILLER              PIC X(1).                        
               10  WS-BEGIN-DATE-DD-R  PIC 9(2).                        
           05  FILLER                  PIC X(17).                       
           05  WS-END-DATE-MSSG        PIC X(11).                       
           05  WS-END-DATE-DATA        PIC X(10).                       
           05  WS-END-DATE-R REDEFINES WS-END-DATE-DATA.                
               10  WS-END-DATE-YR-R    PIC 9(4).                        
               10  FILLER              PIC X(1).                        
               10  WS-END-DATE-MM-R    PIC 9(2).                        
               10  FILLER              PIC X(1).                        
               10  WS-END-DATE-DD-R    PIC 9(2).                        
           05  FILLER                  PIC X(19).                       
      *                                                                 01362500
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA694'.   
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA694'.   
      *                                                                 01362500
T23643 01  WS-COMPANY-NUMBER           PIC X(02).                       
T23643     88 VALID-COMPANY                         VALUE '01' '26'.    
      *                                                                 01362500
       01 WS-SWITCHES.                                                  
           05  WS-OPEN-CURSOR-SW        PIC X(01)    VALUE 'N'.         
               88 CURSOR-OPEN                        VALUE 'Y'.         
               88 CURSOR-NOT-OPEN                    VALUE 'N'.         
T27597     05  WS-DATABASE              PIC 9(01)    VALUE ZERO.        
T27597         88 CSR-DATABASE                       VALUE 1.           
T27597         88 SEB-DATABASE                       VALUE 2.           
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADERS        **          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
           05  WS-RPT-TITLE-1.                                          
               10  P-RPT-PGRMNAME-1    PIC X(10).                       
               10  FILLER              PIC X(44)    VALUE SPACES.       
               10  P-RPT-CO-NAME-1     PIC X(26).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                      'RUN DATE: '.                     
               10  P-RPT-RUN-DATE-1    PIC X(08).                       
      *                                                                         
           05  WS-RPT-TITLE-2.                                          
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT-TRAN-DATE     PIC X(08).                       
               10  FILLER              PIC X(34)    VALUE SPACES.       
               10  FILLER              PIC X(36)    VALUE               
               'TREASURER''S ''A'' CHECK RECONCILIATION'.               
               10  FILLER              PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                      'RUN TIME:  '.                    
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
           05  WS-RPT-TITLE-3.                                          
               10  FILLER              PIC X(25)    VALUE SPACES.       
C37112         10  DE-REG              PIC X(12)    VALUE SPACES.       
               10  FILLER              PIC X(34)    VALUE               
               'CHECKS ELIGIBLE FOR ESCHEATMENT - '.                    
               10  BEG-DATE-MM         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  BEG-DATE-DD         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  BEG-DATE-YYYY       PIC X(04)    VALUE SPACES.       
               10  FILLER              PIC X(04)    VALUE ' TO '.       
               10  END-DATE-MM         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  END-DATE-DD         PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  END-DATE-YYYY       PIC X(04)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  P-RPT-PAGE-NO       PIC ZZ,ZZZ.                      
               10  FILLER              PIC X(07)    VALUE SPACES.       
      *                                                                         
           05  WS-RPT-TITLE-4.                                          
               10  FILLER              PIC X(44)    VALUE SPACES.       
               10  FILLER              PIC X(45)    VALUE               
T27536         'LISTING OF ACCOUNTS WITH CHECK AMOUNT >= $50'.          
               10  FILLER              PIC X(43)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-11.                                         
           05  FILLER                  PIC X(09)    VALUE               
                                       'CHECK NBR'.                     
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(04)    VALUE               
                                       'DATE'.                          
           05  FILLER                  PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(06)    VALUE               
                                       'AMOUNT'.                        
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(12)    VALUE               
                                       'CHECK STATUS'.                  
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(11)    VALUE               
                                       'ACCT NUMBER'.                   
           05  FILLER                  PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'NAME'.                          
           05  FILLER                  PIC X(24)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-12.                                         
           05  FILLER                  PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-DET-11.                                         
           05  P-RPT1-CHK-NUMB         PIC X(09)    VALUE ZEROES.       
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  P-RPT1-ISS-DATE         PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  P-RPT1-CHK-AMT          PIC ZZZ,ZZZ,ZZ9.99               
                                                    VALUE ZEROES.       
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  P-RPT1-CHECK-STATUS     PIC X(14)    VALUE ZEROES.       
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  P-RPT1-ACCT-NUMB        PIC 9(13)    VALUE ZEROES.       
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  P-RPT1-CUST-NAME        PIC X(50)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                    '*** END OF REPORT ***'.                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-PRT-GRAND-TOTALS.                                         
           05  FILLER                  PIC X(20)    VALUE               
                    'NUMBER OF CHECKS IS '.                             
           05  WS-PRT-GRAND-NUMBER     PIC ZZ,ZZZ.                      
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  FILLER                  PIC X(18)    VALUE               
                    'AND THE AMOUNT IS '.                               
           05  WS-PRT-GRAND-AMOUNT     PIC $$,$$$,$$9.99.               
           05  FILLER                  PIC X(74)    VALUE SPACES.       
      *                                                                         
       01  WS-MISC.                                                     
C37112     05  WS-REGULATED-CD         PIC X(02)    VALUE SPACES.       
           05  RS-RETURN-CODE          PIC S9(04)   COMP.               
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-RPT1-LINE-NO         PIC 9(02)    VALUE 0.            
           05  WS-RPT1-PAGE-NO         PIC 9(04)    VALUE 0.            
           05  WS-PREV-COMP-NO         PIC X(02)    VALUE SPACES.       
           05  WS-GRAND-TOTAL-AMOUNT-1 PIC 9(10)V99 VALUE ZEROES.       
           05  WS-GRAND-TOTAL-NUMBER-1 PIC 9(05)    VALUE ZEROES.       
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
P00599     05  SCSKR125                PIC X(08)    VALUE 'SCSKR125'.   
P00599     05  RS-KR125-RETURN-CODE    PIC S9(04) COMP VALUE 0.         
P00599     05  WS-PREV-ACCOUNT-NO      PIC S9(13)V USAGE COMP-3 VALUE 0.
P00599     05  WS-SEQ-NO-COUNT         PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-END-OF-ROWS          PIC X(01)    VALUE 'N'.          
               88  NOT-END-OF-ROWS                  VALUE 'N'.          
               88  END-OF-ROWS                      VALUE 'Y'.          
C37112     05  WS-PRINT-REG-HDR        PIC X(01)    VALUE 'N'.          
C37112         88  NOT-PRINT-REG-HDR                VALUE 'N'.          
C37112         88  PRINT-REG-HDR                    VALUE 'Y'.          
           05  WS-Y                    PIC X(1)     VALUE 'Y'.          
           05  WS-N                    PIC X(1)     VALUE 'N'.          
T28025     05  WS-L                    PIC X(01)    VALUE 'L'.          
T28025     05  WS-O                    PIC X(01)    VALUE 'O'.          
T28025     05  WS-SUB                  PIC 9(2)     VALUE 0.            
T28025     05  WS-NOTICE-DATE.                                          
T28025         10  WS-NOTICE-YY        PIC 9(2)     VALUE 0.            
T28025         10  WS-NOTICE-MM        PIC 9(2)     VALUE 0.            
T28025         10  WS-NOTICE-DD        PIC 9(2)     VALUE 0.            
T28025     05  WS-ACCOUNT-COUNT        PIC 9(5)     VALUE 0.            
C37112     05  WS-ACCT-COUNT-DEREG     PIC 9(5)     VALUE 0.            
C37112     05  WS-ACCT-COUNT-REG       PIC 9(5)     VALUE 0.            
T28025     05  WS-TEMP-DATE            PIC X(10)    VALUE SPACES.       
T28025     05  WS-WORK-DATE            PIC X(10)    VALUE SPACES.       
T28025     05  WS-CURRENT-TIMESTAMP    PIC X(26)    VALUE SPACES.       
T28025     05  WS-DATE-TRANS           PIC X(10)    VALUE SPACES.       
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
T32660     05  WS-ZIP-CODE-FIVE        PIC X(05)    VALUE SPACES.       
T32660     05  WS-ZIP-CODE-TOKEN       PIC X(01)    VALUE SPACES.       
T28025     05  WS-TRANS-HIST-MSG.                                       
T28025         10  FILLER                  PIC X(42)  VALUE             
T28025                  'DUE DILIGENCE LETTER SENT.  CHECK NUMBER: '.   
T28025         10  WS-CHK-NUM              PIC 9(09) VALUE ZEROES.      
T28025         10  FILLER                  PIC X(23)  VALUE             
T28025                  '         CHECK AMOUNT: '.                      
T28025         10  WS-CHK-AMT              PIC $$$,$$$,$$9.99           
T28025                           VALUE ZEROES.                          
T31496     05  WS-TRAN-APPL-NO             PIC S9(04) COMP VALUE 1.     
C37112     05  WS-DEREG-REG                PIC X(01) VALUE SPACES.      
A03866     05  WS-MESSAGE-NO               PIC 9(05) VALUE 40001.       
A03866     05  WS-RED-FL-NULL-IND          PIC S9(04) COMP VALUE +0.    
A03866     05  WS-INITIAL-COMMENT-TX.                                   
A03866         10  WS-INITIAL-COMMENT-TX-LEN  PIC S9(4) USAGE COMP.     
A03866         10  WS-INITIAL-COMMENT-TX-TEXT PIC X(255) VALUE SPACES.  
A03866     05  WS-END-NULL-IND             PIC S9(04) COMP VALUE +0.    
      *                                                                         
      ******* ABEND SWITCH COPYBOOK *****************************               
      *                                                                         
         COPY CWS09900.                                                         
                                                                        
P00599******* CORRESP NOTICE VARIABLES************                              
P00599 COPY CWS00341.                                                           
P00599                                                                  
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00350                                                  
P00599     END-EXEC.                                                            
P00599                                                                  
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCOUNT *****************               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_BILL_NMES  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_MISC_INFO  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ADDR_FORMATTED ***************          
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ADDR_FREEFORM ****************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_AR_TRANS_HIST ***********               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_AR_TRN_HST_DET **********               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_MNT_TRANS_HIST ***********              
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
T31496*                                                                         
T31496******* TABLE DECLARATION FOR CSS_MT_TRN_HST_DET ***********              
T31496*                                                                         
T31496                                                                  
T31496     EXEC SQL                                                             
T31496         INCLUDE TBMNHDT                                                  
T31496     END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_BATCH_JRNL *******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_BCH_JRNL_CNTL ****************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_BUS_CUST_STATS  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBSCSTS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_COMPANY  ****************               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_CUST_ADD_XREF ******************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_CUST_STATS *******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTSTS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_CUSTOMER  ***************               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FRO CSS_GL_ACCT_NO *******************          
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_JOB_PARM    ******************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_MISC_JRNL ********************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_NAME *************************          
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_NAME_ACCT_XREF *****************        
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_PREMISE **********************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_REFUND ***********************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ZIP_CODE *******************            
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
T28025*                                                                         
T28025******* TABLE DECLARATION FOR CSS_MODEL_SQL ******************            
T28025*                                                                         
T28025                                                                  
T28025     EXEC SQL                                                             
T28025         INCLUDE TBMODEL                                                  
T28025     END-EXEC.                                                            
T28025*                                                                         
T28025******* TABLE DECLARATION FOR CSS_COMM_DATA ******************            
T28025*                                                                         
T28025                                                                  
T28025     EXEC SQL                                                             
T28025         INCLUDE TBCOMDAT                                                 
T28025     END-EXEC.                                                            
T28025*                                                                         
T27597******* TABLE DECLARATION FOR CSS_DELINQUENCY ****************            
T27597*                                                                         
T27597                                                                  
T27597     EXEC SQL                                                             
T27597         INCLUDE TBDELQ                                                   
T27597     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE ESCHEATMENT_CSR CURSOR FOR                       
               SELECT AT.ACCOUNT_NO                                     
T28025               ,AT.CUSTOMER_NO                                    
T28025               ,AT.PREMISE_NO                                     
                     ,AT.ADDRESS_ID                                     
T32660               ,AT.ADDRESS_FORMAT                                 
                     ,AT.COMPANY_NO                                     
P00599               ,AT.LOCAL_OFFICE                                   
                     ,RN.REFUND_CHECK_NO                                
                     ,RN.AMT_REFUNDED                                   
                     ,RN.DATE_REFUNDED                                  
                     ,RN.CHECK_STATUS_CD                                
C37112               ,B1.REGULATED_CD                                   
                FROM CSS_REFUND RN WITH(READUNCOMMITTED),                       
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
C37112               CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO = RN.ACCOUNT_NO                      
C37112           AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                  
                 AND RN.MANUAL_INDICATOR IN ('M','S')                   
                 AND RN.CHECK_STATUS_CD IN ('I','U','M')                
                 AND RN.DATE_REFUNDED >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-BEGIN-DATE-DATA
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE-DATA
              ) <> 0) OR (LEN(:WS-BEGIN-DATE-DATA
              ) <> 10), CIS.CHAR2DATE(:WS-BEGIN-DATE-DATA
              ), CONVERT(DATE, :WS-BEGIN-DATE-DATA) )            
                 AND RN.DATE_REFUNDED <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-END-DATE-DATA
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE-DATA
              ) <> 0) OR (LEN(:WS-END-DATE-DATA) <> 10), CIS.CHAR2DATE(
                                                      :WS-END-DATE-DATA
              ), CONVERT(DATE, :WS-END-DATE-DATA) )              
T27536           AND RN.AMT_REFUNDED >= 50.00                           
P35809           AND RN.ESCHEATMENT_CD <> 'U'                           
T23643           AND AT.COMPANY_NO    = :WS-SYSIN-COMP-NO               
P00599      ORDER BY AT.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
C37112               B1.REGULATED_CD,                                   
                     RN.AMT_REFUNDED DESC                               
A03866                                                           
A03866                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ESCHEATMENT_CSR CURSOR FOR                               
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,RN.REFUND_CHECK_NO                                        
MFA-TR*              ,RN.AMT_REFUNDED                                           
MFA-TR*              ,RN.DATE_REFUNDED                                          
MFA-TR*              ,RN.CHECK_STATUS_CD                                        
MFA-TR*              ,B1.REGULATED_CD                                           
MFA-TR*         FROM CSS_REFUND RN,                                             
MFA-TR*              CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.ACCOUNT_NO = RN.ACCOUNT_NO                              
MFA-TR*          AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                          
MFA-TR*          AND RN.MANUAL_INDICATOR IN ('M','S')                           
MFA-TR*          AND RN.CHECK_STATUS_CD IN ('I','U','M')                        
MFA-TR*          AND RN.DATE_REFUNDED >= :WS-BEGIN-DATE-DATA                    
MFA-TR*          AND RN.DATE_REFUNDED <= :WS-END-DATE-DATA                      
MFA-TR*          AND RN.AMT_REFUNDED >= 50.00                                   
MFA-TR*          AND RN.ESCHEATMENT_CD <> 'U'                                   
MFA-TR*          AND AT.COMPANY_NO    = :WS-SYSIN-COMP-NO                       
MFA-TR*     ORDER BY AT.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              B1.REGULATED_CD,                                           
MFA-TR*              RN.AMT_REFUNDED DESC                                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      *                                                                         
      *                                                                         
       01  WS-END                       PIC X(40)                       
               VALUE ' WORKING STORAGE FOR PCSCA694 ENDS HERE '.        
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
               IF AT-COMPANY-NO = WS-SYSIN-COMP-NO                      
T23643            PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT          
                  PERFORM 1000-CURSOR-PROCESS THRU 1000-EXIT            
                    UNTIL END-OF-ROWS                                   
                       OR AT-COMPANY-NO NOT = WS-SYSIN-COMP-NO          
               ELSE                                                     
                   IF END-OF-ROWS                                       
C37112               IF CSR-DATABASE                                    
                       PERFORM 8300-NO-DATA-PARA THRU 8300-EXIT         
C37112               ELSE                                               
C37112                 PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT        
C37112                 MOVE 'R' TO WS-DEREG-REG                         
C37112                 MOVE '  REGULATED ' TO DE-REG                    
C37112                 PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT        
C37112               END-IF                                             
C37112             END-IF                                               
               END-IF.                                                  
      *                                                                         
           PERFORM 7590-UPDATE-JOB-PARM-TABLE THRU 7590-EXIT.           
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   0100-INITIALIZATION                                          *        
      *        COMMON INITIALIZATION ROUTINE                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES TO WS-INPUT-AREA                              
              MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN                    
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSCA694' TO WS-PGRMNAME                            
           END-IF.                                                      
      *                                                                         
           IF WS-INPUT-DATE EQUAL TO SPACES                             
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA694 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 0100-INITIALIZATION'              
              DISPLAY                                                   
              'COMMON DATE IS NOT AVAILABLE IN JOB PARM TABLE'          
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-DATE-10                             
T28025                           WS-TEMP-DATE.                          
           MOVE WS-D10-YY TO WS-D8-YY.                                  
           MOVE WS-D10-MM TO WS-D8-MM.                                  
           MOVE WS-D10-DD TO WS-D8-DD.                                  
           MOVE WS-DATE-8 TO P-RPT-TRAN-DATE                            
                             P-RPT1-REPORT-DATE.                        
      *                                                                         
T23643     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T23643     IF WS-SYSIN-COMP-NO = SPACES                                 
T23643        DISPLAY '***********************************'             
T23643        DISPLAY '** INVALID SYSIN COMPANY NUMBER'                 
T23643        DISPLAY '** CHECK SYSIN DSN MEMBER IN JCL'                
T23643        DISPLAY '** AND RERUN. NO PROCESSING DONE'                
T23643        DISPLAY '** PROCESSING TERMINATED'                        
T23643        DISPLAY '***********************************'             
T23643        PERFORM 9900-ABEND THRU 9900-EXIT                         
T23643     END-IF.                                                      
      *                                                                         
T23643     MOVE  WS-SYSIN-COMP-NO TO WS-COMPANY-NUMBER                  
T23643     IF  VALID-COMPANY                                            
T23643         NEXT SENTENCE                                            
T23643     ELSE                                                         
T23643         DISPLAY '***************************************'        
T23643         DISPLAY '** AT COMPANY NO DOES NOT MATCH SYSIN '         
T23643         DISPLAY '** CHECK SYSIN DSN MEMBER IN JCL'               
T23643         DISPLAY '** AND RERUN. NO PROCESSING DONE'               
T23643         DISPLAY '** PROCESSING TERMINATED'                       
T23643         DISPLAY '***************************************'        
T23643         PERFORM 9900-ABEND THRU 9900-EXIT                        
T23643     END-IF.                                                      
      *                                                                         
           PERFORM 0110-READ-CSS-JOB-PARM THRU 0110-EXIT.               
                                                                        
           MOVE WS-BEGIN-DATE-MM-R TO BEG-DATE-MM.                      
           MOVE WS-BEGIN-DATE-DD-R TO BEG-DATE-DD.                      
           MOVE WS-BEGIN-DATE-YR-R TO BEG-DATE-YYYY.                    
           MOVE WS-END-DATE-MM-R TO END-DATE-MM.                        
           MOVE WS-END-DATE-DD-R TO END-DATE-DD.                        
           MOVE WS-END-DATE-YR-R TO END-DATE-YYYY.                      
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH TO WS-RT-HH.                                      
           MOVE WS-MM TO WS-RT-MM.                                      
           MOVE WS-SS TO WS-RT-SS.                                      
           MOVE WS-RUN-TIME TO P-RPT-RUN-TIME.                          
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY TO WS-RD-YY.                                      
           MOVE WS-CM TO WS-RD-MM.                                      
           MOVE WS-CD TO WS-RD-DD.                                      
           MOVE WS-RUN-DATE TO P-RPT-RUN-DATE-1.                        
      *                                                                         
           INITIALIZE WS-100-RECORD-ID-DATA                             
                      WS-PRT-GRAND-TOTALS.                              
T27597*                                                                         
T27597     MOVE ZERO TO WS-DATABASE.                                    
T27597     MOVE 'DATABASE' TO C8-DELINQ-CD.                             
T27597     MOVE '01' TO C8-COMPANY-NO.                                  
T27597     PERFORM 0150-SELECT-DATABASE THRU 0150-EXIT.                 
C37112     MOVE C8-DELINQ-VALUE               TO WS-DATABASE            
P00599                                           WS-CWS350-DATABASE.    
T27597*                                                                         
              PERFORM 7005-OPEN-CURSOR THRU 7005-EXIT                   
              PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT                  
      *                                                                         
C37112     IF SEB-DATABASE                                              
C37112       IF WS-REGULATED-CD = '02'                                  
C37112          MOVE 'DEREGULATED ' TO DE-REG                           
C37112          PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT               
C37112          MOVE 'R' TO WS-DEREG-REG                                
C37112          MOVE '  REGULATED ' TO DE-REG                           
C37112       ELSE                                                       
C37112          MOVE 'DEREGULATED ' TO DE-REG                           
C37112       END-IF                                                     
C37112     END-IF.                                                      
      *                                                                         
      *                                                                         
T23643     IF END-OF-ROWS                                               
T23643          MOVE WS-SYSIN-COMP-NO TO C7-COMPANY-NO                  
T23643     END-IF.                                                      
T23643     PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09480000
      ****************************************************************  09490000
      *                                                              *  09500000
      * 0110-READ-CSS-JOB-PARM.                                      *  09510000
      *     SELECTS JOB PARM INFORMATION.                            *  09520000
      *                                                              *  09540000
      ****************************************************************  09550000
      *                                                                 09560000
       0110-READ-CSS-JOB-PARM.                                          
      *                                                                 09560000
           EXEC SQL                                                     
               SELECT G6.PARM_DATA                                      
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   
T23643            AND G6.COMPANY_NO   = :WS-SYSIN-COMP-NO               
A03866                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02671000
MFA-TR*        SELECT G6.PARM_DATA                                      02671200
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                   02671700
MFA-TR*         WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   02671800
MFA-TR*           AND G6.COMPANY_NO   = :WS-SYSIN-COMP-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 0110                                                    
MFA-TR*    END-EXEC.                                                    02673000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02674000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               MOVE G6-PARM-DATA TO WS-JOB-PARM-DATA                    
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA694 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 0110-READ-CSS-JOB-PARM'          
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 09700000
       0110-EXIT.                                                       
           EXIT.                                                        
T27597*                                                                 09480000
T27597****************************************************************  09490000
T27597*                                                              *  09500000
T27597* 0150-SELECT-DATABASE.                                        *  09510000
T27597*     SELECTS DATABASE FROM CSS_DELINQUENCY.                   *  09520000
T27597*                                                              *  09540000
T27597****************************************************************  09550000
T27597*                                                                 09560000
T27597 0150-SELECT-DATABASE.                                            
T27597*                                                                 09560000
T27597     EXEC SQL                                                     
T27597         SELECT DELINQ_VALUE                                      
T27597           INTO :C8-DELINQ-VALUE                                  
T27597           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T27597          WHERE DELINQ_CD = :C8-DELINQ-CD                         
T27597            AND COMPANY_NO = :C8-COMPANY-NO                       
A03866                                                           
A03866                                                      
T27597     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02671000
MFA-TR*        SELECT DELINQ_VALUE                                      02671200
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                   02671700
MFA-TR*         WHERE DELINQ_CD = :C8-DELINQ-CD                         02671800
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 0150                                                    
MFA-TR*    END-EXEC.                                                    02673000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27597*                                                                 02674000
T27597     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27597     IF SQLCODE = SUCCESSFUL-CALL                                 
T27597     OR SQLCODE = NOT-FOUND                                       
T27597        CONTINUE                                                  
T27597     ELSE                                                         
T27597         DISPLAY '*************************************'          
T27597         DISPLAY '** PCSCA694 PROCESSING ERROR'                   
T27597         DISPLAY '** PARAGRAPH = 0150-SELECT-DATABASE'            
T27597         DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
T27597         DISPLAY '** DELINQ CODE: ' C8-DELINQ-CD                  
T27597         DISPLAY '** COMPANY NO: ' C8-COMPANY-NO                  
T27597         DISPLAY '** PROCESSING TERMINATED'                       
T27597         DISPLAY '*************************************'          
T27597         PERFORM 9900-ABEND THRU 9900-EXIT                        
T27597     END-IF.                                                      
T27597*                                                                 09700000
T27597 0150-EXIT.                                                       
T27597     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-CURSOR-PROCESS                                            *        
      *                                                                *        
      * PROCESS THE MAIN CURSOR ESCHEATMENT. WRITE HEADER WHEN THERE IS*        
      * A CHANGE IN COMP NO. ACCUMULATES CHECK TOTAL FOR EACH ACCOUNT. *        
      * WRITES INTO REPORT2 IF AMT EXCEEDS 25$. WRITE EVERY ROW FETCHED*        
      * TO REPORT1.                                                    *        
      ******************************************************************        
       1000-CURSOR-PROCESS.                                             
      *                                                                         
           IF AT-COMPANY-NO NOT = WS-PREV-COMP-NO                       
T23643        MOVE WS-SYSIN-COMP-NO TO C7-COMPANY-NO                    
              PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT              
              PERFORM 8000-PRINT-HDR-694-1 THRU 8000-EXIT               
              MOVE AT-COMPANY-NO TO WS-PREV-COMP-NO                     
           END-IF.                                                      
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           PERFORM 8400-MOVE-PRINT-FIELDS THRU 8400-EXIT.               
P00599     PERFORM 8500-MOVE-DUE-DILIG-VAR THRU 8500-EXIT.              
T31496     PERFORM 8600-LOAD-MNT            THRU 8600-EXIT.             
T31496     PERFORM 8800-LOAD-MNT-TRANS-HIST THRU 8800-EXIT.             
T31496     ADD +1 TO WS-TRAN-APPL-NO.                                   
                                                                        
           PERFORM 8900-WRITE-FCSPT33 THRU 8900-EXIT.                   
      *                                                                         
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT                     
      *                                                                         
C37112     IF SEB-DATABASE                                              
C37112       IF END-OF-ROWS                                             
C37112         IF WS-DEREG-REG = SPACES                                 
C37112           IF WS-GRAND-TOTAL-NUMBER-1 NOT = 0                     
C37112             MOVE WS-GRAND-TOTAL-NUMBER-1 TO WS-PRT-GRAND-NUMBER  
C37112             MOVE WS-GRAND-TOTAL-AMOUNT-1 TO WS-PRT-GRAND-AMOUNT  
C37112             WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS          
C37112                   AFTER ADVANCING 3 LINES                        
C37112             INITIALIZE WS-PRT-GRAND-TOTALS                       
C37112           END-IF                                                 
C37112           MOVE '  REGULATED ' TO DE-REG                          
C37112           MOVE 'R' TO WS-DEREG-REG                               
C37112           PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT              
C37112           MOVE 'Y' TO WS-PRINT-REG-HDR                           
C37112         END-IF                                                   
C37112       ELSE                                                       
C37112         IF WS-REGULATED-CD = '02'                                
C37112           IF WS-DEREG-REG = SPACES                               
C37112             MOVE 'DEREGULATED ' TO DE-REG                        
C37112             IF WS-GRAND-TOTAL-NUMBER-1 NOT = 0                   
C37112               MOVE WS-GRAND-TOTAL-NUMBER-1 TO WS-PRT-GRAND-NUMBER
C37112               MOVE WS-GRAND-TOTAL-AMOUNT-1 TO WS-PRT-GRAND-AMOUNT
C37112               WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS        
C37112                     AFTER ADVANCING 3 LINES                      
C37112               INITIALIZE WS-PRT-GRAND-TOTALS                     
C37112             END-IF                                               
C37112             MOVE ZEROES TO WS-RPT1-LINE-NO                       
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-NUMBER-1               
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-AMOUNT-1               
C37112             MOVE '  REGULATED ' TO DE-REG                        
C37112             MOVE 'R' TO WS-DEREG-REG                             
C37112             PERFORM 8000-PRINT-HDR-694-1 THRU 8000-EXIT          
C37112           END-IF                                                 
C37112         END-IF                                                   
C37112       END-IF                                                     
T27597     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
P00599******************************************************************        
P00599* 5000-CALL-NOTICES                                                       
P00599******************************************************************        
P00599*                                                                         
P00599 5000-CALL-NOTICES.                                               
P00599                                                                  
P00599     CALL SCSKR125 USING   WS-CORRESP-HDR                         
P00599                           WS-CORRESP-NOTICE                      
P00599                           WS-CORRESP-VAR                         
P00599                           WS-MISC-PROCESSING-VARS                
P00599                           WS-KR125-COMM-DATA-VARS                
P00599                           WS-KR125-MNT-TRANS-VARS                
P00599                           ABEND-FILE                             
P00599                           WS-CWS350-MISC                         
P00599                           WS-CORRESP-COMM-VAR                    
P00599                           RS-KR125-RETURN-CODE.                  
P00599                                                                  
P00599     IF ABEND-FUNCTION  > SPACES                                  
P00599        MOVE ABEND-SQLCODE           TO RS-RETURN-CODE            
P00599                                        WS-ACTIVE-RETURN-CODE     
P00599        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P00599     END-IF.                                                      
P00599                                                                  
P00599 5000-EXIT.                                                       
      *****************************************************************         
      ** 6010-REDUCE-EMBEDDED-SPACES .                               **         
      *****************************************************************         
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7005-OPEN-CURSOR                                               *        
      *  OPENS THE CURSOR ESCHEATMENT                                  *        
      *                                                                *        
      ******************************************************************        
       7005-OPEN-CURSOR.                                                
      *                                                                         
           EXEC SQL                                                     
              OPEN ESCHEATMENT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y' TO WS-OPEN-CURSOR-SW                             
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA694 PROCESSING ERROR'                   
              DISPLAY '**  PARAGRAPH = 7005-OPEN-CURSOR'                
              DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7010-FETCH-CURSOR.                                           *        
      *        FETCHES ROW FROM ACCT & REFUND FOR CORRESPONDING ACCT   *        
      *        NUMBERS.                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
              FETCH ESCHEATMENT_CSR                                     
               INTO :AT-ACCOUNT-NO,                                     
T28025              :AT-CUSTOMER-NO,                                    
T28025              :AT-PREMISE-NO,                                     
                    :AT-ADDRESS-ID,                                     
T32660              :AT-ADDRESS-FORMAT,                                 
                    :AT-COMPANY-NO,                                     
P00599              :AT-LOCAL-OFFICE,                                   
                    :RN-REFUND-CHECK-NO,                                
                    :RN-AMT-REFUNDED,                                   
                    :RN-DATE-REFUNDED,                                  
                    :RN-CHECK-STATUS-CD,                                
C37112              :WS-REGULATED-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-ROWS                             
              ELSE                                                      
                 DISPLAY '*************************************'        
                 DISPLAY '** PCSCA694 PROCESSING ERROR'                 
                 DISPLAY '** PARAGRAPH = 7010-FETCH-CURSOR'             
                 DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '** PROCESSING TERMINATED'                     
                 DISPLAY '*************************************'        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7015-CLOSE-CURSOR.                                           *        
      *        CLOSES CURSOR ESCHEATMENT_CSR                           *        
      *                                                                *        
      ******************************************************************        
       7015-CLOSE-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
               CLOSE ESCHEATMENT_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA694 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7015-CLOSE-CURSOR'               
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
T27597*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-GET-COMPANY-DESC                                    **          
      **      SELECTS COMPANY NAME FROM CSS_COMPANY USING COMPANY   **          
      **      NO FROM ROW FETCHED FROM CSS_ACCOUNT.                 **          
      ****************************************************************          
      *                                                                         
       7100-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
                 INTO :C7-COMPANY-NAME                                  
                 FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
                WHERE COMPANY_NO = :C7-COMPANY-NO                       
A03866                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C7-COMPANY-NAME TO P-RPT-CO-NAME-1                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '*************************************'       
                  DISPLAY '** PCSCA694 PROCESSING ERROR'                
                  DISPLAY '** PARAGRAPH = 7100-GET-COMPANY-DESC'        
                  DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY '** PROCESSING TERMINATED'                    
                  DISPLAY '*************************************'       
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09720100
                                                                        
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7590-UPDATE-JOB-PARM-TABLE.                                  *  09749500
      *     INCREMENTS YEAR ON JOB PARM TABLE FOR START DATE AND END *  09749600
      *     DATE.                                                    *  09749700
      *                                                              *  09749800
      ****************************************************************  09749900
      *                                                                 09750000
       7590-UPDATE-JOB-PARM-TABLE.                                      
                                                                        
           ADD 1 TO WS-BEGIN-DATE-YR-R.                                 
           ADD 1 TO WS-END-DATE-YR-R.                                   
           MOVE WS-JOB-PARM-DATA TO G6-PARM-DATA.                       
           MOVE 'PARM' TO G6-CMND-CODE.                                 
           MOVE 0001 TO G6-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                SET PARM_DATA    = :G6-PARM-DATA                        
T27271        WHERE COMPANY_NO   = :WS-SYSIN-COMP-NO                    
                AND PROGRAM_NAME = :PROGRAM-NAME                        
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND SEQ_NO       = :G6-SEQ-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA694 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7590-UPDATE-JOB-PARM-TABLE'      
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ** TO GET COMMON DATE FROM JOB PARM                            **         
      *                                                                         
                                                                        
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8000-PRINT-HDR-694-1.                                        *        
      *   IT WRITES THE REPORT 1 HEADERS WHEN EVER THERE IS CHANGE IN  *        
      *   COMPANY NO.                                                  *        
      ******************************************************************        
       8000-PRINT-HDR-694-1.                                            
      *                                                                         
C37112     IF CSR-DATABASE                                              
             MOVE 'PCSCA694-1' TO P-RPT-PGRMNAME-1                      
C37112     ELSE                                                         
C37112        IF SEB-DATABASE                                           
C37112          IF WS-DEREG-REG = SPACES                                
C37112             MOVE 'PCSCA694-1' TO P-RPT-PGRMNAME-1                
C37112          ELSE                                                    
C37112             MOVE 'PCSCA694-2' TO P-RPT-PGRMNAME-1                
C37112          END-IF                                                  
C37112        END-IF                                                    
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-1                       
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-2                       
                 AFTER ADVANCING 1 LINE.                                
           ADD +1 TO WS-RPT1-PAGE-NO.                                   
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-3                       
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-4                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-11                  
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-12                  
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT1-LINE-NO.                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    WRITES NO-DATA-LINE IN REPORT IF NO RECORDS ARE FETCHED.             
      ******************************************************************        
      *                                                                         
       8300-NO-DATA-PARA.                                               
      *                                                                         
           PERFORM 8000-PRINT-HDR-694-1 THRU 8000-EXIT.                 
           WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER                
                 ADVANCING 2 LINES.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08080000
      ****************************************************************  08090000
      **   8400-MOVE-PRINT-FIELDS.                                  **          
      **       MOVES THE DETAILS INTO THE PRINT FIELDS.             **          
      ****************************************************************          
      *                                                                         
       8400-MOVE-PRINT-FIELDS.                                          
      *                                                                         
           MOVE RN-REFUND-CHECK-NO TO P-RPT1-CHK-NUMB.                  
           MOVE RN-DATE-REFUNDED TO  WS-DATE-T1.                        
           MOVE WS-DATE-T1-MM TO WS-DATE-T2-MM.                         
           MOVE WS-DATE-T1-DD TO WS-DATE-T2-DD.                         
           MOVE WS-DATE-T1-YYYY TO WS-DATE-T2-YYYY.                     
           MOVE WS-DATE-T2 TO P-RPT1-ISS-DATE.                          
           MOVE RN-AMT-REFUNDED TO P-RPT1-CHK-AMT.                      
           PERFORM 8550-MOVE-STATUS-CODE-DESCR THRU 8550-EXIT.          
           MOVE AT-ACCOUNT-NO TO P-RPT1-ACCT-NUMB.                      
           IF WS-ACCOUNT-NAME = SPACES                                  
              MOVE WS-CUSTOMER-NAME TO P-RPT1-CUST-NAME                 
           ELSE                                                         
              MOVE WS-ACCOUNT-NAME TO P-RPT1-CUST-NAME                  
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T28025****************************************************************          
T28025**   8500-MOVE-DUE-DILIG-VAR                                  **          
T28025**       POPULATE THE NOTICE VARS AND CALL SCSKR125 TO INSERT **          
T28025**       DILIGENCE LETTERS.                                   **          
T28025****************************************************************          
T28025*                                                                         
T28025 8500-MOVE-DUE-DILIG-VAR.                                         
T28025                                                                  
T28025*                                                                         
P00599     INITIALIZE WS-CORRESP-HDR                                    
P00599                WS-CORRESP-NOTICE                                 
P00599                WS-CORRESP-VAR.                                   
P00599     PERFORM 8525-GET-REPLY-DATE  THRU 8525-EXIT.                 
P00599     IF AT-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                        
P00599        ADD +1                    TO WS-SEQ-NO-COUNT              
P00599     ELSE                                                         
P00599        MOVE ZERO                 TO WS-SEQ-NO-COUNT              
P00599     END-IF.                                                      
P00599     MOVE WS-SEQ-NO-COUNT         TO WS-CORRESP-SEQ-NO.           
P00599     MOVE AT-ACCOUNT-NO           TO WS-NOTICE-ACCOUNT-NO         
P00599                                     WS-PREV-ACCOUNT-NO.          
P00599     MOVE AT-COMPANY-NO           TO WS-CORRESP-COMPANY-NO        
P00599                                     WS-PROCESS-COMPANY-NO.       
P00599     MOVE AT-LOCAL-OFFICE         TO WS-CWS350-LOCAL-OFFICE.      
P00599     MOVE AT-CUSTOMER-NO          TO WS-NOTICE-CUSTOMER-NO.       
P00599     MOVE WS-MESSAGE-NO           TO WS-CORRESP-MSG-ID.           
P00599     MOVE ZEROES                  TO WS-NOTICE-GUARANTOR-ACCT-NO  
P00599                                     WS-CORRESP-THD-PRTY-ID.      
P00599     MOVE SPACES                  TO WS-CORRESP-BARCODE-UNIQUE-ID.
P00599     PERFORM 8650-SELECT-TIMESTAMP    THRU 8650-EXIT              
P00599     MOVE MH-DATE-TRANS           TO WS-CORRESP-CREATE-DT         
P00599                                     WS-COMMON-DATE.              
P00599     MOVE WS-INPUT-DATE           TO WS-CORRESP-STMT-DT.          
P00599     MOVE WS-PGRMNAME             TO WS-CORRESP-CREATED-BY-PGM-ID 
P00599                                  WS-CORRESP-LAST-UPDATE-PGM-ID.  
P00599     MOVE WS-PGRMNAME             TO WS-CALLING-PGM-NAME          
P00599     MOVE RN-AMT-REFUNDED         TO WS-RN-AMT-REFUNDED           
                                           WS-CHK-AMT                   
P00599     MOVE RN-REFUND-CHECK-NO      TO WS-RN-REFUND-CHECK-NO        
                                           WS-CHK-NUM                   
P00599     MOVE WS-WORK-DATE            TO WS-RN-RETURN-DATE            
P00599* MOVE VALUES TO WS-KR125-COMM-DATA-VARS                                  
P00599     INITIALIZE WS-KR125-COMM-DATA-VARS.                          
P00599     MOVE AT-ACCOUNT-NO           TO WS-KR125-COMM-ACCT-NO.       
P00599     MOVE AT-PREMISE-NO           TO WS-KR125-PREMISE-NO.         
P00599     MOVE AT-CUSTOMER-NO          TO WS-KR125-CUSTOMER-NO.        
P00599     MOVE SPACES                  TO WS-KR125-CONTACT-NAME        
P00599                                     WS-KR125-RED-FL-EXP-DT       
P00599                                     WS-KR125-CALL-END-TIME.      
P00599     MOVE 'C'                     TO WS-KR125-COMM-ASSOC-CD.      
P00599     MOVE WS-N                    TO WS-KR125-PSC-COMPL-ID.       
P00599     INITIALIZE WS-INITIAL-COMMENT-TX.                            
P00599     MOVE WS-INITIAL-COMMENT-TX   TO WS-KR125-COMDAT-CMT.         
P00599* MOVE VALUES TO WS-KR125-MNT-TRANS-VARS                                  
P00599     INITIALIZE WS-KR125-MNT-TRANS-VARS.                          
P00599     MOVE AT-ACCOUNT-NO           TO WS-KR125-MNT-ACCOUNT-NO.     
P00599     MOVE 'H'                     TO WS-KR125-CODE-TRAN-TYP.      
P00599     MOVE AT-PREMISE-NO           TO WS-KR125-MNT-PREMISE-NO.     
P00599     MOVE AT-CUSTOMER-NO          TO WS-KR125-MNT-CUSTOMER-NO.    
P00599     MOVE SPACES                  TO WS-KR125-RESP-AREA-ID.       
P00599     MOVE MH-DATE-TRANS           TO WS-KR125-MNT-DATE-TRANS.     
P00599     MOVE WS-TRANS-HIST-MSG       TO WS-KR125-TRAN-CMT-TEXT       
P00599     MOVE +88                     TO WS-KR125-TRAN-CMT-LEN        
P00599     PERFORM 5000-CALL-NOTICES         THRU 5000-EXIT.            
T28025*                                                                         
C37112     IF CSR-DATABASE                                              
T28025        ADD 1 TO WS-ACCOUNT-COUNT                                 
C37112     ELSE                                                         
C37112       IF WS-DEREG-REG = SPACES                                   
C37112          ADD 1 TO WS-ACCT-COUNT-DEREG                            
C37112       ELSE                                                       
C37112          ADD 1 TO WS-ACCT-COUNT-REG                              
C37112       END-IF                                                     
C37112     END-IF.                                                      
T28025                                                                  
T28025 8500-EXIT.                                                       
T28025     EXIT.                                                        
T32660****************************************************************          
T32660**   8510-SELECT-ADDR-FORM.                                   **          
T32660**       SELECT FORMATTED ADDRESS FOR DUE DILIGENCE LETTERS.  **          
T32660****************************************************************          
T32660*                                                                         
T32660 8510-SELECT-ADDR-FORM.                                           
T32660                                                                  
T32660     EXEC SQL                                                     
T32660        SELECT  HOUSE_NO                                          
T32660               ,ADDR_PREFIX_1                                     
T32660               ,ADDR_PREFIX_2                                     
T32660               ,STREET_NAME                                       
T32660               ,STREET_SUFFIX                                     
T32660               ,STREET_LOCATION_1                                 
T32660               ,STREET_LOCATION_2                                 
T32660               ,ADDRESS_OVERFLOW                                  
T32660               ,ZIP_CODE                                          
T32660               ,ZIP_CODE_PLUS_FOUR                                
T32660               ,ZIP_CODE_TOKEN                                    
T32660               ,ADDR_SUFFIX                                       
T32660               ,CARRIER_ROUTE                                     
T32660        INTO    :DY-HOUSE-NO                                      
T32660               ,:DY-ADDR-PREFIX-1                                 
T32660               ,:DY-ADDR-PREFIX-2                                 
T32660               ,:DY-STREET-NAME                                   
T32660               ,:DY-STREET-SUFFIX                                 
T32660               ,:DY-STREET-LOCATION-1                             
T32660               ,:DY-STREET-LOCATION-2                             
T32660               ,:DY-ADDRESS-OVERFLOW                              
T32660               ,:DY-ZIP-CODE                                      
T32660               ,:DY-ZIP-CODE-PLUS-FOUR                            
T32660               ,:DY-ZIP-CODE-TOKEN                                
T32660               ,:DY-ADDR-SUFFIX                                   
T32660               ,:DY-CARRIER-ROUTE                                 
T32660        FROM    CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
T32660        WHERE   ADDRESS_ID                = :WS-ADDRESS-ID        
T32660        AND     ADDR_USAGE_CD             = 'F'                   
A03866                                                           
A03866                                                      
T32660     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,CARRIER_ROUTE                                             
MFA-TR*       INTO    :DY-HOUSE-NO                                              
MFA-TR*              ,:DY-ADDR-PREFIX-1                                         
MFA-TR*              ,:DY-ADDR-PREFIX-2                                         
MFA-TR*              ,:DY-STREET-NAME                                           
MFA-TR*              ,:DY-STREET-SUFFIX                                         
MFA-TR*              ,:DY-STREET-LOCATION-1                                     
MFA-TR*              ,:DY-STREET-LOCATION-2                                     
MFA-TR*              ,:DY-ADDRESS-OVERFLOW                                      
MFA-TR*              ,:DY-ZIP-CODE                                              
MFA-TR*              ,:DY-ZIP-CODE-PLUS-FOUR                                    
MFA-TR*              ,:DY-ZIP-CODE-TOKEN                                        
MFA-TR*              ,:DY-ADDR-SUFFIX                                           
MFA-TR*              ,:DY-CARRIER-ROUTE                                         
MFA-TR*       FROM    CSS_ADDR_FORMATTED                                        
MFA-TR*       WHERE   ADDRESS_ID                = :WS-ADDRESS-ID                
MFA-TR*       AND     ADDR_USAGE_CD             = 'F'                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8510                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32660                                                                  
T32660     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T32660                                                                  
T32660     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T32660        NEXT SENTENCE                                             
T32660     ELSE                                                         
T32660        DISPLAY '*************************************'           
T32660        DISPLAY '** PCSCA694 PROCESSING ERROR'                    
T32660        DISPLAY '** PARAGRAPH = 8510-SELECT-ADDR-FORM'            
T32660        DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
T32660        DISPLAY '** PROCESSING TERMINATED'                        
T32660        DISPLAY '*************************************'           
T32660        PERFORM 9900-ABEND THRU 9900-EXIT                         
T32660     END-IF.                                                      
T32660                                                                  
T32660 8510-EXIT.                                                       
T32660     EXIT.                                                        
T32660****************************************************************          
T32660**   8515-SELECT-TOWN-ST.                                     **          
T32660**       SELECT TOWN AND STATE FOR DUE DILIGENCE LETTERS.     **          
T32660****************************************************************          
T32660*                                                                         
T32660 8515-SELECT-TOWN-ST.                                             
T32660                                                                  
T32660     EXEC SQL                                                     
T32660        SELECT  TOWN                                              
T32660               ,STATE                                             
T32660        INTO    :A4-TOWN                                          
T32660               ,:A4-STATE                                         
T32660        FROM    CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
T32660        WHERE   ZIP_CODE                  = :WS-ZIP-CODE-FIVE     
T32660        AND     ZIP_CODE_TOKEN            = :WS-ZIP-CODE-TOKEN    
A03866                                                           
A03866                                                      
T32660     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TOWN                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*       INTO    :A4-TOWN                                                  
MFA-TR*              ,:A4-STATE                                                 
MFA-TR*       FROM    CSS_ZIP_CODE                                              
MFA-TR*       WHERE   ZIP_CODE                  = :WS-ZIP-CODE-FIVE             
MFA-TR*       AND     ZIP_CODE_TOKEN            = :WS-ZIP-CODE-TOKEN            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8515                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32660                                                                  
T32660     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T32660                                                                  
T32660     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T32660        NEXT SENTENCE                                             
T32660     ELSE                                                         
T32660        DISPLAY '*************************************'           
T32660        DISPLAY '** PCSCA694 PROCESSING ERROR'                    
T32660        DISPLAY '** PARAGRAPH = 8515-SELECT-TOWN-ST'              
T32660        DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
T32660        DISPLAY '** PROCESSING TERMINATED'                        
T32660        DISPLAY '*************************************'           
T32660        PERFORM 9900-ABEND THRU 9900-EXIT                         
T32660     END-IF.                                                      
T32660                                                                  
T32660 8515-EXIT.                                                       
T32660     EXIT.                                                        
      *                                                                         
T28025****************************************************************          
T28025**   8525-GET-REPLY-DATE                                      **          
T28025**       ADD 60 DAYS TO CURRENT DATE TO GET REPLY DATE FOR    **          
T28025**       DUE DILIGENCE LETTERS.                               **          
T28025****************************************************************          
T28025*                                                                         
T28025 8525-GET-REPLY-DATE.                                             
T28025                                                                  
T28025     EXEC SQL                                                     
T28025        SELECT DATEADD( DAY, 60, IIF(TRY_CONVERT(DATE, 
                                                          :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ) )                      
T28025       ,REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')                                        
T28025       ,CAST(SYSDATETIMEOFFSET() AS DATE)                                 
T28025          INTO :WS-WORK-DATE                                      
T28025              ,:WS-CURRENT-TIMESTAMP                              
T28025              ,:WS-DATE-TRANS                                     
T28025          FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
A03866                                                           
A03866                                                      
T28025     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-TEMP-DATE) + 60 DAYS                              
MFA-TR*      ,CURRENT TIMESTAMP                                                 
MFA-TR*      ,CURRENT DATE                                                      
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*             ,:WS-CURRENT-TIMESTAMP                                      
MFA-TR*             ,:WS-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 8525                                                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
T28025                                                                  
T28025 8525-EXIT.                                                       
T28025     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8550-MOVE-STATUS-CODE-DESCR                              **          
      **       MOVES THE STATUS CODE DESCRIPTION TO OUTPUT FIELD.   **          
      ****************************************************************          
      *                                                                         
       8550-MOVE-STATUS-CODE-DESCR.                                     
                                                                        
           EVALUATE RN-CHECK-STATUS-CD                                  
               WHEN 'A'                                                 
                   MOVE 'APPROVED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'C'                                                 
                   MOVE 'CANCELLED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'D'                                                 
                   MOVE 'DISAPPROVED   ' TO P-RPT1-CHECK-STATUS         
               WHEN 'E'                                                 
                   MOVE 'SENT FOR ESCHE' TO P-RPT1-CHECK-STATUS         
               WHEN 'F'                                                 
                   MOVE 'FORGED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'I'                                                 
                   MOVE 'ISSUED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'L'                                                 
                   MOVE 'CLEARED       ' TO P-RPT1-CHECK-STATUS         
               WHEN 'M'                                                 
                   MOVE 'REMAILED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'R'                                                 
                   MOVE 'REQUESTED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'S'                                                 
                   MOVE 'STOP PAYMENT  ' TO P-RPT1-CHECK-STATUS         
               WHEN 'T'                                                 
                   MOVE 'ESCHEATED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'U'                                                 
                   MOVE 'UNDELIVERABLE ' TO P-RPT1-CHECK-STATUS         
               WHEN 'X'                                                 
                   MOVE 'VOIDED        ' TO P-RPT1-CHECK-STATUS         
           END-EVALUATE.                                                
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T28025****************************************************************          
T28025**   8600-LOAD-MNT.                                           **          
T28025**       MOVES THE DETAILS INTO THE HOST-VARIABLES OF         **          
T28025**       CSS_MNT_TRANS_HIST.                                  **          
T28025****************************************************************          
T28025*                                                                         
T31496 8600-LOAD-MNT.                                                   
T28025                                                                  
T31496     MOVE WS-CORRESP-CREATE-DT TO MI-TRANS-HIST-SEQ-NO.           
T31496     MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
T31496     MOVE SPACES TO MI-TABLE-ID.                                  
T31496     MOVE 'DUE DLGNCE LTR' TO MI-COLUMN-DESC.                     
T31496     MOVE +14 TO MI-CHG-COLUMN-VALUE-LEN.                         
T31496     MOVE MH-DATE-TRANS TO MI-CHG-COLUMN-VALUE-TEXT.              
T31496     MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN.                          
T31496     MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT.                    
T31496*                                                                         
T28025 8600-EXIT.                                                       
T28025     EXIT.                                                        
T31496*                                                                         
T31496************************************************************              
T31496**  8650-SELECT-TIMESTAMP.                                **              
T31496**      GET CURRENT DATE AND TIME.                        **              
T31496************************************************************              
T31496*                                                                         
T31496 8650-SELECT-TIMESTAMP.                                           
T31496                                                                  
T31496     EXEC SQL                                                     
T31496        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
T31496              ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
T31496          INTO :MH-TRANS-HIST-SEQ-NO                              
T31496              ,:MH-DATE-TRANS                                     
T31496          FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
A03866                                                           
A03866                                                      
                                                                        
T31496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP                                          
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8650                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31496                                                                  
T31496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31496                                                                  
T31496     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T31496        NEXT SENTENCE                                             
T31496     ELSE                                                         
T31496        DISPLAY '*************************************'           
T31496        DISPLAY '** PCSCA694 PROCESSING ERROR'                    
T31496        DISPLAY '** PARAGRAPH = 8650-SELECT-TIMESTAMP'            
T31496        DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
T31496        DISPLAY '** PROCESSING TERMINATED'                        
T31493        DISPLAY '*************************************'           
T31496        PERFORM 9900-ABEND THRU 9900-EXIT                         
T31496     END-IF.                                                      
T31496                                                                  
T31496 8650-EXIT.                                                       
T31496     EXIT.                                                        
T28025*                                                                         
T28025************************************************************              
T31496**  8800-LOAD-MNT-TRANS-HIST.                             **              
T31496**      INSERTS THE RECORDS IN TO THE CSS_MNT_TRANS_HIST  **              
T31496**      AND THE CSS_MT_TRN_HST_DET TABLES.                **              
T31496************************************************************              
T31496*                                                                         
T31496 8800-LOAD-MNT-TRANS-HIST.                                        
T31496*                                                                         
T31496     PERFORM 8820-INSERT-MT-TRN-HST-DET THRU 8820-EXIT.           
T31496*                                                                         
T31496 8800-EXIT.                                                       
T31496     EXIT.                                                        
T31496*                                                                         
T31496************************************************************              
T31496**  8820-INSERT-MT-TRN-HST-DET.                           **              
T31496**      INSERTS THE RECORDS IN TO THE CSS_MT-TRN-HST-DET  **              
T31496**      TABLE.                                            **              
T31496************************************************************              
T31496*                                                                         
T31496 8820-INSERT-MT-TRN-HST-DET.                                      
T31496*                                                                         
T31496                                                                  
T31496     EXEC SQL                                                     
T31496         INSERT INTO CSS_MT_TRN_HST_DET                           
T31496              (TRANS_HIST_SEQ_NO                                  
T31496              ,TRAN_APPL_NO                                       
T31496              ,COLUMN_DESC                                        
T31496              ,PRV_COLUMN_VALUE                                   
T31496              ,CHG_COLUMN_VALUE                                   
T31496              ,TABLE_ID)                                          
T31496          VALUES                                                  
T31496              (CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                  
T31496              ,:MI-TRAN-APPL-NO                                   
T31496              ,:MI-COLUMN-DESC                                    
T31496              ,:MI-PRV-COLUMN-VALUE                               
T31496              ,:MI-CHG-COLUMN-VALUE                               
T31496              ,:MI-TABLE-ID)                                      
T31496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*             (TRANS_HIST_SEQ_NO                                          
MFA-TR*             ,TRAN_APPL_NO                                               
MFA-TR*             ,COLUMN_DESC                                                
MFA-TR*             ,PRV_COLUMN_VALUE                                           
MFA-TR*             ,CHG_COLUMN_VALUE                                           
MFA-TR*             ,TABLE_ID)                                                  
MFA-TR*         VALUES                                                          
MFA-TR*             (:MI-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:MI-TRAN-APPL-NO                                           
MFA-TR*             ,:MI-COLUMN-DESC                                            
MFA-TR*             ,:MI-PRV-COLUMN-VALUE                                       
MFA-TR*             ,:MI-CHG-COLUMN-VALUE                                       
MFA-TR*             ,:MI-TABLE-ID)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31496                                                                  
T31496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T31496     OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T31496        NEXT SENTENCE                                             
T31496     ELSE                                                         
T31496        DISPLAY '*************************************'           
T31496        DISPLAY '** PCSCA694 PROCESSING ERROR'                    
T31496        DISPLAY '** PARAGRAPH = 8820-INSERT-MT-TRN-HST-DET'       
T31496        DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
T31496        DISPLAY '** PROCESSING TERMINATED'                        
T31496        DISPLAY '*************************************'           
T31496        PERFORM 9900-ABEND            THRU 9900-EXIT              
T31496     END-IF.                                                      
T31496*                                                                         
T31496 8820-EXIT.                                                       
T31496     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8900-WRITE-FCSPT33                                           *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8900-WRITE-FCSPT33.                                              
      *                                                                         
           IF WS-RPT1-LINE-NO > 50                                      
              PERFORM 8000-PRINT-HDR-694-1 THRU 8000-EXIT               
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-PRINT-REP-DET-11                  
                 AFTER  ADVANCING 1 LINE.                               
           ADD 1 TO WS-RPT1-LINE-NO.                                    
           ADD RN-AMT-REFUNDED TO WS-GRAND-TOTAL-AMOUNT-1.              
           ADD 1 TO WS-GRAND-TOTAL-NUMBER-1.                            
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   9000-SEND-ERROR-RESULT.                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   9000-TERMINATE.                                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           IF CSR-DATABASE                                              
             IF WS-GRAND-TOTAL-NUMBER-1 NOT = 0                         
                MOVE WS-GRAND-TOTAL-NUMBER-1 TO WS-PRT-GRAND-NUMBER     
                MOVE WS-GRAND-TOTAL-AMOUNT-1 TO WS-PRT-GRAND-AMOUNT     
                WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS             
                      AFTER ADVANCING 3 LINES                           
                INITIALIZE WS-PRT-GRAND-TOTALS                          
             END-IF                                                     
           ELSE                                                         
C37112        IF SEB-DATABASE                                           
C37112          IF PRINT-REG-HDR                                        
C37112            NEXT SENTENCE                                         
C37112          ELSE                                                    
C37112            IF WS-GRAND-TOTAL-NUMBER-1 NOT = 0                    
C37112              MOVE WS-GRAND-TOTAL-NUMBER-1 TO WS-PRT-GRAND-NUMBER 
C37112              MOVE WS-GRAND-TOTAL-AMOUNT-1 TO WS-PRT-GRAND-AMOUNT 
C37112              WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS         
C37112                   AFTER ADVANCING 3 LINES                        
C37112              INITIALIZE WS-PRT-GRAND-TOTALS                      
C37112            END-IF                                                
C37112          END-IF                                                  
C37112        END-IF                                                    
           END-IF.                                                      
                                                                        
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE                     
                 AFTER ADVANCING 3 LINES.                               
                                                                        
           IF CURSOR-OPEN                                               
                 PERFORM 7015-CLOSE-CURSOR THRU 7015-EXIT               
T27597     END-IF.                                                      
                                                                        
           CLOSE FCSPT33-FILE.                                          
C37112     IF CSR-DATABASE                                              
T28025        DISPLAY 'ACCOUNTS PROCESSED = ' WS-ACCOUNT-COUNT          
C37112     ELSE                                                         
C37112         DISPLAY 'DEREG ACCOUNTS PROCESSED = ' WS-ACCT-COUNT-DEREG
C37112         DISPLAY 'REG ACCOUNTS PROCESSED = ' WS-ACCT-COUNT-REG    
C37112     END-IF.                                                      
      *                                                                         
T28025     IF RETURN-CODE = +12                                         
T28025        GO TO 9000-EXIT                                           
T28025     END-IF.                                                      
T28025*                                                                         
C37112     IF CSR-DATABASE                                              
T28025       IF WS-ACCOUNT-COUNT = 0                                    
T28025        MOVE +2 TO RETURN-CODE                                    
T28025        DISPLAY '*******************************************'     
T28025        DISPLAY '*****         9000-TERMINATE         ******'     
T28025        DISPLAY '*******************************************'     
T28025        DISPLAY 'NO DUE DILIGENCE LETTERS WILL'                   
T28025        DISPLAY ' BE CREATED.'                                    
T28025        DISPLAY '*******************************************'     
C37112       END-IF                                                     
C37112     ELSE                                                         
C37112       IF SEB-DATABASE                                            
C37112        IF WS-ACCT-COUNT-DEREG = 0 OR WS-ACCT-COUNT-REG = 0       
C37112          MOVE +2 TO RETURN-CODE                                  
C37112          DISPLAY '*******************************************'   
C37112          DISPLAY '*****         9000-TERMINATE         ******'   
C37112          DISPLAY '*******************************************'   
C37112         IF WS-ACCT-COUNT-DEREG = 0                               
C37112            DISPLAY 'NO DEREGULATED DUE DILIGENCE LETTERS WILL'   
C37112            DISPLAY ' BE CREATED.'                                
C37112            DISPLAY '*******************************************' 
C37112         END-IF                                                   
C37112         IF WS-ACCT-COUNT-REG = 0                                 
C37112            DISPLAY 'NO REGULATED DUE DILIGENCE LETTERS WILL'     
C37112            DISPLAY ' BE CREATED.'                                
C37112            DISPLAY '*******************************************' 
C37112         END-IF                                                   
C37112        END-IF                                                    
C37112       END-IF                                                     
T28025     END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * TO GET TODAY'S DATE FROM JOB PARM TABLE                                 
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
      * TO GET NAME AND MAIL OR SERVICE ADDRESS                                 
      *                                                                         
                                                                        
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
      *                                                                         
      * 9700-PROCESS-ABEND.                                                     
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      **      THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
