       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA693.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **              P R O G R A M S U M M A R Y                    **         
      **                                                             **         
      **                                                             **         
      **         F U N C T I O N A L   D E S C R I P T I O N         **         
      **                         O F   M O D U L E                   **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  PRINTS REPORTS CA693-1 & CA693-2.                          **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  ESCHEATMENT IS USED FOR THE CHECKS THAT HAVE BEEN REFUNDED **         
      **  TO AN ACCOUNT, BUT NEVER CASHED OUT, COMPONENT CA693 WILL  **         
      **  RUN THROUGH THE DB2 ONCE TWICE EVERY YEAR ON OCT 15 & MAY  **         
      **  15 TO COLLECT INFO ON ALL THE REFUNDED CHECKS THAT ARE AT  **         
      **  LEAST ONE YEAR OLD AND READY TO SET TO ESCHEATMENT.  THE   **         
      **  PROGRAM GENERATED TWO REPORTS, CA693-1 AND CA693-2.        **         
      **  CA693-1 LISTS ALL CHECKS SET TO ESCHEATMENT, AND CA693-2   **         
      **  LISTS ALL CHECKS SET TO ESCHEATMENT WITH AN AMOUNT >= $25. **         
      ****************************************************************          
      **                                                             **         
      **             PROGRAM  MODIFICATION  LOG                      **         
      **                                                             **         
      **   DATE    INITIALS     REASON                               **         
      **   ----    --------     ------                               **         
      **   02/26/96   HAG       INITIAL VERSION                      **         
      **   06/18/96   ELJ       TPR 4620. DECLARE STATEMENT IS USING **         
      **                        THE WRONG VALUES FOR CODE_ACCT_STATUS**         
      **                        FOR FINAL AND INACTIVE STATUS. ALSO  **         
      **                        IF 0100-INTILIZATION PARGRAPH FAILS  **         
      **                        THE PROGRAM SHOULD NOT TRY AND CLOSE **         
      **                        ANY CURSORS.                         **         
      **   07/02/96   HAG       TPR 4813. UPDATE REFUND_STATUS_DT    **         
      **                        WITH CURRENT DATE WHENEVER THE REFUND**         
      **                        TABLE IS UPDATED.                    **         
TP5109**   08/08/96   CSG       TPR 5109. ADD CPD0023B TO USE WITH   **         
      **                         CPD00074.                           **         
TP5327**  09/02/96    CDS       TPR 5327 ADD RS-RETURN-CODE-DISP.    **         
BB0903**  09/03/97    BAB       SEVERAL MODIFICATIONS WERE NECESSARY **         
      **                        IN ORDER TO CORRECTLY JOURNAL:       **         
      **                        1.GL NEUMONICS WERE USED TO RETRIEVE **         
      **                          THE GL NUMBERS                     **         
      **                        2.THE AMOUNTS SHOULD BE ACCUMULATED  **         
      **                          CORRECTLY TO POST TO THE JRNL CNTRL**         
      **                        3.THE CONTROL WILL BE INSERTED AND   **         
      **                          SELECTED ONLY ONCE                 **         
      **                        4.THE CONTROL WILL BE UPDATED ONLY   **         
      **                          AFTER ALL THE RECORDS HAVE BEEN    **         
      **                          PROCESSED                          **         
PCR640**  07/01/98    KLP        ADDED LOGIC TO CHECK FOR AR-LOCKOUT**          
T19412**  03/15/99    CAD        PROGRAM PULLING COMMONDATE INSTEAD  **         
T19412**                         OF COMMON. THIS RUNS BEFORE BILLING **         
T19412**                         SO COMMON SHOULD BE USED.           **         
T19528**  03/25/99    BM         Y2K CHANGES                         **         
T20186**  09/08/00    CB18344    MADE ESCHEATMENT CHANGES NEEDED FOR **         
T20186**                         CSR.                                **         
T20186**  09/11/00    CB18344    REMOVED LINE THAT EXCLUDED ACCTS    **         
T20186**                         THAT HAVE BEEN WRITTEN OFF.         **         
T23643**  06/22/01    BK88121    FOR MULTICOMPANY CHANGES, COMPANY   **         
T23643**                         NUMBER INCLUDED JOB_PARM TABLE      **         
T27271**  08/17/02    COVANSYS   CHANGED LOGIC FOR THE UPDATE OF     **         
T27271**              CHENNAI    CSS_JOB_PARM FOR MULTI-COMPANY      **         
C26474**  10/24/02    SS82048    INCLUDE ESCHEATED CHECKS IN THE     **         
      **                         POSITIVE PAY FILE SENT TO THE BANK  **         
      **                         WITH VOID-INDICATOR AS 'V'          **         
C29199**  09/03/03    CB18344    CHANGED WACHOVIA ACCOUNT NUMBER DUE **         
C29199**                         TO MERGER WITH FIRST UNION.         **         
T27597**  04/04/2005  CB18344    CHANGED PROGRAM TO SELECT ONLY      **         
T27597**                         DEREGULATED ACCOUNTS WHEN RUNNING IN**         
T27597**                         SEB.                                **         
C37112**  03/14/2008  RC41079    CHANGED PROGRAM TO ALSO PROCESS     **         
C37112**                         REGULATED ACCOUNTS WHEN RUNNING IN  **         
C37112**                         SEB.  CREATES REGULATED AND DEREGU- **         
C37112**                         LATED REPORTS FOR CA693-1 AND CA693-**         
C37112**                         2.                                  **         
C35809**  07/09/2008  RC41079    ADDED A CHECK FOR ESCHEATEMENT_CD   **         
C35809**                         NOT EQUAL TO 'U' IN THE WHERE       **         
C35809**                         CLAUSE OF THE ESCHEATMENT_CSR       **         
C35809**                         CURSOR.  RAN IN SEPT. FOR CHECKS    **         
C35809**                         THAT ARE ONE YEAR OLD THAT WILL BE  **         
C35809**                         SENT TO THE STATE OF GEORGIA.       **         
C35809**                                                             **         
C35809**  09/30/2008  RC41079    ADDED CODE TO ONLY WRITE 'FOR THE   **         
C35809**                         STATE OF GEORGIA' IN THE TITLE IF   **         
C35809**                         SEB-DATABASE.                       **         
C35809**  11/10/2008  RC41079    REMOVED STATEMENT AT.LOCAL_OFFICE = **         
C35809**                         = RN.LOCAL_OFFICEFROM CURSOR.       **         
C35809**  11/14/2008  RC41079    REMOVED STATEMENT RN.DATE_REFUNDED  **         
C35809**                         <= :WS-BEGIN-DATE-DATA FROM CURSOR. **         
C35809**  10/05/2009  RC41079    REMOVED * FROM PERFORM 7500-UPDATE- **         
C35809**                         CSS-REFUND LINE OF CODE.            **         
C35809**  05/03/2010  RC41079    REMOVED * FROM PERFORM 7590-UPDATE- **         
C35809**                         JOB-PARM TABLE LINE OF CODE.        **         
      **                                                             **         
ACT067**  22 MAR 2011 RF10596    ADD LOCAL OFFICE TO REPORTS         **         
      **  APPL003082             ADD WITH UR AND QUERYNO             **         
      *****************************************************************         
      *                                                                         
      *             ---- BASIC SEQUENCE STRUCTURE ----                          
      *         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION            
      *         1000 - 1999     INPUT PROCESSING CONTROL PATH                   
      *         2000 - 2999     OUTPUT PROCESSING CONTROL PATH                  
      *         3000 - 4999     BATCH PROCESSING MODULES - NOT USED             
      *         5000 - 5999     COMMON PROGRAM MODULES                          
      *         6000 - 6999     COMMON SYSTEM MODULES                           
      *         7000 - 7999     INPUT MODULES                                   
      *         8000 - 8999     OUTPUT MODULES                                  
      *         9000 - 9799     TERMINATION MODULES                             
      *         9800 - 9899     XCTLS TO PROGRAMS                               
      *         9900 - 9999     ABEND/ABORT MODULES                             
      *    EJECT                                                                
      *    ---- ------------------------- ------------------------------        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
       COPY CSSPT33 REPLACING  FCSPT33-FILE BY FCSPT33A-FILE,                   
                               UT-S-FCSPT33 BY UT-S-FCSPT33A.                   
T20186 COPY CSSRP693.                                                           
C26474* NEW FILES OF ESCHEATED CHECKS TO BE SENT TO BANKS.                      
C26474 COPY CSSCA95.                                                            
C26474 COPY CSSCA96.                                                            
C26474 COPY CSSCA97.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
       COPY CFDPT33 REPLACING FCSPT33-FILE BY FCSPT33A-FILE,                    
                              PRT33-RECORD BY PRT33A-RECORD.                    
T20186 COPY CFDRP693.                                                           
T20186 COPY FIORP693.                                                           
C26474* NEW FILES OF ESCHEATED CHECKS TO BE SENT TO BANKS.                      
C26474 COPY CFDCA95.                                                            
C26474 COPY FIOCA95.                                                            
C26474 COPY CFDCA96.                                                            
C26474 COPY FIOCA96.                                                            
C26474 COPY CFDCA97.                                                            
C26474 COPY FIOCA97.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA693'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA693 STARTS HERE'.            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *                                                                         
      *  WORKING STORAGE FOR REPORT HEADER.                                     
      *                                                                         
       COPY CWS00079.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      ** INCLUDE CWS00061 FOR GL NEUMONICS                                      
BB0903 COPY CWS00061.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
      * FOR NAME AND ADDRESS                                                    
       COPY CWS00074.                                                           
      *                                                                         
TP5109* FOR DB2 ABEND VARIABLES                                                 
TP5109 COPY CWS00010.                                                           
      *                                                                         
      * FOR REDUCING EMBEDDED SPACES                                            
       COPY CWS00011.                                                           
      *                                                                         
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      *                                                                         
      * WORKING STORAGE FOR BATCH JOURNAL ROUTINE.                              
       COPY CJF00101.                                                           
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-STAT-UPT-DT.                                              
           05  WS-UPT-CC               PIC X(02).                       
           05  WS-UPT-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-UPT-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-UPT-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-D10-DD               PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
T20186 01  WS-JOB-PARM-DATA.                                            
T20186     05  WS-BEGIN-DATE-MSSG      PIC X(13).                       
T20186     05  WS-BEGIN-DATE-DATA      PIC X(10).                       
T20186     05  WS-BEGIN-DATE-R REDEFINES WS-BEGIN-DATE-DATA.            
T20186         10  WS-BEGIN-DATE-YR-R  PIC 9(4).                        
T20186         10  FILLER              PIC X(1).                        
T20186         10  WS-BEGIN-DATE-MM-R  PIC 9(2).                        
T20186         10  FILLER              PIC X(1).                        
T20186         10  WS-BEGIN-DATE-DD-R  PIC 9(2).                        
T20186     05  FILLER                  PIC X(17).                       
T20186     05  WS-END-DATE-MSSG        PIC X(11).                       
T20186     05  WS-END-DATE-DATA        PIC X(10).                       
T20186     05  WS-END-DATE-R REDEFINES WS-END-DATE-DATA.                
T20186         10  WS-END-DATE-YR-R    PIC 9(4).                        
T20186         10  FILLER              PIC X(1).                        
T20186         10  WS-END-DATE-MM-R    PIC 9(2).                        
T20186         10  FILLER              PIC X(1).                        
T20186         10  WS-END-DATE-DD-R    PIC 9(2).                        
T20186     05  FILLER                  PIC X(19).                       
      *                                                                 01362500
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA693'.   
TP5109     05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA693'.   
           05  WS-HYPHEN               PIC X(01)    VALUE '-'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-H                    PIC X(01)    VALUE 'H'.          
      *                                                                         
T23643 01  WS-COMPANY-NUMBER           PIC X(02).                       
T23643     88 VALID-COMPANY                         VALUE '01' '26'.    
      *                                                                         
       01 WS-SWITCHES.                                                  
4620       05 WS-OPEN-CURSOR-SW        PIC X(01)    VALUE 'N'.          
4620          88 CURSOR-OPEN                        VALUE 'Y'.          
4620          88 CURSOR-NOT-OPEN                    VALUE 'N'.          
T20186     05 WS-FRP693-STATUS         PIC X(02).                       
T20186        88 FRP693-SUCCESSFUL                  VALUE '00'.         
C26474     05  WS-FCA95-STATUS         PIC X(02)    VALUE SPACES.       
C26474         88 FCA95-SUCCESSFUL                  VALUE '00'.         
C26474     05  WS-FCA96-STATUS         PIC X(02)    VALUE SPACES.       
C26474         88 FCA96-SUCCESSFUL                  VALUE '00'.         
C26474     05  WS-FCA97-STATUS         PIC X(02)    VALUE SPACES.       
C26474         88 FCA97-SUCCESSFUL                  VALUE '00'.         
C26474     05  WS-DATA-FOUND-FL        PIC X(01)    VALUE SPACES.       
C26474         88 WS-DATA-FOUND                     VALUE 'Y'.          
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT1-PAGE-NO             PIC 9(04)    VALUE 0.            
       01  WS-RPT2-LINE-NO             PIC 9(02)    VALUE 0.            
       01  WS-RPT2-PAGE-NO             PIC 9(04)    VALUE 0.            
      *                                                                         
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADERS        **          
      ****************************************************************          
      *                                                                         
T20186 01  WS-HEADING-LINES.                                            
T20186     05  WS-RPT-TITLE-1.                                          
T20186         10  P-RPT-PGRMNAME-1    PIC X(10).                       
               10  FILLER              PIC X(50)    VALUE SPACES.       
T20186         10  P-RPT-CO-NAME-1     PIC X(26).                       
               10  FILLER              PIC X(27)    VALUE SPACES.       
T20186         10  FILLER              PIC X(11)    VALUE               
T20186                                'RUN DATE: '.                     
T20186         10  P-RPT-RUN-DATE-1    PIC X(08).                       
T20186*                                                                         
T20186     05  WS-RPT-TITLE-2.                                          
T20186         10  FILLER              PIC X(06)    VALUE               
T20186                                'DATE: '.                         
T20186         10  P-RPT-TRAN-DATE     PIC X(08).                       
T20186         10  FILLER              PIC X(34)    VALUE SPACES.       
T20186         10  FILLER              PIC X(36)    VALUE               
T20186         'TREASURER''S ''A'' CHECK RECONCILIATION'.               
T20186         10  FILLER              PIC X(29)    VALUE SPACES.       
T20186         10  FILLER              PIC X(11)    VALUE               
T20186                                'RUN TIME:  '.                    
T20186         10  P-RPT-RUN-TIME      PIC X(08).                       
T20186*                                                                         
C35809     05  WS-RPT-TITLE-2B.                                         
C35809         10  FILLER              PIC X(54)    VALUE SPACES.       
C35809         10  FILLER              PIC X(23)    VALUE               
C35809         'FOR THE STATE OF GEOGIA'.                               
T20186*                                                                         
T20186     05  WS-RPT-TITLE-3.                                          
T20186         10  FILLER              PIC X(29)    VALUE SPACES.       
C37112         10  DE-REG              PIC X(12)    VALUE SPACES.       
T20186         10  FILLER              PIC X(28)    VALUE               
T20186         'CHECKS SET TO ESCHEATMENT - '.                          
T20186         10  BEG-DATE-MM         PIC X(02)    VALUE SPACES.       
T20186         10  FILLER              PIC X(01)    VALUE '/'.          
T20186         10  BEG-DATE-DD         PIC X(02)    VALUE SPACES.       
T20186         10  FILLER              PIC X(01)    VALUE '/'.          
T20186         10  BEG-DATE-YYYY       PIC X(04)    VALUE SPACES.       
T20186         10  FILLER              PIC X(04)    VALUE ' TO '.       
T20186         10  END-DATE-MM         PIC X(02)    VALUE SPACES.       
T20186         10  FILLER              PIC X(01)    VALUE '/'.          
T20186         10  END-DATE-DD         PIC X(02)    VALUE SPACES.       
T20186         10  FILLER              PIC X(01)    VALUE '/'.          
T20186         10  END-DATE-YYYY       PIC X(04)    VALUE SPACES.       
T20186         10  FILLER              PIC X(20)    VALUE SPACES.       
T20186         10  FILLER              PIC X(06)    VALUE               
T20186                                'PAGE:'.                          
T20186         10  P-RPT-PAGE-NO       PIC ZZ,ZZZ.                      
T20186         10  FILLER              PIC X(07)    VALUE SPACES.       
T20186*                                                                         
T20186     05  WS-RPT-TITLE-4.                                          
T20186         10  FILLER              PIC X(44)    VALUE SPACES.       
T20186         10  FILLER              PIC X(44)    VALUE               
T20186         'LISTING OF ACCOUNTS WITH CHECK AMOUNT >= $25'.          
T20186         10  FILLER              PIC X(44)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-11.                                         
T20186     05  FILLER                  PIC X(09)    VALUE               
T20186                                 'CHECK NBR'.                     
ACT067     05  FILLER                  PIC X        VALUE SPACES.       
ACT067     05  FILLER                  PIC X(6)     VALUE 'LOCOFF'.     
ACT067     05  FILLER                  PIC X        VALUE SPACES.       
T20186     05  FILLER                  PIC X(04)    VALUE               
T20186                                 'DATE'.                          
T20186     05  FILLER                  PIC X(13)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(06)    VALUE               
T20186                                 'AMOUNT'.                        
T20186     05  FILLER                  PIC X(10)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(12)    VALUE               
T20186                                 'CHECK STATUS'.                  
T20186     05  FILLER                  PIC X(10)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(11)    VALUE               
T20186                                 'ACCT NUMBER'.                   
T20186     05  FILLER                  PIC X(13)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(10)    VALUE               
T20186                                 'NAME'.                          
T20186     05  FILLER                  PIC X(24)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-12.                                         
T20186     05  FILLER                  PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-DET-11.                                         
T20186     05  P-RPT1-CHK-NUMB         PIC X(09)    VALUE ZEROES.       
ACT067     05  FILLER                  PIC XX       VALUE SPACES.       
ACT067     05  P-RPT1-LOC-OFF          PIC X(3)     VALUE SPACES.       
ACT067     05  FILLER                  PIC X(3)     VALUE SPACES.       
T20186     05  P-RPT1-ISS-DATE         PIC X(10)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(01)    VALUE SPACES.       
T20186     05  P-RPT1-CHK-AMT          PIC ZZZ,ZZZ,ZZ9.99 VALUE ZEROES. 
           05  FILLER                  PIC X(10)    VALUE SPACES.       
T20186     05  P-RPT1-CHECK-STATUS     PIC X(13)    VALUE ZEROES.       
T20186     05  FILLER                  PIC X(09)    VALUE SPACES.       
           05  P-RPT1-ACCT-NUMB        PIC 9(13)    VALUE ZEROES.       
T20186     05  FILLER                  PIC X(05)    VALUE SPACES.       
T20186     05  P-RPT1-CUST-NAME        PIC X(50)    VALUE SPACES.       
T20186     05  FILLER                  PIC X(01)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)   VALUE SPACES.        
           05  FILLER                  PIC X(22)   VALUE                
                    '*** END OF REPORT ***'.                            
           05  FILLER                  PIC X(55)   VALUE SPACES.        
      *                                                                         
T20186 01  WS-PRT-GRAND-TOTALS.                                         
T20186     05  FILLER                  PIC X(39)   VALUE                
T20186              'NUMBER OF CHECKS SET TO ESCHEATMENT IS '.          
T20186     05  WS-PRT-GRAND-NUMBER     PIC ZZ,ZZZ.                      
T20186     05  FILLER                  PIC X(01)   VALUE SPACES.        
T20186     05  FILLER                  PIC X(18)   VALUE                
T20186              'AND THE AMOUNT IS '.                               
T20186     05  WS-PRT-GRAND-AMOUNT     PIC $$,$$$,$$9.99.               
T20186     05  FILLER                  PIC X(55)   VALUE SPACES.        
      *                                                                         
T20186 01  WS-MISC.                                                     
C37112     05  WS-REGULATED-CD         PIC X(02)    VALUE SPACES.       
TP5109     05  RS-RETURN-CODE          PIC S9(04)  COMP.                
TP5327     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-NO-OF-LINES          PIC S9(04)  COMP-3 VALUE ZERO.   
T20186     05  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.        
T20186     05  WS-DATE-TRANS           PIC X(10)   VALUE SPACES.        
T20186     05  WS-TRANSFER-MSG.                                         
T20186         10  FILLER              PIC X(23)   VALUE                
T20186                    'ESCHEATED CHECK NUMBER '.                    
T20186         10  WS-CHK-NUM          PIC 9(09).                       
           05  WS-PREV-COMP-NO         PIC X(02)   VALUE SPACES.        
           05  WS-COMP-NO-CHNG         PIC X(01)   VALUE 'N'.           
           05  WS-PREV-CHK-STAT-CD     PIC X(01)   VALUE SPACES.        
T20186     05  WS-GRAND-TOTAL-AMOUNT-1 PIC 9(10)V99 VALUE ZEROES.       
T20186     05  WS-GRAND-TOTAL-NUMBER-1 PIC 9(05)    VALUE ZEROES.       
T20186     05  WS-GRAND-TOTAL-AMOUNT-2 PIC 9(10)V99 VALUE ZEROES.       
T20186     05  WS-GRAND-TOTAL-NUMBER-2 PIC 9(05)    VALUE ZEROES.       
           05  WS-INDICATOR            PIC S9(9)   COMP SYNC VALUE +0.  
           05  WS-SYSIN-COMP-NO        PIC X(02)   VALUE SPACES.        
BB0903     05  WS-PARM-YEAR            PIC 9(02).                       
T20186     05  WS-DATE-T1.                                              
T20186         10  WS-DATE-T1-YYYY     PIC X(04)   VALUE SPACES.        
T20186         10  FILLER              PIC X(01)   VALUE '/'.           
T20186         10  WS-DATE-T1-MM       PIC X(02)   VALUE SPACES.        
T20186         10  FILLER              PIC X(01)   VALUE '/'.           
T20186         10  WS-DATE-T1-DD       PIC X(02)   VALUE SPACES.        
T20186     05  WS-DATE-T2.                                              
T20186         10  WS-DATE-T2-MM       PIC X(02)   VALUE SPACES.        
T20186         10  FILLER              PIC X(01)   VALUE '/'.           
T20186         10  WS-DATE-T2-DD       PIC X(02)   VALUE SPACES.        
T20186         10  FILLER              PIC X(01)   VALUE '/'.           
T20186         10  WS-DATE-T2-YYYY     PIC X(04)   VALUE SPACES.        
           05  WS-END-OF-ROWS          PIC X(01)   VALUE 'N'.           
               88  NOT-END-OF-ROWS                 VALUE 'N'.           
               88  END-OF-ROWS                     VALUE 'Y'.           
C37112     05  WS-PRINT-REG-HDR        PIC X(01)   VALUE 'N'.           
C37112         88  NOT-PRINT-REG-HDR               VALUE 'N'.           
C37112         88  PRINT-REG-HDR                   VALUE 'Y'.           
           05  WS-FIRST-TIME           PIC X(01)   VALUE 'Y'.           
C35809     05  WS-GT25-SW              PIC X(01)   VALUE 'N'.           
T20186     05  WS-MIDDLE-NAME-ALL      PIC X(15).                       
T20186     05  WS-MIDDLE-INIT REDEFINES WS-MIDDLE-NAME-ALL              
T20186                                 PIC X(1).                        
T20186     05  WS-AMT-REFUNDED         PIC ZZZZZZZZ.ZZ.                 
T20186     05  WS-NULL-REQUEST-DT      PIC S9(04)  USAGE COMP.          
T20186     05  WS-NULL-DATE-ESCHEATED  PIC S9(04)  USAGE COMP.          
T20186     05  WS-REQUEST-DT           PIC X(10).                       
T20186     05  WS-REQUEST-DT-R REDEFINES WS-REQUEST-DT.                 
T20186         10  WS-REQUEST-CC       PIC X(02).                       
T20186         10  WS-REQUEST-YY       PIC X(02).                       
T20186         10  WS-REQUEST-SL1      PIC X(01).                       
T20186         10  WS-REQUEST-MM       PIC X(02).                       
T20186         10  WS-REQUEST-SL2      PIC X(01).                       
T20186         10  WS-REQUEST-DD       PIC X(02).                       
T20186     05  WS-ZIP-PLUS-FOUR.                                        
T20186         10  WS-ZIP-FIVE         PIC X(05).                       
T20186         10  FILLER              PIC X(01)   VALUE '-'.           
T20186         10  WS-ZIP-FOUR         PIC X(04).                       
T20186     05  WS-CE-SSN               PIC X(09).                       
T20186     05  WS-CE-SSN-R REDEFINES WS-CE-SSN.                         
T20186         10  WS-CE-SSN-3         PIC X(03).                       
T20186         10  WS-CE-SSN-2         PIC X(02).                       
T20186         10  WS-CE-SSN-4         PIC X(04).                       
T20186     05  WS-PRINT-SSN.                                            
T20186         10  WS-PRINT-SSN-3      PIC X(03).                       
T20186         10  FILLER              PIC X(01)  VALUE '-'.            
T20186         10  WS-PRINT-SSN-2      PIC X(02).                       
T20186         10  FILLER              PIC X(01)  VALUE '-'.            
T20186         10  WS-PRINT-SSN-4      PIC X(04).                       
C26474     05  WS-TOT-ESCHEAT-CNT           PIC 9(05) VALUE ZEROS.      
C26474     05  WS-TOT-ESCHEAT-AMT           PIC 9(10)V99 VALUE ZEROS.   
C26474     05  WS-DATABASE                 PIC 9(01) VALUE 0.           
C26474         88 CSR-DATABASE                       VALUE 1.           
C26474         88 SEB-DATABASE                       VALUE 2.           
C26474     05  WS-ISSUE-DATE               PIC X(06).                   
C26474     05  WS-ISS-DATE-FIRST-UNION     PIC X(08).                   
C37112     05  WS-DEREG-REG                PIC X(01) VALUE SPACES.      
C26474                                                                  
C26474     05  WS-CHECK-NO-HOLD.                                        
C26474         10 WS-FIRST-POS              PIC 9(01) VALUE 0.          
C26474         10 WS-REST-OF-NUMBER         PIC 9(09) VALUE 0.          
C26474*                                                                         
C26474     05  WS-ISSUE-HOLD.                                           
C26474         10 WS-ISSUE-YY               PIC X(02) VALUE SPACES.     
C26474         10 WS-ISSUE-MM               PIC X(02) VALUE SPACES.     
C26474         10 WS-ISSUE-DD               PIC X(02) VALUE SPACES.     
C26474*                                                                         
C26474     05  WS-ISSUE-HOLD-FIRST-UNION.                               
C26474         10 WS-ISSUE-YY-FIRST-UNION   PIC X(04) VALUE SPACES.     
C26474         10 WS-ISSUE-MM-FIRST-UNION   PIC X(02) VALUE SPACES.     
C26474         10 WS-ISSUE-DD-FIRST-UNION   PIC X(02) VALUE SPACES.     
      *                                                                         
      ***************** PCSRP342 REPORT HEADERS **********************          
      *                                                                         
         COPY CWS09900.                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCOUNT *****************               
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_BILL_NMES  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_MISC_INFO  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
T20186******* TABLE DECLARATION FOR CSS_ADDR_FORMATTED ***************          
T20186*                                                                         
T20186                                                                  
T20186     EXEC SQL                                                             
T20186         INCLUDE TBADRFMT                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_AR_TRANS_HIST ***********               
T20186*                                                                         
T20186                                                                  
T20186     EXEC SQL                                                             
T20186         INCLUDE TBARHIST                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_AR_TRN_HST_DET **********               
T20186*                                                                         
T20186                                                                  
T20186     EXEC SQL                                                             
T20186         INCLUDE TBARHDT                                                  
T20186     END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_BUS_CUST_STATS  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBSCSTS                                                 
           END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_COMPANY  ****************               
T20186*                                                                         
T20186                                                                  
T20186     EXEC SQL                                                             
T20186         INCLUDE TBCOMPNY                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_CUST_ADD_XREF ******************        
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBCSADRX                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_CUST_STATS      **************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBCSTSTS                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_CUSTOMER  ***************               
T20186*                                                                         
T20186                                                                  
T20186     EXEC SQL                                                             
T20186         INCLUDE TBCUST                                                   
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_FREE_FRM_ADDR*****************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBADRFRE                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FRO CSS_GL_ACCT_NO *******************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBGLATNO                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_JOB_PARM    ******************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBJBPARM                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_NAME *************************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBNAME                                                   
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_NAME_ACCT_XREF *****************        
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBNMACTX                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_REFUND      ******************          
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBREFUND                                                 
T20186     END-EXEC.                                                            
T20186*                                                                         
T20186******* TABLE DECLARATION FOR CSS_ZIP_CODE   *****************            
T20186*                                                                         
T20186     EXEC SQL                                                             
T20186         INCLUDE TBZIPCD                                                  
T20186     END-EXEC.                                                            
      *                                                                         
      ******* TABLE DECLARATION FOR BATCH-JRNL-ROUTINE  **************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
PCR640******************************************************************        
PCR640*    CSS_AR_LOCKOUT                                                       
PCR640******************************************************************        
PCR640                                                                  
PCR640     EXEC SQL                                                             
PCR640         INCLUDE TBARLOCK                                                 
PCR640     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
C26474     EXEC SQL                                                             
C26474       INCLUDE TBDELQ                                                     
C26474     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE ESCHEATMENT_CSR CURSOR FOR                       
T20186         SELECT AT.ACCOUNT_NO                                     
T20186               ,AT.ADDRESS_ID                                     
T20186               ,AT.COMPANY_NO                                     
T20186               ,AT.CUSTOMER_NO                                    
T20186               ,AT.LOCAL_OFFICE                                   
T20186               ,AT.TOTAL_AR_BALANCE                               
T20186               ,RN.MANUAL_INDICATOR                               
T20186               ,RN.REFUND_CHECK_NO                                
T20186               ,RN.AMT_REFUNDED                                   
T20186               ,RN.CHECK_ISS_REAS_CD                              
T20186               ,RN.DATE_REFUNDED                                  
T20186               ,RN.REFUND_ITEM_ID                                 
T20186               ,RN.CHECK_STATUS_CD                                
T20186               ,RN.DATE_ESCHEATED                                 
T20186               ,AT.PREMISE_NO                                     
T20186               ,RN.REQUEST_DT                                     
C37112               ,B1.REGULATED_CD                                   
                FROM CSS_REFUND RN WITH(READUNCOMMITTED)                        
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
C37112              ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO = RN.ACCOUNT_NO                      
C37112           AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                  
C35809           AND RN.ESCHEATMENT_CD <> 'U'                           
                 AND RN.MANUAL_INDICATOR IN ('M','S')                   
                 AND RN.CHECK_STATUS_CD IN ('I','U','M')                
T20186           AND RN.DATE_REFUNDED <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-END-DATE-DATA
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE-DATA
              ) <> 0) OR (LEN(:WS-END-DATE-DATA) <> 10), CIS.CHAR2DATE(
                                                      :WS-END-DATE-DATA
              ), CONVERT(DATE, :WS-END-DATE-DATA) )              
T23643           AND AT.COMPANY_NO = :WS-SYSIN-COMP-NO                  
C37112         ORDER BY B1.REGULATED_CD,                                
T20186                  RN.REFUND_CHECK_NO                              
ACT067          FOR READ ONLY                                   
ACT067                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ESCHEATMENT_CSR CURSOR FOR                               
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,RN.MANUAL_INDICATOR                                       
MFA-TR*              ,RN.REFUND_CHECK_NO                                        
MFA-TR*              ,RN.AMT_REFUNDED                                           
MFA-TR*              ,RN.CHECK_ISS_REAS_CD                                      
MFA-TR*              ,RN.DATE_REFUNDED                                          
MFA-TR*              ,RN.REFUND_ITEM_ID                                         
MFA-TR*              ,RN.CHECK_STATUS_CD                                        
MFA-TR*              ,RN.DATE_ESCHEATED                                         
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,RN.REQUEST_DT                                             
MFA-TR*              ,B1.REGULATED_CD                                           
MFA-TR*         FROM CSS_REFUND RN                                              
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE AT.ACCOUNT_NO = RN.ACCOUNT_NO                              
MFA-TR*          AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                          
MFA-TR*          AND RN.ESCHEATMENT_CD <> 'U'                                   
MFA-TR*          AND RN.MANUAL_INDICATOR IN ('M','S')                           
MFA-TR*          AND RN.CHECK_STATUS_CD IN ('I','U','M')                        
MFA-TR*          AND RN.DATE_REFUNDED <= :WS-END-DATE-DATA                      
MFA-TR*          AND AT.COMPANY_NO = :WS-SYSIN-COMP-NO                          
MFA-TR*        ORDER BY B1.REGULATED_CD,                                        
MFA-TR*                 RN.REFUND_CHECK_NO                                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*     END-EXEC.                                                           
      *                                                                         
       01  WS-END                       PIC X(40)                       
               VALUE ' WORKING STORAGE FOR PCSCA693 ENDS HERE '.        
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
                                                                        
               IF AT-COMPANY-NO = WS-SYSIN-COMP-NO                      
T23643            PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT          
                  PERFORM 1000-CURSOR-PROCESS THRU 1000-EXIT            
                    UNTIL END-OF-ROWS                                   
                       OR AT-COMPANY-NO NOT = WS-SYSIN-COMP-NO          
C26474              IF  WS-COMPANY-NUMBER = '26' AND WS-DATA-FOUND      
C26474                  PERFORM 8630-WRITE-RECONCILE-HDR THRU 8630-EXIT 
C26474              END-IF                                              
               ELSE                                                     
T23643             IF END-OF-ROWS                                       
C37112               IF CSR-DATABASE                                    
T23643                  PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT       
C37112               ELSE                                               
C37112                  PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT       
C37112                  MOVE 'R' TO WS-DEREG-REG                        
C37112                  MOVE '  REGULATED ' TO DE-REG                   
C37112                  PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT       
C35809                  MOVE 'Y' TO WS-GT25-SW                          
C37112               END-IF                                             
T23643             END-IF                                               
T23643         END-IF.                                                  
      *                                                                         
T20186     PERFORM 7590-UPDATE-JOB-PARM-TABLE THRU 7590-EXIT.           
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   0100-INITIALIZATION                                          *        
      *        COMMON INITIALIZATION ROUTINE                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
C26474*                                                                         
C26474******************************************************************        
C26474* MOVED ACCEPTING COMPANY NO AS THE FIRST THING TO DO IN 0100    *        
C26474* AS FILE OPEN FOR ESHEAT FILES TO BE SENT TO BANK NEEDS TO KNOW *        
C26474* WHAT COMPANY IT IS RUNNING FOR                                 *        
C26474******************************************************************        
T23643     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
      *                                                                         
T23643     IF WS-SYSIN-COMP-NO = SPACES                                 
T23643        DISPLAY '***********************************'             
T23643        DISPLAY '** INVALID SYSIN COMPANY NUMBER'                 
T23643        DISPLAY '** CHECK SYSIN DSN MEMBER IN JCL'                
T23643        DISPLAY '** AND RERUN. NO PROCESSING DONE'                
T23643        DISPLAY '** PROCESSING TERMINATED'                        
T23643        DISPLAY '***********************************'             
T23643        PERFORM 9900-ABEND THRU 9900-EXIT                         
T23643     END-IF.                                                      
      *                                                                         
T23643     MOVE  WS-SYSIN-COMP-NO TO WS-COMPANY-NUMBER                  
C35809                               C7-COMPANY-NO.                     
T23643     IF  VALID-COMPANY                                            
T23643         NEXT SENTENCE                                            
T23643     ELSE                                                         
T23643         DISPLAY '***************************************'        
T23643         DISPLAY '** AT COMPANY NO DOES NOT MATCH SYSIN '         
T23643         DISPLAY '** CHECK SYSIN DSN MEMBER IN JCL'               
T23643         DISPLAY '** AND RERUN. NO PROCESSING DONE'               
T23643         DISPLAY '** PROCESSING TERMINATED'                       
T23643         DISPLAY '***************************************'        
T23643         PERFORM 9900-ABEND THRU 9900-EXIT                        
T23643     END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN OUTPUT FCSPT33A-FILE.                                   
      *                                                                         
T20186     OPEN OUTPUT FCSRP693-FILE.                                   
T20186     IF FRP693-SUCCESSFUL                                         
T20186        CONTINUE                                                  
T20186     ELSE                                                         
T20186        DISPLAY '*************************************'           
T20186        DISPLAY '**  PCSCA693 PROCESSING ERROR'                   
T20186        DISPLAY '**  OPEN ERROR OF FCSRP693 - OUTPUT FILE'        
T20186        DISPLAY '**  FILE STATUS = ' WS-FRP693-STATUS             
T20186        DISPLAY '**  PROCESSING TERMINATED'                       
T20186        DISPLAY '*************************************'           
T20186        PERFORM 9900-ABEND THRU 9900-EXIT                         
T20186     END-IF.                                                      
T20186*                                                                         
C26474     MOVE 'DATABASE'                    TO C8-DELINQ-CD           
C26474     MOVE '01'                          TO C8-COMPANY-NO          
C26474     PERFORM 6500-GET-DATABASE          THRU 6500-EXIT.           
C26474     MOVE C8-DELINQ-VALUE               TO WS-DATABASE            
C26474     IF  SEB-DATABASE                                             
C26474         OPEN OUTPUT FCSCA95-FILE                                 
C26474         IF FCA95-SUCCESSFUL                                      
T29199            MOVE 'REFUND-WACHOVIA-SEB' TO C8-DELINQ-CD            
C26474         ELSE                                                     
C26474            DISPLAY ' '                                           
C26474            DISPLAY '**  PCSCA691 PROCESSING ERROR        **'     
C26474            DISPLAY '**  OPEN ERROR ON FCSCA95 FILE       **'     
C26474            DISPLAY '**  FILE STATUS = ' WS-FCA95-STATUS          
C26474            DISPLAY '**  PROCESSING TERMINATED            **'     
C26474            PERFORM 9900-ABEND THRU 9900-EXIT                     
C26474         END-IF                                                   
C26474     ELSE                                                         
C26474         IF  WS-COMPANY-NUMBER = '01'                             
C26474             OPEN OUTPUT FCSCA96-FILE                             
C26474             IF FCA96-SUCCESSFUL                                  
T29199                MOVE 'REFUND-WACHOVIA-SCEG' TO C8-DELINQ-CD       
T29199                MOVE '01' TO C8-COMPANY-NO                        
C26474             ELSE                                                 
C26474                DISPLAY ' '                                       
C26474                DISPLAY '**  PCSCA691 PROCESSING ERROR        **' 
C26474                DISPLAY '**  OPEN ERROR ON FCSCA96 FILE       **' 
C26474                DISPLAY '**  FILE STATUS = ' WS-FCA96-STATUS      
C26474                DISPLAY '**  PROCESSING TERMINATED            **' 
C26474                PERFORM 9900-ABEND THRU 9900-EXIT                 
C26474             END-IF                                               
C26474         ELSE                                                     
C26474             OPEN OUTPUT FCSCA97-FILE                             
C26474             IF FCA97-SUCCESSFUL                                  
T29199                MOVE 'REFUND-WACHOVIA-PSNC' TO C8-DELINQ-CD       
T29199                MOVE '26' TO C8-COMPANY-NO                        
C26474             ELSE                                                 
C26474                DISPLAY ' '                                       
C26474                DISPLAY '**  PCSCA691 PROCESSING ERROR        **' 
C26474                DISPLAY '**  OPEN ERROR ON FCSCA97 FILE       **' 
C26474                DISPLAY '**  FILE STATUS = ' WS-FCA97-STATUS      
C26474                DISPLAY '**  PROCESSING TERMINATED            **' 
C26474                PERFORM 9900-ABEND THRU 9900-EXIT                 
C26474             END-IF                                               
C26474         END-IF                                                   
C26474     END-IF                                                       
                                                                        
T29199     PERFORM 2200-SELECT-BANK-ACCT-NBR THRU 2200-EXIT.            
                                                                        
T20186*  CHECK AR LOCKOUT                                                       
T20186     PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
T20186     IF AL-AR-LOCKOUT-IND = 'Y'                                   
T20186        DISPLAY '*************************************'           
T20186        DISPLAY '**  PCSCA693 PROCESSING ERROR'                   
T20186        DISPLAY '**  AR LOCKOUT IN EFFECT'                        
T20186        DISPLAY '**  PROCESSING TERMINATED'                       
T20186        DISPLAY '*************************************'           
T20186        PERFORM 9900-ABEND           THRU 9900-EXIT               
T20186     END-IF.                                                      
T20186*                                                                         
T20186     PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
T20186*                                                                         
T20186     IF COMMON-DATE-NEEDED                                        
T20186        MOVE 'COMMON  ' TO WS-PGRMNAME                            
T20186        MOVE SPACES TO WS-INPUT-AREA                              
T20186        MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN                    
T20186        PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
T20186        MOVE 'PCSCA693' TO WS-PGRMNAME                            
T20186     END-IF.                                                      
T20186*                                                                         
T20186     IF WS-INPUT-DATE EQUAL TO SPACES                             
T20186        DISPLAY '*************************************'           
T20186        DISPLAY '** PCSCA693 PROCESSING ERROR'                    
T20186        DISPLAY '** PARAGRAPH = 0100-INITIALIZATION'              
T20186        DISPLAY                                                   
T20186        'COMMON DATE IS NOT AVAILABLE IN JOB PARM TABLE'          
T20186        DISPLAY '** PROCESSING TERMINATED'                        
T20186        DISPLAY '*************************************'           
T20186        PERFORM 9900-ABEND THRU 9900-EXIT                         
T20186     END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-DATE-10.                            
           MOVE WS-D10-YY TO WS-D8-YY.                                  
           MOVE WS-D10-MM TO WS-D8-MM.                                  
           MOVE WS-D10-DD TO WS-D8-DD.                                  
T20186     MOVE WS-DATE-8 TO P-RPT-TRAN-DATE                            
                             P-RPT1-REPORT-DATE.                        
      *                                                                         
      *                                                                         
T20186     PERFORM 0110-READ-CSS-JOB-PARM THRU 0110-EXIT.               
T20186                                                                  
T20186     MOVE WS-BEGIN-DATE-MM-R TO BEG-DATE-MM.                      
T20186     MOVE WS-BEGIN-DATE-DD-R TO BEG-DATE-DD.                      
T20186     MOVE WS-BEGIN-DATE-YR-R TO BEG-DATE-YYYY.                    
T20186     MOVE WS-END-DATE-MM-R TO END-DATE-MM.                        
T20186     MOVE WS-END-DATE-DD-R TO END-DATE-DD.                        
T20186     MOVE WS-END-DATE-YR-R TO END-DATE-YYYY.                      
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH TO WS-RT-HH.                                      
           MOVE WS-MM TO WS-RT-MM.                                      
           MOVE WS-SS TO WS-RT-SS.                                      
T20186     MOVE WS-RUN-TIME TO P-RPT-RUN-TIME.                          
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY TO WS-RD-YY.                                      
           MOVE WS-CM TO WS-RD-MM.                                      
           MOVE WS-CD TO WS-RD-DD.                                      
T20186     MOVE WS-RUN-DATE TO P-RPT-RUN-DATE-1.                        
      *                                                                         
           MOVE WS-CM TO WS-UPT-MM.                                     
           MOVE WS-CD TO WS-UPT-DD.                                     
T20186     MOVE WS-D10-CC TO WS-UPT-CC.                                 
T20186     MOVE WS-CY TO WS-UPT-YY.                                     
      *                                                                         
T20186     INITIALIZE WS-100-RECORD-ID-DATA                             
T20186                WS-PRT-GRAND-TOTALS.                              
      *                                                                         
           PERFORM 7005-OPEN-CURSOR THRU 7005-EXIT.                     
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
      *                                                                         
T23643     IF END-OF-ROWS                                               
T23643          MOVE WS-SYSIN-COMP-NO TO C7-COMPANY-NO                  
T23643     END-IF.                                                      
      *                                                                         
T23643     PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT.                
      *                                                                         
C37112     IF SEB-DATABASE                                              
C37112       IF WS-REGULATED-CD = '02'                                  
C37112          MOVE 'DEREGULATED ' TO DE-REG                           
C37112          PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT               
C37112          MOVE 'R' TO WS-DEREG-REG                                
C37112          MOVE '  REGULATED ' TO DE-REG                           
C37112       ELSE                                                       
C37112          MOVE 'DEREGULATED ' TO DE-REG                           
C37112       END-IF                                                     
C37112     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
T20186*                                                                 09480000
T20186****************************************************************  09490000
T20186*                                                              *  09500000
T20186* 0110-READ-CSS-JOB-PARM.                                      *  09510000
T20186*     SELECTS JOB PARM INFORMATION.                            *  09520000
T20186*                                                              *  09540000
T20186****************************************************************  09550000
T20186*                                                                 09560000
T20186 0110-READ-CSS-JOB-PARM.                                          
T20186*                                                                 09560000
T20186     EXEC SQL                                                     
T20186         SELECT G6.PARM_DATA                                      
T20186           INTO :G6-PARM-DATA                                     
T20186           FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
T20186          WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   
T23643           AND G6.COMPANY_NO  = :WS-SYSIN-COMP-NO                 
ACT067                                                           
ACT067                                                      
T20186     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02671000
MFA-TR*        SELECT G6.PARM_DATA                                      02671200
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                   02671700
MFA-TR*         WHERE G6.PROGRAM_NAME = :PROGRAM-NAME                   02671800
MFA-TR*          AND G6.COMPANY_NO  = :WS-SYSIN-COMP-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 0110                                                   
MFA-TR*    END-EXEC.                                                    02673000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20186*                                                                 02674000
T20186     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20186     IF SQLCODE = SUCCESSFUL-CALL                                 
T20186         MOVE G6-PARM-DATA TO WS-JOB-PARM-DATA                    
T20186     ELSE                                                         
T20186         DISPLAY '*************************************'          
T20186         DISPLAY '** PCSCA693 PROCESSING ERROR'                   
T20186         DISPLAY '** PARAGRAPH = 0110-READ-CSS-JOB-PARM'          
T20186         DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
T20186         DISPLAY '** PROCESSING TERMINATED'                       
T20186         DISPLAY '*************************************'          
T20186         PERFORM 9900-ABEND THRU 9900-EXIT                        
T20186     END-IF.                                                      
T20186*                                                                 09700000
T20186 0110-EXIT.                                                       
T20186     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-CURSOR-PROCESS                                            *        
      *                                                                *        
      * PROCESS THE MAIN CURSOR ESCHEATMENT. WRITE HEADER WHEN THERE IS*        
      * A CHANGE IN COMP NO. ACCUMULATES CHECK TOTAL FOR EACH ACCOUNT. *        
      * WRITES INTO REPORT2 IF AMT EXCEEDS 25$. WRITE EVERY ROW FETCHED*        
      * TO REPORT1.                                                    *        
      ******************************************************************        
       1000-CURSOR-PROCESS.                                             
      *                                                                         
T20186     INITIALIZE E-FRP693-DATA-REC.                                
C26474     SET WS-DATA-FOUND TO TRUE                                    
           IF AT-COMPANY-NO NOT = WS-PREV-COMP-NO                       
T23643        MOVE WS-SYSIN-COMP-NO TO C7-COMPANY-NO                    
              PERFORM 7100-GET-COMPANY-DESC THRU 7100-EXIT              
                 PERFORM 8000-PRINT-HDR-693-1 THRU 8000-EXIT            
                 MOVE AT-COMPANY-NO TO WS-PREV-COMP-NO                  
T20186           MOVE 'Y' TO WS-COMP-NO-CHNG                            
T20186     END-IF.                                                      
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
           PERFORM 3000-FORMAT-ESCHEATMENT THRU 3000-EXIT.              
      *                                                                         
           IF RN-AMT-REFUNDED >= 25                                     
              IF WS-FIRST-TIME = 'Y'                                    
              OR WS-COMP-NO-CHNG = 'Y'                                  
                 PERFORM 8050-PRINT-HDR-693-2 THRU 8050-EXIT            
                 MOVE 'N' TO WS-FIRST-TIME                              
C35809           IF WS-DEREG-REG = 'R'                                  
C35809             MOVE 'Y' TO WS-GT25-SW                               
C35809           END-IF                                                 
              END-IF                                                    
T20186        MOVE RN-AMT-REFUNDED TO P-RPT1-CHK-AMT                    
T20186        PERFORM 8950-WRITE-FCSPT33A THRU 8950-EXIT                
T20186     END-IF.                                                      
      *                                                                         
T20186     MOVE 'T' TO RN-CHECK-STATUS-CD.                              
T20186     MOVE WS-STAT-UPT-DT TO RN-REFUND-STATUS-DT.                  
T20186     PERFORM 7500-UPDATE-CSS-REFUND THRU 7500-EXIT.               
T20186     PERFORM 8900-WRITE-FCSPT33 THRU 8900-EXIT.                   
                                                                        
      **  ONLY INSERT THE JOURNAL CONTROL ONCE                    **            
BB0903     IF WS-COMP-NO-CHNG = 'Y'                                     
              PERFORM 1200-GET-AND-VALIDATE-CNTRL THRU 1200-EXIT        
BB0903        MOVE BC-NO-ITEMS-ENTERED TO WS-JRNL-NO-ITEMS-CNTRL        
T20186     END-IF.                                                      
T20186     PERFORM 2000-CREATE-JRNL-FROM-RECORD THRU 2000-EXIT.         
T20186     MOVE 'N' TO WS-COMP-NO-CHNG.                                 
      *                                                                         
T20186     PERFORM 7560-GET-CURRENT-TIMESTAMP THRU 7560-EXIT.           
T20186     PERFORM 8400-MOVE-AR-TRANS-DETAIL THRU 8400-EXIT.            
T20186     PERFORM 7570-INSERT-AR-TRANS-HIST THRU 7570-EXIT.            
T20186     PERFORM 8450-MOVE-AR-TRANS-DET-DETAIL THRU 8450-EXIT.        
T20186     PERFORM 7580-INSERT-AR-TRN-HST-DET THRU 7580-EXIT.           
      *                                                                         
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
      *                                                                         
C37112     IF SEB-DATABASE                                              
C37112       IF END-OF-ROWS                                             
C37112         IF WS-DEREG-REG = SPACES                                 
C37112           PERFORM 8100-TOTAL-PARA THRU 8100-EXIT                 
C37112           MOVE '  REGULATED ' TO DE-REG                          
C37112           MOVE 'R' TO WS-DEREG-REG                               
C37112           PERFORM 8300-NO-DATA-PARA  THRU 8300-EXIT              
C37112           MOVE 'Y' TO WS-PRINT-REG-HDR                           
C37112         END-IF                                                   
C37112       ELSE                                                       
C37112         IF WS-REGULATED-CD = '02'                                
C37112           IF WS-DEREG-REG = SPACES                               
C37112             PERFORM 8100-TOTAL-PARA THRU 8100-EXIT               
C37112             MOVE 'Y' TO WS-FIRST-TIME                            
C37112             MOVE ZEROES TO WS-RPT2-LINE-NO                       
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-NUMBER-1               
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-AMOUNT-1               
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-NUMBER-2               
C37112             MOVE ZEROES TO WS-GRAND-TOTAL-AMOUNT-2               
C37112             MOVE '  REGULATED ' TO DE-REG                        
C37112             MOVE 'R' TO WS-DEREG-REG                             
C37112             PERFORM 8000-PRINT-HDR-693-1 THRU 8000-EXIT          
C37112           END-IF                                                 
C37112         END-IF                                                   
C37112       END-IF                                                     
T27597     END-IF.                                                      
      *                                                                         
      **  UPDATE THE JOURNAL CONTROL WHEN THERE IS NO DATA OR THE  **           
      **  COMPANY NUMBER CHANGES                                   **           
           IF AT-COMPANY-NO NOT = WS-PREV-COMP-NO                       
           OR END-OF-ROWS                                               
              PERFORM 2100-TIE-OFF-CNTRL                                
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    GET AND VALIDATE CONTROL                                             
      ******************************************************************        
                                                                        
       1200-GET-AND-VALIDATE-CNTRL.                                     
                                                                        
           MOVE 'B' TO WS-JRNL-SOURCE-CODE.                             
BB0903     MOVE SPACES TO WS-JRNL-BT-ENTRY-LOC-OFF                      
                          BC-LOCAL-OFFICE-ENTRY                         
                          WS-JRNL-BT-ENTRY-LOC.                         
      *                                                                         
           PERFORM 6405-GET-CURRENT-JRNL-TIME THRU 6405-EXIT.           
           PERFORM 6410-GET-CURRENT-JRNL-DATE THRU 6410-EXIT.           
BB0903     MOVE '01' TO WS-JRNL-BT-BAT-COMPANY                          
BB0903                  WS-100-COMPANY-NO.                              
BB0903     MOVE '998' TO WS-JRNL-BT-BAT-LOC-OFF                         
BB0903                   WS-JRNL-BT-BAT-REPORT-NO.                      
BB0903     MOVE WS-JRNL-TRAN-DATE TO WS-JRNL-BT-BAT-REPORT-DT.          
BB0903     MOVE '9999' TO WS-JRNL-BT-BAT-CASH-DRWR.                     
      *                                                                         
BB0903     MOVE WS-JRNL-SELECT-AND-OR-INS TO WS-JRNL-OPERATION-RQST.    
      *                                                                         
BB0903     PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
BB0903                                                                  
BB0903     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
BB0903        NEXT SENTENCE                                             
BB0903     ELSE                                                         
BB0903        MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
BB0903        MOVE '1200' TO ACTIVE-PARAGRAPH                           
BB0903        MOVE 'USERABEN' TO ABEND-FUNCTION                         
BB0903        MOVE WS-Y TO WS-USER-FORCE-ABEND                          
BB0903        PERFORM 9900-ABEND THRU 9900-EXIT                         
BB0903     END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    CREATE JOURNAL FROM RECORD                                           
      ******************************************************************        
                                                                        
       2000-CREATE-JRNL-FROM-RECORD.                                    
                                                                        
BB0903     IF AT-ACCOUNT-NO = WS-100-ACCT-NO                            
BB0903        ADD 1 TO WS-100-JRNL-TRAN-APPL-NO                         
BB0903     ELSE                                                         
BB0903        MOVE +1 TO WS-100-JRNL-TRAN-APPL-NO                       
BB0903        MOVE AT-ACCOUNT-NO TO WS-100-ACCT-NO                      
BB0903        PERFORM 7700-SELECT-JRNL-DETAILS THRU 7700-EXIT           
BB0903     END-IF.                                                      
      *                                                                         
           MOVE ZEROS                TO WS-101-ACCT-END-AR-BAL          
                                        WS-101-ITEM-ID-NO               
                                        WS-101-DETAIL-END-BAL           
                                        WS-101-DETAIL-END-AR-BAL.       
           MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.              
           MOVE AT-PREMISE-NO        TO WS-100-PREMISE-NO.              
           MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD.         
           MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.             
           MOVE AT-CODE-COMPANY-ACCT TO WS-101-CODE-COMPANY-ACCT.       
           MOVE AT-CODE-ACCT-STAT    TO WS-101-CODE-ACCOUNT-STATUS.     
                                                                        
           MOVE CU-CODE-EMPL-ACCT    TO WS-101-CODE-EMPL-ACCT.          
      *                                                                         
           MOVE PR-REV-DISTRICT-CD   TO WS-101-CODE-REVENUE-DISTRICT.   
           MOVE PR-CODE-PREMISE-STAT TO WS-101-CODE-PREMISE-STATUS.     
      *                                                                         
           MOVE SPACES TO WS-100-TRANS-ERRORS.                          
                                                                        
           MOVE 101 TO WS-101-JRNL-FORMAT-NO.                           
           MOVE RN-AMT-REFUNDED TO WS-101-AMOUNT-ENTERED                
                                   WS-101-AMT-POSTED                    
BB0903                             WS-JRNL-GEN-LEG-DEBIT-AMT            
BB0903                             WS-JRNL-GEN-LEG-CREDIT-AMT.          
                                                                        
                                                                        
T23643     IF WS-SYSIN-COMP-NO = '01'                                   
BB0903       MOVE WS-GL-DEF-TREASA-KEY  TO GO-GL-ACCT-NAME              
T23643     ELSE                                                         
T23643       MOVE WS-GL-DEF-TREASNC-KEY TO GO-GL-ACCT-NAME              
T23643     END-IF                                                       
BB0903     PERFORM 7430-SELECT-GL-NO THRU 7430-EXIT.                    
BB0903     MOVE GO-GL-ACCT-NO TO WS-101-ACCT-GEN-LED-DR.                
BB0903                                                                  
T23643     IF WS-SYSIN-COMP-NO = '01'                                   
T20186       MOVE WS-GL-DEF-ESCHEA-KEY TO GO-GL-ACCT-NAME               
T23643     ELSE                                                         
T23643       MOVE WS-GL-DEF-ESCHNC-KEY TO GO-GL-ACCT-NAME               
T23643     END-IF                                                       
BB0903     PERFORM 7430-SELECT-GL-NO THRU 7430-EXIT.                    
BB0903     MOVE GO-GL-ACCT-NO TO WS-101-ACCT-GEN-LED-CR.                
BB0903                                                                  
           MOVE 'A' TO WS-100-JRNL-SORT-ID.                             
           MOVE 'ESCM' TO WS-100-CODE-TERMINAL-TRAN.                    
           MOVE 'B' TO WS-100-CODE-ENTRY-SOURCE.                        
                                                                        
           MOVE WS-JRNL-ONLY TO WS-JRNL-OPERATION-RQST.                 
           MOVE WS-JRNL-CASH-UPDATE TO WS-JRNL-BT-AUTH-TYPE.            
           MOVE WS-N TO WS-UPDATE-JRNL-CNTL-NOW.                        
                                                                        
           MOVE CJF00101 TO WS-100-USER-DEFINED-AREA.                   
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA693 PROCESSING ERROR'                   
T20186        DISPLAY '**  PARAGRAPH = 2000-CREATE-JRNL-FROM-RECORD'    
              DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE              
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *    UPDATE BATCH CONTROL RECORD                                          
      ******************************************************************        
                                                                        
       2100-TIE-OFF-CNTRL.                                              
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA693 PROCESSING ERROR'                   
T20186        DISPLAY '**  PARAGRAPH = 2100-TIE-OFF-CNTRL'              
              DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE              
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
T29199************************************************************              
T29199**  2200-SELECT-BANK-ACCT-NBR.                            **              
T29199**      SELECTS WACHOVIA BANK ACCOUNT NUMBERS FROM        **              
T29199**      CSS_DELINQUENCY.                                  **              
T29199************************************************************              
T29199 2200-SELECT-BANK-ACCT-NBR.                                       
T29199*                                                                         
T29199     EXEC SQL                                                     
T29199         SELECT DESCRIPTION                                       
T29199         INTO  :C8-DESCRIPTION                                    
T29199         FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T29199         WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
T29199         AND    COMPANY_NO = :C8-COMPANY-NO                       
ACT067                                                           
ACT067                                                      
T29199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DESCRIPTION                                               
MFA-TR*        INTO  :C8-DESCRIPTION                                            
MFA-TR*        FROM   CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*        AND    COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 2200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29199*                                                                         
T29199     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
T29199*                                                                         
T29199     EVALUATE WS-ACTIVE-RETURN-CODE                               
T29199         WHEN SUCCESSFUL-CALL                                     
T29199              CONTINUE                                            
T29199         WHEN OTHER                                               
T29199             DISPLAY '** PCSCA693 PROCESSING ERROR      **'       
T29199             DISPLAY '** ERROR ON SELECT                **'       
T29199             DISPLAY '** PARA 2200-SELECT-BANK-ACCT-NBR **'       
T29199             DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
T29199             DISPLAY '** DELINQ CODE: ' C8-DELINQ-CD              
T29199             DISPLAY '** COMPANY NO: ' C8-COMPANY-NO              
T29199             DISPLAY '** PROCESSING TERMINATED            **'     
T29199             PERFORM 9900-ABEND THRU 9900-EXIT                    
T29199     END-EVALUATE.                                                
T29199*                                                                         
T29199 2200-EXIT.                                                       
T29199     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 3000-FORMAT-ESCHEATMENT.                                       *        
      *  FORMATS RECORDS FOR PRINTING REPORT 1.                        *        
      *                                                                *        
      ******************************************************************        
       3000-FORMAT-ESCHEATMENT.                                         
      *                                                                         
           MOVE RN-REFUND-CHECK-NO TO P-RPT1-CHK-NUMB.                  
           MOVE RN-DATE-REFUNDED TO WS-DATE-T1.                         
           MOVE WS-DATE-T1-MM TO WS-DATE-T2-MM.                         
           MOVE WS-DATE-T1-DD TO WS-DATE-T2-DD.                         
           MOVE WS-DATE-T1-YYYY TO WS-DATE-T2-YYYY.                     
           MOVE WS-DATE-T2 TO P-RPT1-ISS-DATE.                          
           MOVE RN-AMT-REFUNDED TO P-RPT1-CHK-AMT.                      
           PERFORM 8550-MOVE-STATUS-CODE-DESCR THRU 8550-EXIT.          
           MOVE AT-ACCOUNT-NO TO P-RPT1-ACCT-NUMB.                      
ACT067     MOVE AT-LOCAL-OFFICE TO P-RPT1-LOC-OFF.                      
           IF WS-ACCOUNT-NAME = SPACES                                  
              MOVE WS-CUSTOMER-NAME TO P-RPT1-CUST-NAME                 
           ELSE                                                         
              MOVE WS-ACCOUNT-NAME TO P-RPT1-CUST-NAME                  
           END-IF.                                                      
           PERFORM 8500-MOVE-STATE-FILE THRU 8500-EXIT.                 
C26474     PERFORM 3100-CREATE-ESCHEAT-FILES THRU 3100-EXIT.            
                                                                        
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C26474                                                                  
C26474*****************************************************************         
C26474*  3100-CREATE-ESCHEAT-FILES.                                   *         
C26474*                                                               *         
C26474*****************************************************************         
C26474 3100-CREATE-ESCHEAT-FILES.                                       
C26474                                                                  
C26474     IF  SEB-DATABASE                                             
C26474         PERFORM 8600-CREATE-SEB-FILE THRU 8600-EXIT              
C26474     ELSE                                                         
C26474        IF  AT-COMPANY-NO = '01'                                  
C26474            PERFORM 8610-CREATE-SCEG-FILE THRU 8610-EXIT          
C26474        ELSE                                                      
C26474            IF  AT-COMPANY-NO = '26'                              
C26474                PERFORM 8620-CREATE-PSNC-FILE THRU 8620-EXIT      
C26474            END-IF                                                
C26474        END-IF                                                    
C26474     END-IF.                                                      
C26474     ADD RN-AMT-REFUNDED  TO WS-TOT-ESCHEAT-AMT                   
C26474     ADD 1                TO WS-TOT-ESCHEAT-CNT.                  
C26474                                                                  
C26474 3100-EXIT.                                                       
C26474     EXIT.                                                        
C26474                                                                  
C26474*****************************************************************         
C26474* 6500-GET-DATABASE.                                            *         
C26474*     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
C26474*****************************************************************         
C26474 6500-GET-DATABASE.                                               
C26474                                                                  
C26474     EXEC SQL                                                     
C26474        SELECT DELINQ_VALUE                                       
C26474          INTO :C8-DELINQ-VALUE                                   
C26474          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C26474         WHERE DELINQ_CD = :C8-DELINQ-CD                          
C26474         AND  COMPANY_NO = :C8-COMPANY-NO                         
ACT067                                                           
ACT067                                                      
C26474     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*        AND  COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 6500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26474                                                                  
C26474     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
C26474                                                                  
C26474     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26474         MOVE C8-DELINQ-VALUE          TO WS-DATABASE             
C26474     ELSE                                                         
C26474         MOVE '6500' TO WS-ACTIVE-PARAGRAPH                       
C26474         DISPLAY '*** ABEND IN PARA 6500 ***'                     
C26474         DISPLAY '*** ACCOUNT = ' AT-ACCOUNT-NO                   
C26474         DISPLAY '*** SQLCODE = ' SQLCODE                         
C26474         PERFORM 9900-ABEND THRU 9900-EXIT                        
C26474     END-IF.                                                      
C26474                                                                  
C26474 6500-EXIT.                                                       
C26474     EXIT.                                                        
C26474*                                                                         
      ******************************************************************        
      *                                                                *        
      * 7005-OPEN-CURSOR                                               *        
      *  OPENS THE CURSOR ESCHEATMENT                                  *        
      *                                                                *        
      ******************************************************************        
       7005-OPEN-CURSOR.                                                
      *                                                                         
           EXEC SQL                                                     
              OPEN ESCHEATMENT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
4620          MOVE 'Y' TO WS-OPEN-CURSOR-SW                             
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**  PCSCA693 PROCESSING ERROR'                   
              DISPLAY '**  PARAGRAPH = 7005-OPEN-CURSOR'                
              DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7010-FETCH-CURSOR.                                           *        
      *        FETCHES ROW FROM ACCT & REFUND FOR CORRESPONDING ACCT   *        
      *        NUMBERS.                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
              FETCH ESCHEATMENT_CSR                                     
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-ADDRESS-ID,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-LOCAL-OFFICE,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :RN-MANUAL-INDICATOR,                               
                    :RN-REFUND-CHECK-NO,                                
                    :RN-AMT-REFUNDED,                                   
                    :RN-CHECK-ISS-REAS-CD,                              
                    :RN-DATE-REFUNDED,                                  
                    :RN-REFUND-ITEM-ID,                                 
                    :RN-CHECK-STATUS-CD,                                
                    :RN-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED,                 
                    :AT-PREMISE-NO,                                     
                    :RN-REQUEST-DT :WS-NULL-REQUEST-DT,                         
C37112              :WS-REGULATED-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-ROWS                             
              ELSE                                                      
                 DISPLAY '*************************************'        
                 DISPLAY '** PCSCA693 PROCESSING ERROR'                 
                 DISPLAY '** PARAGRAPH = 7010-FETCH-CURSOR'             
                 DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '** PROCESSING TERMINATED'                     
                 DISPLAY '*************************************'        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7015-CLOSE-CURSOR.                                           *        
      *        CLOSES CURSOR ESCHEATMENT_CSR                           *        
      *                                                                *        
      ******************************************************************        
       7015-CLOSE-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
               CLOSE ESCHEATMENT_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA693 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7015-CLOSE-CURSOR'               
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
T27597*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-GET-COMPANY-DESC                                    **          
      **      SELECTS COMPANY NAME FROM CSS_COMPANY USING COMPANY   **          
      **      NO FROM ROW FETCHED FROM CSS_ACCOUNT.                 **          
      ****************************************************************          
      *                                                                         
       7100-GET-COMPANY-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
                 INTO :C7-COMPANY-NAME                                  
                 FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
                WHERE COMPANY_NO = :C7-COMPANY-NO                       
ACT067                                                           
ACT067                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C7-COMPANY-NAME TO P-RPT-CO-NAME-1                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '*************************************'       
                  DISPLAY '** PCSCA693 PROCESSING ERROR'                
                  DISPLAY '** PARAGRAPH = 7100-GET-COMPANY-DESC'        
                  DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY '** PROCESSING TERMINATED'                    
                  DISPLAY '*************************************'       
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7300-GET-SSN                                             **          
      **      SELECTS SSN FROM CSS_CUST_STATS                       **          
      ****************************************************************          
      *                                                                         
       7300-GET-SSN.                                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT SSN                                               
                 INTO :CE-SSN                                           
                 FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'C'                               
ACT067                                                           
ACT067                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN                                                       
MFA-TR*          INTO :CE-SSN                                                   
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'C'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 0110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7300-GET-SSN'                     
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-SELECT-TAX-ID.                                      **          
      **      SELECTS TAX ID FROM CSS_BUS_CUST_STATS                **          
      ****************************************************************          
      *                                                                         
       7400-SELECT-TAX-ID.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT TAX_ID                                            
                 INTO :BS-TAX-ID                                        
                 FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
ACT067                                                           
ACT067                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TAX_ID                                                    
MFA-TR*          INTO :BS-TAX-ID                                                
MFA-TR*          FROM CSS_BUS_CUST_STATS                                        
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7400-SELECT-TAX-ID'               
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
BB0903************************************************************              
BB0903**  7430-SELECT-GL-NO.                                    **              
BB0903**      SELECTS GL NO FROM THE PNEUMONICS.                **              
BB0903************************************************************              
BB0903 7430-SELECT-GL-NO.                                               
BB0903*                                                                         
BB0903     EXEC SQL                                                     
BB0903         SELECT GL_ACCT_NO                                        
BB0903           INTO :GO-GL-ACCT-NO                                    
BB0903           FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
BB0903          WHERE GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
ACT067                                                           
ACT067                                                      
BB0903     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO                                                
MFA-TR*          INTO :GO-GL-ACCT-NO                                            
MFA-TR*          FROM CSS_GL_ACCT_NO                                            
MFA-TR*         WHERE GL_ACCT_NAME = :GO-GL-ACCT-NAME                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7430                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BB0903*                                                                         
BB0903     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
BB0903     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
BB0903        NEXT SENTENCE                                             
BB0903     ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7430-SELECT-GL-NO'                
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
BB0903        PERFORM 9900-ABEND THRU 9900-EXIT                         
BB0903     END-IF.                                                      
BB0903*                                                                         
BB0903 7430-EXIT.                                                       
BB0903     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-UPDATE-CSS-REFUND.                                  **          
      **      UPDATES CSS_REFUND FOR ACCOUNT_NO & REFUND_ITEM_ID    **          
      ****************************************************************          
      *                                                                         
       7500-UPDATE-CSS-REFUND.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_REFUND                                        
                  SET CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
                     ,REFUND_STATUS_DT = IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) )           
                     ,DATE_ESCHEATED   = IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) )           
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
                  AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REFUND                                                
MFA-TR*           SET CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD                    
MFA-TR*              ,REFUND_STATUS_DT = :RN-REFUND-STATUS-DT                   
MFA-TR*              ,DATE_ESCHEATED   = :RN-REFUND-STATUS-DT                   
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*           AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7500-UPDATE-CSS-REFUND'           
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
BB0903        PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06645500
      ************************************************************      06645600
T18189**  7560-GET-CURRENT-TIMESTAMP.                           **              
T18189**      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
T18189************************************************************              
T18189 7560-GET-CURRENT-TIMESTAMP.                                      
T18189     EXEC SQL                                                     
T18189         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
T18189           INTO :WS-CURRENT-TIMESTAMP                             
                     ,:WS-DATE-TRANS                                    
T18189           FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
ACT067                                                           
ACT067                                                      
T18189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP                                         
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*          INTO :WS-CURRENT-TIMESTAMP                                     
MFA-TR*              ,:WS-DATE-TRANS                                            
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7560                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T18189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18189     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7560-GET-CURRENT-TIMESTAMP'       
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
T18189        PERFORM 9900-ABEND THRU 9900-EXIT                         
T18189     END-IF.                                                      
T18189*                                                                         
T18189 7560-EXIT.                                                       
T18189     EXIT.                                                        
T18189*                                                                         
T18189************************************************************              
T18189**  7570-INSERT-AR-TRANS-HIST.                            **              
T18189**      INSERTS THE RECORDS IN TO THE CSS_AR_TRANS_HIST   **              
T18189**      TABLE.                                            **              
T18189************************************************************              
T18189*                                                                         
T18189 7570-INSERT-AR-TRANS-HIST.                                       
T18189                                                                  
T18189     EXEC SQL                                                     
T18189         INSERT INTO CSS_AR_TRANS_HIST                            
T18189             ( ACCOUNT_NO                                         
T18189              ,TRANS_HIST_SEQ_NO                                  
T18189              ,DATE_TRANS                                         
T18189              ,CODE_TRAN_TYPE                                     
T18189              ,AMT_ORIG_ENTERED                                   
T18189              ,AMT_BILLED_UNPAID                                  
T18189              ,RESP_AREA_ID                                       
T18189              ,APPL_PROGRAM_ID                                    
T18189              ,USER_ID                                            
T18189              ,COMPANY_NO                                         
T18189              ,CASH_COMPANY_NO                                    
T18189              ,CASH_LOCAL_OFFICE                                  
T18189              ,CASH_REPORT_NO                                     
T18189              ,DATE_CASH_REPORT                                   
T18189              ,CASH_DRAWER_ID                                     
T18189              ,TRAN_COMMENT)                                      
T18189          VALUES                                                  
T18189             ( :AR-ACCOUNT-NO                                     
T18189              ,CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO)                  
T18189              ,IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                               
T18189              ,:AR-CODE-TRAN-TYPE                                 
T18189              ,:AR-AMT-ORIG-ENTERED                               
T18189              ,:AR-AMT-BILLED-UNPAID                              
T18189              ,:AR-RESP-AREA-ID                                   
T18189              ,:AR-APPL-PROGRAM-ID                                
T18189              ,:AR-USER-ID                                        
T18189              ,:AR-COMPANY-NO                                     
T18189              ,:AR-CASH-COMPANY-NO                                
T18189              ,:AR-CASH-LOCAL-OFFICE                              
T18189              ,:AR-CASH-REPORT-NO                                 
T18189              ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
T18189              ,:AR-CASH-DRAWER-ID                                 
T18189              ,:AR-TRAN-COMMENT)                                  
T18189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                                    
MFA-TR*            ( ACCOUNT_NO                                                 
MFA-TR*             ,TRANS_HIST_SEQ_NO                                          
MFA-TR*             ,DATE_TRANS                                                 
MFA-TR*             ,CODE_TRAN_TYPE                                             
MFA-TR*             ,AMT_ORIG_ENTERED                                           
MFA-TR*             ,AMT_BILLED_UNPAID                                          
MFA-TR*             ,RESP_AREA_ID                                               
MFA-TR*             ,APPL_PROGRAM_ID                                            
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CASH_COMPANY_NO                                            
MFA-TR*             ,CASH_LOCAL_OFFICE                                          
MFA-TR*             ,CASH_REPORT_NO                                             
MFA-TR*             ,DATE_CASH_REPORT                                           
MFA-TR*             ,CASH_DRAWER_ID                                             
MFA-TR*             ,TRAN_COMMENT)                                              
MFA-TR*         VALUES                                                          
MFA-TR*            ( :AR-ACCOUNT-NO                                             
MFA-TR*             ,:AR-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:AR-DATE-TRANS                                             
MFA-TR*             ,:AR-CODE-TRAN-TYPE                                         
MFA-TR*             ,:AR-AMT-ORIG-ENTERED                                       
MFA-TR*             ,:AR-AMT-BILLED-UNPAID                                      
MFA-TR*             ,:AR-RESP-AREA-ID                                           
MFA-TR*             ,:AR-APPL-PROGRAM-ID                                        
MFA-TR*             ,:AR-USER-ID                                                
MFA-TR*             ,:AR-COMPANY-NO                                             
MFA-TR*             ,:AR-CASH-COMPANY-NO                                        
MFA-TR*             ,:AR-CASH-LOCAL-OFFICE                                      
MFA-TR*             ,:AR-CASH-REPORT-NO                                         
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*             ,:AR-CASH-DRAWER-ID                                         
MFA-TR*             ,:AR-TRAN-COMMENT)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T18189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18189     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T18189     OR NOT-FOUND                                                 
T18189        NEXT SENTENCE                                             
T18189     ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7570-INSERT-AR-TRANS-HIST'        
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
T18189        PERFORM 9900-ABEND THRU 9900-EXIT                         
T18189     END-IF.                                                      
T18189                                                                  
T18189 7570-EXIT.                                                       
T18189     EXIT.                                                        
T18189*                                                                         
T18189************************************************************              
T18189**  7580-INSERT-AR-TRN-HST-DET.                           **              
T18189**      INSERTS INTO THE TABLE CSS_AR_TRN_HST_DET         **              
T18189************************************************************              
T18189*                                                                         
T18189 7580-INSERT-AR-TRN-HST-DET.                                      
T18189                                                                  
T18189     EXEC SQL                                                     
T18189         INSERT INTO CSS_AR_TRN_HST_DET                           
T18189            ( ACCOUNT_NO                                          
T18189             ,TRANS_HIST_SEQ_NO                                   
T18189             ,TRAN_APPL_NO                                        
T18189             ,CODE_AR_AGE                                         
T18189             ,GL_ACCT_CREDIT                                      
T18189             ,GL_ACCT_DEBIT                                       
T18189             ,AMT_POSTED                                          
T18189             ,ITEM_ID                                             
T18189             ,CODE_CONTRACT_TYPE                                  
T18189             ,CURRENCY_TYPE                                       
T18189             ,CURRENCY_AMT)                                       
T18189          VALUES                                                  
T18189            ( :AU-ACCOUNT-NO                                      
T18189             ,CIS.CHAR2TIMESTAMP(:AU-TRANS-HIST-SEQ-NO)                   
T18189             ,:AU-TRAN-APPL-NO                                    
T18189             ,:AU-CODE-AR-AGE                                     
T18189             ,:AU-GL-ACCT-CREDIT                                  
T18189             ,:AU-GL-ACCT-DEBIT                                   
T18189             ,:AU-AMT-POSTED                                      
T18189             ,:AU-ITEM-ID                                         
T18189             ,:AU-CODE-CONTRACT-TYPE                              
T18189             ,:AU-CURRENCY-TYPE                                   
T18189             ,:AU-CURRENCY-AMT)                                   
T18189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_AR_TRN_HST_DET                                   
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*            ,TRANS_HIST_SEQ_NO                                           
MFA-TR*            ,TRAN_APPL_NO                                                
MFA-TR*            ,CODE_AR_AGE                                                 
MFA-TR*            ,GL_ACCT_CREDIT                                              
MFA-TR*            ,GL_ACCT_DEBIT                                               
MFA-TR*            ,AMT_POSTED                                                  
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,CODE_CONTRACT_TYPE                                          
MFA-TR*            ,CURRENCY_TYPE                                               
MFA-TR*            ,CURRENCY_AMT)                                               
MFA-TR*         VALUES                                                          
MFA-TR*           ( :AU-ACCOUNT-NO                                              
MFA-TR*            ,:AU-TRANS-HIST-SEQ-NO                                       
MFA-TR*            ,:AU-TRAN-APPL-NO                                            
MFA-TR*            ,:AU-CODE-AR-AGE                                             
MFA-TR*            ,:AU-GL-ACCT-CREDIT                                          
MFA-TR*            ,:AU-GL-ACCT-DEBIT                                           
MFA-TR*            ,:AU-AMT-POSTED                                              
MFA-TR*            ,:AU-ITEM-ID                                                 
MFA-TR*            ,:AU-CODE-CONTRACT-TYPE                                      
MFA-TR*            ,:AU-CURRENCY-TYPE                                           
MFA-TR*            ,:AU-CURRENCY-AMT)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T18189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18189     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T18189     OR NOT-FOUND                                                 
T18189        NEXT SENTENCE                                             
T18189     ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7580-INSERT-AR-TRN-HST-DET'       
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
T18189        PERFORM 9900-ABEND THRU 9900-EXIT                         
T18189     END-IF.                                                      
T18189                                                                  
T18189 7580-EXIT.                                                       
T18189     EXIT.                                                        
      *                                                                 09720100
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7590-UPDATE-JOB-PARM-TABLE.                                  *  09749500
      *     INCREMENTS YEAR ON JOB PARM TABLE FOR START DATE AND END *  09749600
      *     DATE.                                                    *  09749700
      *                                                              *  09749800
      ****************************************************************  09749900
      *                                                                 09750000
       7590-UPDATE-JOB-PARM-TABLE.                                      
                                                                        
           ADD 1 TO WS-BEGIN-DATE-YR-R.                                 
           ADD 1 TO WS-END-DATE-YR-R.                                   
           MOVE WS-JOB-PARM-DATA TO G6-PARM-DATA.                       
           MOVE 'PARM' TO G6-CMND-CODE.                                 
           MOVE 0001 TO G6-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                SET PARM_DATA    = :G6-PARM-DATA                        
T27271        WHERE COMPANY_NO   = :WS-SYSIN-COMP-NO                    
                AND PROGRAM_NAME = :PROGRAM-NAME                        
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND SEQ_NO       = :G6-SEQ-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '** PCSCA693 PROCESSING ERROR'                   
               DISPLAY '** PARAGRAPH = 7590-UPDATE-JOB-PARM-TABLE'      
               DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '** PROCESSING TERMINATED'                       
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7700-SELECT-JRNL-DETAILS.                                **          
      **      SELECTS REV_DISTRICT_CD, CODE_EMPL_ACCT, CODE_PREMISE **          
      **      STAT FROM TABLES CSS_ACCOUNT, CSS_PREMISE &           **          
      **      CSS_CUSTOMER.                                         **          
      ****************************************************************          
      *                                                                         
       7700-SELECT-JRNL-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT PR.REV_DISTRICT_CD                                
                     ,CU.CODE_EMPL_ACCT                                 
                     ,AT.CODE_COMPANY_ACCT                              
                     ,AT.CODE_ACCT_STAT                                 
                     ,PR.CODE_PREMISE_STAT                              
                 INTO :PR-REV-DISTRICT-CD                               
                     ,:CU-CODE-EMPL-ACCT                                
                     ,:AT-CODE-COMPANY-ACCT                             
                     ,:AT-CODE-ACCT-STAT                                
                     ,:PR-CODE-PREMISE-STAT                             
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                     ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND AT.PREMISE_NO = PR.PREMISE_NO                     
                  AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
ACT067                                                           
ACT067                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PR.REV_DISTRICT_CD                                        
MFA-TR*              ,CU.CODE_EMPL_ACCT                                         
MFA-TR*              ,AT.CODE_COMPANY_ACCT                                      
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,PR.CODE_PREMISE_STAT                                      
MFA-TR*          INTO :PR-REV-DISTRICT-CD                                       
MFA-TR*              ,:CU-CODE-EMPL-ACCT                                        
MFA-TR*              ,:AT-CODE-COMPANY-ACCT                                     
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:PR-CODE-PREMISE-STAT                                     
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*              ,CSS_CUSTOMER CU                                           
MFA-TR*         WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7700                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSCA693 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7700-SELECT-JRNL-DETAILS'         
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
T18189        PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ** TO GET COMMON DATE FROM JOB PARM                            **         
                                                                        
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      * CHECK AR LOCKOUT *********************************************          
PCR640*7999-SELECT-AL                                                           
PCR640     EXEC SQL                                                             
PCR640         INCLUDE CPD00075                                                 
PCR640     END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8000-PRINT-HDR-693-1.                                        *        
      *   IT WRITES THE REPORT 1 HEADERS WHEN EVER THERE IS CHANGE IN  *        
      *   COMPANY NO. WRITES DIFFERENT TITLES BASED ON ALL CHECKS SET  *        
      *   TO ESCHEATMENT, AND ALL CHECKS SET TO ESCHEATMENT FOR AN     *        
      *   AMOUNT >= $25.00.                                            *        
      ******************************************************************        
       8000-PRINT-HDR-693-1.                                            
      *                                                                         
           IF CSR-DATABASE                                              
             MOVE 'PCSCA693-1' TO P-RPT-PGRMNAME-1                      
           ELSE                                                         
              IF SEB-DATABASE                                           
C37112          IF WS-DEREG-REG = SPACES                                
C37112             MOVE 'PCSCA693-1' TO P-RPT-PGRMNAME-1                
C37112          ELSE                                                    
C37112             MOVE 'PCSCA693-2' TO P-RPT-PGRMNAME-1                
C37112          END-IF                                                  
C37112        END-IF                                                    
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-1                       
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-2                       
                 AFTER ADVANCING 1 LINE.                                
C35809     IF SEB-DATABASE                                              
C35809       WRITE PRT33-RECORD FROM WS-RPT-TITLE-2B                    
C35809            AFTER ADVANCING 1 LINE                                
C35809     ELSE                                                         
C35809       CONTINUE                                                   
C35809     END-IF.                                                      
           ADD +1 TO WS-RPT1-PAGE-NO.                                   
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33-RECORD FROM WS-RPT-TITLE-3                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-11                  
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-12                  
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT1-LINE-NO.                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                *        
      *   8050-PRINT-HEADER-693-2.                                     *        
      *   WRITES HEADER FOR REPORT 2 WHENEVER THERE IS A PAGE BREAK    *        
      *   FOR REPORT 2.                                                *        
      ******************************************************************        
       8050-PRINT-HDR-693-2.                                            
      *                                                                         
           IF CSR-DATABASE                                              
              MOVE 'PCSCA693-2' TO P-RPT-PGRMNAME-1                     
           ELSE                                                         
              IF SEB-DATABASE                                           
C37112           IF WS-DEREG-REG = SPACES                               
C37112              MOVE 'PCSCA693-3' TO P-RPT-PGRMNAME-1               
C37112           ELSE                                                   
C37112              MOVE 'PCSCA693-4' TO P-RPT-PGRMNAME-1               
C37112           END-IF                                                 
C37112        END-IF                                                    
           END-IF.                                                      
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-1                      
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-2                      
                 AFTER ADVANCING 1 LINE.                                
C35809     IF SEB-DATABASE                                              
C35809       WRITE PRT33A-RECORD FROM WS-RPT-TITLE-2B                   
C35809             AFTER ADVANCING 1 LINE                               
C35809     ELSE                                                         
C35809       CONTINUE                                                   
C35809     END-IF.                                                      
           ADD +1 TO WS-RPT2-PAGE-NO.                                   
           MOVE WS-RPT2-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-3                      
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33A-RECORD FROM WS-RPT-TITLE-4                      
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           WRITE PRT33A-RECORD FROM WS-PRINT-REP-HDR-11                 
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33A-RECORD FROM WS-PRINT-REP-HDR-12                 
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT2-LINE-NO.                              
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    WRITES TOTAL LINE IN REPORT.                                         
      ******************************************************************        
      *                                                                         
       8100-TOTAL-PARA.                                                 
      *                                                                         
           IF WS-GRAND-TOTAL-NUMBER-1 NOT = 0                           
              MOVE WS-GRAND-TOTAL-NUMBER-1 TO WS-PRT-GRAND-NUMBER       
              MOVE WS-GRAND-TOTAL-AMOUNT-1 TO WS-PRT-GRAND-AMOUNT       
              WRITE PRT33-RECORD FROM WS-PRT-GRAND-TOTALS               
                    AFTER ADVANCING 3 LINES                             
              INITIALIZE WS-PRT-GRAND-TOTALS                            
           END-IF.                                                      
           IF WS-GRAND-TOTAL-NUMBER-2 NOT = 0                           
              MOVE WS-GRAND-TOTAL-NUMBER-2 TO WS-PRT-GRAND-NUMBER       
              MOVE WS-GRAND-TOTAL-AMOUNT-2 TO WS-PRT-GRAND-AMOUNT       
              WRITE PRT33A-RECORD FROM WS-PRT-GRAND-TOTALS              
                      AFTER ADVANCING 3 LINES                           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    WRITES NO-DATA-LINE IN REPORT IF NO RECORDS ARE FETCHED.             
      ******************************************************************        
      *                                                                         
       8300-NO-DATA-PARA.                                               
      *                                                                         
           PERFORM 8000-PRINT-HDR-693-1 THRU 8000-EXIT.                 
T23643     PERFORM 8050-PRINT-HDR-693-2 THRU 8050-EXIT                  
           WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER                
                 ADVANCING 2 LINES.                                     
           WRITE PRT33A-RECORD FROM WS-NO-DATA-LINE AFTER               
                 ADVANCING 2 LINES.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08080000
      ****************************************************************  08090000
T18189**   8400-MOVE-AR-TRANS-DETAIL.                               **          
T18189**       MOVES THE DETAILS INTO THE HOST-VARIABLES OF         **          
T18189**       CSS_AR_TRANS_HIST                                    **          
T18189****************************************************************          
T18189*                                                                         
T18189 8400-MOVE-AR-TRANS-DETAIL.                                       
T18189*                                                                         
T18189     MOVE AT-ACCOUNT-NO                TO  AR-ACCOUNT-NO.         
T18189     MOVE WS-CURRENT-TIMESTAMP         TO  AR-TRANS-HIST-SEQ-NO.  
T18189     MOVE WS-DATE-TRANS                TO  AR-DATE-TRANS.         
T18189     MOVE WS-A                         TO  AR-CODE-TRAN-TYPE.     
T18189     MOVE RN-AMT-REFUNDED              TO  AR-AMT-ORIG-ENTERED.   
T18189     MOVE AT-TOTAL-AR-BALANCE          TO  AR-AMT-BILLED-UNPAID.  
T18189     MOVE '420'                        TO  AR-RESP-AREA-ID.       
T18189     MOVE WS-PGRMNAME                  TO  AR-APPL-PROGRAM-ID.    
T18189     MOVE 'SYSTEM'                     TO  AR-USER-ID.            
T18189     MOVE AT-COMPANY-NO                TO  AR-COMPANY-NO.         
T18189     MOVE BC-CASH-COMPANY-NO           TO  AR-CASH-COMPANY-NO.    
T18189     MOVE BC-CASH-LOCAL-OFFICE         TO  AR-CASH-LOCAL-OFFICE.  
T18189     MOVE BC-CASH-REPORT-NO            TO  AR-CASH-REPORT-NO.     
T18189     MOVE RN-REFUND-CHECK-NO           TO  WS-CHK-NUM.            
T18189     MOVE WS-TRANSFER-MSG              TO  AR-TRAN-COMMENT-TEXT.  
T18189     MOVE +32                          TO  AR-TRAN-COMMENT-LEN.   
T18189*                                                                         
T18189 8400-EXIT.                                                       
T18189     EXIT.                                                        
T18189*                                                                         
T18189****************************************************************          
T18189**   8450-MOVE-AR-TRANS-DET-DETAIL.                           **          
T18189**       MOVES THE DETAILS INTO THE HOST-VARIABLES OF TABLE   **          
T18189**       CSS_AR_TRN_HST_DET.                                  **          
T18189****************************************************************          
T18189*                                                                         
T18189 8450-MOVE-AR-TRANS-DET-DETAIL.                                   
T18189     MOVE AT-ACCOUNT-NO                TO  AU-ACCOUNT-NO.         
T18189     MOVE WS-CURRENT-TIMESTAMP         TO  AU-TRANS-HIST-SEQ-NO.  
T18189     MOVE 01                           TO  AU-TRAN-APPL-NO.       
T18189     MOVE 'P'                          TO  AU-CODE-AR-AGE.        
T18189     MOVE WS-101-ACCT-GEN-LED-DR       TO  AU-GL-ACCT-DEBIT.      
T18189     MOVE WS-101-ACCT-GEN-LED-CR       TO  AU-GL-ACCT-CREDIT.     
T18189     MOVE RN-AMT-REFUNDED              TO  AU-AMT-POSTED          
T18189                                           AU-CURRENCY-AMT.       
T18189     MOVE 01                           TO  AU-ITEM-ID.            
T18189     MOVE 'E'                          TO  AU-CODE-CONTRACT-TYPE. 
T18189     MOVE SPACES                       TO  AU-CURRENCY-TYPE.      
T18189*                                                                         
T18189 8450-EXIT.                                                       
T18189     EXIT.                                                        
T18189*                                                                         
T18189****************************************************************          
T18189**   8500-MOVE-STATE-FILE.                                    **          
T18189**       MOVES THE DETAILS INTO THE FILE THAT WILL BE SENT    **          
T18189**       TO THE STATE AGENCY.                                 **          
T18189****************************************************************          
T18189*                                                                         
T18189 8500-MOVE-STATE-FILE.                                            
           MOVE AT-ACCOUNT-NO TO E-FRP693-ACCOUNT-NO.                   
           PERFORM 7300-GET-SSN THRU 7300-EXIT.                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-SSN TO WS-CE-SSN                                  
              IF WS-CE-SSN NOT = SPACES                                 
                 MOVE WS-CE-SSN-3 TO WS-PRINT-SSN-3                     
                 MOVE WS-CE-SSN-2 TO WS-PRINT-SSN-2                     
                 MOVE WS-CE-SSN-4 TO WS-PRINT-SSN-4                     
                 MOVE WS-PRINT-SSN TO E-FRP693-SSN                      
              ELSE                                                      
                 MOVE ZEROS TO WS-PRINT-SSN-3                           
                 MOVE ZEROS TO WS-PRINT-SSN-2                           
                 MOVE ZEROS TO WS-PRINT-SSN-4                           
                 MOVE WS-PRINT-SSN TO E-FRP693-SSN                      
              END-IF                                                    
           ELSE                                                         
              PERFORM 7400-SELECT-TAX-ID THRU 7400-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF BS-TAX-ID NOT = SPACES                              
                    MOVE BS-TAX-ID TO E-FRP693-SSN                      
                 ELSE                                                   
                    MOVE ZEROS TO E-FRP693-SSN                          
                 END-IF                                                 
              ELSE                                                      
                 MOVE ZEROS TO E-FRP693-SSN                             
              END-IF                                                    
           END-IF.                                                      
           MOVE DQ-TITLE-PREFIX TO E-FRP693-PREFIX.                     
           IF DQ-FIRST-NAME > SPACES                                    
              MOVE DQ-FIRST-NAME TO E-FRP693-FIRST-NAME                 
              MOVE DQ-MIDDLE-NAME TO WS-MIDDLE-NAME-ALL                 
              MOVE WS-MIDDLE-INIT TO E-FRP693-MIDDLE-INITIAL            
              MOVE DQ-LAST-NAME TO E-FRP693-LAST-NAME                   
           ELSE                                                         
              MOVE DQ-FULL-NAME TO E-FRP693-FIRST-NAME                  
              MOVE SPACES TO E-FRP693-MIDDLE-INITIAL                    
                             E-FRP693-LAST-NAME                         
           END-IF.                                                      
           MOVE WS-FMT-TITLE-SUFFIX-1 TO E-FRP693-SUFFIX.               
           IF WS-MAIL-ADDR-STREET = SPACES                              
              MOVE WS-PR-STREET TO E-FRP693-STREET-1                    
              MOVE WS-PR-ADDR-OVERFLOW TO E-FRP693-STREET-2             
           ELSE                                                         
              MOVE WS-MAIL-ADDR-STREET TO E-FRP693-STREET-1             
              MOVE WS-MAIL-ADDR-OVERFLOW TO E-FRP693-STREET-2           
           END-IF.                                                      
           MOVE WS-CITY TO E-FRP693-CITY.                               
           MOVE WS-STATE TO E-FRP693-STATE.                             
           MOVE DY-ZIP-CODE TO WS-ZIP-FIVE.                             
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-ZIP-FOUR                 
           ELSE                                                         
              MOVE '0000' TO WS-ZIP-FOUR                                
           END-IF                                                       
           MOVE WS-ZIP-PLUS-FOUR TO E-FRP693-ZIP-CODE.                  
           MOVE RN-AMT-REFUNDED TO WS-AMT-REFUNDED.                     
           MOVE WS-AMT-REFUNDED TO E-FRP693-AMOUNT.                     
           MOVE RN-REFUND-CHECK-NO TO E-FRP693-CHECK-NO.                
           IF WS-NULL-REQUEST-DT = ZERO                                 
              MOVE RN-REQUEST-DT TO WS-REQUEST-DT                       
              MOVE WS-REQUEST-MM TO E-FRP693-TRANS-MM                   
              MOVE '-' TO WS-REQUEST-SL1                                
              MOVE WS-REQUEST-SL1 TO E-FRP693-TRANS-SL1                 
              MOVE WS-REQUEST-DD TO E-FRP693-TRANS-DD                   
              MOVE '-' TO WS-REQUEST-SL2                                
              MOVE WS-REQUEST-SL2 TO E-FRP693-TRANS-SL2                 
              MOVE WS-REQUEST-YY TO E-FRP693-TRANS-YY                   
           END-IF.                                                      
           MOVE 'UTIL DEPOSITS' TO E-FRP693-CASH-TYPE.                  
           MOVE 'UNCASHED' TO E-FRP693-CASH-STATUS.                     
           MOVE '57-0784499' TO E-FRP693-COMPANY-FEIN.                  
           MOVE 'SC' TO E-FRP693-STATE-OF-INC.                          
           WRITE E-FIORP693.                                            
T18189*                                                                         
T18189 8500-EXIT.                                                       
T18189     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8550-MOVE-STATUS-CODE-DESCR                              **          
      **       MOVES THE STATUS CODE DESCRIPTION TO OUTPUT FIELD.   **          
      ****************************************************************          
      *                                                                         
       8550-MOVE-STATUS-CODE-DESCR.                                     
                                                                        
           EVALUATE RN-CHECK-STATUS-CD                                  
               WHEN 'A'                                                 
                   MOVE 'APPROVED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'C'                                                 
                   MOVE 'CANCELLED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'D'                                                 
                   MOVE 'DISAPPROVED   ' TO P-RPT1-CHECK-STATUS         
               WHEN 'E'                                                 
                   MOVE 'SENT FOR ESCHE' TO P-RPT1-CHECK-STATUS         
               WHEN 'F'                                                 
                   MOVE 'FORGED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'I'                                                 
                   MOVE 'ISSUED        ' TO P-RPT1-CHECK-STATUS         
               WHEN 'L'                                                 
                   MOVE 'CLEARED       ' TO P-RPT1-CHECK-STATUS         
               WHEN 'M'                                                 
                   MOVE 'REMAILED      ' TO P-RPT1-CHECK-STATUS         
               WHEN 'R'                                                 
                   MOVE 'REQUESTED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'S'                                                 
                   MOVE 'STOP PAYMENT  ' TO P-RPT1-CHECK-STATUS         
               WHEN 'T'                                                 
                   MOVE 'ESCHEATED     ' TO P-RPT1-CHECK-STATUS         
               WHEN 'U'                                                 
                   MOVE 'UNDELIVERABLE ' TO P-RPT1-CHECK-STATUS         
               WHEN 'X'                                                 
                   MOVE 'VOIDED        ' TO P-RPT1-CHECK-STATUS         
           END-EVALUATE.                                                
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26474                                                                  
C26474 8600-CREATE-SEB-FILE.                                            
C26474     INITIALIZE E-FCA95-OUTPUT-REC.                               
T29199     MOVE C8-DESCRIPTION(3:13)   TO E-FCA95-WACHOVIA-ACCOUNT-NO.  
C26474     MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
C26474     MOVE WS-CHECK-NO-HOLD       TO E-FCA95-CHECK-NO.             
C26474     MOVE RN-AMT-REFUNDED        TO E-FCA95-AMOUNT.               
C26474     MOVE RN-DATE-REFUNDED(3:2)  TO WS-ISSUE-YY.                  
C26474     MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM.                  
C26474     MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD.                  
C26474     MOVE WS-ISSUE-HOLD          TO WS-ISSUE-DATE.                
C26474     MOVE WS-ISSUE-DATE          TO E-FCA95-ISSUE-DATE.           
C26474     MOVE 'V'                    TO E-FCA95-VOID-CODE.            
C26474                                                                  
C26474     WRITE FIOCA95.                                               
C26474                                                                  
C26474     IF FCA95-SUCCESSFUL                                          
C26474        CONTINUE                                                  
C26474     ELSE                                                         
C26474        DISPLAY '**  ABEND IN 8600-CREATE-SEB-FILE       **'      
C26474        DISPLAY '**  RETURN CODE = ' WS-FCA95-STATUS              
C26474        DISPLAY '**  PROCESSING TERMINATED               **'      
C26474        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26474     END-IF.                                                      
C26474*                                                                         
C26474 8600-EXIT.                                                       
C26474     EXIT.                                                        
C26474*                                                                         
C26474 8610-CREATE-SCEG-FILE.                                           
C26474     INITIALIZE E-FCA96-OUTPUT-REC.                               
T29199     MOVE C8-DESCRIPTION(3:13)   TO E-FCA96-WACHOVIA-ACCOUNT-NO.  
C26474     MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
C26474     MOVE WS-CHECK-NO-HOLD       TO E-FCA96-CHECK-NO.             
C26474     MOVE RN-AMT-REFUNDED        TO E-FCA96-AMOUNT.               
C26474     MOVE RN-DATE-REFUNDED(3:2)  TO WS-ISSUE-YY.                  
C26474     MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM.                  
C26474     MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD.                  
C26474     MOVE WS-ISSUE-HOLD          TO WS-ISSUE-DATE.                
C26474     MOVE WS-ISSUE-DATE          TO E-FCA96-ISSUE-DATE.           
C26474     MOVE 'V'                    TO E-FCA96-VOID-CODE.            
C26474                                                                  
C26474     WRITE FIOCA96.                                               
C26474                                                                  
C26474     IF FCA96-SUCCESSFUL                                          
C26474        CONTINUE                                                  
C26474     ELSE                                                         
C26474        DISPLAY '**  ABEND IN 8610-CREATE-SCEG-FILE       **'     
C26474        DISPLAY '**  RETURN CODE = ' WS-FCA96-STATUS              
C26474        DISPLAY '**  PROCESSING TERMINATED               **'      
C26474        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26474     END-IF.                                                      
C26474*                                                                         
C26474 8610-EXIT.                                                       
C26474     EXIT.                                                        
C26474*                                                                         
C26474 8620-CREATE-PSNC-FILE.                                           
C26474     INITIALIZE E-FCA97-OUTPUT-REC.                               
T29199     MOVE C8-DESCRIPTION(3:13)   TO E-FCA97-WACHOVIA-ACCOUNT-NO.  
C26474     MOVE RN-REFUND-CHECK-NO     TO WS-REST-OF-NUMBER.            
C26474     MOVE WS-CHECK-NO-HOLD       TO E-FCA97-CHECK-NO.             
C26474     MOVE WS-CHECK-NO-HOLD       TO E-FCA97-CHECK-NO.             
C26474     MOVE RN-AMT-REFUNDED        TO E-FCA97-AMOUNT.               
C26474     MOVE RN-DATE-REFUNDED(1:4)  TO WS-ISSUE-YY-FIRST-UNION.      
C26474     MOVE RN-DATE-REFUNDED(6:2)  TO WS-ISSUE-MM-FIRST-UNION.      
C26474     MOVE RN-DATE-REFUNDED(9:2)  TO WS-ISSUE-DD-FIRST-UNION.      
C26474     MOVE WS-ISSUE-HOLD-FIRST-UNION TO WS-ISS-DATE-FIRST-UNION.   
C26474     MOVE WS-ISS-DATE-FIRST-UNION TO E-FCA97-ISSUE-DATE.          
C26474                                                                  
C26474     MOVE 'V'                    TO E-FCA97-VOID-CODE.            
C26474                                                                  
C26474     WRITE FIOCA97.                                               
C26474                                                                  
C26474     IF FCA97-SUCCESSFUL                                          
C26474        CONTINUE                                                  
C26474     ELSE                                                         
C26474        DISPLAY '**  ABEND IN 8620-CREATE-PSNC-FILE       **'     
C26474        DISPLAY '**  RETURN CODE = ' WS-FCA97-STATUS              
C26474        DISPLAY '**  PROCESSING TERMINATED               **'      
C26474        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26474     END-IF.                                                      
C26474*                                                                         
C26474 8620-EXIT.                                                       
C26474     EXIT.                                                        
C26474                                                                  
C26474************************************************************              
C26474** WRITES RECONCILIATION HEADER FOR FIRST UNION POSITIVE  **              
C26474** PAY FILE.                                              **              
C26474**                                                        **              
C26474*                                                                         
C26474************************************************************              
C26474 8630-WRITE-RECONCILE-HDR.                                        
C26474                                                                  
C26474     MOVE 'RECONCILIATIONHEADER' TO E-FCA97-RECONCILE-HDR.        
C26474     MOVE 0001 TO E-FCA97-BANK-NO.                                
T29199     MOVE E-FCA97-WACHOVIA-ACCOUNT-NO TO E-FCA97-BANK-ACCOUNT-NO. 
C26474     MOVE WS-TOT-ESCHEAT-AMT     TO E-FCA97-TOTAL-AMOUNT.         
C26474     MOVE WS-TOT-ESCHEAT-CNT     TO E-FCA97-TOTAL-ITEM-COUNT.     
C26474     WRITE FIOCA97-HEADER-REC.                                    
C26474                                                                  
C26474 8630-EXIT.                                                       
C26474     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8900-WRITE-FCSPT33                                           *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8900-WRITE-FCSPT33.                                              
      *                                                                         
           IF WS-RPT1-LINE-NO > 50                                      
              PERFORM 8000-PRINT-HDR-693-1 THRU 8000-EXIT               
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-PRINT-REP-DET-11                  
                 AFTER  ADVANCING 1 LINE.                               
           ADD 1 TO WS-RPT1-LINE-NO.                                    
           ADD RN-AMT-REFUNDED TO WS-GRAND-TOTAL-AMOUNT-1.              
           ADD 1 TO WS-GRAND-TOTAL-NUMBER-1.                            
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8950-WRITE-FCSPT33A                                          *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8950-WRITE-FCSPT33A.                                             
      *                                                                         
           IF WS-RPT2-LINE-NO > 50                                      
              PERFORM 8050-PRINT-HDR-693-2 THRU 8050-EXIT               
              MOVE ZEROES TO WS-RPT2-LINE-NO                            
           END-IF.                                                      
           WRITE PRT33A-RECORD FROM WS-PRINT-REP-DET-11                 
                 AFTER  ADVANCING 1 LINE.                               
           ADD 1 TO WS-RPT2-LINE-NO.                                    
           ADD RN-AMT-REFUNDED TO WS-GRAND-TOTAL-AMOUNT-2               
           ADD 1 TO WS-GRAND-TOTAL-NUMBER-2.                            
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PCR640*****************************                                             
PCR640 9000-SEND-ERROR-RESULT.                                          
                                                                        
PCR640     GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   9000-CLOSE-FILES.                                            *        
      *                                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *                                                                         
C37112     IF CSR-DATABASE                                              
C37112       PERFORM 8100-TOTAL-PARA THRU 8100-EXIT                     
C37112     ELSE                                                         
C37112       IF SEB-DATABASE                                            
C37112         IF PRINT-REG-HDR                                         
C37112           NEXT SENTENCE                                          
C37112         ELSE                                                     
C37112           PERFORM 8100-TOTAL-PARA THRU 8100-EXIT                 
C37112         END-IF                                                   
C37112       END-IF                                                     
C37112     END-IF.                                                      
C35809     IF WS-GT25-SW = 'N'                                          
C35809       IF WS-DEREG-REG = 'R'                                      
C35809         PERFORM 8050-PRINT-HDR-693-2 THRU 8050-EXIT              
C35809         WRITE PRT33A-RECORD FROM WS-NO-DATA-LINE AFTER           
C35809                     ADVANCING 2 LINES                            
C35809     END-IF
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE                     
                 AFTER ADVANCING 3 LINES.                               
           WRITE PRT33A-RECORD FROM WS-END-DATA-LINE                    
                 AFTER ADVANCING 3 LINES.                               
                                                                        
4620       IF CURSOR-OPEN                                               
4620             PERFORM 7015-CLOSE-CURSOR THRU 7015-EXIT               
4620       END-IF.                                                      
                                                                        
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT33A-FILE.                                         
           CLOSE FCSRP693-FILE.                                         
C26474     IF  SEB-DATABASE                                             
C26474         CLOSE FCSCA95-FILE                                       
C26474     ELSE                                                         
C26474        IF  WS-COMPANY-NUMBER = '01'                              
C26474            CLOSE FCSCA96-FILE                                    
C26474        ELSE                                                      
C26474            CLOSE FCSCA97-FILE                                    
C26474        END-IF                                                    
C26474     END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 6010-REDUCE-EMBEDDED-SPACES .                               **         
      *****************************************************************         
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      * TO CALL PARA TO CREATE BATCH JOURNAL.                                   
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
      * TO GET TODAY'S DATE FROM JOB PARM TABLE                                 
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
                                                                        
      * TO GET NAME AND MAIL OR SERVICE ADDRESS                                 
                                                                        
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
      *                                                                         
TP5109* 9700-PROCESS-ABEND.                                                     
TP5109 COPY CPD0023B.                                                           
      *                                                                         
      * AR-LOCKOUT ERROR * DEFINED IN AR-LOCKOUT CPD00075                       
PCR640 9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                         
      *                                                                         
      ****************************************************************          
      **      THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
