       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA690.                                        
       DATE-WRITTEN.   JUL 2008.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      **                                                             ** 00080000
      **                CUSTOMER INFORMATION SYSTEM                  ** 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **                P R O G R A M S U M M A R Y                  ** 00120000
      **                                                             ** 00130000
      **                                                             ** 00140000
      **         F U N C T I O N A L  D E S C R I P T I O N          ** 00150000
      **                         O F  M O D U L E                    ** 00160000
      **                                                             ** 00170000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  GET THE CHECKS IN APPROVED STATUS FOR ACTIVE AND FINAL     ** 00200000
      **  BILLED ACCOUNT FROM CSS_REFUND AND SPLIT IT INTO 2 ROWS    ** 00210000
      **  IF THE CRITERIA ARE MET                                    ** 00220000
      **                                                             ** 00230000
      **  LOGIC :                                                    ** 00240000
      **                                                             ** 00250000
      **  THE PROGRAM WILL PROCESS ALL OF THE RECORDS ON THE CSS_    ** 00260000
      **  REFUND TABLE THAT HAVE A CHECK_STATUS_CD = 'A'. REFUND     ** 00270000
      **  CHECKS ARE SPLIT IF A DEPOSIT PORTION EXISTS IN THE        ** 00280000
      **  REFUND. THEY ARE DONE FOR FINAL BILLED AND ACTIVE ACCOUNTS ** 00290000
      **                                                             ** 00300000
      ***************************************************************** 00340000
      **                                                             ** 00350000
      **              PROGRAM  MODIFICATION  LOG                     ** 00360000
      **    DATE    INITIALS     REASON                              ** 00370000
      **  ________  _______      ______                              ** 00380000
      ** 07/18/2008  DM94438     INITIAL VERSION                     **         
ACT209** 06/30/2016  SS7F226     CHANGES TO POPULATE ESCHEATMENT_CD  **         
ACT209**              A05460     FOR WRITEOFF ACCOUNTS.              **         
      ***************************************************************** 00491700
                    ---- BASIC BATCH SEQUENCE STRUCTURE -------------   
                    0000 - 0000     MAIN CONTROL PATH                   
                    --------------------------------------------------- 
                    0100 - 0100     INITIALIZE SWITCHES AND COUNTERS    
                                    OPEN FILES                          
                    --------------------------------------------------- 
                    1000 - 1000     MAIN PROCESSING LOOP                
                    --------------------------------------------------- 
                    7000 - 7500     INQUIRY CALLS TO DATABASES          
                    --------------------------------------------------- 
                    8000 - 8000     CREATE EXTRACT                      
                    --------------------------------------------------- 
                    9000 - 9000     TERMINATE                           
                    --------------------------------------------------- 
                    9900 - 9900     ABEND                               
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSC690-FILE  ASSIGN UT-S-FCSC690                     
                              STATUS IS WS-C690-STATUS.                 
      *                                                                 00650000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSC690-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01 FIOC690-REC.                                                 
           05 E-C690-ACCOUNT-NO                PIC 9(13).               
           05 E-C690-ESC-CD                    PIC X(01).               
      *                                                                 00720000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA690'.
MSQ017     COPY MFASQLM.
      *                                                                 00740000
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40) VALUE              
              'WORKING STORAGE FOR PCSCA690 STARTS HERE'.               
           05  WS-ACCOUNT-NO      PIC S9(13)V COMP-3 VALUE 0.           
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-DATE-TRANS               PIC X(10) VALUE SPACES.      
                                                                        
           05  WS-REFUND-AMT               PIC 9(09)V99 VALUE ZEROES.   
           05  WS-DEPOSIT-AMT              PIC 9(09)V99 VALUE ZEROES.   
           05  WS-MAX-REFUND-ITEM-ID       PIC S9(9) USAGE COMP.        
           05  WS-REFUND-ITEM-ID-NI        PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-INDICATORS          PIC S9(04) USAGE COMP.       
           05  WS-NULL-INDICATOR-1         PIC S9(04) USAGE COMP.       
           05  WS-NULL-INDICATOR-2         PIC S9(04) USAGE COMP.       
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
      *                                                                 01350000
       01  WS-SWITCHES.                                                 
           05  WS-C690-STATUS           PIC X(02).                      
               88  C690-SUCCESSFUL      VALUE '00'.                     
           05  WS-REFUND-EOF-SW            PIC X(01) VALUE 'N'.         
               88  END-OF-REFUND                     VALUE 'Y'.         
           05  WS-DATA-ACCT                PIC X(03) VALUE 'YES'.       
               88  NO-MORE-DATA-ACCT                 VALUE 'NO'.        
      *                                                                 01530000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA690'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA690'.  
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
      *                                                                 01590000
       01  WS-COMPANY-NO                   PIC X(02).                   
                                                                        
      /****** JOBS FILE/TABLE DEFINITIONS                               03008000
           COPY FIOCA00.                                                03009000
           COPY FIOJC01.                                                03010000
      /****** CWS00038 IS JC01 WORK DATA                                03020000
       COPY CWS00038.                                                   03030000
      /****** CWS00039 IS CA00 WORK DATA                                03040000
       COPY CWS00039.                                                   03040100
      /****** CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                03040200
       COPY CWS00303.                                                   03040300
      /****** CWS09900 CONTAINS ABEND WS VARIABLES                      03040400
       COPY CWS09900.                                                   03040500
      /****** CWS00010 CONTAINS DB2 ABEND VARIABLES                     03040600
       COPY CWS00010.                                                   03040700
      /****** CWS00011 CONTAINS VARIABLES FOR CPD00004                  03043000
       COPY CWS00011.                                                   03044000
      *                                                                 03045000
           EXEC SQL                                                     03046000
             INCLUDE SQLCA                                              03047000
           END-EXEC.                                                    03048000
      *                                                                 03049000
           EXEC SQL                                                     03050000
             INCLUDE TBACCT                                             03060000
           END-EXEC.                                                    03070000
      *                                                                 03080000
           EXEC SQL                                                     03090000
             INCLUDE TBREFUND                                           03100000
           END-EXEC.                                                    03110000
      *                                                                         
           EXEC SQL                                                     03090000
             INCLUDE TBRFNRSN                                           03100000
           END-EXEC.                                                    03110000
      *                                                                 03120000
           EXEC SQL                                                     03170000
             INCLUDE TBNAME                                             03180000
           END-EXEC.                                                    03190000
      *                                                                 03200000
           EXEC SQL                                                     03250000
             INCLUDE TBJBPARM                                           03260000
           END-EXEC.                                                    03270000
      *                                                                 03280000
           EXEC SQL                                                     03561000
             INCLUDE TBARHDT                                            03562000
           END-EXEC.                                                    03563000
      *                                                                 03564000
           EXEC SQL                                                     03561000
             INCLUDE TBARHIST                                           03562000
           END-EXEC.                                                    03563000
      *                                                                 03564000
           EXEC SQL                                                     03589900
               INCLUDE TBARLOCK                                         03590000
           END-EXEC.                                                    03590100
      *                                                                 03710000
           EXEC SQL                                                     03720000
               INCLUDE TBMNHIST                                         03730000
           END-EXEC.                                                    03740000
      *                                                                 03750000
           EXEC SQL                                                     03760000
               INCLUDE TBMNHDT                                          03770000
           END-EXEC.                                                    03780000
      *                                                                 03790000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACCOUNT_CURSOR CURSOR FOR                       
                SELECT  RN.ACCOUNT_NO                                   
                       ,RN.REFUND_CHECK_NO                              
                       ,RN.DEPOSIT_CERT_NO                              
                       ,RN.CHECK_STATUS_CD                              
                       ,RN.RETURNED_REASON                              
                       ,RN.MANUAL_INDICATOR                             
                       ,RN.USER_ID_APPRVD_BY                            
                       ,RN.REFUND_STATUS_DT                             
                       ,RN.USER_ID_RQSTED_BY                            
                       ,RN.PANEL_NO                                     
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RN.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                            
                       ,RN.COMMENTS                                     
                       ,RN.AMT_REFUNDED                                 
                       ,RN.DATE_REFUNDED                                
                       ,RN.CHECK_ISS_REAS_CD                            
                       ,RN.REQUEST_DT                                   
                       ,RN.LOCAL_OFFICE                                 
                       ,RN.REFUND_ITEM_ID                               
                       ,RN.ADDRESS_ID                                   
                       ,RN.ORIGINAL_CHECK_NO                            
                       ,RN.ESCHEATMENT_CD                               
                       ,AT.COMPANY_NO                                   
                       ,AT.PREMISE_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,AT.CUSTOMER_NO                                  
                       ,AT.CODE_COMPANY_ACCT                            
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.BILL_CYCLE                                   
                       ,AT.TOTAL_AR_BALANCE                             
                       ,AT.ADDRESS_ID                                   
                       ,AT.ADDRESS_FORMAT                               
                       ,RU.CHECK_ISS_RSN_DESC                           
                       ,AT.ACCOUNT_TYPE_CODE                            
                FROM    CSS_REFUND RN WITH(READUNCOMMITTED)                     
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_REFUND_REASON RU WITH(READUNCOMMITTED)              
               WHERE    RN.MANUAL_INDICATOR IN ('M','S') AND            
                        RN.CHECK_STATUS_CD = 'A' AND                    
                        RN.ACCOUNT_NO = AT.ACCOUNT_NO AND               
                        RN.CHECK_ISS_REAS_CD = RU.CHECK_ISS_RSN_CD AND  
                        RN.ESCHEATMENT_CD  NOT IN ('S','U')             
                ORDER BY RN.ACCOUNT_NO                                  
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03591000
MFA-TR*         DECLARE ACCOUNT_CURSOR CURSOR FOR                       03600000
MFA-TR*         SELECT  RN.ACCOUNT_NO                                   03610000
MFA-TR*                ,RN.REFUND_CHECK_NO                                      
MFA-TR*                ,RN.DEPOSIT_CERT_NO                                      
MFA-TR*                ,RN.CHECK_STATUS_CD                                      
MFA-TR*                ,RN.RETURNED_REASON                                      
MFA-TR*                ,RN.MANUAL_INDICATOR                                     
MFA-TR*                ,RN.USER_ID_APPRVD_BY                                    
MFA-TR*                ,RN.REFUND_STATUS_DT                                     
MFA-TR*                ,RN.USER_ID_RQSTED_BY                                    
MFA-TR*                ,RN.PANEL_NO                                             
MFA-TR*                ,RN.TRANS_HIST_SEQ_NO                                    
MFA-TR*                ,RN.COMMENTS                                             
MFA-TR*                ,RN.AMT_REFUNDED                                 03620000
MFA-TR*                ,RN.DATE_REFUNDED                                03621000
MFA-TR*                ,RN.CHECK_ISS_REAS_CD                            03630000
MFA-TR*                ,RN.REQUEST_DT                                   03640000
MFA-TR*                ,RN.LOCAL_OFFICE                                 03650000
MFA-TR*                ,RN.REFUND_ITEM_ID                               03660000
MFA-TR*                ,RN.ADDRESS_ID                                   03661000
MFA-TR*                ,RN.ORIGINAL_CHECK_NO                            03662000
MFA-TR*                ,RN.ESCHEATMENT_CD                               03662000
MFA-TR*                ,AT.COMPANY_NO                                   03670000
MFA-TR*                ,AT.PREMISE_NO                                   03671000
MFA-TR*                ,AT.LOCAL_OFFICE                                 03672000
MFA-TR*                ,AT.CUSTOMER_NO                                  03673000
MFA-TR*                ,AT.CODE_COMPANY_ACCT                            03674000
MFA-TR*                ,AT.CODE_ACCT_STAT                               03675000
MFA-TR*                ,AT.BILL_CYCLE                                   03676000
MFA-TR*                ,AT.TOTAL_AR_BALANCE                             03677000
MFA-TR*                ,AT.ADDRESS_ID                                   03678000
MFA-TR*                ,AT.ADDRESS_FORMAT                               03679000
MFA-TR*                ,RU.CHECK_ISS_RSN_DESC                                   
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*         FROM    CSS_REFUND RN                                   03680000
MFA-TR*                ,CSS_ACCOUNT AT                                  03690000
MFA-TR*                ,CSS_REFUND_REASON RU                                    
MFA-TR*        WHERE    RN.MANUAL_INDICATOR IN ('M','S') AND            03700000
MFA-TR*                 RN.CHECK_STATUS_CD = 'A' AND                    03702000
MFA-TR*                 RN.ACCOUNT_NO = AT.ACCOUNT_NO AND               03710000
MFA-TR*                 RN.CHECK_ISS_REAS_CD = RU.CHECK_ISS_RSN_CD AND          
MFA-TR*                 RN.ESCHEATMENT_CD  NOT IN ('S','U')                     
MFA-TR*         ORDER BY RN.ACCOUNT_NO                                  03720023
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    03730000
      *                                                                 03740000
           EXEC SQL                                                     
             DECLARE DET_DEP_CUR CURSOR FOR                             
               SELECT                                                   
                       AT.ACCOUNT_NO                                    
                      ,AR.AMT_BILLED_UNPAID                             
               FROM                                                     
                       CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                      ,CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)               
                 WHERE                                                  
                   AT.ACCOUNT_NO = :WS-ACCOUNT-NO                       
                   AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                    
                   AND AR.DATE_TRANS <= CAST(AT.ACCT_FINALED_DT AS DATE)        
                   AND AR.CODE_TRAN_TYPE = 'I'                          
                   AND AR.AMT_BILLED_UNPAID < 0                         
                   AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')    
                   ORDER BY AR.TRANS_HIST_SEQ_NO DESC                   
                   FOR READ ONLY                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DET_DEP_CUR CURSOR FOR                                     
MFA-TR*        SELECT                                                           
MFA-TR*                AT.ACCOUNT_NO                                            
MFA-TR*               ,AR.AMT_BILLED_UNPAID                                     
MFA-TR*        FROM                                                             
MFA-TR*                CSS_ACCOUNT     AT                                       
MFA-TR*               ,CSS_AR_TRANS_HIST AR                                     
MFA-TR*          WHERE                                                          
MFA-TR*            AT.ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*            AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                            
MFA-TR*            AND AR.DATE_TRANS <= DATE(AT.ACCT_FINALED_DT)                
MFA-TR*            AND AR.CODE_TRAN_TYPE = 'I'                                  
MFA-TR*            AND AR.AMT_BILLED_UNPAID < 0                                 
MFA-TR*            AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')            
MFA-TR*            ORDER BY AR.TRANS_HIST_SEQ_NO DESC                           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*     END-EXEC.                                                           
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 9(02).                   
      *                                                                 03890000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA690 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************03940000
      **    0000-MAINLINE                                             **03950000
      ******************************************************************03960000
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03990000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 04011000
      *  PROCESS ONLY IF THERE IS DATA                         **       04280031
      *                                                                         
           PERFORM 1100-PROCESS-ACCT-RECS THRU 1100-EXIT                
                     UNTIL NO-MORE-DATA-ACCT                            
      *                                                                 04291131
           PERFORM 9100-TERMINATE THRU 9100-EXIT.                       
           STOP RUN.                                                    
      *                                                                 04310000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04340000
      ************************************************************      04350000
      **  0100-INITIALIZATION.                                  **      04360000
      **      ACCEPTS CURRENT DATE.                             **      04370000
      ************************************************************      04380000
       0100-INITIALIZATION.                                             
      *                                                                 04400000
           OPEN OUTPUT FCSC690-FILE.                                    
           IF C690-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA690 PROCESSING ERROR   **'           
               DISPLAY '**   FCSC690-FILE WILL NOT OPEN   **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY 'FILE-STATUS = ' WS-C690-STATUS                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE  FIOC690-REC.                                     
                                                                        
      *  CHECK AR LOCKOUT                                               04652000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY ' '                                               
              DISPLAY '**  PCSCA690 PROCESSING ERROR  **'               
              DISPLAY '**  AR LOCKOUT IN EFFECT       **'               
              DISPLAY '**  PROCESSING TERMINATED      **'               
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           ELSE                                                         
              PERFORM 7005-OPEN-ACCOUNT-CURSOR THRU 7005-EXIT           
              PERFORM 7010-FETCH-CURSOR-ACCOUNT THRU 7010-EXIT          
           END-IF.                                                      
      *                                                                 04659100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04680000
      ************************************************************      05220000
      **  1100-PROCESS-ACCT-RECS.                               **      05230000
      **      CHECKS IF ACCOUNT IS ACTIVE OR FINAL BILLED       **      05240000
      **      AND BASED ON IT PROCESS THE SPLIT                 **      05250000
      ************************************************************      05270000
      *                                                                 05280000
       1100-PROCESS-ACCT-RECS.                                          
      *                                                                 05300000
           IF AT-ACCOUNT-TYPE-CODE  = 'R'                               
             IF AT-CODE-ACCT-STAT = 'A'                                 
               IF  RN-CHECK-ISS-REAS-CD = 'G'                           
                 MOVE 'U'  TO RN-ESCHEATMENT-CD                         
               ELSE                                                     
                 MOVE 'S'  TO RN-ESCHEATMENT-CD                         
               END-IF                                                   
               PERFORM 8400-UPDATE-REFUND-ESCCODE THRU 8400-EXIT        
             ELSE                                                       
ACT209         IF (AT-CODE-ACCT-STAT = 'B' OR                           
ACT209             AT-CODE-ACCT-STAT = 'S' )                            
                 MOVE RN-AMT-REFUNDED      TO WS-REFUND-AMT             
                 PERFORM 8100-DET-DEP-PARA THRU 8100-EXIT               
                IF WS-DEPOSIT-AMT < 0                                   
                    COMPUTE WS-DEPOSIT-AMT =  WS-DEPOSIT-AMT * -1       
                END-IF                                                  
                IF WS-DEPOSIT-AMT NOT = 0                               
                 IF WS-DEPOSIT-AMT >= WS-REFUND-AMT                     
                    MOVE 'U'  TO RN-ESCHEATMENT-CD                      
                    PERFORM 8400-UPDATE-REFUND-ESCCODE THRU 8400-EXIT   
                 END-IF                                                 
                 IF WS-DEPOSIT-AMT <  WS-REFUND-AMT                     
                    MOVE 'S'  TO RN-ESCHEATMENT-CD                      
                    SUBTRACT WS-DEPOSIT-AMT FROM WS-REFUND-AMT          
                    MOVE WS-REFUND-AMT TO RN-AMT-REFUNDED               
                    PERFORM 8300-UPDATE-REFUND THRU 8300-EXIT           
                    PERFORM 9400-MOVE-REFUND-DETAILS THRU 9400-EXIT     
                    PERFORM 8200-INSERT-REFUND THRU 8200-EXIT           
                 END-IF                                                 
                END-IF                                                  
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
               MOVE 'S'  TO RN-ESCHEATMENT-CD                           
               PERFORM 8400-UPDATE-REFUND-ESCCODE THRU 8400-EXIT        
           END-IF                                                       
           PERFORM 7010-FETCH-CURSOR-ACCOUNT THRU 7010-EXIT.            
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05460000
      ************************************************************      05470000
      **  8100-DET-DEP-PARA                                     **      05480000
      **      GETS THE DEPOSIT PORTION AT THE TIME OF FINAL     **      05490000
      **      BILL                                              **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8100-DET-DEP-PARA.                                               
            EXEC SQL                                                    
               SELECT                                                   
                       AT.ACCOUNT_NO                                    
                      ,AR.AMT_ORIG_ENTERED                              
               INTO                                                     
                       :AT-ACCOUNT-NO                                   
                       ,:AR-AMT-ORIG-ENTERED                            
               FROM                                                     
                       CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                      ,CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)               
                 WHERE                                                  
                   AT.ACCOUNT_NO = :WS-ACCOUNT-NO                       
                   AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                    
                   AND AR.DATE_TRANS <= CAST(AT.ACCT_FINALED_DT AS DATE)        
                   AND AR.CODE_TRAN_TYPE = 'I'                          
                   AND AR.AMT_BILLED_UNPAID < 0                         
                   AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')    
                   ORDER BY AR.TRANS_HIST_SEQ_NO DESC                   
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT                                                           
MFA-TR*                AT.ACCOUNT_NO                                            
MFA-TR*               ,AR.AMT_ORIG_ENTERED                                      
MFA-TR*        INTO                                                             
MFA-TR*                :AT-ACCOUNT-NO                                           
MFA-TR*                ,:AR-AMT-ORIG-ENTERED                                    
MFA-TR*        FROM                                                             
MFA-TR*                CSS_ACCOUNT     AT                                       
MFA-TR*               ,CSS_AR_TRANS_HIST AR                                     
MFA-TR*          WHERE                                                          
MFA-TR*            AT.ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*            AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                            
MFA-TR*            AND AR.DATE_TRANS <= DATE(AT.ACCT_FINALED_DT)                
MFA-TR*            AND AR.CODE_TRAN_TYPE = 'I'                                  
MFA-TR*            AND AR.AMT_BILLED_UNPAID < 0                                 
MFA-TR*            AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')            
MFA-TR*            ORDER BY AR.TRANS_HIST_SEQ_NO DESC                           
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            EVALUATE WS-ACTIVE-RETURN-CODE                              
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AR-AMT-ORIG-ENTERED  TO WS-DEPOSIT-AMT          
               WHEN -811                                                
                   MOVE 0 TO WS-DEPOSIT-AMT                             
                   DISPLAY 'DUP SO-FINAL DEP  '  WS-ACCOUNT-NO          
                   PERFORM 8150-DET-DEP-PARA THRU 8150-EXIT             
               WHEN NOT-FOUND                                           
                   MOVE ZEROS TO WS-DEPOSIT-AMT                         
                   MOVE ZEROS TO WS-REFUND-AMT                          
      *            DISPLAY 'NO DEPOSIT FOR  '  WS-ACCOUNT-NO                1616
                   IF  RN-CHECK-ISS-REAS-CD = 'B'                       
                    MOVE 'U'  TO RN-ESCHEATMENT-CD                      
                   ELSE                                                 
                    MOVE 'S'  TO RN-ESCHEATMENT-CD                      
                   END-IF                                               
                   PERFORM 8400-UPDATE-REFUND-ESCCODE THRU 8400-EXIT    
               WHEN OTHER                                               
                    DISPLAY '** PCSCA690 PROCESSING ERROR    **'        
                    DISPLAY '** ERROR IN SELECT              **'        
                    DISPLAY '** PARA 8100-DET-DEP-PARA       **'        
                    DISPLAY '** SQLCODE IS  ** ' SQLCODE                
                    DISPLAY '** PROCESSING TERMINATED        **'        
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
            END-EVALUATE.                                               
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      ************************************************************      05470000
      **  8150-DET-DEP-PARA                                     **      05480000
      **      GETS THE DEPOSIT PORTION AT THE TIME OF FINAL     **      05490000
      **      BILL AND SUMS FOR MULTIPLE ROWS                   **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8150-DET-DEP-PARA.                                               
            EXEC SQL                                                    
               SELECT                                                   
                      SUM(AR.AMT_ORIG_ENTERED)                          
               INTO                                                     
                       :AR-AMT-ORIG-ENTERED                             
               FROM                                                     
                       CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                      ,CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)               
                 WHERE                                                  
                   AT.ACCOUNT_NO = :WS-ACCOUNT-NO                       
                   AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                    
                   AND AR.DATE_TRANS <= CAST(AT.ACCT_FINALED_DT AS DATE)        
                   AND AR.CODE_TRAN_TYPE = 'I'                          
                   AND AR.AMT_BILLED_UNPAID < 0                         
                   AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')    
                   GROUP BY AR.ACCOUNT_NO                               
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT                                                           
MFA-TR*               SUM(AR.AMT_ORIG_ENTERED)                                  
MFA-TR*        INTO                                                             
MFA-TR*                :AR-AMT-ORIG-ENTERED                                     
MFA-TR*        FROM                                                             
MFA-TR*                CSS_ACCOUNT     AT                                       
MFA-TR*               ,CSS_AR_TRANS_HIST AR                                     
MFA-TR*          WHERE                                                          
MFA-TR*            AT.ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*            AND AT.ACCOUNT_NO = AR.ACCOUNT_NO                            
MFA-TR*            AND AR.DATE_TRANS <= DATE(AT.ACCT_FINALED_DT)                
MFA-TR*            AND AR.CODE_TRAN_TYPE = 'I'                                  
MFA-TR*            AND AR.AMT_BILLED_UNPAID < 0                                 
MFA-TR*            AND AR.APPL_PROGRAM_ID IN ('PCSSO62J','PCSSO62A')            
MFA-TR*            GROUP BY AR.ACCOUNT_NO                                       
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            EVALUATE WS-ACTIVE-RETURN-CODE                              
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AR-AMT-ORIG-ENTERED  TO WS-DEPOSIT-AMT          
               WHEN OTHER                                               
                    DISPLAY '** PCSCA690 PROCESSING ERROR    **'        
                    DISPLAY '** ERROR IN SELECT              **'        
                    DISPLAY '** PARA 8150-DET-DEP-PARA       **'        
                    DISPLAY '** SQLCODE IS  ** ' SQLCODE                
                    DISPLAY '** PROCESSING TERMINATED        **'        
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
            END-EVALUATE.                                               
                                                                        
       8150-EXIT.                                                       
            EXIT.                                                       
      ************************************************************      05470000
      **  8200-INSERT-REFUND                                    **      05480000
      **      GETS THE DEPOSIT PORTION AT THE TIME OF FINAL     **      05490000
      **      BILL                                              **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8200-INSERT-REFUND.                                              
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                  (REFUND_ITEM_ID,                                      
                   REFUND_CHECK_NO,                                     
                   DEPOSIT_CERT_NO,                                     
                   LOCAL_OFFICE,                                        
                   AMT_REFUNDED,                                        
                   REQUEST_DT,                                          
                   CHECK_STATUS_CD,                                     
                   CHECK_ISS_REAS_CD,                                   
                   ORIGINAL_CHECK_NO,                                   
                   RETURNED_REASON,                                     
                   MANUAL_INDICATOR,                                    
                   USER_ID_APPRVD_BY,                                   
                   REFUND_STATUS_DT,                                    
                   USER_ID_RQSTED_BY,                                   
                   ACCOUNT_NO,                                          
                   PANEL_NO,                                            
                   ADDRESS_ID,                                          
                   TRANS_HIST_SEQ_NO,                                   
                   ESCHEATMENT_CD,                                      
                   DATE_REFUNDED,                                       
                   COMMENTS)                                            
                VALUES                                                  
                   (:RN-REFUND-ITEM-ID,                                 
                    :RN-REFUND-CHECK-NO,                                
                    :RN-DEPOSIT-CERT-NO,                                
                    :RN-LOCAL-OFFICE,                                   
                    :RN-AMT-REFUNDED,                                   
                    IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) ),                              
                    :RN-CHECK-STATUS-CD,                                
                    :RN-CHECK-ISS-REAS-CD,                              
                    :RN-ORIGINAL-CHECK-NO,                              
                    :RN-RETURNED-REASON,                                
                    :RN-MANUAL-INDICATOR,                               
                    :RN-USER-ID-APPRVD-BY,                              
                    IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
                    :RN-USER-ID-RQSTED-BY,                              
                    :RN-ACCOUNT-NO,                                     
                    :RN-PANEL-NO,                                       
                    :RN-ADDRESS-ID,                                     
                    CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                  
                    :RN-ESCHEATMENT-CD,                                 
                    IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                          :WS-NULL-INDICATOR-2
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                   :WS-NULL-INDICATOR-2
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-NULL-INDICATOR-2
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                   :WS-NULL-INDICATOR-2
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-NULL-INDICATOR-2
              ) ),              
                    :RN-COMMENTS)                                       
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*         INSERT INTO CSS_REFUND                                  15640000
MFA-TR*           (REFUND_ITEM_ID,                                      15650000
MFA-TR*            REFUND_CHECK_NO,                                     15660000
MFA-TR*            DEPOSIT_CERT_NO,                                     15670000
MFA-TR*            LOCAL_OFFICE,                                        15680000
MFA-TR*            AMT_REFUNDED,                                        15710000
MFA-TR*            REQUEST_DT,                                          15740000
MFA-TR*            CHECK_STATUS_CD,                                     15791000
MFA-TR*            CHECK_ISS_REAS_CD,                                   15792000
MFA-TR*            ORIGINAL_CHECK_NO,                                   15810000
MFA-TR*            RETURNED_REASON,                                     15820000
MFA-TR*            MANUAL_INDICATOR,                                    15830000
MFA-TR*            USER_ID_APPRVD_BY,                                   15840000
MFA-TR*            REFUND_STATUS_DT,                                    15850000
MFA-TR*            USER_ID_RQSTED_BY,                                   15860000
MFA-TR*            ACCOUNT_NO,                                          15870000
MFA-TR*            PANEL_NO,                                            15911000
MFA-TR*            ADDRESS_ID,                                          15912000
MFA-TR*            TRANS_HIST_SEQ_NO,                                           
MFA-TR*            ESCHEATMENT_CD,                                              
MFA-TR*            DATE_REFUNDED,                                               
MFA-TR*            COMMENTS)                                                    
MFA-TR*         VALUES                                                  15930000
MFA-TR*            (:RN-REFUND-ITEM-ID,                                 15940000
MFA-TR*             :RN-REFUND-CHECK-NO,                                15950000
MFA-TR*             :RN-DEPOSIT-CERT-NO,                                15960000
MFA-TR*             :RN-LOCAL-OFFICE,                                   15970000
MFA-TR*             :RN-AMT-REFUNDED,                                   16000000
MFA-TR*             :RN-REQUEST-DT,                                     16030000
MFA-TR*             :RN-CHECK-STATUS-CD,                                16081000
MFA-TR*             :RN-CHECK-ISS-REAS-CD,                              16082000
MFA-TR*             :RN-ORIGINAL-CHECK-NO,                              16100000
MFA-TR*             :RN-RETURNED-REASON,                                16110000
MFA-TR*             :RN-MANUAL-INDICATOR,                               16120000
MFA-TR*             :RN-USER-ID-APPRVD-BY,                              16130000
MFA-TR*             :RN-REFUND-STATUS-DT,                               16140000
MFA-TR*             :RN-USER-ID-RQSTED-BY,                              16150000
MFA-TR*             :RN-ACCOUNT-NO,                                     16160000
MFA-TR*             :RN-PANEL-NO,                                       16201000
MFA-TR*             :RN-ADDRESS-ID,                                     16202000
MFA-TR*             :RN-TRANS-HIST-SEQ-NO,                              16202000
MFA-TR*             :RN-ESCHEATMENT-CD,                                         
MFA-TR*             :RN-DATE-REFUNDED:WS-NULL-INDICATOR-2,                      
MFA-TR*             :RN-COMMENTS)                                       16202000
MFA-TR*         END-EXEC.                                               16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RN-ACCOUNT-NO TO  E-C690-ACCOUNT-NO                  
              MOVE RN-ESCHEATMENT-CD TO E-C690-ESC-CD                   
              PERFORM 8000-WRITE-C690 THRU 8000-EXIT                    
              DISPLAY 'INSERTED*' RN-ACCOUNT-NO ' ' RN-ESCHEATMENT-CD   
           ELSE                                                         
              DISPLAY '** PCSCA690 PROCESSING ERROR        **'          
              DISPLAY '** ERROR IN INSERT                  **'          
              DISPLAY '** ACCOUNT NO **'   RN-ACCOUNT-NO                
              DISPLAY '** PARA 8200-INSERT-REFUND          **'          
              DISPLAY '** SQLCODE IS  ** ' SQLCODE                      
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
       8200-EXIT.                                                       
            EXIT.                                                       
      ************************************************************      05470000
      **  8300-UPDATE-REFUND                                    **      05480000
      **      UPDATES THE AMT-REFUNDED BY SUBTRACTING DEPOSIT   **      05490000
      ************************************************************      05510000
      *                                                                 05520000
       8300-UPDATE-REFUND.                                              
           EXEC SQL                                                     
                UPDATE CSS_REFUND                                       
                SET AMT_REFUNDED          =  :RN-AMT-REFUNDED,          
                ESCHEATMENT_CD            =  :RN-ESCHEATMENT-CD         
                WHERE ACCOUNT_NO          =  :RN-ACCOUNT-NO             
                  AND REFUND_ITEM_ID      =  :RN-REFUND-ITEM-ID         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                MOVE RN-ACCOUNT-NO TO  E-C690-ACCOUNT-NO                
                MOVE RN-ESCHEATMENT-CD TO E-C690-ESC-CD                 
                PERFORM 8000-WRITE-C690 THRU 8000-EXIT                  
                DISPLAY 'UPDATED* ' RN-ACCOUNT-NO ' ' RN-ESCHEATMENT-CD 
               WHEN OTHER                                               
                  DISPLAY '** PCSCA690 PROCESSING ERROR        **'      
                  DISPLAY '** ERROR IN UPDATE                  **'      
                  DISPLAY '** PARA 8300-UPDATE-REFUND          **'      
                  DISPLAY '* ACCOUNT NO '  RN-ACCOUNT-NO                
                  DISPLAY '** SQLCODE IS  ** ' SQLCODE                  
                  DISPLAY '** PROCESSING TERMINATED            **'      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-EVALUATE.                                                
       8300-EXIT.                                                       
           EXIT.                                                        
      ************************************************************      05470000
      **  8400-UPDATE-REFUND-ESCCODE                            **      05480000
      **      UPDATES  ESC-CODE                                 **      05490000
      ************************************************************      05510000
      *                                                                 05520000
       8400-UPDATE-REFUND-ESCCODE.                                      
           EXEC SQL                                                     
                UPDATE CSS_REFUND                                       
                SET ESCHEATMENT_CD        =  :RN-ESCHEATMENT-CD         
                WHERE ACCOUNT_NO          =  :RN-ACCOUNT-NO             
                  AND REFUND_ITEM_ID      =  :RN-REFUND-ITEM-ID         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                MOVE RN-ACCOUNT-NO TO  E-C690-ACCOUNT-NO                
                MOVE RN-ESCHEATMENT-CD TO E-C690-ESC-CD                 
                PERFORM 8000-WRITE-C690 THRU 8000-EXIT                  
                DISPLAY 'UPDATED* ' RN-ACCOUNT-NO ' ' RN-ESCHEATMENT-CD 
               WHEN OTHER                                               
                  DISPLAY '** PCSCA690 PROCESSING ERROR        **'      
                  DISPLAY '** ERROR IN UPDATE                  **'      
                  DISPLAY '** PARA 8400-UPDATE-REFUND          **'      
                  DISPLAY 'ACCOUNT NO ** '  RN-ACCOUNT-NO               
                  DISPLAY '** SQLCODE IS  ** ' SQLCODE                  
                  DISPLAY '** PROCESSING TERMINATED            **'      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-EVALUATE.                                                
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05833600
      **  7005-OPEN-ACCOUNT-CURSOR.                             **      05833200
      **      OPENS CURSOR ACCT TO SELECT RECORDS FROM          **      05833300
      **      TABLE CSS_ACCOUNT & CSS_REFUND WHERE REAS_CD = 'A'**      05833400
      **      AND ACCT NO MATCH BOTH TABLES.                    **      05833500
      ************************************************************      05833600
        7005-OPEN-ACCOUNT-CURSOR.                                       
           EXEC SQL                                                     
               OPEN ACCOUNT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSCA690 PROCESSING ERROR       **'          
               DISPLAY '** OPEN ERROR ON CURSOR ACCOUNT    **'          
               DISPLAY '** PARA 7005-OPEN-ACCOUNT-CURSOR   **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05950000
      ************************************************************      05960000
      **  7006-CLOSE-ACCOUNT-CURSOR.                            **      05970000
      **      CLOSE ACCOUNT CURSOR.                             **      05980000
      ************************************************************      05990000
        7006-CLOSE-ACCOUNT-CURSOR.                                      
           EXEC SQL                                                     
               CLOSE ACCOUNT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSCA690 PROCESSING ERROR        **'         
               DISPLAY '** CLOSE ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 7006-CLOSE-ACCOUNT-CURSOR   **'         
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED            **'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSC690-FILE.                                          
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06170000
      ************************************************************      06180000
      **  7010-FETCH-CURSOR-ACCOUNT.                            **      06190000
      **      FETCHES THE CURSOR VALUES INTO WS VARIABLES       **      06200000
      **      AND TEST SQLCODE FOR SUCCESS AND END OF TABLE     **      06210000
      ************************************************************      06220000
       7010-FETCH-CURSOR-ACCOUNT.                                       
            EXEC SQL                                                    
                FETCH ACCOUNT_CURSOR                                    
                INTO   :RN-ACCOUNT-NO                                   
                      ,:RN-REFUND-CHECK-NO                              
                      ,:RN-DEPOSIT-CERT-NO                              
                      ,:RN-CHECK-STATUS-CD                              
                      ,:RN-RETURNED-REASON                              
                      ,:RN-MANUAL-INDICATOR                             
                      ,:RN-USER-ID-APPRVD-BY                            
                      ,:RN-REFUND-STATUS-DT                             
                      ,:RN-USER-ID-RQSTED-BY                            
                      ,:RN-PANEL-NO                                     
                      ,:RN-TRANS-HIST-SEQ-NO                            
                      ,:RN-COMMENTS                                     
                      ,:RN-AMT-REFUNDED                                 
                      ,:RN-DATE-REFUNDED :WS-NULL-INDICATOR-1            
                      ,:RN-CHECK-ISS-REAS-CD                            
                      ,:RN-REQUEST-DT :WS-NULL-INDICATORS                       
                      ,:RN-LOCAL-OFFICE                                 
                      ,:RN-REFUND-ITEM-ID                               
                      ,:RN-ADDRESS-ID                                   
                      ,:RN-ORIGINAL-CHECK-NO                            
                      ,:RN-ESCHEATMENT-CD                               
                      ,:AT-COMPANY-NO                                   
                      ,:AT-PREMISE-NO                                   
                      ,:AT-LOCAL-OFFICE                                 
                      ,:AT-CUSTOMER-NO                                  
                      ,:AT-CODE-COMPANY-ACCT                            
                      ,:AT-CODE-ACCT-STAT                               
                      ,:AT-BILL-CYCLE                                   
                      ,:AT-TOTAL-AR-BALANCE                             
                      ,:AT-ADDRESS-ID                                   
                      ,:AT-ADDRESS-FORMAT                               
                      ,:RU-CHECK-ISS-RSN-DESC                           
                      ,:AT-ACCOUNT-TYPE-CODE                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE RN-ACCOUNT-NO TO WS-ACCOUNT-NO                  
               WHEN NOT-FOUND                                           
                   MOVE 'NO' TO WS-DATA-ACCT                            
               WHEN OTHER                                               
                   DISPLAY '** PCSCA690 PROCESSING ERROR        **'     
                   DISPLAY '** ERROR ON FETCH CURSOR            **'     
                   DISPLAY '** PARA 7010-FETCH-CURSOR-ACCOUNT   **'     
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED            **'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-EVALUATE.                                            
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06600000
      ************************************************************      06645600
      **  7560-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
      ************************************************************              
       7560-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         VALUES CURRENT TIMESTAMP                                        
MFA-TR*         INTO   :WS-CURRENT-TIMESTAMP                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         VALUES CURRENT DATE                                             
MFA-TR*         INTO   :WS-DATE-TRANS                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '7560-GET-CURRENT-TIMESTAMP'                      
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06645500
      *****************************************************************         
      * 7585-GET-REFUND-ITEM-ID                                       *         
      *                                                               *         
      *     GET THE MAX REFUND-ITEM-ID USED FOR THE ACCOUNT IN        *         
      *     CSS_REFUND TABLE                                          *         
      *****************************************************************         
      *                                                                         
       7585-GET-REFUND-ITEM-ID.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(REFUND_ITEM_ID)                                
              INTO   :WS-MAX-REFUND-ITEM-ID :WS-REFUND-ITEM-ID-NI        
              FROM   CSS_REFUND WITH(READUNCOMMITTED)                           
              WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REFUND_ITEM_ID)                                        
MFA-TR*       INTO   :WS-MAX-REFUND-ITEM-ID:WS-REFUND-ITEM-ID-NI                
MFA-TR*       FROM   CSS_REFUND                                                 
MFA-TR*       WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-REFUND-ITEM-ID-NI < 0                               
                 MOVE 1              TO WS-MAX-REFUND-ITEM-ID           
              ELSE                                                      
                 ADD 1               TO WS-MAX-REFUND-ITEM-ID           
              END-IF                                                    
           ELSE                                                         
               DISPLAY '* 7585-GET-REFUND-ITEM-ID              *'       
               DISPLAY '* ACCOUNT-NO   :', RN-ACCOUNT-NO                
               DISPLAY '* SQLCODE      :', WS-ACTIVE-RETURN-CODE        
               DISPLAY '* PROGRAM ABORTING...                  *'       
               PERFORM 9900-ABEND    THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7585-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08080000
      ****************************************************************  08090000
      **   9400-MOVE-REFUND-DETAILS.                                **          
      **       MOVES THE DETAILS INTO THE HOST-VARIABLES OF         **          
      **       CSS_REFUND                                           **          
      ****************************************************************          
                                                                        
       9400-MOVE-REFUND-DETAILS.                                        
           PERFORM 7560-GET-CURRENT-TIMESTAMP THRU 7560-EXIT            
           MOVE WS-CURRENT-TIMESTAMP TO RN-TRANS-HIST-SEQ-NO            
           PERFORM 7585-GET-REFUND-ITEM-ID THRU 7585-EXIT               
           MOVE WS-MAX-REFUND-ITEM-ID TO RN-REFUND-ITEM-ID              
           MOVE WS-DEPOSIT-AMT TO  RN-AMT-REFUNDED                      
           MOVE 'U'  TO RN-ESCHEATMENT-CD                               
           MOVE '  REFUND DEPOSIT BALANCE' TO RN-COMMENTS               
           MOVE +26                   TO RN-COMMENTS-LEN                
           IF RN-DATE-REFUNDED = LOW-VALUES                             
              MOVE -1 TO WS-NULL-INDICATOR-2                            
           END-IF.                                                      
      *                                                                         
      *                                                                         
       9400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08080000
      ****************************************************************  08533700
      **                                                            **  08533800
      **   9100-TERMINATE.                                          **  08533900
      **       IF PROCESS RUNS THRU OKAY COMMIT'S CHANGES TO DB &   **  08534000
      **       CLOSES ALL FILES.                                    **  08535000
      ****************************************************************  08536000
      *                                                                 08537000
       9100-TERMINATE.                                                  
      *                                                                 08539000
           PERFORM 7006-CLOSE-ACCOUNT-CURSOR THRU 7006-EXIT.            
      *                                                                 08580000
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08740000
      *******************************************************           08740101
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 08741001
      ****************************************************************  08750000
      **                                                            **  08760000
      **   9000-TERMINATE.                                          **  08770000
      **       IF PROCESS ABENDS ROLLS BACK ON CHANGES TO DB  &     **  08780000
      **       CLOSES ALL FILES.                                    **  08790000
      ****************************************************************  08800000
      *                                                                 08810000
       9000-TERMINATE.                                                  
      *                                                                 08830000
           CLOSE FCSC690-FILE.                                          
      *                                                                 08890000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08920000
      ***************************************************************** 09060000
      ** 6251-GET-FJC01-DATE                                         ** 09070000
      ***************************************************************** 09080000
      *                                                                 09090000
       COPY CPD00037.                                                   09100000
      *                                                                 09110000
       COPY CPD00040.                                                   09120000
      *                                                                 09130000
      ***************************************************************** 09140000
      ** 7600-START-FCJ01                                            ** 09150000
      ***************************************************************** 09160000
      *                                                                 09170000
           EXEC SQL                                                     09180000
               INCLUDE CPD00038                                         09190000
           END-EXEC.                                                    09200000
      *                                                                 09210000
      ***************************************************************** 09220000
      ** 7600-START-FCJ01                                            ** 09230000
      ***************************************************************** 09240000
      *                                                                 09250000
           EXEC SQL                                                     09260000
               INCLUDE CPD00039                                         09270000
           END-EXEC.                                                    09280000
      *                                                                 09210000
      ***************************************************************** 09220000
      ** 7999-SELECT-AL                                              ** 09230000
      ***************************************************************** 09240000
      *                                                                 09210000
           EXEC SQL                                                     09290300
               INCLUDE CPD00075                                         09290400
           END-EXEC.                                                    09290500
      *                                                                 09250000
      ******************************************************************        
      * 8000-WRITE-C690.                                               *        
      ******************************************************************        
       8000-WRITE-C690.                                                 
      *                                                                         
           WRITE FIOC690-REC.                                           
      *                                                                         
           IF C690-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA690 PROCESSING ERROR   **'           
               DISPLAY '**   WRITE FCSC690-FILE IS FAILED **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY ' FILE-STATUS = ' WS-C690-STATUS                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 09290600
      ***************************************************************** 09300000
      ** 9700-PROCESS-ABEND.                                         ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
       COPY CPD0023B.                                                   09340000
      *                                                                 09350000
      *                                                                 09350100
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                 09351000
      **************************************************************    09360000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    09370000
      **************************************************************    09380000
      *                                                                 09351000
      *                                                                 09290600
      ***************************************************************** 09300000
      ** 9900-ABEND.                                                 ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
                                                                        
           EXEC SQL                                                     09400000
                INCLUDE CPD09900                                        09410000
           END-EXEC.                                                    09420000
      **************************************************************    09430000
