       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA685.                                        
       DATE-WRITTEN.   NOV 2001.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      ***************************************************************** 00100000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  CONVERT FIRST UNION RECONCILIATION FILE TO FORMAT USED BY  ** 00200000
      **  PCSCA692-RECONCILE CHECKS                                  ** 00210000
      ***************************************************************** 00330000
      ***************************************************************** 00340000
      **                                                             ** 00350000
      **              PROGRAM  MODIFICATION  LOG                     ** 00360000
      **    DATE    INITIALS     REASON                              ** 00370000
      **  ________  _______      ______                              ** 00380000
C24044**  11/19/01    LEF        INITIAL VERSION                     ** 00390000
T29199**  08/26/03  CB18344      CHANGED NAME ON FIOCA97 FROM        ** 00390000
T29199**                         E-FCA97-FIRST-UNION-ACCT-NO TO      **         
T29199**                         E-FCA97-WACHOVIA-ACCOUNT-NO.        **         
      ****************************************************************  00491700
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00620000
           COPY CSSCA94.                                                00640000
      *                                                                         
           COPY CSSCA97.                                                        
      *                                                                 00650000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00680000
           COPY CFDCA97.                                                00690000
           COPY FIOCA97.                                                00700000
      *                                                                         
           COPY CFDCA94.                                                00710000
           COPY FIOCA94.                                                00710000
      *                                                                 00720000
       WORKING-STORAGE SECTION.                                         
      *                                                                 00740000
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40) VALUE              
              'WORKING STORAGE FOR PCSCA691 STARTS HERE'.               
                                                                        
       01  WS-FCA97-OPEN-FLAG              PIC X(01) VALUE 'N'.         
           88  WS-FCA97-OPEN               VALUE 'Y'.                   
                                                                        
       01  WS-FCA94-OPEN-FLAG              PIC X(01) VALUE 'N'.         
           88  WS-FCA94-OPEN               VALUE 'Y'.                   
                                                                        
       01  WS-FCA97-STATUS                 PIC X(02).                   
           88  FCA97-SUCCESSFUL            VALUE '00'.                  
                                                                        
       01  WS-FCA94-STATUS                 PIC X(02).                   
           88  FCA94-SUCCESSFUL            VALUE '00'.                  
                                                                        
       01  WS-AT-END-FLAG                  PIC X(01) VALUE 'N'.         
           88  WS-AT-END                   VALUE 'Y'.                   
                                                                        
       01  WS-FIRST-REC-FLAG               PIC X(01) VALUE 'Y'.         
           88  WS-FIRST-REC                VALUE 'Y'.                   
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************03940000
      **    0000-MAINLINE                                             **03950000
      ******************************************************************03960000
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03990000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-FILE THRU 2000-EXIT.                    
           PERFORM 9100-CLOSE-FILES THRU 9100-EXIT.                     
           STOP RUN.                                                    
      *                                                                 04310000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04340000
      ************************************************************      04350000
      **  0100-INITIALIZATION.                                  **      04360000
      **      ACCEPTS CURRENT DATE. OPENS INPUT & OUTPUT FILE.  **      04370000
      ************************************************************      04380000
       0100-INITIALIZATION.                                             
      *                                                                 04400000
           OPEN INPUT FCSCA97-FILE.                                     
      *                                                                         
           IF (FCA97-SUCCESSFUL)                                        
              MOVE 'Y' TO WS-FCA97-OPEN-FLAG                            
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '** PCSCA685 PROCESSING ERROR       **'           
              DISPLAY '** OPEN ERROR ON FCSCA97 FILE      **'           
              DISPLAY '** FILE STATUS = ' WS-FCA97-STATUS               
              DISPLAY '** PROCESSING TERMINATED           **'           
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                 04540000
           OPEN OUTPUT FCSCA94-FILE.                                    
           IF (FCA94-SUCCESSFUL)                                        
              MOVE 'Y' TO WS-FCA94-OPEN-FLAG                            
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSCA685 PROCESSING ERROR        **'         
              DISPLAY '**  OPEN ERROR ON FCSCA94 FILE       **'         
              DISPLAY '**  FILE STATUS = ' WS-FCA94-STATUS              
              DISPLAY '**  PROCESSING TERMINATED            **'         
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                 04659100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05210000
      ************************************************************      05220000
      **  2000-PROCESS-FILE.                                    **      05230000
      **      CONVERTS FIRST UNION CHECK RECONCILIATION FILE    **      05240000
      **      TO FILE FORMAT USED BY PCSCA692 TO RECONCILE      **      05250000
      **      REFUND CHECKS.                                    **      05260000
      ************************************************************      05270000
       2000-PROCESS-FILE.                                               
                                                                        
            READ FCSCA97-FILE, AT END                                   
                 MOVE 'Y' TO WS-AT-END-FLAG                             
            END-READ.                                                   
                                                                        
            PERFORM UNTIL WS-AT-END                                     
                IF NOT WS-FIRST-REC                                     
                  INITIALIZE CLEARREC                                   
                  MOVE E-FCA97-ISSUE-DATE(3:6) TO E-FCA94-PAID-DATE     
T29199*           MOVE E-FCA97-FIRST-UNION-ACCT-NO TO E-FCA94-ACCOUNT-NO        
T29199            MOVE E-FCA97-WACHOVIA-ACCOUNT-NO TO E-FCA94-ACCOUNT-NO
                  MOVE E-FCA97-CHECK-NO(5:6) TO E-FCA94-CHECK-NO        
                  MOVE E-FCA97-AMOUNT TO E-FCA94-AMOUNT                 
                  WRITE CLEARREC                                        
                ELSE                                                    
                  MOVE 'N' TO WS-FIRST-REC-FLAG                         
                END-IF                                                  
                READ FCSCA97-FILE, AT END                               
                     MOVE 'Y' TO WS-AT-END-FLAG                         
                END-READ                                                
            END-PERFORM.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           IF WS-FCA94-OPEN                                             
              CLOSE FCSCA94-FILE                                        
           END-IF.                                                      
                                                                        
           IF WS-FCA97-OPEN                                             
              CLOSE FCSCA97-FILE                                        
           END-IF.                                                      
                                                                        
           MOVE 12 TO RETURN-CODE                                       
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9100-CLOSE-FILES.                                                
                                                                        
            CLOSE FCSCA94-FILE                                          
            IF NOT (FCA94-SUCCESSFUL)                                   
                DISPLAY '**    PCSCA685 PROCESSING ERROR   **'          
                DISPLAY '**   FCSCA94-FILE WILL NOT CLOSE  **'          
                DISPLAY '**      PARA - 9100-CLOSE-FILES   **'          
                DISPLAY '**      PROCESSING TERMINATED     **'          
                PERFORM 9000-TERMINATE THRU 9000-EXIT                   
            END-IF.                                                     
                                                                        
            CLOSE FCSCA97-FILE                                          
            IF NOT (FCA97-SUCCESSFUL)                                   
                DISPLAY '**    PCSCA685 PROCESSING ERROR   **'          
                DISPLAY '**   FCSCA97-FILE WILL NOT CLOSE  **'          
                DISPLAY '**      PARA - 9100-CLOSE-FILES   **'          
                DISPLAY '**      PROCESSING TERMINATED     **'          
                PERFORM 9000-TERMINATE THRU 9000-EXIT                   
            END-IF.                                                     
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 09350000
