       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA676.                                           
       DATE-WRITTEN.  AUGUST 99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         CBSIMDS                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 06/03/99   CBSI, MDS      DEVELOPMENT OF NEW PROGRAM        **         
C26258** 04/09/2002 CML26258-01    DP19151                           **         
C26258**                           PERFORMANCE ENHANCEMENTS.         **         
C26258**                           REPLACED THE WHERE CLAUSE TO      **         
C26258**                           MAKE THE CURSOR USE THE INDEXES.  **         
      ** 03-10-03   MICHAELSKI     PROJECT CTISUP-81-005-005 TO ADD  **         
      **                      ANOTHER OUTPUT FILE FOR STORM/DISASTER **         
      **                      DATABASE REPLACING WMS330/WMS331 REPORT**         
      **                                                             **         
      ** 06-04-03  MICHAELSKI  ADD WORK AREA TO 21ST CENTURY FILE    **         
      ** 08-25-03  MICHAELSKI  FIX NULL IN GIS-CELL-TX               **         
      ** 01-29-04  MICHAELSKI  HARD CODE DEPARTMENT NBRS PER J WIGFALL*         
      ** 05-20-04  MICHAELSKI  CHANGES FOR TFCCI                      *         
T33184** 01-13-06  CVNS        PERFORMANCE TUNING.                    *         
T33184**           CHENNAI                                            *         
C33743** 05/12/08  SC41135     POINT ID PROJECT - REPLACED SNE_POINT  *         
C33743**                       TABLE WITH CSS_PIM_POINT TABLE         *         
A02158** 17/02/10  MS93554     A NEW COLUMN HAS BEEN ADDED IN THE     *         
      **           ACT-01      REPORT(FCSCA676)COUNTY ID.             *         
      **                                                              *         
A04880** 14 APR 14 RF10596     REMOVE CSS_CUST_STATS FROM CURSOR      *         
A04880**                       SSN NO LONGER NEEDED. ADDED A1,A2      *         
A04880**                       FIX ZIP CODE                           *         
      **                                                              *         
A05136** 19 MAR 15 RF10596     REPLACE GRID-CELL WITH POINT-ID        *         
      **                                                              *         
      *****************************************************************         
      *                   PCSCA676  NARRATIVE                         *         
      *                                                                *        
      * THIS PROGRAM SELECTS ALL THE ACCOUNTS RECORDS OF REVENUE       *        
      * DISTRICT 440 OR 485 OR 486 OR 481 FOR CHARLESTON AND PROCESSES *        
      * ALL THE RECORDS PREMISE ADDRESS AND WRITES ONTO THE OUTPUT FILE         
      *   PROGRAM MODIFIED TO SELECT ALL ELECTRIC ACCOUNTS.            *        
      * SECOND FILE CREATED CONTAINING INFORMATION FOR A STAND-ALONE   *        
      * DATABASE TO LOOKUP SUBSTATION, CIRCUIT AND GIS GRID DATA IN    *        
      * EMERGENCIES WHERE THE MAINFRAME IS NOT AVAILABLE               *        
      ******************************************************************        
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA676.                                                           
      *                                                                         
MM         SELECT SCPINFO ASSIGN TO DA-SCPINFO.                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA676.                                                           
       01  FIOCA676.                                                    
           03  E-FCA676-ACCOUNT-NUMBER PIC 9(13).                       
           03  E-FCA676-ACCOUNT-NAME.                                   
               05  E-FCA676-FIRST-NAME PIC X(25).                       
               05  E-FCA676-LAST-NAME  PIC X(25).                       
           03  E-FCA676-HOUSE-NUMBER   PIC X(5).                        
           03  E-FCA676-STREET-ADDRESS PIC X(41).                       
           03  E-FCA676-CITY-STATE     PIC X(29).                       
A04880     03  E-FCA676-ZIP-CODE.                                       
A04880         05  E-FCA676-ZIP5       PIC 9(5).                        
A04880         05  E-FCA676-ZIP4       PIC 9(4).                        
           03  E-FCA676-HOME-PHONE     PIC 9(10).                       
           03  E-FCA676-WORK-LOCATION  PIC XXX.                         
           03  E-FCA676-SSAN           PIC 9(4).                        
           03  E-FCA676-ACCOUNT-TYPE   PIC X.                           
           03  E-FCA676-ALTERNATE-PHO  PIC X(10).                       
           03  E-FCA676-GRID-CELL      PIC X(10).                       
A02158     03  E-FCA676-COUNTY         PIC X(3).                        
      *                                                                         
MM     FD  SCPINFO                                                      
MM         BLOCK CONTAINS 0 RECORDS                                     
MM         RECORDING MODE IS F                                          
MM         LABEL RECORDS ARE STANDARD.                                  
MM     01  SCP-INFO.                                                    
MM8-03     03  SCP-FILLER          PIC X(6).                            
MM         03  SCP-ACCOUNT-NBR     PIC X(7).                            
MM         03  SCP-PIPE-1          PIC X.                               
MM         03  SCP-ACCOUNT-TYPE    PIC X.                               
MM         03  SCP-PIPE-2          PIC X.                               
MM         03  SCP-ACCOUNT-NAME    PIC X(30).                           
MM         03  SCP-PIPE-3          PIC X.                               
MM         03  SCP-FIRST-NAME      PIC X(15).                           
MM         03  SCP-PIPE-4          PIC X.                               
MM         03  SCP-MIDDLE-NAME     PIC X(10).                           
MM         03  SCP-PIPE-5          PIC X.                               
MM         03  SCP-LAST-NAME       PIC X(20).                           
MM         03  SCP-PIPE-6          PIC X.                               
MM         03  SCP-HOUSE-NO        PIC X(5).                            
MM         03  SCP-PIPE-7          PIC X.                               
MM         03  SCP-ADDR-PRE-1      PIC XXX.                             
MM         03  SCP-PIPE-8          PIC X.                               
MM         03  SCP-ADDR-PRE-2      PIC XX.                              
MM         03  SCP-PIPE-9          PIC X.                               
MM         03  SCP-STREET-NAME     PIC X(16).                           
MM         03  SCP-PIPE-10         PIC X.                               
MM         03  SCP-STREET-SUFFIX   PIC X(4).                            
MM         03  SCP-PIPE-11         PIC X.                               
MM         03  SCP-STREET-LOC-1    PIC X(4).                            
MM         03  SCP-PIPE-12         PIC X.                               
MM         03  SCP-STREET-LOC-2    PIC X(6).                            
MM         03  SCP-PIPE-13         PIC X.                               
MM         03  SCP-TOWN            PIC X(15).                           
MM         03  SCP-PIPE-14         PIC X.                               
MM         03  SCP-STATE           PIC XX.                              
MM         03  SCP-PIPE-15         PIC X.                               
MM         03  SCP-ZIP             PIC X(5).                            
MM         03  SCP-PIPE-16         PIC X.                               
MM         03  SCP-PHONE-NBR       PIC X(10).                           
MM         03  SCP-PIPE-17         PIC X.                               
MM         03  SCP-SUBSTATION      PIC X(5).                            
MM         03  SCP-PIPE-18         PIC X.                               
MM         03  SCP-CIRCUIT         PIC X(5).                            
MM         03  SCP-PIPE-19         PIC X.                               
MM         03  SCP-POLE-TAG-NBR    PIC X(10).                           
MM         03  SCP-PIPE-20         PIC X.                               
MM         03  SCP-METER-NBR       PIC X(9).                            
MM         03  SCP-PIPE-21         PIC X.                               
MM         03  SCP-GRID-CELL       PIC X(10).                           
MM         03  SCP-PIPE-22         PIC X.                               
MM         03  SCP-WORK-LO         PIC XXX.                             
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA676'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA676-STATUS                PIC X(02).               
               88 FCA676-SUCCESSFUL                      VALUE '00'.    
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-803                          PIC X(03) VALUE '803'.   
MM         05  WS-843                          PIC X(03) VALUE '843'.   
MM         05  WS-864                          PIC X(03) VALUE '864'.   
           05  WS-000                          PIC X(03) VALUE '000'.   
           05  WS-R                            PIC X(01) VALUE 'R'.     
           05  WS-PIPE                         PIC X(01) VALUE '|'.     
      *                                                                         
       01  WS-VARIABLES.                                                
COB305     05 STORE-ACCOUNT        PIC S9(13) COMP-3 VALUE 0.      
052004     05  STORE-PHONE                      PIC X(10).              
           05  WS-FIRST-NAME-CONCAT             PIC X(50).              
           05  WS-FIRST-NAME.                                           
               10  WS-FIRST-NAME-CH             PIC X(01)               
                                              OCCURS 50 TIMES           
                                               VALUE SPACES.            
           05  WS-FULL-NAME-CONCAT             PIC X(50).               
           05  WS-FULL-NAME.                                            
               10  WS-FULL-NAME-CH             PIC X(01)                
                                              OCCURS 50 TIMES           
                                               VALUE SPACES.            
           05  WS-NAME-LEN                     PIC 9(02) VALUE ZEROS.   
           05  WS-STREET-ADDRESS               PIC X(46) VALUE SPACES.  
MM8-03     05  WS-RECORD-COUNT              PIC S9(7) VALUE +0 COMP-3.  
           05 PROGRAM-NAME                     PIC X(8)  VALUE          
              'PCSCA676'.                                               
           05 RS-RETURN-CODE                   PIC S9(9) VALUE          
              +000 COMP.                                                
           05 RS-RETURN-CODE-DISP              PIC S9(9) VALUE          
              +000 COMP.                                                
      *                                                                         
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_CUST_PHONE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCSTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_ACCOUNT                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_NAME                                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_PREMISE                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_CUST_CUSTOMER                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ADDR_FORMATTED                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ZIP_CODE                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
MM    *****************************************************************         
MM    * CSS_MTRD_ENVRNMT                                                        
MM    *****************************************************************         
MM         EXEC SQL                                                             
MM             INCLUDE TBMTRENV                                                 
MM         END-EXEC.                                                            
MM    *                                                                         
MM    *****************************************************************         
C33743* CSS_PIM_POINT                                                           
C33743*****************************************************************         
C33743*                                                                         
C33743     EXEC SQL                                                             
C33743         INCLUDE TBPIMPNT                                                 
C33743     END-EXEC.                                                            
C33743*                                                                         
C33743*****************************************************************         
052004* CSS_CUST_STATS                                                          
052004*****************************************************************         
052004*                                                                         
052004     EXEC SQL                                                             
052004         INCLUDE TBCSTSTS                                                 
052004     END-EXEC.                                                            
052004*                                                                         
052004*****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD00004                                                     
      * WORKING STORAGE AREA USED TO REDUCE EMBEDDED BLANKS                     
       COPY CWS00011.                                                           
       COPY CWS00010.                                                           
                                                                        
012904****************************************************************          
012904*   TABLE TO ASSOCIATE GIS LOCAL OFFICE WITH CREW DEPARTMENT   *          
012904****************************************************************          
012904 01  TRANSLATE-GIS-TO-DEPT.                                       
012904     03  FILLER             PIC X(9)  VALUE '0030778MC'.          
012904     03  FILLER             PIC X(9)  VALUE '0050162LX'.          
012904     03  FILLER             PIC X(9)  VALUE '0060921PW'.          
012904     03  FILLER             PIC X(9)  VALUE '0080165CP'.          
012904     03  FILLER             PIC X(9)  VALUE '0090780RA'.          
012904     03  FILLER             PIC X(9)  VALUE '0100163JS'.          
012904     03  FILLER             PIC X(9)  VALUE '0120164SL'.          
012904     03  FILLER             PIC X(9)  VALUE '0140164BT'.          
012904     03  FILLER             PIC X(9)  VALUE '0200182SM'.          
012904     03  FILLER             PIC X(9)  VALUE '0210186SG'.          
012904     03  FILLER             PIC X(9)  VALUE '0230186HH'.          
012904     03  FILLER             PIC X(9)  VALUE '0300166LG'.          
012904     03  FILLER             PIC X(9)  VALUE '0350167LG'.          
012904     03  FILLER             PIC X(9)  VALUE '0420168HM'.          
012904     03  FILLER             PIC X(9)  VALUE '0520181BW'.          
012904     03  FILLER             PIC X(9)  VALUE '0530183NO'.          
012904     03  FILLER             PIC X(9)  VALUE '0600170BU'.          
012904     03  FILLER             PIC X(9)  VALUE '0650614BL'.          
012904     03  FILLER             PIC X(9)  VALUE '0700171SV'.          
012904     03  FILLER             PIC X(9)  VALUE '0800172WB'.          
012904     03  FILLER             PIC X(9)  VALUE '0810173HW'.          
012904     03  FILLER             PIC X(9)  VALUE '0900188CM'.          
012904     03  FILLER             PIC X(9)  VALUE '0910191AP'.          
012904     03  FILLER             PIC X(9)  VALUE '0920190SR'.          
012904     03  FILLER             PIC X(9)  VALUE '0950189MP'.          
012904 01  WIGFALL-TABLE REDEFINES TRANSLATE-GIS-TO-DEPT.               
012904     03  CODE-SWITCH OCCURS 25 TIMES.                             
012904         05  GIS-CODE       PIC XXX.                              
012904         05  FILLER         PIC X.                                
012904         05  NEW-CODE       PIC XXX.                              
012904         05  FILLER         PIC XX.                               
012904 01  WIGFALL-VARIABLES.                                           
012904     03  C-S-COUNT          PIC S99  VALUE +0 COMP-3.             
012904     03  GIS-CODE-HOLD      PIC XXX.                              
012904     03  NEW-CODE-HOLD      PIC XXX.                              
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT ACCOUNT DETAILS OF ACTIVE ACCTS**         
      ** WHOSE  PHONE-TYPE'S ARE H1,H2,B1,B2 AND NAME TYPE 'CN'      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCT-DET-CURSOR CURSOR FOR                       
               SELECT  DISTINCT                                         
                        AT.ACCOUNT_NO                                   
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.ACCOUNT_TYPE_CODE                            
                       ,AT.LOCAL_OFFICE                                 
                       ,DQ.FULL_NAME                                    
                       ,DQ.FIRST_NAME                                   
                       ,DQ.MIDDLE_NAME                                  
                       ,DQ.LAST_NAME                                    
                       ,DY.HOUSE_NO                                     
                       ,DY.ADDR_PREFIX_1                                
                       ,DY.ADDR_PREFIX_2                                
                       ,DY.STREET_NAME                                  
                       ,DY.STREET_LOCATION_1                            
                       ,DY.STREET_LOCATION_2                            
                       ,DY.STREET_SUFFIX                                
6-TEMP                 ,CB.PHONE_NO                                     
6-TEMP                 ,CB.PHONE_TYPE                                   
                       ,A4.TOWN                                         
                       ,A4.STATE                                        
                       ,DY.ZIP_CODE                                     
                       ,DY.ZIP_CODE_PLUS_FOUR                           
MM                     ,MN.METER_NO                                     
MM                     ,MN.GIS_POINT_ID                                 
C33743                 ,PP.POINT_ID                                     
MM                     ,PP.AREA_ID                                      
MM                     ,PP.TAG_NM                                       
MM8-03                 ,COALESCE(PP.GRID_CELL_TX,'NO ID')                 
MM                     ,PP.SUBSTATION_ID                                
MM                     ,PP.CIRCUIT_ID                                   
TEMP                   ,AT.CUSTOMER_NO                                  
A02158                 ,PR.COUNTY                                       
                 FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
                       ,CSS_NAME DQ WITH(READUNCOMMITTED)                       
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
6-TEMP                 ,CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                 
                       ,CSS_PREMISE PR WITH(READUNCOMMITTED)                    
                       ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
                       ,CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                   
MM                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
C33743                 ,CSS_PIM_POINT PP WITH(READUNCOMMITTED)                  
T33184           WHERE  AT.CODE_ACCT_STAT = 'A'                         
T33184              AND CB.PHONE_TYPE IN ('H1','H2','B1','B2','C1',     
T33184                                    'C2','A1','A2')               
T33184              AND CB.PHONE_NO     > '0000000000'                  
T33184              AND DQ.NAME_TYPE      = 'CN'                        
T33184              AND AT.CUSTOMER_NO    = CB.CUSTOMER_NO              
T33184              AND CU.CUSTOMER_NO    = CB.CUSTOMER_NO              
T33184              AND AT.PREMISE_NO     = PR.PREMISE_NO               
T33184              AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO               
T33184              AND PP.POINT_ID       = MN.GIS_POINT_ID             
T33184              AND PR.ADDRESS_ID     = DY.ADDRESS_ID               
T33184              AND DQ.NAME_ID        = CU.NAME_ID                  
T33184              AND DY.ZIP_CODE       = A4.ZIP_CODE                 
T33184              AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN           
               UNION                                                    
               SELECT  DISTINCT                                         
                        AT.ACCOUNT_NO                                   
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.ACCOUNT_TYPE_CODE                            
                       ,AT.LOCAL_OFFICE                                 
                       ,DQ.FULL_NAME                                    
                       ,DQ.FIRST_NAME                                   
                       ,DQ.MIDDLE_NAME                                  
                       ,DQ.LAST_NAME                                    
                       ,DY.HOUSE_NO                                     
                       ,DY.ADDR_PREFIX_1                                
                       ,DY.ADDR_PREFIX_2                                
                       ,DY.STREET_NAME                                  
                       ,DY.STREET_LOCATION_1                            
                       ,DY.STREET_LOCATION_2                            
                       ,DY.STREET_SUFFIX                                
6-TEMP                 ,CB.PHONE_NO                                     
6-TEMP                 ,CB.PHONE_TYPE                                   
                       ,A4.TOWN                                         
                       ,A4.STATE                                        
                       ,DY.ZIP_CODE                                     
                       ,DY.ZIP_CODE_PLUS_FOUR                           
MM                     ,MN.METER_NO                                     
MM                     ,MN.GIS_POINT_ID                                 
C33743                 ,PP.POINT_ID                                     
MM                     ,PP.AREA_ID                                      
MM                     ,PP.TAG_NM                                       
MM8-03                 ,COALESCE(PP.GRID_CELL_TX,'NO ID')                 
MM                     ,PP.SUBSTATION_ID                                
MM                     ,PP.CIRCUIT_ID                                   
TEMP                   ,AT.CUSTOMER_NO                                  
A02158                 ,PR.COUNTY                                       
                 FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
                       ,CSS_NAME DQ WITH(READUNCOMMITTED)                       
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_PREMISE PR WITH(READUNCOMMITTED)                    
                       ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
                       ,CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                   
MM                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
C33743                 ,CSS_PIM_POINT PP WITH(READUNCOMMITTED)                  
                       ,CSS_CONTACT_ACCT  C1 WITH(READUNCOMMITTED)              
                       ,CSS_CONTACT   C2 WITH(READUNCOMMITTED)                  
                       ,CSS_CONTACT_PHONE   CB WITH(READUNCOMMITTED)            
T33184           WHERE  AT.CODE_ACCT_STAT = 'A'                         
                    AND C1.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND C1.CONTACT_ID = C2.CONTACT_ID                   
                    AND C2.CONTACT_TYPE = 'OC'                          
                    AND CB.CONTACT_ID = C2.CONTACT_ID                   
T33184              AND DQ.NAME_TYPE      = 'CN'                        
T33184              AND CU.CUSTOMER_NO    = AT.CUSTOMER_NO              
T33184              AND AT.PREMISE_NO     = PR.PREMISE_NO               
T33184              AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO               
T33184              AND PP.POINT_ID       = MN.GIS_POINT_ID             
T33184              AND PR.ADDRESS_ID     = DY.ADDRESS_ID               
T33184              AND DQ.NAME_ID        = CU.NAME_ID                  
T33184              AND DY.ZIP_CODE       = A4.ZIP_CODE                 
T33184              AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN           
A02158           ORDER BY 1                                             
A02158           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT-DET-CURSOR CURSOR FOR                               
MFA-TR*        SELECT  DISTINCT                                                 
MFA-TR*                 AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*                ,DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*                ,DY.HOUSE_NO                                             
MFA-TR*                ,DY.ADDR_PREFIX_1                                        
MFA-TR*                ,DY.ADDR_PREFIX_2                                        
MFA-TR*                ,DY.STREET_NAME                                          
MFA-TR*                ,DY.STREET_LOCATION_1                                    
MFA-TR*                ,DY.STREET_LOCATION_2                                    
MFA-TR*                ,DY.STREET_SUFFIX                                        
MFA-TR*                ,CB.PHONE_NO                                             
MFA-TR*                ,CB.PHONE_TYPE                                           
MFA-TR*                ,A4.TOWN                                                 
MFA-TR*                ,A4.STATE                                                
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*                ,DY.ZIP_CODE_PLUS_FOUR                                   
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.GIS_POINT_ID                                         
MFA-TR*                ,PP.POINT_ID                                             
MFA-TR*                ,PP.AREA_ID                                              
MFA-TR*                ,PP.TAG_NM                                               
MFA-TR*                ,IFNULL(PP.GRID_CELL_TX,'NO ID')                         
MFA-TR*                ,PP.SUBSTATION_ID                                        
MFA-TR*                ,PP.CIRCUIT_ID                                           
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,PR.COUNTY                                               
MFA-TR*          FROM   CSS_CUSTOMER CU                                         
MFA-TR*                ,CSS_NAME DQ                                             
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_CUST_PHONE CB                                       
MFA-TR*                ,CSS_PREMISE PR                                          
MFA-TR*                ,CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_ZIP_CODE A4                                         
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_PIM_POINT PP                                        
MFA-TR*          WHERE  AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND CB.PHONE_TYPE IN ('H1','H2','B1','B2','C1',             
MFA-TR*                                   'C2','A1','A2')                       
MFA-TR*             AND CB.PHONE_NO     > '0000000000'                          
MFA-TR*             AND DQ.NAME_TYPE      = 'CN'                                
MFA-TR*             AND AT.CUSTOMER_NO    = CB.CUSTOMER_NO                      
MFA-TR*             AND CU.CUSTOMER_NO    = CB.CUSTOMER_NO                      
MFA-TR*             AND AT.PREMISE_NO     = PR.PREMISE_NO                       
MFA-TR*             AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO                       
MFA-TR*             AND PP.POINT_ID       = MN.GIS_POINT_ID                     
MFA-TR*             AND PR.ADDRESS_ID     = DY.ADDRESS_ID                       
MFA-TR*             AND DQ.NAME_ID        = CU.NAME_ID                          
MFA-TR*             AND DY.ZIP_CODE       = A4.ZIP_CODE                         
MFA-TR*             AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                   
MFA-TR*        UNION                                                            
MFA-TR*        SELECT  DISTINCT                                                 
MFA-TR*                 AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*                ,DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*                ,DY.HOUSE_NO                                             
MFA-TR*                ,DY.ADDR_PREFIX_1                                        
MFA-TR*                ,DY.ADDR_PREFIX_2                                        
MFA-TR*                ,DY.STREET_NAME                                          
MFA-TR*                ,DY.STREET_LOCATION_1                                    
MFA-TR*                ,DY.STREET_LOCATION_2                                    
MFA-TR*                ,DY.STREET_SUFFIX                                        
MFA-TR*                ,CB.PHONE_NO                                             
MFA-TR*                ,CB.PHONE_TYPE                                           
MFA-TR*                ,A4.TOWN                                                 
MFA-TR*                ,A4.STATE                                                
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*                ,DY.ZIP_CODE_PLUS_FOUR                                   
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.GIS_POINT_ID                                         
MFA-TR*                ,PP.POINT_ID                                             
MFA-TR*                ,PP.AREA_ID                                              
MFA-TR*                ,PP.TAG_NM                                               
MFA-TR*                ,IFNULL(PP.GRID_CELL_TX,'NO ID')                         
MFA-TR*                ,PP.SUBSTATION_ID                                        
MFA-TR*                ,PP.CIRCUIT_ID                                           
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,PR.COUNTY                                               
MFA-TR*          FROM   CSS_CUSTOMER CU                                         
MFA-TR*                ,CSS_NAME DQ                                             
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_PREMISE PR                                          
MFA-TR*                ,CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_ZIP_CODE A4                                         
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_PIM_POINT PP                                        
MFA-TR*                ,CSS_CONTACT_ACCT  C1                                    
MFA-TR*                ,CSS_CONTACT   C2                                        
MFA-TR*                ,CSS_CONTACT_PHONE   CB                                  
MFA-TR*          WHERE  AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND C1.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND C1.CONTACT_ID = C2.CONTACT_ID                           
MFA-TR*             AND C2.CONTACT_TYPE = 'OC'                                  
MFA-TR*             AND CB.CONTACT_ID = C2.CONTACT_ID                           
MFA-TR*             AND DQ.NAME_TYPE      = 'CN'                                
MFA-TR*             AND CU.CUSTOMER_NO    = AT.CUSTOMER_NO                      
MFA-TR*             AND AT.PREMISE_NO     = PR.PREMISE_NO                       
MFA-TR*             AND AT.ACCOUNT_NO     = MN.ACCOUNT_NO                       
MFA-TR*             AND PP.POINT_ID       = MN.GIS_POINT_ID                     
MFA-TR*             AND PR.ADDRESS_ID     = DY.ADDRESS_ID                       
MFA-TR*             AND DQ.NAME_ID        = CU.NAME_ID                          
MFA-TR*             AND DY.ZIP_CODE       = A4.ZIP_CODE                         
MFA-TR*             AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                   
MFA-TR*          ORDER BY 1                                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   OPENS THE OUTPUT FILE FCSCA676                               *        
      ******************************************************************        
       0100-INITIALISATION.                                             
                                                                        
MM         OPEN OUTPUT FCSCA676-FILE SCPINFO.                           
      *                                                                         
           IF  FCA676-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************PCSCA676**********'                
               DISPLAY 'ERROR IN OPENING FCSCA676'                      
               DISPLAY 'ERROR STATUS ' WS-FCA676-STATUS                 
               DISPLAY '*************PCSCA676**********'                
               PERFORM 9000-TERMINATE          THRU 9000-EXIT           
           END-IF.                                                      
      *                                                                         
052004     MOVE ZEROS TO STORE-ACCOUNT.                                 
052004     MOVE SPACES TO STORE-PHONE.                                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE CURSOR  REV-ACCT   **        
      * CURSOR                                                        **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-ACCT-DET-CURSOR   THRU 7000-EXIT.          
      *                                                                         
           PERFORM 7010-FETCH-ACCT-DET-CURSOR  THRU 7010-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               PERFORM 7020-CLOSE-ACCT-DET-CURSOR THRU 7020-EXIT        
               DISPLAY '********** PCSCA676 ********************'       
               DISPLAY '* NO ROWS FETCHED FOR ACCOUNT         *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '********** PCSCA676 ********************'       
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   PERFORM 2000-LOAD-OUTPUT    THRU 2000-EXIT           
                   PERFORM 7010-FETCH-ACCT-DET-CURSOR                   
                                               THRU 7010-EXIT           
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-ACCT-DET-CURSOR  THRU 7020-EXIT.          
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * POPULATES THE OUTPUT VARIABLES AND WRITES ON TO FCSCA676 FILE           
      ******************************************************************        
      *                                                                         
       2000-LOAD-OUTPUT.                                                
      *                                                                         
           INITIALIZE FIOCA676                                          
                      WS-STREET-ADDRESS                                 
                      WS-FULL-NAME                                      
052004                WS-FIRST-NAME                                     
           MOVE SPACES  TO WS-CMP-TABLE                                 
                           WS-EMB-INPUT                                 
           MOVE 1       TO WS-NAME-LEN.                                 
052004     MOVE AT-ACCOUNT-NO TO E-FCA676-ACCOUNT-NUMBER.               
052004     MOVE AT-ACCOUNT-TYPE-CODE TO E-FCA676-ACCOUNT-TYPE.          
A02158     MOVE PR-COUNTY            TO E-FCA676-COUNTY.                
           MOVE SPACES TO WS-FULL-NAME-CONCAT WS-FIRST-NAME-CONCAT      
           STRING DQ-FIRST-NAME  DELIMITED BY '  '                      
                  ' '      DELIMITED BY SIZE                            
                  DQ-MIDDLE-NAME  DELIMITED BY '  '                     
                  ' '      DELIMITED BY SIZE                            
                  DQ-LAST-NAME DELIMITED BY '  '                        
                  INTO WS-FULL-NAME-CONCAT.                             
                                                                        
052004*  NEW FOR TFCCI                                                          
052004     STRING DQ-FIRST-NAME  DELIMITED BY '  '                      
052004            ' '      DELIMITED BY SIZE                            
052004            DQ-MIDDLE-NAME  DELIMITED BY '  '                     
052004            ' '      DELIMITED BY SIZE                            
052004            INTO WS-FIRST-NAME-CONCAT.                            
052004     MOVE WS-FIRST-NAME-CONCAT TO WS-FIRST-NAME.                  
052004     IF  WS-FIRST-NAME > SPACES                                   
052004         MOVE WS-FIRST-NAME TO WS-EMB-INPUT                       
052004         PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT       
052004         MOVE WS-CMP-TABLE TO WS-FIRST-NAME                       
052004         MOVE SPACES TO WS-CMP-TABLE WS-EMB-INPUT                 
052004     END-IF.                                                      
052004                                                                  
           IF WS-FULL-NAME-CONCAT > SPACES                              
              MOVE WS-FULL-NAME-CONCAT TO DQ-FULL-NAME                  
           END-IF                                                       
           IF  DQ-FULL-NAME = SPACES                                    
               MOVE SPACES                    TO WS-FULL-NAME           
             ELSE                                                       
               MOVE DQ-FULL-NAME              TO WS-FULL-NAME           
               MOVE WS-FULL-NAME              TO WS-EMB-INPUT           
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT       
               MOVE WS-CMP-TABLE              TO WS-FULL-NAME           
               MOVE SPACES                    TO WS-CMP-TABLE           
                                                 WS-EMB-INPUT           
               INSPECT WS-FULL-NAME REPLACING ALL LOW-VALUES BY SPACES  
           END-IF.                                                      
           IF AT-ACCOUNT-TYPE-CODE = 'R'                                
               MOVE DQ-LAST-NAME  TO E-FCA676-LAST-NAME                 
052004         MOVE WS-FIRST-NAME TO E-FCA676-FIRST-NAME                
             ELSE                                                       
052004         MOVE DQ-FULL-NAME  TO E-FCA676-ACCOUNT-NAME              
           END-IF.                                                      
                                                                        
A04880     MOVE '0000' TO E-FCA676-SSAN.                                
                                                                        
052004     IF  CB-PHONE-NO (1:3) = WS-000                               
052004         MOVE WS-803 TO CB-PHONE-NO (1:3)                         
052004     END-IF                                                       
052004     MOVE CB-PHONE-NO TO E-FCA676-HOME-PHONE                      
052004     MOVE CB-PHONE-NO TO SCP-PHONE-NBR                            
052004*    MOVE CB-PHONE-TYPE TO E-FCA676-ALTERNATE-PHO                         
052004     MOVE ZEROS TO E-FCA676-ALTERNATE-PHO                         
C33743     MOVE PP-AREA-ID     TO GIS-CODE-HOLD                         
012904     PERFORM WIGFALL-CONVERSION THRU WIGFALL-EXIT.                
012904     MOVE NEW-CODE-HOLD TO E-FCA676-WORK-LOCATION                 
           STRING A4-TOWN  DELIMITED BY '  '                            
                  ' '      DELIMITED BY SIZE                            
                  A4-STATE DELIMITED BY SIZE                            
                  INTO E-FCA676-CITY-STATE.                             
                                                                        
           STRING DY-ADDR-PREFIX-1     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-ADDR-PREFIX-2     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-NAME       DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-SUFFIX     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-LOCATION-1 DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-LOCATION-2 DELIMITED BY SIZE                
               INTO WS-STREET-ADDRESS.                                  
           MOVE WS-STREET-ADDRESS            TO WS-EMB-INPUT.           
           MOVE DY-HOUSE-NO TO E-FCA676-HOUSE-NUMBER.                   
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE                 TO E-FCA676-STREET-ADDRESS.
      *                                                                         
A04880*    STRING DY-ZIP-CODE           DELIMITED BY SIZE                       
A04880*           DY-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE                       
A04880*    INTO E-FCA676-ZIP-CODE.                                              
      *                                                                         
           IF DY-ZIP-CODE > SPACES                                      
              MOVE DY-ZIP-CODE TO E-FCA676-ZIP5                         
           ELSE                                                         
              MOVE ZEROS TO E-FCA676-ZIP5                               
           END-IF.                                                      
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE DY-ZIP-CODE-PLUS-FOUR TO E-FCA676-ZIP4               
           ELSE                                                         
              MOVE ZEROS TO E-FCA676-ZIP4                               
           END-IF.                                                      
      *                                                                         
C33743*    MOVE PP-GRID-CELL-TX TO E-FCA676-GRID-CELL.                          
A05136     MOVE PP-POINT-ID     TO E-FCA676-GRID-CELL.                  
MM8-03     ADD +1 TO WS-RECORD-COUNT.                                   
           PERFORM 8000-WRITE-E-FCA676-REC     THRU 8000-EXIT.          
           PERFORM 3000-SCP-FILE THRU 3000-EXIT.                        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
012904 WIGFALL-CONVERSION.                                              
012904     MOVE +1 TO C-S-COUNT.                                        
012904 WIGFALL-LOOP.                                                    
012904     IF C-S-COUNT GREATER THAN +25                                
012904        MOVE '778' TO NEW-CODE-HOLD                               
012904        GO TO WIGFALL-EXIT                                        
012904     END-IF.                                                      
012904     IF GIS-CODE-HOLD = GIS-CODE (C-S-COUNT)                      
012904        MOVE NEW-CODE (C-S-COUNT) TO NEW-CODE-HOLD                
012904        GO TO WIGFALL-EXIT                                        
012904     END-IF.                                                      
012904     ADD +1 TO C-S-COUNT.                                         
012904     GO TO WIGFALL-LOOP.                                          
012904 WIGFALL-EXIT.                                                    
012904     EXIT.                                                        
      *                                                                         
MM    ******************************************************************        
MM    * PREPARE SCP FILE INFO                                          *        
MM    ******************************************************************        
MM     3000-SCP-FILE.                                                   
052004     IF AT-ACCOUNT-NO = STORE-ACCOUNT AND                         
052004         CB-PHONE-NO = STORE-PHONE                                
052004         GO TO 3000-EXIT                                          
052004       ELSE                                                       
052004         MOVE AT-ACCOUNT-NO TO STORE-ACCOUNT                      
052004         MOVE CB-PHONE-NO TO STORE-PHONE                          
052004     END-IF.                                                      
MM         MOVE WS-PIPE TO SCP-PIPE-1 SCP-PIPE-2 SCP-PIPE-3             
MM                         SCP-PIPE-4 SCP-PIPE-5 SCP-PIPE-6             
MM                         SCP-PIPE-7 SCP-PIPE-8 SCP-PIPE-9             
MM                         SCP-PIPE-10 SCP-PIPE-11 SCP-PIPE-12          
MM                         SCP-PIPE-13 SCP-PIPE-14 SCP-PIPE-15          
MM                         SCP-PIPE-16 SCP-PIPE-17 SCP-PIPE-18          
MM                         SCP-PIPE-19 SCP-PIPE-20 SCP-PIPE-21          
MM                         SCP-PIPE-22.                                 
012904* GIS-LOC-OFF-CD = CREW QUARTERS LOCATION BUT MUST BE TRANSLATED          
012904* INTO A DEPARTMENT NUMBER PER JAMES WIGFALL.                             
MM8-03     MOVE '000000' TO SCP-FILLER.                                 
MM8-03     MOVE WS-RECORD-COUNT TO SCP-ACCOUNT-NBR                      
MM         MOVE AT-ACCOUNT-TYPE-CODE TO SCP-ACCOUNT-TYPE.               
MM         MOVE DY-HOUSE-NO TO SCP-HOUSE-NO                             
MM         MOVE DY-ADDR-PREFIX-1 TO SCP-ADDR-PRE-1.                     
MM         MOVE DY-ADDR-PREFIX-2 TO SCP-ADDR-PRE-2.                     
MM         MOVE DY-STREET-NAME TO SCP-STREET-NAME.                      
MM         MOVE DY-STREET-LOCATION-1 TO SCP-STREET-LOC-1                
MM         MOVE DY-STREET-LOCATION-2 TO SCP-STREET-LOC-2.               
MM         MOVE DY-STREET-SUFFIX TO SCP-STREET-SUFFIX .                 
MM         MOVE DY-ZIP-CODE TO SCP-ZIP.                                 
MM         MOVE A4-TOWN TO SCP-TOWN.                                    
MM         MOVE A4-STATE TO SCP-STATE.                                  
MM         IF AT-ACCOUNT-TYPE-CODE = 'R'                                
MM            MOVE DQ-FIRST-NAME TO SCP-FIRST-NAME                      
MM            MOVE DQ-MIDDLE-NAME TO SCP-MIDDLE-NAME                    
MM            MOVE DQ-LAST-NAME TO SCP-LAST-NAME                        
MM            MOVE DQ-FULL-NAME TO SCP-ACCOUNT-NAME                     
MM          ELSE                                                        
MM            MOVE DQ-FULL-NAME TO SCP-ACCOUNT-NAME                     
MM            MOVE SPACES TO SCP-FIRST-NAME SCP-MIDDLE-NAME             
MM                           SCP-LAST-NAME                              
MM         END-IF.                                                      
C33743     MOVE PP-SUBSTATION-ID TO SCP-SUBSTATION.                     
C33743     MOVE PP-CIRCUIT-ID TO SCP-CIRCUIT.                           
C33743     MOVE SPACES    TO SCP-POLE-TAG-NBR.                          
C33743     MOVE PP-TAG-NM TO SCP-POLE-TAG-NBR.                          
MM         MOVE MN-METER-NO TO SCP-METER-NBR.                           
012904     MOVE NEW-CODE-HOLD TO SCP-WORK-LO.                           
C33743*    MOVE PP-GRID-CELL-TX TO SCP-GRID-CELL.                               
A05136     MOVE PP-POINT-ID     TO SCP-GRID-CELL.                       
MM         PERFORM 8010-WRITE-SCP-REC THRU 8010-EXIT.                   
MM     3000-EXIT.                                                       
MM         EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
      ******************************************************************        
      * OPENS REV-ACCT CURSOR                                                   
      ******************************************************************        
      *                                                                         
       7000-OPEN-ACCT-DET-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT-DET-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO                       
                                                WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA676   ABORT ************'       
               DISPLAY '* 7000-OPEN-ACCT-DET-CURSOR           *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA676   ABORT ************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES ACCOUNT  DETAILS                                       *        
      ******************************************************************        
       7010-FETCH-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT-DET-CURSOR                                     
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-LOCAL-OFFICE                                   
                    ,:DQ-FULL-NAME                                      
                    ,:DQ-FIRST-NAME                                     
                    ,:DQ-MIDDLE-NAME                                    
                    ,:DQ-LAST-NAME                                      
                    ,:DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-SUFFIX                                  
052004              ,:CB-PHONE-NO                                       
052004              ,:CB-PHONE-TYPE                                     
                    ,:A4-TOWN                                           
                    ,:A4-STATE                                          
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
MM                  ,:MN-METER-NO                                       
MM                  ,:MN-GIS-POINT-ID                                   
C33743              ,:PP-POINT-ID                                       
C33743              ,:PP-AREA-ID                                        
C33743              ,:PP-TAG-NM                                         
C33743              ,:PP-GRID-CELL-TX                                   
C33743              ,:PP-SUBSTATION-ID                                  
C33743              ,:PP-CIRCUIT-ID                                     
TEMP                ,:AT-CUSTOMER-NO                                    
A02158              ,:PR-COUNTY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA676  ABORT ************'        
               DISPLAY '* 7010-FETCH-ACCT-DET-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA676  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES REV-ACCT CURSOR                                         *        
      ******************************************************************        
       7020-CLOSE-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT-DET-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO                       
                                            WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA676  ABORT ************'        
               DISPLAY '* 7020-CLOSE-ACCT-DET-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA676  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * WRITES A RECORD TO FCSCA676-FILE                              *         
      *****************************************************************         
       8000-WRITE-E-FCA676-REC.                                         
      *                                                                         
           WRITE FIOCA676.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
MM    *****************************************************************         
MM    * WRITES A RECORD TO SCP-INFO-FILE                              *         
MM    *****************************************************************         
MM     8010-WRITE-SCP-REC.                                              
MM    *                                                                         
MM         WRITE SCP-INFO.                                              
MM    *                                                                         
MM     8010-EXIT.                                                       
MM         EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSES  THE OUTPUT  FILES                                  **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
MM         CLOSE   FCSCA676-FILE SCPINFO                                
      *                                                                         
           IF  FCA676-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSCA676-FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FCA676-STATUS                 
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
