       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA675.                                         
       DATE-WRITTEN. SEPT 1996.                                         
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **                                                             **         
      **  10/21/96   RS        INITIAL DEVELOPMENT                   **         
PCR376**   9/3/97    PD        SELECT CSS_XREF_ACCT BY JOINING WITH  **         
PCR376**                       CSS_CUST_PREM_HIST TO TAKE CARE OF    **         
PCR376**                       MULTIPLE OLD-ACCOUNT-NO.              **         
T13214**  9/30/97    AJC       HANDLE -803 INSERTS AS UPDATES, WRITE **         
T13214**                       AN ERROR RPT FOR NON-TERMINAL ERRORS  **         
T17354** 11/25/98    CBSI      INCLUDE CWS00095 IS CHANGED TO COPY   **         
T17354**                       CWS00095, AS IT DOESN'T HAVE ANY SQL. **         
BG0202** 02/02/99    VWG       ADDED RATES B27/023/60S TO 7500       **         
T26458** 05/28/02    GAUSE     ADDED RATE 60L TO PARA 7500           **         
C26776** 07/02/02    GSR       REMOVED RATE 023.                     **         
T27897** 12/12/02    COVANSYS  ADD RATE_PLAN_NO F27 TO PARA 7500     **         
T27897**             CHENNAI                                         **         
T26776** 01/14/04    ROD       UPDATE RATE LIST IN 7500-             **         
      **                                                             **         
A03204** 27 MAR 2011 RF10596   ADD RATE 60M IN 7500-                 **         
A03204**                       ADD -WITH UR- AND QUERYNO             **         
      **                                                             **         
A05136** 30 OCT 2015 RF10596   CHANGE INPUT FILE LAYOUT. ADD         **         
A05136**                       COPYBOOKS.  REMOVE RATE CHECK FROM    **         
A05136**                       7500-ACCT-IC-NO SQL.                  **         
      **                                                             **         
ACT122** 14 JUN 2016 VIJAY     CONVERT 24.00.00 TO 00.00.00 TO SUPPORT*         
ACT122** A05460                SQL DATABASE(WILL BE CONVERTED BACK IN**         
ACT122** A05460                CPDCA118 TO 24.00.00 BEFORE ANY CALCU-**         
ACT122** A05460                LATION).                              **         
      *****************************************************************         
      ** PURPOSE      :                                              **         
      **                                                             **         
      **    THIS PROGRAM READS THE BASELINE KWH FOR EVERY HOUR       **         
      ** FROM THE RTPCBL FILE FOR THE ENTIRE YEAR AND LOADS THE      **         
      ** THE INFORMATION INTO TABLE  CSS_CBL_USAGE.                  **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 6999  NOT USED                                      **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READ, SELECTS, ETC.) **         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (DISPLAY,INSERT,ETC.)**         
      **  9000 - 9999  ABEND ROUTINES.                               **         
      **                                                             **         
      *****************************************************************         
                                                                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
A05136 COPY CSSCA675.                                                           
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
A05136 COPY CFDCA675.                                                           
A05136 COPY FIOCA675.                                                           
      *                                                                         
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA675'.
MSQ017     COPY MFASQLM.
                                                                        
      *********************************************************                 
      *  DB2 TABLES USED IN THIS PROGRAM                      *                 
      *********************************************************                 
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *  CSS_ACCOUNT                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *  CSS_XREF_ACCT                                                          
           EXEC SQL                                                             
              INCLUDE TBXREF                                                    
           END-EXEC.                                                            
                                                                        
      *  CSS_CBL_USAGE                                                          
           EXEC SQL                                                             
              INCLUDE TBCBLUSG                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_UTIL_ENVRNMT                                                       
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_CUST_PREM_HIST                                                     
PCR376     EXEC SQL                                                             
PCR376        INCLUDE TBCSTPRM                                                  
PCR376     END-EXEC.                                                            
      *********************************************************                 
      *      COPY BOOKS                                       *                 
      *********************************************************                 
T13214      EXEC SQL                                                            
T13214          INCLUDE CWS09900                                                
T13214      END-EXEC.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00303                                                  
           END-EXEC.                                                            
                                                                        
       01 FILLER                  PIC X(20) VALUE 'WORKING STORAGE'.    
                                                                        
       01 WORK-STORAGE.                                                 
A05136    04 WS-FCA675-STATUS     PIC XX  VALUE SPACES.                 
          04 WS-ACCT-NO           PIC S9(13)V COMP-3                    
                                              VALUE ZEROS.              
          04 WS-TEMP-ACCT-NO      PIC 9(13)                             
                                              VALUE ZEROS.              
          04 WS-HOLD-ACCT         PIC X(13).                            
          04 WS-ERROR-ACCT                           PIC X(13).         
          04 WS-NEW-ACCOUNT-NO         PIC S9(13)V COMP-3               
                                              VALUE ZEROS.              
          04 WS-INTRVAL-START-TIME.                                     
             08 WS-START-HH       PIC X(02).                            
             08 FILLER            PIC X(01)                             
                                              VALUE '.'.                
             08 WS-START-MM       PIC X(02)                             
                                              VALUE '00'.               
             08 FILLER            PIC X(01)                             
                                              VALUE '.'.                
             08 WS-START-SS       PIC X(02)                             
                                              VALUE '01'.               
          04 WS-INTERVAL-END-TIME.                                      
             08 WS-END-TIME-HH    PIC X(02).                            
             08 FILLER            PIC X(01)                             
                                              VALUE '.'.                
             08 WS-END-TIME-MM    PIC X(02)                             
                                              VALUE '00'.               
             08 FILLER            PIC X(01)                             
                                              VALUE '.'.                
             08 WS-END-TIME-SS    PIC X(02)                             
                                              VALUE '00'.               
                                                                        
          04 WS-TEMP-DATE.                                              
             08 WS-TEMP-MM        PIC X(02).                            
             08 FILLER            PIC X(01)                             
                                              VALUE '/'.                
             08 WS-TEMP-DD        PIC X(02).                            
             08 FILLER            PIC X(01)                             
                                              VALUE '/'.                
             08 WS-TEMP-CCYY.                                           
                 10 WS-TEMP-CC    PIC X(02).                            
                 10 WS-TEMP-YY    PIC X(02).                            
                                                                        
          04 WS-REC-NO            PIC 9(03)                             
                                              VALUE ZEROS.              
          04 WS-RECORD-COUNT      PIC 9(03)                             
                                              VALUE ZEROS.              
          04 WS-HOUR-COUNT        PIC 9(02)                             
                                              VALUE ZEROS.              
          04 WS-SWITCHES.                                               
             08 WS-END-OF-FILE-SWITCH  PIC X(03)                        
                                              VALUE 'NO'.               
                 88 END-OF-FILE               VALUE 'YES'.              
      *                                                                         
             08 WS-ERROR-IN-RUN        PIC X(03)                        
                                              VALUE 'NO '.              
                 88 ERROR-FOUND               VALUE 'YES'.              
                                                                        
T13214****************************************************************          
T13214 01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 62   COMP-3.  
T13214 01  WS-RPT1-PAGE-NO             PIC 9(05)    VALUE ZERO COMP-3.  
T13214****************************************************************          
T13214*                                                                         
T13214 01  WS-CURRENT-TIME.                                             
T13214     05  WS-HH                   PIC 9(02).                       
T13214     05  WS-MM                   PIC 9(02).                       
T13214     05  WS-SS                   PIC 9(02).                       
T13214     05  WS-TT                   PIC 9(02).                       
T13214*                                                                         
T13214 01  WS-RUN-TIME.                                                 
T13214     05  WS-RT-HH                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE ':'.          
T13214     05  WS-RT-MM                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE ':'.          
T13214     05  WS-RT-SS                PIC X(02).                       
T13214*                                                                         
T13214 01  WS-CURRENT-DATE.                                             
T13214     05  WS-CY                   PIC 9(02).                       
T13214     05  WS-CM                   PIC 9(02).                       
T13214     05  WS-CD                   PIC 9(02).                       
T13214*                                                                         
T13214 01  WS-RUN-DATE.                                                 
T13214     05  WS-RD-MM                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '/'.          
T13214     05  WS-RD-DD                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '/'.          
T13214     05  WS-RD-YY                PIC X(02).                       
T13214*                                                                         
T13214 01  WS-DATE-10.                                                  
T13214     05  WS-D10-CC               PIC X(02).                       
T13214     05  WS-D10-YY               PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '-'.          
T13214     05  WS-D10-MM               PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '-'.          
T13214     05  WS-D10-DD               PIC X(02).                       
T13214*                                                                         
T13214 01  WS-DATE-8.                                                   
T13214     05  WS-D8-MM                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '/'.          
T13214     05  WS-D8-DD                PIC X(02).                       
T13214     05  FILLER                  PIC X(01)    VALUE '/'.          
T13214     05  WS-D8-YY                PIC X(02).                       
T13214*                                                                         
T13214 01  WS-LITERALS.                                                 
T13214     05  WS-N                    PIC X(01)    VALUE 'N'.          
T13214     05  WS-NO                   PIC X(03)    VALUE 'NO '.        
T13214     05  WS-YES                  PIC X(03)    VALUE 'YES'.        
T13214     05  WS-Y                    PIC X(01)    VALUE 'Y'.          
T13214     05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA675'.   
T13214     05  WS-60                   PIC 9(02)    VALUE 60.           
T13214     05  DUPLICATE-ROW           PIC S9(3)    VALUE -803.         
T13214     05  WS-DEFAULT-RPT1-TITLE1  PIC X(27)    VALUE               
T13214              '  CBL FILE ERRORS REPORT  '.                       
T13214*                                                                         
T13214 01  WS-HEADING-LINES.                                            
T13214*                                                                         
T13214****************************************************************          
T13214**         COMMON WORKING STORAGE FOR REPORT TITLE            **          
T13214****************************************************************          
T13214*                                                                         
T13214     05  WS-RPT1-TITLE.                                           
T13214         10  P-RPT1-TITLE-PGNM   PIC X(10)    VALUE SPACES.       
T13214         10  FILLER              PIC X(42)    VALUE SPACES.       
T13214         10  P-RPT1-COMP-NAME    PIC X(28)    VALUE               
T13214                    'SOUTH CAROLINA ELECTIC & GAS'.               
T13214         10  FILLER              PIC X(34)    VALUE SPACES.       
T13214         10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
T13214         10  P-RPT1-RUN-DATE     PIC X(08).                       
T13214*                                                                         
T13214****************************************************************          
T13214**         COMMON WORKING STORAGE FOR REPORT HEADER1          **          
T13214****************************************************************          
T13214*                                                                         
T13214     05  WS-RPT1-HEADER-1.                                        
T13214         10  FILLER              PIC X(06)    VALUE 'DATE: '.     
T13214         10  P-RPT1-DATE         PIC X(08).                       
T13214         10  FILLER              PIC X(39)    VALUE SPACES.       
T13214         10  P-RPT1-HEAD1        PIC X(27).                       
T13214         10  FILLER              PIC X(34)    VALUE SPACES.       
T13214         10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
T13214         10  P-RPT1-RUN-TIME     PIC X(08).                       
T13214*                                                                         
T13214****************************************************************          
T13214**         COMMON WORKING STORAGE FOR REPORT HEADER2          **          
T13214****************************************************************          
T13214*                                                                         
T13214     05  WS-RPT1-HEADER-2.                                        
T13214         10  FILLER              PIC X(55)    VALUE SPACES.       
T13214         10  P-RPT1-HEAD2        PIC X(22)    VALUE SPACES.       
T13214         10  FILLER              PIC X(41)    VALUE SPACES.       
T13214         10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
T13214         10  FILLER              PIC X(02)    VALUE SPACES.       
T13214         10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
T13214*                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-1.                                 
               10  FILLER              PIC X(06)    VALUE '  PARA'.     
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(45)    VALUE               
                                         '    ERROR DESCRIPTION'.       
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(09)    VALUE               
                                                   'IC NUMBER'.         
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'SQL CODE'.   
               10  FILLER              PIC X(45)    VALUE SPACES.       
T13214****************************************************************          
T13214**          WORKING STORAGE FOR REPORT DETAIL LINES           **          
T13214****************************************************************          
T13214*                                                                         
T13214 01  WS-RPT1-DETAIL-LINES.                                        
T13214*                                                                         
T13214     05  WS-RPT1-DETAIL-LINE-1.                                   
T13214         10  FILLER                 PIC X(02)    VALUE SPACES.    
T13214         10  P-PARA                 PIC X(04).                    
T13214         10  FILLER                 PIC X(06)    VALUE SPACES.    
T13214         10  P-ERROR-DESC           PIC X(45).                    
T13214         10  P-ACCOUNT-NO           PIC 9(13).                    
T13214         10  FILLER                 PIC X(05)    VALUE SPACES.    
T13214         10  P-IC-NO                PIC 9(09).                    
T13214         10  FILLER                 PIC X(06)    VALUE SPACES.    
T13214         10  P-SQL-CODE             PIC -ZZZ9.                    
T13214         10  FILLER                 PIC X(31)    VALUE SPACES.    
T13214*                                                                         
T13214*                                                                         
T13214 01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
T13214 01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
T13214*                                                                         
T13214 01  WS-NO-DATA-LINE.                                             
T13214     05  FILLER                  PIC X(55)    VALUE SPACES.       
T13214     05  FILLER                  PIC X(22)    VALUE               
T13214               '** NO DATA THIS RUN **'.                          
T13214     05  FILLER                  PIC X(55)    VALUE SPACES.       
T13214*                                                                         
T13214 01  WS-END-DATA-LINE.                                            
T13214     05  FILLER                  PIC X(55)    VALUE SPACES.       
T13214     05  FILLER                  PIC X(22)    VALUE               
T13214               '*** END OF REPORT ***'.                           
T13214     05  FILLER                  PIC X(55)    VALUE SPACES.       
T13214*                                                                         
T13214 01  ABEND-FUNCTION.                                              
T13214     05  WS-ABEND-SPACE          PIC X(02).                       
T13214     05  FILLER REDEFINES WS-ABEND-SPACE.                         
T13214         10  WS-ABEND-NUMERIC    PIC 9(02).                       
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************                    
      **                                                                        
      **   0000-MAINLINE                                                        
      **                                                                        
      **   PERFORM THE INITIALIZATION ROUTINE. PERFORM                          
      **   MAIN LOOP UNTIL END OF INPUT FILE. CLOSE THE                         
      **   FILES OPENED AND STOP RUN.                                           
      **                                                                        
      ******************************************************                    
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-RECS THRU 1000-EXIT                     
                      UNTIL END-OF-FILE.                                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
T13214     STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************                    
      **                                                                        
      **   OPEN THE RTP FILE IN READ MODE. INITIALIZE THE                       
      **   INTERNAL VARIABLES. OPEN THE OUTPUT FILE.                            
      **                                                                        
      ******************************************************                    
                                                                        
       0100-INITIALIZATION.                                             
A05136     OPEN INPUT FCSCA675-FILE.                                    
T13214     OPEN OUTPUT FCSPT33-FILE.                                    
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
           IF END-OF-FILE                                               
              PERFORM 8100-WRITE-INIT-ERROR THRU 8100-EXIT              
T13214        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************                    
      **                                                                        
      **   PROCESS THE INPUT RECORDS. INSPECT AND REPLACE                       
      **   VARIABLES FROM SAS FORMAT. LOAD HOURLY DATA. READ                    
      **   THE INPUT FILE UNTIL EOF.                                            
      **                                                                        
      ******************************************************                    
      *                                                                         
       1000-PROCESS-RECS.                                               
      *                                                                         
A05136     IF END-OF-FILE                                               
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        MOVE RTPCBL-ACCOUNT TO WS-HOLD-ACCT                       
A05136        MOVE RTPCBL-ACCOUNT TO WS-TEMP-ACCT-NO                    
              MOVE WS-TEMP-ACCT-NO TO WS-ACCT-NO                        
              PERFORM 7100-ACCT-XREF-IC  THRU 7100-EXIT                 
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              IF WS-ACTIVE-RETURN-CODE = 100                            
                 PERFORM 7200-NEW-XREF-ACCT THRU 7200-EXIT              
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
                 IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL         
                    PERFORM 8200-WRITE-NEW-ACCT-ERROR THRU 8200-EXIT    
T13214              ADD 1 TO WS-RECORD-COUNT                            
T13214              PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT         
A05136                     UNTIL RTPCBL-ACCOUNT NOT = WS-HOLD-ACCT      
C26776                           OR END-OF-FILE                         
T13214              GO TO  1000-PROCESS-RECS                            
                 END-IF                                                 
                 MOVE XR-NEW-ACCOUNT-NO TO WS-NEW-ACCOUNT-NO            
                 MOVE WS-NEW-ACCOUNT-NO TO WS-TEMP-ACCT-NO              
                 MOVE WS-TEMP-ACCT-NO TO WS-ACCT-NO                     
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = 0                           
                    MOVE AT-ACCOUNT-NO TO WS-NEW-ACCOUNT-NO             
                    MOVE WS-NEW-ACCOUNT-NO TO WS-TEMP-ACCT-NO           
                    MOVE WS-TEMP-ACCT-NO TO WS-ACCT-NO                  
                 ELSE                                                   
                   PERFORM 8000-WRITE-ERROR THRU 8000-EXIT              
                   PERFORM 9900-ABEND     THRU 9900-EXIT                
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7500-ACCT-IC-NO THRU 7500-EXIT                    
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL            
                 PERFORM 8300-WRITE-IC-ERROR THRU 8300-EXIT             
T13214           ADD 1 TO WS-RECORD-COUNT                               
T13214           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT            
A05136                  UNTIL RTPCBL-ACCOUNT NOT = WS-HOLD-ACCT         
C26776                      OR END-OF-FILE                              
T13214           GO TO  1000-PROCESS-RECS                               
              END-IF                                                    
              MOVE UT-IC-NO TO CD-IC-NO                                 
      *                                                                         
A05136        IF RTPCBL-ACCOUNT = WS-HOLD-ACCT                          
A05136           CONTINUE                                               
              ELSE                                                      
                PERFORM 2000-END-OF-ACCT-RECS THRU 2000-EXIT            
              END-IF                                                    
      *                                                                         
A05136        INSPECT RTPCBL-MONTH    REPLACING ALL ' ' BY '0'          
A05136        INSPECT RTPCBL-DAY      REPLACING ALL ' ' BY '0'          
A05136        INSPECT RTPCBL-YEAR     REPLACING ALL ' ' BY '0'          
              INSPECT RTPCBL-KW-TABLE REPLACING ALL ' ' BY '0'          
      *                                                                         
              MOVE ZERO TO WS-HOUR-COUNT                                
              PERFORM 1100-LOAD-INSERT-USAGE THRU 1100-EXIT             
                   UNTIL WS-HOUR-COUNT = 24                             
              ADD 1 TO WS-RECORD-COUNT                                  
              PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT               
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************                    
      **                                                                        
      **   LOAD HOURLY DATA.ENTER THE CORRECT CENTURY CODE.                     
      **   GET THE CORRECT IC NUMBER.                                           
      **                                                                        
      ******************************************************                    
                                                                        
       1100-LOAD-INSERT-USAGE.                                          
           MOVE WS-ACCT-NO      TO CD-ACCOUNT-NO                        
           MOVE WS-HOUR-COUNT   TO WS-START-HH                          
           MOVE WS-INTRVAL-START-TIME                                   
                                TO CD-INTRVAL-START-TIME                
                                                                        
           ADD 1                TO WS-HOUR-COUNT.                       
           MOVE WS-HOUR-COUNT TO WS-END-TIME-HH                         
           MOVE WS-INTERVAL-END-TIME TO CD-INTERVAL-END-TIME            
                                                                        
ACT122     IF CD-INTERVAL-END-TIME = '24.00.00'                         
ACT122        MOVE '00.00.00' TO CD-INTERVAL-END-TIME                   
ACT122     END-IF                                                       
                                                                        
A05136     MOVE RTPCBL-MONTH        TO WS-TEMP-MM.                      
A05136     MOVE RTPCBL-DAY          TO WS-TEMP-DD.                      
A05136     MOVE RTPCBL-YEAR         TO WS-TEMP-CCYY.                    
      *                                                                         
           MOVE WS-TEMP-DATE    TO CD-BASELINE-EFFCT-DT                 
           MOVE RTPCBL-KW (WS-HOUR-COUNT) TO CD-BASELINE-KWH            
           MOVE 'E'             TO CD-CODE-UTIL-TYPE                    
           PERFORM 8500-INSERT-RECORD THRU 8500-EXIT                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
T13214       IF WS-ACTIVE-RETURN-CODE = DUPLICATE-ROW                   
T13214           PERFORM 8510-UPDATE-RECORD THRU 8510-EXIT              
T13214           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
T13214           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL         
T13214             PERFORM 8560-WRITE-UPDATE-ERROR THRU 8560-EXIT       
T13214             PERFORM 9900-ABEND THRU 9900-EXIT                    
T13214           END-IF                                                 
T13214        ELSE                                                      
                 PERFORM 8550-WRITE-INSERT-ERROR THRU 8550-EXIT         
T13214           PERFORM 9900-ABEND THRU 9900-EXIT                      
T13214       END-IF                                                     
           END-IF.                                                      
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-END-OF-ACCT-RECS.                                           
           IF NOT (WS-RECORD-COUNT > 364)                               
              MOVE WS-HOLD-ACCT TO WS-ERROR-ACCT                        
              MOVE WS-RECORD-COUNT TO WS-REC-NO                         
              PERFORM 8000-WRITE-ERROR THRU 8000-EXIT                   
           END-IF                                                       
A05136     MOVE RTPCBL-ACCOUNT TO WS-HOLD-ACCT                          
A05136     MOVE RTPCBL-ACCOUNT TO WS-TEMP-ACCT-NO                       
           MOVE WS-TEMP-ACCT-NO TO WS-ACCT-NO                           
           MOVE 0 TO WS-RECORD-COUNT.                                   
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************                    
      **                                                                        
      **    READ THE INPUT FILE.                                                
      **                                                                        
      ******************************************************                    
                                                                        
       7000-READ-INPUT-FILE.                                            
A05136      READ FCSCA675-FILE                                          
                AT END MOVE 'YES' TO WS-END-OF-FILE-SWITCH.             
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************                    
      **                                                                        
      **   CHECK WHETHER THE ACCOUNT EXISTS IN THE ACCOUNT                      
      **   TABLE, IF NOT GET THE NEW ACCOUNT NUMBER AND                         
      **   GET THE IC NUMBER FOR THAT ACCOUNT.                                  
      **                                                                        
      ******************************************************                    
                                                                        
       7100-ACCT-XREF-IC.                                               
           EXEC SQL                                                     
               SELECT ACCOUNT_NO INTO :AT-ACCOUNT-NO                    
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO = :WS-ACCT-NO                           
A03204                                                           
A03204                                                      
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO INTO :AT-ACCOUNT-NO                            
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCT-NO                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-NEW-XREF-ACCT.                                              
PCR376     EXEC SQL                                                     
PCR376        SELECT XR.NEW_ACCOUNT_NO                                  
PCR376          INTO :XR-NEW-ACCOUNT-NO                                 
PCR376          FROM CSS_XREF_ACCT      XR WITH(READUNCOMMITTED),               
PCR376               CSS_ACCOUNT        AT WITH(READUNCOMMITTED),               
PCR376               CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
PCR376          WHERE XR.OLD_ACCOUNT_NO = :WS-ACCT-NO                   
PCR376            AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                 
PCR376            AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                 
PCR376            AND AT.PREMISE_NO     = CH.PREMISE_NO                 
PCR376            AND CH.DATE_UTIL_SVC_STRT =                           
PCR376                (SELECT MAX(DATE_UTIL_SVC_STRT)                   
PCR376                   FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)          
PCR376                  WHERE PREMISE_NO = AT.PREMISE_NO)               
A03204                                                           
A03204                                                      
PCR376     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XR.NEW_ACCOUNT_NO                                          
MFA-TR*         INTO :XR-NEW-ACCOUNT-NO                                         
MFA-TR*         FROM CSS_XREF_ACCT      XR,                                     
MFA-TR*              CSS_ACCOUNT        AT,                                     
MFA-TR*              CSS_CUST_PREM_HIST CH                                      
MFA-TR*         WHERE XR.OLD_ACCOUNT_NO = :WS-ACCT-NO                           
MFA-TR*           AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                         
MFA-TR*           AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                         
MFA-TR*           AND AT.PREMISE_NO     = CH.PREMISE_NO                         
MFA-TR*           AND CH.DATE_UTIL_SVC_STRT =                                   
MFA-TR*               (SELECT MAX(DATE_UTIL_SVC_STRT)                           
MFA-TR*                  FROM CSS_CUST_PREM_HIST                                
MFA-TR*                 WHERE PREMISE_NO = AT.PREMISE_NO)                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7200                                                  
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-ACCT-IC-NO.                                                 
           EXEC SQL                                                     
                SELECT IC_NO INTO :UT-IC-NO                             
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :WS-NEW-ACCOUNT-NO                   
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND (RATE_PLAN_NO = '027'                            
                        OR RATE_PLAN_NO = 'A27'                         
                        OR RATE_PLAN_NO = '060'                         
T26776                  OR RATE_PLAN_NO = '27L'                         
T26776                  OR RATE_PLAN_NO = '27M'                         
BG0202                  OR RATE_PLAN_NO = 'B27'                         
BG0202                  OR RATE_PLAN_NO = '60S'                         
T26776                  OR RATE_PLAN_NO = '60K'                         
A03204                  OR RATE_PLAN_NO = '60M'                         
A05136                  OR RATE_PLAN_NO = '23S'                         
A05136                  OR RATE_PLAN_NO = '23R'                         
A05136                  OR RATE_PLAN_NO = '023'                         
T27897                  OR RATE_PLAN_NO = 'F27')                        
A03204                                                           
A03204                                                      
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IC_NO INTO :UT-IC-NO                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO = :WS-NEW-ACCOUNT-NO                           
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND (RATE_PLAN_NO = '027'                                    
MFA-TR*                 OR RATE_PLAN_NO = 'A27'                                 
MFA-TR*                 OR RATE_PLAN_NO = '060'                                 
MFA-TR*                 OR RATE_PLAN_NO = '27L'                                 
MFA-TR*                 OR RATE_PLAN_NO = '27M'                                 
MFA-TR*                 OR RATE_PLAN_NO = 'B27'                                 
MFA-TR*                 OR RATE_PLAN_NO = '60S'                                 
MFA-TR*                 OR RATE_PLAN_NO = '60K'                                 
MFA-TR*                 OR RATE_PLAN_NO = '60M'                                 
MFA-TR*                 OR RATE_PLAN_NO = '23S'                                 
MFA-TR*                 OR RATE_PLAN_NO = '23R'                                 
MFA-TR*                 OR RATE_PLAN_NO = '023'                                 
MFA-TR*                 OR RATE_PLAN_NO = 'F27')                                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7500                                                  
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************                     
      **                                                                        
      **   DISPLAY ERROR ROUTINE.                                               
      **                                                                        
      *****************************************************                     
                                                                        
       8000-WRITE-ERROR.                                                
           DISPLAY 'ERROR PROCESSING ACCOUNT NUMBER IN PCSCA675'        
           DISPLAY '*** ERROR AT RECORD NUMBER =' WS-REC-NO             
           DISPLAY '*** ACCOUNT NUMBER =' WS-ERROR-ACCT.                
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-WRITE-INIT-ERROR.                                           
           DISPLAY '*** 0100 ***'                                       
           DISPLAY '*** ERROR IN READING INPUT FILE ***'                
           DISPLAY '*** NO RECORDS FOUND ***'.                          
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-WRITE-NEW-ACCT-ERROR.                                       
T13214     MOVE '7200'                         TO P-PARA.               
T13214     MOVE '*** ERROR IN ACCOUNT NUMBER ' TO P-ERROR-DESC.         
A05136     MOVE RTPCBL-ACCOUNT                 TO P-ACCOUNT-NO.         
T13214     MOVE ZEROES                         TO P-IC-NO.              
T13214     MOVE WS-ACTIVE-RETURN-CODE          TO P-SQL-CODE.           
T13214     PERFORM 8400-PRINT-REPORT           THRU 8400-EXIT.          
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-WRITE-IC-ERROR.                                             
T13214     MOVE '7500'                         TO P-PARA.               
T13214     MOVE '*** ERROR IN IC NO ***'       TO P-ERROR-DESC.         
T13214     MOVE WS-NEW-ACCOUNT-NO              TO P-ACCOUNT-NO.         
T13214     MOVE UT-IC-NO                       TO P-IC-NO.              
T13214     MOVE WS-ACTIVE-RETURN-CODE          TO P-SQL-CODE.           
T13214     PERFORM 8400-PRINT-REPORT           THRU 8400-EXIT.          
       8300-EXIT.                                                       
           EXIT.                                                        
T13214****************************************************************          
T13214**   8400-PRINT-REPORT                                        **          
T13214**       PRINTS THE LINES FOR THE REPORT PCSCA675             **          
T13214****************************************************************          
T13214*                                                                         
T13214 8400-PRINT-REPORT.                                               
T13214*                                                                         
T13214     MOVE '8400' TO WS-ACTIVE-PARAGRAPH.                          
T13214                                                                  
T13214     IF WS-RPT1-LINE-NO > 52                                      
T13214         PERFORM 8410-PRINT-TITLE  THRU 8410-EXIT                 
T13214     END-IF.                                                      
T13214*                                                                         
T13214     PERFORM 8430-PRINT-DETAIL-LINE    THRU 8430-EXIT.            
T13214*                                                                         
T13214 8400-EXIT.                                                       
T13214     EXIT.                                                        
T13214****************************************************************          
T13214**   8410-PRINT-TITLE                                         **          
T13214**       PRINTS THE TITLE FOR THE REPORT PCSRP101             **          
T13214****************************************************************          
T13214*                                                                         
T13214 8410-PRINT-TITLE.                                                
T13214*                                                                         
T13214     MOVE '8410' TO WS-ACTIVE-PARAGRAPH.                          
T13214                                                                  
T13214     ADD 1                       TO WS-RPT1-PAGE-NO.              
T13214     MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
T13214*                                                                         
T13214     WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
T13214          AFTER ADVANCING PAGE.                                   
T13214                                                                  
T13214     MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
T13214     WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
T13214          AFTER ADVANCING 1 LINE.                                 
T13214*                                                                         
T13214     MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
T13214     WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
T13214          AFTER ADVANCING 1 LINE.                                 
T13214*                                                                         
T13214     MOVE 3                      TO WS-RPT1-LINE-NO.              
T13214     PERFORM 8420-PRINT-HEADERS  THRU 8420-EXIT.                  
T13214*                                                                         
T13214 8410-EXIT.                                                       
T13214     EXIT.                                                        
T13214****************************************************************          
T13214**   8300-PRINT-HEADERS                                       **          
T13214**       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
T13214****************************************************************          
T13214*                                                                         
T13214 8420-PRINT-HEADERS.                                              
T13214*                                                                         
T13214     MOVE '8420' TO WS-ACTIVE-PARAGRAPH.                          
T13214*                                                                         
T13214     WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-1              
T13214          AFTER ADVANCING 3 LINES.                                
T13214     WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
T13214          AFTER ADVANCING 1 LINE.                                 
T13214*                                                                         
T13214     ADD 5                       TO WS-RPT1-LINE-NO.              
T13214*                                                                         
T13214 8420-EXIT.                                                       
T13214     EXIT.                                                        
T13214*                                                                         
T13214****************************************************************          
T13214**   8430-PRINT-DETAIL-LINE                                   **          
T13214**       PRINTS THE DETAIL LINE OF THE REPORT PCSRP101        **          
T13214****************************************************************          
T13214*                                                                         
T13214 8430-PRINT-DETAIL-LINE.                                          
T13214*                                                                         
T13214     MOVE '8430' TO WS-ACTIVE-PARAGRAPH.                          
A05136     MOVE WS-YES TO WS-ERROR-IN-RUN.                              
T13214*                                                                         
T13214     WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-1                
T13214          AFTER ADVANCING 1 LINE.                                 
T13214*                                                                         
T13214     ADD 1                       TO WS-RPT1-LINE-NO.              
T13214*                                                                         
T13214 8430-EXIT.                                                       
T13214     EXIT.                                                        
T13214*                                                                         
      ******************************************************                    
      **                                                                        
      **   INSERT THE CBL DATA INTO THE CSS_CBL_USAGE TABLE.                    
      **                                                                        
      ******************************************************                    
                                                                        
       8500-INSERT-RECORD.                                              
           EXEC SQL                                                     
              INSERT INTO CSS_CBL_USAGE                                 
                  (ACCOUNT_NO,                                          
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   BASELINE_EFFCT_DT,                                   
                   INTRVAL_START_TIME,                                  
                   INTERVAL_END_TIME,                                   
                   BASELINE_KWH)                                        
              VALUES                                                    
                  (:CD-ACCOUNT-NO,                                      
                   :CD-CODE-UTIL-TYPE,                                  
                   :CD-IC-NO,                                           
                   IIF(TRY_CONVERT(DATE, :CD-BASELINE-EFFCT-DT
              ) IS NULL OR (PATINDEX('%.%', :CD-BASELINE-EFFCT-DT
              ) <> 0) OR (LEN(:CD-BASELINE-EFFCT-DT
              ) <> 10), CIS.CHAR2DATE(:CD-BASELINE-EFFCT-DT
              ), CONVERT(DATE, :CD-BASELINE-EFFCT-DT) ),                       
                   CIS.CHAR2TIME(:CD-INTRVAL-START-TIME),                       
                   CIS.CHAR2TIME(:CD-INTERVAL-END-TIME),                        
                   :CD-BASELINE-KWH)                                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CBL_USAGE                                         
MFA-TR*           (ACCOUNT_NO,                                                  
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            BASELINE_EFFCT_DT,                                           
MFA-TR*            INTRVAL_START_TIME,                                          
MFA-TR*            INTERVAL_END_TIME,                                           
MFA-TR*            BASELINE_KWH)                                                
MFA-TR*       VALUES                                                            
MFA-TR*           (:CD-ACCOUNT-NO,                                              
MFA-TR*            :CD-CODE-UTIL-TYPE,                                          
MFA-TR*            :CD-IC-NO,                                                   
MFA-TR*            :CD-BASELINE-EFFCT-DT,                                       
MFA-TR*            :CD-INTRVAL-START-TIME,                                      
MFA-TR*            :CD-INTERVAL-END-TIME,                                       
MFA-TR*            :CD-BASELINE-KWH)                                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
T13214 8510-UPDATE-RECORD.                                              
T13214     EXEC SQL                                                     
T13214        UPDATE CSS_CBL_USAGE                                      
T13214         SET INTERVAL_END_TIME = CIS.CHAR2TIME(
                                                  :CD-INTERVAL-END-TIME
              ),           
T13214             BASELINE_KWH = :CD-BASELINE-KWH                      
T13214         WHERE  ACCOUNT_NO = :CD-ACCOUNT-NO AND                   
T13214             CODE_UTIL_TYPE = :CD-CODE-UTIL-TYPE AND              
T13214             IC_NO = :CD-IC-NO AND                                
T13214             BASELINE_EFFCT_DT = IIF(TRY_CONVERT(DATE, 
                                                  :CD-BASELINE-EFFCT-DT
              ) IS NULL OR (PATINDEX('%.%', :CD-BASELINE-EFFCT-DT
              ) <> 0) OR (LEN(:CD-BASELINE-EFFCT-DT
              ) <> 10), CIS.CHAR2DATE(:CD-BASELINE-EFFCT-DT
              ), CONVERT(DATE, :CD-BASELINE-EFFCT-DT) ) AND        
T13214             INTRVAL_START_TIME = CIS.CHAR2TIME(
                                                 :CD-INTRVAL-START-TIME
              )          
T13214     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CBL_USAGE                                              
MFA-TR*        SET INTERVAL_END_TIME = :CD-INTERVAL-END-TIME,                   
MFA-TR*            BASELINE_KWH = :CD-BASELINE-KWH                              
MFA-TR*        WHERE  ACCOUNT_NO = :CD-ACCOUNT-NO AND                           
MFA-TR*            CODE_UTIL_TYPE = :CD-CODE-UTIL-TYPE AND                      
MFA-TR*            IC_NO = :CD-IC-NO AND                                        
MFA-TR*            BASELINE_EFFCT_DT = :CD-BASELINE-EFFCT-DT AND                
MFA-TR*            INTRVAL_START_TIME = :CD-INTRVAL-START-TIME                  
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
T13214 8510-EXIT.                                                       
T13214     EXIT.                                                        
      *                                                                         
       8550-WRITE-INSERT-ERROR.                                         
           DISPLAY '8500'                                               
           DISPLAY '**** INSERT FAILED ****'                            
           DISPLAY '*** SQLCODE IS ' WS-ACTIVE-RETURN-CODE              
           DISPLAY '*** ERROR IN ACCOUNT NO ' CD-ACCOUNT-NO             
           DISPLAY '*** UTILITY TYPE ' CD-CODE-UTIL-TYPE                
           DISPLAY '*** IC NO ' CD-IC-NO                                
           DISPLAY '*** EFFECT DATE ' CD-BASELINE-EFFCT-DT              
           DISPLAY '*** START TIME ' CD-INTRVAL-START-TIME              
           DISPLAY '*** END TIME ' CD-INTERVAL-END-TIME                 
           DISPLAY '*** BASELINE KWH ' CD-BASELINE-KWH.                 
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8560-WRITE-UPDATE-ERROR.                                         
           DISPLAY '8510'                                               
           DISPLAY '**** UPDATE FAILED ****'                            
           DISPLAY '*** SQLCODE IS ' WS-ACTIVE-RETURN-CODE              
           DISPLAY '*** ERROR IN ACCOUNT NO ' CD-ACCOUNT-NO             
           DISPLAY '*** UTILITY TYPE ' CD-CODE-UTIL-TYPE                
           DISPLAY '*** IC NO ' CD-IC-NO                                
           DISPLAY '*** EFFECT DATE ' CD-BASELINE-EFFCT-DT              
           DISPLAY '*** START TIME ' CD-INTRVAL-START-TIME              
           DISPLAY '*** END TIME ' CD-INTERVAL-END-TIME                 
           DISPLAY '*** BASELINE KWH ' CD-BASELINE-KWH.                 
       8560-EXIT.                                                       
           EXIT.                                                        
      *****************************************************                     
      **                                                                        
      **   CLOSE THE INPUT FILE. STOP EXECUTION.                                
      **                                                                        
      *****************************************************                     
                                                                        
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY '*** PROCESSING TERMINATE ***'                       
      *                                                                         
T13214     IF ERROR-FOUND                                               
T13214        WRITE PRT33-RECORD FROM WS-END-DATA-LINE                  
T13214          AFTER ADVANCING 1 LINE                                  
T13214         MOVE 05  TO  RETURN-CODE                                 
T13214     ELSE                                                         
A05136        PERFORM 8410-PRINT-TITLE  THRU 8410-EXIT                  
T13214        WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                   
T13214          AFTER ADVANCING 1 LINE                                  
A05136        WRITE PRT33-RECORD FROM WS-END-DATA-LINE                  
A05136          AFTER ADVANCING 1 LINE                                  
T13214     END-IF.                                                      
           CLOSE FCSCA675-FILE.                                         
T13214     CLOSE FCSPT33-FILE.                                          
      *    STOP RUN.                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
T13214*                                                                         
T13214****************************************************************          
T13214**                                                            **          
T13214**   9900-ABEND                                               **          
T13214**                                                            **          
T13214****************************************************************          
T13214*                                                                         
T13214     EXEC SQL                                                             
T13214         INCLUDE CPD09900                                                 
T13214     END-EXEC.                                                            
T13214*                                                                         
T13214****************************************************************          
