       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA669.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  JULY 2015.                                        
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                         DB2                                **          
      ****************************************************************          
      *  COMMENTS: CONVERTS THE NEW METER FILE FROM THE MANUFACTURER *          
      *            TESTS INTO A FILE - READ INTO PCSMT605/PCSMT627.  *          
      *            ANY ERRORS WILL BE WRITTEN TO THE REPORTS.        *          
      *            THERE ARE 2 SORT STEPS PRIOR TO THIS PROGRAM.     *          
      *            THE FIRST SORT TAKES A REALLY MESSED UP DATA SET  *          
      *            AND REFORMATS IT INTO A FIXED BLOCK, USABLE FILE. *          
      *            THE SECOND SORT GETS RID OF EXTRA HEADERS         *          
      *            AND 'END' RECORD                                  *          
      *                                                              *          
      *  FILES:   NEWMTR    - NEW INPUT METER FILE                   *          
      *           FIOCA669  - NEW OUTPUT METER FILE                  *          
      *           SYSIN     - SYSTEM DATE CARD                       *          
      *           PRINTER1  - PRINTER                                *          
      *                                                              *          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  20 JUL 2015 RF10596      REWRITE GMC005 (EZTRIEVE) INTO   **          
      **                           A COBOL PROGRAM.                 **          
      **                                                            **          
A05136**   7 OCT 2015 RF10596      ALLOW FOR SPACES IN ATTACHMENT   **          
      **                           WHEN NO ATTACHMENT MOVE SPACES   **          
      **                           TO THE OUTPUT FIELD              **          
      **                                                            **          
A05136**  13 OCT 2015 RF10596      ALLOW FOR SPACES IN ATTACHMENT   **          
      **                                                            **          
A05136**  12 NOV 2015 RF10596      REFURBISH HAS ' 2' IN BEGINNING  **          
      **                           OF ATTACHMENT. CLEAR THIS.       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA669.                                                           
      *                                                                         
           SELECT NEWMTR-FILE                                           
               ASSIGN UT-S-NEWMTR                                       
               FILE STATUS IS WS-NEWMTR-STATUS.                         
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA669.                                                           
       COPY FIOCA669.                                                           
      *                                                                         
       FD  NEWMTR-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01  NEWMTR-RECORD.                                               
           05 E-NEWMTR-MFG-SERIAL      PIC X(11).                       
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-MTR-NO          PIC X(9).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-MTR-TYPE        PIC X(8).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-FAC-CODE        PIC X(3).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-PURCH-DATE      PIC X(10).                       
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-OPEN-TEST       PIC X(5).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-OPEN-DATE       PIC X(10).                       
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-OPEN-TIME       PIC X(8).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-CHECK           PIC X(5).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-CHECK-DATE      PIC X(10).                       
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-CHECK-TIME      PIC X(8).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-ATTACH-NO       PIC X(12).                       
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-ATTACH-TYPE     PIC XX.                          
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-WARNTY-PERIOD   PIC XX.                          
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-MFG-CODE        PIC XX.                          
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-ATTACH-CODE     PIC X.                           
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-VER-CODE        PIC X(3).                        
           05 FILLER                   PIC X.                           
           05 E-NEWMTR-TEST-CODE       PIC X.                           
      *                                                                         
       FD  PRINTER1                                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  PRT-REPORT.                                                  
           02  PRT-REPORT-CNTL         PIC X.                           
           02  PRT-REPORT-LINE         PIC X(132).                      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA669'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           03  WS-PRINT-FIELDS.                                         
               05  WS-PAGE-COUNT       PIC S9(3) VALUE +1  COMP-3.      
               05  WS-LINE-COUNT       PIC S9(3) VALUE +99 COMP-3.      
               05  WS-INPUT-REC-COUNT  PIC S9(6) VALUE +0  COMP-3.      
               05  WS-COUNTER          PIC 9(4)  VALUE 0.               
      *                                                                         
       01  WS-FLAG.                                                     
           03  WS-NEWMTR-READ-STATUS PIC X VALUE SPACES.                
               88  NEWMTR-NO-REC           VALUE 'N'.                   
               88  NEWMTR-END              VALUE 'E'.                   
               88  NEWMTR-STARTED          VALUE 'S'.                   
      *                                                                         
       01  WS-OPEN-TIME.                                                
           03  WS-OPEN-TIME1           PIC X.                           
           03  WS-OPEN-REST            PIC X(7).                        
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
A05136     03  WS-REFUR                PIC XX    VALUE ' 2'.            
A05136     03  WS-12                   PIC XX    VALUE '12'.            
           03  WS-ERROR-MSG            PIC X(40) VALUE SPACES.          
           03  WS-PURC-DATE            PIC X(10) VALUE SPACES.          
           03  WS-OPEN-DATE            PIC X(10) VALUE SPACES.          
           03  WS-CHCK-DATE            PIC X(10) VALUE SPACES.          
           03  WS-DATE1                PIC X(10) VALUE SPACES.          
           03  WS-DATE2                PIC X(10) VALUE SPACES.          
           03  WS-DATE3                PIC X(10) VALUE SPACES.          
           03  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           03  WS-COMPANY-NO           PIC XX    VALUE SPACES.          
           03  WS-COMPANY-NAME         PIC X(26) VALUE SPACES.          
           03  WS-ERROR-SW             PIC X     VALUE 'N'.             
           03  WS-CODE-UTIL-TYPE       PIC X     VALUE 'G'.             
           03  WS-Y                    PIC X     VALUE 'Y'.             
           03  WS-N                    PIC X     VALUE 'N'.             
           03  WS-K                    PIC X     VALUE 'K'.             
           03  WS-NEWMTR-STATUS        PIC XX    VALUE SPACES.          
           03  WS-FCA669-STATUS        PIC XX    VALUE SPACES.          
           03  WS-METER-NO             PIC X(9)  VALUE SPACES.          
           03  WS-MFG-SERIAL           PIC X(11) VALUE SPACES.          
           03  WS-COMPARE-ATT          PIC X(12) VALUE '000200000000'.  
           03  WS-ATTACH-TYPE          PIC XX    VALUE SPACES.          
           03  WS-MTR-TYPE             PIC X(8)  VALUE SPACES.          
           03  WS-CHECK-PROOF          PIC X(5)  VALUE SPACES.          
           03  WS-CHECK                PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-CHECK-OPEN           PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-CHECK-CHECK          PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-LOW                  PIC S999V99 COMP-3 VALUE 99.50.  
           03  WS-HIGH                 PIC S999V99 COMP-3 VALUE 100.50. 
A05136     03  WS-ATTACHMENT-ALL       PIC X(12) VALUE SPACES.          
      *                                                                         
A05136 01  WS-ATTACHMENT.                                               
A05136     03  WS-ATTACH-FIRST-TWO     PIC XX    VALUE SPACES.          
A05136     03  WS-ATTACHMENT-12        PIC XX    VALUE SPACES.          
A05136     03  WS-ATTACHMENT-X         PIC X(8)  VALUE SPACES.          
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
           03  WS-MTR-MSG              PIC X(40)                        
                  VALUE 'NO METER NUMBER ON THE INPUT FILE       '.     
           03  WS-SER-MSG              PIC X(40)                        
                  VALUE 'NO MFG SERIAL NUMBER ON THE INPUT FILE  '.     
A05136     03  WS-ATT-MSG              PIC X(40)                        
                  VALUE 'INVALID ATTACHMENT NUMBER ON INPUT FILE '.     
           03  WS-MTR-EXIST            PIC X(40)                        
                  VALUE 'METER NUMBER ALREADY ON THE SYSTEM      '.     
           03  WS-ATT-EXIST            PIC X(40)                        
                  VALUE 'ATTACHMENT NBR ALREADY ON THE SYSTEM    '.     
           03  WS-INV-TYPE             PIC X(40)                        
                  VALUE 'INVALID METER SIZE ID                   '.     
           03  WS-INV-PROOF            PIC X(40)                        
                  VALUE 'EITHER OPEN TEST OR CHECK OUT OF RANGE  '.     
           03  WS-DATE-ERROR           PIC X(40)                        
                  VALUE 'ONE OF INPUT DATES IN ERROR             '.     
      *                                                                         
       01  WS-REPORT-PAGE-CONTROLS.                                     
           03  WS-PRT-REPORT-LINE-SPACE      PIC 9.                     
           03  WS-PRT-REPORT-LINE-COUNT      PIC 99 VALUE 0.            
               88  REPORT-PAGE-OVERFLOW         VALUE 57 THRU 99.       
               88  REPORT-NEW-PAGE              VALUE 0.                
               88  REPORT-FIRST-LINE            VALUE 1.                
      *                                                                         
      ****************************************************************          
      * REPORT HEADER RECORDS                                        *          
      ****************************************************************          
      *                                                                         
       01  PRT-REPORT-HEADER1.                                          
           03  FILLER                  PIC X(8)  VALUE 'PCSCA669'.      
           03  FILLER                  PIC X(38) VALUE SPACES.          
           03  PRT-HDR-SCEG            PIC X(26).                       
           03  PRT-HDR-PSNC REDEFINES PRT-HDR-SCEG.                     
               05  FILLER              PIC X(5).                        
               05  PRT-HDR-PSNC2       PIC X(11).                       
               05  FILLER              PIC X(10).                       
           03  FILLER                  PIC X(41) VALUE SPACES.          
           03  PRT-HDR-DATE            PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER2.                                          
           03  FILLER                  PIC X(51) VALUE SPACES.          
           03  FILLER                  PIC X(30) VALUE                  
           'GAS METER PROVER ERROR RECORDS'.                            
           03  FILLER                  PIC X(25) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'PAGE : '.       
           03  PRT-HDR-PAGE            PIC Z,ZZ9.                       
           03  FILLER                  PIC X(14) VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER3.                                          
           03  FILLER                  PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE 'TEST DATE'.     
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE 'METER NBR'.     
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(10) VALUE 'SERIAL NBR'.    
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(8)  VALUE 'MTR TYPE'.      
           03  FILLER                  PIC X(8)  VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'ERROR MESSAGE'. 
           03  FILLER                  PIC X(57) VALUE SPACES.          
      *                                                                         
       01  PRT-ERROR-LINE.                                              
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  PRT-DATE                PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-METER               PIC X(9)  VALUE SPACES.          
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-SERIAL              PIC X(11) VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-WORK-TYPE           PIC X(8)  VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE SPACES.          
           03  PRT-ERROR-MSG           PIC X(40) VALUE SPACES.          
           03  FILLER                  PIC X(30) VALUE SPACES.          
      *                                                                         
       01  PRT-END-LINE.                                                
           03  FILLER                 PIC X(13) VALUE 'END OF REPORT'.  
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT - EQ                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GAS_METER_SIZE - M5                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIP_ATTCHMTS - LX                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQATTH                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_COMPANY  -  C7                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           05 WS-PARMVAL-LENGTH             PIC S9(4) COMP.             
           05 WS-PARM-COMPANY-NO            PIC XX.                     
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                   UNTIL NEWMTR-END.                                    
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPEN INPUT AND OUTPUT FILES.  GET CURRENT DATE               *          
      * GET COMPANY NAME USING COMPANY-NO FROM SYSIN LINKAGE.        *          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE THRU 7000-EXIT.                
      *                                                                         
           MOVE WS-CURRENT-DATE TO PRT-HDR-DATE.                        
      *                                                                         
           MOVE SPACES TO PRT-HDR-SCEG.                                 
           MOVE WS-PARM-COMPANY-NO TO WS-COMPANY-NO.                    
           PERFORM 7225-SELECT-COMPANY-NAME THRU 7225-EXIT.             
           IF WS-PARM-COMPANY-NO = '01'                                 
              MOVE WS-COMPANY-NAME TO PRT-HDR-SCEG                      
           ELSE                                                         
              MOVE WS-COMPANY-NAME TO PRT-HDR-PSNC2                     
           END-IF.                                                      
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS OPENS ALL INPUT AND OUTPUT FILES.               *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT NEWMTR-FILE.                                      
           OPEN OUTPUT FCSCA669-FILE                                    
                       PRINTER1.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * MAIN PROCESS                                                 *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           MOVE WS-N TO WS-ERROR-SW.                                    
           MOVE SPACES TO PRT-ERROR-LINE                                
                          WS-MFG-SERIAL                                 
                          WS-ATTACHMENT                                 
                          WS-METER-NO                                   
                          WS-ERROR-MSG                                  
                          WS-ATTACH-TYPE                                
                          WS-MTR-TYPE                                   
                          WS-PURC-DATE                                  
                          WS-OPEN-DATE                                  
                          WS-CHCK-DATE                                  
                          WS-DATE1                                      
                          WS-DATE2                                      
                          WS-DATE3                                      
                          WS-OPEN-TIME.                                 
           MOVE ZEROS  TO WS-CHECK-OPEN                                 
                          WS-CHECK-CHECK.                               
      *                                                                         
           MOVE E-NEWMTR-ATTACH-TYPE TO WS-ATTACH-TYPE.                 
           MOVE E-NEWMTR-MTR-TYPE    TO WS-MTR-TYPE.                    
           MOVE E-NEWMTR-MTR-NO      TO WS-METER-NO.                    
           MOVE E-NEWMTR-ATTACH-NO   TO WS-ATTACHMENT.                  
           MOVE E-NEWMTR-MFG-SERIAL  TO WS-MFG-SERIAL.                  
      *                                                                         
A05136     IF WS-ATTACHMENT-12 = WS-12 OR WS-REFUR                      
A05136        MOVE SPACES TO WS-ATTACHMENT-12                           
A05136     END-IF.                                                      
      *                                                                         
           INSPECT WS-ATTACHMENT REPLACING ALL SPACES BY ZEROES.        
           INSPECT WS-METER-NO   REPLACING ALL SPACES BY ZEROES.        
           INSPECT WS-MFG-SERIAL REPLACING ALL SPACES BY ZEROES.        
      *                                                                         
A05136     IF WS-ATTACHMENT = ZEROES                                    
A05136        MOVE SPACES TO WS-ATTACHMENT                              
A05136     END-IF.                                                      
A05136     MOVE WS-ATTACHMENT TO WS-ATTACHMENT-ALL.                     
      *                                                                         
           PERFORM 2110-CHECK-TEST-RANGE THRU 2110-EXIT.                
      *                                                                         
           MOVE E-NEWMTR-PURCH-DATE  TO WS-DATE1.                       
           MOVE E-NEWMTR-OPEN-DATE   TO WS-DATE2.                       
           MOVE E-NEWMTR-CHECK-DATE  TO WS-DATE3.                       
           PERFORM 7011-CONVERT-DATES THRU 7011-EXIT.                   
      *                                                                         
           MOVE E-NEWMTR-OPEN-TIME TO WS-OPEN-TIME.                     
           IF WS-OPEN-TIME1 = SPACES                                    
              MOVE '0' TO WS-OPEN-TIME1                                 
           END-IF.                                                      
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              NEXT SENTENCE                                             
           ELSE                                                         
A05136        IF WS-METER-NO = ZEROS                                    
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE SPACES TO WS-METER-NO                             
                 MOVE WS-MTR-MSG TO WS-ERROR-MSG                        
              ELSE                                                      
A05136           IF WS-MFG-SERIAL = ZEROS                               
                    MOVE WS-Y TO WS-ERROR-SW                            
                    MOVE SPACES TO WS-MFG-SERIAL                        
                    MOVE WS-SER-MSG TO WS-ERROR-MSG                     
                 ELSE                                                   
A05136              IF WS-ATTACHMENT > WS-COMPARE-ATT                   
                       MOVE WS-Y TO WS-ERROR-SW                         
                       MOVE SPACES TO WS-ATTACHMENT                     
                       MOVE WS-ATT-MSG TO WS-ERROR-MSG                  
                    ELSE                                                
A05136                 PERFORM 7100-SELECT-EQUIPMENT THRU 7100-EXIT     
A05136                 PERFORM 7150-SELECT-GAS-MTR-SIZE THRU 7150-EXIT  
A05136                 PERFORM 7200-SELECT-EQ-ATTCHMTS THRU 7200-EXIT   
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              PERFORM 2215-PRINT-ERROR-REPORT THRU 2215-EXIT            
              MOVE WS-N TO WS-ERROR-SW                                  
           ELSE                                                         
              PERFORM 2210-CREATE-OUTPUT-REC THRU 2210-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * VERIFY TEST RANGE NUMBER                                     *          
      ****************************************************************          
      *                                                                         
       2110-CHECK-TEST-RANGE.                                           
      *                                                                         
           MOVE E-NEWMTR-OPEN-TEST TO WS-CHECK-PROOF.                   
      *                                                                         
           COMPUTE WS-CHECK ROUNDED =                                   
            FUNCTION NUMVAL(WS-CHECK-PROOF).                            
      *                                                                         
           IF WS-CHECK < WS-LOW OR > WS-HIGH                            
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-INV-PROOF TO WS-ERROR-MSG                         
           END-IF.                                                      
           MOVE WS-CHECK           TO WS-CHECK-OPEN.                    
      *                                                                         
           MOVE E-NEWMTR-CHECK     TO WS-CHECK-PROOF.                   
      *                                                                         
           COMPUTE WS-CHECK ROUNDED =                                   
            FUNCTION NUMVAL(WS-CHECK-PROOF).                            
      *                                                                         
           IF WS-CHECK < WS-LOW OR > WS-HIGH                            
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-INV-PROOF TO WS-ERROR-MSG                         
           END-IF.                                                      
           MOVE WS-CHECK           TO WS-CHECK-CHECK.                   
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  INITIALIZE OUTPUT FIELDS. LOAD OUTPUT RECORD.               *          
      ****************************************************************          
      *                                                                         
       2210-CREATE-OUTPUT-REC.                                          
      *                                                                         
           INITIALIZE FIOCA669.                                         
      *                                                                         
           MOVE WS-METER-NO              TO E-CA669-METER-NO.           
           MOVE WS-OPEN-DATE             TO E-CA669-DATE-TEST.          
           MOVE WS-OPEN-TIME             TO E-CA669-TIME-TEST.          
           MOVE ZEROS                    TO E-CA669-CODE-TIME-PERIOD.   
           MOVE E-NEWMTR-FAC-CODE        TO E-CA669-MTR-FACILITY-CD.    
           MOVE 'A'                      TO E-CA669-CODE-CAP-TYPE.      
           MOVE 'N'                      TO E-CA669-CODE-REPAIR.        
           MOVE 'NO REP NEC'             TO E-CA669-REPAIR-DESC.        
           IF WS-COMPANY-NO = '01'                                      
              MOVE 'A' TO E-CA669-CODE-TEST-TYPE                        
           ELSE                                                         
              MOVE 'E' TO E-CA669-CODE-TEST-TYPE                        
           END-IF.                                                      
           MOVE 'O'                      TO E-CA669-CODE-TEST-LOC.      
           MOVE 'B'                      TO E-CA669-CODE-TEST-RESULT.   
           MOVE WS-CHECK-CHECK           TO E-CA669-IN-CHECK-RATE.      
           MOVE ZEROS                    TO E-CA669-IN-INTER-RATE.      
           MOVE WS-CHECK-OPEN            TO E-CA669-IN-OPEN-RATE.       
           MOVE ZEROS                    TO E-CA669-IN-READ.            
           MOVE WS-CHECK-CHECK           TO E-CA669-OUT-CHECK-RATE.     
           MOVE ZEROS                    TO E-CA669-OUT-INTER-RATE.     
           MOVE WS-CHECK-OPEN            TO E-CA669-OUT-OPEN-RATE.      
           MOVE ZEROS                    TO E-CA669-OUT-READ.           
           MOVE '99999'                  TO E-CA669-EQ-TESTER-ID.       
           MOVE '000003'                 TO E-CA669-TEST-PROVER-ID.     
           MOVE '02'                     TO E-CA669-PLACE.              
           MOVE WS-COMPANY-NO            TO E-CA669-COMPANY-NO.         
           MOVE WS-CODE-UTIL-TYPE        TO E-CA669-CODE-UTIL-TYPE.     
           MOVE WS-MFG-SERIAL            TO E-CA669-SERIAL-NO.          
           MOVE WS-PURC-DATE             TO E-CA669-PURCHASE-DATE.      
           MOVE WS-MTR-TYPE              TO E-CA669-METER-TYPE.         
           MOVE WS-ATTACHMENT            TO E-CA669-ATTACH-NO.          
           MOVE WS-ATTACH-TYPE           TO E-CA669-ATTACH-TYPE.        
           MOVE E-NEWMTR-WARNTY-PERIOD   TO E-CA669-ATTACH-WARRANTY.    
           MOVE E-NEWMTR-MFG-CODE        TO E-CA669-ATTACH-MAKE.        
           MOVE E-NEWMTR-ATTACH-CODE     TO E-CA669-ATTACH-CODE.        
           MOVE E-NEWMTR-VER-CODE        TO E-CA669-ATTACH-VERSION.     
           MOVE E-NEWMTR-TEST-CODE       TO E-CA669-ATTACH-TEST-CD.     
      *                                                                         
           PERFORM 3600-WRITE-FIOCA669 THRU 3600-EXIT.                  
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   LOAD AND PRINT ERROR REPORT                                *          
      ****************************************************************          
      *                                                                         
       2215-PRINT-ERROR-REPORT.                                         
      *                                                                         
           MOVE WS-OPEN-DATE  TO PRT-DATE.                              
           MOVE WS-METER-NO   TO PRT-METER.                             
           MOVE WS-MFG-SERIAL TO PRT-SERIAL.                            
           MOVE WS-MTR-TYPE   TO PRT-WORK-TYPE.                         
           MOVE WS-ERROR-MSG  TO PRT-ERROR-MSG.                         
      *                                                                         
           PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT.                    
      *                                                                         
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ NEWMTR-FILE                                             *          
      ****************************************************************          
      *                                                                         
       3100-READ-NEWMTR-FILE.                                           
      *                                                                         
           READ NEWMTR-FILE                                             
               AT END SET NEWMTR-END TO TRUE                            
           END-READ.                                                    
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITE OUTPUT RECORD                                          *          
      ****************************************************************          
      *                                                                         
       3600-WRITE-FIOCA669.                                             
      *                                                                         
           WRITE FIOCA669.                                              
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT DETAIL RECORD - CHECK FOR HEADERS                      *          
      ****************************************************************          
      *                                                                         
       4300-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-LINE-COUNT > +56                                       
              SET REPORT-NEW-PAGE TO TRUE                               
              MOVE ZEROS TO WS-LINE-COUNT                               
              PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE PRT-ERROR-LINE TO PRT-REPORT-LINE.                      
           MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT HEADERS                                                *          
      ****************************************************************          
      *                                                                         
       4310-HEADER-CTRLRPT1.                                            
      *                                                                         
           MOVE +0                 TO WS-LINE-COUNT.                    
           MOVE WS-PAGE-COUNT      TO PRT-HDR-PAGE.                     
           MOVE PRT-REPORT-HEADER1 TO PRT-REPORT-LINE.                  
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER2 TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER3 TO PRT-REPORT-LINE.                  
           MOVE 2                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT REPORT                                                 *          
      ****************************************************************          
      *                                                                         
       4500-PRINT-REPORT.                                               
      *                                                                         
           IF REPORT-NEW-PAGE                                           
              WRITE PRT-REPORT AFTER ADVANCING PAGE                     
              SET REPORT-FIRST-LINE TO TRUE                             
              MOVE +1 TO WS-LINE-COUNT                                  
              ADD  +1 TO WS-PAGE-COUNT                                  
           ELSE                                                         
              WRITE PRT-REPORT AFTER WS-PRT-REPORT-LINE-SPACE           
              ADD WS-PRT-REPORT-LINE-SPACE TO WS-LINE-COUNT             
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET CURRENT DATE FOR HEADERS                                *          
      ****************************************************************          
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE  = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  7000-GET-CURRENT-DATE              **'       
              DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9100-ABEND THRU 9100-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CONVERT THE INPUT DATE FORMATS INTO DB2 FORMAT              *          
      ****************************************************************          
      *                                                                         
       7011-CONVERT-DATES.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(:WS-DATE1)) E) T),'ISO'),
              CIS.CHAR2$DATE(
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(:WS-DATE2)) E) T),'ISO'),
              CIS.CHAR2$DATE(
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(:WS-DATE3)) E) T),'ISO')
            INTO
              :WS-PURC-DATE,
              :WS-OPEN-DATE,
              :WS-CHCK-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PURC-DATE = CHAR(DATE(TRIM(:WS-DATE1)),ISO)               
MFA-TR*          ,:WS-OPEN-DATE = CHAR(DATE(TRIM(:WS-DATE2)),ISO)               
MFA-TR*          ,:WS-CHCK-DATE = CHAR(DATE(TRIM(:WS-DATE3)),ISO)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7011-CONVERT-DATES                   **'      
              DISPLAY '** ERROR CONVERTING INPUT DATES         **'      
              DISPLAY '** NOT ABENDING - SEND RECORD TO REPORT **'      
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** E-NEWMTR-PURCH-DATE = ' E-NEWMTR-PURCH-DATE   
              DISPLAY '** E-NEWMTR-OPEN-DATE  = ' E-NEWMTR-OPEN-DATE    
              DISPLAY '** E-NEWMTR-CHECK-DATE = ' E-NEWMTR-CHECK-DATE   
              DISPLAY '******************************************'      
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-DATE-ERROR TO WS-ERROR-MSG                        
           END-IF.                                                      
      *                                                                         
       7011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_EQUIPMENT SELECT                                        *          
      ****************************************************************          
      *                                                                         
       7100-SELECT-EQUIPMENT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT EQ.DEVICE_NO                                       
                    ,EQ.SERIAL_NO                                       
                    ,EQ.CODE_CRNT_LOC                                   
                    ,EQ.CRNT_LOC_NO                                     
                    ,EQ.LOCAL_OFFICE                                    
                INTO :EQ-DEVICE-NO                                      
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-LOCAL-OFFICE                                   
                FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE EQ.DEVICE_NO = :WS-METER-NO                        
                 AND EQ.CODE_UTIL_TYPE = 'G'                            
                 AND EQ.COMPANY_NO = :WS-COMPANY-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQ.DEVICE_NO                                               
MFA-TR*             ,EQ.SERIAL_NO                                               
MFA-TR*             ,EQ.CODE_CRNT_LOC                                           
MFA-TR*             ,EQ.CRNT_LOC_NO                                             
MFA-TR*             ,EQ.LOCAL_OFFICE                                            
MFA-TR*         INTO :EQ-DEVICE-NO                                              
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EQ-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_EQUIPMENT EQ                                           
MFA-TR*        WHERE EQ.DEVICE_NO = :WS-METER-NO                                
MFA-TR*          AND EQ.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND EQ.COMPANY_NO = :WS-COMPANY-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-MTR-EXIST TO WS-ERROR-MSG                         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '**     PCSCA669 PROCESSING ERROR       **'    
                 DISPLAY '**       7100-SELECT-EQUIPMENT         **'    
                 DISPLAY '**  SELECT FOR CSS_EQUIPMENT FAILED    **'    
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  METER-NO = ' WS-METER-NO                  
                 DISPLAY '*****************************************'    
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_GAS_METER_SIZE M5                                       *          
      ****************************************************************          
      *                                                                         
       7150-SELECT-GAS-MTR-SIZE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT M5.METER_SIZE_ID                                   
                INTO :M5-METER-SIZE-ID                                  
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE M5.METER_SIZE_ID = :WS-MTR-TYPE                    
                 AND M5.COMPANY_NO    = :WS-COMPANY-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M5.METER_SIZE_ID                                           
MFA-TR*         INTO :M5-METER-SIZE-ID                                          
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE M5.METER_SIZE_ID = :WS-MTR-TYPE                            
MFA-TR*          AND M5.COMPANY_NO    = :WS-COMPANY-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = 100                            
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-INV-TYPE TO WS-ERROR-MSG                       
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '*      PCSCA669 PROCESSING ERROR         *'   
                 DISPLAY '*      7150-SELECT-GAS-MTR-SIZE          *'   
                 DISPLAY '*   SELECT FOR CSS_GAS_METER_SIZE FAILED *'   
                 DISPLAY '*   SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '*   METER_SIZE_ID = ' WS-MTR-TYPE             
                 DISPLAY '******************************************'   
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_EQUIP_ATTCHMTS - LX                                     *          
      ****************************************************************          
      *                                                                         
       7200-SELECT-EQ-ATTCHMTS.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT LX.CODE_UTIL_TYPE                                  
                    ,LX.COMPANY_NO                                      
                INTO :LX-CODE-UTIL-TYPE                                 
                    ,:LX-COMPANY-NO                                     
                FROM CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                
               WHERE LX.DEVICE_NO      = :WS-ATTACHMENT-ALL             
                 AND LX.CODE_ATT_TYPE  = :WS-ATTACH-TYPE                
                 AND LX.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
                 AND LX.COMPANY_NO     = :WS-COMPANY-NO                 
                 AND LX.EQUIP_LOC_ID   = :WS-K                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LX.CODE_UTIL_TYPE                                          
MFA-TR*             ,LX.COMPANY_NO                                              
MFA-TR*         INTO :LX-CODE-UTIL-TYPE                                         
MFA-TR*             ,:LX-COMPANY-NO                                             
MFA-TR*         FROM CSS_EQUIP_ATTCHMTS LX                                      
MFA-TR*        WHERE LX.DEVICE_NO      = :WS-ATTACHMENT-ALL                     
MFA-TR*          AND LX.CODE_ATT_TYPE  = :WS-ATTACH-TYPE                        
MFA-TR*          AND LX.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                     
MFA-TR*          AND LX.COMPANY_NO     = :WS-COMPANY-NO                         
MFA-TR*          AND LX.EQUIP_LOC_ID   = :WS-K                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-ATT-EXIST TO WS-ERROR-MSG                         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '**     PCSCA669 PROCESSING ERROR         **'  
                 DISPLAY '**     7200-SELECT-EQ-ATTCHMTS           **'  
                 DISPLAY '**  SELECT FOR CSS_EQUIP_ATTCHMTS FAILED **'  
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  DEVICE_NO      = ' WS-ATTACHMENT-ALL      
                 DISPLAY '**  CODE_ATT_TYPE  = ' WS-ATTACH-TYPE         
                 DISPLAY '**  CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE      
                 DISPLAY '**  EQUIP_LOC_ID   = ' WS-K                   
                 DISPLAY '*******************************************'  
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET COMPANY NAME FOR REPORT                                  *          
      ****************************************************************          
      *                                                                         
       7225-SELECT-COMPANY-NAME.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
              INTO :C7-COMPANY-NAME                                     
              FROM CSS_COMPANY                                          
              WHERE COMPANY_NO = :WS-COMPANY-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C7-COMPANY-NAME TO WS-COMPANY-NAME                   
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**      PCSCA669 PROCESSING ERROR         **'    
              DISPLAY '**      7225-SELECT-COMPANY-NAME          **'    
              DISPLAY '**   SELECT FOR CSS_COMPANY FAILED        **'    
              DISPLAY '**   SQLCODE  = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**   COMPANY-NO     = ' WS-COMPANY-NO            
              DISPLAY '********************************************'    
              PERFORM 9100-ABEND THRU 9100-EXIT                         
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * CLOSES FILES AT NORMAL TERMINATION                           *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA669-FILE                                          
                 NEWMTR-FILE                                            
                 PRINTER1.                                              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FOLLOWING PROCESS IS INVOKED WHEN ABNORMAL TERMINATION.      *          
      ****************************************************************          
      *                                                                         
       9100-ABEND.                                                      
      *                                                                         
           MOVE +9 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
