       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA668.                                         
       DATE-WRITTEN.   25 MARCH 2012.                                   
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **               SOUTH CAROLINA ELECTRIC & GAS                **          
      **              COMPLETE BUSINESS SOLUTIONS INC.              **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM            *********          
      ********                      DB2                      *********          
      ****************************************************************          
      **                                                            **          
      **            PROGRAM    MODIFICATION  LOG                    **          
      **    DATE    INITIALS     REASON                             **          
      **    ____    ________     ______                             **          
      **                                                            **          
      **  25 MAR 2012 RDF     USED FOR REPORTING COMPANY TOTALS     **          
      **                                                            **          
A04527**  13 MAY 2013 RDF     ADD TOTALS TO REPORT                  **          
      **                                                            **          
A04527**   9 AUG 2013 RDF     ADD TO ALL CURSOR FOR REV TABLES      **          
      **                      REV_POST_STATUS_FL = 'Y'              **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSCA668 NARRATIVE                        
            THIS PROGRAM RETRIEVES THE DATA FROM THE REVENUE TABLES     
            AND PRINTS COMPANY SUMMARY REPORTS FOR ALL ELECTRIC AND     
            ALL GAS (EXCLUDING DEADHEADS) AND FOR ALL DEADHEAD          
            ELECTRIC AND GAS.                                           
      *                                                                         
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       FD  PRINTER1.                                                    
       01  FS-PRINT-REC.                                                
           05  RPT-CNTL                     PIC X.                      
           05  RPT-LINE                     PIC X(132).                 
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA668'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-SCEG01                   PIC XX   VALUE '01'.           
          05 WS-SCEG                     PIC X(4) VALUE 'SCEG'.         
          05 WS-PSNC                     PIC X(4) VALUE 'PSNC'.         
          05 WS-ELECTRIC                 PIC X    VALUE 'E'.            
          05 WS-FRAN-TAX                 PIC X    VALUE 'B'.            
          05 WS-SALES-TAX                PIC X    VALUE 'A'.            
          05 WS-ELE                      PIC X(7) VALUE 'ELE  '.        
A04527    05 WS-ELE-TOT                  PIC X(7) VALUE 'ELE TOT'.      
          05 WS-GAS                      PIC X(7) VALUE 'GAS  '.        
A04527    05 WS-GAS-TOT                  PIC X(7) VALUE 'GAS TOT'.      
A04527    05 WS-PSNC-TOT                 PIC X(7) VALUE 'TOTAL  '.      
          05 WS-ELE-DH                   PIC X(7) VALUE 'DH ELE '.      
          05 WS-GAS-DH                   PIC X(7) VALUE 'DH GAS '.      
          05 WS-LINE-SPACE               PIC 9    VALUE ZERO.           
          05 WS-ONE                      PIC 9    VALUE 1.              
          05 WS-TWO                      PIC 9    VALUE 2.              
          05 WS-ELE-DEADHEAD             PIC X(3) VALUE 'E99'.          
          05 WS-GAS-DEADHEAD             PIC X(3) VALUE 'G99'.          
          05 WS-GAS-UTIL-TYPE            PIC X  VALUE 'G'.              
          05 WS-ELE-UTIL-TYPE            PIC X  VALUE 'E'.              
          05 WS-WANTED                   PIC X  VALUE 'N'.              
          05 WS-YES                      PIC X  VALUE 'Y'.              
          05 WS-NO                       PIC X  VALUE 'N'.              
          05 RS-RETURN-CODE              PIC S9(4) COMP VALUE 0.        
          05 RS-RETURN-CODE-DISP         PIC +Z(4).                     
          05 PROGRAM-NAME                PIC X(8)  VALUE 'PCSCA668'.    
          05 WS-PGRMNAME                 PIC X(8)  VALUE 'PCSCA668'.    
          05 WS-NO-MORE-DATA             PIC X  VALUE 'N'.              
      *                                                                         
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
      *                                                                         
       01  WS-PARM-DATA668.                                             
           05 WS-PARM-LITERAL          PIC X(14).                       
           05 WS-REVENUE-MONTH         PIC 9(6).                        
           05 FILLER                   PIC X(60).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-ACTIVE                PIC X     VALUE 'A'.             
           05 WS-PGM-204               PIC X(8)  VALUE 'PCSCA204'.      
           05 WS-PARM-204              PIC X(4)  VALUE 'PARM'.          
           05 WS-COMPANY-204           PIC XX    VALUE '01'.            
           05 WS-SEQ-NO                PIC S9999V COMP-3 VALUE 6.       
      *                                                                         
       01  WS-CURSOR-COUNTERS.                                          
           05  WS-CUST-CT              PIC S9(9)    COMP-3 VALUE 0.     
           05  WS-TAX-AMT              PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-BILLED-AMT           PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-BILL-USAGE-UNITS     PIC S9(11)   COMP-3 VALUE 0.     
           05  WS-READ-UNITS           PIC S9(11)   COMP-3 VALUE 0.     
      *                                                                         
       01  WS-CLASS.                                                    
           05  WS-CLASS1              PIC X    VALUE SPACES.            
           05  WS-CLASS2              PIC X    VALUE SPACES.            
           05  WS-CLASS3              PIC X    VALUE SPACES.            
      *                                                                         
       01  WS-SCEG-ELECTRIC-ACCUMLATORS.                                
           05  WS-SCEG-RG-ELE-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-BILL-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-READ-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-BILL-AMT   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-SALE-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-FRAN-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-ELE-LOST-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-DH-ELE-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-SCEG-DH-ELE-BILL    PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-DH-ELE-READ    PIC S9(11)   COMP-3 VALUE 0.      
      *                                                                         
       01  WS-SCEG-GAS-ACCUMLATORS.                                     
           05  WS-SCEG-RG-GAS-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-BILL-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-READ-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-BILL-AMT   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-SALE-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-FRAN-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-GAS-LOST-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-SCEG-DH-GAS-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-SCEG-DH-GAS-BILL    PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-SCEG-DH-GAS-READ    PIC S9(11)   COMP-3 VALUE 0.      
      *                                                                         
       01  WS-PSNC-GAS-ACCUMLATORS.                                     
           05  WS-PSNC-RG-GAS-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-BILL-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-READ-UNITS PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-BILL-AMT   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-SALE-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-FRAN-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-PSNC-GAS-LOST-TAX   PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-PSNC-DH-GAS-COUNT   PIC S9(9)    COMP-3 VALUE 0.      
           05  WS-PSNC-DH-GAS-BILL    PIC S9(11)   COMP-3 VALUE 0.      
           05  WS-PSNC-DH-GAS-READ    PIC S9(11)   COMP-3 VALUE 0.      
      *                                                                         
A04527 01  WS-TOTAL-ACCUMLATORS.                                        
A04527     05  WS-TOTAL-COUNT         PIC S9(9)    COMP-3 VALUE 0.      
A04527     05  WS-TOTAL-BILL          PIC S9(11)   COMP-3 VALUE 0.      
A04527     05  WS-TOTAL-READ          PIC S9(11)   COMP-3 VALUE 0.      
      *                                                                         
      ****************************************************************          
      ** REPORT HEADERS                                             **          
      ****************************************************************          
      *                                                                         
       01  HEADER-1.                                                    
           05 FILLER                  PIC X(8)  VALUE 'PCSCA668'.       
           05 FILLER                  PIC X(39) VALUE SPACES.           
           05 FILLER                  PIC X(39) VALUE                   
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                  PIC X(21) VALUE SPACES.           
           05 FILLER                  PIC X(11) VALUE 'RUN DATE = '.    
           05 PRT-HDR-DATE            PIC X(10) VALUE SPACES.           
           05 FILLER                  PIC X(4)  VALUE SPACES.           
      *                                                                         
       01  HEADER-2.                                                    
           05 FILLER                  PIC X(40) VALUE SPACES.           
           05 FILLER                  PIC X(47) VALUE                   
              'REVENUE CORRECTION TOTALS FOR REVENUE MONTH = '.         
           05 PRT-HDR-REVENUE-MONTH   PIC 9(6).                         
           05 FILLER                  PIC X(14) VALUE SPACES.           
           05 FILLER                  PIC X(11) VALUE 'RUN TIME = '.    
           05 PRT-HDR-TIME            PIC X(8)  VALUE SPACES.           
           05 FILLER                  PIC X(6)  VALUE SPACES.           
      *                                                                         
       01  HEADER-3.                                                    
           05 FILLER                  PIC XX    VALUE SPACES.           
           05 FILLER                  PIC X(4)  VALUE 'COMP'.           
           05 FILLER                  PIC X     VALUE SPACES.           
           05 FILLER                  PIC X(5)  VALUE 'TYPE '.          
           05 FILLER                  PIC X(5)  VALUE SPACES.           
           05 FILLER                  PIC X(14) VALUE 'REVENUE AMOUNT'. 
           05 FILLER                  PIC X(7)  VALUE SPACES.           
           05 FILLER                  PIC X(9)  VALUE 'SALES TAX'.      
           05 FILLER                  PIC X(8)  VALUE SPACES.           
           05 FILLER                  PIC X(8)  VALUE 'LOST TAX'.       
           05 FILLER                  PIC X(2)  VALUE SPACES.           
           05 FILLER                  PIC X(13) VALUE 'FRANCHISE TAX'.  
           05 FILLER                  PIC X(8)  VALUE SPACES.           
           05 FILLER                  PIC X(10) VALUE 'CUST COUNT'.     
           05 FILLER                  PIC X(10) VALUE SPACES.           
           05 FILLER                  PIC X(7)  VALUE 'KWH/CCF'.        
           05 FILLER                  PIC X(11) VALUE SPACES.           
           05 FILLER                  PIC X(6)  VALUE 'THERMS'.         
           05 FILLER                  PIC XX    VALUE SPACES.           
      *                                                                         
      ****************************************************************          
      ** SUMMARY PRINT LINES                                        **          
      ****************************************************************          
      *                                                                         
       01  PRT-DETAIL-LINE.                                             
           05 FILLER                   PIC XX    VALUE SPACES.          
           05 PRT-COMPANY              PIC X(4).                        
A04527     05 FILLER                   PIC X     VALUE SPACES.          
A04527     05 PRT-TYPE                 PIC X(7).                        
           05 FILLER                   PIC X     VALUE SPACES.          
           05 PRT-AMOUNT               PIC -,---,---,--9.99.            
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT-SALES-TAX            PIC --,---,--9.99.               
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT-LOST-TAX             PIC --,---,--9.99.               
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT-FRAN-TAX             PIC --,---,--9.99.               
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 PRT-COUNT                PIC -,---,---,--9.               
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT-KWH                  PIC --,---,---,--9.              
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT-THERMS               PIC --,---,---,--9.              
           05 FILLER                   PIC XX    VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      **                  NECESSARY COPYBOOKS                       **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  ABEND SWITCH COPYBOOK                                     **          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ****************************************************************          
      **  COPYBOOK FOR CSS_JOB_PARM                                  *          
      ****************************************************************          
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ****************************************************************          
      **  DB2 AND SQL ERROR CHECKING                                **          
      ****************************************************************          
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ****************************************************************          
      **                 COMMON ABEND FUNCTIONALITY                 **          
      ****************************************************************          
      *                                                                         
       01 ABEND-FUNCTIONS.                                              
          05 WS-ABEND-SPACE              PIC XX  VALUE SPACE.           
          05 FILLER REDEFINES WS-ABEND-SPACE.                           
             10 WS-ABEND-NUMERIC         PIC 99.                        
      *                                                                         
      ****************************************************************          
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_JOB_PARM                                              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_COMPANY                                               **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  REV_BILLING_DET - RV                                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREVBLD                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  REV_BILL_COMP_ADJ - RB                                    **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREVCOM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  REV_BILL_TAX - R9                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREVTAX                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DEFINITION TO SELECT CUSTOMER COUNT  -  DEADHEADS     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE DEAD_CSR CURSOR FOR                              
                  SELECT RV.COMPANY_NO                                  
                        ,RV.CODE_SERVICE_TYPE                           
                        ,SUM(RV.CUST_CT)                                
                    FROM  REV_BILLING_DET RV WITH(READUNCOMMITTED)              
                   WHERE RV.REVENUE_MONTH     = :RV-REVENUE-MONTH       
                     AND RV.RATE_DEPT_CD IN ('E99', 'G99')              
                     AND RV.RATE_PLAN_NO <> '000'                       
P04527               AND RV.REV_POST_STATUS_FL = 'Y'                    
                     GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE       
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DEAD_CSR CURSOR FOR                                      
MFA-TR*           SELECT RV.COMPANY_NO                                          
MFA-TR*                 ,RV.CODE_SERVICE_TYPE                                   
MFA-TR*                 ,SUM(RV.CUST_CT)                                        
MFA-TR*             FROM  REV_BILLING_DET RV                                    
MFA-TR*            WHERE RV.REVENUE_MONTH     = :RV-REVENUE-MONTH               
MFA-TR*              AND RV.RATE_DEPT_CD IN ('E99', 'G99')                      
MFA-TR*              AND RV.RATE_PLAN_NO <> '000'                               
MFA-TR*              AND RV.REV_POST_STATUS_FL = 'Y'                            
MFA-TR*              GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE               
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7001                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DEFINITION TO SELECT CUSTOMER COUNT  - NON-DEADHEADS  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE NONDH_CSR CURSOR FOR                             
                  SELECT RV.COMPANY_NO                                  
                        ,RV.CODE_SERVICE_TYPE                           
                        ,SUM(RV.CUST_CT)                                
                   FROM  REV_BILLING_DET RV WITH(READUNCOMMITTED)               
                   WHERE RV.REVENUE_MONTH     = :RV-REVENUE-MONTH       
                     AND RV.RATE_DEPT_CD NOT IN ('E99', 'G99')          
P04527               AND RV.REV_POST_STATUS_FL = 'Y'                    
                     GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE       
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE NONDH_CSR CURSOR FOR                                     
MFA-TR*           SELECT RV.COMPANY_NO                                          
MFA-TR*                 ,RV.CODE_SERVICE_TYPE                                   
MFA-TR*                 ,SUM(RV.CUST_CT)                                        
MFA-TR*            FROM  REV_BILLING_DET RV                                     
MFA-TR*            WHERE RV.REVENUE_MONTH     = :RV-REVENUE-MONTH               
MFA-TR*              AND RV.RATE_DEPT_CD NOT IN ('E99', 'G99')                  
MFA-TR*              AND RV.REV_POST_STATUS_FL = 'Y'                            
MFA-TR*              GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE               
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7011                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DEFINITION TO SELECT REVENUE AND USE - NON-DEADHEADS  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
              DECLARE REV_CSR CURSOR FOR                                
                 SELECT RV.COMPANY_NO                                   
                       ,RV.CODE_SERVICE_TYPE                            
                       ,SUM(RB.BILLED_AMT)                              
                       ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C') 
                           THEN RB.BILL_USAGE_UNITS                     
                           WHEN RB.CONSUMPT_TYPE_CD = 'D'               
                           THEN (RB.BILL_USAGE_UNITS * 10) ELSE 0 END)  
                       ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C') 
                           THEN RB.READ_UNITS                           
                           WHEN RB.CONSUMPT_TYPE_CD = 'D'               
                           THEN (RB.READ_UNITS * 10) ELSE 0 END)        
                   FROM  REV_BILL_COMP_ADJ RB WITH(READUNCOMMITTED)             
                        ,REV_BILLING_DET RV WITH(READUNCOMMITTED)               
                   WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH          
                     AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS          
                     AND RB.UTILITY_REV_CD = 'U'                        
                     AND RV.RATE_DEPT_CD NOT IN ('E99', 'G99')          
P04527               AND RV.REV_POST_STATUS_FL = 'Y'                    
                     GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE       
                     FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REV_CSR CURSOR FOR                                        
MFA-TR*          SELECT RV.COMPANY_NO                                           
MFA-TR*                ,RV.CODE_SERVICE_TYPE                                    
MFA-TR*                ,SUM(RB.BILLED_AMT)                                      
MFA-TR*                ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')         
MFA-TR*                    THEN RB.BILL_USAGE_UNITS                             
MFA-TR*                    WHEN RB.CONSUMPT_TYPE_CD = 'D'                       
MFA-TR*                    THEN (RB.BILL_USAGE_UNITS * 10) ELSE 0 END)          
MFA-TR*                ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')         
MFA-TR*                    THEN RB.READ_UNITS                                   
MFA-TR*                    WHEN RB.CONSUMPT_TYPE_CD = 'D'                       
MFA-TR*                    THEN (RB.READ_UNITS * 10) ELSE 0 END)                
MFA-TR*            FROM  REV_BILL_COMP_ADJ RB                                   
MFA-TR*                 ,REV_BILLING_DET RV                                     
MFA-TR*            WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                  
MFA-TR*              AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS                  
MFA-TR*              AND RB.UTILITY_REV_CD = 'U'                                
MFA-TR*              AND RV.RATE_DEPT_CD NOT IN ('E99', 'G99')                  
MFA-TR*              AND RV.REV_POST_STATUS_FL = 'Y'                            
MFA-TR*              GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE               
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7031                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DEFINITION TO SELECT DEAD HEAD USAGE                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
              DECLARE REVDEAD_CSR CURSOR FOR                            
                 SELECT RV.COMPANY_NO                                   
                       ,RV.CODE_SERVICE_TYPE                            
                       ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C') 
                           THEN RB.BILL_USAGE_UNITS                     
                           WHEN RB.CONSUMPT_TYPE_CD = 'D'               
                           THEN (RB.BILL_USAGE_UNITS * 10) ELSE 0 END)  
                       ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C') 
                           THEN RB.READ_UNITS                           
                           WHEN RB.CONSUMPT_TYPE_CD = 'D'               
                           THEN (RB.READ_UNITS * 10) ELSE 0 END)        
                  FROM  REV_BILL_COMP_ADJ RB WITH(READUNCOMMITTED)              
                       ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                
                  WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH           
                    AND RB.FACTOR_ID      = 'NETREVFCT'                 
                    AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS           
                    AND RB.UTILITY_REV_CD = 'U'                         
                    AND RV.RATE_DEPT_CD IN ('E99', 'G99')               
P04527              AND RV.REV_POST_STATUS_FL = 'Y'                     
                    GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE        
                    FOR READ ONLY                               
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REVDEAD_CSR CURSOR FOR                                    
MFA-TR*          SELECT RV.COMPANY_NO                                           
MFA-TR*                ,RV.CODE_SERVICE_TYPE                                    
MFA-TR*                ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')         
MFA-TR*                    THEN RB.BILL_USAGE_UNITS                             
MFA-TR*                    WHEN RB.CONSUMPT_TYPE_CD = 'D'                       
MFA-TR*                    THEN (RB.BILL_USAGE_UNITS * 10) ELSE 0 END)          
MFA-TR*                ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')         
MFA-TR*                    THEN RB.READ_UNITS                                   
MFA-TR*                    WHEN RB.CONSUMPT_TYPE_CD = 'D'                       
MFA-TR*                    THEN (RB.READ_UNITS * 10) ELSE 0 END)                
MFA-TR*           FROM  REV_BILL_COMP_ADJ RB                                    
MFA-TR*                ,REV_BILLING_DET RV                                      
MFA-TR*           WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                   
MFA-TR*             AND RB.FACTOR_ID      = 'NETREVFCT'                         
MFA-TR*             AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS                   
MFA-TR*             AND RB.UTILITY_REV_CD = 'U'                                 
MFA-TR*             AND RV.RATE_DEPT_CD IN ('E99', 'G99')                       
MFA-TR*             AND RV.REV_POST_STATUS_FL = 'Y'                             
MFA-TR*             GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE                
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*             QUERYNO 7021                                                
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      * CURSOR DEFINITION TO SELECT ALL TAX DATA                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE TAX_CSR CURSOR FOR                               
                   SELECT RV.COMPANY_NO                                 
                         ,RV.CODE_SERVICE_TYPE                          
                         ,R9.TAX_TYPE                                   
                         ,SUM(R9.TAX_AMT)                               
                    FROM  REV_BILL_TAX R9 WITH(READUNCOMMITTED)                 
                         ,REV_BILLING_DET RV WITH(READUNCOMMITTED)              
                    WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH         
                      AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS         
                      AND R9.TAX_AMT       <> 0                         
P04527                AND RV.REV_POST_STATUS_FL = 'Y'                   
                    GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE        
                            ,R9.TAX_TYPE                                
                      FOR READ ONLY                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TAX_CSR CURSOR FOR                                       
MFA-TR*            SELECT RV.COMPANY_NO                                         
MFA-TR*                  ,RV.CODE_SERVICE_TYPE                                  
MFA-TR*                  ,R9.TAX_TYPE                                           
MFA-TR*                  ,SUM(R9.TAX_AMT)                                       
MFA-TR*             FROM  REV_BILL_TAX R9                                       
MFA-TR*                  ,REV_BILLING_DET RV                                    
MFA-TR*             WHERE RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                 
MFA-TR*               AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS                 
MFA-TR*               AND R9.TAX_AMT       <> 0                                 
MFA-TR*               AND RV.REV_POST_STATUS_FL = 'Y'                           
MFA-TR*             GROUP BY RV.COMPANY_NO, RV.CODE_SERVICE_TYPE                
MFA-TR*                     ,R9.TAX_TYPE                                        
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*               QUERYNO 7041                                              
MFA-TR*     END-EXEC.                                                           
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **    BEGIN                                                   **          
      ****************************************************************          
      *                                                                         
       0000-NOW-WE-START.                                               
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
           PERFORM 0500-PROCESS-DATA THRU 0500-EXIT.                    
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       GET CURRENT DATE -   GET CURRENT REVENUE MONTH       **          
      **           FROM CSS_JOB_PARM - PCSCA204                     **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT PRINTER1.                                        
      *                                                                         
           PERFORM 7200-GET-CURRENT-DATE  THRU 7200-EXIT.               
           MOVE WS-CURRENT-DATE TO PRT-HDR-DATE.                        
      *                                                                         
           MOVE WS-PGM-204     TO G6-PROGRAM-NAME.                      
           MOVE WS-PARM-204    TO G6-CMND-CODE.                         
           MOVE WS-COMPANY-204 TO G6-COMPANY-NO.                        
           MOVE WS-SEQ-NO      TO G6-SEQ-NO.                            
           MOVE WS-ACTIVE      TO G6-STATUS.                            
           PERFORM 7400-GET-REVENUE-MONTH THRU 7400-EXIT.               
           MOVE G6-PARM-DATA TO WS-PARM-DATA668.                        
           DISPLAY 'WS-REVENUE-MONTH   = ' WS-REVENUE-MONTH.            
           DISPLAY 'CURRENT DATE       = ' WS-CURRENT-DATE.             
           DISPLAY 'CURRENT-TIMESTAMP  = ' WS-CURRENT-TIMESTAMP.        
           MOVE WS-REVENUE-MONTH TO PRT-HDR-REVENUE-MONTH.              
           MOVE WS-CURRENT-TIMESTAMP(12:8) TO PRT-HDR-TIME.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   THIS PARAGRAPH OPENS/FETCHES/CLOSES ALL CURSORS AND      **          
      **   STORES THE DATA IN WS FIELDS.  THEN PERFORMS THE         **          
      **   ROUTINE TO PRINT THE SUMMARY REPORT.                     **          
      ****************************************************************          
      *                                                                         
       0500-PROCESS-DATA.                                               
      *                                                                         
           INITIALIZE WS-CURSOR-COUNTERS.                               
      *                                                                         
           MOVE WS-REVENUE-MONTH TO RV-REVENUE-MONTH.                   
      *                                                                         
           PERFORM 7000-OPEN-DEADHEAD-CURSOR THRU 7000-EXIT.            
      *                                                                         
           PERFORM 7001-FETCH-DEADHEAD-CURSOR THRU 7001-EXIT.           
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF RV-COMPANY-NO = WS-SCEG01                              
                 IF RV-CODE-SERVICE-TYPE = WS-ELECTRIC                  
                    MOVE WS-CUST-CT TO WS-SCEG-DH-ELE-COUNT             
                 ELSE                                                   
                    MOVE WS-CUST-CT TO WS-SCEG-DH-GAS-COUNT             
                 END-IF                                                 
              ELSE                                                      
                    MOVE WS-CUST-CT TO WS-PSNC-DH-GAS-COUNT             
              END-IF                                                    
              PERFORM 7001-FETCH-DEADHEAD-CURSOR THRU 7001-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7002-CLOSE-DEADHEAD-CURSOR THRU 7002-EXIT.           
      *                                                                         
           INITIALIZE WS-CURSOR-COUNTERS.                               
      *                                                                         
           MOVE WS-REVENUE-MONTH TO RV-REVENUE-MONTH.                   
      *                                                                         
           PERFORM 7010-OPEN-NONDEADHEAD-CURSOR THRU 7010-EXIT.         
      *                                                                         
           PERFORM 7011-FETCH-NONDEADHEAD-CURSOR THRU 7011-EXIT.        
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF RV-COMPANY-NO = WS-SCEG01                              
                 IF RV-CODE-SERVICE-TYPE = WS-ELECTRIC                  
                    MOVE WS-CUST-CT TO WS-SCEG-RG-ELE-COUNT             
                 ELSE                                                   
                    MOVE WS-CUST-CT TO WS-SCEG-RG-GAS-COUNT             
                 END-IF                                                 
              ELSE                                                      
                    MOVE WS-CUST-CT TO WS-PSNC-RG-GAS-COUNT             
              END-IF                                                    
              PERFORM 7011-FETCH-NONDEADHEAD-CURSOR THRU 7011-EXIT      
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7012-CLOSE-NONDEADHEAD-CURSOR THRU 7012-EXIT.        
      *                                                                         
           INITIALIZE WS-CURSOR-COUNTERS.                               
      *                                                                         
           MOVE WS-REVENUE-MONTH TO RV-REVENUE-MONTH.                   
      *                                                                         
           PERFORM 7020-OPEN-REVDEAD-CURSOR THRU 7020-EXIT.             
      *                                                                         
           PERFORM 7021-FETCH-REVDEAD-CURSOR THRU 7021-EXIT.            
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF RV-COMPANY-NO = WS-SCEG01                              
                 IF RV-CODE-SERVICE-TYPE = WS-ELECTRIC                  
                    MOVE WS-BILL-USAGE-UNITS TO WS-SCEG-DH-ELE-BILL     
                    MOVE WS-READ-UNITS       TO WS-SCEG-DH-ELE-READ     
                 ELSE                                                   
                    MOVE WS-BILL-USAGE-UNITS TO WS-SCEG-DH-GAS-BILL     
                    MOVE WS-READ-UNITS       TO WS-SCEG-DH-GAS-READ     
                 END-IF                                                 
              ELSE                                                      
                    MOVE WS-BILL-USAGE-UNITS TO WS-PSNC-DH-GAS-BILL     
                    MOVE WS-READ-UNITS       TO WS-PSNC-DH-GAS-READ     
              END-IF                                                    
              PERFORM 7021-FETCH-REVDEAD-CURSOR THRU 7021-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7022-CLOSE-REVDEAD-CURSOR THRU 7022-EXIT.            
      *                                                                         
           INITIALIZE WS-CURSOR-COUNTERS.                               
      *                                                                         
           MOVE WS-REVENUE-MONTH TO RV-REVENUE-MONTH.                   
      *                                                                         
           PERFORM 7030-OPEN-REV-CURSOR THRU 7030-EXIT.                 
      *                                                                         
           PERFORM 7031-FETCH-REV-CURSOR THRU 7031-EXIT.                
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF RV-COMPANY-NO = WS-SCEG01                              
                 IF RV-CODE-SERVICE-TYPE = WS-ELECTRIC                  
                    MOVE WS-BILLED-AMT       TO WS-SCEG-ELE-BILL-AMT    
                    MOVE WS-BILL-USAGE-UNITS TO WS-SCEG-ELE-BILL-UNITS  
                    MOVE WS-READ-UNITS       TO WS-SCEG-ELE-READ-UNITS  
                 ELSE                                                   
                    MOVE WS-BILLED-AMT       TO WS-SCEG-GAS-BILL-AMT    
                    MOVE WS-BILL-USAGE-UNITS TO WS-SCEG-GAS-BILL-UNITS  
                    MOVE WS-READ-UNITS       TO WS-SCEG-GAS-READ-UNITS  
                 END-IF                                                 
              ELSE                                                      
                    MOVE WS-BILLED-AMT       TO WS-PSNC-GAS-BILL-AMT    
                    MOVE WS-BILL-USAGE-UNITS TO WS-PSNC-GAS-BILL-UNITS  
                    MOVE WS-READ-UNITS       TO WS-PSNC-GAS-READ-UNITS  
              END-IF                                                    
              PERFORM 7031-FETCH-REV-CURSOR THRU 7031-EXIT              
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7032-CLOSE-REV-CURSOR THRU 7032-EXIT.                
      *                                                                         
           INITIALIZE WS-CURSOR-COUNTERS.                               
      *                                                                         
           MOVE WS-REVENUE-MONTH TO RV-REVENUE-MONTH.                   
      *                                                                         
           PERFORM 7040-OPEN-TAX-CURSOR THRU 7040-EXIT.                 
      *                                                                         
           PERFORM 7041-FETCH-TAX-CURSOR THRU 7041-EXIT.                
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF RV-COMPANY-NO = WS-SCEG01                              
                 IF RV-CODE-SERVICE-TYPE = WS-ELECTRIC                  
                    IF R9-TAX-TYPE =  WS-SALES-TAX                      
                       MOVE WS-TAX-AMT TO WS-SCEG-ELE-SALE-TAX          
                    ELSE                                                
                       IF R9-TAX-TYPE =  WS-FRAN-TAX                    
                          MOVE WS-TAX-AMT TO WS-SCEG-ELE-FRAN-TAX       
                       ELSE                                             
                          MOVE WS-TAX-AMT TO WS-SCEG-ELE-LOST-TAX       
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    IF R9-TAX-TYPE =  WS-SALES-TAX                      
                       MOVE WS-TAX-AMT TO WS-SCEG-GAS-SALE-TAX          
                    ELSE                                                
                       IF R9-TAX-TYPE =  WS-FRAN-TAX                    
                          MOVE WS-TAX-AMT TO WS-SCEG-GAS-FRAN-TAX       
                       ELSE                                             
                          MOVE WS-TAX-AMT TO WS-SCEG-GAS-LOST-TAX       
                       END-IF                                           
                    END-IF
                 END-IF                                              
              ELSE                                                      
                 IF R9-TAX-TYPE =  WS-SALES-TAX                         
                    MOVE WS-TAX-AMT TO WS-PSNC-GAS-SALE-TAX             
                 ELSE                                                   
                    IF R9-TAX-TYPE =  WS-FRAN-TAX                       
                       MOVE WS-TAX-AMT TO WS-PSNC-GAS-FRAN-TAX          
                    ELSE                                                
                       MOVE WS-TAX-AMT TO WS-PSNC-GAS-LOST-TAX          
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7041-FETCH-TAX-CURSOR THRU 7041-EXIT              
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7042-CLOSE-TAX-CURSOR THRU 7042-EXIT.                
      *                                                                         
           PERFORM 5000-PREPARE-PRINTED-REPORT THRU 5000-EXIT.          
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE REPORT                                                *          
      ****************************************************************          
      *                                                                         
       5000-PREPARE-PRINTED-REPORT.                                     
      *                                                                         
           MOVE HEADER-1                 TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE HEADER-2                 TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE HEADER-3                 TO RPT-LINE.                   
           MOVE WS-TWO                   TO WS-LINE-SPACE.              
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-SCEG                TO PRT-COMPANY.                  
           MOVE WS-ELE                 TO PRT-TYPE.                     
           MOVE WS-SCEG-ELE-BILL-AMT   TO PRT-AMOUNT.                   
           MOVE WS-SCEG-ELE-SALE-TAX   TO PRT-SALES-TAX.                
           MOVE WS-SCEG-ELE-LOST-TAX   TO PRT-LOST-TAX.                 
           MOVE WS-SCEG-ELE-FRAN-TAX   TO PRT-FRAN-TAX.                 
           MOVE WS-SCEG-RG-ELE-COUNT   TO PRT-COUNT.                    
           MOVE WS-SCEG-ELE-BILL-UNITS TO PRT-KWH.                      
           MOVE ZEROS                  TO PRT-THERMS.                   
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-SCEG                TO PRT-COMPANY.                  
           MOVE WS-ELE-DH              TO PRT-TYPE.                     
           MOVE ZEROS                  TO PRT-AMOUNT.                   
           MOVE ZEROS                  TO PRT-SALES-TAX.                
           MOVE ZEROS                  TO PRT-LOST-TAX.                 
           MOVE ZEROS                  TO PRT-FRAN-TAX.                 
           MOVE WS-SCEG-DH-ELE-COUNT   TO PRT-COUNT.                    
           MOVE WS-SCEG-DH-ELE-BILL    TO PRT-KWH.                      
           MOVE ZEROS                  TO PRT-THERMS.                   
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
A04527*    DO SCEG ELECTRIC TOTALS                                              
      *                                                                         
A04527     MOVE WS-SCEG                TO PRT-COMPANY.                  
A04527     MOVE WS-ELE-TOT             TO PRT-TYPE.                     
A04527     MOVE WS-SCEG-ELE-BILL-AMT   TO PRT-AMOUNT.                   
A04527     MOVE WS-SCEG-ELE-SALE-TAX   TO PRT-SALES-TAX.                
A04527     MOVE WS-SCEG-ELE-LOST-TAX   TO PRT-LOST-TAX.                 
A04527     MOVE WS-SCEG-ELE-FRAN-TAX   TO PRT-FRAN-TAX.                 
A04527     COMPUTE WS-TOTAL-COUNT =                                     
A04527             WS-SCEG-RG-ELE-COUNT + WS-SCEG-DH-ELE-COUNT.         
A04527     MOVE WS-TOTAL-COUNT         TO PRT-COUNT.                    
A04527     COMPUTE WS-TOTAL-BILL =                                      
A04527             WS-SCEG-ELE-BILL-UNITS + WS-SCEG-DH-ELE-BILL.        
A04527     MOVE WS-TOTAL-BILL          TO PRT-KWH.                      
A04527     MOVE ZEROS                  TO PRT-THERMS.                   
A04527     MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
A04527     MOVE WS-TWO                 TO WS-LINE-SPACE.                
A04527     PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-SCEG                TO PRT-COMPANY.                  
           MOVE WS-GAS                 TO PRT-TYPE.                     
           MOVE WS-SCEG-GAS-BILL-AMT   TO PRT-AMOUNT.                   
           MOVE WS-SCEG-GAS-SALE-TAX   TO PRT-SALES-TAX.                
           MOVE WS-SCEG-GAS-LOST-TAX   TO PRT-LOST-TAX.                 
           MOVE WS-SCEG-GAS-FRAN-TAX   TO PRT-FRAN-TAX.                 
           MOVE WS-SCEG-RG-GAS-COUNT   TO PRT-COUNT.                    
           MOVE WS-SCEG-GAS-BILL-UNITS TO PRT-THERMS.                   
           MOVE WS-SCEG-GAS-READ-UNITS TO PRT-KWH.                      
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-SCEG                TO PRT-COMPANY.                  
           MOVE WS-GAS-DH              TO PRT-TYPE.                     
           MOVE ZEROS                  TO PRT-AMOUNT.                   
           MOVE ZEROS                  TO PRT-SALES-TAX.                
           MOVE ZEROS                  TO PRT-LOST-TAX.                 
           MOVE ZEROS                  TO PRT-FRAN-TAX.                 
           MOVE WS-SCEG-DH-GAS-COUNT   TO PRT-COUNT.                    
           MOVE WS-SCEG-DH-GAS-BILL    TO PRT-THERMS.                   
           MOVE WS-SCEG-DH-GAS-READ    TO PRT-KWH.                      
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
A04527*    DO SCEG GAS TOTAL                                                    
      *                                                                         
A04527     MOVE WS-SCEG                TO PRT-COMPANY.                  
A04527     MOVE WS-GAS-TOT             TO PRT-TYPE.                     
A04527     MOVE WS-SCEG-GAS-BILL-AMT   TO PRT-AMOUNT.                   
A04527     MOVE WS-SCEG-GAS-SALE-TAX   TO PRT-SALES-TAX.                
A04527     MOVE WS-SCEG-GAS-LOST-TAX   TO PRT-LOST-TAX.                 
A04527     MOVE WS-SCEG-GAS-FRAN-TAX   TO PRT-FRAN-TAX.                 
A04527     COMPUTE WS-TOTAL-COUNT =                                     
A04527             WS-SCEG-RG-GAS-COUNT + WS-SCEG-DH-GAS-COUNT.         
A04527     MOVE WS-TOTAL-COUNT         TO PRT-COUNT.                    
A04527     COMPUTE WS-TOTAL-BILL =                                      
A04527             WS-SCEG-GAS-BILL-UNITS + WS-SCEG-DH-GAS-BILL.        
A04527     MOVE WS-TOTAL-BILL          TO PRT-THERMS.                   
A04527     COMPUTE WS-TOTAL-READ =                                      
A04527             WS-SCEG-GAS-READ-UNITS + WS-SCEG-DH-GAS-READ.        
A04527     MOVE WS-TOTAL-READ          TO PRT-KWH.                      
A04527     MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
A04527     MOVE WS-TWO                 TO WS-LINE-SPACE.                
A04527     PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-PSNC                TO PRT-COMPANY.                  
           MOVE WS-GAS                 TO PRT-TYPE.                     
           MOVE WS-PSNC-GAS-BILL-AMT   TO PRT-AMOUNT.                   
           MOVE WS-PSNC-GAS-SALE-TAX   TO PRT-SALES-TAX.                
           MOVE WS-PSNC-GAS-LOST-TAX   TO PRT-LOST-TAX.                 
           MOVE WS-PSNC-GAS-FRAN-TAX   TO PRT-FRAN-TAX.                 
           MOVE WS-PSNC-RG-GAS-COUNT   TO PRT-COUNT.                    
           MOVE WS-PSNC-GAS-BILL-UNITS TO PRT-THERMS.                   
           MOVE WS-PSNC-GAS-READ-UNITS TO PRT-KWH.                      
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
           MOVE WS-PSNC                TO PRT-COMPANY.                  
           MOVE WS-GAS-DH              TO PRT-TYPE.                     
           MOVE ZEROS                  TO PRT-AMOUNT.                   
           MOVE ZEROS                  TO PRT-SALES-TAX.                
           MOVE ZEROS                  TO PRT-LOST-TAX.                 
           MOVE ZEROS                  TO PRT-FRAN-TAX.                 
           MOVE WS-PSNC-DH-GAS-COUNT   TO PRT-COUNT.                    
           MOVE WS-PSNC-DH-GAS-BILL    TO PRT-THERMS.                   
           MOVE WS-PSNC-DH-GAS-READ    TO PRT-KWH.                      
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
           PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
A04527*    DO PSNC GAS TOTAL                                                    
      *                                                                         
A04527     MOVE WS-PSNC                TO PRT-COMPANY.                  
A04527     MOVE WS-PSNC-TOT            TO PRT-TYPE.                     
A04527     MOVE WS-PSNC-GAS-BILL-AMT   TO PRT-AMOUNT.                   
A04527     MOVE WS-PSNC-GAS-SALE-TAX   TO PRT-SALES-TAX.                
A04527     MOVE WS-PSNC-GAS-LOST-TAX   TO PRT-LOST-TAX.                 
A04527     MOVE WS-PSNC-GAS-FRAN-TAX   TO PRT-FRAN-TAX.                 
A04527     COMPUTE WS-TOTAL-COUNT =                                     
A04527             WS-PSNC-RG-GAS-COUNT + WS-PSNC-DH-GAS-COUNT.         
A04527     MOVE WS-TOTAL-COUNT         TO PRT-COUNT.                    
A04527     COMPUTE WS-TOTAL-BILL =                                      
A04527             WS-PSNC-GAS-BILL-UNITS + WS-PSNC-DH-GAS-BILL.        
A04527     MOVE WS-TOTAL-BILL          TO PRT-THERMS.                   
A04527     COMPUTE WS-TOTAL-READ =                                      
A04527             WS-PSNC-GAS-READ-UNITS + WS-PSNC-DH-GAS-READ.        
A04527     MOVE WS-TOTAL-READ          TO PRT-KWH.                      
A04527     MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
A04527     MOVE WS-TWO                 TO WS-LINE-SPACE.                
A04527     PERFORM 8100-WRITE-PRINT-REC THRU 8100-EXIT.                 
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS DEAD_CSR FOR COUNT                                    *          
      ****************************************************************          
      *                                                                         
       7000-OPEN-DEADHEAD-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN DEAD_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7000-OPEN-DEADHEAD-CURSOR              *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH DEAD_CSR FOR COUNT                                    *          
      ****************************************************************          
      *                                                                         
       7001-FETCH-DEADHEAD-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH DEAD_CSR                                            
              INTO :RV-COMPANY-NO                                       
                  ,:RV-CODE-SERVICE-TYPE                                
                  ,:WS-CUST-CT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7001-FETCH-DEADHEAD-CURSOR             *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE DEAD_CSR FOR COUNT                                    *          
      ****************************************************************          
      *                                                                         
       7002-CLOSE-DEADHEAD-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE DEAD_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7002-CLOSE-DEADHEAD-CURSOR             *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS NONHD_CSR FOR COUNT                                   *          
      ****************************************************************          
      *                                                                         
       7010-OPEN-NONDEADHEAD-CURSOR.                                    
      *                                                                         
           EXEC SQL                                                     
              OPEN NONDH_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7010-OPEN-NONDEADHEAD-CURSOR           *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH NONDH_CSR FOR COUNT                                   *          
      ****************************************************************          
      *                                                                         
       7011-FETCH-NONDEADHEAD-CURSOR.                                   
      *                                                                         
           EXEC SQL                                                     
              FETCH NONDH_CSR                                           
              INTO :RV-COMPANY-NO                                       
                  ,:RV-CODE-SERVICE-TYPE                                
                  ,:WS-CUST-CT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7011-FETCH-NONDEADHEAD-CURSOR          *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE NONDH_CSR FOR COUNT                                   *          
      ****************************************************************          
      *                                                                         
       7012-CLOSE-NONDEADHEAD-CURSOR.                                   
      *                                                                         
           EXEC SQL                                                     
              CLOSE NONDH_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7012-CLOSE-NONDEADHEAD-CURSOR          *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7012-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS REVDEAD_CSR FOR CCF AND THERMS                        *          
      ****************************************************************          
      *                                                                         
       7020-OPEN-REVDEAD-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN REVDEAD_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7020-OPEN-REVDEAD-CURSOR               *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH REVDEAD_CSR FOR CCF AND THERMS                        *          
      ****************************************************************          
      *                                                                         
       7021-FETCH-REVDEAD-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH REVDEAD_CSR                                         
              INTO :RV-COMPANY-NO                                       
                  ,:RV-CODE-SERVICE-TYPE                                
                  ,:WS-BILL-USAGE-UNITS                                 
                  ,:WS-READ-UNITS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7021-FETCH-REVDEAD-CURSOR              *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7021-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE REVDEAD_CSR FOR CCF AND THERMS                        *          
      ****************************************************************          
      *                                                                         
       7022-CLOSE-REVDEAD-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE REVDEAD_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7022-CLOSE-REVDEAD-CURSOR              *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7022-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS REV_CSR FOR CCF AND THERMS AND REVENUE AMOUNT         *          
      ****************************************************************          
      *                                                                         
       7030-OPEN-REV-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN REV_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7030-OPEN-REV-CURSOR                   *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH REV_CSR FOR CCF AND THERMS AND REVENUE AMOUNT         *          
      ****************************************************************          
      *                                                                         
       7031-FETCH-REV-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH REV_CSR                                             
              INTO :RV-COMPANY-NO                                       
                  ,:RV-CODE-SERVICE-TYPE                                
                  ,:WS-BILLED-AMT                                       
                  ,:WS-BILL-USAGE-UNITS                                 
                  ,:WS-READ-UNITS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7031-FETCH-REV-CURSOR                  *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7031-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE REV_CSR FOR CCF AND THERMS AND REVENUE AMOUNT         *          
      ****************************************************************          
      *                                                                         
       7032-CLOSE-REV-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE REV_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7032-CLOSE-REV-CURSOR                  *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7032-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS TAX_CSR FOR ALL DIFFERENT TYPES OF TAXES              *          
      ****************************************************************          
      *                                                                         
       7040-OPEN-TAX-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN TAX_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7040-OPEN-TAX-CURSOR                   *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  FETCH TAX_CSR FOR ALL DIFFERENT TYPES OF TAXES              *          
      ****************************************************************          
      *                                                                         
       7041-FETCH-TAX-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH TAX_CSR                                             
              INTO :RV-COMPANY-NO                                       
                  ,:RV-CODE-SERVICE-TYPE                                
                  ,:R9-TAX-TYPE                                         
                  ,:WS-TAX-AMT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7041-FETCH-TAX-CURSOR                  *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7041-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSE TAX_CSR FOR ALL DIFFERENT TYPES OF TAXES              *          
      ****************************************************************          
      *                                                                         
       7042-CLOSE-TAX-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE TAX_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA668  ABORT ***************'     
               DISPLAY '* 7042-CLOSE-TAX-CURSOR                  *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA668  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7042-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET CURRENT DATE                                             *          
      ****************************************************************          
      *                                                                         
       7200-GET-CURRENT-DATE.                                           
      *                                                                         
            EXEC SQL                                                    
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE      = CURRENT DATE                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**  7200-GET-CURRENT-DATE              **'      
               DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'      
               DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE         
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET REVENUE MONTH USING PCSCA204 JOB PARM                 **          
      ****************************************************************          
      *                                                                         
       7400-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  PARM_DATA                                        
                 INTO  :G6-PARM-DATA                                    
               FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  CMND_CODE    = :G6-CMND-CODE                       
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                AND  SEQ_NO       = :G6-SEQ-NO                          
                AND  STATUS       = :G6-STATUS                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PARM_DATA                                                
MFA-TR*          INTO  :G6-PARM-DATA                                            
MFA-TR*        FROM  CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*         AND  SEQ_NO       = :G6-SEQ-NO                                  
MFA-TR*         AND  STATUS       = :G6-STATUS                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING REVENUE MONTH       **'       
              DISPLAY '**   FROM JOB PARM - PCSCA204          **'       
              DISPLAY '**7400-GET-REVENUE-MONTH               **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '**G6-PROGRAM-NAME = ' G6-PROGRAM-NAME            
              DISPLAY '**G6-CMND-CODE    = ' G6-CMND-CODE               
              DISPLAY '**G6-COMPANY-NO   = ' G6-COMPANY-NO              
              DISPLAY '**G6-SEQ-NO       = ' G6-SEQ-NO                  
              DISPLAY '**G6-STATUS       = ' G6-STATUS                  
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES A REPORT LINE FOR THE SUMMARY REPORT                  *          
      ****************************************************************          
      *                                                                         
       8100-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE FS-PRINT-REC AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING       **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **    NORMAL TERMINATION OF JOB                               **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE PRINTER1.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 9700-PROCESS-ABEND                             *          
      ****************************************************************          
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
