       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA667.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  OCTOBER 2013.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      * THIS PROGRAM READS THE "CIS LEDGER TRANSACTION FILE "        *          
      * PRODUCES "CIS LEDGER INTERFACE JOURNALS CREATED REPORT"      *          
      * ACCUMULATE DEBIT,CREDIT DETAILS AND PRINT THE "0134 CIS      *          
      * LEDGER JOURNALS SUMMARY BY ENTITY"                           *          
      * IT ALSO PRODUCES A OUTPUT IN FIOCA667 FORMAT                 *          
      ****************************************************************          
      *                                                                         
      ****************************************************************          
      ***             PROGRAM  MODIFICATION  LOG                   ***          
      **------------------------------------------------------------**          
      **  DATE        EMP-ID   REASON                               **          
      **  --------    -------  -------------------------------------**          
      *                                                              *          
      *   1 OCT 2013  RF10596  INITIAL VERSION (NEW CODE).           *          
      *                                                              *          
A04527*  12 FEB 2014  RF10596  CREATE A DEBIT/CREDIT LINE AND ADD    *          
A04527*                        A TABLE FOR A SUMMARY REPORT          *          
      *                                                              *          
A04880*  12 MAR 2014  RF10596  ADD NEGATIVE CASH-TRANS + TOTAL EG    *          
A04880*                        CREDITS FOR EG SUMMARY LINE.          *          
A04880*                        ADD POSITIVE CASH-TRANS + TOTAL EG    *          
A04880*                        DEBITS FOR EG SUMMARY LINE.           *          
      *                                                              *          
A04880*  16 MAY 2014  RF10596  ADD PSNC TO SUMMARY REPORT AND ADD    *          
A04880*                        PRINTER2 FOR THIS REPORT.             *          
      *                                                              *          
A05744*  14 FEB 2016  RF10596  CHANGE GA TO GN IN TABLE              *          
      *                                                              *          
A05744*  11 MAR 2016  RF10596  ADD GA BACK TO TABLE                  *          
      *                                                              *          
      ****************************************************************          
           REMARKS.                                                     
                    PCSCA667 NARRATIVE                                  
                   RE-WRITE OF DBS188                                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA667.                                                           
      *                                                                         
       COPY CSSCRR03.                                                           
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
A04880     SELECT PRINTER2 ASSIGN TO DA-PRINTER2.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA667.                                                           
       COPY FIOCA667.                                                           
      *                                                                         
       COPY CFDCRR03.                                                           
       COPY FIOCRR03.                                                           
      *                                                                         
       FD  PRINTER1                                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  PRT-REPORT.                                                  
           02  PRT-REPORT-CNTL         PIC X.                           
           02  PRT-REPORT-LINE         PIC X(132).                      
      *                                                                         
       FD  PRINTER2                                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  PRT2-REPORT.                                                 
           02  PRT2-REPORT-CNTL        PIC X.                           
           02  PRT2-REPORT-LINE        PIC X(132).                      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA667'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           03  WS-PRINT-FIELDS.                                         
               05  WS-PAGE-COUNT       PIC S9(3) VALUE +1  COMP-3.      
               05  WS-LINE-COUNT       PIC S9(3) VALUE +99 COMP-3.      
               05  WS-INPUT-REC-COUNT  PIC S9(6) VALUE +0  COMP-3.      
               05  WS-COUNTER          PIC 9(4)  VALUE 0.               
           03 WS-INPUT-ENTITY-FND      PIC X     VALUE 'N'.             
A04527     03 WS-SUMMARY-END           PIC X     VALUE 'N'.             
      *                                                                         
       01  WS-FLAG.                                                     
           03  WS-FCSCRR03-READ-STATUS PIC X VALUE SPACES.              
               88  FCSCRR03-NO-REC           VALUE 'N'.                 
               88  FCSCRR03-END              VALUE 'E'.                 
               88  FCSCRR03-STARTED          VALUE 'S'.                 
      *                                                                         
       01  WS-SYS-DATE.                                                 
           03  WS-SYS-DT-YY            PIC 99.                          
           03  WS-SYS-DT-MM            PIC 99.                          
           03  WS-SYS-DT-DD            PIC 99.                          
      *                                                                         
       01  WS-SYS-TIME.                                                 
           03  WS-SYS-TIME-HH          PIC 99.                          
           03  WS-SYS-TIME-MM          PIC 99.                          
           03  WS-SYS-TIME-SS          PIC 99.                          
           03  WS-SYS-TIME-TT          PIC 99.                          
      *                                                                         
       01  WS-HOLD-VARS.                                                
           03  WS-LST-DT-CUR-FISCAL-MON.                                
               05  WS-FISCAL-CC        PIC 99.                          
               05  WS-FISCAL-YY        PIC 99.                          
               05  WS-FISCAL-MM        PIC 99.                          
               05  WS-FISCAL-DD        PIC 99.                          
           03  WS-EFF-DATE.                                             
               05  WS-EFF-DATE-MM      PIC 99.                          
               05  FILLER              PIC X    VALUE '/'.              
               05  WS-EFF-DATE-DD      PIC 99.                          
               05  FILLER              PIC X    VALUE '/'.              
               05  WS-EFF-DATE-YY      PIC 99.                          
      *                                                                         
A04527 01  SUMMARY-TABLE.                                               
A04527     03 SUMM-DATA OCCURS 50 TIMES.                                
A04527        10  SUM-ENTITY          PIC X(5).                         
A04527        10  SUM-DEBIT           PIC S9(15)V99 COMP-3 VALUE +0.    
A04527        10  SUM-CREDIT          PIC S9(15)V99 COMP-3 VALUE +0.    
A04527        10  SUM-TOTAL           PIC S9(15)V99 COMP-3 VALUE +0.    
      *                                                                         
       01  CASH-TRAN-TABLE.                                             
           05 FILLER  PIC X(39)                                         
             VALUE 'FH    0000 0856 0002 1310901 EG    FADM'.           
           05 FILLER  PIC X(39)                                         
A05744       VALUE 'GN    0000 0986 0003 1310000 EG    FWMS'.           
A05744     05 FILLER  PIC X(39)                                         
A05744       VALUE 'GA    0000 0986 0007 1310903 EG    GADM'.           
           05 FILLER  PIC X(39)                                         
             VALUE 'IN    0000 0879 0006 1310904 EG    INAG'.           
           05 FILLER  PIC X(39)                                         
             VALUE 'NU    0000 0993 0005 1310901 EG    VCS '.           
           05 FILLER  PIC X(39)                                         
             VALUE 'RE    0000 0365 0008 1310902 EG    RADM'.           
           05 FILLER  PIC X(39)                                         
             VALUE 'SC    1006 0984 0011 1310100 EG    SCAN'.           
           05 FILLER  PIC X(39)                                         
             VALUE 'SVCI  1006 1006 0026 1310800 EG    SAPP'.           
           05 FILLER  PIC X(39)                                         
             VALUE 'TR    0000 0358 0009 1310902 EG    COLA'.           
           05 FILLER  PIC X(39)                                         
             VALUE '99999 9999 9999 9999 9999999 99999 9999'.           
       01  CASH-TRAN-TAB REDEFINES CASH-TRAN-TABLE.                     
           05 CASH-INFO OCCURS 20 TIMES.                                
              10  TAB-ENTITY             PIC X(5).                      
              10  FILLER                 PIC X.                         
              10  TAB-COST-CNTR          PIC X(4).                      
              10  FILLER                 PIC X.                         
              10  TAB-REV-ADMI           PIC X(4).                      
              10  FILLER                 PIC X.                         
              10  TAB-NON-REV-ADMI       PIC X(4).                      
              10  FILLER                 PIC X.                         
              10  TAB-GL-ACCT            PIC X(7).                      
              10  FILLER                 PIC X.                         
              10  TAB-CASH-TRAN-ENTITY   PIC X(5).                      
              10  FILLER                 PIC X.                         
              10  TAB-DIVISION           PIC X(4).                      
      *                                                                         
       01  WS-WORK-AMOUNT9             PIC 9(14)V99 VALUE 0.            
       01  WS-WORK-AMOUNTX REDEFINES WS-WORK-AMOUNT9   PIC 9(16).       
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
           03  WS-WORK-AMOUNT          PIC 9(16) VALUE ZEROS.           
           03  WS-FCS003-STATUS        PIC XX    VALUE SPACES.          
           03  WS-FCA667-STATUS        PIC XX    VALUE SPACES.          
           03  WS-COMMA                PIC X     VALUE ','.             
           03  WS-TABLE-SW             PIC X     VALUE 'N'.             
A04880     03  WS-CT-CREDIT            PIC S9(15)V99 COMP-3 VALUE +0.   
A04880     03  WS-CT-DEBIT             PIC S9(15)V99 COMP-3 VALUE +0.   
A04527     03  WS-WORK-SUM             PIC S9(15)V99 COMP-3 VALUE +0.   
A04527     03  WS-DIFF-SUM             PIC S9(15)V99 COMP-3 VALUE +0.   
A04527     03  SUM-SUB                 PIC S9(3) COMP-3 VALUE ZERO.     
A04527     03  WS-50                   PIC S9(3) COMP-3 VALUE +50.      
           03  TABLE-SUB               PIC S9(3) COMP-3 VALUE ZERO.     
           03  SAVE-SUB                PIC S9(3) COMP-3 VALUE ZERO.     
           03  END-OF-TABLE            PIC 9(5)  VALUE 99999.           
           03  WS-COMPANY-SW           PIC X(4)  VALUE SPACES.          
           03  WS-SCEG                 PIC X(4)  VALUE 'SCEG'.          
A04880     03  WS-PSNC                 PIC X(5)  VALUE 'PSNC '.         
A04880     03  WS-SEGA                 PIC X(5)  VALUE 'SEGA '.         
A04880     03  WS-SERG                 PIC X(5)  VALUE 'SERG '.         
           03  WS-ACTUAL               PIC X(6)  VALUE 'ACTUAL'.        
           03  WS-QUANTITY             PIC X(12) VALUE '0000000.0000'.  
           03  WS-LDREN                PIC X(5)  VALUE 'LDREN'.         
           03  WS-JRNL-ID              PIC X(12) VALUE '0134 CIS REV'.  
           03  WS-HDR-ID               PIC X(8)  VALUE ' JRNL-ID'.      
           03  WS-NEG                  PIC X     VALUE '-'.             
           03  WS-POS                  PIC X     VALUE '+'.             
           03  WS-C                    PIC X     VALUE 'C'.             
           03  WS-D                    PIC X     VALUE 'D'.             
A04527     03  WS-Y                    PIC X     VALUE 'Y'.             
           03  WS-PREV-COMPANY-NO      PIC XX    VALUE SPACES.          
           03  WS-PREV-ENTITY          PIC X(5)  VALUE SPACES.          
           03  WS-EG                   PIC X(5)  VALUE 'EG'.            
           03  WS-CT-DIVISION          PIC X(4)  VALUE 'EGCO'.          
           03  WS-CT-ACTIVITY          PIC X(4)  VALUE 'ACJV'.          
           03  WS-CT-COST-CENTER       PIC X(4)  VALUE '0001'.          
           03  WS-CT-RESOURCE          PIC X(3)  VALUE '916'.           
      *                                                                         
           03  WS-PRE-ENTITY           PIC X(5).                        
           03  WS-PRE-COST-CNTR        PIC X(4).                        
           03  WS-PRE-REV-ADMN         PIC X(4).                        
           03  WS-PRE-NON-REV-ADMN     PIC X(4).                        
           03  WS-PRE-GL-ACCT          PIC X(7).                        
           03  WS-PRE-CASH-ENTITY      PIC X(5).                        
           03  WS-PRE-DIVISION         PIC X(4).                        
      *                                                                         
           03  WS-ENTITY-TOTAL         PIC S9(15)V99 COMP-3 VALUE +0.   
           03  WS-CASHTRAN-TOTAL       PIC S9(15)V99 COMP-3 VALUE +0.   
           03  WS-INPUT-ENTITY         PIC X(5).                        
      *                                                                         
           03  WS-DATABASE             PIC 9  VALUE ZERO.               
               88  CSR-DATABASE               VALUE 1.                  
               88  SEB-DATABASE               VALUE 2.                  
      *                                                                         
       01 WS-EFFECTIVE-DATE.                                            
          03  WS-EFF-CENTURY           PIC 99.                          
          03  WS-EFF-YEAR              PIC 99.                          
          03  WS-EFF-MONTH             PIC 99.                          
          03  WS-EFF-DAY               PIC 99.                          
      *                                                                         
       01 WS-FIO667-DATE.                                               
          03  WS-FIO667-MONTH          PIC 99.                          
          03  FILLER                   PIC X VALUE '/'.                 
          03  WS-FIO667-DAY            PIC 99.                          
          03  FILLER                   PIC X VALUE '/'.                 
          03  WS-FIO667-YEAR           PIC 99.                          
      *                                                                         
       01  WS-ENTITY-TOTALS.                                            
           03  WS-CREDIT-ENTITY-TOT     PIC S9(15)V99 COMP-3 VALUE +0.  
           03  WS-DEBIT-ENTITY-TOT      PIC S9(15)V99 COMP-3 VALUE +0.  
      *                                                                         
       01  WS-REPORT-PAGE-CONTROLS.                                     
           03  WS-PRT-REPORT-LINE-SPACE      PIC 9.                     
           03  WS-PRT-REPORT-LINE-COUNT      PIC 99 VALUE 0.            
               88  REPORT-PAGE-OVERFLOW         VALUE 57 THRU 99.       
               88  REPORT-NEW-PAGE              VALUE 0.                
               88  REPORT-FIRST-LINE            VALUE 1.                
      *                                                                         
       01 WS-ENTITY-BREAK-CONTROL.                                      
            03  WS-ENTITY-BREAK               PIC X  VALUE 'Y'.         
                88  FIRST-TIME-IN-ENT-BRK            VALUE 'Y'.         
                88  NOT-FIRST-TIME-IN-ENT-BRK        VALUE 'N'.         
      *                                                                         
       01 WS-ENTITY-CONTROL.                                            
            03  WS-FIRST-ENTITY-CONTROL       PIC X  VALUE 'Y'.         
                88  ENTITY-FIRST-TIME-IN             VALUE 'Y'.         
                88  ENTITY-NOT-FIRST-TIME-IN         VALUE 'N'.         
      *                                                                         
       01 WS-CASH-CONTROL.                                              
            03  WS-FIRST-CASH-CONTROL         PIC X  VALUE 'Y'.         
                88  CASH-FIRST-TIME-IN               VALUE 'Y'.         
                88  CASH-NOT-FIRST-TIME-IN           VALUE 'N'.         
      *                                                                         
       01  WS-ABND-MSG-REC.                                             
           03  WS-ABND-DESC-MSG.                                        
               05  FILLER                     PIC X(10) VALUE           
                   '*** ABND: '.                                        
               05  WS-ABND-MSG                PIC X(45) VALUE SPACES.   
               05  FILLER                     PIC X     VALUE SPACES.   
           03  WS-ABND-DIAG-MSG.                                        
               05  WS-ABND-DIAG-MSG-PARA-ID.                            
                   07  FILLER                 PIC X(13) VALUE           
                       '*** PARA ID: '.                                 
                   07  WS-ABND-PARA-ID        PIC X(6)  VALUE SPACES.   
                   07  FILLER                 PIC X     VALUE SPACES.   
               05  WS-ABND-DIAG-MSG-CD        PIC X(30) VALUE SPACES.   
      *                                                                         
        01  WS-ABND-DIAG-MSG-FILE-ST.                                   
            03  FILLER                        PIC X(4)  VALUE '*** '.   
            03  FILLER                        PIC X(14) VALUE           
                'FILE STATUS : '.                                       
            03  WS-ABND-FILE-ST               PIC XX    VALUE SPACES.   
                                                                        
            03  WS-ERR-STATUS-RET-CTL         PIC X     VALUE 'N'.      
                88  NO-RECORD-IN-ERROR                  VALUE 'N'.      
                88  SOME-RECORDS-IN-ERROR               VALUE 'Y'.      
      *                                                                         
       01  WS-PROCESS-END-MSG.                                          
           03  WS-PROCESS-END-MSG-GOOD.                                 
               05  FILLER                   PIC X(51) VALUE             
                   '***** PCSCA667 ENDED SUCCESSFULLY'.                 
           03  WS-PROCESS-END-MSG-NO-REC.                               
               05  FILLER                   PIC X(51) VALUE             
                   '***** PCSCA667 ENDED :: NO RECORD TO PROCESS'.      
           03  WS-PROCESS-END-MSG-ERROR.                                
               05  FILLER                   PIC X(51) VALUE             
                   '***** PCSCA667 ENDED :: SOME RECORDS IN ERROR'.     
      *                                                                         
       01  WS-HRZN-LINE-132                 PIC X(132) VALUE ALL '='.   
      *                                                                         
       01  WS-HRZN-LINE-SPACE               PIC X(132) VALUE ALL ' '.   
      *                                                                         
A04527 01    WS-7027-ENTITY-TABLE.                                      
A04527       03  WS-7027-ENTITY-FOUND-TABLE OCCURS 50 TIMES             
A04527                 INDEXED BY INDEX-7027.                           
A04527           05  WS-7027-ENTITY               PIC X(5).             
A04527           05  WS-7027-COST-CENTER          PIC X(4).             
A04527           05  WS-7027-REV-ADMN-CC          PIC X(4).             
A04527           05  WS-7027-NON-REV-ADMN-CC      PIC X(4).             
A04527           05  WS-7027-CIS-CASH-ACCT        PIC X(7).             
A04527           05  WS-7027-CIS-CASH-TRAN-ENTITY PIC X(5).             
      *                                                                         
      ****************************************************************          
      * REPORT1 HEADER RECORD                                        *          
      ****************************************************************          
      *                                                                         
A04527 01  WS-SUMMARY-HEADER1.                                          
A04527     03  FILLER                  PIC X(7)  VALUE 'SUMMARY'.       
A04527     03  FILLER                  PIC X(6)  VALUE SPACES.          
A04527     03  FILLER                  PIC X(6)  VALUE 'ENTITY'.        
A04527     03  FILLER                  PIC X(20) VALUE SPACES.          
A04527     03  FILLER                  PIC X(5)  VALUE 'DEBIT'.         
A04527     03  FILLER                  PIC X(21) VALUE SPACES.          
A04527     03  FILLER                  PIC X(6)  VALUE 'CREDIT'.        
A04527     03  FILLER                  PIC X(19) VALUE SPACES.          
A04527     03  FILLER                  PIC X(10) VALUE 'DIFFERENCE'.    
A04527     03  FILLER                  PIC X(32) VALUE SPACES.          
      *                                                                         
       01  WS-REPORT-HEADER1.                                           
           03  WS-REPORT-NAME          PIC X(8)  VALUE 'PCSCA667'.      
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(10) VALUE 'COMPANY = '.    
           03  WS-COMPANY-NO           PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(22) VALUE SPACES.          
           03  FILLER                  PIC X(34) VALUE                  
               'SCANA  CORPORATION  AND  COMPANIES'.                    
           03  FILLER                  PIC X(35) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'PAGE : '.       
           03  WS-PAGE-NUMBER          PIC Z,ZZ9.                       
      *                                                                         
       01  WS-REPORT-HEADER2.                                           
           03  FILLER                  PIC X(38) VALUE SPACES.          
           03  FILLER                  PIC X(53) VALUE                  
           '0134 CIS REV LEDGER INTERFACE JOURNALS CREATED REPORT'.     
           03  FILLER                  PIC X(24) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'DATE : '.       
           03  WS-REPORT-DATE.                                          
               05  WS-REPORT-MM        PIC 99.                          
               05  FILLER              PIC X     VALUE '/'.             
               05  WS-REPORT-DD        PIC 99.                          
               05  FILLER              PIC X     VALUE '/'.             
               05  WS-REPORT-YY        PIC 9(4).                        
      *                                                                         
       01  WS-REPORT-HEADER2B.                                          
           03  FILLER                  PIC X(55) VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'REVENUE MONTH'. 
           03  FILLER                  PIC X     VALUE SPACES.          
           03  REVENUE-DATE1.                                           
               05 WS-REV-REPORT-MM     PIC 99.                          
               05 WS-REV-REPORT-DELIM  PIC X    VALUE '/'.              
               05 WS-REV-REPORT-YY     PIC 9(4).                        
           03  FILLER                  PIC X(41) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'TIME : '.       
           03  WS-REPORT-TIME.                                          
               05  WS-REPORT-HH        PIC 99.                          
               05  FILLER              PIC X     VALUE ':'.             
               05  WS-REPORT-MI        PIC 99.                          
               05  FILLER              PIC X     VALUE ':'.             
               05  WS-REPORT-SS        PIC 99.                          
      *                                                                         
       01  WS-REPORT-HEADER3.                                           
           03  FILLER                  PIC X(5)  VALUE '<----' .        
           03  FILLER                  PIC X(31)                        
               VALUE '-------------------------------'   .              
           03  FILLER                  PIC X(7)  VALUE 'U D A K'.       
           03  FILLER                  PIC X(31)                        
               VALUE '-------------------------------' .                
           03  FILLER                  PIC X(3)  VALUE '-->' .          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'LOCN'.          
           03  FILLER                  PIC X(43) VALUE SPACES.          
      *                                                                         
       01  WS-REPORT-HEADER4.                                           
           03  FILLER                  PIC X(6)  VALUE 'ENTITY'.        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE 'DIV'.           
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC XX    VALUE 'CC'.            
           03  FILLER                  PIC X(9)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'ACCT'.          
           03  FILLER                  PIC X(9)  VALUE SPACES.          
           03  FILLER                  PIC XX    VALUE 'WO'.            
           03  FILLER                  PIC X(7)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'RSRC'.          
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'ACTY'.          
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'CUST'.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'CODE'.          
           03  FILLER                  PIC X(15) VALUE SPACES.          
A04527     03  FILLER                  PIC X(7)  VALUE 'TAX DEB'.       
           03  FILLER                  PIC X(3)  VALUE SPACES.          
A04527     03  FILLER                  PIC X(7)  VALUE 'TAX CRD'.       
      *                                                                         
       01  PRT-DETAIL-LINE.                                             
           03  PRT-ENTITY              PIC X(5).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-DIVISION            PIC X(4).                        
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-COST-CENTER         PIC X(4).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-GL-ACCT             PIC X(7).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-WORK-ORDER          PIC X(6).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-RSRC                PIC X(3).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-ACTIVITY            PIC X(4).                        
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-CUSTOMER            PIC X(3).                        
A04527     03  PRT-HONK                PIC X(11) VALUE SPACES.          
A04527     03  PRT-HONK2 REDEFINES PRT-HONK.                            
A04527         05  FILLER              PIC X(6).                        
A04527         05  PRT-LOCATION-CODE   PIC X(4).                        
A04527         05  FILLER              PIC X(1).                        
A04527     03  PRT-CLEAR-DEB           PIC X(21).                       
A04527     03  PRT-GL-DEB-AMT REDEFINES PRT-CLEAR-DEB                   
A04527                                 PIC Z,ZZZ,ZZZ,ZZZ,ZZZ.ZZ-.       
A04527     03  FILLER                  PIC XX    VALUE SPACES.          
A04527     03  PRT-REMARKS             PIC X(21).                       
A04527     03  PRT-GL-CRD-AMT REDEFINES PRT-REMARKS                     
A04527                                 PIC Z,ZZZ,ZZZ,ZZZ,ZZZ.ZZ-.       
           03  FILLER                  PIC X     VALUE SPACES.          
      *                                                                         
A04527 01  PRT-SUMMARY-LINE.                                            
A04527     03  FILLER                  PIC X(14) VALUE SPACES.          
A04527     03  PRT-SUM-ENTITY          PIC X(5).                        
A04527     03  FILLER                  PIC X(7)  VALUE SPACES.          
A04527     03  PRT-SUM-DEBITX          PIC X(21).                       
A04527     03  PRT-SUM-DEBIT  REDEFINES PRT-SUM-DEBITX                  
A04527                                 PIC Z,ZZZ,ZZZ,ZZZ,ZZ9.99-.       
A04527     03  FILLER                  PIC X(7)  VALUE SPACES.          
A04527     03  PRT-SUM-CREDITX         PIC X(21).                       
A04527     03  PRT-SUM-CREDIT REDEFINES PRT-SUM-CREDITX                 
A04527                                 PIC Z,ZZZ,ZZZ,ZZZ,ZZ9.99-.       
A04527     03  FILLER                  PIC X(7)  VALUE SPACES.          
A04527     03  PRT-SUM-DIFFX           PIC X(21).                       
A04527     03  PRT-SUM-DIFF   REDEFINES PRT-SUM-DIFFX                   
A04527                                 PIC Z,ZZZ,ZZZ,ZZZ,ZZ9.99-.       
A04527     03  FILLER                  PIC X(29) VALUE SPACES.          
      *                                                                         
       01  PRT-END-LINE.                                                
           03  FILLER                 PIC X(13) VALUE 'END OF REPORT'.  
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_DELINQUENCY                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                   UNTIL FCSCRR03-END.                                  
      *                                                                         
           IF CSR-DATABASE                                              
              IF WS-COMPANY-SW = WS-SCEG                                
                 PERFORM 3000-LAST-ENTITY THRU 3000-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
A04880     ADD WS-DEBIT-ENTITY-TOT WS-CREDIT-ENTITY-TOT                 
A04880            GIVING WS-ENTITY-TOTAL.                               
A04880     ADD +1 TO SUM-SUB.                                           
A04880     IF CSR-DATABASE                                              
A04880        MOVE WS-PSNC TO SUM-ENTITY(SUM-SUB)                       
A04880     ELSE                                                         
A04880        MOVE WS-SERG TO SUM-ENTITY(SUM-SUB)                       
A04880     END-IF.                                                      
A04880     MOVE WS-DEBIT-ENTITY-TOT  TO SUM-DEBIT(SUM-SUB).             
A04880     MOVE WS-CREDIT-ENTITY-TOT TO SUM-CREDIT(SUM-SUB).            
A04880     MOVE WS-ENTITY-TOTAL      TO SUM-TOTAL(SUM-SUB).             
      *                                                                         
A04527     PERFORM 2300-SUMMARY-PAGE THRU 2300-EXIT.                    
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  WRITE THE FIRST RECORD ON THE OUTPUT FILE                 **          
      ****************************************************************          
      *                                                                         
       0300-WRITE-FIRST-RECORD.                                         
      *                                                                         
           INITIALIZE FIOCA667.                                         
      *                                                                         
           MOVE WS-LDREN   TO FIO667-LDR-ENTITY.                        
           MOVE WS-HDR-ID TO FIO667-JRNL-ID.                            
           MOVE DBSE-EFFECTIVE-DATE TO WS-EFFECTIVE-DATE.               
           MOVE WS-EFF-YEAR         TO WS-FIO667-YEAR.                  
           MOVE WS-EFF-MONTH        TO WS-FIO667-MONTH.                 
           MOVE WS-EFF-DAY          TO WS-FIO667-DAY.                   
           MOVE WS-FIO667-DATE      TO FIO667-EFF-DATE.                 
           MOVE SPACES              TO FIO667-HONK-SPACES.              
           MOVE WS-COMMA TO FIO667-TAB1                                 
                            FIO667-TAB2                                 
                            FIO667-TAB3                                 
                            FIO667-TAB4                                 
                            FIO667-TAB5                                 
                            FIO667-TAB6                                 
                            FIO667-TAB7                                 
                            FIO667-TAB8                                 
                            FIO667-TAB9                                 
                            FIO667-TAB10                                
                            FIO667-TAB11                                
                            FIO667-TAB12                                
                            FIO667-TAB13                                
                            FIO667-TAB14                                
                            FIO667-TAB15                                
                            FIO667-TAB16                                
                            FIO667-TAB17                                
                            FIO667-TAB18                                
                            FIO667-TAB19                                
                            FIO667-TAB20                                
                            FIO667-TAB21                                
                            FIO667-TAB22.                               
      *                                                                         
           PERFORM 3600-WRITE-FIOCA667 THRU 3600-EXIT.                  
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
      ****************************************************************          
      * FOLLOWING IS THE INITIALIZATION PROCESS TO OPEN FILES FOR    *          
      * INPUT AND OUTPUT, TO GET THE SYSTEM TIME AND DATE FOR CONTROL*          
      * REPORTS                                                      *          
      ****************************************************************          
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 0300-WRITE-FIRST-RECORD THRU 0300-EXIT.              
      *                                                                         
           PERFORM 1200-GET-DATE-TIME THRU 1200-EXIT.                   
      *                                                                         
           MOVE ZERO TO WS-DATABASE.                                    
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7350-GET-DELINQUENCY THRU 7350-EXIT.                 
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
      *                                                                         
           PERFORM 3100-READ-FCSCRR03-FILE THRU 3100-EXIT.              
      *                                                                         
           IF CSR-DATABASE                                              
              IF DBSE-COMPANY-CODE = '01'                               
                 MOVE WS-SCEG TO WS-COMPANY-SW                          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE DBSE-EFFECTIVE-YEAR TO WS-REV-REPORT-YY.                
      *                                                                         
           MOVE DBSE-EFFECTIVE-MONTH TO WS-REV-REPORT-MM.               
      *                                                                         
           MOVE DBSE-BUSINESS-UNIT TO WS-PREV-ENTITY.                   
           MOVE DBSE-COMPANY-CODE TO WS-COMPANY-NO                      
                                     WS-PREV-COMPANY-NO.                
      *                                                                         
A04527     INITIALIZE SUMMARY-TABLE.                                    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS OPENS ALL INPUT AND OUTPUT FILES.               *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT FCSCRR03-FILE.                                    
           OPEN OUTPUT FCSCA667-FILE                                    
                       PRINTER1                                         
                       PRINTER2.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS ACCEPTS RUNDATE FROM SYSTEM DATE AND MOVES DATE *          
      * TO THE CONTROL REPORT HEADER.                                *          
      * THIS PROCESS GETS SYSTEM TIME TO SHOW ON CONTROL REPORT.     *          
      ****************************************************************          
      *                                                                         
       1200-GET-DATE-TIME.                                              
      *                                                                         
           ACCEPT WS-SYS-DATE FROM DATE.                                
      *                                                                         
           MOVE WS-SYS-DT-MM TO WS-REPORT-MM.                           
           MOVE WS-SYS-DT-DD TO WS-REPORT-DD.                           
           MOVE WS-SYS-DT-YY TO WS-REPORT-YY.                           
      *                                                                         
           ACCEPT WS-SYS-TIME FROM TIME.                                
      *                                                                         
           MOVE WS-SYS-TIME-HH TO WS-REPORT-HH.                         
           MOVE WS-SYS-TIME-MM TO WS-REPORT-MI.                         
           MOVE WS-SYS-TIME-SS TO WS-REPORT-SS.                         
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CHECKS TO SEE IF ENTITY IS ONE THAT NEEDS TO CREATE A        *          
      * 'CASHTRAN' ROW.                                              *          
      ****************************************************************          
      *                                                                         
       1400-HARD-CODED-7027.                                            
      *                                                                         
           MOVE 'N' TO WS-TABLE-SW.                                     
           MOVE ZERO TO SAVE-SUB.                                       
           PERFORM VARYING TABLE-SUB FROM 1 BY 1 UNTIL                  
SCA006        WS-TABLE-SW = 'Y' OR 
              TAB-ENTITY (TABLE-SUB) = END-OF-TABLE                             
              IF DBSE-BUSINESS-UNIT = TAB-ENTITY (TABLE-SUB)            
                 MOVE 'Y' TO WS-TABLE-SW                                
                 MOVE TABLE-SUB TO SAVE-SUB                             
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF WS-TABLE-SW = 'Y'                                         
             MOVE TAB-ENTITY(SAVE-SUB)           TO WS-PRE-ENTITY       
             MOVE TAB-COST-CNTR(SAVE-SUB)        TO WS-PRE-COST-CNTR    
             MOVE TAB-REV-ADMI(SAVE-SUB)         TO WS-PRE-REV-ADMN     
             MOVE TAB-NON-REV-ADMI(SAVE-SUB)     TO WS-PRE-NON-REV-ADMN 
             MOVE TAB-GL-ACCT(SAVE-SUB)          TO WS-PRE-GL-ACCT      
             MOVE TAB-CASH-TRAN-ENTITY(SAVE-SUB) TO WS-PRE-CASH-ENTITY  
             MOVE TAB-DIVISION(SAVE-SUB)         TO WS-PRE-DIVISION     
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * MAIN PROCESS, CHECKS FOR ENTITY BREAK                        *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           PERFORM 2100-PROCESS-ENTITY THRU 2100-EXIT.                  
      *                                                                         
           PERFORM 3100-READ-FCSCRR03-FILE THRU 3100-EXIT.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS ENTITY - ON BREAK DO TOTALS AND PROCESS CURRENT      *          
      ****************************************************************          
      *                                                                         
       2100-PROCESS-ENTITY.                                             
      *                                                                         
           IF DBSE-BUSINESS-UNIT = WS-PREV-ENTITY                       
              IF WS-TABLE-SW = 'N'                                      
                 PERFORM 1400-HARD-CODED-7027 THRU 1400-EXIT            
              END-IF                                                    
      *                                                                         
A04527        IF DBSE-CONTROL-AMOUNT < ZEROES                           
A04527           ADD DBSE-CONTROL-AMOUNT TO WS-CREDIT-ENTITY-TOT        
A04527        ELSE                                                      
A04527           ADD DBSE-CONTROL-AMOUNT TO WS-DEBIT-ENTITY-TOT         
A04527        END-IF                                                    
      *                                                                         
              PERFORM 2200-PROCESS-CURRENT-RECORD THRU 2200-EXIT        
           ELSE                                                         
              IF CSR-DATABASE                                           
                 IF WS-COMPANY-SW = WS-SCEG                             
                    PERFORM 2110-PROCESS-ENTITY-TOTALS THRU 2110-EXIT   
                 END-IF                                                 
              ELSE                                                      
                 MOVE +88 TO WS-LINE-COUNT                              
H04880           ADD WS-DEBIT-ENTITY-TOT WS-CREDIT-ENTITY-TOT           
H04880                 GIVING WS-ENTITY-TOTAL                           
H04880           ADD +1 TO SUM-SUB                                      
H04880           MOVE WS-SEGA              TO SUM-ENTITY(SUM-SUB)       
H04880           MOVE WS-DEBIT-ENTITY-TOT  TO SUM-DEBIT(SUM-SUB)        
H04880           MOVE WS-CREDIT-ENTITY-TOT TO SUM-CREDIT(SUM-SUB)       
H04880           MOVE WS-ENTITY-TOTAL      TO SUM-TOTAL(SUM-SUB)        
              END-IF                                                    
      *                                                                         
              INITIALIZE WS-CREDIT-ENTITY-TOT                           
                         WS-DEBIT-ENTITY-TOT                            
      *                                                                         
A04527        IF DBSE-CONTROL-AMOUNT < ZEROES                           
A04527           ADD DBSE-CONTROL-AMOUNT TO WS-CREDIT-ENTITY-TOT        
A04527        ELSE                                                      
A04527           ADD DBSE-CONTROL-AMOUNT TO WS-DEBIT-ENTITY-TOT         
A04527        END-IF                                                    
      *                                                                         
              MOVE DBSE-BUSINESS-UNIT TO WS-PREV-ENTITY                 
              PERFORM 1400-HARD-CODED-7027 THRU 1400-EXIT               
              PERFORM 2200-PROCESS-CURRENT-RECORD THRU 2200-EXIT        
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS ENTITY TOTALS                                        *          
      ****************************************************************          
      *                                                                         
       2110-PROCESS-ENTITY-TOTALS.                                      
      *                                                                         
           ADD WS-DEBIT-ENTITY-TOT WS-CREDIT-ENTITY-TOT                 
                  GIVING WS-ENTITY-TOTAL.                               
           IF WS-PREV-ENTITY = WS-EG                                    
      *                                                                         
A04527        MOVE SPACES TO PRT-DETAIL-LINE                            
A04527        MOVE WS-EG  TO PRT-ENTITY                                 
A04527        MOVE WS-DEBIT-ENTITY-TOT TO PRT-GL-DEB-AMT                
A04527        MOVE WS-CREDIT-ENTITY-TOT TO PRT-GL-CRD-AMT               
A04527        MOVE 'DEB/CRD TOT'  TO PRT-HONK                           
A04527        PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
      *                                                                         
A04527        ADD +1 TO SUM-SUB                                         
A04527        MOVE WS-EG                TO SUM-ENTITY(SUM-SUB)          
A04527        MOVE WS-DEBIT-ENTITY-TOT  TO SUM-DEBIT(SUM-SUB)           
A04527        MOVE WS-CREDIT-ENTITY-TOT TO SUM-CREDIT(SUM-SUB)          
A04527        MOVE WS-ENTITY-TOTAL      TO SUM-TOTAL(SUM-SUB)           
      *                                                                         
              MOVE SPACES TO PRT-DETAIL-LINE                            
              MOVE WS-EG  TO PRT-ENTITY                                 
A04527        MOVE WS-ENTITY-TOTAL TO PRT-GL-DEB-AMT                    
A04527        MOVE 'TOTAL FOR ENTITY' TO PRT-REMARKS                    
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
              MOVE SPACES TO PRT-DETAIL-LINE                            
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
           ELSE                                                         
      *  PRINT 1ST TOTAL LINE - EG                                              
      *                                                                         
A04527        MOVE SPACES TO PRT-DETAIL-LINE                            
A04527        MOVE WS-PRE-CASH-ENTITY  TO PRT-ENTITY                    
A04527        MOVE WS-DEBIT-ENTITY-TOT TO PRT-GL-DEB-AMT                
A04527        MOVE WS-CREDIT-ENTITY-TOT TO PRT-GL-CRD-AMT               
A04527        MOVE 'DEB/CRD TOT'  TO PRT-HONK                           
A04527        PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
      *                                                                         
A04527        ADD +1 TO SUM-SUB                                         
A04527        MOVE WS-PRE-ENTITY        TO SUM-ENTITY(SUM-SUB)          
A04527        MOVE WS-DEBIT-ENTITY-TOT  TO SUM-DEBIT(SUM-SUB)           
A04527        MOVE WS-CREDIT-ENTITY-TOT TO SUM-CREDIT(SUM-SUB)          
A04527        MOVE WS-ENTITY-TOTAL      TO SUM-TOTAL(SUM-SUB)           
      *                                                                         
A04880        IF WS-ENTITY-TOTAL <= 0                                   
A04880          ADD WS-ENTITY-TOTAL TO WS-CT-CREDIT                     
A04880        ELSE                                                      
A04880          ADD WS-ENTITY-TOTAL TO WS-CT-DEBIT                      
A04880        END-IF                                                    
      *                                                                         
              MOVE SPACES TO PRT-DETAIL-LINE                            
              MOVE WS-ENTITY-TOTAL      TO PRT-GL-DEB-AMT               
              MOVE WS-PRE-CASH-ENTITY   TO PRT-ENTITY                   
              MOVE WS-CT-RESOURCE       TO PRT-RSRC                     
              MOVE WS-CT-ACTIVITY       TO PRT-ACTIVITY                 
              MOVE WS-CT-COST-CENTER    TO PRT-COST-CENTER              
              MOVE WS-PRE-GL-ACCT       TO PRT-GL-ACCT                  
              MOVE WS-CT-DIVISION       TO PRT-DIVISION                 
              MOVE 'CASH-TRAN FOR ENTITY' TO PRT-REMARKS                
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
              MOVE SPACES TO PRT-DETAIL-LINE                            
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
      *                                                                         
      *  CREATE 1ST OUTPUT RECORD - CASHTRAN - EG                               
      *                                                                         
              MOVE WS-ENTITY-TOTAL        TO FIO667-REV-AMOUNT          
              MOVE SPACES TO FIO667-SIGN                                
      *                                                                         
              IF WS-ENTITY-TOTAL < 0                                    
                 MOVE WS-NEG TO FIO667-SIGN                             
                 MOVE WS-C   TO FIO667-DR-CR-CODE                       
              ELSE                                                      
                 MOVE WS-D   TO FIO667-DR-CR-CODE                       
              END-IF                                                    
      *                                                                         
              MOVE WS-PRE-CASH-ENTITY     TO FIO667-LDR-ENTITY          
                                             FIO667-LINE-LDR-ENTITY     
              MOVE WS-CT-RESOURCE         TO FIO667-RESOURCE            
              MOVE WS-CT-ACTIVITY         TO FIO667-ACTIVITY            
              MOVE WS-CT-COST-CENTER      TO FIO667-COST-CENTER         
              MOVE WS-PRE-GL-ACCT         TO FIO667-GL-ACCOUNT          
              MOVE WS-CT-DIVISION         TO FIO667-DIVISION            
              MOVE SPACES                 TO FIO667-LOCATION            
              MOVE 'CASHTRAN'             TO FIO667-REFERENCE           
              PERFORM 2220-CASHTRAN-FIOCRR03-REC THRU 2220-EXIT         
      *                                                                         
      *  PRINT 2ND TOTAL LINE - CASH TRAN (FH-GA-SVCI,ETC)                      
      *                                                                         
              MOVE SPACES TO PRT-DETAIL-LINE                            
              MULTIPLY WS-ENTITY-TOTAL BY -1                            
                          GIVING WS-CASHTRAN-TOTAL                      
              MOVE WS-CASHTRAN-TOTAL      TO PRT-GL-DEB-AMT             
              MOVE WS-PRE-ENTITY          TO PRT-ENTITY                 
              MOVE WS-CT-RESOURCE         TO PRT-RSRC                   
              MOVE WS-CT-ACTIVITY         TO PRT-ACTIVITY               
              MOVE WS-PRE-NON-REV-ADMN    TO PRT-COST-CENTER            
              MOVE WS-PRE-GL-ACCT         TO PRT-GL-ACCT                
              MOVE WS-PRE-DIVISION        TO PRT-DIVISION               
              MOVE 'TOTAL FOR ENTITY'     TO PRT-REMARKS                
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
              MOVE SPACES TO PRT-DETAIL-LINE                            
              PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT                  
      *                                                                         
      *  CREATE 2ND OUTPUT RECORD - CASHTRAN (FH-GA-SVCI,ETC)                   
      *                                                                         
              MOVE WS-CASHTRAN-TOTAL      TO FIO667-REV-AMOUNT          
      *                                                                         
              MOVE SPACES TO FIO667-SIGN                                
              IF WS-CASHTRAN-TOTAL < 0                                  
                 MOVE WS-NEG TO FIO667-SIGN                             
                 MOVE WS-C   TO FIO667-DR-CR-CODE                       
              ELSE                                                      
                 MOVE WS-D   TO FIO667-DR-CR-CODE                       
              END-IF                                                    
      *                                                                         
              MOVE WS-PRE-ENTITY          TO FIO667-LDR-ENTITY          
                                             FIO667-LINE-LDR-ENTITY     
              MOVE WS-CT-RESOURCE         TO FIO667-RESOURCE            
              MOVE WS-CT-ACTIVITY         TO FIO667-ACTIVITY            
              MOVE WS-PRE-NON-REV-ADMN    TO FIO667-COST-CENTER         
              MOVE WS-PRE-GL-ACCT         TO FIO667-GL-ACCOUNT          
              MOVE WS-PRE-DIVISION        TO FIO667-DIVISION            
              MOVE SPACES                 TO FIO667-LOCATION            
              MOVE 'CASHTRAN'             TO FIO667-REFERENCE           
              PERFORM 2220-CASHTRAN-FIOCRR03-REC THRU 2220-EXIT         
      *                                                                         
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-PROCESS-CURRENT-RECORD.                                     
      *                                                                         
           IF CSR-DATABASE                                              
              IF DBSE-COMPANY-CODE = '01'                               
                 MOVE WS-SCEG TO WS-COMPANY-SW                          
              ELSE                                                      
                 MOVE SPACES  TO WS-COMPANY-SW                          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF DBSE-CONTROL-AMOUNT = 0                                   
              NEXT SENTENCE                                             
           ELSE                                                         
A04527        INITIALIZE FIOCA667                                       
              MOVE DBSE-BUSINESS-UNIT  TO FIO667-LDR-ENTITY             
                                          FIO667-LINE-LDR-ENTITY        
              MOVE DBSE-COST-CENTER    TO FIO667-COST-CENTER            
      *                                                                         
              IF DBSE-LOCATION = LOW-VALUES                             
                 MOVE SPACES TO FIO667-LOCATION                         
              ELSE                                                      
                 MOVE DBSE-LOCATION TO FIO667-LOCATION                  
              END-IF                                                    
      *                                                                         
              MOVE DBSE-ACCOUNT-NUMBER TO FIO667-GL-ACCOUNT             
              MOVE DBSE-OPERATING-UNIT TO FIO667-DIVISION               
              MOVE SPACES              TO FIO667-REFERENCE              
                                          FIO667-HONK-SPACES            
A04527        MOVE DBSE-CONTROL-AMOUNT TO FIO667-REV-AMOUNT             
      *                                                                         
              PERFORM 2210-CURRENT-FIOCRR03-REC THRU 2210-EXIT          
      *                                                                         
              IF DBSE-COMPANY-CODE =  WS-PREV-COMPANY-NO                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE +88 TO WS-LINE-COUNT                              
                 MOVE DBSE-COMPANY-CODE TO WS-COMPANY-NO                
                                           WS-PREV-COMPANY-NO           
              END-IF                                                    
      *                                                                         
              PERFORM 2215-PRINT-CURRENT-REPORT THRU 2215-EXIT          
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  INITIALIZE OUTPUT FIELDS. LOAD OUTPUT RECORD.               *          
      ****************************************************************          
      *                                                                         
       2210-CURRENT-FIOCRR03-REC.                                       
      *                                                                         
           MOVE SPACES TO FIO667-SIGN                                   
           IF DBSE-CONTROL-AMOUNT < 0                                   
              MOVE WS-NEG TO FIO667-SIGN                                
              MOVE WS-C   TO FIO667-DR-CR-CODE                          
           ELSE                                                         
              MOVE WS-D   TO FIO667-DR-CR-CODE                          
           END-IF.                                                      
      *                                                                         
           ADD 1 TO WS-COUNTER.                                         
      *                                                                         
           MOVE WS-COUNTER           TO FIO667-JRNL-LINE-NBR.           
      *                                                                         
           MOVE DBSE-EFFECTIVE-DATE      TO WS-EFFECTIVE-DATE.          
           MOVE WS-EFF-YEAR              TO WS-FIO667-YEAR.             
           MOVE WS-EFF-MONTH             TO WS-FIO667-MONTH.            
           MOVE WS-EFF-DAY               TO WS-FIO667-DAY.              
           MOVE WS-FIO667-DATE           TO FIO667-EFF-DATE.            
      *                                                                         
           MOVE DBSE-NOE-2               TO FIO667-RESOURCE.            
           MOVE DBSE-COST-CODE           TO FIO667-ACTIVITY.            
           MOVE WS-ACTUAL                TO FIO667-AMOUNT-CLASS.        
      *                                                                         
           MOVE DBSE-BENEFIT-COST-CENTER TO FIO667-CUSTOMER.            
           IF FIO667-CUSTOMER = ZEROS                                   
              MOVE SPACES TO FIO667-CUSTOMER                            
           END-IF.                                                      
      *                                                                         
           MOVE WS-QUANTITY              TO FIO667-QUANTITY.            
A04527*    MOVE A180-POSTING-PD          TO DBSCGL-POSTING-PD.                  
           MOVE ZEROS                    TO FIO667-JRNL-SEQ-NBR.        
           MOVE WS-JRNL-ID               TO FIO667-JRNL-ID.             
           MOVE SPACES                   TO FIO667-SERVICE              
                                            FIO667-EVENT                
                                            FIO667-PUC                  
                                            FIO667-WORK-ORDER           
                                            FIO667-UNIT-OF-MEASURE.     
      *                                                                         
           MOVE WS-COMMA TO FIO667-TAB1                                 
                            FIO667-TAB2                                 
                            FIO667-TAB3                                 
                            FIO667-TAB4                                 
                            FIO667-TAB5                                 
                            FIO667-TAB6                                 
                            FIO667-TAB7                                 
                            FIO667-TAB8                                 
                            FIO667-TAB9                                 
                            FIO667-TAB10                                
                            FIO667-TAB11                                
                            FIO667-TAB12                                
                            FIO667-TAB13                                
                            FIO667-TAB14                                
                            FIO667-TAB15                                
                            FIO667-TAB16                                
                            FIO667-TAB17                                
                            FIO667-TAB18                                
                            FIO667-TAB19                                
                            FIO667-TAB20                                
                            FIO667-TAB21                                
                            FIO667-TAB22.                               
      *                                                                         
           PERFORM 3600-WRITE-FIOCA667 THRU 3600-EXIT.                  
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  INITIALIZE OUTPUT FIELDS. LOAD OUTPUT RECORD.               *          
      ****************************************************************          
      *                                                                         
       2215-PRINT-CURRENT-REPORT.                                       
      *                                                                         
           MOVE DBSE-BUSINESS-UNIT       TO PRT-ENTITY.                 
           MOVE DBSE-OPERATING-UNIT      TO PRT-DIVISION.               
           MOVE DBSE-COST-CENTER         TO PRT-COST-CENTER.            
           MOVE DBSE-ACCOUNT-NUMBER      TO PRT-GL-ACCT.                
           MOVE DBSE-NOE-2               TO PRT-RSRC.                   
      *                                                                         
           MOVE DBSE-BENEFIT-COST-CENTER TO PRT-CUSTOMER.               
      *                                                                         
           MOVE DBSE-COST-CODE           TO PRT-ACTIVITY.               
           MOVE DBSE-LOCATION            TO PRT-LOCATION-CODE.          
           MOVE SPACES                   TO PRT-REMARKS                 
A04527                                      PRT-CLEAR-DEB.              
A04527     IF DBSE-CONTROL-AMOUNT < 0                                   
A04527        MOVE DBSE-CONTROL-AMOUNT TO PRT-GL-CRD-AMT                
A04527     ELSE                                                         
A04527        MOVE DBSE-CONTROL-AMOUNT TO PRT-GL-DEB-AMT                
A04527     END-IF.                                                      
           MOVE ZEROS                    TO PRT-WORK-ORDER.             
           PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT.                    
      *                                                                         
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CREATE THE OUTPUT -CASHTRAN- RECORDS                        *          
      ****************************************************************          
      *                                                                         
       2220-CASHTRAN-FIOCRR03-REC.                                      
      *                                                                         
           ADD 1 TO WS-COUNTER.                                         
      *                                                                         
           MOVE WS-COUNTER           TO FIO667-JRNL-LINE-NBR.           
      *                                                                         
           MOVE DBSE-EFFECTIVE-DATE      TO WS-EFFECTIVE-DATE.          
           MOVE WS-EFF-YEAR              TO WS-FIO667-YEAR.             
           MOVE WS-EFF-MONTH             TO WS-FIO667-MONTH.            
           MOVE WS-EFF-DAY               TO WS-FIO667-DAY.              
           MOVE WS-FIO667-DATE           TO FIO667-EFF-DATE.            
      *                                                                         
           MOVE WS-ACTUAL                TO FIO667-AMOUNT-CLASS.        
A04527     MOVE SPACES                   TO FIO667-CUSTOMER             
                                            FIO667-WORK-ORDER.          
           MOVE WS-QUANTITY              TO FIO667-QUANTITY.            
A04527*    MOVE A180-POSTING-PD          TO DBSCGL-POSTING-PD.                  
           MOVE ZEROS                    TO FIO667-JRNL-SEQ-NBR.        
           MOVE WS-JRNL-ID               TO FIO667-JRNL-ID.             
           MOVE SPACES                   TO FIO667-SERVICE              
                                            FIO667-EVENT                
                                            FIO667-PUC                  
                                            FIO667-UNIT-OF-MEASURE      
                                            FIO667-HONK-SPACES.         
      *                                                                         
           MOVE WS-COMMA TO FIO667-TAB1                                 
                            FIO667-TAB2                                 
                            FIO667-TAB3                                 
                            FIO667-TAB4                                 
                            FIO667-TAB5                                 
                            FIO667-TAB6                                 
                            FIO667-TAB7                                 
                            FIO667-TAB8                                 
                            FIO667-TAB9                                 
                            FIO667-TAB10                                
                            FIO667-TAB11                                
                            FIO667-TAB12                                
                            FIO667-TAB13                                
                            FIO667-TAB14                                
                            FIO667-TAB15                                
                            FIO667-TAB16                                
                            FIO667-TAB17                                
                            FIO667-TAB18                                
                            FIO667-TAB19                                
                            FIO667-TAB20                                
                            FIO667-TAB21                                
                            FIO667-TAB22.                               
      *                                                                         
           PERFORM 3600-WRITE-FIOCA667 THRU 3600-EXIT.                  
      *                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527* PROCESS SUMMARY TOTALS                                       *          
      ****************************************************************          
      *                                                                         
A04527 2300-SUMMARY-PAGE.                                               
      *                                                                         
A04527     MOVE +99 TO WS-LINE-COUNT.                                   
      *                                                                         
A04527     PERFORM VARYING SUM-SUB FROM 1 BY 1 UNTIL                    
SCA006        SUM-SUB > WS-50 OR 
              SUM-ENTITY(SUM-SUB)  = SPACES                                 
A04527        MOVE SPACES TO PRT-SUMMARY-LINE                           
A04527        MOVE SUM-ENTITY(SUM-SUB) TO PRT-SUM-ENTITY                
A04527        MOVE SUM-CREDIT(SUM-SUB) TO PRT-SUM-CREDIT                
A04527        MOVE SUM-DEBIT(SUM-SUB)  TO PRT-SUM-DEBIT                 
      *                                                                         
A04527        IF SUM-TOTAL(SUM-SUB) <= 0                                
A04527          COMPUTE WS-WORK-SUM = ((SUM-TOTAL(SUM-SUB) * -1) +      
A04527                SUM-DEBIT(SUM-SUB))                               
A04527          MOVE WS-WORK-SUM         TO PRT-SUM-DEBIT               
A04527          COMPUTE WS-DIFF-SUM = WS-WORK-SUM + SUM-CREDIT(SUM-SUB) 
A04527        ELSE                                                      
A04527          COMPUTE WS-WORK-SUM = ((SUM-TOTAL(SUM-SUB) * -1) +      
A04527                SUM-CREDIT(SUM-SUB))                              
A04527          MOVE WS-WORK-SUM        TO PRT-SUM-CREDIT               
A04527          COMPUTE WS-DIFF-SUM = WS-WORK-SUM + SUM-DEBIT(SUM-SUB)  
A04527        END-IF                                                    
      *                                                                         
A04880        IF SUM-ENTITY(SUM-SUB) = WS-EG                            
A04880           ADD SUM-CREDIT(SUM-SUB) TO WS-CT-CREDIT                
A04880           MOVE WS-CT-CREDIT TO PRT-SUM-CREDIT                    
A04880           ADD SUM-DEBIT(SUM-SUB)  TO WS-CT-DEBIT                 
A04880           MOVE WS-CT-DEBIT  TO PRT-SUM-DEBIT                     
A04527           COMPUTE WS-DIFF-SUM = WS-CT-DEBIT + WS-CT-CREDIT       
A04880        END-IF                                                    
      *                                                                         
A04527        MOVE WS-DIFF-SUM TO  PRT-SUM-DIFF                         
      *                                                                         
A04527        PERFORM 4320-PRINT-SUMMARY THRU 4320-EXIT                 
A04527     END-PERFORM.                                                 
A04527     MOVE WS-Y TO WS-SUMMARY-END.                                 
      *                                                                         
A04527 2300-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS TAKES CARE OF THE END OF FILE LOGIC             *          
      ****************************************************************          
      *                                                                         
       3000-LAST-ENTITY.                                                
      *                                                                         
           IF WS-COUNTER > 0                                            
              PERFORM 2110-PROCESS-ENTITY-TOTALS THRU 2110-EXIT         
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS READS FCSCRR03-FILE                             *          
      ****************************************************************          
      *                                                                         
       3100-READ-FCSCRR03-FILE.                                         
      *                                                                         
           READ FCSCRR03-FILE                                           
               AT END SET FCSCRR03-END TO TRUE                          
           END-READ.                                                    
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITE OUTPUT RECORD                                          *          
      ****************************************************************          
      *                                                                         
       3600-WRITE-FIOCA667.                                             
      *                                                                         
           WRITE FIOCA667.                                              
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT DETAIL RECORD - CHECK FOR HEADERS                      *          
      ****************************************************************          
      *                                                                         
       4300-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-LINE-COUNT > +56                                       
              SET REPORT-NEW-PAGE TO TRUE                               
              MOVE ZEROS TO WS-LINE-COUNT                               
              PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE PRT-DETAIL-LINE TO PRT-REPORT-LINE.                     
           MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT HEADERS                                                *          
      ****************************************************************          
      *                                                                         
       4310-HEADER-CTRLRPT1.                                            
      *                                                                         
           MOVE +0                 TO WS-LINE-COUNT.                    
           MOVE WS-PAGE-COUNT      TO WS-PAGE-NUMBER.                   
           MOVE WS-REPORT-HEADER1  TO PRT-REPORT-LINE.                  
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-REPORT-HEADER2  TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-REPORT-HEADER2B TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-HRZN-LINE-SPACE TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-REPORT-HEADER3  TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-REPORT-HEADER4  TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE WS-HRZN-LINE-132   TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527* PRINT SUMMARY REPORT HEADERS                                 *          
      ****************************************************************          
      *                                                                         
A04527 4320-PRINT-SUMMARY.                                              
      *                                                                         
A04880     IF WS-LINE-COUNT > +88                                       
A04527        SET REPORT-NEW-PAGE TO TRUE                               
A04880        MOVE +0                 TO WS-LINE-COUNT                  
A04880        MOVE +1                 TO WS-PAGE-NUMBER                 
A04880        MOVE WS-REPORT-HEADER1  TO PRT2-REPORT-LINE               
A04880        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
      *                                                                         
A04880        MOVE WS-REPORT-HEADER2  TO PRT2-REPORT-LINE               
A04880        MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE       
A04880        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
      *                                                                         
A04880        MOVE WS-REPORT-HEADER2B TO PRT2-REPORT-LINE               
A04880        MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE       
A04880        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
      *                                                                         
A04880        MOVE WS-HRZN-LINE-SPACE TO PRT2-REPORT-LINE               
A04880        MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE       
A04880        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
      *                                                                         
A04527        MOVE WS-SUMMARY-HEADER1 TO PRT2-REPORT-LINE               
A04527        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
      *                                                                         
A04527        MOVE WS-HRZN-LINE-SPACE TO PRT2-REPORT-LINE               
A04527        MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE       
A04527        PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT                 
A04880     END-IF.                                                      
      *                                                                         
A04527     MOVE PRT-SUMMARY-LINE TO PRT2-REPORT-LINE.                   
A04527     MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
A04527     PERFORM 4510-PRINT-REPORT2 THRU 4510-EXIT.                   
      *                                                                         
A04527 4320-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES PRINT RECORDS IN PRINTER FILE FOR CONTROL REPORT      *          
      ****************************************************************          
      *                                                                         
       4500-PRINT-REPORT.                                               
      *                                                                         
           IF REPORT-NEW-PAGE                                           
              WRITE PRT-REPORT AFTER ADVANCING PAGE                     
              SET REPORT-FIRST-LINE TO TRUE                             
              MOVE +1 TO WS-LINE-COUNT                                  
              ADD  +1 TO WS-PAGE-COUNT                                  
           ELSE                                                         
              WRITE PRT-REPORT AFTER WS-PRT-REPORT-LINE-SPACE           
              ADD WS-PRT-REPORT-LINE-SPACE TO WS-LINE-COUNT             
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES PRINT RECORDS IN PRINTER2 FOR SUMMARY REPORT          *          
      ****************************************************************          
      *                                                                         
       4510-PRINT-REPORT2.                                              
      *                                                                         
           IF REPORT-NEW-PAGE                                           
              WRITE PRT2-REPORT AFTER ADVANCING PAGE                    
              SET REPORT-FIRST-LINE TO TRUE                             
              MOVE +1 TO WS-LINE-COUNT                                  
              ADD  +1 TO WS-PAGE-COUNT                                  
           ELSE                                                         
              WRITE PRT2-REPORT AFTER WS-PRT-REPORT-LINE-SPACE          
              ADD WS-PRT-REPORT-LINE-SPACE TO WS-LINE-COUNT             
           END-IF.                                                      
      *                                                                         
       4510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  DETERMINE WHICH DATABASE WE ARE USING                       *          
      ****************************************************************          
      *                                                                         
       7350-GET-DELINQUENCY.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD  = 'DATABASE'                          
                   AND COMPANY_NO = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD  = 'DATABASE'                                  
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                              
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7350                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**      PCSCA667 PROCESSING ERROR       **'      
              DISPLAY '**   SELECT FOR DELINQUENCY FAILED      **'      
              DISPLAY '**   SQLCODE WAS: ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '******************************************'      
              PERFORM 9100-ABEND THRU 9100-EXIT                         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS CLOSES ALL OPENED FILES AND DISPLAYS APPROPRIATE*          
      * AT END OF PROGRAM EXECUTION.                                 *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           EVALUATE TRUE                                                
               WHEN FCSCRR03-NO-REC                                     
                    DISPLAY WS-PROCESS-END-MSG-NO-REC                   
                    MOVE +9 TO RETURN-CODE                              
               WHEN SOME-RECORDS-IN-ERROR                               
                    DISPLAY WS-PROCESS-END-MSG-ERROR                    
                    MOVE +9 TO RETURN-CODE                              
               WHEN NO-RECORD-IN-ERROR                                  
                    DISPLAY WS-PROCESS-END-MSG-GOOD                     
                    MOVE +0 TO RETURN-CODE                              
           END-EVALUATE.                                                
      *                                                                         
           CLOSE FCSCA667-FILE                                          
                 FCSCRR03-FILE                                          
                 PRINTER1                                               
                 PRINTER2.                                              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FOLLOWING PROCESS IS INVOKED WHEN ABNORMAL TERMINATION.      *          
      ****************************************************************          
      *                                                                         
       9100-ABEND.                                                      
      *                                                                         
           MOVE +9 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
