       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA666.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  NOVEMBER 2015.                                    
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                         DB2                                **          
      ****************************************************************          
      *  COMMENTS: CONVERTS THE NEW METER FILE FROM THE MANUFACTURER *          
      *            TESTS INTO A FILE - READ INTO PCSMT657.           *          
      *            ANY ERRORS WILL BE WRITTEN TO THE REPORT.         *          
      *            THERE IS A SORT STEP PRIOR TO THIS PROGRAM.       *          
      *            IT TAKES A REALLY MESSED UP DATA SET AND          *          
      *            REFORMATS IT INTO A FIXED BLOCK, USABLE FILE.     *          
      *                                                              *          
      *  FILES:   NEWMTR    - NEW INPUT METER FILE                   *          
      *           FIOCA666  - NEW OUTPUT METER FILE                  *          
      *           SYSIN     - SYSTEM DATE CARD                       *          
      *           PRINTER1  - PRINTER                                *          
      *                                                              *          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  20 JUL 2015 RF10596      REWRITE GMC006 (EZTRIEVE) INTO   **          
      **                           A COBOL PROGRAM.                 **          
      **                                                            **          
A05460**  20 JAN 2016 RF10596      ADD NO DATA TO PRINTER           **          
      **                                                            **          
A05460**  26 JAN 2016 RF10596      CORRECT TIMESTAMP CHECK          **          
      **                                                            **          
A05460**  28 JAN 2016 RF10596      OUTPUT PROVER-ID NEEDS ZEROS     **          
      **                                                            **          
A05460**  28 JAN 2016 RF10596      OUTPUT PROVER-ID REVERSE ZEROS   **          
A05460**                           FIX READ UNITS ERROR             **          
A05460**                           FIX REPAIR CODE LOGIC            **          
A05460**                           DO 2110-CHECK-TEST-RANGE ALWAYS  **          
      **                                                            **          
A05460**   3 FEB 2016 RF10596      CORRECT INPUT FILE LAYOUT        **          
A05460**                           CORRECT IN-READ/OUT-READ         **          
      **                                                            **          
A05460**   5 FEB 2016 RF10596      SPACES TO REPAIR-DESC            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA666.                                                           
      *                                                                         
           SELECT NEWMTR-FILE                                           
               ASSIGN UT-S-NEWMTR                                       
               FILE STATUS IS WS-NEWMTR-STATUS.                         
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA666.                                                           
       COPY FIOCA666.                                                           
      *                                                                         
       FD  NEWMTR-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01  NEWMTR-RECORD.                                               
           05 FILLER                   PIC X.                           
           05 E-666MTR-DATE.                                            
              07 E-666MTR-MONTH        PIC XX.                          
              07 E-666MTR-SLASH1       PIC X.                           
              07 E-666MTR-DAY          PIC XX.                          
              07 E-666MTR-SLASH2       PIC X.                           
              07 E-666MTR-YEAR         PIC X(4).                        
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-TIME-STAMP.                                      
              07 E-666MTR-HOUR         PIC XX.                          
              07 FILLER                PIC X.                           
              07 E-666MTR-MINUTE       PIC XX.                          
              07 FILLER                PIC X.                           
              07 E-666MTR-SECOND       PIC XX.                          
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-EMP-ID          PIC X(5).                        
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-TEST-PROVER-ID  PIC X.                           
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-METER-NBR       PIC X(9).                        
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-MFG-SERIAL-NBR  PIC X(11).                       
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-COMPANY         PIC XX.                          
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-READ-UNITS      PIC X(6).                        
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-TEST-TYPE       PIC X.                           
           05 FILLER                   PIC X(12).                       
           05 E-666MTR-METER-TYPE      PIC X(8).                        
           05 FILLER                   PIC X(3).                        
           05 E-666MTR-IN-OUT-TEST     PIC X(6).                        
           05 FILLER                   PIC X(5).                        
           05 E-666MTR-IN-TEST-OPEN    PIC X(5).                        
           05 FILLER                   PIC X.                           
A05460     05 E-666MTR-OUT-TEST-OPEN   PIC X(5).                        
           05 FILLER                   PIC X(3).                        
A05460     05 E-666MTR-IN-TEST-CHECK   PIC X(5).                        
           05 FILLER                   PIC X.                           
           05 E-666MTR-OUT-TEST-CHECK  PIC X(5).                        
           05 FILLER                   PIC X(7).                        
           05 E-666MTR-DONT-KNOW       PIC X(4).                        
           05 FILLER                   PIC X(12).                       
           05 E-666MTR-DESC.                                            
              07 E-666MTR-REPAIR-CODE  PIC X.                           
              07 FILLER                PIC X.                           
              07 E-666MTR-DESCRIPTION  PIC X(15).                       
           05 FILLER                   PIC X.                           
      *                                                                         
       FD  PRINTER1                                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  PRT-REPORT.                                                  
           02  PRT-REPORT-CNTL        PIC X.                            
           02  PRT-REPORT-LINE        PIC X(132).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA666'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           03  WS-PRINT-FIELDS.                                         
               05  WS-PAGE-COUNT       PIC S9(3) VALUE +1  COMP-3.      
               05  WS-LINE-COUNT       PIC S9(3) VALUE +99 COMP-3.      
               05  WS-INPUT-REC-COUNT  PIC S9(6) VALUE +0  COMP-3.      
               05  WS-COUNTER          PIC 9(4)  VALUE 0.               
      *                                                                         
       01  WS-FLAG.                                                     
           03  WS-NEWMTR-READ-STATUS PIC X VALUE SPACES.                
               88  NEWMTR-NO-REC           VALUE 'N'.                   
               88  NEWMTR-END              VALUE 'E'.                   
               88  NEWMTR-STARTED          VALUE 'S'.                   
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
A05460     03  WS-NODATA-SW            PIC X     VALUE 'Y'.             
A05460     03  WS-WARN-SW              PIC X     VALUE 'N'.             
           03  WS-SLASH                PIC X     VALUE '/'.             
           03  WS-HONK-1               PIC X     VALUE '|'.             
           03  WS-HONK-2               PIC X     VALUE ''.             
           03  WS-REPAIR-CODE          PIC X     VALUE SPACES.          
           03  WS-TEST-TYPE            PIC X     VALUE SPACES.          
A05460     03  WS-PROVER-ZEROS         PIC X(5)  VALUE '00000'.         
           03  WS-ALL-ZEROS            PIC X(5)  VALUE '000.0'.         
           03  WS-ZERO-CHECK           PIC X(5)  VALUE SPACES.          
           03  WS-METER-TYPE           PIC X(8)  VALUE SPACES.          
           03  WS-TEST-TYPE-DESC       PIC X(9)  VALUE SPACES.          
           03  WS-IN-OUT-TEST          PIC X(6)  VALUE SPACES.          
A05460     03  WS-MTR-DESC             PIC X(15) VALUE SPACES.          
           03  WS-A                    PIC X     VALUE 'A'.             
           03  WS-B                    PIC X     VALUE 'B'.             
           03  WS-C                    PIC X     VALUE 'C'.             
           03  WS-G                    PIC X     VALUE 'G'.             
           03  WS-I                    PIC X     VALUE 'I'.             
           03  WS-K                    PIC X     VALUE 'K'.             
           03  WS-N                    PIC X     VALUE 'N'.             
           03  WS-O                    PIC X     VALUE 'O'.             
           03  WS-P                    PIC X     VALUE 'P'.             
           03  WS-Q                    PIC X     VALUE '"'.             
           03  WS-R                    PIC X     VALUE 'R'.             
           03  WS-Y                    PIC X     VALUE 'Y'.             
           03  WS-AST                  PIC X     VALUE '*'.             
           03  WS-ERROR-SW             PIC X     VALUE 'N'.             
           03  WS-ERROR-MSG            PIC X(40) VALUE SPACES.          
           03  WS-WARN-MESSAGE         PIC X(40) VALUE SPACES.          
           03  WS-MTR-DATE             PIC X(10) VALUE SPACES.          
           03  WS-DATE1                PIC X(10) VALUE SPACES.          
           03  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           03  WS-COMPANY-NO           PIC XX    VALUE SPACES.          
           03  WS-CODE-UTIL-TYPE       PIC X     VALUE 'G'.             
           03  WS-NEWMTR-STATUS        PIC XX    VALUE SPACES.          
           03  WS-FCA666-STATUS        PIC XX    VALUE SPACES.          
           03  WS-METER-NO             PIC X(9)  VALUE SPACES.          
           03  WS-MFG-SERIAL           PIC X(11) VALUE SPACES.          
           03  WS-CHECK-PROOF          PIC X(5)  VALUE SPACES.          
           03  WS-READ-UNITX           PIC X(6)  VALUE SPACES.          
           03  WS-READ-UNITS           PIC 9(6)  VALUE ZEROS.           
           03  WS-CHECK                PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-IN-TEST-OPEN         PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-IN-TEST-CHECK        PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-OUT-TEST-OPEN        PIC S999V99 COMP-3 VALUE ZEROS.  
           03  WS-OUT-TEST-CHECK       PIC S999V99 COMP-3 VALUE ZEROS.  
A05460     03  WS-LOW                  PIC S999V99 COMP-3 VALUE 99.00.  
           03  WS-HIGH                 PIC S999V99 COMP-3 VALUE 100.50. 
      *                                                                         
A05460 01  WS-PROVER-ID.                                                
A05460     03  WS-PROVER-ID0           PIC X(5)  VALUE ZEROS.           
A05460     03  WS-PROVER-IDX           PIC X     VALUE SPACES.          
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
           03  WS-NONREG1-MSG          PIC X(40)                        
                  VALUE 'NON-REGISTER METER INTEST > ZERO        '.     
           03  WS-NONREG2-MSG          PIC X(40)                        
                  VALUE 'NON-REGISTER INVALID ON OUTTEST         '.     
           03  WS-REPAIR-MSG           PIC X(40)                        
                  VALUE 'INVALID REPAIR CODE DESCRIPTION         '.     
           03  WS-MTR-MSG              PIC X(40)                        
                  VALUE 'NO METER NUMBER ON THE INPUT FILE       '.     
           03  WS-SER-MSG              PIC X(40)                        
                  VALUE 'NO MFG SERIAL NUMBER ON THE INPUT FILE  '.     
           03  WS-SER-MSG2             PIC X(40)                        
                  VALUE 'INVALID SERIAL NUMBER - CSS_EQUIPMENT   '.     
           03  WS-MTR-EXIST-MSG        PIC X(40)                        
                  VALUE 'METER NUMBER NOT FOUND ON CSS_GAS_METER '.     
           03  WS-MTR-EXIST2-MSG       PIC X(40)                        
                  VALUE 'METER NUMBER NOT FOUND ON CSS_EQUIPMENT '.     
           03  WS-TEST-TYPE-MSG        PIC X(40)                        
                  VALUE 'INVALID REASON FOR TEST DESCRIPTION     '.     
           03  WS-INV-TEST1-MSG        PIC X(40)                        
                  VALUE 'INV TST REASN:SEL SMPL-TSTED PERIOD     '.     
           03  WS-INV-TEST2-MSG        PIC X(40)                        
                  VALUE 'INV TST REASN:SEL PERIOD-TSTED SMPL     '.     
           03  WS-INV-TYPE-MSG         PIC X(40)                        
                  VALUE 'INVALID METER TYPE                      '.     
           03  WS-INV-PROOF-MSG        PIC X(40)                        
                  VALUE 'EITHER OPEN TEST OR CHECK OUT OF RANGE  '.     
           03  WS-DATE-ERROR-MSG       PIC X(40)                        
                  VALUE 'INPUT METER DATE IN ERROR               '.     
           03  WS-INVALID-TMST-MSG     PIC X(40)                        
                  VALUE 'INVALID TIME STAMP                      '.     
           03  WS-WARNING-1-MSG        PIC X(40)                        
                  VALUE 'WARNING: SEL PER OR SMPL-TSTED OTHER    '.     
           03  WS-WARNING-2-MSG        PIC X(40)                        
                  VALUE 'WARNING: NOT SEL FOR SMPL-TSTED SMPL    '.     
           03  WS-WARNING-3-MSG        PIC X(40)                        
                  VALUE 'WARNING: NOT SEL FOR PER- TSTED PER     '.     
      *                                                                         
       01  WS-REPORT-PAGE-CONTROLS.                                     
           03  WS-PRT-REPORT-LINE-SPACE      PIC 9.                     
           03  WS-PRT-REPORT-LINE-COUNT      PIC 99 VALUE 0.            
               88  REPORT-PAGE-OVERFLOW         VALUE 57 THRU 99.       
               88  REPORT-NEW-PAGE              VALUE 0.                
               88  REPORT-FIRST-LINE            VALUE 1.                
      *                                                                         
      ****************************************************************          
      * REPORT HEADER RECORDS                                        *          
      ****************************************************************          
      *                                                                         
       01  PRT-REPORT-HEADER1.                                          
           03  FILLER                  PIC X(8)  VALUE 'PCSCA666'.      
           03  FILLER                  PIC X(39) VALUE SPACES.          
           03  PRT-HDR-SCEG            PIC X(39)                        
               VALUE 'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.         
           03  FILLER                  PIC X(20) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'DATE : '.       
           03  PRT-HDR-DATE            PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER2.                                          
           03  FILLER                  PIC X(49) VALUE SPACES.          
           03  FILLER                  PIC X(34) VALUE                  
           'INVALID METER TEST RECORDS LISTING'.                        
           03  FILLER                  PIC X(23) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'PAGE : '.       
           03  PRT-HDR-PAGE            PIC Z,ZZ9.                       
           03  FILLER                  PIC X(14) VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER3.                                          
           03  FILLER                  PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE 'METER/SER'.     
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(10) VALUE 'DATE/DESCR'.    
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE 'PRV'.           
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'CMPY'.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'EMPL'.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE 'TTC'.           
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE 'UNITS'.         
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'IN-OPEN'.       
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  FILLER                  PIC X(8)  VALUE 'IN-CHECK'.      
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(8)  VALUE 'OUT-OPEN'.      
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE 'OUT-CHECK'.     
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE 'RPR'.           
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(8)  VALUE 'MTR TYPE'.      
           03  FILLER                  PIC X(5)  VALUE SPACES.          
      *                                                                         
       01  PRT-ERROR-LINE.                                              
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  PRT-METER               PIC X(9)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-DATE                PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  PRT-PROVER              PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-COMPANY             PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-EMPLOYEE            PIC X(5)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-TEST-TYPE-CODE      PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-READ-UNIT           PIC X(6)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
A05460     03  PRT-IN-TEST-OPEN        PIC ---9.99.                     
           03  FILLER                  PIC X(4)  VALUE SPACES.          
A05460     03  PRT-IN-TEST-CHECK       PIC ---9.99.                     
           03  FILLER                  PIC X(4)  VALUE SPACES.          
A05460     03  PRT-OUT-TEST-OPEN       PIC ---9.99.                     
           03  FILLER                  PIC X(5)  VALUE SPACES.          
A05460     03  PRT-OUT-TEST-CHECK      PIC ---9.99.                     
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-REPAIR-CODE         PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(6)  VALUE SPACES.          
           03  PRT-METER-TYPE          PIC X(8)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
      *                                                                         
       01  PRT-ERROR-LINE2.                                             
           03  FILLER                  PIC X     VALUE SPACES.          
           03  PRT-SERIAL-NBR          PIC X(11) VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  PRT-TEST-TYPE-DESC      PIC X(9)  VALUE SPACES.          
           03  FILLER                  PIC X(16) VALUE SPACES.          
           03  PRT-ERROR-MESSAGE       PIC X(40) VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE SPACES.          
           03  PRT-WARN-MESSAGE        PIC X(40) VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
      *                                                                         
       01  PRT-END-LINE.                                                
           03  FILLER                  PIC X(59) VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'END OF REPORT'. 
           03  FILLER                  PIC X(60) VALUE SPACES.          
      *                                                                         
A05460 01  PRT-NODATA-LINE.                                             
A05460     03  FILLER                  PIC X(59) VALUE SPACES.          
A05460     03  FILLER                  PIC X(13) VALUE 'NO DATA TODAY'. 
A05460     03  FILLER                  PIC X(60) VALUE SPACES.          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT - EQ                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GAS_METER_SIZE - M5                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMSZ                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GAS_METER  - GM                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIP_TEST_TYP - M9                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTTYP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIP_TST_REPR - N3                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQTRPR                                                 
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                   UNTIL NEWMTR-END.                                    
      *                                                                         
A05460     IF WS-NODATA-SW = WS-Y                                       
A05460        SET REPORT-NEW-PAGE TO TRUE                               
A05460        MOVE ZEROS TO WS-LINE-COUNT                               
A05460        PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
A05460        MOVE PRT-NODATA-LINE TO PRT-REPORT-LINE                   
A05460        MOVE 2 TO WS-PRT-REPORT-LINE-SPACE                        
A05460        PERFORM 4500-PRINT-REPORT THRU 4500-EXIT                  
A05460     END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPEN INPUT AND OUTPUT FILES.  GET CURRENT DATE               *          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE THRU 7000-EXIT.                
      *                                                                         
           MOVE WS-CURRENT-DATE TO PRT-HDR-DATE.                        
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS OPENS ALL INPUT AND OUTPUT FILES.               *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT NEWMTR-FILE.                                      
           OPEN OUTPUT FCSCA666-FILE                                    
                       PRINTER1.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * MAIN PROCESS                                                 *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           MOVE WS-N TO WS-ERROR-SW                                     
A05460                  WS-WARN-SW.                                     
           MOVE SPACES TO PRT-ERROR-LINE                                
                          WS-MFG-SERIAL                                 
                          WS-METER-NO                                   
                          WS-ERROR-MSG                                  
                          WS-WARN-MESSAGE                               
                          WS-DATE1                                      
                          WS-METER-TYPE                                 
                          WS-IN-OUT-TEST                                
                          WS-TEST-TYPE                                  
                          WS-MTR-DESC                                   
                          WS-REPAIR-CODE                                
                          WS-TEST-TYPE-DESC                             
                          WS-READ-UNITX.                                
           MOVE ZEROS  TO WS-IN-TEST-OPEN                               
                          WS-IN-TEST-CHECK                              
                          WS-OUT-TEST-OPEN                              
                          WS-OUT-TEST-CHECK                             
                          WS-READ-UNITS.                                
      *                                                                         
           MOVE E-666MTR-COMPANY         TO WS-COMPANY-NO.              
           MOVE E-666MTR-METER-NBR       TO WS-METER-NO.                
           MOVE E-666MTR-READ-UNITS      TO WS-READ-UNITS.              
           MOVE E-666MTR-MFG-SERIAL-NBR  TO WS-MFG-SERIAL.              
           MOVE E-666MTR-METER-TYPE      TO WS-METER-TYPE.              
           MOVE E-666MTR-IN-OUT-TEST     TO WS-IN-OUT-TEST.             
           MOVE E-666MTR-DESCRIPTION     TO WS-MTR-DESC.                
           MOVE E-666MTR-TEST-TYPE       TO WS-TEST-TYPE.               
      *                                                                         
           INSPECT WS-METER-NO    REPLACING ALL WS-Q BY SPACES.         
           INSPECT WS-MFG-SERIAL  REPLACING ALL WS-Q BY SPACES.         
           INSPECT WS-METER-TYPE  REPLACING ALL WS-Q BY SPACES.         
           INSPECT WS-IN-OUT-TEST REPLACING ALL WS-Q BY SPACES.         
           INSPECT WS-MTR-DESC    REPLACING ALL WS-Q BY SPACES.         
      *                                                                         
A05460*    CUSTOMER WANTS SPACES IN DESCRIPTION FIELD                           
      *                                                                         
A05460     MOVE SPACES TO WS-MTR-DESC.                                  
      *                                                                         
           INSPECT WS-METER-NO   REPLACING ALL SPACES BY ZEROES.        
           INSPECT WS-MFG-SERIAL REPLACING ALL SPACES BY ZEROES.        
      *                                                                         
A05460     MOVE E-666MTR-REPAIR-CODE     TO WS-REPAIR-CODE.             
           IF WS-COMPANY-NO = '26'                                      
              IF WS-REPAIR-CODE = WS-HONK-2                             
                 MOVE WS-HONK-1 TO WS-REPAIR-CODE                       
A05460           MOVE WS-REPAIR-CODE TO E-666MTR-REPAIR-CODE            
              END-IF                                                    
A05460     END-IF.                                                      
      *                                                                         
A05460     PERFORM 2110-CHECK-TEST-RANGE THRU 2110-EXIT.                
      *                                                                         
           MOVE WS-SLASH TO E-666MTR-SLASH1                             
                            E-666MTR-SLASH2.                            
           MOVE E-666MTR-DATE TO WS-DATE1.                              
           PERFORM 7011-CONVERT-DATES THRU 7011-EXIT.                   
      *                                                                         
           PERFORM 2240-TIME-STAMP THRU 2240-EXIT.                      
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-METER-NO = ZEROS                                    
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE SPACES TO WS-METER-NO                             
                 MOVE WS-MTR-MSG TO WS-ERROR-MSG                        
              ELSE                                                      
                 IF WS-MFG-SERIAL = ZEROS                               
                    MOVE WS-Y TO WS-ERROR-SW                            
                    MOVE SPACES TO WS-MFG-SERIAL                        
                    MOVE WS-SER-MSG TO WS-ERROR-MSG                     
                 ELSE                                                   
                    PERFORM 7100-SELECT-GAS-METER THRU 7100-EXIT        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 2275-SCHEDULE-TEST THRU 2275-EXIT        
                    END-IF                                              
                    PERFORM 7125-SELECT-METER-SIZE THRU 7125-EXIT       
                    PERFORM 7150-SELECT-SERIAL-NO THRU 7150-EXIT        
                    PERFORM 7175-SELECT-TEST-TYPE THRU 7175-EXIT        
                    PERFORM 7200-SELECT-REPAIR-DESC THRU 7200-EXIT      
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 2250-REPAIR-CODE THRU 2250-EXIT          
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              PERFORM 2215-PRINT-ERROR-REPORT THRU 2215-EXIT            
              MOVE WS-N TO WS-ERROR-SW                                  
A05460        MOVE WS-N TO WS-NODATA-SW                                 
A05460        MOVE WS-N TO WS-WARN-SW                                   
           ELSE                                                         
A05460        IF WS-WARN-SW = WS-Y                                      
A05460           PERFORM 2215-PRINT-ERROR-REPORT THRU 2215-EXIT         
A05460           MOVE WS-N TO WS-NODATA-SW                              
A05460           MOVE WS-N TO WS-WARN-SW                                
A05460        END-IF                                                    
              PERFORM 2210-CREATE-OUTPUT-REC THRU 2210-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * VERIFY TEST RANGE NUMBER                                     *          
      ****************************************************************          
      *                                                                         
       2110-CHECK-TEST-RANGE.                                           
      *                                                                         
           MOVE E-666MTR-IN-TEST-OPEN TO WS-CHECK-PROOF.                
           COMPUTE WS-CHECK ROUNDED =                                   
              FUNCTION NUMVAL(WS-CHECK-PROOF).                          
           MOVE WS-CHECK TO WS-IN-TEST-OPEN.                            
      *                                                                         
           MOVE E-666MTR-IN-TEST-CHECK TO WS-CHECK-PROOF.               
           COMPUTE WS-CHECK ROUNDED =                                   
              FUNCTION NUMVAL(WS-CHECK-PROOF).                          
           MOVE WS-CHECK TO WS-IN-TEST-CHECK.                           
      *                                                                         
           MOVE E-666MTR-OUT-TEST-OPEN TO WS-CHECK-PROOF.               
           COMPUTE WS-CHECK ROUNDED =                                   
              FUNCTION NUMVAL(WS-CHECK-PROOF).                          
           IF WS-CHECK = ZEROS                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-CHECK < WS-LOW OR > WS-HIGH                         
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-INV-PROOF-MSG TO WS-ERROR-MSG                  
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-CHECK TO WS-OUT-TEST-OPEN.                           
      *                                                                         
           MOVE E-666MTR-OUT-TEST-CHECK TO WS-CHECK-PROOF.              
           COMPUTE WS-CHECK ROUNDED =                                   
              FUNCTION NUMVAL(WS-CHECK-PROOF).                          
           IF WS-CHECK = ZEROS                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-CHECK < WS-LOW OR > WS-HIGH                         
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-INV-PROOF-MSG TO WS-ERROR-MSG                  
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-CHECK TO WS-OUT-TEST-CHECK.                          
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  INITIALIZE OUTPUT FIELDS. LOAD OUTPUT RECORD.               *          
      ****************************************************************          
      *                                                                         
       2210-CREATE-OUTPUT-REC.                                          
      *                                                                         
           INITIALIZE FIOCA666.                                         
      *                                                                         
           MOVE WS-METER-NO             TO E-FMT666-METER-NO.           
           MOVE WS-MTR-DATE             TO E-FMT666-DATE-TEST.          
           MOVE E-666MTR-TIME-STAMP     TO E-FMT666-TIME-TEST.          
           MOVE ZEROS                   TO E-FMT666-CODE-TIME-PERIOD.   
           MOVE WS-A                    TO E-FMT666-CODE-CAP-TYPE.      
           MOVE E-666MTR-REPAIR-CODE    TO E-FMT666-CODE-REPAIR.        
A05460     MOVE WS-MTR-DESC             TO E-FMT666-REPAIR-DESC.        
           MOVE E-666MTR-TEST-TYPE      TO E-FMT666-CODE-TEST-TYPE.     
           MOVE WS-IN-TEST-CHECK        TO E-FMT666-IN-CHECK-RATE.      
           MOVE ZEROS                   TO E-FMT666-IN-INTER-RATE.      
           MOVE WS-IN-TEST-OPEN         TO E-FMT666-IN-OPEN-RATE.       
      *                                                                         
A05460     MOVE WS-READ-UNITS TO E-FMT666-IN-READ                       
A05460                           E-FMT666-OUT-READ.                     
      *                                                                         
           MOVE WS-OUT-TEST-CHECK       TO E-FMT666-OUT-CHECK-RATE.     
           MOVE ZEROS                   TO E-FMT666-OUT-INTER-RATE.     
           MOVE WS-OUT-TEST-OPEN        TO E-FMT666-OUT-OPEN-RATE.      
           MOVE E-666MTR-EMP-ID         TO E-FMT666-EQ-TESTER-ID.       
      *                                                                         
A05460     MOVE E-666MTR-TEST-PROVER-ID TO WS-PROVER-IDX.               
A05460     MOVE WS-PROVER-ZEROS         TO WS-PROVER-ID0.               
A05460     MOVE WS-PROVER-ID            TO E-FMT666-TEST-PROVER-ID.     
      *                                                                         
           MOVE WS-A                    TO E-FMT666-CODE-CAP-TYPE.      
           MOVE WS-B                    TO E-FMT666-CODE-TEST-RESULT.   
           MOVE WS-COMPANY-NO           TO E-FMT666-COMPANY-NO          
                                           E-FMT666-PLACE.              
      *                                                                         
           IF E-666MTR-TEST-PROVER-ID = '1'                             
              MOVE WS-C TO E-FMT666-CODE-TEST-LOC                       
           ELSE                                                         
              IF E-666MTR-TEST-PROVER-ID = '2'                          
                 MOVE WS-G TO E-FMT666-CODE-TEST-LOC                    
              ELSE                                                      
                 MOVE WS-N TO E-FMT666-CODE-TEST-LOC                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 3600-WRITE-FIOCA666 THRU 3600-EXIT.                  
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   LOAD AND PRINT ERROR REPORT                                *          
      ****************************************************************          
      *                                                                         
       2215-PRINT-ERROR-REPORT.                                         
      *                                                                         
           MOVE WS-MFG-SERIAL     TO PRT-SERIAL-NBR.                    
           MOVE WS-TEST-TYPE-DESC TO PRT-TEST-TYPE-DESC.                
           MOVE WS-ERROR-MSG      TO PRT-ERROR-MESSAGE.                 
           MOVE WS-WARN-MESSAGE   TO PRT-WARN-MESSAGE.                  
      *                                                                         
           MOVE WS-METER-NO       TO PRT-METER.                         
           MOVE WS-MTR-DATE       TO PRT-DATE.                          
           MOVE E-666MTR-TEST-PROVER-ID   TO PRT-PROVER.                
           MOVE WS-COMPANY-NO     TO PRT-COMPANY.                       
           MOVE E-666MTR-EMP-ID   TO PRT-EMPLOYEE.                      
           MOVE WS-TEST-TYPE      TO PRT-TEST-TYPE-CODE.                
           MOVE WS-READ-UNITS     TO PRT-READ-UNIT.                     
           MOVE WS-IN-TEST-OPEN   TO PRT-IN-TEST-OPEN.                  
           MOVE WS-IN-TEST-CHECK  TO PRT-IN-TEST-CHECK.                 
           MOVE WS-OUT-TEST-OPEN  TO PRT-OUT-TEST-OPEN.                 
           MOVE WS-OUT-TEST-CHECK TO PRT-OUT-TEST-CHECK.                
           MOVE WS-REPAIR-CODE    TO PRT-REPAIR-CODE.                   
           MOVE WS-METER-TYPE     TO PRT-METER-TYPE.                    
      *                                                                         
           PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT.                    
      *                                                                         
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   VERIFY TIME STAMP IS VALID                                 *          
      ****************************************************************          
      *                                                                         
       2240-TIME-STAMP.                                                 
      *                                                                         
A05460     IF E-666MTR-HOUR < '00' OR > '23'                            
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-INVALID-TMST-MSG TO WS-ERROR-MSG                  
           ELSE                                                         
A05460        IF E-666MTR-MINUTE < '00' OR > '59'                       
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-INVALID-TMST-MSG TO WS-ERROR-MSG               
              ELSE                                                      
A05460           IF E-666MTR-SECOND < '00' OR > '59'                    
                    MOVE WS-Y TO WS-ERROR-SW                            
                    MOVE WS-INVALID-TMST-MSG TO WS-ERROR-MSG            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK REPAIR CODE                                          *          
      ****************************************************************          
      *                                                                         
       2250-REPAIR-CODE.                                                
      *                                                                         
           IF (WS-REPAIR-CODE = WS-O OR WS-P) AND WS-TEST-TYPE = WS-I   
                   AND (WS-IN-TEST-OPEN > 0 OR WS-IN-TEST-CHECK > 0)    
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-NONREG1-MSG TO WS-ERROR-MSG                       
           END-IF.                                                      
      *                                                                         
           IF (WS-REPAIR-CODE = WS-O OR WS-P) AND WS-TEST-TYPE = WS-A   
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-NONREG2-MSG TO WS-ERROR-MSG                       
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   VALIDATE THE REASON FOR THE TEST                           *          
      ****************************************************************          
      *                                                                         
       2275-SCHEDULE-TEST.                                              
      *                                                                         
           IF GM-LAST-TEST-SEL-CD > SPACES                              
              IF GM-TEST-SCHED-CD = WS-R AND WS-TEST-TYPE = WS-B        
                 MOVE WS-INV-TEST1-MSG TO WS-ERROR-MSG                  
                 MOVE WS-Y TO WS-ERROR-SW                               
              END-IF                                                    
              IF GM-TEST-SCHED-CD NOT = WS-R AND WS-TEST-TYPE = WS-C    
                 MOVE WS-INV-TEST2-MSG TO WS-ERROR-MSG                  
                 MOVE WS-Y TO WS-ERROR-SW                               
              END-IF                                                    
              IF WS-TEST-TYPE = (WS-B OR WS-C)                          
                 NEXT SENTENCE                                          
              ELSE                                                      
                 IF GM-TEST-SCHED-CD > SPACES                           
                    MOVE WS-WARNING-1-MSG TO WS-WARN-MESSAGE            
A05460              MOVE WS-Y TO WS-WARN-SW                             
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF GM-LAST-TEST-SEL-CD = SPACES                              
              IF WS-TEST-TYPE = WS-C                                    
                 MOVE WS-WARNING-2-MSG TO WS-WARN-MESSAGE               
A05460           MOVE WS-Y TO WS-WARN-SW                                
              END-IF                                                    
              IF WS-TEST-TYPE = WS-B                                    
                 MOVE WS-WARNING-3-MSG TO WS-WARN-MESSAGE               
A05460           MOVE WS-Y TO WS-WARN-SW                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ NEWMTR-FILE                                             *          
      ****************************************************************          
      *                                                                         
       3100-READ-NEWMTR-FILE.                                           
      *                                                                         
           READ NEWMTR-FILE                                             
               AT END SET NEWMTR-END TO TRUE                            
           END-READ.                                                    
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITE OUTPUT RECORD                                          *          
      ****************************************************************          
      *                                                                         
       3600-WRITE-FIOCA666.                                             
      *                                                                         
           WRITE FIOCA666.                                              
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT DETAIL RECORD - CHECK FOR HEADERS                      *          
      ****************************************************************          
      *                                                                         
       4300-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-LINE-COUNT > +56                                       
              SET REPORT-NEW-PAGE TO TRUE                               
              MOVE ZEROS TO WS-LINE-COUNT                               
              PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE PRT-ERROR-LINE TO PRT-REPORT-LINE.                      
           MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-ERROR-LINE2 TO PRT-REPORT-LINE.                     
           MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT HEADERS                                                *          
      ****************************************************************          
      *                                                                         
       4310-HEADER-CTRLRPT1.                                            
      *                                                                         
           MOVE +0                 TO WS-LINE-COUNT.                    
           MOVE WS-PAGE-COUNT      TO PRT-HDR-PAGE.                     
           MOVE PRT-REPORT-HEADER1 TO PRT-REPORT-LINE.                  
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER2 TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER3 TO PRT-REPORT-LINE.                  
           MOVE 2                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT REPORT                                                 *          
      ****************************************************************          
      *                                                                         
       4500-PRINT-REPORT.                                               
      *                                                                         
           IF REPORT-NEW-PAGE                                           
              WRITE PRT-REPORT AFTER ADVANCING PAGE                     
              SET REPORT-FIRST-LINE TO TRUE                             
              MOVE +1 TO WS-LINE-COUNT                                  
              ADD  +1 TO WS-PAGE-COUNT                                  
           ELSE                                                         
              WRITE PRT-REPORT AFTER WS-PRT-REPORT-LINE-SPACE           
              ADD WS-PRT-REPORT-LINE-SPACE TO WS-LINE-COUNT             
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET CURRENT DATE FOR HEADERS                                *          
      ****************************************************************          
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE  = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  7000-GET-CURRENT-DATE              **'       
              DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9100-ABEND THRU 9100-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CONVERT THE INPUT DATE FORMATS INTO DB2 FORMAT              *          
      ****************************************************************          
      *                                                                         
       7011-CONVERT-DATES.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(:WS-DATE1)) E) T),'ISO')
            INTO
              :WS-MTR-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MTR-DATE = CHAR(DATE(TRIM(:WS-DATE1)),ISO)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7011-CONVERT-DATES                   **'      
              DISPLAY '** ERROR CONVERTING INPUT DATE          **'      
              DISPLAY '** NOT ABENDING - SEND RECORD TO REPORT **'      
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** WS-DATE1 = ' WS-DATE1                         
              DISPLAY '******************************************'      
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-DATE-ERROR-MSG TO WS-ERROR-MSG                    
           END-IF.                                                      
      *                                                                         
       7011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_GAS_METER                                               *          
      ****************************************************************          
      *                                                                         
       7100-SELECT-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TEST_SCHED_CD                                      
                    ,LAST_TEST_SEL_CD                                   
                INTO :GM-TEST-SCHED-CD                                  
                    ,:GM-LAST-TEST-SEL-CD                               
                FROM CSS_GAS_METER WITH(READUNCOMMITTED)                        
               WHERE METER_NO = :WS-METER-NO                            
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TEST_SCHED_CD                                              
MFA-TR*             ,LAST_TEST_SEL_CD                                           
MFA-TR*         INTO :GM-TEST-SCHED-CD                                          
MFA-TR*             ,:GM-LAST-TEST-SEL-CD                                       
MFA-TR*         FROM CSS_GAS_METER                                              
MFA-TR*        WHERE METER_NO = :WS-METER-NO                                    
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-MTR-EXIST-MSG TO WS-ERROR-MSG                  
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '**     PCSCA666 PROCESSING ERROR       **'    
                 DISPLAY '**       7100-SELECT-GAS-METER         **'    
                 DISPLAY '**  SELECT FOR CSS_GAS_METER FAILED    **'    
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  METER-NO = ' WS-METER-NO                  
                 DISPLAY '*****************************************'    
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_GAS_METER_SIZE M5                                       *          
      ****************************************************************          
      *                                                                         
       7125-SELECT-METER-SIZE.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT METER_SIZE_ID                                      
                INTO :M5-METER-SIZE-ID                                  
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE METER_SIZE_ID = :WS-METER-TYPE                     
                 AND COMPANY_NO    = :WS-COMPANY-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_SIZE_ID                                              
MFA-TR*         INTO :M5-METER-SIZE-ID                                          
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE METER_SIZE_ID = :WS-METER-TYPE                             
MFA-TR*          AND COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = 100                            
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-INV-TYPE-MSG TO WS-ERROR-MSG                   
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '*      PCSCA666 PROCESSING ERROR         *'   
                 DISPLAY '*      7125-SELECT-METER-SIZE            *'   
                 DISPLAY '*   SELECT FOR CSS_GAS_METER_SIZE FAILED *'   
                 DISPLAY '*   SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '*   METER_SIZE_ID = ' WS-METER-TYPE           
                 DISPLAY '******************************************'   
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_EQUIPMENT  -  EQ                                        *          
      ****************************************************************          
      *                                                                         
       7150-SELECT-SERIAL-NO.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT DEVICE_NO                                          
                    ,SERIAL_NO                                          
                    ,CODE_CRNT_LOC                                      
                    ,CRNT_LOC_NO                                        
                    ,LOCAL_OFFICE                                       
                INTO :EQ-DEVICE-NO                                      
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-LOCAL-OFFICE                                   
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE DEVICE_NO      = :WS-METER-NO                      
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND COMPANY_NO     = :WS-COMPANY-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DEVICE_NO                                                  
MFA-TR*             ,SERIAL_NO                                                  
MFA-TR*             ,CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*         INTO :EQ-DEVICE-NO                                              
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EQ-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE DEVICE_NO      = :WS-METER-NO                              
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :WS-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF EQ-SERIAL-NO NOT = WS-MFG-SERIAL                       
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-SER-MSG2 TO WS-ERROR-MSG                       
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-MTR-EXIST2-MSG TO WS-ERROR-MSG                 
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '**     PCSCA666 PROCESSING ERROR         **'  
                 DISPLAY '**     7150-SELECT-SERIAL-NO             **'  
                 DISPLAY '**  SELECT FOR CSS_EQUIPMENT FAILED      **'  
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  DEVICE_NO      = ' WS-METER-NO            
                 DISPLAY '**  CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE      
                 DISPLAY '*******************************************'  
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_EQUIP_TEST_TYP  - M9                                    *          
      ****************************************************************          
      *                                                                         
       7175-SELECT-TEST-TYPE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TEST_TYPE_DESC                                     
                INTO :M9-TEST-TYPE-DESC                                 
                FROM CSS_EQUIP_TEST_TYP WITH(READUNCOMMITTED)                   
               WHERE CODE_TEST_TYPE = :WS-TEST-TYPE                     
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TEST_TYPE_DESC                                             
MFA-TR*         INTO :M9-TEST-TYPE-DESC                                         
MFA-TR*         FROM CSS_EQUIP_TEST_TYP                                         
MFA-TR*        WHERE CODE_TEST_TYPE = :WS-TEST-TYPE                             
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE M9-TEST-TYPE-DESC TO WS-TEST-TYPE-DESC               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-TEST-TYPE-MSG TO WS-ERROR-MSG                  
                 MOVE SPACES TO WS-TEST-TYPE-DESC                       
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '**     PCSCA666 PROCESSING ERROR         **'  
                 DISPLAY '**     7175-SELECT-TEST-TYPE             **'  
                 DISPLAY '**  SELECT FOR CSS_EQUIP_TEST_TYP        **'  
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  TEST TYPE      = ' WS-TEST-TYPE           
                 DISPLAY '**  CODE_UTIL_TYPE = ' WS-CODE-UTIL-TYPE      
                 DISPLAY '*******************************************'  
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CSS_EQUIP_TST_REPR  - N3                                    *          
      ****************************************************************          
      *                                                                         
       7200-SELECT-REPAIR-DESC.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TEST_REPAIR_DESC                                   
                INTO :N3-TEST-REPAIR-DESC                               
                FROM CSS_EQUIP_TST_REPR WITH(READUNCOMMITTED)                   
               WHERE CODE_REPAIR    = :WS-REPAIR-CODE                   
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND COMPANY_NO     = :WS-COMPANY-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TEST_REPAIR_DESC                                           
MFA-TR*         INTO :N3-TEST-REPAIR-DESC                                       
MFA-TR*         FROM CSS_EQUIP_TST_REPR                                         
MFA-TR*        WHERE CODE_REPAIR    = :WS-REPAIR-CODE                           
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                        
MFA-TR*          AND COMPANY_NO     = :WS-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-REPAIR-MSG TO WS-ERROR-MSG                     
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '**     PCSCA666 PROCESSING ERROR         **'  
                 DISPLAY '**     7200-SELECT-REPAIR-DESC           **'  
                 DISPLAY '**  SELECT FOR CSS_EQUIP_TST_REPR        **'  
                 DISPLAY '**  SQLCODE  = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY '**  WS-REPAIR-CODE    = ' WS-REPAIR-CODE      
                 DISPLAY '**  WS-CODE-UTIL-TYPE = ' WS-CODE-UTIL-TYPE   
                 DISPLAY '**  WS-COMPANY-NO     = ' WS-COMPANY-NO       
                 DISPLAY '*******************************************'  
                 PERFORM 9100-ABEND THRU 9100-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES FILES AT NORMAL TERMINATION                           *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA666-FILE                                          
                 NEWMTR-FILE                                            
                 PRINTER1.                                              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FOLLOWING PROCESS IS INVOKED WHEN ABNORMAL TERMINATION.      *          
      ****************************************************************          
      *                                                                         
       9100-ABEND.                                                      
      *                                                                         
           MOVE +9 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
