       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA665.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  SEPTEMBER 2015.                                   
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                         DB2                                **          
      ****************************************************************          
      *  COMMENTS: THIS PROGRAM READS THE -9 GENERATION OF A FILE    *          
      *    CREATED IN PCSBW105.  IT IS SORTED PRIOR TO INPUT INTO    *          
      *    THIS PROGRAM TO GET RID OF ANY DUPLICATE RECORDS.         *          
      *    THE PURPOSE FOR READING THE -9 GENERATION IS TO GIVE      *          
      *    THE ORDERS A FEW DAYS TO POST.  THIS PROGRAM CHECKS       *          
      *    CSS_EQUIPMENT TO SEE IF CODE_CRNT_LOC IN ('J', 'K'),      *          
      *    WHICH IS 'INSTALLED AT PREMISE OR 'ATTACHED TO THE METER'.*          
      *    OMITS METERS FROM THE OUTPUT FILE THAT ARE NOW AT THE     *          
      *    PREMISE.                                                  *          
      *                                                              *          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  9/30/2015 RF10596        REWRITE CSR105 (EZTRIEVE) INTO   **          
      **                           A COBOL PROGRAM.                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW105.                                                           
      *                                                                         
      ****************************************************************          
      * SELECT STATEMENT FOR OUTPUT FIOBW105 FILE                    *          
      ****************************************************************          
      *                                                                         
           SELECT OUTBW105-FILE                                         
             ASSIGN UT-S-OUTBW105                                       
             STATUS IS WS-OUT105-STATUS.                                
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW105.                                                           
      *                                                                         
       COPY FIOBW105.                                                           
      *                                                                         
      ***************************************************************           
      ** OUPUT FILE HAS SAME FORMAT AS INPUT FILE                  **           
      ***************************************************************           
      *                                                                         
       FD  OUTBW105-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
       01  OUTBW105      PIC X(450).                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA665'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-MISCELLANEOUS.                                             
          05 WS-PREMISE                PIC S9(10)V COMP-3 VALUE 0.      
          05 WS-COMPANY-NO             PIC XX   VALUE SPACES.           
          05 WS-METER-NO               PIC X(9) VALUE SPACES.           
          05 WS-EORG                   PIC X    VALUE SPACES.           
          05 WS-E                      PIC X    VALUE 'E'.              
          05 WS-G                      PIC X    VALUE 'G'.              
          05 WS-YES                    PIC X    VALUE 'Y'.              
          05 WS-EOF-FLAG               PIC X    VALUE 'N'.              
             88 END-OF-FILE                     VALUE 'Y'.              
          05 WS-FBW105-STATUS          PIC XX.                          
             88 FBW105-SUCCESSFUL               VALUE '00'.             
          05 WS-OUT105-STATUS          PIC XX.                          
             88 OUT105-SUCCESSFUL               VALUE '00'.             
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT - EQ                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBEQUIP                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAIN.                                                       
      *                                                                         
           OPEN INPUT FCSBW105-FILE.                                    
      *                                                                         
           IF FBW105-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '    ABENDING PROGRAM    '                        
              DISPLAY '  0000-MAIN '                                    
              DISPLAY ' FCSBW105 OPEN FILE ERROR'                       
              DISPLAY ' FBW105 FILE STATUS = ' WS-FBW105-STATUS         
              DISPLAY '******************************************'      
              MOVE +12 TO RETURN-CODE                                   
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT OUTBW105-FILE.                                   
      *                                                                         
           PERFORM 7000-READ-FILE THRU 7000-EXIT.                       
      *                                                                         
           IF E-FBW105-MESSAGE-AREA = 'NO DATA FOR THIS RUN'            
                OR END-OF-FILE                                          
              DISPLAY '******************************************'      
              DISPLAY '*      PCSCA665                          *'      
              DISPLAY '*      0000-MAIN                         *'      
              DISPLAY '*  NO DATA FOR THIS RUN                  *'      
              DISPLAY '******************************************'      
              MOVE 0 TO RETURN-CODE                                     
           ELSE                                                         
              PERFORM 1000-PROCESS-FILE THRU 1000-EXIT                  
                UNTIL END-OF-FILE                                       
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PROCESS INPUT RECORD                                        *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-FILE.                                               
      *                                                                         
           MOVE SPACES TO WS-EORG.                                      
           IF E-FBW105-ERT-TYPE = '02' OR '12'                          
              MOVE WS-G TO WS-EORG                                      
           ELSE                                                         
              MOVE WS-E TO WS-EORG                                      
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW105-COMPANY-NO TO WS-COMPANY-NO.                   
           MOVE E-FBW105-METER-NO   TO WS-METER-NO.                     
           PERFORM 8000-CHECK-EQUIPMENT THRU 8000-EXIT.                 
      *                                                                         
           IF SQLCODE = 100                                             
              MOVE FIOBW105 TO OUTBW105                                 
              PERFORM 8200-WRITE-OUTBW105 THRU 8200-EXIT                
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FILE THRU 7000-EXIT.                       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  READ THE INPUT FILE                                         *          
      ****************************************************************          
      *                                                                         
       7000-READ-FILE.                                                  
      *                                                                         
           READ FCSBW105-FILE                                           
                AT END MOVE WS-YES TO WS-EOF-FLAG.                      
      *                                                                         
           IF FBW105-SUCCESSFUL OR END-OF-FILE                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**   PCSCA665 PROCESSING ERROR     **'           
              DISPLAY '**   ABEND IN PARAGRAPH 7000       **'           
              DISPLAY '**  READ STATUS   = ' WS-FBW105-STATUS           
              DISPLAY '*************************************'           
              MOVE +12 TO RETURN-CODE                                   
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CHECK ON CSS_EQUIPMENT  - IF NOT FOUND, WRITE THIS RECORD   *          
      *      TO THE OUTPUT FILE.                                     *          
      ****************************************************************          
      *                                                                         
       8000-CHECK-EQUIPMENT.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT CRNT_LOC_NO                                        
                INTO :WS-PREMISE                                        
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO     = :WS-COMPANY-NO                    
                 AND DEVICE_NO      = :WS-METER-NO                      
                 AND CODE_UTIL_TYPE = :WS-EORG                          
                 AND CODE_CRNT_LOC  IN ('J', 'K')                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CRNT_LOC_NO                                                
MFA-TR*         INTO :WS-PREMISE                                                
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO     = :WS-COMPANY-NO                            
MFA-TR*          AND DEVICE_NO      = :WS-METER-NO                              
MFA-TR*          AND CODE_UTIL_TYPE = :WS-EORG                                  
MFA-TR*          AND CODE_CRNT_LOC  IN ('J', 'K')                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0 OR 100                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '*      PCSCA665 PROCESSING ERROR         *'      
              DISPLAY '*      8000-CHECK-EQUIPMENT              *'      
              DISPLAY '*   SQLCODE  = ' SQLCODE                         
              DISPLAY '* METER NBR = ' E-FBW105-METER-NO                
              DISPLAY '* ERT-TYPE  = ' E-FBW105-ERT-TYPE                
              DISPLAY '*         JOB TERMINATING                *'      
              DISPLAY '******************************************'      
              MOVE +12 TO RETURN-CODE                                   
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  WRITE THE OUTPUT RECORD.                                    *          
      ****************************************************************          
      *                                                                         
       8200-WRITE-OUTBW105.                                             
      *                                                                         
           WRITE OUTBW105.                                              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * JOB TERMINATION - NORMAL AND ABNORMAL                        *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
