       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA656.                                        
       DATE-WRITTEN.   SEP 1997.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS     REASON                             **  00160000
      **  ________  ________     _________________________________  **  00170000
T16229**                                                            **  00154007
T16229**    05/98     CBSI     UTIL-TYPE IS ALSO PASSED TO THE CALLED*  00155007
T16229**                       PROGRAM ALONG WITH OTHER DETAILS.    **  00156007
T16852**                                                            **  00154007
T16852**    06/98     CBSI     JOB PARM PROCESSING IS CHANGED. RECORD*  00155007
T16852**                       WITH SELECT QTY IS REQUIRED ONLY FOR **  00156007
T16852**                       RUN TYPE ADDITIONAL OTHERWISE 3 & 4  **  00156007
T16852**                       RECORDS ARE OPTIONAL. CODE CHANGED   **  00156007
T16852**                       TO CONSIDER METERS AT OLD-ACCOUNTS   **  00156007
T16852**                       ALSO FOR SAMPLE METER TESTING.       **  00156007
T19314**    03/99     CBSI     CHANGES MADE TO CREATE SERVICE ORDERS**  00155007
T19314**                       FOR EACH OF THE MTRS SELECTED FROM   **  00156007
T19314**                       THE NEW SYSTEM.                      **  00156007
T20234**    06/99      CBSI     DELETED THE CODE WHICH ACCESS THE OLD**         
T20234**               MADRAS   SYSTEM TO GET THE ACCOUNT AND METER  **         
T20234**                        DETAILS AND INCLUDED LOGIC TO GET    **         
T20234**                        ACCOUNT NO FROM CPD00099.            **         
      **    07/00      ISD      COMMENTED OUT 8100-UPDATE TEMPARARILY**         
      **               RK12999  FOR ADDITIONAL MTR SELECTION W/OUT   **         
      **                        TABLE INCREMENTATION. REMOVE B/F     **         
      **                        2001 SELECTION.(REMOVE 11/00)        **         
T22243**    08/00      RK12999 CHANGES MADE TO IMPLEMENT MULTI-     **          
T22243**                       COMPANY IN METER INVENTORY.          **          
      **    08/00      RK12999 ADDED TEMPORARY CODE TO PULL ALL     **          
      **                       MTRS OF A GROUP. REMOVE BEFORE 2001. **          
      **    11/00      RK12999 ADDED GAS BILLING ACCOUNT INFO CODE  **          
      **                       TO THE ADDITIONAL PULL ROUTINES.     **          
T23377**    12/00      GSR     CHANGES MADE TO SELECT METERS BASED  **          
T23377**                       ON LAST TEST DATE FOR PSNC.          **          
T23377**                       TEMPORARY CODE IS DELETED BY RNK.    **          
      **    02/04      RK12999 REMOVED GAS BILLING ACCOUNT INFO     **          
      **                       CODE DUE TO THEIR CONVERSION.        **          
C31091**    07/04      VD88125 SELECT MTR_TEST_GRP_TX FROM MTR_TEST_**          
C31091**                       HIST TABLE INSTEAD CSS_MTR_TEST_GROUP**          
A01209**    10/22/09   BG17805 ADD GROUPS '43' THRU '46'            **          
A01209**                                                            **          
A01209**    03/11/10   SP94986 1. REMOVED THE LOCAL OFFICE CHECKS.  **          
A01209**                       2. USED THE CUST_NOFITY_FL FOR LETTERS**         
A01209**                          AND SO_REQUIRED_FL FOR GROUPS FROM **         
A01209**                          CSS_MTR_GROUP_TEST.                **         
A01209**                       3. REMOVED THE JOB_PARM CURSOR & ADDED**         
A01209**                          WITH UR STATS TO CURSORS.          **         
ACT019** 05/25/11      MC95456    TWO NEW FIELDS ARE TO BE POPULATED            
ACT019** A03082-ACT019            IN FIOCA66 TO MAKE USE OF THEM IN             
ACT019**                          REPORT DISPLAY.                               
ACT040** A03967-ACT040 BD09555 SET RETURN CODE 2 IN FORECAST MODE               
ACT018** A04527-ACT018 DB41297 INCREASE TABLE LIMIT.                            
ACT058** A04880-ACT058 BD09555 ADD CHECKS TO PREVENT LOOPING.                   
ACT058** A04880-ACT058 ADDITIONAL LOGIC TO ALLOW WHEN RANDOM NUMBER OF          
ACT058** A04880-ACT058 ZERO IS SELECTED.  WHEN 'ADDITIONAL' METERS ARE          
ACT058** A04880-ACT058 SELECTED, USE THE POPULATION SIZE BASED ON THE           
ACT058** A04880-ACT058 NUMBER AVAILABLE, INSTEAD OF THE NUMBER INSTALLED        
ACT058** A04880-ACT058 SINCE SOME HAVE ALREADY BEEN SELECTED.                   
ACT047** A05136-ACT047 BD09555  INCREASE SIZE OF TEST GROUP TABLE TO 200        
ACT069** A05460-ACT069 DB41297 REMOVE REDUNDANT CODE.                           
ACT194** A05460-ACT194 TP7R341 REMOVE WS-B AND HARDCODE THE VALUE 'B'           
P01176**                                                                        
P01176** 09/2016  NC94746  CHANGES RELATED TO AUTOMATED GAS SAMPLING *          
      ******************************************************************        
           REMARKS.                                                     
                              PCSCA656 NARRATIVE                        
                       SELECT GAS  METERS FOR SAMPLE TESTING            
      *                                                                         
                 THIS PROGRAM SELECTS GAS METERS FOR SAMPLE TESTING.    
                 WHEN A METER IS SELECTED,LAST_TEST_SEL_CD AND          
                 LAST_TEST_SEL_DT ON CSS_GAS_METER WILL BE              
                 POPULATED.A JOB PARM CAN BE USED TO RUN THE PROGRAM    
                 TO ONLY COUNT THE INSTALLED METERS, DETERMINE THE      
                 SAMPLE SIZE, AND CREATE THE OUTPUT FILE FOR            
                 PCSMT651, BUT TO NOT SELECT THE METERS OR UPDATE       
                 THE POPULATION AND SAMPLE SIZE INFORMATION ON          
                 CSS_MTR_TEST_HIST.                                     
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-3090 WITH DEBUGGING MODE.                   
       OBJECT-COMPUTER. IBM-3090.                                       
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT POPULATION-SAMPLE-FILE ASSIGN TO FCSRP61              
                        STATUS IS WS-SAMPFIL-STATUS.                    
           SELECT METER-DETAIL-FILE      ASSIGN TO FIOCA66              
                        STATUS IS WS-METFIL-STATUS.                     
           SELECT LETTER-DETAIL-FILE     ASSIGN TO LETTERS              
                        STATUS IS WS-METFIL-STATUS.                     
           SELECT UNSORTED-RANDOM-FILE   ASSIGN TO UNSORTED             
                        STATUS IS WS-UNSORTEDFIL-STATUS.                
           SELECT SORTED-RANDOM-FILE     ASSIGN TO SORTED               
                        STATUS IS WS-SORTEDFIL-STATUS.                  
           SELECT RANDOM-NBR-FILE        ASSIGN TO RANDOMFL             
                        STATUS IS WS-RANDOMFIL-STATUS.                  
           SELECT SORT-FILE              ASSIGN TO TEMP.                
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  POPULATION-SAMPLE-FILE                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  POP-SAMPLE-REC              PIC X(89).                       
      *                                                                         
       FD  METER-DETAIL-FILE                                            
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  METER-DETAIL-REC            PIC X(572).                      
      *                                                                         
       FD  LETTER-DETAIL-FILE                                           
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  LETTER-DETAIL-REC           PIC X(572).                      
      *                                                                         
       FD  UNSORTED-RANDOM-FILE                                         
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  UNSORTED-RANDOM-REC.                                         
           05 UNSORTED-RANDOM-NBR      PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                         
       FD  SORTED-RANDOM-FILE                                           
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  SORTED-RANDOM-REC.                                           
           05 WS-RANDOM-NBR            PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                         
       FD  RANDOM-NBR-FILE                                              
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  RANDOM-NUMBER-REC.                                           
           05 RANDOM-NBR               PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                         
       SD  SORT-FILE.                                                   
       01  SORT-REC.                                                    
           05 S-RANDOM-NBR             PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA656'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA656 STARTS HERE'.                  
      *                                                                         
       01  PROGRAM-NAME                PIC X(08)    VALUE 'PCSCA656'.   
      *                                                                         
      *THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER                   
      *WHICH INVOKES THE ABEND ROUTINE                                          
       COPY CWS09900.                                                           
      *COPYBOOK HAVING NOT-FOUND                                                
       COPY CWS00303.                                                           
      *ABEND WORK AREA                                                          
       COPY CWS00010.                                                           
      *COPYBOOK USED BY CPD00074                                                
       COPY CWS00074.                                                           
      *COPYBOOK FOR POPULATION SAMPLE FILE                                      
       COPY FCSRP61.                                                            
      *COPYBOOK FOR METER-DETAIL-FILE & LETTER-DETAIL-FILE                      
       COPY FIOCA66.                                                            
      *COPYBOOK HAVING IO AREA FOR PARAMETER INPUT FILE                         
       COPY FIOJC01.                                                            
      *COPYBOOK FOR 6010-REDUCE-EMBEDDED-SPACES                                 
       COPY CWS00011.                                                           
      *COPYBOOK FOR TABLE B-3 WHICH IS THE SAMPLE METER TEST SIZE               
      *TABLE BY GROUP SIZE.                                                     
T20234******************************************************************        
T20234* WORKING STORAGE FOR CPD00099                                   *        
T20234******************************************************************        
T20234     EXEC SQL                                                             
T20234         INCLUDE CWS00099                                                 
T20234     END-EXEC.                                                            
T20234*                                                                         
      * B-3 TABLE FOR SCEG VALUES                                      *        
       COPY ELCHSAMP.                                                           
      *                                                                         
      * B-3 TABLE FOR PSNC VALUES                                      *        
       COPY GMCCSAMP.                                                           
      *                                                                         
       01  WS-WORK-AREA.                                                
ACT058     05  WS-DISPLAY-RC           PIC S9(04)   COMP  VALUE +0.     
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA656'.   
           05  WS-FETCH-ALL-MTRS       PIC 9(08)    VALUE 0.            
           05  WS-NBR-OF-FETCHES       PIC 9(08)    VALUE 0.            
           05  WS-METER-NUM-INDEX      PIC 9(08)    VALUE 0.            
           05  WS-NBR-RANDOM-NBRS      PIC 9(09)    VALUE 0.            
           05  WS-METER-SEQ            PIC 9(08)    VALUE 0.            
           05  WS-RANDOM-INDEX         PIC 9(08)    VALUE 0.            
COB305     05 WS-TEMP        PIC 9(15) COMP-3 VALUE 0.             
           05  WS-SUB                  PIC 9(04)    VALUE 0.            
           05  RS-RETURN-CODE          PIC S9(04)   COMP.               
ACT040     05  WS-RETURN-CODE          PIC S9(04)   COMP   VALUE 0.     
           05  WS-INITIAL-SEED-JUSTIFIED                                
                                       PIC X(10) JUSTIFIED RIGHT.       
           05  WS-PARM-TEST-YEAR       PIC 9(04).                       
           05  WS-PARM-RUN-TYPE        PIC X(10).                       
ACT058         88 SELECTING-ADDITIONAL           VALUE 'ADDITIONAL'.    
ACT047     05  WS-MAX-TEST-GROUP-ENTRIES  PIC S9(4) COMP VALUE 200.     
ACT047     05  WS-PARM-TEST-GRP        OCCURS 200 TIMES.                
               10 WS-PARM-TEST-GRP-3      PIC X(02).                    
ACT047     05  WS-PARM-SEL-QTY         OCCURS 200 TIMES.                
               10 WS-PARM-SELECT-QTY      PIC 9(04).                    
           05  WS-PARM-TEST-GRP-4      PIC X(02).                       
           05  WS-PARM-INITIAL-SEED    PIC X(10).                       
           05  WS-RUN-TYPE-GIVEN       PIC X(01) VALUE 'Y'.             
           05  WS-DATE-LAST-TESTED-NULLIND                              
                                       PIC S9(04) COMP VALUE -1.        
           05  WS-SELECTED-QT          PIC S9(9) USAGE COMP.            
           05  WS-SAMPLE-MIN-QT        PIC S9(9) USAGE COMP.            
           05  WS-CALL-SCSCA657        PIC X(01) VALUE 'N'.             
T22243     05  WS-SYSIN-COMP-NO        PIC X(02) VALUE SPACES.          
T23377     05  WS-SELECT-YEAR          PIC S9(4) COMP.                  
      *                                                                         
           05  COUNTERS.                                                
               10  WS-COUNT-UPD-GAS-MTR                                 
                                       PIC 9(7)     VALUE 0.            
               10  WS-TOT-TEST-GROUPS                                   
                                       PIC S9(7)    VALUE +1.           
               10  WS-COUNT            PIC S9(7)    VALUE +0.           
               10  WS-COUNT-1          PIC S9(7)    VALUE +0.           
               10  WS-CTR-I            PIC S9(7)    VALUE +0.           
               10  WS-CTR-J            PIC S9(7)    VALUE +1.           
               10  WS-CTR-K            PIC S9(7)    VALUE +0.           
               10  WS-INSPECT-CNTR     PIC 99       VALUE  0.           
               10  WS-SO-INDEX         PIC S9(7)    VALUE +0.           
               10  WS-END-OF-FILE      PIC X(01)    VALUE SPACES.       
COB305         10 WS-GRP-COUNT        PIC 9(07) COMP-3 VALUE 0.             
           05  WS-SWITCHES.                                             
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-IS-INPUT-VALID   PIC X(01)    VALUE 'Y'.          
                   88  INPUT-IS-VALID               VALUE 'Y'.          
                   88  INPUT-IS-INVALID             VALUE 'N'.          
               10  WS-FOUND            PIC X(01)    VALUE 'N'.          
                   88  FOUND                        VALUE 'Y'.          
               10  WS-SAMPLE-SIZE-FOUND PIC X(01)   VALUE 'N'.          
                   88  SAMPLE-SIZE-FOUND            VALUE 'Y'.          
               10  WS-END-MTR-TEST-GRP PIC X(01)    VALUE 'N'.          
                   88  END-MTR-TEST-GRP             VALUE 'Y'.          
               10  WS-END-SAMPLE-METER-REC PIC X(01) VALUE 'N'.         
                   88  END-SAMPLE-METER-REC          VALUE 'Y'.         
               10  WS-NO-REC-FOUND         PIC X(01) VALUE 'N'.         
                   88  NO-REC-FOUND                  VALUE 'Y'.         
               10  WS-VALID-RANDOM-NBR     PIC X(01) VALUE 'Y'.         
                   88  VALID-RANDOM-NBR              VALUE 'N'.         
               10  WS-INVALID-RANDOM-NBR   PIC X(01) VALUE 'N'.         
                   88  INVALID-RANDOM-NBR            VALUE 'Y'.         
               10  WS-EXIT-LOOP            PIC X(01) VALUE 'N'.         
                   88  EXIT-LOOP                     VALUE 'Y'.         
               10  WS-MAX-RAN-NUM-REACHED  PIC X(01) VALUE 'N'.         
                   88  MAX-RAN-NUM-REACHED           VALUE 'Y'.         
               10  WS-ACCT-XREF-SW         PIC X(01) VALUE 'Y'.         
                   88  NAME-ACCT-XREF-FOUND          VALUE 'Y'.         
                   88  NAME-ACCT-XREF-NOT-FOUND      VALUE 'N'.         
               10  WS-SAMPFIL-STATUS       PIC X(02) VALUE '00'.        
                   88  SAMPFIL-SUCCESS               VALUE '00'.        
               10  WS-METFIL-STATUS        PIC X(02) VALUE '00'.        
                   88  METFIL-SUCCESS                VALUE '00'.        
               10  WS-LETFIL-STATUS        PIC X(02) VALUE '00'.        
                   88  LETFIL-SUCCESS                VALUE '00'.        
               10  WS-UNSORTEDFIL-STATUS   PIC X(02) VALUE '00'.        
                   88  UNSORTFIL-SUCCESS             VALUE '00'.        
               10  WS-SORTEDFIL-STATUS     PIC X(02) VALUE '00'.        
                   88  SORTFIL-SUCCESS               VALUE '00'.        
               10  WS-RANDOMFIL-STATUS     PIC X(02) VALUE '00'.        
                   88  RANDOMFIL-SUCCESS             VALUE '00'.        
T16852         10  WS-MAST-FILE-STATUS     PIC X(02) VALUE '00'.        
T16852             88  MAST-FILE-SUCCESS             VALUE '00' '97'.   
T16852             88  END-OF-MAST-FILE              VALUE '99'.        
T16852         10  WS-MTR-FILE-STATUS      PIC X(02) VALUE '00'.        
T16852             88  MTR-FILE-SUCCESS              VALUE '00' '97'.   
T16852             88  DUPLICATE-KEY                 VALUE '22'.        
T16852             88  RECORD-NOT-FOUND              VALUE '23'.        
T23377         10  WS-GRP-CD-FOUND         PIC X(01) VALUE 'N'.         
T23377             88  GRP-CD-FOUND                  VALUE 'Y'.         
               10  WS-TRACE-SWITCH         PIC X(01) VALUE 'N'.         
                   88  READY-TRACE                   VALUE 'Y'.         
                                                                        
           05  WS-JOB-PARM-2           PIC X(01)    VALUE 'N'.          
           05  WS-JOB-PARM-3           PIC X(01)    VALUE 'N'.          
           05  WS-JOB-PARM-4           PIC X(01)    VALUE 'N'.          
P01176     05  WS-AUTOMATIC-TST-FL     PIC X(01).                       
           05  WS-CURRENT-INSTALLED-QTY                                 
                                       PIC S9(09)   USAGE COMP          
                                       VALUE ZEROES.                    
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-SYS-TIME.                                             
               10  WS-SYS-TIME-HR      PIC 9(02).                       
               10  WS-SYS-TIME-MIN     PIC 9(02).                       
               10  WS-SYS-TIME-SEC     PIC 9(02).                       
               10  WS-SYS-TIME-HSEC    PIC 9(02).                       
           05  WS-DB2-DATE.                                             
               10  WS-DB2-YEAR .                                        
                   15  WS-DB2-CC       PIC 9(02).                       
                   15  WS-DB2-YY       PIC 9(02).                       
               10  FILLER REDEFINES WS-DB2-YEAR.                        
                   15  WS-DB2-YEARS        PIC S9(04) COMP.             
               10  FILLER              PIC X.                           
               10  WS-DB2-MM           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-DD           PIC X(2).                        
           05  WS-RANDOM-NUM-VARIABLES.                                 
COB305         10 ISEC        PIC 9(15) COMP-3 VALUE 0.             
COB305         10 IMIN        PIC 9(15) COMP-3 VALUE 0.             
COB305         10 IHR        PIC 9(15) COMP-3 VALUE 0.             
COB305         10 IDAY        PIC 9(15) COMP-3 VALUE 0.             
COB305         10 IMON        PIC 9(15) COMP-3 VALUE 0.             
COB305         10 IYR        PIC 9(15) COMP-3 VALUE 0.             
               10  WS-1                PIC 9(15)    COMP-3   VALUE 1.   
               10  WS-12               PIC 9(15)    COMP-3   VALUE 12.  
               10  WS-24               PIC 9(15)    COMP-3   VALUE 24.  
               10  WS-31               PIC 9(15)    COMP-3   VALUE 31.  
               10  WS-60               PIC 9(15)    COMP-3   VALUE 60.  
COB305         10 WS-RANDOM-SEED        PIC 9(15) COMP-3 VALUE 0.             
               10  WS-RANDOM-M         PIC 9(15)    COMP-3              
                                       VALUE   2147483647.              
               10  WS-RANDOM-A         PIC 9(15)    COMP-3 VALUE 16807. 
COB305         10 WS-RANDOM-X        PIC 9(15) COMP-3 VALUE 0.             
               10  WS-RANDOM-R                      COMP-2.             
COB305         10 WS-RANDOM-NBR-TEST        PIC 9(07) COMP-3 VALUE 0.           
               10  WS-MAX-RANDOM-NBR   PIC 9(3)     COMP-3 VALUE 250.   
               10  WS-REMAINDER        PIC S9(3)V99 COMP-3  VALUE +0.   
               10  WS-DIV-REMAINDER    PIC S9(3)V99 COMP-3  VALUE +0.   
               10  WS-REM-RANDOM       PIC 9(15)    VALUE 0.            
               10  WS-DIV-RANDOM       PIC 9(15)    VALUE 0.            
               10  WS-LIMIT            PIC 9(3)     VALUE 0.            
      *                                                                         
       01  WS-RANDOM-NBR-TABLE.                                         
COB305     05 WS-RANDOM-NBR-ARRAY        PIC 9(07) COMP-3 OCCURS       
COB305                                                  250 TIMES 
COB305       VALUE 0.      
      *                                                                         
       01  WS-SCSCA657-LINKAGE.                                         
T16229     05  WS-SO-UTIL-TYPE         PIC X(01).                       
COB305     05 WS-NBR-METERS        PIC S9(3) COMP-3 VALUE 0.             
           05  WS-SO-DATE              PIC X(10).                       
ACT047     05  WS-SCSCA657-ARRAY       OCCURS  200 TIMES.               
COB305         10 WS-SO-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.             
               10  WS-SO-METER-NO      PIC X(9).                        
               10  WS-SO-TEST-TYPE     PIC X(1).                        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC 9(01)    VALUE 1.            
           05  WS-TWO                  PIC 9(01)    VALUE 2.            
           05  WS-F                    PIC X(01)    VALUE 'F'.          
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-I                    PIC X(01)    VALUE 'I'.          
           05  WS-J                    PIC X(01)    VALUE 'J'.          
T23377     05  WS-P                    PIC X(01)    VALUE 'P'.          
           05  WS-R                    PIC X(01)    VALUE 'R'.          
           05  WS-S                    PIC X(01)    VALUE 'S'.          
T23377     05  WS-T                    PIC X(01)    VALUE 'T'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
T16852     05  WS-X                    PIC X(01)    VALUE 'X'.          
           05  WS-YES                  PIC X(03)    VALUE 'YES'.        
           05  WS-NO                   PIC X(03)    VALUE 'NO '.        
           05  WS-UNKNOWN              PIC X(08)    VALUE 'UNKNOWN '.   
           05  WS-SELECT               PIC X(10)    VALUE 'SELECT'.     
           05  WS-FORECAST             PIC X(10)    VALUE 'FORECAST'.   
           05  WS-ADDITIONAL           PIC X(10)    VALUE 'ADDITIONAL'. 
           05  WS-ACTIVE               PIC X(01)    VALUE 'A'.          
T22243     05  WS-01                   PIC X(02)    VALUE '01'.         
                                                                        
           05  WS-TEST-YEAR            PIC X(12)                        
                                       VALUE  'TEST YEAR = '.           
           05  WS-RUN-TYPE             PIC X(11)                        
                                       VALUE  'RUN TYPE = '.            
           05  WS-TEST-GROUP           PIC X(13)                        
                                       VALUE  'TEST GROUP = '.          
           05  WS-SELECT-QTY           PIC X(13)                        
                                       VALUE  'SELECT QTY = '.          
           05  WS-INITIAL-SEED         PIC X(15)                        
                                       VALUE  'INITIAL SEED = '.        
      *                                                                         
       01  WS-NO-ERROR-LINE.                                            
           05                          PIC X(30)    VALUE               
           'PCSCA656  NO ERRORS WERE FOUND'.                            
           05                          PIC X(50)    VALUE SPACES.       
      *                                                                         
       COPY CWS00038.                                                           
       01 WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05  WS-PARAMETER-REC-1.                                       
              10  WS-TEST-YEAR-TEXT    PIC X(12).                       
              10  WS-TEST-YEAR-VALUE-C PIC X(04).                       
              10  FILLER  REDEFINES WS-TEST-YEAR-VALUE-C.               
                  15 WS-TEST-YEAR-VALUE                                 
                                       PIC 9(04).                       
              10  FILLER               PIC X(64).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-2.                                       
              10  WS-RUN-TYPE-TEXT     PIC X(11).                       
              10  WS-RUN-TYPE-VALUE    PIC X(10).                       
                  88  RUN-TYPE-SELECT            VALUE 'SELECT'.        
                  88  RUN-TYPE-FORECAST          VALUE 'FORECAST'.      
                  88  RUN-TYPE-ADDITIONAL        VALUE 'ADDITIONAL'.    
              10  FILLER               PIC X(59).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-3.                                       
              10 WS-TEST-GROUP-3-TEXT  PIC X(13).                       
              10 WS-TEST-GROUP-VALUE-3 PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-SELECT-QTY-TEXT    PIC X(13).                       
              10 WS-SELECT-QTY-VALUE   PIC 9(04).                       
              10 FILLER                PIC X(47).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-4.                                       
              10 WS-TEST-GROUP-4-TEXT  PIC X(13).                       
              10 WS-TEST-GROUP-VALUE-4 PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-INITIAL-SEED-TEXT  PIC X(15).                       
              10 WS-INITIAL-SEED-VALUE PIC X(10).                       
              10 FILLER                PIC X(40).                       
      *                                                                         
       01 METER-TABLE.                                                  
T16852    05  WS-METER-NO-TBL  OCCURS   250 TIMES.                      
T16852        10  WS-METER-NUMBER          PIC X(09).                   
T16852        10  WS-CRNT-LOC-CD           PIC X(01).                   
      *                                                                         
       01 WS-INSTALLED-QTY-TBL.                                         
ACT047    05  WS-GRP-QTY-TBL OCCURS 200 TIMES.                          
              10  WS-TEST-GRP-CD           PIC X(02).                   
              10  WS-INSTALLED-QTY         PIC 9(08).                   
P01176        10  WS-AUTO-SAMPLE-TST-FL    PIC X(01).                   
      *                                                                         
      ****************************************************************          
      **     INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER,  PREFIX - GM                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_EQUIPMENT,  PREFIX - EQ                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_TST_GROUP,  PREFIX - GG              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASGRP                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_HIST , PREFIX - MQ              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRTST                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_GROUP, PREFIX - GR              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRGP                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_JOB_PARM,       PREFIX - G6              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT,        PREFIX - AT              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_UTIL_ENVRNMT,   PREFIX - UT              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTRD_ENVRNMT,   PREFIX - MN              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
ACT019****************************************************************          
ACT019*    COPYBOOK FOR CSS_METER_TYPE,     PREFIX - M7              *          
ACT019****************************************************************          
ACT019     EXEC SQL                                                             
ACT019         INCLUDE TBMTRTYP                                                 
ACT019     END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_CAP,        PREFIX - MC              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      *****TABLES REQUIRED FOR 4000-MAIL-NAME-ADDRESS                           
      ****************************************************************          
      *    COPYBOOK FOR CSS_NAME,           PREFIX - DQ              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_NAME_ACCT_XREF, PREFIX - HT              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_CUST_ADDR_XREF, PREFIX - DM              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR  CSS_ADDR_FREEFORM, PREFIX - DZ              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_ADDR_FORMATTED, PREFIX - DY              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_ZIP_CODE,       PREFIX - A4              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCT_MISC_INFO, PREFIX - TA              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ***  END OF DCLGEN TABLE AND HOST VARIABLE DEFINITIONS                    
      *                                                                         
      ***  SQL DECLARE STATEMENTS                                               
      *                                                                         
      ****************************************************************          
      **            CURSOR TO SELECT METERS FOR A TEST GROUP        **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE METER-EQUIP-TEST CURSOR FOR                      
               SELECT GM.METER_NO         ,                             
                      GM.TEST_SCHED_CD    ,                             
                      GM.METER_SIZE_ID    ,                             
                      GM.DATE_LAST_TESTED ,                             
ACT019                GM.CODE_METER_TYPE  ,                             
                      EQ.COMPANY_NO       ,                             
T16852                EQ.CODE_CRNT_LOC    ,                             
T16852                EQ.CRNT_LOC_NO      ,                             
                      EQ.CODE_MAKE        ,                             
                      EQ.LOCAL_OFFICE     ,                             
A01209                GR.SO_REQUIRED_FL   ,                             
A01209                GR.CUST_NOTIFY_FL                                 
                 FROM CSS_GAS_METER      GM WITH(READUNCOMMITTED)               
                     ,CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)               
                     ,CSS_GAS_TST_GROUP  GG WITH(READUNCOMMITTED)               
T23377               ,CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)               
                WHERE GG.CODE_UTIL_TYPE    = :MQ-CODE-UTIL-TYPE         
T23377          AND   GR.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE          
                AND   GG.MTR_TEST_GRP_CD   = :MQ-MTR-TEST-GRP-CD        
T23377          AND   GR.MTR_TEST_GRP_CD   = GG.MTR_TEST_GRP_CD         
T20234          AND   EQ.CODE_CRNT_LOC     = 'J'                        
                AND   GM.METER_NO          = EQ.DEVICE_NO               
                AND   GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          
                AND   GM.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE          
T16852          AND   GM.METER_SIZE_ID     = GG.METER_SIZE_ID           
T23377          AND  ((GR.SELECT_TYPE_CD  = :WS-T                       
T23377          AND   (GM.DATE_LAST_TESTED IS NULL                      
T23377           OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT 
T23377                                     AND    GG.END_PURCHASE_DT))) 
T23377           OR   (GR.SELECT_TYPE_CD  = :WS-P                       
T16852          AND   (EQ.DATE_PURCHASED  IS NULL                       
T16852           OR   (EQ.DATE_PURCHASED BETWEEN                        
                                                GG.BEGIN_PURCHASE_DT    
T23377                                   AND    GG.END_PURCHASE_DT))))  
T22243          AND EQ.COMPANY_NO          = :EQ-COMPANY-NO             
T22243          AND GM.COMPANY_NO          = EQ.COMPANY_NO              
T22243          AND GG.COMPANY_NO          = GM.COMPANY_NO              
T23377          AND GR.COMPANY_NO          = GG.COMPANY_NO              
                AND LAST_TEST_SEL_CD       = '  '                       
T16852          ORDER BY METER_NO FOR READ ONLY                        
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE METER-EQUIP-TEST CURSOR FOR                              
MFA-TR*        SELECT GM.METER_NO         ,                                     
MFA-TR*               GM.TEST_SCHED_CD    ,                                     
MFA-TR*               GM.METER_SIZE_ID    ,                                     
MFA-TR*               GM.DATE_LAST_TESTED ,                                     
MFA-TR*               GM.CODE_METER_TYPE  ,                                     
MFA-TR*               EQ.COMPANY_NO       ,                                     
MFA-TR*               EQ.CODE_CRNT_LOC    ,                                     
MFA-TR*               EQ.CRNT_LOC_NO      ,                                     
MFA-TR*               EQ.CODE_MAKE        ,                                     
MFA-TR*               EQ.LOCAL_OFFICE     ,                                     
MFA-TR*               GR.SO_REQUIRED_FL   ,                                     
MFA-TR*               GR.CUST_NOTIFY_FL                                         
MFA-TR*          FROM CSS_GAS_METER      GM                                     
MFA-TR*              ,CSS_EQUIPMENT      EQ                                     
MFA-TR*              ,CSS_GAS_TST_GROUP  GG                                     
MFA-TR*              ,CSS_MTR_TEST_GROUP GR                                     
MFA-TR*         WHERE GG.CODE_UTIL_TYPE    = :MQ-CODE-UTIL-TYPE                 
MFA-TR*         AND   GR.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE                  
MFA-TR*         AND   GG.MTR_TEST_GRP_CD   = :MQ-MTR-TEST-GRP-CD                
MFA-TR*         AND   GR.MTR_TEST_GRP_CD   = GG.MTR_TEST_GRP_CD                 
MFA-TR*         AND   EQ.CODE_CRNT_LOC     = 'J'                                
MFA-TR*         AND   GM.METER_NO          = EQ.DEVICE_NO                       
MFA-TR*         AND   GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE                  
MFA-TR*         AND   GM.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE                  
MFA-TR*         AND   GM.METER_SIZE_ID     = GG.METER_SIZE_ID                   
MFA-TR*         AND  ((GR.SELECT_TYPE_CD  = :WS-T                               
MFA-TR*         AND   (GM.DATE_LAST_TESTED IS NULL                              
MFA-TR*          OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT         
MFA-TR*                                    AND    GG.END_PURCHASE_DT)))         
MFA-TR*          OR   (GR.SELECT_TYPE_CD  = :WS-P                               
MFA-TR*         AND   (EQ.DATE_PURCHASED  IS NULL                               
MFA-TR*          OR   (EQ.DATE_PURCHASED BETWEEN                                
MFA-TR*                                         GG.BEGIN_PURCHASE_DT            
MFA-TR*                                  AND    GG.END_PURCHASE_DT))))          
MFA-TR*         AND EQ.COMPANY_NO          = :EQ-COMPANY-NO                     
MFA-TR*         AND GM.COMPANY_NO          = EQ.COMPANY_NO                      
MFA-TR*         AND GG.COMPANY_NO          = GM.COMPANY_NO                      
MFA-TR*         AND GR.COMPANY_NO          = GG.COMPANY_NO                      
MFA-TR*         AND LAST_TEST_SEL_CD       = '  '                               
MFA-TR*         ORDER BY METER_NO FOR FETCH ONLY                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **           CURSOR TO SELECT METER TEST HISTORY              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE SAMPLE-TEST-HIST CURSOR FOR                      
               SELECT MTR_TEST_GRP_CD    ,                              
                      CODE_UTIL_TYPE     ,                              
                      SAMPLE_MIN_QT      ,                              
                      SAMPL_OVERAGE_PCT  ,                              
                      SAMPL_CORRECTV_PCT ,                              
                      SAMPL_ADDITIONL_QT ,                              
C31091                MTR_TEST_GRP_TX                                   
               FROM   CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                   
               WHERE  CODE_UTIL_TYPE     =  :WS-G                       
               AND    TEST_YEAR          =  :MQ-TEST-YEAR               
               AND    TEST_SCHED_CD      =  :WS-R                       
T22243         AND    COMPANY_NO          = :MQ-COMPANY-NO              
               AND    LAST_TEST_SEL_DT   IS NULL                        
T16852         ORDER  BY MTR_TEST_GRP_CD FOR READ ONLY                 
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SAMPLE-TEST-HIST CURSOR FOR                              
MFA-TR*        SELECT MTR_TEST_GRP_CD    ,                                      
MFA-TR*               CODE_UTIL_TYPE     ,                                      
MFA-TR*               SAMPLE_MIN_QT      ,                                      
MFA-TR*               SAMPL_OVERAGE_PCT  ,                                      
MFA-TR*               SAMPL_CORRECTV_PCT ,                                      
MFA-TR*               SAMPL_ADDITIONL_QT ,                                      
MFA-TR*               MTR_TEST_GRP_TX                                           
MFA-TR*        FROM   CSS_MTR_TEST_HIST                                         
MFA-TR*        WHERE  CODE_UTIL_TYPE     =  :WS-G                               
MFA-TR*        AND    TEST_YEAR          =  :MQ-TEST-YEAR                       
MFA-TR*        AND    TEST_SCHED_CD      =  :WS-R                               
MFA-TR*        AND    COMPANY_NO          = :MQ-COMPANY-NO                      
MFA-TR*        AND    LAST_TEST_SEL_DT   IS NULL                                
MFA-TR*        ORDER  BY MTR_TEST_GRP_CD FOR FETCH ONLY                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** CURSOR TO GET ACCOUNT DETAILS                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCOUNT-DETAIL CURSOR FOR                        
               SELECT UT.ACCOUNT_NO    ,                                
                      UT.RATE_PLAN_NO  ,                                
                      UT.READ_CYCLE    ,                                
                      UT.READ_ROUTE    ,                                
                      AT.CUSTOMER_NO   ,                                
                      AT.CODE_ACCT_STAT,                                
                      AT.LOCAL_OFFICE  ,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') 
           ACCT_CREATE_DT,                                
                      AT.ADDRESS_ID,                                    
ACT019                AT.ADDRESS_FORMAT,                                
ACT019                MN.REGISTER_RD_SEQ                                
               FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                  
                    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                  
                    CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
               WHERE MN.CODE_UTIL_TYPE    = :WS-G                       
               AND   MN.METER_NO          = :MN-METER-NO                
               AND   MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
               AND   MN.IC_NO             = UT.IC_NO                    
               AND   MN.ACCOUNT_NO        = UT.ACCOUNT_NO               
               AND   MN.ACCOUNT_NO        = AT.ACCOUNT_NO               
T20234         AND   MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
T16852         AND   AT.PREMISE_NO        = :EQ-CRNT-LOC-NO             
T22243         AND   AT.COMPANY_NO        = :AT-COMPANY-NO              
A01209         FOR READ ONLY                                    
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCOUNT-DETAIL CURSOR FOR                                
MFA-TR*        SELECT UT.ACCOUNT_NO    ,                                        
MFA-TR*               UT.RATE_PLAN_NO  ,                                        
MFA-TR*               UT.READ_CYCLE    ,                                        
MFA-TR*               UT.READ_ROUTE    ,                                        
MFA-TR*               AT.CUSTOMER_NO   ,                                        
MFA-TR*               AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.LOCAL_OFFICE  ,                                        
MFA-TR*               AT.ACCT_CREATE_DT,                                        
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.ADDRESS_FORMAT,                                        
MFA-TR*               MN.REGISTER_RD_SEQ                                        
MFA-TR*        FROM CSS_MTRD_ENVRNMT MN,                                        
MFA-TR*             CSS_UTIL_ENVRNMT UT,                                        
MFA-TR*             CSS_ACCOUNT      AT                                         
MFA-TR*        WHERE MN.CODE_UTIL_TYPE    = :WS-G                               
MFA-TR*        AND   MN.METER_NO          = :MN-METER-NO                        
MFA-TR*        AND   MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                   
MFA-TR*        AND   MN.IC_NO             = UT.IC_NO                            
MFA-TR*        AND   MN.ACCOUNT_NO        = UT.ACCOUNT_NO                       
MFA-TR*        AND   MN.ACCOUNT_NO        = AT.ACCOUNT_NO                       
MFA-TR*        AND   MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*        AND   AT.PREMISE_NO        = :EQ-CRNT-LOC-NO                     
MFA-TR*        AND   AT.COMPANY_NO        = :AT-COMPANY-NO                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** CURSOR TO GET POPULATION SIZE                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE GET-INSTALLED-QTY CURSOR FOR                     
               SELECT COUNT(*)                                          
P01176               ,GG.MTR_TEST_GRP_CD                                
P01176               ,GR.AUTO_SAMPLE_TST_FL                             
                FROM CSS_GAS_METER   GM WITH(READUNCOMMITTED),                  
                     CSS_EQUIPMENT   EQ WITH(READUNCOMMITTED),                  
                     CSS_GAS_TST_GROUP GG WITH(READUNCOMMITTED)                 
T23377              ,CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)                
               WHERE EQ.CODE_UTIL_TYPE  = :WS-G                         
                AND   GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE             
                AND   GG.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE             
T23377          AND   GR.CODE_UTIL_TYPE = GG.CODE_UTIL_TYPE             
                AND   GM.METER_NO       = EQ.DEVICE_NO                  
T16852          AND   GM.METER_SIZE_ID   = GG.METER_SIZE_ID             
T23377          AND   GR.MTR_TEST_GRP_CD = GG.MTR_TEST_GRP_CD           
T23377          AND  ((GR.SELECT_TYPE_CD  = :WS-T                       
T23377          AND   (GM.DATE_LAST_TESTED IS NULL                      
T23377           OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT 
T23377                                     AND    GG.END_PURCHASE_DT))) 
T23377           OR   (GR.SELECT_TYPE_CD  = :WS-P                       
T16852          AND   (EQ.DATE_PURCHASED  IS NULL                       
T16852           OR   (EQ.DATE_PURCHASED BETWEEN GG.BEGIN_PURCHASE_DT   
T23377                                   AND    GG.END_PURCHASE_DT))))  
T23377          AND   YEAR(GG.BEGIN_PURCHASE_DT) <=                     
T23377                     (:WS-SELECT-YEAR - GG.TEST_FREQ_YEARS_QT)    
T22243          AND   EQ.COMPANY_NO      = :EQ-COMPANY-NO               
T22243          AND   GM.COMPANY_NO      = EQ.COMPANY_NO                
T22243          AND   GG.COMPANY_NO      = GM.COMPANY_NO                
T23377          AND   GR.COMPANY_NO      = GG.COMPANY_NO                
T20234          AND   EQ.CODE_CRNT_LOC  = :WS-J                         
T23377         GROUP BY GG.MTR_TEST_GRP_CD, GR.AUTO_SAMPLE_TST_FL       
T23377         ORDER BY GG.MTR_TEST_GRP_CD                              
A01209         FOR READ ONLY                                    
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-INSTALLED-QTY CURSOR FOR                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*              ,GG.MTR_TEST_GRP_CD                                        
MFA-TR*              ,GR.AUTO_SAMPLE_TST_FL                                     
MFA-TR*         FROM CSS_GAS_METER   GM,                                        
MFA-TR*              CSS_EQUIPMENT   EQ,                                        
MFA-TR*              CSS_GAS_TST_GROUP GG                                       
MFA-TR*             ,CSS_MTR_TEST_GROUP GR                                      
MFA-TR*        WHERE EQ.CODE_UTIL_TYPE  = :WS-G                                 
MFA-TR*         AND   GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                     
MFA-TR*         AND   GG.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                     
MFA-TR*         AND   GR.CODE_UTIL_TYPE = GG.CODE_UTIL_TYPE                     
MFA-TR*         AND   GM.METER_NO       = EQ.DEVICE_NO                          
MFA-TR*         AND   GM.METER_SIZE_ID   = GG.METER_SIZE_ID                     
MFA-TR*         AND   GR.MTR_TEST_GRP_CD = GG.MTR_TEST_GRP_CD                   
MFA-TR*         AND  ((GR.SELECT_TYPE_CD  = :WS-T                               
MFA-TR*         AND   (GM.DATE_LAST_TESTED IS NULL                              
MFA-TR*          OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT         
MFA-TR*                                    AND    GG.END_PURCHASE_DT)))         
MFA-TR*          OR   (GR.SELECT_TYPE_CD  = :WS-P                               
MFA-TR*         AND   (EQ.DATE_PURCHASED  IS NULL                               
MFA-TR*          OR   (EQ.DATE_PURCHASED BETWEEN GG.BEGIN_PURCHASE_DT           
MFA-TR*                                  AND    GG.END_PURCHASE_DT))))          
MFA-TR*         AND   YEAR(GG.BEGIN_PURCHASE_DT) <=                             
MFA-TR*                    (:WS-SELECT-YEAR - GG.TEST_FREQ_YEARS_QT)            
MFA-TR*         AND   EQ.COMPANY_NO      = :EQ-COMPANY-NO                       
MFA-TR*         AND   GM.COMPANY_NO      = EQ.COMPANY_NO                        
MFA-TR*         AND   GG.COMPANY_NO      = GM.COMPANY_NO                        
MFA-TR*         AND   GR.COMPANY_NO      = GG.COMPANY_NO                        
MFA-TR*         AND   EQ.CODE_CRNT_LOC  = :WS-J                                 
MFA-TR*        GROUP BY GG.MTR_TEST_GRP_CD, GR.AUTO_SAMPLE_TST_FL               
MFA-TR*        ORDER BY GG.MTR_TEST_GRP_CD                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
ACT058     EXEC SQL                                                     
ACT058         DECLARE GET-INSTALLED-QTY-ADD CURSOR FOR                 
ACT058            SELECT COUNT(*)                                       
P01176                  ,GG.MTR_TEST_GRP_CD                             
P01176                  ,GR.AUTO_SAMPLE_TST_FL                          
ACT058               FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                
ACT058                  ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                 
ACT058                  ,CSS_GAS_TST_GROUP GG WITH(READUNCOMMITTED)             
ACT058                  ,CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)            
ACT058             WHERE GG.CODE_UTIL_TYPE    = 'G'                     
ACT058             AND   GR.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE       
ACT058             AND   GR.MTR_TEST_GRP_CD   = GG.MTR_TEST_GRP_CD      
ACT058             AND   EQ.CODE_CRNT_LOC     = 'J'                     
ACT058             AND   GM.METER_NO          = EQ.DEVICE_NO            
ACT058             AND   GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE       
ACT058             AND   GM.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE       
ACT058             AND   GM.METER_SIZE_ID     = GG.METER_SIZE_ID        
ACT058             AND  ((GR.SELECT_TYPE_CD  = 'T'                      
ACT058             AND   (GM.DATE_LAST_TESTED IS NULL                   
ACT058          OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT  
ACT058                                    AND    GG.END_PURCHASE_DT)))  
ACT058          OR   (GR.SELECT_TYPE_CD  = 'P'                          
ACT058         AND   (EQ.DATE_PURCHASED  IS NULL                        
ACT058          OR   (EQ.DATE_PURCHASED BETWEEN                         
ACT058                                         GG.BEGIN_PURCHASE_DT     
ACT058                                  AND    GG.END_PURCHASE_DT))))   
ACT058         AND EQ.COMPANY_NO          = :EQ-COMPANY-NO              
ACT058         AND GM.COMPANY_NO          = EQ.COMPANY_NO               
ACT058         AND GG.COMPANY_NO          = GM.COMPANY_NO               
ACT058         AND GR.COMPANY_NO          = GG.COMPANY_NO               
ACT058         AND LAST_TEST_SEL_CD       = '  '                        
ACT058         GROUP BY GG.MTR_TEST_GRP_CD, GR.AUTO_SAMPLE_TST_FL       
ACT058         ORDER BY GG.MTR_TEST_GRP_CD                              
ACT058         FOR READ ONLY                                    
ACT058                                                      
ACT058     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-INSTALLED-QTY-ADD CURSOR FOR                         
MFA-TR*           SELECT COUNT(*)                                               
MFA-TR*                 ,GG.MTR_TEST_GRP_CD                                     
MFA-TR*                 ,GR.AUTO_SAMPLE_TST_FL                                  
MFA-TR*              FROM CSS_GAS_METER GM                                      
MFA-TR*                 ,CSS_EQUIPMENT EQ                                       
MFA-TR*                 ,CSS_GAS_TST_GROUP GG                                   
MFA-TR*                 ,CSS_MTR_TEST_GROUP GR                                  
MFA-TR*            WHERE GG.CODE_UTIL_TYPE    = 'G'                             
MFA-TR*            AND   GR.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE               
MFA-TR*            AND   GR.MTR_TEST_GRP_CD   = GG.MTR_TEST_GRP_CD              
MFA-TR*            AND   EQ.CODE_CRNT_LOC     = 'J'                             
MFA-TR*            AND   GM.METER_NO          = EQ.DEVICE_NO                    
MFA-TR*            AND   GM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE               
MFA-TR*            AND   GM.CODE_UTIL_TYPE    = GG.CODE_UTIL_TYPE               
MFA-TR*            AND   GM.METER_SIZE_ID     = GG.METER_SIZE_ID                
MFA-TR*            AND  ((GR.SELECT_TYPE_CD  = 'T'                              
MFA-TR*            AND   (GM.DATE_LAST_TESTED IS NULL                           
MFA-TR*         OR   (GM.DATE_LAST_TESTED BETWEEN GG.BEGIN_PURCHASE_DT          
MFA-TR*                                   AND    GG.END_PURCHASE_DT)))          
MFA-TR*         OR   (GR.SELECT_TYPE_CD  = 'P'                                  
MFA-TR*        AND   (EQ.DATE_PURCHASED  IS NULL                                
MFA-TR*         OR   (EQ.DATE_PURCHASED BETWEEN                                 
MFA-TR*                                        GG.BEGIN_PURCHASE_DT             
MFA-TR*                                 AND    GG.END_PURCHASE_DT))))           
MFA-TR*        AND EQ.COMPANY_NO          = :EQ-COMPANY-NO                      
MFA-TR*        AND GM.COMPANY_NO          = EQ.COMPANY_NO                       
MFA-TR*        AND GG.COMPANY_NO          = GM.COMPANY_NO                       
MFA-TR*        AND GR.COMPANY_NO          = GG.COMPANY_NO                       
MFA-TR*        AND LAST_TEST_SEL_CD       = '  '                                
MFA-TR*        GROUP BY GG.MTR_TEST_GRP_CD, GR.AUTO_SAMPLE_TST_FL               
MFA-TR*        ORDER BY GG.MTR_TEST_GRP_CD                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7201                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA656 ENDS HERE  '.                  
      *                                                                         
       LINKAGE SECTION.                                                 
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *   THE FOLLOWING CODE IS USED FOR DEBUGGING. TO ENABLE THE               
      *   COBOL II DEBUGGING FEATURES, REMOVE THE ASTERISKS FROM THE            
      *   'SET WS-TRACE-ON TO TRUE' STATEMENT IN THE MAINLINE ROUTINE.          
      *   ALSO MAKE SURE THE 'SOURCE-COMPUTER' STATEMENT IN THE                 
      *   ENVIRONMENT DIVISION SAYS 'WITH DEBUGGING OPTION'.                    
       DECLARATIVES.                                                    
       DEBUG-DECLARE SECTION.                                           
           USE FOR DEBUGGING ON ALL PROCEDURES.                         
       DEBUG-PARA.                                                      
           IF READY-TRACE                                               
               DISPLAY 'ENTERING    '                                   
                       DEBUG-NAME                                       
                       DEBUG-LINE                                       
                       DEBUG-CONTENTS                                   
           END-IF.                                                      
       END DECLARATIVES.                                                
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
***********SET READY-TRACE TO TRUE.                                             
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT-PARM       THRU 1000-EXIT         
           PERFORM 8300-UPDATE-PARM              THRU 8300-EXIT         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
A01209     PERFORM 7970-GET-DB2-TODAYS-DATE    THRU 7970-EXIT.          
A01209     ACCEPT WS-SYS-DATE                  FROM DATE.               
A01209     ACCEPT WS-SYS-TIME                  FROM TIME.               
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
      *                                                                         
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-01              TO WS-SYSIN-COMP-NO              
T22243     END-IF.                                                      
T22243*                                                                         
T22243     MOVE WS-SYSIN-COMP-NO       TO EQ-COMPANY-NO                 
T22243                                    GM-COMPANY-NO                 
T22243                                    MC-COMPANY-NO                 
T22243                                    GG-COMPANY-NO                 
T22243                                    MQ-COMPANY-NO                 
T22243                                    AT-COMPANY-NO                 
T22243                                    GR-COMPANY-NO.                
T22243     DISPLAY '*********************************'                  
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', EQ-COMPANY-NO     
T22243     DISPLAY '*********************************'                  
      *                                                                         
           INITIALIZE    DCLCSS-JOB-PARM.                               
      *                                                                         
T22243     MOVE WS-SYSIN-COMP-NO       TO G6-COMPANY-NO.                
           PERFORM 0200-READ-INPUT-PARM          THRU 0200-EXIT         
           PERFORM 0300-OPEN-OUTPUT-FILES        THRU 0300-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0200-READ-INPUT-PARM.                                            
      *                                                                         
           MOVE WS-PARM                   TO WS-COMMAND                 
           MOVE WS-PGRMNAME               TO WS-PROGRAM                 
           PERFORM   7600-START-FCSJC01          THRU 7600-EXIT         
           PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT         
T16852     IF END-OF-SYSIPT                                             
T16852        DISPLAY '******************************'                  
T16852        DISPLAY '*   NO RECORDS FOR PCSCA656  *'                  
T16852        DISPLAY '*   IN CSS_JOB_PARM          *'                  
T16852        DISPLAY '******************************'                  
T16852        PERFORM 9900-ABEND                 THRU 9900-EXIT         
T16852     END-IF.                                                      
           IF G6-SEQ-NO                   EQUAL WS-ONE AND              
              G6-STATUS                   EQUAL WS-A                    
              MOVE WS-INPUT-DATA-BREAKDOWN   TO WS-PARAMETER-DATA       
              IF WS-TEST-YEAR-TEXT           NOT EQUAL WS-TEST-YEAR     
                 DISPLAY '*****************************************'    
                 DISPLAY '*       INVALID PARM IN 1ST RECORD      *'    
                 DISPLAY '*           OF CSS_JOB_PARM             *'    
                 DISPLAY '*   PARM GIVEN IS : ' WS-TEST-YEAR-TEXT       
                 DISPLAY '*   PARM SHOULD BE : TEST YEAR = 9999   *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-TEST-YEAR-VALUE-C        NOT NUMERIC                
                 DISPLAY '*****************************************'    
                 DISPLAY '*    TEST YEAR  SHOULD BE NUMERIC IN    *'    
                 DISPLAY '*      1 ST RECORD OF CSS_JOB_PARM      *'    
                 DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE-C     
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-TEST-YEAR-VALUE          LESS THAN 1996       OR    
                 WS-TEST-YEAR-VALUE          GREATER THAN 2100          
                 DISPLAY '**********************************'           
                 DISPLAY '*   INVALID  TEST YEAR           *'           
                 DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE       
                 DISPLAY '**********************************'           
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              ELSE                                                      
                 MOVE WS-TEST-YEAR-VALUE     TO WS-PARM-TEST-YEAR       
                                                WS-PARM-TEST-YEAR       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-DB2-TODAYS-DATE        TO WS-DB2-DATE             
              MOVE WS-DB2-YEAR               TO WS-PARM-TEST-YEAR       
           END-IF.                                                      
T23377     MOVE WS-PARM-TEST-YEAR            TO WS-SELECT-YEAR.         
T16852*                                                                         
T16852     PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT         
           IF G6-SEQ-NO                      EQUAL WS-TWO               
              MOVE WS-Y                      TO WS-JOB-PARM-2           
              MOVE WS-RUN-TYPE-VALUE         TO WS-PARM-RUN-TYPE        
              IF G6-STATUS                   NOT EQUAL WS-A             
                 DISPLAY '*******************************'              
                 DISPLAY '*   INACTIVE STATUS           *'              
                 DISPLAY '* PARM STATUS    : ' G6-STATUS                
                 DISPLAY '*******************************'              
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-RUN-TYPE-TEXT            NOT EQUAL WS-RUN-TYPE      
                 DISPLAY '*****************************************'    
                 DISPLAY '*       INVALID PARM IN 2ND RECORD      *'    
                 DISPLAY '*           OF CSS_JOB_PARM             *'    
                 DISPLAY '*   PARM GIVEN IS : ' WS-RUN-TYPE-TEXT        
                 DISPLAY '*   PARM SHOULD BE : RUN TYPE = SELECT  *'    
                 DISPLAY '*       (OR FORECAST OR ADDITIONAL)     *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-PARM-RUN-TYPE            EQUAL WS-SELECT OR         
                 WS-PARM-RUN-TYPE            EQUAL WS-FORECAST OR       
                 WS-PARM-RUN-TYPE            EQUAL WS-ADDITIONAL        
ACT058               DISPLAY 'RUNNING IN ' WS-PARM-RUN-TYPE ' MODE'     
              ELSE                                                      
                 DISPLAY '**************************************'       
                 DISPLAY '*   INVALID  RUN TYPE 1              *'       
                 DISPLAY '* PARM RUN TYPE  : ' WS-PARM-RUN-TYPE         
                 DISPLAY '**************************************'       
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-N                      TO WS-RUN-TYPE-GIVEN       
              DISPLAY '******************************'                  
              DISPLAY '*   RUN TYPE NOT GIVEN       *'                  
              DISPLAY '*   IN CSS_JOB_PARM          *'                  
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
T16852     END-IF.                                                      
T16852*                                                                         
T16852     PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT.        
T16852     PERFORM 0210-PROCESS-TEST-GRP-REC     THRU 0210-EXIT.        
      *                                                                         
           IF WS-PARM-RUN-TYPE        EQUAL WS-ADDITIONAL               
              IF WS-JOB-PARM-3   NOT  EQUAL WS-Y                        
                 DISPLAY '****************************************'     
                 DISPLAY '*IF RUN TYPE = ADDITIONAL, TEST GROUP *'      
                 DISPLAY '* AND SELECT QTY SHOULD BE GIVEN       *'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0210-PROCESS-TEST-GRP-REC.                                       
      *                                                                         
           PERFORM 0230-PROCESS-ADD-PARM-REC THRU 0230-EXIT             
                   UNTIL WS-SELECT-QTY-TEXT NOT EQUAL WS-SELECT-QTY     
T16852                                     OR END-OF-SYSIPT.            
T16852     IF END-OF-SYSIPT                                             
T16852        GO TO 0210-EXIT                                           
T16852     END-IF.                                                      
      *                                                                         
A01209*    ROW HAS BEEN ADDED TO JOB_PARM TABLE WITH STATUS AS INACTIVE         
A01209*    WHEN NEED MAKE THE STATUS AS ACTIVE AND RUN THE JOB.                 
A01209*                                                                         
           PERFORM 0240-VAL-INITIAL-SEED     THRU 0240-EXIT.            
                                                                        
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0220-VAL-ADD-PARM-REC.                                           
           IF G6-STATUS NOT EQUAL WS-A                                  
              GO TO 0220-EXIT                                           
           END-IF                                                       
           IF WS-SELECT-QTY-TEXT          EQUAL WS-SELECT-QTY           
              MOVE WS-Y                   TO WS-JOB-PARM-3              
           END-IF                                                       
           IF WS-TEST-GROUP-3-TEXT        NOT EQUAL WS-TEST-GROUP       
              DISPLAY '********************************************'    
              DISPLAY '*       INVALID PARM IN 3RD RECORD         *'    
              DISPLAY '*           OF CSS_JOB_PARM                *'    
              DISPLAY '*     PARM GIVEN IS : ' WS-TEST-GROUP-3-TEXT     
              DISPLAY '*     PARM SHOULD BE :                     *'    
              DISPLAY '*     TEST GROUP = XX SELECT QTY = 9999    *'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
*******    VALIDATE TEST GROUP AGAINST CSS_MTR_TEST_GROUP                       
           MOVE  WS-TEST-GROUP-VALUE-3    TO GR-MTR-TEST-GRP-CD         
           PERFORM 7000-VALIDATE-MTR-TST-GROUP                          
                                              THRU 7000-EXIT            
           IF SQLCODE                     EQUAL   NOT-FOUND             
              DISPLAY '*****************************************'       
              DISPLAY '*INVALID  TEST GROUP IN  3 REC          *'       
              DISPLAY '*IN CSS_JOB _PARM                       *'       
              DISPLAY '* TEST GROUP     : ' WS-TEST-GROUP-VALUE-3       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           IF WS-SELECT-QTY-VALUE         NOT NUMERIC                   
              DISPLAY '*****************************************'       
              DISPLAY '*    SELECT QTY SHOULD BE NUMERIC IN    *'       
              DISPLAY '*      3 RD RECORD OF CSS_JOB_PARM      *'       
              DISPLAY '* PARM SELECT QTY : ' WS-SELECT-QTY-VALUE        
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           ADD 1                          TO WS-CTR-K                   
           MOVE WS-SELECT-QTY-VALUE       TO                            
                                          WS-PARM-SELECT-QTY (WS-CTR-K) 
           MOVE WS-TEST-GROUP-VALUE-3     TO                            
                                          WS-PARM-TEST-GRP-3 (WS-CTR-K).
      *                                                                         
       0220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0230-PROCESS-ADD-PARM-REC.                                       
      *                                                                         
           PERFORM 0220-VAL-ADD-PARM-REC     THRU 0220-EXIT.            
           PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT.            
      *                                                                         
       0230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0240-VAL-INITIAL-SEED.                                           
A01209*                                                                         
A01209     IF G6-STATUS NOT EQUAL WS-A                                  
A01209        DISPLAY 'JOB PARM NOT ACTIVE FOR INITAL-SEED: '           
A01209        GO TO 0240-EXIT                                           
A01209     END-IF                                                       
                                                                        
           IF WS-INITIAL-SEED-TEXT           EQUAL WS-INITIAL-SEED      
              MOVE WS-Y                      TO WS-JOB-PARM-4           
              IF WS-TEST-GROUP-4-TEXT        NOT EQUAL WS-TEST-GROUP    
                 DISPLAY '********************************************' 
                 DISPLAY '*       INVALID PARM IN 4TH RECORD         *' 
                 DISPLAY '*           OF CSS_JOB_PARM                *' 
                 DISPLAY '* PARM GIVEN IS : ' WS-TEST-GROUP-4-TEXT      
                 DISPLAY '* PARM SHOULD BE :                         *' 
                 DISPLAY '* TEST GROUP = XX INITIAL SEED = 9999999999*' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
*******       VALIDATE TEST GROUP AGAINST CSS_MTR_TEST_GROUP                    
              MOVE  WS-TEST-GROUP-VALUE-4     TO GR-MTR-TEST-GRP-CD     
              PERFORM 7000-VALIDATE-MTR-TST-GROUP                       
                                                 THRU 7000-EXIT         
              IF SQLCODE                     EQUAL   NOT-FOUND          
                 DISPLAY '*****************************************'    
                 DISPLAY '*INVALID  TEST GROUP IN  4 REC          *'    
                 DISPLAY '*IN CSS_JOB _PARM                       *'    
                 DISPLAY '* TEST GROUP     : ' WS-TEST-GROUP-VALUE-4    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              INSPECT WS-INITIAL-SEED-VALUE REPLACING ALL               
                 LOW-VALUES BY SPACES                                   
              INSPECT WS-INITIAL-SEED-VALUE TALLYING                    
                        WS-INSPECT-CNTR FOR ALL ' '                     
              COMPUTE  WS-INSPECT-CNTR =                                
                     LENGTH OF WS-INITIAL-SEED-VALUE - WS-INSPECT-CNTR  
              IF ( WS-INSPECT-CNTR EQUAL ZERO )                         
                   MOVE LENGTH OF WS-INITIAL-SEED-VALUE                 
                                             TO WS-INSPECT-CNTR         
              END-IF                                                    
              MOVE WS-INITIAL-SEED-VALUE(1:WS-INSPECT-CNTR) TO          
                                             WS-INITIAL-SEED-JUSTIFIED  
              INSPECT WS-INITIAL-SEED-JUSTIFIED                         
                                   REPLACING ALL ' ' BY '0'             
              IF WS-INITIAL-SEED-JUSTIFIED   NOT NUMERIC                
                 DISPLAY '********************************************' 
                 DISPLAY '* INITIAL SEED VALUE IN 4 TH               *' 
                 DISPLAY '* REC OF CSS_JOB_PARM NOT                  *' 
                 DISPLAY '* NUMERIC                                  *' 
                 DISPLAY '* INITIAL SEED : ' WS-INITIAL-SEED-JUSTIFIED  
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              MOVE WS-TEST-GROUP-VALUE-4     TO WS-PARM-TEST-GRP-4      
              MOVE WS-INITIAL-SEED-JUSTIFIED TO WS-PARM-INITIAL-SEED    
           END-IF.                                                      
      *                                                                         
       0240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0300-OPEN-OUTPUT-FILES.                                          
           IF WS-PARM-RUN-TYPE               EQUAL WS-SELECT            
              OPEN OUTPUT POPULATION-SAMPLE-FILE                        
              IF  SAMPFIL-SUCCESS                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FCSRP61  FILE OPEN ERROR'                    
                  DISPLAY 'FCSRP61 FILE STATUS IS ==>' WS-SAMPFIL-STATUS
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
              OPEN OUTPUT METER-DETAIL-FILE                             
              IF  METFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FIOCA66             FILE OPEN ERROR'         
                  DISPLAY 'FIOCA66 FILE STATUS IS ==>' WS-METFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
              OPEN OUTPUT LETTER-DETAIL-FILE                            
              IF  LETFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'LETTERS             FILE OPEN ERROR'         
                  DISPLAY 'LETTERS FILE STATUS IS ==>' WS-LETFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-RUN-TYPE  EQUAL WS-FORECAST                       
ACT040        MOVE +2 TO WS-RETURN-CODE                                 
              OPEN OUTPUT POPULATION-SAMPLE-FILE                        
              IF  SAMPFIL-SUCCESS                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FCSRP61             FILE OPEN ERROR'         
                  DISPLAY 'FCSRP61 FILE STATUS IS ==>' WS-SAMPFIL-STATUS
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-RUN-TYPE  EQUAL WS-ADDITIONAL                     
              OPEN OUTPUT METER-DETAIL-FILE                             
              IF  METFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FIOCA66             FILE OPEN ERROR'         
                  DISPLAY 'FIOCA66 FILE STATUS IS ==>' WS-METFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
              OPEN OUTPUT LETTER-DETAIL-FILE                            
              IF  LETFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'LETTERS             FILE OPEN ERROR'         
                  DISPLAY 'LETTERS FILE STATUS IS ==>' WS-LETFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-RUN-TYPE  EQUAL WS-FORECAST                       
              CONTINUE                                                  
           ELSE                                                         
ACT069        MOVE 'H'                TO E-FCA66-HEADER-ID              
ACT069        MOVE WS-DB2-TODAYS-DATE TO E-FCA66-HEADER-DATE            
ACT069        MOVE ZEROS              TO E-FCA66-HEADER-ZEROS           
ACT069        WRITE METER-DETAIL-REC FROM FIOCA66-HEADER-RECORD         
ACT069        WRITE LETTER-DETAIL-REC FROM FIOCA66-HEADER-RECORD        
           END-IF.                                                      
      *FOLL 2 LINES TO BE DELETED LATER                                         
           OPEN OUTPUT RANDOM-NBR-FILE                                  
           IF RANDOMFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'RANDOM FILE OPEN ERROR'                          
              DISPLAY 'RANDOM FILE STATUS IS ===>'                      
                                 WS-RANDOMFIL-STATUS                    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1000-PROCESS-INPUT-PARM.                                         
      *                                                                         
T16852     PERFORM 7200-OPEN-GET-INSTALLED-QTY THRU 7200-EXIT           
T16852     PERFORM 7210-FETCH-GET-INSTALLED-QTY THRU 7210-EXIT          
T16852     PERFORM 1100-STORE-INSTALLED-QTY THRU 1100-EXIT              
ACT047         UNTIL SQLCODE EQUAL NOT-FOUND                            
ACT047            OR WS-SUB > WS-MAX-TEST-GROUP-ENTRIES                 
      *                                                                         
T16852     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T16852         DISPLAY '****************PCSCA656******************'     
ACT047         DISPLAY 'NUMBER OF TEST GROUPS IN THE TABLE IS > '       
ACT047             WS-MAX-TEST-GROUP-ENTRIES                            
T16852         DISPLAY 'PROGRAM NEEDS TO BE CHANGED               '     
T16852         DISPLAY '****************PCSCA656******************'     
T16852         PERFORM 7220-CLOSE-GET-INSTALLED-QTY   THRU 7220-EXIT    
T16852         PERFORM 9900-ABEND             THRU 9900-EXIT            
T16852     END-IF.                                                      
T16852     PERFORM 7220-CLOSE-GET-INSTALLED-QTY   THRU 7220-EXIT.       
      *                                                                         
           IF WS-JOB-PARM-3                  EQUAL   WS-Y   AND         
             WS-PARM-RUN-TYPE EQUAL WS-ADDITIONAL                       
             PERFORM 2000-SELECT-ADDITIONAL-METERS                      
                                                 THRU 2000-EXIT         
                VARYING WS-TOT-TEST-GROUPS FROM 1 BY 1                  
                   UNTIL WS-TOT-TEST-GROUPS   >   WS-CTR-K              
           END-IF.                                                      
      *                                                                         
           IF WS-PARM-RUN-TYPE EQUAL WS-SELECT   OR                     
              WS-PARM-RUN-TYPE EQUAL WS-FORECAST                        
              PERFORM 3000-SELECT-AND-FORECAST   THRU 3000-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T16852 1100-STORE-INSTALLED-QTY.                                        
T16852*                                                                         
T16852     ADD 1 TO WS-SUB.                                             
           MOVE  GG-MTR-TEST-GRP-CD        TO WS-TEST-GRP-CD (WS-SUB).  
           MOVE  WS-CURRENT-INSTALLED-QTY  TO WS-INSTALLED-QTY (WS-SUB).
P01176     MOVE  GR-AUTO-SAMPLE-TST-FL TO WS-AUTO-SAMPLE-TST-FL(WS-SUB).
           DISPLAY 'TEST GROUP = ' GG-MTR-TEST-GRP-CD.                  
           DISPLAY 'INSTALLED QTY = ' WS-CURRENT-INSTALLED-QTY.         
T16852     PERFORM 7210-FETCH-GET-INSTALLED-QTY   THRU 7210-EXIT.       
T16852*                                                                         
T16852 1100-EXIT.                                                       
T16852     EXIT.                                                        
      *                                                                         
       2000-SELECT-ADDITIONAL-METERS.                                   
      *                                                                         
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR            
           MOVE WS-PARM-TEST-GRP-3 (WS-TOT-TEST-GROUPS)                 
                                             TO MQ-MTR-TEST-GRP-CD      
           PERFORM 7100-SELECT-METER-TEST-HIST   THRU 7100-EXIT         
      *                                                                         
T16852     MOVE 1                            TO WS-SUB.                 
T23377     MOVE WS-N                         TO WS-GRP-CD-FOUND         
ACT047     PERFORM UNTIL GRP-CD-FOUND                                   
ACT047                OR WS-SUB > WS-MAX-TEST-GROUP-ENTRIES             
T23377         IF  WS-TEST-GRP-CD(WS-SUB) EQUAL MQ-MTR-TEST-GRP-CD      
T23377             SET GRP-CD-FOUND          TO TRUE                    
T23377         ELSE                                                     
T23377             ADD 1 TO WS-SUB                                      
               END-IF                                                   
T16852     END-PERFORM.                                                 
T23377     IF  GRP-CD-FOUND                                             
T16852     MOVE WS-INSTALLED-QTY (WS-SUB) TO MQ-INSTALLED-QT            
T23377                                    WS-CURRENT-INSTALLED-QTY      
T23377     ELSE                                                         
T23377         MOVE ZEROS                 TO WS-CURRENT-INSTALLED-QTY   
T23377     END-IF.                                                      
                                                                        
           MOVE WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)                 
                                             TO WS-NBR-RANDOM-NBRS      
           MOVE 0 TO WS-GRP-COUNT                                       
*******    GENERATE RANDOM NUMBERS                                              
           PERFORM 4500-GENERATE-RANDOM-NUM      THRU 4500-EXIT         
                                                                        
           PERFORM 7300-OPEN-METER-EQUIP-TST     THRU 7300-EXIT         
           MOVE 1                            TO WS-RANDOM-INDEX         
           MOVE 1                            TO WS-METER-NUM-INDEX      
           MOVE 0                            TO WS-METER-SEQ            
      *                                                                         
           SORT SORT-FILE                                               
           ON ASCENDING KEY S-RANDOM-NBR                                
           USING UNSORTED-RANDOM-FILE                                   
           GIVING SORTED-RANDOM-FILE.                                   
      *                                                                         
           OPEN INPUT SORTED-RANDOM-FILE.                               
      *                                                                         
           PERFORM 2100-PROCESS-ADDITIONAL-METERS                       
                   THRU 2100-EXIT                                       
T16852                VARYING WS-COUNT  FROM 1 BY 1 UNTIL               
ACT058                 WS-METER-NUM-INDEX >                             
                           WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS).     
           PERFORM 7320-CLOSE-METER-EQUIP-TST    THRU 7320-EXIT         
      *                                                                         
           CLOSE SORTED-RANDOM-FILE.                                    
           IF WS-SO-INDEX  >  0                                         
              MOVE WS-G                TO WS-SO-UTIL-TYPE               
              MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE                    
              COMPUTE WS-NBR-METERS    =  WS-SO-INDEX                   
              IF (WS-SYSIN-COMP-NO = '01' AND GR-SO-REQUIRED-FL = 'Y')  
               OR WS-SYSIN-COMP-NO = '26'                               
                  CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE             
              END-IF                                                    
              COMPUTE WS-SO-INDEX = 0                                   
           END-IF                                                       
      *                                                                         
           MOVE 1                            TO WS-METER-NUM-INDEX      
           PERFORM 2200-UPDATE-GAS-METER         THRU 2200-EXIT         
                   VARYING WS-COUNT-UPD-GAS-MTR   FROM 1 BY 1           
                      UNTIL WS-COUNT-UPD-GAS-MTR   >                    
                         WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS).       
      *                                                                         
      *ADD PARM SELECT QTY TO SAMPLE_ADDITIONAL_QT , SELECTED_TEST_QT           
      *ON CSS_MTR_TEST_HIST                                                     
                                                                        
           COMPUTE MQ-SAMPL-ADDITIONL-QT  = MQ-SAMPL-ADDITIONL-QT       
                   + WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)            
           IF MAX-RAN-NUM-REACHED                                       
              CONTINUE                                                  
           ELSE                                                         
              COMPUTE MQ-SELECTED-QT       = MQ-SELECTED-QT             
                   + WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)            
           END-IF                                                       
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
           PERFORM 8100-UPDATE-MTR-TEST-HIST     THRU 8100-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-PROCESS-ADDITIONAL-METERS.                                  
           READ SORTED-RANDOM-FILE                                      
           COMPUTE WS-NBR-OF-FETCHES                                    
              =  WS-RANDOM-NBR  - WS-METER-SEQ                          
           PERFORM 2110-FETCH-NEXT-RECORD        THRU 2110-EXIT         
ACT058         WITH TEST AFTER                                          
               VARYING WS-FETCH-ALL-MTRS FROM 1 BY 1                    
ACT058              UNTIL WS-FETCH-ALL-MTRS >= WS-NBR-OF-FETCHES.       
      *                                                                         
T16852     PERFORM 2300-CALL-SCSCA657            THRU 2300-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2110-FETCH-NEXT-RECORD.                                          
           PERFORM  7310-FETCH-METER-EQUIP-TEST  THRU 7310-EXIT         
           ADD 1                             TO WS-METER-SEQ.           
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-UPDATE-GAS-METER.                                           
T16229     IF  WS-METER-NUMBER(WS-METER-NUM-INDEX) > SPACES AND         
T16229         LOW-VALUES                                               
             MOVE WS-METER-NUMBER(WS-METER-NUM-INDEX) TO GM-METER-NO    
             PERFORM  8000-UPDATE-GAS-METER        THRU 8000-EXIT       
             ADD 1                             TO WS-METER-NUM-INDEX    
T16229     END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-CALL-SCSCA657.                                              
      *                                                                         
T16852     IF  GM-METER-NO EQUAL SPACES OR LOW-VALUES                   
T16229         GO TO 2300-EXIT                                          
T16229     END-IF.                                                      
      *                                                                         
      *     GET ACCOUNT NO FOR THE METER                                        
T16852      MOVE GM-METER-NO                 TO MN-METER-NO             
T20234      MOVE EQ-CRNT-LOC-NO             TO WS-CPD99-PREMISE-NO.     
T20234      PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.              
T20234      MOVE WS-CPD99-ACCOUNT-NO        TO MN-ACCOUNT-NO.           
            PERFORM 7400-OPEN-ACCOUNT-DETAILS     THRU 7400-EXIT        
            PERFORM 7410-FETCH-ACCOUNT-DETAILS    THRU 7410-EXIT        
T16852      IF SQLCODE                       EQUAL SUCCESSFUL-CALL      
                ADD +1                        TO WS-SO-INDEX            
                MOVE UT-ACCOUNT-NO            TO                        
                                           WS-SO-ACCT-NO(WS-SO-INDEX)   
                MOVE WS-R                     TO                        
                                           WS-SO-TEST-TYPE(WS-SO-INDEX) 
                MOVE GM-METER-NO              TO                        
                                           WS-SO-METER-NO(WS-SO-INDEX)  
ACT047          IF WS-SO-INDEX = WS-MAX-TEST-GROUP-ENTRIES              
                   MOVE WS-G                   TO WS-SO-UTIL-TYPE       
                   MOVE WS-DB2-TODAYS-DATE     TO WS-SO-DATE            
                   COMPUTE WS-NBR-METERS = WS-SO-INDEX                  
A01209             IF (WS-SYSIN-COMP-NO = '01' AND                      
A01209                 GR-SO-REQUIRED-FL = 'Y') OR                      
A01209                 WS-SYSIN-COMP-NO = '26'                          
                       CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE        
                   END-IF                                               
                   COMPUTE WS-SO-INDEX = 0                              
                END-IF                                                  
                IF WS-PARM-RUN-TYPE               EQUAL WS-ADDITIONAL   
                   IF WS-METER-NUM-INDEX EQUAL                          
                               WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)  
                      IF WS-SO-INDEX  >  0   AND                        
ACT047                   WS-SO-INDEX  <  WS-MAX-TEST-GROUP-ENTRIES      
                         MOVE WS-G                TO WS-SO-UTIL-TYPE    
                         MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE         
                         COMPUTE WS-NBR-METERS    =  WS-SO-INDEX        
A01209                   IF (WS-SYSIN-COMP-NO = '01' AND                
A01209                       GR-SO-REQUIRED-FL = 'Y') OR                
A01209                       WS-SYSIN-COMP-NO = '26'                    
                             CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE  
                         END-IF                                         
                         COMPUTE WS-SO-INDEX = 0                        
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
                IF WS-PARM-RUN-TYPE               EQUAL WS-SELECT       
                   IF (WS-METER-NUM-INDEX  = (WS-NBR-RANDOM-NBRS - 1)   
                           OR WS-COUNT-1  = (WS-NBR-RANDOM-NBRS - 1))   
                      IF WS-SO-INDEX  >  0   AND                        
ACT047                   WS-SO-INDEX  <  WS-MAX-TEST-GROUP-ENTRIES      
                         MOVE WS-G                TO WS-SO-UTIL-TYPE    
                         MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE         
                         COMPUTE WS-NBR-METERS    =  WS-SO-INDEX        
A01209                   IF (WS-SYSIN-COMP-NO = '01' AND                
A01209                       GR-SO-REQUIRED-FL = 'Y') OR                
A01209                       WS-SYSIN-COMP-NO = '26'                    
                             CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE  
                         END-IF                                         
                         COMPUTE WS-SO-INDEX = 0                        
                      END-IF                                            
                   ELSE                                                 
                     IF WS-JOB-PARM-3 EQUAL WS-Y                        
                      IF WS-PARM-TEST-GRP-3 (WS-CTR-K) EQUAL            
                         MQ-MTR-TEST-GRP-CD AND                         
                         WS-METER-NUM-INDEX EQUAL                       
                         WS-PARM-SELECT-QTY (WS-CTR-K)                  
                         IF WS-SO-INDEX  >  0   AND                     
ACT047                      WS-SO-INDEX  <  WS-MAX-TEST-GROUP-ENTRIES   
                            MOVE WS-G               TO WS-SO-UTIL-TYPE  
                            MOVE WS-DB2-TODAYS-DATE TO WS-SO-DATE       
                            COMPUTE WS-NBR-METERS    =  WS-SO-INDEX     
A01209                      IF (WS-SYSIN-COMP-NO = '01' AND             
A01209                          GR-SO-REQUIRED-FL = 'Y') OR             
A01209                          WS-SYSIN-COMP-NO = '26'                 
                               CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE
                            END-IF                                      
                            MOVE WS-Y       TO WS-CALL-SCSCA657         
                            COMPUTE WS-SO-INDEX = 0                     
                         END-IF                                         
                      END-IF                                            
                     END-IF                                             
                   END-IF                                               
                END-IF                                                  
              PERFORM 2310-WRITE-CA65           THRU 2310-EXIT          
T16852      ELSE                                                        
              DISPLAY '***************************************'         
              DISPLAY '*     NO ACCOUNT DETAILS FOUND FOR    *'         
              DISPLAY '*   METER ',  MN-METER-NO                        
              DISPLAY '*   PROCESSING CONTINUES...           *'         
              DISPLAY '**************PCSCA656 ****************'         
T16852      END-IF.                                                     
            PERFORM 7420-CLOSE-ACCOUNT-DETAILS    THRU 7420-EXIT.       
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2310-WRITE-CA65.                                                 
      *     SELECT ACCOUNT,LOCAL OFFICE,RATE PLAN, READ ROUTE,                  
      *     READ CYCLE, NAME AND ADDRESS INFORMATION FOR METER.                 
      *     GET ACCOUNT NUMBER FOR THE NEXT METER NUMBER.                       
      *                                                                         
           INITIALIZE FIOCA66                                           
           MOVE UT-ACCOUNT-NO               TO E-FCA66-ACCT-NO          
                                               AT-ACCOUNT-NO            
      *SELECT ON CSS_ACCOUNT                                                    
           PERFORM 7500-GET-LOCAL-OFFICE        THRU 7500-EXIT          
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT          
           MOVE WS-CUSTOMER-NAME            TO E-FCA66-NAME             
           MOVE WS-PR-STREET                TO E-FCA66-SERV-ADDR        
           MOVE WS-PR-ADDR-OVERFLOW         TO                          
                                           E-FCA66-SERV-ADDR-OVR        
           MOVE WS-PR-ADDR-ZIP-CODE         TO E-FCA66-SERV-ZIP-CODE    
           MOVE WS-PR-ADDR-CITY-STATE-ZIP   TO                          
                                           E-FCA66-ADDR-CITY-ST-ZIP     
           IF WS-MAIL-ADDR-STREET > SPACES                              
            MOVE WS-MAIL-ADDR-STREET         TO E-FCA66-MAIL-ADDR       
            MOVE WS-MAIL-ADDR-OVERFLOW       TO E-FCA66-MAIL-ADDR-OVR   
            MOVE WS-MAIL-ADDR-ZIP            TO E-FCA66-MAIL-ZIP-CODE   
            MOVE WS-MAIL-ADDR-CITY-STATE-ZIP TO                         
                                             E-FCA66-MAIL-CITY-ST-ZIP   
           ELSE                                                         
            MOVE WS-PR-STREET                TO E-FCA66-MAIL-ADDR       
            MOVE WS-PR-ADDR-OVERFLOW         TO E-FCA66-MAIL-ADDR-OVR   
            MOVE WS-PR-ADDR-ZIP-CODE         TO E-FCA66-MAIL-ZIP-CODE   
            MOVE WS-PR-ADDR-CITY-STATE-ZIP   TO                         
                                             E-FCA66-MAIL-CITY-ST-ZIP   
           END-IF                                                       
           MOVE UT-READ-CYCLE               TO E-FCA66-READ-CYCLE       
           MOVE UT-READ-ROUTE               TO E-FCA66-READ-ROUTE       
           MOVE UT-RATE-PLAN-NO             TO E-FCA66-RATE             
           MOVE AT-CUSTOMER-NO              TO E-FCA66-CUSTOMER-NO      
           MOVE AT-LOCAL-OFFICE             TO E-FCA66-LOCAL-OFFICE     
      *SELECT ON CSS_GAS_METER  TO GET METER DETAILS                            
               PERFORM 7601-SELECT-GAS-METER        THRU 7601-EXIT.     
            MOVE WS-R                        TO E-FCA66-TEST-TYPE-CODE  
            MOVE GM-TEST-SCHED-CD            TO E-FCA66-TEST-SCH-CD     
            MOVE GM-METER-NO                 TO E-FCA66-METER-NO        
                                                MC-METER-NO             
                                                EQ-DEVICE-NO            
            PERFORM 7960-SELECT-EQUIP-DETAILS    THRU 7960-EXIT         
            MOVE EQ-CODE-MAKE                TO E-FCA66-CODE-MAKE       
            MOVE EQ-COMPANY-NO               TO E-FCA66-COMPANY-NO      
            MOVE +1                          TO MC-REG-ID-NO            
            MOVE WS-G                        TO MC-CODE-UTIL-TYPE       
            MOVE WS-G                        TO E-FCA66-UTIL-TYPE       
      *SELECT CONSTANT FROM CSS_MTR_CAP                                         
            PERFORM 7700-SELECT-MTR-CAP-CONSTANT                        
                                                 THRU 7700-EXIT         
            MOVE MC-CONSTANT                 TO E-FCA66-CONSTANT        
            MOVE GM-METER-SIZE-ID            TO E-FCA66-METER-SIZE      
            IF WS-DATE-LAST-TESTED-NULLIND = -1                         
               MOVE SPACES                   TO E-FCA66-TEST-DATE       
            ELSE                                                        
               MOVE GM-DATE-LAST-TESTED      TO E-FCA66-TEST-DATE       
            END-IF                                                      
            MOVE SPACES                      TO E-FCA66-METER-TYPE      
            MOVE +0                          TO E-FCA66-SORT-KEY        
            MOVE MQ-MTR-TEST-GRP-CD          TO E-FCA66-MTR-TEST-GRP-CD 
            MOVE WS-DB2-TODAYS-DATE          TO                         
                                                E-FCA66-LAST-TEST-SEL-DT
      *                                                                         
ACT019      MOVE MN-REGISTER-RD-SEQ          TO E-FCA66-REGISTER-RD-SEQ 
      *                                                                         
ACT019*SELECT METER TYPE DESCRIPTION FROM CSS_METER_TYPE                        
ACT019      MOVE GM-CODE-METER-TYPE          TO M7-CODE-METER-TYPE      
ACT019      PERFORM 7750-SELECT-METER-TYPE-DESC  THRU 7750-EXIT         
ACT019      MOVE M7-METER-TYPE-DESC          TO E-FCA66-METER-TYPE-DESC 
      *                                                                         
            WRITE METER-DETAIL-REC           FROM FIOCA66.              
      *                                                                         
ACT069      IF GR-CUST-NOTIFY-FL = 'Y'                                  
                WRITE LETTER-DETAIL-REC      FROM FIOCA66               
            END-IF.                                                     
T16852                                                                  
T16852      MOVE GM-METER-NO                 TO                         
T16852                          WS-METER-NUMBER (WS-METER-NUM-INDEX)    
T18652      MOVE EQ-CODE-CRNT-LOC            TO                         
T18652                           WS-CRNT-LOC-CD (WS-METER-NUM-INDEX)    
T16852      ADD 1                            TO WS-METER-NUM-INDEX.     
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3000-SELECT-AND-FORECAST.                                        
      *                                                                         
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
           PERFORM 7800-OPEN-SAMPLE-TEST-HIST    THRU 7800-EXIT         
           PERFORM 3100-GET-SAMPLE-TEST-HIST     THRU 3100-EXIT         
               UNTIL END-MTR-TEST-GRP.                                  
           PERFORM 7820-CLOSE-SAMPLE-TEST-HIST   THRU 7820-EXIT.        
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3100-GET-SAMPLE-TEST-HIST.                                       
           PERFORM 7810-FETCH-SAMPLE-TEST-HIST   THRU 7810-EXIT         
           IF SQLCODE  EQUAL  NOT-FOUND                                 
              MOVE WS-Y                      TO WS-END-MTR-TEST-GRP     
              GO TO 3100-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *DETERMINE POPULATION SIZE - COUNT ALL METERS WITH MATCHING               
      *SELECTION CRITERIA THAT HAVE A CODE_CRNT_LOC EQUAL TO                    
      *'J' INSTALLED                                                            
      *                                                                         
T16852     MOVE 1                            TO WS-SUB.                 
T23377     MOVE WS-N                         TO WS-GRP-CD-FOUND         
ACT047     PERFORM UNTIL GRP-CD-FOUND                                   
ACT047                OR WS-SUB > WS-MAX-TEST-GROUP-ENTRIES             
T23377         IF  WS-TEST-GRP-CD(WS-SUB) EQUAL MQ-MTR-TEST-GRP-CD      
T23377             SET GRP-CD-FOUND          TO TRUE                    
T23377         ELSE                                                     
T23377             ADD 1 TO WS-SUB                                      
T23377         END-IF                                                   
T16852     END-PERFORM.                                                 
T23377     IF  GRP-CD-FOUND                                             
T16852         MOVE WS-INSTALLED-QTY (WS-SUB) TO                        
T16852                                    WS-CURRENT-INSTALLED-QTY      
P01176         MOVE WS-AUTO-SAMPLE-TST-FL (WS-SUB) TO                   
P01176                                    WS-AUTOMATIC-TST-FL           
T23377     ELSE                                                         
T23377         MOVE ZEROS                 TO WS-CURRENT-INSTALLED-QTY   
P01176         MOVE 'N'                   TO WS-AUTOMATIC-TST-FL        
T23377     END-IF.                                                      
T16852*                                                                         
           IF WS-CURRENT-INSTALLED-QTY   EQUAL ZERO                     
              GO TO 3100-EXIT                                           
           END-IF.                                                      
           MOVE WS-CURRENT-INSTALLED-QTY     TO MQ-INSTALLED-QT.        
      *                                                                         
T16852*SELECT SAMPLE SIZE FROM TABLE B-3 "SAMPLE SIZE AND MAXIMUM               
ST    *ALLOWABLE PERCENT DEFECTIVE" IN "A STATISTICAL SAMPLING PLAN             
      *FOR SCE&G"                                                               
                                                                        
           MOVE WS-N                   TO WS-FOUND.                     
                                                                        
      *PROCESS TABLE B-3 VALUES FOR SCEG SAMPLE TEST                            
           IF WS-SYSIN-COMP-NO = '01'                                   
      *IF CURRENT INSTALLED QTY IS LESS THAN 3, DO NOT READ TABLE B-3,          
      *MAKE MQ-SAMPLE-MIN-QT SAME AS CURRENT INSTALLED QTY                      
             IF WS-CURRENT-INSTALLED-QTY < 3                            
                 MOVE WS-CURRENT-INSTALLED-QTY   TO MQ-SAMPLE-MIN-QT    
                                                    MQ-SELECTED-QT      
             ELSE                                                       
               PERFORM VARYING WS-SUB  FROM 1 BY 1                      
                        UNTIL WS-SUB > 15 OR FOUND                      
                IF (WS-CURRENT-INSTALLED-QTY >= ESMP-MIN-SIZE (WS-SUB)) 
                AND (WS-CURRENT-INSTALLED-QTY <= ESMP-MAX-SIZE (WS-SUB))
                  MOVE WS-Y                     TO WS-FOUND             
                END-IF                                                  
               END-PERFORM                                              
      *                                                                         
               IF FOUND                                                 
                   COMPUTE WS-SUB = WS-SUB - 1                          
               END-IF                                                   
      *IF SAMPLE SIZE IS NOT DEFINED IN TABLE ELEHSAMP THEN TAKE                
      *THE VALUE FROM THE 16TH RECORD OF THE TABLE                              
               MOVE ESMP-SAMPLE-SIZE (WS-SUB) TO MQ-SAMPLE-MIN-QT       
      *                                                                         
      *IF A TEST GROUP HAS FAILED IN THE PAST,USE CORRECTIVE                    
      *PERCENT INSTEAD OF TABLE B-3.                                            
      *                                                                         
END            IF MQ-SAMPL-CORRECTV-PCT          IS GREATER THAN ZERO   
T16852           COMPUTE  MQ-SAMPLE-MIN-QT  = MQ-SAMPLE-MIN-QT +        
T16852             (MQ-INSTALLED-QT * MQ-SAMPL-CORRECTV-PCT) / 100      
                 PERFORM VARYING WS-SUB FROM 1 BY 1                     
                  UNTIL WS-SUB > 15 OR SAMPLE-SIZE-FOUND                
                   IF MQ-SAMPLE-MIN-QT <= ESMP-SAMPLE-SIZE (WS-SUB)     
                     MOVE ESMP-SAMPLE-SIZE (WS-SUB) TO WS-SAMPLE-MIN-QT 
                     MOVE WS-Y                  TO WS-SAMPLE-SIZE-FOUND 
                   END-IF                                               
                   IF NOT SAMPLE-SIZE-FOUND                             
                     MOVE 200                     TO WS-SAMPLE-MIN-QT   
                   END-IF                                               
                 END-PERFORM                                            
      *                                                                         
                 MOVE WS-SAMPLE-MIN-QT            TO MQ-SAMPLE-MIN-QT   
T16852         END-IF                                                   
      *                                                                         
               COMPUTE  MQ-SELECTED-QT ROUNDED                          
                                         = MQ-SAMPLE-MIN-QT  +          
                 ((MQ-SAMPLE-MIN-QT * MQ-SAMPL-OVERAGE-PCT) / 100)      
      *                                                                         
               IF MQ-SELECTED-QT               >  MQ-INSTALLED-QT       
                 MOVE MQ-INSTALLED-QT            TO MQ-SELECTED-QT      
               END-IF                                                   
T16852       END-IF                                                     
T12999     END-IF.                                                      
                                                                        
      *PROCESS TABLE B-3 VALUES FOR PSNC SAMPLE TEST                            
           IF WS-SYSIN-COMP-NO = '26'                                   
      *IF CURRENT INSTALLED QTY IS LESS THAN 2, DO NOT READ TABLE B-3,          
      *MAKE MQ-SAMPLE-MIN-QT SAME AS CURRENT INSTALLED QTY                      
             IF WS-CURRENT-INSTALLED-QTY < 2                            
                 MOVE WS-CURRENT-INSTALLED-QTY   TO MQ-SAMPLE-MIN-QT    
                                                    MQ-SELECTED-QT      
             ELSE                                                       
               PERFORM VARYING WS-SUB  FROM 1 BY 1                      
                        UNTIL WS-SUB > 13 OR FOUND                      
                IF (WS-CURRENT-INSTALLED-QTY >= PSNC-MIN-SIZE (WS-SUB)) 
                AND (WS-CURRENT-INSTALLED-QTY <= PSNC-MAX-SIZE (WS-SUB))
                  MOVE WS-Y                     TO WS-FOUND             
                END-IF                                                  
               END-PERFORM                                              
      *                                                                         
               IF FOUND                                                 
                   COMPUTE WS-SUB = WS-SUB - 1                          
               END-IF                                                   
      *IF SAMPLE SIZE IS NOT DEFINED IN TABLE GMCCSAMP THEN TAKE                
      *THE VALUE FROM THE 14TH RECORD OF THE TABLE                              
               MOVE PSNC-SAMPLE-SIZE (WS-SUB) TO MQ-SAMPLE-MIN-QT       
      *                                                                         
      *IF A TEST GROUP HAS FAILED IN THE PAST,USE CORRECTIVE                    
      *PERCENT INSTEAD OF TABLE B-3.                                            
      *                                                                         
END            IF MQ-SAMPL-CORRECTV-PCT          IS GREATER THAN ZERO   
T16852           COMPUTE  MQ-SAMPLE-MIN-QT  = MQ-SAMPLE-MIN-QT +        
T16852             (MQ-INSTALLED-QT * MQ-SAMPL-CORRECTV-PCT) / 100      
                 PERFORM VARYING WS-SUB FROM 1 BY 1                     
                  UNTIL WS-SUB > 15 OR SAMPLE-SIZE-FOUND                
                   IF MQ-SAMPLE-MIN-QT <= PSNC-SAMPLE-SIZE (WS-SUB)     
                     MOVE PSNC-SAMPLE-SIZE (WS-SUB) TO WS-SAMPLE-MIN-QT 
                     MOVE WS-Y                  TO WS-SAMPLE-SIZE-FOUND 
                   END-IF                                               
                   IF NOT SAMPLE-SIZE-FOUND                             
                     MOVE 200                     TO WS-SAMPLE-MIN-QT   
                   END-IF                                               
                 END-PERFORM                                            
      *                                                                         
                 MOVE WS-SAMPLE-MIN-QT            TO MQ-SAMPLE-MIN-QT   
T16852         END-IF                                                   
      *                                                                         
               COMPUTE  MQ-SELECTED-QT ROUNDED                          
                                         = MQ-SAMPLE-MIN-QT  +          
                 ((MQ-SAMPLE-MIN-QT * MQ-SAMPL-OVERAGE-PCT) / 100)      
      *                                                                         
               IF MQ-SELECTED-QT               >  MQ-INSTALLED-QT       
                 MOVE MQ-INSTALLED-QT            TO MQ-SELECTED-QT      
               END-IF                                                   
T16852       END-IF                                                     
T12999     END-IF.                                                      
      *                                                                         
           MOVE MQ-SELECTED-QT               TO WS-SELECTED-QT          
      *                                                                         
           MOVE WS-PARM-TEST-YEAR            TO E-FRP61-TEST-YEAR       
           IF WS-PARM-RUN-TYPE  EQUAL WS-SELECT                         
              MOVE WS-S                      TO E-FRP61-TYPE-RUN        
           END-IF                                                       
           IF WS-PARM-RUN-TYPE  EQUAL WS-FORECAST                       
              MOVE WS-F                      TO E-FRP61-TYPE-RUN        
           END-IF                                                       
           MOVE MQ-MTR-TEST-GRP-CD           TO E-FRP61-MTR-TEST-GRP-CD 
              MOVE MQ-MTR-TEST-GRP-TX        TO                         
                                             E-FRP61-MTR-TEST-GRP-DESC  
           MOVE MQ-SAMPL-OVERAGE-PCT         TO                         
                                             E-FRP61-SAMPL-OVERAGE-PCT  
           MOVE MQ-SAMPL-CORRECTV-PCT        TO                         
                                             E-FRP61-SAMPL-CORRECTV-PCT 
           MOVE WS-CURRENT-INSTALLED-QTY     TO                         
                                            E-FRP61-INSTALLED-QT        
           MOVE MQ-SAMPLE-MIN-QT             TO E-FRP61-SAMPLE-MIN-QT   
           MOVE MQ-SAMPL-ADDITIONL-QT        TO                         
                                            E-FRP61-SAMPL-ADDITIONL-QT  
      *IF 3RD RECORD ON CSS_JOB_PARM IS PRESENT AND IF THE TEST GROUP           
      *VALUE IN THAT RECORD IS THE SAME AS MQ-MTR-TEST-GRP-CD, THEN             
      *THE NUMBER OF  METERS SELECTED FOR THAT TEST GRP SHOULD BE WHAT          
      *IS GIVEN IN SELECT QTY OF THE 3RD RECORD.                                
           IF WS-JOB-PARM-3                  EQUAL WS-Y                 
              IF WS-PARM-TEST-GRP-3 (WS-CTR-K) EQUAL MQ-MTR-TEST-GRP-CD 
                 MOVE WS-PARM-SELECT-QTY (WS-CTR-K)                     
                                             TO E-FRP61-SELECTED-QT     
                                             WS-NBR-RANDOM-NBRS         
              ELSE                                                      
                 MOVE MQ-SELECTED-QT            TO E-FRP61-SELECTED-QT  
                                                WS-NBR-RANDOM-NBRS      
              END-IF                                                    
           ELSE                                                         
              MOVE MQ-SELECTED-QT            TO E-FRP61-SELECTED-QT     
                                             WS-NBR-RANDOM-NBRS         
           END-IF                                                       
      *                                                                         
           WRITE POP-SAMPLE-REC              FROM FCSRP61.              
      *                                                                         
           IF WS-PARM-RUN-TYPE               EQUAL WS-FORECAST          
              GO TO 3100-EXIT                                           
           END-IF.                                                      
      *                                                                         
P01176     IF WS-AUTOMATIC-TST-FL = 'Y'                                 
P01176        MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR         
P01176        PERFORM 8250-UPDATE-MTR-TEST_HIST THRU 8250-EXIT          
P01176        GO TO 3100-EXIT                                           
P01176     END-IF.                                                      
      *                                                                         
      *GENERATE RANDOM NUMBERS                                                  
           PERFORM 4500-GENERATE-RANDOM-NUM      THRU 4500-EXIT         
      *                                                                         
T23377     PERFORM 7300-OPEN-METER-EQUIP-TST     THRU 7300-EXIT         
           MOVE 1                            TO WS-RANDOM-INDEX         
           MOVE 0                            TO WS-METER-SEQ            
           MOVE 1                            TO WS-METER-NUM-INDEX      
      *                                                                         
           SORT SORT-FILE                                               
           ON ASCENDING KEY S-RANDOM-NBR                                
           USING UNSORTED-RANDOM-FILE                                   
           GIVING SORTED-RANDOM-FILE.                                   
      *                                                                         
           OPEN INPUT SORTED-RANDOM-FILE.                               
      *                                                                         
           PERFORM 3200-PROCESS-SAMPLE-METERS    THRU 3200-EXIT         
T16852          VARYING WS-COUNT-1 FROM 1 BY 1                          
T16852           UNTIL WS-METER-NUM-INDEX  >  WS-NBR-RANDOM-NBRS        
                 OR SQLCODE EQUAL     NOT-FOUND                         
                 OR WS-END-OF-FILE    EQUAL WS-Y.                       
           MOVE WS-N                         TO  WS-END-OF-FILE         
           CLOSE                             SORTED-RANDOM-FILE         
      *                                                                         
T23377     PERFORM 7320-CLOSE-METER-EQUIP-TST    THRU 7320-EXIT         
T19314*                                                                         
T19314     IF  WS-SO-INDEX  >  0   AND                                  
ACT047         WS-SO-INDEX  <  WS-MAX-TEST-GROUP-ENTRIES                
              MOVE WS-G                TO WS-SO-UTIL-TYPE               
              MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE                    
              COMPUTE WS-NBR-METERS    =  WS-SO-INDEX                   
A01209        IF (WS-SYSIN-COMP-NO = '01' AND GR-SO-REQUIRED-FL = 'Y' ) 
A01209           OR WS-SYSIN-COMP-NO = '26'                             
                  CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE             
              END-IF                                                    
              COMPUTE WS-SO-INDEX = 0                                   
           END-IF                                                       
      *                                                                         
T16852     MOVE WS-METER-NUM-INDEX           TO  WS-COUNT.              
T16852     COMPUTE MQ-SELECTED-QT = WS-COUNT - 1.                       
           MOVE 1                            TO  WS-METER-NUM-INDEX     
           PERFORM 2200-UPDATE-GAS-METER         THRU 2200-EXIT         
                VARYING WS-COUNT-1 FROM 1 BY 1                          
T16852            UNTIL WS-COUNT-1  > MQ-SELECTED-QT.                   
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
           PERFORM 8200-UPDATE-MTR-SELECTED      THRU 8200-EXIT.        
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3200-PROCESS-SAMPLE-METERS.                                      
      *                                                                         
           READ SORTED-RANDOM-FILE                                      
             AT END MOVE WS-Y   TO WS-END-OF-FILE                       
T16852       COMPUTE WS-COUNT-1 = WS-COUNT-1 - 1                        
             GO TO 3200-EXIT                                            
           END-READ.                                                    
      *                                                                         
           COMPUTE  WS-NBR-OF-FETCHES                                   
             =   WS-RANDOM-NBR - WS-METER-SEQ                           
           PERFORM 3210-FETCH-NEXT-RECORD        THRU 3210-EXIT         
                   VARYING WS-FETCH-ALL-MTRS FROM 1 BY 1                
                   UNTIL WS-FETCH-ALL-MTRS  >    WS-NBR-OF-FETCHES      
                   OR SQLCODE                EQUAL NOT-FOUND.           
      *STORE METERS IN TABLE                                                    
T16852     IF WS-NBR-OF-FETCHES NOT = 0 AND SQLCODE = SUCCESSFUL-CALL   
T16852        IF  WS-CALL-SCSCA657 EQUAL WS-Y                           
T16852            MOVE WS-N                     TO WS-CALL-SCSCA657     
T16852        ELSE                                                      
T16852            PERFORM 2300-CALL-SCSCA657            THRU 2300-EXIT  
T16852        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3210-FETCH-NEXT-RECORD.                                          
T23377     PERFORM  7310-FETCH-METER-EQUIP-TEST  THRU 7310-EXIT         
           ADD 1                             TO WS-METER-SEQ.           
      *                                                                         
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4500-GENERATE-RANDOM-NUM.                                        
      *                                                                         
      * THIS PROGRAM USES A RANDOM NUMBER GENERATOR BASED ON                    
      * RECOMMENDATIONS FOUND IN THE BOOK 'RANDOM NUMBER GENERATORS'            
      * COPYRIGHTED BY THE COMPUTATIONAL SCIENCE EDUCATION PROJECT              
      * (FOUND AT INTERNET ADDRESS HTTP://WWW.IAC.TUT.FI/CSEP/RN/RN.HTML        
      * 6/10/97). ANDY BOWDEN RECOMMENDED THIS SOURCE.                          
      * SECTION 3.1 APPROACH TO LINEAR CONGRUENTIAL GENERATOR                   
      * NEXT RANDOM INTEGER : X(N+1) = (A*X(N) + C) (MOD M)                     
      * CORRESPONDING REAL NUMBER: R(N) = X(N) / (M-1) (0<= R(N) <=1)           
      * SECTION 3.4 SUMMARY OF LINEAR CONGRUENTIAL GENERATOR PROPERTIES         
      * RECOMMENDS THE FOLLOWING VALUES :                                       
      * M IS THE INTEGER MODULUS = (2**31) - 1 = 2,147,483,647                  
      * A IS AN INTEGER CONSTANT = (2**16) + 3 = 16807                          
      * C = 0                                                                   
      * M   PIC 9(15)       COMP-3       VALUE 2147483647                       
      * A   PIC 9(15)       COMP-3       VALUE 16807                            
      * X   PIC 9(15)       COMP-3                                              
      * R                   COMP-2 (COMP-2 IS DOUBLE PRECISION INTERNAL         
      *                     FLOATING POINT)                                     
      * RANDOM-NBR-TEST  PIC 9(7) COMP-3.                                       
      * RANDOM-NBR       PIC 9(7) COMP-3 OCCURS 250 TIMES.                      
      * MAX-RANDOM-NBR   PIC 9(3) COMP-3 VALUE 250.                             
      *                                                                         
           MOVE WS-SYS-TIME-SEC              TO ISEC                    
           MOVE WS-SYS-TIME-MIN              TO IMIN                    
           MOVE WS-SYS-TIME-HR               TO IHR                     
           MOVE WS-SYS-DATE-DD               TO IDAY                    
           MOVE WS-SYS-DATE-MM               TO IMON                    
           MOVE WS-SYS-DATE-YY               TO IYR                     
      * FOR EACH TEST GROUP GENERATE AN INITIAL SEED AND RANDOM NUMBERS         
      * MQ-RANDOM-SEED = ISEC + 60*(IMIN + 60*(IHR + 24*(IDAY - 1 +             
      * 31*(IMON - 1 + 12*IYR))))                                               
           IF WS-JOB-PARM-4 EQUAL WS-Y       AND                        
           MQ-MTR-TEST-GRP-CD  EQUAL WS-PARM-TEST-GRP-4                 
              MOVE  WS-PARM-INITIAL-SEED     TO WS-RANDOM-SEED          
              MOVE  WS-RANDOM-SEED           TO MQ-INITIAL-RANDM-SEED   
           ELSE                                                         
      * CALCULATE INITIAL SEED USING PREFERRED METHOD IN SECTION 3.2            
      * INITIAL SEED - SEE REFERENCE TO SOURCE FOR RANDOM NUMBER                
      * GENERATORS.                                                             
              COMPUTE WS-RANDOM-SEED = IMON - WS-1 + WS-12 * IYR        
              COMPUTE WS-RANDOM-SEED = IDAY - WS-1 +                    
                                       WS-31 * WS-RANDOM-SEED           
              COMPUTE WS-RANDOM-SEED = IHR +  WS-24 * WS-RANDOM-SEED    
              COMPUTE WS-RANDOM-SEED = IMIN + WS-60 * WS-RANDOM-SEED    
              COMPUTE WS-RANDOM-SEED = ISEC + WS-60 * WS-RANDOM-SEED    
              MOVE WS-RANDOM-SEED            TO MQ-INITIAL-RANDM-SEED   
           END-IF.                                                      
      *ENSURE THAT SEED IS ODD                                                  
           DIVIDE MQ-INITIAL-RANDM-SEED      BY 2                       
                                 GIVING     WS-DIV-REMAINDER            
                                 REMAINDER  WS-REMAINDER                
           IF WS-REMAINDER                   EQUAL  0                   
              COMPUTE MQ-INITIAL-RANDM-SEED =                           
                              MQ-INITIAL-RANDM-SEED   + WS-1            
           END-IF                                                       
      *                                                                         
      *ENSURE SAMPLE SIZE IS NOT GREATER THAN SIZE OF RANDOM NUMBER             
      *TABLE.                                                                   
           IF WS-NBR-RANDOM-NBRS IS GREATER THAN WS-MAX-RANDOM-NBR      
               DISPLAY '***************PCSCA656**************'          
               DISPLAY '* 4500-GENERATE-RANDOM-NUM          *'          
               DISPLAY '* METER TEST GROUP ', MQ-MTR-TEST-GRP-CD        
               DISPLAY '* EXCEEDS MAXIMUM SAMPLE SIZE OF    *'          
               DISPLAY '* MAX-RANDOM-NBR ', WS-MAX-RANDOM-NBR           
               DISPLAY '* SAMPLE SIZE SET TO "WS-MAX-RANDOM-NBR"*'      
               DISPLAY '***************PCSCA656**************'          
               MOVE WS-MAX-RANDOM-NBR        TO MQ-SELECTED-QT          
                                                WS-NBR-RANDOM-NBRS      
               MOVE WS-Y                     TO WS-MAX-RAN-NUM-REACHED  
           END-IF                                                       
      *                                                                         
      *GENERATE REQUIRED NUMBER OF RANDOM NUMBERS BETWEEN 1 AND                 
      *POPULATION SIZE                                                          
           MOVE MQ-INITIAL-RANDM-SEED        TO WS-RANDOM-X             
           OPEN OUTPUT UNSORTED-RANDOM-FILE                             
           IF UNSORTFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'UNSORTED  FILE OPEN ERROR'                       
              DISPLAY 'UNSORTED FILE STATUS IS ===>'                    
                                 WS-UNSORTEDFIL-STATUS                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
           MOVE 0                                TO RANDOM-NBR          
           WRITE    RANDOM-NUMBER-REC                                   
           PERFORM 4510-GEN-UNIQUE-RANDOM-NBR    THRU    4510-EXIT      
              VARYING WS-CTR-I FROM 1 BY 1                              
                  UNTIL WS-CTR-I  >    WS-NBR-RANDOM-NBRS.              
      *                                                                         
           CLOSE  UNSORTED-RANDOM-FILE                                  
           IF UNSORTFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'UNSORTED  FILE CLOSE ERROR'                      
              DISPLAY 'UNSORTED FILE STATUS IS  ===> '                  
                              WS-UNSORTEDFIL-STATUS                     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4510-GEN-UNIQUE-RANDOM-NBR.                                      
           PERFORM 4520-GEN-A-RANDOM-NBR         THRU 4520-EXIT         
              UNTIL VALID-RANDOM-NBR   OR  WS-CTR-I  >    249           
              OR    WS-CTR-I   >  WS-NBR-RANDOM-NBRS.                   
      *ONLY UNIQUE RANDOM NUMBERS ARE WRITTEN TO FILE                           
           IF INVALID-RANDOM-NBR                                        
              MOVE WS-N                      TO WS-INVALID-RANDOM-NBR   
           ELSE                                                         
              MOVE WS-RANDOM-NBR-TEST        TO                         
                                          WS-RANDOM-NBR-ARRAY(WS-CTR-I) 
              MOVE WS-RANDOM-NBR-TEST        TO UNSORTED-RANDOM-NBR     
ACT058        DISPLAY 'RANDOM NUMBER ' WS-RANDOM-NBR-TEST               
ACT058            ' SELECTED FOR GROUP ' MQ-MTR-TEST-GRP-CD             
              WRITE  UNSORTED-RANDOM-REC                                
      *FOLL 2 LINES TO BE DELETED LATER                                         
              MOVE WS-RANDOM-NBR-TEST        TO RANDOM-NBR              
              WRITE  RANDOM-NUMBER-REC                                  
           END-IF.                                                      
           MOVE WS-Y                         TO WS-VALID-RANDOM-NBR.    
      *                                                                         
       4510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4520-GEN-A-RANDOM-NBR.                                           
           COMPUTE WS-RANDOM-X = WS-RANDOM-A * WS-RANDOM-X              
           DIVIDE WS-RANDOM-X BY WS-RANDOM-M GIVING WS-DIV-RANDOM       
                         REMAINDER WS-REM-RANDOM                        
           MOVE WS-REM-RANDOM                TO WS-RANDOM-X             
           COMPUTE WS-TEMP = WS-RANDOM-M - WS-1                         
           DIVIDE WS-RANDOM-X BY WS-TEMP GIVING WS-RANDOM-R             
           MULTIPLY WS-RANDOM-R BY MQ-INSTALLED-QT  GIVING              
           WS-RANDOM-NBR-TEST ROUNDED                                   
      *CHECK TO SEE IF RANDOM NUMBER IS ALREADY IN TABLE                        
           MOVE   1                          TO WS-CTR-J                
           COMPUTE WS-LIMIT = WS-CTR-I  - 1                             
           PERFORM 4530-PROCESS                  THRU 4530-EXIT         
               UNTIL EXIT-LOOP.                                         
           MOVE WS-N                         TO WS-EXIT-LOOP.           
      *                                                                         
       4520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4530-PROCESS.                                                    
      *                                                                         
           IF WS-CTR-I                       EQUAL 1                    
              MOVE  WS-Y                     TO WS-EXIT-LOOP            
              MOVE  WS-N                     TO WS-VALID-RANDOM-NBR     
              GO TO 4530-EXIT                                           
           END-IF.                                                      
      *CHECKS IF DUPLICATE RANDOM NUMBER IS GENERATED                           
           IF WS-RANDOM-NBR-ARRAY(WS-CTR-J)  EQUAL WS-RANDOM-NBR-TEST   
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
              MOVE WS-Y                      TO WS-INVALID-RANDOM-NBR   
              MOVE WS-Y                      TO WS-EXIT-LOOP            
              COMPUTE WS-CTR-I = WS-CTR-I - 1                           
              GO TO 4530-EXIT                                           
           END-IF                                                       
           IF WS-PARM-RUN-TYPE  EQUAL WS-ADDITIONAL AND                 
              WS-RANDOM-NBR-TEST  >  WS-CURRENT-INSTALLED-QTY           
              DISPLAY '*******************************************'     
              DISPLAY '* CANNOT HAVE A SEQUENCE NUMBER GREATER   *'     
              DISPLAY '* THAN THE NUMBER OF CURRENTLY INSTALLED  *'     
              DISPLAY '* METERS, WHICH COULD BE LESS THAN THE    *'     
              DISPLAY '* ORIGINAL NUMBER OF INSTALLED METERS.    *'     
              DISPLAY '*******************************************'     
              PERFORM 9000-TERMINATE             THRU 9000-EXIT         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
              MOVE WS-Y                      TO WS-EXIT-LOOP            
           END-IF                                                       
           IF WS-CTR-J                       EQUAL WS-LIMIT             
              MOVE WS-Y                      TO WS-EXIT-LOOP            
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
           END-IF.                                                      
           COMPUTE WS-CTR-J = WS-CTR-J + 1.                             
      *                                                                         
       4530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES THE READ ON CSS_JOB_PARM                       *          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00004                                                
           END-EXEC.                                                            
      ****************************************************************          
      * THIS INCLUDES 9700-PROCESS-ABEND                            *           
      ****************************************************************          
           COPY CPD0023C.                                                       
T20234*                                                                         
T20234******************************************************************        
T20234* 6990-FETCH-CUR-ACCOUNT                                         *        
T20234*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
T20234******************************************************************        
T20234     EXEC SQL                                                             
P01176         INCLUDE CPDCA099                                                 
T20234     END-EXEC.                                                            
T20234*                                                                         
T20234 6995-CPD99-ERROR-ROUTINE.                                        
T20234*                                                                         
T20234     DISPLAY '***************PCSCA656*******************'         
T20234     DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
T20234     DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO 9             
T20234     DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
T20234     DISPLAY '***************PCSCA656*******************'         
T20234     PERFORM 9900-ABEND              THRU 9900-EXIT.              
T20234*                                                                         
T20234 6995-EXIT.                                                       
T20234     EXIT.                                                        
T20234*                                                                         
      ****************************************************************          
       7000-VALIDATE-MTR-TST-GROUP.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT MTR_TEST_GRP_CD,                                   
                     MTR_TEST_GRP_TX                                    
              INTO :GR-MTR-TEST-GRP-CD,                                 
                   :GR-MTR-TEST-GRP-TX                                  
              FROM CSS_MTR_TEST_GROUP WITH(READUNCOMMITTED)                     
              WHERE CODE_UTIL_TYPE       = :WS-G                        
              AND   MTR_TEST_GRP_CD      = :GR-MTR-TEST-GRP-CD          
T22243        AND   COMPANY_NO           = :GR-COMPANY-NO               
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_TEST_GRP_CD,                                           
MFA-TR*              MTR_TEST_GRP_TX                                            
MFA-TR*       INTO :GR-MTR-TEST-GRP-CD,                                         
MFA-TR*            :GR-MTR-TEST-GRP-TX                                          
MFA-TR*       FROM CSS_MTR_TEST_GROUP                                           
MFA-TR*       WHERE CODE_UTIL_TYPE       = :WS-G                                
MFA-TR*       AND   MTR_TEST_GRP_CD      = :GR-MTR-TEST-GRP-CD                  
MFA-TR*       AND   COMPANY_NO           = :GR-COMPANY-NO                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSCA656**************'          
               DISPLAY '* 7000-VALIDATE-MTR-TST-GROUP       *'          
               DISPLAY '* ERROR READING CSS_MTR_TEST_GROUP  *'          
               DISPLAY '* MTR TEST GRP ', GR-MTR-TEST-GRP-CD            
T22243         DISPLAY '* COMPANY NO   ', GR-COMPANY-NO                 
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSCA656**************'          
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-SELECT-METER-TEST-HIST.                                     
           EXEC SQL                                                     
               SELECT  CODE_UTIL_TYPE     ,                             
                       SELECTED_QT        ,                             
                       SAMPLE_MIN_QT      ,                             
                       SAMPL_OVERAGE_PCT  ,                             
                       SAMPL_CORRECTV_PCT ,                             
                       SAMPL_ADDITIONL_QT ,                             
C31091                 MTR_TEST_GRP_TX                                  
               INTO                                                     
                       :MQ-CODE-UTIL-TYPE     ,                         
                       :MQ-SELECTED-QT        ,                         
                       :MQ-SAMPLE-MIN-QT      ,                         
                       :MQ-SAMPL-OVERAGE-PCT  ,                         
                       :MQ-SAMPL-CORRECTV-PCT ,                         
                       :MQ-SAMPL-ADDITIONL-QT ,                         
C31091                 :MQ-MTR-TEST-GRP-TX                              
               FROM CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE      = :WS-G                        
                     AND TEST_YEAR       = :MQ-TEST-YEAR                
                     AND TEST_SCHED_CD   = :WS-R                        
                     AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD          
T22243               AND COMPANY_NO      = :MQ-COMPANY-NO               
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_UTIL_TYPE     ,                                     
MFA-TR*                SELECTED_QT        ,                                     
MFA-TR*                SAMPLE_MIN_QT      ,                                     
MFA-TR*                SAMPL_OVERAGE_PCT  ,                                     
MFA-TR*                SAMPL_CORRECTV_PCT ,                                     
MFA-TR*                SAMPL_ADDITIONL_QT ,                                     
MFA-TR*                MTR_TEST_GRP_TX                                          
MFA-TR*        INTO                                                             
MFA-TR*                :MQ-CODE-UTIL-TYPE     ,                                 
MFA-TR*                :MQ-SELECTED-QT        ,                                 
MFA-TR*                :MQ-SAMPLE-MIN-QT      ,                                 
MFA-TR*                :MQ-SAMPL-OVERAGE-PCT  ,                                 
MFA-TR*                :MQ-SAMPL-CORRECTV-PCT ,                                 
MFA-TR*                :MQ-SAMPL-ADDITIONL-QT ,                                 
MFA-TR*                :MQ-MTR-TEST-GRP-TX                                      
MFA-TR*        FROM CSS_MTR_TEST_HIST                                           
MFA-TR*        WHERE CODE_UTIL_TYPE      = :WS-G                                
MFA-TR*              AND TEST_YEAR       = :MQ-TEST-YEAR                        
MFA-TR*              AND TEST_SCHED_CD   = :WS-R                                
MFA-TR*              AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                  
MFA-TR*              AND COMPANY_NO      = :MQ-COMPANY-NO                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSCA656**********************'  
               DISPLAY '* 7100-SELECT-METER-TEST-HIST               *'  
               DISPLAY '* ERROR READING CSS_MTR_TEST_HIST           *'  
               DISPLAY '* TEST YEAR       IS '     MQ-TEST-YEAR         
               DISPLAY '* TEST SCHED CD   IS '     WS-R                 
               DISPLAY '* MTR TEST GRP CD IS '    MQ-MTR-TEST-GRP-CD    
T22243         DISPLAY '* COMPANY NO      IS '    MQ-COMPANY-NO         
               DISPLAY '* SQLCODE         IS '  WS-DISPLAY-RC           
               DISPLAY '* PROGRAM ABENDING...                       *'  
               DISPLAY '***************PCSCA656**********************'  
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-OPEN-GET-INSTALLED-QTY.                                     
ACT058     IF  SELECTING-ADDITIONAL                                     
ACT058         EXEC SQL                                                 
ACT058             OPEN GET-INSTALLED-QTY-ADD                           
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     ELSE                                                         
ACT058         EXEC SQL                                                 
ACT058             OPEN GET-INSTALLED-QTY                               
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     END-IF.                                                      
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7200-OPEN-GET-INSTALLED-QTY        *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7210-FETCH-GET-INSTALLED-QTY.                                    
      *                                                                         
ACT058     IF  SELECTING-ADDITIONAL                                     
ACT058         EXEC SQL                                                 
ACT058             FETCH GET-INSTALLED-QTY-ADD                          
ACT058             INTO :WS-CURRENT-INSTALLED-QTY                       
ACT058                 ,:GG-MTR-TEST-GRP-CD                             
P01176                 ,:GR-AUTO-SAMPLE-TST-FL                          
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     ELSE                                                         
ACT058         EXEC SQL                                                 
ACT058             FETCH GET-INSTALLED-QTY                              
ACT058             INTO :WS-CURRENT-INSTALLED-QTY                       
ACT058                 ,:GG-MTR-TEST-GRP-CD                             
P01176                 ,:GR-AUTO-SAMPLE-TST-FL                          
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     END-IF.                                                      
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7210-FETCH-GET-INSTALLED-QTY       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7220-CLOSE-GET-INSTALLED-QTY.                                    
           IF SELECTING-ADDITIONAL                                      
ACT058         EXEC SQL                                                 
ACT058             CLOSE GET-INSTALLED-QTY-ADD                          
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     ELSE                                                         
ACT058         EXEC SQL                                                 
ACT058             CLOSE GET-INSTALLED-QTY                              
ACT058         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
ACT058     END-IF.                                                      
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7220-CLOSE-GET-INSTALLED-QTY       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7300-OPEN-METER-EQUIP-TST.                                       
           EXEC SQL                                                     
               OPEN METER-EQUIP-TEST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7300-OPEN-METER-EQUIP-TST          *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7310-FETCH-METER-EQUIP-TEST.                                     
      *                                                                         
           EXEC SQL                                                     
               FETCH METER-EQUIP-TEST                                   
               INTO                                                     
               :GM-METER-NO         ,                                   
               :GM-TEST-SCHED-CD    ,                                   
               :GM-METER-SIZE-ID    ,                                   
               :GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULLIND,       
ACT019         :GM-CODE-METER-TYPE  ,                                   
               :EQ-COMPANY-NO       ,                                   
T16852         :EQ-CODE-CRNT-LOC    ,                                   
T16852         :EQ-CRNT-LOC-NO      ,                                   
               :EQ-CODE-MAKE        ,                                   
               :EQ-LOCAL-OFFICE     ,                                   
A01209         :GR-SO-REQUIRED-FL   ,                                   
A01209         :GR-CUST-NOTIFY-FL                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7310-FETCH-METER-EQUIP-TEST        *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7320-CLOSE-METER-EQUIP-TST.                                      
           EXEC SQL                                                     
               CLOSE METER-EQUIP-TEST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7320-CLOSE-METER-EQUIP-TST         *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7400-OPEN-ACCOUNT-DETAILS.                                       
           EXEC SQL                                                     
               OPEN ACCOUNT-DETAIL                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7400-OPEN-ACCOUNT-DETAILS           *'        
               DISPLAY '* METER_NO         ',  MN-METER-NO              
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_ACCOUNT     *'        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE            THRU 9000-EXIT         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7410-FETCH-ACCOUNT-DETAILS.                                      
           EXEC SQL                                                     
               FETCH ACCOUNT-DETAIL                                     
               INTO                                                     
               :UT-ACCOUNT-NO    ,                                      
               :UT-RATE-PLAN-NO  ,                                      
               :UT-READ-CYCLE    ,                                      
               :UT-READ-ROUTE    ,                                      
               :AT-CUSTOMER-NO   ,                                      
               :AT-CODE-ACCT-STAT,                                      
               :AT-LOCAL-OFFICE  ,                                      
               :AT-ACCT-CREATE-DT,                                      
               :AT-ADDRESS-ID,                                          
ACT019         :AT-ADDRESS-FORMAT,                                      
ACT019         :MN-REGISTER-RD-SEQ                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7410-FETCH-ACCOUNT-DETAILS          *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_ACCOUNT     *'        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE            THRU 9000-EXIT         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7420-CLOSE-ACCOUNT-DETAILS.                                      
           EXEC SQL                                                     
               CLOSE ACCOUNT-DETAIL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7420-CLOSE-ACCOUNT-DETAILS          *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_ACCOUNT     *'        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE            THRU 9000-EXIT         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7500-GET-LOCAL-OFFICE.                                           
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE                                      
               INTO  :AT-LOCAL-OFFICE                                   
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T22243         AND   COMPANY_NO = :AT-COMPANY-NO                        
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE                                              
MFA-TR*        INTO  :AT-LOCAL-OFFICE                                           
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        AND   COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7500-GET-LOCAL-OFFICE              *'         
               DISPLAY '* SQLCODE IS  ', WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO  ', AT-ACCOUNT-NO                  
T22243         DISPLAY '* COMPANY NO  ', AT-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7601-SELECT-GAS-METER.                                           
           EXEC SQL                                                     
               SELECT TEST_SCHED_CD        ,                            
                      METER_SIZE_ID        ,                            
                      DATE_LAST_TESTED                                  
               INTO   :GM-TEST-SCHED-CD    ,                            
                      :GM-METER-SIZE-ID    ,                            
                      :GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULLIND 
               FROM CSS_GAS_METER WITH(READUNCOMMITTED)                         
               WHERE CODE_UTIL_TYPE   = :WS-G                           
               AND   METER_NO         = :GM-METER-NO                    
T22243         AND   COMPANY_NO       = :GM-COMPANY-NO                  
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TEST_SCHED_CD        ,                                    
MFA-TR*               METER_SIZE_ID        ,                                    
MFA-TR*               DATE_LAST_TESTED                                          
MFA-TR*        INTO   :GM-TEST-SCHED-CD    ,                                    
MFA-TR*               :GM-METER-SIZE-ID    ,                                    
MFA-TR*               :GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULLIND         
MFA-TR*        FROM CSS_GAS_METER                                               
MFA-TR*        WHERE CODE_UTIL_TYPE   = :WS-G                                   
MFA-TR*        AND   METER_NO         = :GM-METER-NO                            
MFA-TR*        AND   COMPANY_NO       = :GM-COMPANY-NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7601                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7601-SELECT-GAS-METER               *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_GAS_METER   *'        
               DISPLAY '* CODE  UTIL TYPE  ', WS-G                      
               DISPLAY '* METER NO         ', GM-METER-NO               
T22243         DISPLAY '* COMPANY NO       ', GM-COMPANY-NO             
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7601-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7700-SELECT-MTR-CAP-CONSTANT.                                    
      *                                                                         
           EXEC SQL                                                     
                SELECT CONSTANT                                         
                INTO   :MC-CONSTANT                                     
                FROM   CSS_MTR_CAP WITH(READUNCOMMITTED)                        
                WHERE  CODE_UTIL_TYPE = :WS-G                           
                AND    METER_NO       = :MC-METER-NO                    
                AND    REG_ID_NO      = :MC-REG-ID-NO                   
T22243          AND    COMPANY_NO     = :MC-COMPANY-NO                  
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CONSTANT                                                 
MFA-TR*         INTO   :MC-CONSTANT                                             
MFA-TR*         FROM   CSS_MTR_CAP                                              
MFA-TR*         WHERE  CODE_UTIL_TYPE = :WS-G                                   
MFA-TR*         AND    METER_NO       = :MC-METER-NO                            
MFA-TR*         AND    REG_ID_NO      = :MC-REG-ID-NO                           
MFA-TR*         AND    COMPANY_NO     = :MC-COMPANY-NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ************'         
               DISPLAY '* 7700-SELECT-MTR-CAP-CONSTANT       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* METER NO IS ', MC-METER-NO                    
T22243         DISPLAY '* COMPANY NO  ', MC-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA656 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT019 7750-SELECT-METER-TYPE-DESC.                                     
ACT019*                                                                         
ACT019     EXEC SQL                                                     
ACT019          SELECT METER_TYPE_DESC                                  
ACT019          INTO   :M7-METER-TYPE-DESC                              
ACT019          FROM   CSS_METER_TYPE WITH(READUNCOMMITTED)                     
ACT019          WHERE  CODE_METER_TYPE = :M7-CODE-METER-TYPE            
ACT019                                                           
ACT019                                                      
ACT019     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT METER_TYPE_DESC                                          
MFA-TR*         INTO   :M7-METER-TYPE-DESC                                      
MFA-TR*         FROM   CSS_METER_TYPE                                           
MFA-TR*         WHERE  CODE_METER_TYPE = :M7-CODE-METER-TYPE                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT019*                                                                         
ACT019     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ACT019         CONTINUE                                                 
ACT019     ELSE                                                         
ACT019         MOVE SQLCODE            TO WS-DISPLAY-RC                 
ACT019         DISPLAY '********** PCSCA656 ABORT ************'         
ACT019         DISPLAY '* 7750-SELECT-METER-TYPE-DESC        *'         
ACT019         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
ACT019         DISPLAY '* METER TYPE CODE' M7-CODE-METER-TYPE           
ACT019         DISPLAY '* PROGRAM ABORTING...                *'         
ACT019         DISPLAY '********** PCSCA656 ABORT ************'         
ACT019         PERFORM 9000-TERMINATE       THRU 9000-EXIT              
ACT019         PERFORM 9900-ABEND                THRU 9900-EXIT         
ACT019     END-IF.                                                      
ACT019*                                                                         
ACT019 7750-EXIT.                                                       
ACT019     EXIT.                                                        
      *                                                                         
       7800-OPEN-SAMPLE-TEST-HIST.                                      
           EXEC SQL                                                     
               OPEN SAMPLE-TEST-HIST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7800-OPEN-SAMPLE-TEST-HIST          *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE          -    CSS_MTR_TEST_HIST*'       
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7810-FETCH-SAMPLE-TEST-HIST.                                     
           EXEC SQL                                                     
               FETCH SAMPLE-TEST-HIST                                   
               INTO                                                     
               :MQ-MTR-TEST-GRP-CD      ,                               
               :MQ-CODE-UTIL-TYPE       ,                               
               :MQ-SAMPLE-MIN-QT        ,                               
               :MQ-SAMPL-OVERAGE-PCT    ,                               
               :MQ-SAMPL-CORRECTV-PCT   ,                               
               :MQ-SAMPL-ADDITIONL-QT   ,                               
C31091         :MQ-MTR-TEST-GRP-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT *************'        
               DISPLAY '* 7810-FETCH-SAMPLE-TEST-HIST         *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE            '                            
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA656 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7820-CLOSE-SAMPLE-TEST-HIST.                                     
           EXEC SQL                                                     
               CLOSE SAMPLE-TEST-HIST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA656 ABORT ***************'      
               DISPLAY '* 7820-CLOSE-SAMPLE-TEST-HIST           *'      
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTR_TEST_HIST *'      
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA656 ABORT ***************'      
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7960-SELECT-EQUIP-DETAILS.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
                      CODE_MAKE                                         
               INTO  :EQ-COMPANY-NO,                                    
                     :EQ-CODE-MAKE                                      
               FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
               WHERE CODE_UTIL_TYPE = :WS-G                             
               AND   DEVICE_NO      = :EQ-DEVICE-NO                     
T22243         AND   COMPANY_NO     = :EQ-COMPANY-NO                    
A01209                                                           
ACT019                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               CODE_MAKE                                                 
MFA-TR*        INTO  :EQ-COMPANY-NO,                                            
MFA-TR*              :EQ-CODE-MAKE                                              
MFA-TR*        FROM CSS_EQUIPMENT                                               
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*        AND   DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*        AND   COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7960                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA656******************'        
               DISPLAY '* 7960-SELECT-EQUIP-DETAILS           *'        
               DISPLAY '* TABLE    :         CSS_EQUIPMENT    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO   IS ', EQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA656******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01209***************************************************************** 10290000
A01209* GET THE DB2- DATE                                             * 10300000
A01209***************************************************************** 10320000
A01209 7970-GET-DB2-TODAYS-DATE.                                        
A01209*                                                                 10340000
A01209     EXEC SQL                                                     
A01209       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DB2-TODAYS-DATE                     
A01209     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10350000
MFA-TR*      SET :WS-DB2-TODAYS-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                    10390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209*                                                                 10400000
A01209     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A01209     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209         MOVE SQLCODE                    TO WS-DISPLAY-RC         
A01209         DISPLAY '********** PCSMT656 ABORT ************'         
A01209         DISPLAY '* 7970-GET-DB2-TODAYS-DATE           *'         
A01209         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
A01209         DISPLAY '* TEST DATE  ', WS-DB2-TODAYS-DATE              
A01209         DISPLAY '* PROGRAM ABORTING...                *'         
A01209         DISPLAY '********** PCSMT656 ABORT ************'         
A01209         PERFORM 9900-ABEND                THRU 9900-EXIT         
A01209     END-IF.                                                      
A01209*                                                                 10540000
A01209 7970-EXIT.                                                       
A01209     EXIT.                                                        
      *                                                                 10572000
       8000-UPDATE-GAS-METER.                                           
           EXEC SQL                                                     
               UPDATE CSS_GAS_METER                                     
               SET LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
                   LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD               
               WHERE CODE_UTIL_TYPE = :WS-G                             
               AND   METER_NO       = :GM-METER-NO                      
T22243         AND   COMPANY_NO     = :GM-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_METER                                             
MFA-TR*        SET LAST_TEST_SEL_DT = CURRENT DATE,                             
MFA-TR*            LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD                       
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*        AND   METER_NO       = :GM-METER-NO                              
MFA-TR*        AND   COMPANY_NO     = :GM-COMPANY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA656******************'        
               DISPLAY '* 8000-UPDATE-GAS-METER               *'        
               DISPLAY '* ERROR UPDATING CSS_GAS_METER        *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* METER NUMBER IS ', GM-METER-NO                
T22243         DISPLAY '* COMPANY NO   IS ', GM-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA656******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-UPDATE-MTR-TEST-HIST.                                       
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
               SET SAMPL_ADDITIONL_QT   = :MQ-SAMPL-ADDITIONL-QT,       
                   SELECTED_QT          = :MQ-SELECTED-QT               
               WHERE CODE_UTIL_TYPE     = :MQ-CODE-UTIL-TYPE            
               AND   TEST_YEAR          = :MQ-TEST-YEAR                 
               AND   TEST_SCHED_CD      = :WS-R                         
               AND   MTR_TEST_GRP_CD    = :MQ-MTR-TEST-GRP-CD           
T22243         AND   COMPANY_NO         = :MQ-COMPANY-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA656******************'        
               DISPLAY '* 8100-UPDATE-MTR-TEST-HIST           *'        
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* TEST_YEAR       ', MQ-TEST-YEAR               
               DISPLAY '* TEST_SCHED_CD   ', MQ-TEST-SCHED-CD           
               DISPLAY '* MTR_TEST_GRP_CD ', MQ-MTR-TEST-GRP-CD         
T22243         DISPLAY '* COMPANY NO      ', MQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA656******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-UPDATE-MTR-SELECTED.                                        
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
T16852         SET INSTALLED_QT  = :MQ-INSTALLED-QT,                    
T16852             SELECTED_QT   = :MQ-SELECTED-QT,                     
                   SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                   
T16852             LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
ACT194             STATUS_CD     = 'B'                                  
               WHERE CODE_UTIL_TYPE = :WS-G                             
               AND   TEST_YEAR      = :MQ-TEST-YEAR                     
               AND   TEST_SCHED_CD  = :WS-R                             
               AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
T22243         AND   COMPANY_NO      = :MQ-COMPANY-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTR_TEST_HIST                                         
MFA-TR*        SET INSTALLED_QT  = :MQ-INSTALLED-QT,                            
MFA-TR*            SELECTED_QT   = :MQ-SELECTED-QT,                             
MFA-TR*            SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                           
MFA-TR*            LAST_TEST_SEL_DT = CURRENT DATE,                             
MFA-TR*            STATUS_CD     = 'B'                                          
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-G                                     
MFA-TR*        AND   TEST_YEAR      = :MQ-TEST-YEAR                             
MFA-TR*        AND   TEST_SCHED_CD  = :WS-R                                     
MFA-TR*        AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                      
MFA-TR*        AND   COMPANY_NO      = :MQ-COMPANY-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL  SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA656******************'        
               DISPLAY '* 8200-UPDATE-MTR-SELECTED            *'        
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-G                       
               DISPLAY '* TEST_YEAR       ', WS-DB2-YEAR                
               DISPLAY '* TEST_SCHED_CD   ', WS-R                       
               DISPLAY '* MTR_TEST_GRP_CD ', MQ-MTR-TEST-GRP-CD         
T22243         DISPLAY '* COMPANY NO      ', MQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA656******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P01176*================================================================*        
P01176 8250-UPDATE-MTR-TEST_HIST.                                       
P01176*================================================================*        
P01176                                                                  
P01176     EXEC SQL                                                     
P01176         UPDATE CSS_MTR_TEST_HIST                                 
P01176         SET INSTALLED_QT  = :MQ-INSTALLED-QT,                    
P01176             SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                   
P01176             LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
P01176             STATUS_CD     = 'B'                                  
P01176         WHERE CODE_UTIL_TYPE = 'G'                               
P01176         AND   TEST_YEAR      = :MQ-TEST-YEAR                     
P01176         AND   TEST_SCHED_CD  = 'R'                               
P01176         AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
P01176         AND   COMPANY_NO      = :MQ-COMPANY-NO                   
P01176     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTR_TEST_HIST                                         
MFA-TR*        SET INSTALLED_QT  = :MQ-INSTALLED-QT,                            
MFA-TR*            SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                           
MFA-TR*            LAST_TEST_SEL_DT = CURRENT DATE,                             
MFA-TR*            STATUS_CD     = 'B'                                          
MFA-TR*        WHERE CODE_UTIL_TYPE = 'G'                                       
MFA-TR*        AND   TEST_YEAR      = :MQ-TEST-YEAR                             
MFA-TR*        AND   TEST_SCHED_CD  = 'R'                                       
MFA-TR*        AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                      
MFA-TR*        AND   COMPANY_NO      = :MQ-COMPANY-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P01176*                                                                         
P01176     IF SQLCODE EQUAL  SUCCESSFUL-CALL                            
P01176         NEXT SENTENCE                                            
P01176     ELSE                                                         
P01176         MOVE SQLCODE TO WS-DISPLAY-RC                            
P01176         DISPLAY '*************PCSCA656******************'        
P01176         DISPLAY '* 8250-UPDATE-MTR-TEST_HIST           *'        
P01176         DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
P01176         DISPLAY '* UTIL TYPE IS    ', WS-G                       
P01176         DISPLAY '* TEST_YEAR       ', WS-DB2-YEAR                
P01176         DISPLAY '* TEST_SCHED_CD   ', WS-R                       
P01176         DISPLAY '* MTR_TEST_GRP_CD ', MQ-MTR-TEST-GRP-CD         
P01176         DISPLAY '* COMPANY NO      ', MQ-COMPANY-NO              
P01176         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
P01176         DISPLAY '* PROGRAM ABENDING...                 *'        
P01176         DISPLAY '*************PCSCA656******************'        
P01176         PERFORM 9000-TERMINATE       THRU 9000-EXIT              
P01176         PERFORM 9900-ABEND THRU 9900-EXIT                        
P01176     END-IF.                                                      
P01176*                                                                         
P01176 8250-EXIT.                                                       
P01176     EXIT.                                                        
P01176*                                                                         
A01209***************************************************************** 06560000
A01209* UPDATION OF JOB-PARM ROWS WITH STATUS = 'I'                   * 06570000
A01209***************************************************************** 06580000
A01209 8300-UPDATE-PARM.                                                
      *                                                                         
           EXEC SQL                                                     
A01209          UPDATE CSS_JOB_PARM                                     
A01209          SET STATUS         = :WS-I                              
A01209          WHERE COMPANY_NO   = :G6-COMPANY-NO                     
A01209            AND PROGRAM_NAME = :G6-PROGRAM-NAME                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01209     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A01209     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
A01209         MOVE SQLCODE                    TO WS-DISPLAY-RC         
A01209         DISPLAY '*************PCSMT656******************'        
A01209         DISPLAY '* 8200-UPDATE-PARM                *'            
               DISPLAY '* ERROR UPDATING CSS_JOB_PARM         *'        
               DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
A01209         DISPLAY '* CMP NO          '                             
               DISPLAY '* CMND_CODE       ', WS-PARM                    
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
A01209         DISPLAY '*************PCSMT656******************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
A01209 8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-PARM-RUN-TYPE    EQUAL WS-SELECT OR                    
              WS-PARM-RUN-TYPE    EQUAL WS-FORECAST                     
              CLOSE POPULATION-SAMPLE-FILE                              
      *                                                                         
              IF  SAMPFIL-SUCCESS                                       
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY 'FCSRP61  FILE CLOSE ERROR'                   
                  DISPLAY 'FCSRP61 FILE STATUS ==>' WS-SAMPFIL-STATUS   
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF WS-PARM-RUN-TYPE    EQUAL WS-SELECT OR                    
              WS-PARM-RUN-TYPE    EQUAL WS-ADDITIONAL                   
      *                                                                         
              CLOSE METER-DETAIL-FILE                                   
              IF  METFIL-SUCCESS                                        
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY 'FIOCA66  FILE CLOSE ERROR'                   
                  DISPLAY 'FIOCA66  FILE STATUS  ==>' WS-METFIL-STATUS  
              END-IF                                                    
      *                                                                         
              CLOSE LETTER-DETAIL-FILE                                  
              IF  LETFIL-SUCCESS                                        
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY 'LETTERS  FILE CLOSE ERROR'                   
                  DISPLAY 'LETTERS  FILE STATUS  ==>' WS-LETFIL-STATUS  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *BEGIN - LINES TO BE DELETED                                              
           CLOSE  RANDOM-NBR-FILE                                       
           IF RANDOMFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'RANDOMFIL  FILE CLOSE ERROR'                     
              DISPLAY 'RANDOMFIL FILE STATUS IS  ===> '                 
                              WS-RANDOMFIL-STATUS                       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
ACT040     MOVE WS-RETURN-CODE TO  RETURN-CODE.                         
      * DUMMY PARA FOR ADDR FORMATTING ROUTINES                                 
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *DUMMY PARA FOR ADDR FORMATTING ROUTINES - EXECUTES 9900-ABEND            
       9900-SQL-ERROR-ROUTINE.                                          
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *        
      ******************************************************************        
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
      *                                                                         
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                      

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

                                                                        
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
                                                                        
           IF WS-ABEND-YES                                              
               STOP RUN                                                 
           END-IF.                                                      
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
