       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA652.                                        
       AUTHOR.         ROGER D FAULK                                    
       INSTALLATION.                                                    
       DATE-WRITTEN.   JANUARY 2017.                                    
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  1 JAN 2017 RF10596       DEVELOPMENT OF NEW PROGRAM TO    **          
      **                           CREATE A WQ FOR METERS THAT HAVE **          
      **                           USAGE AND SHOULD NOT.            **          
      **                                                            **          
      ** 21 FEB 2017 RF10596       CORRECT READING FOR TYPE 04      **          
      **                                                            **          
      ** 24 FEB 2017 RF10596       OUT A SIGN ON DIFFERENCE         **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSCA652 NARRATIVE                        
           PROGRAM READS THE INPUT FIOBW09 FILE.  CREATE A WQ FOR       
           METERS THAT HAVE USEAGE AND SHOULD BE INVESTIGATED.          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW09.                                                            
      *                                                                         
       COPY CSSBW105.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW09.                                                            
       COPY FIOBW09.                                                            
      *                                                                         
       COPY CFDBW105.                                                           
       COPY FIOBW105.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA652'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME               PIC X(8)    VALUE 'PCSCA652'.     
      *                                                                         
       01  WS-WORK-AREA.                                                
           05 WS-WORK-DATE            PIC X(10)   VALUE SPACES.         
           05 WS-NO-READ-DAYS         PIC S9(4) COMP  VALUE ZEROS.      
           05 WS-NO-READ-DAYSX        PIC 9(5)    VALUE ZEROS.          
           05 WS-METER-SIZE-ID        PIC X(8)    VALUE 'I-210-I'.      
           05 WS-BYPASS-RECORD        PIC X       VALUE 'N'.            
           05 WS-SAVE-CODE-VALUE      PIC X(10)   VALUE SPACES.         
           05 WS-SAVE-FLASH-CARD-ID   PIC X(15)   VALUE SPACES.         
           05 WS-COMPANY-NAME         PIC X(26)   VALUE SPACES.         
           05 WS-PREM-ADDR            PIC X(55)   VALUE SPACES.         
           05 WS-PREM-TOWN            PIC X(30)   VALUE SPACES.         
           05 WS-PREM-ZIP             PIC X(5)    VALUE SPACES.         
           05 WS-MTR-READ-SOURCE-CD   PIC X       VALUE SPACES.         
           05 WS-NORMAL-PRIORITY      PIC X       VALUE 'N'.            
           05 WS-SCEG-NO-DATA         PIC X       VALUE 'N'.            
           05 WS-PSNC-NO-DATA         PIC X       VALUE 'N'.            
           05 WS-METER-NO             PIC X(9)    VALUE SPACES.         
           05 WS-METER-NO-CURRENTLY   PIC X(9)    VALUE SPACES.         
           05 WS-811                  PIC S9(9)   VALUE -811 COMP.      
           05 WS-803                  PIC S9(9)   VALUE -803 COMP.      
           05 WS-SAVE-PREMISE         PIC 9(10)   VALUE 0.              
           05 WS-SAVE-ERTID           PIC X(12)   VALUE SPACES.         
           05 WS-PGRMNAME             PIC X(8)    VALUE 'PCSCA652'.     
           05 WS-PREMISE-NO           PIC S9(10)V VALUE 0 COMP-3.       
           05 WS-CODE-UTIL-TYPE       PIC X(01)   VALUE SPACES.         
           05 WS-ERT-NO               PIC X(12)   VALUE SPACES.         
           05 WS-CURR-ACCT-NO         PIC 9(13)   VALUE ZERO.           
           05 WS-DEVICE-NO            PIC X(12)   VALUE SPACES.         
           05 WS-CATEGORY-ID          PIC S9(4) COMP VALUE 585.         
           05 WS-ROUTING-CATEGORY     PIC X       VALUE '1'.            
           05 SCSCB077                PIC X(8)    VALUE 'SCSCB077'.     
           05 WS-ACCOUNT              PIC S9(13)V COMP-3 VALUE 0.       
           05 WS-MV-ACCOUNT           PIC S9(13)V COMP-3 VALUE 0.       
           05 WS-LAST-REG-READ-DATE   PIC X(10)   VALUE SPACES.         
           05 WS-MV-INDEX             PIC ZZZZZ9.                       
           05 WS-OR-INDEX             PIC ZZZZZ9.                       
A05744     05 WS-USAGE                PIC ZZZZZZ9-.                     
           05 WS-MV-READ-VALUEX       PIC 9(15)   VALUE 0.              
           05 WS-MV-READ-VALUE        PIC S9(12)V9(3) COMP-3 VALUE 0.   
A05744     05 WS-CRNT-USE             PIC S9(9)V9(3) COMP-3 VALUE 0.    
           05 WS-MV-PREMISE           PIC S9(10)V COMP-3 VALUE 0.       
           05 WS-E                    PIC X    VALUE 'E'.               
           05 WS-WQ-YES               PIC X    VALUE 'Y'.               
           05 WS-WQ-NO                PIC X    VALUE 'N'.               
           05 WS-WQ-USE               PIC X    VALUE 'N'.               
           05 WS-SWITCHES.                                              
              10 WS-EOF-FLAG          PIC X    VALUE 'N'.               
                 88 END-OF-FILE              VALUE 'Y'.                 
              10 WS-FBW09-STATUS      PIC XX.                           
                 88 FBW09-SUCCESSFUL         VALUE '00'.                
              10 WS-FBW105-STATUS     PIC XX.                           
                 88 FBW105-SUCCESSFUL        VALUE '00'.                
      *                                                                         
       01 RS-RPC-RETURN-CODE.                                           
          05 RS-RETURN-CODE            PIC S9(4) VALUE +000 COMP.       
          05 RS-RETURN-CODE-DISP       PIC S9(4) VALUE +000 COMP.       
       01 S-RETURN-CODE                PIC S9(4) VALUE 0.               
      *                                                                         
       01 WS-COMMENTS-TEXT.                                             
          05 WS-COMMENTS-MSG           PIC X(26)                        
             VALUE 'OUT OF ROUTE READ - ERROR '.                        
          05 FILLER                    PIC X(8)                         
             VALUE 'METER = '.                                          
          05 WS-COMMENTS-METER         PIC X(9)   VALUE SPACES.         
          05 FILLER                    PIC X(8)                         
             VALUE ' TYPE = '.                                          
          05 WS-COMMENTS-TYPE          PIC X      VALUE SPACES.         
          05 FILLER                    PIC X(17)                        
             VALUE ' OOR READ DATE = '.                                 
          05 WS-COMMENTS-FILEDATE      PIC X(10)  VALUE SPACES.         
          05 FILLER                    PIC X(9)                         
             VALUE ' INDEX = '.                                         
          05 WS-COMMENTS-FILEINDX      PIC X(10)  VALUE SPACES.         
          05 FILLER                    PIC X(16)                        
             VALUE ' MN READ DATE = '.                                  
          05 WS-COMMENTS-MNDATE        PIC X(10)  VALUE SPACES.         
          05 FILLER                    PIC X(12)                        
             VALUE ' MN INDEX = '.                                      
          05 WS-COMMENTS-MNINDX        PIC X(15)  VALUE SPACES.         
          05 FILLER                    PIC X(14)                        
             VALUE ' USAGE DAYS = '.                                    
          05 WS-COMMENTS-DAYS          PIC X(10)  VALUE SPACES.         
A05744    05 FILLER                    PIC X(9)                         
A05744       VALUE ' USAGE = '.                                         
A05744    05 WS-COMMENTS-USAGE         PIC X(10)  VALUE SPACES.         
          05 FILLER                    PIC X(56)  VALUE SPACES.         
      *                                                                         
       01  WS-ERT-TYPE             PIC X(02).                           
           88  WS-ELECTRIC-METER   VALUE '04','05','07','08'.           
           88  WS-GAS-METER        VALUE '02','12'.                     
      *                                                                         
       01  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.            
       01  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.            
       01  WS-CURRENT-DATE-X10.                                         
           05  WS-SAVE-CURR-CC     PIC XX      VALUE SPACES.            
           05  WS-SAVE-CURR-YY     PIC XX      VALUE SPACES.            
           05  FILLER              PIC X       VALUE SPACES.            
           05  WS-SAVE-CURR-MM     PIC XX      VALUE SPACES.            
           05  FILLER              PIC X       VALUE SPACES.            
           05  WS-SAVE-CURR-DD     PIC XX      VALUE SPACES.            
      *                                                                         
       01  WS-ERT-READING          PIC 9(10)   VALUE ZEROS.             
       01  WS-ERT-READING7         PIC 9(7)    VALUE ZEROS.             
       01  WS-DIALS                PIC 99      VALUE 10.                
      *                                                                         
       01  WS-DATE-READ.                                                
           05 WS-FBW09-DATE-READ-YEAR.                                  
              10 WS-FBW09-DATE-READ-CC    PIC XX   VALUE SPACES.        
              10 WS-FBW09-DATE-READ-YY    PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE '-'.           
           05 WS-FBW09-DATE-READ-MM       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE '-'.           
           05 WS-FBW09-DATE-READ-DD       PIC XX   VALUE SPACES.        
      *                                                                         
       01  WS-TIME-READ.                                                
           05 WS-FBW09-TIME-READ-HH       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE ':'.           
           05 WS-FBW09-TIME-READ-MM       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE ':'.           
           05 WS-FBW09-TIME-READ-SS       PIC XX   VALUE SPACES.        
      *                                                                         
       01  WS-ERT-12A.                                                  
           05  WS-ERT-4                PIC X(4).                        
           05  WS-ERT-8                PIC X(8).                        
       01  WS-ERT-12B REDEFINES WS-ERT-12A.                             
           05  WS-ERT-3                PIC X(3).                        
           05  WS-ERT-9                PIC X(9).                        
      *                                                                         
       01 WS-WORK-PARM.                                                 
          05 WS-PARM-PROGRAM           PIC X(8)    VALUE 'PCSCA652'.    
          05 WS-PARM-COMPANY           PIC XX      VALUE SPACES.        
          05 WS-PARM-CMND-CODE         PIC X(4)    VALUE 'PARM'.        
      *                                                                         
       01  WS-EXCEPTION-MESSAGES.                                       
           05 WS-PREM-NOT-FOUND       PIC X(36)                         
              VALUE 'METER HAS NEVER BEEN INSTALLED      '.             
           05 WS-NOT-FOUND-ONMV       PIC X(36)                         
              VALUE 'METER NOT ON MOVEMENT_HIST AS J OR K'.             
           05 WS-NO-DATA-MSG          PIC X(23)                         
              VALUE 'NO DATA FOR THIS RUN   '.                          
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-NEGATIVE                 PIC X   VALUE '-'.           
           05  WS-YES                      PIC X   VALUE 'Y'.           
           05  WS-Y                        PIC X   VALUE 'Y'.           
           05  WS-N                        PIC X   VALUE 'N'.           
           05  WS-I                        PIC X   VALUE 'I'.           
           05  WS-NO                       PIC X   VALUE 'N'.           
           05  WS-M                        PIC X   VALUE 'M'.           
           05  WS-DOT                      PIC X   VALUE '.'.           
           05  WS-19-CENTURY               PIC 99  VALUE  19.           
           05  WS-20-CENTURY               PIC 99  VALUE  20.           
           05  WS-SCEG                     PIC X(26)                    
               VALUE '   S C ELECTRIC AND GAS CO'.                      
           05  WS-PSNC                     PIC X(26)                    
               VALUE '       PSNC ENERGY        '.                      
           05  WS-ELECTRIC                 PIC X   VALUE 'E'.           
           05  WS-GAS                      PIC X   VALUE 'G'.           
      *                                                                         
      ****************************************************************          
      *  CWS00303  WORKING STORAGE FIELDS                            *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900                                 *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_WQ_ITEMS                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD00074 - NAME AND ADDRESS              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM                                 *          
      *                                                              *          
      * DO NOT PUT ANYTHING BETWEEN CWS00038, 01 WS-PARM-FILE-06     *          
      * AND CWS00114.                                                *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - CREATE FILE 06 PARM           *          
      ****************************************************************          
      *                                                                         
       01  WS-PARM-FILE-06 REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           05  WS-COMPANY-LIT    PIC X(10).                             
           05  WS-COMPANY-PARM   PIC XX.                                
           05  FILLER            PIC X.                                 
           05  WS-FILE-06-LIT    PIC X(17).                             
           05  WS-FILE-06-PARM   PIC X.                                 
           05  FILLER            PIC X(49).                             
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - REPORT DATE                   *          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ****************************************************************          
      * USED WITH THE EMBEDDED SPACES ROUTINE                        *          
      ****************************************************************          
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_METER_ATTCHMTS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_ELEC_METER  -  EM                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTR_CAP                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTRD_ENVRNMT                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_PREMISE                                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_MOVEMENT_HIST                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_COMPANY                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FORMATTED                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FREEFORM                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_BILL_NMES                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_MISC_INFO                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_ADDR_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME_ACCT_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ZIP_CODE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CODE_VALUE                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   WORKING STORAGE FOR CPD00099 - GET MOST CURRENT            *          
      *        ACCOUNT NUMBER AT A PREMISE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                 40070000
      ****************************************************************          
      *    FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     *          
      ****************************************************************          
      *                                                                 40070000
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
           IF E-FBW09-NO-DATA-LIT = 'No input files to process.'        
              DISPLAY '***********************************'             
              DISPLAY '         0000-MAINLINE           **'             
              DISPLAY '      FCSBW09 FILE IS EMPTY      **'             
              DISPLAY '***********************************'             
           ELSE                                                         
              PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT                 
                 UNTIL END-OF-FILE                                      
           END-IF.                                                      
      *                                                                         
           PERFORM 3000-PROCESS-NODATA-REPORT THRU 3000-EXIT.           
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   INITIAL ROUTINE - OPEN INPUT AND OUTPUT FILES              *          
      *   AND GET CURRENT DATE.                                      *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW09-FILE.                                     
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '    ABENDING PROGRAM    '                        
              DISPLAY ' FIOBW09 FILE OPEN ERROR '                       
              DISPLAY '  0100-INITIALIZATION '                          
              DISPLAY 'FIOBW09 FILE STATUS = ' WS-FBW09-STATUS          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBW105-FILE.                                   
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
           MOVE WS-CURRENT-DATE TO WS-CURRENT-DATE-X10.                 
      *                                                                         
           IF WS-COMPANY-PARM = '01'                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE '01' TO WS-COMPANY-PARM                              
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** JOB PARM VALUE FOR COMPANY-NO NOT  **'        
              DISPLAY '** VALID.  USING 01 AS DEFAULT.       **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO WS-ERT-12A.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS INPUT DATA                                         *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE E-FBW09-DATE-READ-MM TO WS-FBW09-DATE-READ-MM.          
           MOVE E-FBW09-DATE-READ-DD TO WS-FBW09-DATE-READ-DD.          
           MOVE E-FBW09-DATE-READ-YY TO WS-FBW09-DATE-READ-YY.          
           MOVE WS-SAVE-CURR-CC      TO WS-FBW09-DATE-READ-CC.          
      *                                                                         
           MOVE E-FBW09-TIME-READ-HH TO WS-FBW09-TIME-READ-HH.          
           MOVE E-FBW09-TIME-READ-MM TO WS-FBW09-TIME-READ-MM.          
           MOVE E-FBW09-TIME-READ-SS TO WS-FBW09-TIME-READ-SS.          
      *                                                                         
           MOVE SPACES               TO WS-ERT-TYPE                     
                                        WS-ERT-NO                       
                                        WS-DEVICE-NO                    
                                        WS-CODE-UTIL-TYPE.              
           MOVE E-FBW09-ERT-TYPE     TO WS-ERT-TYPE.                    
                                                                        
           IF WS-ELECTRIC-METER                                         
              MOVE WS-ELECTRIC       TO WS-CODE-UTIL-TYPE               
           ELSE                                                         
              IF WS-GAS-METER                                           
                 MOVE WS-GAS         TO WS-CODE-UTIL-TYPE               
              ELSE                                                      
                 PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT            
                 GO TO 1000-EXIT                                        
           END-IF
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW09-ERT-ID(3:8)  TO WS-ERT-8.                       
           MOVE ZEROS                TO WS-ERT-4.                       
      *                                                                         
           MOVE WS-ERT-12A TO MA-DEVICE-NO                              
                              WS-ERT-NO.                                
      *                                                                         
                                                                        
           PERFORM 7100-CHECK-FOR-FIRST-ERT THRU 7100-EXIT              
                                                                        
           IF WS-DEVICE-NO = WS-ERT-NO                                  
              PERFORM 1200-PROCESS-ERT-ID   THRU 1200-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK ERT-ID ON METER_ATTCHMNTS.                           *          
      ****************************************************************          
      *                                                                         
       1200-PROCESS-ERT-ID.                                             
      *                                                                         
           INITIALIZE FIOBW105.                                         
           MOVE ZEROS  TO WS-DIALS.                                     
           MOVE SPACES TO WS-PREM-ADDR                                  
                          WS-PREM-TOWN                                  
                          WS-PREM-ZIP.                                  
           MOVE WS-WQ-NO TO WS-WQ-USE.                                  
      *                                                                         
           MOVE WS-COMPANY-PARM TO MA-COMPANY-NO.                       
           PERFORM 7200-CHECK-METER-ATTACHMENT THRU 7200-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MA-METER-NO TO MC-METER-NO                           
      *                                                                         
      *    CHECK - IF ELECTRIC AND METER-SIZE-ID = I-210-I ON                   
      *            CSS_ELEC_METER, GO READ ANOTHER                              
      *                                                                         
              MOVE WS-N TO WS-BYPASS-RECORD                             
              IF WS-ELECTRIC-METER                                      
                 MOVE MA-METER-NO     TO EM-METER-NO                    
                 MOVE WS-COMPANY-PARM TO EM-COMPANY-NO                  
                 MOVE WS-ELECTRIC     TO EM-CODE-UTIL-TYPE              
                 PERFORM 7450-ELEC-METER THRU 7450-EXIT                 
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-Y TO WS-BYPASS-RECORD                       
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF WS-BYPASS-RECORD = WS-N                                
                 MOVE WS-COMPANY-PARM TO MC-COMPANY-NO                  
                 PERFORM 7320-GET-MTR-CAP THRU 7320-EXIT                
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE MC-NO-DIALS TO WS-DIALS                        
                    PERFORM 1500-CALC-READING THRU 1500-EXIT            
                 ELSE                                                   
                    MOVE ZEROS TO WS-DIALS                              
                 END-IF                                                 
      *                                                                         
                 MOVE ZEROS TO WS-SAVE-PREMISE                          
                 MOVE MA-METER-NO TO EQ-DEVICE-NO                       
                 MOVE WS-COMPANY-PARM TO EQ-COMPANY-NO                  
      *                                                                         
                 PERFORM 7300-GET-PREMISE-FROM-EQ THRU 7300-EXIT        
                 MOVE EQ-CRNT-LOC-NO TO WS-SAVE-PREMISE                 
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF EQ-CODE-CRNT-LOC = 'J' OR 'K'                    
                       IF EQ-CRNT-LOC-NO = 0                            
                          MOVE SPACES TO WS-METER-NO-CURRENTLY          
                          MOVE MA-METER-NO TO MV-DEVICE-NO              
                          MOVE WS-COMPANY-PARM TO MV-COMPANY-NO         
                          PERFORM 7325-GET-PREMISE-FROM-MV              
                                      THRU 7325-EXIT                    
                          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
                             MOVE MV-LOC-NO TO WS-SAVE-PREMISE          
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                    IF WS-SAVE-PREMISE = 0                              
                       NEXT SENTENCE                                    
                    ELSE                                                
                       MOVE ZEROS TO WS-CPD99-ACCOUNT-NO                
                       MOVE WS-SAVE-PREMISE TO WS-CPD99-PREMISE-NO      
                       PERFORM 1400-GET-CURRENT-ACCOUNT THRU 1400-EXIT  
      *                                                                         
                       IF WS-CPD99-ACCOUNT-NO > ZEROS                   
                          MOVE WS-CPD99-ACCOUNT-NO TO MN-ACCOUNT-NO     
                          MOVE MA-METER-NO         TO MN-METER-NO       
                          PERFORM 7335-GET-MTRENV THRU 7335-EXIT        
                          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
                             MOVE MN-METER-NO TO WS-METER-NO-CURRENTLY  
                             PERFORM 1300-CREATE-OUTFILE-REPORT         
                                    THRU 1300-EXIT                      
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMISE NOT ON EQ FOR ' EQ-DEVICE-NO       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PREPARE FOR OUTPUT FILE FIOBW105.  THIS OUTPUT FILE        *          
      *   WILL BE PRINTED IN AN EZT PROGRAM.                         *          
      ****************************************************************          
      *                                                                         
       1300-CREATE-OUTFILE-REPORT.                                      
      *                                                                         
           IF WS-COMPANY-PARM = '01'                                    
              MOVE 'Y' TO WS-SCEG-NO-DATA                               
           END-IF.                                                      
      *                                                                         
           IF WS-PREM-ADDR = SPACES                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PREM-ADDR  TO E-FBW105-SERV-ADDR                  
              MOVE WS-PREM-TOWN  TO E-FBW105-SERV-TOWN                  
              MOVE WS-PREM-ZIP   TO E-FBW105-SERV-ZIP                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-CURRENT-DATE      TO E-FBW105-RUN-DATE.              
           MOVE WS-CURRENT-TIMESTAMP TO E-FBW105-RUN-TIMESTAMP.         
           MOVE WS-ERT-12A           TO E-FBW105-ERT-ID.                
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO  TO E-FBW105-ACCOUNT-NO.            
      *                                                                         
           MOVE WS-COMPANY-PARM      TO E-FBW105-COMPANY-NO.            
           MOVE MA-METER-NO          TO E-FBW105-METER-NO               
                                        WS-METER-NO.                    
           MOVE WS-SAVE-PREMISE      TO E-FBW105-PREMISE-NO.            
      *                                                                         
           MOVE WS-DATE-READ          TO E-FBW105-DATE-READ             
                                         WS-WORK-DATE.                  
           MOVE WS-TIME-READ          TO E-FBW105-TIME-READ.            
           MOVE E-FBW09-ERT-TYPE      TO E-FBW105-ERT-TYPE.             
           MOVE E-FBW09-TAMPER-CD-1   TO E-FBW105-TAMPER-CD-1.          
           MOVE E-FBW09-TAMPER-CD-2   TO E-FBW105-TAMPER-CD-2.          
           MOVE WS-METER-NO-CURRENTLY TO E-FBW105-METER-NO-CURRENTLY.   
           MOVE WS-ERT-READING        TO E-FBW105-ERT-READING.          
           MOVE WS-DIALS              TO E-FBW105-DIALS.                
      *                                                                         
           IF E-FBW09-FLASH-CARD-ID = WS-SAVE-FLASH-CARD-ID             
              MOVE WS-SAVE-CODE-VALUE TO E-FBW105-FLASH-CARD-ID         
           ELSE                                                         
              MOVE SPACES TO UV-CODE-SHORT-DESC                         
              MOVE E-FBW09-FLASH-CARD-ID TO UV-CODE-VALUE-TEXT          
              MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN    
              PERFORM 7030-SELECT-CODE-VALUE THRU 7030-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                MOVE SPACES                  TO WS-SAVE-CODE-VALUE      
                                                WS-SAVE-FLASH-CARD-ID   
                MOVE UV-CODE-SHORT-DESC-TEXT TO E-FBW105-FLASH-CARD-ID  
                                                WS-SAVE-CODE-VALUE      
                MOVE E-FBW09-FLASH-CARD-ID   TO WS-SAVE-FLASH-CARD-ID   
              ELSE                                                      
                MOVE SPACES                TO WS-SAVE-CODE-VALUE        
                                              WS-SAVE-FLASH-CARD-ID     
                MOVE E-FBW09-FLASH-CARD-ID TO WS-SAVE-FLASH-CARD-ID     
                MOVE 'INVALID CD'          TO E-FBW105-FLASH-CARD-ID    
                                              WS-SAVE-CODE-VALUE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW105-ACCOUNT-NO TO WS-ACCOUNT.                      
      *                                                                         
           IF E-FBW105-ACCOUNT-NO = ZEROS OR LOW-VALUES                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-MV-READ-VALUE = E-FBW105-ERT-READING                
                  OR WS-LAST-REG-READ-DATE > E-FBW105-DATE-READ         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 COMPUTE WS-CRNT-USE ROUNDED = E-FBW105-ERT-READING     
                         - WS-MV-READ-VALUE                             
                 IF WS-CODE-UTIL-TYPE = WS-E                            
A05744              IF WS-CRNT-USE > +11 OR WS-CRNT-USE < -11           
                       MOVE WS-WQ-YES TO WS-WQ-USE                      
                    END-IF                                              
                 ELSE                                                   
A05744              IF WS-CRNT-USE > +4 OR WS-CRNT-USE < -4             
                       MOVE WS-WQ-YES TO WS-WQ-USE                      
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              IF WS-WQ-USE = WS-WQ-YES                                  
                 PERFORM 7330-GET-NO-DAYS THRU 7330-EXIT                
                 PERFORM 4450-CREATE-WQ THRU 4450-EXIT                  
                 MOVE WS-WQ-NO TO WS-WQ-USE                             
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8200-WRITE-FIOBW105 THRU 8200-EXIT.                  
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET THE MOST CURRENT ACCOUNT FOR THE PREMISE NUMBER        *          
      *   AND SERVICE ADDRESS.                                       *          
      ****************************************************************          
      *                                                                         
       1400-GET-CURRENT-ACCOUNT.                                        
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
      *                                                                         
           IF WS-CPD99-ACCOUNT-NO = ZEROS                               
              DISPLAY '******************************************'      
              DISPLAY ' 1400-GET-CURRENT-ACCOUNT                *'      
              DISPLAY ' DID NOT FIND THE MOST CURRENT ACCOUNT   *'      
              DISPLAY ' FOR PREMISE NUMBER = ' WS-CPD99-PREMISE-NO      
              DISPLAY '******************************************'      
           ELSE                                                         
              MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                 
              MOVE ZEROS               TO AT-ADDRESS-ID                 
              PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT             
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   TAKE THE INPUT ERT-READING AND REFORMAT USING NUMBER       *          
      *   OF DIALS FROM MTRCAP.                                      *          
      ****************************************************************          
      *                                                                         
       1500-CALC-READING.                                               
      *                                                                         
           MOVE ZEROS TO WS-ERT-READING.                                
      *                                                                         
A05744     IF E-FBW09-ERT-TYPE = '04'                                   
A05744        MOVE E-FBW09-ERT-READING TO WS-ERT-READING                
A05744     ELSE                                                         
              IF WS-DIALS = 4 OR 5                                      
                 MOVE E-FBW09-ERT-READING (1:8) TO WS-ERT-READING       
              ELSE                                                      
                 MOVE E-FBW09-ERT-READING (1:9) TO WS-ERT-READING       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  WS-SCEG-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 01 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      ****************************************************************          
      *                                                                         
       3000-PROCESS-NODATA-REPORT.                                      
      *                                                                         
           IF WS-SCEG-NO-DATA = 'N'                                     
              INITIALIZE FIOBW105                                       
              MOVE WS-COMPANY-PARM TO E-FBW105-COMPANY-NO               
              MOVE WS-CURRENT-DATE TO E-FBW105-RUN-DATE                 
              MOVE WS-NO-DATA-MSG  TO E-FBW105-MESSAGE-AREA             
              PERFORM 8200-WRITE-FIOBW105 THRU 8200-EXIT                
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ****************************************************************          
      *  CREATE WQ FOR THIS ACOCUNT DUE TO USE                       *          
      ****************************************************************          
      *                                                                         
       4450-CREATE-WQ.                                                  
      *                                                                         
           INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
           MOVE WS-CATEGORY-ID      TO WS-77-CATEGORY-ID.               
      *                                                                         
           MOVE E-FBW105-METER-NO     TO WS-COMMENTS-METER.             
           MOVE WS-CODE-UTIL-TYPE     TO WS-COMMENTS-TYPE.              
           MOVE E-FBW105-DATE-READ    TO WS-COMMENTS-FILEDATE.          
           MOVE WS-LAST-REG-READ-DATE TO WS-COMMENTS-MNDATE.            
           MOVE E-FBW105-ERT-READING  TO WS-OR-INDEX.                   
           MOVE WS-OR-INDEX           TO WS-COMMENTS-FILEINDX.          
           MOVE WS-MV-READ-VALUE      TO WS-MV-READ-VALUEX.             
           MOVE WS-MV-READ-VALUEX     TO WS-MV-INDEX.                   
           MOVE WS-MV-INDEX           TO WS-COMMENTS-MNINDX.            
           MOVE WS-NO-READ-DAYS       TO WS-NO-READ-DAYSX.              
           MOVE WS-NO-READ-DAYSX      TO WS-COMMENTS-DAYS.              
      *                                                                         
A05744     MOVE WS-CRNT-USE           TO WS-USAGE.                      
A05744     MOVE WS-USAGE              TO WS-COMMENTS-USAGE.             
      *                                                                         
           MOVE WS-COMMENTS-TEXT    TO WS-77-COMMENTS-TEXT.             
           MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN.    
      *                                                                         
           MOVE SPACES              TO WS-77-RESP-AREA-ID.              
           MOVE ZEROS               TO WS-77-SERV-ORDER-NO.             
           MOVE E-FBW105-DATE-READ  TO WS-77-DATE-REQUIRED(1:10).       
           MOVE E-FBW105-ACCOUNT-NO TO WS-77-ACCOUNT-NO.                
           MOVE E-FBW105-PREMISE-NO TO WS-77-PREMISE-NO.                
           MOVE ZEROS               TO WS-77-CUSTOMER-NO.               
           MOVE SPACES              TO WS-77-LOCAL-OFFICE.              
           MOVE WS-ROUTING-CATEGORY TO WS-77-ROUTE-CATEGORY.            
           MOVE WS-NORMAL-PRIORITY  TO WS-77-PRIORITY.                  
           MOVE WS-PGRMNAME         TO WS-77-CREATED-BY.                
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
       4450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6995-CPD99-ERROR-ROUTINE IS PERFORMED IN CPD00099 WHEN      *          
      *  THERE IS A PROBLEM.                                         *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '*************PCSCA652************'               
              DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
              DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
              DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
              DISPLAY '* INFORMATIONAL ONLY  *'                         
              DISPLAY '*************PCSCA652************'               
           ELSE                                                         
              DISPLAY '*************PCSCA652************'               
              DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
              DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
              DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
              DISPLAY '* PROGRAM ABENDING...           *'               
              DISPLAY '*************PCSCA652************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   READ INPUT FILE                                            *          
      ****************************************************************          
      *                                                                         
       7000-READ-INPUT-FILE.                                            
      *                                                                         
           READ FCSBW09-FILE                                            
                     AT END MOVE WS-YES TO WS-EOF-FLAG.                 
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              IF END-OF-FILE                                            
                 CONTINUE                                               
              ELSE                                                      
                   DISPLAY '*************************************'      
                   DISPLAY '**   PCSCA652 PROCESSING ERROR     **'      
                   DISPLAY '**   ABEND IN PARAGRAPH 7000       **'      
                   DISPLAY '**  READ STATUS   = ' WS-FBW09-STATUS       
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET FLASH-ID LITERAL FROM CSS_CODE_VALUE                   *          
      *   IF THE VALUE IS NOT FOUND, "INVALID CD" WILL BE PUT        *          
      *   THE OUTPUT RECORD.                                         *          
      ****************************************************************          
      *                                                                         
       7030-SELECT-CODE-VALUE.                                          
      *                                                                         
           EXEC SQL                                                     
            SELECT CODE_SHORT_DESC                                      
              INTO :UV-CODE-SHORT-DESC                                  
             FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                         
             WHERE COMPANY_NO = '01'                                    
             AND   COLUMN_NA  = 'FLASH_ID'                              
             AND   TABLE_NA   = 'CSS_DUMMY'                             
             AND   CODE_VALUE = :UV-CODE-VALUE                          
             AND   PROGRAM_ID = 'PCSCA652'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODE_SHORT_DESC                                              
MFA-TR*       INTO :UV-CODE-SHORT-DESC                                          
MFA-TR*      FROM  CSS_CODE_VALUE                                               
MFA-TR*      WHERE COMPANY_NO = '01'                                            
MFA-TR*      AND   COLUMN_NA  = 'FLASH_ID'                                      
MFA-TR*      AND   TABLE_NA   = 'CSS_DUMMY'                                     
MFA-TR*      AND   CODE_VALUE = :UV-CODE-VALUE                                  
MFA-TR*      AND   PROGRAM_ID = 'PCSCA652'                                      
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '****************************************'       
               DISPLAY '**    7030-SELECT-CODE-VALUE          **'       
               DISPLAY '**      SOMETHING NOT RIGHT           **'       
               DISPLAY '** CODE VALUE = ' UV-CODE-VALUE                 
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '****************************************'       
               DISPLAY ' '                                              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *  In case of multiple ERT's, send only if the ERT received is *          
      *  the first ERT.                                              *          
      ****************************************************************          
      *                                                                         
       7100-CHECK-FOR-FIRST-ERT.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(MIN(DEVICE_NO),' ')                  
                 INTO :WS-DEVICE-NO                                     
                 FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO     = :WS-COMPANY-PARM                 
                  AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                  AND METER_NO =                                        
                      (SELECT MA.METER_NO                               
                       FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)         
                       WHERE MA.COMPANY_NO     = :WS-COMPANY-PARM       
                         AND MA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE     
                         AND MA.DEVICE_NO      = :WS-ERT-NO)            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MIN(DEVICE_NO),CHAR(' '))                          
MFA-TR*          INTO :WS-DEVICE-NO                                             
MFA-TR*          FROM CSS_METER_ATTCHMTS                                        
MFA-TR*         WHERE COMPANY_NO     = :WS-COMPANY-PARM                         
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO =                                                
MFA-TR*               (SELECT MA.METER_NO                                       
MFA-TR*                FROM CSS_METER_ATTCHMTS MA                               
MFA-TR*                WHERE MA.COMPANY_NO     = :WS-COMPANY-PARM               
MFA-TR*                  AND MA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
MFA-TR*                  AND MA.DEVICE_NO      = :WS-ERT-NO)                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '  ABENDING PROGRAM '                            
               DISPLAY '  7100-CHECK-FOR-FIRST-ERT '                    
               DISPLAY ' RETURN CODE =  ' WS-ACTIVE-RETURN-CODE         
               DISPLAY ' COMPANY NO     ' WS-COMPANY-PARM               
               DISPLAY ' CODE-UTIL-TYPE ' WS-CODE-UTIL-TYPE             
               DISPLAY ' ERT NO         ' WS-ERT-NO                     
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE METER NUMBER FROM CSS_METER_ATTCHMTS              *          
      ****************************************************************          
      *                                                                         
       7200-CHECK-METER-ATTACHMENT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :MA-METER-NO                                       
               FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                   ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)                 
              WHERE MA.COMPANY_NO            = :MA-COMPANY-NO           
               AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE       
               AND  MA.DEVICE_NO             = :MA-DEVICE-NO            
               AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE        
               AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE         
               AND  N5.DEVICE_TYPE_CD        = 'A'                      
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MA-METER-NO                                               
MFA-TR*        FROM CSS_METER_ATTCHMTS MA                                       
MFA-TR*            ,CSS_MTR_ATT_TYPE   N5                                       
MFA-TR*       WHERE MA.COMPANY_NO            = :MA-COMPANY-NO                   
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE               
MFA-TR*        AND  MA.DEVICE_NO             = :MA-DEVICE-NO                    
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE                
MFA-TR*        AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE                 
MFA-TR*        AND  N5.DEVICE_TYPE_CD        = 'A'                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_METER_ATTCHMTS   '                    
               DISPLAY '   7200-CHECK-METER-ATTACHMENT '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ERT-ID NUMBER  = ' MA-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_EQUIPMENT                 *          
      ****************************************************************          
      *                                                                         
       7300-GET-PREMISE-FROM-EQ.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CODE_CRNT_LOC,
              CRNT_LOC_NO                                        
                INTO :EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
                WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
                AND   DEVICE_NO      = :EQ-DEVICE-NO                    
                AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*         INTO :EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*         WHERE COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*         AND   DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*         AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7300-GET-PREMISE-FROM-EQ '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' EQ-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE NUMBER OF DIALS FROM CSS_MTR_CAP                  *          
      ****************************************************************          
      *                                                                         
       7320-GET-MTR-CAP.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) NO_DIALS                                           
                INTO :MC-NO-DIALS                                       
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
                WHERE COMPANY_NO     = :MC-COMPANY-NO                   
                AND   METER_NO       = :MC-METER-NO                     
                AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_DIALS                                                   
MFA-TR*         INTO :MC-NO-DIALS                                               
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*         WHERE COMPANY_NO     = :MC-COMPANY-NO                           
MFA-TR*         AND   METER_NO       = :MC-METER-NO                             
MFA-TR*         AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7320-GET-MTR-CAP   '                      
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' MC-METER-NO                 
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_MOVEMENT_HIST             *          
      ****************************************************************          
      *                                                                         
       7325-GET-PREMISE-FROM-MV.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) LOC_NO                                            
                INTO :MV-LOC-NO                                         
                FROM CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO     = :MV-COMPANY-NO                   
                 AND  DEVICE_NO      = :MV-DEVICE-NO                    
                 AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_CRNT_LOC  IN ('J', 'K')                      
                 AND  LOC_NO         > 0                                
           ORDER BY MOVE_NO DESC                                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  LOC_NO                                                    
MFA-TR*         INTO :MV-LOC-NO                                                 
MFA-TR*         FROM CSS_MOVEMENT_HIST                                          
MFA-TR*         WHERE COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*          AND  DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_CRNT_LOC  IN ('J', 'K')                              
MFA-TR*          AND  LOC_NO         > 0                                        
MFA-TR*    ORDER BY MOVE_NO DESC                                                
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '       CSS_MOVEMENT_HIST '                       
              DISPLAY '      7325-GET-PREMISE-FROM-MV '                 
              DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY ' METER NO       = ' MV-DEVICE-NO                 
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET NUMBER OF DAYS                                           *          
      ****************************************************************          
      *                                                                         
       7330-GET-NO-DAYS.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DATE
              ), CONVERT(DATE, :WS-LAST-REG-READ-DATE) ) )
            INTO
              :WS-NO-READ-DAYS   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-READ-DAYS =                                            
MFA-TR*            DAYS(:WS-WORK-DATE) - DAYS(:WS-LAST-REG-READ-DATE)           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA652 PROCESSING ERROR      **'       
               DISPLAY '**      IN PARAGRAPH 7330             **'       
               DISPLAY '** FILE DATE READ = ' WS-WORK-DATE              
               DISPLAY '** MN DATE READ = ' WS-LAST-REG-READ-DATE       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               MOVE ZEROS TO WS-NO-READ-DAYS                            
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE ACTUAL METER NUMBER ON CSS_MTRD_ENVRNMT           *          
      ****************************************************************          
      *                                                                         
       7335-GET-MTRENV.                                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) LAST_READ_VALUE,
              LAST_REG_READ_DATE                                 
                INTO :WS-MV-READ-VALUE                                  
                    ,:WS-LAST-REG-READ-DATE                             
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                 AND  METER_NO       = :MN-METER-NO                     
                 AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_METER_STATUS = 'J'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_READ_VALUE                                            
MFA-TR*             ,LAST_REG_READ_DATE                                         
MFA-TR*         INTO :WS-MV-READ-VALUE                                          
MFA-TR*             ,:WS-LAST-REG-READ-DATE                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*          AND  METER_NO       = :MN-METER-NO                             
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_METER_STATUS = 'J'                                   
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '  ABENDING PROGRAM '                             
              DISPLAY '  CSS_MTRD_ENVRNMT '                             
              DISPLAY '  7335-GET-MTRENV '                              
              DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY ' ACCOUNT-NO     = ' MN-ACCOUNT-NO                
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7335-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CHECK TO SEE IF YO WANT THIS METER.  IF FOUND, YOU DO NOT   *          
      *    WANT THIS METER.  IT HAS BEEN SOLD TO ANOTHER COMPANY     *          
      ****************************************************************          
      *                                                                         
       7450-ELEC-METER.                                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_SIZE_ID                                      
                INTO :EM-METER-SIZE-ID                                  
                FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
                WHERE METER_NO       = :EM-METER-NO                     
                 AND  COMPANY_NO     = :EM-COMPANY-NO                   
                 AND  CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE               
                 AND  METER_SIZE_ID  = :WS-METER-SIZE-ID                
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_SIZE_ID                                              
MFA-TR*         INTO :EM-METER-SIZE-ID                                          
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*         WHERE METER_NO       = :EM-METER-NO                             
MFA-TR*          AND  COMPANY_NO     = :EM-COMPANY-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                       
MFA-TR*          AND  METER_SIZE_ID  = :WS-METER-SIZE-ID                        
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '  ABENDING PROGRAM '                             
              DISPLAY '  CSS_ELEC_METER   '                             
              DISPLAY '  7450-ELEC-METER '                              
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY ' METER-NO       = ' EM-METER-NO                  
              DISPLAY ' COMPANY-NO     = ' EM-COMPANY-NO                
              DISPLAY ' CODE-UTIL-TYPE = ' EM-CODE-UTIL-TYPE            
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET CURRENT DATE AND TIMESTAMP                            *          
      ****************************************************************          
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURRENT DATE OR TIMESTAMP'        
              DISPLAY ' 7500-GET-CURRENT-TIMESTAMP '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  WRITE FIOBW105 RECORD                                     **          
      ****************************************************************          
      *                                                                         
       8200-WRITE-FIOBW105.                                             
      *                                                                         
           WRITE FIOBW105.                                              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8895-INSERT-WORK-QUEUE                                      *          
      ****************************************************************          
      *                                                                         
       8895-INSERT-WORK-QUEUE.                                          
      *                                                                         
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
      *                                                                         
           MOVE RS-RETURN-CODE  TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE WS-PGRMNAME     TO ABEND-PROGRAM                     
              DISPLAY '8895-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'ACCOUNT-NO      ' WS-77-ACCOUNT-NO               
              DISPLAY 'METER-NO        ' E-FBW105-METER-NO              
              DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
       8895-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   NORMAL JOB TERMINATION                                     *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW105-FILE                                          
                 FCSBW09-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  THIS INCLUDES 9700-PROCESS-ABEND                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE AND ALSO PERFORMS    *          
      *  9000-TERMINATE.  THEN IT MOVES 12 TO RETURN CODE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
