       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA651.                                        
       DATE-WRITTEN.   JAN 1984.                                        
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
TP4597**    09/10/96    JRX      TPR 4597 - ADD LOGIC TO FILL THE    **         
      **                         UTILITY TYPE IN THE OUTPUT FILE.    **         
      **                         ENABLE THE PROGRAM TO HANDLE BOTH   **         
      **                         GAS AND ELECTRIC METER.             **         
      **                         WRITE TO OUTPUT FILE CA83 IS THE    **         
      **                         TEST TYPE IS PERIODIC.              **         
PCR040**    01/06/97    CBSI     CHANGED THE METER HISTORY CODE TO 5 **         
PCR040**                MADRAS   CHARACTERS. CHANGED THE TITLE OF THE**         
PCR040**                         REPORT TO 'PERIODIC METER TEST      **         
PCR040**                         CONTROL LIST AS OF MM/DD/YY'        **         
CB4597**    JUNE,97     CBSI     ALL LINES MARKED AS CB4597 ARE FOR  **         
CB4597**               MADRAS         TPR4597                        **         
CB4597**                         REMOVED THE EXISTING REPORT. CODE   **         
CB4597**                         ADDED TO GIVE TWO  REPORTS          **         
CB4597**                          PCSCA651-01, PCSCA651-02           **         
CB4597**                         THE SORT FIELDS FOR THE FIRST ONE   **         
CB4597**                         ARE TEST-GROUP-CODE & METER NO      **         
CB4597**                         THE SORT FIELDS FOR THE SECOND REPORT*         
CB4597**                         ARE LOCAL OFFICE & METER NO.        **         
T22243**    08/24       CBSI     CHANGES MADE TO IMPLEMENT MULTI-    **         
T22243**               MADRAS    COMPANY IN METER INVENTORY.         **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA651 NARRATIVE                        
      *****************************************************************         
      *         THIS PROGRAM PRINTS A CONTROL LIST USED WITH THE      *         
CB4597*         ELECTRIC RANDOM METER EXCHANGE. INPUT TO THIS PROGRAM *         
CB4597*         IS A FLAT FILE BUILT BY PROGRAM PCSCA650 (ELECTRIC).  *         
      *****************************************************************         
                                                                        
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA65.                                                            
CB4597 COPY CSSCA651.                                                           
       COPY CSSPT32.                                                            
CB4597 COPY CSSPT321.                                                           
HPCCDM*EJECT                                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA65.                                                            
       COPY FIOCA65.                                                            
CB4597 COPY CFDCA651.                                                           
       COPY CFDPT32.                                                            
CB4597 COPY CFDPT321.                                                           
                                                                        
HPCCDM*EJECT                                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA651'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSCA651 STARTS HERE'.                  
      *                                                                         
       01  WS-NO-DATA-REC.                                              
           05  FILLER                      PIC X(57) VALUE SPACES.      
           05  FILLER                      PIC X(22) VALUE              
                                           '***NO DATA THIS RUN***'.    
           05  FILLER                      PIC X(53) VALUE SPACES.      
       01  WS-END-OF-DATA.                                              
           05  FILLER                      PIC X(57) VALUE SPACES.      
           05  FILLER                      PIC X(20) VALUE              
                                           '***END OF REPORT*** '.      
           05  FILLER                      PIC X(55) VALUE SPACES.      
       01  WS-MISC.                                                     
           05  WS-SUB                      PIC 9(02) VALUE ZEROES.      
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-R                        PIC X(01) VALUE 'R'.         
           05  WS-E                        PIC X(01) VALUE 'E'.         
           05  WS-G                        PIC X(01) VALUE 'G'.         
           05  WS-FCA65-STATUS             PIC X(02) VALUE '00'.        
TPR891         88 FCA65-SUCCESSFUL                   VALUE '00'.        
CB4597     05  WS-FCA651-STATUS            PIC X(02) VALUE '00'.        
CB4597         88 FCA651-SUCCESSFUL                  VALUE '00'.        
TPR891     05  WS-FCA32-STATUS             PIC X(02) VALUE '00'.        
TPR891         88 FCA32-SUCCESSFUL                   VALUE '00'.        
CB4597     05  WS-FCA321-STATUS            PIC X(02) VALUE '00'.        
CB4597         88 FCA321-SUCCESSFUL                  VALUE '00'.        
           05  WS-LINE-COUNT               PIC 9(02) VALUE ZEROES.      
           05  WS-PAGE-COUNT               PIC 9(03) VALUE ZEROES.      
           05  WS-CONSTANT-UNPK            PIC 9(06)V9(03) VALUE ZEROES.
           05  WS-FILE-FLAG                PIC X(01)  VALUE 'Y'.        
               88  MORE-RECORDS                       VALUE 'Y'.        
               88  NO-MORE-RECORDS                    VALUE 'N'.        
           05  WS-FISRT-RECORD                 PIC X(01)  VALUE 'N'.    
               88  FIRST-RECORD                           VALUE 'N'.    
               88  NOT-FIRST-RECORD                       VALUE 'Y'.    
TP4597     05  WS-PREV-UTIL-TYPE           PIC X(01)  VALUE SPACE.      
                                                                        
TP4597     05  WS-ELECTRIC-TEST            PIC X(08)  VALUE 'ELECTRIC'. 
TP4597     05  WS-GAS-TEST                 PIC X(08)  VALUE 'GAS     '. 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSCA651'. 
                                                                        
       01  WS-PREV-ACCOUNT-DETAILS.                                     
           05  WS-PREV-LOCAL-OFFICE        PIC X(03) VALUE SPACES.      
CB4597     05  WS-PREV-GROUP-CODE          PIC X(02)  VALUE SPACES.     
CB4597 01  WS-PREV-TOTALS.                                              
CB4597     05  WS-GRP-TOTAL                PIC S9(4) COMP-3 VALUE ZERO. 
CB4597     05  WS-OFF-TOTAL                PIC S9(4) COMP-3 VALUE ZERO. 
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
      *                                                                         
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00004.                                                           
       COPY CWS00010.                                                           
       COPY CWS00301.                                                           
                                                                        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
                                                                        
            EXEC SQL                                                            
                 INCLUDE CWS00038                                               
            END-EXEC.                                                           
                                                                        
       COPY CWS00039.                                                           
      *                                                                         
       01  WS-CONTROL-LIST-AREA.                                        
           05  HEADER-01.                                               
CB4597         10  FILLER             PIC X(09) VALUE 'PCSCA651-'.      
CB4597         10  HDR-REPORT-NO      PIC X(02) VALUE SPACES.           
CB4597         10  FILLER             PIC X(40) VALUE SPACES.           
CB4597*        10  HDR-01-TITLE       PIC X(31) VALUE                           
T22243         10  WS-COMPANY-NAME    PIC X(26) VALUE SPACES.           
CB4597         10  FILLER             PIC X(29) VALUE SPACES.           
CB4597         10  FILLER             PIC X(11) VALUE 'RUN DATE:  '.    
CB4597         10  HDR-01-DATE        PIC X(08).                        
CB4597*                                                                         
CB4597     05  HEADER-01A.                                              
CB4597         10  FILLER             PIC X(45) VALUE SPACES.           
CB4597         10  FILLER             PIC X(40) VALUE                   
CB4597             'ELECTRIC SAMPLE METER TEST CONTROL LIST '.          
CB4597         10  FILLER             PIC X(26) VALUE SPACES.           
CB4597         10  FILLER             PIC X(11) VALUE 'RUN TIME:  '.    
CB4597         10  HDR-01A-TIME.                                        
CB4597             15  HDR-01A-HH     PIC X(02).                        
CB4597             15  FILLER         PIC X(01) VALUE ':'.              
CB4597             15  HDR-01A-MM     PIC X(02).                        
CB4597             15  FILLER         PIC X(01) VALUE ':'.              
CB4597             15  HDR-01A-SS     PIC X(02).                        
                                                                        
CB4597     05  HEADER-02A.                                              
CB4597         10  FILLER             PIC X(45) VALUE SPACES.           
CB4597         10  FILLER             PIC X(12) VALUE 'TEST GROUP: '.   
CB4597         10  HDR-02A-TEST-CD    PIC X(02) VALUE SPACES.           
CB4597         10  FILLER             PIC X(01) VALUE SPACES.           
CB4597         10  HDR-02A-GRP-DESC   PIC X(25) VALUE SPACES.           
CB4597         10  FILLER             PIC X(30) VALUE SPACES.           
CB4597         10  FILLER             PIC X(09)  VALUE 'PAGE:    '.     
CB4597         10  HDR-02A-PAGE       PIC ZZ,ZZ9.                       
CB4597*                                                                         
           05  HEADER-03.                                               
               10  FILLER             PIC X(56) VALUE SPACES.           
               10  FILLER             PIC X(14) VALUE 'CURRENT AS OF '. 
               10  HDR-03-DATE.                                         
                   15 HDR-03-MM       PIC X(2)  VALUE SPACES.           
                   15 FILLER          PIC X(1)  VALUE '/'.              
                   15 HDR-03-DD       PIC X(2)  VALUE SPACES.           
                   15 FILLER          PIC X(1)  VALUE '/'.              
                   15 HDR-03-YY       PIC X(2)  VALUE SPACES.           
CB4597         10  FILLER             PIC X(37) VALUE SPACES.           
CB4597         10  HDR-03-PGNO.                                         
CB4597             15  HDR-03-PAGE    PIC X(09)  VALUE 'PAGE:    '.     
CB4597             15  HDR-03-PNO     PIC ZZ,ZZ9.                       
                                                                        
                                                                        
           05  HEADER-04.                                               
               10  FILLER                    PIC X(01) VALUE SPACE.     
               10  FILLER          PIC X(15) VALUE 'LOCAL OFFICE - '.   
               10  HRD-04-LOCAL-OFFICE       PIC X(03) VALUE SPACES.    
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  HRD-04-LOCAL-OFFICE-DESC  PIC X(25) VALUE SPACES.    
               10  FILLER                    PIC X(96) VALUE SPACES.    
      *                                                                         
CB4597     05  HEADER-05A.                                              
CB4597         10  FILLER             PIC X(06) VALUE SPACES.           
CB4597         10  HDR-COL1P1         PIC X(07) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE SPACES.           
CB4597         10  HDR-COL2P1         PIC X(30) VALUE SPACES.           
CB4597         10  FILLER             PIC X(22) VALUE SPACES.           
CB4597         10  FILLER             PIC X(04) VALUE 'RATE'.           
CB4597         10  FILLER             PIC X(01) VALUE SPACES.           
CB4597         10  FILLER             PIC X(12) VALUE 'METER NUMBER'.   
CB4597         10  FILLER             PIC X(02) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE 'METER '.         
CB4597         10  FILLER             PIC X(03) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE 'METER '.         
CB4597         10  FILLER             PIC X(03) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE 'METER '.         
CB4597         10  FILLER             PIC X(05) VALUE SPACES.           
CB4597         10  FILLER             PIC X(10) VALUE ' LAST TEST'.     
CB4597         10  FILLER             PIC X(01) VALUE SPACES.           
                                                                        
CB4597     05  HEADER-06A.                                              
CB4597         10  FILLER             PIC X(06) VALUE SPACES.           
CB4597         10  HDR-COL1P2         PIC X(07) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE SPACES.           
CB4597         10  HDR-COL2P2         PIC X(40) VALUE SPACES.           
CB4597         10  FILLER             PIC X(31) VALUE SPACES.           
CB4597         10  FILLER             PIC X(06) VALUE 'CLASS '.         
CB4597         10  FILLER             PIC X(04) VALUE SPACES.           
CB4597         10  FILLER             PIC X(04) VALUE 'SPEC'.           
CB4597         10  FILLER             PIC X(05) VALUE SPACES.           
CB4597         10  FILLER             PIC X(04) VALUE 'TYPE'.           
CB4597         10  FILLER             PIC X(09) VALUE SPACES.           
CB4597         10  FILLER             PIC X(04) VALUE 'DATE'.           
CB4597         10  FILLER             PIC X(04) VALUE SPACES.           
CB4597*                                                                         
CB4597     05  HEADER-07.                                               
CB4597         10  FILLER             PIC X(20) VALUE SPACES.           
CB4597         10  FILLER             PIC X(22) VALUE                   
CB4597               'TOTAL FOR TEST GROUP: '.                          
CB4597         10  DTL-TOTAL-GRP      PIC ZZZ,ZZ9.                      
CB4597         10  FILLER             PIC X(82) VALUE SPACES.           
CB4597*                                                                         
CB4597     05  HEADER-08.                                               
CB4597         10  FILLER             PIC X(20) VALUE SPACES.           
CB4597         10  FILLER             PIC X(24) VALUE                   
CB4597               'TOTAL FOR LOCAL OFFICE: '.                        
CB4597         10  DTL-TOTAL-LOCAL    PIC ZZZ,ZZ9.                      
CB4597         10  FILLER             PIC X(79) VALUE SPACES.           
                                                                        
CB4597     05  DTL-ACCT-NO.                                             
CB4597         10  DTL-ACT1              PIC 9(1).                      
CB4597         10  DTL-ACT2              PIC 9(4).                      
CB4597         10  DTL-ACT3              PIC 9(4).                      
CB4597         10  DTL-ACT4              PIC 9(4).                      
CB4597     05  DTL-01A-ACCT-NO.                                         
CB4597         10  DTL-01A-A1            PIC X(01).                     
CB4597         10  FILLER                PIC X(01) VALUE '-'.           
CB4597         10  DTL-01A-A2            PIC X(04).                     
CB4597         10  FILLER                PIC X(01) VALUE '-'.           
CB4597         10  DTL-01A-A3            PIC X(04).                     
CB4597         10  FILLER                PIC X(01) VALUE '-'.           
CB4597         10  DTL-01A-A4            PIC X(04).                     
CB4597     05  DTL-01A-NAME              PIC X(50) VALUE SPACES.        
CB4597     05  DTL-01A-READ-ROUTE        PIC X(04) VALUE SPACES.        
CB4597     05  DETAIL-01A.                                              
CB4597         10  FILLER                PIC X(02) VALUE SPACES.        
CB4597         10  DTL-01A-COL1          PIC X(16).                     
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597         10  DTL-01A-COL2          PIC X(50).                     
CB4597         10  FILLER                PIC X(03) VALUE SPACES.        
CB4597         10  DTL-01A-RATE          PIC X(03).                     
CB4597         10  FILLER                PIC X(03) VALUE SPACES.        
CB4597         10  DTL-01A-METER-NO      PIC X(09).                     
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597         10  FILLER                PIC X(04) VALUE SPACES.        
CB4597         10  DTL-01A-MTR-CLASS-CD  PIC X(02) VALUE SPACES.        
CB4597         10  FILLER                PIC X(07) VALUE SPACES.        
CB4597         10  DTL-01A-MTR-SPEC-CD   PIC X(03) VALUE SPACES.        
CB4597         10  FILLER                PIC X(02) VALUE SPACES.        
CB4597         10  DTL-01A-METER-TYPE    PIC X(08).                     
CB4597         10  FILLER                PIC X(06) VALUE SPACES.        
CB4597         10  DTL-01A-TEST-DATE     PIC X(10) VALUE SPACES.        
CB4597         10  FILLER                PIC X(02) VALUE SPACES.        
CB4597*                                                                         
CB4597    05  DETAIL-02A.                                               
CB4597         10  FILLER                PIC X(19) VALUE SPACES.        
CB4597         10  DTL-02A-CUST-NAME     PIC X(40) VALUE SPACES.        
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597         10  DTL-02A-ADDR          PIC X(35) VALUE SPACES.        
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597         10  DTL-02A-CITY-ST-ZCD   PIC X(34) VALUE SPACES.        
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597*                                                                         
          05  DETAIL-02.                                                
CB4597         10  FILLER                PIC X(19) VALUE SPACES.        
               10  DTL-02-ADDRESS        PIC X(42).                     
CB4597         10  FILLER                PIC X(01) VALUE SPACES.        
CB4597         10  DTL-02-CITY-ST-ZIP    PIC X(41).                     
CB4597         10  FILLER                PIC X(28) VALUE SPACES.        
      *                                                                         
109408 01  WS-SYSTEM-DATE.                                              
109408     05  WS-SYSTEM-YY            PIC 9(02).                       
109408     05  WS-SYSTEM-MM            PIC 9(02).                       
109408     05  WS-SYSTEM-DD            PIC 9(02).                       
      *                                                                         
109408 01  WS-FORMAT-DATE.                                              
109408     05  WS-FORMAT-MM            PIC 9(02).                       
109408     05  FILLER                  PIC X(01) VALUE '/'.             
109408     05  WS-FORMAT-DD            PIC 9(02).                       
109408     05  FILLER                  PIC X(01) VALUE '/'.             
109408     05  WS-FORMAT-YY            PIC 9(02).                       
      *                                                                         
109408 01  WS-REPORT-DATE.                                              
109408     10  WS-REPORT-CCYY.                                          
109408       15  WS-REPORT-CC            PIC X(02).                     
109408       15  WS-REPORT-YY            PIC X(02).                     
109408       15  FILLER                  PIC X(01).                     
109408       15  WS-REPORT-MM            PIC 9(02).                     
109408       15  FILLER                  PIC X(01).                     
109408       15  WS-REPORT-DD            PIC 9(02).                     
      *                                                                         
       01  WS-END                        PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSCA651 ENDS HERE  '.                  
HPCCDM*EJECT                                                                    
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
                                                                        
******* TABLE DECLARATION FOR CSS_LOCAL_OFFICE ********************             
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
******* TABLE DECLARATION FOR CSS_JOB_PARM ********************                 
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
CB4597* TABLE DECLARATION FOR CSS_MTR_TEST_GROUP***************                 
CB4597*                                                                         
CB4597     EXEC SQL                                                             
CB4597         INCLUDE TBMTRGP                                                  
CB4597     END-EXEC.                                                            
CB4597*                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00042                                                 
           END-EXEC.                                                            
      *                                                                         
T22243     EXEC SQL                                                             
T22243         INCLUDE TBCOMPNY                                                 
T22243     END-EXEC.                                                            
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
CB4597     PERFORM 0200-INITIALIZE-CA65 THRU 0200-EXIT.                 
      *                                                                         
CB4597     PERFORM 1000-FCSCA65-PROCESS THRU 1000-EXIT                  
               UNTIL NO-MORE-RECORDS.                                   
CB4597     MOVE WS-GRP-TOTAL  TO  DTL-TOTAL-GRP.                        
CB4597     IF  (57 - WS-LINE-COUNT)  LESS THAN  4                       
CB4597         PERFORM 8100-PRINT-PRT32-HEADINGS THRU 8100-EXIT         
CB4597     END-IF.                                                      
CB4597     WRITE PRT32-RECORD FROM HEADER-07 AFTER 2.                   
      *                                                                         
           IF FIRST-RECORD                                              
               PERFORM 8500-NO-DATA-REPORT THRU 8500-EXIT               
CB4597         PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           ELSE                                                         
               WRITE PRT32-RECORD FROM WS-END-OF-DATA AFTER 2           
CB4597*                                                                         
CB4597         PERFORM 0300-INITIALIZE-CA651 THRU 0300-EXIT             
CB4597         PERFORM 2000-FCSCA651-PROCESS THRU 2000-EXIT             
CB4597                  UNTIL NO-MORE-RECORDS                           
CB4597*                                                                         
CB4597         MOVE WS-OFF-TOTAL TO DTL-TOTAL-LOCAL                     
CB4597         IF  (57 - WS-LINE-COUNT)  LESS THAN  4                   
CB4597             PERFORM 8101-PRINT-PRT321-HEADINGS THRU 8101-EXIT    
CB4597         END-IF                                                   
CB4597         WRITE PRT321-RECORD FROM HEADER-08 AFTER 2               
CB4597         WRITE PRT321-RECORD FROM WS-END-OF-DATA AFTER 2          
CB4597         PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
      *                                                                         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *   INITIALIZATION ROUTINE                                       *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE ZEROES TO  WS-PAGE-COUNT.                               
           MOVE SPACES TO  WS-PREV-ACCOUNT-DETAILS.                     
CB4597     MOVE ZEROES TO  WS-PREV-TOTALS.                              
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
                                                                        
           MOVE WS-HH                  TO HDR-01A-HH.                   
           MOVE WS-MM                  TO HDR-01A-MM.                   
           MOVE WS-SS                  TO HDR-01A-SS.                   
      *                                                                         
           ACCEPT WS-SYSTEM-DATE FROM DATE.                             
                                                                        
           MOVE WS-SYSTEM-YY           TO WS-FORMAT-YY.                 
           MOVE WS-SYSTEM-MM           TO WS-FORMAT-MM.                 
           MOVE WS-SYSTEM-DD           TO WS-FORMAT-DD.                 
      *                                                                         
CB4597      MOVE WS-SYSTEM-DD  TO HDR-03-DD.                            
CB4597      MOVE WS-SYSTEM-MM  TO HDR-03-MM.                            
CB4597      MOVE WS-SYSTEM-YY  TO HDR-03-YY.                            
CB4597*                                                                         
           MOVE WS-FORMAT-DATE         TO HDR-01-DATE.                  
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
            MOVE WS-INPUT-DATE TO WS-REPORT-DATE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
CB4597*                                                                         
CB4597 0200-INITIALIZE-CA65.                                            
                                                                        
CB4597     PERFORM 0100-INITIALIZATION  THRU  0100-EXIT.                
CB4597     SET FIRST-RECORD TO TRUE.                                    
CB4597     OPEN INPUT FCSCA65-FILE.                                     
CB4597*                                                                         
CB4597     IF  FCA65-SUCCESSFUL                                         
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FCSCA65 FILE OPEN ERROR'                        
CB4597         DISPLAY 'FCSCA65 FILE STATUE IS ==>' WS-FCA65-STATUS     
CB4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597     OPEN OUTPUT FCSPT32-FILE.                                    
CB4597     IF  FCA32-SUCCESSFUL                                         
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FCSPT32 FILE OPEN ERROR'                        
CB4597         DISPLAY 'FCSPT32 FILE STATUE IS ==>' WS-FCA32-STATUS     
CB4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
CB4597     END-IF.                                                      
CB4597 0200-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
CB4597 0300-INITIALIZE-CA651.                                           
CB4597*                                                                         
CB4597     PERFORM 0100-INITIALIZATION  THRU  0100-EXIT.                
CB4597     SET MORE-RECORDS                    TO  TRUE.                
CB4597*                                                                         
CB4597     OPEN INPUT FCSCA651-FILE.                                    
CB4597                                                                  
CB4597     IF  FCA651-SUCCESSFUL                                        
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FCSCA651 FILE OPEN ERROR'                       
CB4597         DISPLAY 'FCSCA651 FILE STATUE IS ==>' WS-FCA651-STATUS   
CB4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597     OPEN OUTPUT FCSPT321-FILE.                                   
CB4597     IF  FCA321-SUCCESSFUL                                        
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FCSPT321 FILE OPEN ERROR'                       
CB4597         DISPLAY 'FCSPT321 FILE STATUE IS ==>' WS-FCA321-STATUS   
CB4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
CB4597     END-IF.                                                      
CB4597 0300-EXIT.                                                       
CB4597     EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   MAIN PROCESS                                                 *        
      ******************************************************************        
CB4597 1000-FCSCA65-PROCESS.                                            
CB4597     PERFORM 7000-READ-FCSCA65-FILE THRU 7000-EXIT.               
T22243     MOVE E-FCA65-COMPANY-NO        TO GR-COMPANY-NO              
T22243                                       C7-COMPANY-NO.             
                                                                        
           IF MORE-RECORDS                                              
CB4597         PERFORM 8000-PRINT-REPORT-CA65 THRU 8000-EXIT            
               SET NOT-FIRST-RECORD TO TRUE                             
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      *COPY CPD00024.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
CB4597*                                                                         
CB4597 2000-FCSCA651-PROCESS.                                           
CB4597*                                                                         
CB4597     PERFORM 7001-READ-FCSCA651-FILE THRU 7001-EXIT.              
CB4597*                                                                         
CB4597     IF  MORE-RECORDS                                             
CB4597         PERFORM 8001-PRINT-REPORT-CA651 THRU 8001-EXIT           
CB4597         SET NOT-FIRST-RECORD TO TRUE                             
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597 2000-EXIT.                                                       
CB4597     EXIT.                                                        
HPCCDM*EJECT                                                                    
CB4597*                                                                         
CB4597 2100-MOVE-DETAILS-PARA.                                          
CB4597*                                                                         
CB4597     MOVE E-FCA65-ACCT-NO                TO  DTL-ACCT-NO.         
CB4597     MOVE DTL-ACT1                       TO  DTL-01A-A1.          
CB4597     MOVE DTL-ACT2                       TO  DTL-01A-A2.          
CB4597     MOVE DTL-ACT3                       TO  DTL-01A-A3.          
CB4597     MOVE DTL-ACT4                       TO  DTL-01A-A4.          
CB4597     MOVE E-FCA65-NAME                   TO  DTL-01A-NAME         
CB4597                                             DTL-02A-CUST-NAME.   
CB4597     MOVE E-FCA65-SERV-ADDR              TO  DTL-02-ADDRESS       
CB4597                                             DTL-02A-ADDR.        
CB4597     MOVE E-FCA65-ADDR-CITY-ST-ZIP       TO  DTL-02-CITY-ST-ZIP   
CB4597                                             DTL-02A-CITY-ST-ZCD. 
CB4597     MOVE E-FCA65-RATE                   TO  DTL-01A-RATE.        
CB4597     MOVE E-FCA65-METER-NO               TO  DTL-01A-METER-NO.    
CB4597     MOVE E-FCA65-TEST-DATE              TO  DTL-01A-TEST-DATE.   
CB4597     MOVE E-FCA65-METER-SIZE             TO  DTL-01A-METER-TYPE.  
CB4597     MOVE E-FCA65-MTR-SPEC-CD            TO  DTL-01A-MTR-SPEC-CD. 
CB4597     MOVE E-FCA65-MTR-CLASS-CD           TO  DTL-01A-MTR-CLASS-CD.
CB4597     MOVE E-FCA65-READ-ROUTE             TO  DTL-01A-READ-ROUTE.  
CB4597*                                                                         
CB4597 2100-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
      ******************************************************************        
      *   READ INPUT FILE SET END FLAG TO TRUE WHEN REACHES END OF FILE*        
      ******************************************************************        
CB4597 7000-READ-FCSCA65-FILE.                                          
                                                                        
           READ FCSCA65-FILE                                            
           AT END                                                       
              SET NO-MORE-RECORDS TO TRUE                               
              GO TO 7000-EXIT                                           
           END-READ.                                                    
                                                                        
           IF FCA65-SUCCESSFUL                                          
CB4597         IF  E-FCA65-MTR-TEST-GRP-CD = WS-PREV-GROUP-CODE         
CB4597             ADD 1 TO WS-GRP-TOTAL                                
CB4597         END-IF                                                   
           ELSE                                                         
                                                                        
              DISPLAY 'FCSCA65 FILE OPEN ERROR'                         
              DISPLAY 'FCSCA65 FILE STATUE IS ==>' WS-FCA65-STATUS      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
                                                                        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
CB4597******************************************************************        
CB4597***READS THE FILE FCSCA651 AND SETS END-OF-FILE FLAG AT THE END***        
CB4597******************************************************************        
CB4597 7001-READ-FCSCA651-FILE.                                         
CB4597*                                                                         
CB4597     READ FCSCA651-FILE                                           
CB4597     AT END                                                       
CB4597        SET NO-MORE-RECORDS TO TRUE                               
CB4597        GO TO 7001-EXIT                                           
CB4597     END-READ.                                                    
CB4597*                                                                         
CB4597     IF  FCA651-SUCCESSFUL                                        
CB4597*                                                                         
CB4597         MOVE SPACES  TO FIOCA65                                  
CB4597         MOVE FCSCA651-REC TO FIOCA65                             
CB4597         IF  E-FCA65-LOCAL-OFFICE = WS-PREV-LOCAL-OFFICE          
CB4597             ADD 1 TO WS-OFF-TOTAL                                
CB4597         END-IF                                                   
CB4597     ELSE                                                         
CB4597         DISPLAY 'FCSCA651 FILE READ ERROR'                       
CB4597         DISPLAY 'FCSCA651 FILE STATUE IS ==>' WS-FCA651-STATUS   
CB4597         PERFORM 9900-ABEND THRU 9900-EXIT                        
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597 7001-EXIT.                                                       
CB4597     EXIT.                                                        
                                                                        
       7200-GET-LOCAL-OFFICE.                                           
      ******************************************************************        
      *   GET LOCAL OFFICE DESCRIPTION  FROM CSS_LOCAL_OFFICE TABLE    *        
      ******************************************************************        
      *                                                                         
           MOVE E-FCA65-COMPANY-NO     TO B1-COMPANY-NO.                
           MOVE E-FCA65-LOCAL-OFFICE   TO B1-LOCAL-OFFICE.              
                                                                        
           EXEC SQL                                                     
               SELECT   LOCAL_OFFICE_DESC                               
                 INTO   :B1-LOCAL-OFFICE-DESC                           
                 FROM   CSS_LOCAL_OFFICE                                
               WHERE    COMPANY_NO   = :B1-COMPANY-NO                   
               AND      LOCAL_OFFICE = :B1-LOCAL-OFFICE                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE E-FCA65-LOCAL-OFFICE TO HRD-04-LOCAL-OFFICE         
               MOVE B1-LOCAL-OFFICE-DESC TO HRD-04-LOCAL-OFFICE-DESC    
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7200-GET-LOCAL-OFFICE *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY-NO = ' B1-COMPANY-NO                  
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
T22243******************************************************************        
T22243*  GETTING COMPANY NAME FOR WRITING REPORT.                      *        
T22243******************************************************************        
T22243 7300-GET-COMP-NAME.                                              
T22243     EXEC SQL                                                     
T22243          SELECT COMPANY_NAME                                     
T22243          INTO   :C7-COMPANY-NAME                                 
T22243          FROM   CSS_COMPANY                                      
T22243          WHERE  COMPANY_NO = :C7-COMPANY-NO                      
T22243     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T22243         MOVE C7-COMPANY-NAME    TO WS-COMPANY-NAME               
T22243         CONTINUE                                                 
T22243     ELSE                                                         
T22243         DISPLAY '* SELECT ERROR IN 7300-GET-COMP-NAME *'         
T22243         DISPLAY '* COMPANY-NO = ' C7-COMPANY-NO                  
T22243         DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '*         PROCESSING TERMINATED         *'      
T22243         PERFORM 9900-ABEND            THRU 9900-EXIT             
T22243     END-IF.                                                      
T22243 7300-EXIT.                                                       
T22243     EXIT.                                                        
T22243*                                                                         
CB4597 7700-GET-GROUP-CODE.                                             
CB4597******************************************************************        
CB4597*   GET GROUP CODE  DESCRIPTION  FROM CSS_MTR_TEST_GROUP         *        
CB4597******************************************************************        
CB4597*                                                                         
CB4597     EXEC SQL                                                     
CB4597         SELECT   MTR_TEST_GRP_TX                                 
CB4597           INTO   :GR-MTR-TEST-GRP-TX                             
CB4597           FROM   CSS_MTR_TEST_GROUP                              
CB4597         WHERE    MTR_TEST_GRP_CD = :GR-MTR-TEST-GRP-CD           
CB4597         AND      CODE_UTIL_TYPE = :GR-CODE-UTIL-TYPE             
T22243         AND      COMPANY_NO     = :GR-COMPANY-NO                 
CB4597     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CB4597*                                                                         
CB4597     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY '* SELECT ERROR IN 7700-GET-GROUP-CODE   *'      
CB4597         DISPLAY '* RETURN CODE = ' SQLCODE                       
CB4597         DISPLAY '*         PROCESSING TERMINATED         *'      
T22243         DISPLAY '* COMPANY-NO = ' GR-COMPANY-NO                  
CB4597         PERFORM 9900-ABEND            THRU 9900-EXIT             
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597 7700-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
      ******************************************************************        
      *   PRINT REPORT WITH CONTROL BREAKS AS REQUIRED                 *        
      ******************************************************************        
CB4597 8000-PRINT-REPORT-CA65.                                          
CB4597*                                                                         
CB4597     IF  E-FCA65-MTR-TEST-GRP-CD NOT EQUAL WS-PREV-GROUP-CODE     
CB4597         IF  WS-PREV-GROUP-CODE NOT EQUAL SPACES                  
CB4597             MOVE WS-GRP-TOTAL TO   DTL-TOTAL-GRP                 
CB4597             IF  (57 - WS-LINE-COUNT)  LESS THAN  2               
CB4597                 PERFORM 8100-PRINT-PRT32-HEADINGS THRU 8100-EXIT 
CB4597             END-IF                                               
CB4597             WRITE PRT32-RECORD FROM HEADER-07 AFTER 2            
CB4597             ADD 2 TO WS-LINE-COUNT                               
CB4597         END-IF                                                   
CB4597         MOVE    1                       TO  WS-GRP-TOTAL         
CB4597         MOVE E-FCA65-MTR-TEST-GRP-CD    TO  GR-MTR-TEST-GRP-CD   
CB4597         MOVE E-FCA65-UTIL-TYPE          TO  GR-CODE-UTIL-TYPE    
CB4597*                                                                         
CB4597         PERFORM 7700-GET-GROUP-CODE  THRU 7700-EXIT              
CB4597         IF  SQLCODE EQUAL SUCCESSFUL-CALL                        
CB4597             MOVE GR-MTR-TEST-GRP-CD     TO  HDR-02A-TEST-CD      
CB4597             MOVE GR-MTR-TEST-GRP-TX     TO  HDR-02A-GRP-DESC     
CB4597         END-IF                                                   
CB4597         PERFORM 8100-PRINT-PRT32-HEADINGS THRU 8100-EXIT         
CB4597         PERFORM 8200-PRINT-PRT32-DETAIL THRU 8200-EXIT           
CB4597         MOVE E-FCA65-MTR-TEST-GRP-CD TO WS-PREV-GROUP-CODE       
CB4597     ELSE                                                         
CB4597         IF  (57 - WS-LINE-COUNT)  LESS THAN  4                   
CB4597             PERFORM 8100-PRINT-PRT32-HEADINGS THRU 8100-EXIT     
CB4597             PERFORM 8200-PRINT-PRT32-DETAIL THRU 8200-EXIT       
CB4597         ELSE                                                     
CB4597             PERFORM 8200-PRINT-PRT32-DETAIL THRU 8200-EXIT       
               END-IF                                                   
            END-IF.                                                     
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
CB4597******************************************************************        
CB4597*   PRINT REPORT WITH CONTROL BREAKS AS REQUIRED FOR CFDPT321    *        
CB4597******************************************************************        
CB4597 8001-PRINT-REPORT-CA651.                                         
CB4597*                                                                         
CB4597     IF  E-FCA65-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCAL-OFFICE      
CB4597         IF  WS-PREV-LOCAL-OFFICE NOT EQUAL SPACES                
CB4597             MOVE WS-OFF-TOTAL TO DTL-TOTAL-LOCAL                 
CB4597             IF  (57 - WS-LINE-COUNT)  LESS THAN  2               
CB4597                 PERFORM 8101-PRINT-PRT321-HEADINGS THRU 8101-EXIT
CB4597             END-IF                                               
CB4597             WRITE PRT321-RECORD FROM HEADER-08 AFTER 2           
CB4597             ADD 2 TO WS-LINE-COUNT                               
CB4597         END-IF                                                   
CB4597         MOVE 1  TO  WS-OFF-TOTAL                                 
CB4597         PERFORM 7200-GET-LOCAL-OFFICE THRU  7200-EXIT            
CB4597         PERFORM 8101-PRINT-PRT321-HEADINGS THRU 8101-EXIT        
CB4597         PERFORM 8201-PRINT-PRT321-DETAIL THRU 8201-EXIT          
CB4597         MOVE E-FCA65-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE        
CB4597     ELSE                                                         
CB4597         IF  (57 - WS-LINE-COUNT)  LESS THAN  5                   
CB4597             PERFORM 8101-PRINT-PRT321-HEADINGS THRU 8101-EXIT    
CB4597             PERFORM 8201-PRINT-PRT321-DETAIL THRU 8201-EXIT      
CB4597         ELSE                                                     
CB4597             PERFORM 8201-PRINT-PRT321-DETAIL THRU 8201-EXIT      
CB4597         END-IF                                                   
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597 8001-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
CB4597 8100-PRINT-PRT32-HEADINGS.                                       
      ******************************************************************        
      *   PRINT THE HEADING AND AFTER DETAIL LINE WHEN DATA IS THERE   *        
      ******************************************************************        
                                                                        
           MOVE ZEROES TO WS-LINE-COUNT.                                
           ADD 1 TO WS-PAGE-COUNT.                                      
                                                                        
CB4597     MOVE '01'                           TO HDR-REPORT-NO.        
CB4597     MOVE WS-PAGE-COUNT                  TO  HDR-02A-PAGE.        
T22243     PERFORM 7300-GET-COMP-NAME          THRU 7300-EXIT.          
CB4597     WRITE PRT32-RECORD FROM HEADER-01   AFTER NEW-PAGE.          
CB4597     WRITE PRT32-RECORD FROM HEADER-01A AFTER 1.                  
CB4597     WRITE PRT32-RECORD FROM HEADER-02A AFTER 1.                  
CB4597     MOVE SPACES TO HDR-03-PGNO.                                  
CB4597     WRITE PRT32-RECORD FROM HEADER-03   AFTER 1.                 
CB4597     MOVE 'ACCOUNT'  TO  HDR-COL1P1.                              
CB4597     MOVE 'NUMBER '  TO  HDR-COL1P2.                              
CB4597     MOVE 'CUSTOMER NAME'    TO  HDR-COL2P1.                      
CB4597     MOVE 'SERVICE ADDRESS'  TO  HDR-COL2P2.                      
CB4597     WRITE PRT32-RECORD FROM HEADER-05A AFTER 2.                  
CB4597     WRITE PRT32-RECORD FROM HEADER-06A AFTER 1.                  
CB4597     ADD 07 TO WS-LINE-COUNT.                                     
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
CB4597 8101-PRINT-PRT321-HEADINGS.                                      
CB4597******************************************************************        
CB4597*   PRINT THE HEADING AND AFTER DETAIL LINE WHEN DATA IS THERE   *        
CB4597******************************************************************        
CB4597*                                                                         
CB4597     MOVE ZEROES                         TO  WS-LINE-COUNT.       
CB4597     ADD 1                               TO  WS-PAGE-COUNT.       
CB4597*                                                                         
CB4597     MOVE '02'                           TO HDR-REPORT-NO.        
CB4597     MOVE 'PAGE:    '                    TO HDR-03-PAGE.          
CB4597     MOVE WS-PAGE-COUNT                  TO HDR-03-PNO.           
CB4597*                                                                         
T22243     PERFORM 7300-GET-COMP-NAME          THRU 7300-EXIT.          
CB4597     WRITE PRT321-RECORD FROM HEADER-01  AFTER NEW-PAGE.          
CB4597     WRITE PRT321-RECORD FROM HEADER-01A AFTER 1.                 
CB4597     WRITE PRT321-RECORD FROM HEADER-03  AFTER 1.                 
CB4597     WRITE PRT321-RECORD FROM HEADER-04  AFTER 2.                 
CB4597     MOVE 'READ'  TO  HDR-COL1P1                                  
CB4597     MOVE 'ROUTE' TO  HDR-COL1P2                                  
CB4597     MOVE 'ACCOUNT NUMBER'                  TO  HDR-COL2P1.       
CB4597     MOVE 'CUSTOMER NAME, SERVICE ADDRESS'  TO  HDR-COL2P2.       
CB4597     WRITE PRT321-RECORD FROM HEADER-05A AFTER 2.                 
CB4597     WRITE PRT321-RECORD FROM HEADER-06A AFTER 1.                 
CB4597     ADD 08 TO WS-LINE-COUNT.                                     
CB4597*                                                                         
CB4597 8101-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
                                                                        
CB4597 8200-PRINT-PRT32-DETAIL.                                         
CB4597******************************************************************        
CB4597*   WRITES THE REPORT DETAIL LINE FOR CFDPT32  FILE              *        
CB4597******************************************************************        
CB4597*                                                                         
CB4597     INITIALIZE DETAIL-01A.                                       
CB4597     INITIALIZE DETAIL-02.                                        
CB4597*                                                                         
CB4597     PERFORM 2100-MOVE-DETAILS-PARA THRU 2100-EXIT.               
CB4597     MOVE DTL-01A-ACCT-NO                TO  DTL-01A-COL1.        
CB4597     MOVE DTL-01A-NAME                   TO  DTL-01A-COL2.        
CB4597     WRITE PRT32-RECORD FROM DETAIL-01A AFTER 2.                  
CB4597     WRITE PRT32-RECORD FROM DETAIL-02   AFTER 1.                 
CB4597*                                                                         
CB4597     ADD 3 TO WS-LINE-COUNT.                                      
CB4597 8200-EXIT.                                                       
CB4597     EXIT.                                                        
CB4597*                                                                         
CB4597******************************************************************        
CB4597*   WRITES THE REPORT DETAIL LINE FOR CFDPT321 FILE              *        
CB4597******************************************************************        
CB4597 8201-PRINT-PRT321-DETAIL.                                        
CB4597*                                                                         
CB4597     INITIALIZE DETAIL-01A.                                       
CB4597     INITIALIZE DETAIL-02A.                                       
CB4597*                                                                         
CB4597     PERFORM 2100-MOVE-DETAILS-PARA THRU 2100-EXIT.               
CB4597     MOVE DTL-01A-READ-ROUTE             TO  DTL-01A-COL1(5:4).   
CB4597     MOVE DTL-01A-ACCT-NO                TO  DTL-01A-COL2.        
CB4597     WRITE PRT321-RECORD FROM DETAIL-01A AFTER 2.                 
CB4597     WRITE PRT321-RECORD FROM DETAIL-02A AFTER 1.                 
CB4597*                                                                         
CB4597     ADD 3 TO WS-LINE-COUNT.                                      
CB4597 8201-EXIT.                                                       
CB4597     EXIT.                                                        
                                                                        
       8500-NO-DATA-REPORT.                                             
      ******************************************************************        
      *   WHEN NO DATA EXISTS THIS PARA IS CALLED                      *        
      ******************************************************************        
      *                                                                         
T22243     PERFORM 7300-GET-COMP-NAME          THRU 7300-EXIT.          
           WRITE PRT32-RECORD FROM HEADER-01 AFTER NEW-PAGE.            
CB4597     WRITE PRT32-RECORD FROM HEADER-01A AFTER 1.                  
           WRITE PRT32-RECORD FROM WS-NO-DATA-REC AFTER 3.              
       8500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ** 6251-GET-FJC01-DATE                                         **         
      *****************************************************************         
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
HPCCDM* EJECT                                                                   
      ******************************************************************        
      *   TERMINATION ROUTINE                                          *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA65-FILE.                                          
      *                                                                         
TPR891     IF FCA65-SUCCESSFUL                                          
TPR891         NEXT SENTENCE                                            
TPR891     ELSE                                                         
TPR891         DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSCA65 FILE STATUS ==>' WS-FCA65-STATUS        
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT32-FILE.                                          
                                                                        
TPR891     IF FCA32-SUCCESSFUL                                          
TPR891         NEXT SENTENCE                                            
TPR891     ELSE                                                         
TPR891         DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSCA32 FILE STATUS ==>' WS-FCA32-STATUS        
           END-IF.                                                      
CB4597*                                                                         
CB4597     CLOSE FCSCA651-FILE.                                         
CB4597*                                                                         
CB4597     IF  FCA651-SUCCESSFUL                                        
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FILE CLOSE ERROR'                               
CB4597         DISPLAY 'FCSCA651 FILE STATUS ==>' WS-FCA651-STATUS      
CB4597     END-IF.                                                      
CB4597*                                                                         
CB4597     CLOSE FCSPT321-FILE.                                         
CB4597     IF  FCA321-SUCCESSFUL                                        
CB4597         NEXT SENTENCE                                            
CB4597     ELSE                                                         
CB4597         DISPLAY 'FILE CLOSE ERROR'                               
CB4597         DISPLAY 'FCSCA321 FILE STATUS ==>' WS-FCA321-STATUS      
CB4597     END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************    08140000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    08150000
      **************************************************************    08160000
           EXEC SQL                                                     08170000
             INCLUDE CPD09900                                           08180001
           END-EXEC.                                                    08190000
                                                                        
