       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA650.                                        
       DATE-WRITTEN.   JUL 1997.                                        
       DATE-COMPILED.                                                   
      ****************************************************************  00050000
      **                                                            **  00060000
      ********            CUSTOMER SERVICE SYSTEM             ********  00070000
      ********                      DB2                       ********  00080000
      ****************************************************************  00090000
      **              PROGRAM  MODIFICATION  LOG                    **  00100000
      **                                                            **  00110000
      **    DATE    INITIALS     REASON                             **  00120000
      **  ________  ________     _________________________________  **  00130000
T16229**                                                            **  00140000
T16229**    05/98     CBSI     UTIL-TYPE IS ALSO PASSED TO THE CALLED*  00150000
T16229**                       PROGRAM ALONG WITH OTHER DETAILS.    **  00160000
T16852**                                                            **  00170000
T16852**    07/98     CBSI     JOB PARM PROCESSING IS CHANGED. RECORD*  00180000
T16852**                       WITH SELECT QTY IS REQUIRED ONLY FOR **  00190000
T16852**                       RUN TYPE ADDITIONAL OTHERWISE 3 & 4  **  00200000
T16852**                       RECORDS ARE OPTIONAL. CODE CHANGED   **  00210000
T16852**                       FOR SAMPLE METER TESTING.            **  00220000
T19314**    03/99     CBSI     CHANGES MADE TO CREATE SERVICE ORDERS**  00230000
T19314**                       FOR EACH OF THE MTRS SELECTED FROM   **  00240000
T19314**                       THE NEW SYSTEM.                      **  00250000
T19459**    03/99     CBSI     CHANGES MADE NOT TO SELECT METERS WITH*  00260000
T19459**                       CODE-CRNT-LOC = 'X' AND CRNT-LOC-NO  **  00270000
T19459**                       8888888888 (10 8'S).                 **  00280000
T20234**    06/99     CBSI     DELETED THE CODE WHICH ACCESS THE OLD**  00290000
T20234**              MADRAS   SYSTEM TO GET THE ACCOUNT AND METER  **  00300000
T20234**                       DETAILS AND INCLUDED LOGIC TO GET    **  00310000
T20234**                       ACCOUNT NO FROM CPD00099.            **  00320000
T22268**    05/00     SREENI   CHANGES MADE TO FIX AN ABEND ON      **  00330000
T22268**                       WS-GRP-QTY-TBL(WHEN THERE ARE NO MTRS**  00340000
T22268**                       SELECTED FOR A TEST GROUP).          **  00350000
T22243**    05/00     SREENI   CHANGES MADE TO IMPLEMENT MULTI-     **  00360000
T22243**                       COMPANY IN METER INVENTORY.          **  00370000
T33287**    11/05     JC91900  CONVERT ALL COMPONENTS RELATED TO ELE**  00380000
T33287**                       SUBSYSTEM TO ELC.                    **  00390000
C33678**    01/06     DB41297  IF NO OUTPUT RECORDS, MOVE 4 TO RC   **  00400000
C33678**                       SO JCL CAN BYPASS REMAINING JOBSTEPS.**  00410000
ACT018** A04527-ACT018 DB41297 INCREASE TABLE LIMIT.                **  00411002
      **                                                            **  00400000
A05136** 31 JUL 2015  RF10596  REMOVE COMMENTED CODE                **  00400000
A05268** 04 MAR 2016  VK7L032  OUTPUT - POPULATION SAMPLE FILE      **  00400000
ACT046**                       CHANGED TO CSV FORMAT AND CHANGES    **          
      **                       DONE IN FIOMT13 COPYBOOK.            **          
ACT194** 22 JUN 2016  TP7R341  HARDCODED AND REMOVED WS-B           **  00400000
ACT194**  A05460                                                    **          
      ****************************************************************  00420000
           REMARKS.                                                     
                              PCSCA650 NARRATIVE                        
                       SELECT ELECTRIC METERS FOR SAMPLE TESTING        
      *                                                                 00460000
                 THIS PROGRAM SELECTS ELECTRIC METERS FOR SAMPLE        
                 TESTING. WHEN A METER IS SELECTED,LAST_TEST_SEL_CD     
                 AND LAST_TEST_SEL_DT ON CSS_ELEC_METER WILL BE         
                 POPULATED.A JOB PARM CAN BE USED TO RUN THE PROGRAM    
                 TO ONLY COUNT THE INSTALLED METERS, DETERMINE THE      
                 SAMPLE SIZE, AND CREATE THE OUTPUT FILE FOR            
                 PCSMT506, BUT TO NOT SELECT THE METERS OR UPDATE       
                 THE POPULATION AND SAMPLE SIZE INFORMATION ON          
                 CSS_MTR_TEST_HIST.                                     
                                                                        
      *                                                                 00570000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                 00690000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00710000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00740000
           SELECT POPULATION-SAMPLE-FILE ASSIGN TO FCSMT13              
                        STATUS IS WS-SAMPFIL-STATUS.                    
           SELECT METER-DETAIL-FILE      ASSIGN TO FIOCA65              
                        STATUS IS WS-METFIL-STATUS.                     
           SELECT UNSORTED-RANDOM-FILE   ASSIGN TO UNSORTED             
                        STATUS IS WS-UNSORTEDFIL-STATUS.                
           SELECT SORTED-RANDOM-FILE     ASSIGN TO SORTED               
                        STATUS IS WS-SORTEDFIL-STATUS.                  
           SELECT RANDOM-NBR-FILE        ASSIGN TO RANDOMFL             
                        STATUS IS WS-RANDOMFIL-STATUS.                  
           SELECT SORT-FILE              ASSIGN TO TEMP.                
T16852*                                                                 00860000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  POPULATION-SAMPLE-FILE                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
A05268 01  POP-SAMPLE-REC              PIC X(208).                      
      *                                                                 00960000
       FD  METER-DETAIL-FILE                                            
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
T16229 01  METER-DETAIL-REC            PIC X(233).                      
      *                                                                 01040000
       FD  UNSORTED-RANDOM-FILE                                         
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  UNSORTED-RANDOM-REC.                                         
           05 UNSORTED-RANDOM-NBR      PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                 01120000
       FD  SORTED-RANDOM-FILE                                           
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  SORTED-RANDOM-REC.                                           
           05 WS-RANDOM-NBR            PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                 01200000
       FD  RANDOM-NBR-FILE                                              
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  RANDOM-NUMBER-REC.                                           
           05 RANDOM-NBR               PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                 01280000
       SD  SORT-FILE.                                                   
       01  SORT-REC.                                                    
           05 S-RANDOM-NBR             PIC 9(07).                       
           05 FILLER                   PIC X(73).                       
      *                                                                 01330000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA650'.
MSQ017     COPY MFASQLM.
      *                                                                 01350000
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA650 STARTS HERE'.                  
      *                                                                 01380000
       01  PROGRAM-NAME                PIC X(08)    VALUE 'PCSCA650'.   
      *                                                                 01400000
       COPY CWS09900.                                                   01420000
      *COPYBOOK HAVING NOT-FOUND                                        01430000
       COPY CWS00303.                                                   01440000
      *ABEND WORK AREA                                                  01450000
       COPY CWS00010.                                                   01460000
      *COPYBOOK USED BY CPD00074                                        01470000
       COPY CWS00074.                                                   01480000
       COPY FIOMT13.                                                    01490000
       COPY FIOCA65.                                                    01500000
       COPY FIOJC01.                                                    01510000
                                                                        
      *COPYBOOK FOR 6010-REDUCE-EMBEDDED-SPACES                         01530000
       COPY CWS00011.                                                   01540000
T20234******************************************************************01550000
T20234* WORKING STORAGE FOR CPD00099                                   *01560000
T20234******************************************************************01570000
T20234     EXEC SQL                                                     01580000
T20234         INCLUDE CWS00099                                         01590000
T20234     END-EXEC.                                                    01600000
T20234*                                                                 01610000
                                                                        
T33287 COPY ELCHSAMP.                                                   01640000
      *                                                                 01650000
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-RC           PIC -ZZZZZZZZ9.9.                
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA650'.   
           05  WS-MIN-NUMBER           PIC 9(08)    VALUE 0.            
           05  WS-MAX-NUMBER           PIC 9(08)    VALUE 250.          
           05  WS-RANDOM-NUMBERS       PIC 9(08)    VALUE 0.            
           05  WS-FETCH-ALL-MTRS       PIC 9(08)    VALUE 0.            
           05  WS-NBR-OF-FETCHES       PIC 9(08)    VALUE 0.            
           05  WS-METER-NUM-INDEX      PIC 9(08)    VALUE 0.            
           05  WS-NBR-RANDOM-NBRS      PIC 9(09)    VALUE 0.            
           05  WS-METER-SEQ            PIC 9(08)    VALUE 0.            
           05  WS-RANDOM-INDEX         PIC 9(08)    VALUE 0.            
COB305     05 WS-TEMP        PIC 9(15) COMP-3 VALUE 0.                
           05  WS-SUB                  PIC 9(04)    VALUE 0.            
           05  RS-RETURN-CODE          PIC S9(04)   COMP.               
           05  WS-INITIAL-SEED-JUSTIFIED                                
                                       PIC X(10) JUSTIFIED RIGHT.       
           05  WS-PARM-TEST-YEAR       PIC 9(04).                       
           05  WS-PARM-RUN-TYPE        PIC X(10).                       
           05  WS-PARM-TEST-GRP        OCCURS 50 TIMES.                 
               10 WS-PARM-TEST-GRP-3      PIC X(02).                    
           05  WS-PARM-SEL-QTY         OCCURS 50 TIMES.                 
               10 WS-PARM-SELECT-QTY      PIC 9(04).                    
           05  WS-PARM-TEST-GRP-4      PIC X(02).                       
           05  WS-PARM-INITIAL-SEED    PIC X(10).                       
           05  WS-RUN-TYPE-GIVEN       PIC X(01) VALUE 'Y'.             
           05  WS-DATE-LAST-TESTED-NULLIND                              
                                       PIC S9(04) COMP VALUE -1.        
           05  WS-SELECTED-QT          PIC S9(9) USAGE COMP.            
           05  WS-CALL-SCSCA657        PIC X(01) VALUE 'N'.             
           05  WS-QUANTITY             PIC 9(9)V9.                      
           05  WS-QUANTITY-R REDEFINES WS-QUANTITY.                     
               10  WS-INTEGER-PART     PIC 9(09).                       
               10  WS-DECIMAL-PART     PIC 9(01).                       
T16852     05  WS-MTR-NO               PIC X(09).                       
T16852     05  WS-ST-POS               PIC 9(01).                       
T16852     05  WS-ST-LEN               PIC 9(01).                       
T16852     05  WS-LOCAL-OFFICE.                                         
T16852         10  FILLER              PIC X(01) VALUE '0'.             
T16852         10  WS-LOC-OFF          PIC X(02) VALUE SPACES.          
T16852     05  WS-CONSTANT             PIC 9(03).                       
T16852     05  WS-SAVE-MTR-NO          PIC X(09).                       
      *                                                                 02080000
           05  COUNTERS.                                                
               10  WS-COUNT-MTR-TEST-GRP                                
                                       PIC 9(7)     VALUE 0.            
               10  WS-COUNT-RANDOM-METERS                               
                                       PIC 9(7)     VALUE 0.            
               10  WS-COUNT-FETCH-ALL-MTRS                              
                                       PIC 9(7)     VALUE 0.            
               10  WS-COUNT-UPD-ELEC-MTR                                
                                       PIC 9(7)     VALUE 0.            
               10  WS-TOT-TEST-GROUPS                                   
                                       PIC S9(7)    VALUE +1.           
               10  WS-COUNT            PIC S9(7)    VALUE +0.           
               10  WS-COUNT-1          PIC S9(7)    VALUE +0.           
               10  WS-CTR-I            PIC S9(7)    VALUE +0.           
               10  WS-CTR-J            PIC S9(7)    VALUE +1.           
               10  WS-CTR-K            PIC S9(7)    VALUE +0.           
               10  WS-INSPECT-CNTR     PIC 99       VALUE  0.           
               10  WS-SO-INDEX         PIC S9(7)    VALUE +0.           
               10  WS-END-OF-FILE      PIC X(01)    VALUE SPACES.       
               10  WS-WRITE-CNT        PIC S9(7) COMP-3 VALUE +0.       
               10  WS-WRITE-FORMAT     PIC Z(6)9.                       
COB305     05 WS-TEMP-VOLTAGE        PIC 9(5) COMP-3 VALUE 0.
COB305         88  VALID-VOLTAGE                    VALUES              
COB305                                              120, 240, 277, 480. 
           05  WS-SWITCHES.                                             
               10  WS-EOF-FLAG         PIC X(01)    VALUE 'N'.          
                   88  END-OF-FILE                  VALUE 'Y'.          
               10  WS-IS-INPUT-VALID   PIC X(01)    VALUE 'Y'.          
                   88  INPUT-IS-VALID               VALUE 'Y'.          
                   88  INPUT-IS-INVALID             VALUE 'N'.          
               10  WS-FOUND            PIC X(01)    VALUE 'N'.          
                   88  FOUND                        VALUE 'Y'.          
               10  WS-END-MTR-TEST-GRP PIC X(01)    VALUE 'N'.          
                   88  END-MTR-TEST-GRP             VALUE 'Y'.          
               10  WS-END-SAMPLE-METER-REC PIC X(01) VALUE 'N'.         
                   88  END-SAMPLE-METER-REC          VALUE 'Y'.         
               10  WS-NO-REC-FOUND         PIC X(01) VALUE 'N'.         
                   88  NO-REC-FOUND                  VALUE 'Y'.         
               10  WS-VALID-RANDOM-NBR     PIC X(01) VALUE 'Y'.         
                   88  VALID-RANDOM-NBR              VALUE 'N'.         
               10  WS-INVALID-RANDOM-NBR   PIC X(01) VALUE 'N'.         
                   88  INVALID-RANDOM-NBR            VALUE 'Y'.         
               10  WS-EXIT-LOOP            PIC X(01) VALUE 'N'.         
                   88  EXIT-LOOP                     VALUE 'Y'.         
               10  WS-MAX-RAN-NUM-REACHED  PIC X(01) VALUE 'N'.         
                   88  MAX-RAN-NUM-REACHED           VALUE 'Y'.         
               10  WS-SAMPFIL-STATUS       PIC X(02) VALUE '00'.        
                   88  SAMPFIL-SUCCESS               VALUE '00'.        
               10  WS-METFIL-STATUS        PIC X(02) VALUE '00'.        
                   88  METFIL-SUCCESS                VALUE '00'.        
               10  WS-UNSORTEDFIL-STATUS   PIC X(02) VALUE '00'.        
                   88  UNSORTFIL-SUCCESS             VALUE '00'.        
               10  WS-SORTEDFIL-STATUS     PIC X(02) VALUE '00'.        
                   88  SORTFIL-SUCCESS               VALUE '00'.        
               10  WS-RANDOMFIL-STATUS     PIC X(02) VALUE '00'.        
                   88  RANDOMFIL-SUCCESS             VALUE '00'.        
T16852         10  WS-SAMPLE-SIZE-FOUND    PIC X(01) VALUE 'N'.         
T16852             88  SAMPLE-SIZE-FOUND             VALUE 'Y'.         
T22268         10  WS-GRP-CD-FOUND         PIC X(01) VALUE 'N'.         
T22268             88  GRP-CD-FOUND                  VALUE 'Y'.         
T16852     05  WS-SAMPLE-MIN-QT        PIC S9(9) USAGE COMP.            
T22243     05  WS-SYSIN-COMP-NO        PIC X(02) VALUE SPACES.          
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-JOB-PARM-2           PIC X(01)    VALUE 'N'.          
           05  WS-JOB-PARM-3           PIC X(01)    VALUE 'N'.          
           05  WS-JOB-PARM-4           PIC X(01)    VALUE 'N'.          
           05  WS-CURRENT-INSTALLED-QTY                                 
                                       PIC S9(09)   USAGE COMP          
                                       VALUE ZEROES.                    
           05  WS-POPULATION-SIZE      PIC 9(4)     VALUE ZEROES.       
           05  WS-SYS-DATE.                                             
               10  WS-SYS-DATE-YY      PIC 9(02).                       
               10  WS-SYS-DATE-MM      PIC 9(02).                       
               10  WS-SYS-DATE-DD      PIC 9(02).                       
           05  WS-DB2-TODAYS-DATE      PIC X(10).                       
           05  WS-SYS-TIME.                                             
               10  WS-SYS-TIME-HR      PIC 9(02).                       
               10  WS-SYS-TIME-MIN     PIC 9(02).                       
               10  WS-SYS-TIME-SEC     PIC 9(02).                       
               10  WS-SYS-TIME-HSEC    PIC 9(02).                       
           05  WS-CRNT-DATE-BREAKDOWN.                                  
               10  WS-CRNT-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-DD          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CRNT-YY          PIC 9(02).                       
           05  WS-DB2-DATE.                                             
               10  WS-DB2-YEAR .                                        
                   15  WS-DB2-CC       PIC 9(02).                       
                   15  WS-DB2-YY       PIC 9(02).                       
               10  FILLER REDEFINES WS-DB2-YEAR.                        
                   15  WS-DB2-YEARS        PIC S9(04) COMP.             
               10  FILLER              PIC X.                           
               10  WS-DB2-MM           PIC X(2).                        
               10  FILLER              PIC X.                           
               10  WS-DB2-DD           PIC X(2).                        
           05  WS-RANDOM-NUM-VARIABLES.                                 
COB305         10 ISEC        PIC 9(15) COMP-3 VALUE 0.                
COB305         10 IMIN        PIC 9(15) COMP-3 VALUE 0.                
COB305         10 IHR        PIC 9(15) COMP-3 VALUE 0.                
COB305         10 IDAY        PIC 9(15) COMP-3 VALUE 0.                
COB305         10 IMON        PIC 9(15) COMP-3 VALUE 0.                
COB305         10 IYR        PIC 9(15) COMP-3 VALUE 0.                
               10  WS-1                PIC 9(15) COMP-3   VALUE 1.      
               10  WS-12               PIC 9(15) COMP-3   VALUE 12.     
               10  WS-24               PIC 9(15) COMP-3   VALUE 24.     
               10  WS-31               PIC 9(15) COMP-3   VALUE 31.     
               10  WS-60               PIC 9(15) COMP-3   VALUE 60.     
COB305         10 WS-RANDOM-SEED        PIC 9(15) COMP-3 VALUE 0.               
               10  WS-RANDOM-M         PIC 9(15) COMP-3                 
                                       VALUE 2147483647.                
               10  WS-RANDOM-A         PIC 9(15) COMP-3 VALUE 16807.    
COB305         10 WS-RANDOM-X        PIC 9(15) COMP-3 VALUE 0.                
               10  WS-RANDOM-R         COMP-2.                          
COB305         10 WS-RANDOM-NBR-TEST        PIC 9(07) COMP-3 VALUE 0.           
               10  WS-MAX-RANDOM-NBR   PIC 9(3)  COMP-3 VALUE 250.      
               10  WS-REMAINDER        PIC S9(3)V99  COMP-3  VALUE +0.  
               10  WS-DIV-REMAINDER    PIC S9(3)V99  COMP-3  VALUE +0.  
               10  WS-REM-RANDOM       PIC 9(15)    VALUE 0.            
               10  WS-DIV-RANDOM       PIC 9(15)    VALUE 0.            
               10  WS-LIMIT            PIC 9(3)        VALUE 0.         
      *                                                                 03300000
       01  WS-RANDOM-NBR-TABLE.                                         
COB305     05 WS-RANDOM-NBR-ARRAY        PIC 9(07) COMP-3 OCCURS          
COB305                                                  250 TIMES 
COB305       VALUE 0.      
      *                                                                 03340000
       01  WS-SCSCA657-LINKAGE.                                         
T16229     05  WS-SO-UTIL-TYPE         PIC X(01).                       
COB305     05 WS-NBR-METERS        PIC S9(3) COMP-3 VALUE 0.             
           05  WS-SO-DATE              PIC X(10).                       
ACT018     05  WS-SCSCA657-ARRAY       OCCURS  110 TIMES.               
COB305         10 WS-SO-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.             
               10  WS-SO-METER-NO      PIC X(9).                        
               10  WS-SO-TEST-TYPE     PIC X(1).                        
      *                                                                 03430000
       01  WS-LITERALS.                                                 
           05  WS-ONE                  PIC 9(01)    VALUE 1.            
           05  WS-TWO                  PIC 9(01)    VALUE 2.            
           05  WS-THREE                PIC 9(01)    VALUE 3.            
           05  WS-FOUR                 PIC 9(01)    VALUE 4.            
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-F                    PIC X(01)    VALUE 'F'.          
           05  WS-I                    PIC X(01)    VALUE 'I'.          
T16852     05  WS-K                    PIC X(01)    VALUE 'K'.          
T16852     05  WS-M                    PIC X(01)    VALUE 'M'.          
           05  WS-R                    PIC X(01)    VALUE 'R'.          
           05  WS-S                    PIC X(01)    VALUE 'S'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-YES                  PIC X(03)    VALUE 'YES'.        
           05  WS-NO                   PIC X(03)    VALUE 'NO '.        
T22243     05  WS-01                   PIC X(02)    VALUE '01'.         
           05  WS-UNKNOWN              PIC X(08)    VALUE 'UNKNOWN '.   
           05  WS-SELECT               PIC X(10)    VALUE 'SELECT'.     
           05  WS-FORECAST             PIC X(10)    VALUE 'FORECAST'.   
           05  WS-ADDITIONAL           PIC X(10)    VALUE 'ADDITIONAL'. 
           05  WS-ACTIVE               PIC X(01)    VALUE 'A'.          
           05  WS-ZEROES               PIC X(03)    VALUE '000'.        
           05  WS-CURRENT-CENTURY      PIC 9(02)    VALUE  19.          
           05  WS-NEXT-CENTURY         PIC 9(02)    VALUE  20.          
           05  WS-TEST-YEAR            PIC X(12)                        
                                       VALUE  'TEST YEAR = '.           
           05  WS-RUN-TYPE             PIC X(11)                        
                                       VALUE  'RUN TYPE = '.            
           05  WS-TEST-GROUP           PIC X(13)                        
                                       VALUE  'TEST GROUP = '.          
           05  WS-SELECT-QTY           PIC X(13)                        
                                       VALUE  'SELECT QTY = '.          
           05  WS-INITIAL-SEED         PIC X(15)                        
                                       VALUE  'INITIAL SEED = '.        
      *                                                                 03810000
       01  WS-NO-ERROR-LINE.                                            
           05                          PIC X(30)    VALUE               
           'PCSCA650  NO ERRORS WERE FOUND'.                            
           05                          PIC X(50)    VALUE SPACES.       
      *                                                                 03860000
       COPY CWS00038.                                                   03870000
       01 WS-PARAMETER-DATA REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05  WS-PARAMETER-REC-1.                                       
              10  WS-TEST-YEAR-TEXT    PIC X(12).                       
              10  WS-TEST-YEAR-VALUE-C PIC X(04).                       
              10  FILLER  REDEFINES WS-TEST-YEAR-VALUE-C.               
                  15 WS-TEST-YEAR-VALUE                                 
                                       PIC 9(04).                       
              10  FILLER               PIC X(64).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-2.                                       
              10  WS-RUN-TYPE-TEXT     PIC X(11).                       
              10  WS-RUN-TYPE-VALUE    PIC X(10).                       
                  88  RUN-TYPE-SELECT            VALUE 'SELECT'.        
                  88  RUN-TYPE-FORECAST          VALUE 'FORECAST'.      
                  88  RUN-TYPE-ADDITIONAL        VALUE 'ADDITIONAL'.    
              10  FILLER               PIC X(59).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-3.                                       
              10 WS-TEST-GROUP-3-TEXT  PIC X(13).                       
              10 WS-TEST-GROUP-VALUE-3 PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-SELECT-QTY-TEXT    PIC X(13).                       
              10 WS-SELECT-QTY-VALUE   PIC 9(04).                       
              10 FILLER                PIC X(47).                       
       01 FILLER REDEFINES WS-PARAMETER-DATA.                           
          05  WS-PARAMETER-REC-4.                                       
              10 WS-TEST-GROUP-4-TEXT  PIC X(13).                       
              10 WS-TEST-GROUP-VALUE-4 PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-INITIAL-SEED-TEXT  PIC X(15).                       
              10 WS-INITIAL-SEED-VALUE PIC X(10).                       
              10 FILLER                PIC X(40).                       
      *                                                                 04200000
       01 METER-TABLE.                                                  
          05  WS-METER-NUMBER PIC X(09)  OCCURS   250 TIMES.            
                                                                        
T16852 01 WS-INSTALLED-QTY-TBL.                                         
T16852    05  WS-GRP-QTY-TBL OCCURS 75 TIMES.                           
T16852        10  WS-TEST-GRP-CD           PIC X(02).                   
T16852        10  WS-INSTALLED-QTY         PIC 9(08).                   
      *                                                                 04280000
       01 WS-FIOMT13-REC.                                               
          05  FILLER          PIC X(09)  VALUE 'TEST YEAR'.             
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(08)  VALUE 'TYPE RUN'.              
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(17)  VALUE 'METER TEST GRP CD'.     
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(19)  VALUE 'METER TEST GRP DESC'.   
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(22)  VALUE 'SAMPLE OVERAGE PERCENT'.
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(25)                                 
                              VALUE 'SAMPLE CORRECTIVE PERCENT'.        
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(20)  VALUE 'INSTALLED POPULATION'.  
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(23)                                 
                              VALUE 'MINIMUM SAMPLE QUANTITY'.          
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(28)                                 
                              VALUE 'ADDITIONAL QUANTITY SELECTED'.     
          05  FILLER          PIC X(01)  VALUE ','.                     
          05  FILLER          PIC X(28)                                 
                              VALUE 'TOTAL SELECTED TEST QUANTITY'.     
      ****************************************************************  04290000
      **     INCLUDE DCLGEN TABLE AND HOST VARIABLE DEFINITIONS     **  04300000
      ****************************************************************  04310000
      *                                                                 04320000
           EXEC SQL                                                     04330000
               INCLUDE SQLCA                                            04340000
           END-EXEC.                                                    04350000
      ****************************************************************  04360000
      *    COPYBOOK FOR CSS_ELEC_METER, PREFIX - EM                  *  04370000
      ****************************************************************  04380000
           EXEC SQL                                                     04390000
               INCLUDE TBELMTR                                          04400000
           END-EXEC.                                                    04410000
      ****************************************************************  04420000
      *    COPYBOOK FOR CSS_EQUIPMENT,  PREFIX - EQ                  *  04430000
      ****************************************************************  04440000
           EXEC SQL                                                     04450000
               INCLUDE TBEQUIP                                          04460000
           END-EXEC.                                                    04470000
      ****************************************************************  04480000
      *    COPYBOOK FOR CSS_ELEC_TST_GROUP, PREFIX - TG              *  04490000
      ****************************************************************  04500000
           EXEC SQL                                                     04510000
               INCLUDE TBELGRP                                          04520000
           END-EXEC.                                                    04530000
      ****************************************************************  04540000
      *    COPYBOOK FOR CSS_MTR_TEST_HIST , PREFIX - MQ              *  04550000
      ****************************************************************  04560000
           EXEC SQL                                                     04570000
               INCLUDE TBMTRTST                                         04580000
           END-EXEC.                                                    04590000
      ****************************************************************  04600000
      *    COPYBOOK FOR CSS_MTR_TEST_GROUP, PREFIX - GR              *  04610000
      ****************************************************************  04620000
           EXEC SQL                                                     04630000
               INCLUDE TBMTRGP                                          04640000
           END-EXEC.                                                    04650000
      ****************************************************************  04660000
      *    COPYBOOK FOR CSS_JOB_PARM,       PREFIX - G6              *  04670000
      ****************************************************************  04680000
           EXEC SQL                                                     04690000
               INCLUDE TBJBPARM                                         04700000
           END-EXEC.                                                    04710000
      ****************************************************************  04720000
      *    COPYBOOK FOR CSS_ACCOUNT,        PREFIX - AT              *  04730000
      ****************************************************************  04740000
           EXEC SQL                                                     04750000
               INCLUDE TBACCT                                           04760000
           END-EXEC.                                                    04770000
      ****************************************************************  04780000
      *    COPYBOOK FOR CSS_UTIL_ENVRNMT,   PREFIX - UT              *  04790000
      ****************************************************************  04800000
           EXEC SQL                                                     04810000
               INCLUDE TBUTLENV                                         04820000
           END-EXEC.                                                    04830000
      ****************************************************************  04840000
      *    COPYBOOK FOR CSS_MTRD_ENVRNMT,   PREFIX - MN              *  04850000
      ****************************************************************  04860000
           EXEC SQL                                                     04870000
               INCLUDE TBMTRENV                                         04880000
           END-EXEC.                                                    04890000
      ****************************************************************  04900000
      *    COPYBOOK FOR CSS_MTR_CAP,        PREFIX - MC              *  04910000
      ****************************************************************  04920000
           EXEC SQL                                                     04930000
               INCLUDE TBMTRCAP                                         04940000
           END-EXEC.                                                    04950000
      *                                                                 04960000
T16852****************************************************************  04970000
ST    *    COPYBOOK FOR CSS_METER_ATTCHMTS, PREFIX - MA              *  04980000
      ****************************************************************  04990000
           EXEC SQL                                                     05000000
               INCLUDE TBMTRATT                                         05010000
END        END-EXEC.                                                    05020000
T16852*                                                                 05030000
      *****TABLES REQUIRED FOR 4000-MAIL-NAME-ADDRESS                   05040000
      ****************************************************************  05050000
      *    COPYBOOK FOR CSS_NAME,           PREFIX - DQ              *  05060000
      ****************************************************************  05070000
           EXEC SQL                                                     05080000
               INCLUDE TBNAME                                           05090000
           END-EXEC.                                                    05100000
      ****************************************************************  05110000
      *    COPYBOOK FOR CSS_NAME_ACCT_XREF, PREFIX - HT              *  05120000
      ****************************************************************  05130000
           EXEC SQL                                                     05140000
               INCLUDE TBNMACTX                                         05150000
           END-EXEC.                                                    05160000
      ****************************************************************  05170000
      *    COPYBOOK FOR CSS_CUST_ADDR_XREF, PREFIX - DM              *  05180000
      ****************************************************************  05190000
           EXEC SQL                                                     05200000
               INCLUDE TBCSADRX                                         05210000
           END-EXEC.                                                    05220000
      ****************************************************************  05230000
      *    COPYBOOK FOR  CSS_ADDR_FREEFORM, PREFIX - DZ              *  05240000
      ****************************************************************  05250000
           EXEC SQL                                                     05260000
               INCLUDE TBADRFRE                                         05270000
           END-EXEC.                                                    05280000
      ****************************************************************  05290000
      *    COPYBOOK FOR CSS_ADDR_FORMATTED, PREFIX - DY              *  05300000
      ****************************************************************  05310000
           EXEC SQL                                                     05320000
               INCLUDE TBADRFMT                                         05330000
           END-EXEC.                                                    05340000
      ****************************************************************  05350000
      *    COPYBOOK FOR CSS_ZIP_CODE,       PREFIX - A4              *  05360000
      ****************************************************************  05370000
           EXEC SQL                                                     05380000
               INCLUDE TBZIPCD                                          05390000
           END-EXEC.                                                    05400000
      ****************************************************************  05410000
      *    COPYBOOK FOR CSS_ACCT_MISC_INFO, PREFIX - TA              *  05420000
      ****************************************************************  05430000
           EXEC SQL                                                     05440000
               INCLUDE TBATMISC                                         05450000
           END-EXEC.                                                    05460000
      *                                                                 05470000
      ***  END OF DCLGEN TABLE AND HOST VARIABLE DEFINITIONS            05480000
      *                                                                 05490000
      ***  SQL DECLARE STATEMENTS                                       05500000
      *                                                                 05510000
      ****************************************************************  05520000
      **            CURSOR TO SELECT METERS FOR A TEST GROUP        **  05530000
      ****************************************************************  05540000
      *                                                                 05550000
           EXEC SQL                                                     
               DECLARE METER-EQUIP-TEST CURSOR FOR                      
               SELECT EM.METER_NO         ,                             
                      EM.TEST_SCHED_CD    ,                             
                      EM.METER_SIZE_ID    ,                             
                      EM.DATE_LAST_TESTED ,                             
                      EM.ELEC_MTR_CLASS_CD,                             
                      EM.ELEC_MTR_SPEC_CD ,                             
                      EM.METER_SIZE_ID    ,                             
                      EQ.COMPANY_NO       ,                             
T16852                EQ.CODE_CRNT_LOC    ,                             
T16852                EQ.CRNT_LOC_NO      ,                             
                      EQ.CODE_MAKE        ,                             
                      EQ.LOCAL_OFFICE                                   
                 FROM CSS_ELEC_METER     EM,                            
                      CSS_EQUIPMENT      EQ,                            
                      CSS_ELEC_TST_GROUP TG                             
                WHERE TG.CODE_UTIL_TYPE    = :MQ-CODE-UTIL-TYPE         
                AND   TG.MTR_TEST_GRP_CD   = :MQ-MTR-TEST-GRP-CD        
T16852          AND   EQ.CODE_CRNT_LOC    IN ('J', 'K')                 
                AND   EM.METER_NO          = EQ.DEVICE_NO               
                AND   EM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          
                AND   EM.CODE_UTIL_TYPE    = TG.CODE_UTIL_TYPE          
                AND   EM.ELEC_MTR_SPEC_CD  = TG.ELEC_MTR_SPEC_CD        
T16852          AND ( TG.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD       
T16852           OR   TG.ELEC_MTR_CLASS_CD = ' ' )                      
                AND   (EQ.DATE_PURCHASED BETWEEN                        
                                                TG.BEGIN_PURCHASE_DT    
                                         AND    TG.END_PURCHASE_DT)     
T22243          AND EQ.COMPANY_NO          = :EQ-COMPANY-NO             
T22243          AND EM.COMPANY_NO          = EQ.COMPANY_NO              
T22243          AND TG.COMPANY_NO          = EM.COMPANY_NO              
T16852          AND TEST_SCHED_CD          = 'R'                        
                AND LAST_TEST_SEL_CD       = ' '                        
T16852          ORDER BY METER_NO FOR READ ONLY                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     05560000
MFA-TR*        DECLARE METER-EQUIP-TEST CURSOR FOR                      05570000
MFA-TR*        SELECT EM.METER_NO         ,                             05580000
MFA-TR*               EM.TEST_SCHED_CD    ,                             05590000
MFA-TR*               EM.METER_SIZE_ID    ,                             05600000
MFA-TR*               EM.DATE_LAST_TESTED ,                             05610000
MFA-TR*               EM.ELEC_MTR_CLASS_CD,                             05620000
MFA-TR*               EM.ELEC_MTR_SPEC_CD ,                             05630000
MFA-TR*               EM.METER_SIZE_ID    ,                             05640000
MFA-TR*               EQ.COMPANY_NO       ,                             05650000
MFA-TR*               EQ.CODE_CRNT_LOC    ,                             05660000
MFA-TR*               EQ.CRNT_LOC_NO      ,                             05670000
MFA-TR*               EQ.CODE_MAKE        ,                             05680000
MFA-TR*               EQ.LOCAL_OFFICE                                   05690000
MFA-TR*          FROM CSS_ELEC_METER     EM,                            05700000
MFA-TR*               CSS_EQUIPMENT      EQ,                            05710000
MFA-TR*               CSS_ELEC_TST_GROUP TG                             05720000
MFA-TR*         WHERE TG.CODE_UTIL_TYPE    = :MQ-CODE-UTIL-TYPE         05730000
MFA-TR*         AND   TG.MTR_TEST_GRP_CD   = :MQ-MTR-TEST-GRP-CD        05740000
MFA-TR*         AND   EQ.CODE_CRNT_LOC    IN ('J', 'K')                 05750000
MFA-TR*         AND   EM.METER_NO          = EQ.DEVICE_NO               05760000
MFA-TR*         AND   EM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          05770000
MFA-TR*         AND   EM.CODE_UTIL_TYPE    = TG.CODE_UTIL_TYPE          05780000
MFA-TR*         AND   EM.ELEC_MTR_SPEC_CD  = TG.ELEC_MTR_SPEC_CD        05790000
MFA-TR*         AND ( TG.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD       05800000
MFA-TR*          OR   TG.ELEC_MTR_CLASS_CD = ' ' )                      05810000
MFA-TR*         AND   (EQ.DATE_PURCHASED BETWEEN                        05820000
MFA-TR*                                         TG.BEGIN_PURCHASE_DT    05830000
MFA-TR*                                  AND    TG.END_PURCHASE_DT)     05840000
MFA-TR*         AND EQ.COMPANY_NO          = :EQ-COMPANY-NO             05850000
MFA-TR*         AND EM.COMPANY_NO          = EQ.COMPANY_NO              05860000
MFA-TR*         AND TG.COMPANY_NO          = EM.COMPANY_NO              05870000
MFA-TR*         AND TEST_SCHED_CD          = 'R'                        05880000
MFA-TR*         AND LAST_TEST_SEL_CD       = ' '                        05890000
MFA-TR*         ORDER BY METER_NO FOR FETCH ONLY                        05900000
MFA-TR*    END-EXEC.                                                    05910000
      *                                                                 05920000
      ****************************************************************  05930000
      **           CURSOR TO SELECT METER TEST HISTORY              **  05940000
      ****************************************************************  05950000
      *                                                                 05960000
           EXEC SQL                                                     
               DECLARE SAMPLE-TEST-HIST CURSOR FOR                      
               SELECT MTR_TEST_GRP_CD    ,                              
                      CODE_UTIL_TYPE     ,                              
                      SAMPLE_MIN_QT      ,                              
                      SAMPL_OVERAGE_PCT  ,                              
                      SAMPL_CORRECTV_PCT ,                              
                      SAMPL_ADDITIONL_QT ,                              
C31091                MTR_TEST_GRP_TX                                   
               FROM   CSS_MTR_TEST_HIST                                 
               WHERE  CODE_UTIL_TYPE     =  :WS-E                       
               AND    TEST_YEAR          =  :MQ-TEST-YEAR               
               AND    TEST_SCHED_CD      =  :WS-R                       
T22243         AND    COMPANY_NO         =  :MQ-COMPANY-NO              
               AND    LAST_TEST_SEL_DT   IS NULL                        
T16852         ORDER  BY MTR_TEST_GRP_CD FOR READ ONLY                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     05970000
MFA-TR*        DECLARE SAMPLE-TEST-HIST CURSOR FOR                      05980000
MFA-TR*        SELECT MTR_TEST_GRP_CD    ,                              05990000
MFA-TR*               CODE_UTIL_TYPE     ,                              06000000
MFA-TR*               SAMPLE_MIN_QT      ,                              06010000
MFA-TR*               SAMPL_OVERAGE_PCT  ,                              06020000
MFA-TR*               SAMPL_CORRECTV_PCT ,                              06030000
MFA-TR*               SAMPL_ADDITIONL_QT ,                              06040000
MFA-TR*               MTR_TEST_GRP_TX                                   06050000
MFA-TR*        FROM   CSS_MTR_TEST_HIST                                 06060000
MFA-TR*        WHERE  CODE_UTIL_TYPE     =  :WS-E                       06070000
MFA-TR*        AND    TEST_YEAR          =  :MQ-TEST-YEAR               06080000
MFA-TR*        AND    TEST_SCHED_CD      =  :WS-R                       06090000
MFA-TR*        AND    COMPANY_NO         =  :MQ-COMPANY-NO              06100000
MFA-TR*        AND    LAST_TEST_SEL_DT   IS NULL                        06110000
MFA-TR*        ORDER  BY MTR_TEST_GRP_CD FOR FETCH ONLY                 06120000
MFA-TR*    END-EXEC.                                                    06130000
      *                                                                 06140000
      ****************************************************************  06150000
      **           CURSOR FOR RANDOM SELECTION OF METERS            **  06160000
      ****************************************************************  06170000
      *                                                                 06180000
           EXEC SQL                                                     
               DECLARE SAMPLE-SELECT CURSOR FOR                         
               SELECT EM.METER_NO                                       
T16852               ,EQ.CODE_CRNT_LOC                                  
T16852               ,EQ.CRNT_LOC_NO                                    
               FROM   CSS_ELEC_METER  EM,                               
                      CSS_EQUIPMENT   EQ,                               
                      CSS_ELEC_TST_GROUP TG                             
               WHERE  TG.CODE_UTIL_TYPE   =  :MQ-CODE-UTIL-TYPE         
               AND    TG.MTR_TEST_GRP_CD  =  :MQ-MTR-TEST-GRP-CD        
T19459         AND    EQ.CODE_CRNT_LOC    IN ('J', 'K')                 
               AND EM.METER_NO            =  EQ.DEVICE_NO               
               AND EM.CODE_UTIL_TYPE      = EQ.CODE_UTIL_TYPE           
T16852         AND EQ.CODE_UTIL_TYPE      = TG.CODE_UTIL_TYPE           
               AND EM.ELEC_MTR_SPEC_CD    = TG.ELEC_MTR_SPEC_CD         
T16852         AND ( TG.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD        
T16852          OR   TG.ELEC_MTR_CLASS_CD = ' ' )                       
T16852         AND TEST_SCHED_CD          = 'R'                         
               AND EM.LAST_TEST_SEL_CD    = ' '                         
               AND (EQ.DATE_PURCHASED BETWEEN TG.BEGIN_PURCHASE_DT      
                          AND TG.END_PURCHASE_DT)                       
T22243         AND EQ.COMPANY_NO          = :EQ-COMPANY-NO              
T22243         AND EM.COMPANY_NO          =  EQ.COMPANY_NO              
T22243         AND TG.COMPANY_NO          =  EM.COMPANY_NO              
           END-EXEC.                                                    
      *                                                                 06440000
      ****************************************************************  06450000
      ** CURSOR TO UPDATE CSS_JOB_PARM                               *  06460000
      ****************************************************************  06470000
      *                                                                 06480000
           EXEC SQL                                                     
               DECLARE JOB-PARM      CURSOR FOR                         
               SELECT STATUS                                            
               FROM CSS_JOB_PARM                                        
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
               AND   COMPANY_NO   = :G6-COMPANY-NO                      
               AND   CMND_CODE    = :G6-CMND-CODE                       
               FOR UPDATE OF STATUS                                     
           END-EXEC.                                                    
      *                                                                 06580000
      ****************************************************************  06590000
      ** CURSOR TO GET ACCOUNT DETAILS                               *  06600000
      ****************************************************************  06610000
      *                                                                 06620000
           EXEC SQL                                                     
               DECLARE ACCOUNT-DETAIL CURSOR FOR                        
               SELECT UT.ACCOUNT_NO    ,                                
                      UT.RATE_PLAN_NO  ,                                
                      UT.READ_ROUTE    ,                                
                      AT.CODE_ACCT_STAT,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') 
           ACCT_CREATE_DT,                                
29312                 UT.READ_CYCLE                                     
               FROM CSS_MTRD_ENVRNMT MN,                                
                    CSS_UTIL_ENVRNMT UT,                                
                    CSS_ACCOUNT      AT                                 
               WHERE MN.CODE_UTIL_TYPE    = :WS-E                       
               AND   MN.METER_NO          = :MN-METER-NO                
               AND   MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
               AND   MN.IC_NO             = UT.IC_NO                    
               AND   MN.ACCOUNT_NO        = UT.ACCOUNT_NO               
               AND   MN.ACCOUNT_NO        = AT.ACCOUNT_NO               
T20234         AND   MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
T16852         AND   AT.PREMISE_NO        = :EQ-CRNT-LOC-NO             
T22243         AND   AT.COMPANY_NO        = :AT-COMPANY-NO              
T16852          FOR READ ONLY                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06630000
MFA-TR*        DECLARE ACCOUNT-DETAIL CURSOR FOR                        06640000
MFA-TR*        SELECT UT.ACCOUNT_NO    ,                                06650000
MFA-TR*               UT.RATE_PLAN_NO  ,                                06660000
MFA-TR*               UT.READ_ROUTE    ,                                06670000
MFA-TR*               AT.CODE_ACCT_STAT,                                06680000
MFA-TR*               AT.ACCT_CREATE_DT,                                06690000
MFA-TR*               UT.READ_CYCLE                                     06700000
MFA-TR*        FROM CSS_MTRD_ENVRNMT MN,                                06710000
MFA-TR*             CSS_UTIL_ENVRNMT UT,                                06720000
MFA-TR*             CSS_ACCOUNT      AT                                 06730000
MFA-TR*        WHERE MN.CODE_UTIL_TYPE    = :WS-E                       06740000
MFA-TR*        AND   MN.METER_NO          = :MN-METER-NO                06750000
MFA-TR*        AND   MN.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           06760000
MFA-TR*        AND   MN.IC_NO             = UT.IC_NO                    06770000
MFA-TR*        AND   MN.ACCOUNT_NO        = UT.ACCOUNT_NO               06780000
MFA-TR*        AND   MN.ACCOUNT_NO        = AT.ACCOUNT_NO               06790000
MFA-TR*        AND   MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              06800000
MFA-TR*        AND   AT.PREMISE_NO        = :EQ-CRNT-LOC-NO             06810000
MFA-TR*        AND   AT.COMPANY_NO        = :AT-COMPANY-NO              06820000
MFA-TR*         FOR FETCH ONLY                                          06830000
MFA-TR*    END-EXEC.                                                    06840000
      *                                                                 06850000
T16852****************************************************************  06860000
ST    ** CURSOR TO GET POPULATION SIZE                               *  06870000
      ****************************************************************  06880000
      *                                                                 06890000
           EXEC SQL                                                     
               DECLARE GET-INSTALLED-QTY CURSOR FOR                     
               SELECT COUNT(*)                                          
                     ,MTR_TEST_GRP_CD                                   
                FROM CSS_ELEC_METER     EM                              
                    ,CSS_EQUIPMENT      EQ                              
                    ,CSS_ELEC_TST_GROUP TG                              
               WHERE  EQ.CODE_UTIL_TYPE  = :WS-E                        
                AND   EM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE             
                AND   TG.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE             
                AND   EM.METER_NO       = EQ.DEVICE_NO                  
T19459          AND   EQ.CODE_CRNT_LOC    IN ('J', 'K')                 
                AND   EM.ELEC_MTR_SPEC_CD    = TG.ELEC_MTR_SPEC_CD      
                AND ( TG.ELEC_MTR_CLASS_CD   = EM.ELEC_MTR_CLASS_CD     
                 OR   TG.ELEC_MTR_CLASS_CD   = '  ' )                   
                AND   EM.LAST_TEST_SEL_CD    = ' '                      
                AND   (EQ.DATE_PURCHASED BETWEEN TG.BEGIN_PURCHASE_DT   
                          AND TG.END_PURCHASE_DT)                       
T22243          AND   EQ.COMPANY_NO          = :EQ-COMPANY-NO           
T22243          AND   EM.COMPANY_NO          = EQ.COMPANY_NO            
T22243          AND   TG.COMPANY_NO          = EM.COMPANY_NO            
T16852          AND   TEST_SCHED_CD          = 'R'                      
                AND   LAST_TEST_SEL_CD   = ' '                          
               GROUP BY MTR_TEST_GRP_CD                                 
END            ORDER BY MTR_TEST_GRP_CD                                 
T16852     END-EXEC.                                                    
      *                                                                 07160000
       01  WS-END                      PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSCA650 ENDS HERE  '.                  
      *                                                                 07190000
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      ****************************************************************  07220000
      **                                                            **  07230000
      **  0000-MAINLINE                                             **  07240000
      **      CONTROLS MAIN PATH OF PROGRAM                         **  07250000
      **                                                            **  07260000
      ****************************************************************  07270000
       0000-MAINLINE.                                                   
      *                                                                 07290000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 07310000
           PERFORM 1000-PROCESS-INPUT-PARM       THRU 1000-EXIT         
      *                                                                 07330000
           PERFORM 5000-UPDATE-PARM              THRU 5000-EXIT         
      *                                                                 07350000
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                 07370000
           STOP RUN.                                                    
      *                                                                 07390000
       0100-INITIALIZATION.                                             
      *                                                                 07410000
           ACCEPT WS-SYS-DATE                    FROM DATE.             
      *                                                                 07430000
           ACCEPT WS-SYS-TIME                    FROM TIME.             
      *                                                                 07450000
           IF WS-SYS-DATE-YY              GREATER THAN 50               
              MOVE WS-CURRENT-CENTURY     TO WS-TEMP-CC                 
           ELSE                                                         
              MOVE WS-NEXT-CENTURY        TO WS-TEMP-CC                 
           END-IF.                                                      
      *                                                                 07510000
           STRING WS-TEMP-CC,                                           
                  WS-SYS-DATE-YY,                                       
                  '-',                                                  
                  WS-SYS-DATE-MM,                                       
                  '-',                                                  
                  WS-SYS-DATE-DD                                        
                        DELIMITED BY SIZE                               
                                    INTO WS-DB2-TODAYS-DATE             
           END-STRING.                                                  
      *                                                                 07610000
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-01              TO WS-SYSIN-COMP-NO              
T22243     END-IF.                                                      
T22243*                                                                 07660000
T22243     MOVE WS-SYSIN-COMP-NO       TO EQ-COMPANY-NO                 
T22243                                    EM-COMPANY-NO                 
T22243                                    MC-COMPANY-NO                 
T22243                                    MA-COMPANY-NO                 
T22243                                    MQ-COMPANY-NO                 
T22243                                    AT-COMPANY-NO                 
T22243                                    GR-COMPANY-NO.                
T22243     DISPLAY '*********************************'                  
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', EQ-COMPANY-NO     
T22243     DISPLAY '*********************************'                  
T22243*                                                                 07770000
           INITIALIZE    DCLCSS-JOB-PARM.                               
      *                                                                 07790000
T22243     MOVE WS-SYSIN-COMP-NO       TO G6-COMPANY-NO.                
           PERFORM 0200-READ-INPUT-PARM          THRU 0200-EXIT         
           PERFORM 0300-OPEN-OUTPUT-FILES        THRU 0300-EXIT.        
      *                                                                 07830000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07860000
       0200-READ-INPUT-PARM.                                            
           MOVE WS-PARM                   TO WS-COMMAND                 
           MOVE WS-PGRMNAME               TO WS-PROGRAM                 
           PERFORM   7600-START-FCSJC01          THRU 7600-EXIT         
           PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT         
T16852     IF END-OF-SYSIPT                                             
T16852        DISPLAY '******************************'                  
T16852        DISPLAY '*   NO RECORDS FOR PCSCA650  *'                  
T16852        DISPLAY '*   IN CSS_JOB_PARM          *'                  
T16852        DISPLAY '******************************'                  
T16852        PERFORM 9900-ABEND                 THRU 9900-EXIT         
T16852     END-IF.                                                      
           IF G6-SEQ-NO                   EQUAL WS-ONE AND              
              G6-STATUS                   EQUAL WS-A                    
              MOVE WS-INPUT-DATA-BREAKDOWN   TO WS-PARAMETER-DATA       
              IF WS-TEST-YEAR-TEXT           NOT EQUAL WS-TEST-YEAR     
                 DISPLAY '*****************************************'    
                 DISPLAY '*       INVALID PARM IN 1ST RECORD      *'    
                 DISPLAY '*           OF CSS_JOB_PARM             *'    
                 DISPLAY '*   PARM GIVEN IS : ' WS-TEST-YEAR-TEXT       
                 DISPLAY '*   PARM SHOULD BE : TEST YEAR = 9999   *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-TEST-YEAR-VALUE-C        NOT NUMERIC                
                 DISPLAY '*****************************************'    
                 DISPLAY '*    TEST YEAR  SHOULD BE NUMERIC IN    *'    
                 DISPLAY '*      1 ST RECORD OF CSS_JOB_PARM      *'    
                 DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE-C     
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-TEST-YEAR-VALUE          LESS THAN 1996       OR    
                 WS-TEST-YEAR-VALUE          GREATER THAN 2100          
                 DISPLAY '**********************************'           
                 DISPLAY '*   INVALID  TEST YEAR           *'           
                 DISPLAY '* PARM TEST YEAR : ' WS-TEST-YEAR-VALUE       
                 DISPLAY '**********************************'           
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              ELSE                                                      
                 MOVE WS-TEST-YEAR-VALUE     TO WS-PARM-TEST-YEAR       
                                                WS-PARM-TEST-YEAR       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-DB2-TODAYS-DATE        TO WS-DB2-DATE             
              MOVE WS-DB2-YEAR               TO WS-PARM-TEST-YEAR       
           END-IF.                                                      
T16852*                                                                 08340000
T16852     PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT         
           IF G6-SEQ-NO                      EQUAL WS-TWO               
              MOVE WS-Y                      TO WS-JOB-PARM-2           
              MOVE WS-RUN-TYPE-VALUE         TO WS-PARM-RUN-TYPE        
              IF G6-STATUS                   NOT EQUAL WS-A             
                 DISPLAY '*******************************'              
                 DISPLAY '*   INACTIVE STATUS           *'              
                 DISPLAY '* PARM STATUS    : ' G6-STATUS                
                 DISPLAY '*******************************'              
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-RUN-TYPE-TEXT            NOT EQUAL WS-RUN-TYPE      
                 DISPLAY '*****************************************'    
                 DISPLAY '*       INVALID PARM IN 2ND RECORD      *'    
                 DISPLAY '*           OF CSS_JOB_PARM             *'    
                 DISPLAY '*   PARM GIVEN IS : ' WS-RUN-TYPE-TEXT        
                 DISPLAY '*   PARM SHOULD BE : RUN TYPE = SELECT  *'    
                 DISPLAY '*       (OR FORECAST OR ADDITIONAL)     *'    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-PARM-RUN-TYPE            EQUAL WS-SELECT OR         
                 WS-PARM-RUN-TYPE            EQUAL WS-FORECAST OR       
                 WS-PARM-RUN-TYPE            EQUAL WS-ADDITIONAL        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '**************************************'       
                 DISPLAY '*   INVALID  RUN TYPE 1              *'       
                 DISPLAY '* PARM RUN TYPE  : ' WS-PARM-RUN-TYPE         
                 DISPLAY '**************************************'       
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-N                      TO WS-RUN-TYPE-GIVEN       
              DISPLAY '******************************'                  
              DISPLAY '*   RUN TYPE NOT GIVEN       *'                  
              DISPLAY '*   IN CSS_JOB_PARM          *'                  
              DISPLAY '******************************'                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
T16852*                                                                 08750000
T16852     PERFORM   7610-READ-FCSJC01           THRU 7610-EXIT.        
T16852     PERFORM 0210-PROCESS-TEST-GRP-REC     THRU 0210-EXIT.        
      *                                                                 08780000
           IF WS-PARM-RUN-TYPE        EQUAL WS-ADDITIONAL               
              IF WS-JOB-PARM-3   NOT  EQUAL WS-Y                        
                 DISPLAY '****************************************'     
                 DISPLAY '*IF RUN TYPE = ADDITIONAL, TEST GROUP *'      
                 DISPLAY '* AND SELECT QTY SHOULD BE GIVEN       *'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08880000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08910000
       0210-PROCESS-TEST-GRP-REC.                                       
      *                                                                 08930000
           PERFORM 0230-PROCESS-ADD-PARM-REC THRU 0230-EXIT             
                   UNTIL WS-SELECT-QTY-TEXT NOT EQUAL WS-SELECT-QTY     
T16852                                     OR END-OF-SYSIPT.            
T16852     IF END-OF-SYSIPT                                             
T16852        GO TO 0210-EXIT                                           
T16852     END-IF.                                                      
      *                                                                 09000000
           PERFORM 0240-VAL-INITIAL-SEED     THRU 0240-EXIT.            
                                                                        
                                                                        
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09060000
       0220-PROCESS-ADD-PARM-REC.                                       
           IF WS-SELECT-QTY-TEXT             EQUAL WS-SELECT-QTY        
              MOVE WS-Y                      TO WS-JOB-PARM-3           
           END-IF.                                                      
           IF WS-TEST-GROUP-3-TEXT        NOT EQUAL WS-TEST-GROUP       
              DISPLAY '********************************************'    
              DISPLAY '*       INVALID PARM IN 3RD RECORD         *'    
              DISPLAY '*           OF CSS_JOB_PARM                *'    
              DISPLAY '*     PARM GIVEN IS : ' WS-TEST-GROUP-3-TEXT     
              DISPLAY '*     PARM SHOULD BE :                     *'    
              DISPLAY '*     TEST GROUP = XX SELECT QTY = 9999    *'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
      *    VALIDATE TEST GROUP AGAINST CSS_MTR_TEST_GROUP               09210000
           MOVE  WS-TEST-GROUP-VALUE-3    TO GR-MTR-TEST-GRP-CD         
           PERFORM 7000-VALIDATE-MTR-TST-GROUP                          
                                              THRU 7000-EXIT            
           IF SQLCODE                     EQUAL   NOT-FOUND             
              DISPLAY '*****************************************'       
              DISPLAY '*INVALID  TEST GROUP IN  3 REC          *'       
              DISPLAY '*IN CSS_JOB _PARM                       *'       
              DISPLAY '* TEST GROUP     : ' WS-TEST-GROUP-VALUE-3       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           IF WS-SELECT-QTY-TEXT          NOT EQUAL WS-SELECT-QTY       
              DISPLAY '********************************************'    
              DISPLAY '*       INVALID PARM IN 3RD RECORD         *'    
              DISPLAY '*           OF CSS_JOB_PARM                *'    
              DISPLAY '*     PARM GIVEN IS : ' WS-SELECT-QTY-TEXT       
              DISPLAY '*     PARM SHOULD BE :                     *'    
              DISPLAY '*     TEST GROUP = XX SELECT QTY = 9999    *'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           IF WS-SELECT-QTY-VALUE         NOT NUMERIC                   
              DISPLAY '*****************************************'       
              DISPLAY '*    SELECT QTY SHOULD BE NUMERIC IN    *'       
              DISPLAY '*      3 RD RECORD OF CSS_JOB_PARM      *'       
              DISPLAY '* PARM SELECT QTY : ' WS-SELECT-QTY-VALUE        
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           ADD 1                          TO WS-CTR-K                   
           MOVE WS-SELECT-QTY-VALUE       TO                            
                                          WS-PARM-SELECT-QTY (WS-CTR-K) 
           MOVE WS-TEST-GROUP-VALUE-3     TO                            
                                          WS-PARM-TEST-GRP-3 (WS-CTR-K).
      *                                                                 09560000
       0220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09590000
       0230-PROCESS-ADD-PARM-REC.                                       
      *                                                                 09610000
           PERFORM 7610-READ-FCSJC01          THRU 7610-EXIT.           
      *                                                                 09640000
       0230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09670000
       0240-VAL-INITIAL-SEED.                                           
           IF WS-INITIAL-SEED-TEXT           EQUAL WS-INITIAL-SEED      
              MOVE WS-Y                      TO WS-JOB-PARM-4           
              IF WS-TEST-GROUP-4-TEXT        NOT EQUAL WS-TEST-GROUP    
                 DISPLAY '********************************************' 
                 DISPLAY '*       INVALID PARM IN 4TH RECORD         *' 
                 DISPLAY '*           OF CSS_JOB_PARM                *' 
                 DISPLAY '* PARM GIVEN IS : ' WS-TEST-GROUP-4-TEXT      
                 DISPLAY '* PARM SHOULD BE :                         *' 
                 DISPLAY '* TEST GROUP = XX INITIAL SEED = 9999999999*' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
      *       VALIDATE TEST GROUP AGAINST CSS_MTR_TEST_GROUP            09810000
              MOVE  WS-TEST-GROUP-VALUE-4     TO GR-MTR-TEST-GRP-CD     
              PERFORM 7000-VALIDATE-MTR-TST-GROUP                       
                                                 THRU 7000-EXIT         
              IF SQLCODE                     EQUAL   NOT-FOUND          
                 DISPLAY '*****************************************'    
                 DISPLAY '*INVALID  TEST GROUP IN  4 REC          *'    
                 DISPLAY '*IN CSS_JOB _PARM                       *'    
                 DISPLAY '* TEST GROUP     : ' WS-TEST-GROUP-VALUE-4    
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              IF WS-INITIAL-SEED-TEXT        NOT EQUAL WS-INITIAL-SEED  
                 DISPLAY '********************************************' 
                 DISPLAY '*       INVALID PARM IN 4TH RECORD         *' 
                 DISPLAY '*           OF CSS_JOB_PARM                *' 
                 DISPLAY '* PARM GIVEN IS : ' WS-INITIAL-SEED-TEXT      
                 DISPLAY '* PARM SHOULD BE :                         *' 
                 DISPLAY '* TEST GROUP = XX INITIAL SEED = 9999999999*' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              INSPECT WS-INITIAL-SEED-VALUE REPLACING ALL               
                 LOW-VALUES BY SPACES                                   
              INSPECT WS-INITIAL-SEED-VALUE TALLYING                    
                        WS-INSPECT-CNTR FOR ALL ' '                     
              COMPUTE  WS-INSPECT-CNTR =                                
                     LENGTH OF WS-INITIAL-SEED-VALUE - WS-INSPECT-CNTR  
              IF ( WS-INSPECT-CNTR EQUAL ZERO )                         
                   MOVE LENGTH OF WS-INITIAL-SEED-VALUE                 
                                             TO WS-INSPECT-CNTR         
              END-IF                                                    
              MOVE WS-INITIAL-SEED-VALUE(1:WS-INSPECT-CNTR) TO          
                                             WS-INITIAL-SEED-JUSTIFIED  
              INSPECT WS-INITIAL-SEED-JUSTIFIED                         
                                   REPLACING ALL ' ' BY '0'             
              IF WS-INITIAL-SEED-JUSTIFIED   NOT NUMERIC                
                 DISPLAY '********************************************' 
                 DISPLAY '* INITIAL SEED VALUE IN 4 TH               *' 
                 DISPLAY '* REC OF CSS_JOB_PARM NOT                  *' 
                 DISPLAY '* NUMERIC                                  *' 
                 DISPLAY '* INITIAL SEED : ' WS-INITIAL-SEED-JUSTIFIED  
                 DISPLAY '********************************************' 
      *          PERFORM 9000-TERMINATE       THRU 9000-EXIT            10240000
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
              MOVE WS-TEST-GROUP-VALUE-4     TO WS-PARM-TEST-GRP-4      
              MOVE WS-INITIAL-SEED-JUSTIFIED TO WS-PARM-INITIAL-SEED    
           END-IF.                                                      
      *                                                                 10300000
       0240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10330000
       0300-OPEN-OUTPUT-FILES.                                          
           IF WS-PARM-RUN-TYPE               EQUAL WS-SELECT            
              OPEN OUTPUT POPULATION-SAMPLE-FILE                        
              IF  SAMPFIL-SUCCESS                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FCSMT13  FILE OPEN ERROR'                    
                  DISPLAY 'FCSMT13 FILE STATUS IS ==>' WS-SAMPFIL-STATUS
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
              OPEN OUTPUT METER-DETAIL-FILE                             
              IF  METFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FIOCA65             FILE OPEN ERROR'         
                  DISPLAY 'FIOCA65 FILE STATUS IS ==>' WS-METFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-RUN-TYPE  EQUAL WS-FORECAST                       
              OPEN OUTPUT POPULATION-SAMPLE-FILE                        
              IF  SAMPFIL-SUCCESS                                       
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FCSMT13             FILE OPEN ERROR'         
                  DISPLAY 'FCSMT13 FILE STATUS IS ==>' WS-SAMPFIL-STATUS
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-PARM-RUN-TYPE  EQUAL WS-ADDITIONAL                     
              OPEN OUTPUT METER-DETAIL-FILE                             
              IF  METFIL-SUCCESS                                        
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY 'FIOCA65             FILE OPEN ERROR'         
                  DISPLAY 'FIOCA65 FILE STATUS IS ==>' WS-METFIL-STATUS 
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *FOLL 2 LINES TO BE DELETED LATER                                 10730000
           OPEN OUTPUT RANDOM-NBR-FILE                                  
           IF RANDOMFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'RANDOM FILE OPEN ERROR'                          
              DISPLAY 'RANDOM FILE STATUS IS ===>'                      
                                 WS-RANDOMFIL-STATUS                    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *END OF LINES TO BE DELETED                                       10830000
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10860000
       1000-PROCESS-INPUT-PARM.                                         
      *                                                                 10880000
T16852       PERFORM 7200-OPEN-GET-INSTALLED-QTY THRU 7200-EXIT         
T16852       PERFORM 7210-FETCH-GET-INSTALLED-QTY   THRU 7210-EXIT      
T16852       PERFORM 1100-STORE-INSTALLED-QTY THRU 1100-EXIT            
T16852         UNTIL SQLCODE EQUAL NOT-FOUND OR WS-SUB > 75             
      *                                                                 10930000
T16852     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T16852         DISPLAY '****************PCSCA650******************'     
T16852         DISPLAY ' # OF TEST GROUPS IN THE TABLE IS > 75    '     
T16852         DISPLAY 'PROGRAM NEEDS TO BE CHANGED               '     
T16852         DISPLAY '****************PCSCA650******************'     
T16852         PERFORM 7220-CLOSE-GET-INSTALLED-QTY   THRU 7220-EXIT    
T16852         PERFORM 9900-ABEND             THRU 9900-EXIT            
T16852     END-IF.                                                      
T16852     PERFORM 7220-CLOSE-GET-INSTALLED-QTY   THRU 7220-EXIT.       
      *                                                                 11030000
           IF WS-JOB-PARM-3                  EQUAL   WS-Y   AND         
             WS-PARM-RUN-TYPE EQUAL WS-ADDITIONAL                       
             PERFORM 2000-SELECT-ADDITIONAL-METERS                      
                                                 THRU 2000-EXIT         
                 VARYING WS-TOT-TEST-GROUPS FROM 1 BY 1                 
                       UNTIL WS-TOT-TEST-GROUPS  > WS-CTR-K             
           END-IF.                                                      
      *                                                                 11110000
           IF WS-PARM-RUN-TYPE EQUAL WS-SELECT   OR                     
              WS-PARM-RUN-TYPE EQUAL WS-FORECAST                        
              PERFORM 3000-SELECT-AND-FORECAST   THRU 3000-EXIT         
           END-IF.                                                      
      *                                                                 11160000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11190000
T16852 1100-STORE-INSTALLED-QTY.                                        
T16852*                                                                 11210000
T16852     ADD 1 TO WS-SUB.                                             
T16852     MOVE  TG-MTR-TEST-GRP-CD         TO WS-TEST-GRP-CD (WS-SUB)  
T16852     MOVE  WS-CURRENT-INSTALLED-QTY   TO WS-INSTALLED-QTY (WS-SUB)
T16852     PERFORM 7210-FETCH-GET-INSTALLED-QTY   THRU 7210-EXIT.       
T16852*                                                                 11260000
T16852 1100-EXIT.                                                       
T16852     EXIT.                                                        
T16852*                                                                 11290000
       2000-SELECT-ADDITIONAL-METERS.                                   
      *                                                                 11310000
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR            
           MOVE WS-PARM-TEST-GRP-3 (WS-TOT-TEST-GROUPS)                 
                                             TO MQ-MTR-TEST-GRP-CD      
           PERFORM 7100-SELECT-METER-TEST-HIST   THRU 7100-EXIT         
      *                                                                 11360000
T16852     MOVE 1                            TO WS-SUB.                 
T22268     MOVE WS-N                         TO WS-GRP-CD-FOUND         
T22268     PERFORM UNTIL GRP-CD-FOUND OR WS-SUB > 75                    
T22268         IF  WS-TEST-GRP-CD(WS-SUB) EQUAL MQ-MTR-TEST-GRP-CD      
T22268             SET GRP-CD-FOUND          TO TRUE                    
T22268         ELSE                                                     
T22268             ADD 1 TO WS-SUB                                      
T22268         END-IF                                                   
T16852     END-PERFORM.                                                 
T22268     IF  GRP-CD-FOUND                                             
T16852     MOVE WS-INSTALLED-QTY (WS-SUB) TO MQ-INSTALLED-QT            
T22268                                    WS-CURRENT-INSTALLED-QTY      
T22268     ELSE                                                         
T22268         MOVE ZEROS                 TO WS-CURRENT-INSTALLED-QTY   
T22268     END-IF.                                                      
                                                                        
           MOVE WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)                 
                                             TO WS-NBR-RANDOM-NBRS      
      *    GENERATE RANDOM NUMBERS                                      11560000
           PERFORM 4500-GENERATE-RANDOM-NUM      THRU 4500-EXIT         
                                                                        
           PERFORM 7300-OPEN-METER-EQUIP-TST     THRU 7300-EXIT         
           MOVE 1                            TO WS-RANDOM-INDEX         
           MOVE 1                            TO WS-METER-NUM-INDEX      
           MOVE 0                            TO WS-METER-SEQ            
      *                                                                 11630000
           SORT SORT-FILE                                               
           ON ASCENDING KEY S-RANDOM-NBR                                
           USING UNSORTED-RANDOM-FILE                                   
           GIVING SORTED-RANDOM-FILE.                                   
      *                                                                 11680000
           OPEN INPUT SORTED-RANDOM-FILE.                               
      *                                                                 11700000
           PERFORM 2100-PROCESS-ADDITIONAL-METERS                       
                   THRU 2100-EXIT                                       
T16852                VARYING WS-COUNT  FROM 1 BY 1 UNTIL               
T16852                 WS-METER-NUM-INDEX >                             
                           WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS).     
           PERFORM 7320-CLOSE-METER-EQUIP-TST    THRU 7320-EXIT         
T22243*                                                                 11770000
T22243     CLOSE SORTED-RANDOM-FILE.                                    
      *                                                                 11790000
           MOVE 1                            TO WS-METER-NUM-INDEX      
           PERFORM 2200-UPDATE-ELEC-METER        THRU 2200-EXIT         
                   VARYING WS-COUNT-UPD-ELEC-MTR  FROM 1 BY 1           
                      UNTIL WS-COUNT-UPD-ELEC-MTR  >                    
                         WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS).       
                                                                        
      *ADD PARM SELECT QTY TO SAMPLE_ADDITIONAL_QT , SELECTED_TEST_QT   11960000
      *ON CSS_MTR_TEST_HIST                                             11970000
                                                                        
           COMPUTE MQ-SAMPL-ADDITIONL-QT  = MQ-SAMPL-ADDITIONL-QT       
                   + WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)            
           IF MAX-RAN-NUM-REACHED                                       
              CONTINUE                                                  
           ELSE                                                         
              COMPUTE MQ-SELECTED-QT       = MQ-SELECTED-QT             
                   + WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS)            
           END-IF                                                       
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
           PERFORM 8100-UPDATE-MTR-TEST-HIST     THRU 8100-EXIT.        
      *                                                                 12100000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12130000
       2100-PROCESS-ADDITIONAL-METERS.                                  
           READ SORTED-RANDOM-FILE                                      
           COMPUTE WS-NBR-OF-FETCHES                                    
              =  WS-RANDOM-NBR  - WS-METER-SEQ                          
           PERFORM 2110-FETCH-NEXT-RECORD        THRU 2110-EXIT         
                   VARYING WS-FETCH-ALL-MTRS FROM 1 BY 1                
                      UNTIL WS-FETCH-ALL-MTRS EQUAL                     
                           WS-NBR-OF-FETCHES.                           
      *    STORE METER NUMBERS IN TABLE                                 12230000
T16852     PERFORM 2300-CALL-SCSCA657            THRU 2300-EXIT.        
      *                                                                 12280000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12310000
       2110-FETCH-NEXT-RECORD.                                          
           PERFORM  7310-FETCH-METER-EQUIP-TEST  THRU 7310-EXIT         
           ADD 1                             TO WS-METER-SEQ.           
      *                                                                 12350000
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12380000
       2200-UPDATE-ELEC-METER.                                          
T16229     IF  WS-METER-NUMBER(WS-METER-NUM-INDEX) > SPACES AND         
T16229         LOW-VALUES                                               
           MOVE WS-METER-NUMBER(WS-METER-NUM-INDEX)                     
                                             TO EM-METER-NO             
           PERFORM  8000-UPDATE-ELEC-METER       THRU 8000-EXIT         
           ADD 1                             TO WS-METER-NUM-INDEX      
T16229     END-IF.                                                      
      *                                                                 12470000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12500000
       2300-CALL-SCSCA657.                                              
      *                                                                 12520000
T16852     IF  EM-METER-NO EQUAL SPACES OR LOW-VALUES                   
T16229         GO TO 2300-EXIT                                          
T16229     END-IF.                                                      
T16852*                                                                 12560000
T16852     IF  EQ-CODE-CRNT-LOC EQUAL WS-K                              
T16852         MOVE EM-METER-NO                TO MA-DEVICE-NO          
T16852         PERFORM 7965-GET-MTR-NO-ATTCHED-TO THRU 7965-EXIT        
T16852         IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
T16852             CONTINUE                                             
T16852         ELSE                                                     
T16852             MOVE MA-METER-NO            TO EM-METER-NO           
T16852         END-IF                                                   
T16852     END-IF.                                                      
T16852*                                                                 12660000
      *     GET ACCOUNT NO FOR THE METER                                12670000
T16852      MOVE EM-METER-NO                 TO MN-METER-NO             
T20234      MOVE EQ-CRNT-LOC-NO             TO WS-CPD99-PREMISE-NO.     
T20234      PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.              
T20234      MOVE WS-CPD99-ACCOUNT-NO        TO MN-ACCOUNT-NO.           
T20234*                                                                 12720000
            PERFORM 7400-OPEN-ACCOUNT-DETAILS     THRU 7400-EXIT        
            PERFORM 7410-FETCH-ACCOUNT-DETAILS    THRU 7410-EXIT        
T16852*                                                                 12750000
T16852     IF  EQ-CODE-CRNT-LOC EQUAL WS-K                              
T16852         MOVE MA-DEVICE-NO             TO EM-METER-NO             
T16852     END-IF.                                                      
T16852*                                                                 12790000
T16852      IF SQLCODE                       EQUAL SUCCESSFUL-CALL      
               ADD +1                        TO WS-SO-INDEX             
               MOVE UT-ACCOUNT-NO            TO                         
                                             WS-SO-ACCT-NO(WS-SO-INDEX) 
               MOVE WS-R                     TO                         
                                           WS-SO-TEST-TYPE(WS-SO-INDEX) 
T16852         MOVE EM-METER-NO              TO                         
                                           WS-SO-METER-NO(WS-SO-INDEX)  
ACT018         IF WS-SO-INDEX = 110                                     
T16229            MOVE WS-E                   TO WS-SO-UTIL-TYPE        
                  MOVE WS-DB2-TODAYS-DATE     TO WS-SO-DATE             
                  COMPUTE WS-NBR-METERS = WS-SO-INDEX                   
                  CALL 'SCSCA657'   USING WS-SCSCA657-LINKAGE           
                  COMPUTE WS-SO-INDEX = 0                               
               END-IF                                                   
               IF WS-PARM-RUN-TYPE               EQUAL WS-ADDITIONAL    
T16852            IF WS-METER-NUM-INDEX EQUAL                           
T16852                          WS-PARM-SELECT-QTY (WS-TOT-TEST-GROUPS) 
                     IF WS-SO-INDEX  >  0   AND                         
ACT018                  WS-SO-INDEX  <  110                             
T16229                  MOVE WS-E                TO WS-SO-UTIL-TYPE     
                        MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE          
                        COMPUTE WS-NBR-METERS    =  WS-SO-INDEX         
                        CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE       
                        COMPUTE WS-SO-INDEX = 0                         
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
               IF WS-PARM-RUN-TYPE               EQUAL WS-SELECT        
T19314            IF (WS-METER-NUM-INDEX  = (WS-NBR-RANDOM-NBRS - 1)    
T19314                     OR WS-COUNT-1  = (WS-NBR-RANDOM-NBRS - 1))   
                     IF WS-SO-INDEX  >  0   AND                         
ACT018                  WS-SO-INDEX  <  110                             
T16229                  MOVE WS-E                TO WS-SO-UTIL-TYPE     
                        MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE          
                        COMPUTE WS-NBR-METERS    =  WS-SO-INDEX         
                        CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE       
                        COMPUTE WS-SO-INDEX = 0                         
                     END-IF                                             
                  ELSE                                                  
T16852               IF WS-JOB-PARM-3 EQUAL WS-Y                        
                     IF WS-PARM-TEST-GRP-3 (WS-CTR-K) EQUAL             
                        MQ-MTR-TEST-GRP-CD AND                          
T16852                  WS-METER-NUM-INDEX EQUAL                        
                        WS-PARM-SELECT-QTY (WS-CTR-K)                   
                        IF WS-SO-INDEX  >  0   AND                      
ACT018                     WS-SO-INDEX  <  110                          
T16229                     MOVE WS-E                TO WS-SO-UTIL-TYPE  
                           MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE       
                           COMPUTE WS-NBR-METERS    =  WS-SO-INDEX      
                           CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE    
                           MOVE WS-Y       TO WS-CALL-SCSCA657          
                           COMPUTE WS-SO-INDEX = 0                      
                        END-IF                                          
                     END-IF                                             
T16852               END-IF                                             
                  END-IF                                                
               END-IF                                                   
            PERFORM 2310-WRITE-CA65           THRU 2310-EXIT            
T16852      ELSE                                                        
T16852         DISPLAY '***************************************'        
T16852         DISPLAY '*     NO ACCOUNT DETAILS FOUND FOR    *'        
T16852         DISPLAY '*   METER ',  MN-METER-NO                       
T16852         DISPLAY '*   PROCESS CONTINUES WITH NEXT MTR...*'        
T16852         DISPLAY '**************PCSCA650 ****************'        
T16852      END-IF.                                                     
            PERFORM 7420-CLOSE-ACCOUNT-DETAILS    THRU 7420-EXIT.       
      *                                                                 13470000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13500000
       2310-WRITE-CA65.                                                 
      *     SELECT ACCOUNT,LOCAL OFFICE,RATE PLAN, READ ROUTE, NAME     13520000
      *     AND ADDRESS INFORMATION FOR METER.                          13530000
      *     GET ACCOUNT NUMBER FOR THE NEXT METER NUMBER.               13540000
      *WRITE RECORD TO FCSCA65                                          13550000
            MOVE UT-ACCOUNT-NO               TO E-FCA65-ACCT-NO         
                                                AT-ACCOUNT-NO           
      *SELECT ON CSS_ACCOUNT                                            13580000
            PERFORM 7500-GET-LOCAL-OFFICE        THRU 7500-EXIT.        
      *SELECT ON CSS_ELEC_METER TO GET METER DETAILS                    13600000
            PERFORM 7601-SELECT-ELEC-METER       THRU 7601-EXIT.        
      *PATCH TO AVOID S0C7                                              13620000
            MOVE ZEROES                      TO AT-ADDRESS-ID           
            MOVE ZEROES                      TO HT-ADDRESS-ID           
      *                                                                 13650000
            PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT         
            MOVE WS-CUSTOMER-NAME            TO E-FCA65-NAME            
            MOVE WS-PR-STREET                TO E-FCA65-SERV-ADDR       
            MOVE WS-R                        TO E-FCA65-TEST-TYPE-CODE  
            MOVE EM-TEST-SCHED-CD            TO E-FCA65-TEST-SCH-CD     
            MOVE UT-READ-ROUTE               TO E-FCA65-READ-ROUTE      
29312       MOVE UT-READ-CYCLE               TO E-FCA65-READ-CYCLE      
            MOVE UT-RATE-PLAN-NO             TO E-FCA65-RATE            
            MOVE EM-METER-NO                 TO E-FCA65-METER-NO        
                                                MC-METER-NO             
                                                EQ-DEVICE-NO            
            PERFORM 7960-SELECT-EQUIP-DETAILS    THRU 7960-EXIT         
            MOVE EQ-CODE-MAKE                TO E-FCA65-CODE-MAKE       
            MOVE EQ-COMPANY-NO               TO E-FCA65-COMPANY-NO      
            MOVE +1                          TO MC-REG-ID-NO            
            MOVE WS-E                        TO MC-CODE-UTIL-TYPE       
            MOVE WS-E                        TO E-FCA65-UTIL-TYPE       
      *SELECT CONSTANT FROM CSS_MTR_CAP                                 13830000
            PERFORM 7700-SELECT-MTR-CAP-CONSTANT                        
                                                 THRU 7700-EXIT         
            MOVE MC-CONSTANT                 TO E-FCA65-CONSTANT        
            MOVE EM-METER-SIZE-ID            TO E-FCA65-METER-SIZE      
            IF WS-DATE-LAST-TESTED-NULLIND = -1                         
               MOVE SPACES                   TO E-FCA65-TEST-DATE       
            ELSE                                                        
               MOVE EM-DATE-LAST-TESTED      TO E-FCA65-TEST-DATE       
            END-IF                                                      
            MOVE SPACES                      TO E-FCA65-METER-TYPE      
            MOVE AT-LOCAL-OFFICE             TO E-FCA65-LOCAL-OFFICE    
            MOVE +0                          TO E-FCA65-SORT-KEY        
            MOVE MQ-MTR-TEST-GRP-CD          TO E-FCA65-MTR-TEST-GRP-CD 
            MOVE EM-ELEC-MTR-SPEC-CD         TO E-FCA65-MTR-SPEC-CD     
            MOVE EM-ELEC-MTR-CLASS-CD        TO E-FCA65-MTR-CLASS-CD    
            MOVE WS-PR-ADDR-CITY-STATE-ZIP   TO                         
                                               E-FCA65-ADDR-CITY-ST-ZIP 
            MOVE WS-DB2-TODAYS-DATE          TO                         
                                               E-FCA65-LAST-TEST-SEL-DT 
      *                                                                 14040000
            WRITE METER-DETAIL-REC           FROM FIOCA65.              
            ADD 1 TO WS-WRITE-CNT.                                      
      *                                                                 14070000
T16852      MOVE EM-METER-NO                 TO                         
T16852                          WS-METER-NUMBER (WS-METER-NUM-INDEX)    
T16852      ADD 1                            TO WS-METER-NUM-INDEX.     
T16852*                                                                 14110000
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14140000
       3000-SELECT-AND-FORECAST.                                        
      *                                                                 14160000
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
           PERFORM 7800-OPEN-SAMPLE-TEST-HIST    THRU 7800-EXIT         
A05268     WRITE POP-SAMPLE-REC              FROM WS-FIOMT13-REC.       
           PERFORM 3100-GET-SAMPLE-TEST-HIST     THRU 3100-EXIT         
               UNTIL END-MTR-TEST-GRP.                                  
           PERFORM 7820-CLOSE-SAMPLE-TEST-HIST   THRU 7820-EXIT.        
      *                                                                 14220000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14250000
       3100-GET-SAMPLE-TEST-HIST.                                       
           PERFORM 7810-FETCH-SAMPLE-TEST-HIST   THRU 7810-EXIT         
           IF SQLCODE  EQUAL  NOT-FOUND                                 
              MOVE WS-Y                      TO WS-END-MTR-TEST-GRP     
              GO TO 3100-EXIT                                           
           END-IF.                                                      
      *                                                                 14320000
T16852     MOVE 1                            TO WS-SUB.                 
T22268     MOVE WS-N                         TO WS-GRP-CD-FOUND         
T22268     PERFORM UNTIL GRP-CD-FOUND OR WS-SUB > 75                    
T22268         IF  WS-TEST-GRP-CD(WS-SUB) EQUAL MQ-MTR-TEST-GRP-CD      
T22268             SET GRP-CD-FOUND          TO TRUE                    
T22268         ELSE                                                     
T22268             ADD 1 TO WS-SUB                                      
T22268         END-IF                                                   
T16852     END-PERFORM.                                                 
T22268     IF  GRP-CD-FOUND                                             
T16852     MOVE WS-INSTALLED-QTY (WS-SUB) TO                            
T16852                                    WS-CURRENT-INSTALLED-QTY      
T22268     ELSE                                                         
T22268         MOVE ZEROS                 TO WS-CURRENT-INSTALLED-QTY   
T22268     END-IF.                                                      
      *                                                                 14480000
           IF WS-CURRENT-INSTALLED-QTY   EQUAL ZERO                     
              GO TO 3100-EXIT                                           
           END-IF                                                       
           MOVE WS-CURRENT-INSTALLED-QTY     TO MQ-INSTALLED-QT         
      *                                                                 14530000
      *SELECT SAMPLE SIZE FROM TABLE B-3 "SAMPLE SIZE AND MAXIMUM       14540000
      *ALLOWABLE PERCENT DEFECTIVE" IN "A STATISTICAL SAMPLING PLAN     14550000
      *FOR SCE&G"                                                       14560000
                                                                        
              MOVE WS-N                      TO WS-FOUND                
      *IF CURRENT INSTALLED QTY IS LESS THAN 3, DO NOT READ TABLE B-3,  14590000
      *MAKE MQ-SAMPLE-MIN-QT SAME AS CURRENT INSTALLED QTY              14600000
              IF WS-CURRENT-INSTALLED-QTY  <  3                         
                 MOVE WS-CURRENT-INSTALLED-QTY    TO MQ-SAMPLE-MIN-QT   
                                                    MQ-SELECTED-QT      
              ELSE                                                      
                 PERFORM VARYING WS-SUB  FROM 1 BY 1                    
                 UNTIL WS-SUB > 15 OR FOUND                             
            IF (WS-CURRENT-INSTALLED-QTY >= ESMP-MIN-SIZE (WS-SUB)) AND 
               (WS-CURRENT-INSTALLED-QTY <= ESMP-MAX-SIZE (WS-SUB))     
               MOVE WS-Y                     TO WS-FOUND                
            END-IF                                                      
                 END-PERFORM                                            
                 IF FOUND                                               
                    COMPUTE WS-SUB = WS-SUB - 1                         
                 END-IF                                                 
                 MOVE ESMP-SAMPLE-SIZE (WS-SUB) TO MQ-SAMPLE-MIN-QT     
              END-IF                                                    
      *IF A TEST GROUP HAS FAILED IN THE PAST,USE CORRECTIVE            14770000
      *PERCENT INSTEAD OF TABLE B-3.                                    14780000
      *                                                                 14790000
           IF MQ-SAMPL-CORRECTV-PCT          IS GREATER THAN ZERO       
              COMPUTE  MQ-SAMPLE-MIN-QT  = MQ-SAMPLE-MIN-QT +           
                  (MQ-INSTALLED-QT * MQ-SAMPL-CORRECTV-PCT) / 100       
      *                                                                 14830000
              PERFORM VARYING WS-SUB FROM 1 BY 1                        
                UNTIL WS-SUB > 15 OR SAMPLE-SIZE-FOUND                  
                IF MQ-SAMPLE-MIN-QT <= ESMP-SAMPLE-SIZE (WS-SUB)        
                   MOVE ESMP-SAMPLE-SIZE (WS-SUB) TO WS-SAMPLE-MIN-QT   
                   MOVE WS-Y                    TO WS-SAMPLE-SIZE-FOUND 
                END-IF                                                  
                IF NOT SAMPLE-SIZE-FOUND                                
                   MOVE 200                     TO WS-SAMPLE-MIN-QT     
                END-IF                                                  
              END-PERFORM                                               
      *                                                                 14940000
              MOVE WS-SAMPLE-MIN-QT             TO MQ-SAMPLE-MIN-QT     
           END-IF                                                       
      *                                                                 14970000
              COMPUTE  MQ-SELECTED-QT ROUNDED                           
                                         = MQ-SAMPLE-MIN-QT  +          
END             ((MQ-SAMPLE-MIN-QT * MQ-SAMPL-OVERAGE-PCT) / 100)       
      *                                                                 15010000
           IF MQ-SELECTED-QT               >  MQ-INSTALLED-QT           
              MOVE MQ-INSTALLED-QT            TO MQ-SELECTED-QT         
           END-IF                                                       
      *                                                                 15050000
           MOVE MQ-SELECTED-QT               TO WS-SELECTED-QT          
      *                                                                 15070000
           MOVE WS-PARM-TEST-YEAR            TO E-FMT13-TEST-YEAR       
           IF WS-PARM-RUN-TYPE  EQUAL WS-SELECT                         
              MOVE WS-S                      TO E-FMT13-TYPE-RUN        
           END-IF                                                       
           IF WS-PARM-RUN-TYPE  EQUAL WS-FORECAST                       
              MOVE WS-F                      TO E-FMT13-TYPE-RUN        
           END-IF                                                       
           MOVE MQ-MTR-TEST-GRP-CD           TO E-FMT13-MTR-TEST-GRP-CD 
           MOVE MQ-MTR-TEST-GRP-TX           TO                         
                                             E-FMT13-MTR-TEST-GRP-DESC  
           MOVE MQ-SAMPL-OVERAGE-PCT         TO                         
                                             E-FMT13-SAMPL-OVERAGE-PCT  
           MOVE MQ-SAMPL-CORRECTV-PCT        TO                         
                                             E-FMT13-SAMPL-CORRECTV-PCT 
           MOVE WS-CURRENT-INSTALLED-QTY     TO                         
                                            E-FMT13-INSTALLED-QT        
           MOVE MQ-SAMPLE-MIN-QT             TO E-FMT13-SAMPLE-MIN-QT   
           MOVE MQ-SAMPL-ADDITIONL-QT        TO                         
                                            E-FMT13-SAMPL-ADDITIONL-QT  
      *IF 3RD RECORD ON CSS_JOB_PARM IS PRESENT AND THE TEST GROUP      15360000
      *VALUE IS THE SAME AS MQ-MTR-TEST-GRP, THEN THE NUMBER OF METERS  15370000
      *SELECTED FOR THAT TEST GROUP SHOULD BE THE SAME AS WHAT IS GIVEN 15380000
      *IN SELECT QTY OF THE 3RD RECORD.                                 15390000
           IF WS-JOB-PARM-3                  EQUAL WS-Y                 
              IF WS-PARM-TEST-GRP-3 (WS-CTR-K) EQUAL MQ-MTR-TEST-GRP-CD 
                 MOVE WS-PARM-SELECT-QTY (WS-CTR-K)                     
                                             TO E-FMT13-SELECTED-QT     
                                                WS-NBR-RANDOM-NBRS      
              ELSE                                                      
                 MOVE MQ-SELECTED-QT            TO E-FMT13-SELECTED-QT  
                                                WS-NBR-RANDOM-NBRS      
              END-IF                                                    
           ELSE                                                         
              MOVE MQ-SELECTED-QT            TO E-FMT13-SELECTED-QT     
                                             WS-NBR-RANDOM-NBRS         
           END-IF                                                       
      *                                                                 15530000
           WRITE POP-SAMPLE-REC              FROM FIOMT13.              
      *                                                                 15550000
           IF WS-PARM-RUN-TYPE               EQUAL WS-FORECAST          
              GO TO 3100-EXIT                                           
           END-IF.                                                      
      *                                                                 15590000
      *GENERATE RANDOM NUMBERS                                          15620000
           PERFORM 4500-GENERATE-RANDOM-NUM      THRU 4500-EXIT         
      *                                                                 15640000
           PERFORM 7930-OPEN-SAMPLE-SELECT       THRU 7930-EXIT         
           MOVE 1                            TO WS-RANDOM-INDEX         
           MOVE 0                            TO WS-METER-SEQ            
           MOVE 1                            TO WS-METER-NUM-INDEX      
      *                                                                 15690000
           SORT SORT-FILE                                               
           ON ASCENDING KEY S-RANDOM-NBR                                
           USING UNSORTED-RANDOM-FILE                                   
           GIVING SORTED-RANDOM-FILE.                                   
      *                                                                 15740000
           OPEN INPUT SORTED-RANDOM-FILE.                               
      *                                                                 15760000
           PERFORM 3200-PROCESS-SAMPLE-METERS    THRU 3200-EXIT         
T16852          VARYING WS-COUNT-1 FROM 1 BY 1                          
T16852           UNTIL WS-METER-NUM-INDEX  >  WS-NBR-RANDOM-NBRS        
                 OR SQLCODE EQUAL     NOT-FOUND                         
                 OR WS-END-OF-FILE    EQUAL WS-Y.                       
           MOVE WS-N                         TO  WS-END-OF-FILE.        
           CLOSE SORTED-RANDOM-FILE.                                    
      *                                                                 15840000
           PERFORM 7950-CLOSE-SAMPLE-SELECT      THRU 7950-EXIT         
T19314*                                                                 15860000
T19314     IF  WS-SO-INDEX  >  0   AND                                  
ACT018         WS-SO-INDEX  <  110                                      
T19314         MOVE WS-E                TO WS-SO-UTIL-TYPE              
T19314         MOVE WS-DB2-TODAYS-DATE  TO WS-SO-DATE                   
T19314         COMPUTE WS-NBR-METERS    =  WS-SO-INDEX                  
T19314         CALL 'SCSCA657' USING WS-SCSCA657-LINKAGE                
T19314         COMPUTE WS-SO-INDEX = 0                                  
T19314     END-IF                                                       
T19314*                                                                 15950000
T16852     MOVE WS-METER-NUM-INDEX           TO  WS-COUNT.              
T16852     COMPUTE MQ-SELECTED-QT = WS-COUNT - 1.                       
           MOVE 1                            TO  WS-METER-NUM-INDEX     
           PERFORM 2200-UPDATE-ELEC-METER        THRU 2200-EXIT         
                VARYING WS-COUNT-1 FROM 1 BY 1                          
T16852            UNTIL WS-COUNT-1  > MQ-SELECTED-QT.                   
      *                                                                 16060002
           MOVE WS-PARM-TEST-YEAR            TO MQ-TEST-YEAR.           
      *                                                                 16220000
           COMPUTE MQ-SELECTED-QT = WS-COUNT - 1.                       
           PERFORM 8200-UPDATE-MTR-SELECTED      THRU 8200-EXIT.        
      *                                                                 16250000
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16280000
       3200-PROCESS-SAMPLE-METERS.                                      
      *                                                                 16300000
           READ SORTED-RANDOM-FILE                                      
             AT END MOVE WS-Y   TO WS-END-OF-FILE                       
T16852       COMPUTE WS-COUNT-1 = WS-COUNT-1 - 1                        
             GO TO 3200-EXIT                                            
           END-READ.                                                    
      *                                                                 16360000
           COMPUTE  WS-NBR-OF-FETCHES                                   
             =   WS-RANDOM-NBR                    - WS-METER-SEQ        
           PERFORM 3210-FETCH-NEXT-RECORD        THRU 3210-EXIT         
                   VARYING WS-FETCH-ALL-MTRS FROM 1 BY 1                
                   UNTIL WS-FETCH-ALL-MTRS  >    WS-NBR-OF-FETCHES      
                   OR SQLCODE                EQUAL NOT-FOUND.           
T16852     IF WS-NBR-OF-FETCHES NOT = 0 AND SQLCODE = SUCCESSFUL-CALL   
T16852        IF  WS-CALL-SCSCA657 EQUAL WS-Y                           
T16852            MOVE WS-N                     TO WS-CALL-SCSCA657     
T16852        ELSE                                                      
T16852            PERFORM 2300-CALL-SCSCA657            THRU 2300-EXIT  
T16852        END-IF                                                    
           END-IF.                                                      
      *                                                                 16550000
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16580000
       3210-FETCH-NEXT-RECORD.                                          
           PERFORM 7940-FETCH-SAMPLE-SELECT      THRU 7940-EXIT         
           ADD 1                             TO WS-METER-SEQ.           
      *                                                                 16620000
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16650000
       4500-GENERATE-RANDOM-NUM.                                        
      *                                                                 16670000
      * THIS PROGRAM USES A RANDOM NUMBER GENERATOR BASED ON            16680000
      * RECOMMENDATIONS FOUND IN THE BOOK 'RANDOM NUMBER GENERATORS'    16690000
      * COPYRIGHTED BY THE COMPUTATIONAL SCIENCE EDUCATION PROJECT      16700000
      * (FOUND AT INTERNET ADDRESS HTTP://WWW.IAC.TUT.FI/CSEP/RN/RN.HTML16710000
      * 6/10/97). ANDY BOWDEN RECOMMENDED THIS SOURCE.                  16720000
      * SECTION 3.1 APPROACH TO LINEAR CONGRUENTIAL GENERATOR           16730000
      * NEXT RANDOM INTEGER : X(N+1) = (A*X(N) + C) (MOD M)             16740000
      * CORRESPONDING REAL NUMBER: R(N) = X(N) / (M-1) (0<= R(N) <=1)   16750000
      * SECTION 3.4 SUMMARY OF LINEAR CONGRUENTIAL GENERATOR PROPERTIES 16760000
      * RECOMMENDS THE FOLLOWING VALUES :                               16770000
      * M IS THE INTEGER MODULUS = (2**31) - 1 = 2,147,483,647          16780000
      * A IS AN INTEGER CONSTANT = (2**16) + 3 = 16807                  16790000
      * C = 0                                                           16800000
      * M   PIC 9(15)       COMP-3       VALUE 2147483647               16810000
      * A   PIC 9(15)       COMP-3       VALUE 16807                    16820000
      * X   PIC 9(15)       COMP-3                                      16830000
      * R                   COMP-2 (COMP-2 IS DOUBLE PRECISION INTERNAL 16840000
      *                     FLOATING POINT)                             16850000
      * RANDOM-NBR-TEST  PIC 9(7) COMP-3.                               16860000
      * RANDOM-NBR       PIC 9(7) COMP-3 OCCURS 250 TIMES.              16870000
      * MAX-RANDOM-NBR   PIC 9(3) COMP-3 VALUE 250.                     16880000
      *                                                                 16890000
           MOVE WS-SYS-TIME-SEC              TO ISEC                    
           MOVE WS-SYS-TIME-MIN              TO IMIN                    
           MOVE WS-SYS-TIME-HR               TO IHR                     
           MOVE WS-SYS-DATE-DD               TO IDAY                    
           MOVE WS-SYS-DATE-MM               TO IMON                    
           MOVE WS-SYS-DATE-YY               TO IYR                     
      * FOR EACH TEST GROUP GENERATE AN INITIAL SEED AND RANDOM NUMBERS 16960000
      * MQ-RANDOM-SEED = ISEC + 60*(IMIN + 60*(IHR + 24*(IDAY - 1 +     16970000
      * 31*(IMON - 1 + 12*IYR))))                                       16980000
           IF WS-JOB-PARM-4 EQUAL WS-Y       AND                        
           MQ-MTR-TEST-GRP-CD  EQUAL WS-PARM-TEST-GRP-4                 
              MOVE  WS-PARM-INITIAL-SEED     TO WS-RANDOM-SEED          
              MOVE  WS-RANDOM-SEED           TO MQ-INITIAL-RANDM-SEED   
           ELSE                                                         
      * CALCULATE INITIAL SEED USING PREFERRED METHOD IN SECTION 3.2    17040000
      * INITIAL SEED - SEE REFERENCE TO SOURCE FOR RANDOM NUMBER        17050000
      * GENERATORS.                                                     17060000
              COMPUTE WS-RANDOM-SEED = IMON - WS-1 + WS-12 * IYR        
              COMPUTE WS-RANDOM-SEED = IDAY - WS-1 +                    
                                       WS-31 * WS-RANDOM-SEED           
              COMPUTE WS-RANDOM-SEED = IHR +  WS-24 * WS-RANDOM-SEED    
              COMPUTE WS-RANDOM-SEED = IMIN + WS-60 * WS-RANDOM-SEED    
              COMPUTE WS-RANDOM-SEED = ISEC + WS-60 * WS-RANDOM-SEED    
              MOVE WS-RANDOM-SEED            TO MQ-INITIAL-RANDM-SEED   
           END-IF.                                                      
      *ENSURE THAT SEED IS ODD                                          17150000
           DIVIDE MQ-INITIAL-RANDM-SEED      BY 2                       
                                 GIVING     WS-DIV-REMAINDER            
                                 REMAINDER  WS-REMAINDER                
           IF WS-REMAINDER                   EQUAL  0                   
              COMPUTE MQ-INITIAL-RANDM-SEED =                           
                              MQ-INITIAL-RANDM-SEED   + WS-1            
           END-IF                                                       
      *                                                                 17230000
      *ENSURE SAMPLE SIZE IS NOT GREATER THAN SIZE OF RANDOM NUMBER     17240000
      *TABLE.                                                           17250000
           IF WS-NBR-RANDOM-NBRS IS GREATER THAN WS-MAX-RANDOM-NBR      
               DISPLAY '***************PCSCA650**************'          
               DISPLAY '* 4500-GENERATE-RANDOM-NUM          *'          
               DISPLAY '* METER TEST GROUP ', MQ-MTR-TEST-GRP-CD        
               DISPLAY '* EXCEEDS MAXIMUM SAMPLE SIZE OF    *'          
               DISPLAY '* MAX-RANDOM-NBR ', WS-MAX-RANDOM-NBR           
               DISPLAY '* SAMPLE SIZE SET TO "WS-MAX-RANDOM-NBR"*'      
               DISPLAY '***************PCSCA650**************'          
               MOVE WS-MAX-RANDOM-NBR        TO MQ-SELECTED-QT          
                                                WS-NBR-RANDOM-NBRS      
               MOVE WS-Y                     TO WS-MAX-RAN-NUM-REACHED  
           END-IF                                                       
      *                                                                 17390000
      *GENERATE REQUIRED NUMBER OF RANDOM NUMBERS BETWEEN 1 AND         17400000
      *POPULATION SIZE                                                  17410000
           MOVE MQ-INITIAL-RANDM-SEED        TO WS-RANDOM-X             
           OPEN OUTPUT UNSORTED-RANDOM-FILE                             
           IF UNSORTFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'UNSORTED  FILE OPEN ERROR'                       
              DISPLAY 'UNSORTED FILE STATUS IS ===>'                    
                                 WS-UNSORTEDFIL-STATUS                  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
           PERFORM 4510-GEN-UNIQUE-RANDOM-NBR    THRU    4510-EXIT      
              VARYING WS-CTR-I FROM 1 BY 1                              
                  UNTIL WS-CTR-I  >    WS-NBR-RANDOM-NBRS.              
      *                                                                 17550000
           CLOSE  UNSORTED-RANDOM-FILE                                  
           IF UNSORTFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'UNSORTED  FILE CLOSE ERROR'                      
              DISPLAY 'UNSORTED FILE STATUS IS  ===> '                  
                              WS-UNSORTEDFIL-STATUS                     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 17650000
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17680000
       4510-GEN-UNIQUE-RANDOM-NBR.                                      
           PERFORM 4520-GEN-A-RANDOM-NBR         THRU 4520-EXIT         
              UNTIL VALID-RANDOM-NBR  OR  WS-CTR-I  >    249            
              OR    WS-CTR-I   >  WS-NBR-RANDOM-NBRS                    
      *ONLY UNIQUE RANDOM NUMBERS ARE WRITTEN TO FILE                   17730000
           IF INVALID-RANDOM-NBR                                        
              MOVE WS-N                      TO WS-INVALID-RANDOM-NBR   
           ELSE                                                         
              MOVE WS-RANDOM-NBR-TEST        TO                         
                                          WS-RANDOM-NBR-ARRAY(WS-CTR-I) 
              MOVE WS-RANDOM-NBR-TEST        TO UNSORTED-RANDOM-NBR     
              WRITE  UNSORTED-RANDOM-REC                                
           END-IF.                                                      
           MOVE WS-Y                         TO WS-VALID-RANDOM-NBR.    
      *                                                                 17840000
       4510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17870000
       4520-GEN-A-RANDOM-NBR.                                           
           COMPUTE WS-RANDOM-X = WS-RANDOM-A * WS-RANDOM-X              
           DIVIDE WS-RANDOM-X BY WS-RANDOM-M GIVING WS-DIV-RANDOM       
                         REMAINDER WS-REM-RANDOM                        
           MOVE WS-REM-RANDOM                TO WS-RANDOM-X             
           COMPUTE WS-TEMP = WS-RANDOM-M - WS-1                         
           DIVIDE WS-RANDOM-X BY WS-TEMP GIVING WS-RANDOM-R             
           MULTIPLY WS-RANDOM-R BY MQ-INSTALLED-QT  GIVING              
           WS-RANDOM-NBR-TEST ROUNDED                                   
      *CHECK TO SEE IF RANDOM NUMBER IS ALREADY IN TABLE                18010000
           MOVE   1                          TO WS-CTR-J                
           COMPUTE WS-LIMIT = WS-CTR-I  - 1                             
           PERFORM 4530-PROCESS                  THRU 4530-EXIT         
               UNTIL EXIT-LOOP.                                         
           MOVE WS-N                         TO WS-EXIT-LOOP.           
      *                                                                 18080000
       4520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18110000
       4530-PROCESS.                                                    
      *                                                                 18130000
           IF WS-CTR-I                       EQUAL 1                    
              MOVE  WS-Y                     TO WS-EXIT-LOOP            
              MOVE  WS-N                     TO WS-VALID-RANDOM-NBR     
              GO TO 4530-EXIT                                           
           END-IF.                                                      
      *CHECKS IF DUPLICATE RANDOM NUMBER IS GENERATED                   18190000
           IF WS-RANDOM-NBR-ARRAY(WS-CTR-J)  EQUAL WS-RANDOM-NBR-TEST   
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
              MOVE WS-Y                      TO WS-INVALID-RANDOM-NBR   
              MOVE WS-Y                      TO WS-EXIT-LOOP            
              COMPUTE WS-CTR-I = WS-CTR-I - 1                           
              GO TO 4530-EXIT                                           
           END-IF                                                       
           IF WS-PARM-RUN-TYPE  EQUAL WS-ADDITIONAL AND                 
              WS-RANDOM-NBR-TEST  >  WS-CURRENT-INSTALLED-QTY           
              DISPLAY '*******************************************'     
              DISPLAY '* CANNOT HAVE A SEQUENCE NUMBER GREATER   *'     
              DISPLAY '* THAN THE NUMBER OF CURRENTLY INSTALLED  *'     
              DISPLAY '* METERS, WHICH COULD BE LESS THAN THE    *'     
              DISPLAY '* ORIGINAL NUMBER OF INSTALLED METERS.    *'     
              DISPLAY '*******************************************'     
              PERFORM 9000-TERMINATE             THRU 9000-EXIT         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
              MOVE WS-Y                      TO WS-EXIT-LOOP            
           END-IF                                                       
           IF WS-CTR-J                       EQUAL WS-LIMIT             
              MOVE WS-Y                      TO WS-EXIT-LOOP            
              MOVE WS-N                      TO WS-VALID-RANDOM-NBR     
           END-IF.                                                      
           COMPUTE WS-CTR-J = WS-CTR-J + 1.                             
      *                                                                 18450000
       4530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18480000
       5000-UPDATE-PARM.                                                
           PERFORM 8300-OPEN-JOB-PARM            THRU 8300-EXIT         
      *                                                                 18510000
           PERFORM UNTIL NO-REC-FOUND                                   
              PERFORM 8400-FETCH-JOB-PARM        THRU 8400-EXIT         
              IF SQLCODE EQUAL NOT-FOUND                                
                 MOVE WS-Y                   TO WS-NO-REC-FOUND         
              ELSE                                                      
                 PERFORM 8500-UPDATE-JOB-PARM    THRU 8500-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 18600000
           PERFORM 8600-CLOSE-JOB-PARM           THRU 8600-EXIT.        
      *                                                                 18620000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18650000
      ****************************************************************  18660000
      * THIS INCLUDES THE READ ON CSS_JOB_PARM                       *  18670000
      ****************************************************************  18680000
           EXEC SQL                                                     18690000
                INCLUDE CPD00038                                        18700000
           END-EXEC.                                                    18710000
                                                                        
      ****************************************************************  18790000
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *  18800000
      ****************************************************************  18810000
           EXEC SQL                                                     18820000
                INCLUDE CPD00074                                        18830000
           END-EXEC.                                                    18840000
      ****************************************************************  18850000
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *  18860000
      ****************************************************************  18870000
           EXEC SQL                                                     18880000
                INCLUDE CPD00004                                        18890000
           END-EXEC.                                                    18900000
      ****************************************************************  18910000
      * THIS INCLUDES 9700-PROCESS-ABEND                            *   18920000
      ****************************************************************  18930000
           COPY CPD0023C.                                               18940000
T20234*                                                                 18950000
T20234******************************************************************18960000
T20234* 6990-FETCH-CUR-ACCOUNT                                         *18970000
T20234*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *18980000
T20234******************************************************************18990000
T20234     EXEC SQL                                                     19000000
T20234         INCLUDE CPD00099                                         19010000
T20234     END-EXEC.                                                    19020000
T20234*                                                                 19030000
T20234 6995-CPD99-ERROR-ROUTINE.                                        
T20234*                                                                 19050000
T20234     DISPLAY '***************PCSCA650*****************'           
T20234     DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
T20234     DISPLAY '* PREMISE_NO = ', WS-CPD99-PREMISE-NO               
T20234     DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
T20234     DISPLAY '***************PCSCA650*****************'           
T20234     PERFORM 9900-ABEND              THRU 9900-EXIT.              
T20234*                                                                 19120000
T20234 6995-EXIT.                                                       
T20234     EXIT.                                                        
T20234*                                                                 19150000
      ****************************************************************  19160000
       7000-VALIDATE-MTR-TST-GROUP.                                     
      *                                                                 19180000
           EXEC SQL                                                     
              SELECT MTR_TEST_GRP_CD,                                   
                     MTR_TEST_GRP_TX                                    
              INTO :GR-MTR-TEST-GRP-CD,                                 
                   :GR-MTR-TEST-GRP-TX                                  
              FROM CSS_MTR_TEST_GROUP                                   
              WHERE CODE_UTIL_TYPE       = :WS-E                        
              AND   MTR_TEST_GRP_CD      = :GR-MTR-TEST-GRP-CD          
T22243        AND   COMPANY_NO           = :GR-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19290000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSCA650**************'          
               DISPLAY '* 7000-VALIDATE-MTR-TST-GROUP       *'          
               DISPLAY '* ERROR READING CSS_MTR_TEST_GROUP  *'          
               DISPLAY '* MTR TEST GRP ', GR-MTR-TEST-GRP-CD            
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSCA650**************'          
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 19440000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19470000
       7100-SELECT-METER-TEST-HIST.                                     
           EXEC SQL                                                     
               SELECT  CODE_UTIL_TYPE     ,                             
                       SELECTED_QT        ,                             
                       SAMPLE_MIN_QT      ,                             
                       SAMPL_OVERAGE_PCT  ,                             
                       SAMPL_CORRECTV_PCT ,                             
                       SAMPL_ADDITIONL_QT ,                             
C31091                 MTR_TEST_GRP_TX                                  
               INTO                                                     
                       :MQ-CODE-UTIL-TYPE     ,                         
                       :MQ-SELECTED-QT        ,                         
                       :MQ-SAMPLE-MIN-QT      ,                         
                       :MQ-SAMPL-OVERAGE-PCT  ,                         
                       :MQ-SAMPL-CORRECTV-PCT ,                         
                       :MQ-SAMPL-ADDITIONL-QT ,                         
C31091                 :MQ-MTR-TEST-GRP-TX                              
               FROM CSS_MTR_TEST_HIST                                   
               WHERE CODE_UTIL_TYPE      = :WS-E                        
                     AND TEST_YEAR       = :MQ-TEST-YEAR                
                     AND TEST_SCHED_CD   = :WS-R                        
                     AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD          
T22243               AND COMPANY_NO      = :MQ-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19720000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
           OR SQLCODE EQUAL NOT-FOUND                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '***************PCSCA650**********************'  
               DISPLAY '* 7100-SELECT-METER-TEST-HIST               *'  
               DISPLAY '* ERROR READING CSS_MTR_TEST_HIST           *'  
               DISPLAY '* TEST YEAR       IS '     MQ-TEST-YEAR         
               DISPLAY '* TEST SCHED CD   IS '     WS-R                 
               DISPLAY '* MTR TEST GRP CD IS '    MQ-MTR-TEST-GRP-CD    
T22243         DISPLAY '* COMPANY NO      IS '    MQ-COMPANY-NO         
               DISPLAY '* SQLCODE         IS '  WS-DISPLAY-RC           
               DISPLAY '* PROGRAM ABENDING...                       *'  
               DISPLAY '***************PCSCA650**********************'  
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 19910000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19940000
T16852 7200-OPEN-GET-INSTALLED-QTY.                                     
           EXEC SQL                                                     
               OPEN GET-INSTALLED-QTY                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19990000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7200-OPEN-GET-INSTALLED-QTY        *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20120000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20150000
       7210-FETCH-GET-INSTALLED-QTY.                                    
      *                                                                 20170000
           EXEC SQL                                                     
               FETCH GET-INSTALLED-QTY                                  
               INTO :WS-CURRENT-INSTALLED-QTY                           
                   ,:TG-MTR-TEST-GRP-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20230000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7210-FETCH-GET-INSTALLED-QTY       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20360000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20390000
       7220-CLOSE-GET-INSTALLED-QTY.                                    
           EXEC SQL                                                     
               CLOSE GET-INSTALLED-QTY                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20440000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7220-CLOSE-GET-INSTALLED-QTY       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20570000
END    7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20600000
       7300-OPEN-METER-EQUIP-TST.                                       
           EXEC SQL                                                     
               OPEN METER-EQUIP-TEST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20650000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7300-OPEN-METER-EQUIP-TST          *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20780000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20810000
       7310-FETCH-METER-EQUIP-TEST.                                     
      *                                                                 20830000
           EXEC SQL                                                     
               FETCH METER-EQUIP-TEST                                   
               INTO                                                     
               :EM-METER-NO         ,                                   
               :EM-TEST-SCHED-CD    ,                                   
               :EM-METER-SIZE-ID    ,                                   
               :EM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULLIND,       
               :EM-ELEC-MTR-CLASS-CD,                                   
               :EM-ELEC-MTR-SPEC-CD ,                                   
               :EM-METER-SIZE-ID    ,                                   
               :EQ-COMPANY-NO       ,                                   
T16852         :EQ-CODE-CRNT-LOC    ,                                   
T16852         :EQ-CRNT-LOC-NO      ,                                   
               :EQ-CODE-MAKE        ,                                   
               :EQ-LOCAL-OFFICE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21000000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7310-FETCH-METER-EQUIP-TEST        *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 21130000
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21160000
       7320-CLOSE-METER-EQUIP-TST.                                      
           EXEC SQL                                                     
               CLOSE METER-EQUIP-TEST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21210000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7320-CLOSE-METER-EQUIP-TST         *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 21340000
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21370000
       7400-OPEN-ACCOUNT-DETAILS.                                       
           EXEC SQL                                                     
               OPEN ACCOUNT-DETAIL                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21420000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7400-OPEN-ACCOUNT-DETAILS           *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_ACCOUNT     *'        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 21580000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21610000
       7410-FETCH-ACCOUNT-DETAILS.                                      
           EXEC SQL                                                     
               FETCH ACCOUNT-DETAIL                                     
               INTO                                                     
               :UT-ACCOUNT-NO    ,                                      
               :UT-RATE-PLAN-NO  ,                                      
               :UT-READ-ROUTE    ,                                      
               :AT-CODE-ACCT-STAT,                                      
               :AT-ACCT-CREATE-DT,                                      
29312          :UT-READ-CYCLE                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21730000
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
              MOVE SQLCODE            TO WS-DISPLAY-RC                  
              DISPLAY '********** PCSCA650 ABORT *************'         
              DISPLAY '* 7410-FETCH-ACCOUNT-DETAILS          *'         
              DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC              
              DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'         
              DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'         
              DISPLAY '* TABLE               CSS_ACCOUNT     *'         
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA650 ABORT *************'         
              PERFORM 9000-TERMINATE            THRU 9000-EXIT          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 21890000
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21920000
       7420-CLOSE-ACCOUNT-DETAILS.                                      
           EXEC SQL                                                     
               CLOSE ACCOUNT-DETAIL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21970000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7420-CLOSE-ACCOUNT-DETAILS          *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTRD_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_UTIL_ENVRNMT*'        
               DISPLAY '* TABLE               CSS_ACCOUNT     *'        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE            THRU 9000-EXIT         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 22130000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22160000
       7500-GET-LOCAL-OFFICE.                                           
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE                                      
               INTO  :AT-LOCAL-OFFICE                                   
               FROM CSS_ACCOUNT                                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22240000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7500-GET-LOCAL-OFFICE              *'         
               DISPLAY '* SQLCODE IS  ', WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO  ', AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 22380000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22410000
       7601-SELECT-ELEC-METER.                                          
           EXEC SQL                                                     
               SELECT TEST_SCHED_CD        ,                            
                      METER_SIZE_ID        ,                            
                      DATE_LAST_TESTED     ,                            
                      ELEC_MTR_SPEC_CD     ,                            
                      ELEC_MTR_CLASS_CD                                 
               INTO   :EM-TEST-SCHED-CD    ,                            
                      :EM-METER-SIZE-ID    ,                            
                      :EM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-NULLIND,
                      :EM-ELEC-MTR-SPEC-CD ,                            
                      :EM-ELEC-MTR-CLASS-CD                             
               FROM CSS_ELEC_METER                                      
               WHERE CODE_UTIL_TYPE   = :WS-E                           
               AND   METER_NO         = :EM-METER-NO                    
T22243         AND   COMPANY_NO       = :EM-COMPANY-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22590000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7601-SELECT-ELEC-METER              *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_ELEC_METER  *'        
               DISPLAY '* CODE  UTIL TYPE  ', WS-E                      
               DISPLAY '* METER NO         ', EM-METER-NO               
T22243         DISPLAY '* COMPANY NO       ', EM-COMPANY-NO             
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 22760000
       7601-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22790000
       7700-SELECT-MTR-CAP-CONSTANT.                                    
      *                                                                 22810000
           EXEC SQL                                                     
                SELECT CONSTANT                                         
                INTO   :MC-CONSTANT                                     
                FROM   CSS_MTR_CAP                                      
                WHERE  CODE_UTIL_TYPE = :WS-E                           
                AND    METER_NO       = :MC-METER-NO                    
                AND    REG_ID_NO      = :MC-REG-ID-NO                   
T22243          AND    COMPANY_NO     = :MC-COMPANY-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22910000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7700-SELECT-MTR-CAP-CONSTANT       *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* METER NO IS ', MC-METER-NO                    
T22243         DISPLAY '* COMPANY NO       ', MC-COMPANY-NO             
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 23060000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23090000
       7800-OPEN-SAMPLE-TEST-HIST.                                      
           EXEC SQL                                                     
               OPEN SAMPLE-TEST-HIST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23140000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7800-OPEN-SAMPLE-TEST-HIST          *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE          -    CSS_MTR_TEST_HIST*'       
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 23310000
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23340000
       7810-FETCH-SAMPLE-TEST-HIST.                                     
           EXEC SQL                                                     
               FETCH SAMPLE-TEST-HIST                                   
               INTO                                                     
               :MQ-MTR-TEST-GRP-CD      ,                               
               :MQ-CODE-UTIL-TYPE       ,                               
               :MQ-SAMPLE-MIN-QT        ,                               
               :MQ-SAMPL-OVERAGE-PCT    ,                               
               :MQ-SAMPL-CORRECTV-PCT   ,                               
               :MQ-SAMPL-ADDITIONL-QT   ,                               
               :MQ-MTR-TEST-GRP-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23470000
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7810-FETCH-SAMPLE-TEST-HIST         *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE            '                            
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 23640000
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23670000
       7820-CLOSE-SAMPLE-TEST-HIST.                                     
           EXEC SQL                                                     
               CLOSE SAMPLE-TEST-HIST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23720000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT ***************'      
               DISPLAY '* 7820-CLOSE-SAMPLE-TEST-HIST           *'      
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_MTR_TEST_HIST *'      
               DISPLAY '* TEST SCHED CD    ', WS-R                      
               DISPLAY '* TEST YEAR        ', WS-DB2-YEAR               
               DISPLAY '* LAST_TEST_SEL_DT NULL'                        
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA650 ABORT ***************'      
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 23890000
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23920000
       7930-OPEN-SAMPLE-SELECT.                                         
           EXEC SQL                                                     
               OPEN SAMPLE-SELECT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23970000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7930-OPEN-SAMPLE-SELECT             *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_ELEC_METER    *'      
               DISPLAY '* TABLE               CSS_EQUIPMENT     *'      
               DISPLAY '* TABLE               CSS_ELEC_TST_GROUP*'      
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 24130000
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24160000
       7940-FETCH-SAMPLE-SELECT.                                        
           EXEC SQL                                                     
               FETCH SAMPLE-SELECT                                      
               INTO  :EM-METER-NO                                       
T16852              ,:EQ-CODE-CRNT-LOC                                  
T16852              ,:EQ-CRNT-LOC-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24240000
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7940-FETCH-SAMPLE-SELECT            *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_ELEC_METER    *'      
               DISPLAY '* TABLE               CSS_EQUIPMENT     *'      
               DISPLAY '* TABLE               CSS_ELEC_TST_GROUP*'      
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 24400000
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24430000
       7950-CLOSE-SAMPLE-SELECT.                                        
           EXEC SQL                                                     
               CLOSE SAMPLE-SELECT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24480000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA650 ABORT *************'        
               DISPLAY '* 7950-CLOSE-SAMPLE-SELECT            *'        
               DISPLAY '* SQLCODE IS       ', WS-DISPLAY-RC             
               DISPLAY '* TABLE               CSS_ELEC_METER    *'      
               DISPLAY '* TABLE               CSS_EQUIPMENT     *'      
               DISPLAY '* TABLE               CSS_ELEC_TST_GROUP*'      
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA650 ABORT *************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 24640000
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24670000
       7960-SELECT-EQUIP-DETAILS.                                       
      *                                                                 24690000
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
                      CODE_MAKE                                         
               INTO  :EQ-COMPANY-NO,                                    
                     :EQ-CODE-MAKE                                      
               FROM CSS_EQUIPMENT                                       
               WHERE CODE_UTIL_TYPE = :WS-E                             
               AND   DEVICE_NO      = :EQ-DEVICE-NO                     
T22243         AND   COMPANY_NO     = :EQ-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24800000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 7960-SELECT-EQUIP-DETAILS           *'        
               DISPLAY '* TABLE    :         CSS_EQUIPMENT    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
               DISPLAY '* METER NUMBER IS ', EQ-DEVICE-NO               
T22243         DISPLAY '* COMPANY NO   IS ', EQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 24970000
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25000000
T16852***************************************************************** 25010000
ST    *SELECT METER-NO TO WHICH THE METER IS ATTACHED                 * 25020000
      ***************************************************************** 25030000
       7965-GET-MTR-NO-ATTCHED-TO.                                      
      *                                                                 25050000
           EXEC SQL                                                     
                SELECT  METER_NO                                        
                  INTO :MA-METER-NO                                     
                  FROM  CSS_METER_ATTCHMTS                              
                 WHERE  CODE_UTIL_TYPE   = :WS-E                        
                   AND  DEVICE_NO        = :MA-DEVICE-NO                
                   AND  CODE_DEVICE_TYPE = :WS-M                        
T22243             AND  COMPANY_NO       = :MA-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25150000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSCA650 ABORT ************'         
               DISPLAY '* 7965-GET-MTR-NO-ATTCHED-TO         *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* METER NO IS ', MA-DEVICE-NO                   
T22243         DISPLAY '* COMPANY NO IS ', MA-COMPANY-NO                
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '********** PCSCA650 ABORT ************'         
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 25310000
       7965-EXIT.                                                       
END        EXIT.                                                        
T16852*                                                                 25340000
       8000-UPDATE-ELEC-METER.                                          
           EXEC SQL                                                     
               UPDATE CSS_ELEC_METER                                    
               SET LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
                   LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD               
               WHERE CODE_UTIL_TYPE = :WS-E                             
               AND   METER_NO       = :EM-METER-NO                      
T22243         AND   COMPANY_NO     = :EM-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     25360000
MFA-TR*        UPDATE CSS_ELEC_METER                                    25370000
MFA-TR*        SET LAST_TEST_SEL_DT = CURRENT DATE,                     25380000
MFA-TR*            LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD               25390000
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-E                             25400000
MFA-TR*        AND   METER_NO       = :EM-METER-NO                      25410000
MFA-TR*        AND   COMPANY_NO     = :EM-COMPANY-NO                    25420000
MFA-TR*    END-EXEC.                                                    25430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25440000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8000-UPDATE-ELEC-METER              *'        
               DISPLAY '* ERROR UPDATING CSS_ELEC_METER       *'        
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
               DISPLAY '* METER NUMBER IS ', EM-METER-NO                
T22243         DISPLAY '* COMPANY-NO   IS ', EM-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 25610000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25640000
       8100-UPDATE-MTR-TEST-HIST.                                       
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
               SET SAMPL_ADDITIONL_QT   = :MQ-SAMPL-ADDITIONL-QT,       
                   SELECTED_QT          = :MQ-SELECTED-QT               
               WHERE CODE_UTIL_TYPE     = :MQ-CODE-UTIL-TYPE            
               AND   TEST_YEAR          = :MQ-TEST-YEAR                 
               AND   TEST_SCHED_CD      = :WS-R                         
               AND   MTR_TEST_GRP_CD    = :MQ-MTR-TEST-GRP-CD           
T22243         AND   COMPANY_NO         = :MQ-COMPANY-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25760000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8100-UPDATE-MTR-TEST-HIST           *'        
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
               DISPLAY '* TEST_YEAR       ', MQ-TEST-YEAR               
               DISPLAY '* TEST_SCHED_CD   ', MQ-TEST-SCHED-CD           
               DISPLAY '* MTR_TEST_GRP_CD ', MQ-MTR-TEST-GRP-CD         
T22243         DISPLAY '* COMPANY_NO      ', MQ-COMPANY-NO              
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 25950000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25980000
       8200-UPDATE-MTR-SELECTED.                                        
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
T16852         SET INSTALLED_QT  = :MQ-INSTALLED-QT,                    
T16852             SELECTED_QT   = :MQ-SELECTED-QT,                     
                   SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                   
                   LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
ACT194             STATUS_CD     = 'B'                                  
               WHERE CODE_UTIL_TYPE = :WS-E                             
               AND   TEST_YEAR      = :MQ-TEST-YEAR                     
               AND   TEST_SCHED_CD  = :WS-R                             
               AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
T22243         AND   COMPANY_NO      = :MQ-COMPANY-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     26000000
MFA-TR*        UPDATE CSS_MTR_TEST_HIST                                 26010000
MFA-TR*        SET INSTALLED_QT  = :MQ-INSTALLED-QT,                    26020000
MFA-TR*            SELECTED_QT   = :MQ-SELECTED-QT,                     26030000
MFA-TR*            SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                   26040000
MFA-TR*            LAST_TEST_SEL_DT = CURRENT DATE,                     26050000
MFA-TR*            STATUS_CD     = 'B'                                  26060000
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-E                             26070000
MFA-TR*        AND   TEST_YEAR      = :MQ-TEST-YEAR                     26080000
MFA-TR*        AND   TEST_SCHED_CD  = :WS-R                             26090000
MFA-TR*        AND   MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              26100000
MFA-TR*        AND   COMPANY_NO      = :MQ-COMPANY-NO                   26110000
MFA-TR*    END-EXEC.                                                    26120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26130000
           IF SQLCODE EQUAL  SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8200-UPDATE-MTR-SELECTED            *'        
               DISPLAY '* ERROR UPDATING CSS_MTR_TEST_HIST    *'        
               DISPLAY '* UTIL TYPE IS    ', WS-E                       
               DISPLAY '* TEST_YEAR       ', WS-DB2-YEAR                
               DISPLAY '* TEST_SCHED_CD   ', WS-R                       
               DISPLAY '* MTR_TEST_GRP_CD  ', MQ-MTR-TEST-GRP-CD        
T22243         DISPLAY '* COMPANY_NO       ', MQ-COMPANY-NO             
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 26320000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26350000
       8300-OPEN-JOB-PARM.                                              
           EXEC SQL                                                     
               OPEN JOB-PARM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26400000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8300-OPEN-JOB-PARM                  *'        
               DISPLAY '* ERROR IN OPEN OF CSS_JOB_PARM       *'        
               DISPLAY '* FOR UPDATE.                         *'        
               DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
               DISPLAY '* CMP NO 01       '                             
               DISPLAY '* CMND_CODE       ', WS-PARM                    
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 26580000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26610000
       8400-FETCH-JOB-PARM.                                             
           EXEC SQL                                                     
               FETCH JOB-PARM                                           
               INTO :G6-STATUS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26670000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8400-FETCH-JOB-PARMM                *'        
               DISPLAY '* ERROR IN FETCH OF CSS_JOB_PARM      *'        
               DISPLAY '* FOR UPDATE.                         *'        
               DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
               DISPLAY '* CMP NO 01       '                             
               DISPLAY '* CMND_CODE       ', WS-PARM                    
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
      *                                                                 26860000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26890000
       8500-UPDATE-JOB-PARM.                                            
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
               SET STATUS = :WS-I                                       
               WHERE CURRENT OF JOB-PARM                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26960000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8500-UPDATE-JOB-PARM                *'        
               DISPLAY '* ERROR UPDATING CSS_JOB_PARM         *'        
               DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
               DISPLAY '* CMP NO 01       '                             
               DISPLAY '* CMND_CODE       ', WS-PARM                    
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 27130000
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27160000
       8600-CLOSE-JOB-PARM.                                             
           EXEC SQL                                                     
               CLOSE JOB-PARM                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27210000
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*************PCSCA650******************'        
               DISPLAY '* 8600-CLOSE-JOB-PARM                 *'        
               DISPLAY '* ERROR IN CLOSE OF CSS_JOB_PARM      *'        
               DISPLAY '* DURING UPDATE .                     *'        
               DISPLAY '* PROGRAM NAME    ', WS-PGRMNAME                
               DISPLAY '* CMP NO 01       '                             
               DISPLAY '* CMND_CODE       ', WS-PARM                    
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                 *'        
               DISPLAY '*************PCSCA650******************'        
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 27390000
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27420000
       9000-TERMINATE.                                                  
      *                                                                 27440000
           MOVE WS-WRITE-CNT TO WS-WRITE-FORMAT.                        
           DISPLAY '** NUMBER OF RECORDS WRITTEN = '                    
              WS-WRITE-FORMAT ' **'.                                    
           IF WS-WRITE-CNT = 0                                          
              MOVE 4 TO RETURN-CODE                                     
           END-IF.                                                      
                                                                        
           IF WS-PARM-RUN-TYPE    EQUAL WS-SELECT OR                    
              WS-PARM-RUN-TYPE    EQUAL WS-FORECAST                     
              CLOSE POPULATION-SAMPLE-FILE                              
      *                                                                 27550000
              IF  SAMPFIL-SUCCESS                                       
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY 'FCSMT13  FILE CLOSE ERROR'                   
                  DISPLAY 'FCSMT13 FILE STATUS ==>' WS-SAMPFIL-STATUS   
              END-IF                                                    
           END-IF                                                       
      *                                                                 27630000
           IF WS-PARM-RUN-TYPE    EQUAL WS-SELECT OR                    
              WS-PARM-RUN-TYPE    EQUAL WS-ADDITIONAL                   
              CLOSE METER-DETAIL-FILE                                   
      *                                                                 27670000
              IF  METFIL-SUCCESS                                        
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY 'FIOCA65  FILE CLOSE ERROR'                   
                  DISPLAY 'FIOCA65  FILE STATUS  ==>' WS-METFIL-STATUS  
              END-IF                                                    
           END-IF.                                                      
      *                                                                 27750000
      *BEGIN - LINES TO BE DELETED                                      27760000
           CLOSE  RANDOM-NBR-FILE                                       
           IF RANDOMFIL-SUCCESS                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'RANDOMFIL  FILE CLOSE ERROR'                     
              DISPLAY 'RANDOMFIL FILE STATUS IS  ===> '                 
                              WS-RANDOMFIL-STATUS                       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *END   - LINES TO BE DELETED                                      27860000
      * DUMMY PARA FOR ADDR FORMATTING ROUTINES                         27870000
       9000-SEND-ERROR-RESULT.                                          
T16852*                                                                 27890000
       9000-EXIT.                                                       
           EXIT.                                                        
      *DUMMY PARA FOR ADDR FORMATTING ROUTINES - EXECUTES 9900-ABEND    27920000
       9900-SQL-ERROR-ROUTINE.                                          
      ******************************************************************27940000
      *     9900-ABEND                                                 *27950000
      *                                                                *27960000
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *27970000
      ******************************************************************27980000
      *                                                                 27990000
       9900-ABEND.                                                      
      *                                                                 28010000
           DISPLAY 'PERFORMING 9900-ABEND'.                             
      *                                                                 28030000
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                      

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

                                                                        
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
                                                                        
           IF WS-ABEND-YES                                              
               STOP RUN                                                 
           END-IF.                                                      
      *                                                                 28160000
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28190000
