       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA645.                                        
       DATE-WRITTEN.   JANUARY 2016.                                    
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
ACT116** 04-07-16   BD09555        UPDATE LENGTH WHEN WORK DISTRICT **          
ACT116**A05460-ACT116              CHANGES                                      
ACT212** 07-06-16   BD09555        UPDATE GAS LEAK WHEN GREATER THAN**          
ACT212**A05460-ACT212              ZERO INSTEAD OF SPACES           **          
ACT253**A05460-ACT253              REMOVE INCORRECT UPDATE OF COUNTY            
ACT253**                           CODE                                         
ACT253**A05460-ACT253              DON'T UPDATE LEAK SURVEY FREQ IF             
ACT253**                           IT IS 55, 66, 77, OR 88.                     
ACT280** 09-09-16   BD09555        VERIFY REVENUE DISTRICT CHANGES  **          
ACT280**A05460-ACT280              BEFORE CHANGING.   ADD TO TABLE  **          
ACT291**A05460-ACT291              CORRECT RESTART ROW LOGIC        **          
ACT291** 10-05-16   BD09555                                         **          
ACT375**A05460-ACT375              UPDATE PREMISE LAT/LONG          **          
ACT375** 10-05-16   BD09555                                         **          
ACT390**A05460-ACT390              LOAD NEW REVENUE DISTRICT TO     **          
ACT390** 12-22-16   BD09555        CPD0037F PARM; PROCESS LOCAL     **          
ACT390** 12-22-16   BD09555        OFFICE UPDATES FOR COMPANY 01    **          
ACT398** 12-28-16   BD09555        INITIALIZE DELINQUENCY VALUE     **          
ACT398** 12-28-16   BD09555        BEFORE CALLING CPD0037F MODULES. **          
ACT021** 12-22-16   BD09555        VALIDATE CSS_ZIPCODE_LO_RT FOR   **          
ACT021** A05744-ACT021             REVENUE DISTRICT CHANGES         **          
ACT021** 02-08-17   BD09555        DISPLAY RECORD BEING PROCESSED   **          
ACT021** A05744-ACT021             AND INCREMENT UPDATE COUNTER ONLY**          
ACT021** A05744-ACT021             IF THERE WAS AN UPDATE.  FETCH   **          
ACT021** A05744-ACT021             FIRST ROW ONLY ON CSS_MTRD_ENV   **          
ACT021** A05744-ACT021             IN CASE THERE ARE DUPLICATE METER**          
ACT021** A05744-ACT021             NUMBERS.                         **          
ACT040** 02-23-17   BD09555        NO LONGER NEED TO UPDATE LAT/LONG**          
ACT040** A05744-ACT040             ON CSS_MTRD_ENVRNMT.  MAKE SURE  **          
ACT040** A05744-ACT040             ROUTE CHANGE SHOWS UP IN TRANS   **          
ACT040** A05744-ACT040             HISTORY                          **          
ACT040** 03-02-17   BD09555        SHOW CORRECT OLD READ ROUTE ON   **          
ACT040** A05744-ACT040             TRANS HISTORY.  ELIMINATE UNNEDED**          
ACT040** A05744-ACT040             LAT/LONG UPDATES IN TRANS HIST.  **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSCA645 NARRATIVE                        
           THIS PROGRAM UPDATES:                                        
             CSS_MTRD_ENVRNT: LATITUDE AND LONGITUDE                    
             CSS_PREMISE:     REVENUE DISTRICT                          
                              LOCAL OFFICE                              
                              SUBDIVISION ID                            
                              GAS LEAK SURVEY FREQUENCY                 
                              COUNTY CODE                               
                              ELECTRIC SERVICE WORK DISTRICT            
                              GAS OPERATIONS WORK DISTRICT              
                              FIELD SERVICES WORK DISTRICT              
                              REVENUE PROTECTION WORK DISTRICT          
                              DSM WORK DISTRICT                         
                                                                        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
           SELECT FCSCA645 ASSIGN TO UT-S-FCSCA645.                     
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       FD  FCSCA645                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
       01  FILLER                     PIC X(452).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA645'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME                PIC X(8)    VALUE 'PCSCA645'.    
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                           PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-ZIP-CODE             PIC X(5)    VALUE SPACES.        
           05  WS-COMPARE-ACCT         PIC 9(13)   VALUE 0.             
           05  WS-ACTIVE-RETURN-CODE   PIC S9(9)   VALUE +0.            
           05  WS-READ-ROUTE-ALPHA     PIC X(5).                        
           05  WS-READ-ROUTE-NUM REDEFINES WS-READ-ROUTE-ALPHA          
                                       PIC 99999.                       
           05  WS-READ-ROUTE-DISP      PIC ZZZZ9.                       
           05  WS-NEW-ROUTE            PIC S9(4)   COMP.                
           05  WS-SCEG-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-PSNC-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-CATEGORY-ID-362      PIC S9(4)   VALUE 362 COMP.      
           05  WS-DEVICE-NO            PIC X(9)    VALUE SPACES.        
           05  WS-METER-NO             PIC X(9)    VALUE SPACES.        
           05  SUCCESSFUL-CALL         PIC S9(9)   VALUE +0   COMP.     
           05  NOT-FOUND               PIC S9(9)   VALUE +100 COMP.     
           05  I                       PIC S9(4)   VALUE +0   COMP.     
           05  J                       PIC S9(4)   VALUE +0   COMP.     
           05  K                       PIC S9(4)   VALUE +0   COMP.     
           05  WS-RATE-ITEM-CODE       PIC S9(4)   VALUE +0   COMP.     
           05  WS-RETURN-CODE          PIC S9(4)   VALUE +0   COMP.     
           05  WS-DIST-GROUP-LEN       PIC S9(4)   VALUE +40  COMP.     
           05  WS-MAX-LEN              PIC S9(4)   VALUE +40  COMP.     
           05  WS-LENGTH               PIC S9(4)   VALUE +40  COMP.     
           05  WS-811                  PIC S9(9)   VALUE -811 COMP.     
           05  WS-803                  PIC S9(9)   VALUE -803 COMP.     
           05  WS-PREV-PREMISE-NO      PIC 9(10)   VALUE 0.             
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSCA645'.    
           05  WS-EXP-COUNT            PIC S9(3)   VALUE 0 COMP-3.      
           05  WS-DETAIL-COUNT         PIC 9(7)    VALUE 0.             
           05  WS-WORK-DIST            PIC X(60)   VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.        
           05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CHECK-DATE           PIC X(10)   VALUE SPACES.        
           05  WS-RECORD-STATUS        PIC X(04)   VALUE SPACES.        
           05  WS-REVENUE-DISTRICT     PIC XXX.                         
           05  WS-OLD-REVENUE-DIST     PIC X(35)   VALUE SPACES.        
           05  WS-NEW-REVENUE-DIST     PIC X(35)   VALUE SPACES.        
           05  WS-LOCAL-OFFICE         PIC XXX.                         
           05  WS-OLD-LOC-OFFICE       PIC X(35)   VALUE SPACES.        
           05  WS-NEW-LOC-OFFICE       PIC X(35)   VALUE SPACES.        
           05  WS-COUNTY               PIC X(03)   VALUE SPACES.        
           05  WS-OLD-COUNTY           PIC X(22)   VALUE SPACES.        
           05  WS-NEW-COUNTY           PIC X(22)   VALUE SPACES.        
           05  WS-SUBDIVISION          PIC XXX.                         
           05  WS-OLD-SUBDIVISION      PIC X(35)   VALUE SPACES.        
           05  WS-NEW-SUBDIVISION      PIC X(35)   VALUE SPACES.        
           05  WS-MTR-NO               PIC X(9).                        
           05  WS-METER-NO-JUSTIFIED   PIC X(9) JUSTIFIED RIGHT.        
           05  WS-INSPECT-CNTR         PIC 99      VALUE ZERO.          
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-PREMISE-NO           PIC S9(10)V VALUE 0 COMP-3.      
           05  WS-LAST-PREMISE-UPDATED PIC S9(10)V VALUE 0 COMP-3.      
           05  WS-LINE-COUNT           PIC S9(3)   VALUE +66 COMP-3.    
           05  WS-PAGE-COUNT           PIC S9(3)   VALUE 0 COMP-3.      
           05  WS-MTRP-TEXT-LEN        PIC S9(4)   VALUE +38 COMP.      
           05  WS-MTRP-TEXT            PIC X(38)   VALUE                
            'UPDATE VIA READONE LINK TOHOST PROCESS'.                   
           05  WS-TOTAL-MTRP-CHG       PIC S9(5)   VALUE 0 COMP-3.      
           05  RS-RETURN-CODE-037      PIC S9(4)   VALUE +0 COMP.       
           05  PARM-REV-DISTRICT-CD-037 PIC XXX.                        
      *                                                                         
           05  WS-SWITCHES.                                             
               10  WS-EOF-FLAG         PIC X    VALUE 'N'.              
                   88  END-OF-FILE              VALUE 'Y'.              
               10  WS-ZIP-SUB-FLAG     PIC X    VALUE 'N'.              
                   88  NO-SUBDIVISION           VALUE 'N'.              
                   88  GOOD-SUBDIVISION         VALUE 'Y'.              
               10  WS-LOC-OFFICE-FLAG  PIC X    VALUE 'N'.              
                   88  NO-LOCAL-OFFICE          VALUE 'N'.              
               10  WS-FCA645-STATUS    PIC XX.                          
                   88  FCA645-SUCCESSFUL        VALUE '00'.             
               10  WS-FCA33-STATUS     PIC XX.                          
                   88  FCA33-SUCCESSFUL         VALUE '00'.             
               10  WS-UPDATE-METER-ENV PIC X(1)    VALUE SPACES.        
                   88  UPDATE-METER-ENV         VALUE 'Y'.              
               10  WS-UPDATE-PREMISE   PIC X(1)    VALUE SPACES.        
                   88  UPDATE-PREMISE           VALUE 'Y'.              
               10  WS-LEAK-CODE              PIC XX.                    
                   88  IN-OFF-LIMITS-LIST     VALUE '55' '66' '77' '88'.
           05  PARM-ACCOUNT-NO                  PIC X(13).              
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                                PIC 9(13).              
           05  PARM-PREMISE-NO                  PIC X(10).              
           05  PARM-PREMISE-NO-NUM REDEFINES PARM-PREMISE-NO            
                                                PIC 9(10).              
           05  PARM-RATE-ITEM-CODE              PIC X(4).               
           05  PARM-RATE-ITEM-CODE-NUM REDEFINES PARM-RATE-ITEM-CODE    
                                                PIC 9(4).               
           05  PARM-USER-ID                     PIC X(7).               
           05  PARM-DATE-PLAN-START             PIC X(10).              
      *                                                                         
       01  WS-MIN-LATITUDE-MN           PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MAX-LATITUDE-MN           PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MIN-LONGITUDE-MN          PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MAX-LONGITUDE-MN          PIC S9(3)V9(6) COMP-3 VALUE 0.  
ACT375 01  WS-NEW-LATITUDE              PIC S9(3)V9(6) COMP-3 VALUE 0.  
ACT375 01  WS-NEW-LONGITUDE             PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-PREV-LAT                  PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-PREV-LONG                 PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-PREV-LAT-EDITED           PIC ZZ9.999999.                 
       01  WS-PREV-LONG-EDITED          PIC -Z9.999999.                 
      *                                                                         
       01  WS-LONG                      PIC 9(2)V9(9).                  
       01  WS-LONG-AN REDEFINES WS-LONG PIC X(11).                      
       01  WS-LONG-CHECK                PIC 9(3)V9(6)  VALUE ZEROS.     
      *                                                                         
A37741 01 S-RETURN-CODE                 PIC S9(9) VALUE 0.              
      *                                                                         
       01 WS-UPDATE-BY-PREMISE         PIC X       VALUE 'N'.           
           88  UPDATING-BY-METER                   VALUE 'N'.           
           88  UPDATING-BY-PREMISE                 VALUE 'Y'.           
      *                                                                         
       01 WS-WORK-PARM.                                                 
          05 WS-PARM-PROGRAM           PIC X(8)    VALUE 'PCSCA645'.    
          05 WS-PARM-COMPANY           PIC XX      VALUE SPACES.        
          05 WS-PARM-CMND-CODE         PIC X(4)    VALUE 'PARM'.        
      *                                                                         
       01 WS-PARM-MIN-MAX.                                              
          05 WS-PARM-COMPANY-LITERAL   PIC X(3).                        
          05 WS-PARM-COMPANY-NO        PIC XX.                          
          05 FILLER                    PIC X.                           
          05 WS-PARM-MINIMUM-LITERAL   PIC X(8).                        
          05 WS-PARM-MINIMUM.                                           
             10 WS-PARM-MIN-SIGN       PIC X.                           
             10 WS-PARM-MIN1           PIC XX.                          
             10 WS-PARM-MIN-DOT        PIC X.                           
             10 WS-PARM-MIN2           PIC X(6).                        
          05 FILLER                    PIC X.                           
          05 WS-PARM-MAXIMUM-LITERAL   PIC X(8).                        
          05 WS-PARM-MAXIMUM.                                           
             10 WS-PARM-MAX-SIGN       PIC X.                           
             10 WS-PARM-MAX1           PIC XX.                          
             10 WS-PARM-MAX-DOT        PIC X.                           
             10 WS-PARM-MAX2           PIC X(6).                        
          05 FILLER                    PIC X(37).                       
      *                                                                         
       01 WS-LATITUDE-MIN-MAX.                                          
          05 WS-MIN-LATITUDE.                                           
             10 WS-LAT-MIN-SIGN       PIC X.                            
             10 WS-LAT-MIN1           PIC XX.                           
             10 WS-LAT-MIN-DOT        PIC X.                            
             10 WS-LAT-MIN2           PIC X(6).                         
          05 WS-MAX-LATITUDE.                                           
             10 WS-LAT-MAX-SIGN       PIC X.                            
             10 WS-LAT-MAX1           PIC XX.                           
             10 WS-LAT-MAX-DOT        PIC X.                            
             10 WS-LAT-MAX2           PIC X(6).                         
      *                                                                         
       01 WS-LONGITUDE-MIN-MAX.                                         
          05 WS-MIN-LONGITUDE.                                          
             10 WS-LON-MIN-SIGN       PIC X.                            
             10 WS-LON-MIN1           PIC XX.                           
             10 WS-LON-MIN-DOT        PIC X.                            
             10 WS-LON-MIN2           PIC X(6).                         
          05 WS-MAX-LONGITUDE.                                          
             10 WS-LON-MAX-SIGN       PIC X.                            
             10 WS-LON-MAX1           PIC XX.                           
             10 WS-LON-MAX-DOT        PIC X.                            
             10 WS-LON-MAX2           PIC X(6).                         
      *                                                                         
      *                                                                         
       01  WS-EXCEPTION-MESSAGES.                                       
           05 WS-MSG-1                PIC X(47)                         
              VALUE 'ACCOUNT NUMBER AND METER NUMBER ARE INVALID    '.  
           05 WS-MSG-2                PIC X(47)                         
              VALUE 'INVALID LATITUDE AND/OR LONGITUDE NUMBERS      '.  
           05 WS-MSG-3                PIC X(47)                         
              VALUE 'INVALID DATE COLLECTED                         '.  
           05 WS-MSG-4                PIC X(47)                         
              VALUE 'ALL ATTEMPTS TO GET MOST RECENT ACCOUNT FAILED '.  
           05 WS-MSG-5                PIC X(47)                         
              VALUE 'LONGITUDE FIELD MUST BE A NEGATIVE NUMBER      '.  
           05 WS-MSG-6                PIC X(47)                         
              VALUE 'LATITUDE AND/OR LONGITUDE OUT OF PARM RANGE    '.  
           05 WS-MSG-7                PIC X(47)                         
              VALUE 'ACCOUNT NUMBER NOT FOUND ON METER ENVIRONMENT  '.  
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-NEGATIVE                 PIC X      VALUE '-'.        
           05  WS-YES                      PIC X      VALUE 'Y'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-I                        PIC X(01)  VALUE 'I'.        
           05  WS-NO                       PIC X      VALUE 'N'.        
           05  WS-M                        PIC X      VALUE 'M'.        
           05  WS-DOT                      PIC X      VALUE '.'.        
           05  WS-19-CENTURY               PIC 99     VALUE  19.        
           05  WS-20-CENTURY               PIC 99     VALUE  20.        
           05  WS-SCEG                     PIC X(26)                    
               VALUE '   S C ELECTRIC AND GAS CO'.                      
           05  WS-PSNC                 PIC X(26)                        
               VALUE '       PSNC ENERGY        '.                      
      *                                                                         
       01  WS-WHO-CARES-DATE           PIC X(10).                       
      *                                                                         
      *--------------------------------------------------------------*          
      *   HEADERS FOR THE EXCEPTION REPORT.                          *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 HEADER1.                                                      
          05 FILLER           PIC X     VALUE SPACES.                   
          05 FILLER           PIC X(11) VALUE 'PCSCA645-01'.            
          05 FILLER           PIC X(41) VALUE SPACES.                   
          05 WS-COMPANY-NAME  PIC X(26) VALUE SPACES.                   
          05 FILLER           PIC X(22) VALUE SPACES.                   
          05 FILLER           PIC X(10) VALUE 'RUN DATE: '.             
          05 HDR-DATE         PIC X(10) VALUE SPACES.                   
          05 FILLER           PIC X     VALUE SPACES.                   
          05 FILLER           PIC X(7)  VALUE 'PAGE = '.                
          05 HDR-PAGE         PIC ZZ9.                                  
          05 FILLER           PIC X     VALUE SPACES.                   
      *                                                                         
       01 HEADER2.                                                      
          05 FILLER           PIC X(51) VALUE SPACES.                   
          05 FILLER           PIC X(33) VALUE                           
             'GIS DATA POSTING EXCEPTION REPORT'.                       
          05 FILLER           PIC X(49)  VALUE SPACES.                  
      *                                                                         
       01 HEADER2B.                                                     
          05 FILLER           PIC X(40) VALUE SPACES.                   
          05 FILLER           PIC X(55) VALUE                           
             'GIS DATA POSTING EXCEPTION REPORT - DATAWAREHOUSE LOAD'.  
          05 FILLER           PIC X(38)  VALUE SPACES.                  
      *                                                                         
       01 HEADER3.                                                      
          05 FILLER           PIC X(19) VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'UTL'.                    
          05 FILLER           PIC X(16) VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'GIS'.                    
          05 FILLER           PIC X(33) VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'TECH'.                   
          05 FILLER           PIC X(6)  VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'DATE'.                   
          05 FILLER           PIC X(45) VALUE SPACES.                   
      *                                                                         
       01 HEADER4.                                                      
          05 FILLER           PIC X(4)  VALUE SPACES.                   
          05 FILLER           PIC X(10) VALUE 'ACCOUNT NO'.             
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'TYP'.                    
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(8)  VALUE 'METER NO'.               
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'SRCE'.                   
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(8)  VALUE 'LATITUDE'.               
          05 FILLER           PIC X(6)  VALUE SPACES.                   
          05 FILLER           PIC X(9)  VALUE 'LONGITUDE'.              
          05 FILLER           PIC X(7)  VALUE SPACES.                   
          05 FILLER           PIC XX    VALUE 'ID'.                     
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(9)  VALUE 'COLLECTED'.              
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(15) VALUE 'PREMISE ADDRESS'.        
          05 FILLER           PIC X(22)                                 
             VALUE '/EXCEPTION DESCRIPTION'.                            
          05 FILLER           PIC XX    VALUE SPACES.                   
      *                                                                         
      *--------------------------------------------------------------*          
      *   NO DATA PRINT LINE FOR THE EXCEPTION REPORT                *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 NO-DATA-LINE.                                                 
          05 FILLER            PIC X(57) VALUE SPACES.                  
          05 NO-DATA-LITERAL   PIC X(20) VALUE 'NO DATA FOR THIS RUN'.  
          05 FILLER            PIC X(56) VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   EXCEPTION REPORT LINE                                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 EXCEPTION-LINE.                                               
          05 FILLER            PIC X     VALUE SPACES.                  
          05 PRT-ACCOUNT       PIC XBXXXXBXXXXBXXXX VALUE SPACES.       
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-UTIL-TYPE     PIC X     VALUE SPACES.                  
          05 FILLER            PIC X(5)  VALUE SPACES.                  
          05 PRT-METER-NO      PIC X(9)  VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
          05 PRT-GIS-SOURCE    PIC X     VALUE SPACES.                  
          05 FILLER            PIC X(5)  VALUE SPACES.                  
          05 PRT-LATITUDE      PIC X(11) VALUE SPACES.                  
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-LONGITUDE     PIC X(11) VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
          05 PRT-TECH-ID       PIC X(5)  VALUE SPACES.                  
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-DATE-COLL     PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC XX    VALUE SPACES.                  
          05 PRT-ADDRESS.                                               
             10 PRT-HOUSE      PIC X(5)  VALUE SPACES.                  
             10 FILLER         PIC X     VALUE SPACES.                  
             10 PRT-STREET     PIC X(18) VALUE SPACES.                  
             10 FILLER         PIC X     VALUE SPACES.                  
             10 PRT-SUFFIX     PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   EXCEPTION DESCRIPTION FOR REPORT LINE                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 EXCEPTION-DESC-LINE.                                          
          05 FILLER            PIC X(85) VALUE SPACES.                  
          05 PRT-DESCRIPTION   PIC X(47) VALUE SPACES.                  
          05 FILLER            PIC X     VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   GENERAL USE PRINT LINE.                                    *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-LINE           PIC X(133) VALUE SPACES.                 
      *                                                                         
      *--------------------------------------------------------------*          
      *   PRINT TOTAL LINE FOR THE EXCEPTION REPORT                  *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-TOTAL-LINE.                                             
          05 FILLER            PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC X(45)                                
             VALUE 'TOTAL NUMBER OF ACCOUNTS WITH AN EXCEPTION = '.     
          05 PRT-TOTAL         PIC Z(9)9 VALUE ZEROS.                   
          05 FILLER            PIC X(68) VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   PRINT END OF REPORT LINE FOR THE EXCEPTION REPORT          *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-END.                                                    
          05 FILLER            PIC X(60) VALUE SPACES.                  
          05 FILLER            PIC X(13) VALUE 'END OF REPORT'.         
          05 FILLER            PIC X(60) VALUE SPACES.                  
       01  WS-UPDATE-FLAGS.                                             
          05   WS-UPDATES.                                              
              10  WS-UPDATE-FLAG OCCURS 15 TIMES                        
                                   PIC X.                               
          05  FILLER           REDEFINES WS-UPDATES.                    
              10  WS-LAT-UPD       PIC X.                               
                  88  LATITUDE-UPDATED     VALUE 'Y'.                   
              10  WS-LONG-UPD      PIC X.                               
                  88  LONGITUDE-UPDATED    VALUE 'Y'.                   
              10  WS-REV-UPD       PIC X.                               
                  88  REVENUE-DIST-UPDATED VALUE 'Y'.                   
              10  WS-LO-UPD        PIC X.                               
                  88  LOCAL-OFFICE-UPDATED VALUE 'Y'.                   
              10  WS-SUBD-UPD      PIC X.                               
                  88  SUBDIVISION-UPDATED  VALUE 'Y'.                   
              10  WS-LKF-UPD       PIC X.                               
                  88  LEAK-FREQ-UPDATED    VALUE 'Y'.                   
              10  WS-COU-UPD       PIC X.                               
                  88  COUNTY-UPDATED       VALUE 'Y'.                   
              10  WS-WD1-UPD       PIC X.                               
                  88  WORK-DIST1-UPDATED   VALUE 'Y'.                   
              10  WS-WD2-UPD       PIC X.                               
                  88  WORK-DIST2-UPDATED   VALUE 'Y'.                   
              10  WS-WD3-UPD       PIC X.                               
                  88  WORK-DIST3-UPDATED   VALUE 'Y'.                   
              10  WS-WD4-UPD       PIC X.                               
                  88  WORK-DIST4-UPDATED   VALUE 'Y'.                   
              10  WS-WD5-UPD       PIC X.                               
                  88  WORK-DIST5-UPDATED   VALUE 'Y'.                   
ACT375        10  WS-PREM-LAT-UPD  PIC X.                               
ACT375            88  PREM-LAT-UPDATED     VALUE 'Y'.                   
ACT375        10  WS-PREM-LONG-UPD PIC X.                               
ACT375            88  PREM-LONG-UPDATED    VALUE 'Y'.                   
ACT040        10  WS-RR-UPD         PIC X.                              
ACT040            88  READ-ROUTE-UPDATED    VALUE 'Y'.                  
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05) VALUE ZERO.        
           05  WS-RESTART-RECORD-NO        PIC 9(07).                   
           05  WS-RESTART-REC-KEY.                                      
               10 WS-RESTART-COMPANY-NO    PIC XX.                      
               10 WS-RESTART-G-E-W-IND     PIC X.                       
               10 WS-RESTART-METER-ID      PIC X(9).                    
               10 WS-RESTART-ACCOUNT-NO    PIC X(13).                   
               10 WS-RESTART-PREMISE-NO    PIC X(10).                   
                                                                        
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +59.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART            VALUE 'Y'.           
           05  WS-NEXT-RECORD-READ-FLAG    PIC X(01) VALUE 'N'.         
               88  WS-NEXT-RECORD-READ             VALUE 'Y'.           
               88  WS-NEXT-RECORD-NOT-READ         VALUE 'N'.           
           05  WS-FCA645-REC-CNT           PIC S9(09) COMP VALUE ZERO.  
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.         
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
           05  WS-COMMIT-COUNTER           PIC 9(8)         VALUE 0.    
           05  FILLER REDEFINES WS-COMMIT-COUNTER.                      
               10  WS-COMMIT-NUMBER            PIC 9(6).                
               10  WS-COUNTER-TEST             PIC 99.                  
           05  WS-CHKP-UPD-COUNTER         PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02) VALUE 'B4'.        
               10  WS-CHKP-PART-NO         PIC 9(01) VALUE 1.           
               10  WS-CHKP-SEQ-NO          PIC 9(05) VALUE ZERO.        
      *****************************************************************         
      *    THE FOLLOWING FIELD WILL ALLOW PROGRAMMER TO FORCE ABEND BY          
      *    SPECIFYING AN ACCOUNT NO                                             
      *****************************************************************         
           05  WS-STOP-ACCOUNT-NO          PIC 9(13).                   
      *                                                                         
      ****************************************************************          
      *  FILE LAYOUT FOR GIS TOHOST FILE FROM UPA TO SCANA TO UPDATE *          
      *  LONGITUDE AND LATTITUDE IN PCSCA635.                        *          
      ****************************************************************          
      *                                                                         
      *--------------------------------------------------------------*          
      *                                                                         
      ****************************************************************          
      *  FILE LAYOUT FOR GIS TOHOST FILE FROM UPA TO SCANA TO UPDATE *          
      *  LONGITUDE AND LATTITUDE IN PCSCA645.                        *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
                INCLUDE FIOCA645                                                
            END-EXEC.                                                           
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      *  CWS00038  JOB PARM ROUTINE                                  *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      * WORKING STORAGE FOR CPD09900                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_DELINQUENCY                                *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_TAX_RATE                                   *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTXRATE                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_SPCL_BILL_MSG                              *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSBLMSG                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_TAX_CNTL                                   *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTXCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_FRNCHSE_CRDT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFRNCRD                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_MTRD_ENVRNMT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPSUB                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    COPYBOOK FOR CSS_ZIPCODE_LO_RT                            *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPRTE                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_MNT_TRANS_HIST                                         *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_MT_TRN_HST_DET                                         *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_PREMISE                                                *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST                     *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_RESTART                                    *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_REV_DISTRICT                               *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBRVDST                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_STATE_COUNTY                               *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBSTCNTY                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_LOCAL_OFFICE                               *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_SUBDIVISION                                *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBSUBDVN                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   WORKING STORAGE FOR CPD00099 - GET MOST CURRENT            *          
      *        ACCOUNT NUMBER AT A PREMISE                           *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                 40070000
           EXEC SQL                                                             
               INCLUDE CWS0037F                                                 
           END-EXEC.                                                            
      *                                                                 40070000
       PROCEDURE DIVISION.                                              
      *                                                                         
      *==============================================================*          
       0000-MAINLINE.                                                   
      *==============================================================*          
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE                                 
              THRU 7000-EXIT.                                           
      *                                                                         
           IF END-OF-FILE                                               
              IF NOT WS-THIS-IS-A-RESTART                               
                 DISPLAY '***********************************'          
                 DISPLAY '     FCSCA645 FILE IS EMPTY      **'          
                 DISPLAY '         0000-MAINLINE           **'          
                 DISPLAY '***********************************'          
              END-IF                                                    
           ELSE                                                         
                 DISPLAY 'PROCESSING STARTED WITH: '                    
                          FIOCA645-RECORD(1:83)                         
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT UNTIL END-OF-FILE                          
      *                                                                         
           PERFORM 3000-PROCESS-NODATA-REPORT                           
              THRU 3000-EXIT                                            
      *                                                                         
           PERFORM 5500-PROCESS-SUCCESSFUL-JOB                          
              THRU 5500-EXIT                                            
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
      *                                                                         
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0100-INITIALIZATION.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   INTITIAL ROUTINE - GET REVENUE MONTH, CURRENT DATE,        *          
      *                      OPEN INPUT FILE AND OUTPUT PRINT FILE   *          
      *--------------------------------------------------------------*          
      *                                                                         
           OPEN INPUT  FCSCA645                                         
                OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 4300-GET-LAT-LONG-RANGE THRU 4300-EXIT.              
      *                                                                         
      *                                                                         
           INITIALIZE DCLCSS-PREMISE.                                   
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT.           
      *                                                                         
           MOVE WS-CURRENT-DATE TO HDR-DATE.                            
      *                                                                         
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT           
      *                                                                         
           PERFORM 0600-GET-RESTART-DATA       THRU 0600-EXIT           
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT           
           IF  WS-THIS-IS-A-RESTART                                     
               PERFORM 0800-REPOSITION-FILES                            
                  THRU 0800-EXIT                                        
           ELSE                                                         
               PERFORM 0700-INITIALIZE-RESTART  THRU 0700-EXIT          
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0600-GET-RESTART-DATA.                                           
      *==============================================================*          
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO           
                                              WS-CHKP-PART-NO.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           PERFORM 7300-SELECT-RESTART-DATA    THRU 7300-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT   TO WS-RESTART-DATA           
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-YES             TO WS-IS-THIS-A-RESTART      
               ELSE                                                     
                   MOVE WS-NO              TO WS-IS-THIS-A-RESTART      
               END-IF                                                   
           ELSE                                                         
               MOVE WS-NO              TO WS-IS-THIS-A-RESTART          
           END-IF                                                       
           .                                                            
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    0605-VALIDATE-RESTART                                      *         
      *****************************************************************         
       COPY CPD00030.                                                           
      *==============================================================*          
       0700-INITIALIZE-RESTART.                                         
      *==============================================================*          
      *                                                                         
           MOVE 0                        TO WS-RESTART-PROCESS-TYPE     
           MOVE WS-CURRENT-DATE          TO WS-RESTART-INPUT-DATE       
           MOVE ZERO                     TO WS-RESTART-CHKP-SEQ-NO      
           MOVE SPACES                   TO WS-RESTART-REC-KEY          
           SET WS-RERUN-PENDING          TO TRUE                        
           .                                                            
       0700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0800-REPOSITION-FILES.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    REPOSITION INPUT FILE                                     *          
      *--------------------------------------------------------------*          
           MOVE ZERO                       TO WS-FCA645-REC-CNT.        
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT                  
               UNTIL WS-FCA645-REC-CNT = WS-RESTART-RECORD-NO.          
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA645  *****'.       
           DISPLAY '*******************************************'.       
           IF  WS-RESTART-G-E-W-IND  = E-FCA645-G-E-W-IND               
           AND WS-RESTART-METER-ID   = E-FCA645-METER-ID                
           AND WS-RESTART-COMPANY-NO = E-FCA645-COMPANY-NO              
           AND WS-RESTART-PREMISE-NO = E-FCA645-PREMISE-NO              
           AND WS-RESTART-ACCOUNT-NO = E-FCA645-ACCOUNT-NO              
               DISPLAY '*** REPOSITION SUCCESSFULL ***'                 
           ELSE                                                         
               DISPLAY '***    FAIL TO REPOSITIONING FILE     **'       
               DISPLAY '**      ABEND IN PARAGRAPH 0611       **'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       0800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1000-PROCESS-INPUT.                                              
      *==============================================================*          
      *                                                                         
           PERFORM 4200-SAVE-FOR-RESTART                                
              THRU 4200-EXIT                                            
      *                                                                         
           MOVE SPACES TO WS-UPDATES.                                   
           MOVE 'N' TO WS-UPDATE-METER-ENV WS-UPDATE-PREMISE.           
           IF E-FCA645-COMPANY-NO = '01'                                
              MOVE WS-SCEG TO WS-COMPANY-NAME                           
           ELSE                                                         
              MOVE WS-PSNC TO WS-COMPANY-NAME                           
           END-IF                                                       
           MOVE E-FCA645-PREMISE-NO TO WS-PREMISE-NO.                   
           PERFORM 1200-PROCESS-DETAIL-RECORD THRU 1200-EXIT.           
           IF SQLCODE = +100                                            
               GO TO 0999-SKIP                                          
           END-IF.                                                      
ACT040     MOVE E-FCA645-ROUTE      TO WS-READ-ROUTE-ALPHA.             
ACT040     MOVE WS-READ-ROUTE-NUM   TO WS-NEW-ROUTE.                    
ACT040     MOVE PR-READ-ROUTE       TO WS-READ-ROUTE-DISP.              
           IF E-FCA645-SUBDIVISION-ID     > SPACES               AND    
              E-FCA645-SUBDIVISION-ID NOT = PR-SUBDIVISION-ID    AND    
              E-FCA645-SUBDIVISION-ID NOT = 'ZZY' AND 'ZZZ' AND '000'   
                   PERFORM 4400-VERIFY-SUBDIVISION    THRU 4400-EXIT    
           END-IF.                                                      
           IF E-FCA645-SUBDIVISION-ID NOT > SPACES                      
               MOVE PR-SUBDIVISION-ID TO E-FCA645-SUBDIVISION-ID        
           END-IF                                                       
ACT280     IF E-FCA645-REVENUE-DISTRICT > SPACES                  AND   
ACT280        E-FCA645-REVENUE-DISTRICT NOT = PR-REV-DISTRICT-CD        
ACT040                 PERFORM 4600-VERIFY-REV-DISTRICT   THRU 4600-EXIT
ACT280     END-IF.                                                      
ACT040     MOVE 'N' TO WS-LOC-OFFICE-FLAG.                              
ACT280     IF E-FCA645-LOCAL-OFFICE     > '000'                   AND   
ACT280        E-FCA645-COMPANY-NO       = '01'                          
ACT280           IF E-FCA645-LOCAL-OFFICE = PR-LOCAL-OFFICE             
                     MOVE 'Y' TO WS-LOC-OFFICE-FLAG                     
                 ELSE                                                   
ACT040             PERFORM 4700-VERIFY-LOC-OFFICE     THRU 4700-EXIT    
ACT280           END-IF                                                 
ACT280     END-IF.                                                      
           PERFORM 4800-WHAT-CHANGED          THRU 4800-EXIT.           
           IF WS-UPDATES NOT = SPACES                                   
                PERFORM 4900-TRANS-HIST            THRU 4900-EXIT       
           END-IF.                                                      
      *    IF UPDATE-METER-ENV                                                  
      *         PERFORM 7500-UPDATE-BY-METER       THRU 7500-EXIT               
      *    END-IF.                                                              
           IF WS-CPD99-PREMISE-NO NOT =  WS-LAST-PREMISE-UPDATED        
               IF UPDATE-PREMISE                                        
ACT021             DISPLAY 'PROCESSING ACCOUNT: ' E-FCA645-ACCOUNT-NO   
ACT021                 ' PREMISE: '           E-FCA645-PREMISE-NO       
ACT021                 ' METER: '             E-FCA645-METER-ID         
                   PERFORM 7700-UPDATE-PREMISE        THRU 7700-EXIT    
ACT021             ADD +1 TO WS-COMMIT-COUNTER                          
ACT021             IF WS-COUNTER-TEST = 0                               
ACT021                 MOVE 0               TO WS-RESTART-PROCESS-TYPE  
ACT021                 SET WS-RERUN-PENDING TO TRUE                     
ACT021                 PERFORM 8800-ISSUE-CHKP THRU 8800-EXIT           
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
       0999-SKIP.                                                       
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
       1000-EXIT.                                                       
           EXIT.                                                        
           EXEC SQL                                                             
               INCLUDE CPD0037F                                                 
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
       1200-PROCESS-DETAIL-RECORD.                                      
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   PROCESS DETAIL RECORDS.                                    *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE E-FCA645-METER-ID TO WS-METER-NO                        
           MOVE WS-METER-NO       TO WS-MTR-NO                          
           INSPECT WS-MTR-NO REPLACING ALL LOW-VALUES BY SPACES         
           MOVE 0                 TO WS-INSPECT-CNTR                    
           INSPECT WS-MTR-NO TALLYING  WS-INSPECT-CNTR FOR ALL ' '      
           COMPUTE WS-INSPECT-CNTR =                                    
               LENGTH OF WS-MTR-NO - WS-INSPECT-CNTR                    
           MOVE WS-MTR-NO(1:WS-INSPECT-CNTR) TO                         
                WS-METER-NO-JUSTIFIED                                   
           INSPECT WS-METER-NO-JUSTIFIED REPLACING ALL ' ' BY '0'       
           MOVE WS-METER-NO-JUSTIFIED TO WS-METER-NO                    
           IF (WS-METER-NO = ZEROS OR SPACES OR LOW-VALUES)             
           AND (E-FCA645-ACCOUNT-NO = ZEROS OR SPACES OR LOW-VALUES)    
              MOVE WS-MSG-1 TO PRT-DESCRIPTION                          
              PERFORM 1400-EXCEPTION-REPORT THRU 1400-EXIT              
              GO TO 1200-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FCA645-PREMISE-NO TO WS-CPD99-PREMISE-NO.             
      *                                                                         
           PERFORM 8100-GET-PREMISE-DETAILS THRU 8100-EXIT.             
           IF SQLCODE = +100                                            
               DISPLAY '    BYPASSING ' E-FCA645-ACCOUNT-NO ' NOT FOUND'
               GO TO 1200-EXIT                                          
           END-IF.                                                      
           MOVE ZEROS TO WS-CPD99-ACCOUNT-NO.                           
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO TO WS-COMPARE-ACCT.                 
           IF E-FCA645-ACCOUNT-NO NOT > ZERO                            
               MOVE WS-COMPARE-ACCT TO E-FCA645-ACCOUNT-NO              
           END-IF.                                                      
      *                                                                         
           INSPECT E-FCA645-LATITUDE                                    
               REPLACING ALL ' ' BY '0'.                                
           INSPECT E-FCA645-LONGITUDE                                   
               REPLACING ALL ' ' BY '0'.                                
           COMPUTE  MN-MTR-REF-LATITUDE =                               
                FUNCTION NUMVAL (E-FCA645-LATITUDE).                    
           MOVE MN-MTR-REF-LATITUDE TO WS-NEW-LATITUDE.                 
           COMPUTE  MN-MTR-REF-LONGITUDE =                              
                FUNCTION NUMVAL (E-FCA645-LONGITUDE).                   
           MOVE MN-MTR-REF-LONGITUDE TO WS-NEW-LONGITUDE.               
           IF E-FCA645-ACCOUNT-NO  NOT = WS-COMPARE-ACCT                
              IF WS-CPD99-ACCOUNT-NO = ZEROS                            
                  MOVE WS-MSG-4 TO PRT-DESCRIPTION                      
                  PERFORM 1400-EXCEPTION-REPORT THRU 1400-EXIT          
                  GO TO 1200-EXIT                                       
              ELSE                                                      
                  DISPLAY '    NOTE: INPUT ACCOUNT = '                  
                          E-FCA645-ACCOUNT-NO                           
                          ' MOST CURRENT ACCOUNT = ' WS-COMPARE-ACCT    
                  MOVE WS-COMPARE-ACCT TO E-FCA645-ACCOUNT-NO           
                  END-IF                                                
           END-IF.                                                      
           MOVE E-FCA645-DATE-COLL TO MN-LAT-LONG-DT.                   
      *                                                                         
      *                                                                         
           MOVE E-FCA645-GIS-SOURCE-CD TO MN-LAT-LONG-SOURCE-CD.        
      *                                                                         
           MOVE E-FCA645-ACCOUNT-NO    TO MN-ACCOUNT-NO.                
           MOVE E-FCA645-G-E-W-IND     TO MN-CODE-UTIL-TYPE.            
           MOVE WS-METER-NO            TO MN-METER-NO.                  
      *    MOVE E-FCA645-IC-NO         TO MN-IC-NO.                             
           MOVE E-FCA645-MTR-REF-NO    TO MN-MTR-REF-NO.                
      *                                                                         
           PERFORM 7900-GET-METER-COORDINATES THRU 7900-EXIT.           
           IF MN-MTR-REF-LATITUDE = ZERO                                
               MOVE WS-PREV-LAT  TO MN-MTR-REF-LATITUDE                 
           ELSE                                                         
               IF MN-MTR-REF-LATITUDE < WS-MIN-LATITUDE-MN OR           
                  MN-MTR-REF-LATITUDE > WS-MAX-LATITUDE-MN              
                     DISPLAY '    LATITUDE OUT OF RANGE: '              
                             E-FCA645-LATITUDE                          
                     MOVE WS-PREV-LAT TO MN-MTR-REF-LATITUDE            
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
      *                                                                         
           IF MN-MTR-REF-LONGITUDE = ZERO                               
               MOVE WS-PREV-LONG TO MN-MTR-REF-LONGITUDE                
           ELSE                                                         
               IF MN-MTR-REF-LONGITUDE < WS-MIN-LONGITUDE-MN OR         
                  MN-MTR-REF-LONGITUDE > WS-MAX-LONGITUDE-MN            
                      DISPLAY '    LONGITUDE  OUT OF RANGE: '           
                      E-FCA645-LONGITUDE                                
                      MOVE WS-PREV-LONG TO MN-MTR-REF-LONGITUDE         
               END-IF                                                   
           END-IF.                                                      
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1400-EXCEPTION-REPORT.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   PREPARE FOR EXCEPTION REPORT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE 'FAIL'  TO WS-RECORD-STATUS                             
                                                                        
           MOVE WS-METER-NO            TO PRT-METER-NO.                 
           MOVE E-FCA645-ACCOUNT-NO    TO PRT-ACCOUNT.                  
           INSPECT PRT-ACCOUNT REPLACING ALL ' ' BY '-'.                
           MOVE E-FCA645-G-E-W-IND     TO PRT-UTIL-TYPE.                
           MOVE E-FCA645-HOUSE-NBR     TO PRT-HOUSE.                    
           MOVE E-FCA645-STREET        TO PRT-STREET.                   
           MOVE E-FCA645-SUFFIX        TO PRT-SUFFIX.                   
      *                                                                         
           MOVE E-FCA645-GIS-SOURCE-CD TO PRT-GIS-SOURCE.               
           MOVE E-FCA645-TECH-ID       TO PRT-TECH-ID.                  
      *                                                                         
           MOVE E-FCA645-LATITUDE      TO PRT-LATITUDE.                 
           MOVE E-FCA645-LONGITUDE     TO PRT-LONGITUDE.                
      *                                                                         
           MOVE E-FCA645-DATE-COLL     TO PRT-DATE-COLL.                
      *                                                                         
           MOVE EXCEPTION-LINE TO PRINT-LINE.                           
      *                                                                         
           PERFORM 7400-WRITE-EXCEPTION-REPORT THRU 7400-EXIT.          
      *                                                                         
           MOVE SPACES TO EXCEPTION-LINE.                               
      *                                                                         
           MOVE EXCEPTION-DESC-LINE TO PRINT-LINE.                      
      *                                                                         
           PERFORM 7400-WRITE-EXCEPTION-REPORT THRU 7400-EXIT.          
           ADD +1 TO WS-EXP-COUNT.                                      
      *                                                                         
           IF E-FCA645-COMPANY-NO = '01'                                
              MOVE 'Y' TO WS-SCEG-NO-DATA                               
           ELSE                                                         
              MOVE 'Y' TO WS-PSNC-NO-DATA                               
           END-IF                                                       
           .                                                            
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3000-PROCESS-NODATA-REPORT.                                      
      *==============================================================*          
      ****************************************************************          
      *  WS-SCEG-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 01 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      *                                                                         
      *  WS-PSNC-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 26 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      ****************************************************************          
      *                                                                         
           IF WS-SCEG-NO-DATA = 'N'                                     
              MOVE WS-SCEG TO WS-COMPANY-NAME                           
              MOVE 0 TO WS-PAGE-COUNT                                   
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
              MOVE NO-DATA-LINE TO PRINT-LINE                           
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
              MOVE PRINT-END TO PRINT-LINE                              
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF.                                                      
      *                                                                         
           IF WS-PSNC-NO-DATA = 'N'                                     
              MOVE WS-PSNC TO WS-COMPANY-NAME                           
              MOVE 0 TO WS-PAGE-COUNT                                   
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
              MOVE NO-DATA-LINE TO PRINT-LINE                           
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
              MOVE PRINT-END TO PRINT-LINE                              
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF                                                       
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       4200-SAVE-FOR-RESTART.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   SAVE NON-EDITED DATA FOR RESTART JUST IN CASE              *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE WS-FCA645-REC-CNT   TO WS-RESTART-RECORD-NO             
           MOVE E-FCA645-ACCOUNT-NO TO WS-RESTART-ACCOUNT-NO            
           MOVE E-FCA645-PREMISE-NO TO WS-RESTART-PREMISE-NO            
           MOVE E-FCA645-G-E-W-IND  TO WS-RESTART-G-E-W-IND             
           MOVE E-FCA645-METER-ID   TO WS-RESTART-METER-ID              
           MOVE E-FCA645-COMPANY-NO TO WS-RESTART-COMPANY-NO            
           .                                                            
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       4300-GET-LAT-LONG-RANGE.                                         
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET THE MINIMUM / MAXIMUM LATITUDE AND LONGITUDE FOR      *          
      *    THE COMPANY YOU ARE RUNNING FOR.                          *          
      *    USED FOR LATITUDE / LONGITUDE VALIDATION.                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'MIN LAT=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA645                         **'        
              DISPLAY '**  4300-GET-LAT-LONG-RANGE           **'        
              DISPLAY '**  ERROR RETRIEVING THE MINIMUM AND  **'        
              DISPLAY '**  MAXIMUM LATITUDE PARM FROM        **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-MIN-MAX                      
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE WS-PARM-MINIMUM TO WS-MIN-LATITUDE                   
              MOVE WS-PARM-MAXIMUM TO WS-MAX-LATITUDE                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'MIN LON=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA645                         **'        
              DISPLAY '**  4300-GET-LAT-LONG-RANGE           **'        
              DISPLAY '**  ERROR RETRIEVING THE MINIMUM AND  **'        
              DISPLAY '**  MAXIMUM LONGITUDE PARM FROM       **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-MIN-MAX                      
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE WS-PARM-MINIMUM TO WS-MIN-LONGITUDE                  
              MOVE WS-PARM-MAXIMUM TO WS-MAX-LONGITUDE                  
           END-IF.                                                      
      *                                                                         
           DISPLAY 'MIN LATITUDE:  '  WS-MIN-LATITUDE                   
                   ' MAX LATITUDE:  ' WS-MAX-LATITUDE.                  
           DISPLAY 'MIN LONGITUDE: '  WS-MIN-LONGITUDE                  
                   ' MAX LONGITUDE: ' WS-MAX-LONGITUDE.                 
           COMPUTE WS-MIN-LATITUDE-MN =                                 
               FUNCTION NUMVAL (WS-MIN-LATITUDE).                       
      *                                                                         
           COMPUTE WS-MAX-LATITUDE-MN =                                 
               FUNCTION NUMVAL (WS-MAX-LATITUDE).                       
      *                                                                         
           COMPUTE WS-MIN-LONGITUDE-MN =                                
               FUNCTION NUMVAL (WS-MIN-LONGITUDE).                      
      *                                                                         
           COMPUTE WS-MAX-LONGITUDE-MN =                                
               FUNCTION NUMVAL (WS-MAX-LONGITUDE).                      
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4400-VERIFY-SUBDIVISION.                                         
           MOVE 'N' TO WS-ZIP-SUB-FLAG.                                 
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                  INTO :WS-ZIP-SUB-FLAG                                 
                  FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                    
                  WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID     
                    AND COMPANY_NO       = :E-FCA645-COMPANY-NO         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*           INTO :WS-ZIP-SUB-FLAG                                         
MFA-TR*           FROM CSS_SUBDIVISION                                          
MFA-TR*           WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID             
MFA-TR*             AND COMPANY_NO       = :E-FCA645-COMPANY-NO                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                 MOVE 'Y' TO WS-ZIP-SUB-FLAG                            
               WHEN 100                                                 
                 DISPLAY '    SUBDIVSION ROW FOR '                      
                     E-FCA645-ACCOUNT-NO ' '                            
                     E-FCA645-PREMISE-NO ' '                            
                     E-FCA645-SUBDIVISION-ID                            
                     ' NOT UPDATED - NOT ON SUBDIVISION TABLE'          
                 MOVE PR-SUBDIVISION-ID TO E-FCA645-SUBDIVISION-ID      
               WHEN OTHER                                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 4400       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO       
                           ' PREMISE # '      E-FCA645-PREMISE-NO       
                           ' SUBDIVISION ID ' E-FCA645-SUBDIVISION-ID   
                           ' COMPANY NO '     E-FCA645-COMPANY-NO       
                           ' REVENUE DIST '   E-FCA645-REVENUE-DISTRICT 
                           ' LOCAL OFFICE '   E-FCA645-LOCAL-OFFICE     
                           ' SUBDIVISION '    E-FCA645-SUBDIVISION-ID   
                           ' ZIP CODE '       WS-ZIP-CODE               
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       4400-EXIT.                                                       
           EXIT.                                                        
       4500-VERIFY-SUBDIVISION.                                         
           MOVE 'N' TO WS-ZIP-SUB-FLAG.                                 
           IF E-FCA645-SUBDIVISION-ID NOT > '   '                       
               MOVE PR-SUBDIVISION-ID TO E-FCA645-SUBDIVISION-ID        
           END-IF                                                       
           MOVE E-FCA645-REVENUE-DISTRICT TO WS-REVENUE-DISTRICT.       
           EXEC SQL                                                     
               SELECT TOP(1) RATE_ITEM_CD                                      
                  INTO :WS-RATE-ITEM-CODE                               
                  FROM CSS_ZIPCODE_SUBDIV WITH(READUNCOMMITTED)                 
                  WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID     
                    AND REV_DISTRICT_CD  = :WS-REVENUE-DISTRICT         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_ITEM_CD                                              
MFA-TR*           INTO :WS-RATE-ITEM-CODE                                       
MFA-TR*           FROM CSS_ZIPCODE_SUBDIV                                       
MFA-TR*           WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID             
MFA-TR*             AND REV_DISTRICT_CD  = :WS-REVENUE-DISTRICT                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                 MOVE 'Y' TO WS-ZIP-SUB-FLAG                            
               WHEN 100                                                 
                   IF E-FCA645-LOCAL-OFFICE > SPACES                    
                       PERFORM 8000-GET-RATE-ITEM-CODE THRU 8000-EXIT   
                   ELSE                                                 
                       DISPLAY '    SUBDIVSION ROW FOR '                
                               E-FCA645-ACCOUNT-NO ' '                  
                               E-FCA645-PREMISE-NO ' '                  
                               E-FCA645-REVENUE-DISTRICT ' '            
                               E-FCA645-SUBDIVISION-ID                  
                               ' NOT ADDED - NO LOCAL OFFICE'           
                       MOVE ' ' TO WS-ZIP-SUB-FLAG                      
                   END-IF                                               
               WHEN OTHER                                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 4500       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO       
                           ' PREMISE # '      E-FCA645-PREMISE-NO       
                           ' SUBDIVISION ID ' E-FCA645-SUBDIVISION-ID   
                           ' COMPANY NO '     E-FCA645-COMPANY-NO       
                           ' REVENUE DIST '   E-FCA645-REVENUE-DISTRICT 
                           ' LOCAL OFFICE '   E-FCA645-LOCAL-OFFICE     
                           ' SUBDIVISION '    E-FCA645-SUBDIVISION-ID   
                           ' ZIP CODE '       WS-ZIP-CODE               
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       4500-EXIT.                                                       
           EXIT.                                                        
       4600-VERIFY-REV-DISTRICT.                                        
           MOVE E-FCA645-REVENUE-DISTRICT TO WS-REVENUE-DISTRICT.       
           IF E-FCA645-LOCAL-OFFICE > '000'                             
               MOVE E-FCA645-LOCAL-OFFICE TO WS-LOCAL-OFFICE            
           ELSE                                                         
               MOVE PR-LOCAL-OFFICE       TO WS-LOCAL-OFFICE            
           END-IF.                                                      
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                  INTO :WS-ZIP-SUB-FLAG                                 
                  FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                  
                  WHERE ZIP_CODE         = :DY-ZIP-CODE         AND     
                        LOCAL_OFFICE     = :WS-LOCAL-OFFICE     AND     
                        READ_ROUTE       = :WS-NEW-ROUTE        AND     
                        REV_DISTRICT_CD  = :WS-REVENUE-DISTRICT         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*           INTO :WS-ZIP-SUB-FLAG                                         
MFA-TR*           FROM CSS_ZIPCODE_LO_RT                                        
MFA-TR*           WHERE ZIP_CODE         = :DY-ZIP-CODE         AND             
MFA-TR*                 LOCAL_OFFICE     = :WS-LOCAL-OFFICE     AND             
MFA-TR*                 READ_ROUTE       = :WS-NEW-ROUTE        AND             
MFA-TR*                 REV_DISTRICT_CD  = :WS-REVENUE-DISTRICT                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                 CONTINUE                                               
               WHEN 100                                                 
                   DISPLAY E-FCA645-ACCOUNT-NO ' ' E-FCA645-PREMISE-NO  
                   ' NO REVENUE DISTRICT CHANGE FROM LO '               
                   PR-LOCAL-OFFICE ' TO ' E-FCA645-LOCAL-OFFICE         
                   'REV DIST ' PR-REV-DISTRICT-CD ' TO '                
                   E-FCA645-REVENUE-DISTRICT                            
                   MOVE PR-LOCAL-OFFICE TO E-FCA645-LOCAL-OFFICE        
                   MOVE PR-REV-DISTRICT-CD TO E-FCA645-REVENUE-DISTRICT 
               WHEN OTHER                                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 4500       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO       
                           ' PREMISE # '      E-FCA645-PREMISE-NO       
                           ' SUBDIVISION ID ' E-FCA645-SUBDIVISION-ID   
                           ' COMPANY NO '     E-FCA645-COMPANY-NO       
                           ' REVENUE DIST '   E-FCA645-REVENUE-DISTRICT 
                           ' LOCAL OFFICE '   E-FCA645-LOCAL-OFFICE     
                           ' SUBDIVISION '    E-FCA645-SUBDIVISION-ID   
                           ' ZIP CODE '       WS-ZIP-CODE               
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       4600-EXIT.                                                       
           EXIT.                                                        
       4700-VERIFY-LOC-OFFICE.                                          
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                  INTO :WS-LOC-OFFICE-FLAG                              
                  FROM  CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                
                  WHERE COMPANY_NO       = :E-FCA645-COMPANY-NO AND     
                        READ_ROUTE       = :WS-NEW-ROUTE   AND          
                        LOCAL_OFFICE     = :E-FCA645-LOCAL-OFFICE       
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*           INTO :WS-LOC-OFFICE-FLAG                                      
MFA-TR*           FROM  CSS_LOC_OFF_CYC_RT                                      
MFA-TR*           WHERE COMPANY_NO       = :E-FCA645-COMPANY-NO AND             
MFA-TR*                 READ_ROUTE       = :WS-NEW-ROUTE   AND                  
MFA-TR*                 LOCAL_OFFICE     = :E-FCA645-LOCAL-OFFICE               
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                 CONTINUE                                               
               WHEN 100                                                 
                 MOVE PR-READ-ROUTE TO WS-READ-ROUTE-DISP               
                 DISPLAY '    LOCAL OFFICE   FOR '                      
                     E-FCA645-ACCOUNT-NO ' '                            
                     E-FCA645-PREMISE-NO ' '                            
                     E-FCA645-LOCAL-OFFICE ' '                          
                     WS-READ-ROUTE-DISP    ' '                          
                     E-FCA645-ROUTE                                     
                     ' NOT UPDATED - NOT ON CSS_LOC_OFF_CYC_RT'         
                 MOVE PR-LOCAL-OFFICE TO E-FCA645-LOCAL-OFFICE          
               WHEN OTHER                                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 4500       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO       
                           ' PREMISE # '      E-FCA645-PREMISE-NO       
                           ' SUBDIVISION ID ' E-FCA645-SUBDIVISION-ID   
                           ' COMPANY NO '     E-FCA645-COMPANY-NO       
                           ' REVENUE DIST '   E-FCA645-REVENUE-DISTRICT 
                           ' LOCAL OFFICE '   E-FCA645-LOCAL-OFFICE     
                           ' SUBDIVISION '    E-FCA645-SUBDIVISION-ID   
                           ' ZIP CODE '       WS-ZIP-CODE               
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       4700-EXIT.                                                       
           EXIT.                                                        
       4800-WHAT-CHANGED.                                               
ACT212     IF E-FCA645-REVENUE-DISTRICT > '000'  AND                    
              PR-REV-DISTRICT-CD NOT = E-FCA645-REVENUE-DISTRICT        
                MOVE 'Y' TO WS-REV-UPD  WS-UPDATE-PREMISE               
ACT398           IF E-FCA645-COMPANY-NO = '01'                          
                    PERFORM F1000-DETERMINE-REGION THRU F1000-EXIT      
                    IF C8-DELINQ-VALUE = 1                              
                        PERFORM F1100-CHECK-FOR-ACCOUNTS                
                        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL      
ACT390                     MOVE E-FCA645-REVENUE-DISTRICT TO            
ACT390                                   PARM-REV-DISTRICT-CD-037       
                           PERFORM F1200-PROCESS-FRANCHISE-FEE          
                        END-IF                                          
                    END-IF                                              
ACT398           END-IF                                                 
                 MOVE PR-REV-DISTRICT-CD         TO WS-REVENUE-DISTRICT 
                 PERFORM 8600-GET-REV-DIST-NAMES THRU 8600-EXIT         
                 MOVE A9-REV-DISTRICT-DESC         TO                   
                                                 WS-OLD-REVENUE-DIST    
                 MOVE E-FCA645-REVENUE-DISTRICT    TO                   
                                                 WS-REVENUE-DISTRICT    
                 PERFORM 8600-GET-REV-DIST-NAMES THRU 8600-EXIT         
                 MOVE A9-REV-DISTRICT-DESC       TO                     
                                                 WS-NEW-REVENUE-DIST    
           END-IF.                                                      
                                                                        
           IF E-FCA645-LOCAL-OFFICE    > SPACES                AND      
              PR-LOCAL-OFFICE     NOT  = E-FCA645-LOCAL-OFFICE AND      
ACT390        E-FCA645-COMPANY-NO      = '01'                           
                 MOVE 'Y' TO WS-LO-UPD    WS-UPDATE-PREMISE             
                 MOVE PR-LOCAL-OFFICE              TO WS-LOCAL-OFFICE   
                 PERFORM 8700-GET-LOC-OFFICE-NAMES THRU 8700-EXIT       
                 MOVE B1-LOCAL-OFFICE-DESC         TO WS-OLD-LOC-OFFICE 
                 MOVE E-FCA645-LOCAL-OFFICE        TO WS-LOCAL-OFFICE   
                 PERFORM 8700-GET-LOC-OFFICE-NAMES THRU 8700-EXIT       
                 MOVE B1-LOCAL-OFFICE-DESC         TO WS-NEW-LOC-OFFICE 
           END-IF.                                                      
                                                                        
           IF WS-LOC-OFFICE-FLAG  = 'Y'                                 
               IF WS-NEW-ROUTE NOT = PR-READ-ROUTE                      
                  MOVE 'Y' TO WS-RR-UPD WS-UPDATE-PREMISE               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF E-FCA645-SUBDIVISION-ID > SPACES AND                      
              E-FCA645-SUBDIVISION-ID NOT = '000' AND                   
              PR-SUBDIVISION-ID  NOT = E-FCA645-SUBDIVISION-ID          
                 MOVE 'Y' TO WS-SUBD-UPD   WS-UPDATE-PREMISE            
                 MOVE PR-SUBDIVISION-ID            TO WS-SUBDIVISION    
                 PERFORM 8760-GET-SUBDIVISION-NAMES  THRU 8760-EXIT     
                 MOVE B0-SUBDIVISION-DESC          TO WS-OLD-SUBDIVISION
                 MOVE E-FCA645-SUBDIVISION-ID      TO WS-SUBDIVISION    
                 PERFORM 8760-GET-SUBDIVISION-NAMES  THRU 8760-EXIT     
                 MOVE B0-SUBDIVISION-DESC          TO WS-NEW-SUBDIVISION
                 PERFORM 7100-SUBDIVISION-LIGHTING-CHG                  
           END-IF.                                                      
                                                                        
           MOVE PR-GAS-LK-SURVEY-FREQ TO WS-LEAK-CODE.                  
ACT212     IF E-FCA645-LEAK-SURVEY        > '00'               AND      
ACT212        PR-GAS-LK-SURVEY-FREQ NOT = E-FCA645-LEAK-SURVEY AND      
ACT212        NOT IN-OFF-LIMITS-LIST                                    
               MOVE 'Y' TO WS-LKF-UPD   WS-UPDATE-PREMISE               
           END-IF.                                                      
           IF E-FCA645-COUNTY-ID    > SPACES AND                        
              E-FCA645-COUNTY-ID (3:1) NUMERIC                          
                 INSPECT E-FCA645-COUNTY-ID REPLACING ALL ' ' BY '0'    
                 IF E-FCA645-COUNTY-ID < '101'                          
                     IF PR-COUNTY             NOT = E-FCA645-COUNTY-ID  
                        MOVE 'Y' TO WS-COU-UPD  WS-UPDATE-PREMISE       
                        MOVE PR-COUNTY               TO   WS-COUNTY     
                        PERFORM 8780-GET-COUNTY-NAME THRU 8780-EXIT     
                        MOVE SC-COUNTY-DESC          TO   WS-OLD-COUNTY 
                        MOVE E-FCA645-COUNTY-ID      TO   WS-COUNTY     
                        PERFORM 8780-GET-COUNTY-NAME THRU 8780-EXIT     
                        MOVE SC-COUNTY-DESC          TO   WS-NEW-COUNTY 
                     END-IF                                             
                 ELSE                                                   
                     DISPLAY '    COUNTY CHECK BYPASSED '               
                             E-FCA645-COUNTY-ID ' OUT OF RANGE'         
                 END-IF                                                 
           END-IF.                                                      
                                                                        
           IF E-FCA645-CLICK-ELC-DIST-GRP   > SPACES AND                
              PR-FM-ELEC-SVC-WKDIST-TEXT                                
                                       NOT = E-FCA645-CLICK-ELC-DIST-GRP
               MOVE 'Y' TO WS-WD1-UPD   WS-UPDATE-PREMISE               
           END-IF.                                                      
                                                                        
           IF E-FCA645-CLICK-GAS-DIST-GRP > SPACES AND                  
              PR-FM-GAS-OPS-WKDIST-TEXT                                 
                                       NOT = E-FCA645-CLICK-GAS-DIST-GRP
               MOVE 'Y' TO WS-WD2-UPD    WS-UPDATE-PREMISE              
           END-IF.                                                      
                                                                        
           IF E-FCA645-CLICK-FLD-SERV-GRP > SPACES AND                  
              PR-FM-FLD-SVCS-WKDIST-TEXT                                
                                       NOT = E-FCA645-CLICK-FLD-SERV-GRP
               MOVE 'Y' TO WS-WD3-UPD    WS-UPDATE-PREMISE              
           END-IF.                                                      
                                                                        
           IF E-FCA645-CLICK-REV-PROT-GRP > SPACES AND                  
              PR-FM-REV-PRT-WKDIST-TEXT                                 
                                       NOT = E-FCA645-CLICK-REV-PROT-GRP
               MOVE 'Y' TO WS-WD4-UPD    WS-UPDATE-PREMISE              
           END-IF.                                                      
                                                                        
           IF E-FCA645-CLICK-DSM-GRP > SPACES AND                       
              PR-FM-DSM-ESVC-WKDIST-TEXT                                
                                       NOT = E-FCA645-CLICK-DSM-GRP     
               MOVE 'Y' TO WS-WD5-UPD    WS-UPDATE-PREMISE              
           END-IF.                                                      
                                                                        
      *    IF MN-MTR-REF-LATITUDE    NOT = WS-PREV-LAT AND                      
      *       MN-MTR-REF-LATITUDE    NOT = ZERO                                 
      *           MOVE 'Y' TO WS-LAT-UPD                                        
      *    END-IF.                                                              
                                                                        
      *    IF MN-MTR-REF-LONGITUDE   NOT = WS-PREV-LONG AND                     
      *       MN-MTR-REF-LONGITUDE   NOT = ZERO                                 
      *           MOVE 'Y' TO WS-LONG-UPD                                       
      *    END-IF.                                                              
                                                                        
ACT375     IF PR-PREM-REF-LATITUDE    NOT = WS-NEW-LATITUDE AND         
ACT375        WS-NEW-LATITUDE         NOT = ZERO                        
ACT375            MOVE 'Y' TO WS-PREM-LAT-UPD    WS-UPDATE-PREMISE      
ACT375     END-IF.                                                      
ACT375                                                                  
ACT375     IF PR-PREM-REF-LONGITUDE   NOT = WS-NEW-LONGITUDE AND        
ACT375        WS-NEW-LONGITUDE        NOT = ZERO                        
ACT375            MOVE 'Y' TO WS-PREM-LONG-UPD    WS-UPDATE-PREMISE     
           END-IF.                                                      
       4800-EXIT.                                                       
           EXIT.                                                        
       4900-TRANS-HIST.                                                 
           MOVE 0                    TO MH-ACCOUNT-NO.                  
           MOVE 'PCSCA645'           TO MH-APPL-PROGRAM-ID.             
           MOVE 'F'                  TO MH-CODE-TRAN-TYPE.              
           MOVE 0                    TO MH-CUSTOMER-NO.                 
           MOVE 0                    TO MH-ENTITY-KEY-DESC-LEN.         
           MOVE E-FCA645-PREMISE-NO  TO MH-PREMISE-NO.                  
           MOVE ' '                  TO MH-RESP-AREA-ID.                
           MOVE 12                   TO MH-TRAN-COMMENT-LEN.            
           MOVE 'GIS/CIS SYNC'       TO MH-TRAN-COMMENT-TEXT            
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT.           
           MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO            
                                        MI-TRANS-HIST-SEQ-NO            
                                        MH-DATE-TRANS.                  
           MOVE 'SYSTEM'             TO MH-USER-ID                      
           MOVE 1                    TO J.                              
           PERFORM VARYING I FROM 1 BY 1                                
               UNTIL I > 15                                             
               IF WS-UPDATE-FLAG (I) = 'Y'                              
                   MOVE J                     TO MI-TRAN-APPL-NO        
                   PERFORM 5100-FIND-VALUES         THRU 5100-EXIT      
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD +1                     TO J                      
               END-IF                                                   
           END-PERFORM.                                                 
       4900-EXIT.                                                       
           EXIT.                                                        
       5000-PROCESS-SUCCESSFUL-JOB.                                     
      *--------------------------------------------------------------           
      * THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN            
      * AND RESET RE-START CONTROLS IN CASE OF RE-START RUN                     
      *--------------------------------------------------------------           
           MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED    TO TRUE                        
           ELSE                                                         
               SET WS-RUN-COMPLETED-NO-PROBLEMS                         
                                         TO TRUE                        
           END-IF.                                                      
           PERFORM 8900-WRITE-RSDDR THRU 8900-EXIT.                     
                                                                        
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                  THRU 8893-EXIT                                        
           END-IF.                                                      
       5000-EXIT.                                                       
           EXIT.                                                        
       5100-FIND-VALUES.                                                
           MOVE 'B1'                         TO MI-TABLE-ID.            
           EVALUATE TRUE                                                
             WHEN LATITUDE-UPDATED                                      
               MOVE 'LATITUDE'               TO MI-COLUMN-DESC          
               MOVE WS-PREV-LAT-EDITED       TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-LATITUDE        TO MI-CHG-COLUMN-VALUE-TEXT
               MOVE 10                       TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE 'MN'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-LAT-UPD              
             WHEN LONGITUDE-UPDATED                                     
               MOVE 'LONGITUDE'              TO MI-COLUMN-DESC          
               MOVE WS-PREV-LONG-EDITED      TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-LONGITUDE       TO MI-CHG-COLUMN-VALUE-TEXT
               MOVE 10                       TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE 'MN'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-LONG-UPD             
ACT375       WHEN PREM-LAT-UPDATED                                      
ACT375         MOVE 'LATITUDE'               TO MI-COLUMN-DESC          
ACT375         MOVE PR-PREM-REF-LATITUDE     TO WS-PREV-LAT-EDITED      
ACT375         MOVE WS-PREV-LAT-EDITED       TO MI-PRV-COLUMN-VALUE-TEXT
ACT375         MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN 
ACT375         MOVE E-FCA645-LATITUDE        TO MI-CHG-COLUMN-VALUE-TEXT
ACT375         MOVE 10                       TO MI-CHG-COLUMN-VALUE-LEN 
ACT375         MOVE 'PR'                     TO MI-TABLE-ID             
ACT375         MOVE WS-NEW-LATITUDE          TO PR-PREM-REF-LATITUDE    
ACT375         MOVE ' '                      TO WS-PREM-LAT-UPD         
ACT375       WHEN PREM-LONG-UPDATED                                     
ACT375         MOVE 'LONGITUDE'              TO MI-COLUMN-DESC          
ACT375         MOVE PR-PREM-REF-LONGITUDE    TO WS-PREV-LONG-EDITED     
ACT375         MOVE WS-PREV-LONG-EDITED      TO MI-PRV-COLUMN-VALUE-TEXT
ACT375         MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN 
ACT375         MOVE E-FCA645-LONGITUDE       TO MI-CHG-COLUMN-VALUE-TEXT
ACT375         MOVE 10                       TO MI-CHG-COLUMN-VALUE-LEN 
ACT375         MOVE 'PR'                     TO MI-TABLE-ID             
ACT375         MOVE WS-NEW-LONGITUDE         TO PR-PREM-REF-LONGITUDE   
ACT375         MOVE ' '                      TO WS-PREM-LONG-UPD        
             WHEN REVENUE-DIST-UPDATED                                  
               MOVE 'REVENUE DIST'           TO MI-COLUMN-DESC          
               MOVE WS-OLD-REVENUE-DIST      TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE E-FCA645-REVENUE-DISTRICT                           
                                             TO PR-REV-DISTRICT-CD      
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-NEW-REVENUE-DIST      TO MI-CHG-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-REV-UPD              
             WHEN LOCAL-OFFICE-UPDATED                                  
               MOVE 'LOCAL OFFICE'           TO MI-COLUMN-DESC          
               MOVE WS-OLD-LOC-OFFICE        TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-LOCAL-OFFICE    TO PR-LOCAL-OFFICE         
               MOVE WS-NEW-LOC-OFFICE        TO MI-CHG-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE ' '                      TO WS-LO-UPD               
ACT040       WHEN READ-ROUTE-UPDATED                                    
ACT040         MOVE 'READ ROUTE'             TO MI-COLUMN-DESC          
ACT040         MOVE WS-READ-ROUTE-DISP       TO MI-PRV-COLUMN-VALUE-TEXT
ACT040         MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN 
ACT040         MOVE WS-NEW-ROUTE             TO PR-READ-ROUTE           
ACT040         MOVE WS-NEW-ROUTE             TO WS-READ-ROUTE-DISP      
ACT040         MOVE WS-READ-ROUTE-DISP       TO MI-CHG-COLUMN-VALUE-TEXT
ACT040         MOVE 'PR'                     TO MI-TABLE-ID             
ACT040         MOVE 5                        TO MI-CHG-COLUMN-VALUE-LEN 
ACT040         MOVE ' '                      TO WS-RR-UPD               
             WHEN SUBDIVISION-UPDATED                                   
               MOVE 'SUBDIVISION'            TO MI-COLUMN-DESC          
               MOVE WS-OLD-SUBDIVISION       TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-SUBDIVISION-ID  TO PR-SUBDIVISION-ID       
               MOVE WS-NEW-SUBDIVISION       TO MI-CHG-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
ACT280         MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-SUBD-UPD             
             WHEN LEAK-FREQ-UPDATED                                     
               MOVE 'GAS LEAK FREQ'          TO MI-COLUMN-DESC          
               MOVE PR-GAS-LK-SURVEY-FREQ    TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE 02                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-LEAK-SURVEY     TO MI-CHG-COLUMN-VALUE-TEXT
                                                PR-GAS-LK-SURVEY-FREQ   
               MOVE 02                       TO MI-CHG-COLUMN-VALUE-LEN 
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-LKF-UPD              
             WHEN COUNTY-UPDATED                                        
               MOVE 'COUNTY'                 TO MI-COLUMN-DESC          
               MOVE WS-OLD-COUNTY            TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-NEW-COUNTY            TO MI-CHG-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE E-FCA645-COUNTY-ID       TO PR-COUNTY               
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-COU-UPD              
             WHEN WORK-DIST1-UPDATED                                    
               MOVE 'ELEC SVC WKDIST'        TO MI-COLUMN-DESC          
               MOVE PR-FM-ELEC-SVC-WKDIST-TEXT                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-CLICK-ELC-DIST-GRP                         
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                                              PR-FM-ELEC-SVC-WKDIST-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
ACT116                                        PR-FM-ELEC-SVC-WKDIST-LEN 
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-WD1-UPD              
             WHEN WORK-DIST2-UPDATED                                    
               MOVE 'GAS OPS WKDIST'        TO MI-COLUMN-DESC           
               MOVE PR-FM-GAS-OPS-WKDIST-TEXT                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-CLICK-GAS-DIST-GRP                         
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                                             PR-FM-GAS-OPS-WKDIST-TEXT  
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
ACT116                                       PR-FM-GAS-OPS-WKDIST-LEN   
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-WD2-UPD              
             WHEN WORK-DIST3-UPDATED                                    
               MOVE 'FLD SVCS WKDIST'        TO MI-COLUMN-DESC          
               MOVE PR-FM-FLD-SVCS-WKDIST-TEXT                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-CLICK-FLD-SERV-GRP                         
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                                             PR-FM-FLD-SVCS-WKDIST-TEXT 
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
ACT116                                       PR-FM-FLD-SVCS-WKDIST-LEN  
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-WD3-UPD              
             WHEN WORK-DIST4-UPDATED                                    
               MOVE 'REV PROT WKDIST'        TO MI-COLUMN-DESC          
               MOVE PR-FM-REV-PRT-WKDIST-TEXT                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-CLICK-REV-PROT-GRP                         
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                                             PR-FM-REV-PRT-WKDIST-TEXT  
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
ACT116                                       PR-FM-REV-PRT-WKDIST-LEN   
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-WD4-UPD              
             WHEN WORK-DIST5-UPDATED                                    
               MOVE 'DSM ESVC WKDIST'        TO MI-COLUMN-DESC          
               MOVE PR-FM-DSM-ESVC-WKDIST-TEXT                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE E-FCA645-CLICK-DSM-GRP   TO MI-CHG-COLUMN-VALUE-TEXT
                                             PR-FM-DSM-ESVC-WKDIST-TEXT 
                                                WS-WORK-DIST            
               PERFORM 5300-FIND-LENGTH    THRU 5300-EXIT               
               MOVE WS-LENGTH                TO MI-CHG-COLUMN-VALUE-LEN 
ACT116                                       PR-FM-DSM-ESVC-WKDIST-LEN  
ACT280         MOVE 'PR'                     TO MI-TABLE-ID             
               MOVE ' '                      TO WS-WD5-UPD              
           END-EVALUATE.                                                
       5100-EXIT.                                                       
           EXIT.                                                        
       5300-FIND-LENGTH.                                                
           MOVE 0 TO K.                                                 
           MOVE LENGTH OF WS-WORK-DIST TO WS-MAX-LEN.                   
           IF WS-WORK-DIST     > SPACES                                 
               INSPECT FUNCTION REVERSE (WS-WORK-DIST)                  
                   TALLYING K FOR LEADING SPACES                        
               COMPUTE WS-LENGTH = WS-MAX-LEN - K                       
           ELSE                                                         
               MOVE 1 TO WS-LENGTH                                      
           END-IF.                                                      
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       5500-PROCESS-SUCCESSFUL-JOB.                                     
      *==============================================================*          
      *--------------------------------------------------------------*          
      * THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
      * AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
      *--------------------------------------------------------------*          
           MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED    TO TRUE                        
           ELSE                                                         
               SET WS-RUN-COMPLETED-NO-PROBLEMS                         
                                         TO TRUE                        
           END-IF.                                                      
      *                                                                         
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                  THRU 8893-EXIT                                        
           END-IF                                                       
           .                                                            
       5500-EXIT.                                                       
           EXIT.                                                        
      *==============================================================*          
       6995-CPD99-ERROR-ROUTINE.                                        
      *==============================================================*          
      *                                                                         
           DISPLAY '*************PCSCA645************'.                 
           DISPLAY '* ERROR IN PERFORMING - 6990-FETCH-CUR-ACCOUNT '.   
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSCA645************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT                            
           .                                                            
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7000-READ-INPUT-FILE.                                            
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   READ INPUT FILE                                            *          
      *--------------------------------------------------------------*          
      *                                                                         
           READ FCSCA645      INTO FIOCA645-RECORD                      
                     AT END MOVE WS-YES TO WS-EOF-FLAG.                 
      *                                                                         
           IF NOT END-OF-FILE                                           
              ADD 1         TO  WS-FCA645-REC-CNT                       
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
       7100-SUBDIVISION-LIGHTING-CHG.                                   
      *    MOVE E-FCA645-ACCOUNT-NO TO PARM-ACCOUNT-NO-NUM.                     
      *    MOVE E-FCA645-PREMISE-NO TO PARM-PREMISE-NO-NUM.                     
      *    MOVE WS-RATE-ITEM-CODE   TO PARM-RATE-ITEM-CODE-NUM.                 
      *    MOVE 'SYSTEM'            TO PARM-USER-ID.                            
      *    MOVE E-FCA645-DATE-COLL  TO PARM-DATE-PLAN-START.                    
      *    EXEC SQL                                                             
      *         CALL CSR02100 (:PARM-ACCOUNT-NO,                                
      *                        :PARM-PREMISE-NO,                                
      *                        :PARM-RATE-ITEM-CODE,                            
      *                        :PARM-USER-ID,                                   
      *                        :PARM-DATE-PLAN-START)                           
      *    END-EXEC.                                                            
      *    IF SQLCODE = 466                                                     
      *        DISPLAY E-FCA645-ACCOUNT-NO                                      
      *           ' SUBDIVSION LIGHTING CHANGE'                                 
      *    ELSE                                                                 
      *        DISPLAY 'CSR02100 SQL CODE = ' SQLCODE ' '                       
      *           ' SUBDIVSION LIGHTING ERROR '                                 
      *            'ACCOUNT NO = ' PARM-ACCOUNT-NO     ' '                      
      *            'PREMISE NO = ' PARM-PREMISE-NO    ' '                       
      *            'RATE ITEM  = ' WS-RATE-ITEM-CODE  ' '                       
      *            'DATE = '       E-FCA645-DATE-COLL                           
      *        MOVE 4 TO WS-RETURN-CODE                                         
      *    END-IF.                                                              
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *                                                                         
      *==============================================================*          
       7200-GET-CURRENT-TIMESTAMP.                                      
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET CURRENT DATE AND TIMESTAMP                            *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                 
MFA-TR*            ,:WS-CURRENT-DATE       =  CURRENT DATE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURRENT DATE '                    
              DISPLAY ' 7200-GET-CURRENT-TIMESTAMP '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *==============================================================*          
      *==============================================================*          
       7300-SELECT-RESTART-DATA.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      * THIS SELECTS A ROW FROM CSS_RESTART TO CHECK WHETHER THE     *          
      * CURRENT RUN IS A REGULAR RUN OR A RESTART.IF A ROW IS PRESENT*          
      * FOR THIS PROGRAM IT IS A RERUN, THE PROCESS STARTS FROM THE  *          
      * ACCOUNT AND PROCESS WHICH IS STORED IN RESTART-DATA          *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW143 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7400-WRITE-EXCEPTION-REPORT.                                     
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   WRITE THE EXCEPTION REPORT                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *==============================================================*          
       7500-UPDATE-BY-METER.                                            
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   UPDATE CSS_MTRD_ENVRNMT WITH NEW LATITUDE & LONGITUDE      *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
               SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :MN-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAT-LONG-DT
              ) <> 0) OR (LEN(:MN-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :MN-LAT-LONG-DT
              ), CONVERT(DATE, :MN-LAT-LONG-DT) ),                
                   LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,         
                   MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,           
                   MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE           
               WHERE ACCOUNT_NO       = :WS-CPD99-ACCOUNT-NO            
                 AND METER_NO       = :MN-METER-NO                      
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*        SET LAT_LONG_DT        = :MN-LAT-LONG-DT,                        
MFA-TR*            LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,                 
MFA-TR*            MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,                   
MFA-TR*            MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE                   
MFA-TR*        WHERE ACCOUNT_NO       = :WS-CPD99-ACCOUNT-NO                    
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                 DISPLAY '    PCSCA645 METER NO ' MN-METER-NO           
                     ' WAS NOT FOUND AT ACCOUNT ' MN-ACCOUNT-NO         
              ELSE                                                      
                  DISPLAY '****************************************'    
                  DISPLAY '       ABENDING PROGRAM '                    
                  DISPLAY '     MTRD-ENVRNMT UPDATE '                   
                  DISPLAY '   7500-UPDATE-MTRD-ENVRNMT '                
                  DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY ' ACCOUNT NO     = ' E-FCA645-ACCOUNT-NO      
                  DISPLAY ' CODE-UTIL-TYPE = ' E-FCA645-G-E-W-IND       
                  DISPLAY ' METER-NO       = ' WS-METER-NO              
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
       7550-ADD-ZIPCODE-LO-ROUTE.                                       
           EXEC SQL                                                     
               INSERT INTO CSS_ZIPCODE_LO_RT                            
                   (  ZIP_CODE,                                         
                      LOCAL_OFFICE,                                     
                      REV_DISTRICT_CD,                                  
                      READ_ROUTE,                                       
                      COMPANY_NO)                                       
                VALUES                                                  
                   ( :DY-ZIP-CODE,                                      
                     :E-FCA645-LOCAL-OFFICE,                            
                     :E-FCA645-REVENUE-DISTRICT,                        
                     :WS-NEW-ROUTE,                                     
                     :E-FCA645-COMPANY-NO)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
                  DISPLAY '****************************************'    
                  DISPLAY '       ABENDING PROGRAM '                    
                  DISPLAY '   7550-ADD-ZIPCODE-LO-ROUTE'                
                  DISPLAY ' FUNCTION       =   INSERT'                  
                  DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY ' ACCOUNT NO     = ' E-FCA645-ACCOUNT-NO      
                  DISPLAY ' ZIP CODE       = ' DY-ZIP-CODE              
                  DISPLAY ' REVENUE DIST   = ' E-FCA645-REVENUE-DISTRICT
                  DISPLAY ' COMPANY        = ' E-FCA645-COMPANY-NO      
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-IF.                                                      
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
       7700-UPDATE-PREMISE.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    UPDATE THE PREMISE WITH LAT/LONG INFO                     *          
      *                                                              *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
               SET REV_DISTRICT_CD     = :PR-REV-DISTRICT-CD,           
                   LOCAL_OFFICE        = :PR-LOCAL-OFFICE,              
                   SUBDIVISION_ID      = :PR-SUBDIVISION-ID,            
                   GAS_LK_SURVEY_FREQ  = :PR-GAS-LK-SURVEY-FREQ,        
                   COUNTY              = :PR-COUNTY,                    
ACT375             PREM_REF_LATITUDE   = :PR-PREM-REF-LATITUDE,         
ACT375             PREM_REF_LONGITUDE  = :PR-PREM-REF-LONGITUDE,        
ACT040             READ_ROUTE          = :PR-READ-ROUTE,                
                   FM_ELEC_SVC_WKDIST  = :PR-FM-ELEC-SVC-WKDIST,        
                   FM_GAS_OPS_WKDIST   = :PR-FM-GAS-OPS-WKDIST,         
                   FM_FLD_SVCS_WKDIST  = :PR-FM-FLD-SVCS-WKDIST,        
                   FM_REV_PRT_WKDIST   = :PR-FM-REV-PRT-WKDIST,         
                   FM_DSM_ESVC_WKDIST  = :PR-FM-DSM-ESVC-WKDIST         
               WHERE PREMISE_NO        = :WS-CPD99-PREMISE-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CPD99-PREMISE-NO TO WS-LAST-PREMISE-UPDATED.         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA645 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7700       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**      PREMISE = ' WS-CPD99-PREMISE-NO         
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7800-INSERT-ZIPCODE-SUBDIV.                                      
      *--------------------------------------------------------------*          
      *    UPDATE THE ROW WHEN ONE IS NOT CURRENTLY ON TABLE         *          
      *                                                              *          
      *--------------------------------------------------------------*          
      *                                                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ZIPCODE_SUBDIV                           
                   (  ZIP_CODE,                                         
                      SUBDIVISION_ID,                                   
                      COMPANY_NO,                                       
                      LAST_UPDATE_TS,                                   
                      LAST_UPDATE_USERID,                               
                      RATE_ITEM_CD,                                     
                      REV_DISTRICT_CD,                                  
                      LOCAL_OFFICE)                                     
                VALUES                                                  
                   ( :DY-ZIP-CODE,                                      
                     :E-FCA645-SUBDIVISION-ID,                          
                     :E-FCA645-COMPANY-NO,                              
                      CIS.CURRENT$TIMESTAMP(),                                
                      'SYSTEM',                                         
                     :WS-RATE-ITEM-CODE,                                
                     :E-FCA645-REVENUE-DISTRICT,                        
                     :E-FCA645-LOCAL-OFFICE)                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ZIPCODE_SUBDIV                                   
MFA-TR*            (  ZIP_CODE,                                                 
MFA-TR*               SUBDIVISION_ID,                                           
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               LAST_UPDATE_TS,                                           
MFA-TR*               LAST_UPDATE_USERID,                                       
MFA-TR*               RATE_ITEM_CD,                                             
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               LOCAL_OFFICE)                                             
MFA-TR*         VALUES                                                          
MFA-TR*            ( :DY-ZIP-CODE,                                              
MFA-TR*              :E-FCA645-SUBDIVISION-ID,                                  
MFA-TR*              :E-FCA645-COMPANY-NO,                                      
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               'SYSTEM',                                                 
MFA-TR*              :WS-RATE-ITEM-CODE,                                        
MFA-TR*              :E-FCA645-REVENUE-DISTRICT,                                
MFA-TR*              :E-FCA645-LOCAL-OFFICE)                                    
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
               WHEN ZERO                                                
                   DISPLAY '    CSS_ZIPCODE_SUBDIV ROW FOR '            
                           E-FCA645-ACCOUNT-NO ' '                      
                           E-FCA645-PREMISE-NO ' '                      
                           E-FCA645-REVENUE-DISTRICT ' '                
                           E-FCA645-SUBDIVISION-ID   ' '                
                           E-FCA645-LOCAL-OFFICE     ' WAS ADDED'       
ACT280         WHEN -530                                                
ACT280             DISPLAY '    CSS_ZIPCODE_SUBDIV ROW FOR '            
ACT280                     DY-ZIP-CODE ' '                              
ACT280                     E-FCA645-SUBDIVISION-ID                      
ACT280                     ' NOT ADDED - RI ERROR - '                   
ACT280                     'BYPASSING REVENUE DISTRICT UPDATE FOR '     
ACT280                     'PREMISE ' E-FCA645-PREMISE-NO               
ACT280              MOVE PR-REV-DISTRICT-CD TO E-FCA645-REVENUE-DISTRICT
ACT040              MOVE 'N' TO WS-ZIP-SUB-FLAG                         
               WHEN -803                                                
                   DISPLAY '    CSS_ZIPCODE_SUBDIV ROW FOR '            
                           DY-ZIP-CODE ' '                              
                           E-FCA645-SUBDIVISION-ID                      
                           ' NOT ADDED - ALREADY ON TABLE'              
                   DISPLAY '    BYPASSING REVENUE DISTRICT UPDATE FROM '
                           PR-REV-DISTRICT-CD ' TO '                    
ACT280                     E-FCA645-REVENUE-DISTRICT                    
ACT280              MOVE PR-REV-DISTRICT-CD TO E-FCA645-REVENUE-DISTRICT
ACT040              MOVE 'N' TO WS-ZIP-SUB-FLAG                         
               WHEN OTHER                                               
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7800       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY '**      PREMISE = ' WS-CPD99-PREMISE-NO     
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7900-GET-METER-COORDINATES.                                      
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   UPDATE CSS_MTRD_ENVRNMT WITH NEW LATITUDE & LONGITUDE      *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE ZERO TO WS-PREV-LAT WS-PREV-LONG.                       
           EXEC SQL                                                     
               SELECT TOP(1) MTR_REF_LATITUDE,
              MTR_REF_LONGITUDE                                    
               INTO :WS-PREV-LAT,                                       
                    :WS-PREV-LONG                                       
               FROM CSS_MTRD_ENVRNMT                                    
               WHERE ACCOUNT_NO       = :WS-CPD99-ACCOUNT-NO            
                 AND METER_NO         = :MN-METER-NO                    
                 AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE              
                 AND CODE_METER_STATUS <> 'K'                           
ACT021                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*            MTR_REF_LATITUDE,                                            
MFA-TR*            MTR_REF_LONGITUDE                                            
MFA-TR*        INTO :WS-PREV-LAT,                                               
MFA-TR*             :WS-PREV-LONG                                               
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*        WHERE ACCOUNT_NO       = :WS-CPD99-ACCOUNT-NO                    
MFA-TR*          AND METER_NO         = :MN-METER-NO                            
MFA-TR*          AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE                      
MFA-TR*          AND CODE_METER_STATUS <> 'K'                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-PREV-LAT      TO WS-PREV-LAT-EDITED              
               MOVE WS-PREV-LONG TO WS-PREV-LONG-EDITED                 
           ELSE                                                         
              IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                 DISPLAY '    PCSCA645 METER NO ' MN-METER-NO           
                     ' WAS NOT FOUND AT ACCOUNT ' MN-ACCOUNT-NO         
              ELSE                                                      
                  DISPLAY '****************************************'    
                  DISPLAY '       ABENDING PROGRAM '                    
                  DISPLAY '     MTRD-ENVRNMT UPDATE '                   
                  DISPLAY '   7900-GET-METER-COORDINATES'               
                  DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY ' ACCOUNT NO     = ' E-FCA645-ACCOUNT-NO      
                  DISPLAY ' CODE-UTIL-TYPE = ' E-FCA645-G-E-W-IND       
                  DISPLAY ' METER-NO       = ' WS-METER-NO              
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
       8000-GET-RATE-ITEM-CODE.                                         
           EXEC SQL                                                     
               SELECT TOP(1) RATE_ITEM_CD                                      
                  INTO :WS-RATE-ITEM-CODE                               
                  FROM CSS_ZIPCODE_SUBDIV WITH(READUNCOMMITTED)                 
                  WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID     
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_ITEM_CD                                              
MFA-TR*           INTO :WS-RATE-ITEM-CODE                                       
MFA-TR*           FROM CSS_ZIPCODE_SUBDIV                                       
MFA-TR*           WHERE SUBDIVISION_ID   = :E-FCA645-SUBDIVISION-ID             
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = 0                                           
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA645 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 8000       **'   
                   DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM   
                   DISPLAY '**      SQLCODE = ' SQLCODE                 
                   DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO       
                           ' PREMISE # '      E-FCA645-PREMISE-NO       
                           ' SUBDIVISION ID ' E-FCA645-SUBDIVISION-ID   
                           ' COMPANY NO '     E-FCA645-COMPANY-NO       
                           ' REVENUE DIST '   E-FCA645-REVENUE-DISTRICT 
                           ' LOCAL OFFICE '   E-FCA645-LOCAL-OFFICE     
                           ' SUBDIVISION '    E-FCA645-SUBDIVISION-ID   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8100-GET-PREMISE-DETAILS.                                        
           INITIALIZE DCLCSS-PREMISE.                                   
           EXEC SQL                                                     
               SELECT REV_DISTRICT_CD,                                  
                      LOCAL_OFFICE,                                     
                      SUBDIVISION_ID,                                   
                      GAS_LK_SURVEY_FREQ,                               
                      COUNTY,                                           
ACT375                PREM_REF_LATITUDE,                                
ACT375                PREM_REF_LONGITUDE,                               
ACT040                READ_ROUTE,                                       
                      FM_ELEC_SVC_WKDIST,                               
                      FM_GAS_OPS_WKDIST ,                               
                      FM_FLD_SVCS_WKDIST,                               
                      FM_REV_PRT_WKDIST ,                               
                      FM_DSM_ESVC_WKDIST,                               
                      ZIP_CODE                                          
                 INTO :PR-REV-DISTRICT-CD,                              
                      :PR-LOCAL-OFFICE,                                 
                      :PR-SUBDIVISION-ID,                               
                      :PR-GAS-LK-SURVEY-FREQ,                           
                      :PR-COUNTY,                                       
ACT375                :PR-PREM-REF-LATITUDE,                            
ACT375                :PR-PREM-REF-LONGITUDE,                           
ACT040                :PR-READ-ROUTE,                                   
                      :PR-FM-ELEC-SVC-WKDIST,                           
                      :PR-FM-GAS-OPS-WKDIST ,                           
                      :PR-FM-FLD-SVCS-WKDIST,                           
                      :PR-FM-REV-PRT-WKDIST ,                           
                      :PR-FM-DSM-ESVC-WKDIST,                           
                      :DY-ZIP-CODE                                      
                  FROM CSS_PREMISE        PR WITH(READUNCOMMITTED),             
                       CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                  WHERE PREMISE_NO       = :WS-CPD99-PREMISE-NO  AND    
                        PR.ADDRESS_ID    = DY.ADDRESS_ID                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REV_DISTRICT_CD,                                          
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               SUBDIVISION_ID,                                           
MFA-TR*               GAS_LK_SURVEY_FREQ,                                       
MFA-TR*               COUNTY,                                                   
MFA-TR*               PREM_REF_LATITUDE,                                        
MFA-TR*               PREM_REF_LONGITUDE,                                       
MFA-TR*               READ_ROUTE,                                               
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST ,                                       
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST ,                                       
MFA-TR*               FM_DSM_ESVC_WKDIST,                                       
MFA-TR*               ZIP_CODE                                                  
MFA-TR*          INTO :PR-REV-DISTRICT-CD,                                      
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-SUBDIVISION-ID,                                       
MFA-TR*               :PR-GAS-LK-SURVEY-FREQ,                                   
MFA-TR*               :PR-COUNTY,                                               
MFA-TR*               :PR-PREM-REF-LATITUDE,                                    
MFA-TR*               :PR-PREM-REF-LONGITUDE,                                   
MFA-TR*               :PR-READ-ROUTE,                                           
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST ,                                   
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST ,                                   
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST,                                   
MFA-TR*               :DY-ZIP-CODE                                              
MFA-TR*           FROM CSS_PREMISE        PR,                                   
MFA-TR*                CSS_ADDR_FORMATTED DY                                    
MFA-TR*           WHERE PREMISE_NO       = :WS-CPD99-PREMISE-NO  AND            
MFA-TR*                 PR.ADDRESS_ID    = DY.ADDRESS_ID                        
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = 0 AND 100                                   
                DISPLAY '****************************************'      
                DISPLAY '**     PCSCA645 PROCESSING ERROR      **'      
                DISPLAY '**      ABEND IN PARAGRAPH 8100       **'      
                DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM      
                DISPLAY '**      SQLCODE = ' SQLCODE                    
                DISPLAY 'ACCOUNT # '       E-FCA645-ACCOUNT-NO          
                        ' PREMISE # '      WS-CPD99-PREMISE-NO          
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
      *==============================================================*          
       8200-PRINT-HEADERS.                                              
      *==============================================================*          
      *--------------------------------------------------------------*          
      *        WRITES THE HEADER TO THE REPORT FILE                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER1 AFTER NEW-PAGE.              
      *                                                                         
           IF E-FCA645-GIS-SOURCE-CD = 'D'                              
               WRITE PRT33-RECORD FROM HEADER2B AFTER 1                 
           ELSE                                                         
               WRITE PRT33-RECORD FROM HEADER2  AFTER 1                 
           END-IF                                                       
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER3 AFTER 2.                     
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER4 AFTER 1.                     
      *                                                                         
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM 8950-WRITE-REPORT THRU 8950-EXIT.                    
      *                                                                         
           MOVE +6 TO WS-LINE-COUNT.                                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8300-PRINT-REPORT.                                               
      *==============================================================*          
      *--------------------------------------------------------------*          
      *        WRITES THE OUTPUT RECORDS TO THE REPORT FILE          *          
      *--------------------------------------------------------------*          
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF                                                       
      *                                                                         
           MOVE PRINT-LINE TO PRT33-RECORD.                             
      *                                                                         
           PERFORM 8950-WRITE-REPORT THRU 8950-EXIT.                    
      *                                                                         
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8400-UPDATE-RESTART.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      * UPDATES A ROW IN CSS_RESTART BEFORE EVERY COMMIT             *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA645 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 8400       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8500-INSERT-RESTART.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      * INSERTS A ROW INTO CSS_RESTART WHEN THERE IS NO ROW FOR      *          
      * RESTART DATA                                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM                                        
                   ,PARTITION_NO                                        
                   ,DUP_CNTRL_NO                                        
                   ,RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM                                    
                   ,:RF-PARTITION-NO                                    
                   ,:RF-DUP-CNTRL-NO                                    
                   ,:RF-RESTART-DATA)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA645 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 8500       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8600-GET-REV-DIST-NAMES.                                         
           MOVE SPACES TO A9-REV-DISTRICT-DESC.                         
           IF WS-REVENUE-DISTRICT > SPACES                              
               EXEC SQL                                                 
                   SELECT REV_DISTRICT_DESC                             
                   INTO   :A9-REV-DISTRICT-DESC                         
                   FROM   CSS_REV_DISTRICT                              
                   WHERE  REV_DISTRICT_CD = :WS-REVENUE-DISTRICT        
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               IF  SQLCODE        NOT = SUCCESSFUL-CALL                 
                  DISPLAY '****************************************'    
                  DISPLAY '**     PCSCA645 PROCESSING ERROR      **'    
                  DISPLAY '**      ABEND IN PARAGRAPH 8600       **'    
                  DISPLAY '**      REVENUE DIST  = ' WS-REVENUE-DISTRICT
                  DISPLAY '**      SQLCODE = ' SQLCODE                  
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
       8700-GET-LOC-OFFICE-NAMES.                                       
           MOVE SPACES TO B1-LOCAL-OFFICE-DESC.                         
           IF WS-LOCAL-OFFICE     > SPACES                              
               EXEC SQL                                                 
                   SELECT LOCAL_OFFICE_DESC                             
                   INTO   :B1-LOCAL-OFFICE-DESC                         
                   FROM   CSS_LOCAL_OFFICE                              
                   WHERE  LOCAL_OFFICE    = :WS-LOCAL-OFFICE            
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               IF  SQLCODE NOT = SUCCESSFUL-CALL                        
                  DISPLAY '****************************************'    
                  DISPLAY '**     PCSCA645 PROCESSING ERROR      **'    
                  DISPLAY '**      ABEND IN PARAGRAPH 8700       **'    
                  DISPLAY '**      LOCAL OFFICE  = ' WS-LOCAL-OFFICE    
                  DISPLAY '**      SQLCODE = ' SQLCODE                  
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
       8700-EXIT.                                                       
           EXIT.                                                        
       8760-GET-SUBDIVISION-NAMES.                                      
           MOVE SPACES TO B0-SUBDIVISION-DESC.                          
           IF WS-SUBDIVISION      > SPACES                              
               EXEC SQL                                                 
                   SELECT SUBDIVISION_DESC                              
                   INTO   :B0-SUBDIVISION-DESC                          
                   FROM   CSS_SUBDIVISION                               
                   WHERE  SUBDIVISION_ID  = :WS-SUBDIVISION AND         
                          COMPANY_NO      = :E-FCA645-COMPANY-NO        
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               IF  SQLCODE             NOT   = SUCCESSFUL-CALL          
                  DISPLAY '****************************************'    
                  DISPLAY '**     PCSCA645 PROCESSING ERROR      **'    
                  DISPLAY '**      ABEND IN PARAGRAPH 8760       **'    
                  DISPLAY '**      SUBDIVISION ID= ' WS-SUBDIVISION     
                  DISPLAY '**      SQLCODE = ' SQLCODE                  
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
       8760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8780-GET-COUNTY-NAME.                                            
           MOVE SPACES TO SC-COUNTY-DESC.                               
           IF WS-COUNTY           > SPACES                              
               EXEC SQL                                                 
                   SELECT COUNTY_DESC                                   
                   INTO   :SC-COUNTY-DESC                               
                   FROM   CSS_STATE_COUNTY                              
                   WHERE  COUNTY     = :WS-COUNTY AND                   
                          COMPANY_NO = :E-FCA645-COMPANY-NO             
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               EVALUATE SQLCODE                                         
                   WHEN 0                                               
                       CONTINUE                                         
                   WHEN 100                                             
                      DISPLAY '    BYPASSING COUNTY CODE UPDATE FOR '   
                              ' PREMISE: ' E-FCA645-PREMISE-NO          
                              ' COUNTY: ' WS-COUNTY                     
                              ' COMPANY: ' E-FCA645-COMPANY-NO          
                              ' - NOT FOUND ON TABLE'                   
                      MOVE ' ' TO WS-COU-UPD                            
                   WHEN OTHER                                           
                      DISPLAY '****************************************'
                      DISPLAY '**     PCSCA645 PROCESSING ERROR      **'
                      DISPLAY '**      ABEND IN PARAGRAPH 8780       **'
                      DISPLAY '**      SUBDIVISION ID= ' WS-COUNTY      
                      DISPLAY '**      SQLCODE = ' SQLCODE              
                      DISPLAY '****************************************'
                      PERFORM 9900-ABEND THRU 9900-EXIT                 
               END-EVALUATE                                             
           END-IF.                                                      
       8780-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8800-ISSUE-CHKP.                                                 
      *==============================================================*          
      *                                                                         
           PERFORM 8900-WRITE-RSDDR THRU 8900-EXIT.                     
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-COMMIT-NUMBER ' TAKEN. '        
           .                                                            
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8900-WRITE-RSDDR.                                                
      *==============================================================*          
      *--------------------------------------------------------------*          
      * POPULATES THE RESTART-DATA BEFORE IT IS STORED IN CSS_RESTART*          
      * AND UPDATES/INSERTS THE RESTART-DATA IN CSS_RESTART          *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM           
           MOVE 1                          TO RF-DUP-CNTRL-NO           
                                              RF-PARTITION-NO           
           MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT      
           MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN       
           PERFORM 8400-UPDATE-RESTART THRU 8400-EXIT                   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               PERFORM 8500-INSERT-RESTART THRU 8500-EXIT               
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8950-WRITE-REPORT.                                               
      *==============================================================*          
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A37741****************************************************************          
A37741* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A37741****************************************************************          
A37741 9000-SEND-ERROR-RESULT.                                          
A37741     MOVE +12 TO WS-RETURN-CODE.                                  
A37741*                                                                         
      *==============================================================*          
       9000-TERMINATE.                                                  
      *==============================================================*          
      *                                                                         
ACT291     IF RETURN-CODE = ZERO                                        
               MOVE WS-RETURN-CODE TO RETURN-CODE                       
ACT291         IF RETURN-CODE = 0                                       
ACT291             PERFORM 5000-PROCESS-SUCCESSFUL-JOB THRU 5000-EXIT   
ACT291         END-IF                                                   
           END-IF.                                                      
           CLOSE FCSCA645                                               
                 FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *              
      * COPYBOOK FOR WRITING THE MH AND MI.                      *              
      ************************************************************              
      *                                                                         
      *==============================================================*          
       9900-SQL-ERROR-ROUTINE.                                          
      *==============================================================*          
           GO TO 9900-EXIT.                                             
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE                      *          
      *  MOVES 12 TO RETURN CODE                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6235-GET-FJC01-RESTART-REQ.                                          
      *****************************************************************         
       COPY CPD00035.                                                           
      *                                                                         
      *                                                                         
      ****************************************************************          
      * 6530-LOAD-MNT-TRANS-HIST                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
