       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA635.                                      
COB303 DATE-WRITTEN.     SEP 24, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
      *--  09/01/2015    VV7M728     THIS PROGRAM TO GENERATE A      --*        
      *--                            INTERVAL REPORT FOR THE         --*        
      *--                            INDUSTRIAL ELECTRIC CUSTOMERS   --*        
      *--                                                            --*        
A05460*--   6 APR 2016   RF10596     FIX PERCENTAGE AND ADD ACCOUNT  --*        
A05460*--                            TOTAL LINE                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSWK05.                                                            
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDWK05.                                                            
       COPY FIOWK05.                                                            
       COPY CFDPT331.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA635'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ADDR_FORMATTED                                       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ADDR_FREEFORM                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_PREMISE                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_NAME                                                 *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ZIP_CODE                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTR_CAP                                              *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_NAME_ACCT_XREF                                       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    COPYBOOKS                                                *           
      ***************************************************************           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSCA635'.     
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
      *                                                                         
       01 WS-OUTFILE-HDR.                                               
           05 OUT-HDR-DATE              PIC X(04) VALUE 'DATE'.         
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-HOUR              PIC X(04) VALUE 'HOUR'.         
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-ACTUAL-LOAD       PIC X(16)                       
                                     VALUE 'ACTUAL LOAD(KWH)'.          
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-CBL-LOAD          PIC X(13)                       
                                     VALUE 'CBL LOAD(KWH)'.             
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-HOUR-INC          PIC X(23)                       
                                     VALUE 'HOURLY INCREMENTAL(KWH)'.   
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-RTP-PRICE         PIC X(18)                       
                                     VALUE 'RTP PRICE(CNT\KWH)'.        
           05 FILLER                    PIC X(01) VALUE '|'.            
           05 OUT-HDR-RTP-PRICE         PIC X(26)                       
                                     VALUE 'HOURLY INCREMENTAL COST($)'.
           05 FILLER                    PIC X(23) VALUE SPACES.         
                                                                        
       01 WS-OUTFILE.                                                   
           05 OUT-ACCOUNT             PIC X(13) VALUE SPACES.           
           05 FILLER                  PIC X(01) VALUE '|'.              
           05 OUT-USAGE-DATE          PIC X(10) VALUE SPACES.           
           05 FILLER                  PIC X(01) VALUE '|'.              
           05 OUT-USAGE-HOUR          PIC ZZ.                           
           05 FILLER                  PIC X(01) VALUE '|'.              
A05460     05 OUT-KWH-UNITS           PIC ZZ,ZZZ,ZZZ.99- VALUE ZEROES.  
           05 FILLER                  PIC X(01) VALUE '|'.              
A05460     05 OUT-BASELINE-LOAD       PIC ZZ,ZZZ,ZZZ.99- VALUE ZEROES.  
           05 FILLER                  PIC X(01) VALUE '|'.              
A05460     05 OUT-HOURLY-INCRE-UNITS  PIC ZZ,ZZZ,ZZZ.99- VALUE ZEROES.  
           05 FILLER                  PIC X(01) VALUE '|'.              
A05460     05 OUT-RATE-1              PIC ZZZ.999999- VALUE ZEROES.     
           05 FILLER                  PIC X(01) VALUE '|'.              
A05460     05 OUT-HOURLY-INCRE-COST   PIC ZZ,ZZZ,ZZZ.99- VALUE ZEROES.  
           05 FILLER                  PIC X(21) VALUE SPACES.           
                                                                        
       01 WS-MISC.                                                      
A05460     05 WS-HONK                   PIC X     VALUE 'N'.            
           05 WS-ACCT-NO                PIC X(13) VALUE SPACES.         
           05 WS-OUT-ACCOUNT            PIC X(13) VALUE SPACES.         
           05 WS-OUT-USAGE-DATE         PIC X(10) VALUE SPACES.         
           05 WS-ACCOUNT-NO             PIC X(13) VALUE SPACES.         
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05 WS-NAME1                  PIC X(20) VALUE SPACES.         
           05 WS-ADDR1                  PIC X(27) VALUE SPACES.         
           05 WS-CITY1                  PIC X(12) VALUE SPACES.         
           05 WS-FWK05-KWH-UNITS01      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-FWK05-KWH-UNITS02      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-FWK05-KWH-UNITS03      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-FWK05-KWH-UNITS04      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-TOT-FWK05-KWH-UNITS    PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-SUM-FWK05-KWH-UNITS    PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-FWK05-BASELINE-LOAD    PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-SUM-BASELINE-LOAD      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-HOURLY-INCRE-UNITS     PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-SUM-HOURLY-INCRE-UNITS PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-HOURLY-INCRE-COST      PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
           05 WS-SUM-HOURLY-INCRE-COST  PIC S9(9)V99 COMP-3             
                                                    VALUE +0.           
A05460     05 WS-ACCT-TOT-KWH-UNITS     PIC S9(9)V99 COMP-3 VALUE 0.    
A05460     05 WS-ACCT-TOT-INCR-UNITS    PIC S9(9)V99 COMP-3 VALUE 0.    
A05460     05 WS-ACCT-TOT-BASELINE      PIC S9(9)V99 COMP-3 VALUE 0.    
A05460     05 WS-ACCT-TOT-INCR-COST     PIC S9(9)V99 COMP-3 VALUE 0.    
A05460     05 WS-FWK05-RATE-1           PIC S9(3)V9(6) COMP-3 VALUE 0.  
           05 WS-FWK05-USAGE-DATE       PIC X(10) VALUE SPACES.         
           05 WS-FWK05-BREC             PIC 9(01) VALUE ZEROES.         
           05 WS-COUNT                  PIC 9(01) VALUE ZEROES.         
           05 WS-REV-MONTH              PIC 9(06) VALUE ZEROES.         
           05 WS-PNC-ACCT               PIC X(09) VALUE SPACES.         
           05 WS-FMT-ACCT               PIC X(13) VALUE SPACES.         
           05 WS-TIT-ACCT               PIC X(13) VALUE SPACES.         
                                                                        
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FWK05-STATUS          PIC X(02) VALUE '00'.           
               88 FWK05-SUCCESSFUL                VALUE '00'.           
               88 END-OF-REC                      VALUE '10'.           
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
           05 WS-PREM-STAT              PIC X(01) VALUE SPACES.         
           05 WS-FIRST-TYM              PIC X(01) VALUE SPACES.         
           05 WS-SUM-STAT               PIC X(01) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1000-PROCESS-INPUT               THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN INPUT  FCSWK05-FILE.                                    
                                                                        
           IF NOT FWK05-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSWK05-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FWK05-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 8100-WRITE-FCSPT331-HDR          THRU 8100-EXIT.     
           PERFORM 7200-READ-FCSWK05                THRU 7200-EXIT.     
           PERFORM 2000-PROCESS-DTLS                THRU 2000-EXIT      
             UNTIL END-OF-REC.                                          
           PERFORM 2400-TOTAL-CALC                  THRU 2400-EXIT.     
A05460     PERFORM 2425-ACCOUNT-TOTAL               THRU 2425-EXIT.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS                                            **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           MOVE E-FWK05-ACCOUNT-NO(1:1)      TO WS-FWK05-BREC.          
                                                                        
           IF (WS-FWK05-BREC NOT EQUAL X'00')    AND                    
              (WS-FWK05-BREC NOT EQUAL X'FF')    AND                    
              (E-FWK05-METER-NO EQUAL 'SUMMARY') AND                    
              (E-FWK05-REC-TYPE EQUAL 'A'        OR                     
               E-FWK05-REC-TYPE EQUAL 'C')                              
                                                                        
             IF (( E-FWK05-ACCOUNT-NO NOT EQUAL WS-OUT-ACCOUNT )    OR  
                 ( E-FWK05-USAGE-DATE NOT EQUAL WS-OUT-USAGE-DATE ))    
                PERFORM 2400-TOTAL-CALC           THRU 2400-EXIT        
                MOVE WS-YES              TO WS-SUM-STAT                 
      *                                                                         
A05460          IF E-FWK05-ACCOUNT-NO = WS-OUT-ACCOUNT                  
A05460             CONTINUE                                             
A05460          ELSE                                                    
A05460             IF WS-FIRST-TYM = WS-NO                              
A05460                PERFORM 2425-ACCOUNT-TOTAL THRU 2425-EXIT         
A05460             END-IF                                               
A05460          END-IF                                                  
      *                                                                         
             ELSE                                                       
                MOVE WS-NO               TO WS-SUM-STAT                 
             END-IF                                                     
      *                                                                         
             PERFORM 2300-FORMAT-DETAIL-LINE     THRU 2300-EXIT         
                                                                        
             IF E-FWK05-ACCOUNT-NO NOT EQUAL WS-ACCT-NO                 
                                                                        
               MOVE E-FWK05-ACCOUNT-NO   TO WS-ACCT-NO                  
                                            WS-TIT-ACCT                 
                                            WS-ACCOUNT-NO               
                                                                        
               PERFORM 7100-GET-DETAILS           THRU 7100-EXIT        
                                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                 MOVE WS-ACCT-NO         TO WS-ACCOUNT-NO               
                 MOVE AT-PREMISE-NO      TO WS-PREMISE-NO               
                 MOVE WS-YES             TO WS-PREM-STAT                
                                                                        
               ELSE                                                     
                 MOVE WS-NO              TO WS-PREM-STAT                
               END-IF                                                   
             END-IF                                                     
                                                                        
            IF WS-PREM-STAT   NOT EQUAL WS-NO                           
             COMPUTE WS-TOT-FWK05-KWH-UNITS ROUNDED EQUAL               
                                   ( WS-FWK05-KWH-UNITS01 +             
                                     WS-FWK05-KWH-UNITS02 +             
                                     WS-FWK05-KWH-UNITS03 +             
                                     WS-FWK05-KWH-UNITS04 )             
                                                                        
             COMPUTE WS-HOURLY-INCRE-UNITS ROUNDED EQUAL                
                     (WS-TOT-FWK05-KWH-UNITS - WS-FWK05-BASELINE-LOAD)  
                                                                        
             COMPUTE WS-HOURLY-INCRE-COST ROUNDED  EQUAL                
                     (WS-FWK05-RATE-1 * WS-HOURLY-INCRE-UNITS)          
                                                                        
             COMPUTE WS-SUM-FWK05-KWH-UNITS EQUAL                       
                ( WS-TOT-FWK05-KWH-UNITS + WS-SUM-FWK05-KWH-UNITS )     
                                                                        
             COMPUTE WS-SUM-HOURLY-INCRE-UNITS EQUAL                    
                ( WS-HOURLY-INCRE-UNITS + WS-SUM-HOURLY-INCRE-UNITS )   
                                                                        
             COMPUTE WS-SUM-BASELINE-LOAD EQUAL                         
                ( WS-FWK05-BASELINE-LOAD + WS-SUM-BASELINE-LOAD )       
                                                                        
             COMPUTE WS-SUM-HOURLY-INCRE-COST EQUAL                     
                ( WS-SUM-HOURLY-INCRE-COST + WS-HOURLY-INCRE-COST )     
      *                                                                         
             COMPUTE WS-COUNT EQUAL WS-COUNT + 1                        
                                                                        
             IF WS-COUNT EQUAL 1                                        
               MOVE WS-YES                TO WS-FIRST-TYM               
             ELSE                                                       
               MOVE WS-NO                 TO WS-FIRST-TYM               
             END-IF                                                     
                                                                        
             PERFORM 2500-POPULATE-OUTPUT-DATA      THRU 2500-EXIT      
           END-IF                                                       
           END-IF.                                                      
                                                                        
           PERFORM 7200-READ-FCSWK05                THRU 7200-EXIT.     
                                                                        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE                                  **          
      **       FORMATS THE DETAIL LINE OF THE REPORT PCSRP627       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2300-FORMAT-DETAIL-LINE.                                         
      *                                                                         
           MOVE E-FWK05-BASELINE-LOAD  TO WS-FWK05-BASELINE-LOAD.       
           MOVE E-FWK05-RATE-1         TO WS-FWK05-RATE-1.              
                                                                        
           SET WK05-INTV               TO 1.                            
      *                                                                         
           PERFORM 4 TIMES                                              
               SEARCH E-FWK05-INTERVAL-DATA                             
                   WHEN WK05-INTV LESS THAN 5                           
                     IF WK05-INTV EQUAL 1                               
                       MOVE E-FWK05-KWH-UNITS (WK05-INTV)               
                                       TO WS-FWK05-KWH-UNITS01          
                     END-IF                                             
                     IF WK05-INTV EQUAL 2                               
                       MOVE E-FWK05-KWH-UNITS (WK05-INTV)               
                                       TO WS-FWK05-KWH-UNITS02          
                     END-IF                                             
                     IF WK05-INTV EQUAL 3                               
                       MOVE E-FWK05-KWH-UNITS (WK05-INTV)               
                                       TO WS-FWK05-KWH-UNITS03          
                     END-IF                                             
                     IF WK05-INTV EQUAL 4                               
                       MOVE E-FWK05-KWH-UNITS (WK05-INTV)               
                                       TO WS-FWK05-KWH-UNITS04          
                     END-IF                                             
                       SET WK05-INTV UP BY 1                            
               END-SEARCH                                               
           END-PERFORM.                                                 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-TOTAL-CALC.                                             **        
      ******************************************************************        
      *                                                                         
       2400-TOTAL-CALC.                                                 
                                                                        
             IF WS-FIRST-TYM EQUAL WS-NO                                
                                                                        
               MOVE 'TOTAL'                   TO OUT-ACCOUNT            
               MOVE SPACES                    TO OUT-USAGE-DATE         
               MOVE ZEROES                    TO OUT-USAGE-HOUR         
                                                 OUT-RATE-1             
               MOVE WS-SUM-HOURLY-INCRE-UNITS TO OUT-HOURLY-INCRE-UNITS 
               MOVE WS-SUM-FWK05-KWH-UNITS    TO OUT-KWH-UNITS          
               MOVE WS-SUM-HOURLY-INCRE-COST  TO OUT-HOURLY-INCRE-COST  
               MOVE WS-SUM-BASELINE-LOAD      TO OUT-BASELINE-LOAD      
                                                                        
               PERFORM 8000-WRITE-FCSPT331            THRU 8000-EXIT    
      *                                                                         
A05460         ADD WS-SUM-FWK05-KWH-UNITS    TO WS-ACCT-TOT-KWH-UNITS   
A05460         ADD WS-SUM-HOURLY-INCRE-UNITS TO WS-ACCT-TOT-INCR-UNITS  
A05460         ADD WS-SUM-BASELINE-LOAD      TO WS-ACCT-TOT-BASELINE    
A05460         ADD WS-SUM-HOURLY-INCRE-COST  TO WS-ACCT-TOT-INCR-COST   
      *                                                                         
               MOVE ZEROES               TO  WS-SUM-HOURLY-INCRE-UNITS  
                                             WS-SUM-FWK05-KWH-UNITS     
                                             WS-SUM-HOURLY-INCRE-COST   
                                             WS-SUM-BASELINE-LOAD       
             END-IF.                                                    
                                                                        
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05460** ACCOUNT TOTAL LINE                                         **          
      ****************************************************************          
      *                                                                         
A05460 2425-ACCOUNT-TOTAL.                                              
      *                                                                         
A05460     MOVE 'ACCT TOTAL'              TO OUT-ACCOUNT.               
A05460     MOVE SPACES                    TO OUT-USAGE-DATE.            
A05460     MOVE ZEROES                    TO OUT-USAGE-HOUR             
A05460                                       OUT-RATE-1.                
A05460     MOVE WS-ACCT-TOT-KWH-UNITS     TO OUT-KWH-UNITS.             
A05460     MOVE WS-ACCT-TOT-INCR-UNITS    TO OUT-HOURLY-INCRE-UNITS.    
A05460     MOVE WS-ACCT-TOT-BASELINE      TO OUT-BASELINE-LOAD.         
A05460     MOVE WS-ACCT-TOT-INCR-COST     TO OUT-HOURLY-INCRE-COST.     
      *                                                                         
A05460     PERFORM 8000-WRITE-FCSPT331 THRU 8000-EXIT.                  
      *                                                                         
A05460     MOVE ZEROES TO  WS-ACCT-TOT-KWH-UNITS                        
A05460                     WS-ACCT-TOT-INCR-UNITS                       
A05460                     WS-ACCT-TOT-BASELINE                         
A05460                     WS-ACCT-TOT-INCR-COST.                       
      *                                                                         
A05460 2425-EXIT.                                                       
A05460     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2500-POPULATE-OUTPUT-DATA                                **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2500-POPULATE-OUTPUT-DATA.                                       
      *                                                                         
             MOVE E-FWK05-USAGE-DATE     TO WS-FWK05-USAGE-DATE.        
             MOVE E-FWK05-ACCOUNT-NO     TO WS-FMT-ACCT.                
             MOVE WS-FMT-ACCT            TO OUT-ACCOUNT.                
             MOVE WS-FWK05-USAGE-DATE    TO OUT-USAGE-DATE.             
             MOVE E-FWK05-USAGE-HOUR     TO OUT-USAGE-HOUR.             
             MOVE WS-TOT-FWK05-KWH-UNITS TO OUT-KWH-UNITS.              
             MOVE WS-FWK05-BASELINE-LOAD TO OUT-BASELINE-LOAD.          
             MOVE WS-HOURLY-INCRE-UNITS  TO OUT-HOURLY-INCRE-UNITS.     
             MOVE WS-FWK05-RATE-1        TO OUT-RATE-1.                 
             MOVE WS-HOURLY-INCRE-COST   TO OUT-HOURLY-INCRE-COST.      
      *                                                                         
             MOVE E-FWK05-ACCOUNT-NO     TO WS-OUT-ACCOUNT.             
             MOVE E-FWK05-USAGE-DATE     TO WS-OUT-USAGE-DATE.          
                                                                        
             PERFORM 8000-WRITE-FCSPT331            THRU 8000-EXIT.     
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * P4000-GET-NAME-ADDR.                                         *          
      ****************************************************************          
      *COPY CWSE0074.                                                           
      *COPY CPDE0074.                                                           
      *                                                                         
      ******************************************************************        
      **  7100-GET-DETAILS.                                           **        
      ******************************************************************        
      *                                                                         
       7100-GET-DETAILS.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) AT.PREMISE_NO                                      
                INTO :AT-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO  = :WS-ACCT-NO                       
                 AND AT.ACCOUNT_NO  = UT.ACCOUNT_NO                     
                 AND UT.CODE_UTIL_TYPE = 'E'                            
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.PREMISE_NO                                              
MFA-TR*         INTO :AT-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE AT.ACCOUNT_NO  = :WS-ACCT-NO                               
MFA-TR*          AND AT.ACCOUNT_NO  = UT.ACCOUNT_NO                             
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA635 ABORT *****'                   
              DISPLAY '**  7100-GET-DETAILS       **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  WS-ACCT-NO  = ' WS-ACCT-NO                   
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READ FCSWK05 FILE FOR INPUT                                   *        
      ******************************************************************        
      *                                                                         
       7200-READ-FCSWK05.                                               
      *                                                                         
           READ FCSWK05-FILE                                            
                                                                        
           IF FWK05-SUCCESSFUL   OR  END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '************ PCSCA635 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSWK05 FILE ****'          
               DISPLAY '** FILE STATUS IS ' WS-FWK05-STATUS             
               DISPLAY '*** PROCESSING TERMINATED ***********'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT331.                                         **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT331.                                             
      *                                                                         
           WRITE PRT331-RECORD FROM WS-OUTFILE.                         
           IF NOT FCA331-SUCCESSFUL                                     
                                                                        
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8100-WRITE-FCSPT331-HDR.                                     **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT331-HDR.                                         
      *                                                                         
           WRITE PRT331-RECORD FROM WS-OUTFILE-HDR.                     
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSWK05-FILE.                                          
                                                                        
           IF NOT FWK05-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT80-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FWK05-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
